#
# spec file for package less
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%if ! %{defined _distconfdir}
%define _distconfdir %{_sysconfdir}
%else
%define use_usretc 1
%endif
Name:           less
Version:        643
Release:        150600.3.3.1
Summary:        Text File Browser and Pager Similar to more
License:        BSD-2-Clause OR GPL-3.0-or-later
Group:          Productivity/Text/Utilities
URL:            https://www.greenwoodsoftware.com/less/
Source:         https://www.greenwoodsoftware.com/less/less-%{version}.tar.gz
Source1:        README.SUSE
Source2:        lessopen.sh
Source3:        lessclose.sh
Source4:        lesskey.src
Source5:        https://www.greenwoodsoftware.com/less/less-%{version}.sig
Source6:        https://www.greenwoodsoftware.com/less/pubkey.asc#/%{name}.keyring
Patch0:         less-429-shell.patch
Patch2:         less-429-more.patch
# PATCH-FIX-UPSTREAM danilo.spinella@suse.com bsc#1222849
# mishandling of \n character in paths when LESSOPEN is set leads to OS command execution
Patch3:         CVE-2024-32487.patch
BuildRequires:  automake
BuildRequires:  ncurses-devel
BuildRequires:  pkgconfig
Requires:       file
# lessopen.sh uses which
Requires:       /usr/bin/which

%description
less is a text file browser and pager similar to more. It allows
backward as well as forward movement within a file. Also, less does not
have to read the entire input file before starting. It is possible to
start an editor at any time from within less.

%prep
%autosetup -p1
#
# the ./configure script is not writable for the normal user
# rather fix permissions for all files
chmod u+w *
#
cp %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} .

%build
autoreconf -fiv
export CFLAGS="%{optflags} -fPIE"
export LDFLAGS="-pie"
%configure
#
# regenerate help.c because less.hlp was patched
./mkhelp.pl <less.hlp >help.c
#
# build less
%make_build

%install
%make_install
#
# lesskey
install -m 755 -d %{buildroot}/%{_distconfdir}
install -m 644 lesskey.src %{buildroot}/%{_distconfdir}/lesskey
%{buildroot}%{_bindir}/lesskey -o %{buildroot}%{_distconfdir}/lesskey.bin %{buildroot}%{_distconfdir}/lesskey
#
# preprocessor
install -m 755 lessopen.sh lessclose.sh %{buildroot}/%{_bindir}
chmod -x LICENSE COPYING NEWS README.SUSE

%files
%license LICENSE COPYING
%doc NEWS README.SUSE
%{_mandir}/*/*
%{_distconfdir}/*
%{_bindir}/*

%changelog
* Tue Jun 11 2024 sbrabec@suse.com
- Fix CVE-2024-32487, mishandling of \n character in paths when
  LESSOPEN is set leads to OS command execution
  (CVE-2024-32487, bsc#1222849)
  * CVE-2024-32487.patch
* Thu Nov  9 2023 dmueller@suse.com
- add zstd support to lessopen
* Mon Aug 14 2023 info@paolostivanin.com
- Update to 643:
  * Fix problem when a program piping into less reads from the tty,
    like sudo asking for password (github #368).
  * Fix search modifier ^E after ^W.
  * Fix bug using negated (^N) search (github #374).
  * Fix bug setting colors with -D on Windows build (github #386).
  * Fix reading special chars like PageDown on Windows (github #378).
  * Fix mouse wheel scrolling on Windows (github #379).
  * Fix erroneous EOF when terminal window size changes (github #372).
  * Fix compile error with some definitions of ECHONL (github #395).
  * Fix crash on Windows when writing logfile (github #405).
  * Fix regression in exit code when stdin is /dev/null and
    output is a file (github #373).
  * Add lesstest test suite to production release (github #344).
  * Change lesstest output to conform with
    automake Simple Test Format (github #399).
* Thu May  4 2023 kstreitova@suse.com
- Update to 633
  * This release fixes a build problem found in less-632 on systems
    which have termcap.h in a subdirectory (ncurses/termcap.h or
    ncursesw/termcap.h). There is no functional difference between
    less-632 and less-633
* Tue May  2 2023 kstreitova@suse.com
- Update to 632 (differences between 608 and 632)
  * Add LESSUTFCHARDEF environment variable (github #275).
  * Add # command (github #330).
  * Add ^S search modifier (github #196).
  * Add --wordwrap option (github #113).
  * Add --no-vbell option (github #304).
  * Add --no-search-headers option (github #44).
  * Add --modelines option (github #89).
  * Add --intr option (github #224).
  * Add --proc-backspace, --proc-tab and --proc-return options (github #335).
  * Add --show-preproc-errors option (github #258).
  * Add LESS_LINES and LESS_COLUMNS environment variables (github #84).
  * Add LESS_DATA_DELAY environment variable (github #337).
  * Allow empty "lines" field in --header option.
  * Update Unicode tables.
  * Improve ability of ^X to interrupt F command (github #49).
  * Status column (-J) shows off-screen matches.
  * Parenthesized sub-patterns in searches are colored with unique colors, if supported by the regular expression library (github #196).
  * Don't allow opening a tty as file input unless -f is set (github #309).
  * Don't require newline input after +&... option (github #339).
  * Fix incorrect handling of some Private Use Unicode characters.
  * Fix ANSI color bug when overstriking with colored chars (github #276).
  * Fix compiler const warning (github #279).
  * Fix signal race in iread (github #280).
  * Fix reading procfs files on Linux (github #282).
  * Fix --ignore-case with ctrl-R (no regex) search (github #300).
  * Fix bug doing repeat search after setting & filter (github #299).
  * Fix bug doing repeat search before non-repeat search.
  * Fix crash with -R and certain line lengths (github #338).
  * Fix input of Windows dead keys (github #352).
  * Don't retain search options from a cancelled search (github #302).
  * Don't call realpath on fake filenames like "-" (github #289).
  * Implement lesstest test suite.
  * Convert function parameter definitions from K&R to C89 (github #316).
- Drop patch cve-2022-46663.patch (merged).
* Tue Feb  7 2023 psimons@suse.com
- Apply "cve-2022-46663.patch" to fix a vulnerability in less that
  could be exploited for denial-of-service attacks or even remote
  code execution by printing specially crafted escape sequences to
  the terminal. [CVE-2022-46663, bsc#1207815]
- Refreshed all other patches with quilt to an uniform -p1 patch
  style, which allows us to use %%autosetup and simplify the spec
  file a bit.
* Wed Sep 14 2022 danilo.spinella@suse.com
- Update to 608:
  * Add the --header option (github #43).
  * Add the --no-number-headers option (github #178).
  * Add the --status-line option.
  * Add the --redraw-on-quit option (github #36).
  * Add the --search-options option (github #213).
  * Add the --exit-follow-on-close option (github #244).
  * Add 'H' color type to set color of header lines.
  * Add #version conditional to lesskey.
  * Add += syntax to variable section in lesskey files.
  * Allow option name in -- command to end with '=' in addition to '\n'.
  * Add $HOME/.config to possible locations of lesskey file (github #153).
  * Add $XDG_STATE_HOME and $HOME/.local/state to possible locations
    of history file (github #223).
  * Don't read or write history file in secure mode (github #201).
  * Fix display of multibyte and double-width chars in prompt.
  * Fix ESC-BACKSPACE command when BACKSPACE key does not send 0x08
    (github #188).
  * Add more \k codes to lesskey format.
  * Fix bug when empty file is modified while viewing it.
  * Fix bug when parsing a malformed lesskey file (githb #234).
  * Fix bug scrolling history when --incsearch is set (github #214).
  * Fix buffer overflow when invoking lessecho with more than 63 -m/-n
    options (github #198).
  * Fix buffer overflow in bin_file (github #271).
  * Fix bug restoring color at end of highlighted text.
  * Fix bug in parsing lesskey file.
  * Defer moving cursor to lower left in some more cases.
  * Suppress TAB filename expansion in some cases where it doesn't make sense.
  * Fix termlib detection when compiler doesn't accept
    calls to undeclared functions.
  * Escape filenames when invoking LESSCLOSE.
  * Fix bug using multibyte UTF-8 char in search string
    with --incsearch (github #273).
* Tue Aug 16 2022 kukuk@suse.com
- Which need one /usr/bin/which, not the package which
* Thu Sep 16 2021 danilo.spinella@suse.com
- Add missing runtime dependency on which, which it is used by lessopen.sh.
  Fix bsc#1190552.
* Tue Jul  6 2021 predivan@mts.rs
- Fix build on Leap:
    Account for distinction in confdir after UsrMerge.
* Thu Jun 17 2021 dmueller@suse.com
- update to 590:
  * Make less able to read lesskey source files (deprecating lesskey).
  * If XDG_CONFIG_HOME is set, find lesskey source file
    in $XDG_CONFIG_HOME/lesskey rather than $HOME/.lesskey.
  * If XDG_DATA_HOME is set, find and store history file
    in $XDG_DATA_HOME/lesshst rather than $HOME/.lesshst.
  * Add the --lesskey-src option.
  * Add the --file-size option.
  * With -F, if screen is resized to make file fit on one screen, don't exit.
* Mon Jun 14 2021 jengelh@inai.de
- Remove --with-pic (no static libs are ever produced).
* Sun May 16 2021 dmueller@suse.com
- update to 586:
  * Make less able to read lesskey source files (deprecating lesskey).
  * If XDG_CONFIG_HOME is set, find lesskey source file
    in $XDG_CONFIG_HOME/lesskey rather than $HOME/.lesskey.
  * If XDG_DATA_HOME is set, find and store history file
    in $XDG_DATA_HOME/lesshst rather than $HOME/.lesshst.
  * Add the --lesskey-src option.
  * Add the --file-size option.
  * Fix bug which could leave terminal in mouse-reporting mode
    after exiting less.
  * Fix bug which caused failure to respond to window resize.
  * Fix backslash bug searching in tag file.
* Thu Apr 29 2021 dmueller@suse.com
- update to 581.2:
  * This fixes a bug found in less-581 where the terminal was sometimes left in
    mouse-reporting mode after exiting less.
* Fri Apr 23 2021 andreas.stieger@gmx.de
- less 581:
  * Change ESC-u command to toggle, not disable, highlighting per
    man page
  * Add ESC-U command
  * Add ctrl-W search modifier for wrapping search
  * F command can be interrupted by ^X
  * Support OSC 8 hyperlinks when -R is in effect
  * g command with no number will ignore -j and put first line at
    top of screen
  * Multiple + or -p command line options are handled better
  * Add the --incsearch option
  * Add the --line-num-width option
  * Add the --status-col-width option
  * Add the --use-color and --color options
  * Display -w highlight even if highlighted line is empty
  * If search result is in a long line, scroll to ensure it is
    visible
  * Editing the same file under different names now creates only
    one entry in the file list.
  * Make visual bell more visible on some terminals
  * Ring end-of-file bell no more than once per second
  * Build can use either Python or Perl for Makefile.aut operations
  * Fix crash when using the @ search modifier.
  * Fix crash in the 's' command due to duplicate free
- drop less-429-save_line_position.patch which was never accepted
  upstream due to solving one problem and creating others
* Sat Aug 15 2020 dmueller@suse.com
- update to 563:
  * Update Unicode tables.
  * Treat Hangul Jamo medial vowels and final consonants as zero width.
  * Display error message immediately when -o is toggled and
    input is not a pipe.
  * Fix regression: make screen repaint when "squished" and
    a no-movement command is given.
  * Fix erroneous EOF calculation when F command is interrupted.
  * Make WIN32C version include this fix from 551:
    Don't count lines in initial screen if using -X with -F.
  * Fix display bug in WIN32C version.
  * Fix memory corruption when built with libtermcap.
  * Support libtinfow.
* Wed May 20 2020 andreas.stieger@gmx.de
- less 562:
  * Update unicode tables
  * formatting changes in man pages
* Sat Apr  4 2020 andreas.stieger@gmx.de
- less 557:
  * Update Unicode tables
  * Treat Hangul Jamo medial vowels and final consonants as zero width
  * Display error message immediately when -o is toggled and
    input is not a pipe
  * Fix memory corruption when built with libtermcap
  * Support libtinfow
* Wed Dec 11 2019 kukuk@suse.com
- Move lesskey* from /etc to /usr/etc
* Sat Sep 21 2019 andreas.stieger@gmx.de
- less 551:
  * Add --mouse option
  * Add --wheel-lines option
  * Add --no-histdups option
  * Add --save-marks option
  * Support PCRE2 regular expression library
  * Redraw screen on SIGWINCH even if screen size doesn't change
  * Shell-escape filenames in history so they can be used again
  * Ring bell if user enters invalid long option name
  * Use PCRE_UTF8 flag for pcre regular expressions when in UTF-8 mode
  * Don't count lines in initial screen if using -X with -F
  * Fix bug in v command on empty file
  * Fix bug in v command when filename contains shell metacharacters
- refresh less-429-shell.patch
* Sun Apr 29 2018 kstreitova@suse.com
- update to version 530 [bsc#1091308]
  * Don't output terminal init sequence if using -F and file fits
    on one screen.
  * When using -S, mark truncated lines with a special character.
    The character can be changed or disabled via the new --rscroll
    option.
  * New command M marks the last line displayed on the screen.
  * New command ESC-m removes a line mark.
  * Status column (enabled via -J) now shows mark letters.
  * Status column shows search matches even if highlighting is
    disabled via -G.
  * A second ESC-u command will clear search match markers in the
    status column.
  * Do same ANSI escape code filtering for tag matching that we do
    for searching, to help when viewing syntax-highlighted code.
  * Catch SIGTERM and clean up before exiting.
  * Fix bug initializing default charset on Windows.
  * Handle keypad ENTER key correctly if it sends something other
    than newline.
  * Fix buffering bug when using stdin with a LESSOPEN pipe.
  * Update Unicode tables to 2017-03-08.
  * Pass-thru Unicode formating chars (Cf type) instead of treating
    them as binary chars. But treat them as binary if -U is set.
  * Fix erroneous binary file warning when UTF-8 file contains ANSI
    SGR sequences.
  * Fix bugs when using LESSOPEN and switching between stdin and
    other files.
  * Fix some bugs handling filenames containing shell metacharacters
  * Fix some memory leaks.
  * Allow some debugging environment variables to be set in lesskey
    file.
  * Code improvements:
  * Use ANSI prototypes in funcs.h declarations.
  * Fix some const mismatches.
  * Remove archaic "register" in variable declarations.
- remove the following patches (applied upstream)
  * less-429-strict_aliasing.patch
  * less-429-terminate.patch
- renumber patches
- remove 'make mkhelp' from the specfile as mkhelp.pl is now
  distributed in the tarball
* Tue Apr  3 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Fri Oct 27 2017 werner@suse.de
- Let lessopen.sh also handle UTF-8 for (g)roff input, only apparmor
  as breaker of /usr/bin/file re,mains as "file" is not allowed to
  read files within the tool lessopen.sh
* Fri Apr 28 2017 werner@suse.de
- Extend lesskey with mappings for 8-bit controls key escape sequences
* Tue Apr  4 2017 kstreitova@suse.com
- update to version 487
  * New commands ESC-{ and ESC-} to shift to start/end of displayed
    lines.
  * Make search highlights work correctly when changing caselessness
    with -i.
  * New option -Da in Windows version to enable SGR mode.
  * Fix "nothing to search" error when top or bottom line on screen
    is empty.
  * Fix bug when terminal has no "cm" termcap entry.
  * Fix incorrect display when entering double-width chars in search
    string.
  * Fix bug in Unicode handling that missed some double width
    characters.
  * Update Unicode database to 9.0.0.
- remove less-429-widechars.patch that is no longer needed
  (fixed upstream)
- refresh less-429-shell.patch
- get rid of %%{name} macro from the patch names
* Sun Nov  1 2015 astieger@suse.com
- less 481:
  * Don't overwrite history file; just append to it. This behaves
    better when multiple sessions are running less simultaneously
    and using the same history file.
  * New command ESC-G goes to end of currently buffered data in a
    pipe.
  * Disable history feature when compiled with LESSHISTFILE set to
    "-".
  * In more-compatible mode, make the -p option apply to every file
    opened, not just the first one.
  * In more-compatible mode, change the -e option to work like -E,
    not -EF.
  * Treat multiple CRs before LF are like one CR (all the CRs are
    hidden).
  * Allow "extra" string in lesskey file to append to a multi-char
    command (like a search pattern), without executing the command.
  * Ignore -u/-U setting while viewing help file, so that underline
    and bold chars are displayed correctly.
  * Improve detection of "binary" files in UTF-8 mode.
  * Fix bug with ++ commands.
  * Fix bug where prompt was sometimes not displayed with +G.
  * Fix possible memory corruption
  * Fix bugs and improve performance in ampersand filtering.
  * Allow %%%% escape sequence in LESSOPEN variable.
  * Automate construction of Unicode tables from Unicode database.
- add keyring and verify source signature
- drop upstream patches:
  * less-458-out_of_bounds_read.patch
  * less-fix_crash_in_hilite_line.patch
* Thu Jun 25 2015 vcizek@suse.com
- fix a crash in hilite_line (boo#915387)
  * added less-fix_crash_in_hilite_line.patch
* Fri Mar 13 2015 kstreitova@suse.com
- add less-458-out_of_bounds_read.patch to fix an "out of bounds
  read access in the UTF-8" vulnerability (bnc#921719),
  (CVE-2014-9488)
* Fri Dec 19 2014 meissner@suse.com
- build with PIE
* Mon Nov 24 2014 tchvatal@suse.com
- Spec-cleaner
- Remove jless less-normal provides/obsoletes they are from 2000
* Tue Jul 29 2014 pgajdos@suse.com
- SuSE -> SUSE [bnc#889031] (internal)
* Wed Nov 13 2013 tiwai@suse.de
- Fix lesspipe.sh for removing properly the leftover tmp files
  when viewing patch files without colordiff (bnc#850225)
* Tue Jul 30 2013 sweet_f_a@gmx.de
- Update to version 458
  * Fix Win32 attribute display bug.
  * Fix display bug when using up/down arrow on the command line.
* Mon May  6 2013 sleep_walker@suse.cz
- make sure that -R or --RAW-CONTROL-CHARS is set in LESS
  environment variable
* Mon May  6 2013 sleep_walker@suse.cz
- add support for colordiff in lessopen.sh
* Wed Mar 20 2013 idonmez@suse.com
- Update to version 457
  * Allow backslash escaping of metacharacters in LESS environment
    variable if the --use-backslash option is set.
  * Don't quit if syntax errors are found in command line options.
  * Increase sizes of some internal buffers.
  * Fix configure bug with --with-regex=none.
  * Fix crash with "stty rows 0".
* Mon Nov 12 2012 puzel@suse.com
- Update to version 456
  * Yet another bugfix in option string parser
* Tue Nov  6 2012 puzel@suse.com
- Update to version 455
  * Bugfixes in buildsystem and option parser
* Sun Nov  4 2012 puzel@suse.com
- Update to version 453
  * Allow backslash escaping of metacharacters in LESS environment
    variable.
  * Don't quit if syntax errors are found in command line options.
  * Increase sizes of some internal buffers.
  * Fix configure bug with --with-regex=none.
  * Fix crash with "stty rows 0".
* Tue Sep 25 2012 vdziewiecki@suse.com
- Update to version 451
  * Add ESC-F command to keep reading data until a pattern is
  * found.
  * Use exit code of LESSOPEN script if LESSOPEN starts with
  * "||".
  * When up/down arrow is used on the command line immediately
  * after typing text, the next command starting with that text is
    found.
  * Add support for GNU regex.
  * Add configure option --with-regex=none and fix compile
  * errors when compiling with no regex library.
  * Fix possible crashes caused by malformed LESSOPEN or
    LESSCLOSE variables.
  * Fix bug highlighting text which is discontiguous in the
  * file due to backspace processing.
  * Fix bug in displaying status column when scrolling
  * backwards with -J and -S in effect.
- Remove speed patch.
- Remove less-429-lessecho-man.patch
* Mon Dec  5 2011 cfarrell@suse.com
- license update: GPL-3.0+ or BSD-2-Clause
  The less license is a choice of either GPL-3.0+ or BSD-2-Clause (less
  license). Use SPDX format
* Wed Nov 30 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Fri Nov  4 2011 puzel@suse.com
- correctly recognize xz compressed data (bnc#728033)
* Thu Jun 16 2011 idonmez@novell.com
- Update to version 444
  * Fix bug in unget handling that can cause strange effects
    on the command line.
  * Remove vestiges of obsolete -l option that can cause a crash.
* Thu May 26 2011 sweet_f_a@gmx.de
- bump version 443
  * Change search behavior such that when a search is given an explicit pattern,
    the entire displayed screen is included in the search and not just the
    portion after the target line.
  * Add -A option to change search behavior to the old way: only the portion of
    the screen after the target line is searched.
  * Add %%F formatting to prompt strings, replaced by the last component of the
    input file.
  * Control-G while editing a command exits the command.
  * Less now exits with status 2 if control-C is pressed and -K is in effect.
  * Fix "ungetc overflow" when passing long commands via the -p option.
  * Fix bug in using line filtering via the & command in combination with -i and
  - I.
  * Fix bug in handling negative arguments to the -j option.
  * Fix bug in handling %%t in prompt strings.
  * Improve handling of long option names.
  * Improve percentage calculation for very large files.
- remove mouse patch because
  * conflicting short opt -A since version 443, see changes above
  * was working for xterm only so probably nobody is using it
* Thu May 26 2011 sweet_f_a@gmx.de
- lessopen.sh, support xz compressed data
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Thu Oct  1 2009 puzel@novell.com
- add support for listing directories to lessopen.sh (bnc#537646)
  - thanks to Dimitar Pashov for the patch
* Mon Jul 27 2009 puzel@novell.com
- bump version to less-436 (final)
  * no code changed
* Fri Jul 10 2009 puzel@novell.com
- update to less-436beta
  * Fixes a few search and filter bugs.
* Tue Jul  7 2009 puzel@novell.com
- update to less-434beta
  * Don't pass "-" to non-pipe LESSOPEN unless it starts with "-".
  * Allow a fraction as the argument to the -# (--shift) option.
  * Fix highlight bug when underlined/overstruck text matches at end of line.
  * Fix non-regex searches with ctrl-R.
* Wed Jun  3 2009 puzel@suse.cz
- update to less-429
  * LESSOPEN pipe will now be used on standard input, if the LESSOPEN
    environment variable begins with "|-".
  * The -D option with one number now means use the normal background color.
  * Fix non-ANSI-compliant code that caused problems with some compilers.
  * Fix binary file detection in UTF-8 mode.
  * Fix display problems with long lines on "ignaw" terminals.
  * Fix problem interrupting the line number calculation for initial prompt.
  * Fix SGR emulation when dealing with multiple attributes (eg. bold+underline).
  * Fix highlight bug when searching for underlined/overstruck text.
- drop fix-binfile-detection.patch (fixed upstream)
- drop less-424b.patch (fixed upstream)
* Wed Dec 17 2008 puzel@suse.cz
- add fix-binfile-detection.patch (bnc#446732)
* Thu Aug 28 2008 anosek@suse.cz
- updated to version 424b
  * New "&" command allows filtering of lines based on a pattern.
  * Status column now displays a search match, even if the matched
    string is scrolled off screen because -S is in effect.
  * Improve behavior of -F option.
  * Allow CSI character (0x9B) to work in UTF-8 mode.
  * Output carriage return at startup in case terminal doesn't default
    to column 1.
  * Fix bug in '' (quote, quote) command after G command.
* Sun Jul 20 2008 crrodriguez@suse.de
- fix build
* Tue Jan 29 2008 anosek@suse.cz
- updated to version 418
  * Fix search bug when using -R and text contains ANSI color escape sequences.
  * Fix crash when using -r with UTF-8 text containing 0x9B bytes.
  * Fix display bug when using ' command to move less than one page forward.
  * Update GPL to version 3.
* Thu Dec 20 2007 anosek@suse.cz
- udpated to version 416
  * New --follow-name option makes F command follow the name of a file
    rather than the file descriptor if an open file is renamed.
  * Make searching with -i/-I work correctly with non-ASCII text.
  * Support CSI escape sequences, like SGR escape sequences.
  * Fix bug which caused screen to fail to repaint when window is resized.
  * Fix bug in using -i and -I flags with non-ASCII text.
  * Fix crash when searching text containing certain invalid UTF-8 sequences.
* Thu Nov 15 2007 werner@suse.de
- Avoid memory leaks in case of an error during saving history
* Wed Nov 14 2007 werner@suse.de
- Speed up the history save by using a temorary file and make the
  stream of that file a full buffered one.
* Wed Oct 31 2007 anosek@suse.cz
- udpated to version 409
  * fixed crash when searching text containing certain
    invalid UTF-8 sequences.
* Wed Sep 12 2007 anosek@suse.cz
- fixed Less -l option conflicts with more -l [#307796] (more.patch)
* Fri Aug 17 2007 anosek@suse.cz
- fixed Incorrect behaviour of -r parameter [#244791]
  (save_line_position.patch)
* Fri Jul 27 2007 anosek@suse.cz
- updated to version 406
  * Allow decimal point in number for %% (percent) command.
  * Allow decimal point in number for -j option (fraction of screen height).
  * Make n command fetch previous pattern from history file on first search.
  * Don't rewrite history file if it has not changed.
  * Don't move to bottom of screen on first page.
  * Don't output extraneous newlines, so copy & pasting lines from the
    output works better.
  * The -c option has been made identical with the -C option.
  * Allow "/dev/null" as synomym for "-" in LESSHISTFILE to indicate
    that no history file should be used.
  * Search can now find text which follows a null byte, if the PCRE
    library is used, or if no-regex searching (ctrl-R) is used.
  * Better compatibility with POSIX more specification.
  * Make -f work for directories.
  * Make "t" cmd traverse tags in the correct order.
  * Allow a few binary characters in the input file before warning
    that the file is binary.
  * Don't warn that file is binary if it merely contains ANSI color sequences
    and -R is in effect.
  * Update Unicode character tables.
  * Support DESTDIR in Makefile.
  * Fix bug when filename contains certain shell metacharacters such as "$".
  * Fix bug when resizing the window while waiting for input from a pipe.
  * Fix configure bugs.
* Mon Mar 26 2007 rguenther@suse.de
- add ncurses-devel BuildRequires
* Fri Apr  7 2006 mmarek@suse.cz
- don't use $SHELL for running external commands to avoid
  side-effects caused by $SHELL's startup scripts
  [#158044, #164041] (shell.patch)
* Mon Feb  6 2006 mmarek@suse.cz
- fix editing of wide characters in search prompt (regression
  caused by dropping iso patch)
  (widechars.patch)
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Tue Jan 10 2006 mmarek@suse.cz
- upated to version 394
- removed iso patch, because vanilla less-394 is capable enough
- removed patches 2-7
- lessecho.1 included in upstream tarball
- unpacked less-SuSE.tar.bz2
* Mon Jan  2 2006 mmarek@suse.cz
- fix typo in previous fix
* Mon Dec 19 2005 mmarek@suse.cz
- fixed lessopen man page
  [#105865]
- applied lessopen patches to less-SuSE.tar.bz2
* Fri Oct  7 2005 dmueller@suse.de
- add head of changelog to rpm listing
* Wed Oct  5 2005 mmarek@suse.cz
- updated Japanese patch to less-382-iso258, fixing #64531
  * renumbered patches in specfile
  * fixed implicit function declaration warning
* Thu Sep 15 2005 mmarek@suse.cz
- make expand_linebuf() faster [#39724]
* Tue Sep 13 2005 mmarek@suse.cz
- recognize .cab archives with new file(1) [#116779]
* Wed Sep  8 2004 pmladek@suse.cz
- fixed searching if the ANSI escape sequences are used in the text;
  it still does not work for Japanese coding (see search_ansi_esc_seq.patch
  for comments) [#44115]
* Fri May 14 2004 pmladek@suse.cz
- fixed UTF-8 support to do not consider all non-ASCII characters as wide
  characters; they are detected correctly by the function internalize_utf8
  if _XOPEN_SOURCE is enabled (fix added to the utf8.patch) [#29455]
* Thu May 13 2004 pmladek@suse.cz
- improved handling of SIGTERM to remove temporary files and clean up terminal
  [#39273] (terminate.patch)
- improved lessopen.sh [#39272] :
  * removed potential tmp file race
  * added w3m to preprocess HTML pages as an alternative for lynx;
    w3m is preferred over lynx
* Wed Apr 14 2004 pmladek@suse.cz
- fixed search line to display correctly UTF-8 characters; solution based
  on the Japanese patch [#19587]
* Tue Feb 24 2004 pmladek@suse.cz
- updated to version 382:
  * removed some old copyrighted code
- fixed to work with Turkish locales, problems with functions like
  isupper, many thanks to Björn Jacke for hint and patch [#29827]
- added some missing braces in opttbl.c to mouse.patch and iso254.patch
- fixed code violating strict aliasing rules
- used norootforbuild
* Fri Nov 14 2003 pmladek@suse.cz
- fixed lessopen.sh:
  * added some missing quotes [#33058]
  * the script adds ./ before a relative file name to enable preprocess
    a file whose name begins with a "-" or "+" (inspiration got from RedHat)
    [#33058]
  * fixed detection of Debian's packages
- merged mouse_test_for_xselection.patch into mouse.patch
* Wed Sep 10 2003 pmladek@suse.cz
- test the utility xselection only if the mouse support is enabled [#29612]
* Mon Aug  4 2003 pmladek@suse.cz
- updated to version 381 [#17201]:
  * new -L option to disable LESSOPEN processing
  * further support for large (64 bit) file addressing
  * use only 7 spaces for line numbers in -N mode, if possible
  * fix some nroff issues in the man page
- removed obsolete patch for support for large file addressing (lfs.patch)
- used autoreconf to rebuild autoconf stuff
* Mon Dec 30 2002 pmladek@suse.cz
- updated to version 378:
  * default buffer space is now 64K as documented
  * search highlighting works properly when used with -R
  * windows version works properly when input file contains carriage returns
  * clean up some compiler warnings
- merged less-378-iso254-bug.patch into the less-378-iso254.patch
- removed unused CXXFLAGS setting from the spec file
- fixed the patch for the mouse support (prefixes to a less commands were not
  printed immediately in the searched string as yet) [#21320]
* Tue Aug 27 2002 pmladek@suse.cz
- removed code which is obsoleted by Japanese patch and make
  problems with UTF-8 [#17592, #17593]
* Fri Aug  9 2002 pmladek@suse.cz
- updated to new stable version 376
  * -x option can now specify multiple variable-width tab stops
  * -X option no longer disables keypad initialization
  * new option --no-keypad disables keypad initialization
  * new commands t and T step through multiple tag matches
  * new prompt style set by option -Pw
  * system-wide lesskey file now defaults to sysless in etc directory
    instead of .sysless in bin directory
  * pressing RightArrow or LeftArrow while entering a number now shifts
    the display N columns rather than editing the number itself
  * searching works better with ANSI (SGR) escape sequences
  * improved performance in reading very large pipes
  * eliminated some dependencies on file offets being 32 bits
  * fixed problems when viewing files with very long lines
  * fixed overstriking in UTF-8 mode, and overstriking tabs
  * improved horizontal shifting of text using -R option with ANSI color
  * improved handling of filenames containing shell metacharacters
- fixed Japanese patch for this less version
- iso247-bugs patch merged with Japanese patch
- fixed bug in detection of xselection utillity
* Fri May 17 2002 pmladek@suse.cz
- added mouse support (inspired by vim-6.0):
  * it is enabled by -A option
  * works only in xterm
  * contains support for mouse wheel [#9385]
  * direct access to X selection by xselection utility
- applied patches less preprocessor patches
* Thu Mar 21 2002 pmladek@suse.cz
- improved detection for input conding from keyboard, proper input
  coding is detected by locales now [#15155]
- changed default input coding from "japanese-iso7" to "iso8859"
- user can still define his input conding by the environment
  variable JLESSKEYCHARSET
* Tue Mar 12 2002 pmladek@suse.cz
- changed meaning of the variable LESS_ADVANCED_PREPROCESSOR,
  many binary formats are preprocessed always, the text
  formats (ps, troff, html) are preprocessed only when
  the variable LESS_ADVANCED_PREPROCESSOR=yes
* Thu Feb 21 2002 pmladek@suse.cz
- added support for cab files into less preprocessor
* Mon Feb 18 2002 pmladek@suse.cz
- fixed to do not install .orig files
* Fri Feb 15 2002 pmladek@suse.cz
- error messages in lessopen.sh must be redirected to the standard
  error output
- fixed Copyright in lessopen.sh and lessclose.sh
* Thu Feb 14 2002 pmladek@suse.cz
- added man page for lessecho from the Debian GNU/Linux distribution
  [#13275]
- fixed usage of macro %%suse_update_config
* Mon Nov  5 2001 mfabian@suse.de
- add init_def_codesets.diff (fixes the problem that less
  outputs ESC-A to set 'G1' to 'Right-hand Part of Latin
  Alphabet No.1 ISO 8859/1, ECMA-94'. This works only with
  xterm but fails with konsole, rxvt ...)
  Thanks to Michael Schroeder <mls@suse.de>
- add arabic.diff to fix typo in possible values of JLESSPLANESET
  (alabic -> arabic).
- remove %%attr(644, -, -) in front of %%doc, this gives
  wrong permissions to the directory /usr/share/doc/packages/less
  use 'chmod 644 LICENSE COPYING NEWS' instead.
* Fri Sep 21 2001 vinil@suse.cz
- README.SuSE about LESS_ADVANCED_PREPROCESSOR added
* Tue Sep 11 2001 mfabian@suse.de
- include Japanese patch
- rewrote utf8.diff. Together with the Japanese patch it almost
  works now. German, Italian and Spanish man pages display fine
  in an UTF-8 xterm. Czech is still broken, but that seems to
  be the fault of groff rather than less.
- add less-SuSE.patch to display Japanese roff files correctly
* Wed Sep  5 2001 vinil@suse.cz
- .zip handled by "unzip -v" (#10211)
* Tue Aug 28 2001 vinil@suse.cz
- LESS_ADVANCED_PREPROCESSOR used for handling more than compressed
  files (#9287)
* Tue Aug 14 2001 vinil@suse.cz
- typo fixed (#9730)
* Tue Jul 17 2001 vinil@suse.cz
- can handle symlinks              \
- can handle x and pm man pages    -- bug #9393
* Mon May 14 2001 vinil@suse.cz
- utf8.diff added: less can handle bold and underlined utf-8 chars
  (needed especially for man)
* Sat May  5 2001 schwab@suse.de
- lessopen.sh: Create tempfiles securely; add quotes as necessary; make
  sure we don't match the file type against the file name; don't leave
  temporary files around.
* Fri May  4 2001 schwab@suse.de
- lessopen.sh: echo nothing if we have no alternate file (#7679).
* Fri May  4 2001 schwab@suse.de
- lessopen.sh: Use the first stage contents if the second stage has
  nothing special.  Tighten the patterns that recognize compressed
  data.  Just echo the original file name if the file is not readable.
* Tue May  1 2001 schwab@suse.de
- lessclose.sh: Only remove file if different from original file.
* Mon Apr 30 2001 schwab@suse.de
- lessopen.sh: Use original file name if no conversions were done (#7421).
* Fri Apr 27 2001 vinil@suse.cz
- lessing non-existing files now produce error message [bug #7320]
* Thu Apr 19 2001 mfabian@suse.de
- removed "LESSCHARSET=latin1" from /etc/lesskey
  If LESSCHARSET is not set, latin1 is the default, unless
  "UTF-8" is found in LC_ALL, LC_CTYPE or LANG, the the default
  is utf-8. So setting "LESSCHARSET=latin1" is useless in
  case of a iso-8859-x locale and bad in case of a UTF-8 locale.
  If LESSCHARSET is set in /etc/lesskey, one cannot even override
  it by setting the environment variable anymore.
* Fri Mar 16 2001 vinil@suse.cz
- less piping completely rewritten (using 'file', now)
  (bug #6256 fixed)
* Wed Jan 10 2001 smid@suse.cz
- lesspipe.sh fixed
* Tue Jan  9 2001 smid@suse.cz
- lesspipe.sh fixed [#5003]
* Wed Dec 13 2000 mfabian@suse.de
- added "Provides: normal-less". This enables the japanized
  jless to use "Provides: less" and "Conflicts: normal-less".
  (Suggestion by bjacke@suse.de)
* Mon Dec 11 2000 smid@suse.cz
- added conflict with jless
* Fri Dec  1 2000 aj@suse.de
- Compile with LFS support, fix CFLAGS/CXXFLAGS.
* Tue Nov 21 2000 werner@suse.de
- Remove swapping of kp-separator/kp-decimal because it's
  done in xkbd map for german keyboards
* Tue Nov 21 2000 werner@suse.de
- Add some newer xterm escape sequences (oldFunctionsKeys)
* Mon Sep 25 2000 ro@suse.de
- make lesspipe executable again
* Mon Sep 25 2000 smid@suse.cz
- upgrade to 358
* Mon May 22 2000 smid@suse.cz
- upgrade to 354
- Copyright field fix
- documentation added
* Thu Apr 13 2000 smid@suse.cz
- buildroot added
- upgrade to 3.46
* Thu Feb 10 2000 kukuk@suse.de
- Fill out Copyright and Group field
* Mon Jan 24 2000 kukuk@suse.de
- Move /usr/man -> /usr/share/man
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Jun 17 1999 ro@suse.de
- update to less-340 using jurix-dif
- added [rs]pm to lesspipe-switch
- added werners lesskey
* Thu Sep  4 1997 bs@suse.de
- added *.as to lesspipe.sh
* Wed May 28 1997 werner@suse.de
- added new etc/lesskey and etc/lesskey.bin
* Sat Apr 26 1997 florian@suse.de
- update to new version 332
* Sun Apr 13 1997 florian@suse.de
- update to new version 330
* Thu Jan  2 1997 bs@suse.de
  added new etc/lesskey*
* Thu Jan  2 1997 bs@suse.de
  lesskey from aaa_base inserted.
* Thu Jan  2 1997 florian@suse.de
- Neue Version 321.
- Bug mit falschen Aufruf von free() behoben.
- In /etc/profile wird global fuer alle Benutzer eine 'lesskey'-Datei
  eingetragen. Braucht also nicht mehr im Home-Verzeichnis aller Benutzer
  erstellt werden.
