#
# spec file for package python-decorator
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


# Please submit bugfixes or comments via http://bugs.opensuse.org/
#
%{?!python_module:%define python_module() python-%{**} python3-%{**}}
Name:           python-decorator
Version:        4.4.2
Release:        150200.7.6.1
Summary:        Decorators for Humans
License:        BSD-2-Clause
Group:          Development/Languages/Python
URL:            https://github.com/micheles/decorator
Source:         https://files.pythonhosted.org/packages/source/d/decorator/decorator-%{version}.tar.gz
BuildRequires:  %{python_module setuptools}
BuildRequires:  dos2unix
BuildRequires:  fdupes
BuildRequires:  python-rpm-macros
%ifpython3
Provides:       python36-decorator = %{version}
Obsoletes:      python36-decorator <= %{version}
%endif
BuildArch:      noarch
%python_subpackages

%description
Typical implementations of Python decorators involve nested
functions, and do not preserve the signature of decorated functions,
thus can be confusing to both developers and documentation tools.

This module changes the usage of decorators for the average
programmer so as to make decorators such as memoize, tracing,
redirecting_stdout, locked, etc. more accessible.

%prep
%setup -q -n decorator-%{version}

%build
%python_build

%install
%python_install
%python_expand %fdupes %{buildroot}%{$python_sitelib}

%check
%python_expand PYTHONPATH=%{buildroot}%{$python_sitelib} $python src/tests/test.py -v

%files %{python_files}
%license LICENSE.txt
%doc CHANGES.md README.rst
%{python_sitelib}/decorator.py*
%pycache_only %{python_sitelib}/__pycache__/decorator.*.py*
%{python_sitelib}/decorator-%{version}-py*.egg-info

%changelog
* Mon Jun 16 2025 daniel.garcia@suse.com
- Add python36-decorator provides/obsoletes to enable SLE-12 ->
  SLE-15 migration, bsc#1233012
* Sat Mar 14 2020 dmueller@suse.com
- update to 4.4.2:
  * removing the usage of `__file__`, that was breaking PyOxidizer.
  * fixes for the future Python 3.9.
  * some fixes for the future Python 3.10.
* Fri Dec 20 2019 dmueller@suse.com
- update to 4.4.1:
  Changed the description to "Decorators for Humans" are requested by
  several users. Fixed a .rst bug in the description as seen in PyPI.
* Tue Mar 19 2019 tchvatal@suse.com
- Update to 4.4.0:
  * Fixed a regression with decorator factories breaking the case with no
    arguments by going back to the syntax used in version 4.2.
* Wed Feb 13 2019 toddrme2178@gmail.com
- update to version 4.3.2
  * now the decorator module can decorate generator functions by
    preserving their being generator functions
  * Set `python_requires='>=2.6, !=3.0.*, !=3.1.*'` in setup.py
- update to version 4.3.1
  * Added a section "For the impatient" to the README, addressing
    an issue raised by Amir Malekpour.
  * Added support for Python 3.7.
  * Now  the path to the decorator module appears in the
    tracebacks, as suggested by a user at EuroPython 2018.
* Tue Dec  4 2018 mcepl@suse.com
- Remove superfluous devel dependency for noarch package
* Tue Apr 17 2018 jengelh@inai.de
- Ensure neutrality of description.
* Tue Apr 17 2018 arun@gmx.de
- update to version 4.3.0:
  * Extended the decorator family facility to work with positional
    arguments and updated the documentation. Removed
    decorator.getargspec and provided decorator.getfullargspec
    instead. This is convenient for users of Python 2.6/2.7, the
    others can just use inspect.getfullargspec.
* Wed Jan 17 2018 arun@gmx.de
- specfile:
  - updated copyright year
- updated to version 4.2.1:
  * Fixed a regression breaking IPython reported by
    https://github.com/spapini .
- changes from version 4.2.0 :
  * Added a facility to define families of decorators (aka decorators
    with arguments) as requested by several users. Accepted a pylint
    patch by David Allouche.
* Wed Aug  9 2017 tbechtold@suse.com
- update to 4.1.2:
  * Made it possible to define decorators converting coroutines into regular
    functions.
  * Changed the documentation build system to sphinx and uploaded the docs
    on readthedocs.org.
  * Support for Python 3.5 coroutines defined with `async def`, thanks to
    Victor-Nicolae Savu who raised the issue of `iscoroutinefunction` not
    giving the right answer for coroutines decorated with the decorator module.
* Wed Apr  5 2017 jmatejek@suse.com
- fix source url
* Sat Apr  1 2017 toddrme2178@gmail.com
- Update to 4.0.11
  * Small improvements to the documentation and tested with Python 3.6
- Update to 4.0.10
  * Improved the documentation thanks to Tony Goodchild (zearin) who also
    provided a much better CSS than the one I was using.
- Update to 4.0.9
  * Same as 4.0.7 and 4.0.8, re-uploaded due to issues on PyPI.
- Update to 4.0.7
  * Switched to a new changelog format (the one in http://keepachangelog.com/)
    since it was contributed by Alexander Artemenko. Re-added a newline to support
    old version of Python, as requested by [azjps](https://github.com/azjps).
- Update to 4.0.6
  * Removed a file x.py accidentally entered in the tarball.
- Update to 4.0.5
  * Documented a quirk signaled by David Goldstein when writing decorators
    for functions with keyword arguments. Avoided copying the globals,
    as signaled by Benjamin Peterson.
- Update to 4.0.4
  * Included a patch from Zev Benjamin: now decorated functions play well
    with cProfile.
- Update to 4.0.3
  * Added a warning about the memoize example, as requested by Robert
    Buchholz.
- Update to 4.0.2
  * docs/README.rst was not included in MANIFEST.in by accident,
    thus breaking the source installation.
- Update to 4.0.1
  * Added docs directory and upload_docs command. Fixed bug with
    `__qualname__`, reported by Lucian Petrut.
- Update to 4.0.0
  * Removed the need for 2to3 by dropping the support for Python 2.5.
  * Added a MANIFEST.in file and produced a proper wheel. Improved
    the integration with setuptools so that `python setup.py test` works.
  * Reworked the documentation and introduced `decorator.decorated`.
  * Removed any dependence from `inspect.getargspec`, which is deprecated
    in Python 3.5, as signaled by Ralf Gommers.
  * Fixed `contextmanager` to work with Python 3.5.
  * Copied the `__qualname__` attribute, as requested by Frazer McLean.
  * Added a `dispatch_on` facility to implement generic functions.
- Implement single-spec version.
* Sat May  2 2015 benoit.monin@gmx.fr
- update to version 3.4.2:
  * Same as 3.4.1, re-uploaded to PyPI
- additional changes from version 3.4.1:
  * Ported the repository from GoogleCode to GitHub and added
    Travis CI support
  * Tests are executed with the new command `python test.py -v`
  * setuptools is now mandatory in Python 3
  * The suggested installation tool is `pip`, not `easy_install`
  * Supported IronPython and other Python implementations without
    sys._getframe, as requested by Doug Blank
- remove python-nose from BuildRequires, unneeded
- replace README.txt with README.rst: changed upstream
* Thu Oct 24 2013 speilicke@suse.com
- Require python-setuptools instead of distribute (upstreams merged)
* Tue Jun 25 2013 dmueller@suse.com
- update to 3.4.0:
  * Added the ability to use classes and generic callables as callers and
  implemented a signature-preserving contexmanager decorator. Fixed a bug
  with the signature f(**kw) in Python 3 and fixed a couple of doctests
  broken by Python 3.3, both issues pointed out by Dominic Sacré (18/10/2012)
* Wed May 23 2012 highwaystar.ru@gmail.com
- update to version 3.3.3
- minor spec improvement
- python3 package added
* Tue Nov 29 2011 cfarrell@suse.com
- license update: BSD-2-Clause
  SPDX format
* Thu Nov 24 2011 idoenmez@suse.de
- Update to upstream tarball, no code changes
* Mon Sep 26 2011 saschpe@suse.de
- Add python-distribute (setuptools) BuildRequires, seemed to got lost
* Thu Sep  1 2011 saschpe@suse.de
- Update to version 3.3.2
- Added proper changes file
* Thu Jan  7 2010 hpj@urpla.net
- Update to 3.3.0
* Mon Aug 10 2009 cfarrell1980@gmail.com
- Update to 3.0.1
* Tue Dec  2 2008 jfunk@funktronics.ca
- Initial release
