#
# spec file for package release-notes-sles
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define SUSE_PROD SUSE_Linux_Enterprise_Server_15
# "lifecycle" changes the document profiling, accepted values:
#   beta | maintained | unmaintained
%define lifecycle maintained
Name:           release-notes-sles
Version:        15.6.20250821
Release:        150600.3.9.1
Summary:        Release Notes for SUSE Linux Enterprise Server
License:        CC-BY-ND-4.0
Group:          Documentation/SUSE
URL:            https://www.suse.com/releasenotes/
Source:         %{name}-%{version}.tar.bz2
BuildRequires:  daps
BuildRequires:  suse-xsl-stylesheets >= 1.9.18
BuildRequires:  update-desktop-files
BuildRequires:  w3m
Requires:       dejavu-fonts
Requires:       google-opensans-fonts
Provides:       release-notes() = SLES
BuildArch:      noarch

%description
This package contains the release notes for SUSE Linux Enterprise Server.
After installing this package, the release notes files can be
found in the %{_datadir}/doc/release-notes directory.  The release notes
are available in the following output formats: PDF, HTML, and TXT.

%prep
%setup -q

%build
sed -i 's/@VERSION@/%{version}/' adoc/release-notes-docinfo.xml
%make_build all LIFECYCLE=%{lifecycle}

%install
rnpath=%{buildroot}%{_datadir}/doc/release-notes/%{SUSE_PROD}
install -m 0644 -D LICENSE ${rnpath}/LICENSE
install -m 0644 -D "build/release-notes/html/release-notes/index.html" "${rnpath}/RELEASE-NOTES.en.html"
install -m 0644 -D "build/release-notes/html/release-notes/changelog.html" "${rnpath}"
install -m 0644 -D "build/release-notes/html/release-notes/kernel-parameter-changes.html" "${rnpath}"
cp -R "build/release-notes/html/release-notes/static/" "${rnpath}"
install -m 0644 -D "build/release-notes/yast-html/release-notes.html" "${rnpath}/RELEASE-NOTES.en.rtf"
install -m 0644 -D "build/release-notes/release-notes_color_en.pdf" "${rnpath}/RELEASE-NOTES.en.pdf"
install -m 0644 -D "build/release-notes/release-notes.txt" "${rnpath}/RELEASE-NOTES.en.txt"

%files
%doc %{_datadir}/doc/release-notes/

%changelog
* Thu Aug 21 2025 lukas.kucharczyk@suse.com
- 15.6.20250821 (tracked in bsc#933411)
- Added note about virt-install --cdrom with SEV (bsc#1241602)
- Added note about SSH algo control method changing and link
  (bsc#1244260)
- Added note about 4096-bit signing key (jsc#PED-8000)
- Added note about Non unified image for SEV (bsc#1232762)
- Added note about new systems management module (jsc#PED-12703)
- Added note about externally supported flag (jsc#PED-8462)
- Added MI300A support (jsc#PED-7607)
- Added note about PHP 7.4 deprecation (jsc#PED-8166)
- Clarified support of BPF-related tools (jsc#PED-8569)
- Added note about deprecating NFSv2 (bsc#1230914)
* Thu Sep 26 2024 fs@suse.com
- 15.6.20240926 (tracked in bsc#933411)
  - Corrected a wrong entry regarding 389 and OpenLDAP
  * OpenLDAP will be replaced by 389 in future SLE versions
  * OpenLDAP has been re-added to SLE 15 SP5 and SP6 to prolong
    the migration time window
* Fri Sep  6 2024 lukas.kucharczyk@suse.com
- 15.6.20240906 (tracked in bsc#933411)
- Updated max user space limit (bsc#1227524)
- Added note about OpenLDAP deprecation (jsc#PED-8118)
- Added Confidential computing info (jsc#PED-8022)
- Added note about Python 3 packages in Basesystem (bsc#1224313)
* Wed May 15 2024 lukas.kucharczyk@suse.com
- 15.6.20240515 (tracked in bsc#933411)
- Added note about timezone-java removal (jsc#PED-8162)
- Added note about xorriso split (jsc#PED-5016)
- Added note about IAA Crypto Driver (jsc#PED-7757)
- Added note about sysctl-logger (jsc#PED-8070)
- Added note about bind 9.18 (jsc#PED-7933)
- Added note about pgAdmin4 update (jsc#PED-8160)
- Added note about IMA/EVM signing plugin (jsc#PED-7247)
- Added note about disabled LVM reuse (jsc#PED-7980)
- Added note about self-updated URL change (jsc#PED-7561)
- Added note about default container registries (jsc#PED-8291)
- Added note about LUKS2 installer support (jsc#PED-3881)
- Added note about DLPAR remove failing with Emulex FC adapter
  (bsc#1222895)
- Added note about out of memory during installation on Power
  (bsc#1223982)
- Added note about kdump output directory format (jsc#DOCTEAM-1384)
- Fixed certification info (jsc#DOCTEAM-1386)
- Updated kernel version to 6.4 (jsc#PED-4594)
* Wed Apr 17 2024 lukas.kucharczyk@suse.com
- 15.6.20240417 (tracked in bsc#933411)
- Added note about OpenSSH update (bsc#1222831)
- Added note about CPU mitigations (bsc#1217940)
- Added note about SSH between different architectures (bsc#1216868)
- Added note about glibc 2.38 (bsc#1220966)
- Added mention of searching packages on RMT systems (bsc#1220964)
- Added note about dropping HPC product (jsc#PED-7684)
- Added note about secure boot IPL requirements (bsc#1222353)
- Added note about OpenSSL 3.1.4 (bsc#1220091)
- Added note about systemd effective limit properties (jsc#PED-7978)
- Clarified what needs fixing after glibc update (bsc#1222839)
- Updated product names and abbrevs (jsc#DOCTEAM-1133)
- Removed incorrect search-packages parameter (bsc#1222848)
* Mon Mar 11 2024 lukas.kucharczyk@suse.com
- 15.6.20240311 (tracked in bsc#933411)
- Updated note about cgroup v2 (jsc#PED-1447)
- Updated Virtualization section
* Wed Feb 21 2024 lukas.kucharczyk@suse.com
- 15.6.20240221 (tracked in bsc#933411)
- Added note about systemd 254 (jsc#PED-4846)
- Added note about numad removal (jsc#PED-7916)
- Updated Java lifecycle (jsc#PED-1590)
- Added note about ceph client packages deprecation (jsc#PED-6808)
- Added note about cgroup v2 (jsc#PED-1447)
- aarch64: Document glibc updated for FEAT_MTE (jsc#PED-7310)
- aarch64: Document kernel iommu.passthrough default changed
  (jsc#PED-7009)
- kernel: Document CONFIG_HZ changed (jsc#PED-7600)
- aarch64: Mention NVIDIA Grace Hopper and GPU (jsc#PED-4564)
- aarch64: Updated 64K page size kernel flavor to supported
  (jsc#PED-4489)
- aarch64: Added NVIDIA Grace (jsc#PED-4564)
* Thu Oct 19 2023 lukas.kucharczyk@suse.com
- 15.6.20231019 (tracked in bsc#933411)
- Added Public Cloud module removals (jsc#PED-3806)
- 15.5.20230522 (tracked in bsc#933411)
- Updated certifications info (bsc#1211471)
* Mon May 15 2023 lukas.kucharczyk@suse.com
- 15.5.20230515 (tracked in bsc#933411)
- Added note about secure execution on s390x (bsc#1211316)
* Thu May 11 2023 lukas.kucharczyk@suse.com
- 15.5.20230511 (tracked in bsc#933411)
- Added note about xpram removal (bsc#1205381)
- Added note about ibmvnic (jsc#PED-2319)
- Added note about ibmveth (jsc#PED-2638)
- Added note about NVMf-FC kdump (jsc#PED-1256)
- Added note about pseries-wdt (jsc#PED-530)
- Added note about OpenSSL perf improvements (jsc#PED-512)
- Added note about NSS FreeBL (jsc#PED-495)
- Added note about libgcrypt improvements (jsc#PED-520)
- Added note about nettle crypto enhancements (jsc#PED-505)
* Wed May 10 2023 lukas.kucharczyk@suse.com
- 15.5.20230510 (tracked in bsc#933411)
- Added note about cpuid (jsc#PED-2653)
- Added note about zypper-docker removal (jsc#PED-147)
- Added note about dracut persistent policy (jsc#PED-1884)
- Added note about GISA support in KVM (jsc#PED-461)
- Added note about p11sak Dilithium and Kyber support (jsc#PED-2867)
- Added note about Btfs installation on PowerPC (bsc#1209365)
- Added note about NVMe-oF and LVM (jsc#DOCTEAM-978)
- Added note about nouveau and Nvidia Turing/Ampere (bsc#1210197)
- Added note about Podman 4.3.1 (jsc#PED-1805)
* Wed Apr 12 2023 lukas.kucharczyk@suse.com
- 15.5.20230412 (tracked in bsc#933411)
- Added note about SCLP CPI additional info (jsc#PED-472)
- Added note about z16 PIA Extension 1 (jsc#PED-472)
- Added note about z16 CPU-MF counters (jsc#PED-472)
- Added note about z16 PIA crypto compliance (jsc#PED-472)
- Added note about NVMe standalone dump support (jsc#PED-472)
- Added note about ESCON removal from installer (jsc#PED-482)
- Added note about PCI devices over network in installer (jsc#PED-454)
- Added note about KDUMP_AUTO_RESIZE (jsc#PED-432)
- Added note about device busid for subchannels (jsc#PED-3182)
- Added note about persisted driverctl definitions (jsc#PED-2317)
- Added note about KVM long kernel command lines (jsc#PED-472)
- Added note about KVM virtual CPU topology (jsc#PED-445)
- Added note about KVM attestation support for secure execution
  (jsc#PED-466)
- Added note about secure exection guest dump encryption (jsc#PED-449)
- Added note about vfio-ap enhancements (jsc#PED-456)
- Added note about PCI enhanced interpretation (jsc#PED-473)
- Added note about ROCE independent usage of physical func
  (jsc#PED-470)
- Added note about zipl site-aware env block (jsc#PED-472)
- Added note about zipl support (jsc#PED-472)
- Added note about transparent PCI device recovery (jsc#PED-457)
- Added note about zdev site-aware device conf (jsc#PED-472)
- Added note about transparent DASD PPRC (jsc#PED-444)
- Added note about libica FIPS 140-3 compliance (jsc#PED-2871)
- Added note about p11-ki IBM-specific stuff (jsc#PED-440)
- Added note about openCryptoki CKA_DERIVE_TEMPLATE (jsc#PED-442)
- Added note about zcryptctl control domain support (jsc#PED-480)
- Added note about PAI CPACF counters (jsc#PED-472)
- Added note about libica Sw fallbacks (jsc#PED-468)
- Added note about libica statistics (jsc#PED-478)
- Added note about openCryptoki key generation (jsc#IBM-1001)
- Added note about openCryptoki crypto profiles (jsc#IBM-1001)
- Added note about openCryptoki vendor-specific key derivation
  (jsc#IBM-1001)
- Added note about z16 openCryptoki EP11 support (jsc#IBM-1001)
- Added note about new crypto hardware support (jsc#PED-472)
- Added note about openCryptoki ep11 (jsc#PED-442)
- Added note about SIMD implementation of chacha20 (jsc#PED-439)
- Added note about zlib CRC32 optimization (jsc#PED-1350)
- Added note about MIO instructions (jsc#PED-2175)
- Added note about Python changes (jsc#PED-3799)
- Added note about Nvidia vGPU (jsc#SLE-18741)
- Fixed release date (bsc#1209068)
* Wed Mar  1 2023 lukas.kucharczyk@suse.com
- 15.5.20230301 (tracked in bsc#933411)
- Added note about rage (jsc#PED-1891)
- Updated virtualization info (jsc#PED-2104)
* Wed Feb  1 2023 lukas.kucharczyk@suse.com
- 15.5.20230201 (tracked in bsc#933411)
- Added note about SSH installation on s390x (bsc#1206585)
- Added note about silencing killmode=none (jsc#PED-407)
* Wed Nov 30 2022 lukas.kucharczyk@suse.com
- 15.5.20221130
- Added note about gnote deprecation (jsc#PED-1839)
- Added note about samba-ad-dc-libs removal (jsc#PED-143)
- Added note about yast2-iscsi-client dependences (bsc#1204978)
* Wed Nov  2 2022 lukas.kucharczyk@suse.com
- 15.5.20221102
- Restore default file compression setting on Btrfs (jsc#PED-63)
- Added note about openmpi2 and openmpi3 deprecation (jsc#PED-904)
* Tue Oct 18 2022 lukas.kucharczyk@suse.com
- 15.5.20221018
- Added note about thunderbolt-user-space removal (jsc#PED-1358)
- Added note about Kerberos/LDAP YaST removal (bsc#1202257)
- Updated Java lifecycle (jsc#PED-1590)
- Updated PHP 8 note to refer to version 8.0.10 (bsc#1201709)
- Updated wording around list of updated packages/modules (bsc#1201370)
* Wed May 11 2022 lukas.kucharczyk@suse.com
- 15.4.20220511 (tracked in bsc#933411)
- Added note about Pipewire (jsc#SLE-18651)
- Added note about schedutil (bsc#1176440)
- Added note about unsupported abbreviated options in suseconnect-ng
  (bsc#1195106)
- Updated link to IBM-Z documentation (bsc#1199136)
- Updated configuring stripe size on RAID 5 (jsc#SLE-20728)
- deprecate NIS (jsc#SLE-243555)
- Added note about manual intervention for hibernation
  (jsc#DOCTEAM-613)
- Added note about POWER logical partition migration with NX
  (jsc#SLE-23831)
- Added note about OpenSSL 3.0 (jsc#SLE-21421)
- Updated POWER-related notes
- Added note about LPM and DLPAR with Secure Boot (bsc#1198415)
- Proofreading improvements (bsc#1198054)
* Wed Mar 23 2022 lukas.kucharczyk@suse.com
- 15.4.20220323 (tracked in bsc#933411)
- Added note about /dev/mapper in fstab for LUKS devices
  (jsc#SLE-20416)
- Added note about GNOME 41 (jsc#SLE-18648)
- Added note about AutoYaST per-product schema (jsc#SLE-18820)
- Added note about Alderlake graphics support (jsc#SLE-22725)
- Added note about new kernel module tools package (jsc#SLE-20693)
- Added note about bzr and breezy (jsc#SLE-21914)
- Added note about MariaDB 10.6 (jsc#SLE-20671)
- Added note about additon of PostgreSQL 14 (jsc#SLE-20673)
- Added note about Ruby BCI (jsc#SLE-22390)
- Added note about Rust BCI (jsc#SLE-22392)
- Added note about BCI minimal image (jsc#SLE-22134)
- Added note about YaST themes (jsc#SLE-20547)
- Added note about YaST and AutoYaST changes (jsc#SLE-20563)
- Added note about YaST assigning subuids/subgids (jsc#SLE-20563)
- Added note about adcli --dont-expire-password (jsc#SLE-21225)
- Added note about zstd module compression (jsc#SLE-21256)
- Added note about cgroups unified hierarchy support (jsc#SLE-20926)
- Added note about zypper single transaction mode (jsc#SLE-21329)
- Added note about NTLM support in Unified Installer (jsc#SLE-17026)
- Added note about SEV live migration (jsc#SLE-22831)
- Added note about POWER10 support (bsc#1192121)
- Added note about Busybox BCI (jsc#SLE-22427)
- Added note about Uacce support (jsc#SLE-17963)
- Added note about chrony NTS support (jsc#SLE-17334)
- Added note about util-linux update, raw removal (jsc#SLE-21111)
- Added note about suseconnect-ng (jsc#SLE-17603)
- Added note about ARMv8.7 EPAN (jsc#SLE-19045)
- Added note about OpenSSL 3 backports (jsc#SLE-19742)
- Added note about NVMe-oF-TCP CDC (jsc#SLE-20184)
- Added note about simpledrm (jsc#SLE-18823)
- Added note about X-fstrim.notrim (jsc#SLE-17942)
- Added note about nodejs12 removal (jsc#SLE-21259)
- Added note about AutoYaST GRUB2 password protection (jsc#SLE-20928)
- Added note about LUKS2 tech preview (jsc#SLE-21308)
- Added note about subversion (jsc#SLE-21037)
- Added note about Certificate Auto Enrollment (jsc#SLE-18457)
- Added note about rust dev tools (jsc#SLE-22290)
- Added note about zram (jsc#SLE-18818)
- Added note about AutoYaST UEFI detection (jsc#SLE-18819)
- Added note about LUKS and TMP2/FIDO2 (jsc#SLE-18822)
- Added note about preempt kernel mode (jsc#SLE-18857)
- Added note about vTPM support (jsc#SLE-22652)
- Added note about Bluetooth codecs (jsc#SLE-17243)
- Added note about Wayland working on Nvidia (jsc#SLE-19965)
- Added note about Python 3.10 (jsc#SLE-18038)
- Added note about fish 3 in Package Hub (jsc#SLE-23450)
- Added note about updating all Python packages (jsc#SLE-21167)
- Added note about apparmor-parser (jsc#SLE-22704)
- Added note about 389ds container (jsc#SLE-18534)
- Added note about User Space Live Patching (jsc#SLE-20049)
- Added note about Qt 5 update (jsc#SLE-18248)
- Added note about RMT container (jsc#SLE-21196)
- Added note about jeos-firstboot welcome screen (jsc#SLE-18305)
- Added note about lpfc INTx mode (bsc#1179916)
- Added note about rpm 4.15 macros (jsc#SLE-20017)
- Added note about GTK 4.0 (jsc#SLE-17858)
- Added note about FIPS mode (jsc#SLE-23133)
- Added note about squid 5.2 (jsc#SLE-22289)
- Added note about NVIDIA vGPU support (jsc#SLE-18741)
- Added note about sudoers.ldap negation (jsc#SLE-21463)
- Added note about zstd-compressed initramfs (jsc#SLE-18768)
- Updated note about Python 2 removal (jsc#SLE-16747)
- Rename JeOS to Minimal-VM and Minimal-Image (jsc#SLE-20354)
- Removed Vagrant information (jsc#SLE-23632)
* Wed Feb 16 2022 lukas.kucharczyk@suse.com
- 15.4.20220216 (tracked in bsc#933411)
- Added note about Python 3 module (jsc#SLE-23605)
- Added note about kernel firmware compression (jsc#SLE-19648)
- Added note about mkinitrd removal (jsc#SLE-20348)
- Added note about TCK complicance testing (jsc#SLE-20308)
- Added note about Samba 4.15 and ad-dc deprecation (jsc#SLE-20577)
- Added note about native graphical installer (jsc#SLE-18632)
- Added note about Podman 3.4.2 (jsc#SLE-18349)
- Added note about deprecating lftp_wrapper (jsc#SLE-17861)
- Added note about PHP 8 (jsc#SLE-18816)
- Added note about AMD SEV-ES (jsc#SLE-18732)
- Added note about deprecating XFS V4 (jsc#SLE-22664)
- Added note about removal of rpm's udev dependency (jsc#SLE-20309)
- Added note about unixODBC drivers in production (jsc#SLE-20556)
- Added note about sigstore, rekor, cosign support (jsc#SLE-23476)
- Added note about RTL8821CE support (jsc#SLE-22690)
- Added note about Xen automatic firmware selection (jsc#SLE-11435)
- Added note about Btrfs sub-page blcok size support (jsc#SLE-17674)
- Updated note about unixODBC drivers in production (jsc#SLE-20556)
- Updated the virtualization section (jsc#SLE-18261)
- Updated LX2160A deprecation to removal (jsc#SLE-17153)
- Updated for 64K page size (jsc#SLE-17674)
* Wed Jan 19 2022 lukas.kucharczyk@suse.com
- 15.4.20220119 (tracked in bsc#933411)
- Added note about BPF tooling update (jsc#SLE-22170)
- Added note about Bluez 5.62 (jsc#SLE-18497)
* Wed Dec  8 2021 lukas.kucharczyk@suse.com
- 15.4.20211208 (tracked in bsc#933411)
- Added note about thunderbolt-user-space (jsc#SLE-19359)
- Added note about Shared Virtual Addressing (jsc#SLE-17310)
- Added note about tmon (jsc#SLE-20403)
- Added note about AMD SEV-ES (jsc#SLE-19923)
- Added note about unprivileged eBPF (jsc#SLE-22593)
- Added note about hibernation in installer (jsc#SLE-12280)
- Updated note about Vagrant boxes (jsc#DOCTEAM-413)
* Wed Nov 17 2021 lukas.kucharczyk@suse.com
- 15.4.20211117 (tracked in bsc#933411)
- Added links to topics in What's new (jsc#DOCTEAM-385)
- Updated responsibilities in README
* Wed Nov  3 2021 lukas.kucharczyk@suse.com
- 15.4.20211103 (tracked in bsc#933411)
- Initial SP4 release
- Added note about opa-fmgui (jsc#SLE-21060)
- Update responsibilities in README
* Wed May  5 2021 lukas.kucharczyk@suse.com
- 15.3.20210505 (tracked in bsc#933411)
- Added note about (Auto)YaST NVRAM update (jsc#SLE-11500)
- Added note about config:type and virt_bridge_proposal in AutoYaST (bsc#1178603)
- Added note about deprecating lftp_wrapper (jsc#SLE-17859)
- Added note about dm-crypt synchronous encryption (jsc#SLE-12226)
- Added note about ERB support in AutoYaST (bsc#1175735)
- Added note about GICv4.1 (jsc#SLE-14763)
- Added note about initrd rebuild after hardware changes (bsc#1184898)
- Added note about mounting multipath devices by-label (bsc#1181658)
- Added note about nftables backend in firewalld (jsc#SLE-16300)
- Added note about Raspberry Pi known limitations
- Added note about removal of Berkeley DB (jsc#SLE-12191)
- Added note about swtpm (jsc#SLE-16993)
- Added note about the addition of ServiceReport (jsc#SLE-13288)
- Added note about 2nd gen AMD EPYC support in QEMU/KVM (jsc#SLE-13573)
- Fixed IBM-Z doc link (bsc#1185109)
- Updated branding (jsc#SLE-14772)
* Thu Apr 22 2021 lukas.kucharczyk@suse.com
- 15.3.20210422 (tracked in bsc#933411)
- Fix broken links
* Wed Apr 21 2021 lukas.kucharczyk@suse.com
- 15.3.20210421
- Added note about kernel parameter changes (jsc#SLE-11213)
- Added note about Leap migration changes (jsc#SLE-17419)
- Added note about haltpoll support (jsc#SLE-15938)
- Added note about VM hibernation support on Azure (jsc#SLE-17093)
- Added note about SELinux support in YaST (jsc#SLE-17307)
- Added note about erlang 22.3 (jsc#SLE-17487)
- Added note about adding WireGuard tools (jsc#SLE-12804)
- Added note about NetworkManager non-support on server (jsc#SLE-17767)
- Added note about moving rpcgen (jsc#DOCTEAM-12)
- Updated note about RoCE performance (bsc#1153309)
* Wed Mar 31 2021 lukas.kucharczyk@suse.com
- 15.3.20210331
- Added note about ACPI not being supported for LX2160A (jsc#NXP-9)
- Added note about ThunderX2 errata removal (jsc#SLE-11529)
- Added note about JeOS KVM image being available for aarch64 (jsc#SLE-13849)
- Added note about RoCE ConnectX-5 performance drops (bsc#1153309)
- Updated note about Xavier firmware for Jetson Xavier NX (jsc#SLE-15847)
- Fixed note about installation/SSH: service is enabled by installer in any case
* Wed Mar 10 2021 lukas.kucharczyk@suse.com
- 15.3.20210310
- Fixed Jetson trademark usage (jsc#SLE-15847)
- Fixed name of a YaST screen, simplify wording (jsc#SLE-16903)
- Hid section and references about Ruby optimization
- Clarified Xavier GPU (jsc#SLE-15847)
- Clarified Xavier note for Jetson (jsc#SLE-15847)
- Announced NVIDIA Xavier enablement (jsc#SLE-15847)
- Announced NXP i.MX 8MM (jsc#SLE-11914)
- Announced NXP LS1012A (jsc#SLE-12251)
- Added note about arm64 64K kernel flavor (jsc#SLE-15406)
  (jsc#SLE-16764)
- Added note about deprecating NXP LX2160A rev. 1.0 (jsc#SLE-17152)
- Added note about NVIDIA DRIVE (jsc#SLE-15847)
- Added note about WE security policies (jsc#SLE-15840)
- Added note about updating tpm2-tss to 2.3.3 (jsc#SLE-17366)
- Added note about updating util-linux to 2.36.2 (jsc#SLE-17286)
- Added note about updating glibc to 2.31 (jsc#SLE-13756)
- Added note about addition of Python 3.9 (jsc#SLE-13738)
- Added note about MariaDB 10.5 (jsc#SLE-16269)
- Added note about known issue on BIOS systems (bsc#1182065)
- Added note about increased PowerVM memory (bsc#1178019)
- Added note about supporting Goya cards (jsc#SLE-17488)
* Wed Feb 17 2021 lukas.kucharczyk@suse.com
- 15.3.20210217
- Added note about insufficient VRAM on some VMware VMs (bsc#1170059)
- Added note about AutoYaST profile changes (bsc#1178261)
- Added note about exception to recommending TLS 1.3 (bsc#1181043)
- Added note about increased RLIMIT_NOFILE (bsc#1177876)
- Added note about compat-libpthread-nonshared (bsc#1178616)
- Added note about per-inode DAX flag (jsc#SLE-17365)
- Added note about deprecating LXC containers (jsc#SLE-17280)
- Added note about rootless containers (jsc#SLE-12431)
- Added note about new CA tool (jsc#SLE-11521)
- Added note about RFC2132-formatted DHCP request via linuxrc
  (jsc#SLE-15488)
- Added note about PostgreSQL 13, 10 and JDBC Driver
  (jsc#SLE-17030,jsc#SLE-15782,jsc#SLE-12561)
* Wed Jan 27 2021 lukas.kucharczyk@suse.com
- 15.3.20210127
- Added note about warning if SSH off but root uses SSH key login
  (jsc#SLE-15487)
- Added note about addition of librabbitmq (jsc#SLE-12262)
- Added note about supporting more than 256 CPUs in VMs (jsc#SLE-16823)
- Added note about pstore block oops/panic logger (jsc#SLE-17217)
- Added note about btrfs-progs exclusive operations lock (jsc#SLE-17264)
- Added back OpenLDAP note from SLES 15 GA (jsc#SLE-16552)
* Wed Jan 13 2021 sknorr@suse.com
- 15.3.20210113
- Added note about Bash at /usr/bin/bash (jsc#SLE-15652)
  (jsc#SLE-11629)
- Added note about ClamAv 0.103 (jsc#SLE-16780)
- Added note about removal of LXC option from yast-vm (jsc#SLE-16682)
- Added note about Snapper free-space cleanup (jsc#SLE-15765)
- Added note about exfatprogs (jsc#SLE-16156)
- Added note about new Python modules (jsc#SLE-16674, jsc#SLE-16243)
- Added note about bcache-tools (jsc#SLE-9186)
- Added note about removal of NodeJS 8, addition of NodeJS 14
  (jsc#SLE-10977)
- Added note about DOCUMENTATION_URL in /etc/os-release (jsc#SLE-16678)
- Added note about Arm optimizations in Ruby (jsc#SLE-16764)
- Added note about SUSE-specific RPM macros in new package
  (jsc#SLE-17074)
- Expand note about creation of kvm/qemu/libvirt users/groups
- Replaced invalid AsciiDoc attribute {slesa} (bsc#1180647)
* Mon Jan 11 2021 sknorr@suse.com
- 15.3.20210111
- Added notes:
  - fwupd Updated (jsc#SLE-16809)
  - Perf Stat Command Updated (jsc#SLE-12724)
  - RPM uses NDB (jsc#SLE-15587)
  - Transactional memory on POWER (jsc#SLE-16056)
  - Vagrant images
  - Group/user ID for KVM/QEMU
- Added references/short notes:
  - `python-anymarkup` added to Package Hub (jsc#SLE-16925)
  - `pgaudit` added to Package Hub (jsc#SLE-12557)
  - PostgreSQL 10 deprecated (jsc#SLE-15782)
  - `pam_ldap`/`nss_ldap` deprecated (jsc#SLE-15651)
  - `rxe_cfg` removed (jsc#SLE-16854)
- Updated notes:
  - NVIDIA Compute SLE module
* Wed Dec  2 2020 sknorr@suse.com
- 15.3.20201202
- Added note for the NVIDIA Compute Module (jsc#ECO-2878)
- Added note on kernel module compression (jsc#SLE-10886)
- Added note on scheduler preemption mode switch (jsc#SLE-16775)
- Added note on removal of locale warning in JeOS first boot
  (jsc#SLE-15348)
- Updated note on Python 2 deprecation (jsc#SLE-16751)
- Updated notes on vm-install, Xen features, Azure VMs
* Wed Nov 11 2020 sknorr@suse.com
- 15.3.20201111
- Initial release for SLES 15 SP3
- Added notes AutoYaST changes
- Added note about virt-manager 3.0.0
- Added note about libvirt 6.9.0
- Added note about Xen 4.14.0
- Added note about QEMU 5.1
- Added KubeVirt as a technology preview (jsc#SLE-15935)
- Added notes about `os-dbinfo` and `open-vm-tools`
- Added notes about spice
- Marked spice-gtk PulseAudio back-end as removed,
  not deprecated
- Added Nutanix Acropolis to supported hypervisors
  (bsc#1176224)
- Reorganized note about deprecation of SysV initscripts
  (bsc#1176398)
- Removed virtualization limits and supported host systems
  (bsc#1164744)
* Tue Jun  9 2020 fs@suse.com
- 15.2.20200609
- aarch64:
  * updated New features section
  * Added more NXP Layerscape variants
  * Document Neoverse N1 SDP issues (jsc#SLE-10258)
  * Announced Arm Neoverse N1 (jsc#SLE-10258)
  * MentionedBCM2710 to explain BCM2711 sort order (jsc#SLE-7276)
  * Announced panfrost GPU driver (jsc#SLE-8203)
  * Announced lima driver as Tech Preview (jsc#SLE-8203)
  * Documented missing FlexCAN driver as known issue (jsc#SLE-9263)
  * Announced LS1028A enablement (jsc#SLE-9263)
  * Considered feature-reduced variants of LS1028A (jsc#SLE-9263)
  * Added missing enabled NXP QorIQ model LS2085A
- Updated the virtualization section
  * Added WSL support
  * Added note on new xen-tools-xendomains-wait-disk package
    (jsc#SLE-10172, bsc#1055731)
  * Added note on dropping SDL support
- Added note on SALT 3000 (jsc#SLE-12433)
* Fri Jun  5 2020 sknorr@suse.com
- 15.2.20200605
- Added information that MariaDB now supports OQGRAPH (jsc#SLE-8269)
- Added note about AppArmor 2.13 (jsc#SLE-10161)
- Added note about AutoYaST Signature Handling (bsc#1171343)
- Added note about backported Apache Key ID patch (jsc#SLE-7472)
- Added note about default lack of TasksMax limit in systemd
  (jsc#SLE-10123)
- Added note about deprecation of rc<service> (jsc#SLE-10912)
- Added note about deprecation of SysV init.d scripts support
  (jsc#SLE-7690)
- Added note about EDAC for AMD Zen 3 CPU (jsc#SLE-11833)
- Added note about IBM Secure Execution
- Added note about LLVM 9 (jsc#SLE-7400)
- Added note about LVM2 update (bsc#1170209)
- Added note about PHP 7.4 (jsc#SLE-12482)
- Added note about RabbitMQ (jsc#SLE-10913)
- Added note about support for Large Increment per Cycle Events for
  AMD's Family 17h and up (jsc#SLE-11831)
- Added note about Wireshark update (jsc#SLE-11632)
- Added OpenJDK 1.8.0 to supported Java versions
- Updated support information: haltpoll is supported for HANA on KVM
  use (jsc#SLE-11312)
- Clarified information about TLS support (jsc#SLE-9294)
- Fixed displayed month of 15 SP2 release
- Reorganized former Base System section
* Mon May 11 2020 sknorr@suse.com
- 15.2.20200511
- Added note about PostgreSQL 12 (jsc#SLE-11079)
- Added note about removal of TLS 1.0 and TLS 1.1 (FATE#323868)
- Added note about Userspace X Drivers being unsupported
  (bsc#1122173)
- Added note about scc_ file names used by supportconfig
  (jsc#SLE-6762)
- Added note about update to jq 1.6 (jsc#SLE-12188)
- Add note about removal of XEN JeOS image (bsc#1166474)
- Made Removed/Deprecated sections more consistent
- Clarified status of squashfs 3.0 support
- Clarified that snapper-zypp-plugin is plug-in for Zypper
- Simplified Java section intro sentence
- Improved grammar and formatting of podman note
* Fri Apr 24 2020 sknorr@suse.com
- 15.2.20200424
- Added note about Ampere Altra (jsc#SLE-9551)
- Added note about AWS Graviton2 (jsc#SLE-10505)
- Added note about etnaviv (jsc#SLE-9263)
- Added note about kiwi-templates-JeOS renaming (ISR#200997)
- Added note about LS1028A graphics output (jsc#SLE-9263)
- Added note about mali-dp (jsc#SLE-9263)
- Added note about Pensando ionic driver (jsc#ECO-1386)
- Added note about SynQuacer SPI (jsc#SLE-8763)
- Added note about U-Boot btrfs (jsc#SLE-10302)
- Added note about NVIDIA Jetson (jsc#SLE-9387, jsc#SLE-9335,
  jsc#SLE-10607)
- Added explanation of limits of AArch64 SoC enablement
- Added explanation of SBBR/EBBR requirements
- Added note about new GeoIP tools (jsc#SLE-11184)
- Added note about ibmveth speed (bsc#1136157)
- Added note about Python 2 removal (FATE#327577)
- Improved and moved note about Boot with encrypted network device
  (jsc#SLE-7687)
- Clarified note about CONFIG_RT_GROUP_SCHED (jsc#SLE-10427)
- Clarified that kernel-preempt is only available for x86-64 and aarch64
  (jsc#SLE-11309)
- Clarified and improved formatting in AArch64 section
- Fixed the product name in mentions of SLES JeOS
- Fixed AArch64 Kiwi template package name
- Fixed btrfs subvolume commands in note about AArch64 system upgrade
  (bsc#1122591)
* Fri Mar 13 2020 sknorr@suse.com
- 15.2.20200313
- Added note about haltpoll (jsc#SLE-11312)
- Added note about podman (jsc#SLE-9112)
- Added listing of supported Arm SoC (jsc#SLE-7276, jsc#SLE-9032,
  jsc#SLE-10505, jsc#SLE-9387, jsc#SLE-9335, jsc#SLE-9263)
- Added note about A64FX CPU frequency scaling
- Added note about Raspberry Pi support (jsc#SLE-7277, jsc#SLE-7276)
- Added note about deprecation of early ThunderX2 (jsc#SLE-11528)
- Added note about kernel 5.3 (jsc#SLE-6763)
- Added note about CONFIG_RT_GROUP_SCHED (jsc#SLE-10427)
- Added note about Kernel package clean-up (jsc#SLE-10162)
- Added note about XFS reflinks (jsc#SLE-10160)
- Added note about squashfs 3.x removal (jsc-SLE-9416)
- Added note about Systemtap update (jsc#SLE-9205)
- Added note about Microcode Loading Interface removal
  (jsc#SLE-7041)
- Clarified KVM membarriers note
- Clarified Arm Btrfs note
- language and formatting improvements for multiple notes
* Thu Feb 20 2020 sknorr@suse.com
- 15.2.20200220
- Added multiple IBM Z-related notes
- Added Optane DC note (jsc#SLE-7143)
- Added note about yast2-firstboot in WSL (jsc#SLE-11239)
- Added note about Changes for Snapper Plug-in for zypper
  (jsc#SLE-10500)
- Added note about removal of xfs_scrub_all (jsc#SLE-10500)
- Added note about Extended Package Search in YaST (jsc#SLE-9109)
- Added KVM-related notes (bsc#1130134, jsc#SLE-11089)
- Added Xen/libvirt-related notes (bsc#1157100)
- Improved display of File Systems & Kernel tables
- Fixed URL used for in-document report-bug links (bsc#1161101)
* Tue Feb  4 2020 sknorr@suse.com
- 15.2.20200204
  - Many updates (fixes bsc#1162230, bsc#1162239, bsc#1162232)
* Fri Jan 10 2020 fs@suse.com
- 15.2.20200110:
  - Added release notes entries for
  * Vagrant boxes
  * Jeos
  * new media layout
  * virtualization
  - adjusted the tech preview section
* Wed Nov 27 2019 fs@suse.com
- 15.2.20191127
  * initial version for SLES 15 SP2
* Mon May 13 2019 fs@suse.com
- 15.1.20190513
- Document fixes and changed notes:
  - In-kernel Crypto: GCM Enhancements (FATE#325686)
  - Support for the CEX6S Crypto Card (FATE#325695)
  - Enhanced SIMD Instructions in libica (FATE#325699)
  - Elliptic Curve Support for Crypto (FATE#325701)
  - I/O Device Pre-Configuration (FATE#326357)
  - Raw Track Access without Prefix CCW (FATE#326358)
  - Handle Provisioned MAC Addresses (FATE#326373)
  - scsi: zfcp: Add Port Speed Capabilities (FATE#326374)
  - NumaTOP Has Been Added (FATE#326395, update requested via
    bsc#1132238)
  - PCI Error Reporting Tool (FATE#326826)
* Thu May  2 2019 sknorr@suse.com
- 15.1.20190502
- Updated template text
- New notes:
  - TLS 1.0 and 1.1 Will Be Disabled Starting with SUSE Linux
    Enterprise 15 SP2 (FATE#323868)
  - Xen Auto-Ballooning Disabled by Default (FATE#323901)
  - PostgreSQL Has Been Upgraded to Version 10 (FATE#325659, requested
    via bsc#1127393, jsc#SLE-4302)
  - Protected Key dm-crypt Key Management Tool (FATE#325684)
  - In-kernel Crypto: GCM Enhancements (FATE#325686)
  - zcrypt DD: Introduce APQN Tags to Support Deterministic Driver
    Binding (FATE#325689)
  - Support Architectural Limit of Crypto Adapters in zcrypt Device
    Driver (FATE#325692)
  - kvm_stat Package from kernel Tree (FATE#325693)
  - Support for the CEX6S Crypto Card (FATE#325695)
  - Shared Memory Communications - Direct (SMC-Direct) (FATE#325698)
  - Enhanced SIMD Instructions in libica (FATE#325699)
  - Support 4K Sectors for Fast Clear Key dm-crypt (FATE#325700)
  - Elliptic Curve Support for Crypto (FATE#325701)
  - Boot and Driver Enablement for Raspberry Pi (FATE#325731)
  - resolv.conf Is Now Located in /run (FATE#325872)
  - Chelsio T3 Driver (cxgbe3) Is Deprecated (FATE#325947)
  - Access to Additional POWER Registers in GDB (FATE#326120)
  - The OProfile Package Has Been Updated (FATE#326121)
  - Network Performance Improvements (FATE#326350)
  - SIMD Implementation of Poly1305 in OpenSSL (FATE#326351)
  - OpenSSL: Crucial Enhancements (FATE#326354)
  - Development-Tools Module: Valgrind IBM z13 Support (FATE#326355)
  - Partial RELRO Support in binutils (FATE#326356)
  - I/O Device Pre-Configuration (FATE#326357)
  - Raw Track Access without Prefix CCW (FATE#326358)
  - Collecting NVMe-related Debug Data (FATE#326361)
  - Configurable IFCC Handling (FATE#326362)
  - In-kernel Crypto: Support Protected Keys Generated by random in
    paes Module (FATE#326366)
  - Expose Detailed Guest Crash Information to the Hypervisor
    (FATE#326368)
  - Guest-Dedicated Crypto Adapters (FATE#326370)
  - Handle Provisioned MAC Addresses (FATE#326373)
  - scsi: zfcp: Add Port Speed Capabilities (FATE#326374)
  - Support of CPACF Hashes in ep11 Token in openCryptoki and libica
    (FATE#326375)
  - Full-blown TCP Segmentation Offload (FATE#326377)
  - Interactive Bootloader (FATE#326378)
  - zPCI Passthrough Support for KVM (FATE#326382)
  - OSA IPv6 Checksum Offload (FATE#326383)
  - libica: Use TRNG to Seed DRBG (crypto) (FATE#326389)
  - dm-crypt with Protected Keys - Change Master Key Tool (FATE#326390)
  - Performance Counters for IBM z14 (CPU-MF) (FATE#326391)
  - SDT Markers added to libglib (FATE#326393)
  - ibmvnic Device Driver (FATE#326521)
  - SIMD Implementation of Chacha20 in OpenSSL (FATE#326561)
  - HiDPI support in GNOME (FATE#326682)
  - PAPI Package Update (FATE#326712)
  - Uprobes: Support for SDT events with reference counter (perf)
    (FATE#326782)
  - OSA-Express7S Adapters Are Now Supported (FATE#326806)
  - Support Multiple zcrypt Device Nodes (FATE#326807)
  - Cryptsetup 2.0.5 for LUKS2 Support (FATE#326824)
  - PCI Error Reporting Tool (FATE#326826)
  - Huge Pages (FATE#326829)
  - Performance Co-pilot (PCP) Updated, Perfevent Performance Metrics
    Domain Agent (PMDA) Support Libraries Added (FATE#326864)
  - LUKS2 Support for pam_mount (FATE#326986)
  - Reduced Memory Usage When Booting FADump Capture Kernel
    (FATE#327173)
  - Python 2 Module: python Executable Is Not Available in Standard
    Distribution (FATE#327577, requested via bsc#1125712)
  - SMB Shares Used via mount or /etc/fstab Are Now Expected to use SMB
    2.1 or Higher (FATE#327579)
  - System-on-Chip Driver Enablement (FATE#327734)
  - JeOS Images for Hyper-V and VMware Are Now Compressed (FATE#327755)
  - Chrony Is Now Installed by Default on JeOS and Raspberry Pi Images
    (FATE#327756)
- Document fixes and changed notes:
  - Support for Socket-Based Services Activation (FATE#319428)
  - Driver Enablement for NXP SC16IS7xx UARTs (FATE#326668)
* Wed Jan 30 2019 sknorr@suse.com
- 15.1.20190130
- Updated template text
- New notes:
  - QED Image Format Is No Longer Supported (FATE#324200)
  - Zypper and the --no-recommends Option (FATE#325513)
  - CD/DVD Repositories Will Be Disabled After Installation
    (FATE#325541)
  - New sysctl Option to Configure NUMA Statistics (FATE#326308)
  - Web and Scripting Module: Support for NodeJS 10.x (FATE#326919)
  - IOMMU Passthrough Is Now Default on All Architectures
    (FATE#326981)
- Document fixes and changed notes:
  - Improve module information
* Fri Dec 14 2018 sknorr@suse.com
- 15.1.20181214
- Updated template text
- New notes:
  - Displaying Disk Space Used by Snapper Snapshots (FATE#323843)
  - Snapper's Space-Aware Snapshot Cleanup Has Been Improved
    (FATE#325774)
  - NumaTOP Has Been Added (FATE#326395)
  - Snapper Output Highlights Mount Status of Snapshots (FATE#326479)
  - Package supportutils-plugin-salt Has Been Moved to the Base System
    Module (FATE#326488)
  - Product Registration Changes for HPC Customers (FATE#326567)
  - Fake NUMA Emulation in the Linux Kernel Can Now Uniformly Split
    Physical Nodes (FATE#326637)
  - Support for NXP SC16IS7xx on Raspberry Pi (FATE#326668)
  - The Driver i40evf Has Been Renamed to iavf (FATE#326705)
- Document fixes and changed notes:
  - Updated Btrfs features table for 15 SP1 and 12 SP4 (bsc#1118664)
  - Fixed Btrfs footnote number (bsc#1106505)
  - Mark Live Migration note as applying to both KVM and Xen
* Tue Sep 18 2018 sknorr@suse.com
- 15.1.20180918 (initial version)
- Updated Makefile
- Updated template text
  - Removed circular links, correct documentation URL (bsc#1101609)
- Updated release notes from FATE
- New notes:
  - Support for Socket-Based Services Activation (FATE#319428)
  - Package insserv-compat Has Been Added to SAP Application Server
    Base Pattern (FATE#325727)
* Fri Jul 13 2018 sknorr@suse.com
- 15.0.20180713 (tracked in bsc#1101177)
- Updated template text
  - Updated product description
  - Update AArch64 kernel limits
- Updated release notes from FATE
- New notes:
  - Device Driver ibmvnic (FATE#323285)
  - NIS Supports IPv6 (FATE#324353)
  - Advanced Systems Management Module Has Been Removed (FATE#324614)
  - Migrating from SLES 12 to SLES 15 when the HPC Module is Registered
    (FATE#325666)
  - Package insserv-compat Has Been Added to SAP Application Server
    Base Pattern (FATE#325727)
  - Raspberry Pi Using Device Tree From Firmware (FATE#325780)
  - The User Space X Drivers cirrus/mga/ast Have Been Removed
    (FATE#325795, bsc#1089319)
  - Using Thunderbolt Devices (FATE#325796, bsc#1090199)
  - Updated Btrfs Subvolume Layout (FATE#325797, bsc#1085628)
  - su Does Not Preserve the Value of PATH (FATE#325802, bsc#353876)
- Changed notes:
  - NFS Tuning (FATE#322786, bsc#1097236)
    [Correct parameter that needs to be used]
  - Intel* Omni-Path Architecture (OPA) Host Software (FATE#323041,
    bsc#1080368)
    [Correct URL]
  - xinetd and yast2-inetd Have Been Removed (FATE#323373, bsc#1089586)
    [Add note about only_from]
  - Removed packages (FATE#323783)
    [Added cirrus/mga/ast driver information]
  - Searching Packages Across All SLE Modules (FATE#325452,
    bsc#1098864)
    [Wording fixes]
* Tue Jun  5 2018 sknorr@suse.com
- 15.0.20180605 (tracked in bsc#1054478)
- Added provides to fix Release Notes display in installer
- Updated template text
  - Removed Windows version from Samba AD support statement
  - Updated Xen Limits (FATE#324056)
  - Updated KVM Limits (FATE#324057)
  - Fixed deprecations time frame (bsc#1087249)
- Updated release notes from FATE
- New entries:
  - virt-bootstrap: Creating libvirt LXC root file systems (FATE#321985)
  - ReiserFS Support Removed (FATE#323394)
  - Page Cache Limit Is Now Opt-in cgroup Isolation (FATE#323778)
  - Registration Rollback When Migrating From SLE 11 to SLE 15
    (FATE#323798)
  - SunRPC Is Deprecated (FATE#324412)
  - System Roles for SUSE Linux Enterprise Server (FATE#325572)
  - GPU Virtualization under KVM (virtio-gpu) (FATE#325725)
  - dmraid Is Deprecated (FATE#325736)
  - Plymouth/GDM May Hang If No Display Is Connected (FATE#325753)
- Changed entries:
  - YaST Partitioner: Redesigned Back-end and UI Changes (FATE#318196)
  - Manually Selecting Repositories When Upgrading from SLES 12 to SLES
    15 (FATE#323163)
  - Legacy Module: OpenLDAP Client Libraries Have Been Moved to the
    Legacy Module (FATE#323453)
  - Wicked: Using RFC 4361 DHCPv4 client-id on Ethernet (FATE#323576)
  - Removed Packages (FATE#323783)
  - New SAP Applications Module (FATE#323792)
  - Major changes in SLE 15 (FATE#324493, bsc#1094083)
  - SMT Has Been Replaced by RMT (FATE#325115)
* Fri May 18 2018 sknorr@suse.com
- 15.0.20180518 (15.0 GMC)
- Updated template text
  - Workstation extension is partly L2-supported (bsc#1093506)
  - Added JeOS to related products (FATE#325677)
- Updated release notes from FATE
- New entries:
  - KVM Nested Virtualization (FATE#320082)
  - lshw Has Been Added (FATE#322439)
  - Supported JeOS Image Formats (FATE#323220)
  - Supported Host Operating Systems and Hypervisors (FATE#324054)
  - Supported Offline Migration Scenarios (FATE#324058)
  - Major changes in SLE 15 (FATE#324493)
  - SMT Has Been Replaced by RMT (FATE#325115)
  - Searching Packages Across All SLE Modules (FATE#325452)
  - sapconf SAP Tuning Tool Sets All Specified Tuning Values on OS
    Irrespective of Current Value (FATE#325548)
  - CUPS No Longer Supports System V-Style Interface Scripts
    (FATE#325672)
  - Graphics Chipset Compatibility under Wayland (FATE#325703)
    [bsc#1093306]
- Changed entries:
  - YaST Partitioner: Redesigned Back-end and UI Changes (FATE#318196)
  - firewalld Replaces SuSEfirewall2 as Default Software Firewall
    (FATE#320794)
  - Support for dm-crypt with Protected Keys (FATE#321524)
  - Manually Selecting Repositories When Upgrading from SLES 12 to SLES
    15 (FATE#323163)
  - ntpd Has Been Replaced With Chrony (FATE#323432)
  - SuSEFirewall2 Has Been Replaced by firewalld (FATE#323460)
  - Removed Packages (FATE#323783)
  - New SAP Applications Module (FATE#323792)
  - Supported Live Migration Scenarios (FATE#324059)
- Removed entries:
  - ReiserFS Support Removed (FATE#323394)
* Fri Apr 27 2018 sknorr@suse.com
- 15.0.20180427
- Template updates:
  - SLE 15 ships with OpenJDK 10 (FATE#325522)
  - Updated CPU count on AArch64
- Updated release notes from FATE
- New entries:
  - firewalld Replaces SuSEfirewall2 as Default Software Firewall
    (FATE#320794)
  - All SLE 15 Packages Are Enabled for Address Space Layout
    Randomization (FATE#322473)
  - 389 Directory Server Is Now the Primary LDAP Server
    (FATE#323362)
  - Legacy Module: OpenLDAP Client Libraries Has Been Moved to
    the Legacy Module (FATE#323453)
  - New AppArmor Features to Restrict Processes (FATE#323500)
  - atftp Has Been Removed (FATE#323633)
  - Store Hypervisor Information (STHYI) for LPAR (FATE#324112)
  - SIMD Extensions for IBM z14 (FATE#324113)
  - OpenJDK 10 Has Been Added (FATE#325522)
  - Support for 32-bit Runtimes on Intel 64/AMD64 (x86-64)
    (FATE#325552)
  - Remote Installation via VNC (FATE#325565)
- Changed entries:
  - System-wide Locale/Keymap/Font Settings are not read from
    /etc/sysconfig/ anymore (FATE#319454)
  - Support for True Random Number Generator (TRNG) (FATE#321516)
  - AES_GCM Encryption Enhancements in openssl, ibmca and libica
    (FATE#321518)
  - Support for DASD Block Layer Discard (FATE#322263)
  - Persistent Device Configuration (FATE#322567)
  - Support for IBM z14 Instructions in LLVM (FATE#322616)
  - Support for SET VNIC_CHARS in qeth (FATE#323301)
  - SuSEFirewall2 Has Been Replaced by firewalld (FATE#323460)
  - Removed Packages (FATE#323783)
  - OpenSSH Supports Using Hardware Security Modules (HSMs) for
    Connecting via OpenSSL (FATE#323902)
  - CPU Model for IBM z14 (FATE#324111)
  - Provide Guest ASCE on Host Page Table Invalidates (FATE#324119)
  - Add CPU_MF Hardware Counters for IBM z13/z13s (FATE#324254)
  - Full LOADPARM/BOOTPROG Support (FATE#324479)
  - CPUMF Basic Sample Configuration Level Indication (FATE#324484)
  - Network Boot Base Enablement (FATE#324485)
* Mon Apr  9 2018 sknorr@suse.com
- 15.0.20180409
- Updated template text
  - Added Java support table (FATE#325499)
- Updated release notes from FATE
- New entries:
  - Support for UEFI HTTPS Boot (FATE#320130)
  - SIMD Extensions for IBM z14 (FATE#321495)
  - Kernel Interface for the Guarded Storage Facility Added to Improve
    Java Performance (FATE#321511)
  - Guest Kernel Support to Avoid Unnecessary TLB Purges (FATE#321512)
  - Support for IBM z14 Instructions in the Toolchain (FATE#321513)
  - Support for SHA3 Algorithm Hardware Acceleration in libica
    (FATE#321515)
  - Support for True Random Number Generator (TRNG) (FATE#321516)
  - Support for dm-crypt with Protected Keys (FATE#321524)
  - Support for Transforming Secure Keys Into Protected Keys
    (FATE#321525)
  - BPF Compiler Collection (BCC) Has Been Added (FATE#322227)
  - Support for DASD Block Layer Discard (FATE#322263)
  - IBM z13 Lock Optimizations in glibc (FATE#322265)
  - Concurrent Support of Multiple Crypto Domains (FATE#322267)
  - Improved CRC-32 Algorithm in the Kernel (FATE#322269)
  - CPU Speed Information Provided on procfs Interface
    (FATE#322270)
  - Persistent Device Configuration (FATE#322567)
  - Support for Uprobes (FATE#322573)
  - Parted Has Been Upgraded to Use fdasd/vtoc Code Base from
    s390-tools (FATE#322575)
  - Support for libseccomp in systemd (FATE#322579)
  - Backend Support for eBPF (FATE#322613)
  - Support for IBM z14 Instructions in LLVM (FATE#322616)
  - Exploitation of Shared Memory Communications (FATE#322619)
  - lsmem and chmem Have Been Moved to util-linux (FATE#322621)
  - Single Increment Assignment of Memory (FATE#323299)
  - Support for SET VNIC_CHARS in qeth (FATE#323301)
  - Migrating Systems with BIOS RAID from SLES 11 to SLES 15
    (FATE#323395)
  - Kernel Address Space Randomization (KASLR) Enabled by Default
    (FATE#323473)
  - Report Distro KVM Using Call Home (FATE#323770)
  - nginx Has Been Added (FATE#323994)
  - Transparent Facility Bit Handling (FATE#324110)
  - CPU Model for IBM z14 (FATE#324111)
  - libica Supports FIPS 140-2 Mode (FATE#324115)
  - Provide Guest ASCE on Host Page Table Invalidates (FATE#324119)
  - Zone Awareness for lsmem / chmem (FATE#324252)
  - Add CPU_MF Hardware Counters for IBM z13/z13s (FATE#324254)
  - Support for TLB Purge Enhancements (FATE#324255)
  - Robust Machine Check Handling (FATE#324256)
  - Store Hypervisor Information (STHYI) for LPAR (FATE#324258)
  - Support for Guarded Storage Facility (FATE#324472)
  - Keyless Guest Support (FATE#324473)
  - Full LOADPARM/BOOTPROG Support (FATE#324479)
  - CPUMF Basic Sample Configuration Level Indication (FATE#324484)
  - Network Boot Base Enablement (FATE#324485)
  - SDT Markers in Select Applications and Libraries (FATE#324969)
  - 31-Bit Libraries Have Been Removed (FATE#325470)
- Changed entries:
  - AES_GCM Encryption Enhancements in openssl, ibmca and libica
    (FATE#321518)
  - Manually Selecting Repositories When Upgrading from SLES 12 to
    SLES 15 (FATE#323163)
  - UnRAR Has Been Replaced by unar (FATE#323896)
  - wodim Has Been Replaced by cdrtools (FATE#324159)
  - Parted Supports Linux-Specific GPT GUID for Partitions
    (FATE#325468)
* Mon Mar 19 2018 sknorr@suse.com
- 15.0.20180319
- Updated template text
  - Updated URL for upgrade documentation (bsc#1084476)
- Updated release notes from FATE
- New entries:
  - Intel* Omni-Path Architecture (OPA) Host Software (FATE#323041,
    bsc#1080368)
  - Open MPI Has Been Replaced by Open MPI 2 (FATE#323413)
  - OpenSSH Supports Using Hardware Security Modules (HSMs) for
    Connecting via OpenSSL (FATE#323902)
  - wodim Has Been Replaced by cdrtools (FATE#324159)
  - Parted Supports Linux-Specific GPT GUID for Partitions (FATE#325468)
- Changed entries:
  - Support for AMD Memory Encryption (FATE#322123)
  - ntpd Has Been Replaced With Chrony (FATE#323432)
  - Removed Packages (FATE#323783)
* Mon Mar 12 2018 sknorr@suse.com
- 15.0.20180312
- Updated template text
  - Updated extension, product, module listings
  - Added instructions for enabling unsupported features (bsc#1073261)
  - Added "Journal checksumming" row to file system table (bsc#1073261)
  - Fixed link to Upgrade documentation (bsc#1084476)
- Updated release notes from FATE
- New entries:
  - AMD Memory Encryption (FATE#322123)
  - Support for AMD Secure Encrypted Virtualization (FATE#322124)
  - Development Module: Valgrind Support for POWER9 (FATE#322256)
  - Development Module: OProfile Support for POWER9 (FATE#322257)
  - GLIBC/GCC Support of Standard Math Functions for _Float128 (POWER9)
    (FATE#322258)
  - Optimized GLIBC for POWER9 (FATE#322453)
  - GLIBC Support for POWER9 (FATE#322454)
  - DPDK Has Been Updated, libdpdk Package Has Been Added (FATE#322608)
  - Support for Nested Virtualization Performance Features in Newer AMD
    Processors (FATE#323405)
  - Legacy Module: ntpd is now part of the Legacy Module (FATE#323411,
    bsc#1084470)
  - Wicked: Use rfc4361 dhcp4 client-id on Ethernet (FATE#323576)
  - KVM/libvirt: Support for Setting OEM Strings Table in SMBIOS
    (FATE#323624)
  - YaPI Is Deprecated and Should Not Be Used Anymore (FATE#323734)
  - UnRAR Has Been Replaced by unar (FATE#323896)
  - Supported Live Migration Scenarios (FATE#324059)
  - PostgreSQL: psqlODBC Driver Has Been Added to Replace unixODBC
    (FATE#324501)
  - Device Error Prevention Enabled (CONFIG_IO_STRICT_DEVMEM)
    (FATE#325368)
- Changed entries:
  - YaST Partitioner: Redesigned Back-end and UI Changes (FATE#318196)
  - IPVS Has Been Moved From the HA Extension to the Base OS
    (FATE#321936, bsc#1084464) -- fixed duplication
  - Manually Selecting Repositories When Upgrading from SLES 12 to SLES
    15 (FATE#323163)
  - ntpd Has Been Replaced With Chrony (FATE#323432)
  - Removed packages (FATE#323783)
  - Legacy Module: OpenSSL 0.9.8 Has Been Removed (FATE#323914)
  - Legacy Module: OpenSSL 1.0.x Has Been Moved to the Legacy Module
    (FATE#323920)
* Mon Feb 26 2018 sknorr@suse.com
- 15.0.20180226
- Updated template text
  - Removed leftover SDK reference
- Updated release notes from FATE
- New entries:
  - YaST Partitioner: Clean-up of System Views in UI (FATE#318196)
  - Refactored YaST iSCSI LIO server (FATE#319238)
  - XFS Realtime Volumes Feature Has Been Disabled (FATE#321934)
  - IPVS Has Been Moved From the HA Extension to the Base OS
    (FATE#321936)
  - Support for POWER9 Has Been Added to LibPFM (FATE#322254)
  - Support for POWER9 Has Been Added to PAPI (FATE#322255)
  - Support for POWER9 PMU Events Has Been Added to the perf Tool
    (FATE#322450)
  - Support for POWER9 Has Been Added to GDB (FATE#322451)
  - The libpsm_infinipath1 Implementation from the Package
    libpsm_infinipath1 Will Be Picked By Default (FATE#323044)
  - Manually Selecting Repositories When Upgrading from SLES 12 to SLES
    15 (FATE#323163)
  - Support for POWER9 24x7 Counters Has Been Added (FATE#323438)
  - SuSEFirewall2 Has Been Replaced by firewalld (FATE#323460)
  - AutoYaST Configuration Is Done After Reboot (FATE#323698)
  - OpenSSL 1.0.x Has Been Moved to the Legacy Module (FATE#323920)
  - LIO target utilities and libraries Have Been Updated (FATE#323928)
  - Ceph Client Packages Have Been Updated to Upstream Release "Mimic"
    (13.0) (FATE#324270)
  - net-tools Has Been Split into net-tools and net-tools-deprecated
    (FATE#324397)
  - Reflink Feature of XFS Is Not Supported (FATE#324503)
  - libibcm Has Been Removed (FATE#324648)
  - systemctl stop apparmor Does Not Work (FATE#325343)
  - x11vnc Has Been Removed (FATE#325344)
  - Support for Scalable Machine Check Architecture (Scalable MCA)
    (FATE#322484)
  - xinetd and yast2-inetd Have Been Removed (FATE#323373)
- Changed entries:
  - ntpd Has Been Replaced With Chrony (FATE#323432)
  - MariaDB Has Been Upgraded to 10.2 (FATE#323738)
  - Removed packages (FATE#323783)
  - Packaging Changes (FATE#325054)
* Mon Feb 12 2018 sknorr@suse.com
- 15.0.20180212
- Updated template text
- Updated release notes from FATE
- Packaging changes:
  - Removed recode depency
  - Removed unnecessary *.desktop file
- New entries:
  - Alignment of Partition Size in the Storage Proposal and Expert
    Partitioner (FATE#317129)
  - QEMU Guest Agent Is Now Supported on Xen (FATE#324963)
  - OpenSSH Has Been Updated to Version 7.6p1 (FATE#324974)
  - List of removed packages (FATE#323783)
  - List of packages with major changes (FATE#325054)
- Changed entries:
  - lvmlockd Has Been Added As an Alternative to clvm (FATE#323203)
* Mon Jan 15 2018 sknorr@suse.com
- 15.0.20180115
- Updated release notes from FATE
- New entries:
  - System-wide Locale/Keymap/Font Settings are not read from
    /etc/sysconfig/ anymore (FATE#319454)
  - DASD Channel-Path Aware Error Recovery (FATE#321518)
  - IPVS Has Been Moved From the HA Extension to the Base OS
    (FATE#321936)
  - TPM 2.0 Software Stack Has Been Updated (FATE#322605)
  - lvmlockd Has Been Added As an Alternative to clvm (FATE#323203)
  - MariaDB: Support for TokuDB Storage Engine (FATE#323280)
  - Support for POWER9 Radix Page Tables When Running as KVM Guest
    (FATE#323286)
  - Open vSwitch Has Been Updated to Version 2.8 (FATE#323334)
  - ntpd Has Been Replaced With Chrony (FATE#323432)
  - MariaDB Has Been Upgraded to 10.2 (FATE#323738)
  - New SAP Applications Module (FATE#323792)
  - Handling of Extension Repositories in AutoYaST (FATE#324535)
    [bsc#1070070]
  - Squid Has Been Updated to Version 4 (FATE#324583)
- Changed entries:
  - MariaDB: Dates After 2038 (FATE#323910)
  - MariaDB: Default Encoding and Collation Changed to utf8mb4
    (FATE#324329)
* Mon Dec  4 2017 sknorr@suse.com
- 15.0.20171204
- Updated Makefile
- Updated template text
- Updated release notes from FATE
- New entries:
  - Support for Floppy Disks Has Been Removed from YaST (FATE#319096)
  - cryptconfig Has Been Removed (FATE#323541)
  - MariaDB: Dates After 2038 (FATE#323910)
  - qemu-kvm Wrapper Not Installed by Default (FATE#324323,
    bsc#1065952)
  - MariaDB Default Encoding and Collation Changed to utf8mb4
    (FATE#324329)
  - /etc/SuSE-release Has Been Removed (FATE#324409)
  - Cavium ThunderX2 CRB Firmware Requirements (FATE#324437)
  - Better AutoYaST Device Resize Handling (FATE#324446)
* Mon Nov 20 2017 sknorr@suse.com
- 15.0.20171120
- Updated Makefile, use namespaced stylesheets (temporarily)
- Updated template text
  - Removed Scripting Languages Module from module table
  - Correct and extend file systems comparison table (bsc#1064279)
  - Support for sparse files on OCFS2; note on thread limit
    (bsc#1050940)
- Updated release notes from FATE
- New entries:
  - OpenSSL 0.9.8 Has Been Removed (FATE#323914)
  - Zypper Return Code for Non-Fatal Failures (FATE#324190)
* Fri Oct 20 2017 sknorr@suse.com
- 15.0.20171020
- Updated template text
  - Updated Btrfs feature table
  - Updated table of SLE modules
  - Removed references to outdated file systems & hardware
  - Removed ReiserFS column from File System table (FATE#323394)
- Updated release notes from FATE
- New entries:
  - No dasd_reload During Installation (FATE#318138)
  - Wireshark Qt UI Replaces Deprecated GTK+ UI (FATE#323341)
  - No Default Compose Key Combination (FATE#324214)
- Changed entries:
  - NFS Tuning (FATE#322786)
* Fri Oct  6 2017 sknorr@suse.com
- 15.0.20171006
- Updated template text
  - Documentation URLs now point to beta.suse.com
  - Bug report links now allow reporting bugs for beta product
- Updated release notes from FATE
- New entries:
  - NFS Tuning (FATE#322786)
  - ReiserFS Support Removed (FATE#323394)
  - Intel Resource Director Technology Interface Update and Skylake
    Errata (FATE#323965)
* Mon Aug 21 2017 sknorr@suse.com
- Updated template text
- Use profiling and update entities
- Comment most of What's New? for the moment
* Thu Aug  3 2017 sseebergelverfeldt@suse.com
- 15.0.20170803 (tracked in bsc#1052062)
- Updated Makefile
- Updated template text
  - Updated Btrfs feature table (bsc#1048014)
- Updated release notes from FATE
- New entries:
  - GnuPG Uses SHA-2 Family of Digests by Default (FATE#323084)
- Changed entries:
  - Support for the IDNA2008 Standard for Internationalized Domain
    Names (FATE#321897)
- Removed entries:
  - Snapper: Cleanup Rules Based on Fill Level (FATE#312751)
  - MariaDB Replaces MySQL (FATE#313595)
  - /tmp Cleanup from sysconfig Automatically Migrated into systemd
    Configuration (FATE#314974)
  - TPM-Capable UEFI Bootloader (FATE#315831)
  - Use /etc/os-release Instead of /etc/SuSE-release (FATE#316268)
  - KVM Nested Virtualization (FATE#316354)
  - systemd Daemon (FATE#316631)
  - Software Requiring Specific Contracts (FATE#316990)
  - SELinux Enablement (FATE#317116)
  - Support for Arbitrary Btrfs Subvolume Structure in AutoYaST
    (FATE#317775)
  - Installing with LVM2, Without a Separate /boot Partition
    (FATE#317838)
  - LUN Scanning Enabled by Default (FATE#317881)
  - GPFS Partition Type in fdasd (FATE#318032)
  - YaST: iSCSI Authentication Has Been Redesigned (FATE#318832)
  - ntp 4.2.8 (FATE#319040)
  - Upgrading PostgreSQL Installations from 9.1 to 9.4 (FATE#319049)
  - Updating Registration Status After Rollback (FATE#319118)
  - SMT Supports SCC Exclusively (FATE#319132)
  - SMT: Upgrading Database Schema and Engine (FATE#319135)
  - Support for Intel OPA Fabrics Moved to mvapich2-psm2 Package
    (FATE#319240)
  - Support for AVIC (Advanced Virtual Interrupt Controller)
    (FATE#319478)
  - Zypper Option --plus-content Has Been Enhanced (FATE#319486)
  - Memory Reservation Support for fadump in YaST (FATE#319551)
  - Hardware Breakpoint Support in GDB (FATE#319573)
  - snIPL: Hardening (FATE#319579)
  - Salt Configuration with AutoYaST (FATE#319830)
  - Support for Setting Kdump Low-Memory and High-Memory Allocation on
    the YaST Command Line (FATE#320016)
  - ntp 4.2.8 (FATE#320392)
  - Warning When Enabling Snapshots on Small Root File Systems
    (FATE#320416)
  - Online Migration: Checking the Status of Registered Products
    (FATE#320534)
  - Toolchain Module Enabled in Default Installation (FATE#320679)
  - No Support for Samba as Active Directory-Style Domain Controller
    (FATE#320709)
  - Docker Compose Has Been Removed from the Containers Module
    (FATE#320740)
  - /var/cache on an Own Subvolume for Snapshots and Rollback
    (FATE#320834)
  - libgcrypt11 Available from the Legacy Module (FATE#320852)
  - Root File System Conversion to Btrfs Not Supported (FATE#320870)
  - All Snapper Commands Support the Option --no-dbus (FATE#321049)
  - Ceph Client Support on z Systems and POWER (FATE#321098)
  - Ceph Client Support on z Systems and POWER (FATE#321098)
  - GNOME: Support for Chinese, Japanese, Korean Installed and
    Configured Automatically (FATE#321126)
  - NVDIMM: Support for Device DAX (Direct Access) (FATE#321135)
  - Network Interfaces Configured via linuxrc Take Precendence
    (FATE#321358)
  - Support for Intel Xeon Phi Knights Landing Coprocessors
    (FATE#321398)
  - hpwdt Driver (HPE Watchdog) Has Been Updated (FATE#321401)
  - Support for Intel Kaby Lake Processors (FATE#321402)
  - Support for Both TPM 1.2 and 2.0 (FATE#321435)
  - Online Migration with Live Patching Enabled (FATE#321493)
  - New dasdfmt Quick Format Mode (FATE#321527)
  - DASD Channel Path-Aware Error Recovery (FATE#321528)
  - qeth Device Driver Has Accelerated set_rx_mode Implementation
    (FATE#321529)
  - Toleration Support for New Cryptography Hardware (FATE#321530)
  - parted Augmented with Partitioning Functionality as Provided by z
    Systems Tools (FATE#321531)
  - Stable PCI Identifiers Using UIDs (FATE#321534)
  - Open vSwitch Has Been Updated to Version 2.7.0 (FATE#321541)
  - Inclusion of IBM TPM 2.0 Stack (FATE#321601)
  - Extended CPU Topology to Support Drawers (FATE#321650)
  - Support for 2 GB Memory Pages (FATE#321651)
  - YaST: Default Auto-Refresh Status for Local Repositories Is "Off"
    (FATE#321767)
  - Automatic Cleanup of Snapshots Created by Rollbacks (FATE#321773)
  - Support for KVM Guests Using NVDIMM Devices (FATE#321778)
  - Parameter crashkernel Is Now Used for fadump Memory Reservation
    (FATE#321841)
  - Support for OpenDataPlane on Cavium ThunderX and Octeon TX
    Platforms (FATE#321977)
  - Update Repositories for kGraft Live Patching Are Now Specific to
    Service Packs (FATE#322004)
  - libica with DRBG Random Number Generation (FATE#322025)
  - Sudo Has Been Updated from 1.8.10p3 to 1.8.19p2 (FATE#322095)
  - Support for Scalable MCA (SMCA) (FATE#322164)
  - Installing Systems from Online Repositories (FATE#322275)
  - Exploitation of Shared Memory Communications (FATE#322375)
  - s390-tools: util Improvements and dbginfo Speedup (FATE#322377)
  - GnuTLS Has Been Updated to Version 3.3 (FATE#322523)
  - Support for Matrox G200eH3 Graphics Chips (FATE#322780)
  - libcgroup1 Deprecated Starting with SLE 12 SP4 (FATE#323093)
  - The YaST Module for SSH Server Configuration Has Been Removed
    (FATE#323175)
  - "Register Extensions or Modules Again" Has Been Removed from YaST
    (FATE#323343)
  - New System-on-Chip Driver Enablement (FATE#323366)
  - System Clone AutoYaST XML Reflects Btrfs Snapshot State
    (FATE#323556)
  - AppliedMicro X-C1 Server Development Platform (Mustang) Firmware
    Requirements (FATE#323585)
  - QEMU-virtualized PReP Partition (FATE#323651)
* Tue Nov 15 2016 sknorr@suse.com
- Replace @VERSION@ with version number (bsc#1009221)
* Thu Nov 10 2016 sknorr@suse.com
- 12.3.20161110
- Updated template text
- Updated release notes from FATE
- Initial entries:
  - FATE#321767: YaST: Auto-Refresh Status for Local Repositories
  - FATE#321493: Online Migration with Live Patching Enabled
* Fri Nov  4 2016 sknorr@suse.com
- 12.2.20161104 (tracked in bsc#1007209)
- Updated template text
  - Fixed wrong Service Pack number in Support section (bsc#1007705)
  - Updated amount of supported RAM for z Systems (bsc#1007153)
  - Updated Xen limits
  - Miscellaneous language and structure fixes
- Updated release notes from FATE
- New entries:
  - FATE#319898: GICv2 and GICv3 Interrupt Controller Support in QEMU
  - FATE#319945: GCC SIMD Performance Tuning
  - FATE#319948: Improved Auto LUN Scan
  - FATE#321179: GNOME Desktop: Clicking "Open in Terminal" on Desktop
  - FATE#321984: iSCSI with CHAP Is Not Supported in FIPS Mode
    [bsc#985603]
  - FATE#322002: Btrfs File System Going Read-only om Balance
    [bsc#1006804]
- Changed entries:
  - FATE#317891: Virtualization: Supported Disks Formats and Protocols
    [QCOW format not supported anymore]
  - FATE#318726: Device Driver ibmvnic Has Been Added
    [Feature is a technology preview]
  - FATE#319531: Support for UEFI in QEMU Virtual Machines
    [Feature is supported]
  - FATE#319660: Guest 3D Acceleration With virtio-gpu
    [Clarification]
  - FATE#319716: Updating the Installer at the Beginning of Install
    [Feature is off by default]
  - FATE#319792: NVDIMM Support
    [Clarified support status]
  - FATE#320440: The libcxl Userspace Library for CAPI Has Been Added
    [Move to Power category]
  - FATE#320494: Media-based Sources Are Disabled After Installation
    [Clarification]
  - FATE#315712: Xen: PV-OPS Kernel Supersedes kernel-xen,
    FATE#317970: Create AutoYaST Profile During Installation,
    FATE#318001: Support for CXL Flash Storage Device Driver,
    FATE#319624: Configurable Importing of SSH Keys,
    FATE#319858: NVDIMM Kernel Subsystem,
    FATE#319893: YaST Clears New Partitions,
    FATE#320111: Partitioning Proposal: "Flexible Partitioning",
    FATE#320305: Incompatible Changes in the New 4.4 Kernel,
    FATE#320358: Support for PIDs cgroup Controller,
    FATE#320635: Transparent Huge Page Defragmentation Disabled,
    FATE#321021: Change of OpenMPI Behavor for Plugin Developers
    [Language fixes]
* Wed Oct 19 2016 sknorr@suse.com
- 12.2.20161019
- Updated release notes from FATE
- New entries:
  - FATE#321493: Online Migration with Live Patching Enabled
    [Documentation for bsc#985647]
- Changed entries:
  - FATE#321497: KVM on AArch64
    [Updated wording]
* Tue Oct 18 2016 sknorr@suse.com
- 12.2.20161018
- Updated release notes from FATE
- Changed entries:
  - FATE#319482: Boot Requirements for AppliedMicro X-Gene 1
    [Slightly updated wording]
  - FATE#319792: NVDIMM Support
    [Slightly updated wording]
  - FATE#321136: Docker Orchestration
    [Slightly updated wording]
  - FATE#321497: KVM on AArch64
    [Updated wording]
* Tue Oct 11 2016 ke@suse.de
- 12.2.20161011
- Updated release notes from FATE
- New entry:
  - FATE#321136: Docker Orchestration (TechPrev)
* Fri Oct  7 2016 sknorr@suse.com
- 12.2.20161007 (for SLE 12 SP2 GMC)
- Updated template text
- Updated release notes from FATE
- New entries:
  - FATE#318444: ARM AArch64 System-on-Chip Platform Driver Enablement
  - FATE#320535: Virtual Machine Driver Pack 2.4 (VMDP 2.4)
  - FATE#321497: KVM on AArch64
- Changed entries:
  - FATE#319585: CPACF MSA 4: Support for PKCS #11 v2.4 (part 1)
- Removed entries:
  - FATE#319577: OpenSSL Now Supports PKCS#11 Engine
    [Not ready for customer usage and not a technical preview]
* Fri Sep 16 2016 sknorr@suse.com
- 12.2.20160916
- Updated template text
  - Fixed section structure of InfraPackArch (bsc#997470)
- Updated release notes from FATE
- New entries:
  - FATE#316136: Nagios Server Now Part of a SUSE Manager Subscription
  - FATE#319143: Partial Memory Mirroring
  - FATE#319461: openldap2-ppolicy-check-password Has Been Added:
    OpenLDAP Password Strength Policy Enforcer
  - FATE#319716: Updating the Installer at the Beginning of the
    Installation or Upgrade
  - FATE#320122: Support for New Intel Processors
  - FATE#320407: Enrolling in a Microsoft Active Directory Domain via
    YaST
  - FATE#321157: SASL Integration in sudo
  - FATE#321358: Network Interfaces Configured via linuxrc Take
    Precendence
  - FATE#321367: Enable Boot Parameter quiet for Better Visibility of
    Password Prompts
- Changed entries:
  - FATE#320305: Incompatible Changes in the New 4.4 Kernel
    [Added information about end_phys_index file.]
- Removed entries:
  - FATE#320535: Virtual Machine Driver Pack 2.4
    [Was in fact not yet ready.]
* Mon Aug 29 2016 sknorr@suse.com
- 12.2.20160829 (for 12 SP2 RC2)
- Updated release notes from FATE
- New entries:
  - FATE#321181: iSCSI Devices Not Enabled After Installation
    (bnc#993382)
* Fri Aug 26 2016 sknorr@suse.com
- 12.2.20160826 (for 12 SP2 RC2)
- Updated template text
  - Reorganize modules/extensions/derived products
    (FATE#320579, bsc#995577)
  - Update KVM and Xen limits (FATE#320428, FATE#320579)
  - Add Btrfs feature table (bsc#979501)
- Updated release notes from FATE
- New entries:
  - FATE#316274: Converting Physical Machines to KVM Virtual
    Machines
  - FATE#318726: Device Driver ibmvnic Has Been Added
  - FATE#319267: systemd: The NFS Mount Option bg Is Deprecated
  - FATE#320018: Devilspie 2 Has Been Added
  - FATE#320123: Executing Hypervisor-Specific Actions During Boot
  - FATE#320305: Incompatible Changes in the New 4.4 Kernel
  - FATE#320330: Qt 5 Has Been Updated to 5.6.1
  - FATE#320467: Cluster Support and High Availability for POWER
  - FATE#320535: Virtual Machine Driver Pack 2.4
  - FATE#321027: Support Status of Ethernet Drivers
- Changed entries:
  - FATE#320268: Installing kGraft Patches With Weak Package
    Dependency Resolution Disabled
  - FATE#320434: targetcli-fb Has Been Added
  - FATE#320440: The libcxl Userspace Library for CAPI Has Been
    Added
  - FATE#321010: Ceph Client Enablement Has Been Upgraded to Ceph
    Jewel
* Thu Aug  4 2016 sknorr@suse.com
- 12.2.20160804 (for SLES 12 SP2 RC1)
- Updated Makefile from repository
- Updated template text
  - Updated support tables
  - Added AArch64 kernel limits (bsc#988955)
- Updated release notes from FATE
- New entries:
  - FATE#316628: Obtaining Addresses with libvirt-nss
  - FATE#318001: Support for CXL Flash Storage Device Driver
  - FATE#318471: Enhanced Support for System Call Filtering on POWER
  - FATE#319935: perf Provides Guest Exit Statistics
  - FATE#319952: Extended CPU Performance Metrics in HYPFS for Linux
    z/VM guests
  - FATE#320350: KVM Legacy Device Assignment Was Disabled
  - FATE#320486: Subset of Scheduler Debugging Statistics Disabled by
    Default
  - FATE#320635: Transparent Huge Page Defragmentation Disabled by
    Default
  - FATE#320870: Root File System Conversion to Btrfs Not Supported
  - FATE#320983: Perl Bindings for Cyrus Have Been Removed
  - FATE#321010: Ceph Client Enablement Has Been Upgraded to Ceph Jewel
  - FATE#321021: Change of OpenMPI Behavor for Plugin Developers
- Removed entries:
  - FATE#316856: Kernel Driver cpqarray Was Removed
    [Change had actually been in SLES 12 GA already]
  - FATE#318032: Support of GPFS Partitions in fdasd
    [Feature deferred]
  - FATE#319593: Exploitation of Shared Memory Communications
    [Feature deferred]
  - FATE#319595: PCI: Function-Measurement-Block Enhancements
    [Feature deferred]
  - FATE#319603: Number of Outstanding I/Os for Flash Express Increased
    [No documentation needed]
  - FATE#320254: Support for "Access IBM"/"ThinkVantage" Button Removed
    [Only relevant x86 computers which are not supported by SLE]
* Fri Jul  1 2016 sknorr@suse.com
- 12.2.20160701
- Updated Makefile from repository
- Updated release notes from FATE
- New entries:
  - FATE#318236: Hardware Transactional Memory (HTM) support in glibc
  for POWER
  - FATE#318722: Enhanced OSA Network to Receive All Frames Through a
    Network Interface
  - FATE#319560: nvme-cli: A User-Space Tool to Manage NVMe Devices on
  Linux
  - FATE#319575: zKVM: SIE Capability Exposed to User Space
  - FATE#319576: Support for CCA Master Key Change for openCryptoki CCA
  Token
  - FATE#319577: OpenSSL Now Supports PKCS#11 Engine
  - FATE#319578: IPv6 Support in snIPL
  - FATE#319584: Bus Awareness for z Systems in systemd
  - FATE#319585: CPACF MSA 4: Support for PKCS #11 v2.4 (part 1)
  - FATE#319586: Layer 2 Offloads Enabled
  - FATE#319588: CUIR: Enhanced Scope Detection
  - FATE#319589: Fake NUMA Support
  - FATE#319591: IBM z13 Hardware Instructions in glibc
  - FATE#319592: Support for Dynamic Traces in openCryptoki
  - FATE#319593: Exploitation of Shared Memory Communications
  - FATE#319595: PCI: Function-Measurement-Block Enhancements
  - FATE#319597: Support for IPL Device in Any Subchannel Set
  - FATE#319598: Monitoring CPACF Crypto Activity
  - FATE#319600: IPv6 Priority Queuing Added to qeth Device Driver
  - FATE#319602: Bridging HiperSockets to Ethernet
  - FATE#319603: Number of Outstanding I/Os for Flash Express Increased
  - FATE#319605: Query Host Access to Volume Support
  - FATE#319606: VMUR Print Spool Options for Linux
  - FATE#319610: Support for DBRG in libica
  - FATE#319675: OpenSSH Was Updated to Version 7.2
  - FATE#319949: 10GbE RoCE Express Feature for RDMA
  - FATE#320679: Toolchain Module Enabled in Default Installation
  - FATE#320958: AutoYaST: Applying the First-Stage Network
  Configuration
    to the Installed System
  - FATE#320973: systemd: Support for System V and LSB Init Scripts Has
    Been Moved Out of Core Daemon
- Changed entries:
  - FATE#317043: openSSL Was Updated to Version 1.0.2
  - FATE#317893: Virtualization: Network Devices Supported
  - FATE#318421: Byebug Was Added
  - FATE#318829: Memory Compression with zswap
  - FATE#318899: Installing From DVD/USB Drive of the HMC
  - FATE#319858: NVDIMM Kernel Subsystem
  - FATE#320494: Media-based Sources Are Disabled After Installation If
    They Are Not Needed
  - FATE#320496: Enabling Enhanced Information About Physical Memory
    Page Ownership and Status
  - FATE#320649: GNOME Desktop Environment as a Technology Preview
    on AArch64
* Mon Jun 13 2016 sknorr@novell.com
- 12.2.20160613 (12 SP2 Beta 3):
- Updated release notes from FATE
- New entries:
  FATE#320649, FATE#319531, FATE#320494, FATE#319893, FATE#319639,
  FATE#319624, FATE#320358, FATE#318957, FATE#318829, FATE#315995,
  FATE#320616, FATE#320834, FATE#320490, FATE#320402, FATE#316612,
  FATE#315712, FATE#320080, FATE#319145, FATE#318421, FATE#320434,
  FATE#320889, FATE#320541, FATE#317043, FATE#320900
- Removed entries:
  FATE#319961, FATE#319525
* Tue May  3 2016 sknorr@suse.com
- 12.2.20160503
- Updated release notes from FATE
  - New entries: FATE#320388, FATE#320496, FATE#319858,
    FATE#319691, FATE#320679, FATE#320392, FATE#320268,
    FATE#318850, FATE#315818, FATE#312751, FATE#319660,
    FATE#316228, FATE#320638, FATE#319810, FATE#320353,
    FATE#319685, FATE#320254, FATE#318845, FATE#317885,
    FATE#318032, FATE#318899, FATE#320245, FATE#319365
  - Smaller changes in some entries
- Updated Makefile from new Makefile repo
* Mon Mar  7 2016 sknorr@suse.com
- Version 12.2.20160307
- Initial version for SLES 12 SP2
- Updated release notes entries from FATE
* Fri Mar  4 2016 sknorr@suse.com
- Version 12.1.20160304 (tracked in bsc#963395)
- Updated release notes from FATE.
- New entries:
  - FATE#319118: Updating Registration Status
  - FATE#319517: Virtual Machine Driver Pack 2.3
  - FATE#320402: GRUB Does Not Support vfb/vkbd Any More
    (see: bsc#961638)
  - FATE#319640: Starting X After Upgrading
    (see: bsc#919723)
  - FATE#319493: Puppet Has Been Updated
  - FATE#319388: Wireshark Updated
  - FATE#317893: Virtualization: Network Devices
  - FATE#317891: Virtualization: Supported Disks Formats and Protocols
- Changed entries:
  - FATE#319638: Automatic Removal of Add-on Products:
    (language/formatting fixes)
  - FATE#319053: Zypper Can List Already Installed and Unneeded Patches
    by CVE Number
    (content correction, see: bsc#965592)
  - FATE#319136: Recommended Packages
    (language fixes)
  - FATE#318063: 10GbE RoCE Express Feature
    (add APAR requirement to text, see: bsc#958054)
  - Small language fixes in boilerplate/template text
* Fri Jan 22 2016 sknorr@suse.com
- Tracked in bsc#961150
- Update release notes from FATE.
- New entries:
  - FATE#320285: Wayland is not supported
  - FATE#320021: In zKVM, avoid reboot after installation
    (see: bsc#943582)
- Changed entries:
  - FATE#315161: SP Update: Appended information about update on
    minimal installations
    (see: bsc#959134)
  - FATE#318956: OpenJDK 8 availability: Clarification, language
    cleanup
  - Minor changes to a few other entries to improve spelling,
    grammar, terminology, and readability
* Fri Jan  8 2016 sknorr@suse.com
- Tracked in bsc#957796
- Update release notes from FATE.
- New entries:
  - FATE#320203: AutoYaST Uses Wrong crashkernel Value During First
    Boot (see also: bsc#957447)
  - FATE#315161: New Method of Online Migration Between Service Packs
    (see: bsc#959576)
- Changed entries:
  - [What's New]: Docker is a fully supported technology
    (see: bsc#959614)
  - Lots of other entries changed to improve spelling, grammar,
    terminology, and readability
* Thu Dec  3 2015 sknorr@suse.com
- Tracked in bsc#957749
- Update release notes from FATE.
- New entries:
  - FATE#320019: Specifying Registration Code for Module Installation
    (see: bsc#956726)
- Changed entries:
  - FATE#318488: HTTP Proxy for Registration (wording)
  - FATE#314685: YaST Modules Dropped ... (typo fix, see: bsc#957749)
* Thu Nov 19 2015 sknorr@suse.com
- Update release notes from FATE.
- New entries:
  - Rollback of Service Packs (FATE#319108)
  - openlmi-bmc (FATE#316000)
  - Tar: Extended Attributes (FATE#319391)
- Fixed issue where text version of RN had a # character at the end of
  each title (bsc#955662)
- Fix typos.
* Mon Nov  9 2015 ke@suse.de
- 12.1.20151109 (bsc#933411):
- Update release notes from FATE.
* Fri Nov  6 2015 ke@suse.de
- 12.1.20151106 (bsc#933411):
- Update release notes from FATE.
* Wed Nov  4 2015 ke@suse.de
- - 12.1.20151104 (bsc#933411):
- Update release notes from FATE.
* Tue Nov  3 2015 ke@suse.de
- 12.1.20151103 (bsc#933411):
- Update release notes from FATE.
* Thu Oct 22 2015 ke@suse.de
- 12.1.20151022 (bsc#948980):
- Update release notes from FATE.
* Thu Oct  8 2015 ke@suse.de
- 12.1.20151008 (bsc#933411):
- Update release notes from FATE.
* Mon Sep 14 2015 ke@suse.de
- 12.1.20150914 (bsc#938049):
- Update release notes from FATE.
- Fix encoding of .txt.
* Tue Sep  8 2015 ke@suse.de
- 12.1.20150908 (bsc#933411):
- Update release notes from FATE.
* Tue Sep  1 2015 ke@suse.de
- 12.1.20150901 (bsc#933411):
- Update release notes from FATE.
* Mon Aug 17 2015 ke@suse.de
- 12.1.20150817 (bsc#933411):
- Update release notes from FATE.
* Thu Jul 30 2015 ke@suse.de
- 12.1.20150730:
- Update release notes from FATE (bsc#933411).
* Tue Jul 14 2015 ke@suse.de
- 12.1.20150714:
- Update release notes from FATE (bsc#933411).
- .spec: Remove obsolete Provides/Obsoletes.
- .spec: Provide locate yast.xsl to ensure UTF-8 encoding (bsc#938049).
* Thu Jul  2 2015 ke@suse.de
- 12.1.20150702:
- Update release notes from FATE (bsc#933411).
* Tue Jun  2 2015 ke@suse.de
- 12.1.20150602 (bsc#933411):
- Update release notes from FATE.
- Updated entries: KVM Limits (max vcpus is 160) (bsc#921171).
* Wed Feb 11 2015 ke@suse.de
- 12.1.20150211:
- Start with resetting for SLES 12 SP1.
* Thu Jan  8 2015 ke@suse.de
- 12.0.20150108 (bnc#910036):
- Update release notes from FATE.
- Updated entries: System z Performance Counters in perf Tool
  (bnc#909721 via fate#315988).
- New entries: Dynamic Aggregation of LVM Metadata via lvmetad
  (fate#314556); Linux support for Flash and concurrent Flash MCL
  updates (bnc#909721 via fate#315317); Connection to VNC support GNOME
  (fate#318311).
* Wed Dec  3 2014 ke@suse.de
- 12.0.20141203 (bnc#903795):
- Update release notes from FATE.
- Updated entries: Current Features and Limitations in a UEFI Secure
  Boot Context (bnc#896645 via fate#317500); Filesystem Support Table
  (bnc#903673); Enabling the wicked "nanny" Framework (fate#316649);
  Apache 2.4 (fate#317912); Serial Console Bootloader Settings
  (fate#317818); /proc/acpit/event Interface Removed
  (fate#317911).
- New entries: Autoselecting Packages during Module Activation
  (bnc#905802 via fate#318213); cifs-utils /etc/samba/smbfstab migration
  (bnc#903217 via fate#318090).
* Tue Oct 28 2014 ke@suse.de
- 12.0.20141028:
- Update release notes from FATE.
- Fix URLs to documentation; bnc#902868.
* Thu Oct 23 2014 ke@suse.de
- 12.0.20141023 (bnc#902380):
- Update release notes from FATE.
- Add life cycle of the modules.
* Tue Oct 14 2014 ke@suse.de
- 12.0.20141014 (bnc#900083):
- Update release notes from FATE.
- Cosmetic changes such as bnc#888469 (via fate#317042, already
  submitted earlier); bnc#900771 (via fate#316585, typo).
- New entry: Support for Intel PSM API (fate#315889).
* Fri Oct 10 2014 ke@suse.de
- 12.0.20141010:
- Update release notes from FATE.
- Update What's New: Info on fix status of bash (bnc#900057).
* Wed Oct  8 2014 ke@suse.de
- 12.0.20141008:
- Update release notes from FATE.
- New entries: Mounting NFS volumes locally on the exporting server (via
  fate#317947).
* Mon Oct  6 2014 ke@suse.de
- 12.0.20141006:
- Update release notes from FATE.
- Updated entries: Default file system (fate#316637).
* Mon Sep 29 2014 ke@suse.de
- 12.0.20140929:
- Update release notes from FATE.
- Updated entries: What's New (bnc#898123).
* Thu Sep 25 2014 ke@suse.de
- 12.0.20140925:
- New entries: /dev/disk/by-path/ links no longer created for virtio
  devices (bnc#893728 via fate#317887 [probably already submitted last
  time]); Firefox Integration in Active Directory Environments Using
  NTLMv1 Protocol (bnc#882670 via fate#317918).
* Thu Sep 18 2014 ke@suse.de
- 12.0.20140918:
- Update release notes from FATE.
- New entry: Initrd File Compression Format (bnc#895960 via
  fate#316212).
- Update kernel limits.
* Thu Sep  4 2014 ke@suse.de
- 12.0.20140904:
- Update release notes from FATE.
- Update support section (bnc#894282).
- Update kernel and file system limits.
- Updated entries: File System Layout (/run/media/$user) (bnc#890198
  via fate#317286).
* Tue Sep  2 2014 ke@suse.de
- 12.0.20140902:
- Update release notes from FATE.
- Update kernel and file system limits.
- Updated entries: Remove IPF Architecture from Hot-Add Memory section
  (fate#316731 via bnc#894472).
- New entry: AppArmor command names (bnc#889316 via fate#317860);
  PostgreSQL support status (bnc#894441 via fate#316990).
* Mon Sep  1 2014 ke@suse.de
- Update release notes from FATE.
- Update XEN and KVM limits (FATE#315980, FATE#315981)
- New entries: remote login with xdmcp (bnc#893077 via fate#317876).
* Thu Aug 28 2014 ke@suse.de
- 12.0.20140828:
- New entries: MariaDB Replaces mySQL (update issue) (bnc#889346 via
  fate#313595); mlx5 Driver Supports New Mellanox Connect-IB Adapter for
  Power (was lost, bnc#893511 via fate##315949).
* Thu Aug 21 2014 ke@suse.de
- 12.0.20140821 (bnc#891958):
- Update release notes from FATE.
- New entries: Enabling Full Heap Randomization (bnc#884733 via
  fate#317848); Format of the 'microcode' Field in /proc/cpuinfo Changed
  (bnc#884736 via fate#317814).
* Thu Aug 14 2014 ke@suse.de
- 12.0.20140814 (bnc#891302):
- New entries: Samba: Changing "winbind expand groups" to "0"
  (bnc#890008 via fate#317830); VMware Does Not Support Migrating
  (bnc#891302 via fate#317832).
- Improve support statement (bnc#882262).
- File systems update (wip).
* Mon Aug 11 2014 ke@suse.de
- 12.0.20140811 (or earlier) (bnc#888175):
- Update release notes from FATE.
- Updated entries: Huge Page Memory Support on POWER (bnc#886651 via
  fate#317800); TrackPoint Configuration (bnc#885667 via fate#317087).
- New entries: Serial Console Bootloader Settings (bnc#887014 via
  fate#317818).
* Wed Aug  6 2014 ke@suse.de
- 12.0.20140806:
- Update SLE 12 release notes from FATE.
* Mon Aug  4 2014 rsalevsky@suse.com
- 12.0.20140804:
  * change date format
  * fix wrong version
* Tue Jul 29 2014 rsalevsky@suse.com
- 12.0.20140729:
  * New Makefile
* Fri Jul 25 2014 rsalevsky@suse.com
- 12.0.24:
  * Update release notes from FATE.
* Mon Jul 21 2014 ke@suse.de
- Update release notes from FATE.
* Thu Jul  3 2014 ke@suse.de
- 12.0.22:
- Update release notes from FATE.
- Switch to article layout.
* Mon Jun 23 2014 ke@suse.de
- 12.0.21:
- Update SLE 12 release notes from FATE.
- Build HTML for the Web with explicit web fonts enabling
  (build.for.web=1) (bnc#883820).
* Wed Jun 18 2014 ke@suse.de
- 12.0.20:
- Update SLE 12 release notes from FATE.
- Add product release date.
* Wed Jun 18 2014 ke@suse.de
- 12.0.19:
- Update SLE 12 release notes from FATE.
- Cleanup framework files.
* Thu Jun 12 2014 ke@suse.de
- 12.0.18:
- Update SLE 12 release notes from FATE.
- Updated entries: Hot-Add Memory (adjusted according to bnc#882257 via
  fate#316731).
- Removed entries: Using iSCSI Disks when Installing (bnc#882257).
* Mon Jun  2 2014 ke@suse.de
- 12.0.17:
- Update SLE 12 release notes from FATE.
* Thu May 15 2014 ke@suse.de
- 12.0.16:
- Update SLE 12 release notes from FATE.
* Wed Apr 30 2014 ke@suse.de
- 12.0.15:
- Update SLE 12 release notes from FATE.
- Updated entries: Kernel Modules (bnc#869159).
* Wed Apr 16 2014 rsalevsky@suse.com
- 12.0.14
- Update release notes from FATE.
- Cleanup specfile and fix build warning.
* Tue Apr  8 2014 ke@suse.de
- 12.0.13:
- Update release notes from FATE.
- Fix profiling for the PDF of the SLES for VMware product
  (bnc#872172).
* Mon Apr  7 2014 ke@suse.de
- 12.0.12:
- Update release notes from FATE.
* Mon Mar 31 2014 ke@suse.de
- 12.0.11:
- Update release notes from FATE.
* Thu Mar 27 2014 ke@suse.de
- 12.0.10:
- Update release notes from FATE.
- Now using RN12 categories from FATE for real.
- SLE-11 to SLE-12 migration (bnc#870534, now via fate#313189).
* Mon Mar 24 2014 ke@suse.de
- 12.0.9:
- Update SP3 release notes from FATE.
- Start using new fate release notes categories; this implies changes in
  structuring (fate#317024).
* Thu Mar 13 2014 ke@suse.de
- 12.0.8:
- Update SP3 release notes from FATE.
- Require dejavu-fonts and google-opensans-fonts.
* Wed Mar  5 2014 ke@suse.de
- 12.0.7:
- Update SP3 release notes from FATE.
- Avoid superfluous directory in release-notes-static (bnc#866876).
* Thu Feb 27 2014 ke@suse.de
- 12.0.6:
- Update SP3 release notes from FATE.
- Use profile-yast.xsl to avoid setting docbook default
  body.attributes (bnc#864900).
* Thu Feb 13 2014 ke@suse.de
- 12.0.5:
- Update SP3 release notes from FATE.
* Thu Jan 30 2014 ke@suse.de
- 12.0.4:
- Update SP3 release notes from FATE.
- Install LICENSE.
* Fri Jan 24 2014 ke@suse.de
- 12.0.3:
- Update SP3 release notes from FATE.
- Change license from Any commercial to CC-BY-ND-3.0.
- Add license text.
- 12.0.2:
- Use daps 2.0.x for building.
- Update SP3 release notes from FATE.
* Thu Jan  9 2014 ke@suse.de
- 12.0.1:
- Update SLES 12 release notes from FATE.
* Thu Nov 28 2013 ke@suse.de
- 12.0.0
- Start with resetting for SLES 12.
- For testing, we currently include SLED 12 features.
- New structure.
* Tue Oct 22 2013 ke@suse.de
- 11.3.27 (bnc#841003):
- New entries: Enabling NFS 4.1 for nfsd (bnc#832264).
- Updated entries: EXT4 module loading (bnc#834142), Xen Limits
  (adjustments for XEN 4.2).
* Tue Sep 10 2013 ke@suse.de
- 11.3.26 (bnc#828181):
- New entries: Hyper-V: Time Synchronization (bnc#822523).
- Changed entries: Software Requiring Specific Contracts, remove
  misleading WebSphere reference (bnc#836418).
* Tue Aug  6 2013 ke@suse.de
- 11.3.25 (bnc#828181):
- Update SP3 release notes from FATE.
- New entries: Upgrade Bind to version 9.9 (bnc#831891); Multipath
  Configuration Change (bnc#828888).
- Changed entries: Packages and Features to Be Removed in the Future:
  dhcp-client will stay, bug dhcpv6 will be discontinued (bnc#829664);
  Updated qla2xxx to version 8.04.00.13.11.3-k (bnc#832630).
* Wed Jul 10 2013 ke@suse.de
- 11.3.24:
- Update SP3 release notes from FATE.
- Update support statement (bnc#828478).
* Thu Jul  4 2013 ke@suse.de
- 11.3.22 (bnc#:824787):
- Updated entries: Service Pack for HP Linux ProLiant (bnc#826123); move
  UEFI section to a better location (bnc#828056 via fate); add pointer
  to fadump config (bnc#817831 via fate)..
- New entries: Capturing kdump on a Target using Devicemapper
  (Incl. Multipath) (bnc#827016); Lower Version Numbers in SUSE Linux
  Enterprise 11 SP3 than in SP2 (bnc#827325).
- Removed entries: iSCSI Installations with Multiple NICs Losing Network
  Connectivity at the End of Firstboot Stage (bnc#825141).
* Thu Jun 13 2013 ke@suse.de
- 11.3.22 (bnc#824155):
- Update SP3 release notes from FATE.
- Updated entries: List of updated packages (bnc#823367); kernel command
  line can be shortened by customer on System z (bnc#824027).
- New entries: authorized_keys via fate#314262 (bnc#822877).
* Thu Jun 13 2013 ke@suse.de
- 11.3.22 (bnc#824155):
- Update SP3 release notes from FATE.
- Updated entries: List of updated packages (bnc#823367).
- New entries: authorized_keys via fate#314262 (bnc#822877).
* Thu Jun  6 2013 ke@suse.de
- 11.3.21:
- Update SP3 release notes from FATE.
- New entry: XFS stack overflow (bnc#815356)
- Updated entries: update the list of updated packages, only show major
  update; libica 2.1.0 Available since SLES 11 SP2 for s390x.
* Thu May 30 2013 ke@suse.de
- 11.3.20:
- Update SP3 release notes from FATE.
- Updated entries: Migrating Hosts Running SMT to SP3 (bnc#818105); KVM
  limits (fate#314371).
* Tue May 28 2013 ke@suse.de
- 11.3.19:
- Update SP3 release notes from FATE.
- Set params to make the home page link active.
- New entries: Support for the btrfs File System (bnc#732564, had link
  limitation configurable).
- Updated entries: Hot-Add Memory (bnc#819950); List of Updated
  Packages.
* Thu May 23 2013 ke@suse.de
- 11.3.18:
- Update SP3 release notes from FATE.
- Update introduction (bnc#821338).
* Thu May 16 2013 ke@suse.de
- 11.3.17:
- Update SP3 release notes from FATE.
- Updated entries: Hot-Add Memory (bnc#819950); Installation on 4KB
  Sector Drives Not Supported (bnc#819950).
- Collect TechPreview topics in the Technology Preview section;
  bnc#819947 (via fate).
- Additional target (release-notes-static) for publishing on the Web
  using daps.
- Use daps to build the PDF output format.
- Remove BuildRequires that are already covered by daps.
* Mon May 13 2013 ke@suse.de
- 11.3.16:
- Update SP3 release notes from FATE.
- Update introduction.
- Updated entries: KVM Limits; kdump Support for System z (bnc#819556
  via fate#314077).
- Removed entries: Formatting Large Disk Partitions on Windows 8
  Server.
* Wed May  8 2013 ke@suse.de
  11.3.15:
- Update SP3 release notes from FATE.
- Updated entries: Updated qla4xxx to version v5.03.00.06.11.3-k0
  (bnc#818162); Using iSCSI Disks when Installing (bnc#818162); kdump
  Support for System z (fate#314077; bnc#818700).
* Thu May  2 2013 ke@suse.de
- 11.3.14:
- Update SP3 release notes from FATE.
- New entries: Migrating Hosts Running SMT to SP3 (bnc#818105).
* Thu Apr 25 2013 ke@suse.de
- 11.3.13:
- release-notes.txt: provide plain ascii file (bnc#816751).
- Resolve several "checkit" marked entries.
- New entries: Migrating SUSE Linux Enterprise Server 11 SP2 with
  WebYaST Installed via wagon (bnc#804970).
- Updated entries: Migrating to SLE 11 SP3 Using Zypper.
* Tue Apr 23 2013 ke@suse.de
- Install RELEASE-NOTES-web.en.html with embedded CSS.
* Thu Apr 18 2013 ke@suse.de
- 11.3.12:
- Update SP3 release notes from FATE (now also with fates in state
  validation).
* Mon Apr 15 2013 ke@suse.de
- 11.3.11:
- Update SP3 release notes from FATE.
* Thu Apr  4 2013 ke@suse.de
- 11.3.10:
- Re-classifying KVM features in fate (bnc#812241).
- New entries: Using btrfs as /root File System on IBM Power Systems
  (bnc#812457).
* Thu Mar 28 2013 ke@suse.de
- 11.3.9:
- Update entries: Hot-Add Memory (bnc#810575).
- Embed CSS.
* Thu Mar 21 2013 ke@suse.de
- 11.3.7:
- Update SP3 release notes from FATE.
- Updated entries (via bnc#810575; bnc#810756).
* Fri Mar 15 2013 ke@suse.de
- 11.3.6:
- Update SP3 release notes from FATE.
- New entries: New Partition Types Added to the fdasd Command
  (bnc#792066).
* Thu Mar  7 2013 ke@suse.de
- 11.3.5:
- Update SP3 release notes from FATE.
- Updated entries: WebYaST as add-on (bnc#804970); File
  Systems table (btrfs) (bnc#807470 and bnc#807235).
* Wed Feb 27 2013 ke@suse.de
- 11.3.4:
- Update SP3 release notes from FATE.
- Updated entries: Desktop features (bnc#804973);
  vm.dirty_background_ratio is 10 (bnc#805838).
* Tue Feb 12 2013 ke@suse.de
- 11.3.3:
- Update SP3 release notes from FATE.
- Build and ship PDF of the release notes document.
* Thu Feb  7 2013 ke@suse.de
- 11.3.2:
- Update SP3 release notes from FATE.
* Thu Jan 31 2013 ke@suse.de
- 11.3.1
- New entries (selection): IBM Java 1.4.2 End of Live (fate#313355;
  bnc#801019).
- Update SP3 release notes from FATE.
* Wed Dec  5 2012 ke@suse.de
- 11.3.0:
- Start resetting for SLES 11 SP3.
- Pull in SP3 release notes from FATE.
* Wed Nov 28 2012 ke@suse.de
- 11.2.0.42:
- New entry: Mounting NFS Volumes Locally on the Exporting Server
  (bnc#778116).
* Tue Nov 20 2012 ke@suse.de
- Rebuild source archive to eliminate 1 false positive and to provide
  the correct release date.
* Thu Oct 25 2012 ke@suse.de
- 11.2.0.41 (bnc#779575):
- New entry: VWware ballooning driver (bnc#779572; fate#311976);
  autofs timeouts (bnc#778537; fate#312611).
* Tue Aug 21 2012 ke@suse.de
- 11.2.0.40:
- New entry: PostgreSQL update (bnc#774588; fate#311794).
* Wed Aug  1 2012 ke@suse.de
- 11.2.0.39:
- Update SP2 release notes from FATE.
- New entry: LXC Requires Correct Network Configuration (bnc#771384).
* Thu Jun 14 2012 ke@suse.de
- Rebuild 11.2.0.38 to make fate#311705 (pstore) appear.
* Wed Jun 13 2012 ke@suse.de
- 11.2.0.38 (bnc#761121):
- Insecurity with XEN on Some AMD Processors.
- pstore to read kernel crashes (fate#311705).
- YaST Repair Tool Limitation (bnc#747605).
- More fixes: bnc#749554 (novfs and NCL, in fate#313160).
* Tue May  8 2012 ke@suse.de
- 11.2.0.37 (tracker bug bnc#757039):
- Updated entries: btrfs (bnc#757039, updated in fate), Broadcom 57712
  vNICs/NPAR PCIE Functions Disappearing under SP2 (bnc#750414).
- New entries: Kernel Development Files Moved (bnc#661511).
- More fixes: bnc#757044, bnc#760930 (php version info, also see
  fate#311983), bnc#756881, bnc#749049.
* Fri Apr 13 2012 ke@suse.de
- 11.2.0.36 (tracker bug bnc#750625):
- Update SP2 release notes from FATE.
- Updated entries: Collaborative Memory Management Stage II (CMM2) Lite
  (bnc#753005), Broadcom 57712 vNICs/NPAR PCIE Functions Disappearing
  under SP2 (bnc#750414), Upgrading from SLES 10 (GA and Service Packs)
  or SLES 11 GA (bnc#755503, bnc#751006), libica 2.1.0 Available in SLES
  11 SP2 for s390x, Loading the Installation Kernel via Network on POWER
  (bnc#756801).
- New entries: Formatting Large Disk Partitions on Windows 8 Server
  (bnc#754041); SUSE Linux Enterprise Real Time Extension (bnc#754267).
- More fixes: bnc#755877; bnc#750905; bnc#750970 (in fate).
* Tue Mar  6 2012 ke@suse.de
- 11.2.0.35 (tracker bug bnc#746871):
- Update SP2 release notes from FATE.
- New entry: ATI Radeon ES1000 Support (bnc#744314), Broadcom 57712
  vNICs Disappearing under SP2 (bnc#742845), Brocade FCoE Switch Does
  Not Accept Fabric Logins from Initiator (bnc#726754).
- Updated entries: Migrating to SLE 11 SP2 Using Zypper (bnc#731924);
  Btrfs from FATE (see bnc#747343).
* Mon Feb 27 2012 ke@suse.de
- 11.2.0.34:
- Update SP2 release notes from FATE again.
- New entry: iSCSI Booting with iBFT in UEFI Mode (bnc#746579).
* Wed Feb 15 2012 ke@suse.de
- 11.2.0.33:
- Update SP2 release notes from FATE again.
* Wed Feb 15 2012 ke@suse.de
- 11.2.0.32:
- Update SP2 release notes from FATE.
- Update existing System z entries.
* Wed Feb 15 2012 ke@suse.de
- 11.2.0.31:
- Updated entries: Using qla3xxx and qla4xxx Drivers at the Same Time
  (bnc#745201).
- Update SP2 release notes from FATE (e.g., for bnc#722273).
* Mon Feb 13 2012 ke@suse.de
- 11.2.0.30:
- Move "Miscellaneous" section to the end of the document.
- New entries: Updating Firmware for QLogic 82XX based CNA
  (bnc#744652).
- Updated entries: CPU Overcommit and Fully Virtualized Guest
  (bnc#744288); fix gdb version info (bnc#745325); enhance KVM
  (bnc#739455).
- Update SP2 release notes from FATE.
  11.2.0.29:
- Cleanup skeleton (e.g., remove duplicated S390x features).
- Update SP2 release notes from FATE.
* Mon Feb  6 2012 ke@suse.de
- 11.2.0.28:
- Update SP2 release notes from FATE.
- 11.2.0.27:
- New feature section: Resource Management.
- Update SP2 release notes from FATE.
* Fri Feb  3 2012 ke@suse.de
- 11.2.0.26:
- Update SP2 release notes from FATE.
- New entries: Support of Live Guest Relocation (LGR) with z/VM 6.2 on
  SLES 11 SP2 (bnc#738559); Limitations with the "qetharp" Utility
  (bnc#744841); Linux Guests Running on z/VM 5.4 and 6.1 Require z/VM
  Service Applied (bnc#743338).
- Updated entries: IPv6 Improvements. Also adjust other parts.
* Fri Feb  3 2012 ke@suse.de
- Set license.
* Thu Feb  2 2012 ke@suse.de
- 11.2.0.25:
- Update SP2 release notes from FATE.
- Continue with general cleanup and proofreading.
- New entries: Migrating to SLE 11 SP2 (bnc#731924)
  11.2.0.24:
- Add info on SLES for VMware and profile accordingly.
- General cleanup and proofreading.
- Updated entry: Unplugging all channel paths might lead to a kernel
  panic in a DASD PAV environment (bnc#743665).
* Fri Jan 27 2012 ke@suse.de
- 11.2.0.23:
- Update SP2 release notes from FATE.
- New entry: Existing Data Execution Protection Removed for System z
  (bnc#721253); RAW IO on PAV Devices with Cable Plug/Unplug Causes Path
  Group to Get Lost (bnc#743665).
- Updated entry: Upgrading to SLES 11 SP2 with Root Filesystem on iSCSI
  (bnc#733001); Installation Using Persistent Device Names
  (bnc#732999); LILO Configuration Via YaST or AutoYaST (bnc#740513);
  Updating with Alternative Boot Loader (Non-Linux) or Multiple Boot
  Loader Programs (bnc#740509).
- Remove obsolete entries (bnc#743336) and adjust some other parts.
* Mon Jan 23 2012 ke@suse.de
- 11.2.0.22:
- Update SP2 release notes from FATE.
- New entry: Mellanox ConnectX2 Ethernet Adapter (bnc#725246).
* Fri Jan 20 2012 ke@suse.de
- 11.2.0.21:
- Update SP2 release notes from FATE.
* Mon Jan 16 2012 ke@suse.de
- 11.2.0.20:
- Update SP2 release notes from FATE.
* Fri Jan 13 2012 ke@suse.de
- 11.2.0.19:
- Update SP2 release notes from FATE.
- Fixed bugs: bnc#740469, bnc#733000, bnc#740509.
- New entries: Tomcat6 and Related Packages (fate#312717).
* Wed Dec 28 2011 ke@suse.de
- 11.2.0.18:
- Update SP2 release notes from FATE.
- Updated entry: Authentication for kdump through YaST (bnc#706059).
* Wed Dec 14 2011 ke@suse.de
- 11.2.0.17:
- Update and now restructure SP2 release notes from FATE.
- New entry: Authentication for kdump through YaST (bnc#706059).
- Updated entry: Myri10GE driver (bnc#736148).
* Fri Dec  2 2011 ke@suse.de
- 11.2.0.16:
- General initial cleanup.
- Import and update SP2 release notes from FATE.
* Mon Nov 28 2011 ke@suse.de
- 11.2.0.15:
- Add feedback received via (bnc#730631).
* Thu Nov 24 2011 ke@suse.de
- 11.2.0.14:
- Import and update SP2 release notes from FATE.
* Fri Nov 18 2011 ke@suse.de
- 11.2.0.13:
- Import and update SP2 release notes from FATE.
- New entry: Booting from Harddisks larger than 2 TiB in Non-UEFI Mode
  (bnc#719429).
* Fri Nov  4 2011 ke@suse.de
- Release 11.2.0.12:
- Import and update SP2 release notes from FATE.
- General proofreading of the old entries.
* Fri Oct 28 2011 ke@suse.de
- Release 11.2.0.11:
- Import and update SP2 release notes from FATE.
* Wed Oct 12 2011 ke@suse.de
- Release 11.2.0.10:
- POWER: Misleading Buffer I/O Error Messages (bnc#705401).
- Directly Addressable Memory (ZONE_NORMAL) on x86 Machines
  (bnc#721333).
* Fri Sep 16 2011 ke@suse.de
- Release 11.2.0.9:
- Import and update SP2 release notes from FATE.
* Thu Sep  1 2011 ke@suse.de
- Release 11.2.0.8:
- Rename configure.in to configure.ac.
- Update check for XML DTD.
- Import and update SP2 release notes from FATE.
* Fri Aug 26 2011 ke@suse.de
- Release 11.2.0.7
- Update entries from FATE for testing.
* Mon Aug 22 2011 ke@suse.de
- Release 11.2.0.5
- Update entries from FATE for testing; automatically generated using
  fate2docbook.
- Update several existing entries.
* Fri Jul 29 2011 ke@suse.de
- Release 11.2.0.4
- Remove unwanted SDK entries.
- Update entries from FATE for testing; automatically generated using
  fate2docbook.
- Fix spelling errors reported by Jared Hudson [bnc#708802].
* Thu Jul 28 2011 ke@suse.de
- Release version 11.2.0.3
- Update entries from FATE for testing; automatically generated using
  fate2docbook.
* Mon Jul  4 2011 ke@suse.de
- Release version 11.2.0.2
- Add new and changed entries, which will also be published with the
  next SLES 11 SP1 release notes update.
- Include entries from FATE for testing; automatically generated using
  fate2docbook.
* Fri Jun 17 2011 kukuk@suse.de
- adjust for SLES11 SP2
- ecryptfs no longer techpreview [FATE#312109]
* Wed May 18 2011 ke@suse.de
- Fix typo.
* Tue Apr 19 2011 ke@suse.de
- release version 11.1.1.3
- Document Stopping Cron Status Messages [bnc#622203]
* Wed Feb 16 2011 kukuk@suse.de
- release version 11.1.1.3
- Document changed routing behavior [bnc#632856]
* Tue Sep 21 2010 kukuk@suse.de
- release version 11.1.1.2
- Adjust XEN limits [bnc#640006]
* Mon May 31 2010 ihno@suse.de
- release version 11.1.1.1
- Fixed Samba release number to 3.4.3 [bnc#606288]
- Remove snipped about SGI REACT [bnc#609367], [bnc#448734]
- poloshing the iSCSI text. [bnc#486012]
* Fri May 28 2010 ihno@suse.de
- Removed duplicate Entry about NFS over RDMA [bnc#608541]
- Added restriction about NFSv4 over IPv6 Support [bnc#608543]
* Wed May 26 2010 kukuk@suse.de
- Correct state about VMI kernel flavour [bnc#608693].
* Thu May 20 2010 aosthof@suse.de
- Adjusted paragraph about mcelog in technical.xml
* Fri May 14 2010 kkaempf@novell.com
- Add WebYaST paragraph.
* Tue May 11 2010 kukuk@suse.de
- Add 2 TiB limitation of legacy bios on x86/x86-64 [bnc#591566]
- Re-Add end of support [bnc#602292]
* Mon May 10 2010 ihno@suse.de
- Added zSeries features to the existing list of features.
* Sat May  8 2010 mge@novell.com
- RDMA NFS server may hang during shutdown (OFED) [bnc#585361]
- InfiniBand - SDP protocol is not supported on IBM HW [bnc#602954]
- Power Hot Add Memory Reference [bnc#600361]
- iSCSI target not using HW functionality on Broadcom 5709 [bnc#594957]
- No end of support in release notes [bnc#602292]
- Graphical administration of remotely installed HW [bnc#585190]
- iSCSI install with multiple NICs may loose
  network connectivity at the end of firstboot stage [bnc#486012]
* Fri May  7 2010 mge@novell.com
- Adjust kernel- and filesystem-limits for SLE 11 SP 1 [bnc#582624]
- Add btrfs to filesystem overview (TechPreview)
- Add legal wording
- remove zfcs specific comment [bnc#601588]
- add virtio-balloon to virtualization aware drivers
  for SLES 10 SP 3 and KVM [bnc#602493]
- no xfs for /boot [bnc#580311]
- itrace and gdb [bnc#600835]
* Mon Apr 26 2010 ihno@suse.de
- added line about XEN / UEFI [bnc#578927]
- document how to switch off cgroups/mem [bnc#587832]
* Sun Apr 25 2010 ihno@suse.de
- Updated KVM parameters in Release Notes [bnc#597027]
* Fri Apr 23 2010 ihno@suse.de
- added missing line 'setenv load-base 4000'  [bnc#568388]A
- added section about libica [bnc#598405]
- repleaced two sections for ppc64 [bnc#598902]
* Wed Apr 21 2010 aosthof@suse.de
- Added paragraph about mcelog to technical.xml
* Tue Apr 20 2010 kukuk@suse.de
- Fix version number of iprutils [bnc#598022]
* Mon Apr 12 2010 ihno@suse.de
- fixed multiple versio nnumbers from packages in the update section
- deleted three s390x sections [bnc#595154]
- NFS over RDMA server hangs during shutdown [bnc#585361]
* Tue Mar 30 2010 kukuk@suse.de
- Update kernel module version numbers
- Adjust for RC2
* Thu Mar 18 2010 kukuk@suse.de
- Adjust for RC1
- Fix URL for online version of release-notes
* Thu Feb 25 2010 kukuk@suse.de
- Adjust for Beta5
* Wed Feb 24 2010 ihno@suse.de
- add KVM
- adjusted XEN
* Tue Feb 16 2010 kukuk@suse.de
- Fix encoding problem in .txt files [bnc#575693]
- Remove obsolete "known issue" entries for reiserfs and HP on ia64
* Thu Feb 11 2010 kukuk@suse.de
- Update for Beta4
* Fri Feb  5 2010 kukuk@suse.de
- Fix some typos [bnc#577037]
* Thu Jan 28 2010 kukuk@suse.de
- Update for Beta3
* Tue Jan 26 2010 kukuk@suse.de
- Adjust version number for KDE and QT
* Thu Jan 14 2010 kukuk@suse.de
- Update for Beta2
- Document read-only root filesystem changes
- Fix layout
* Thu Dec 10 2009 kukuk@suse.de
- Update for Beta1
* Fri Nov 27 2009 kukuk@suse.de
- Sync with Alpha3
* Wed Nov 18 2009 kukuk@suse.de
- First version for SLES11 SP1
* Mon Nov  9 2009 kukuk@suse.de
- Don't convert html to rtf but symlink [FATE#306167]
* Fri Nov  6 2009 mge@novell.com
- fixes
  bnc#547040	bnc#486449
  bnc#490462	bnc#488642
  bnc#488006	bnc#518491
  bnc#486144	bnc#448734
* Fri Oct 16 2009 kukuk@suse.de
- Install .txt version for YaST in text mode [FATE#306167]
* Wed Mar 18 2009 mge@novell.com
- fix wording regarding SPident
* Wed Mar 18 2009 mge@novell.com
- 11.0.0.31
- fix packaging
- fixes
  bnc#481480
* Mon Mar 16 2009 mge@novell.com
- 11.0.0.30
- fixes
  bnc#481480	bnc#417244
* Mon Mar 16 2009 mge@novell.com
- 11.0.0.29
- fixes
  bnc#485183	bnc#465601	bnc#473572
  bnc#476471	bnc#482381	bnc#483702
  bnc#484856	bnc#484093	bnc#484850
  bnc#484358	bnc#483250
- deprecation of 32bit Xen hypervisor with a later SP.
- clarify language regarding CPUs (following bnc#483250)
* Mon Mar  9 2009 mge@novell.com
- adjust Xen limits, see also bnc#482614
* Thu Mar  5 2009 mge@novell.com
- fixes bnc#481909
- fix minor typos
* Wed Mar  4 2009 mge@novell.com
- use entities (&sle; &sles;) more consequently
* Tue Mar  3 2009 mge@novell.com
- 11.0.0.28
- merge more reviews by Kerry Kim (chapters 8,9)
* Sat Feb 28 2009 mge@novell.com
- 11.0.0.27
- merge review by Kerry Kim (chapters 1-7; 10)
- merge information about news on System z
* Fri Feb 27 2009 mge@novell.com
- 11.0.0.26
- fix release-notes-sles.desktop
- propose YaST Kdump module for kdump configuration
- document: Memory controller (cgroup) is disabled by default
  FATE#302085 bnc#467688
- fix minor typos
* Thu Feb 26 2009 mge@novell.com
- Update to 11.0.0.25
- fixes
  bnc#477729 c17
  bnc#448734 c47
  bnc#448734 c48
  bnc#448734 c50
* Wed Feb 25 2009 mge@novell.com
- Update to 11.0.0.24
- merge x86 and x86_64
- minor additions; finally fixes bnc#448734 c41
- replace all "SLES" with &sles;
* Tue Feb 24 2009 mge@novell.com
- Update to 11.0.0.23
- fixes bnc#415665
  bnc#448734 c26 bnc#448734 c27 bnc#448734 c28
  bnc#448734 c29 bnc#448734 c30 bnc#448734 c31
  bnc#448734 c37 bnc#448734 c38 bnc#448734 c40
  bnc#448734 c41
  bnc#458698 bnc#468251 bnc#468922 bnc#471221
  bnc#474036 bnc#474040 bnc#475311 bnc#475566
  bnc#476136 bnc#476147 bnc#476284 bnc#476285
  bnc#476305 bnc#476385 bnc#476471 bnc#476855
  bnc#476996 bnc#477469
* Mon Feb  9 2009 mge@suse.de
- Update to 11.0.0.22
- fixes bnc#436909, bnc#470748
- (partially) fixes bnc#448734
* Fri Jan 23 2009 mge@suse.de
- Update to 11.0.0.21:
- add details about minimal pattern
- fix typos
* Mon Jan 19 2009 kukuk@suse.de
- Update to 11.0.0.20: Fix layout
* Thu Jan 15 2009 mge@novell.com
- update to 11.0.0.19
- include news and special notes for System z (s390x)
* Tue Jan 13 2009 mge@novell.com
- update to 11.0.0.18
- kernel-limits, filesystem limits
- architecture specific comments
* Mon Jan 12 2009 mge@novell.com
- update to 11.0.0.17
- add support statement
- add version numbers
- text cleanups
* Fri Dec 19 2008 kukuk@suse.de
- Remove old entry about MD/iSCSI deadlock
* Mon Dec  8 2008 kukuk@suse.de
- Add more packages to technology preview list
* Thu Dec  4 2008 kukuk@suse.de
- Add more info about TPM
- Add know problems about software selection and partitioner
  [bnc#450786]
- Add unsupported VSCSI server support [bnc#433956]
* Tue Nov 25 2008 kukuk@suse.de
- Add patches for POWER [bnc#448547]
* Mon Nov 24 2008 kukuk@suse.de
- Mark biosdevname as Technology Preview
- Incoporate fixes from rf.
* Fri Nov 14 2008 kukuk@suse.de
- Add hint about changed man behavior
* Wed Nov 12 2008 kukuk@suse.de
- Rework iSCSI hints [bnc#443820]
* Fri Nov  7 2008 kukuk@suse.de
- Document network booting issues on POWER [bnc#427960]
* Tue Nov  4 2008 kukuk@suse.de
- Document netconf and Open-FCoE
* Mon Oct 27 2008 kukuk@suse.de
- Merge cleanups from Product Management
* Thu Oct 16 2008 kukuk@suse.de
- Document YaST2 LDAP Server Module changes
* Tue Oct 14 2008 kukuk@suse.de
- Document traceroute over TCP
* Mon Oct 13 2008 kukuk@suse.de
- Fix typos [bnc#433482]
- Remove IPv6 NFS support
- Rework unsupported module section
* Tue Sep 30 2008 kukuk@suse.de
- Document kernel split
* Fri Sep 26 2008 kukuk@suse.de
- Incorporate features collected from presentations
* Fri Sep 19 2008 kukuk@suse.de
- Remove old stuff from SLES9/SLES10
* Wed Sep 10 2008 kukuk@suse.de
- First adjustments for SLES11
* Tue Jul 22 2008 kukuk@suse.de
- Fix Version number
* Mon Jul 21 2008 kukuk@suse.de
- Create dummy Release-Notes
* Tue May 13 2008 kukuk@suse.de
- Fix spelling errors
* Tue May  6 2008 ihno@suse.de
- Added zSeries specific feature describtion and knwon issues
* Wed Apr 30 2008 kukuk@suse.de
- Extend kernel-vmi description
* Tue Apr 29 2008 olh@suse.de
- document missing symlinks in glibc-debuginfo [bnc#374902]
* Thu Apr 24 2008 olh@suse.de
- document HMC hugepage config in POWER [bnc#377163]
* Thu Apr 10 2008 kukuk@suse.de
- Add changes done with RC2
* Mon Mar 31 2008 kukuk@suse.de
- Document problems of HP systems with more than one VGA adapter
  [bnc#366143]
- Document feature of EVMS
- Document end of support for SLES10 SP1
- Document known issues of YaST2 CD-Creator [bnc#363989]
* Thu Mar 20 2008 kukuk@suse.de
- Add changes done with RC1.
* Mon Mar 17 2008 kukuk@suse.de
- Add read-only / tech preview infos
- Update version numbers of kernel drivers
* Mon Mar  3 2008 kukuk@suse.de
- Fix typos
* Fri Feb 22 2008 kukuk@suse.de
- Remove hyperlinks from rtf version [bnc#358477]
* Mon Feb 18 2008 kukuk@suse.de
- Remove duplicate reiserfs entry
- Update known issues on zSeries
* Fri Feb 15 2008 kukuk@suse.de
- Add all new features until Beta2
- Add known System z9 problem.
- Split update problems in general, from SLES9 and SLES10 SP1
  sections.
* Wed Jan 30 2008 kukuk@suse.de
- Add all new features until Beta1
* Tue Jan 22 2008 kukuk@suse.de
- Finish converting old data
* Mon Jan 21 2008 kukuk@suse.de
- Start reworking for new format
* Sun Nov  4 2007 ihno@suse.de
- added snipped for mysql (#282976)
- change of s390-by-id snipped (#276988)
- added snipped about power eha restrictions (#281258)
- added snipped about new sub-device id to support
  PCI-Express icom WAN adapter (#261314)
* Mon Jun 11 2007 ihno@suse.de
- added snipped about minidisks for s390x (#270526)
- added snipped about Matrox Card in ppc system (#265498)
- added snipped about sap (#271832)
- added snipped about installation in textmode for ia64 (#243074)
- added wording for iSCSI on root (#246077)
- added snipped about XFS performance degradation (#277793)
* Tue May 22 2007 ihno@suse.de
- fixed path in relnotes.t.pci_ids
* Wed May 16 2007 ihno@suse.de
- replacing &amp; by & (#274516)
* Thu May 10 2007 ihno@suse.de
- snipped about problem running qla3_xxx and qla4_xx (#271190)
* Fri May  4 2007 ihno@suse.de
- adding snipped about not detected SATA drives for x86_64. (#233281)
* Fri Apr 27 2007 ihno@suse.de
- added snipped about QIOassist for s390x (#245838)
- added snipped about libata for ppc (#246941)
- added snipped about system error -1007 for ia64 (#236404)
- added snipped about hot-add-memory for x86_64 (#248673)
* Mon Apr 23 2007 ihno@suse.de
- Added snipped about
  "Online Update From Behind a Mandatory Proxy Server" for all archs (#207301)
- Added a snipped about tar incompatibility for all archs (#262926)
- Added a snipped on how to create LVM/EVMS volumes on s390x
  with DASDs (#201692)
- Added snipped about "Updating PCI-ID database" for all archs except 390
- Added snipped about "Migration to SP1 with KMPs" for all archs
* Mon Apr  2 2007 ihno@suse.de
-  Ading snipped about dual-core Intel CPUs (#188178)
* Wed Mar 21 2007 ihno@suse.de
- Adding section about SNIPL for s390
- Updating XEN part.
* Tue Feb 20 2007 ihno@suse.de
- Adding section about DASD/zFCP disks for s390x (#160399)
* Tue Feb 20 2007 kukuk@suse.de
- Update XEN section
* Tue Feb 20 2007 ihno@suse.de
- Adding kdump for x86, x86_64, ppc (#185553)
- Adding zvm51 restriction for s390x (#236825)
* Mon Jan 22 2007 ihno@suse.de
- Changed Header to SP1
- replaced XEN section
* Fri Sep 22 2006 ihno@suse.de
- adding relnotes.t.load_unsupported (#189948) for all
- adding relnotes.i.ia64_qlogic (#191100) for ia64
- updated relnotes.i.persistent-devices (#173932)
- updated relnotes.i.zvm_patches_general
* Thu Jul 13 2006 ihno@suse.de
- Corrections for xen
- Corrections from proofreading
- Added snipped about system freeze for i386 and x86_64 (#188921)
- Added snipped about large mem for i586
- Added snipped about mem restriction on x86_64
- Added snipped about realtime Apps for all archs (#175797)
* Wed Jul  5 2006 ihno@suse.de
- Added snipped about xen for i386 and x86_64 (mail from bb)
- Added snippes about hot-add memory for i386 and x86_64 (#186862)
- Added snipped about unsupported OCFS2 on s390 (#159836)
- Adding corrections
* Mon Jul  3 2006 ihno@suse.de
- Added snipped about LVM Names for root (#184567)
* Tue Jun 20 2006 ihno@suse.de
- Added snipped about scheduler tuning (#176738)
* Tue Jun 20 2006 kukuk@suse.de
- Fix duplicates in cryptoloop. [#186572]
* Mon Jun 19 2006 ihno@suse.de
- Adding snipped with link to developerworks
* Fri Jun 16 2006 kukuk@suse.de
- Document iSCSI and SAN issues
* Tue Jun 13 2006 ihno@suse.de
- adding snipped about preventing of loading from drivers (#160304)
* Thu Jun  1 2006 ihno@suse.de
- corrected scheduler snipped on how to set scheduler
- adding s390 specific snipped on scheduler
- adding snipped about white spaces in parmfiles (#176095)
- adding snipped about the restriction when using cpint/hcp (#81839)
- adding snipped about libhugetlbfs (#142046)
- adding snipped about using persistent devices names (#148931)
- adding snipped about EVMS and iSCSI apon request of Todd Grant
* Sat May 20 2006 ihno@suse.de
- Modify ctc_iucv snipped from Interfaces to IP interfaces.
- Added snipped about use_edd signature (#82867)
* Fri May 19 2006 kukuk@suse.de
- Really remove jfs for ia64
* Wed May 17 2006 kukuk@suse.de
- Document mount by UUID/LABEL [#176201]
* Tue May 16 2006 kukuk@suse.de
- Document multipath with dm and on /
* Tue May  9 2006 kukuk@suse.de
- Fix typo in update part
- Add ulimit section
* Mon May  8 2006 kukuk@suse.de
- Fix typo in scheduler part [#172502]
* Mon May  8 2006 kukuk@suse.de
- No jfs on IA64 at all
* Wed May  3 2006 kukuk@suse.de
- Fix conf error
* Tue May  2 2006 kukuk@suse.de
- Remove Beta Tag
* Thu Apr 27 2006 kukuk@suse.de
- Add snipped about vsftpd and xinetd [#169517]
* Wed Apr 26 2006 ihno@suse.de
- Adding snipped about supported Update-paths
* Wed Apr 26 2006 ihno@suse.de
- removed PCMCIA-snipped for S390
- extended AppArmor snipped.
- added snipped about I/O-scheduler (#168244)
- added snipped about withiscsi-parameter (#167975)
* Wed Apr 12 2006 kukuk@suse.de
- For Beta10
* Fri Apr  7 2006 ihno@suse.de
- Adding snipped about deprecatet mapped-base
- Adding snipped about deprecatet s390 ctc/escon/iucv interfaces
* Sun Mar 26 2006 ro@suse.de
- fix release-notes.conf
* Fri Mar 24 2006 ihno@suse.de
- Adding two snippets about need z/VM-patches
* Tue Mar 14 2006 kukuk@suse.de
- Fix product name in all places
* Fri Mar 10 2006 kukuk@suse.de
- Remove text about kernel debug options
- Prepare for Beta8
* Mon Mar  6 2006 kukuk@suse.de
- Prepare for Beta7
* Mon Feb 27 2006 kukuk@suse.de
- Beta6
- Add URL for php4->php5 migration
* Fri Feb 17 2006 kukuk@suse.de
- Remove obsolete sync comments
- Beta5
* Wed Feb 15 2006 kukuk@suse.de
- For Beta4
* Tue Feb 14 2006 kukuk@suse.de
- Document console number change on ia64 [#149700]
* Thu Feb  9 2006 kukuk@suse.de
- Add hint about LD_ASSUME_KERNEL
* Mon Jan 30 2006 kukuk@suse.de
- Remove hack, we need to fix YaST2 now.
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 25 2006 kukuk@suse.de
- Add Hack for YaST2 to display release-notes in Beta2
* Tue Jan 24 2006 kukuk@suse.de
- Add hints about KDB
* Mon Jan 23 2006 kukuk@suse.de
- Add hint about kernel debug options enabled
- Add Beta2
* Thu Jan 19 2006 kukuk@suse.de
- Fix path to AppAmor documentation
- Move docu to SLES subdirectory
* Tue Jan 17 2006 kukuk@suse.de
- Provide/Obsolete release-notes
* Mon Jan 16 2006 kukuk@suse.de
- Initial version for SLES10 Beta1
