#
# spec file for package lshw
#
# Copyright (c) 2024 SUSE LLC
# Copyright (c) 2013 Pascal Bleser <pascal.bleser@opensuse.org>
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


Name:           lshw
Version:        B.02.20
Release:        150200.3.18.2
Summary:        HardWare LiSter
License:        GPL-2.0-only
URL:            https://www.ezix.org/project/wiki/HardwareLiSter
Source:         lshw-%{version}.tar.gz
Source1:        lshw.desktop.in
Source2:        lshw.png
BuildRequires:  gcc-c++
BuildRequires:  hicolor-icon-theme
BuildRequires:  libpng-devel
BuildRequires:  pkgconfig
BuildRequires:  update-desktop-files
BuildRequires:  pkgconfig(gtk+-3.0)
Recommends:     hwdata
%lang_package

%description
lshw (Hardware Lister) is a small tool to provide detailed informaton on the
hardware configuration of the machine. It can report exact memory
configuration, firmware version, mainboard configuration, CPU version and
speed, cache config uration, bus speed, etc. on DMI-capable x86 systems and
on some PowerPC machines (PowerMac G4 is known to work).

Information can be output in plain text, XML or HTML.

For detailed information on lshw features and usage, please see the
included documentation or go to the lshw Web page,
http://www.ezix.org/software/lshw.html

%package gui
Summary:        HardWare LiSter (GUI Frontend)
Group:          Hardware/Other
Requires:       %{name} = %{version}-%{release}
Requires:       hicolor-icon-theme
Requires(post): hicolor-icon-theme
Requires(post): update-desktop-files
Requires(postun): hicolor-icon-theme
Requires(postun): update-desktop-files

%description gui
lshw (Hardware Lister) is a small tool to provide detailed informaton on the
hardware configuration of the machine. It can report exact memory
configuration, firmware version, mainboard configuration, CPU version and
speed, cache config uration, bus speed, etc. on DMI-capable x86 systems and
on some PowerPC machines (PowerMac G4 is known to work).

This package provides a graphical user interface to display hardware
information.

For detailed information on lshw features and usage, please see the
included documentation or go to the lshw Web page,
http://www.ezix.org/software/lshw.html

%prep
%autosetup

%build

%make_build \
  SBINDIR="%{_sbindir}" \
  RPM_OPT_FLAGS="%{optflags} -fno-strict-aliasing" \
  STRIP=touch \
  VERSION="%{version}" \
  all gui \
  --jobs=1

%install
%make_install install-gui VERSION="%{version}"

install -d "%{buildroot}%{_datadir}/applications"
sed 's,@@EXEC@@,%{_sbindir}/gtk-lshw,g' < "%{SOURCE1}" \
    > "%{buildroot}%{_datadir}/applications/%{name}.desktop"
chmod 0644 "%{buildroot}%{_datadir}/applications/%{name}.desktop"
install -D -p -m 0644 %{SOURCE2} \
  %{buildroot}%{_datadir}/pixmaps/%{name}.png

%suse_update_desktop_file -r "%{name}" System HardwareSettings
# All of following are shipped by other packages as well
rm -f %{buildroot}%{_datadir}/%{name}/pci.ids
rm -f %{buildroot}%{_datadir}/%{name}/usb.ids
rm -f %{buildroot}%{_datadir}/%{name}/pnp.ids
rm -f %{buildroot}%{_datadir}/%{name}/oui.txt
rm -f %{buildroot}%{_datadir}/%{name}/manuf.txt
rm -f %{buildroot}%{_datadir}/%{name}/pnpid.txt

%find_lang lshw

%files
%defattr(-,root,root,0755)
%license COPYING
%doc README.md docs/TODO docs/Changelog docs/lshw.xsd
%attr(0755,root,root) %{_sbindir}/lshw
%dir %{_datadir}/lshw
%{_mandir}/man1/lshw.1%{?ext_man}

%files lang -f %{name}.lang

%files gui
%defattr(-,root,root,0755)
%license COPYING
%attr(0755,root,root) %{_sbindir}/gtk-lshw
%{_datadir}/lshw/artwork
%{_datadir}/lshw/ui
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png

%changelog
* Tue Feb 13 2024 mpluskal@suse.com
- Update to version B.02.20 (jsc#9912):
  * update changelog
  * update data files
  * get rid of GTK deprecation warning
  * get rid of some snprintf warnings
  * Add support for 100Gbit interfaces
* Tue Nov 28 2023 mpluskal@suse.com
- Update to version B.02.19.2+git.20231115:
  * merge github PR #98
* Thu Mar 23 2023 mpluskal@suse.com
- Update to version B.02.19.2+git.20230320 (bsc#1209531):
  * fix NVMe multipath detection
  * NVMe: fix logical name with native multipath
* Thu Nov 24 2022 mpluskal@suse.com
- Update to version B.02.19.2+git.20220831:
  * PA-RISC: handle pushd failure
* Tue Jul 26 2022 mpluskal@suse.com
- Update to version B.02.19.2+git.20220628 (jsc#526):
  * make version check optional
* Mon Mar 28 2022 mpluskal@suse.com
- Update to version B.02.19.2+git.20220310:
  * Github PR85  Set product name for all netdevs sharing the same PCI number
* Fri Jan 21 2022 mpluskal@suse.com
- Update to version B.02.19.2+git.20211222:
  * Add Spanish translation
  * Fix mistakes in Catalan translation
* Thu Nov 11 2021 mpluskal@suse.com
- Update to version B.02.19.2+git.20211102:
  * merge Github PR#77
  * use max (9) Gzip compression
  * Add Catalan translation
  * Update POT file
  * Add more network speeds
* Thu Oct 14 2021 mpluskal@suse.com
- Update to version B.02.19.2+git.20211013:
  * add some includes
  * fix typo
  * cosmetic fixes
  * support for new ethtool capabilities
  * code clean-up
  * code clean-up
  * allow pkg-config override
  * allow pkg-config override
  * Remove unnecessary space before closing parenthesis
  * Translate all words of a phrase together
  * Fix another typo
* Wed Aug  4 2021 mpluskal@suse.com
- Update versioning to to allow easy transition on SLE
- Disable parallel build to avoid random failures
* Thu Jun 24 2021 mpluskal@suse.com
- Update to version B.02.19+git.20210619:
  * Fix typos in translatable messages
- jsc#SLE-19399
* Wed May 26 2021 mpluskal@suse.com
- Update to version B.02.19+git.20210429:
  * Fix getting size of memory banks <32GiB
  * devtree: Add UUID property
  * code clean-up
  * improve portability (esp. musl)
  * fix potential crash
  * add static target to Makefile
  * Avoid crash on device-tree parsing
  * Add JEDEC manufacturer
  * Report correct memory size on SMBIOS < 2.7
  * fix man page after previous update
- Drop no longer needed patches:
  * lshw-fix-segfault-in-apfs-volume-code.patch
  * lshw-fix-mmc.patch
  * lshw-fix-ppc.patch
  * lshw-devtree-Add-UUID-property.patch
* Tue Jan 26 2021 msuchanek@suse.de
- Display UUID on Power VM LPAR (bsc#1181411 ltc#191040)
  * lshw-devtree-Add-UUID-property.patch
* Mon Aug 31 2020 mpluskal@suse.com
- Fix detection of ppc products - boo#1172156
  * lshw-fix-ppc.patch
* Fri Apr 24 2020 guillaume.gardet@opensuse.org
- Reenable LTO for powerpc and aarch64
- Fix PowerPC and aarch64 LTO: boo#1168865 and boo#1169668
  * lshw-fix-segfault-in-apfs-volume-code.patch
- Fix aarch64 SIGABRT: (boo#1169668)
  * lshw-fix-mmc.patch
* Thu Apr 23 2020 normand@linux.vnet.ibm.com
- Disable LTO for aarch64 & PowerPC, bypass boo#1168865
* Mon Mar 30 2020 mpluskal@suse.com
- Update to version B.02.19.2:
  * New release tagged, no significant changes from previous
    version (git snapsho)
- Drop no longer needed patches:
  * lshw-display-latest-version.patch
  * lshw-add-notime-option-to-manpage.patch
  * lshw-nvme.patch
* Mon Mar 16 2020 mpluskal@suse.com
- Update to version B.02.18+git.20191228:
  * fix #755: handle invalid FAT
  * code clean-up
  * volumes: Add support for detecting Apple APFS fstype
  * partitions: Add Apple APFS GUID
  * specfile: Fix version issue
  * Do not show modified time with -notime option
  * Update help message and man page
- Drop upstreamed patches:
  * lshw-help-man.patch
  * lshw-modified-time.patch
- Add lshw-nvme.patch to support nvme devices bsc#1161323
* Thu Feb 20 2020 mpluskal@suse.com
- Disable LTO as it causes random build failures on some
  architectures (bsc#1164297)
* Fri Feb  7 2020 bjorn.lie@gmail.com
- No longer recommend -lang: supplements are in use.
* Wed Feb  5 2020 mpluskal@suse.com
- Fix bsc#1162690:
  * lshw-add-notime-option-to-manpage.patch
* Thu Oct 24 2019 mpluskal@suse.com
- Update to version B.02.18+git.20190613 (fate#326432 jsc#SLE-7715):
  * devtree: Add DIMM running speed
  * spd: Print dimm rank information
  * Display proper logical name of network device
- Drop no longer needed lswh-logical-name-iface.patch
* Thu May  2 2019 mpluskal@suse.com
- Fix displaying proper logical name of network device bsc#1133923
  * lswh-logical-name-iface.patch
- Fix displaying correct version bsc##1130818
  * lshw-display-latest-version.patch
  * lshw-help-man.patch
  * lshw-modified-time.patch
* Thu Mar 28 2019 mpluskal@suse.com
- Update to version B.02.18+git.20190324:
  * merge Github PR44
- Set correct version (bsc#1130818)
* Mon Jan  7 2019 mpluskal@suse.com
- Update to version B.02.18+git.20190104:
  * Resolves bsc#1120819 bsc#1093650 fate#326432
  * various new HW enablement, including:
    + improved support for latest PPC64LE
    + DDR4
- Drop no longer needed patches:
  * lshw-cpuinfo.patch
  * lshw-devtree_cpunodes.patch
  * lshw-devtree_machine_describtion.patch
  * lshw-dimminfo.patch
* Wed Feb  7 2018 mpluskal@suse.com
- Drop not needed post macros
- Add ppc enablement patches (bsc#1079846):
  * lshw-cpuinfo.patch
  * lshw-devtree_cpunodes.patch
  * lshw-devtree_machine_describtion.patch
  * lshw-dimminfo.patch
* Tue May 30 2017 mpluskal@suse.com
- Recommend hwdata
* Tue May  2 2017 mpluskal@suse.com
- Simplify dependencies and build
- Split lang subpackage
- Prepare for SLE submission (fate#322439)
* Mon Jun 20 2016 mpluskal@suse.com
- Small spec file cleanup
- Do not ship pci/usb/oter id's as they are provided by other
  packages as well
- Disable parallel building as it seems to cause random linking
  failures (boo#985111)
* Tue Apr 26 2016 mpluskal@suse.com
- Update to B.02.18
  * no changelog available
- Use pkgconfig style dependencies
- Update dependencies
- Build gui and cli at same time
- Drop no longer needed patches
  * lshw-gcc43.patch
  * lshw-stack-corruption.patch
* Fri Jul 24 2015 mpluskal@suse.com
- Cleanup spec file with spec-cleaner
- Unconditionally build gui
- Use proper scriplets for desktop files/icons
- Update license information
* Wed Oct 16 2013 xrigou@otenet.gr
- Add a patch for a stack curruption introduced in B.02.17 and fixed
  upstream (ticket #632)
* Tue Aug  6 2013 pascal.bleser@opensuse.org
- update to B.02.17 (no detailed changelog available, minor bug fixes)
* Wed Jan 11 2012 pascal.bleser@opensuse.org
- update to B.02.16:
  * bug fixes
  * code cleanup
  * improved support for GPT-partitioned disks
  * report physical sector size of hard disks
  * rewrote GTK2 GUI for increased flexibility (use external UI file)
  * updated data files
* Wed Oct  6 2010 pascal.bleser@opensuse.org
- update to B.02.15:
  * adds experimental support for dumping information into an SQLite database
  * a French localization was added
  * a number of bugs were fixed
* Wed Jun 16 2010 pascal.bleser@opensuse.org
- rework patch for Factory (with 0 fuzz)
- repackage upstream tarball as .tar.bz2
* Sat Feb 14 2009 guru@unixtech.be
- update to B.02.14:
  * fixes several bugs that caused lshw to hang while scanning the system
  * improves portability
  * adds support for detection of EXT4 volumes
* Sun May 11 2008 guru@unixtech.be
- moved to openSUSE Build Service
- new upstream version
* Sun Oct 14 2007 guru@unixtech.be
- new upstream version
* Wed Oct 10 2007 guru@unixtech.be
- moved to Packman
- new upstream version
* Wed Nov  8 2006 guru@unixtech.be
- new upstream version
* Wed May 10 2006 guru@unixtech.be
- added binary stripping on SUSE < 9.3
- replaced /usr/share with _datadir
- removed Packager and Distribution, injected by rpmmacros
- new upstream version
* Sun Mar  5 2006 guru@unixtech.be
- new package
