#
# spec file for package mozilla-nspr
#
# Copyright (c) 2025 SUSE LLC
#               2006-2025 Wolfgang Rosenauer
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define useccache     1

Name:           mozilla-nspr
Version:        4.36
Release:        150000.3.32.1
Summary:        Netscape Portable Runtime
License:        MPL-2.0
Group:          System/Libraries
URL:            http://www.mozilla.org/projects/nspr/
BuildRequires:  gcc-c++
BuildRequires:  pkg-config
%if 0%{useccache} != 0
BuildRequires:  ccache
%endif
# bug437293
%ifarch ppc64
Obsoletes:      mozilla-nspr-64bit
%endif
#
Source:         https://ftp.mozilla.org/pub/nspr/releases/v%{version}/src/nspr-%{version}.tar.gz
Source1:        baselibs.conf
Source99:       %{name}.changes
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
NSPR provides platform independence for non-GUI operating system
facilities. These facilities include threads, thread synchronization,
normal file and network I/O, interval timing and calendar time, basic
memory management (malloc and free), and shared library linking.

%package devel
Summary:        Netscape Portable Runtime development files
Group:          Development/Libraries/Other
Requires:       mozilla-nspr = %{version}
# bug437293
%ifarch ppc64
Obsoletes:      mozilla-nspr-devel-64bit
%endif
#

%description devel
NSPR provides platform independence for non-GUI operating system
facilities. These facilities include threads, thread synchronization,
normal file and network I/O, interval timing and calendar time, basic
memory management (malloc and free), and shared library linking.

%prep
%setup -n nspr-%{version} -q

%build
%global _lto_cflags %{_lto_cflags} -ffat-lto-objects
pushd nspr
# set buildtime to "last-modification-time"
modified="$(sed -n '/^----/n;s/ - .*$//;p;q' "%{S:99}")"
BUILD_STRING="$(date -u -d "${modified}" "+%%F %%T")"
BUILD_TIME="$(date -u -d "${modified}" "+%%s000000")"
#
export CFLAGS="%{optflags}"
./configure --enable-optimize="$CFLAGS" \
            --disable-debug \
%ifarch x86_64
	    --enable-64bit \
%endif
	    --libdir=%{_libdir} \
	    --includedir=%{_includedir}/nspr4 \
%if 0%{useccache} != 0
	    --with-ccache \
%endif
	    --prefix=%{_prefix}
make SH_DATE="$BUILD_STRING" SH_NOW="$BUILD_TIME" %{?_smp_mflags}
popd

%install
pushd nspr
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_libdir}/nspr
mkdir -p %{buildroot}%{_libdir}/pkgconfig
mkdir -p %{buildroot}%{_includedir}/nspr4
cp config/nspr-config %{buildroot}%{_bindir}/
cp config/nspr.pc %{buildroot}%{_libdir}/pkgconfig
cp -L dist/lib/*.so %{buildroot}%{_libdir}
cp -L dist/lib/*.a  %{buildroot}%{_libdir}/nspr/
cp -rL dist/include/nspr/* %{buildroot}%{_includedir}/nspr4/
# #31667
chmod -x %{buildroot}%{_includedir}/nspr4/prvrsion.h
popd

%check
cd nspr
# Run test suite
perl ./pr/tests/runtests.pl 2>&1 | tee output.log
TEST_FAILURES=`grep -c FAILED ./output.log` || :
if [ $TEST_FAILURES -ne 0 ]; then
  echo "error: test suite returned failure(s)"
  exit 1
fi
echo "test suite completed"

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_libdir}/*.so

%files devel
%defattr(-, root, root)
%{_bindir}/nspr-config
%{_libdir}/pkgconfig/nspr.pc
%{_includedir}/nspr4/
%exclude %{_includedir}/nspr4/md/*
%{_libdir}/nspr/

%changelog
* Mon Nov 25 2024 wr@rosenauer.org
- update to version 4.36
  * remove support for OS/2
  * remove support for Unixware, Bsdi, old AIX, old HPUX9 & scoos
  * remove support for Windows 16 bit
  * renamed the prwin16.h header to prwin.h
  * configure was updated from 2.69 to 2.71
  * various build, test and automation script fixes
  * major parts of the source code were reformatted
* Sun Oct 16 2022 wr@rosenauer.org
- update to version 4.35
  * fixes for building with clang
  * use the number of online processors for the
    PR_GetNumberOfProcessors() API on some platforms
  * fix build on mips+musl libc
  * Add support for the LoongArch 64-bit architecture
* Wed Aug 10 2022 martin.sirringhaus@suse.com
- update to version 4.34.1
  * add file descriptor sanity checks in the NSPR poll function.
* Sun May 29 2022 wr@rosenauer.org
- update to version 4.34
  * add an API that returns a preferred loopback IP on hosts that
    have two IP stacks available.
* Wed Dec 29 2021 andreas.stieger@gmx.de
- update to 4.33:
  * fixes to build system and export of private symbols
* Mon Jul 26 2021 martin.sirringhaus@suse.com
- update to version 4.32:
  * implement new socket option PR_SockOpt_DontFrag
  * support larger DNS records by increasing the default buffer
    size for DNS queries
* Thu May 27 2021 andreas.stieger@gmx.de
- update to version 4.31:
  * Lock access to PRCallOnceType members in PR_CallOnce* for
    thread safety bmo#1686138
* Sun Apr 18 2021 wr@rosenauer.org
- update to version 4.30
  * support longer thread names on macOS
  * fix a build failure on OpenBSD
* Wed Sep 30 2020 wr@rosenauer.org
- update to version 4.29
  * Remove macOS Code Fragment Manager support code
  * Remove XP_MACOSX and OS_TARGET=MacOSX
  * Refresh config.guess and config.sub
  * Remove NSPR's patch to config.sub
  * Add support for e2k target (64-bit Elbrus 2000)
* Tue Sep  8 2020 wr@rosenauer.org
- update to version 4.28
  * Fix a compiler warning
  * Add rule for cross-compiling with cygwin
* Sat Aug 22 2020 wr@rosenauer.org
- update to version 4.27
  * the macOS platform code for shared library loading was
    changed to support macOS 11.
    If the absolute path parameter given to PR_LoadLibrary
    begins with either /System/ or /usr/lib/ then no test is
    performed if the library exists at a file.
  * An include statement for a Windows system library header
    was added
* Thu Jul 23 2020 wr@rosenauer.org
- update to version 4.26
  * PR_GetSystemInfo supports a new flag PR_SI_RELEASE_BUILD to get
    information about the operating system build version.
  * Better support parallel building on Windows.
  * The internal release automatic script requires python 3.
* Tue Mar  3 2020 wr@rosenauer.org
- update to version 4.25
  * fixed reading files larger than 4 GB on Win32
  * added support for Xtensa architecture
* Wed Jan 15 2020 martin.sirringhaus@suse.com
- update to version 4.24
  * added macro PR_ASSERT_ARG
  * removed some declarations
  * added support for Nios-II, Nds32 and Microblaze architectures
* Wed Dec  4 2019 martin.sirringhaus@suse.com
- update to version 4.23
  * fixed a build failure that was introduced in 4.22
  * correctness fix for Win64 socket polling
  * whitespace in C files was cleaned up and no longer uses
    tab characters for indenting
- update to version 4.22
  * added support for the ARC architecture
  * removed support for the following platforms:
    OSF1/Tru64, DGUX, IRIX, Symbian, BeOS
  * correctness and build fixes
* Fri Nov 22 2019 cgrobertson@suse.com
- Use FAT LTO objects in order to provide proper static library
* Mon Jul 15 2019 martin.sirringhaus@suse.com
- update to version 4.21
  * Use MAP_SHARED for read-only file mappings on MacOS and
    Android.
  * Changed prbit.h to use builtin function on aarch64.
  * Test program build fixes.
  * Minor fixes to support unified builds.
  * Update library copyright notices.
  * Removed Gonk/B2G references.
* Mon Oct 29 2018 alarrosa@suse.com
- update to version 4.20
  * abstract socket address support for Linux (incl. Android)
  * aarch64 support for Windows
  * support for riscv64
* Thu Mar 15 2018 cgrobertson@suse.com
- update to version 4.19
  * changed order of shutdown cleanup to avoid a crash on Mac OSX
  * build compatibility with Android NDK r16 and glibc 2.26
* Wed Feb  7 2018 wr@rosenauer.org
- update to version 4.18
  * removed HP-UX DCE threads support
  * improvements for the Windows implementation of PR_SetCurrentThreadName
  * fixes for the Windows implementation of TCP Fast Open
* Sun Oct  1 2017 wr@rosenauer.org
- update to version 4.17
  * changes to the Windows implementation of the networking code
    required for Firefox 57
  * a FreeBSD build fix (bmo#1391716)
* Tue Sep 12 2017 wr@rosenauer.org
- update to version 4.16
  * contains various correctness fixes
    see
    https://bugzilla.mozilla.org/buglist.cgi?resolution=FIXED&query_format=advanced&product=NSPR&target_milestone=4.16
    for details
* Sat Aug  5 2017 wr@rosenauer.org
- update to version 4.15
  * added TCP Fast Open functionality
  * various correctness fixes
* Wed Apr 26 2017 wr@rosenauer.org
- update to version 4.14
  * a socket without PR_NSPR_IO_LAYER will no longer trigger
    an assertion when polling
  * the PRNetAddr structure has been extended on Windows (bmo#1313612)
  * allow sending a zero size UDP message on Windows (bmo#1331810)
* Wed Jan 18 2017 wr@rosenauer.org
- update to version 4.13.1
  * The previously released version 4.13 had changed pipes to be
    nonblocking by default, and as a consequence, PollEvent was changed
    to not block on clear.
    The NSPR development team received reports that these changes
    caused regressions in some applications that use NSPR, and it
    has been decided to revert the changes made in NSPR 4.13.
    NSPR 4.13.1 restores the traditional behavior of pipes and PollEvent.
- update to version 4.13
  NSPR 4.13 has the following bug fixes:
  * PL_strcmp (and others) were fixed to return consistent results
    when one of the arguments is NULL.
  * PollEvent was fixed to not block on clear.
  * Pipes are always nonblocking.
  * PR_GetNameForIdentity: added thread safety lock and bound checks.
  * Removed the PLArena freelist.
  * Avoid some integer overflows.
  * fixed several comments.
* Thu Nov 17 2016 schwab@suse.de
- Properly run testsuite
* Mon Feb 29 2016 wr@rosenauer.org
- update to version 4.12
  * added a PR_GetEnvSecure function, which attempts to detect if
    the program is being executed with elevated privileges, and
    returns NULL if detected. It is recommended to use this function
    in general purpose library code.
  * fixed a memory allocation bug related to the PR_*printf functions
  * exported API PR_DuplicateEnvironment, which had already been
    added in NSPR 4.10.9
  * added support for FreeBSD aarch64
  * several minor correctness and compatibility fixes
* Sat Dec 19 2015 wr@rosenauer.org
- update to version 4.11
  * Enable atomic instructions on mips (bmo#1129878)
  * Fix mips assertion failure when creating thread with custom
    stack size (bmo#1129968)
* Sun Oct 25 2015 wr@rosenauer.org
- update to version 4.10.10 (bnc#952810)
  * MFSA 2015-133/CVE-2015-7183 (bmo#1205157)
    memory corruption issues
* Fri Aug 21 2015 wr@rosenauer.org
- update to version 4.10.9
  * bmo#1021167: Leak of |poll_list| on failure in _MW_PollInternal
  * bmo#1030692: Make compiling nspr on windows possible again.
  * bmo#1088790: dosprint() doesn't support %%zu and other size formats
  * bmo#1130787: prtime.h does not compile with MSVC's /Za (ISO C/C++
    conformance) option
  * bmo#1153610: MIPS64: Add support for n64 ABI
  * bmo#1156029: Teach clang-analyzer about PR_ASSERT
  * bmo#1160125: MSVC version detection is broken CC is set to a wrapper
    (like sccache)
  * bmo#1163346: Add NSPR support for FreeBSD mips/mips64
  * bmo#1169185: Add support for OpenRISC (or1k)
  * bmo:1174749: Remove configure block for iOS that uses MACOS_SDK_DIR
  * bmo#1174781: PR_GetInheritedFD can use uninitialized variables
* Wed Feb  4 2015 coolo@suse.com
- add the changes file as source so the .src.rpm builds (used for
  fake build time)
* Thu Jan 29 2015 wr@rosenauer.org
- update to version 4.10.8
  * bmo#573192: remove the stack-based PRFileDesc cache.
  * bmo#756047: check for _POSIX_THREAD_PRIORITY_SCHEDULING > 0 instead
    of only checking if the identifier is defined.
  * bmo#782113: Add NSPR support for FreeBSD ppc/ppc64/arm.
  * bmo#782124: Implement PR_GetPhysicalMemorySize on FreeBSD/DragonFly.
  * bmo#1060292: Make PR_Assert() and PR_Abort() output visible in the
    logcat on Android.
  * bmo#1089908: Fix variable shadowing in _PR_MD_LOCKFILE. Use
    PR_ARRAY_SIZE to get the array size of _PR_RUNQ(t->cpu).
  * bmo#1105144: Two places in NSPR's pruthr.c cast a pointer to long,
    which isn't correct on 64-bit Windows.
  * bmo#1060401: change import library name under mingw.
  * bmo#1106600: Replace PR_ASSERT(!"foo") with PR_NOT_REACHED("foo") t
    fix clang -Wstring-conversion warnings.
  * bmo#1107063: link NSPR libs with -soname on OpenBSD.
  * bmo#1120772: Avoid defining snprintf when MSVC provides it.
* Fri Aug 29 2014 wr@rosenauer.org
- update to version 4.10.7
  * bmo#836658: VC11+ defaults to SSE2 builds by default.
  * bmo#979278: TSan: data race nsprpub/pr/src/threads/prtpd.c:103
    PR_NewThreadPrivateIndex.
  * bmo#1026129: Replace some manual declarations of MSVC intrinsics with
    [#]include <intrin.h>.
  * bmo#1026469: Use AC_CHECK_LIB instead of MOZ_CHECK_PTHREADS. Skip
    compiler checks when using MSVC, even when $CC is
    not literally "cl".
  * bmo#1034415: NSPR hardcodes the C compiler to cl on Windows.
  * bmo#1042408: Compilation fix for Android > API level 19.
  * bmo#1043082: NSPR's build system hardcodes -MD.
* Tue Jun 10 2014 wr@rosenauer.org
- update to version 4.10.6 (bnc#881874)
  * requirement for Firefox 30
  * PR_GetPhysicalMemorySize should release the mach_host_self()
    Mach port when done with it (bmo#1009270)
  * "Network address type not supported" error on the Hurd (bmo#1011861)
  * Clang Static Analysis: useless declaration in NSPR (bmo#1003946)
  * OOB write with sprintf and console functions (bmo#1018783)
    (CVE-2014-1545)
* Wed May  7 2014 wr@rosenauer.org
- update to version 4.10.5
  * autoconf updates
  * PPC64LE support
- dropped obsolete nspr-ppc64le.patch
* Mon Mar 10 2014 wr@rosenauer.org
- update to version 4.10.4
  * bmo#767759: Add support for new x32 abi
  * bmo#844784: Thread data race in PR_EnterMonitor
  * bmo#939786: data race nsprpub/pr/src/pthreads/ptthread.c:137 _pt_root
  * bmo#958796: Users of _beginthreadex that set a custom stack size
    may not be getting the behavior they want
  * bmo#963033: AArch64 support update for NSPR
  * bmo#969061:	Incorrect end-of-list test when iterating over a
    PRCList in prcountr.c and prtrace.c
  * bmo#971152: IPv6 detection on linux depends on availability of
    /proc/net/if_inet6
* Mon Mar  3 2014 ro@suse.de
- drop patch config-guess-sub-update.diff
  config.guess and config.sub are updated by the ppc64le patch
* Fri Feb 28 2014 pcerny@suse.com
- update of the PowerPC 64 LE support patch
  (renamed ppc64le-support.patch to nspr-ppc64le.patch)
* Thu Feb  6 2014 wr@rosenauer.org
- update to version 4.10.3
  * bmo#749849: ensure we'll free the thread-specific data key.
  * bmo#941461: don't compile android with unaligned memory access.
  * bmo#932398: Add PR_SyncMemMap, a portable version of
    msync/FlushViewOfFile.
  * bmo#952621: Fix a thread-unsafe access to lock->owner in PR_Lock.
  * bmo#957458: Fix several bugs in the lock rank checking code.
  * bmo#936320: Use an alternative test for IPv6 support on Linux to
    avoid opening a socket.
* Thu Dec 12 2013 uweigand@de.ibm.com
- Add ppc64le-support.patch:
  * add support for powerpc64le-linux
* Mon Nov 11 2013 wr@rosenauer.org
- update to version 4.10.2
  relevant changes
  * bmo#770534: possible pointer overflow in PL_ArenaAllocate()
  * bmo#888546: ptio.c:PR_ImportUDPSocket doesn't work
* Sun Sep 22 2013 wr@rosenauer.org
- update to version 4.10.1
  * bmo#888273: RWIN Scaling (RFC1323) limited to 2 on Windows 7 and 8
    (Windows only)
  * bmo#907512: Unix platforms shouldn't mask errors specific to
    Unix domain sockets
* Sun Jun  9 2013 wr@rosenauer.org
- update to version 4.10
  * bmo#844513: Add AddressSanitizer (ASan) memory check annotations to
    PLArena.
  * bmo#849089: Simple changes to make NSPR's configure.in work with
    the current version of autoconf.
  * bmo#856196: Fix compiler warnings and clean up code in NSPR 4.10.
  * bmo#859066: Fix warning in nsprpub/pr/src/misc/prnetdb.c.
  * bmo#859830: Deprecate ANDROID_VERSION in favor of android/api-level.h.
  * bmo#861434: Make PR_SetThreadPriority() change priorities
    relatively to the main process instead of using absolute values on
    Linux.
  * bmo#871064L: _PR_InitThreads() should not call PR_SetThreadPriority.
* Sat Mar 16 2013 wr@rosenauer.org
- update to version 4.9.6
  * aarch64 support
    (removed obsolete aarch64-support.patch)
  * added PL_SizeOfArenaPoolExcludingPool function (bmo#807883)
  * Auto detect android api version for x86 (bmo#782214)
  * Initialize Windows CRITICAL_SECTIONs without debug info and
    with nonzero spin count (bmo#812085)
* Thu Feb 28 2013 wr@rosenauer.org
- update to version 4.9.5
  * bmo#634793: define NSPR's exact-width integer types PRInt{N} and
    PRUint{N} types to match the <stdint.h> exact-width integer types
    int{N}_t and uint{N}_t.
  * bmo#782815: passing 'int *' to parameter of type 'unsigned int *'
    in setsockopt().
  * bmo#822932: Port bmo#802527 (NDK r8b support for x86) to NSPR.
  * bmo#824742: NSPR shouldn't require librt on Android.
  * bmo#831793: data race on lib->refCount in PR_UnloadLibrary.
* Thu Feb 28 2013 dmueller@suse.com
- Add config-guess-sub-update.diff:
  * update config.guess/sub for aarch64 support
- Add aarch64-support.patch:
  * add support for aarch64
* Fri Nov 30 2012 wr@rosenauer.org
- update to version 4.9.4
  * bmo#757593: PR_IntervalNow not monotonic for Android, Linux,
    Mac OS X.
  * bmo#804806: Remove support for obsolete platforms (ncr, nec,
    sony, nextstep, sinix/reliantunix, and sunos4).
  * bmo#804833: Allow PR_FormatTime and PR_FormatTimeUSEnglish with
    NO_NSPR_10_SUPPORT. Fixed by Isaac Aggrey.
* Thu Oct 25 2012 wr@rosenauer.org
- update to version 4.9.3
  * bmo#749849: NSPR pthread_key_t leak and memory corruption.
  * bmo#794316: PR_PushIOLayer doesn't push layer on the top correctly
  * bmo#795213: clang's -Wtautological-constant-out-of-range-compare
    warns on prnetdb.c
* Tue Jul 24 2012 wr@rosenauer.org
- update to version 4.9.2
  * new PR_SetThreadName and PR_GetThreadName functions for setting
    and getting the name of the *current thread*
* Fri Jun  1 2012 wr@rosenauer.org
- update to version 4.9.1
  * Android fixes
  * pkgconfig file included (removed our patch)
  * added Hurd support
  * honor EHOSTDOWN
  * a few smaller fixes
- license change from tri-license to MPL-2.0
* Thu Feb 16 2012 wr@rosenauer.org
- update to version 4.9
- added testsuite in %%check
* Wed Sep 21 2011 wr@rosenauer.org
- some spec file cleanup
- override the build time detection and use the last change time
  instead to incorporate into the build
* Fri Aug 12 2011 wr@rosenauer.org
- update to 4.8.9 RTM
  * no release notes available from upstream
* Thu May 19 2011 wr@rosenauer.org
- update to 4.8.8 RTM
  * minor cleanup changes
  * minor changes not affecting the Linux platform
* Thu Apr 28 2011 wr@rosenauer.org
- update to 4.8.8beta3
  * support IPv6 on Android (bmo#626866)
  * use AI_ADDRCONFIG for loopback hostnames (bmo#614526)
  * support SDP sockets (bmo#518078)
  * support m32r architecture (bmo#635667)
  * use atomic functions on ARM (bmo#626309)
  * some other fixes not affecting the Linux platform
* Sun Jan  9 2011 wr@rosenauer.org
- update to 4.8.7 RTM
  * no code changes to beta2
  * only updated internal version information
* Thu Dec  9 2010 wr@rosenauer.org
- update to 4.8.7beta2
  * minimal requirement for NSS 3.12.9
  * bugfixes
* Fri Jul 23 2010 wr@rosenauer.org
- update to 4.8.6
  * moved PR_STATIC_ASSERT from prlog.h to prtypes.h
  * use new NSPR atomic macros
  * bugfixes
- removed fixes for temporary package split
* Sat Apr 24 2010 coolo@novell.com
- buildrequire pkg-config to fix provides
* Fri Mar  5 2010 wr@rosenauer.org
- update to 4.8.4
  * bugfix release
* Fri Dec 18 2009 wr@rosenauer.org
- update to 4.8.3
  * NSPR logging timestamp month number is off by one
  * fixed possible DoS in prdtoa
- added baselibs.conf
* Tue Oct 13 2009 wr@rosenauer.org
- update to 4.8.2 (bnc#546371)
  * RISC OS, Symbian and WinCE improvements
  * bugfixes and optimizations
* Wed May 20 2009 wr@rosenauer.org
- update to 4.8
  * Windows 9x and NT 3.51 and 4.0 are no longer
    supported
  * Windows Mobile and Mac OS X 64-bit (x86_64) are now supported
  * New macros:
    prlock.h: PR_ASSERT_CURRENT_THREAD_OWNS_LOCK
    prmon.h: PR_ASSERT_CURRENT_THREAD_IN_MONITOR
  * special log module timestamp adds timestamps to NSPR log
    messages
* Sat Apr 11 2009 wr@rosenauer.org
- update to 4.7.4
  * Fix strict aliasing issues in prdtoa.c for gcc 4.4 (bmo#439144)
  - obsoletes prdtoa.patch and -fno-strict-aliasing flag
  * In prlink.c, errStrBuf is not thread-safe
* Fri Jan 30 2009 hfiguiere@suse.de
- update to 4.7.3
  * Only Solaris fixes.
* Tue Jan 13 2009 wr@rosenauer.org
- update to 4.7.2 RTM version
  * use /dev/urandom instead of /dev/random (bmo#455829)
  * support Linux/SPARC64 (bmo#459304)
* Wed Jan  7 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Wed Jun 18 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang)
  (bnc#400001 and SWAMP#18164).
* Fri May  2 2008 wr@rosenauer.org
- update to 4.7.1 RTM version
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Mon Mar 31 2008 maw@suse.de
- Undo the shared library package split, per discussion in
  opensuse-packaging.
* Wed Mar 26 2008 wr@rosenauer.org
- update to 4.7.1beta2-20080325 snapshot
* Tue Mar 25 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang)
- Update to the 4.7.1beta1-20080225 snapshot
- Split out a shared library subpackage.
* Thu Feb  7 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang).
- Remove strcstr.patch, which has been upstreamed.
* Thu Feb  7 2008 wr@rosenauer.org
- update to 4.7.0 (requirement for Firefox 3)
- added a %%clean section
* Thu Nov 22 2007 wr@rosenauer.org
- update to version 4.6.8
* Mon Jun 11 2007 ro@suse.de
- update to NSPR 4.6.7 (pull in from wr from opensuse BS)
* Wed Feb 21 2007 maw@suse.de
- Update to version 4.6.5
* Wed Feb  7 2007 wr@rosenauer.org
- fixed crasher in PL_strcaserstr() (strcstr.patch) (bmo #369467)
* Wed Jan 31 2007 maw@suse.de
- Don't install %%{_includedir}/nspr4/prvrsion.h with the executable
  bit set.
* Sat Oct 21 2006 aj@suse.de
- from openSUSE BuildService (thanks Wolfgang Rosenauer):
- update to version 4.6.3: Bug fix release.
* Tue Aug  1 2006 stark@suse.de
- version is still 4.6.2
* Sat Jul 15 2006 stark@suse.de
- added PR_SI_HOSTNAME_UNTRUNCATED flag to get the hostname as
  FQDN with PR_GetSystemInfo() if configured on a system
  (bmo #322956)
* Mon May 15 2006 stark@suse.de
- update to 4.6.2 RTM version
  bugs fixed:
  * PR_ParseTimeString use PR_Assert and it calls abort on
    invalid date (bmo #247896)
  * PR_SetSysfdTableSize and PR_GetSysfdTableMax are not exported
    (bmo #326110)
  * Add a UTF-16 API to load a library (bmo #326168)
  * various changes for non-Linux platforms
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Dec 16 2005 stark@suse.de
- update to final 4.6.1 RTM version
* Wed Dec  7 2005 stark@suse.de
- moved headers to nspr4 sub-directories and removed some
  unneeded headers
* Fri Nov 25 2005 stark@suse.de
- changed ldconfig call in install-scripts
* Tue Nov 15 2005 stark@suse.de
- current 4.6.1pre (20051114)
* Tue Oct 11 2005 stark@suse.de
- next official release will most likely be 4.6.1 (20051010)
* Mon Sep 26 2005 mls@suse.de
- make devel package require base package
* Thu Sep 22 2005 stark@suse.de
- update to 4.7.0pre (20050921)
* Tue May 31 2005 stark@suse.de
- update to final 4.6
* Thu May 19 2005 stark@suse.de
- renamed mozilla-nspr.pc to nspr.pc as decided upstream
- latest snapshots which integrates hidden.patch
* Wed May 18 2005 stark@suse.de
- workaround for gcc bug (bmo #293438, bnc #83908)
- provide its own pkgconfig file (mozilla-nspr.pc)
* Tue May 10 2005 stark@suse.de
- update to current HEAD (upstreamed two patches)
* Tue Apr 26 2005 stark@suse.de
- moved static libs to sub-directory
  (almost nobody should link against them statically)
* Mon Apr 25 2005 stark@suse.de
- fix nspr-config for biarch
* Tue Mar 22 2005 stark@suse.de
- update to HEAD for mozilla compatibility
* Sat Mar 19 2005 stark@suse.de
- update to 4.5.2beta1
* Tue Mar  8 2005 stark@suse.de
- initial standalone package
