#
# spec file for package update-alternatives
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           update-alternatives
Version:        1.19.0.4
Release:        150000.4.7.1
Summary:        Maintain symbolic links determining default commands
License:        GPL-2.0+
Group:          System/Management
Url:            http://ftp.de.debian.org/debian/pool/main/d/dpkg/
Source0:        http://ftp.de.debian.org/debian/pool/main/d/dpkg/dpkg_%{version}.tar.xz
Source3:        sensible-editor
Patch0:         update-alternatives-suse.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
BuildRequires:  ncurses-devel
BuildRequires:  pkgconfig
Provides:       alternatives = %{version}

%description
update-alternatives creates, removes, maintains and displays
information about the symbolic links comprising the alternatives
system. It is possible for several programs fulfilling the same or
similar functions to be installed on a single system at the same time.
For example, many systems have several text editors installed at once.
This gives choice to the users of a system, allowing each to use a
different editor, if desired, but makes it difficult for a program to
make a good choice of editor to invoke if the user has not specified a
particular preference.

%prep
%setup -q -n dpkg-%{version}
%patch0 -p1

%build
autoreconf -fvi
%configure \
  --disable-silent-rules \
  --with-admindir=%{_localstatedir}/lib

make -C lib/compat %{?_smp_mflags}
make -C utils/ %{?_smp_mflags}
make -C man/ %{?_smp_mflags}

%install
install -d -m 0755 %{buildroot}/%{_sbindir}/
install -d -m 0755 %{buildroot}/%{_mandir}/man1/
install -d -m 0755 %{buildroot}/%{_sysconfdir}/alternatives
install -d -m 0755 %{buildroot}%{_localstatedir}/lib/alternatives
install -d -m 0755 %{buildroot}/%{_localstatedir}/log

install -pm 0755 utils/%{name} %{buildroot}/%{_sbindir}
ln -s %{name} %{buildroot}/%{_sbindir}/alternatives
install -pm 0644 man/%{name}.1 %{buildroot}/%{_mandir}/man1/

%post -p <lua>
-- Migrate to new location
if posix.access('var/lib/rpm/alternatives', 'x') then
  print("migrating update alternatives database to new location")
  -- We proceed even if no alternatives directory exists, such situation
  -- occurs in buildroot environment
  new_location='%{_localstatedir}/lib/alternatives/'
  for i,old_file in pairs(posix.dir("var/lib/rpm/alternatives/")) do
    print(old_file.."\n")
    new_file = string.gsub(old_file, "(.*/)(.*)", new_location .. "%2")
    print(new_file.."\n")
    os.rename(old_file, new_file)
  end
  posix.rmdir('var/lib/rpm/alternatives')
end
-- touch file
io.open('%{_localstatedir}/log/alternatives.log', "w"):close()


%files
%doc COPYING
%dir %{_sysconfdir}/alternatives
%dir %{_localstatedir}/lib/alternatives
%{_sbindir}/alternatives
%{_sbindir}/update-alternatives
%{_mandir}/man1/update-alternatives.1%{ext_man}
%ghost %{_localstatedir}/log/alternatives.log

%changelog
* Fri Feb 11 2022 pgajdos@suse.com
- break bash <-> update-alternatives cycle by coolo's rewrite
  of %%post in lua [bsc#1195654]
* Tue Jan 16 2018 tchvatal@suse.com
- Update to 1.19.0.4:
  * No changes in update-alternatives just match step with dpkg
- Drop patch 0001-In-case-of-equal-priority-rather-update.patch
  * Causes issues on too eagerly regenerating stuff bsc#1075971
  * Reason for this patch should no longer be needed as all python
    packages are singlespec
  * Also drop the post override
* Wed Nov 22 2017 dimstar@opensuse.org
- Migrate u-a data from /var/lib/rpm instead of relying on dbpath:
  no u-a version ever installed files explicitly into dbpath, but
  always hard specified /var/lib/rpm. The fact that RPM moved its
  database is irrelevant to update-alternatives. In case RPM moved
  it's database, our files are still accessible via the
  /var/lib/rpm symlink being put in place.
- Drop the arbitrary depenency on a specific rpm version: the idea
  was to ensure to have an rpm with the new dbpath location in
  place. For one, the dependency does not work as intended, and
  2nd, as the migration now happens explicitly from the old u-a
  admindir without relying on dbpath, is no longer needed.
* Mon Nov 20 2017 mpluskal@suse.com
- Move update alternatives database to new location
- Update rpm requirements to avoid unnecessary builds
* Tue Nov  7 2017 mpluskal@suse.com
- Use dbpath macro for locationg rpm state directory
- Require exactly same version of rpm we had when building to make
  sure dbpath matches
* Wed Aug  9 2017 tchvatal@suse.com
- Silence the update-alternatives regen output wrt bsc#1050848
  it causes more confusion than benefits
* Mon Mar 27 2017 tchvatal@suse.com
- Update to 1.18.23:
  * Various small fixes and memleaks removed
- Make sure to generate manpage
- Refresh patch update-alternatives-suse.patch
* Wed Sep  7 2016 tchvatal@suse.com
- Version update to 1.18.10:
  * Various few fixes, see changelog file in the package
  * Refresh patch update-alternatives-suse.patch
  * Remove patch dpkg-sparc.diff
* Wed Sep  7 2016 tchvatal@suse.com
- Use ls . instead of * to avoid error when nothing is in alternatives
  directory
* Tue May 31 2016 tchvatal@suse.com
- Require touch in post phase bnc#982336
* Fri May 13 2016 tchvatal@suse.com
- Provide alternatives binary and alternatives = %%{version} symbol
* Wed Apr  6 2016 tchvatal@suse.com
- Fix bnc#969171 by updating even with equal priority
  * 0001-In-case-of-equal-priority-rather-update.patch
- Try to autorefresh all the alternatives in post in case some of
  them were broken
* Wed Apr  6 2016 tchvatal@suse.com
- The logfile for update-alternatives is /var/log/alternatives.log
  so stop using update-alternatives.log file which is empty
* Fri Mar 25 2016 tchvatal@suse.com
- Update to the 1.18.4:
  * Rebase patch update-alternatives-suse.patch
  * Touch the gost file in post
* Fri Jun  5 2015 tchvatal@suse.com
- Adjust to the new manpage location
* Thu Jun  4 2015 tchvatal@suse.com
- Verion bump to 1.18.1:
  * Bump to latest upstream release
  * Plenty of fixes with too long changelog, see changelog file in
    documentation
  * Also fixes bnc#926749 CVE-2015-0840
  * Refresh patch:
    + update-alternatives-suse.patch
* Wed Apr  1 2015 tchvatal@suse.com
- Cleanup with spec-cleaner
* Wed Apr  1 2015 tchvatal@suse.com
- Update to 1.11.24:
  * Translation updates
  * Various small fixes
* Tue Feb 17 2015 p.drouand@gmail.com
- Update to version 1.17.23
  + Use a matching group instead of ${^MATCH} in s/// in dselect build script.
  + Skip tar extractor tests if tar is not GNU tar >= 1.27.
  + Reset the trigger cycle tracking on unsatisfied dependencies during
    trigger processing. Closes: bdo#771730
  + Fix out-of-bounds buffer read accesses when parsing field and trigger
    names or checking package ownership of conffiles and directories.
  + Add versioned Breaks on packages creating trigger cycles. Namely auctex,
    apt-cudf, ccache, cups, distcc, fusionforge-plugin-mediawiki, gap-core,
    gxine, hoogle, icecc, libjs-protoaculous, mcollective, pypy, wordpress
    and xfonts-traditional.
  + Update translations
- Remove unapplied patches; SLE11 support is disabled in project home
  + dpkg-pod2man-no-utf8.patch
  + dpkg-old-File-Path.patch
  + dpkg-old-Test-More.patch
- Remove obsolete patches
  * dpkg-ppc64le.diff
  * dpkg-archive_tar_format_gnu.patch
  * dpkg-archtable-suse.patch
- Rename updated patch
  pdate-alternatives-1.16.8-suse.patch > pdate-alternatives-suse.patch
- Clean up a bit specfile
* Mon May 12 2014 tchvatal@suse.com
- Use SUSE not SuSE.
* Mon Dec  2 2013 dvaleev@suse.com
- add dpkg-ppc64le.diff (adds ppc64le architecture)
* Wed Jul  3 2013 jengelh@inai.de
- Add dpkg-sparc.diff to unbreak compilation on sparcv9 build
* Mon Mar 25 2013 frank.lichtenheld@sophos.com
- update to 1.16.10
  * Fix update-alternatives test suite to behave correctly on non-Debian
  binary paths. Known to be affecting at least Gentoo and Mac OS X.
  * Do not leak subcall command arguments in update-alternatives.
  * Fix segfault on update-alternatives when passing --slave without any
  action at all. lp#1037431
* Thu Sep 27 2012 frank.lichtenheld@sophos.com
- update to 1.16.8
* Fri Jul  6 2012 frank.lichtenheld@sophos.com
- update to 1.16.7
  * Print master and slave alternarive link names in update-alternatives
  - -query and always print alternative link in --config. Closes: #679010
  * Check parsed integers for invalid or no digit errors in
  update-alternatives. Check all parsed integers for out of range
  errors. On "update-alternatives --install" only warn for now on
  out of range priorities and clamp the values
* Wed Jun  6 2012 coolo@suse.com
- fix the reworked patch
* Mon May 21 2012 i@marguerite.su
- update to 1.16.3
- reworked patch
* Sun Jan 29 2012 frank.lichtenheld@sophos.com
- update to 1.15.8.12
  * no changes, just keep in sync with deb
* Sat Nov 26 2011 frank.lichtenheld@sophos.com
- update to 1.15.8.11
- remove unused tarballs and patches
* Sun Sep 18 2011 jengelh@medozas.de
- Remove redundant tags/sections from specfile
  (cf. packaging guidelines)
- Use %%_smp_mflags for parallel build
* Thu Mar 17 2011 mvyskocil@suse.cz
- update to 1.15.8.10 - bug fix release
- build it in the same source tree as package deb
* Mon Mar 14 2011 mvyskocil@suse.cz
- update to 1.15.8.5
  * update-alternatives is now implemented in C
- fix bnc#647151 - update-alternatives: false claim in the description
  * removed jpackage only part, as it's now don't have any sense
* Thu Feb 17 2011 mvyskocil@suse.cz
- fix bnc#669716 - update-alternatives corrupt
  the pack/unpack removal code broke the java update-alternatives file
* Mon Jul 21 2008 mvyskocil@suse.cz
- fix of enhancenment request[bnc#261246] - update-alternatives should support --set
  - update to the 1.14.19
* Tue Nov  6 2007 mvyskocil@suse.cz
- fix the manual link state after --install and --remove commands [#334783]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Sep 28 2005 dmueller@suse.de
- add norootforbuild
* Wed Sep  1 2004 skh@suse.de
- Initial package version 1.8.3
