#
# spec file for package tuned
#
# Copyright (c) 2019 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%{!?_tmpfilesdir:%global _tmpfilesdir %{_libexecdir}/tmpfiles.d}
Name:           tuned
Version:        2.10.0
Release:        150600.28.3.1
Summary:        A dynamic adaptive system tuning daemon
License:        GPL-2.0-or-later
Group:          System/Base
URL:            https://github.com/redhat-performance/tuned
#Source0:        https://github.com/redhat-performance/tuned/archive/v%%{version}.tar.gz#/%%{name}-%%{version}.tar.gz
Source0:        %{name}-%{version}.tar.xz
Source1:        tuned.rpmlintrc
# PATCH-FIX-OPENSUSE fix-allow-receive_sender-default.patch <allow receive_sender="com.redhat.com"/> allow receive_* is normally
# not needed as that is the default --<p.drouand@gmail.com>
Patch0:         fix-allow-receive_sender-default.patch
Patch1:         reload_profile_configuration_on_SIGHUP.patch
Patch2:         fix_unit_configuration_reading.patch
Patch3:         log_initialize_explicitly_with_int.patch
Patch4:         conservative_governor_may_be_compiled_as_module_and_needs_explicit_loading.patch
Patch5:         plugin_disk_fix_checking_removable_attribute_on_python3.patch
Patch6:         plugin_disk_fix_plug_in_out_problem.patch
Patch7:         fix_check_in_add_and_remove_device_methods_of_monitor_class.patch
Patch8:         increase_log_file_size.patch
Patch9:         tuned_differ_x86_and_other_archs_in_cpu_plugin_mainline.patch
Patch10:        s2kb_fixed_to_be_compatible_with_python3.patch
Patch11:        balanced_added_explicit_priority_to_CPU_plugin_instance.patch
Patch12:        log_full_stack_trace_of_unhandled_exceptions_as_an_error.patch
Patch13:        plugin_script-Execute-all-scripts-regardless-of-errors.patch
Patch14:        moved-kernel-paths-1.patch
Patch15:        uncore-pr477.patch
Patch16:        uncore-pr590.patch
Patch17:        uncore-pr606.patch

BuildRequires:  bash-completion
BuildRequires:  desktop-file-utils
BuildRequires:  pkgconfig
BuildRequires:  python3-base
BuildRequires:  pkgconfig(systemd)
# need perf_bias now
Requires:       cpupower >= 4.19
Requires:       ethtool
Requires:       gawk
Requires:       hdparm
Requires:       polkit
Requires:       python3-configobj
Requires:       python3-dbus-python
Requires:       python3-decorator
Requires:       python3-gobject
Requires:       python3-linux-procfs
Requires:       python3-pyudev
Requires:       util-linux
Requires:       virt-what
Obsoletes:      pm-profiler
BuildArch:      noarch
%{?systemd_requires}

%description
The tuned package contains a daemon that tunes system settings dynamically.
It does so by monitoring the usage of several system components periodically.
Based on that information components will then be put into lower or higher
power saving modes to adapt to the current usage. Currently only ethernet
network and ATA harddisk devices are implemented.

%package gtk
Summary:        Disk and net statistic monitoring systemtap scripts - GTK GUI
Group:          System/Base
Requires:       %{name} = %{version}
Requires:       polkit
Requires:       powertop

%description gtk
GTK GUI that can control tuned and provide simple profile editor.

# Do not ship SAP profiles for SLE and Leap, there are other packages
# providing these profiles
%if !0%{?sle_version}
%package profiles-sap
Summary:        Additional tuned profile(s) targeted to SAP NetWeaver loads
Group:          System/Base
Requires:       %{name} = %{version}

%description profiles-sap
Additional profile(s) for the tuned daemon, targeted to SAP NetWeaver loads.

%package profiles-sap-hana
Summary:        Additional tuned profile(s) targeted to SAP HANA loads
Group:          System/Base
Requires:       %{name} = %{version}

%description profiles-sap-hana
Additional profile(s) for the tuned daemon, targeted to SAP HANA loads.
%endif

%package profiles-atomic
Summary:        Additional tuned profiles targeted to Atomic
Group:          System/Base
Requires:       %{name} = %{version}

%description profiles-atomic
Additional profile(s) for the tuned daemon, targeted to Atomic host and guest.

%package profiles-realtime
Summary:        Additional tuned profiles targeted to realtime
Group:          System/Base
Requires:       %{name} = %{version}

%description profiles-realtime
Additional profile(s) for the tuned daemon, targeted to realtime.

%package profiles-oracle
Summary:        Additional tuned profiles targeted to Oracle loads
Group:          System/Base
Requires:       %{name} = %{version}

%description profiles-oracle
Additional profile(s) for the tuned daemon,  targeted to Oracle loads.

%package profiles-nfv
Summary:        Additional tuned profiles targeted to Network Function Virtualization (NFV)
Group:          System/Base
Requires:       %{name} = %{version}

%description profiles-nfv
Additional profile(s) for the tuned daemon, targeted to Network Function Virtualization (NFV).

%package utils
Summary:        Disk and net statistic monitoring systemtap scripts
Group:          System/Base
Requires:       %{name} = %{version}
Requires:       powertop

%description utils
This package contains utilities that can help you to fine tune your
system and manage tuned profiles.

%package utils-systemtap
Summary:        Disk and net statistic monitoring systemtap scripts
Group:          System/Base
Requires:       %{name} = %{version}
Requires:       systemtap

%description utils-systemtap
This package contains several systemtap scripts to allow detailed
manual monitoring of the system. Instead of the typical IO/sec it collects
minimal, maximal and average time between operations to be able to
identify applications that behave power inefficient (many small operations
instead of fewer large ones).

%prep
%setup -q
%autopatch -p1

%build
# The tuned daemon is written in pure Python. Nothing requires to be built.
# Just a hack to avoid installation in a wrong directory
sed -i 's|usr/libexec/tuned|%{_libexecdir}/%{name}|' Makefile

%install
%make_install
# we do not have the python perf module (see bsc #1217758)
rm %{buildroot}/%{python3_sitelib}/tuned/plugins/plugin_scheduler.py
%py3_compile %{buildroot}/%{python3_sitelib}
rm -rf %{buildroot}/%{_datadir}/doc
# Remove unwanted stuff instead of excluding them in files list
rm -rf %{buildroot}%{_libexecdir}/%{name}/{default,desktop-powersave,laptop-ac-powersave,server-powersave,laptop-battery-powersave,enterprise-storage,spindown-disk}
rm %{buildroot}%{_mandir}/man7/tuned-profiles-compat.7
ln -sf service %{buildroot}%{_sbindir}/rctuned

%post
%service_add_post %{name}.service
%if 0%{?suse_version} <= 1320
    systemd-tmpfiles --create %{_tmpfilesdir}/%{name}.conf >/dev/null 2>&1 || :
%else
    %tmpfiles_create %{_tmpfilesdir}/%{name}.conf
%endif
# convert active_profile from full path to name (if needed)
sed -i 's|.*/\([^/]\+\)/[^\.]\+\.conf|\1|' %{_sysconfdir}/tuned/active_profile
%if 0%{?suse_version} < 1500
%desktop_database_post
%endif

%pre
%service_add_pre %{name}.service

%preun
%service_del_preun %{name}.service

%postun
%service_del_postun %{name}.service
%if 0%{?suse_version} < 1500
%desktop_database_postun
%endif

%files

%dir %{_sysconfdir}/modprobe.d
%license COPYING
%doc AUTHORS README
%{_datadir}/bash-completion/completions/tuned-adm
%{_datadir}/polkit-1/actions/com.redhat.tuned.policy
%exclude %{python3_sitelib}/tuned/gtk
%{python3_sitelib}/tuned
%{_sbindir}/tuned
%{_sbindir}/tuned-adm
%{_sbindir}/rctuned
%exclude %{_sysconfdir}/tuned/realtime-variables.conf
%exclude %{_sysconfdir}/tuned/realtime-virtual-guest-variables.conf
%exclude %{_sysconfdir}/tuned/realtime-virtual-host-variables.conf
%exclude %{_libexecdir}/tuned/realtime-virtual-guest
%exclude %{_libexecdir}/tuned/realtime-virtual-host
%exclude %{_libexecdir}/tuned/sap-netweaver
%exclude %{_libexecdir}/tuned/sap-hana
%exclude %{_libexecdir}/tuned/sap-hana-vmware
%exclude %{_sysconfdir}/tuned/sap-hana-vmware-variables.conf
%exclude %{_mandir}/man7/tuned-profiles-sap*.7.gz
%exclude %{_libexecdir}/tuned/atomic-host
%exclude %{_libexecdir}/tuned/atomic-guest
%exclude %{_libexecdir}/tuned/oracle
%exclude %{_libexecdir}/tuned/realtime
%exclude %{_libexecdir}/tuned/defirqaffinity*
%{_libexecdir}/tuned
# active_profile might be empty when built via build service, but typically
# not on a real install -> better do not mark it %%ghost
%config(noreplace) %verify(not size mtime md5) %{_sysconfdir}/tuned/active_profile
%config(noreplace) %{_sysconfdir}/modprobe.d/tuned.conf
%config(noreplace) %{_sysconfdir}/tuned/cpu-partitioning-variables.conf
%config(noreplace) %{_sysconfdir}/tuned/tuned-main.conf
%config(noreplace) %{_sysconfdir}/tuned/profile_mode
%config(noreplace) %verify(not size mtime md5) %{_sysconfdir}/tuned/bootcmdline
%dir %{_sysconfdir}/dbus-1
%dir %{_sysconfdir}/dbus-1/system.d
%config %{_sysconfdir}/dbus-1/system.d/com.redhat.tuned.conf
%{_sysconfdir}/grub.d
%{_tmpfilesdir}/tuned.conf
%{_unitdir}/tuned.service
%dir %{_localstatedir}/log/tuned
%dir %{_sysconfdir}/tuned
%{_mandir}/man5/tuned*
%{_mandir}/man7/tuned-profiles-cpu-partitioning.7%{?ext_man}
%{_mandir}/man7/tuned-profiles.7%{?ext_man}
%{_mandir}/man7/tuned-profiles-mssql.7%{?ext_man}
%{_mandir}/man8/tuned*
%dir %{_datadir}/tuned
%ghost %dir /run/tuned
%dir %{_prefix}/lib/kernel
%dir %{_prefix}/lib/kernel/install.d
%{_prefix}/lib/kernel/install.d/92-tuned.install

%files gtk
%dir %{_datadir}/icons/hicolor
%dir %{_datadir}/icons/hicolor/*/
%dir %{_datadir}/icons/hicolor/*/apps
%{_datadir}/icons/hicolor/*/apps/*
%{_datadir}/applications/tuned-gui.desktop
%{_sbindir}/tuned-gui
%{python3_sitelib}/tuned/gtk
%{_datadir}/tuned/ui
%{_datadir}/polkit-1/actions/com.redhat.tuned.gui.policy

%if !0%{?sle_version}
%files profiles-sap
%{_libexecdir}/tuned/sap-netweaver
%{_mandir}/man7/tuned-profiles-sap.7%{?ext_man}

%files profiles-sap-hana
%{_libexecdir}/tuned/sap-hana
%{_libexecdir}/tuned/sap-hana-vmware
%{_mandir}/man7/tuned-profiles-sap-hana.7%{?ext_man}
%endif

%files profiles-atomic
%{_libexecdir}/tuned/atomic-host
%{_libexecdir}/tuned/atomic-guest
%{_mandir}/man7/tuned-profiles-atomic.7%{?ext_man}

%files profiles-realtime
%config(noreplace) %{_sysconfdir}/tuned/realtime-variables.conf
%{_libexecdir}/tuned/realtime
%{_mandir}/man7/tuned-profiles-realtime.7%{?ext_man}

%files profiles-oracle
%{_libexecdir}/tuned/oracle
%{_mandir}/man7/tuned-profiles-oracle.7%{?ext_man}

%files profiles-nfv
%config(noreplace) %{_sysconfdir}/tuned/realtime-virtual-guest-variables.conf
%config(noreplace) %{_sysconfdir}/tuned/realtime-virtual-host-variables.conf
%{_libexecdir}/tuned/realtime-virtual-guest
%{_libexecdir}/tuned/realtime-virtual-host
%{_libexecdir}/tuned/defirqaffinity*
%{_mandir}/man7/tuned-profiles-nfv-*.7%{?ext_man}

%files utils
%license COPYING
%{_bindir}/powertop2tuned

%files utils-systemtap
%license COPYING
%doc doc/README.utils doc/README.scomes
%{_sbindir}/varnetload
%{_sbindir}/netdevstat
%{_sbindir}/diskdevstat
%{_sbindir}/scomes
%{_mandir}/man8/varnetload.*
%{_mandir}/man8/netdevstat.*
%{_mandir}/man8/diskdevstat.*
%{_mandir}/man8/scomes.*

%changelog
* Thu Jul  4 2024 aschnell@suse.com
- added uncore plugin (jsc#PED-8397)
  A uncore-477.patch
  A uncore-590.patch
  A uncore-606.patch
* Mon Dec  4 2023 aschnell@suse.com
- own directory /usr/lib/kernel/install.d to fix build
* Mon Dec  4 2023 aschnell@suse.com
- adapt to changed kernel paths (jsc#PED-7308)
  A    moved-kernel-paths-1.patch
* Mon Dec  4 2023 aschnell@suse.com
- do not package inoperable plugins (bsc#1217758)
* Fri Sep 17 2021 trenn@suse.de
- plugin_script: Execute all scripts regardless of errors
  found by review for SLE 15 SP4 (jsc#SLE-20335)
  A plugin_script-Execute-all-scripts-regardless-of-errors.patch
* Fri Oct 11 2019 trenn@suse.de
- Exclude leftover config file (bsc#1153341):
  /etc/tuned/sap-hana-vmware-variables.conf
  which is part of sap-hana-vmware-variables profile, which got
  explicitly excluded recently
* Tue Mar 12 2019 trenn@suse.de
  Added mainline git commit of with proper header:
  A    balanced_added_explicit_priority_to_CPU_plugin_instance.patch
  D    tuned_differ_x86_and_other_archs_in_cpu_plugin.patch
  Fix backtrace/exit when log file gets rotated (bsc#bsc#1126609):
  log_initialize_explicitly_with_int.patch
  Added mainline git commit bug fixes found by review:
  A    conservative_governor_may_be_compiled_as_module_and_needs_explicit_loading.patch
  A    fix_check_in_add_and_remove_device_methods_of_monitor_class.patch
  A    fix_unit_configuration_reading.patch
  A    increase_log_file_size.patch
  A    log_full_stack_trace_of_unhandled_exceptions_as_an_error.patch
  A    plugin_disk_fix_checking_removable_attribute_on_python3.patch
  A    plugin_disk_fix_plug_in_out_problem.patch
  A    reload_profile_configuration_on_SIGHUP.patch
  A    s2kb_fixed_to_be_compatible_with_python3.patch
  A    tuned_differ_x86_and_other_archs_in_cpu_plugin_mainline.patch
* Wed Jan 16 2019 trenn@suse.de
- Differ archs and x86 CPU vendors to avoid wrong warning about a
  missing intel tool (x86_energy_perf_bias)
- Remember arch and x86 CPU vendor to allow arch/vendor specific
  CPU tunings in the future (fate#326694)
  A tuned_differ_x86_and_other_archs_in_cpu_plugin.patch
- Require virt-what to be able to detect whether it is running
  on a virtual machine
* Fri Jan 11 2019 trenn@suse.de
- Update to latest git head commit 26db89de18efad1b4536
  including quite some mainline fixes
- tuned needs polkit daemon running
* Thu Jan  3 2019 trenn@suse.de
- Remove sap subpackages entirely for SLE and Leap products.
  These conflict with possible other SLE optimized sap subpackages
  (bnc#1064832).
- Create systemd tmpfiles correctly for different releases again.
* Tue Dec 25 2018 9+suse@cirno.systems
- Add missing dependency on python3-linux-procfs
* Thu Nov 22 2018 trenn@suse.de
- Go for 2.10.0 full version in _service (even this is rc1)
  bsc#1071436
  Latest included git commit:
  commit 3722b151920dc20735dc15cbd45aed7b573fdfc2
  Date:   Wed Nov 21 14:21:32 2018 +0100
  Still keep the old git version parameter commented out, maybe
  I need this again.
- Since cpupower also has perf_bias binary, the cpupower call to
  switch this has been reverted to lower maintenance overhead
  D    check_for_cpupower.patch
  D    use-cpupower-for-intel-perf-bias.patch
- Update to version 2.10.0:
  * Add range feature for cpu exclusion
  * Disable KSM only once, re-enable it only on full rollback
  * Add log message for unsupported parameters in plugin_net
  * Add missing feature parameters aliases to plugin_net
  * Make virtual-host identical to latency-performance
* Fri Apr  6 2018 tchvatal@suse.com
- Reintroduce the _service file as we must use git head in order to
  get all the python3 fixes in
- Update to version 2.9.0+git20180328.d25e8b8:
  * makefile: dropped KVM unit tests, now provided by standalone package
  * sysctl: support assignment modifiers as other plugins do
  * spec: used weak deps for tuned-profiles-nfv-host-bin
  * Added requires to tuned-profiles-nfv-host-bin
  * Dropped tuned-profiles-nfv-host-bin subpackage
  * tuned: Add readahead comment to throughput-performance tuned.conf
  * oracle: fixed ip_local_port_range parity warning
  * Consistently use 'balance' instead of 'rebalance' in cpu-partitioning
- Rebase check_for_cpupower.patch to apply cleanly again
* Fri Apr  6 2018 tchvatal@suse.com
- Version update to 2.9.0:
  * python3 porting start
  * various small fixes
- Drop patches merged upstream:
  * fix-desktop-category.patch
  * remove-unnecessary-shebangs.patch
  * fix-glade-file-permission.patch
- Switch to autopatch from calling all individual patchlines
* Fri Apr  6 2018 tchvatal@suse.com
- Switch to python3 and format with spec-cleaner
* Fri Apr  6 2018 tchvatal@suse.com
- Switch to normal url fetching, there is no actual reason to run
  service in order to generate the versioned tarballs
* Fri Feb 16 2018 dimstar@opensuse.org
- Own %%{_sysconfdir}/dbus-1/system.d and %%{_sysconfdir}/dbus-1: in
  the past systemd happened to install things there and 'own' the
  directory for us, but that was just a coincidence.
- Replace systemd BuildRequires with pkgconfig(systemd), allowing
  OBS to pick systemd-mini for the build.
* Thu Nov 16 2017 jloeser@suse.com
- check for `cpupower` binary and set attribute correctly (bsc#1055070)
- added patch:
  * check_for_cpupower.patch
* Fri Jul  7 2017 fschnizlein@suse.com
- Update to version 2.8.0:
  * builtin functions: parser not traceback if func expands to empty string
  * systemd: added support for older systemd CPUAffinity syntax
  * scheduler: do not traceback if process dissapears during enumeration
  * scheduler: fix more python-linux-procfs tracebacks
  * plugin_net: Fix invocation of execute()
  * cpu-partitioning: use tuna for cores isolation
  * builtin functions: add strip
  * bootloader: workaround for adding tuned_initrd to new kernels on restart
  * new release (2.8.0)
  + Add Patch: Fix category in desktop file for tuned-gui (fix-desktop-category.patch)
  + Add Patch: Remove unnecessary shebangs (remove-unnecessary-shebangs.patch)
  + Add Patch: Fix file permission for glade file (fix-glade-file-permission.patch)
  + Add rpmlintrc to silence unnecessary warnings
  + Remove Patch: tuned-2.4.0-use_cpupower_for_intel_perf_bias.patch
  = Modified Patches to apply with 2.8.0:
  - fix-allow-receive_sender-default.patch
  - use-cpupower-for-intel-perf-bias.patch
* Sun Jan 17 2016 mpluskal@suse.com
- Update to 2.6.0
  * plugin_cpu: do not show error if cpupower or
    x86_energy_perf_policy are missing
  * plugin_sysctl: fixed quoting of sysctl values
  * tuned-adm: added log file location hint to verify command output
  * libexec: fixed listdir and isdir in defirqaffinity.py
  * plugin_cpu: save and restore only intel pstate attributes that
    were changed
  * functions: fixed sysfs save to work with options
  * plugins: added scsi_host plugin
  * tuned-adm: fixed restart attempt if tuned is not running
  * spec: fixed post scriptlet to work without grub
  * tuned-profiles-nfv: fix find-lapictscdeadline-optimal.sh for
    CPUS where ns > 6500
  * functions: fixed restore_logs_syncing to preserve SELinux
    context on rsyslog.conf
  * realtime: set unboud workqueues cpumask
  * spec: correctly remove tuned footprint from /etc/default/grub
  * gui: fixed creation of new profile
  * profiles: removed nohz_full from the realtime profile
  * profiles: Added nohz_full and nohz=on to realtime guest/host
    profiles
  * profiles: fixed lapic_timer_adv_ns cache
  * plugin_sysctl: pass verification even if the option doesn't
    exist
  * added support for 'summary' and 'description' of profiles,
    extended D-Bus API for better Cockpit support
* Tue Sep 29 2015 mpluskal@suse.com
- Fix build for openSUSE Leap (lack of tmpfiles.d macro)
* Mon Aug 17 2015 mpluskal@suse.com
- Update to 2.5.1
  * plugin_scheduler: work with nohz_full (rhbz#1247184)
  * fixed realtime-virtual-guest/host profiles packaged twice
    (rhbz#1249028)
  * fixed requirements of realtime and nfv profiles
  * fixed tuned-gui not starting (boo#937647)
  * various other minor fixes
* Wed Jul 15 2015 mpluskal@suse.com
- tuned-2.4.0-use_cpupower_for_intel_perf_bias.patch
  * fixed indentation and tabs usage
* Sun Jul 12 2015 mpluskal@suse.com
- Update to 2.5.0
  * add tuned-adm verify command for verification if all settings
    from profile was applied (rhbz#1212836)
  * add variables support to profiles / scripts (rhbz#1225124)
  * add support for calling built-in functions when expanding
    variables, built-in functions can be provided by function
    plugins, add some built-in functions for unit conversion
    (rhbz#1225135)
  * add support for no daemon mode (rhbz#1068663)
  * add oracle tuned profile (rhbz#1196298)
  * add tuned profile for RHEL-RT (rhbz#1228801)
  * add tuned profiles for RHEL-NFV (rhbz#1228803)
  * plugin_scheduler: added support for runtime tuning of
    processes using perf (rhbz#1148546)
  * plugin_sysfs: add glob support (rhbz#1212831)
  * plugin_net: add support for ethtool -C (rhbz#1152539)
  * plugin_net: add support for ethtool -K (rhbz#1152541)
  * plugin_bootloader: add support for calculation of values for
    the kernel command line (rhbz#1191595)
  * tuned-adm: fix bash completions (rhbz#1207668)
  * plugin_bootloader: do not install tuned kernel command line to
    rescue kernels (rhbz#1223864)
  * add support for changing elevators on xvd* devices
    (Amazon EC2) (rhbz#1170152)
  * do not change settings of transparent hugepages if set in
    kernel cmdline (rhbz#1189868
- Rebase patch:
  * tuned-2.4.0-use_cpupower_for_intel_perf_bias.patch
- Drop patch included in upstream
  * tuned-powertop2tuned-fix-KeyError-on-id-attribute.patch
- Fix some rpmlint warnings
  * ghost rundif
  * create tpmfiles in post using proper macro
- Small cleanups using spec-cleaner
* Fri Jul 10 2015 bwiedemann@suse.com
- fix syntax (bnc#937647)
* Mon Jan  5 2015 p.drouand@gmail.com
- Add tuned-powertop2tuned-fix-KeyError-on-id-attribute.patch;
  fix bnc#888599
* Fri Oct 17 2014 oholecek@suse.com
- Update to version 2.4.1
  + plugin_disk: set_spindown and set_APM made independent (rhbz#976725)
  + plugin_bootloader: added check for grub2 (rhbz#1150047)
  + tuned-adm: fixed traceback on "tuned-adm list" (rhbz#1149162)
  + plugin_bootloader: 00_tuned do not return error if there is no cmdline (rhbz#1151768, bsc#901180)
  + fixed polkit configuration
- Remove tuned-2.4.0-polkit-tuned-gui-path.patch
* Sat Oct 11 2014 p.drouand@gmail.com
- Remove python-gobject dependency in -gtk subpackage; main package
  already requires python-gobject
* Fri Oct 10 2014 p.drouand@gmail.com
- Update to version 2.4.0
  + rebase tuned to latest upstream (rhbz#1093883)
  + fixed traceback if profile cannot be loaded
    related: rhbz#953128
  + powertop2tuned: fixed traceback if rewriting file instead of dir
    resolves: rhbz#963441
  + throughput-performance: altered dirty ratios for better performance
    resolves: rhbz#1043533
  + latency-performance: leaving THP on its default
    resolves: rhbz#1064510
  + used throughput-performance profile on server by default
    resolves: rhbz#1063481
  + network-latency: added new profile
    resolves: rhbz#1052418
  + network-throughput: added new profile
    resolves: rhbz#1052421
  + recommend.conf: fixed config file
    resolves: rhbz#1069123
  + systemd: added cpupower.service conflict
    resolves: rhbz#1073392
  + balanced: used medium_power ALPM policy
  + added support for >, < assignment modifiers in tuned.conf
  + handled root block devices
  + balanced: used conservative CPU governor
    resolves: rhbz#1124125
  + plugins: added selinux plugin
  + plugin_net: added nf_conntrack_hashsize parameter
  + profiles: added atomic-host profile
    resolves: rhbz#1091977
  + profiles: added atomic-guest profile
    resolves: rhbz#1091979
  + moved profile autodetection from post install script to tuned daemon
    resolves: rhbz#1144067
  + profiles: included sap-hana and sap-hana-vmware profiles
  + man: structured profiles manual pages according to sub-packages
  + added missing hdparm dependency
    resolves: rhbz#1144858
  + improved error handling of switch_profile
    resolves: rhbz#1068699
  + tuned-adm: active: detect whether tuned deamon is running
    related: rhbz#1068699
  + removed active_profile from RPM verification
    resolves: rhbz#1104126
  + plugin_disk: readahead value can be now specified in sectors
    resolves: rhbz#1127127
  + plugins: added bootloader plugin
    resolves: rhbz#1044111
  + plugin_disk: added error counter to hdparm calls
  + plugins: added scheduler plugin
    resolves: rhbz#1100826
  + added tuned-gui
- Add tuned-2.4.0-polkit-tuned-gui-path.patch; fix tuned-gui path
  in polkit policy rule
- Remove fix-new-systemd-tmpfiles.d-path.patch; fixed by upstream
- Update use_cpupower_for_intel_perf_bias to upstream changes
  + Added : tuned-2.4.0-use_cpupower_for_intel_perf_bias.patch
  + Deleted : se_cpupower_for_intel_perf_bias
- Add tuned-gtk, profiles-sap, profiles-sap-hana, and profiles-atomic
  subpackages
- Add hdparm and util-linux requirements; new dependencies
- Add bash-completion build requirement to avoid owning standard
  directory
* Fri May 23 2014 jsegitz@novell.com
- added necessary macros for systemd files
* Mon Mar 31 2014 trenn@suse.de
- Use cpupower {info,set} -b to set Intel perf bias value instead of
  x86_energy_perf_policy we do not ship.
  Add use_cpupower_for_intel_perf_bias
- Add rctuned service link in /usr/sbin
- Mark pm-profiler obsoleted by this package
* Fri Feb 21 2014 p.drouand@gmail.com
- Add fix-allow-receive_sender-default.patch  allow receive_* is
  normally not needed as that is the default
* Sun Feb  2 2014 cfarrell@suse.com
- license update: GPL-2.0+
  No sign of GPL-2.0 (only) licensed components
* Sun Dec 22 2013 p.drouand@gmail.com
- Update to version 2.3.0
  + audio plugin: fixed audio settings in standard profiles
    resolves: rhbz#1019805
  + video plugin: fixed tunings
  + daemon: fixed crash if preset profile is not available
    resolves: rhbz#953128
  + man: various updates and corrections
  + functions: fixed usb and bluetooth handling
  + tuned: switched to lightweighted pygobject3-base
  + daemon: added global config for dynamic_tuning
    resolves: rhbz#1006427
  + utils: added pmqos-static script for debug purposes
    resolves: rhbz#1015676
  + throughput-performance: various fixes
    resolves: rhbz#987570
  + tuned: added global option update_interval
  + plugin_cpu: added support for x86_energy_perf_policy
    resolves: rhbz#1015675
  + dbus: fixed KeyboardInterrupt handling
  + plugin_cpu: added support for intel_pstate
    resolves: rhbz#996722
  + profiles: various fixes
    resolves: rhbz#922068
  + profiles: added desktop profile
    resolves: rhbz#996723
  + tuned-adm: implemented non DBus fallback control
  + profiles: added sap profile
  + tuned: lowered CPU usage due to python bug
    resolves: rhbz#917587
- Add missing requirements; ethtool, gawk, python-pyudev and powertop
- Replace python-gobject2 with python-gobject in requirements;
  python-gobject2 is depreciated
- Remove unwanted stuff instead of exclude it
* Sun Oct 20 2013 hrvoje.senjan@gmail.com
- Adjust Requires again: we are openSUSE, not Fedora, so require
  python-gobject2 instead of non-existant pygobject2
* Wed Oct 16 2013 hrvoje.senjan@gmail.com
- Update to version 2.2.2:
  * cpu plugin: fixed cpupower workaround
  * cpu plugin: fixed crash if cpupower is installed
- Changes since 2.2.1:
  * audio plugin: fixed error handling in _get_timeout
  * removed cpupower dependency, added sysfs fallback
  * powertop2tuned: fixed parser crash on binary garbage
  * cpu plugin: dropped multicore_powersave as kernel upstream
    already did
  * plugins: options manipulated by dynamic tuning are now
    correctly saved and restored
  * powertop2tuned: added alias -e for --enable option
  * powertop2tuned: new option -m, --merge-profile to select
    profile to merge
  * prefer transparent_hugepage over redhat_transparent_hugepage
  * recommend: use recommend.conf not autodetect.conf
  * tuned.service: switched to dbus type service
  * tuned: new option --pid, -P to write PID file
  * tuned, tuned-adm: added new option --version, -v to show version
  * disk plugin: use APM value 254 for cleanup / APM disable
    instead of 255
  * tuned: new option --log, -l to select log file
  * powertop2tuned: avoid circular deps in include
    (one level check only)
  * powertop2tuned: do not crash if powertop is not installed
  * net plugin: added support for wake_on_lan static tuning
  * loader: fixed error handling
- Require dbus-1-python instead of dbus-python, so the package is
  made installable
* Fri Feb  8 2013 p.drouand@gmail.com
- Update to version 2.2.0:
  * remove nobarrier from virtual-guest (data loss prevention)
  * devices enumeration via udev, instead of manual retrieval
  * support for dynamically inserted devices (currently disk plugin)
  * dropped rfkill plugins (bluetooth and wifi), the code didn't work
- Add Requires:python-configobj tag needed for profiles configuration
* Mon Dec 24 2012 p.drouand@gmail.com
- Update to 2.1.1 version:
  * fix: powertop2tuned execution
  * fix: ownership of /etc/tuned
  * daemon: allow running without selected profile
  * daemon: fix profile merging, allow only safe characters in profile names
  * daemon: implement missing methods in DBus interface
  * daemon: implement profile recommendation
  * daemon: improve daemonization, PID file handling
  * daemon: improved device matching in profiles, negation possible
  * daemon: various internal improvements
  * executables: check for EUID instead of UID
  * executables: run python with -Es to increase security
  * plugins: cpu - fix cpupower execution
  * plugins: disk - fix option setting
  * plugins: mounts - new, currently supports only barriers control
  * plugins: sysctl - fix a bug preventing settings application
  * powertop2tuned: speedup, fix crashes with non-C locales
  * powertop2tuned: support for powertop 2.2 output
  * profiles: progress on replacing scripts with plugins
  * tuned-adm: bash completion - suggest profiles from all supported locations
  * tuned-adm: complete switch to D-bus
  * tuned-adm: full control to users with physical access
- Add a %%post script to try to autodetect the best profile
- Update the patches
- Change subpackages to be more coherent and for don't oblige to install
  useless packages by user
* Tue Oct 30 2012 p.drouand@gmail.com
- Remove rpmlintrc for being acceptable on Factory
* Tue Oct 30 2012 p.drouand@gmail.com
- Use %%doc for the doc files - that will put them automatically into
  /usr/share/doc/packages/tuned. Do not use /usr/share/doc/tuned-%%version
  at all
* Tue Oct 30 2012 p.drouand@gmail.com
- Add %%py_compiles macro for bitcompile .py files
- Add fix-new-systemd-tmpfiles.d-path.patch to fix tmpfiles.d
  directory
* Tue Oct 30 2012 p.drouand@gmail.com
- Update to 2.0.2 version:
  * No changelog available
- Remove compat-profiles: no versions < 2.0 have been provided
* Thu Oct  4 2012 p.drouand@gmail.com
- Some changes to be more "Suse-like":
  * add systemd suse macro
- Add a patch to fix allow receive
* Fri Sep 28 2012 p.drouand@gmail.com
- Initial release of tuned
