#
# spec file for package python36
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%global flavor base%{nil}
%if "%{flavor}" == "doc"
%define psuffix -documentation
%if 0%{?suse_version} >= 1500
%bcond_without doc
%else
%bcond_with doc
%endif
%bcond_with base
%bcond_with general
%endif
%if "%{flavor}" == "base"
%define psuffix -core
%bcond_with doc
%bcond_without base
%bcond_with general
%endif
%if "%{flavor}" == ""
%define psuffix %{nil}
%bcond_with doc
%bcond_with base
%bcond_without general
%if 0%{?suse_version} >= 1500
%bcond_without appstream
%else
%bcond_with appstream
%endif
%endif

# deadlocks on test_faulthandler and blocks the build
%if 0%{?do_profiling} && !0%{?qemu_user_space_build}
%bcond_without profileopt
%else
%bcond_with profileopt
%endif

%define _version %(c=%{version}; echo ${c/[a-z]*/})
%define tar_suffix %(c=%{_version}; echo ${c#%{_version}})
%define python_version %(c=%{_version}; echo ${c:0:3})
# based on the current source tarball
%define python_version_abitag %(c=%{python_version}; echo ${c//./})
# FIXME %%define python_version_soname %%(c=%%{python_version}; echo ${c//./_})
%define         python_version_soname   3_6
%if 0%(test -n "%{tar_suffix}" && echo 1)
%define _version %(echo "%{_version}~%{tar_suffix}")
%define tarversion %{version}
%else
%define tarversion %{version}
%endif
# Will provide the python3-* provides
# Will do the /usr/bin/python3 and all the core links
%if 0%{?suse_version} >= 1500 && 0%{?suse_version} < 1550
%define         primary_interpreter 1
%define         python_pkg_name python3
%else
%define         primary_interpreter 0
%define         python_pkg_name python36
%endif
%define         folderversion %{tarversion}
%define         tarname    Python-%{tarversion}
%define         sitedir         %{_libdir}/python%{python_version}
# three possible ABI kinds: m - pymalloc, d - debug build; see PEP 3149
%define         abi_kind   m
# python ABI version - used in some file names
%define         python_abi %{python_version}%{abi_kind}
# soname ABI tag defined in PEP 3149
%define         abi_tag    %{python_version_abitag}%{abi_kind}
# version part of "libpython" package
%define         so_major 1
%define         so_minor 0
%define         so_version %{python_version_soname}%{abi_kind}%{so_major}_%{so_minor}
# rpm and python have different ideas about what is an arch-dependent name, so:
%if "%{__isa_name}" == "ppc"
%define archname %(echo %{_arch} | sed s/ppc/powerpc/)
%else
%define archname %{_arch}
%endif
# our arm has Hardware-Floatingpoint
%if "%{_arch}" == "arm"
%define armsuffix hf
%endif
# pyexpat.cpython-35m-x86_64-linux-gnu
# pyexpat.cpython-35m-powerpc64le-linux-gnu
# pyexpat.cpython-35m-armv7-linux-gnueabihf
# _md5.cpython-36m-x86_64-linux-gnu.so
%define dynlib() %{sitedir}/lib-dynload/%{1}.cpython-%{abi_tag}-%{archname}-%{_os}%{?_gnu}%{?armsuffix}.so
Name:           %{python_pkg_name}%{psuffix}
Version:        3.6.15
Release:        150300.10.97.1
Summary:        Python 3 Interpreter
License:        Python-2.0
URL:            https://www.python.org/
Source0:        https://www.python.org/ftp/python/%{folderversion}/%{tarname}.tar.xz
Source1:        https://www.python.org/ftp/python/%{folderversion}/%{tarname}.tar.xz.asc
Source2:        baselibs.conf
Source3:        README.SUSE
Source7:        macros.python3
Source8:        import_failed.py
Source9:        import_failed.map
Source11:       skipped_tests.py
Source12:       idle3.desktop
Source13:       idle3.appdata.xml
# Fixed bundled wheels
Source20:       setuptools-44.1.1-py2.py3-none-any.whl
Source21:       pip-20.0.2-py2.py3-none-any.whl
# The following files are not used in the build.
# They are listed here to work around missing functionality in rpmbuild,
# which would otherwise exclude them from distributed src.rpm files.
# Originally from https://www.python.org/static/files/pubkeys.txt#/python.keyring
Source99:       python.keyring
Source100:      PACKAGING-NOTES
# Patches generated from opensuse_3.6 branch of https://github.com/openSUSE-Python/cpython
# All metadata in commit messages of individual commits
Patch01:        Python-3.0b1-record-rpm.patch
Patch02:        python-3.6.0-multilib-new.patch
Patch04:        python-3.3.0b1-localpath.patch
Patch05:        pep538_coerce_legacy_c_locale.patch
Patch06:        python-3.3.0b1-fix_date_time_compiler.patch
Patch07:        python-3.3.0b1-curses-panel.patch
Patch15:        subprocess-raise-timeout.patch
Patch20:        python-3.6-CVE-2017-18207.patch
Patch21:        0001-allow-for-reproducible-builds-of-python-packages.patch
Patch22:        distutils-reproducible-compile.patch
Patch23:        skip_random_failing_tests.patch
Patch24:        python3-sorted_tar.patch
Patch29:        bpo23395-PyErr_SetInterrupt-signal.patch
Patch30:        aarch64-prolong-timeout.patch
Patch31:        skip_SSL_tests.patch
Patch35:        CVE-2019-9674-zip-bomb.patch
Patch36:        riscv64-support.patch
Patch37:        riscv64-ctypes.patch
Patch39:        ignore_pip_deprec_warn.patch
Patch40:        sphinx-update-removed-function.patch
Patch41:        remove-sphinx40-warning.patch
Patch43:        CVE-2015-20107-mailcap-unsafe-filenames.patch
Patch44:        bpo-46623-skip-zlib-s390x.patch
Patch45:        CVE-2021-28861-double-slash-path.patch
Patch46:        CVE-2020-10735-DoS-no-limit-int-size.patch
Patch47:        CVE-2022-37454-sha3-buffer-overflow.patch
Patch48:        bsc1188607-pythreadstate_clear-decref.patch
Patch49:        CVE-2022-45061-DoS-by-IDNA-decode.patch
Patch50:        bpo27321-email-no-replace-header.patch
Patch51:        CVE-2023-24329-blank-URL-bypass.patch
Patch52:        bpo-44434-libgcc_s-for-pthread_cancel.patch
Patch53:        CVE-2007-4559-filter-tarfile_extractall.patch
Patch54:        99366-patch.dict-can-decorate-async.patch
Patch55:        CVE-2023-40217-avoid-ssl-pre-close.patch
Patch56:        bpo38361-syslog-no-slash-ident.patch
Patch57:        CVE-2023-27043-email-parsing-errors.patch
Patch58:        CVE-2023-6597-TempDir-cleaning-symlink.patch
Patch59:        CVE-2023-52425-libexpat-2.6.0-backport.patch
Patch60:        bh42369-thread-safety-zipfile-SharedFile.patch
Patch61:        CVE-2024-0450-zipfile-avoid-quoted-overlap-zipbomb.patch
Patch62:        bpo-41675-modernize-siginterrupt.patch
Patch63:        CVE-2024-0397-memrace_ssl.SSLContext_cert_store.patch
Patch64:        CVE-2024-4032-private-IP-addrs.patch
Patch65:        CVE-2024-6923-email-hdr-inject.patch
Patch66:        CVE-2024-7592-quad-complex-cookies.patch
Patch67:        CVE-2024-5642-switch-off-NPN.patch
Patch68:        CVE-2024-6232-ReDOS-backtrack-tarfile.patch
Patch69:        CVE-2024-9287-venv_path_unquoted.patch
Patch70:        CVE-2024-11168-validation-IPv6-addrs.patch
# PATCH-FIX-UPSTREAM CVE-2025-0938-sq-brackets-domain-names.patch bsc#1236705 mcepl@suse.com
# functions `urllib.parse.urlsplit` and `urlparse` accept domain names including square brackets
Patch71:        CVE-2025-0938-sq-brackets-domain-names.patch
# PATCH-FIX-UPSTREAM CVE-2025-4516-DecodeError-handler.patch bsc#1243273 mcepl@suse.com
# prevent DDoS in unicode_escape codec
Patch72:        CVE-2025-4516-DecodeError-handler.patch
# PATCH-FEATURE-UPSTREAM ipaddress-update-pr60.patch gh#phihag/ipaddress!60 mcepl@suse.com
# update ipaddress to 3.8 equivalent
Patch73:        ipaddress-update-pr60.patch
# PATCH-FIX-UPSTREAM gh-128840_parse-IPv6-with-emb-IPv4.patch bsc#1244401 mcepl@suse.com
# protect against unrully IPv4-in-IPv6 addresses
Patch74:        gh-128840_parse-IPv6-with-emb-IPv4.patch
# PATCH-FIX-UPSTREAM CVE-2025-6069-quad-complex-HTMLParser.patch bsc#1244705 mcepl@suse.com
# avoid quadratic complexity when processing malformed inputs with HTMLParser
Patch75:        CVE-2025-6069-quad-complex-HTMLParser.patch
# PATCH-FIX-UPSTREAM CVE-2025-4435-normalize-lnk-trgts-tarfile.patch bsc#1244061 mcepl@suse.com
# Patch from gh#fedora-python/cpython!129
# Normalize link targets in tarfile, add os.path.realpath(strict='allow_missing')
Patch76:        CVE-2025-4435-normalize-lnk-trgts-tarfile.patch
# PATCH-FIX-UPSTREAM CVE-2025-8194-tarfile-no-neg-offsets.patch bsc#1247249 mcepl@suse.com
# tarfile now validates archives to ensure member offsets are non-negative
Patch77:        CVE-2025-8194-tarfile-no-neg-offsets.patch
BuildRequires:  automake
BuildRequires:  fdupes
BuildRequires:  gmp-devel
%if 0%{?sle_version} >= 120000 && 0%{?sle_version} < 120400
BuildRequires:  libopenssl-devel
%else
BuildRequires:  libopenssl-1_1-devel
%endif
BuildRequires:  lzma-devel
BuildRequires:  netcfg
BuildRequires:  pkgconfig
BuildRequires:  xz
BuildRequires:  pkgconfig(bzip2)
BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(libffi)
BuildRequires:  pkgconfig(zlib)
#!BuildIgnore:  gdk-pixbuf-loader-rsvg
%if 0%{?suse_version} >= 1550
# The provider for python(abi) is in rpm-build-python
BuildRequires:  rpm-build-python
%endif
%if 0%{?suse_version} >= 1500
BuildRequires:  pkgconfig(libnsl)
BuildRequires:  pkgconfig(libtirpc)
%endif
%if %{with doc}
%if 0%{?sle_version} && 0%{?sle_version} <= 150300
# Here we just run sphinx and we can use generic one, we don't need
# the flavor variant
BuildRequires:  python3-Sphinx
%else
# This is because of single-Python images on multi-Python
# distributions (bsc#1183858)
BuildRequires:  %{python_pkg_name}-Sphinx
%endif
%endif
%if %{with general}
# required for idle3 (.desktop and .appdata.xml files)
%if %{with appstream}
BuildRequires:  appstream-glib
%endif
BuildRequires:  gcc-c++
BuildRequires:  gdbm-devel
BuildRequires:  gettext
BuildRequires:  readline-devel
BuildRequires:  sqlite-devel
BuildRequires:  timezone
BuildRequires:  pkgconfig(ncurses)
BuildRequires:  pkgconfig(tk)
BuildRequires:  pkgconfig(x11)
Requires:       %{python_pkg_name}-base = %{version}
Recommends:     %{python_pkg_name}-curses
Recommends:     %{python_pkg_name}-dbm
Recommends:     %{python_pkg_name}-pip
Provides:       python = %{python_version}
%if %{primary_interpreter}
Provides:       python3 = %{python_version}
Obsoletes:      python3 <= %{python_version}
Provides:       python36 = %{version}
Obsoletes:      python36 <= %{version}
%endif
%endif

%description
Python 3 is modern interpreted, object-oriented programming language,
often compared to Tcl, Perl, Scheme, or Java.  You can find an overview
of Python in the documentation and tutorials included in the python3-doc
package.

This package supplies rich command line features provided by readline,
and sqlite3 support for the interpreter core, thus forming a so called
"extended" runtime.
Installing "python3" is sufficient for the vast majority of usecases.
In addition, recommended packages provide UI toolkit support (python3-curses,
python3-tk), legacy UNIX database bindings (python3-dbm), and the IDLE
development environment (python3-idle).

%package -n %{python_pkg_name}-tk
Summary:        TkInter, a Python Tk Interface
Requires:       %{python_pkg_name} = %{version}
%if %{primary_interpreter}
Provides:       python3-tk = %{version}
Obsoletes:      python3-tk < %{version}
Provides:       python36-tk = %{version}
Obsoletes:      python36-tk <= %{version}
%endif

%description -n %{python_pkg_name}-tk
Python interface to Tk. Tk is the GUI toolkit that comes with Tcl.

%package -n %{python_pkg_name}-curses
Summary:        Python Interface to the (N)Curses Library
Requires:       %{python_pkg_name} = %{version}
%if %{primary_interpreter}
Provides:       python3-curses = %{version}
Obsoletes:      python3-curses < %{version}
Provides:       python36-curses = %{version}
Obsoletes:      python36-curses <= %{version}
%endif

%description -n %{python_pkg_name}-curses
An easy to use interface to the (n)curses CUI library. CUI stands for
Console User Interface.

%package -n %{python_pkg_name}-dbm
Summary:        Python Interface to the GDBM Library
Requires:       %{python_pkg_name} = %{version}
%if %{primary_interpreter}
Provides:       python3-dbm = %{version}
Obsoletes:      python3-dbm < %{version}
Provides:       python36-dbm = %{version}
Obsoletes:      python36-dbm <= %{version}
%endif

%description -n %{python_pkg_name}-dbm
An easy to use interface for Unix DBM databases, and more specifically,
the GNU implementation GDBM.

%package -n %{python_pkg_name}-idle
Summary:        An Integrated Development Environment for Python
Requires:       %{python_pkg_name} = %{version}
Requires:       %{python_pkg_name}-tk
%if %{primary_interpreter}
Provides:       python3-idle = %{version}
Obsoletes:      python3-idle < %{version}
Provides:       python36-idle = %{version}
Obsoletes:      python36-idle <= %{version}
%endif

%description -n %{python_pkg_name}-idle
IDLE is a Tkinter based integrated development environment for Python.
It features a multi-window text editor with multiple undo, Python
colorizing, and many other things, as well as a Python shell window and
a debugger.

%package -n %{python_pkg_name}-doc
Summary:        Package Documentation for Python 3
Enhances:       %{python_pkg_name} = %{python_version}
%if %{primary_interpreter}
Provides:       python3-doc = %{version}
Obsoletes:      python3-doc < %{version}
Provides:       python36-doc = %{version}
Obsoletes:      python36-doc <= %{version}
%endif

%description -n %{python_pkg_name}-doc
Tutorial, Global Module Index, Language Reference, Library Reference,
Extending and Embedding Reference, Python/C API Reference, Documenting
Python, and Macintosh Module Reference in HTML format.

%package -n %{python_pkg_name}-doc-devhelp
Summary:        Additional Package Documentation for Python 3 in devhelp format
%if %{primary_interpreter}
Provides:       python3-doc-devhelp = %{version}
Obsoletes:      python3-doc-devhelp < %{version}
Provides:       python36-doc-devhelp = %{version}
Obsoletes:      python36-doc-devhelp <= %{version}
%endif

%description -n %{python_pkg_name}-doc-devhelp
Tutorial, Global Module Index, Language Reference, Library Reference,
Extending and Embedding Reference, Python/C API Reference, Documenting
Python, and Macintosh Module Reference in format for devhelp.

%package -n %{python_pkg_name}-base
Summary:        Python 3 Interpreter and Stdlib Core
Requires:       libpython%{so_version} = %{version}
Recommends:     %{python_pkg_name} = %{version}
#Recommends:     python3-ensurepip
# python 3.1 didn't have a separate python-base, so it is wrongly
# not a conflict to have python3-3.1 and python3-base > 3.1
Obsoletes:      python3 < 3.2
# no Provides, because python3 is obviously provided by package python3
# python 3.4 provides asyncio
Provides:       %{python_pkg_name}-asyncio = %{version}
# python 3.6 provides typing
Provides:       %{python_pkg_name}-typing = %{version}
# python3-xml was merged into python3, now moved into -base
Provides:       %{python_pkg_name}-xml = %{version}
%if %{primary_interpreter}
Provides:       python3-asyncio = %{version}
Provides:       python3-base = %{version}
Obsoletes:      python3-asyncio < %{version}
Obsoletes:      python3-base < %{version}
Provides:       python3-typing = %{version}
Obsoletes:      python3-typing < %{version}
Provides:       python3-xml = %{version}
Obsoletes:      python3-xml < %{version}

Provides:       python36-asyncio = %{version}
Provides:       python36-base = %{version}
Provides:       python36-typing = %{version}
Provides:       python36-xml = %{version}
Obsoletes:      python36-asyncio <= %{version}
Obsoletes:      python36-base <= %{version}
Obsoletes:      python36-typing <= %{version}
Obsoletes:      python36-xml <= %{version}
%endif

%description -n %{python_pkg_name}-base
Python is an interpreted, object-oriented programming language, and is
often compared to Tcl, Perl, Scheme, or Java.  You can find an overview
of Python in the documentation and tutorials included in the python-doc
package.

This package contains the interpreter core and most commonly used modules
from the standard library. This is sufficient for many usecases, but it
excludes components that depend on external libraries, most notably XML,
database and UI toolkits support.

%package -n %{python_pkg_name}-tools
Summary:        Python Utility and Demonstration Scripts
Requires:       %{python_pkg_name}-base = %{version}
Provides:       %{python_pkg_name}-2to3 = %{version}
Provides:       %{python_pkg_name}-demo = %{version}
%if %{primary_interpreter}
Provides:       python3-2to3 = %{version}
Provides:       python3-demo = %{version}
Provides:       python3-tools = %{version}
Obsoletes:      python3-2to3 < %{version}
Obsoletes:      python3-demo < %{version}
Obsoletes:      python3-tools < %{version}

Provides:       python36-2to3 = %{version}
Provides:       python36-demo = %{version}
Provides:       python36-tools = %{version}
Obsoletes:      python36-2to3 <= %{version}
Obsoletes:      python36-demo <= %{version}
Obsoletes:      python36-tools <= %{version}
%endif

%description -n %{python_pkg_name}-tools
A number of scripts that are useful for building, testing or extending Python,
and a set of demonstration programs.

%package -n %{python_pkg_name}-devel
Summary:        Include Files and Libraries Mandatory for Building Python Modules
Requires:       %{python_pkg_name}-base = %{version}
%if %{primary_interpreter}
Provides:       python3-devel = %{version}
Obsoletes:      python3-devel < %{version}
Provides:       python36-devel = %{version}
Obsoletes:      python36-devel <= %{version}
%endif

%description -n %{python_pkg_name}-devel
The Python programming language's interpreter can be extended with
dynamically loaded extensions and can be embedded in other programs.

This package contains header files, a static library, and development
tools for building Python modules, extending the Python interpreter or
embedding Python in applications.

This also includes the Python distutils, which were in the Python
package up to version 2.2.2.

%package -n %{python_pkg_name}-testsuite
Summary:        Unit tests for Python and its standard library
Requires:       %{python_pkg_name} = %{version}
Requires:       %{python_pkg_name}-tk = %{version}
%if %{primary_interpreter}
Provides:       python3-testsuite = %{version}
Obsoletes:      python3-testsuite < %{version}
Provides:       python36-testsuite = %{version}
Obsoletes:      python36-testsuite <= %{version}
%endif

%description -n %{python_pkg_name}-testsuite
Unit tests that are useful for verifying integrity and functionality
of the installed Python interpreter and standard library.
They are a documented part of stdlib, as a module 'test'.

%package -n libpython%{so_version}
Summary:        Python Interpreter shared library
Requires:       %{python_pkg_name}-base >= %{version}

%description -n libpython%{so_version}
Python is an interpreted, object-oriented programming language, and is
often compared to Tcl, Perl, Scheme, or Java.  You can find an overview
of Python in the documentation and tutorials included in the python-doc
(HTML) or python-doc-pdf (PDF) packages.

This package contains libpython3.2 shared library for embedding in
other applications.

%prep
%autosetup -p1 -n %{tarname}

# drop Autoconf version requirement
sed -i 's/^AC_PREREQ/dnl AC_PREREQ/' configure.ac

%if %{primary_interpreter}
# fix shebangs - convert /usr/local/bin/python and /usr/bin/env/python to /usr/bin/python3
for dir in Lib Tools; do
    # find *.py, filter to files that contain bad shebangs
    # break up "/""usr" like this to prevent replacing with %%{_prefix}
    find $dir -name '*.py' -type f -print0 \
        | xargs -0 grep -lE '^#! *(/''usr/.*bin/(env +)?)?python' \
        | xargs sed -r -i -e '1s@^#![[:space:]]*(/''usr/(local/)?bin/(env +)?)?python([0-9]+(\.[0-9]+)?)?@#!%{_bindir}/python3@'
done
%else
# For non-primary Python, just don't bother (bsc#1193179) and remove all
# those shebangs
for dir in Lib Tools; do
    find $dir -name '*.py' -type f -exec sed -i '1{/^#!.*python/ d}' '{}' \;
done
%endif

# drop in-tree libffi and expat
rm -r Modules/_ctypes/libffi* Modules/_ctypes/darwin
rm -r Modules/expat

# drop duplicate README from site-packages
rm Lib/site-packages/README.txt

# Replace bundled wheels with the updates ones
rm -v Lib/ensurepip/_bundled/*.whl
cp -v %{SOURCE20} %{SOURCE21} Lib/ensurepip/_bundled/
STVER=$(basename %{SOURCE20}|cut -d- -f2)
PIPVER=$(basename %{SOURCE21}|cut -d- -f2)
sed -E -i -e "s/^(\s*_SETUPTOOLS_VERSION\s+=\s+)\"[0-9.]+\"/\1\"${STVER}\"/" \
          -e "s/^(\s*_PIP_VERSION\s+=\s+)\"[0-9.]+\"/\1\"${PIPVER}\"/" \
    Lib/ensurepip/__init__.py

%build
%if 0%{?suse_version} < 1500
%define make_build make %{?_smp_mflags} V=1 VERBOSE=1
%endif

%if %{with doc}
TODAY_DATE=`date -r %{SOURCE0} "+%%B %%d, %%Y"`
# TODO use not date of tarball but date of latest patch

cd Doc
sed -i "s/^today = .*/today = '$TODAY_DATE'/" conf.py
%make_build -j1 html

# Build also devhelp files
sphinx-build -a -b devhelp . build/devhelp
rm -rfv build/devhelp/.doctrees
%else
%define _lto_cflags %{nil}
# use rpm_opt_flags
%if 0%{?suse_version} < 1500
export OPT="%{optflags} -DOPENSSL_LOAD_CONF -fwrapv $(pkg-config --cflags-only-I libffi)"
%else
export OPT="%{optflags} -DOPENSSL_LOAD_CONF -fwrapv $(pkg-config --cflags-only-I libffi) -fno-semantic-interposition"
%endif

touch -r %{SOURCE0} Makefile.pre.in

autoreconf -fvi

%if 0%{?sles_version}
sed -e 's/-fprofile-correction//' -i Makefile.pre.in
%endif

%configure \
    --docdir=%{_docdir}/python \
    --enable-ipv6 \
    --enable-shared \
    --with-fpectl \
    --with-ensurepip=no \
    --with-system-ffi \
    --with-system-expat \
    --without-lto \
%if %{with profileopt}
    --enable-optimizations \
%endif
    --enable-loadable-sqlite-extensions

# prevent make from trying to rebuild PYTHON_FOR_GEN stuff
%make_build -t Python/Python-ast.c \
        Include/Python-ast.h \
        Objects/typeslots.inc \
        Python/opcode_targets.h \
        Include/opcode.h

%if %{with general}
%make_build
%endif
%if %{with base}
%if %{with profileopt}
    target=profile-opt
%else
    target=all
%endif
LD_LIBRARY_PATH=.:$LD_LIBRARY_PATH \
    %make_build -j 1 $target
%endif
%endif

%check
export SLE_VERSION=%{sle_version}
# export LANG=en_US.UTF-8
%if %{with general}
# exclude test_gdb -- it doesn't run in buildservice anyway, and fails on missing debuginfos
# when you install gdb into your test env
EXCLUDE="test_gdb"
# we patch out the message to recommend zypper in and thus this would fail
EXCLUDE="$EXCLUDE test_pydoc"

%ifarch %{arm} s390x
# test_multiprocessing_forkserver is racy
EXCLUDE="$EXCLUDE test_multiprocessing_forkserver"
%endif
%ifarch ppc ppc64 ppc64le
# exclue test_faulthandler due to bnc#831629
EXCLUDE="$EXCLUDE test_faulthandler"
%endif
# some tests break in QEMU
%if 0%{?qemu_user_space_build}
EXCLUDE="$EXCLUDE test_faulthandler test_multiprocessing_forkserver test_multiprocessing_spawn test_posix test_os test_socket"
# qemu bug (siginterrupt handling)
EXCLUDE="$EXCLUDE test_signal"
%endif

# gh#python/cpython#81350
%if 0%{?suse_version} <= 1500
EXCLUDE="$EXCLUDE test_capi"
%endif

# This test (part of test_uuid) requires real network interfaces
# so that ifconfig output has "HWaddr <something>".  Some kvm instances
# done have any such interface breaking the uuid module.
EXCLUDE="$EXCLUDE test_uuid"

# TEMPORARILY EXCLUDE test_capi bpo#37169
EXCLUDE="$EXCLUDE test_capi"

# Limit virtual memory to avoid spurious failures
if test $(ulimit -v) = unlimited || test $(ulimit -v) -gt 10000000; then
  ulimit -v 10000000 || :
fi

export PYTHONPATH="$(pwd -P)/Lib"
# Use timeout, like make target buildbottest
# We cannot run tests parallel, because osc build environment doesn’t
# have /dev/shm
%make_build -j1 test TESTOPTS="-u curses -v -x $EXCLUDE --timeout=3000"
# use network, be verbose:
#make test TESTOPTS="-l -u network -v"
%endif

%install
%if %{with doc}
export PDOCS=%{buildroot}%{_docdir}/python%{python_version}
mkdir -p $PDOCS
# generated docs
rm Doc/build/*/.buildinfo
cp -r Doc/build/html $PDOCS
# misc
install -d -m 755 $PDOCS/Misc
rm Misc/README.AIX
for i in Misc/* ; do
  [ -f $i ] && install -c -m 644 $i $PDOCS/Misc/
done
# devhelp
mkdir -p %{buildroot}%{_datadir}/gtk-doc/html
cp -r Doc/build/devhelp %{buildroot}%{_datadir}/gtk-doc/html/Python%{python_version}
rm -rf %{buildroot}%{_datadir}/gtk-doc/html/Python%{python_version}/.doctrees
%endif
%if %{with general}
%make_install

# clean out stuff that is in python-base and subpackages

find %{buildroot}%{_bindir} -mindepth 1 -not -name "*idle3*" -print -delete
rm %{buildroot}%{_libdir}/lib*
rm -r %{buildroot}%{_libdir}/pkgconfig
rm -r %{buildroot}%{_mandir}/*
rm -r %{buildroot}%{_includedir}/*

rm -r %{buildroot}%{sitedir}/config*
find %{buildroot}%{sitedir} -name "*.egg-info" -delete
rm -r %{buildroot}%{sitedir}/__pycache__
rm -r %{buildroot}%{sitedir}/site-packages
rm %{buildroot}%{sitedir}/*.*

for module in \
    asyncio ctypes collections concurrent distutils email encodings \
    ensurepip html http \
    importlib json logging multiprocessing pydoc_data unittest \
    urllib venv wsgiref lib2to3 test turtledemo \
    xml xmlrpc
do
    rm -r %{buildroot}%{sitedir}/$module
done

for library in \
    array _asyncio audioop binascii _bisect _bz2 cmath _codecs_* \
    _crypt _csv _ctypes _datetime _decimal fcntl grp \
    _hashlib _heapq _json _lsprof _lzma math mmap _multibytecodec \
    _multiprocessing _opcode ossaudiodev parser _pickle \
    _posixsubprocess _random resource select _ssl _socket spwd \
    _struct syslog termios _testbuffer _testimportmultiple \
    _testmultiphase unicodedata zlib _ctypes_test _testcapi xxlimited \
    _elementtree pyexpat _md5 _sha1 \
    _sha256 _sha512 _blake2 _sha3
do
    eval rm -f "%{buildroot}%{sitedir}/lib-dynload/$library.*"
done

# Idle is not packaged in base due to the appstream-glib dependency
# move idle config into /etc
install -d -m 755 %{buildroot}%{_sysconfdir}/idle%{python_version}
(
    cd %{buildroot}/%{sitedir}/idlelib/
    for file in *.def ; do
        mv $file %{buildroot}%{_sysconfdir}/idle%{python_version}/
        ln -sf %{_sysconfdir}/idle%{python_version}/$file  %{buildroot}/%{sitedir}/idlelib/
    done
)

# keep just idle3.X
rm %{buildroot}%{_bindir}/idle3

# install idle icons
for size in 16 32 48 ; do
    install -m 644 -D Lib/idlelib/Icons/idle_${size}.png \
    %{buildroot}%{_datadir}/icons/hicolor/${size}x${size}/apps/idle%{python_version}.png
done

# install idle desktop file
cp %{SOURCE12} idle%{python_version}.desktop
sed -i -e 's:idle3:idle%{python_version}:g' idle%{python_version}.desktop
mkdir -p %{buildroot}%{_datadir}/applications
install -m 644 -D -t %{buildroot}%{_datadir}/applications idle%{python_version}.desktop

%if %{with appstream}
cp %{SOURCE13} idle%{python_version}.appdata.xml
sed -i -e 's:idle3.desktop:idle%{python_version}.desktop:g' idle%{python_version}.appdata.xml
mkdir -p %{buildroot}%{_datadir}/metainfo
install -m 644 -D -t %{buildroot}%{_datadir}/metainfo idle%{python_version}.appdata.xml
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/idle%{python_version}.appdata.xml
%endif

%fdupes %{buildroot}/%{_libdir}/python%{python_version}
%endif
%if %{with base}
%make_install

# remove .a
find %{buildroot} -name "*.a" -delete

# install "site-packages" and __pycache__ for third parties
install -d -m 755 %{buildroot}%{sitedir}/site-packages
install -d -m 755 %{buildroot}%{sitedir}/site-packages/__pycache__
# and their 32bit counterparts explicitly
mkdir -p %{buildroot}%{_prefix}/lib/python%{python_version}/site-packages/__pycache__

# cleanup parts that don't belong
for dir in curses dbm sqlite3 tkinter idlelib; do
    find "%{buildroot}/%{sitedir}/$dir"/* -maxdepth 0 -name "test" -o -exec rm -rf {} +
done
rm -fv %{buildroot}%{dynlib nis}

# overwrite the copied binary with a link
ln -sf python%{python_version} %{buildroot}%{_bindir}/python3

# decide to ship python3 or just python3.X
%if !%{primary_interpreter}
# base
rm %{buildroot}%{_bindir}/python3
rm %{buildroot}%{_bindir}/pydoc3
rm %{buildroot}%{_bindir}/pyvenv
rm %{buildroot}%{_mandir}/man1/python3.1
# devel
rm %{buildroot}%{_bindir}/python3-config
rm -f %{buildroot}%{_libdir}/libpython3.so
rm %{buildroot}%{_libdir}/pkgconfig/python3.pc
%endif

# link shared library instead of static library that tools expect
ln -s ../../libpython%{python_abi}.so %{buildroot}%{_libdir}/python%{python_version}/config-%{python_abi}-%{archname}-%{_os}%{?_gnu}%{?armsuffix}/libpython%{python_abi}.so

# delete idle3, which has to many packaging dependencies for base
rm %{buildroot}%{_bindir}/idle3*

# delete the generic 2to3 binary if we are not primary
%if !%{primary_interpreter}
rm %{buildroot}%{_bindir}/2to3
%endif

# replace duplicate .pyo/.pyc with hardlinks
%fdupes %{buildroot}/%{sitedir}

# documentation
export PDOCS=%{buildroot}%{_docdir}/%{name}
install -d -m 755 $PDOCS
install -c -m 644 %{SOURCE3} $PDOCS/
install -c -m 644 README.rst $PDOCS/

# tools
for x in `find Tools/ \( -not -name Makefile \) -print | sort` ; do
  test -d $x && ( install -c -m 755 -d $PDOCS/$x ) \
             || ( install -c -m 644 $x $PDOCS/$x )
done
# gdb script is shipped with devel subpackage
rm -r $PDOCS/Tools/gdb
# clean up the bat files
find "$PDOCS" -name "*.bat" -delete

# put gdb helper script into place
install -m 755 -D Tools/gdb/libpython.py %{buildroot}%{_datadir}/gdb/auto-load/%{_libdir}/libpython%{python_abi}.so.%{so_major}.%{so_minor}-gdb.py

# install devel files to /config
#cp Makefile Makefile.pre.in Makefile.pre $RPM_BUILD_ROOT%{sitedir}/config-%{python_abi}/

# Remove -IVendor/ from python-config boo#1231795
sed -i 's/-IVendor\///' %{buildroot}%{_bindir}/python%{python_abi}-config

# RPM macros
%if %{primary_interpreter}
mkdir -p %{buildroot}%{_rpmconfigdir}/macros.d/
install -m 644 %{SOURCE7} %{buildroot}%{_rpmconfigdir}/macros.d/ # macros.python3
%endif

# import_failed hooks
FAILDIR=%{buildroot}/%{sitedir}/_import_failed
mkdir $FAILDIR
install -m 644 %{SOURCE8} %{SOURCE9} $FAILDIR # import_failed.*
LD_LIBRARY_PATH=. ./python -c "from py_compile import compile; compile('$FAILDIR/import_failed.py', dfile='%{sitedir}/_import_failed/import_failed.py')"
LD_LIBRARY_PATH=. ./python -O -c "from py_compile import compile; compile('$FAILDIR/import_failed.py', dfile='%{sitedir}/_import_failed/import_failed.py')"
(
    cd $FAILDIR
    while read package modules; do
        for module in $modules; do
            ln import_failed.py $module.py
            pushd __pycache__
            for i in import_failed*; do
                ln $i "$module${i#import_failed}"
            done
            popd
        done
    done < %{SOURCE9}
)
echo %{sitedir}/_import_failed > %{buildroot}/%{sitedir}/site-packages/zzzz-import-failed-hooks.pth
%endif

# For the purposes of reproducibility, it is necessary to eliminate any *.pyc files inside documentation dirs
if [ -d %{buildroot}%{_defaultdocdir} ] ; then
find %{buildroot}%{_defaultdocdir} -type f -name \*.pyc -ls -exec rm -vf '{}' \;
fi

%if %{with general}
%files -n %{python_pkg_name}-tk
%{sitedir}/tkinter
%exclude %{sitedir}/tkinter/test
%{dynlib _tkinter}

%files -n %{python_pkg_name}-curses
%{sitedir}/curses
%{dynlib _curses}
%{dynlib _curses_panel}

%files -n %{python_pkg_name}-dbm
%{sitedir}/dbm
%{dynlib _dbm}
%{dynlib _gdbm}

%files -n %{python_pkg_name}
%dir %{sitedir}
%dir %{sitedir}/lib-dynload
%{sitedir}/sqlite3
%exclude %{sitedir}/sqlite3/test
%{dynlib readline}
%{dynlib _sqlite3}
%{dynlib nis}

%files -n %{python_pkg_name}-idle
%{sitedir}/idlelib
%dir %{_sysconfdir}/idle%{python_version}
%config %{_sysconfdir}/idle%{python_version}/*
%doc Lib/idlelib/NEWS.txt
%doc Lib/idlelib/README.txt
%doc Lib/idlelib/TODO.txt
%doc Lib/idlelib/extend.txt
%doc Lib/idlelib/ChangeLog
%{_bindir}/idle%{python_version}
%{_datadir}/applications/idle%{python_version}.desktop
%if %{with appstream}
%dir %{_datadir}/metainfo
%{_datadir}/metainfo/idle%{python_version}.appdata.xml
%endif
%{_datadir}/icons/hicolor/*/apps/idle%{python_version}.png
%dir %{_datadir}/icons/hicolor
%dir %{_datadir}/icons/hicolor/16x16
%dir %{_datadir}/icons/hicolor/32x32
%dir %{_datadir}/icons/hicolor/48x48
%dir %{_datadir}/icons/hicolor/*/apps
%attr(755, root, root) %{_bindir}/idle%{python_version}
# endif for if general
%endif

%if %{with doc}
%files -n %{python_pkg_name}-doc
%dir %{_docdir}/python%{python_version}
%doc %{_docdir}/python%{python_version}/Misc
%doc %{_docdir}/python%{python_version}/html

%files -n %{python_pkg_name}-doc-devhelp
%dir %{_datadir}/gtk-doc
%dir %{_datadir}/gtk-doc/html
%doc %{_datadir}/gtk-doc/html/Python%{python_version}
%endif

%if %{with base}
%post -n libpython%{so_version} -p /sbin/ldconfig
%postun -n libpython%{so_version} -p /sbin/ldconfig

%files -n libpython%{so_version}
%{_libdir}/libpython%{python_abi}.so.%{so_major}.%{so_minor}

%files -n %{python_pkg_name}-tools
%{sitedir}/turtledemo
%if %{primary_interpreter}
%{_bindir}/2to3
%endif
%attr(755, root, root)%{_bindir}/2to3-%{python_version}
%doc %{_docdir}/%{name}/Tools

%files -n %{python_pkg_name}-devel
%{_libdir}/libpython%{python_abi}.so
%if %{primary_interpreter}
%{_libdir}/libpython3.so
%endif
%{_libdir}/pkgconfig/*
%{_includedir}/python%{python_abi}
%{sitedir}/config-%{python_abi}-*
%{_bindir}/python%{python_abi}-config
%{_bindir}/python%{python_version}-config
%if %{primary_interpreter}
%{_bindir}/python3-config
%endif
# Own these directories to not depend on gdb
%dir %{_datadir}/gdb
%dir %{_datadir}/gdb/auto-load
%dir %{_datadir}/gdb/auto-load%{_prefix}
%dir %{_datadir}/gdb/auto-load%{_libdir}
%{_datadir}/gdb/auto-load/%{_libdir}/libpython%{python_abi}.so.%{so_major}.%{so_minor}-gdb.py

%files -n %{python_pkg_name}-testsuite
%{sitedir}/test
%{sitedir}/*/test
%{sitedir}/*/tests
%{dynlib _ctypes_test}
%{dynlib _testbuffer}
%{dynlib _testcapi}
%{dynlib _testimportmultiple}
%{dynlib _testmultiphase}
%{dynlib xxlimited}
# workaround for missing packages
%dir %{sitedir}/sqlite3
%dir %{sitedir}/tkinter

%files -n %{python_pkg_name}-base
# docs
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README.rst
%license LICENSE
%doc %{_docdir}/%{name}/README.SUSE
%if %{primary_interpreter}
%{_mandir}/man1/python3.1%{?ext_man}
%endif
%{_mandir}/man1/python%{python_version}.1%{?ext_man}
# license text, not a doc because the code can use it at run-time
%{sitedir}/LICENSE.txt
# RPM macros
%if %{primary_interpreter}
%{_rpmconfigdir}/macros.d/macros.python3
%endif
# binary parts
%dir %{sitedir}/lib-dynload
%{dynlib array}
%{dynlib _asyncio}
%{dynlib audioop}
%{dynlib binascii}
%{dynlib _bisect}
%{dynlib _bz2}
%{dynlib cmath}
%{dynlib _codecs_cn}
%{dynlib _codecs_hk}
%{dynlib _codecs_iso2022}
%{dynlib _codecs_jp}
%{dynlib _codecs_kr}
%{dynlib _codecs_tw}
%{dynlib _crypt}
%{dynlib _csv}
%{dynlib _ctypes}
%{dynlib _datetime}
%{dynlib _decimal}
%{dynlib _elementtree}
%{dynlib fcntl}
%{dynlib grp}
%{dynlib _hashlib}
%{dynlib _heapq}
%{dynlib _json}
%{dynlib _lsprof}
%{dynlib _lzma}
%{dynlib math}
%{dynlib mmap}
%{dynlib _multibytecodec}
%{dynlib _multiprocessing}
%{dynlib _opcode}
%{dynlib ossaudiodev}
%{dynlib parser}
%{dynlib _pickle}
%{dynlib _posixsubprocess}
%{dynlib pyexpat}
%{dynlib _random}
%{dynlib resource}
%{dynlib select}
%{dynlib _socket}
%{dynlib spwd}
%{dynlib _ssl}
%{dynlib _struct}
%{dynlib syslog}
%{dynlib termios}
%{dynlib unicodedata}
%{dynlib zlib}
# hashlib fallback modules
%{dynlib _blake2}
%{dynlib _md5}
%{dynlib _sha1}
%{dynlib _sha256}
%{dynlib _sha512}
%{dynlib _sha3}
# python parts
%dir %{_prefix}/lib/python%{python_version}
%dir %{_prefix}/lib/python%{python_version}/site-packages
%dir %{_prefix}/lib/python%{python_version}/site-packages/__pycache__
%dir %{sitedir}
%dir %{sitedir}/site-packages
%dir %{sitedir}/site-packages/__pycache__
%exclude %{sitedir}/*/test
%exclude %{sitedir}/*/tests
%{sitedir}/*.py
%{sitedir}/asyncio
%{sitedir}/ctypes
%{sitedir}/collections
%{sitedir}/concurrent
%{sitedir}/distutils
%{sitedir}/email
%{sitedir}/encodings
%{sitedir}/ensurepip
%{sitedir}/html
%{sitedir}/http
%{sitedir}/importlib
%{sitedir}/json
%{sitedir}/lib2to3
%{sitedir}/logging
%{sitedir}/multiprocessing
%{sitedir}/pydoc_data
%{sitedir}/unittest
%{sitedir}/urllib
%{sitedir}/venv
%{sitedir}/wsgiref
%{sitedir}/xml
%{sitedir}/xmlrpc
%{sitedir}/__pycache__
# import-failed hooks
%{sitedir}/_import_failed
%{sitedir}/site-packages/zzzz-import-failed-hooks.pth
# symlinks
%if %{primary_interpreter}
%{_bindir}/python3
%{_bindir}/pydoc3
%{_bindir}/pyvenv
%endif
# executables
%attr(755, root, root) %{_bindir}/pydoc%{python_version}
%attr(755, root, root) %{_bindir}/python%{python_abi}
%attr(755, root, root) %{_bindir}/python%{python_version}
%attr(755, root, root) %{_bindir}/pyvenv-%{python_version}
# endif for if base
%endif

%changelog
* Fri Aug  1 2025 mcepl@cepl.eu
- Add CVE-2025-8194-tarfile-no-neg-offsets.patch which now
  validates archives to ensure member offsets are non-negative
  (gh#python/cpython#130577, CVE-2025-8194, bsc#1247249).
* Wed Jul  2 2025 mcepl@cepl.eu
- Add CVE-2025-4435-normalize-lnk-trgts-tarfile.patch
  Security fixes for CVE-2025-4517, CVE-2025-4330, CVE-2025-4138,
  CVE-2024-12718, CVE-2025-4435 on tarfile (bsc#1244032,
  bsc#1244061, bsc#1244059, bsc#1244060, bsc#1244056).
  The backported fixes do not contain changes for ntpath.py and
  related tests, because the support for symlinks and junctions
  were added later in Python 3.9, and it does not make sense to
  backport them to 3.6 here.
  The patch is contains the following changes:
  - python@42deeab fixes symlink handling for tarfile.data_filter
  - python@9d2c2a8 fixes handling of existing files/symlinks in tarfile
  - python@00af979 adds a new "strict" argument to realpath()
  - python@dd8f187 fixes mulriple CVE fixes in the tarfile module
  - downstream only fixes that makes the changes work and
    compatible with Python 3.6
- Add CVE-2025-6069-quad-complex-HTMLParser.patch to avoid worst
  case quadratic complexity when processing certain crafted
  malformed inputs with HTMLParser (CVE-2025-6069, bsc#1244705).
* Thu Jun 12 2025 daniel.garcia@suse.com
- Add python36-* provides/obsoletes to enable SLE-12 -> SLE-15
  migration, bsc#1233012
* Tue Jun 10 2025 mcepl@suse.com
- Add ipaddress-update-pr60.patch from gh#phihag/ipaddress!60 to
  update vendored ipaddress module to 3.8 equivalent
- Add gh-128840_parse-IPv6-with-emb-IPv4.patch to limit buffer
  size for IPv6 address parsing (gh#python/cpython#128840,
  bsc#1244401).
- Update CVE-2025-4516-DecodeError-handler.patch not to break
  _PyBytes_DecodeEscape signature.
* Thu May 22 2025 mcepl@cepl.eu
- Add CVE-2025-4516-DecodeError-handler.patch fixing
  CVE-2025-4516 (bsc#1243273) blocking DecodeError handling
  vulnerability, which could lead to DoS.
* Wed Mar 12 2025 mcepl@suse.com
- Update CVE-2024-11168-validation-IPv6-addrs.patch
  according to the Debian version
  (gh#python/cpython#103848#issuecomment-2708135083).
* Tue Feb  4 2025 mcepl@cepl.eu
- Add CVE-2025-0938-sq-brackets-domain-names.patch which
  disallows square brackets ([ and ]) in domain names for parsed
  URLs (bsc#1236705, CVE-2025-0938, gh#python/cpython#105704)
* Thu Nov 14 2024 mcepl@cepl.eu
- Remove -IVendor/ from python-config boo#1231795
- Fix CVE-2024-11168-validation-IPv6-addrs.patch
- PGO run of build freezes with parallel processing, switch to -j1
* Wed Nov 13 2024 mcepl@cepl.eu
- Add CVE-2024-11168-validation-IPv6-addrs.patch
  fixing bsc#1233307 (CVE-2024-11168,
  gh#python/cpython#103848): Improper validation of IPv6 and
  IPvFuture addresses.
* Thu Oct 24 2024 mcepl@cepl.eu
- Add CVE-2024-9287-venv_path_unquoted.patch to properly quote
  path names provided when creating a virtual environment
  (bsc#1232241, CVE-2024-9287)
* Wed Oct  2 2024 mcepl@cepl.eu
- Drop .pyc files from docdir for reproducible builds
  (bsc#1230906).
* Wed Sep 18 2024 mcepl@cepl.eu
- Add CVE-2024-6232-ReDOS-backtrack-tarfile.patch prevent
  ReDos via excessive backtracking while parsing header values
  (bsc#1230227, CVE-2024-6232).
* Wed Sep 18 2024 mcepl@cepl.eu
- Add CVE-2024-5642-switch-off-NPN.patch switching off the NPN
  support eliminating bsc#1227233 (CVE-2024-5642).
* Mon Aug 12 2024 mcepl@cepl.eu
- Add CVE-2024-6923-email-hdr-inject.patch to prevent email
  header injection due to unquoted newlines (bsc#1228780,
  CVE-2024-6923).
- Add CVE-2024-7592-quad-complex-cookies.patch fixing quadratic
  complexity in parsing cookies with backslashes (bsc#1229596,
  CVE-2024-7592)
- %%{profileopt} variable is set according to the variable
  %%{do_profiling} (bsc#1227999)
* Mon Jul 22 2024 mcepl@cepl.eu
- Remove %%suse_update_desktop_file macro as it is not useful any
  more.
* Mon Jul 15 2024 mcepl@cepl.eu
- Stop using %%%%defattr, it seems to be breaking proper executable
  attributes on /usr/bin/ scripts (bsc#1227378).
* Tue Jun 25 2024 mcepl@cepl.eu
- Add CVE-2024-4032-private-IP-addrs.patch to fix bsc#1226448
  (CVE-2024-4032) rearranging definition of private v global IP
  addresses.
* Fri Jun 21 2024 mcepl@cepl.eu
- Add CVE-2024-0397-memrace_ssl.SSLContext_cert_store.patch
  fixing bsc#1226447 (CVE-2024-0397) by removing memory race
  condition in ssl.SSLContext certificate store methods.
* Tue May  7 2024 mcepl@cepl.eu
- Add bpo38361-syslog-no-slash-ident.patch (bsc#1222109,
  gh#python/cpython!16557) fixes syslog making default "ident"
  from sys.argv[0].
- Update CVE-2023-52425-libexpat-2.6.0-backport.patch so that
  it uses features sniffing, not just comparing version number
  (bsc#1220664, bsc#1219559, bsc#1221563, bsc#1222075).
- Remove support-expat-CVE-2022-25236-patched.patch, which was
  the previous name of this patch.
- Add CVE-2023-52425-remove-reparse_deferral-tests.patch skipping
  failing tests.
- Refresh patches:
  - CVE-2023-27043-email-parsing-errors.patch
  - fix_configure_rst.patch
  - skip_if_buildbot-extend.patch
* Thu Apr 25 2024 mcepl@cepl.eu
- bsc#1221854 (CVE-2024-0450) Add
  CVE-2024-0450-zipfile-avoid-quoted-overlap-zipbomb.patch
  detecting the vulnerability of the "quoted-overlap" zipbomb
  (from gh#python/cpython!110016).
- Add bh42369-thread-safety-zipfile-SharedFile.patch (from
  gh#python/cpython!26974) required by the previous patch.
- Add expat-260-test_xml_etree-reparse-deferral.patch to make the
  interpreter work with patched libexpat in our distros.
- Move all patches from locally sourced to the branch
  opensuse-3.6 branch at GitHub repo, and move all metadata to
  commits themselves (readable in the headers of each patch).
- Add bpo-41675-modernize-siginterrupt.patch to make Python build
  cleanly even on more recent SPs of SLE-15
  (gh#python/cpython#85841).
- Remove patches:
  - bpo36263-Fix_hashlib_scrypt.patch - fix against bug in
    OpenSSL fixed in 1.1.1c (gh#openssl/openssl!8483), so this
    patch is redundant on all SUSE-supported distros
  - python-3.3.0b1-test-posix_fadvise.patch - protection
    against the kernel issues which has been fixed in
    gh#torvalds/linux@3d3727cdb07f, which has been included in
    all our kernels more recent than SLE-11.
  - python-3.3.3-skip-distutils-test_sysconfig_module.patch -
    skips a test, which should be relevant only for testing on
    Mac OS X systems with universal builds. I have no valid
    record, that this test would be ever problematic on Linux.
  - bpo-36576-skip_tests_for_OpenSSL-111.patch, which was
    included already in Python 3.5.
* Fri Feb 23 2024 mcepl@suse.com
- (bsc#1219666, CVE-2023-6597) Add
  CVE-2023-6597-TempDir-cleaning-symlink.patch (patch from
  gh#python/cpython!99930) fixing symlink bug in cleanup of
  tempfile.TemporaryDirectory.
- Merge together bpo-36576-skip_tests_for_OpenSSL-111.patch into
  skip_SSL_tests.patch, and make them include all conditionals.
* Mon Dec 18 2023 mcepl@cepl.eu
- Refresh CVE-2023-27043-email-parsing-errors.patch to
  gh#python/cpython!111116, fixing bsc#1210638 (CVE-2023-27043).
* Mon Sep 11 2023 daniel.garcia@suse.com
- Add CVE-2023-40217-avoid-ssl-pre-close.patch fixing
  gh#python/cpython#108310, backport from upstream patch
  gh#python/cpython#108315
  (bsc#1214692, CVE-2023-40217)
* Sat May  6 2023 mcepl@suse.com
- Add 99366-patch.dict-can-decorate-async.patch fixing
  gh#python/cpython#98086 (backport from Python 3.10 patch in
  gh#python/cpython!99366), fixing bsc#1211158.
* Wed May  3 2023 mcepl@suse.com
- Add CVE-2007-4559-filter-tarfile_extractall.patch to fix
  CVE-2007-4559 (bsc#1203750) by adding the filter for
  tarfile.extractall (PEP 706).
* Tue Apr 18 2023 steven.kowalik@suse.com
- Use python3 modules to build the documentation.
* Wed Mar 15 2023 mcepl@suse.com
- Add bpo-44434-libgcc_s-for-pthread_cancel.patch
  which eliminates unnecessary and dangerous calls to
  PyThread_exit_thread() (bsc#1203355).
* Wed Mar  1 2023 mcepl@suse.com
- Add CVE-2023-24329-blank-URL-bypass.patch (CVE-2023-24329,
  bsc#1208471) blocklists bypass via the urllib.parse component
  when supplying a URL that starts with blank characters
* Wed Feb 22 2023 mcepl@suse.com
- Add bpo27321-email-no-replace-header.patch to stop
  email.generator.py from replacing a non-existent header
  (bsc#1208443, gh#python/cpython#71508).
* Thu Nov 17 2022 mcepl@suse.com
- Add bsc1188607-pythreadstate_clear-decref.patch to fix crash in
  the garbage collection (bsc#1188607).
* Wed Nov  9 2022 mcepl@suse.com
- Add CVE-2022-45061-DoS-by-IDNA-decode.patch to avoid
  CVE-2022-45061 (bsc#1205244) allowing DoS by IDNA decoding
  extremely long domain names.
* Fri Oct 28 2022 mcepl@suse.com
- Add CVE-2022-37454-sha3-buffer-overflow.patch to fix
  bsc#1204577 (CVE-2022-37454, gh#python/cpython#98517) buffer
  overflow in hashlib.sha3_* implementations (originally from the
  XKCP library).
* Fri Sep 16 2022 mcepl@suse.com
- Add CVE-2020-10735-DoS-no-limit-int-size.patch to fix
  CVE-2020-10735 (bsc#1203125) to limit amount of digits
  converting text to int and vice vera (potential for DoS).
  Originally by Victor Stinner of Red Hat.
* Thu Sep  1 2022 steven.kowalik@suse.com
- Add patch CVE-2021-28861-double-slash-path.patch:
  * http.server: Fix an open redirection vulnerability in the HTTP server
    when an URI path starts with //. (bsc#1202624, CVE-2021-28861)
* Thu Jun  9 2022 mcepl@suse.com
- Add CVE-2015-20107-mailcap-unsafe-filenames.patch to avoid
  CVE-2015-20107 (bsc#1198511, gh#python/cpython#68966), the
  command injection in the mailcap module.
- Rename support-expat-245.patch to
  support-expat-CVE-2022-25236-patched.patch to unify the patch
  with other packages.
- Add bpo-46623-skip-zlib-s390x.patch skipping two failing tests
  on s390x.
* Sat Feb 26 2022 mcepl@suse.com
- Update bundled pip wheel to the latest SLE version patched
  against bsc#1186819 (CVE-2021-3572).
* Tue Feb 22 2022 steven.kowalik@suse.com
- Add patch support-expat-245.patch:
  * Support Expat >= 2.4.5
* Fri Feb  4 2022 mcepl@suse.com
- Rename 22198.patch into more descriptive remove-sphinx40-warning.patch.
* Thu Dec 16 2021 mcepl@suse.com
- Don't use appstream-glib on SLE-12.
- Use Python 2-based Sphinx on SLE-12.
- No documentation on SLE-12.
- Add skip_SSL_tests.patch skipping tests because of patched
  OpenSSL (bpo#9425).
* Thu Dec 16 2021 mcepl@suse.com
- Don't use appstream-glib on SLE-12.
- Use Python 2-based Sphinx on SLE-12.
- No documentation on SLE-12.
- Add skip_SSL_tests.patch skipping tests because of patched
  OpenSSL (bpo#9425).
* Thu Dec  9 2021 mcepl@suse.com
- Don't use OpenSSL 1.1 on platforms which don't have it.
* Mon Nov 29 2021 mcepl@suse.com
- Remove shebangs from from python-base libraries in _libdir
  (bsc#1193179, bsc#1192249).
- Readjust patches:
  - bpo-31046_ensurepip_honours_prefix.patch
  - decimal.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
* Sat Nov 27 2021 dmueller@suse.com
- build against openssl 1.1 as it is incompatible with openssl 3.0+  (bsc#1190566)
* Wed Nov  3 2021 schwab@suse.de
- 0001-allow-for-reproducible-builds-of-python-packages.patch: ignore
  permission error when changing the mtime of the source file in presence
  of SOURCE_DATE_EPOCH
* Wed Oct 27 2021 mcepl@suse.com
- The previous construct works only on the current Factory, not
  in SLE.
* Wed Oct 13 2021 dimstar@opensuse.org
- BuildRequire rpm-build-python: The provider to inject python(abi)
  has been moved there. rpm-build pulls rpm-build-python
  automatically in when building anything against python3-base, but
  this implies that the initial build of python3-base does not
  trigger the automatic installation.
* Wed Oct  6 2021 mcepl@suse.com
- Due to conflicting demands of bsc#1183858 and platforms where
  Python 3.6 is only in interpreter+pip set we have to make
  complicated ugly construct about Sphinx BR.
* Thu Sep 23 2021 mcepl@suse.com
- Make python36 primary interpreter on SLE-15
* Thu Sep 23 2021 mcepl@suse.com
- Make build working even on older SLEs.
* Wed Sep 15 2021 mcepl@suse.com
- Update to 3.6.15:
  - bpo-43124: Made the internal putcmd function in smtplib
    sanitize input for presence of \r and \n characters to avoid
    (unlikely) command injection. Library
  - bpo-45001: Made email date parsing more robust against
    malformed input, namely a whitespace-only Date: header. Patch
    by Wouter Bolsterlee. Tests
  - bpo-38965: Fix test_faulthandler on GCC 10. Use the
    “volatile” keyword in faulthandler._stack_overflow() to
    prevent tail call optimization on any compiler, rather than
    relying on compiler specific pragma.
  - bpo-40791: Make compare_digest more constant-time
    (bsc#1214691, CVE-2022-48566).
- Remove upstreamed patches:
  - faulthandler_stack_overflow_on_GCC10.patch
* Thu Aug 26 2021 schwab@suse.de
- test_faulthandler is still problematic under qemu linux-user emulation,
  disable it there
* Tue Aug 10 2021 qydwhotmail@gmail.com
- Update to 3.6.14:
  * Security
  - bpo-44022 (bsc#1189241, CVE-2021-3737): mod:http.client now
    avoids infinitely reading potential HTTP headers after
    a 100 Continue status response from the server.
  - bpo-43882: The presence of newline or tab characters in parts
    of a URL could allow some forms of attacks.
    Following the controlling specification for URLs defined by
    WHATWG urllib.parse() now removes ASCII newlines and tabs
    from URLs, preventing such attacks.
  - bpo-42988 (CVE-2021-3426, bsc#1183374): Remove the getfile feature
    of the pydoc module which could be abused to read arbitrary files
    on the disk (directory traversal vulnerability). Moreover, even
    source code of Python modules can contain sensitive data like
    passwords. Vulnerability reported by David Schwörer.
  - bpo-43285: ftplib no longer trusts the IP address value
    returned from the server in response to the PASV command by
    default. This prevents a malicious FTP server from using the
    response to probe IPv4 address and port combinations on the
    client network.
    Code that requires the former vulnerable behavior may set a
    trust_server_pasv_ipv4_address attribute on their ftplib.FTP
    instances to True to re-enable it.
  - bpo-43075 (CVE-2021-3733, bsc#1189287): Fix Regular Expression
    Denial of Service (ReDoS) vulnerability in
    urllib.request.AbstractBasicAuthHandler. The ReDoS-vulnerable
    regex has quadratic worst-case complexity and it allows cause
    a denial of service when identifying crafted invalid RFCs. This
    ReDoS issue is on the client side and needs remote attackers to
    control the HTTP server.
- Upstreamed patches were removed:
  - CVE-2021-3426-inf-disclosure-pydoc-getfile.patch
  - CVE-2021-3733-ReDoS-urllib-AbstractBasicAuthHandler.patch
- Refreshed patches:
  - python3-sorted_tar.patch
  - riscv64-ctypes.patch
* Mon Jul 26 2021 mcepl@suse.com
- Rebuild to get new headers, avoid building in support for
  stropts.h (bsc#1187338).
* Tue Jul 20 2021 mcepl@suse.com
- Use versioned python-Sphinx to avoid dependency on other
  version of Python (bsc#1183858).
* Fri Jul 16 2021 mcepl@suse.com
- Modify Lib/ensurepip/__init__.py to contain the same version
  numbers as are in reality the ones in the bundled wheels
  (bsc#1187668).
* Tue Jun  8 2021 dmueller@suse.com
- add 22198.patch to build with Sphinx 4
* Fri May 21 2021 mcepl@suse.com
- Stop providing "python" symbol (bsc#1185588), which means
  python2 currently.
* Sun May  2 2021 code@bnavigator.de
- Make sure to close the import_failed.map file after the exception
  has been raised in order to avoid ResourceWarnings when the
  failing import is part of a try...except block.
* Tue Apr 27 2021 mcepl@suse.com
- Add CVE-2021-3426-inf-disclosure-pydoc-getfile.patch to remove
  getfile feature from pydoc, which is a security nightmare
  (among other things, CVE-2021-3426, allows disclosure of any
  file on the system; bsc#1183374, bpo#42988).
* Fri Feb 19 2021 mcepl@suse.com
  Update to 3.6.13, final release of 3.6 branch:
  * Security
  - bpo#42967 (bsc#1182379, CVE-2021-23336): Fix web cache
    poisoning vulnerability by defaulting the query args
    separator to &, and allowing the user to choose a custom
    separator.
  - bpo#42938 (bsc#1181126, CVE-2021-3177): Avoid static
    buffers when computing the repr of ctypes.c_double and
    ctypes.c_longdouble values.
  - bpo#42103: Prevented potential DoS attack via CPU and RAM
    exhaustion when processing malformed Apple Property List
    files in binary format.
  - bpo#42051: The plistlib module no longer accepts entity
    declarations in XML plist files to avoid XML
    vulnerabilities. This should not affect users as entity
    declarations are not used in regular plist files.
  - bpo#40791: Add volatile to the accumulator variable in
    hmac.compare_digest, making constant-time-defeating
    optimizations less likely.
  * Core and Builtins
  - bpo#35560: Fix an assertion error in format() in debug
    build for floating point formatting with “n” format, zero
    padding and small width. Release build is not impacted.
    Patch by Karthikeyan Singaravelan.
  * Library
  - bpo#42103: InvalidFileException and RecursionError are now
    the only errors caused by loading malformed binary Plist
    file (previously ValueError and TypeError could be raised
    in some specific cases).
  * Tests
  - bpo#42794: Update test_nntplib to use offical group name of
    news.aioe.org for testing. Patch by Dong-hee Na.
  - bpo#41944: Tests for CJK codecs no longer call eval() on
    content received via HTTP.
- Patches removed, because they were included in the upstream
  tarball:
  - CVE-2020-27619-no-eval-http-content.patch
  - CVE-2021-3177-buf_ovrfl_PyCArg_repr.patch
* Fri Jan 29 2021 mcepl@suse.com
- Add CVE-2021-3177-buf_ovrfl_PyCArg_repr.patch fixing
  bsc#1181126 (CVE-2021-3177) buffer overflow in PyCArg_repr in
  _ctypes/callproc.c, which may lead to remote code execution.
* Wed Jan 27 2021 mcepl@suse.com
- Provide the newest setuptools wheel (bsc#1176262,
  CVE-2019-20916) in their correct form (bsc#1180686).
* Tue Jan  5 2021 mcepl@suse.com
- (bsc#1180125) We really don't Require python-rpm-macros package.
  Unnecessary dependency.
* Mon Dec 28 2020 meissner@suse.com
- readd --with-fpectl (bsc#1180377)
* Mon Dec  7 2020 mcepl@suse.com
- Adjust sphinx-update-removed-function.patch
* Sat Dec  5 2020 mcepl@suse.com
- (bsc#1179630) Update sphinx-update-removed-function.patch to
  work with all versions of Sphinx (not binding the Python
  documentation build to the latest verison of Sphinx). Updated
  version mentioned on gh#python/cpython#13236.
* Tue Dec  1 2020 mcepl@suse.com
- Add CVE-2020-27619-no-eval-http-content.patch fixing
  CVE-2020-27619 (bsc#1178009), where Lib/test/multibytecodec_support
  calls eval() on content retrieved via HTTP.
* Tue Dec  1 2020 steven.kowalik@suse.com
- Add patch sphinx-update-removed-function.patch to no longer call
  a now removed function (gh#python/cpython#13236). As
  a consequence, no longer pin Sphinx version.
* Fri Nov 27 2020 mmachova@suse.com
- Pin Sphinx version to fix doc subpackage
* Wed Nov 25 2020 mcepl@suse.com
- Change setuptools and pip version numbers according to new
  wheels (bsc#1179756).
- Add ignore_pip_deprec_warn.patch to switch of persistently
  failing test.
* Tue Nov 24 2020 mcepl@suse.com
- Replace bundled wheels for pip and setuptools with the updated ones
  (bsc#1176262 CVE-2019-20916).
* Tue Oct 13 2020 mcalabkova@suse.com
- Handful of changes to make python36 compatible with SLE15 and SLE12
  (jsc#ECO-2799, jsc#SLE-13738)
- Rebase bpo23395-PyErr_SetInterrupt-signal.patch
* Fri Oct  9 2020 dimstar@opensuse.org
- Fix build with RPM 4.16: error: bare words are no longer
  supported, please use "...":  x86 == ppc.
* Fri Oct  9 2020 mcepl@suse.com
- Fix installing .desktop file
* Fri Sep 25 2020 dimstar@opensuse.org
- Buildrequire timezone only for general flavor. It's used in this
  flavor for the test suite.
* Wed Sep  2 2020 mcepl@suse.com
- Add faulthandler_stack_overflow_on_GCC10.patch to make build
  working even with GCC10 (bpo#38965).
* Tue Sep  1 2020 mcepl@suse.com
- Just cleanup and reordering items to synchronize with python38
* Mon Aug 31 2020 tchvatal@suse.com
- Format with spec-cleaner
* Fri Aug 21 2020 schwab@suse.de
- riscv64-support.patch: bpo-33377: add triplets for mips-r6 and riscv
  (#6655)
- riscv64-ctypes.patch: bpo-35847: RISC-V needs CTYPES_PASS_BY_REF_HACK
  (GH-11694)
- Update list of tests to exclude under qemu linux-user
* Thu Aug 20 2020 mcalabkova@suse.com
- Update the python keyring
- Correct libpython name
* Thu Aug 20 2020 mcalabkova@suse.com
- Drop patches which are not mentioned in spec:
  * CVE-2019-5010-null-defer-x509-cert-DOS.patch
  * F00102-lib64.patch
  * F00251-change-user-install-location.patch
  * OBS_dev-shm.patch
  * SUSE-FEDORA-multilib.patch
  * bpo-31046_ensurepip_honours_prefix.patch
  * bpo34022-stop_hash-based_invalidation_w_SOURCE_DATE_EPOCH.patch
  * bpo36302-sort-module-sources.patch
  * bpo40784-Fix-sqlite3-deterministic-test.patch
  * bsc1167501-invalid-alignment.patch
  * python3-imp-returntype.patch
- Working around missing python-packaging dependency in
  python-Sphinx (bsc#1174571) is not necessary anymore.
* Wed Aug 19 2020 mcalabkova@suse.com
- Update to 3.6.12 (bsc#1179193)
  * Ensure python3.dll is loaded from correct locations when Python is embedded
  * The __hash__() methods of ipaddress.IPv4Interface and ipaddress.IPv6Interface
    incorrectly generated constant hash values of 32 and 128 respectively. This
    resulted in always causing hash collisions. The fix uses hash() to generate
    hash values for the tuple of (address, mask length, network address).
  * Prevent http header injection by rejecting control characters in
    http.client.putrequest(…).
  * Unpickling invalid NEWOBJ_EX opcode with the C implementation raises now
    UnpicklingError instead of crashing.
  * Avoid infinite loop when reading specially crafted TAR files using the tarfile
    module
- Drop merged fixtures:
  * CVE-2020-14422-ipaddress-hash-collision.patch
  * CVE-2019-20907_tarfile-inf-loop.patch
  * recursion.tar
- This release also fixes CVE-2020-26116 (bsc#1177211) and CVE-2019-20907 (bsc#1174091).
* Mon Jul 20 2020 mcepl@suse.com
- Add CVE-2019-20907_tarfile-inf-loop.patch fixing bsc#1174091
  (CVE-2019-20907, bpo#39017) avoiding possible infinite loop
  in specifically crafted tarball.
  Add recursion.tar as a testing tarball for the patch.
* Fri Jul 17 2020 mcalabkova@suse.com
- Make library names internally consistent
* Fri Jul 17 2020 tchvatal@suse.com
- Disable profile optimalizations as they deadlock in test_faulthandler
* Fri Jul 17 2020 tchvatal@suse.com
- Disable lto as it causes mess and works with 3.7 onwards only
* Fri Jul 17 2020 tchvatal@suse.com
- Sync the test disablements from the python3 in sle15
* Fri Jul 17 2020 tchvatal@suse.com
- Update to 3.6.11:
  - bpo-39073: Disallow CR or LF in email.headerregistry. Address
    arguments to guard against header injection attacks.
  - bpo-38576 (bsc#1155094): Disallow control characters in
    hostnames in http.client, addressing CVE-2019-18348. Such
    potentially malicious header injection URLs now cause
    a InvalidURL to be raised.
  - bpo-39503: CVE-2020-8492: The AbstractBasicAuthHandler class
    of the urllib.request module uses an inefficient regular
    expression which can be exploited by an attacker to cause
    a denial of service. Fix the regex to prevent the
    catastrophic backtracking. Vulnerability reported by Ben
    Caller and Matt Schwager.
  - bpo-39401: Avoid unsafe load of
    api-ms-win-core-path-l1-1-0.dll at startup on Windows 7.
- Remove merged patch CVE-2020-8492-urllib-ReDoS.patch,
  CRLF_injection_via_host_part.patch, and
  CVE-2019-18348-CRLF_injection_via_host_part.patch.
* Wed Jul 15 2020 tchvatal@suse.com
- Fix minor issues found in the staging.
* Wed Jul 15 2020 tchvatal@suse.com
- Do not set ourselves as a primary interpreter
* Thu Jun 25 2020 mcepl@suse.com
- Add CVE-2020-14422-ipaddress-hash-collision.patch fixing
  CVE-2020-14422 (bsc#1173274, bpo#41004), where hash collisions
  in IPv4Interface and IPv6Interface could lead to DOS.
* Tue Mar 10 2020 mcepl@suse.com
- Change name of idle3 icons to idle3.png
  to avoid collision with Python 2 version (bsc#1165894).
* Sat Feb  8 2020 mcepl@suse.com
- Add CVE-2019-9674-zip-bomb.patch to improve documentation
  warning about dangers of zip-bombs and other security problems
  with zipfile library. (bsc#1162825 CVE-2019-9674)
- Add CVE-2020-8492-urllib-ReDoS.patch fixing the security bug
  "Python urrlib allowed an HTTP server to conduct Regular
  Expression Denial of Service (ReDoS)" (bsc#1162367)
* Sat Feb  8 2020 mcepl@suse.com
- Add Requires: libpython%%{so_version} == %%{version}-%%{release}
  to python3-base to keep both packages always synchronized
  (bsc#1162224).
* Mon Feb  3 2020 tchvatal@suse.com
- Reame idle icons to idle3 in order to not conflict with python2
  variant of the package bsc#1165894
  * renamed the icons
  * renamed icon load in desktop file
* Tue Jan 28 2020 mcepl@suse.com
- Add pep538_coerce_legacy_c_locale.patch to coerce locale to
  C.UTF-8 always (bsc#1162423).
* Thu Dec 19 2019 mcepl@suse.com
- Update to 3.6.10 (still in line with jsc#SLE-9426,
  jsc#SLE-9427, bsc#1159035):
  - Security:
  - bpo-38945: Newline characters have been escaped when
    performing uu encoding to prevent them from overflowing
    into to content section of the encoded file. This prevents
    malicious or accidental modification of data during the
    decoding process.
  - bpo-37228: Due to significant security concerns, the
    reuse_address parameter of
    asyncio.loop.create_datagram_endpoint() is no longer
    supported. This is because of the behavior of SO_REUSEADDR
    in UDP. For more details, see the documentation for
    loop.create_datagram_endpoint(). (Contributed by Kyle
    Stanley, Antoine Pitrou, and Yury Selivanov in bpo-37228.)
  - bpo-38804: Fixes a ReDoS vulnerability in http.cookiejar.
    Patch by Ben Caller.
  - bpo-38243: Escape the server title of
    xmlrpc.server.DocXMLRPCServer when rendering the document
    page as HTML. (Contributed by Dong-hee Na in bpo-38243.)
  - bpo-38174: Update vendorized expat library version to
    2.2.8, which resolves CVE-2019-15903.
  - bpo-37461: Fix an infinite loop when parsing specially
    crafted email headers. Patch by Abhilash Raj.
  - bpo-34155: Fix parsing of invalid email addresses with more
    than one @ (e.g. a@b@c.com.) to not return the part before
    2nd @ as valid email address. Patch by maxking & jpic.
  - Library:
  - bpo-38216: Allow the rare code that wants to send invalid
    http requests from the http.client library a way to do so.
    The fixes for bpo-30458 led to breakage for some projects
    that were relying on this ability to test their own
    behavior in the face of bad requests.
  - bpo-36564: Fix infinite loop in email header folding logic
    that would be triggered when an email policy’s
    max_line_length is not long enough to include the required
    markup and any values in the message. Patch by Paul Ganssle
- Remove patches included in the upstream tarball:
  - CVE-2019-16935-xmlrpc-doc-server_title.patch (and also
    bpo37614-race_test_docxmlrpc_srv_setup.patch, which was
    resolving bsc#1174701).
  - CVE-2019-16056-email-parse-addr.patch
- Move idle subpackage build from python3-base to python3 (bsc#1159622).
  appstream-glib required for packaging introduces considerable
  extra dependencies and a build loop via rust/librsvg.
- Correct installation of idle IDE icons:
  + idle.png is not the target directory
  + non-GNOME-specific icons belong into icons/hicolor
- Add required Name key to idle3 desktop file
* Thu Dec 12 2019 mcepl@suse.com
- Unify all Python 3.6* SLE packages into one (jsc#SLE-9426,
  jsc#SLE-9427, bsc#1159035)
  - Patches which were already included upstream:
  - CVE-2018-1061-DOS-via-regexp-difflib.patch
  - CVE-2018-14647_XML_SetHashSalt-in_elementtree.patch
* Tue Oct 22 2019 mcepl@suse.com
- Add CVE-2019-16935-xmlrpc-doc-server_title.patch fixing
  bsc#1153238 (aka CVE-2019-16935) fixing a reflected XSS in
  python/Lib/DocXMLRPCServer.py
* Thu Sep 19 2019 mcepl@suse.com
- Add bpo-36576-skip_tests_for_OpenSSL-111.patch (originally from
  bpo#36576) skipping tests failing with OpenSSL 1.1.1. Fixes
  bsc#1149792
- Add bpo36263-Fix_hashlib_scrypt.patch which works around
  bsc#1151490
* Mon Sep 16 2019 mcepl@suse.com
- Add CVE-2019-16056-email-parse-addr.patch fixing the email
  module wrongly parses email addresses [bsc#1149955,
  bnc#1149955, CVE-2019-16056]
* Mon Sep  9 2019 mcepl@suse.com
- jsc#PM-1350 bsc#1149121 Update python3 to the last version of
  the 3.6 line. This is just a bugfix release with no changes in
  functionality.
- The following patches were included in the upstream release as
  so they can be removed in the package:
  - CVE-2018-20852-cookie-domain-check.patch
  - CVE-2019-5010-null-defer-x509-cert-DOS.patch
  - CVE-2019-10160-netloc-port-regression.patch
  - CVE-2019-9636-urlsplit-NFKC-norm.patch
  - CVE-2019-9947-no-ctrl-char-http.patch
- Patch bpo23395-PyErr_SetInterrupt-signal.patch has been
  reapplied on the upstream base without changing any
  functionality.
- Add patch aarch64-prolong-timeout.patch to fix failing
  test_utime_current_old test.
* Wed Jul 24 2019 mcepl@suse.com
- FAKE RECORD FROM SLE-12 CHANNEL Apply
  "CVE-2018-1000802-shutil_use_subprocess_no_spawn.patch" which
  converts shutil._call_external_zip to use subprocess rather
  than distutils.spawn. [bsc#1109663, CVE-2018-1000802]
* Wed Jul 24 2019 mcepl@suse.com
- FAKE RECORD FROM SLE-12 CHANNEL bsc#1109847: add
  CVE-2018-14647_XML_SetHashSalt-in_elementtree.patch fixing bpo#34623.
* Fri Jul 19 2019 mcepl@suse.com
- boo#1141853 (CVE-2018-20852) add
  CVE-2018-20852-cookie-domain-check.patch fixing
  http.cookiejar.DefaultPolicy.domain_return_ok which did not
  correctly validate the domain: it could be tricked into sending
  cookies to the wrong server.
* Wed Jul  3 2019 mcepl@suse.com
- bsc#1138459: add CVE-2019-10160-netloc-port-regression.patch
  which fixes regression introduced by the previous patch.
  (CVE-2019-10160)
  Upstream gh#python/cpython#13812
* Wed Jun 12 2019 mcepl@suse.com
- FAKE RECORD FROM SLE-12 CHANNEL bsc#1137942: Avoid duplicate
  files with python3* packages (https://fate.suse.com/327309)
* Tue Jun 11 2019 mcepl@suse.com
- bsc#1094814: Add bpo23395-PyErr_SetInterrupt-signal.patch to
  handle situation when the SIGINT signal is ignored or not handled
* Tue Apr 30 2019 mcepl@suse.com
- Update to 3.6.8:
  - bugfixes only
  - removed patches (subsumed in the upstream tarball):
  - CVE-2018-20406-pickle_LONG_BINPUT.patch
  - refreshed patches:
  - CVE-2019-5010-null-defer-x509-cert-DOS.patch
  - CVE-2019-9636-urlsplit-NFKC-norm.patch
  - Python-3.0b1-record-rpm.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
  - python-3.3.0b1-test-posix_fadvise.patch
  - python-3.3.3-skip-distutils-test_sysconfig_module.patch
  - python-3.6.0-multilib-new.patch
  - python3-sorted_tar.patch
  - subprocess-raise-timeout.patch
  - switch off LTO and PGO optimization (bsc#1133452)
- bsc#1130840 (CVE-2019-9947): add CVE-2019-9947-no-ctrl-char-http.patch
  Address the issue by disallowing URL paths with embedded
  whitespace or control characters through into the underlying
  http client request. Such potentially malicious header
  injection URLs now cause a ValueError to be raised.
* Tue Apr  9 2019 mcepl@suse.com
- bsc#1129346: add CVE-2019-9636-urlsplit-NFKC-norm.patch
  Characters in the netloc attribute that decompose under NFKC
  normalization (as used by the IDNA encoding) into any of ``/``,
  ``?``, ``#``, ``@``, or ``:`` will raise a ValueError. If the
  URL is decomposed before parsing, or is not a Unicode string,
  no error will be raised. (CVE-2019-9636)
  Upstream gh#python/cpython#12224
* Mon Jan 21 2019 mcepl@suse.com
- bsc#1120644 add CVE-2018-20406-pickle_LONG_BINPUT.patch fixing bpo#34656
  Modules/_pickle.c in Python before 3.7.1 has an integer overflow via
  a large LONG_BINPUT value that is mishandled during a "resize to twice
  the size" attempt. This issue might cause memory exhaustion, but is
  only relevant if the pickle format is used for serializing tens or
  hundreds of gigabytes of data.
* Sat Jan 19 2019 mcepl@suse.com
- bsc#1122191: add CVE-2019-5010-null-defer-x509-cert-DOS.patch
  fixing bpo-35746.
  An exploitable denial-of-service vulnerability exists in the
  X509 certificate parser of Python.org Python 2.7.11 / 3.7.2.
  A specially crafted X509 certificate can cause a NULL pointer
  dereference, resulting in a denial of service. An attacker can
  initiate or accept TLS connections using crafted certificates
  to trigger this vulnerability.
* Mon Sep  3 2018 mcepl@suse.com
- Add -fwrapv to OPTS, which is default for python3 anyway
  See for example https://github.com/zopefoundation/persistent/issues/86
  for bugs which are caused by avoiding it. (bsc#1107030)
* Fri Jun 29 2018 mcepl@suse.com
- Apply "CVE-2018-1061-DOS-via-regexp-difflib.patch" to prevent
  low-grade poplib REDOS (CVE-2018-1060) and to prevent difflib REDOS
  (CVE-2018-1061). Prior to this patch mail server's timestamp was
  susceptible to catastrophic backtracking on long evil response from
  the server. Also, it was susceptible to catastrophic backtracking,
  which was a potential DOS vector.
  [bsc#1088004 and bsc#1088009, CVE-2018-1061 and CVE-2018-1060]
* Tue Apr 17 2018 tchvatal@suse.com
- As we run in main python package do not generate the pre_checkin
  from both now
* Mon Apr 16 2018 tchvatal@suse.com
- Move the tests from base to generic package wrt bsc#1088573
  * We still fail the whole distro if python3 is not build
  * The other archs than x86_64 took couple of hours to unblock
    build of other software, this way we work around the issue
- Some tests are still run in -base for the LTO tweaking, but at
  least it is not run twice
* Sat Mar 31 2018 mimi.vx@gmail.com
- update to 3.6.5
  * bugfix release
  * see Misc/NEWS for details
- drop ctypes-pass-by-value.patch
- drop fix-localeconv-encoding-for-LC_NUMERIC.patch
- refresh python-3.6.0-multilib-new.patch
* Tue Mar 13 2018 psimons@suse.com
- Apply "python-3.6-CVE-2017-18207.patch" to add a check to
  Lib/wave.py that verifies that at least one channel is provided.
  Prior to this check, attackers could cause a denial of service
  (divide-by-zero error and application crash) via a crafted wav
  format audio file. [bsc#1083507, CVE-2017-18207]
* Wed Mar  7 2018 adam@mizerski.pl
- Created %%so_major and %%so_minor macros
- Put Tools/gdb/libpython.py script into proper place and ship it with devel
  subpackage.
* Tue Feb 20 2018 schwab@suse.de
- ctypes-pass-by-value.patch: Fix pass by value for structs on aarch64
* Tue Feb 20 2018 bwiedemann@suse.com
- Add python3-sorted_tar.patch (boo#1081750, bsc#1086001)
* Wed Feb  7 2018 tchvatal@suse.com
- Add patch to fix glibc 2.27 fail bsc#1079761:
  * fix-localeconv-encoding-for-LC_NUMERIC.patch
* Wed Jan 24 2018 jmatejek@suse.com
- move XML modules and python3-xml provide to python3-base
  (fixes bsc#1077230)
- move ensurepip to base
* Thu Jan 18 2018 normand@linux.vnet.ibm.com
- Add skip_random_failing_tests.patch only for PowerPC
* Wed Jan  3 2018 jmatejek@suse.com
- update to 3.6.4
  * bugfix release, over a hundred bugs fixed
  * see Misc/NEWS for details
- drop upstreamed python3-ncurses-6.0-accessors.patch
- drop PYTHONSTARTUP hooks that cause spurious startup errors
  * fixes bsc#1070738
  * the relevant feature (REPL history) is now built into Python itself
* Sat Dec  2 2017 dimstar@opensuse.org
- Install 2to3-%%{python_version} executable (override defattr of
  the -tools package). 2to3 (unversioned) is a symlink and does not
  carry permissions (bsc#1070853).
* Thu Nov 16 2017 mimi.vx@gmail.com
- move 2to3 to python3-tools package
* Wed Oct 11 2017 jmatejek@suse.com
- update to 3.6.3
  * bugfix release, over a hundred bugs fixed
  * see Misc/NEWS for details
- drop upstreamed 0001-3.6-bpo-30714-ALPN-changes-for-OpenSSL-1.1.0f-3093.patch
* Wed Sep 20 2017 dmueller@suse.com
- drop python-2.7-libffi-aarch64.patch: this patches the intree
  copy of libffi which is unused/deleted in the line afterwards
- fix build against system libffi: include flags weren't set
  so it actually used the in-tree libffi headers.
* Thu Sep 14 2017 vcizek@suse.com
- Fix test broken with OpenSSL 1.1 (bsc#1042670)
  * add 0001-3.6-bpo-30714-ALPN-changes-for-OpenSSL-1.1.0f-3093.patch
* Thu Aug 31 2017 schwab@suse.de
- fix missing %%{?armsuffix}
* Wed Aug 30 2017 jmatejek@suse.com
- distutils-reproducible-compile.patch: ensure distutils order files
  before compiling, which works around bsc#1049186
* Thu Aug 17 2017 kukuk@suse.de
- Add libnsl-devel build requires for glibc obsoleting libnsl
* Thu Aug  3 2017 jmatejek@suse.com
- update to 3.6.2
  * bugfix release, over a hundred bugs fixed
  * see Misc/NEWS for details
- drop upstreamed test-socket-aead-kernel49.patch
- add Provides: python3-typing (fixes bsc#1050653)
- drop duplicate Provides: python3
* Tue Jun 20 2017 asn@cryptomilk.org
- Add missing link to python library in config dir (bsc#1040164)
* Thu Mar 23 2017 jmatejek@suse.com
- update to 3.6.1
  * bugfix release, over a hundred bugs fixed
  * never add import location's parent directory to sys.path
  * switch to git for version control, build changes related to that
  * fix "failed to get random numbers" on old kernels (bsc#1029902)
  * several crashes and memory leaks corrected
  * f-string are no longer accepted as docstrings
* Mon Mar 13 2017 jmatejek@suse.com
- prevent regenerating AST at build-time more robustly
- add "--without profileopt" and "--without testsuite" options to python3-base
  to allow short circuiting when working on the package
* Wed Mar  1 2017 jmatejek@suse.com
- FAKE RECORD FROM SLE-12 CHANNEL update to 3.4.6 (bsc#1027282):
  * fixed potential crash in PyUnicode_AsDecodedObject() in debug build
  * fixed possible DoS and arbitrary execution in gettext plurals
  * fix possible use of uninitialized memory in operator.methodcaller
  * fix possible Py_DECREF on unowned object in _sre
  * fix possible integer overflow in _csv module
  * prevent HTTPoxy attack (CVE-2016-1000110)
  * fix selectors incorrectly retaining invalid fds
- drop upstreamed python-3.4-CVE-2016-1000110-fix.patch
- move _elementtree to python3.rpm to match its pyexpat dependency
  (bsc#1029377)
* Sat Feb 25 2017 bwiedemann@suse.com
- Add 0001-allow-for-reproducible-builds-of-python-packages.patch
  upstream https://github.com/python/cpython/pull/296
* Wed Feb  8 2017 jmatejek@suse.com
- reenable test_socket with AEAD patch (test-socket-aead-kernel49.patch)
- reintroduce %%py3_soflags macro (and better named %%cpython3_soabi equivalent)
* Wed Jan 11 2017 jmatejek@suse.com
- update to 3.6.0
  * PEP 498 Formated string literals
  * PEP 515 Underscores in numeric literals
  * PEP 526 Syntax for variable annotations
  * PEP 525 Asynchronous generators
  * PEP 530 Asynchronous comprehensions
  * PEP 506 New "secrets" module for safe key generation
  * less memory consumed by dicts
  * dtrace and systemtap support
  * improved asyncio module
  * better defaults for ssl
  * new hashing algorithms in hashlib
  * bytecode format changed to allow more optimizations
  * "async" and "await" are on track to be reserved words
  * StopIteration from generators is deprecated
  * support for openssl < 1.0.2 is deprecated
  * os.urandom now blocks when getrandom() blocks
  * huge number of new features, bugfixes and optimizations
  * see https://docs.python.org/3.6/whatsnew/3.6.html for details
- rework multilib patch: drop Python-3.5.0-multilib.patch, implement
  upstreamable python-3.6.0-multilib-new.patch
- refresh python-3.3.0b1-localpath.patch, subprocess-raise-timeout.patch
- drop upstreamed Python-3.5.1-fix_lru_cache_copying.patch
- finally drop python-2.6b1-canonicalize2.patch that was not applied in source
  and only kept around in case we needed it in the future. (which we don't, as it seems)
- update import_failed map and baselibs
- build ctypes against system libffi
  (buildrequire libffi-devel in python3-base)
- add new key to keyring (signed by keys already in keyring)
- introduced common configure section between python3 and python3-base
- moved pyconfig.h and Makefile to devel subpackage as distutils no longer
  need it at runtime
- added python-rpm-macros dependency, regenerated macros file, drop macros.python3.py
  because it is not used now
- improve summaries and descriptions (fixes bsc#917607)
- enabled Link-Time Optimization, see what happens
- including skipped_tests.py in pre_checkin.sh run
- run specs through spec-cleaner, rearrange sections
* Sat Aug  6 2016 hpj@urpla.net
- FAKE RECORD FROM SLE-12 CHANNEL apply fix for CVE-2016-1000110
  - CGIHandler: sets environmental variable based on user
    supplied Proxy request header:
    python-3.4-CVE-2016-1000110-fix.patch (fixes bsc#989523,
    CVE-2016-1000110)
- refresh python3-urllib-prefer-lowercase-proxies.patch
* Sun Jul  3 2016 hpj@urpla.net
- FAKE RECORD FROM SLE-12 CHANNEL update to 3.4.5
  check: https://docs.python.org/3.4/whatsnew/changelog.html
  (fixes bsc#984751, CVE-2016-0772)
  (fixes bsc#985177, CVE-2016-5636)
  (fixes bsc#985348, CVE-2016-5699)
- drop upstreamed werror-declaration-after-statement.patch
* Tue Jun 14 2016 hpj@urpla.net
- FAKE RECORD FROM SLE-12 CHANNEL Due to being fixed upstream
  (differently), removed outdated patch
  CVE-2014-4650-CGIHTTPServer-traversal.patch (bsc#983582)
* Fri Apr 22 2016 jmatejek@suse.com
- move _hashlib and _ssl modules and tests to python3-base
- recommend python3
* Mon Mar  7 2016 toddrme2178@gmail.com
- Add  Python-3.5.1-fix_lru_cache_copying.patch
  Fix copying the lru_cache() wrapper object.
  Fixes deep-copying lru_cache regression, which worked on
  previous versions of python but fails on python 3.5.
  This fixes a bunch of packages in devel:languages:python3.
  See: https://bugs.python.org/issue25447
* Wed Dec  9 2015 toddrme2178@gmail.com
- update to 3.5.1
  * bugfix-only release, dozens of bugs fixed
- Drop upstreamed Python-3.5.0-_Py_atomic_xxx-symbols.patch
- "Python3" to "Python 3" in summary
  * This seems cleaner and fixes and rpmlint warning
* Fri Oct 23 2015 jmatejek@suse.com
- FAKE RECORD FROM SLE-12 CHANNEL Issue #21121: Don't force 3rd
  party C extensions to be built with -Werror=declaration-after-statement.
  (werror-declaration-after-statement.patch, bsc#951166)
* Wed Oct 14 2015 toddrme2178@gmail.com
- Add Python-3.5.0-_Py_atomic_xxx-symbols.patch
  This fixes a build error for many packages that use the Python,
  C-API.
  This patch is already accepted upstream and is slated to appear in
  python 3.5.1.
* Tue Sep 29 2015 jmatejek@suse.com
- update to 3.5.0
  * coroutines with async/await syntax
  * matrix multiplication operator `@`
  * unpacking generalizations
  * new modules `typing` and `zipapp`
  * type annotations
  * .pyo files replaced by custom suffixes for optimization levels in __pycache__
  * support for memory BIO in ssl module
  * performance improvements in several modules
  * and many more
- removals and behavior changes
  * deprecated `__version__` is removed
  * support for .pyo files was removed
  * system calls are auto-retried on EINTR
  * bare generator expressions in function calls now cause SyntaxError
    (change "f(x for x in i)" to "f((x for x in i))" to fix)
  * removed undocumented `format` member of private `PyMemoryViewObject` struct
  * renamed `PyMemAllocator` to `PyMemAllocatorEx`
- redefine %%dynlib macro to reflect that modules now have arch+os as part of name
- module `time` is now built-in
- dropped upstreamed patches:
  python-3.4.1-fix-faulthandler.patch
  python-3.4.3-test-conditional-ssl.patch
  python-fix-short-dh.patch (also dropped dh2048.pem required for this patch)
- updated patch Python-3.3.0b2-multilib.patch to Python-3.5.0-multilib.patch
- python-ncurses-6.0-accessors.patch taken from python 2 to fix build failure
  with new gcc + ncurses
* Wed Sep  9 2015 dimstar@opensuse.org
- Add python3-ncurses-6.0-accessors.patch: Fix build with
  NCurses 6.0 and OPAQUE_WINDOW set to 1.
* Mon Aug 24 2015 jmatejek@suse.com
- improve import_failed hook to do the right thing when invoking
  missing modules with "python3 -m modulename" (boo#942751)
* Thu Jul 23 2015 fisiu@opensuse.org
- Build with --enable-loadable-sqlite-extensions to make it works
  as geospatial database.
* Wed Jun 24 2015 meissner@suse.com
- dh2048.pem: added generated 2048 dh parameter set to fix
  ssl test (bsc#935856)
- python-fix-short-dh.patch: replace the 512 bits dh parameter set
  by 2048 bits to fix build with new openssl 1.0.2c (bsc#935856)
* Tue May 19 2015 schwab@suse.de
- ctypes-libffi-aarch64.patch: remove upstreamed patch
- python-2.7-libffi-aarch64.patch: Fix argument passing in libffi for
  aarch64
* Thu May 14 2015 jmatejek@suse.com
- python-3.4.3-test-conditional-ssl.patch - restore tests failing because
  test_urllib was unconditionally importing ssl (without really needing it)
- restore functionality of multilib patch
- drop libffi-ppc64le.diff because upstream completely changed everything
  yet again (sorry ppc64 folks :| )
* Fri May  1 2015 mailaender@opensuse.org
- Update to version 3.4.3
- Drop upstreamed CVE-2014-4650-CGIHTTPServer-traversal.patch
  (bpo#21766)
* Wed Mar 25 2015 rguenther@suse.com
- Add python-3.4.1-fix-faulthandler.patch, upstream patch for bogus
  faulthandler which fails with GCC 5.
* Sun Jan 11 2015 p.drouand@gmail.com
- asyncio has been merged in python3 main package; provide and
  obsolete it
- Remove obsolete AUTHORS section
- Remove redundant %%clean section
* Mon Oct 13 2014 jmatejek@suse.com
- add %%python3_version rpm macro for Fedora compatibility
- add missing argument in import_failed, rename Novell Bugzilla
  to SUSE Bugzilla
* Thu Jul 31 2014 dimstar@opensuse.org
- Rename rpmlintrc to %%{name}-rpmlintrc.
  Follow the packaging guidelines.
* Wed Jul 23 2014 jmatejek@suse.com
- CVE-2014-4650-CGIHTTPServer-traversal.patch: CGIHTTPServer file
  disclosure and directory traversal through URL-encoded characters
  (CVE-2014-4650, bnc#885882)
* Tue Jul 22 2014 jmatejek@suse.com
- drop python-3.4.1-SUSE-ensurepip.patch for compatibility reasons,
  reinstate bundled copies of pip and setuptools
  (fixes bnc#885662)
- add more files as sources to silence the validator
* Wed May 21 2014 jmatejek@suse.com
- update to 3.4.1
  * bugfix-only release, over 300 bugs fixed
- drop upstreamed python-3.4.0rc2-sqlite-3.8.4-tests.patch
- drop upstreamed CVE-2014-2667-mkdir.patch
- include Python release manager keyring and signature file
  for the source archive (thus renumbering of source files)
  (see https://www.python.org/download/#openpgp-public-keys )
- move ensurepip to python3, because it transitively requires ssl
* Fri Apr  4 2014 jmatejek@suse.com
- CVE-2014-2667-mkdir.patch: race condition with reseting umask
  in os.makedirs
  (CVE-2014-2667, bnc#871152)
- updated multilib patch to include ~/.local/lib64 (bnc#637176)
* Wed Mar 26 2014 jmatejek@suse.com
- raise timeout value for test_subprocess to 10s (might fix
  intermittent build failures in OBS)
* Mon Mar 24 2014 dmueller@suse.com
- remove blacklisting of test_posix on aarch64: qemu bug is fixed
* Mon Mar 17 2014 jmatejek@suse.com
- update to 3.4.0 final
- drop upstreamed python-3.4rc2-importlib.patch
* Sun Mar 16 2014 schwab@suse.de
- Only build with profile-opt if profiling is enabled
- Update test exclusion lists:
  * test_ctypes no longer fails on arm
  * test_io no longer fails on ppc*
  * test_multiprocessing has been split in multiple tests
  * test_posix and test_signal fail due to qemu bugs
* Fri Mar 14 2014 andreas.stieger@gmx.de
- Fix build with SQLite 3.8.4 [bnc#867887], fixing SQLite tests,
  adding python-2.7.6-sqlite-3.8.4-tests.patch
* Thu Feb 27 2014 jmatejek@suse.com
- update to 3.4.0 rc2
  * pre-release bugfixes
  * improvements to asyncio library
- drop upstreamed tracemalloc_gcov.patch
- python-3.4rc2-importlib.patch fixes backwards-incompatibility
  in the reworked importlib module that blocks build of vim
* Fri Jan 17 2014 jmatejek@suse.com
- initial commit of 3.4.0 beta 3
  * new stdlib modules: pathlib, enum, statistics, tracemalloc
  * asynchronous IO with new asyncio module
  * introspection data for builtins
  * subprocesses no longer inherit open file descriptors
  * standardized metadata for packages
  * internal hashing changed to SipHash
  * new pickle protocol
  * improved handling of codecs
  * TLS 1.2 support
  * major speed improvements for internal unicode handling
  * many bugfixes and optimizations
- see porting guide at:
  http://docs.python.org/3.4/whatsnew/3.4.html#porting-to-python-3-4
- moved several modules to -testsuite subpackage
- updated list of binary extensions, refreshed patches
- tracemalloc_gcov.patch fixes profile-based optimization build
- updated packages and pre_checkin.sh to use ~-version notation
  for prereleases
- fix-shebangs part of build process moved to common %%prep
- drop python-3.3.2-no-REUSEPORT.patch (upstreamed)
- update baselibs for new soname
- TODOs:
  * require python-pip, make ensurepip work with zypper
* Wed Dec  4 2013 matz@suse.de
- add ppc64le (ELFv2) support for libffi copy for ctypes module
- Adjust Python-3.3.0b2-multilib.patch for ppc64le (make sys.lib be
  "lib64").
- added patches:
  * libffi-ppc64le.diff
* Tue Dec  3 2013 adrian@suse.de
- add ppc64le rules
* Fri Nov 22 2013 speilicke@suse.com
- Add python-3.3.3-skip-distutils-test_sysconfig_module.patch:
  + Disable global and distutils sysconfig comparison test, we deviate
    from the default depending on optflags
* Tue Nov 19 2013 jmatejek@suse.com
- update to 3.3.3
  * bugfix-only release
  * many SSL-related fixes
  * upstream fix for CVE-2013-4238 (bnc#834601)
  * upstream fixes for CVE-2013-1752
- move example module xxlimited to python3-testsuite
- remove --with-wide-unicode config option, it is now the default
  (and only) choice
- don't touch anything between make and makeinstall
- drop python-3.2b2-buildtime-generate.patch - the issue was caused
  by touching things between make and makeinstall
- link pycache entries for import_failed hooks properly
* Thu Aug  8 2013 dvaleev@suse.com
- Exclue test_faulthandler from tests on powerpc due to bnc#831629
* Thu Jun 13 2013 jmatejek@suse.com
- update to 3.3.2
  * bugfix-only release
  * fixes several regressions introduced in 3.3.1
- switch to xz compression
- remove README.txt (bnc#709442)
- move _lzma module to python3-base
- python-3.3.2-no-REUSEPORT.patch to fix build on kernels without SO_REUSEPORT
* Mon Apr 29 2013 schwab@suse.de
- Readd missing bits from ctypes-libffi-aarch64.patch
* Sat Apr 13 2013 idonmez@suse.com
- Update to version 3.3.1
  * Fix the –enable-profiling configure switch.
  * In IDLE, close the replace dialog after it is used.
- Too many bugfixes to list here,
  see See http://hg.python.org/cpython/file/v3.3.0/Misc/NEWS
- Refresh Python-3.3.0b2-multilib.patch
- Refresh python-3.2b2-buildtime-generate.patch
- Drop upstream patches: ctypes-libffi-aarch64.patch,
  python-3.2.3rc2-pypirc-secure.patch, python-3.3.0-getdents64.patch
* Fri Apr  5 2013 idonmez@suse.com
- Add Source URL, see https://en.opensuse.org/title=SourceUrls
* Wed Apr  3 2013 jmatejek@suse.com
- remove spurious modification of python-3.3.0b1-localpath.patch
  that would force installation into /usr/local.
  this fixes bnc#809831
* Thu Mar 28 2013 jmatejek@suse.com
- replace broken movetogetdents64.diff patch with a correct one
  from upstream repo (python-3.3.0-getdents64.patch)
* Fri Mar  1 2013 dmueller@suse.com
- add ctypes-libffi-aarch64.patch:
  * import aarch64 support for libffi in _ctypes module
- add aarch64 to the list of lib64 based archs
- add movetogetdents64.diff:
  * port to getdents64, as SYS_getdents is not implemented everywhere
* Tue Feb 26 2013 saschpe@suse.de
- /etc/rpm/macros.python3 is no %%config, it is not meant to be changed
  by users.
- Add rpmlintrc with some obvious filters
* Mon Jan 28 2013 jmatejek@suse.com
- update baselibs for new version of libpython3
* Thu Nov 29 2012 jmatejek@suse.com
- fix include path in macros (bnc#787526)
- implement failed import handlers for modules that live in
  subpackages - e.g. "import ssl" will now throw a sensible error
  message telling you to install "python3"
* Wed Nov 28 2012 jmatejek@suse.com
- merge python3-xml into python3
- merge python3-2to3 library into python3-base
  and the 2to3 binary into python3-devel
  (python3-devel is now in conflict with python-2to3, which
  will be dropped)
- enable --with-system-expat for python3, making the xml modules
  (and thus python3) depend on expat
- reconfigure tests to disable network and GUI resources, which
  the upstream apparently thought is a good idea to enable by default.
  this fixes build failures in Factory
- add lzma-devel to build the _lzma module
- moved %%dynlib macro definition to common section
* Mon Nov  5 2012 coolo@suse.com
- buildrequire timezone for the test suite
* Mon Oct 29 2012 dmueller@suse.com
- disable more checks for qemu builds as they use syscalls not
  implemented yet
* Thu Oct 25 2012 Rene.vanPaassen@gmail.com
- exclude test_math for SLE 11; math library fails on negative
  gamma function values close to integers and 0, probably
  due to imprecision in -lm on SLE_11_SP2.
* Tue Oct 16 2012 coolo@suse.com
- buildrequire libbz2-devel explicitly
* Mon Oct  8 2012 jmatejek@suse.com
- remove distutils.cfg (bnc#658604)
  * this changes default prefix for distutils to /usr
  * see ML for details:
  http://lists.opensuse.org/opensuse-packaging/2012-09/msg00254.html
* Mon Oct  1 2012 idonmez@suse.com
- Update to final 3.3.0 release
  * See http://hg.python.org/cpython/file/v3.3.0/Misc/NEWS
* Thu Sep 27 2012 idonmez@suse.com
- Correct dependency for python3-testsuite,
  python3-tkinter -> python3-tk
* Thu Aug 23 2012 jmatejek@suse.com
- update to 3.3.0 RC1
* Fri Aug  3 2012 jmatejek@suse.com
- update to 3.3.0 beta 1
  * flexible string representation, no longer distinguishing
    between wide and narrow Unicode builds
  * importlib-based import system
  * virtualenv support in core
  * namespace packages
  * explicit Unicode literals for easier porting
  * key-sharing dict implementation reduces memory footprint
    of OO code
  * hash randomization on by default
  * many other new bugfixes and features, check NEWS for details
- pre_checkin.sh now autofills various version strings in specs
- ship hashlib's fallback modules - those uselessly take up space
  when real _hashlib.so from python3 is present, but the space wasted
  is only 114kB and it provides python3-base with a working hashlib
  module.
  (also, this fixes bnc#743787)
* Fri Jul 27 2012 dvaleev@suse.com
- skip test_io on ppc
- drop test_io ppc patch
* Thu Jun 28 2012 saschpe@suse.de
- Satisfy source_validator by uncommenting an otherwise unused "Patch"
  line
* Fri May 18 2012 idonmez@suse.com
- update to 3.2.3
  * No changes since rc2
* Thu Mar 29 2012 jmatejek@suse.com
- update to 3.2.3rc2
  * fixes several security issues:
  * CVE-2012-0845, bnc#747125
  * CVE-2012-1150, bnc#751718
  * CVE-2011-4944, bnc#754447
  * CVE-2011-3389, bnc#754677
- fix for insecure .pypirc (CVE-2011-4944, bnc#754447)
- disable test_gdb because it is broken by our gdb
* Thu Feb 16 2012 dvaleev@suse.com
- skip broken test_io test on ppc
* Wed Jan 18 2012 jmatejek@suse.com
- update to 3.2.2
  * bugfix-only release
  * reports "linux2" as sys.platform regardless of Linux kernel
- added pre_checkin.sh to copy common spec sections to python3.spec
- added PACKAGING-NOTES with some helpful info for packagers
* Sun Dec 25 2011 idonmez@suse.com
- Use system ffi, included one is broken see
  http://bugs.python.org/issue11729 and
  http://bugs.python.org/issue12081
* Fri Dec  9 2011 jmatejek@suse.com
- license.opensuse.org-compatible license headers
* Fri Dec  2 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Thu Nov 24 2011 agraf@suse.com
- fix ARM build (exclude some test cases which break for us)
* Tue Aug 16 2011 termim@gmail.com
- use sysconfig module to get py3_incdir, py3_abiflags,
  py3_soflags, python3_sitelib and python3_sitearch
* Mon Jul 18 2011 jmatejek@novell.com
- update to 3.2.1
  * bugfix-only release, no major changes
- fix build on linux3 platform
- remove upstreamed pybench patch
- install /usr/lib directories in all cases to prevent spurious
  "directory not owned" in dependent packages
* Wed Jun 15 2011 jmatejek@novell.com
- replaced dynamic so version with manual so version, because
  autobuild does not support autogeneration
* Tue May 24 2011 jmatejek@novell.com
- generate macros.python3 at compile-time with fixed values
- don't include bogus values in pyconfig.h, as they can break
  third-party packages (bnc#673071)
* Tue May 17 2011 jmatejek@novell.com
- added Obsoletes: python3 < 3.1 so that the transition from
  non-split to split packages goes smoothly
* Fri May 13 2011 jmatejek@novell.com
- fixed RPM macros to use python3 instead of python
- updated to build --with-wide-unicode (for compatibility with
  fedora and our own python 2.x series)
* Thu Apr 21 2011 termim@gmail.com
- fix python3-base build failure due to pybench.py crash by
  python-3.2-pybench.patch
- move pyconfig.h from python3-devel to python3-base package to
  make python3-base functional again
* Wed Mar 23 2011 termim@gmail.com
- update to python 3.2
  * stable ABI, ABI-tagged .so files
  * concurrent.futures and many other new or upgraded modules
  * PYC repository directories ( __pycache__ )
  * python WSGI 1.0.1
  * Unicode 6.0.0 support
  * a great number of bugfixes and assorted improvements
* Tue Feb  8 2011 matejcik@suse.cz
- update to python 3.2 RC2
- renamed python3-demo to python3-tools, because the demo part
  became much smaller than the tools part
- added rpm macros
* Tue Jan 18 2011 jmatejek@novell.com
- update to python 3.2 beta 2, see NEWS for details
- split off -base package with less dependencies, and a shlib-policy
  compliant libpython3 package
- mostly rewritten the spec file with more detailed comments
- cleaned up lists of patches
