#
# spec file for package postgresql
#
# Copyright (c) 2016 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

%define pgmajor 17
%define defaultpackage postgresql16

%if ! %{defined _rpmmacrodir}
%define _rpmmacrodir %{_rpmconfigdir}/macros.d
%endif

#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir /var/adm/fillup-templates
%endif

%if 0%{?suse_version} >= 1300
%bcond_without  systemd
%else
%bcond_with     systemd
%endif

# We do not need the pgmajor comparison here as it is irrelevant which version this package has
%if 0%{?suse_version} >= 1500
%bcond_without  llvm
%else
%bcond_with     llvm
%endif

# On SLE-15 up to SP3 sysusers does not support shells
# other than /bin/nologin
%if 0%{?suse_version} >= 1550 || 0%{?sle_version} >= 150400
%bcond_without sysusers
%else
%bcond_with sysusers
%endif

Name:           postgresql
Summary:        Basic Clients and Utilities for PostgreSQL
License:        PostgreSQL
Group:          Productivity/Databases/Tools
Version:        %pgmajor
Release:        150600.17.6.1
Url:            https://www.postgresql.org/
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Provides:       postgresql-noarch = %version-%release
Requires:       postgresql-implementation
Requires:       update-alternatives
Recommends:     %defaultpackage
# In June 2020 we changed the package layout for PostgreSQL and
# conflict with older releases to get a clean cut-over.
Conflicts:      postgresql < 9
Conflicts:      postgresql90
Conflicts:      postgresql91
Conflicts:      postgresql92
Conflicts:      postgresql93
Conflicts:      postgresql94 < 9.4.26
Conflicts:      postgresql95 < 9.5.22
Conflicts:      postgresql96 < 9.6.18
Conflicts:      postgresql10 < 10.13
Conflicts:      postgresql11 < 11.8
Conflicts:      postgresql12 < 12.3
BuildArch:      noarch
Source0:        postgresql-init
Source1:        postgresql-sysconfig
Source2:        postgresql-firewall
Source3:        postgresql-tmpfiles.conf
Source4:        postgresql.service
Source5:        postgresql-bashprofile
Source6:        postgresql-script
Source7:        postgresql-install-alternatives
Source8:        postgresql-extensions-macros
Source9:        postgresql.sysusers
Source10:       postgresql-README.SUSE
Source11:       postgresql-README

%if 0%{?suse_version} > 1100
    %define fwdir /etc/sysconfig/SuSEfirewall2.d/services
    %define fwname postgresql
%else
    %define fwdir /etc/sysconfig/scripts
    %define fwname SuSEfirewall2-postgresql
%endif

%description
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the basic utility and client programs necessary
to maintain and work with local or remote PostgreSQL databases as well
as manual pages for the SQL commands that PostgreSQL supports. Full
HTML documentation for PostgreSQL can be found in the postgresql-docs
package.

%package server
Summary:        The Programs Needed to Create and Run a PostgreSQL Server
Group:          Productivity/Databases/Servers
Provides:       postgresql-server-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-server-implementation
Recommends:     %defaultpackage-server
%if 0%{?suse_version} >= 1315
%if %{with sysusers}
BuildRequires:  sysuser-tools
%sysusers_requires
%else
Requires(pre):  shadow
%endif
%else
Requires(pre):  pwdutils
%endif
Provides:       postgresql-init = %version.0-%release
Obsoletes:      postgresql-init < %version.0-%release
%if %{with systemd}
BuildRequires:  pkgconfig(systemd)
%{?systemd_ordering}
%else
Requires(postun): %insserv_prereq
%endif


%description server
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, sub-queries, triggers, and user-defined
types and functions.

This package includes the programs needed to create and run a
PostgreSQL server, which will in turn allow you to create and maintain
PostgreSQL databases.

%package server-devel
Summary:        PostgreSQL server development header files and utilities
Group:          Development/Libraries/C and C++
Provides:       postgresql-server-devel-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-server-devel-implementation
Recommends:     %defaultpackage-server-devel

%description server-devel
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the header files and libraries needed to compile
C extensions that link into the PostgreSQL server. For building client
applications, see the %defaultpackage-devel package.

%package llvmjit
Summary:        Just-in-time compilation support for PostgreSQL
Group:          Productivity/Databases/Servers
Provides:       postgresql-llvmjit-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-llvmjit-implementation
Recommends:     %defaultpackage-llvmjit

%description llvmjit
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, sub-queries, triggers, and user-defined
types and functions.

This package contains support for just-in-time compiling parts of
PostgreSQL queries. Using LLVM it compiles e.g. expressions and tuple
deforming into native code, with the goal of accelerating analytics
queries.

%package llvmjit-devel
Summary:        Helper package to pull all dependencies to build with llvm support
Group:          Productivity/Databases/Servers
Provides:       postgresql-llvmjit-devel-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-server-devel-noarch
Requires:       postgresql-llvmjit-devel-implementation

%description llvmjit-devel
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, sub-queries, triggers, and user-defined
types and functions.

This package will pull all the dependencies to build extensions with llvm
support if the base distro has llvm enabled.

Otherwise it will just pull the postgresqlXY-server-devel package

%package test
Summary:        The test suite for PostgreSQL
Group:          Productivity/Databases/Servers
Provides:       postgresql-test-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-test-implementation
Recommends:     %defaultpackage-implementation

%description test
This package contains the sources and pre-built binaries of various
tests for the PostgreSQL database management system, including
regression tests and benchmarks.

%package docs
Summary:        HTML Documentation for PostgreSQL
Group:          Productivity/Databases/Tools
Provides:       postgresql-docs-noarch = %version-%release
Requires:       postgresql-docs-implementation
Recommends:     %defaultpackage-docs

%description docs
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the HTML documentation for PostgreSQL. The start
page is: file:///usr/share/doc/packages/postgresql/html/index.html .
Manual pages for the PostgreSQL SQL statements can be found in the
postgresql package.

%package contrib
Summary:        Contributed Extensions and Additions to PostgreSQL
Group:          Productivity/Databases/Tools
Provides:       postgresql-contrib-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-contrib-implementation
Recommends:     %defaultpackage-contrib

%description contrib
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

The postgresql-contrib package includes extensions and additions that
are distributed along with the PostgreSQL sources, but are not (yet)
officially part of the PostgreSQL core.

Documentation for the modules contained in this package can be found in
/usr/share/doc/packages/postgresql/contrib.

%package devel
Summary:        PostgreSQL development header files and libraries
Group:          Development/Libraries/C and C++
Provides:       postgresql-devel-noarch = %version-%release
Provides:       pkgconfig(libecpg) = %{version}-%{release}
Provides:       pkgconfig(libecpg_compat) = %{version}-%{release}
Provides:       pkgconfig(libpgtypes) = %{version}-%{release}
Provides:       pkgconfig(libpq) = %{version}-%{release}
Requires:       postgresql = %version-%release
Requires:       postgresql-devel-implementation
Recommends:     %defaultpackage-devel

%description devel
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the header files and libraries needed to compile
C applications which will directly interact with a PostgreSQL database
management server and the ECPG Embedded C Postgres preprocessor. You
need to install this package if you want to develop applications in C
which will interact with a PostgreSQL server.

%package plperl
Summary:        The PL/Tcl, PL/Perl, and  PL/Python procedural languages for PostgreSQL
Group:          Productivity/Databases/Servers
Provides:       postgresql-plperl-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-plperl-implementation
Recommends:     %defaultpackage-plperl

%description plperl
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the PL/Perl procedural language for PostgreSQL.
With this module one can use Perl to write stored procedures,
functions, and triggers.

%package plpython
Summary:        The PL/Python Procedural Languages for PostgreSQL
Group:          Productivity/Databases/Servers
Provides:       postgresql-plpython-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-plpython-implementation
Recommends:     %defaultpackage-plpython

%description plpython
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the PL/Python procedural language for PostgreSQL.
With this module one can use Python to write stored procedures,
functions, and triggers.

%package pltcl
Summary:        PL/Tcl Procedural Language for PostgreSQL
Group:          Productivity/Databases/Tools
Provides:       postgresql-pltcl-noarch = %version-%release
Requires:       postgresql = %version-%release
Requires:       postgresql-pltcl-implementation
Recommends:     %defaultpackage-pltcl

%description pltcl
PostgreSQL is an advanced object-relational database management system
that supports an extended subset of the SQL standard, including
transactions, foreign keys, subqueries, triggers, and user-defined
types and functions.

This package contains the PL/Tcl procedural language for PostgreSQL.
With thie module one can use Tcl to write stored procedures, functions,
and triggers.

%prep

%build

%if %{with sysusers}
%sysusers_generate_pre %{SOURCE9} %{name}-server %{name}-server.conf
%endif

cp %{SOURCE10} README.SUSE
cp %{SOURCE11} README

%install
mkdir -p %buildroot/var/lib/pgsql/

install -m755 -d %buildroot%{_fillupdir}
install -m644 %{S:1} %buildroot%{_fillupdir}/sysconfig.postgresql

%if 0%{?suse_version} < 1550
install -m755 -d %buildroot%fwdir
install -m644 %{S:2} %buildroot%fwdir/%fwname
%endif

install -m755 -d %buildroot/usr/sbin

install -m755 -d %buildroot/usr/share/postgresql
install -m755 %{S:7} %buildroot/usr/share/postgresql/install-alternatives

%if %{with systemd}
install -m644 %{S:5} %buildroot/usr/share/postgresql/bash_profile
install -m755 -d %buildroot/%_tmpfilesdir
install -m644 %{S:3} %buildroot%_tmpfilesdir/postgresql.conf
install -m755 %{S:6} %buildroot/usr/share/postgresql

install -m755 -d %buildroot%_unitdir
install -m444 %{S:4} %buildroot%_unitdir

ln -sf service %buildroot/usr/sbin/rcpostgresql
%else
install -m640 %{S:5} %buildroot/var/lib/pgsql/.bash_profile
install -m755 -d %buildroot/etc/init.d
install -m755 %{S:0} %buildroot/etc/init.d/postgresql
ln -sf /etc/init.d/postgresql %buildroot/usr/sbin/rcpostgresql
%endif

install -D -m 0644 %{SOURCE8} %{buildroot}%{_rpmmacrodir}/macros.%{name}

# sysusers.d
%if %{with sysusers}
install -Dm0644 %{SOURCE9} %{buildroot}%{_sysusersdir}/%{name}-server.conf
%endif


%define eflag /run/postgresql-was-enabled
%define aflag /run/postgresql-was-running

%if %{with sysusers}
%pre server -f %{name}-server.pre
%else
%pre server
getent group postgres > /dev/null ||
	groupadd -g 26 -o -r postgres
getent passwd postgres > /dev/null ||
	useradd -g postgres -o -r -d /var/lib/pgsql -s /bin/bash \
	-c "PostgreSQL Server" -u 26 postgres
%endif
%if %{with systemd}
if test -x /usr/bin/systemctl; then
%service_add_pre postgresql.service

# Save the "enabled" and "active" state across the transition of
# ownership of postgresql.service from postgresql-init to
# postgresql-server.
if [ $1 -ge 1 ]; then \
	if [ x$(systemctl is-enabled postgresql.service 2>/dev/null ||:) = "xenabled" ]; then
		touch %eflag
	fi
	systemctl is-active postgresql.service &>/dev/null && touch %aflag ||:
fi
fi
%endif

%post server
if [ -x /bin/fillup ]; then
    %fillup_only -n postgresql
fi
%if %{with systemd}
if test -x /usr/bin/systemctl; then
PROFILE="/var/lib/pgsql/.bash_profile"
if test -r "$PROFILE" && test "`cat $PROFILE`" = "/usr/share/postgresql/bash_profile"
then
	# Correct a mistake in /usr/lib/tmpfiles.d/postgresql.conf
	# that created /var/lib/pgsql/.bash_profile with invalid
	# content (bsc#1159335).
	rm "$PROFILE"
fi
%tmpfiles_create %_tmpfilesdir/postgresql.conf
%service_add_post postgresql.service
fi
%endif

%preun server
%if %{with systemd}
if test -x /usr/bin/systemctl; then
# Cannot use systemd macros here, because they're doing too much
/usr/bin/systemctl --no-reload disable postgresql.service || :
fi
%else
%stop_on_removal postgresql
%endif

%postun server
%if %{with systemd}
if test -x /usr/bin/systemctl; then
# Cannot use systemd macros here, because they're doing too much
rm -f "/var/lib/systemd/migrated/postgresql"
/usr/bin/systemctl daemon-reload || :
fi

%else
%insserv_cleanup
%endif

%if %{with systemd}
%posttrans server
if test -x /usr/bin/systemctl; then
# Save the "enabled" and "active" state across the transition of
# ownership of postgresql.service from postgresql-init to
# postgresql-server.
if test -f %eflag; then
	rm -f %eflag
	systemctl enable postgresql.service
fi

if test -f %aflag; then
	rm -f %aflag
	systemctl start postgresql.service
fi
fi
%endif

%files
%defattr(-,root,root,-)
%doc README.SUSE
%dir /usr/share/postgresql
/usr/share/postgresql/install-alternatives

%files server
%defattr(-,root,root,-)
%doc README
%attr(750,postgres,postgres) %dir /var/lib/pgsql
%if %{with systemd}
%attr(644,root,root) /usr/share/postgresql/bash_profile
%ghost %config %attr(640,postgres,postgres) /var/lib/pgsql/.bash_profile
%else
%config %attr(640,postgres,postgres) /var/lib/pgsql/.bash_profile
%endif

%if 0%{?suse_version} < 1550
%if 0%{?suse_version} > 1110
%dir %fwdir
%endif
%config %fwdir/%fwname
%endif

%{_fillupdir}/sysconfig.postgresql
/usr/sbin/rcpostgresql
%if %{with systemd}
%_tmpfilesdir/postgresql.conf
%_unitdir/
/usr/share/postgresql/postgresql-script
%ghost %dir %attr(1775,postgres,postgres) /run/postgresql
%else
%config /etc/init.d/postgresql
%dir %attr(1775,postgres,postgres) /var/run/postgresql
%endif
%if %{with sysusers}
%{_sysusersdir}/%{name}-server.conf
%endif

%files test
%defattr(-,root,root,-)
%doc README

%files docs
%defattr(-,root,root,-)
%doc README

%files contrib
%defattr(-,root,root,-)
%doc README

%files devel
%defattr(-,root,root,-)
%doc README

%files server-devel
%defattr(-,root,root,-)
%doc README
%{_rpmmacrodir}/macros.%{name}

%if %{with llvm}
%files llvmjit
%defattr(-,root,root,-)
%doc README

%files llvmjit-devel
%defattr(-,root,root,-)
%doc README
%endif

%files plperl
%defattr(-,root,root,-)
%doc README

%files plpython
%defattr(-,root,root,-)
%doc README

%files pltcl
%defattr(-,root,root,-)
%doc README

%changelog
* Wed Nov 13 2024 max@suse.com
- Bump major to 17 for SLE.
* Thu Sep 19 2024 max@suse.com
- Bump major and default to 17 for Factory and TW.
* Thu Sep 12 2024 max@suse.com
- bsc#1230423: Relax the dependency of extensions on the server
  version from exact major.minor to greater or equal, after Tom
  Lane confirmed on the PostgreSQL packagers list that ABI
  stability is being taken care of between minor releases.
* Tue Feb 27 2024 max@suse.com
- bsc#1219340: The last fix was not correct. Improve it by removing
  the dependency again and call fillup only if it is installed.
* Thu Feb  8 2024 max@suse.com
- bsc#1219340: Require fillup.
* Fri Oct 13 2023 max@suse.com
- Interlock version and release of all noarch packages except for
  the postgresql-docs.
* Thu Sep 14 2023 max@suse.com
- Bump default to 16 on Factory.
* Mon Aug  7 2023 max@suse.com
- Bump major version to prepare for PostgreSQL 16, but keep
  default at 15 for now on Factory.
* Tue May 23 2023 max@suse.com
- boo#1122892: Add a sysconfig variable for initdb.
* Mon May 15 2023 max@suse.com
- Overhaul postgresql-README.SUSE and move it from the binary
  package to the noarch wrapper package.
- bsc#1179231: Add an explanation for the /tmp -> /run/postgresql
  move and permission change.
- Add postgresql-README as a separate source file.
* Mon Mar 27 2023 max@suse.com
- bsc#1209208: Drop hard dependency on systemd
* Mon Jan  9 2023 max@suse.com
- bsc#1206796: Refine the distinction of where to use sysusers and
  use bcond to have the expression only in one place.
* Thu Sep 22 2022 schwab@suse.de
- riscv64 does not have llvm support yet,
  adapt the %%postgresql_has_llvm macro accordingly.
* Mon Sep  5 2022 dmueller@suse.com
- avoid bashisms in /bin/sh based startup script
* Sat May 21 2022 mrueckert@suse.de
- Bump to postgresql 15
* Wed Mar 16 2022 gmbr3@opensuse.org
- Change to systemd-sysusers
* Thu Feb 10 2022 max@suse.com
- Fix the pg_server_requires macro on older rpm versions (SLE-12).
* Fri Jan 28 2022 max@suse.com
- Avoid a dependency on awk in postgresql-script.
* Thu Dec  2 2021 max@suse.com
- Move the dependency of llvmjit-devel on clang and llvm to the
  implementation packages where we can depend on the correct
  versions.
* Thu Dec  2 2021 mrueckert@suse.de
- fix postgresql_has_llvm usage
* Mon Nov 15 2021 mrueckert@suse.de
- First round of changes to make it easier to build extensions for
  - add postgresql-llvmjit-devel subpackage:
    This package will pull in clang and llvm if the distro has a
    recent enough version, otherwise it will just pull
    postgresql-server-devel.
  - add postgresql macros to the postgresql-server-devel package
    those cover all the variables from pg_config and some macros
    to remove repitition from the spec files
* Tue Oct  5 2021 max@suse.com
- Bump version to 14.
- Bump default to 14 on Factory and future SPs.
* Tue May 18 2021 max@suse.com
- Re-enable build of the llvmjit subpackage on SLE, but it will
  only be delivered on PackageHub for now (boo#1183118).
* Mon Jan 25 2021 max@suse.com
- Bump default version to 13 for SLE-15-SP3.
* Fri Sep 25 2020 max@suse.com
- Bump major version to 13.
- Bump default version to 13 in OBS.
* Thu Aug 13 2020 max@suse.com
- We also transfer PostgreSQL 9.4.26 to the new package layout in
  SLE12-SP2 and newer. Reflect this in the conflict with
  postgresql94.
* Fri Jun 26 2020 max@suse.com
- Also conflict with PostgreSQL versions before 9.
- Conflicting with older versions is not limited to SLE.
* Tue Jun 16 2020 max@suse.com
- Bump version to 12.0.1, so that the binary packages also have
  a cut-point to conflict with.
* Wed Jun  3 2020 max@suse.com
- Disable LLVM on SLE (bsc#1172274).
- Conflict with versions of the binary packages prior to the
  May 2020 update, because we changed the package layout at that
  point and need a clean cutover.
* Tue Mar 24 2020 max@suse.com
- Bump package version to 12, but leave default at 10 for
  SLE-15 and SLE-15-SP1.
* Tue Dec 17 2019 max@suse.com
- Fix a mistake in the creation of /var/lib/pgsql/.bash_profile
  with the tmpfiles mechanism (bsc#1159335).
* Thu Nov 14 2019 max@suse.com
- Sync ownership of /run/postgresql in the file list with tmpfiles.
* Tue Oct 22 2019 mrueckert@suse.de
- bump to 12
* Mon Oct  7 2019 max@suse.com
- Use the correct content for .bash_profile (boo#1153168).
* Mon Sep 23 2019 max@suse.com
- Stop shipping SUSEfirewall2 config files (bsc#1151591).
- Fix installation of bash_profile for SLE11 (pre systemd).
* Fri Feb 22 2019 fbui@suse.com
- Drop use of $FIRST_ARG in .spec
  The use of $FIRST_ARG was probably required because of the
  %%service_* rpm macros were playing tricks with the shell positional
  parameters. This is bad practice and error prones so let's assume
  that no macros should do that anymore and hence it's safe to assume
  that positional parameters remains unchanged after any rpm macro
  call.
* Tue Feb 19 2019 max@suse.com
- Change the persmissions for /var/run/postgresql to 1775, so that
  the directory can only be used by users in the postgres group
  (bsc#1123886).
* Thu Jan 31 2019 max@suse.com
- Move bash profile out of /var/lib to allow transactional updates
  (bsc#1100397).
- Use /run/postgresql instead of /var/run/postgresql in %%ghost and
  postgresql-tmpfiles.conf to avoid rpmlint warnings and errors.
* Fri Nov 30 2018 mrueckert@suse.de
- add /var/run/postgresql to the filelist. as %%ghost for systemd
  systems and directly for non systemd systems
* Fri Nov 30 2018 mrueckert@suse.de
- fix the unexpanded macro in the description of server-devel
* Thu Nov 15 2018 max@suse.com
- Also bump the default package to 11.
* Wed Nov  7 2018 mrueckert@suse.de
- add server-devel and llvmjit package file sections
* Thu Oct 25 2018 max@suse.com
- Add the new subpackages server-devel and llvmjit that were
  introduced with postgresql11.
* Mon Jul  2 2018 mrueckert@suse.de
- bump to 11
* Mon Apr 30 2018 dimstar@opensuse.org
- Require update-alternatives by postgresql: one of the main
  scripts in use is install-alternatives, which calls u-a.
* Fri Feb  2 2018 max@suse.com
- Put POSTGRES_LANG into LC_ALL instead of LANG to retain the
  previous behaviour of that variable (boo#1077027).
* Wed Jan 17 2018 max@suse.com
- postgresql-script: /etc/sysconfig/language is deprecated, use the
  locale that was inherited from systemd instead for initializing
  a new database instance (boo#1074988).
* Wed Dec 13 2017 mrueckert@suse.de
- add provides for all the pkgconfig() provides you also find in
  the postgresqlXY-devel packages. then we automatically will pull
  postgresql-devel which in turn will pull our default
  postgresqlXY-devel package. (boo#1071971)
* Wed Dec  6 2017 bruno@ioda-net.ch
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Fri Nov 24 2017 mrueckert@suse.de
- instead of hardcoding version 10, just check if the prio is
  smaller than 80.
* Thu Nov 23 2017 mrueckert@suse.de
- simplify the postgresql-install-alternatives to only require the
  pg version and go from there.
  supported calls of the script are:
  /usr/share/postgresql/install-alternatives postgresqlXY
  /usr/share/postgresql/install-alternatives XY
  where XY can currently be: 92 93 94 95 96 10
* Wed Nov 22 2017 max@suse.com
- CVE-2017-14798, bsc#1062722: Fix LPE via postgres init script.
  This only affected SysV-init based systems (i.e. SLE11).
* Tue Nov 14 2017 max@suse.com
- postgresql-test was missing a %%files section.
* Fri Nov  3 2017 max@suse.com
- Move the start/stop script to /usr/share/postgresql
- Add a script for handling update-alternatives as subpackages
  get installed/uninstalled, so that the implementation packages
  don't have to repeat the logic (postgresql-install-alternatives).
- Add the postgresql-test subpackage.
- Fix some dependencies.
- Save the enabled and running state when upgrading from the
  obsolete postgresql-init package.
* Fri Oct  6 2017 mrueckert@suse.de
- properly guard the systemd macro in %%pre server so it wont be
  used on sle11
- add Requires(pre) so we have groupadd/useradd available
* Thu Sep 21 2017 max@suse.com
- Refine the dependencies between the "dummy" packages and the
  actual implementation of PostgreSQL. The dummy packages now
  require an arbitrary implementation and recommend the default
  version.
- Move the contents of postgresql-init to the server package.
* Thu Aug  3 2017 mrueckert@suse.de
- bump to 10
* Wed Jun 28 2017 max@suse.com
- Bump version and defaultpackage to 9.6 in SLE12 (bsc#1046324).
* Sun Oct 30 2016 13ilya@gmail.com
- Bump version and defaultpackage to 9.6 in Factory.
* Mon Sep 28 2015 max@suse.com
- Move ~postgres/.bash_profile to postgresql-server to avoid a
  file conflict between the versioned server packages.
* Sun Aug 16 2015 ro@suse.de
- Bump version and defaultpackage to 9.4. in SLE (bnc#941886)
* Wed Feb 18 2015 max@suse.com
- Bump version and defaultpackage to 9.4 in Factory.
* Tue Sep 17 2013 max@suse.com
- Bump version and defaultpackage to 9.3.
* Wed Jan  9 2013 max@suse.com
- Change license string to PostgreSQL.
* Fri Oct  5 2012 max@suse.com
- Make all dummy packages noarch.
* Thu Oct  4 2012 max@suse.com
- Make PostgreSQL 9.2 the default.
* Mon Oct  1 2012 max@suse.com
- Reduce the postgresql packages with unversioned names to dummy
  packages that require the respective versioned package names.
