#
# spec file for package firewalld
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

# Modern python stack in SLE-15
%global flavor %{nil}
%if "%{flavor}" == "python311"
%bcond_without python311
%else
%bcond_with python311
%endif

#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir %{_localstatedir}/adm/fillup-templates
%endif
%if 0%{?suse_version} < 1550 && 0%{?sle_version} < 150400
# systemd-rpm-macros(or kmod) is wrong in 15.2 and 15.3
%define _modprobedir /lib/modprobe.d
%endif
%global modprobe_d_files firewalld-sysctls.conf

Name:           firewalld
Version:        2.0.1
Release:        150600.3.12.1
Summary:        A firewall daemon with D-Bus interface providing a dynamic firewall
License:        GPL-2.0-or-later
Group:          Productivity/Networking/Security
URL:            https://www.firewalld.org
Source0:        https://github.com/firewalld/firewalld/releases/download/v%{version}/firewalld-%{version}.tar.bz2
Source1:        docker-zone.xml
Patch0:         0002-Disable-FlushAllOnReload-option.patch
#upstream https://github.com/firewalld/firewalld/pull/1406, bsc#1231771
Patch1:		0001-fix-nftables-set-correctly-match-iifname-oifname.patch
Patch2:		0002-test-ipset-verify-match-with-iface.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  desktop-file-utils
BuildRequires:  docbook-xsl-stylesheets
# Adding tools to BuildRequires as well so they can be autodetected
# Else the configure tool will set them to /bin/false
BuildRequires:  fdupes
BuildRequires:  ebtables
BuildRequires:  gettext
BuildRequires:  glib2-devel
BuildRequires:  gobject-introspection
BuildRequires:  hicolor-icon-theme
BuildRequires:  intltool
BuildRequires:  ipset
BuildRequires:  iptables
BuildRequires:  nftables
BuildRequires:  libxslt-tools
%if %{with python311}
BuildRequires:  python311-devel
%else
BuildRequires:  python3-devel
%endif
BuildRequires:  systemd-rpm-macros
Recommends:     logrotate
Obsoletes:      firewalld-prometheus-config < 0.2
Provides:       firewalld-prometheus-config = 0.2
Requires:       ebtables
Requires:       ipset
Requires:       iptables
Requires:       logrotate
Requires:       nftables
Requires:       python3-firewall = %{version}
Requires:       python3-gobject
Requires:       python3-nftables
Requires(post): %fillup_prereq
Suggests:       susefirewall2-to-firewalld
BuildArch:      noarch
%{?systemd_ordering}

%description
firewalld is a firewall service daemon that provides a dynamic customizable
firewall with a D-Bus interface.

%package -n python3-firewall
Summary:        Python3 bindings for FirewallD
Group:          Productivity/Networking/Security
Requires:       dbus-1-python3
Requires:       python3-dbus-python
Requires:       python3-decorator
Requires:       python3-gobject

%description -n python3-firewall
The python3 bindings for firewalld.

%package -n python311-firewall
Summary:        Python3.11 bindings for FirewallD
Group:          Productivity/Networking/Security
Requires:       dbus-1-python311
Requires:       python311-dbus-python
Requires:       python311-decorator
Requires:       python311-gobject

%description -n python311-firewall
The python3.11 bindings for firewalld.

%package -n firewall-macros
Summary:        FirewallD RPM macros
Group:          Productivity/Networking/Security

%description -n firewall-macros
This package provides the firewalld RPM macros file needed by packages
which provide their own firewalld service files.

%package -n firewall-applet
Summary:        Firewall panel applet
Group:          Productivity/Networking/Security
Requires:       firewall-config = %{version}-%{release}
Requires:       hicolor-icon-theme
Requires:       python3-gobject
Requires:       python3-qt5

%description -n firewall-applet
The firewall panel applet provides a status information of firewalld and also
the firewall settings.

%package -n firewall-config
Summary:        Firewall configuration application
Group:          Productivity/Networking/Security
Requires:       %{name} = %{version}-%{release}
Requires:       hicolor-icon-theme
Requires:       python3-gobject-Gdk

%description -n firewall-config
The firewall configuration application provides an configuration interface for
firewalld.

%package test
Summary:        Firewalld testsuite
Group:          Productivity/Networking/Security

%description test
This package provides the firewalld testsuite.

%package bash-completion
Summary:        Bash Completion for firewalld
Group:          Productivity/Networking/Security
Requires:       %{name} = %{version}-%{release}
Requires:       bash-completion
Supplements:    (%{name} and bash-completion)

%description bash-completion
Bash command line completion support for firewalld.

%package zsh-completion
Summary:        Zsh Completion for firewalld
Group:          Productivity/Networking/Security
Requires:       %{name} = %{version}-%{release}
Requires:       zsh
Supplements:    (%{name} and zsh)

%description zsh-completion
Zsh command line completion support for firewalld.

%lang_package

%prep
%autosetup -p1

# bsc#1078223
rm config/services/high-availability.xml

%build
%if %{with python311}
export PYTHON="%{_bindir}/python3.11"
%else
export PYTHON="%{_bindir}/python3"
%endif
autoreconf -fiv
%configure \
  --enable-sysconfig \
  --enable-rpmmacros \
  --with-ifcfgdir="%{_sysconfdir}/sysconfig/network"

# Normally documentation is shipped but this will ensure that missing
# files will be generated.
%make_build

%install
%make_install

%if %{with python311}
%python311_compile
%else
%py3_compile %{buildroot}
%endif

# remove files that shouldn't exist in the final rpms
rm -rf %{buildroot}%{_datadir}/%{name}/__pycache__

desktop-file-install --delete-original \
  --dir %{buildroot}%{_sysconfdir}/xdg/autostart \
  %{buildroot}%{_sysconfdir}/xdg/autostart/firewall-applet.desktop

desktop-file-install --delete-original \
  --dir %{buildroot}%{_datadir}/applications \
  %{buildroot}%{_datadir}/applications/firewall-config.desktop

# fillup_only will take care of that
%{_bindir}/install -c -D -m 600 %{buildroot}%{_sysconfdir}/sysconfig/firewalld %{buildroot}%{_fillupdir}/sysconfig.%{name}
rm %{buildroot}%{_sysconfdir}/sysconfig/firewalld

ln -sf %{_sbindir}/service %{buildroot}/%{_sbindir}/rcfirewalld

# add firewalld zone (rhbz#1817022)
install -dp %{buildroot}%{_prefix}/lib/firewalld/zones
install -p -m 644 %{SOURCE1} %{buildroot}%{_prefix}/lib/firewalld/zones/docker.xml

# No more /etc
mkdir -p %{buildroot}%{_modprobedir}
mv %{buildroot}%{_sysconfdir}/modprobe.d/* %{buildroot}%{_modprobedir}
%if 0%{?suse_version} >= 1550
mkdir -p %{buildroot}%{_distconfdir}/xdg/autostart
mkdir -p %{buildroot}%{_distconfdir}/logrotate.d
mv %{buildroot}%{_sysconfdir}/xdg/autostart/* %{buildroot}%{_distconfdir}/xdg/autostart
mv %{buildroot}%{_sysconfdir}/logrotate.d/firewalld %{buildroot}%{_distconfdir}/logrotate.d/firewalld
%endif

%if %{with python311}
%fdupes %{buildroot}%{python311_sitelib}
%else
%fdupes %{buildroot}%{python3_sitelib}
%endif

%find_lang %{name} --all-name

# Remove non python311 files
%if %{with python311}
rm -rf %{buildroot}%{_sysconfdir}
rm -rf %{buildroot}%{_modprobedir}
rm -rf %{buildroot}%{_bindir}
rm -rf %{buildroot}%{_sbindir}
rm -rf %{buildroot}%{_datadir}
rm -rf %{buildroot}%{_prefix}/lib/firewalld
rm -rf %{buildroot}%{_prefix}/lib/rpm
rm -rf %{buildroot}%{_prefix}/lib/systemd
%endif

%pre
%service_add_pre firewalld.service
# Avoid restoring outdated stuff in posttrans
for _f in %{?modprobe_d_files}; do
    [ ! -f "/etc/modprobe.d/${_f}.rpmsave" ] || \
        mv -f "/etc/modprobe.d/${_f}.rpmsave" "/etc/modprobe.d/${_f}.rpmsave.old" || :
done
%if 0%{?suse_version} > 1500
# Prepare for migration to /usr/etc; save any old .rpmsave
for i in logrotate.d/firewalld ; do
   test -f %{_sysconfdir}/${i}.rpmsave && mv -v %{_sysconfdir}/${i}.rpmsave %{_sysconfdir}/${i}.rpmsave.old ||:
done
%endif

%post
%service_add_post firewalld.service
%fillup_only firewalld

%preun
%service_del_preun firewalld.service

%postun
# We might a have runtime configuration which we haven't
# made it permanent yet so restarting the service could be
# dangerous. It's safer to not touch the firewall ourselves but
# Let the user restart it whenever he feels like it.
%service_del_postun_without_restart firewalld.service

%posttrans
# Migration of modprobe.conf files to _modprobedir
for _f in %{?modprobe_d_files}; do
    [ ! -f "/etc/modprobe.d/${_f}.rpmsave" ] || \
        mv -fv "/etc/modprobe.d/${_f}.rpmsave" "/etc/modprobe.d/${_f}" || :
done
%if 0%{?suse_version} > 1500
# Migration to /usr/etc, restore just created .rpmsave
for i in logrotate.d/firewalld ; do
   test -f %{_sysconfdir}/${i}.rpmsave && mv -v %{_sysconfdir}/${i}.rpmsave %{_sysconfdir}/${i} ||:
done
%endif

%post -n firewall-applet
/bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null || :

%postun -n firewall-applet
if [ $1 -eq 0 ] ; then
    /bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null
    %{_bindir}/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
    %{_bindir}/glib-compile-schemas %{_datadir}/glib-2.0/schemas &> /dev/null || :
fi

%posttrans -n firewall-applet
%{_bindir}/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
%{_bindir}/glib-compile-schemas %{_datadir}/glib-2.0/schemas &> /dev/null || :

%post -n firewall-config
/bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null || :

%postun -n firewall-config
if [ $1 -eq 0 ] ; then
    /bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null
    %{_bindir}/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
    %{_bindir}/glib-compile-schemas %{_datadir}/glib-2.0/schemas &> /dev/null || :
fi

%posttrans -n firewall-config
%{_bindir}/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
%{_bindir}/glib-compile-schemas %{_datadir}/glib-2.0/schemas &> /dev/null || :

%if %{with python311}
%files -n python311-firewall
%attr(0755,root,root) %dir %{python311_sitelib}/firewall
%attr(0755,root,root) %dir %{python311_sitelib}/firewall/config
%attr(0755,root,root) %dir %{python311_sitelib}/firewall/core
%attr(0755,root,root) %dir %{python311_sitelib}/firewall/core/io
%attr(0755,root,root) %dir %{python311_sitelib}/firewall/server
%attr(0755,root,root) %{python311_sitelib}/firewall/__pycache__
%attr(0755,root,root) %{python311_sitelib}/firewall/config/__pycache__
%attr(0755,root,root) %{python311_sitelib}/firewall/core/__pycache__
%attr(0755,root,root) %{python311_sitelib}/firewall/core/io/__pycache__
%attr(0755,root,root) %{python311_sitelib}/firewall/server/__pycache__
%{python311_sitelib}/firewall/*.py*
%{python311_sitelib}/firewall/config/*.py*
%{python311_sitelib}/firewall/server/*.py*
%{python311_sitelib}/firewall/core/io/*.py*
%{python311_sitelib}/firewall/core/*.py*
%else
%files
%doc README.md
%license COPYING
%{_sbindir}/firewalld
%{_sbindir}/rcfirewalld
%{_bindir}/firewall-cmd
%{_bindir}/firewall-offline-cmd
%dir %{_prefix}/lib/firewalld
%dir %{_prefix}/lib/firewalld/icmptypes
%dir %{_prefix}/lib/firewalld/ipsets
%dir %{_prefix}/lib/firewalld/services
%dir %{_prefix}/lib/firewalld/zones
%dir %{_prefix}/lib/firewalld/helpers
%dir %{_prefix}/lib/firewalld/policies
%{_prefix}/lib/firewalld/icmptypes/*.xml
%{_prefix}/lib/firewalld/ipsets/README.md
%{_prefix}/lib/firewalld/services/*.xml
%{_prefix}/lib/firewalld/zones/*.xml
%{_prefix}/lib/firewalld/helpers/*.xml
%{_prefix}/lib/firewalld/policies/*.xml
%{_datadir}/polkit-1
%dir %{_datadir}/dbus-1
%dir %{_datadir}/dbus-1/system.d
%dir %{_modprobedir}
%{_modprobedir}/firewalld-sysctls.conf
%config(noreplace) %{_sysconfdir}/firewalld/firewalld.conf
%config(noreplace) %{_sysconfdir}/firewalld/lockdown-whitelist.xml
%if 0%{?suse_version} > 1550
%{_distconfdir}/logrotate.d/firewalld
%else
%config(noreplace) %{_sysconfdir}/logrotate.d/firewalld
%endif
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld/icmptypes
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld/services
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld/zones
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld/ipsets
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld/helpers
%attr(0750,root,root) %dir %{_sysconfdir}/firewalld/policies
%{_unitdir}/firewalld.service
%{_fillupdir}/sysconfig.%{name}
%{_datadir}/dbus-1/system.d/FirewallD.conf
%{_mandir}/man1/firewall*cmd*.1%{?ext_man}
%{_mandir}/man1/firewalld*.1%{?ext_man}
%{_mandir}/man5/firewall*.5%{?ext_man}

%files -n python3-firewall
%attr(0755,root,root) %dir %{python3_sitelib}/firewall
%attr(0755,root,root) %dir %{python3_sitelib}/firewall/config
%attr(0755,root,root) %dir %{python3_sitelib}/firewall/core
%attr(0755,root,root) %dir %{python3_sitelib}/firewall/core/io
%attr(0755,root,root) %dir %{python3_sitelib}/firewall/server
%attr(0755,root,root) %{python3_sitelib}/firewall/__pycache__
%attr(0755,root,root) %{python3_sitelib}/firewall/config/__pycache__
%attr(0755,root,root) %{python3_sitelib}/firewall/core/__pycache__
%attr(0755,root,root) %{python3_sitelib}/firewall/core/io/__pycache__
%attr(0755,root,root) %{python3_sitelib}/firewall/server/__pycache__
%{python3_sitelib}/firewall/*.py*
%{python3_sitelib}/firewall/config/*.py*
%{python3_sitelib}/firewall/server/*.py*
%{python3_sitelib}/firewall/core/io/*.py*
%{python3_sitelib}/firewall/core/*.py*

%files -n firewall-macros
%{_rpmmacrodir}/macros.firewalld

%files -n firewall-applet
%attr(0755,root,root) %{_bindir}/firewall-applet
%dir %{_sysconfdir}/firewall
%config(noreplace) %{_sysconfdir}/firewall/applet.conf
%if %{undefined _distconfdir}
%{_sysconfdir}/xdg/autostart/firewall-applet.desktop
%else
%{_distconfdir}/xdg/autostart/firewall-applet.desktop
%endif
%{_datadir}/icons/hicolor/*/apps/firewall-applet*.*
%{_mandir}/man1/firewall-applet*.1%{?ext_man}

%files -n firewall-config
%dir %{_datadir}/firewalld
%attr(0755,root,root) %{_bindir}/firewall-config
%{_datadir}/firewalld/firewall-config.glade
%attr(0755,root,root) %{_datadir}/firewalld/gtk3_chooserbutton.py*
%attr(0755,root,root) %{_datadir}/firewalld/gtk3_niceexpander.py*
%{_datadir}/applications/firewall-config.desktop
%{_datadir}/metainfo/firewall-config.appdata.xml
%{_datadir}/icons/hicolor/*/apps/firewall-config*.*
%{_datadir}/glib-2.0/schemas/org.fedoraproject.FirewallConfig.gschema.xml
%{_mandir}/man1/firewall-config*.1%{?ext_man}

%files test
%dir %{_datadir}/firewalld/testsuite
%{_datadir}/firewalld/testsuite/README.md
%{_datadir}/firewalld/testsuite/testsuite
%dir %{_datadir}/firewalld/testsuite/integration
%{_datadir}/firewalld/testsuite/integration/testsuite
%dir %{_datadir}/firewalld/testsuite/python
%attr(0755,root,root) %{_datadir}/firewalld/testsuite/python/*.py
%attr(0755,root,root) %{_datadir}/firewalld/testsuite/python/__pycache__

%files bash-completion
%dir %{_datadir}/bash-completion/completions
%{_datadir}/bash-completion/completions/firewall-cmd

%files zsh-completion
%dir %{_datadir}/zsh/site-functions
%{_datadir}/zsh/site-functions/_firewalld

%files lang -f %{name}.lang
%endif

%changelog
* Tue Jul  8 2025 fvogt@suse.com
- Do not recommend python311-firewalld (bsc#1246100)
* Fri May 23 2025 meissner@suse.com
- added a python311 flavor
* Thu Oct 31 2024 davide.benini@suse.com
- Fix for SG#69031, bsc#1231771:
  * 0001-fix-nftables-set-correctly-match-iifname-oifname.patch:
    [PATCH 1/2] fix(nftables): set: correctly match iifname/oifname
  * 0002-test-ipset-verify-match-with-iface.patch: [PATCH 2/2]
    test(ipset): verify match with iface
* Tue Oct  3 2023 mohd.saquib@suse.com
- update to v2.0.1 (jsc#PED-5597)
  * fix(cli): all --list-all-zones output identical (d30bc61)
  * fix(cli): properly show default zone attribute (ea8d9a8)
  * fix(cli): properly show active attribute for zones and policies (b202403)
  * fix(cli): --get-active-zones should include the default zone (dae9112)
  * fix(nftables): always flush main table on start (cd20981)
  * fix(runtimeToPermanent): deepcopy settings before mangling (9c53639)
  * docs: fix reference to lockdown-whitelist.xml in SYNOPSIS section (1c77205)
  * fix(firewall-config): escape markup stored in bindings store (c876fd0)
  * fix(tests): avoid deprecated assertRaisesRegexp for assertRaisesRegex (2935119)
  * fix(icmp): fix check_icmpv6_name() to use correct IPv6 names (af3c35b)
  * fix(ipset): fix configuring IP range for ipsets with nftables (6a050ec)
  * fix(ipset): fix configuring "timeout","maxelem" values for ipsets with nftables (7d3340c)
  * fix(core): fix exception while parsing invalid "tcp-mss-clamp" in policy (ff61209)
  * docs(policy): fix wrong documentation of in man firewalld.policy (21026d9)
  * Correct Requires, python3-slip-dbus -> python3-dbus-python
  * This is a major release. The major version is being bumped symbolically
    to reflect significant changes done in commit f4d2b80 ("fix(policy):
    disallow zone drifting"). It does not contain any deliberate breaking changes
  * fix(reload): restore policy for old backend if it changed (de85849)
  * fix(io): rich: tcp mss: handle value=None (8016f10)
  * fix(firewall-config): rich: set destination address (f6641a9)
  * fix(policy): mixed IP families in ingress/egress (69ed4d6)
- removed following patches:
  [- 0001-chore-fw_zone-call-permanent-config-checks-at-runtim.patch]
  [- 0003-firewall-offline-cmd-fail-fix.patch]
  [- 0004-fix_rich_source_address_with_netmask.patch]
  [- feature-upstream-new-check-config-1.patch]
  [- feature-upstream-new-check-config-2.patch]
* Tue Jul 11 2023 mohd.saquib@suse.com
- Fix firewalld does not longer understand IPv4 network masks
  of type `255.255.255.0`
  Added following patch (boo#1212974)
  [+ 0004-fix_rich_source_address_with_netmask.patch]
* Fri Jan 13 2023 mohd.saquib@suse.com
- Fix firewall-offline-cmd fails with ERROR: Calling pre func
  Added following patch (bsc#1206928)
  [+ 0003-firewall-offline-cmd-fail-fix.patch]
* Mon May  9 2022 sflees@suse.de
- Fix regression introduced in previous patch (an api change to a
  function also needed backporting) (bsc#1198814)
  * feature-upstream-new-check-config-1.patch
  * feature-upstream-new-check-config-2.patch
* Mon Mar 28 2022 witold.bedyk@suse.com
- Provide dummy firewalld-prometheus-config package (bsc#1197042)
* Wed Mar 16 2022 mrostecki@suse.com
- Add patch which fixes the zone configuration (bsc#1191837)
  * 0001-chore-fw_zone-call-permanent-config-checks-at-runtim.patch
* Fri Mar  4 2022 mwilck@suse.com
- Fix modprobe.d directory for SLE15 SP3
- Always own %%_modprobedir (bsc#1196275, jsc#SLE-20639)
* Wed Apr  7 2021 mrostecki@suse.com
- Remove dependency on firewalld from firewall-macros (bsc#1183404)
* Tue Jan 26 2021 mrostecki@suse.com
- Disable FlushAllOnReload option to not retain interface to zone
  assignments and direct rules when using --reload option.
  * 0002-Disable-FlushAllOnReload-option.patch
* Mon Jan 25 2021 mrostecki@suse.com
- Update to 0.9.3 (jsc#SLE-17336):
  * docs(dbus): fix invalid method names
  * fix(forward): iptables: ipset used as zone source
  * fix(rich): non-printable characters removed from rich rules
  * docs(firewall-cmd): small description grammar fix
  * fix(rich): limit table to strip non-printables to C0 and C1
  * fix(zone): add source with mac address
* Thu Jan 14 2021 rfrohl@suse.com
- Add dependency for firewall-offline-cmd (bsc#1180883)
* Mon Nov  9 2020 mrostecki@suse.com
- Remove the patch which enforces usage of iptables instead of
  nftables (jsc#SLE-16300):
  * 0001-firewall-backend-Switch-default-backend-to-iptables.patch
- Add firewalld zone for the docker0 interface. This is the
  workaround for lack of nftables support in docker. Without that
  additional zone, containers have no Internet connectivity.
  (rhbz#1817022, jsc#SLE-16300)
- Update to 0.9.1:
  * Bugfixes:
  * docs(firewall-cmd): clarify lockdown whitelist command paths
  * fix(dbus): getActivePolicies shouldn't return a policy if a zone is not active
  * fix(policy): zone interface/source changes should affect all using zone
* Fri Sep 11 2020 fbui@suse.com
- Make use of %%service_del_postun_without_restart
  And stop using DISABLE_RESTART_ON_UPDATE as this interface is
  obsolete.
* Wed Sep  9 2020 mrostecki@suse.com
- Add python3-nftables as a requirement.
* Fri Sep  4 2020 callumjfarmer13@gmail.com
- update to 0.9.0:
  * New major features
  * prevention of Zone Drifting
  * Intra Zone Forwarding
  * Policy Objects
  * For a full list of changes, see
    https://github.com/firewalld/firewalld/compare/v0.8.0...v0.9.0
* Sun Aug 16 2020 dmueller@suse.com
- update to 0.8.3:
  * nftables: convert to libnftables JSON interface
  * service: new “helper” element to replace “module” More accurately represents the conntrack helper. Deprecates “module”.
  * allow custom helpers using standard helper modules (rhbz 1733066)
  * testsuite is now shipped in the dist tarball
  * Typo in firewall-config(1)
  * Fix typo in TFTP service description
  * doc: README: add note about language translations
  * fix: rich: source/dest only matching with mark action
  * feat: AllowZoneDrifting config option
  * feat: nftables: support AllowZoneDrifting=yes
  * feat: ipXtables: support AllowZoneDrifting=yes
  * fix: firewall-offline-cmd: Don’t print warning about AllowZoneDrifting
  * fix: add logrotate policy
  * doc: direct: add CAVEATS section
  * fix: checkIP6: strip leading/trailing square brackets
  * fix: nftables: remove square brackets from IPv6 addresses
  * fix: ipXtables: remove square brackets from IPv6 addresses
  * fix: nftables: ipset types using “port”
  * fix: nftables: zone dispatch with multidimensional ipsets
  * fix: ipset: destroy runtime sets on reload/stop
  * fix: port: support querying sub ranges
  * fix: source_port: support querying sub ranges
  * doc: specify accepted characters for object names
  * fix: doc: address copy/paste mistakes in short/description
  * fix: configure: atlocal: quote variable values
  * fix: nftables: allow set intervals with concatenations
  * doc: clarify –set-target values “default” vs “reject”
  * fix: update dynamic DCE RPC ports in freeipa-trust service
  * fix: nftables: ipset: port ranges for non-default protocols
  * fix(systemd): Conflict with nftables.service
  * fix(direct): rule in a zone chain
  * fix(client): addService needs to reduce tuple size
  * fix(doc): dbus: signatures for zone tuple based APIs
  * fix(config): bool values in dict based import/export
  * fix(dbus): service: don’t cleanup config for old set APIs
  * fix(ipset): flush the set if IndividiualCalls=yes
  * fix(firewall-offline-cmd): remove instances of “[P]” in help text
  * fix(rich): source mac with nftables backend
  * docs: replace occurrences of the term blacklist with denylist
  * fix: core: rich: Catch ValueError on non-numeric priority values
  * docs(README): add libxslt for doc generation
  * fix(cli): add –zone is an invalid option with –direct
  * fix(cli): add ipset type hash:mac is incompatible with the family parameter
* Wed Aug 12 2020 mrostecki@suse.com
- Update to version 0.7.5 (jsc#SLE-12281):
  * release: v0.7.5
  * chore(translation): merge from master
  * fix(cli): add ipset type hash:mac is incompatible with the family parameter Fixes: rhbz1541077
  * test(rhbz1483921): better test name
  * fix(cli): add --zone is an invalid option with --direct
  * fix: core: rich: Catch ValueError on non-numeric priority values
  * fix: update dynamic DCE RPC ports in freeipa-trust service
  * docs: replace occurrences of the term blacklist with denylist
  * docs(README): add libxslt for doc generation
  * test(rich): source mac with nftables backend
  * fix(firewall-offline-cmd): remove instances of "[P]" in help text
  * test(check-container): add support for centos8 stream
  * test(functions): use IndividualCalls if host doesn't support nft rule index
  * test(functions): add macro IF_HOST_SUPPORTS_NFT_RULE_INDEX
  * test(dbus): better way to check IPv6_rpfilter expected value
  * fix(ipset): flush the set if IndividiualCalls=yes
  * test(ipv6): skip square bracket address tests if ipv6 not available
  * test(gh509): only run test for nftables backend
  * fix(dbus): service: don't cleanup config for old set APIs
  * fix(config): bool values in dict based import/export
  * fix(doc): dbus: signatures for zone tuple based APIs
  * test(dbus): zone: fix zone runtime functional test title
  * test(dbus): zone: fix false failure due to list order
  * fix(client): addService needs to reduce tuple size
  * test(direct): rule in a zone chain
  * fix(direct): rule in a zone chain
  * test(dbus): zone: verify runtime config APIs
  * test(dbus): zone: verify permanent config APIs
  * fix(systemd): Conflict with nftables.service
  * fix: test/regression/gh599: use expr to be more portable
  * test: dbus: zone: verify runtime config API signatures
  * test: dbus: zone: verify permanent config API signatures
  * fix: test/regression/gh599: fix if not using debug output
  * test: log: verify logging still works after truncate
  * test: ipset: verify port ranges for non-default protocol
* Fri Apr  3 2020 Mathias.Homann@opensuse.org
- Update to 0.7.4
  This is a bug fix only release.
  However, it does reintroduce the zone drifting bug as a feature. See #258 and #441. This behavior is disabled by default.
  * improvement: build: add an option to disable building documentation
  * Typo in firewall-config(1)
  * Fix typo in TFTP service description
  * doc: README: add note about language translations
  * fix: rich: source/dest only matching with mark action
  * feat: AllowZoneDrifting config option
  * feat: nftables: support AllowZoneDrifting=yes
  * feat: ipXtables: support AllowZoneDrifting=yes
  * fix: firewall-offline-cmd: Don't print warning about AllowZoneDrifting
  * fix: add logrotate policy
  * fix: tests: regenerate testsuite if .../{cli,python}/*.at changes
  * doc: direct: add CAVEATS section
  * fix: checkIP6: strip leading/trailing square brackets
  * fix: nftables: remove square brackets from IPv6 addresses
  * fix: ipXtables: remove square brackets from IPv6 addresses
  * fix: nftables: zone dispatch with multidimensional ipsets
  * fix: ipset: destroy runtime sets on reload/stop
  * fix: port: support querying sub ranges
  * fix: source_port: support querying sub ranges
  * doc: specify accepted characters for object names
  * fix: doc: address copy/paste mistakes in short/description
  * fix: configure: atlocal: quote variable values
  * fix: nftables: allow set intervals with concatenations
  * doc: clarify --set-target values "default" vs "reject"
* Sun Mar  8 2020 hpj@urpla.net
- Update to version 0.7.3:
  * release: v0.7.3
  * chore: update translations
  * doc: README: add note about integration tests
  * test: check-container: also run check-integration
  * test: integration: NM zone overrides interface on reload
  * test: build: support integration tests
  * test: functions: add macro NMCLI_CHECK
  * test: functions: new macros for starting/stopping NetworkManager
  * fix: test: leave "cleanup" for tests cases
  * test: check-container: add support for fedora rawhide
  * test: check-container: add support for debian sid
  * test: build: add support for running in containers
  * fix: test/functions: FWD_END_TEST: improve grep for errors/warnings
  * fix: test: direct passthrough: no need to check for dummy module
  * fix: test: CHECK_NAT_COEXISTENCE: only check for kernel version
  * fix: reload: let NM interface assignments override permanent config
  * chore: tests: rename IF_IPV6_SUPPORTED to IF_HOST_SUPPORTS_IPV6_RULES
  * fix: tests: convert host ipv6 checks to runtime
  * fix: tests: convert ip6tables checks to runtime
  * fix: tests: convert probe of nft numeric args to runtime
  * fix: tests: convert nftables fib checks to runtime
  * fix: build: distribute testsuite
  * fix: don't probe for available kernel modules
  * fix: failure to load modules no longer fatal
  * fix: tests/functions: canonicalize XML output
  * chore: doc: update authors
  * fix: test: use debug output based on autotest variable
  * fix: src/tests/Makefile: distclean should clean atconfig
* Tue Feb  4 2020 bjorn.lie@gmail.com
- No longer recommend -lang: supplements are in use.
* Sun Nov 24 2019 ngompa13@gmail.com
- Replace incorrect usage of %%_libexecdir with %%_prefix/lib
* Thu Oct 10 2019 Mathias.Homann@opensuse.org
- rebased the original patch from revision 19
* Fri Oct  4 2019 Mathias.Homann@opensuse.org
- Added a patch to make iptables the default again on openSUSE
* Fri Oct  4 2019 Mathias.Homann@opensuse.org
- Update to version 0.7.2:
  This is a bug fix only release.
  * fix: direct: removeRules() was mistakenly removing all rules
  * fix: guarantee zone source dispatch is sorted by zone name
  * fix: nftables: fix zone dispatch using ipset sources in nat chains
  * doc: add --default-config and --system-config
  * fix: --add-masquerade should only affect ipv4
  * fix: nftables: --forward-ports should only affect IPv4
  * fix: direct: removeRules() not removing all rules in chain
  * dbus: service: fix service includes individual APIs
  * fix: allow custom helpers using standard helper modules
  * fix: service: usage of helpers with '-' in name
  * fix: Revert "ebtables: drop support for broute table"
  * fix: ebtables: don't use tables that aren't available
  * fix: fw: initialize _rfc3964_ipv4
* Mon Sep  9 2019 mrostecki@opensuse.org
- Update to version 0.7.1:
  * Rich Rule Priorities
  * Service Definition Includes - Service definitions can now
    include lines like: <include service="https"/> which will
    include all the ports, etc from the https service.
  * RFC3964 IPv4 filtering - A new option RFC3964_IPv4 in
    firewalld.conf is available. It does filtering based on RFC3964
    in regards to IPv4 addresses. This functionality was
    traditionally in network-scripts.
  * FlushAllOnReload - A new option FlushAllOnReload in
    firewalld.conf is available. Older release retained some
    settings (direct rules, interface to zone assignments) during a
  - -reload. With the introduction of this configuration option
    that is no longer the case. Old behavior can be restored by
    setting FlushAllOnReload=no.
  * 15 new service definitions
  * fix: firewall-offline-cmd: service: use dict based APIs
  * fix: client: service: use dict based dbus APIs
  * test: dbus: coverage for new service APIs
  * fix: dbus: new dict based APIs for services
  * test: dbus: service API coverage
  * test: functions: add macro DBUS_INTROSPECT
  * test: functions: add CHOMP macro for shell output
  * fix: tests/functions: use gdbus instead of dbus-send
  * fix: dbus: add missing APIs for service includes
- Remove patch for using iptables instead of nftables - we should
  finally switch to nftables and fix its issues properly if they
  occur again:
  * 0001-firewall-backend-Switch-default-backend-to-iptables.patch
- Remove patch which was released upstream:
  * 0002-Add-FlushAllOnReload-config-option.patch
* Tue Jun 11 2019 mrostecki@opensuse.org
- Update to version 0.6.4:
  * chore: update translations
  * treewide: fix over indentation (flake8 E117)
  * test: travis: add another test matrix for omitting ip6tables
  * chore: travis: split test matrix by keywords
  * chore: tests: add AT_KEYWORDS for firewall-offline-cmd
  * improvement: tests: Use AT_KEYWORDS for backends
  * fix: tests: guard occurrences of IPv6
  * fix: tests/functions: ignore warnings about missing ip6tables
  * test: add macro IF_IPV6_SUPPORTED
* Wed May  8 2019 dimstar@opensuse.org
- Move RPM macros to %%_rpmmacrodir.
* Thu Mar 28 2019 dimstar@opensuse.org
- Revert last change: the macros DO reference firewall-cmd, but as
  they are expanded during build time of the package, not at
  runtime, the point in time is wrong to require firewalld. The
  consumer of the macro is responsible to ask for the right
  commands to be present at runtime of the scripts
  (boo#1125775#c9).
* Mon Feb 25 2019 mrostecki@opensuse.org
- Add dependency between firewall-macros and firewalld.
  (boo#1125775)
* Wed Feb  6 2019 mrostecki@opensuse.org
- Fix --with-ifcfgdir configure parameter. (boo#1124212)
* Thu Jan 10 2019 mrostecki@suse.de
- Add upstream patch to make --reload/--complete-reload forget the
  runtime configuration and always load the permanent one
  (bsc#1121277)
  * 0002-Add-FlushAllOnReload-config-option.patch
* Mon Oct 15 2018 mchandras@suse.de
- Update to 0.6.3. Some of the changes are:
  * update translations
  * nftables: fix reject statement in "block" zone
  * shell-completion: bash: don't check firewalld state
  * firewalld: fix --runtime-to-permanent if NM not in use.
  * firewall-cmd: sort --list-protocols output
  * firewall-cmd: sort --list-services output
  * command: sort services/protocols in --list-all output
  * services: add audit
  * nftables: fix rich rule log/audit being added to wrong chain
  * nftables: fix destination checks not allowing masks
  * firewall/core/io/*.py: Let SAX handle the encoding of XML files (gh#firewalld/firewalld#395)(bsc#1083361)
  * fw_zone: expose _ipset_match_flags()
  * tests/firewall-cmd: exercise multiple interfaces and zones
  * fw_transaction: On clear zone transaction, must clear fw and other zones
  * Fix translating labels (gh#firewalld/firewalld#392)
- Remove patches which have made it upstream:
  * 0001-Fix-translating-labels-392.patch
  * 0002-firewalld-0.6.x-rich-rule-with-ipset-regression.patch
* Mon Sep 24 2018 mchandras@suse.de
- Add upstream patch to mark more strings as translatable which is
  required by firewall UI when creating rich rules (bsc#1096542)
  * 0001-Fix-translating-labels-392.patch
* Fri Sep 21 2018 luizluca@gmail.com
- Add upstream patch to fix rich rules that uses ipset (bsc#1104990)
  * 00002-firewalld-0.6.x-rich-rule-with-ipset-regression.patch
* Thu Sep 20 2018 mchandras@suse.de
- Update to 0.6.2. Some of the changes are:
  * update translations
  * nftables: fix log-denied with values other than "all" or "off"
  * fw_ipset: raise FirewallError if backend command fails
  * ipset: only use "-exist" on restore
  * fw_ipset: fix duplicate add of ipset entries
  * *tables: For opened ports/protocols/etc match ct state new,untracked (bsc#1105821)
  * ipXtables: increase wait lock to 10s
  * nftables: fix rich rules ports/protocols/source ports not considering ct state
  * ports: allow querying a single added by range
  * fw_zone: do not change rich rule errors into warnings
  * fw_zone: fix services with multiple destination IP versions (bsc#1105899)
  * fw_zone: consider destination for protocols
  * firewall/core/fw_nm: nm_get_zone_of_connection should return None or empty string instead of False (boo#1106319)
  * fw: If direct rules fail to apply add a "Direct" label to error msg
  * fw: if startup fails on reload, reapply non-perm config that survives reload
  * nftables: fix rich rule audit log
  * ebtables: replace RETURN policy with explicit RETURN at end of chain
  * direct backends: allow build_chain() to build multiple rules
  * fw: if failure occurs during startup set state to FAILED
  * fw: on restart set policy from same function
  * ebtables: drop support for broute table
- Remove upstream patches
  * 0001-nftables-fix-rich-rules-ports-protocols-source-ports.patch
  * 0001-fw_zone-consider-destination-for-protocols.patch
  * 0002-fw_zone-fix-services-with-multiple-destination-IP-ve.patch
  * firewalld-fix-firewalld-config-crash.patch
* Mon Sep 17 2018 mchandras@suse.de
- Add upstream patch to fix Neighbor Discovery filtering for IPv6 (bsc#1105821)
  * 0001-nftables-fix-rich-rules-ports-protocols-source-ports.patch
- Add upstream patch to fix building rules for multiple IP families (bsc#1105899)
  * 0001-fw_zone-consider-destination-for-protocols.patch
  * 0002-fw_zone-fix-services-with-multiple-destination-IP-ve.patch
* Sun Sep  2 2018 luc14n0@linuxmail.org
- Add firewalld-fix-firewalld-config-crash.patch: set
  nm_get_zone_of_connection to return 'None' instead of 'False' for
  automatically generated connections to avoid firewall-config
  crashes. Patch provided by upstream (boo#1106319,
  gh#firewalld/firewalld#370).
* Mon Aug 13 2018 mchandras@suse.de
- Also switch firewall backend fallback to 'iptables' (bsc#1102761)
  This ensures that existing configuration files will keep working
  even if FirewallBackend option is missing.
  * 0001-firewall-backend-Switch-default-backend-to-iptables.patch
* Fri Aug 10 2018 mchandras@suse.de
- Update to 0.6.1. Some of the changes are:
  * Correct source/destination in rich rule masquerade
  * Only modify ifcfg files for permanent configuration changes
  * Fix a backtrace when calling common_reverse_rule()
  * man firewalld.conf: Show nftables is the default FirewallBackend
  * firewall-config: fix some untranslated strings that caused a UI
    bug causing rich rules to not be modify-able (bsc#1096542)
  * fw_direct: avoid log for untracked passthrough queries
  * fixed many issues if iptables is actually iptables-nft
  * Use preferred location for AppData files
  * ipXtables: fix ICMP block inversion with set-log-denied
  * fixes ICMP block inversion with set-log-denied with
    IndividualCalls=yes
  * nftables: fix set-log-denied if target is not ACCEPT
  * fw_direct: strip _direct chain suffix if using nftables
  * NetworkManager integration bugfixes.
* Mon Aug  6 2018 mchandras@suse.de
- Switch back to 'iptables' backend as default (bsc#1102761)
* Fri Jul  6 2018 mchandras@suse.de
- Update to 0.6.0. Some of the changes are:
  * update translations
  * firewall-config: Add ipv6-icmp to the protocol dropdown box (#348, bsc#1099698)
  * core: logger: Remove world-readable bit from logfile (#349, bsc#1098986)
  * IPv6 rpfilter: explicitly allow neighbor solicitation
  * nftables backend (default)
  * Added loads of new services
  * firewall-cmd: add --check-config option
  * firewall-offline-cmd: add --check-config option
  * firewallctl: completely remove all code and references
  * dbus: expose FirewallBackend
  * dbus: fix erroneous fallback for AutomaticHelpers
- Remove patches which have made it upstream
  * firewalld-add-additional-services.patch
- spec-cleaner fixes
* Mon May 14 2018 mchandras@suse.de
- Update to 0.5.3 (bsc#1093120)
  * tests/regression: add test for ipset with timeout
  * ipset: allow adding entries to ipsets with timeout
  * translations: update
  * helpers: load helper module explicitly if no port given
  * helpers: nf_conntrack_proto-* helpers needs name cropped
  * config/Makefile: correct name of proto-gre helper
  * tests/regression: test helper nf_conntrack_proto_gre (#263)
  * functions: get_nf_nat_helpers() should look in other directories too
  * functions: Allow nf_conntrack_proto_* helpers
  * services: Add GRE
  * helpers: Add proto-gre
  * tests/regression: add test to verify ICMP block in forward chain
  * ipXtables: fix ICMP block not being present in FORWARD chain
* Wed Apr 18 2018 sbrabec@suse.com
- Translations update (bsc#1081623).
* Fri Mar 16 2018 mchandras@suse.de
- Backport upstream patches to add additional services (bsc#1082033)
  * firewalld-add-additional-services.patch
* Tue Mar 13 2018 mchandras@suse.de
- Update to 0.5.2
  * fix rule deduplication causing accidental removal of rules
  * log failure to parse direct rules xml as an error
  * firewall-config: Break infinite loop when firewalld is not running
  * fix set-log-denied not taking effect
  * po: update translations
* Thu Feb  1 2018 mchandras@suse.de
- Remove high-availability service. SUSE HA uses the cluster service
  provided by the yast2-cluster package (bsc#1078223)
* Tue Jan 30 2018 mchandras@suse.de
- Update to 0.5.1
  * ipXtables: fix iptables-restore wait option detection
  * python3: use "foo in dict" not dict.has_key(foo)
  * Fix potential python3 keys() incompatibility in watcher
  * Fixed python3 compatibility
  * ebtables: fix missing default value to set_rule()
  * fw_zone: fix invalid reference to __icmp_block_inversion
  * zones: Correct and defer check_name for combined zones
* Fri Jan 26 2018 mchandras@suse.de
- Update to 0.5.0
  * firewallctl: mark deprecated (gh#firewalld/firewalld##261)
  * Add nmea-0183 service
  * Add sycthing-gui service
  * Add syncthing service
  * Adding FirewallD jenkins service (gh#firewalld/firewalld#256)
  * services/high-availability: Add port 9929
  * Fix and improve firewalld-sysctls.conf
  * firewalld: also reload dbus config interface for global options
  * Add MongoDB service definition
  * src: firewall: Add support for SUSE ifcfg scripts
  * Add UPnP client service
  * firewalld: Allow specifying log file location
  * firewalld/firewall-offline-cmd: Allow setting system config directories
- Drop obsolete patch
  * 0001-suse-ifcfg-files.patch
- Drop tests installation
* Thu Dec 21 2017 mchandras@suse.de
- Introduce new python3-firewall and firewall-macros subpackages.
  The first one contains the firewalld python3 bindings and the second
  one contains the RPM macros for firewalld.
* Wed Nov 29 2017 dimstar@opensuse.org
- Replace dbus-1-python requires with dbus-1-python3: since
  firewalld was migrated to python3, we also have to require the
  python3 dependencies (boo#1070310).
* Tue Nov 28 2017 mchandras@suse.de
- Add missing python3-gobject-Gdk dependency (boo#1069952)
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Sun Nov 19 2017 mpluskal@suse.com
- Make sure to use python3 everywhere (boo#1068778)
* Thu Nov 16 2017 mchandras@suse.de
- Add combined upstream patch to support SUSE ifcfg network files.
  * 0001-suse-ifcfg-files.patch (gh#firewalld/firewalld#262, fate#323460)
* Wed Nov 15 2017 mchandras@suse.de
- Update to version 0.4.4.6
  * firewall.core.fw_config: Fix check for icmp builtin name
  * config.services: docker-swarm: fix incorrect attribute
  * xmlschema/service.xsd: Fix protocol looking for name instead of value
  * Add docker swarm service (gh#firewalld/firewalld#230)
  * Adding FirewallD redis service (gh#firewalld/firewalld#248)
  * Adding firewalld zabbix server and agent services (gh#firewalld/firewalld#221)
  * firewall-offline-cmd: Don't require root for help output
  * doc: firewall-cmd: Document --query-* options return codes
  * firewall-cmd: Use colors only if output is a TTY
  * core: Log unsupported ICMP types as informational only
  * add bgp service to predefined services edit to config/Makefile.am
  * Add git service
  * Add kprop service
  * minidlna definitions (gh#firewalld/firewalld#236)
  * SpiderOak ONE listens on port 21327 and 21328
  * autogen.sh: Allow skipping configure via NOCONFIGURE env var
  * Add missing ports to RH-Satellite-6 service
  * Reload nf_conntrack sysctls after the module is loaded
  * Add NFSv3 service.
  * config/Makefile.am: Add murmur service (a95eed1)
  * add new service IRC
  * firewall.core.prog: Simplify runProg output: Combine stderr and stdout
  * firewall.core.fw: Fix possible dict size change in for loop
  * firewall.core.fw: Use new firewalld git repo in firewalld organization
  * config/firewall-config.appdata.xml.in: Use new firewalld git repo in firewalld organization
  * firewall.core.fw_zone: Rich-rule ICMP type: Error only for conflicting family
  * firewall.core.rich: Add checks for Rich_Source validation
  * Handle also IPv6 with the zone masquerade flag
  * Add IPv6 support for forward-ports in zones
  * firewall.command: Enable parse_forward_port to work with IPv6 adresses
  * firewall.core.fw_zone: Fix IPv6 address in rich rule forward ports
  * add Murmur (Mumble server) service
- spec file fixes to avoid rpmlint warnings about duplicate files.
* Wed Nov  8 2017 mpluskal@suse.com
- Switch to python3
- Run spec cleaner
- Move autogen to build section
- Add systemd requirements
* Tue Jun  6 2017 mchandras@suse.de
- Update to version 0.4.4.5
  * firewall-offline-cmd: Fix --remove-service-from-zone option (rh#1438127)
  * Support sctp and dccp in ports, source-ports, forward-ports, helpers and rich rules
  * firewall-cmd: Fix --{set,get}-{short,description} for zone
  * firewall.core.ipXtables: Use new wait option for restore commands if available
  * Adding ovirt-vmconsole service file
  * Adding oVirt storage-console service.
  * Adding ctdb service file.
  * Adding service file for nrpe.
  * Rename extension for policy choices (server and desktop) to .policy.choice (rh#1449754)
  * D-Bus interfaces: Fix GetAll for interfaces without properties (rh#1452017)
  * firewall.core.fw_config: Fix wrong variable use in repr output
  * firewall.core.fw_icmptype: Add missing import for copy
  * firewall.core.fw_test: Fix wrong format string in repr
  * firewall.core.io.zone: Fix getattr use on super(Zone)
  * firewall.functions: New function get_nf_nat_helpers
  * firewall.core.fw: Get NAT helpers and store them internally.
  * firewall.core.fw_zone: Load NAT helpers with conntrack helpers
  * firewalld.dbus: Add missing properties nf_conntrach_helper_setting and nf_conntrack_helpers
  * firewall.server.firewalld: New property for NAT helpers supported by the kernel
* Mon Mar 27 2017 mchandras@suse.de
- Update to version 0.4.4.4
  * Drop references to fedorahosted.org from spec file and Makefile.am
  * firewall-config: Show invalid ipset type in the ipset dialog in the bad label
  * firewall.core.fw: Show icmptypes and ipsets with type errors in permanent env
  * firewall.server.firewalld: Provide information about the supported icmp types
  * firewall.core.fw_icmptype: Add ICMP type only if the type is supported
  * firewall.core.fw: New attributes ip{4,6}tables_supported_icmp_types
  * firewall.core.ipXtables: New method supported_icmp_types
  * firewall-config: Deactivate edit buttons if there are no items
  * firewall.core.io.zone: Fix permanent rich rules using icmp-type (rh#1434594)
  * firewall.core.fw_ipset: get_ipset may not ckeck if set is applied by default
  * firewall.core.fw_transaction: Use LastUpdatedOrderedDict for zone transactions
- Remove upstream patch:
  * 0001-firewall.core.fw_ipset-get_ipset-may-not-ckeck-if-se.patch
* Mon Feb 13 2017 mchandras@suse.de
- Update to version 0.4.4.3
  * New service freeipa-trust (rh#1411650)
  * Complete icmp types for IPv4 and IPv6
  * New h323 helper container
  * Support helper container: h323
  * firewall.server.decorators: ALREADY_ errors should be logged as warnings
  * firewall.command: ALREADY_SET should also result in zero exit code
  * tests/firewall-offline-cmd_test.sh: Only use firewall-offline-cmd
  * Support more ipset types: hash:ip,port, hash:ip,port,ip, hash:ip,port,net, hash:ip,mark, hash:net,net, hash:net,port, hash:net,port,net, hash:net,iface
  * New checks for ipset entry validation
  * Use ipset dimension for match
  * firewall.core.base: New ZONE_SOURCE_IPSET_TYPES list
  * New firewall.core.icmp providing names and types for icmp and icmpv6 values
  * firewall.core.fw_ipset: New methods to get ipset dimension and applied state
  * firewall.errors: New error NOT_APPLIED
  * firewall-cmd man page: Add missing --get-ipset-types
  * firewall.core.fw_nm: No trace back on failed get_connection call (rh#1413345)
  * firewall.core.prog: Fix addition of the error output in runProg
  * Speed up ipset handling, (re)loading and import from file
  * Support --family option for --new-ipset
  * Handle FirewallError for query sequences in command line tools
  * Fail to alter entries of ipsets with timeout
  * Extended tests for ipset options
  * Return empty list for ipsets using timeouts
  * firewall.functions: Fix checks in checkIPnMask and checkIP6nMask (gh#t-woerner/firewalld#186)
  * firewalld.conf man page: New section about AutomaticHelpers
  * firewall-offline-cmd man page: Added -v and -q options, fixed section ids
  * firewall{-cmd, ctl}: Fix scope of final return in try_set_zone_of_interface
  * firewall.core.fw_zone: Limit masquerading forward rule to new connections
  * firewall-config: Update active zones on reloaded signal
  * firewall-applet: Update active zones and tooltip on reloaded signal
  * firewall.core.fw_zone: Fix missing chain for helper in rich rules using service (rh#1416578)
  * Support icmp-type usage in rich rules (rh#1409544)
  * firewall[-offline]-cmd: Fix --{set,get}-{short,description} for ipset and helper (rh#1416325)
  * firewall.core.ipset: Solve ipset creation issues with -exist and more flag tests
  * Speed up start and restart for ipsets with lots of entries (rh#1416817)
  * Speed up of ipset alteration by adding and removing entries using a file (rh#1416817)
  * Code cleanup and minor bug fixes
  * firewall.core.prog: Fix addition of the error output in runProg
  * New services mssql, kibana, elasticsearch, quassel, bitcoin-rpc, bitcoin-testnet-rpc, bitcoin-testnet, bitcoin and spideroak-lansync
  * Translation updates
- Add upstream patch to fix ipset overloading from /etc/firewalld/ipsets (gh#t-woerner/firewalld#206)
  * 0001-firewall.core.fw_ipset-get_ipset-may-not-ckeck-if-se.patch
* Mon Dec  5 2016 mchandras@suse.de
- Update to version 0.4.4.2
  * firewalld.spec: Added helpers and ipsets paths to firewalld-filesystem
  * firewall.core.fw_nm: create NMClient lazily
  * Do not use hard-coded path for modinfo, use autofoo to detect it
  * firewall.core.io.ifcfg: Dropped invalid option warning with bad format string
  * firewall.core.io.ifcfg: Properly handle quoted ifcfg values
  * firewall.core.fw_zone: Do not reset ZONE with ifdown
  * Updated translations from zanata
  * firewall-config: Extra grid at bottom to visualize firewalld settings
* Mon Nov 14 2016 mchandras@suse.de
- Update to version 0.4.4.1
  * Translation updates form zanata
  * firewallctl: New support for helpers
  * firewallctl: Use sys.excepthook to force exception_handler usage always
  * firewall-config: Use proper source check in sourceDialog
* Mon Oct 31 2016 mchandras@suse.de
- Update to version 0.4.4
  * firewall-applet: Use PyQt5
  * firewall-config: New nf_conntrack_select dialog, use nf_conntrack_helpers
    D-Bus property
  * New helpers Q.931 and RAS from nf_conntrack_h323
  * firewall.core.fw_zone: Add zone bingings for PREROUTING in the raw table
  * firewall.core.ipXtables: Add PREROUTING default rules for zones in raw
    table
  * New helper configuration files for amanda, ftp, irc, netbios-ns, pptp,
    sane, sip, snmp and tftp
  * firewall-cmd: Fixed --{get,set}-{description,short} for permanent zones
  * firewall.command: Do not use error code 254 for {ALREADY,NOT}_ENABLED
    sequences
  * Misc bug fixes.
  * For the complete list of changes please see:
    https://github.com/t-woerner/firewalld/releases/tag/v0.4.4
* Fri Sep  2 2016 mchandras@suse.de
- Relax permissions for default installation files. The files in
  /usr/lib/firewalld are the default ones as shipped by the package and
  there is nothing secret in them.
* Tue Aug 16 2016 mchandras@suse.de
- Update to version 0.4.3.3
  * Fixes CVE-2016-5410 (bsc#992772)
  * Standard error is now used for errors and warnings
  * Several fixes for use in change roots
  * Systemd service file changes
  * Fixed translations in firewall-config
  * Command line clients
  * Fixes infinite event handling loop in firewall-{config,applet} (bsc#992082)
* Tue Jul  5 2016 mchandras@suse.de
- Update to version 0.4.3.2
  * Fix regression with unavailable optional commands
  * All missing backend messages should be warnings
  * Individual calls for missing restore commands
  * Only one authenticate call for add and remove options and also
    sequences
  * New service RH-Satellite-6
* Tue Jun 28 2016 mchandras@suse.de
- Update to version 0.4.3.1
  * firewall.command: Fix python3 DBusException message not interable error
  * src/Makefile.am: Fix path in firewall-[offline-]cmd_test.sh while installing
  * firewallctl: Do not trace back on list command without further arguments
  * firewallctl (man1): Added remaining sections zone, service, ..
  * firewallctl: Added runtime-to-permanent, interface and source parser, IndividualCalls setting
  * firewall.server.config: Allow to set IndividualCalls property in config interface
  * Fix missing icmp rules for some zones
  * runProg: Fix issue with running programs
  * firewall-offline-cmd: Fix issues with missing system-config-firewall
  * firewall.core.ipXtables: Split up source and dest addresses for transaction
  * firewall.server.config: Log error in case of loading malformed files in watcher
  * Install and package the firewallctl man page
  * Translation updates
* Wed Jun 22 2016 mchandras@suse.de
- Update to version 0.4.3
  * New firewallctl utility (rh#1147959)
  * doc.xml.seealso: Show firewalld.dbus in See Also sections
  * firewall.core.fw_config: Create backup on zone, service, ipset and icmptype removal (rh#1339251)
  * {zone,service,ipset,icmptype}_writer: Do not fail on failed backup
  * firewall-[offline-]cmd: Fix --new-X-from-file options for files in cwd
  * firewall-cmd: Dropped duplicate setType call in --new-ipset
  * radius service: Support also tcp ports (RBZ#1219717)
  * xmlschemas: Support source-port, protocol, icmp-block-inversion and ipset sources
  * config.xmlschema.service.xsd: Fix service destination conflicts (rh#1296573)
  * firewall-cmd, firewalld man: Information about new NetworkManager and ifcfg
  * firewall.command: Only print summary and description in print_X_info with verbose
  * firewall.command: print_msg should be able to print empty lines
  * firewall-config: No processing of runtime passthroughs signals in permanent
  * Landspace.io fixes and pylint calm downs
  * firewall.core.io.zone: Add zone_reader and zone_writer to all, pylint fixes
  * firewall-config: Fixed titles of command and context dialogs, also entry lenths
  * firewall-config: pylint calm downs
  * firewall.core.fw_zone: Fix use of MAC source in rich rules without ipv limit
  * firewall-config: Use self.active_zoens in conf_zone_added_cb
  * firewall.command: New parse_port, extended parse methods with more checks
  * firewall.command: Fixed parse_port to use the separator in the split call
  * firewall.command: New [de]activate_exception_handler, raise error in parse_X
  * services ha: Allow corosync-qnetd port
  * firewall-applet: Support for kde5-nm-connection-editor
  * tests/firewall-offline-cmd_test.sh: New tests for service and icmptype modifications
  * firewall-offline-cmd: Use FirewallCommand for simplification and sequence options
  * tests/firewall-cmd_test.sh: New tests for service and icmptype modifications
  * firewall-cmd: Fixed set, remove and query destination options for services
  * firewall.core.io.service: Source ports have not been checked in _check_config
  * firewall.core.fw_zone: Method check_source_port is not used, removed
  * firewall.core.base: Added default to ZONE_TARGETS
  * firewall.client: Allow to remove ipv:address pair for service destinations
  * tests/firewall-offline-cmd_test.sh: There is no timeout option in permanent
  * firewall-cmd: Landscape.io fixes, pylint calm downs
  * firewall-cmd: Use FirewallCommand for simplification and sequence options
  * firewall.command: New FirewallCommand for command line client simplification
  * New services: kshell, rsh, ganglia-master, ganglia-client
  * firewalld: Cleanup of unused imports, do not translate some deamon messages
  * firewalld: With fd close interation in runProg, it is not needed here anymore
  * firewall.core.prog: Add fd close iteration to runProg
  * firewall.core.fw_nm: Hide NM typelib import, new nm_get_dbus_interface function
  * firewalld.spec: Require NetworkManager-libnm instead of NetworkManager-glib
  * firewall-config: New add/remove ipset entries from file, remove all entries
  * firewall-applet: Fix tooltip after applet start with connection to firewalld
  * firewall-config: Select new zone, service or icmptype if the view was empty
  * firewalld.spec: Added build requires for iptables, ebtables and ipset
  * Adding nf_conntrack_sip module to the service SIP
  * firewall: core: fw_ifcfg: Quickly return if ifcfg directory does not exist
  * Drop unneeded python shebangs
  * Translation updates
- Remove obsolete patches:
  * 0001-src-firewall-core-Drop-unneeded-python-shebangs.patch
  * 0002-firewall-core-fw_ifcfg-Quickly-return-if-ifcfg-direc.patch
  * 0003-firewall.core.fw_nm-Hide-NM-typelib-import-new-nm_ge.patch
- Add missing %%{?_smp_mflags} during install. This will speed up
  the installation phase as well as expose build system's problems
  due to higher level of parallelism.
- Run make during %%build to ensure missing documentation is generated.
- spec file cleanups.
* Wed Jun  8 2016 mchandras@suse.de
- Add upstream patch to prevent unconditional dependencies to the
  NetworkManager typelib (gh#t-woerner/firewalld#119)
  * 0003-firewall.core.fw_nm-Hide-NM-typelib-import-new-nm_ge.patch
* Tue May 31 2016 mchandras@suse.de
- Update to version 0.4.2
  * New module to search for and change ifcfg files for interfaces
    not under control of NM
  * firewall_config: Enhanced messages in status bar
  * firewall-config: New message window as overlay if not connected
  * firewall-config: Fix sentivity of option, view menus and main
    paned if not connected
  * firewall-applet: Quit on SIGINT (Ctrl-C), reduced D-Bus calls,
    some cleanup
  * firewall-[offline]cmd: Show target in zone information
  * D-Bus: Completed masquerade methods in FirewallClientZoneSettings
  * Fixed log-denied rules for icmp-blocks
  * Keep sorting of interfaces, services, icmp-blocks and other
    settings in zones
  * Fixed runtime-to-permanent not to save interfaces under control
    of NM
  * New icmp-block-inversion flag in the zones
  * ICMP type filtering in the zones
  * New services: sip, sips, managesieve
  * rich rules: Allow destination action (rh#1163428)
  * firewall-offline-cmd: New option -q/--quiet
  * firewall-[offline-]cmd: New --add-[zone,service,ipset,icmptype]-from-file
  * firewall-[offline-]cmd: Fix option for setting the destination
    address
  * firewall-config: Fixed resizing behaviour
  * New transaction model for speed ups in start, restart, stop and
    other actions
  * firewall-cmd: New options --load{zone,service,ipset,icmptype}-defaults
  * Fixed memory leak in dbus_introspection_add_properties
  * Landscape.io fixes, pylint calm downs
  * New D-Bus getXnames methods to speed up firewall-config and firewall-cmd
  * ebtables-restore: No support for COMMIT command
  * Source port support in services, zones and rich rules
  * firewall-offline-cmd: Added --{add,remove}-entries-from-file for ipsets
  * firewall-config: New active bindings side bar for simple binding changes
  * Reworked NetworkManager module
  * Proper default zone handling for NM connections
  * Try to set zone binding with NM if interface is under control of NM
  * Code cleanup and bug fixes
  * Include test suite in the release and install in /usr/share/firewalld/tests
  * New Travis-CI configuration file
  * Fixed more broken frensh translations
  * Translation updates
- Add upstream patches
  * 0001-src-firewall-core-Drop-unneeded-python-shebangs.patch: Removes
    unneeded python shebangs
  * 0002-firewall-core-fw_ifcfg-Quickly-return-if-ifcfg-direc.patch: Do
    not try to access the network-scripts ifcfg directory.
- Drop rejected patch
  * drop-standard-output-error-systemd.patch
- Minor spec file clean-up
* Fri May  6 2016 jengelh@inai.de
- Avoid runtime dependency on systemd, the macros can all deal with
  its absence.
* Fri Apr 29 2016 mchandras@suse.de
- Suggest the susefirewall2-to-firewalld package which could assist
  in migrating the SuSEFirewall2 iptables rules to FirewallD.
* Thu Apr 21 2016 mchandras@suse.de
- Update to version 0.4.1.2
  * Install fw_nm module
  * firewalld: Do not fail if log file could not be opened
  * Make ipsets visible per default in firewall-config
  * Fixed translations with python3
  [changes in 0.4.1.1]
  * Fix for broken frensh translation
  [changes in 0.4.1]
  * Enhancements of ipset handling
  * No cleanup of ipsets using timeouts while reloading
  * Only destroy conflicting ipsets
  * Only use ipset types supported by the system
  * Add and remove several ipset entries in one call using a file
  * Reduce time frame where builtin chains are on policy DROP while reloading
  * Include descriptions in --info-X calls
  * Command line interface support to get and alter descriptions of zones,
  * services, ipsets and icmptypes with permanent option
  * Properly watch changes in combined zones
  * Fix logging in rich rule forward rules
  * Transformed direct.passthrough errors into warnings
  * Rework of import structures
  * Reduced calls to get ids for port and protocol names (rh#1305434)
  * Build and installation fixes by Markos Chandras
  * Provide D-Bus properties in introspection data
  * Fix for flaws found by landscape.io
  * Fix for repeated SUGHUP
  * New NetworkManager module to get and set zones of connections, used in
    firewall-applet and firewall-config
  * configure: Autodetect backend tools ({ip,ip6,eb}tables{,-restore}, ipset)
  * Code cleanups
  * Bug fixes
- Fix drop-standard-output-error-systemd.patch tagging
- Add libxslt-tools build dependency
* Tue Mar  8 2016 mchandras@suse.de
- Do not recommend a specific version for the lang subpackage
* Tue Mar  1 2016 mchandras@suse.de
- Move translations to a new subpackage
* Mon Feb 29 2016 mchandras@suse.de
- Set DISABLE_RESTART_ON_UPDATE to 'yes' instead of '1'. The macros in
  /etc/rpm/macros.systemd only check for the 'yes' value so fix it to
  properly prevent the firewalld service from being restarted during
  updates.
* Mon Feb 22 2016 mchandras@suse.de
- Drop typelib(NetworkManager), NetworkManager-glib, gtk3
  and libnotify dependencies (see OBS SR#360792)
* Mon Feb 22 2016 jslaby@suse.com
- firewall-config needs typelib(NetworkManager) to run
* Mon Feb  1 2016 mchandras@suse.de
- Initial commit. Version 0.4.0
  * drop-standard-output-error-systemd.patch (gh#t-woerner/firewalld/pull/67)
