#
# spec file for package permissions
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           permissions
Version:        20240826
Release:        150600.10.18.2
Summary:        SUSE Linux Default Permissions
# Maintained in github by the security team.
License:        GPL-2.0+
Group:          Productivity/Security
Url:            http://github.com/openSUSE/permissions
Source:         permissions-%{version}.tar.xz
BuildRequires:  libcap-devel
BuildRequires:  python3
#!BuildIgnore:  group(trusted)
Requires(post): %fillup_prereq
Requires(pre):  group(trusted)
Provides:       aaa_base:%{_sysconfdir}/permissions

%description
Permission settings of files and directories depending on the local
security settings. The local security setting (easy, secure, or paranoid)
can be configured in /etc/sysconfig/security.

%prep
%setup -q

%build
make %{?_smp_mflags} CFLAGS="-W -Wall %{optflags}" FSCAPS_DEFAULT_ENABLED=0

%install
%make_install fillupdir=%{_fillupdir}

%check
# we can't test with sanitizers in SLE15, compiler is too old for some of them
tests/regtest.py --skip-make

%post
%{fillup_only -n security}
# apply all potentially changed permissions
%{_bindir}/chkstat --system

%files
%config %{_sysconfdir}/permissions
%config %{_sysconfdir}/permissions.easy
%config %{_sysconfdir}/permissions.secure
%config %{_sysconfdir}/permissions.paranoid
%config(noreplace) %{_sysconfdir}/permissions.local
%{_bindir}/chkstat
%{_mandir}/man5/permissions.5%{ext_man}
%{_mandir}/man8/chkstat.8%{ext_man}
%{_fillupdir}/sysconfig.security

%package -n permissions-zypp-plugin
BuildArch:      noarch
Requires:       permissions = %version
Requires:       python3-zypp-plugin
Requires:       libzypp(plugin:commit) = 1
Summary:        A zypper commit plugin for calling chkstat
Group:          Productivity/Security

%description -n permissions-zypp-plugin
This package contains a plugin for zypper that calls `chkstat --system` after
new packages have been installed. This is helpful for maintaining custom
entries in /etc/permissions.local.

%files -n permissions-zypp-plugin
%dir /usr/lib/zypp
%dir /usr/lib/zypp/plugins
%dir /usr/lib/zypp/plugins/commit
/usr/lib/zypp/plugins/commit/permissions.py

%changelog
* Mon Feb 10 2025 matthias.gerstner@suse.com
- Update to version 20240826:
  * permissions: reintroduce nscd socket, which acts as a whitelisting for glibc (bsc#1236960)
* Thu Jan 16 2025 matthias.gerstner@suse.com
- Update to version 20240826:
  * permissions: remove legacy and nonsensical entries
  * permissions: remove traceroute entry
  * permissions: remove outdated sudo directories
  * permissions: remove legacy RPM directory entries
  * permissions: remove some static /var/spool/* dirs
  * permissions: remove unnecessary static dirs and devices (bsc#1235873)
* Thu Jan 16 2025 matthias.gerstner@suse.com
- _service: switch to "manual"
* Thu Jan  2 2025 matthias.gerstner@suse.com
- Update to version 20240826:
  * chkstat: backport support to operate in insecure mode via envvar opt-in (bsc#1219736)
* Tue Aug 27 2024 matthias.gerstner@suse.com
- Update to version 20240826:
  * permissions: remove outdated entries (bsc#1228968)
* Mon Aug 26 2024 wolfgang.frisch@suse.com
- Update to version 20240826:
  * cockpit: revert path change (bsc#1229329)
* Thu Aug  1 2024 wolfgang.frisch@suse.com
- New branch for SLE-15-SP6
- Update to version 20240801:
  * cockpit: moved setuid executable (bsc#1228548)
* Wed Oct 19 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * permissions for enlightenment helper on 32bit arches (bsc#1194047)
* Tue Oct 11 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * fix regression introduced by backport of security fix (bsc#1203911)
* Tue Sep 13 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * chkstat: also consider group controlled paths (bsc#1203018, CVE-2022-31252)
* Fri Jul 15 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * postfix: add postlog setgid for maildrop binary (bsc#1201385)
* Mon Jul 11 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * apptainer: fix starter-suid location (bsc#1198720)
* Wed Jul  6 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * static permissions: remove deprecated bind / named chroot entries (bsc#1200747)
* Tue Apr 26 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * backport of apptainer whitelisting (bsc#1196145, bsc#1198720)
* Fri Apr  1 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * squid: adjust pinger path, drop basic_pam_auth (bsc#1197649)
* Fri Mar 11 2022 matthias.gerstner@suse.com
- Update to version 20201225:
  * whitelist ksysguard network helper (bsc#1151190)
* Fri Jan 14 2022 jsegitz@suse.com
- Update to version 20181225:
  * setuid bit for cockpit session binary (bsc#1169614)
* Wed Dec 22 2021 matthias.gerstner@suse.com
- Update to version 20181225:
  * drop ping capabilities in favor of ICMP_PROTO sockets (bsc#1174504)
* Fri Apr 30 2021 matthias.gerstner@suse.com
- Update to version 20181225:
  * etc/permissions: remove unnecessary entries (bsc#1182899)
* Thu Jan 21 2021 matthias.gerstner@suse.com
- Update to version 20181224:
  * pcp: remove no longer needed / conflicting entries
    (bsc#1171883, CVE-2020-8025)
* Tue Jun  2 2020 matthias.gerstner@suse.com
- Update to version 20181224:
  * profiles: add entries for enlightenment (bsc#1171686)
* Thu May 28 2020 malte.kraus@suse.com
- whitelist texlive public binary (bsc#1171686)
* Mon May 11 2020 jsegitz@suse.com
- Remove setuid bit for newgidmap and newuidmap in paranoid profile
  (bsc#1171173)
* Thu Apr  2 2020 jsegitz@suse.com
- correct spelling of icinga group (icingagmd -> icingacmd, bsc#1168364)
* Tue Mar 24 2020 jsegitz@suse.com
- whitelist s390-tools setgid bit on log directory (bsc#1167163)
* Mon Mar  2 2020 malte.kraus@suse.com
- run testsuite during package build
- Update to version 20181224:
  * testsuite: adapt expected behavior to legacy branches
  * adjust testsuite to post CVE-2020-8013 link handling
  * testsuite: add option to not mount /proc
  * do not follow symlinks that are the final path element: CVE-2020-8013, bsc#1163922
  * add a test for symlinked directories
  * fix relative symlink handling
  * regtest: fix the static PATH list which was missing /usr/bin
  * regtest: also unshare the PID namespace to support /proc mounting
  * Makefile: force remove upon clean target to prevent bogus errors
  * regtest: by default automatically (re)build chkstat before testing
  * regtest: add test for symlink targets
  * regtest: make capability setting tests optional
  * regtest: fix capability assertion helper logic
  * regtests: add another test case that catches set*id or caps in world-writable sub-trees
  * regtest: add another test that catches when privilege bits are set for special files
  * regtest: add test case for user owned symlinks
  * regtest: employ subuid and subgid feature in user namespace
  * regtest: add another test case that covers unknown user/group config
  * regtest: add another test that checks rejection of insecure mixed-owner paths
  * regtest: add test that checks for rejection of world-writable paths
  * regtest: add test for detection of unexpected parent directory ownership
  * regtest: add further helper functions, allow access to main instance
  * regtest: introduce some basic coloring support to improve readability
  * regtest: sort imports, another piece of rationale
  * regtest: add capability test case
  * regtest: improve error flagging of test cases and introduce warnings
  * regtest: support caps
  * regtest: add a couple of command line parameter test cases
  * regtest: add another test that checks whether the default profile works
  * regtests: add tests for correct application of local profiles
  * regtest: add further test cases that test correct profile application
  * regtest: simplify test implementation and readability
  * regtest: add helpers for permissions.d per package profiles
  * regtest: support read-only bind mounts, also bind-mount permissions repo
  * tests: introduce a regression test suite for chkstat
* Fri Feb 28 2020 malte.kraus@suse.com
- Update to version 20181224:
  * whitelist WMP (bsc#1161335)
  * Makefile: allow to build test version programmatically
  * chkstat: handle symlinks in final path elements correctly
  * add .gitignore for chkstat binary
  * faxq-helper: correct "secure" permission for trusted group (bsc#1157498)
  * fix syntax of paranoid profile
* Thu Feb  6 2020 matthias.gerstner@suse.com
- Update to version 20181224:
  * mariadb: settings for new auth_pam_tool (bsc#1160285)
  * chkstat: capability handling fixes (bsc#1161779)
  * chkstat: fix regression where chkstat breaks without /proc available (bsc#1160764, bsc#1160594)
  * dumpcap: remove 'other' executable bit because of capabilities (boo#1148788, CVE-2019-3687)
* Wed Feb  5 2020 matthias.gerstner@suse.com
  Sync upstream SLE-15-SP1 branch with our SLE-15-SP1:Update package. Therefore
  remove all of the following patches which are now included in the tarball:
- 0001-whitelisting-update-virtualbox.patch
- 0002-consistency-between-profiles.patch 0003-var-run-postgresql.patch
- 0004-var-cache-man.patch
- 0005-singularity-starter-suid.patch
- 0006-bsc1110797_amanda.patch
- 0007-chkstat-fix-privesc-CVE-2019-3690.patch
- 0008-squid-pinger-owner-fix-CVE-2019-3688.patch
- 0009-chkstat-handle-missing-proc.patch
- 0010-chkstat-capabilities-implicit-changes.patch
  Because of inconsistencies between the upstream branch and the package state
  the following previously missing changes are introduced by this update:
- Update to version 20181117:
  * removed old entry for rmtab
  * Fixed typo in icinga2 whitelist entry
* Fri Jan 31 2020 malte.kraus@suse.com
- fix regression where chkstat breaks without /proc available
  (bsc#1160764, bsc#1160594, 0009-chkstat-handle-missing-proc.patch)
- fix capability handling when doing multiple permission changes
  at once (bsc#1161779,
  0010-chkstat-capabilities-implicit-changes.patch)
* Tue Nov 19 2019 malte.kraus@suse.com
- fix invalid free() when permfiles points to argv (bsc#1157198,
  changed 0007-chkstat-fix-privesc-CVE-2019-3690.patch)
* Mon Oct 28 2019 malte.kraus@suse.com
- fix /usr/sbin/pinger ownership to root:squid (bsc#1093414,
  CVE-2019-3688, 0008-squid-pinger-owner-fix-CVE-2019-3688.patch)
* Mon Oct 28 2019 malte.kraus@suse.com
- fix privilege escalation through untrusted symlinks (bsc#1150734,
  CVE-2019-3690, 0007-chkstat-fix-privesc-CVE-2019-3690.patch)
* Thu Sep 26 2019 jsegitz@suse.com
- Updated permissons for amanda, added 0006-bsc1110797_amanda.patch
  (bsc#1110797)
* Thu Jun 13 2019 malte.kraus@suse.com
- Added ./0005-singularity-starter-suid.patch (bsc#1128598)
  New whitelisting for /usr/lib/singularity/bin/starter-suid
* Tue Apr 30 2019 jsegitz@suse.com
- Added 0004-var-cache-man.patch. Removed entry for /var/cache/man.
  Conflicts with packaging and man:man is the better setting anyway
  (bsc#1133678)
* Tue Feb 12 2019 jsegitz@suse.com
- Added 0001-whitelisting-update-virtualbox.patch (bsc#1120650)
  New whitelisting for /usr/lib/virtualbox/VirtualBoxVM and removed
  stale entries for VirtualBox
- Added 0002-consistency-between-profiles.patch
  Ensure consistency of entries, otherwise switching between settings
  becomes problematic
- Added 0003-var-run-postgresql.patch (bsc#1123886)
  Whitelist for postgresql. Currently the checker doesn't complain
  because the directories aren't packaged, but that might change
  and/or our checkers might improve
* Wed Nov 28 2018 opensuse-packaging@opensuse.org
- Update to version 20181116:
  * zypper-plugin: new plugin to fix bsc#1114383
  * singularity: remove dropped -suid binaries (bsc#1028304)
  * capability whitelisting: allow cap_net_bind_service for ns-slapd from 389-ds
  * setuid whitelisting: add fusermount3 (bsc#1111230)
  * setuid whitelisting: add authbind binary (bsc#1111251)
  * setuid whitelisting: add firejail binary (bsc#1059013)
  * setuid whitelisting: add lxc-user-nic (bsc#988348)
  * whitelisting: add smc-tools LD_PRELOAD library (bsc#1102956)
  * whitelisting: add spice-gtk usb helper setuid binary (bnc#1101420)
  * Fix wrong file path in help string
  * Capabilities for usage of Wireshark for non-root
- remove 0001-whitelisting-add-spice-gtk-usb-helper-setuid-binary-.patch:
  is now contained in tarball.
* Mon Aug 20 2018 matthias.gerstner@suse.com
- 0001-whitelisting-add-spice-gtk-usb-helper-setuid-binary-.patch: add
  whitelisting for the spice-gtk setuid binary (bsc#1101420) for improved
  usability.
* Thu Jan 25 2018 meissner@suse.com
- Update to version 20180125:
  * the eror should be reported for permfiles[i], not argv[i], as these are not the same files. (bsc#1047247)
  * make btmp root:utmp (bsc#1050467)
* Mon Jan 15 2018 krahmer@suse.com
- Update to version 20180115:
  * - polkit-default-privs: usbauth (bsc#1066877)
* Mon Dec  4 2017 kukuk@suse.com
- fillup is required for post, not pre installation
* Thu Nov 30 2017 mpluskal@suse.com
- Cleanup spec file with spec-cleaner
- Drop conditions/definitions related to old distros
* Wed Nov 29 2017 astieger@suse.com
- Update to version 20171129:
  * permissions: adding gvfs (bsc#1065864)
  * Allow setgid incingacmd on directory /run/icinga2/cmd bsc#1069410
  * Allow fping cap_net_raw (bsc#1047921)
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Tue Nov 21 2017 krahmer@suse.com
- Update to version 20171121:
  * - permissions: adding kwayland (bsc#1062182)
* Mon Nov  6 2017 eeich@suse.com
- Update to version 20171106:
  * Allow setuid root for singularity (group only) bsc#1028304
* Wed Oct 25 2017 jsegitz@suse.com
- Update to version 20171025:
  * Stricter permissions on cron directories (paranoid) and stricter permissions on sshd_config (secure/paranoid)
* Thu Sep 28 2017 astieger@suse.com
- Update to version 20170928:
  * Fix invalid syntax bsc#1048645 bsc#1060738
* Wed Sep 27 2017 pgajdos@suse.com
- Update to version 20170927:
  * fix typos in manpages
* Fri Sep 22 2017 astieger@suse.com
- Update to version 20170922:
  * Allow setuid root for singularity (group only) bsc#1028304
* Wed Sep 13 2017 astieger@suse.com
- Update to version 20170913:
  * Allow setuid for shadow newuidmap, newgidmap bsc#979282, bsc#1048645)
* Wed Sep  6 2017 opensuse-packaging@opensuse.org
- Update to version 20170906:
  * permissions - copy dbus-daemon-launch-helper from / to /usr - bsc#1056764
  * permissions: Adding suid bit for VBoxNetNAT (bsc#1033425)
* Wed Jun  7 2017 dimstar@opensuse.org
- BuildIgnore group(trusted): we don't really care for this group
  in the buildroot and do not want to get system-users into the
  bootstrap cycle as we can avoid it.
* Sat Jun  3 2017 meissner@suse.com
- Require: group(trusted), as we are handing it out to some unsuspecting
  binaries and it is no longer default. (bsc#1041159 for fuse, also cronie, etc)
* Fri Jun  2 2017 meissner@suse.com
- Update to version 20170602:
  * make /etc/ppp owned by root:root. The group dialout usage is no longer used
* Sun Aug  7 2016 meissner@suse.com
- Update to version 20160807:
  * suexec2 is a symlink, no need for permissions handling
* Tue Aug  2 2016 meissner@suse.com
- Update to version 20160802:
  * list the newuidmap and newgidmap, currently 0755 until review is done (bsc#979282)
  * root:shadow 0755 for newuidmap/newgidmap
* Tue Aug  2 2016 krahmer@suse.com
- adding qemu-bridge-helper mode 04750 (bsc#988279)
* Mon May 23 2016 dimstar@opensuse.org
- Introduce _service to easier update the package. For simplicity,
  change the version from yyyy.mm.dd to yyyymmdd (which is eactly
  %%cd in the _service defintion). Upgrading is no problem.
* Mon May 23 2016 meissner@suse.com
- chage only needs read rights to /etc/shadow, so setgid shadow is sufficient (bsc#975352)
* Wed Mar 30 2016 meissner@suse.com
- permissions: adding gstreamer ptp file caps (bsc#960173)
* Fri Jan 15 2016 meissner@suse.com
- the apache folks renamed suexec2 to suexec with symlink. adjust both (bsc#962060)
* Tue Jan 12 2016 meissner@suse.com
- pinger needs to be squid:root, not root:squid (there is no squid group) bsc#961363
* Thu Oct 29 2015 meissner@suse.com
- add suexec with 0755 to all standard profiles. this can and should be overridden in permissions.local if you need it setuid root. bsc#951765 bsc#263789
- added missing / to the squid specific directories (bsc#950557)
* Mon Sep 28 2015 meissner@suse.com
- adjusted radosgw to root:www mode 0750 (bsc#943471)
* Mon Sep 28 2015 meissner@suse.com
- radosgw can get capability cap_bind_net_service (bsc#943471)
* Mon Jun  8 2015 meissner@suse.com
- remove /usr/bin/get_printing_ticket; (bnc#906336)
* Wed Dec  3 2014 krahmer@suse.com
- Added iouyap capabilities (bnc#904060)
* Wed Nov  5 2014 meissner@suse.com
- %%{_bindir}/get_printing_ticket turned to mode 700, setuid root no longer needed (bnc#685093)
- permissions: incorporating squid changes from bnc#891268
- hint that chkstat --system --set needs to be run after editing bnc#895647
* Tue Aug 26 2014 meissner@suse.com
- Do not applies permissions from backup files (~ / .rpmsave / .rpmnew) (bnc#893370)
- do not mention SuSEconfig anymore, long dead (bnc#843083)
* Fri Aug  1 2014 meissner@suse.com
- append a / to /var/log/journal so the framework makes sure it is a directory bnc#888151
* Wed Jul 23 2014 meissner@suse.com
- make innbind mode 4550  (bnc#876287)
- permissions: Adding systemd-journal directory (bnc#888151)
* Mon Jul 21 2014 krahmer@suse.com
- permissions: Adding new kdesud path for KDE5 (bnc#872276)
* Tue Jul  1 2014 meissner@suse.com
- vlock_main lost its permission checking, so remove from here.
* Mon Jun 16 2014 meissner@suse.com
- opiesu,wodim,vlock-main have no setuid root. (bnc#882035)
* Thu Jun  5 2014 meissner@suse.com
- tighten /etc/crontab to be always mode 600, even in easy (bnc#867799)
* Tue Apr 15 2014 meissner@suse.com
- duplicate /var/run entries to /run (bnc#873708)
* Mon Mar 24 2014 krahmer@suse.com
- permissions: incorporating capability for mtr, removing +s from ping
  (bnc#865351)
* Mon Oct 28 2013 meissner@suse.com
- GIT repo moved to GITHUB.
- removed the setuid bit from "eject" (bnc#824406)
* Thu Aug 22 2013 meissner@suse.com
- do not use magic constants for strlen (bnc#834790
* Wed Aug 21 2013 meissner@suse.com
- Chrome sandbox also allowed to be setuid root in secure mode now (bnc#718016)
* Fri Aug 16 2013 meissner@suse.com
- use PERMISSION_FSCAPS
* Fri Aug 16 2013 meissner@suse.com
- it is PERMISSIONS_FSCAPS (bnc#834790)
- qemu-bridge-helper has no special privileges currently (bnc#765948)
* Wed Jun 12 2013 meissner@suse.com
- utempter helper binary moved in new version to /usr/lib/utempter/utempter (bnc#823302)
* Mon Jun 10 2013 meissner@suse.com
- cdrtools: allow some filesystem capabilities for more stable CD/DVD
  burning in "easy" mode. (bnc#550021) (cap_sys_nice, cap_sys_rawio,
  cap_sys_resource, cap_ipc_lock)
* Wed May  8 2013 meissner@suse.com
- leave out readcd,cdda2wav,cdrecord until it is ready for the distro (bnc#550021)
* Sat May  4 2013 meissner@suse.com
- cdrecord currently has no special permissions approved (bnc#550021)
- append a /
* Tue Jan 29 2013 meissner@suse.com
- Allow pcp to have stickybit worldwriteable directories
* Tue Nov 27 2012 meissner@suse.com
- add /usr/bin/dumpcap to watchlist
- make fscaps=1 the default on ""
- added PERMISSION_FSCAPS to the sysconfig/security fillup template.
- /bin/ping(6) was moved to /usr/bin/ping(6) /bin/eject was moved to /usr/bin/eject
* Wed Nov 21 2012 lnussel@suse.de
- apply permissions settings in %%post. During initial installation
  some packages might be installed before the permissions package
  due to dependency loops so we need to make sure their settings
  are applied too. Also, on update of the permissions package
  changed permission settings may need to be applied.
* Mon Oct 15 2012 lnussel@suse.de
- temporarily add su.core. workaround for the migration of su from
  coreutils to util-linux needs to be reverted as soon as util-linux
  is also in
* Tue Sep 25 2012 meissner@suse.com
- no longer install SuSEconfig.permissions, SuSEconfig is gone.
* Fri Jul  6 2012 meissner@suse.com
- enable ecryptfs-utils setuid root mount wrapper (bnc#740110) in .easy
* Mon Jun  4 2012 lnussel@suse.de
- remove /var/run/vi.recover (bnc#765288)
* Fri Jun  1 2012 lnussel@suse.de
- remove /var/cache/fonts (bnc#764885)
- remove /var/lib/xemacs/lock/ (bnc#764887)
* Thu May 31 2012 lnussel@suse.de
- Revert "Use credentials from within the root file system"
  breaks use of --root option in brp-05-permissions
* Tue May 15 2012 lnussel@suse.de
- print warning when requested to check not listed files
- Use credentials from within the root file system
* Wed Feb  8 2012 lnussel@suse.de
- add duplicate entries for / and /usr (bnc#745622)
* Tue Feb  7 2012 lnussel@suse.de
- add scripts for automatic package sumission
- drop zypp-refresh-wrapper (bnc#738677)
* Mon Nov  7 2011 lnussel@suse.de
- disable run time fscaps detection (bnc#728312)
* Fri Sep 23 2011 lnussel@suse.de
- set permission by default in SuSEconfig mode as permissions are
  only set when called explicitly anyways (bnc#720010).
* Wed Sep 21 2011 lnussel@suse.de
- fix typo in path
* Tue Sep 20 2011 lnussel@suse.de
- remove world writable /var/crash again (bnc#438041)
- remove world writable permissions from /usr/src/packages (bnc#719217)
* Tue Sep 20 2011 lnussel@suse.de
- add chromium browser sandbox helper (bnc#718016)
- don't offer PERMISSION_SECURITY in config anymore
- remove setgid games bits (bnc#429882)
* Tue Jun 28 2011 lnussel@suse.de
- remove setuid bit from opiesu (bnc#698772)
* Fri Jun 17 2011 lnussel@suse.de
- disable fscaps by default as factory kernel still doesn't have the
  required patch for auto detection
* Thu May 26 2011 lnussel@suse.de
- read /sys/kernel/fscaps for fscaps settings
* Thu May 12 2011 lnussel@suse.de
- change path to gnome-pty-helper (bnc#690202)
* Mon Mar  7 2011 lnussel@suse.de
- setuid bit on VBoxNetDHCP (bnc#669055)
* Mon Feb 14 2011 lnussel@suse.de
- fix hawk permissions (bnc#665045)
* Wed Feb  9 2011 lnussel@suse.de
- add hawk (bnc#665045)
* Thu Dec  2 2010 lnussel@suse.de
- remove Xorg setuid bit (bnc#632737)
* Thu Nov 18 2010 lnussel@suse.de
- update permissions of lastlog, faillog, wtmp, utmp and btmp
* Wed Nov 17 2010 lnussel@suse.de
- remove permissions handling for /etc/inittab, /etc/inetd.conf and /etc/mtab
- revert previous commit, done in coreutils instead
* Tue Nov 16 2010 lnussel@suse.de
- change fillup deps to requires to avoid coreutils loop
* Tue Nov 16 2010 lnussel@suse.de
- change utempter from group tty to group utmp (bnc#652877)
* Tue Nov  9 2010 lnussel@suse.de
- add permissions man page
- update docu
- add --level option
- set perms for setuid files always if owner changes
- strip root dir when printing file names
* Tue Nov  9 2010 lnussel@suse.de
- add option to explicitly warn only
* Fri Nov  5 2010 lnussel@suse.de
- reimplement the core features in chkstat itself instead of
  SuSEconfig.permissions
* Thu Nov  4 2010 lnussel@suse.de
- don't make changes if not called explicitly
* Wed Nov  3 2010 lnussel@suse.de
- add support for file system capabilities
* Mon Oct 18 2010 lnussel@suse.de
- remove vlock (bnc#629236#c13)
* Tue Oct  5 2010 lnussel@suse.de
- update path to gnome-pty-helper (bnc#634199)
* Wed Sep 22 2010 lnussel@suse.de
- vlock -> vlock-main (bnc#629236)
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Fri Apr 23 2010 lnussel@suse.de
- add lockdev (bnc#588325)
* Wed Apr  7 2010 lnussel@suse.de
- update for innd update (bnc#594393)
- remove lppasswd (bnc#574336)
* Tue Dec  8 2009 jengelh@medozas.de
- enable parallel building
* Wed Oct  7 2009 lnussel@suse.de
- add /usr/lib/virtualbox/VBoxNetAdpCtl (bnc#533550)
* Thu Aug 27 2009 lnussel@suse.de
- add /usr/src/packages/BUILDROOT/ for rpm 4.7
* Wed Aug 26 2009 lnussel@suse.de
- add more arm directories to /usr/src/packages/RPMS/
* Mon Aug 24 2009 lnussel@suse.de
- remove permissions handling for traceroute6 and cdrecord which are
  symlinks nowadays
* Thu Aug 20 2009 lnussel@suse.de
- fix weird sendfax permissions (bnc#525954)
* Wed Aug 19 2009 lnussel@suse.de
- permissions now maintained at gitorious so use tarball instead of
  individual files
* Wed Aug 12 2009 meissner@suse.de
- added polkit setuid root helpers after review (bnc#523377)
* Fri Aug  7 2009 meissner@suse.de
- also added KDE4 start_kdeinit (same source as kde3 start_kdeinit),
  bnc#523833
* Thu Aug  6 2009 meissner@suse.de
- open-vm-tools gets setuid root:root in mode easy (bnc#474285)
* Tue Jul 28 2009 lnussel@suse.de
- hylafax directory permissions are handled by the package
  - change group of amanda binaries (bnc#523006)
* Mon Mar  2 2009 lnussel@suse.de
- add some missing slashes to directories and remove entries for at
  and cron (bnc#480855)
* Tue Nov 25 2008 lnussel@suse.de
- add VirtualBox (bnc#429725)
* Fri Nov  7 2008 lnussel@suse.de
- add newrole from policycoreutils (bnc#440596)
* Thu Oct 23 2008 lnussel@suse.de
- add udev device files (bnc#438039)
- add system crash dump directory (bnc#438041)
- add bind chroot devices (bnc#438045)
* Mon Oct 20 2008 lnussel@suse.de
- dbus-daemon-launch-helper neeeds to be setuid in level secure
  (bnc#435776)
* Thu Sep 25 2008 lnussel@suse.de
- change /var/games to 755 to prevent ill-considered maneuvers there
  (bnc#429882)
* Thu Sep 11 2008 lnussel@suse.de
- remove static smpppd config file permissions
- fix permissions of polkit-set-default-helper
- grant permissions to PolicyKit helpers also in level secure
* Tue Jul 15 2008 lnussel@suse.de
- ensure correct permissions on ssh files to avoid sshd refusing
  logins (bnc#398250)
* Thu Jul  3 2008 lnussel@suse.de
- adapt permissions of lppasswd for current cups setup (bnc#406058)
* Mon Jun  2 2008 lnussel@suse.de
- add mount.nfs due to an ever increasing number of users
  hit by the regression (bnc#331020, bnc#304318)
* Wed May  7 2008 lnussel@suse.de
- zypp-checkpatches-wrapper -> zypp-refresh-wrapper (bnc#385207)
* Mon Apr 21 2008 lnussel@suse.de
- /dev/full should be 0666 (bnc#379545)
* Thu Apr 17 2008 lnussel@suse.de
- update chkstat manpage and support '--' argument for chkstat
  (bnc#57438)
* Wed Mar 12 2008 lnussel@suse.de
- new PolicyKit permissions (bnc#295341)
- remove obsolete entries for scmxx and zapping
* Mon Jan  7 2008 lnussel@suse.de
- remove setuid bits on man (#351988)
* Mon Dec  3 2007 lnussel@suse.de
- add dbus-daemon-launch-helper (#333361)
* Fri Nov  2 2007 dmueller@suse.de
- kcheckpass/kdesud moved to %%_libdir/kde4/libexec
* Wed Oct 17 2007 lnussel@suse.de
- remove bing (#306626)
* Fri Oct 12 2007 lnussel@suse.de
- remove suexec2 (#263789)
* Fri Aug 10 2007 aj@suse.de
- Readd nscd socket permissions, otherwise glibc build will fail.
* Fri Aug 10 2007 lnussel@suse.de
- add PolicyKit helpers (#295341)
* Wed Aug  8 2007 lnussel@suse.de
- remove nscd socket permission handling as chkstat refuses to touch
  that file anyways (#298334).
* Tue Jun 12 2007 schwab@suse.de
- permissions.local: Fix comment to use uid:gid instead of uid.gid.
* Fri Jun  1 2007 lnussel@suse.de
- package /etc/permissions.local
* Wed May 30 2007 lnussel@suse.de
- add /usr/bin/kcheckpass and /usr/bin/kdesud (#276502)
* Wed Apr 18 2007 dmueller@suse.de
- create debuginfo package (#265667)
* Thu Feb 22 2007 lnussel@suse.de
- prefer package specific permissions files over central ones
  (#246252)
* Thu Feb 22 2007 lnussel@suse.de
- add /opt/kde3/bin/start_kdeinit (#203535)
- remove entries for dropped packages OpenPBS and xtetris
* Wed Jan 17 2007 lnussel@suse.de
- make pam authentication helpers unix_chkpwd, unix2_chkpwd and
  pam_auth setuid root instead of setgid shadow (#216816)
* Wed Jan 10 2007 sbrabec@suse.cz
- Prefix of /opt/gnome binaries changed to /usr.
- Removed gnome-stones.
* Mon Nov 13 2006 lnussel@suse.de
- remove khc_indexbuilder (#188192)
* Mon Oct 16 2006 lnussel@suse.de
- add zypp patch checking helper (#211286)
* Wed Aug 23 2006 lnussel@suse.de
- /usr/X11R6 -> /usr
- remove obsolete entries for xmris,pcmcia-cardinfo,geki2,vmware,nicimud
* Thu Aug 17 2006 cthiel@suse.de
- change paths for v4l-conf from /usr/X11R6/bin to /usr/bin
* Thu Jul 20 2006 sndirsch@suse.de
- Xorg moved from /usr/X11R6/bin to /usr/bin; fixes build of
  xorg-x11-server package
* Tue Jun 27 2006 lnussel@suse.de
- remove setuid bit on gpg (#137562)
* Fri May 19 2006 lnussel@suse.de
- add get_printing_ticket in order to enable smb printing with
  kerberos authentication (#177114)
* Wed May 17 2006 lnussel@suse.de
- add setuid bit to gnomesu-pam-backend in level secure (#175616)
* Thu Feb 23 2006 schwab@suse.de
- /usr/lib/ia32el/suid_libia32x.so renamed to suid_ia32x_loader.
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Mon Jan 16 2006 meissner@suse.de
- removed pmount, pumount.
- moved pmpost to /usr/lib/pcp/pmpost.
* Thu Dec 15 2005 lnussel@suse.de
- /opt/kde3/bin/fileshareset -> /usr/bin/fileshareset
* Fri Dec  9 2005 meissner@suse.de
- temporary only setuid bit for pmount and pumount. #135792
* Wed Nov 23 2005 lnussel@suse.de
- add /usr/bin/fusermount (#133657)
* Mon Nov 21 2005 lnussel@suse.de
- remove Xwrapper, it's a symlink nowadays (#134611)
* Wed Nov  2 2005 dmueller@suse.de
- don't build as root
* Thu Oct 13 2005 meissner@suse.de
- nici moved to /var/opt/novell/...
* Tue Oct 11 2005 meissner@suse.de
- Temporary added setuid binary from "nici" (Novell I? Crypto Interface),
  bug #127545.
* Fri Sep 30 2005 lnussel@suse.de
- add slashes to several directories (#103186)
- change /var/games to games:games 775 again (#103186)
* Tue Aug 30 2005 lnussel@suse.de
- remove kpopup helper (#100132)
* Thu Aug 25 2005 lnussel@suse.de
- add /opt/gnome/sbin/change-passwd (#104993)
* Thu Aug 11 2005 lnussel@suse.de
- remove xmcd (#104040)
- add suexec2 from apache2 (#66304)
- add exim (#66306)
* Thu Aug 11 2005 lnussel@suse.de
- remove /opt/gnome/bin/iagno (#103844)
* Wed Aug 10 2005 lnussel@suse.de
- remove xbl (#103762)
- clean up bsd games list (#103785)
- remove score files as they are the same in all levels anyways
* Wed Aug 10 2005 lnussel@suse.de
- change /var/games{,/xsok} to root:root (#103186)
* Fri Aug  5 2005 lnussel@suse.de
- /usr/sbin/isdnctrl -> /sbin/isdnctrl (#100750)
* Tue Aug  2 2005 lnussel@suse.de
- remove kde games again. Turned out they don't work as intended.
* Tue Aug  2 2005 lnussel@suse.de
- cardctl -> pccardctl (#100120)
* Fri Jul 22 2005 lnussel@suse.de
- add setgid games to some kde games
* Wed Jun  8 2005 lnussel@suse.de
- use correct gnomesu-pam-backend path
* Tue Jun  7 2005 lnussel@suse.de
- add gnomesu-pam-backend (#75823)
- add lppasswd (#66305)
- make ntping 4750 root:trusted also in easy (#66211)
- add cl_status from heartbeat (#66310)
- remove unused /opt/gnome/sbin/change-passwd
* Mon May 16 2005 ro@suse.de
- added /opt/gnome/sbin/change-passwd
* Mon Apr 25 2005 lnussel@suse.de
- add OpenPBS permissions (#66320)
* Tue Mar  1 2005 lnussel@suse.de
- fix inn permissions (#67032)
- remove setuid bit from ziptool (#66191)
* Wed Feb 23 2005 lnussel@suse.de
- remove no longer existing files
- remove setuid plpnfsd (#66207)
- remove setuid bit from dga program
- change vmware permissions
- add /opt/kde3/bin/receivepopup (#66313)
- add /opt/kde3/bin/fileshareset (#66312)
- add /usr/bin/scmxx (#66309)
- add some missing mailman files (#66315)
- include perl script to perform some basic consistency checks
* Mon Jan 31 2005 meissner@suse.de
- backported security fix from SLES 9 branch. #43035
* Sat Jan 15 2005 schwab@suse.de
- Comment fixes.
* Mon Nov 22 2004 sndirsch@suse.de
- permissions.secure: set Xorg to 0711 (4711 before)
* Wed Nov 10 2004 ro@suse.de
- /var/cache/fonts to 1777 (as in tetex perms before)
* Mon Nov  8 2004 kukuk@suse.de
- Add nscd socket to permissions file
* Tue Sep 14 2004 ro@suse.de
- do not use rpm in SuSEconfig.permissions (#45252)
* Tue Sep 14 2004 ro@suse.de
- dropped check for perl in SuSEconfig.permissions (#45252)
* Wed May 26 2004 draht@suse.de
- /usr/lib/ia32el/suid_libia32x.so set to (6755,0755,0755) (#40234)
  source code audit in progress (#40234) (thomas)
* Fri May 14 2004 ro@suse.de
- /usr/lib/ia32el/suid_libia32x.so added to easy,secure,paranoid
  (0755,0755,0755) (#40234)
* Thu Apr 15 2004 sndirsch@suse.de
- XFree86 --> Xorg in permissions files
* Tue Apr  6 2004 mls@suse.de
- added --root option for buildroot operation
* Mon Apr  5 2004 mls@suse.de
- chkstat: fixed relative symlink chasing
- /usr/src/packages/RPMS back to 1777 in easy, as chkstat can
  now handle it
* Sun Apr  4 2004 mls@suse.de
- chkstat: added missing link count check and safepath() function
- chkstat: refuse to give away s-bits on insecure paths
- chkstat: bugfix: stat file again after chown, as modes may have
  changed
* Fri Apr  2 2004 mls@suse.de
- chkstat: re-implemented it in C to make it more secure
* Thu Apr  1 2004 kukuk@suse.de
- Remove /var/lock/subsys [#37759]
- Add sticky bit to /var/lock [#37759]
* Wed Mar 24 2004 draht@suse.de
- make /usr/bin/gpg setuid root in easy+secure, 0755 in paranoid.
  [#33570].
* Tue Mar 23 2004 draht@suse.de
- #36741: /usr/src/packages/RPMS 1777->0755 in easy.
* Mon Mar 22 2004 kukuk@suse.de
- Fix syntax error in permission.easy
- /usr/bin/ssh should be always 0755
* Fri Feb 13 2004 draht@suse.de
- /var/run/uscreens (root:root 1777) added
* Thu Feb 12 2004 kukuk@suse.de
- Don't modify group of crontab and at useless
* Fri Jan  9 2004 kukuk@suse.de
- Add RPM directory for hppa2.0
* Fri Nov 21 2003 ro@suse.de
- fpexec decrease go rights to 11
* Tue Nov  4 2003 ro@suse.de
- inn scripts: u-w (not needed)
* Mon Nov  3 2003 schwab@suse.de
- chkstat: fix option parsing.
* Wed Oct 29 2003 kukuk@suse.de
- Sync permissions for shadow package
* Tue Oct 28 2003 ro@suse.de
- require /sbin/SuSEconfig
* Tue Oct 28 2003 ro@suse.de
- chkstat: added some new extensions:
  allow specifying singular files or a filelist to be checked
  output previous/current mode of a failed file
  adapted manpage
* Tue Oct 21 2003 draht@suse.de
- permissions.secure: /etc/ftpusers 0640 root.root -> 0644
* Mon Oct 20 2003 ro@suse.de
- permissions.*: use ":" and not "." to separate user/group
- chkstat: output also which of (permissions/owner) is wrong
- chkstat: don't try to chown if not root
* Tue Oct 14 2003 draht@suse.de
- reformatting of all 4 permissions files. xkobo, rocksndiamonds,
  xlogical, lbreakout2 and ltris path adoptions.
  for future reference: :-)
  for i in permissions permissions.easy permissions.secure
  permissions.paranoid; do cat $i | \
  awk '/^(#|$)/ { print $0; next; }
  { if(NF > 3) {printf("error: %%s\n",$0);exit};
    printf("%%-55s %%-17s %%4s\n",$1,$2,$3)}' \
  > $i.. && mv $i.. $i; done
* Thu Sep 18 2003 kukuk@suse.de
- Fix group of straps, popauth and ntping
- Remove some GNOME games which do not need special rights anymore
* Tue Sep 16 2003 kukuk@suse.de
- permissions.easy: change group of bing, vboxbeep, plpnfsd to
  trusted, majordomo/wrapper to daemon
* Tue Sep 16 2003 kukuk@suse.de
- permissions.easy: change group of gpasswd and ziptool to trusted
* Tue Sep  2 2003 kkeil@suse.de
- fix user fax for hylafax specific files
* Tue Sep  2 2003 kukuk@suse.de
- fix path to cons.saver, remove setuid bit in paranoid (#25907)
- remove screen
- remove smail (dropped years ago)
* Mon Sep  1 2003 kkeil@suse.de
- fix group for isdnctrl uucp --> dialout (#28997)
* Mon Sep  1 2003 draht@suse.de
- feedback@suse.de -> http://www.suse.de/feedback in all files of
  the package. #29635.
* Sat Aug 23 2003 sndirsch@suse.de
- added martian entries of package pachi
* Tue Aug 19 2003 mmj@suse.de
- Add sysconfig metadata [#28937]
* Tue Jul 29 2003 draht@suse.de
- fax changes from Tomas Crhak: faxq-helper and spool directories.
* Tue Jul 29 2003 ro@suse.de
- gnome games moved back to /opt/gnome
* Mon Jul 28 2003 kukuk@suse.de
- Remove /var/run from permissions file list [Bug #28289]
* Mon Jul 28 2003 kukuk@suse.de
- /var/lib/gdm: Removed to solve [Bug #28257] for future products.
* Fri Jul 25 2003 draht@suse.de
- /usr/lib/vte/gnome-pty-helper -> /opt/gnome/lib/vte/gnome-pty-helper
  The same with /opt/gnome/lib64/.
* Fri Jun 13 2003 kukuk@suse.de
- /usr/lib/mgetty+sendfax/faxq-helper added 4711 in easy and secure
* Fri May  2 2003 sndirsch@suse.de
- added /usr/games/pachi and /var/games/pachi.scores
* Mon Mar 10 2003 sndirsch@suse.de
- added /usr/games/falconseye.bin
- removed /usr/games/falconseye
* Mon Mar 10 2003 kukuk@suse.de
- added /usr/lib64/vte/gnome-pty-helper until ported to utempter
* Sun Mar  9 2003 sndirsch@suse.de
- added /usr/games/falconseye
- removed old falconseye entries
* Thu Mar  6 2003 ro@suse.de
- added /usr/lib/vte/gnome-pty-helper until ported to utempter
* Thu Feb 20 2003 mmj@suse.de
- Add sysconfig metadata [#22686]
* Tue Feb 18 2003 kssingvo@suse.de
- removed squid entries. They will be added and corrected to squids own
  permission file /etc/permissions.d/squid (bugzilla#23752):
  /var/squid
  /var/squid/cache
  /var/squid/logs
* Tue Feb 18 2003 draht@suse.de
- /usr/games/trackballs added 2755 games.games in easy.
* Sun Feb 16 2003 adrian@suse.de
- allow khc_indexbuilder to write into /var/cache/susehelp in easy mode
- remove old entries (kreatecd and kscd)
* Mon Feb 10 2003 draht@suse.de
- additions/changes (from #17012, Tobias Burnus):
  * read all files from the commandline at once and override
    entries given multiple times by the last entry
  * enable option --set in addition to -set
  * manpage adoptions
  * call chkstat only once from SuSEconfig.permissions
* Thu Feb  6 2003 ro@suse.de
- /var/mtrack -> /var/lib/mtrack
* Tue Nov 19 2002 ro@suse.de
- zapping_setup_fb moved to /opt/gnome/sbin
* Thu Nov 14 2002 bg@suse.de
- added hppa to rpm subsystem in permissions files to be able to
  finish autobuild
* Thu Oct 24 2002 ro@suse.de
- two more nethack flavors with sgid games in easy
* Tue Sep 10 2002 draht@suse.de
- cda entries below /usr/X11R6/lib/X11/xmcd removed.
  index.html under /var/lib/xmcd/discog directories added
  world-writeable. This is not satisfactory. New user xmcd will be
  added in next release.
* Thu Sep  5 2002 draht@suse.de
- /usr/X11R6/lib/X11/xmcd/bin-Linux-ia64/{cda,xmcd} added.
* Mon Aug 26 2002 draht@suse.de
- removed all occurrences of kv4lsetup upon request by adrian+uli.
- -s for xlock, xlock-mesa + xscreensaver (#18125), (#18132)
- /usr/src/packages/RPMS/alphaev67 added.
- added /sbin/unix2_chkpwd root.shadow 2755
- -s /usr/sbin/papd (#18103)
* Wed Aug 21 2002 draht@suse.de
- removed suid bits from heimdal's su and otp (#18104)
* Wed Aug 21 2002 draht@suse.de
- remove setuid bit from traceroute due to new implementation by
  Olaf Kirch which doesn't need euid root. (#18101)
* Wed Aug 21 2002 draht@suse.de
- removed lprng entries because of conflicts cups <-> lprng
* Wed Aug 21 2002 draht@suse.de
- vboxbeep -> 0755 in secure.
* Mon Aug 19 2002 ro@suse.de
- added prereq (#17956)
* Mon Aug 19 2002 uli@suse.de
- added nethack for lib64 archs
* Mon Aug 19 2002 uli@suse.de
- added xmcd for archs != i386
* Tue Aug 13 2002 draht@suse.de
- gnome-games2 entries changed/adopted to /opt/gnome2 path.
* Tue Aug 13 2002 draht@suse.de
- changed kcheckpass from 2755 root.shadow to 4755. (#17664)
* Wed Jul 31 2002 olh@suse.de
- ncpmount, ncpumount, nwsfind, ncplogin, ncpmap root.trusted 4750
* Sat Jul 27 2002 kukuk@suse.de
- Rename group wwwadmin to www
- Rename group game to games
* Tue Jul 23 2002 draht@suse.de
- added sapdb files, not setuid root in secure,paranoid.
* Mon Jul 22 2002 draht@suse.de
- added frontpage files
* Tue Jul 16 2002 draht@suse.de
- changed entries for mailman: group mdom -> mailman
* Tue Jul 16 2002 draht@suse.de
- mailman sgid mdom files added to easy, secure and paranoid.
* Wed Jul 10 2002 draht@suse.de
- .paranoid comment fixed about at and cron (#12159)
* Mon Jul  8 2002 draht@suse.de
- ppp dialup networking fixes and cleanup.
* Mon Jul  8 2002 draht@suse.de
- modifications: -s for pppd, world-writeable directories for
  kdemultimedia3-sound, gift, mips and armv4l RPMS directory.
* Fri Jul  5 2002 kukuk@suse.de
- Add /usr/src/packages/RPMS/sparcv9 to easy,secure,paranoid.
* Thu Jul  4 2002 draht@suse.de
- /usr/lib64/pt_chown added to easy,secure,paranoid.
* Mon Jul  1 2002 draht@suse.de
- entries for packages added or changed:
  squid
  geki2
  d1x
  falconseye
  fdutils
  gewels
  gnome-games
  heimdal
  lbreakout
  lpdfilter
  lprng
  man
  mgetty (/var/spool/fax/outgoing/* need discussion)
  mtrack (locfile+satfile -> 0644)
  nethack
  nvi-m17n (/var/preserve/vi.recover -> 1777)
  opie (/bin -> /usr/bin)
  pcp
  plptools
  qpopper
  rp-pppoe (/usr/sbin/pppoe-wrapper)
  smpppd (/usr/sbin/cinternet-wwwrun wwwrun.dialout   2750)
  squid (/usr/sbin/pam_auth)
  su-wrapper
  xemacs (lock directory changed again? now /var/state/xemacs and /var/lib/xemacs)
  xgalaga
  xmcd
  xscrabble
* Sun Jun 30 2002 ro@suse.de
- don't install all sources (spec file etc.)
* Fri Jun 28 2002 draht@suse.de
- minor spec file change
* Fri Jun 28 2002 draht@suse.de
- entries for packages added:
  ftpdir
  gnokii
  kamplus
  geki2
  aaa_dir (/tmp/.ICE-unix)
* Fri Jun 28 2002 draht@suse.de
- unpack tar archive in source for convenience.
* Thu Jun 27 2002 olh@suse.de
- update permissions of /usr/src/packages/RPMS/<arch>
* Fri Jun 21 2002 ro@suse.de
- created package as split off from aaa_base
