#
# spec file for package dracut
#
# Copyright (c) 2022 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

%define dracutlibdir %{_prefix}/lib/dracut

%if 0%{?suse_version} >= 1550
%define dracut_sbindir %{_sbindir}
%else
%define dracut_sbindir /sbin
%endif

Name:           dracut
Version:        059+suse.562.geca59f6b
Release:        150600.3.23.1
Summary:        Event driven initramfs infrastructure
License:        GPL-2.0-or-later AND LGPL-2.1-or-later
Group:          System/Base
URL:            https://github.com/dracutdevs/dracut/wiki
Source0:        dracut-%{version}.tar.xz
Source1:        dracut-rpmlintrc
Source2:        README.susemaint
BuildRequires:  asciidoc
BuildRequires:  bash
BuildRequires:  docbook-xsl-stylesheets
BuildRequires:  libxslt
BuildRequires:  pkgconfig(libkmod)
BuildRequires:  pkgconfig(systemd) >= 219
BuildRequires:  cargo
BuildRequires:  rust
# For regenerate_initrd_posttrans
%if 0%{?suse_version} < 1550
BuildRequires:  suse-module-tools
%else
BuildRequires:  rpm-config-SUSE
%endif
Requires:       gawk
Requires:       %{_bindir}/get_kernel_version
Requires:       bash
Requires:       coreutils
Requires(post): coreutils
Requires:       cpio
Requires:       elfutils
Requires:       file
Requires:       filesystem
Requires:       findutils
Requires:       grep
Requires:       hardlink
Requires:       modutils
Requires:       pigz
Requires:       sed
Requires:       systemd >= 219
Recommends:     (tpm2.0-tools if tpm2-0-tss)
Requires:       udev > 166
Requires:       util-linux >= 2.21
Requires:       util-linux-systemd >= 2.36.2
Recommends:     xz
Requires:       zstd
# We use 'btrfs fi usage' that was not present before
Conflicts:      btrfsprogs < 3.18
# suse-module-tools >= 15.4.7 is prepared for the removal of mkinitrd-suse.sh
Conflicts:      suse-module-tools < 15.4.7
%{?systemd_requires}
Requires:       (iputils or arping2 or wicked)
Requires:       (jq if nvme-cli)

%description
Dracut contains tools to create a bootable initramfs for Linux kernels >= 2.6.
Dracut contains various modules which are driven by the event-based udev
and systemd. Having root on MD, DM, LVM2, LUKS is supported as well as
NFS, iSCSI, NBD, FCoE.

%package fips
Summary:        Dracut modules to build a dracut initramfs with an integrity check
Group:          System/Base
Requires:       %{name} = %{version}-%{release}
Requires:       libcryptsetup12-hmac
Requires:       libkcapi-tools
Requires:       libopenssl1_1-hmac

%description fips
This package requires everything which is needed to build an
initramfs with dracut, which does an integrity check of the kernel
and its cryptography during startup.

%package ima
Summary:        Dracut modules to build a dracut initramfs with IMA
Group:          System/Base
Requires:       %{name} = %{version}-%{release}
Requires:       evmctl
Requires:       keyutils

%description ima
This package requires everything which is needed to build an
initramfs (using dracut) which tries to load an IMA policy during startup.

%package tools
Summary:        Tools to build a local initramfs
Group:          System/Base
Requires:       %{name}
# split-provides for upgrade from SLES12 SP1 to SLES12 SP2
Provides:       %{name}:%{_bindir}/dracut-catimages

%description tools
This package contains tools to assemble the local initrd and host configuration.

%package extra
Summary:        Dracut modules usually not required for normal operation
Group:          System/Base
Requires:       %{name} = %{version}-%{release}
Requires:       evmctl
Requires:       keyutils

%description extra
This package contains all modules that are part of dracut upstream
but are not normally supported or required.

%package mkinitrd-deprecated
Summary:        Dracut mkinitrd wrapper
Group:          System/Base
Requires:       %{name} = %{version}-%{release}
Requires:       dracut
Obsoletes:      mkinitrd < 2.8.2
Provides:       mkinitrd = 2.8.2
Provides:       dracut:/sbin/mkinitrd

%description mkinitrd-deprecated
This package contains the legacy initrd script for dracut.
Call dracut directly instead.

%prep
%autosetup

%build
%configure \
  --systemdsystemunitdir=%{_unitdir} \
  --bashcompletiondir=%{_datadir}/bash-completion/completions \
  --libdir=%{_prefix}/lib \
  --enable-dracut-cpio
%make_build all CFLAGS="%{optflags}" %{?_smp_mflags}

%install
%make_install

echo -e "#!/bin/bash\nDRACUT_VERSION=%{version}-%{release}" > %{buildroot}%{dracutlibdir}/dracut-version.sh

# remove architecture specific modules
%ifnarch ppc ppc64 ppc64le ppc64p7
rm -rf %{buildroot}%{dracutlibdir}/modules.d/90ppcmac
%endif
%ifnarch s390 s390x
rm -rf %{buildroot}%{dracutlibdir}/modules.d/80cms
rm -rf %{buildroot}%{dracutlibdir}/modules.d/81cio_ignore
rm -rf %{buildroot}%{dracutlibdir}/modules.d/91zipl
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95dasd
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95dasd_mod
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95dasd_rules
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95dcssblk
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95qeth_rules
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95zfcp
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95zfcp_rules
rm -rf %{buildroot}%{dracutlibdir}/modules.d/95znet
%else
rm -rf %{buildroot}%{dracutlibdir}/modules.d/00warpclock
%endif

mkdir -p %{buildroot}/boot/dracut
mkdir -p %{buildroot}%{_localstatedir}/lib/dracut/overlay
mkdir -p %{buildroot}%{_localstatedir}/log
touch %{buildroot}%{_localstatedir}/log/dracut.log

install -D -m 0644 dracut.conf.d/suse.conf.example %{buildroot}%{dracutlibdir}/dracut.conf.d/01-dist.conf
install -m 0644 suse/99-debug.conf %{buildroot}%{_sysconfdir}/dracut.conf.d/99-debug.conf
install -m 0644 dracut.conf.d/fips.conf.example %{buildroot}%{_sysconfdir}/dracut.conf.d/40-fips.conf
install -m 0644 dracut.conf.d/ima.conf.example %{buildroot}%{_sysconfdir}/dracut.conf.d/40-ima.conf
# bsc#915218
%ifarch s390 s390x
install -m 0644 suse/s390x_persistent_policy.conf %{buildroot}%{_sysconfdir}/dracut.conf.d/10-persistent_policy.conf
%else
install -m 0644 suse/persistent_policy.conf %{buildroot}%{_sysconfdir}/dracut.conf.d/10-persistent_policy.conf
%endif

install -D -m 0755 suse/mkinitrd-suse.sh %{buildroot}/%{dracut_sbindir}/mkinitrd

mv %{buildroot}%{_mandir}/man8/mkinitrd-suse.8 %{buildroot}%{_mandir}/man8/mkinitrd.8

%if 0%{?suse_version}
rm -f %{buildroot}%{dracutlibdir}/modules.d/45ifcfg/write-ifcfg.sh
ln -s %{dracutlibdir}/modules.d/45ifcfg/write-ifcfg-suse.sh %{buildroot}%{dracutlibdir}/modules.d/45ifcfg/write-ifcfg.sh
%else
mv %{buildroot}%{dracutlibdir}/modules.d/45ifcfg/write-ifcfg.sh %{buildroot}%{dracutlibdir}/modules.d/45ifcfg/write-ifcfg-redhat.sh
ln -s %{dracutlibdir}/modules.d/45ifcfg/write-ifcfg-redhat.sh %{buildroot}%{dracutlibdir}/modules.d/45ifcfg/write-ifcfg.sh
%endif

# create a link to dracut-util to be able to parse kernel command line arguments at generation time
ln -s %{dracutlibdir}/dracut-util %{buildroot}%{dracutlibdir}/dracut-getarg

%post
# check whether /var/run has been converted to a symlink
if [ ! -L /var/run ]; then
    grep -q '^[ 	]*GRUB_CMDLINE_LINUX_DEFAULT=.*rd.convertfs' /etc/default/grub || \
    sed -i '/^[ 	]*GRUB_CMDLINE_LINUX_DEFAULT.*/s/"$/ rd.convertfs"/' /etc/default/grub  || :
    if ! grep --no-message 'add_dracutmodules+=" convertfs "' /etc/dracut.conf.d/05-convertfs.conf; then
        cat >>/etc/dracut.conf.d/05-convertfs.conf<<EOF
add_dracutmodules+=" convertfs "
EOF
    fi
fi
#clean up after the conversion is done
if [ -L /var/run ] && [ -f /etc/dracut.conf.d/05-convertfs.conf ]; then
    sed -i '/^[ 	]*GRUB_CMDLINE_LINUX_DEFAULT.*/s/rd.convertfs//' /etc/default/grub || :
    [ -f /etc/dracut.conf.d/05-convertfs.conf ] && sed -i '/add_dracutmodules+="[ 	]*convertfs[ 	]*"/d' /etc/dracut.conf.d/05-convertfs.conf || :
    [ -s /etc/dracut.conf.d/05-convertfs.conf ] || rm -f /etc/dracut.conf.d/05-convertfs.conf || :
    [ -d /var/lock.lockmove~ ] && rm -rf /var/lock.lockmove~ || :
    [ -d /var/run.runmove~ ] && rm -rf /var/run.runmove~ || :
fi

# remove obsolete legacy fillup template for /etc/sysconfig/kernel
rm -f /var/adm/fillup-templates/sysconfig.kernel-mkinitrd

%{?regenerate_initrd_post}

%post fips
%{?regenerate_initrd_post}

%post ima
%{?regenerate_initrd_post}

%postun
%{?regenerate_initrd_post}

%postun fips
%{?regenerate_initrd_post}

%postun ima
%{?regenerate_initrd_post}

%posttrans
%{?regenerate_initrd_posttrans}

%posttrans fips
%{?regenerate_initrd_posttrans}

%posttrans ima
%{?regenerate_initrd_posttrans}

%files fips
%license COPYING
%config %{_sysconfdir}/dracut.conf.d/40-fips.conf
%{dracutlibdir}/modules.d/01fips

%files ima
%license COPYING
%config %{_sysconfdir}/dracut.conf.d/40-ima.conf
%{dracutlibdir}/modules.d/96securityfs
%{dracutlibdir}/modules.d/97masterkey
%{dracutlibdir}/modules.d/98integrity

%files tools
%{_bindir}/dracut-catimages
%{_mandir}/man8/dracut-catimages.8*
%dir /boot/dracut
%dir %{_localstatedir}/lib/dracut
%dir %{_localstatedir}/lib/dracut/overlay

%files extra
%license COPYING

%{dracutlibdir}/modules.d/00mksh
%{dracutlibdir}/modules.d/02caps
%{dracutlibdir}/modules.d/00dash
%{dracutlibdir}/modules.d/05busybox
%ifarch ppc ppc64 ppc64le ppc64p7
%{dracutlibdir}/modules.d/90ppcmac
%endif
%ifarch s390 s390x
# RH-specific s390 modules, we take another approach
%{dracutlibdir}/modules.d/95dasd
%{dracutlibdir}/modules.d/95zfcp
%{dracutlibdir}/modules.d/95znet
%endif

%files mkinitrd-deprecated
%{dracut_sbindir}/mkinitrd
%{_mandir}/man8/mkinitrd.8*

%files
%license COPYING
%doc README.md NEWS.md AUTHORS dracut.html
%doc docs/README.cross docs/README.generic docs/README.kernel
%doc docs/HACKING.md docs/dracut.png docs/dracut.svg
%{_bindir}/dracut
%{_bindir}/lsinitrd
%dir %{_datadir}/bash-completion
%dir %{_datadir}/bash-completion/completions
%{_datadir}/bash-completion/completions/dracut
%{_datadir}/bash-completion/completions/lsinitrd
%{_datadir}/pkgconfig/dracut.pc

%config(noreplace) %{_sysconfdir}/dracut.conf
%dir %{_sysconfdir}/dracut.conf.d
%dir %{dracutlibdir}/dracut.conf.d
%{dracutlibdir}/dracut.conf.d/01-dist.conf
%config %{_sysconfdir}/dracut.conf.d/99-debug.conf
%config %{_sysconfdir}/dracut.conf.d/10-persistent_policy.conf

%{_mandir}/man8/dracut.8*
%{_mandir}/man1/lsinitrd.1*
%{_mandir}/man7/dracut.kernel.7*
%{_mandir}/man7/dracut.cmdline.7*
%{_mandir}/man7/dracut.bootup.7*
%{_mandir}/man7/dracut.modules.7*
%{_mandir}/man8/dracut-cmdline.service.8*
%{_mandir}/man8/dracut-initqueue.service.8*
%{_mandir}/man8/dracut-pre-pivot.service.8*
%{_mandir}/man8/dracut-pre-trigger.service.8*
%{_mandir}/man8/dracut-pre-udev.service.8*
%{_mandir}/man8/dracut-mount.service.8.*
%{_mandir}/man8/dracut-pre-mount.service.8.*
%{_mandir}/man8/dracut-shutdown.service.8.*
%{_mandir}/man5/dracut.conf.5*

%dir %{_prefix}/lib/kernel
%dir %{_prefix}/lib/kernel/install.d
%{_prefix}/lib/kernel/install.d/50-dracut.install
%{_prefix}/lib/kernel/install.d/51-dracut-rescue.install

%dir %{dracutlibdir}
%{dracutlibdir}/skipcpio
%{dracutlibdir}/dracut-functions.sh
%{dracutlibdir}/dracut-init.sh
%{dracutlibdir}/dracut-functions
%{dracutlibdir}/dracut-version.sh
%{dracutlibdir}/dracut-logger.sh
%{dracutlibdir}/dracut-initramfs-restore
%{dracutlibdir}/dracut-install
%{dracutlibdir}/dracut-util
%{dracutlibdir}/dracut-getarg
%{dracutlibdir}/dracut-cpio

%dir %{dracutlibdir}/modules.d
%{dracutlibdir}/modules.d/00bash
%{dracutlibdir}/modules.d/00systemd
%{dracutlibdir}/modules.d/00systemd-network-management
%ifnarch s390 s390x
%{dracutlibdir}/modules.d/00warpclock
%endif
%{dracutlibdir}/modules.d/01systemd-ac-power
%{dracutlibdir}/modules.d/01systemd-ask-password
%{dracutlibdir}/modules.d/01systemd-coredump
%{dracutlibdir}/modules.d/01systemd-hostnamed
%{dracutlibdir}/modules.d/01systemd-initrd
%{dracutlibdir}/modules.d/01systemd-integritysetup
%{dracutlibdir}/modules.d/01systemd-journald
%{dracutlibdir}/modules.d/01systemd-ldconfig
%{dracutlibdir}/modules.d/01systemd-modules-load
%{dracutlibdir}/modules.d/01systemd-networkd
%{dracutlibdir}/modules.d/01systemd-pcrphase
%{dracutlibdir}/modules.d/01systemd-portabled
%{dracutlibdir}/modules.d/01systemd-pstore
%{dracutlibdir}/modules.d/01systemd-repart
%{dracutlibdir}/modules.d/01systemd-resolved
%{dracutlibdir}/modules.d/01systemd-sysctl
%{dracutlibdir}/modules.d/01systemd-sysext
%{dracutlibdir}/modules.d/01systemd-sysusers
%{dracutlibdir}/modules.d/01systemd-timedated
%{dracutlibdir}/modules.d/01systemd-timesyncd
%{dracutlibdir}/modules.d/01systemd-tmpfiles
%{dracutlibdir}/modules.d/01systemd-udevd
%{dracutlibdir}/modules.d/01systemd-veritysetup
%{dracutlibdir}/modules.d/03modsign
%{dracutlibdir}/modules.d/03rescue
%{dracutlibdir}/modules.d/04watchdog
%{dracutlibdir}/modules.d/04watchdog-modules
%{dracutlibdir}/modules.d/06dbus-broker
%{dracutlibdir}/modules.d/06dbus-daemon
%{dracutlibdir}/modules.d/06rngd
%{dracutlibdir}/modules.d/09dbus
%{dracutlibdir}/modules.d/10i18n
%{dracutlibdir}/modules.d/30convertfs
%{dracutlibdir}/modules.d/35connman
%{dracutlibdir}/modules.d/35network-legacy
%{dracutlibdir}/modules.d/35network-manager
%{dracutlibdir}/modules.d/40network
%{dracutlibdir}/modules.d/45ifcfg
%{dracutlibdir}/modules.d/45url-lib
%{dracutlibdir}/modules.d/50drm
%{dracutlibdir}/modules.d/50plymouth
%{dracutlibdir}/modules.d/62bluetooth
%ifarch s390 s390x
%{dracutlibdir}/modules.d/80cms
%endif
%{dracutlibdir}/modules.d/80lvmmerge
%{dracutlibdir}/modules.d/80lvmthinpool-monitor
%exclude %{dracutlibdir}/modules.d/80test
%exclude %{dracutlibdir}/modules.d/80test-makeroot
%exclude %{dracutlibdir}/modules.d/80test-root
%ifarch s390 s390x
%{dracutlibdir}/modules.d/81cio_ignore
%endif
%{dracutlibdir}/modules.d/90btrfs
%{dracutlibdir}/modules.d/90crypt
%{dracutlibdir}/modules.d/90dm
%{dracutlibdir}/modules.d/90dmraid
%{dracutlibdir}/modules.d/90dmsquash-live
%{dracutlibdir}/modules.d/90dmsquash-live-autooverlay
%{dracutlibdir}/modules.d/90dmsquash-live-ntfs
%{dracutlibdir}/modules.d/90kernel-modules-extra
%{dracutlibdir}/modules.d/90kernel-modules
%{dracutlibdir}/modules.d/90kernel-network-modules
%{dracutlibdir}/modules.d/90livenet
%{dracutlibdir}/modules.d/90lvm
%{dracutlibdir}/modules.d/90mdraid
%{dracutlibdir}/modules.d/90multipath
%{dracutlibdir}/modules.d/90nvdimm
%{dracutlibdir}/modules.d/90overlayfs
%{dracutlibdir}/modules.d/90qemu
%{dracutlibdir}/modules.d/90qemu-net
%{dracutlibdir}/modules.d/91crypt-gpg
%{dracutlibdir}/modules.d/91crypt-loop
%{dracutlibdir}/modules.d/91fido2
%{dracutlibdir}/modules.d/91pcsc
%{dracutlibdir}/modules.d/91pkcs11
%{dracutlibdir}/modules.d/91tpm2-tss
%ifarch s390 s390x
%{dracutlibdir}/modules.d/91zipl
%endif
%{dracutlibdir}/modules.d/95cifs
%ifarch s390 s390x
%{dracutlibdir}/modules.d/95dasd_mod
%{dracutlibdir}/modules.d/95dasd_rules
%{dracutlibdir}/modules.d/95dcssblk
%endif
%{dracutlibdir}/modules.d/95debug
%{dracutlibdir}/modules.d/95fcoe
%{dracutlibdir}/modules.d/95fcoe-uefi
%{dracutlibdir}/modules.d/95fstab-sys
%{dracutlibdir}/modules.d/95iscsi
%{dracutlibdir}/modules.d/95lunmask
%{dracutlibdir}/modules.d/95nbd
%{dracutlibdir}/modules.d/95nfs
%{dracutlibdir}/modules.d/95nvmf
%ifarch s390 s390x
%{dracutlibdir}/modules.d/95qeth_rules
%endif
%{dracutlibdir}/modules.d/95resume
%{dracutlibdir}/modules.d/95rootfs-block
%{dracutlibdir}/modules.d/95ssh-client
%{dracutlibdir}/modules.d/95terminfo
%{dracutlibdir}/modules.d/95udev-rules
%{dracutlibdir}/modules.d/95virtfs
%{dracutlibdir}/modules.d/95virtiofs
%ifarch s390 s390x
%{dracutlibdir}/modules.d/95zfcp_rules
%endif
%{dracutlibdir}/modules.d/97biosdevname
%{dracutlibdir}/modules.d/98dracut-systemd
%{dracutlibdir}/modules.d/98ecryptfs
%{dracutlibdir}/modules.d/98pollcdrom
%{dracutlibdir}/modules.d/98selinux
%{dracutlibdir}/modules.d/98syslog
%{dracutlibdir}/modules.d/98usrmount
%{dracutlibdir}/modules.d/99base
%{dracutlibdir}/modules.d/99fs-lib
%{dracutlibdir}/modules.d/99img-lib
%{dracutlibdir}/modules.d/99memstrack
%{dracutlibdir}/modules.d/99shutdown
%{dracutlibdir}/modules.d/99squash
%{dracutlibdir}/modules.d/99suse
%{dracutlibdir}/modules.d/99suse-initrd
%{dracutlibdir}/modules.d/99uefi-lib
%attr(0640,root,root) %ghost %config(missingok,noreplace) %{_localstatedir}/log/dracut.log
%dir %{_unitdir}/initrd.target.wants
%dir %{_unitdir}/sysinit.target.wants
%{_unitdir}/*.service
%{_unitdir}/*/*.service

%changelog
* Tue Aug 12 2025 antonio.feijoo@suse.com
- Update to version 059+suse.562.geca59f6b:
  * fix(dracut-util): crash if CMDLINE ends with quotation mark (bsc#1247819)
  * fix(rngd): adjust license to match the license of the whole project
  * fix(nfs): set correct ownership of rpc.statd state directories (bsc#1217885)
  * perf(nfs): remove references to old rpcbind state dir
  * fix(nfs): libnfsidmap plugins not added in some distributions
* Fri Mar  7 2025 antonio.feijoo@suse.com
- Update to version 059+suse.557.gccd6ab94:
  * fix(iscsi): make sure services are shut down when switching root (bsc#1237695)
  * fix(iscsi): don't require network setup for qedi
  * fix(network-legacy): do not require pgrep when using wicked (bsc#1236982)
* Tue Feb  4 2025 antonio.feijoo@suse.com
- Update to version 059+suse.552.g232957b4:
  Fixes related to getting live image size (bsc#1235912):
  * fix(livenet): split `imgsize` calculation to avoid misleading error message
  * fix(livenet): check also `content-length` from live image header
  * fix(livenet): propagate error code
  Fixes for booting from iSCSI offload with bnx2i (bsc#1228086):
  * fix(iscsi): attempt iSCSI login before all interfaces are up
  * fix(iscsi): don't require network setup for bnx2i
  Other:
  * fix(dracut): rework timeout for devices added via --mount and --add-device (bsc#1231792)
* Mon Nov  4 2024 antonio.feijoo@suse.com
- Update to version 059+suse.543.g98d7f037:
  * fix(dm): remove 59-persistent-storage-dm.rules (bsc#1232063)
* Fri Sep 27 2024 antonio.feijoo@suse.com
- Update to version 059+suse.541.g3c2df232:
  * fix(dasd-rules): handle all possible options in `rd.dasd` (bsc#1230110)
* Fri Sep 20 2024 antonio.feijoo@suse.com
- Update to version 059+suse.539.gdd3495f7:
  * fix(dracut.spec): add Builddeps for initrd posttrans macros (bsc#1230639)
  * fix(zfcp_rules): check for presence of legacy rules (bsc#1230330)
  Fixes for NVMeoF boot (bsc#1230468):
  * fix(nvmf): install (only) required nvmf modules
  * fix(nvmf): require NVMeoF modules
  * fix(nvmf): move /etc/nvme/host{nqn,id} requirement to hostonly
* Fri Aug 23 2024 antonio.feijoo@suse.com
- Update to version 059+suse.531.g48487c31:
  * feat(systemd*): include systemd config files from /usr/lib/systemd (bsc#1228398)
  * fix(convertfs): error in conditional expressions (bsc#1228847)
* Mon Jul  8 2024 antonio.feijoo@suse.com
- Update to version 059+suse.527.g7870f083:
  * feat(crypt): force the inclusion of crypttab entries with x-initrd.attach (bsc#1226529)
  * fix(mdraid): try to assemble the missing raid device (bsc#1226412)
  * fix(dracut-install): continue parsing if ldd prints "cannot be preloaded" (bsc#1208690)
* Fri May  3 2024 antonio.feijoo@suse.com
- Update to version 059+suse.521.g8412a1c0:
  * fix(suse-initrd): clean return of installkernel() (bsc#1223467)
* Tue Apr 30 2024 antonio.feijoo@suse.com
- Update to version 059+suse.519.g3edf43b4:
  * chore(suse): remove obsolete fillup template (bsc#1223467)
* Tue Mar 19 2024 antonio.feijoo@suse.com
- Update to version 059+suse.515.g83296e6f:
  * fix(dracut): correct regression with multiple `rd.break=` options (bsc#1221675)
  * fix(dracut-util): do not call `strcmp` if the `value` argument is NULL (bsc#1219841)
  * fix(i18n): handle symlinked keymap (bsc#1221193)
  * fix(zfcp_rules): correct shellcheck regression when parsing ccw args (bsc#1220485)
  * fix(dracut.sh): skip README for AMD microcode generation (bsc#1217083)
* Mon Nov 13 2023 antonio.feijoo@suse.com
- Update to version 059+suse.506.gd33b6bef:
  * fix(dracut.sh): remove microcode check based on CONFIG_MICROCODE_[AMD|INTEL] (bsc#1217031)
  * fix(network): correct network device naming (bsc#1192986)
* Mon Oct 23 2023 antonio.feijoo@suse.com
- Update to version 059+suse.502.g92237883:
  * fix(systemd): add new systemd-tmpfiles-setup-dev-early.service
  * revert(suse): fix systemd-sysvinit dependency
* Thu Oct 19 2023 antonio.feijoo@suse.com
- Update to version 059+suse.499.g2976c52f:
  * fix(dracut.spec): do not require libgcrypt20-hmac for dracut-fips (bsc#1216059)
* Fri Sep  8 2023 antonio.feijoo@suse.com
- Update to version 059+suse.497.g6a2c5f83:
  * chore(suse): fix systemd-sysvinit dependency (bsc#1215132)
* Wed Aug 23 2023 antonio.feijoo@suse.com
- Update to version 059+suse.495.g55462f85:
  * chore(suse): fix invalid license
* Wed Aug 23 2023 antonio.feijoo@suse.com
- Update to version 059+suse.494.g2ed56105:
  Update to current upstream version (059+backports) (jsc#PED-4884)
  Upstream backports not included in 059:
  Features:
  * feat(network-wicked): remove module
  * feat(systemd-rfkill): remove module
  * feat(livenet): add memory size check depending on live image size
  * feat(nvmf): add code for parsing the NBFT
  * chore(shfmt): update to pass with shfmt v3.5.1
  * feat(dracut-init.sh): do not print by default if an udev rule is skipped
  * feat(lsinitrd): notify user on missing compressor
  * feat(dracut): use log level indicator in console output
  * feat(kernel-modules): driver support for macbook keyboards
  * feat(dracut-init.sh): specify if a module cannot be found or cannot be installed
  Fixes:
  * fix(dracut-install): protect against broken links pointing to themselves
  * fix(dracut.sh): exit if resolving executable dependencies fails (bsc#1214081)
  * fix(systemd-udevd): add missing override paths
  * fix(systemd-journald): add systemd-sysusers dependency
  * fix(base): correct handling of quiet in loginit
  * fix(integrity): do not require ls
  * fix(dracut-init.sh): `module_check` method ignores `forced` option
  * fix(man): add missing initrd-root-device.target to flow chart
  * fix(dracut-init.sh): use the local _ret variable
  * chore(suse): require gawk instead of awk
  * fix(dracut.sh): use gawk for strtonum
  * fix(man): remove duplicate entry
  * fix(systemd-sysext): handle confexts and correct extensions search path
  * fix(modsign): load keys to correct keyring
  * fix(dmsquash-live-autooverlay): specify filesystemtype when it is already known
  * fix(fs-lib): remove quoting form the first argument of the e2fsck call
  * fix(Makefile): remove leftover rpm build rules
  * fix(Makefile): no longer upload to kernel.org
  * fix(nvmf): support /etc/nvme/config.json
  * fix(install.d): respect even more kernel-install vars, plus style fixes
  * fix(install.d): respect more kernel-install env variables
  * fix(dracut.sh): also prevent fsfreeze for tmpfs
  * fix(dmsquash-live): allow other fstypes
  * fix(bluetooth): make bluetooth rules more strict
  * fix(bluetooth): add missing files
  * fix(bluetooth): include it if Appearance matches the value assigned for keyboard
  * fix(btrfs): do not require module via cmdline when --no-kernel
  * fix(btrfs): add missing cmdline function
  * fix(multipath): explicitly check if `hostonly_cmdline` is `yes`
  * fix(systemd-timedated): correct typo in override path
  * fix(systemd-resolved): correct typo in override path
  * fix(systemd-networkd): correct typos in override paths
  * fix(dracut-init.sh): correct check in `is_qemu_virtualized` function
  * fix(Makefile): execute command -v instead of which
  * fix(network-legacy): typo
  * fix(network,dbus): improve dependency checking
  * fix(systemd-pcrphase): only include systemd-pcrphase-initrd.service
  * fix(systemd-tmpfiles): do not include systemd-tmpfiles-clean.timer
  * fix(systemd-journald): do not include systemd-journal-flush.service
  * fix(systemd): do not include systemd-random-seed.service
  * fix(kernel-modules): add interconnect drivers
  * fix(dracut-lib.sh): remove successful finished initqueue scripts
  * fix(udev-rules): remove firmware.rules
  * fix(dracut.sh): silence the output of hardlinking files by default
  * fix(virtiofs): add virtio_pci kernel module to virtiofs
  * fix(dracut-systemd): rootfs-generator cannot write outside of generator dir
  * fix(dracut-systemd): check and create generator dir outside of inner function
  * fix(dracut-systemd): do not hardcode the systemd generator directory
  * fix(dracut-functions): avoid calling grep with PCRE (-P)
  * fix(dracut-initramfs-restore.sh): handle /etc/machine-id empty or uninitialized
  * fix(lsinitrd.sh): handle /etc/machine-id empty or uninitialized
  * fix(dracut.sh): handle /etc/machine-id empty or uninitialized
  * fix(systemd-networkd): add missing conf files and services
  * fix(dracut-functions.sh): convert mmcblk to the real kernel module name
  * fix(multipath): remove dependency on multipathd.socket
  * fix(99base): adjust to allow mksh as initrd shell
  * fix(base): do not quote $CLINE in the `set` command
  * fix(systemd-ac-power): correct systemd-ac-power binary path
  * fix(dracut.sh): use dynamically uefi's sections offset
  * fix(lvmthinpool-monitor): activate lvm thin pool before extend its size
  * fix(dmsquash-live): restore compatibility with earlier releases
  * fix(dracut.sh): kmoddir does not handle trailing /
  * fix(udev-rules): remove old eudev specific rule
  * fix(udev-rules): remove old redhat specific rule
  * fix(udev-rules): remove old edd_id extra rules
  * fix(udev-rules): remove old debian specific rules
  * fix(kernel-modules): add UFS drivers
  * fix(kernel-modules): use modalias info in get_dev_module()
  * fix(crypt): add missing libraries
  * revert(network-manager): avoid restarting NetworkManager
  * fix(dracut.sh): handle sbsign errors for UEFI builds
  * fix(dracut.sh): handle out of space error for UEFI builds
  * fix(plymouth): remove /etc/system-release dependency
  * fix(network-manager): add "After" dependency on dbus.service
  * fix(fido2): libfido2.so depends on libz.so
  * fix: make iso-scan trigger udev events
  * fix(install): do not undef _FILE_OFFSET_BITS
  * fix(dracut.sh): --sysroot option broken if global variables not set in conf
  * fix(lsinitrd.sh): handle filenames with special characters
  * fix(dracut-systemd): remove unused argument
  * fix(dracut-init.sh): correct typo in comment
  * fix(dracut.sh): correct --help and --version exit codes
  * fix(crypt-gpg): do not use always --card-status
  * fix(dmsquash-live): live:/dev/*
  * fix(load_fstype): avoid false positive searchs
  * fix: shellcheck 0.8.0
  Other:
  * refactor(install): log about missing firmware only once
  * refactor(dracut-init.sh): remove redundant "dracut" from "dracut module" prints
  * refactor(virtiofs): remove exit after die
  * build: remove rpm spec file and build rules
  * docs: remove rd.lvm.snapsize and rd.lvm.snapshot
  * chore(gentoo.conf): remove examples to avoid confusion
  * chore: remove git2spec.pl, it is no longer used
  * chore(suse): update url in spec
  Bugs between 056 and 059 not referenced yet:
  * fix(fips): add libkcapi fipscheck also with the libexec location (bsc#1207892)
  * revert(multipath): install multipathd.socket (bsc#1207524)
  * fix(dracut-initramfs-restore.sh): hide unpack errors (bsc#1199341)
  * fix(suse-initrd): always check that MACHINE_ID is not empty (bsc#1201780)
  * fix(i18n): add required includes for keymaps (bsc#1200950)
  * fix(integrity): do not enable EVM if there is no key (bsc#1200718)
  * fix(nfs): /var is not mounted during the transactional-update run (bsc#1184970)
  * fix(lvm): add missing grep requirement (bsc#1198271)
  * fix(dracut-initramfs-restore.sh): unpack uncompressed initrd as last option (bsc#1197195)
  For more details on the changes included with 056, 057, 058 and 059 see:
  * https://github.com/dracutdevs/dracut/releases/tag/059
  * https://github.com/dracutdevs/dracut/releases/tag/058
  * https://github.com/dracutdevs/dracut/releases/tag/057
  * https://github.com/dracutdevs/dracut/releases/tag/056
* Mon Jun 26 2023 antonio.feijoo@suse.com
- Update to version 055+suse.366.g14047665:
  * fix(dracut-install): continue parsing if ldd prints "cannot execute binary file" (bsc#1212662)
* Mon Jun  5 2023 antonio.feijoo@suse.com
- Update to version 055+suse.364.g4c1d0276:
  * fix(nvmf): honor rd.timeout for nvme ctrl_loss_tmo (bsc#1211080)
  * fix(nvmf): suppress pointless warning if hostname is not set (bsc#1211072)
  * fix(nvmf): set netroot=nbft (bsc#1210909)
* Wed Apr 26 2023 antonio.feijoo@suse.com
- Update to version 055+suse.360.g076f1113:
  * fix(network-legacy): handle do_dhcp calls without arguments (bsc#1210640)
  fips=1 and separate /boot break s390x (bsc#1204478):
  * fix(fips): move fips-boot script to pre-pivot
  * fix(fips): only unmount /boot if it was mounted by the fips module
  * feat(fips): add progress messages
  * fix(fips): do not blindly remove /boot
* Wed Mar 15 2023 antonio.feijoo@suse.com
- Update to version 055+suse.353.g5603b001:
  A series of changes for the NVMeoF boot with IPv6 (bsc#1209166):
  * fix(nvmf): move connect logic to initqueue script
  * fix(nvmf): don't assume prefix lenth 64 by default
  * fix(nvmf): prefix syntax for static iBFT IPv6 addresses
  * fix(network): IPv6: don't wait for RA for static IPv6 assignments
  * fix(network-legacy): always include af_packet
  * fix(network): don't assume prefix lenth 64 by default
  * fix(iscsi): prefix syntax for static iBFT IPv6 addresses
* Tue Feb  7 2023 antonio.feijoo@suse.com
- Update to version 055+suse.345.g8b8708cb:
  * feat(lvm): always include all drivers that LVM can use (bsc#1206195)
* Fri Jan 20 2023 antonio.feijoo@suse.com
- Update to version 055+suse.343.g0113f4b9:
  A series of changes for the NVMeoF boot feature (jsc#PED-1449):
  * fix(dracut.spec): require jq for nvmf
  * fix(suse/dracut.spec): require program for duplicate IP address detection
  * fix(iscsi): install 8021q module unconditionally
  * fix(nvmf): install 8021q module unconditionally
  * feat(nvmf): enable module if NBFT exists
  * feat(nvmf): add NBFT connect support, and fix configuration priority
  * feat(nvmf): add code for parsing the NBFT
  * fix(dracut.spec): require libopenssl1_1-hmac for dracut-fips (bsc#1206439)
* Tue Dec 13 2022 antonio.feijoo@suse.com
- Update to version 055+suse.333.g39325ba0:
  * feat(kernel-modules): exclude USB drivers in strict hostonly mode (bsc#1186056)
  * fix(multipath): warn if included with no multipath devices and no user conf (bsc#1069169)
  * fix(dracut.sh): improve detection of installed kernel versions (bsc#1205175)
  * fix(nfs): chown using rpc default group (bsc#1204929)
* Wed Nov  2 2022 antonio.feijoo@suse.com
- Update to version 055+suse.325.g6780025c:
  * fix(network-manager): always install the library plugins directory (bsc#1202014)
  * feat(dracut-init.sh): add inst_libdir_dir() helper (bsc#1202014)
  A series of fixes for NVMeoF boot (bsc#1203368):
  * fix(man): dracut.cmdline.7: clarify "rd.nvmf.discover=fc,auto"
  * fix(network): avoid double brackets around IPv6 address
  * feat(nvmf): set rd.neednet=1 if tcp records encountered
  * fix(man): dracut.cmdline(7): correct syntax for rd.nonvmf
  * fix(network): don't use same ifname multiple times
  * fix(nvmf): run cmdline hook before parse-ip-opts.sh
  * fix(nvmf): avoid calling "exit" in a cmdline hook
  * fix(nvmf): make sure "rd.nvmf.discover=fc,auto" takes precedence
  * fix(nvmf): don't use "finished" queue for autoconnect
  * fix(nvmf): don't create did-setup file
  * fix(nvmf): no need to load the nvme module
  * fix(nvmf): don't try to validate network connections in cmdline hook
  * fix(nvmf): nvme list-subsys prints the address using commas as separator
  * fix(nvmf): deprecate old nvmf cmdline options
  * fix(nvmf): set executable bit on nvmf-autoconnect.sh
* Fri Oct 14 2022 antonio.feijoo@suse.com
- Update to version 055+suse.306.g5b4feffc:
  * fix(network-legacy): misleading duplicate address detection using wicked (bsc#1201235)
  * fix(dmsquash-live): correct regression introduced with shellcheck changes (bsc#1203894)
* Thu Sep 29 2022 antonio.feijoo@suse.com
- Update to version 055+suse.300.ge878982d:
  * chore(suse): change default persistent policy (jsc#PED-1885)
  * fix(systemd): add missing modprobe@.service (bsc#1203749)
  * fix(i18n): do not fail if FONT in /etc/vconsole.conf has the file extension (bsc#1203267)
* Fri Aug  5 2022 antonio.feijoo@suse.com
- Update to version 055+suse.294.gc5bc4bb5:
  Missing network-manager module fixes (bsc#1201975):
  * fix(network-manager): avoid calling unavailable dracut-logger functions
  * fix(network-manager): skip non-directories in /sys/class/net
  * fix(network-manager): disable tty output if the console is not usable
  * fix(network-manager): show output on console only with rd.debug enabled
  * fix(network-manager): write DHCP filename option to dhcpopts file
  * fix(network-manager): ensure safe content of /tmp/dhclient."$ifname".dhcpopts
  * fix(network-manager): include nm-daemon-helper binary
  * fix(network-manager): don't pull in systemd-udev-settle
  * fix(network-manager): support teaming under NM+systemd
  * fix(network-manager): pull in network.target in nm-initrd.service
* Tue Aug  2 2022 antonio.feijoo@suse.com
- Update to version 055+suse.283.ge98ece25:
  * fix(network-manager): check for nm-initrd-generator in both /usr/{libexec,lib} (bsc#1201975)
  * fix(network-legacy): add auto timeout to wicked DHCP test (bsc#1198709)
* Fri Jun 10 2022 antonio.feijoo@suse.com
- Update to version 055+suse.279.g3b3c36b2:
  * fix(bluetooth): accept compressed firmwares in inst_multiple (bsc#1200236)
  * fix(network-legacy): support rd.net.timeout.dhcp (bsc#1200360)
  * fix(convertfs): ignore commented lines in fstab (bsc#1200251)
  * fix(integrity): do not display any error if there is no IMA certificate (bsc#1187654)
* Wed May  4 2022 antonio.feijoo@suse.com
- Update to version 055+suse.271.g70f710e4:
  * fix(nfs): /var is not mounted during the transactional-update run (bsc#1184970)
  * fix(nfs): give /run/rpcbind ownership to rpc user (bsc#1177461)
  * fix(dracut-install): copy files preserving ownership attributes (bsc#1197967)
  * fix(crypt): remove quotes from cryptsetupopts (bsc#1197635)
  * fix(lvm): restore setting LVM_MD_PV_ACTIVATED (bsc#1195604)
  * fix(iscsi): remove unneeded iscsi NOP-disable code (bsc#1196267)
  * fix(dracut-systemd): do not require vconsole-setup.service (bsc#1195508)
  * fix(bluetooth): make hostonly configuration files optional (bsc#1195047)
* Thu Apr 28 2022 antonio.feijoo@suse.com
- Update to version 055+suse.252.g4988b0bf:
  * fix(resume): do not add this module if there is no suitable swap (bsc#1198095)
  * feat(resume): improve sanity check by verifying volatile swap (bsc#1198095)
  * feat(resume): sanity check (bsc#1197192)
* Tue Apr  5 2022 antonio.feijoo@suse.com
- Update to version 055+suse.248.g92d06110:
  * fix(resume): correct call to block_is_netdevice function (bsc#1197737)
  * chore(suse): remove fipscheck requirement (bsc#1198065)
* Mon Mar 14 2022 antonio.feijoo@suse.com
- Update to version 055+suse.244.g2f624182:
  * fix(resume): only exclude this module when swap is netdev (bsc#1194915)
* Thu Mar 10 2022 antonio.feijoo@suse.com
- Update to version 055+suse.242.g76ae5ce4:
  * fix(multipath): align multipathd.service type with upstream (bsc#1196958)
  * fix(systemd-sysusers): use split systemd sysuser configs (bsc#1196223)
* Fri Feb 18 2022 antonio.feijoo@suse.com
- Update to version 055+suse.238.gacab0df5:
  * fix(cpio): correct dev_t -> rmajor/rminor mapping (bsc#1195808)
  * ci(cpio): add test_archive_dev_maj_min (bsc#1195808)
  * ci(cpio): add TempWorkDir.create_tmp_mknod helper (bsc#1195808)
* Thu Feb 17 2022 antonio.feijoo@suse.com
- Update to version 055+suse.234.gbdaf66ff:
  * fix(tpm2-tss): install SUSE specific files (bsc#1195984)
  * fix(systemd-sysusers): override systemd-sysusers.service (bsc#1195983)
* Mon Feb 14 2022 antonio.feijoo@suse.com
- Update to version 055+suse.230.g3fdde49a:
  * fix(dasd_rules): correct udev dasd rules parsing (bsc#1195309)
  * revert(lvm): remove 69-dm-lvm-metad.rules (bsc#1195604)
* Fri Jan 28 2022 antonio.feijoo@suse.com
- Update to version 055+suse.226.g44139dde:
  * fix(zfcp_rules): remove collect based udev rule creators
  * fix(dasd_rules): remove collect based udev rule creators
  * fix(kernel-modules-extra): handle zstd module extension
  * fix(ifcfg): add SUSE specific write-ifcfg file (bsc#1193518)
  * fix(dracut-functions): skip iSCSI sessions without initiatorname (bsc#1195011)
  * fix(dracut-functions.sh): ip route parsing (bsc#1195011)
  * fix(fips): missing sourcing of dracut-lib
  * fix(fips): wrong error message
  * fix(network-legacy): install only existing SUSE specific files (bsc#1194879)
  * fix(network-legacy): set dhclient as optional (bsc#1194879)
  * fix(40network): consistent use of "$gw" for gateway (bsc#1192685)
  * fix(multipathd-configure.service): drop unneeded dependencies
  * fix(multipath): check if mpathconf is available
  * fix(multipathd.service): drop dependencies on iscsi and iscsid
  * fix(multipathd.service): adapt to upstream multipath-tools unit file
  * fix(multipathd.service): remove dependency on systemd-udev-settle
  * fix(fips): avoid shellcheck warnings
  * fix(fips): get _vmname value only if it is needed
  * fix(fips.sh): respect rd.fips.skipkernel
  * fix(fips): alignment with the upstream format
* Mon Jan 17 2022 antonio.feijoo@suse.com
- Update to version 055+suse.194.gdd41932a:
  * fix(network-legacy): add wicked as an alternative to arping (bsc#1193670)
  * fix(network): add wicked as an alternative to arping (bsc#1193670)
* Mon Jan 17 2022 antonio.feijoo@suse.com
- Update to version 055+suse.191.g67eb4ea8:
  * fix(dracut-initramfs-restore.sh): add test for SUSE initrd name (bsc#1194570)
  * fix(dracut.spec): require util-linux-systemd (bsc#1194162)
  * fix(network-wicked): multiple path corrections
  * fix(drm): add privacy screen modules to the initrd (bsc#1193590)
* Fri Dec 10 2021 thomas.blume@suse.com
- Update to version 055+suse.183.g7d569585:
  * fix(dracut.spec): update usrmerged mkinitrd dir
  * fix(url-lib): improve ca-bundle detection (bsc#1175892)
* Thu Dec  9 2021 thomas.blume@suse.com
- Update to version 055+suse.179.g3cf989c2:
  * fix(cpio): write zeros instead of seek for padding and alignment (bsc#1190982)
  * fix(dracut.sh): check kernel zstd support early
  * fix(dracut.sh): check availability of configured compression
  * fix(dracut.sh): inform user about auto-selected compression method
  * fix(dracut.sh): drop pointless check for module compression method
  * chore(suse): add dracut-cpio archiver (jsc#SLE-16157)
  * ci(TEST-63-DRACUT-CPIO): kernel extraction tests for dracut-cpio
  * feat(dracut.sh): add "--enhanced-cpio" option for calling dracut-cpio
  * feat(Makefile): cargo wrapper for dracut-cpio build
  * feat(cpio): add newc archive creation utility
  * feat(cpio): add rust argument parsing library from crosvm
  * ci(TEST-62-SKIPCPIO): add simple skipcpio test
  * ci(test): export basedir and testdir as absolute paths
  * ci(TEST-60-BONDBRIDGEVLANIFCFG): use toplevel Makefile
  * fix(dracut.spec): check for non-usrmerged environments
  * fix(zfcp_rules): add quotes around rule installation argument
  * fix(zipl): correct argument for uuid to device conversion
  * fix(fips): missing value of _vmname variable (bsc#1193267)
  * chore(suse): add fido2 module (jsc#SLE-21070)
  * feat(crypt): check if fido2 module is needed in hostonly mode (jsc#SLE-21070)
  * feat(fido2): introducing the fido2 module (jsc#SLE-21070)
  * feat(crypt): check if tpm2-tss module is needed in hostonly mode (jsc#SLE-21070)
  * fix(dracut-functions.sh): get block device driver if in a virtual subsystem (bsc#1189776)
  * fix(mdraid): allow UUID comparison for more than one UUID (bsc#1192665)
* Mon Nov 22 2021 thomas.blume@suse.com
- Update to version 055+suse.148.g65e8258f:
  * fix(dracut.spec): update dependency for suse-module-tools
* Mon Nov 22 2021 thomas.blume@suse.com
- Update to version 055+suse.146.g71f186fa:
  * fix(network-legacy): route parsing issues in ifup (bsc#1182688)
  * fix(systemd-udevd): make collect optional (bsc#1177870)
  * style(dracut.sh): remove redundant script header
  * fix(dracut.sh): change misspelled variable name
  * fix(dracut.sh): remove wrong $ in loop sequence
  * chore(suse): update spec
  * fix(90kernel-modules): add isp1760 USB controller
  * fix(iscsi): add support for the new iscsiadm "no-wait" (-W) command
    (bsc#1187190)
  * ci(suse.conf.example): optimal compression parameters for zstd
  * feat(dracut.sh): check if target kernel has zstd support compiled in
  * ci(suse.conf.example): change default compression option for SUSE
* Wed Oct  6 2021 antonio.feijoo@suse.com
- Update to version 055+suse.129.g7d8c3ce3:
  * fix(kernel-modules): add blk_mq_alloc_disk and blk_cleanup_disk to blockfuncs (bsc#1190326)
  * docs: update SUSE maintainers doc
  * fix(suse): add 60-io-scheduler.rules (bsc#1188713)
  * revert: remove /sbin/installkernel script from dracut package
  * spec: modernize specfile constructs
* Thu Sep 30 2021 antonio.feijoo@suse.com
- Update to version 055+suse.119.g6c4187af:
  * fix(suse-initrd): handle cases with zero modprobe.d files (bsc#1189895)
* Mon Aug 16 2021 lnussel@suse.de
- Update to version 055+suse.117.ge5fc2048:
  * fix(suse-initrd): need to handle relative links too
* Thu Aug 12 2021 lnussel@suse.de
- Update to version 055+suse.115.gf65e559b:
  * fix(suse-initrd): find links of usrmerged kernels (boo#1184804)
  * fix(tpm2-tss): typo in depends()
  * fix(suse-initrd): inform on usage of obsolete -f parameter (bsc#1187470)
- use manual mode in _service file
* Mon Jun 28 2021 thomas.blume@suse.com
- Update to version 055+suse.110.gbe35f166:
  * fix(fips-suse): fipscheck doesn't need the -c parameter (bsc#1187498)
  * fix(kernel-install): initrd vs initramfs
* Thu Jun 17 2021 thomas.blume@suse.com
- Update to version 055+suse.106.g760b0c69:
  * chore(suse): add Conflicts for old suse-module-tools to specfile (bsc#1187115)
* Thu Jun 17 2021 thomas.blume@suse.com
- Update to version 055+suse.104.g9d45c1df:
  * feat(suse-initrd): add INITRD_MODULES from /etc/sysconfig/kernel, too
  * fix(suse-initrd): call dracut_instmods with hostonly=
  * fix(suse-initrd): use $kernel rather than $(uname -r)
* Mon Jun 14 2021 thomas.blume@suse.com
- Update to version 055+suse.100.ga2700279:
  * fix(suse-initrd): remove references to INITRD_MODULES (bsc#1187115)
  * chore(suse): erase conditional for usrmerge from specfile
  * chore(suse): fix specfile for usrmerge
* Mon May 31 2021 thomas.blume@suse.com
- Update to version 055+suse.97.gb98506b2:
  * docs: update NEWS.md and AUTHORS
  * fix(fs-lib): install fsck utilities
  * fix(integrity): require ALLOW_METADATA_WRITES to come from EVM config file
  * fix(install): configure logging earlier
  * fix(warpclock): minor cleanups
  * fix(dash): minor cleanups
  * fix(mksh): minor cleanups
  * feat(install): add default value for --firmwaredirs
  * fix(dracut-functions): get_maj_min without get_maj_min_cache_file set
  * fix(dracut): pipe hardlink output to `dinfo`
  * fix(install): sane default --kerneldir
  * fix(bash): minor cleanups
  * fix(squash): don't mount the mount points if already mounted
  * ci: add shfmt to Fedora containers
  * fix(base): add missing `str_replace` to `dracut-dev-lib.sh`
  * feat(dracut.sh): detect running in a container
  * fix(base): split out `dracut-dev-lib.sh`
  * fix(dracut-util): print error message with trailing newline
  * fix(packit): downstream has renamed the master branch to main
* Mon May 31 2021 thomas.blume@suse.com
- Update to version 054+suse.96.gb5aa64d2:
  * fix(suse-initrd) fix list of modprobe.d directories
  * fix(suse-initrd): exclude modules that are built-in (bsc#1185646)
  * fix(systemd-coredump): shellcheck for modules.d/01systemd-coredump
    (bsc#1190845)
* Tue May 18 2021 daniel.molkentin@suse.com
- Update to version 054+suse.95.gd5820102:
  * chore(suse) update spec
    Important change on mkinitrd:
    mkinitrd is now in its own subpackage "dracut-mkinit-deprecated",
    which requires dracut. If you need mkinitrd, require "mkinitrd".
    However note that in the long run, mkinit will go away. It is
    preferred to call dracut directly.
* Mon May 17 2021 daniel.molkentin@suse.com
- Update to version 054+suse.94.g1648453e:
  * chore(suse): re-add SUSE mkinitrd
* Mon May 17 2021 daniel.molkentin@suse.com
- Update to version 054+suse.93.gd393f006:
  With this release dracut has undergone a major overhaul.
  A lot of systemd related modules have been added.
  The integration test suite has finally ironed out the flaky behaviour due to the parallel device probing of the kernel,
  which bit sometimes in the non-kvm github CI. So, if you see any /dev/sda in a setup script with more than two hard drives,
  chances are, that the script works on the wrong disk. Same goes for network interfaces.
  This release is also fully shellcheck'ed with ShellCheck-0.7.2 and indented with shfmt and astyle.
  The dracut project builds test containers every day for:
    opensuse/tumbleweed-dnf:latest
    archlinux:latest
    fedora:rawhide
    fedora:latest
    fedora:33
  These containers can easily be used to run the integration tests locally without root permissions via podman.
  We hope this serves as a blueprint for your distribution's CI process.
  More information can be found in docs/HACKING.md.
  Bug Fixes
    make testsuite pass on OpenSuse and Arch (8b2afb08)
    cope with distributions with /usr/etc files (3ad3b3a4)
    deprecate gummiboot (5c94cf41)
    set vimrc and emacs indention according to .editorconfig (9012f399)
    correctly handle kernel parameters (501d82f7)
    remove dracut.pc on make clean (d643156d)
    honor KVERSION environment in the Makefile (d8a454a5)
    always use mkdir -p (9cf7b1c5)
    dracut.sh:
    prevent symbolic links containing // (de0c0872)
    adding missing globalvars for udev (f35d479d)
    sysctl global variables (3ca9aa1d)
    add global vars for modules-load (ec4539c6)
    omission is an addition to other omissions in conf files (96c31333)
    harden dracut against GZIP environment variable (d8e47e20)
    add a missing tmpfilesconfdir global variable (8849dd8d)
    include modules.builtin.alias in the initramfs (7f633747)
    install all depmod relevant configuration files (50a01dd4)
    add modules.builtin.modinfo to the initramfs (87c4c178)
    search for btrfs devices from actual mount poiont (3fdc734a)
    dracut-functions.sh:
    implement a cache for get_maj_min (c3bb9d18)
    word splitting issue for sed in get_ucode_file (122657b2)
    dracut-logger.sh: double dash trigger unknown logger warnings during run (4fbccde5)
    dracut-install:
    handle $LIB in ldd output parsing (bsc#1185615)
    handle builtin modules (2536a9ea)
    base:
    suppress calls to getarg in build phase (6feaaabc)
    source hooks without exec (8059bcb2)
    wait_for_dev quote shell variables (b800edd6)
    adding crc32c for ext3 (61f45643)
    crypt:
    install all crypto modules in the generic initrd (10f9e569)
    include cryptsetups tmpfile (a4cc1964)
    crypt-gpg:
    cope with different scdaemon location (44fd1c13)
    dbus-broker:
    enable the service (df1e5f06)
    dbus-daemon:
    only error out in install() (ae4fbb3d)
    dracut-systemd:
    don't refuse root=tmpfs when systemd is used (a96900a8)
    examples: remove the examples directory and reference to it (b37c90c8)
    fips:
    add dh and ecdh ciphers (543b8014)
    remove old udev version requirements (be30d987)
    i18n:
    skip if data is missing (651fe01e)
    img-lib:
    ignored null byte in input (85eb9680)
    integrity:
    properly set up EVM when using an x509 cert (4bdd7eb2)
    iscsi:
    replace sed call with bash internals (66b920c6)
    add iscsid.service requirements (bb6770f1)
    only rely on socket activiation (0eb87d78)
    kernel-modules:
    optionally add /usr/lib/modules.d to initramfs (92e6a8f8)
    add watchdog drivers for generic initrd (3a60c036)
    mdraid:
    remove dependency statements (86b75634)
    memstrack:
    correct dependencies (c2ecc4d1)
    multipath:
    stop multipath before udev db cleanup (3c244c7c)
    revise multipathd-stop (7b8c78ff)
    nbd:
    assume nbd version >= 3.8 (6209edeb)
    remove old udev version requirements (fd15dbad)
    make nbd work again with systemd (77906443)
    network:
    use wicked unit instead of find_binary (57eefcf7)
    user variable for sdnetworkd instead of path (4982e16d)
    correct regression in iface_has_carrier (36af0518)
    network-legacy:
    add missing options to dhclient.conf (abfd547a)
    silence getargs (60a34d8b)
    network-manager:
    cope with distributions not using libexec (22d6863e)
    set timeout via command line option (8a51ee1f)
    run after dracut-cmdline (4d03404f)
    create /run directories (49b61496)
    use /run/NetworkManager/initrd/neednet in initqueue (6a37c6f6)
    only run NetworkManager if rd.neednet=1 (ac0e8f7d)
    nm-run.service: don't kill forked processes (1f21fac6)
    no default deps for nm-run.service (ba4bcf5f)
    nm-lib.sh does not require bash (3402142e)
    squash:
    post install should be the last step before stripping (8c8aecdc)
    systemd:
    include all nss libraries (b3bbf5fb)
    include hosts and nsswitch.conf in hostonly mode (5912f4fb)
    remove old systemd version requirements (fc53987b)
    systemd-hostnamed: extra quote (2aa65234)
    systemd-modules: remove dependency on systemd meta module (afef4557)
    systemd-modules-load:
    misc repairs (782ac8f1)
    systemd-networkd:
    make systemd-networkd a proper network provider (ea779750, closes #737)
    systemd-resolved: remove nss libraries (12bef83c)
    systemd-sysctl:
    sysctl global variables (02acedd0)
    systemd-sysusers:
    misc fixes and cleanup (7359ba8a)
    systemd-udev: use global vars instead of fixed path (fd883a58)
    systemd-udevd: add udev id program files (562cb77b)
    systemd-verity:
    incorrect reference to cryptsetup target (ba92d1fc)
    re-naming module to veritysetup (0267f3c3)
    tpm2-tss: add tpm2 requirement (8f99fada)
    udev-rules:
    remove sourcing of network link files (69f4e7cd)
    add btrfs udev rules by default (567c4557)
    url-lib:
    fix passing args (5f6be515)
    zipl:
    don't depend on grub2 (6b499ec1)
  Performance
    disable initrd compression when squash module is enabled (7c0bc0b2)
  Features
    support ZSTD-compressed kernel modules (ce9af251)
    also restore the initramfs from /lib/modules (33e27fab)
    extend Makefile indent target (e0a0fa61)
    customize .editorconfig according to shfmt (1f621aba)
    squash module follow --compress option (5d05ffbd)
    bluetooth: implement bluetooth support in initrd (64ee2a53)
    btrfs: add 64-btrfs-dm.rules rules (d4caa86a)
    mkinitrd: remove mkinitrd (43df4ee2)
    nbd: support ipv6 link local nbds (b12f8188)
    network-manager: run as daemon with D-Bus (112f03f9)
    qemu: include the virtio_mem kernel module (f3dcb606)
    skipcpio: speed up and harden skipcpio (63033495)
    squash:
    use busybox for early setup if available (90f269f6)
    install and depmod modules seperately (5a18b24a)
    systemd-ac-power: introducing the systemd-ac-power module (e7407230)
    systemd-hostnamed: introducing the systemd-hostnamed module (bf273e3e)
    systemd-initrd: add initrd-usr-fs.target (5eb73610)
    systemd-journald: introducing the systemd-journald module (3697891b)
    systemd-ldconfig: introducing the systemd-ldconfig module (563c434e)
    systemd-network-management: introducing systemd-network-management module (e942d86c)
    systemd-resolved: introducing the systemd-resolved module (b7d3caef)
    systemd-rfkill: introducing the systemd-rfkill module (21536544)
    systemd-sysext: introducing the systemd-sysext module (fc88af54)
    systemd-timedated: introducing the systemd-timedated module (1c41cc90)
    systemd-timesyncd: introducing the systemd-timesyncd module (2257d545)
    systemd-tmpfiles: introducing the systemd-tmpfiles module (2b61be32)
    systemd-udevd: introducing the systemd-udevd module (3534789c)
    systemd-verity: introducing the systemd-verity module (3d4dea58)
    tpm2-tss: introducing the tpm2-tss module (8743b073)
* Wed Mar  3 2021 daniel.molkentin@suse.com
- Update to version 053+suse.93.g039ac07d:
  * fix(kernel-modules): optionally add /usr/lib/modules.d to initramfs
* Wed Mar  3 2021 daniel.molkentin@suse.com
- Update to version 053+suse.91.g4a0bdda1:
  * fix(kernel-modules): optionally add /usr/lib/modules.d to initramfs (bsc#1180822)
* Tue Feb 23 2021 daniel.molkentin@suse.com
- Update to version 053+suse.90.gb89b6347:
  Highlights: https://github.com/dracutdevs/dracut/releases/tag/053
  dracut.sh:
    unfreeze /boot on exit (d87ae137)
    proper return code for inst_multiple in dracut-init.sh (d437970c)
  fcoe:
    rename rd.nofcoe to rd.fcoe (6f7823bc)
    rd.nofcoe=0 should disable fcoe (805b46c2)
  i18n:
    get rid of eval calls (5387ed24), backported for 052 downstream
    create the keyboard symlinks again (9e1c7f3d), backported for 052 downstream
  network-manager:
    run as a service if systemd module is present (c17c5b76)
    rework how NM is started in debug mode (34c73b33)
    drm: skip empty modalias files in drm module setup (c3f24184)
* Wed Feb 17 2021 daniel.molkentin@suse.com
- Update to version 052+suse.93.g7bfaa6d9:
  * fix(dbus-daemon): make sure that dbus.socket is stopped before switch root (bsc#1181167)
* Wed Feb 17 2021 daniel.molkentin@suse.com
- Update to version 052+suse.91.gb30dce3c:
  * chore: update suse/dracut.spec
* Wed Feb 17 2021 daniel.molkentin@suse.com
- Update to version 052+suse.88.gc78b4ac8:
  Highlights: https://github.com/dracutdevs/dracut/releases/tag/052
  * fix(i18n): get rid of `eval` calls
  * fix(i18n): create the keyboard symlinks again
  * docs: update NEWS.md and AUTHORS
  * chore: add `CONTRIBUTORS` target to Makefile
  * fix: shellcheck across multiple modules
  * docs: fix dracut.cmdline.7
  * fix: update dbus module directory in spec file
  * fix: add sdaskpw and sdsyctl to spec file
  * fix: cosmetic comment fixes
  * feat(systemd-ask-password): introducing systemd-ask-password module
  * Revert "nbd: use systemd-run to start nbd-client"
  * dmsquash-live-root: squashfs in bare device
  * feat(systemd-sysctl): introducing systemd-sysctl module
  * fix: adding missing efi paths
  * fix: correct the squash quirk
  * feat(systemd-modules-load): introducing systemd-modules-load module
  * fix(shutdown): add timeout to umount calls (bsc#1178219)
  * fix: revise all module checks
  * fix: add missing line continuation
  * fix: BuildRequiring git-core is enough in dracut.spec
  * fix(kernel-modules): add reset controllers for arm (bsc#1180336)
  * 35network-legacy: discard pointless RTNETLINK message
  * fix(plymouth): install binaries with dependencies
  * fix: correct the line continuation
  * fix(dbus-daemon): use uid/gid from sysroot is dracutsysrootdir is set
  * fix(network-manager): allow override network manager version
  * feat(dracut.sh): allow overriding the systemctl command for sysroot
  * fix: use find_binary
  * fix(dracut.sh): don't override path with foreign sysroot
  * fix: quote globbing in module-setup.sh for inst_multiple
  * fix(dracut-install): allow globbing for multiple sources
  * Fix bad ls parsing
  * fix: move ldconfig after library workaround
  * feat(kernel-modules): add driver memory
  * feat(systemd-repart): introducing systemd-repart module
  * feat(dbus-daemon): introducing the dbus-daemon module
  * feat(dbus-broker): introducing the dbus-broker module
  * feat(dbus): introducing a meta module for dbus
  * fix(network-legacy): silent check for leaseinfo
  * 95nfs: fix rpc.statd installation
  * fix: do not set cmdline for uefi images unless asked
  * feat(network-legacy): send dhcp in parallel on all devices
  * fix(mdraid): remove offroot
  * fix(mdraid): add grow continue service
  * fix(spec): add new systemd-coredump module to spec
  * fix(watchdog): replace return with echo
  * feat(systemd-coredump): introducing systemd-coredump module
  * prepare usrmerge (boo#1029961)
  * test: incr. disk size for TEST 35 ISCSI-MULTI
  * fix(skipcpio): edit skipcpio.c: strstr -> memmem
  * fix(1007): adding shared keyring mode to type unit
  * feat(systemd-sysusers): introducing systemd-sysuser module
  * feat(systemd-sysusers): introducing systemd-sysuser module
  * fix(1001): use efivars fs over the deprecated sysfs entries
  * fix(kernel-network-modules): also install modules from mdio subdirectory
  * fix(06dbus): do not hardcode path to dbus utils
  * fix(06dbus): do not hardcode path to systemd unit
  * fix(dracut-init.sh): make inst_libdir_file work with dracutsysrootdir set
  * fix(99squash): use kernel config instead of modprobe to check modules
  * fix(dracut-functions.sh): check kernel config from $dracutsysrootdir
  * fix(90kernel-modules): install generic crypto modules with hostonly unset
  * feat: add addional global variables
  * fix: add a missing efi support
  * chore(removal): eliminate bootchart module
  * feat: add addional global variables
  * feat(cli): add --no-uefi option
  * chore(github): add CODEOWNERS file
  * chore(cleanup): remove logrotate file
  * fix(35network-manager): avoid restarting NetworkManager
  * chore: Add configuration for vim
  * chore: Add editorconfig
  * chore: Editors
  * test(conventional): add Conventional Commits PR github action
  * docs(development): add HACKING.md
* Tue Feb  2 2021 daniel.molkentin@suse.com
- Update to version 051+suse.85.g04886430:
  * prepare usrmerge (boo#1029961)
* Mon Dec 14 2020 daniel.molkentin@suse.com
- Update to version 051 (051+suse.84.gc6bd70b8):
  * suse.spec: add 051 modules dbus, wicked
  * Update AUTHORS, NEWS
  * Drop 51-dracut-rescue-postinst.sh entirely
  * Revert "Retrieve service, rpc and protcol entries via getent in hostonly mode"
  * Adding stalebot file
  * Revert "Add --uefi-output for custom output filename"
  * Improve documentation of iso-scan/filename feature
  * multipathd: fix the comparison
  * 06dbus: consider dbus-broker
  * 06dbus: Add busctl as a more useful tool
  * 06dbus: Include dbus or messagebus group and user, depending on distro
  * 35network-wicked: openSUSE Factory has reintroduced libexec
  * 35network-wicked: install ip utility anyway
  * 35network-wicked: Run wicked early enough to unlock block devices
  * 06dbus: Do not install superfluous services
  * 40network: introduce wicked option
  * 35network-wicked: introduce wicked support module
  * 06dbus: introduce dbus support
  * Add --uefi-output for custom output filename
  * 95fcoe: don't install if there is no FCoE hostonly devices
  * 95fcoe: ensure needed modules are installed
  * dracut-install: Globbing support for resolving "firmware:"
  * dracut-bash-completion.sh: add positional argument completion
  * Prevent creating unexpected files on the host when running dracut (bsc#1176171)
  * configure: Find FTS library with --as-needed
* Sat Nov 14 2020 daniel.molkentin@suse.com
- Update to version 050+suse.275.gc9639522:
  * Don't print when a module is explicitly omitted (by default)
  * 95nfs: /var/lib/nfs/statd/sm is /var/lib/nfs/sm on SUSE (boo#1177462) (bsc#1184970)
  * Retrieve service, rpc and protcol entries via getent in hostonly mode (boo#1177461)
  * Remove uses of bash (and bash specific syntax) in runtime scripts
  * 90crypt: pull in remote-cryptsetup.target enablement
  * 90multipath: install kpartx's 11-dm-parts.rules
  * Revert "90crypt: ship initrd-cryptsetup.target"
  * 90qemu-net: install less module for strict hostonly mode
  * 90qemu-net: in hostonly mode, only install if network is needed
  * 95nfs: Install less module if hostonly mode is strict
  * 90kernel-modules: Install less modules for hostonly mode
  * 90kernel-modules: install block drivers more strictly
  * 04watchdog-modules: Simplify install_kernel using new added helper
  * dracut-init.sh: Add a helper for detect device kernel modules
  * dracut-functions.sh: Fix check_block_and_slaves_all
  * 90kernel-network-modules: Don't install iscsi related module
  * Add a --hostonly-nics option
  * Configure the runner for team interfaces
  * 99squash: Check require module earlier, and properly
  * dracut-functions: add a helper to check if kernel module is available
  * 90crypt: ship initrd-cryptsetup.target
  * Revert "90crypt: pull in remote-cryptsetup.target enablement"
  * dmsquash-live/iso-scan: Provide an easy reference to iso-scan device.
  * 99memstrack: use /bin/bash
  * modules.d: fix udev rules detection of multipath devices (bsc#bsc#1171370)
  * 95fcoe: load 'libfcoe' module as a fallback (bsc#1173560)
  * 99base: enable the initqueue in both 'dracut --add-device' and 'dracut --mount' cases.
    (bsc#bsc#1161573)
  * 90kernel-modules-extra: don't resolve symlinks before instmod (bsc#1185277)
  * fcoe/fcoe-genrules.sh: use $name instead of $env{INTERFACE} (bsc#1186260)
* Tue Oct 13 2020 daniel.molkentin@suse.com
- Update to version 050+suse.250.ge6b6e843:
  * Revert "Revert "install: also install post weak dependencies of kernel modules""
  * 98dracut-systemd: don't wait for root device if remote cryptsetup active
  * cryptroot-ask: unify /etc/crypttab and rd.luks.key
  * 90kernel-modules: arm: add drivers/hwmon for arm/arm64
  * rootfs-block: only write root argument for block device
  * 90crypt: pull in remote-cryptsetup.target enablement
  * 00systemd: add missing cryptsetup-related targets (bsc#1177811)
  * 95nvmf: Implement 'fc,auto' commandline syntax (bsc#1142248)
  * 95nvmf: add nvmf-autoconnect script
  * 95nvmf: Fixup FC connections
  * 95nvmf: add documentation
  * 95nvmf: rework parameter handling
  * dracut-install: fix edge-case regression with weak modules
  * dracut-install: ignore bogus preload libs
  * dracut.spec: Use make macros
  * dracut.spec: remove fedora pre 30 quirks
  * 50drm: Check drm_encoder_init along drm_crtc_init
  * 50drm: Include drm platform drivers in hostonly
  * 50drm: fix ambiguous redirects
  * Include devfreq drivers in initrd
  * dracut.spec: include the 04watchdog-modules module
* Mon Oct 12 2020 daniel.molkentin@suse.com
- Update to version 050+suse.228.gd0d6792d:
  * 99memstrack: use /bin/bash
* Mon Sep 28 2020 daniel.molkentin@suse.com
- Update to version 050+suse.227.g7a9b782d:
  * Revert "install: also install post weak dependencies of kernel modules" (boo#1177016)
* Mon Sep 21 2020 daniel.molkentin@suse.com
- Update to version 050+suse.226.gb86d9bcf:
  We are now tracking the master branch, preparing for a 051 release
  within the next weeks.
  (the list includes changes previously backported)
  * 01fips: modprobe failures during manual module loading is not fatal
  * 01fips: turn info calls into fips_info calls (bsc#1164076)
  * 04watchdog: split the watchdog module install
  * 35network-legacy: simplify fallback dhcp setup
  * 51-dracut-rescue.install: Don't use BLS fragment shipped by kernel package
  * 90crypt: make `rd.luks.key` usable with encrypted keydev.
  * 90crypt/module-setup.sh: try to catch kernel config changes
  * 90kernel-modules: add pci_hyperv
  * 90kernel-modules/module-setup.sh: add sg kernel module
  * 90kernel-modules: remove nfit from static module list
  * 90lvm: do not add newline to cmdline
  * 90nvdimm: include nvdimm keys in initrd
  * 90ppcmac: respect DRACUT_ARCH, don't exclude ppcle
  * 91zipl: parse-zipl.sh: honor SYSTEMD_READY
  * 95cifs: install new softdeps (sha512, gcm, ccm, aead2)
  * 95cifs: pass rootflags to mount
  * 95dcssblk: fix script permissions
  * 95fcoe: default rd.nofcoe to false
  * 95iscsi: fix ipv6 target discovery
  * 95iscsi: fix missing space when compiling cmdline args
  * 95iscsi: use ip_params_for_remote_addr()
  * 95nfs: only install rpc services for NFS < 4 when hostonly is strict
  * 95nfs: use ip_params_for_remote_addr()
  * 95nvmf: add module for NVMe-oF (jsc#ECO-3063)
  * 95nvmf: add NVMe over TCP support
  * 95nvmf: fix typo in the example documentation
  * 95resume: Do not resume on iSCSI, FCoE or NBD
  * 95zfcp_rules/parse-zfcp.sh: remove rule existence check
  * 95znet: Add a rd.znet_ifname= option
  * 99base: Remove duplicate nfsroot_to_var from dracut-lib.sh
  * 99memstrack: hook script should not call exit
  * 99memstrack: Only start tracking service when rd.memdebug=4|5
  * 99squash: Don't hardcode the squash sub directories
  * 99squash: improve pre-requirements check
  * 99squash: simplify the code
  * Add 99memstrack module
  * Adding a bug report template
  * Adding a feature request template
  * Adding a pull request template
  * Adding code of conduct
  * Adding documentation template
  * Adding security policy
  * Adding the labels file for master
  * Adding the labels file for the RHEL-6 branch
  * Adding the labels file for the RHEL-7 branch
  * Adding the labels file for the RHEL-8 branch
  * Adding the labels trigger file for the Master branch
  * Adding the labels trigger file for the RHEL-6 branch
  * Adding the labels trigger file for the RHEL-7 branch
  * Adding the labels trigger file for the RHEL-8 branch
  * Add module "90nvdimm" for NVDIMM support
  * Add --version to man page
  * Allow $DRACUT_INSTALL to be not an absolute path
  * Always pull in machinery to read ifcfg files
  * As of v246 of systemd "syslog" and "syslog-console" switches have been deprecated (bsc#1180119)
  * btrfs: force preload btrfs module
  * busybox: simplify listing of supported utilities
  * Change the order of NFS servers during the boot NFS server provided by DHCP in next-server option has higher priority than DHCP-server itself
  * CI: remove Fedora 30, add Fedora 32
  * cms: regenerate NetworkManager connections
  * cryptroot-ask: no warn if /run/cryptsetup exist
  * dasd: only install /etc/dasd.conf if present
  * dhclient-script: Fix typo in output of  BOUND & BOUND6 cases
  * dmsquash-live-root: Remove obsolete osmin.img processing.
  * Document initqueue/online hook
  * Do not start inside container
  * don't prefer $TMPDIR over --tmpdir
  * dracut.cmdline.7.asc: clarify usage of `rd.lvm.vg` and `rd.lvm.lv`
  * dracut.cmdline.7.asc: fix typo
  * dracut.conf.5.asc: document how to config --no-compress in the config
  * dracut-functions: add ip_params_for_remote_addr() helper
  * dracut-functions: fix find_binary() to return full path
  * dracut-initqueue: Print more useful info in case of timeout
  * dracut-lib.sh: quote variables in parameter expansion patterns
  * dracut.modules.7.asc: fix another typo
  * dracut.modules.7.asc: fix reference to insmodpost module (bsc#1187774)
  * dracut.sh: add check for invalid configuration files
  * dracut.sh: Add --version
  * dracut.sh: don't call fsfreeze on subvol of root file system
  * dracut.sh: FIPS workaround for openssl-libs on Fedora/RHEL (bsc#1178217)
  * dracut.sh: fix early microcode detection logic
  * dracut.sh: fix errors pointed out by shellcheck.
  * dracut.sh: fix ia32 detection for uefi executables
  * dracut.sh: fix some indentation.
  * dracut.sh: Move the library workaround after squash
  * dracut.spec: add 90nvdimm
  * dracut.spec: add version check for deprecated files
  * Fix CI badges in README.md and fix dracut description
  * Fix CoC URL
  * fix graphics startup failure with the rhgb paramter in CentOS8.2
  * Fix pre-trigger stage by replacing exit with return in lldpad.sh
  * Fix test in lsinitrd
  * Fix Unicode
  * Fix Unicode and dracut install labeler
  * github actions: use test container directly
  * .github: fix path to label workflow mapping file
  * i18n: Always install /etc/vconsole.conf
  * install: also install post weak dependencies of kernel modules
  * Install crypto modules in 90kernel-modules
  * install dependant libs too
  * lvm: fix removal of pvscan from udev rules
  * lvm: remove unnecessary ${initdir} from lvm_scan.sh
  * Make externally defined CFLAGS work
  * Makefile: fix VERSION again
  * Makefile: merge main-version and git-version earlier
  * Makefile: really make externally defined CFLAGS work
  * match simplified rd.zfcp format too
  * match the whole string
  * mkinitrd-dracut.sh: use vmlinux regex for ppc*, vmlinuz for i686
  * mkinitrd-suse.sh: Fix i586 platform detection
  * mount-root.sh: fix writing fstab file with missing fsck flag
  * multipath: add automatic configuration for multipath
  * net-lib.sh: support infiniband network mac addresses
  * network: fix glob matching ipv6 addresses
  * network-manager: ensure that nm-run.sh is executed when needed
  * network-manager: install libnss DNS and mDNS plugins
  * network-manager: move connection generation to a lib file
  * network-manager: set kernel hostname from the command line
  * New labels file
  * New label trigger file
  * README.md: fix github action badge links
  * Remove cleanup_trace_mem calls
  * Remove memtrace-ko and rd.memdebug=4 support in dracut
  * Remove stratis module
  * Removing dracut entry not compat with new plugin
  * Switching label triggers from pull requests to cron
  * systemd: skip dependency add for non-existent units
  * TEST-03-USR-MOUNT/test.sh: increase loglevel
  * TEST-12-RAID-DEG/create-root.sh: more udevadm settle
  * TEST-41-NBD-NM/Makefile: should be based on TEST-40-NBD not TEST-20-NFS
  * TEST-99: exclude /etc/dnf/* from check
  * test/TEST-35-ISCSI-MULTI: bump disk space
  * test: use dd from /dev/zero, instead of creating files with a hole
  * .travis.yml: reformat
  * UEFI Mode: only write kernel cmdline to UEFI binary
  * Update master-labels.yml
  * url-lib: drop NSS if it's not in curl --version
  * Use TMPDIR if available
* Fri Sep  4 2020 fvogt@suse.com
- Generate the tarball during buildtime. Tracking both the tarball
  and the .obscpio combines the worst of both.
* Wed Aug 19 2020 daniel.molkentin@suse.com
- Update to version 050+suse.75.g266a76d9:
  * net-lib.sh: support infiniband network mac addresses (bsc#996146)
  * 95iscsi: use ip_params_for_remote_addr() (bsc#1167494)
  * 95nfs: use ip_params_for_remote_addr() (bsc#1167494)
  * dracut-functions: add ip_params_for_remote_addr() helper (bsc#1167494)
* Thu Jul  9 2020 daniel.molkentin@suse.com
- Update to version 050+suse.71.g390f4d72:
  * 01fips: modprobe failures during manual module loading is not fatal (bsc#1169997)
  * 91zipl: parse-zipl.sh: honor SYSTEMD_READY (bsc#1165828)
  * 95iscsi: fix ipv6 target discovery (bsc#1172807)
  * 35network-legacy: correct conditional for creating did-setup file (bsc#1172807)
* Wed Jun 17 2020 daniel.molkentin@suse.com
- Update to version 050+suse.67.g28be2f36:
  * 35network-legacy: Fix dual stack setups (bsc#1172807)
* Wed Jun 10 2020 daniel.molkentin@suse.com
- Update to version 050+suse.66.g76431c83:
  * 95iscsi: fix missing space when compiling cmdline args (bsc#1172816)
* Thu Jun  4 2020 daniel.molkentin@suse.com
- Update to version 050+suse.65.ge1e64674:
  * Add wicked specific config files (bsc#1089333)
  * Run format_spec_file
* Wed May 13 2020 daniel.molkentin@suse.com
- Update to version 050+suse.63.g796e020e:
  * suse.spec: Move /bin/* and /sbin/* to /usr
  * suse.spec: Remove long unused mkinitrd_setup file
* Mon May  4 2020 daniel.molkentin@suse.com
- Update to version 050+suse.61.g0fe0e854:
  * Fix test in lsinitrd (https://progress.opensuse.org/issues/65334)
* Fri Apr 17 2020 daniel.molkentin@suse.com
- Update to version 050+suse.60.ged08acac:
  * 90nvdimm: include nvdimm keys in initrd (bsc#1161343)
  * network-legacy/net-genrules.sh: use $name instead of $env{INTERFACE} (bsc#1161438)
* Tue Apr  7 2020 daniel.molkentin@suse.com
- Update to version 050+suse.59.gc635f468:
  * mkinitrd-suse.sh: Fix i586 platform detection (boo#1168341)
* Sun Mar 22 2020 daniel.molkentin@suse.com
- Update to version 050+suse.58.g0b998bee:
  * Mark interface setup after dhcp (bsc#1167161)
  * Store nameserver received from wicked dhcp lease (bsc#1167161)
* Thu Mar 19 2020 daniel.molkentin@suse.com
- Changed scheme to 050+suse.56.gec64a6fa to match systemd package
  * Scheme pattern> <PARENT_TAG>+suse.<TAG_OFFSET>.g<SHA1>
  * No functional change
* Sat Mar 14 2020 daniel.molkentin@suse.com
- Update to version 050+git56.ec64a6fa:
  * Makefile: really make externally defined CFLAGS work
  * suse.spec: Sort new modules and files in 050 into sub packages
* Wed Mar 11 2020 daniel.molkentin@suse.com
- Update to version 049.1+git135.46dceb02:
  * 40network: Do not require hostname binary
  * suse.spec: add new modules 90nvdimm and 99suse-initrd
  * 95fcoe: default rd.nofcoe to false (bsc#1163343)
  * Add module "99suse-initrd" for parsing "SUSE INITRD" lines (bsc#1161343)
    Dependent commits:
  * Add module "90nvdimm" for NVDIMM support
  * 90kernel-modules: remove nfit from static module list
* Tue Mar 10 2020 daniel.molkentin@suse.com
- Update to version 049.1+git129.0f19bbfd:
  * 35network-legacy: dhclient is optional (bsc#1166188)
  * suse.spec: Create -extra package (bsc#1166188)
  * suse.spec: Remove obsolete permission fixups
  * 00warpclock: Fix permissions in warpclock.sh
* Tue Mar  3 2020 daniel.molkentin@suse.com
- Update to version 049.1+git125.e2b2c9ef:
  * 01fips: handle SHA1 on machines without AVX (bsc#1160318)
  * Update: 90kernel-modules: Add PCI host controller modules (boo#1162669)
* Fri Feb 21 2020 daniel.molkentin@suse.com
- Update to version 049.1+git124.70941b30:
  * 90kernel-modules: Add PCI host controller modules (boo#1162669)
* Fri Feb 21 2020 daniel.molkentin@suse.com
- Update to version 049.1+git123.c2a6645e:
  * dracut: add warning when including unsupported modules (bsc#1163055)
  * 01fips: Boot without BOOT_IMAGE being set (bsc#1161292)
  * 01fips: Use correct kernel image name for more platforms (bsc#1164076)
* Tue Feb  4 2020 daniel.molkentin@suse.com
- Update to version 049.1+git120.dbfbfcb8:
  * 95zfcp_rules/parse-zfcp.sh: remove rule existence check (bsc#1008352)
* Wed Jan 29 2020 daniel.molkentin@suse.com
- Update to version 049.1+git119.abf1a408:
  * 30convertfs: adopt for SUSE (boo#1158777)
* Tue Jan 14 2020 daniel.molkentin@suse.com
- Update to version 049+git118.a6090e2f:
  * Implement support for verifying the boot with fipscheck (bsc#1158530)
* Thu Jan  9 2020 daniel.molkentin@suse.com
- Update to version 049+git117.d3206e79:
  * Remove purge-kernels scripts and service (jsc#SLE-10162)
* Tue Dec 10 2019 daniel.molkentin@suse.com
- Update to version 049+git116.e9995c78:
  * dracut.spec: add convertfs module correctly (boo#1158777)
* Thu Nov 28 2019 daniel.molkentin@suse.com
- Update to version 049+git115.c2d8d6fb:
  * suse: Remove incorrect usage of %%_libexecdir (boo#1155785)
* Tue Oct  1 2019 daniel.molkentin@suse.com
- Update to version 049+git114.058e566c:
  * 35network-legacy: only skip waiting for interfaces if netroot is set (bsc#1152006)
  * fixup "Dracut: only login to one target at a time" (bsc#1152650)
* Mon Sep 23 2019 daniel.molkentin@suse.com
- Update to version 049+git112.fe41ccd9:
  * dracut: move /var/run and /var/lock from directory to symlink (bsc#1149103, ECO#323)
  * 35network-legacy: signalize the setup in ifup when dhcp (bsc#1146661)
  * 35network-legacy: fix typo
  * 35network-legacy: install hostname required by ifup.sh (bsc#1146661)
* Mon Aug 26 2019 daniel.molkentin@suse.com
- Update to version 049+git108.6c9d1156:
  * dracut-init.sh: Nuke unused install_kmod_with_fw function
  * dracut-install: Support the compressed firmware files correctly (boo#1146769)
  * dracut: let module handling function accept optional path option
  * dracut.sh: Fix udevdir detection
* Fri Jul 19 2019 daniel.molkentin@suse.com
- Update to version 049+git104.1244eed7:
  * mkinitrd-suse.sh: remove trailing "|"
* Thu Jul 18 2019 daniel.molkentin@suse.com
- Update to version 049+git103.c8d99b62:
  * Add support for compressed kernel modules (boo#1135854)
* Thu Jul 18 2019 daniel.molkentin@suse.com
- Update to version 049+git102.9ee0c387:
  * dracut-install: Add support for compressed firmware files (boo#1136677)
* Thu Jul 18 2019 daniel.molkentin@suse.com
- Update to version 049+git101.17c579a0:
  * call netroot on wicked dhcp setup
  * nfsroot follow ifcfg settings for boot protocol
* Thu Jul 18 2019 daniel.molkentin@suse.com
- Update to version 049+git99.76df40e7:
  * 95fcoe: Fix startup when fcoe module is included (boo#1136977)
  * tests: Ignore .testdir
  * Add support for riscv64
  * mkinitrd-suse.sh: simplify get_kernel_version (bsc#1139939)
  * 95dasd-rules & 95zfcp_rules: Look for correct rule name (bsc#1137784)
* Mon Jun 17 2019 ext-linus.larsson@se.fujitsu.com
- Update to version 049+git94.aef7a52b:
  * ucode: properly include early only ucode (bsc#1098915, bsc#1125393)
  * keep network device naming scheme on upgrade (bsc#1136927)
* Sat May 25 2019 daniel.molkentin@suse.com
- Bump to 049
- Contains fixes for bsc#1134472, bsc#1134347 and bsc#1133819
- Patches are now maintained in git
  * Removed 0012-40network-Fix-race-condition-when-wait-for-networks.patch
  * Removed 0013-40network-always-start-netroot-in-ifup.sh.patch
  * Removed 0015-40network-replace-dhclient-with-wickedd-dhcp-supplic.patch
  * Removed 0016-Add-new-s390x-specific-rule-files.patch
  * Removed 0017-45ifcfg-use-distro-specific-scripts.patch
  * Removed 0020-00warpclock-Set-correct-timezone.patch
  * Removed 0021-95dcssblk-Add-new-module-for-DCSS-block-devices.patch
  * Removed 0048-40network-Only-enable-network-interfaces-if-explicit.patch
  * Removed 0053-01fips-fixup-loading-issues.patch
  * Removed 0056-81cio_ignore-handle-cio_ignore-commandline.patch
  * Removed 0057-01fips-Include-some-more-hmacs.patch
  * Removed 0058-dracut-add-warning-when-including-unsupported-module.patch
  * Removed 0059-99suse-Add-SUSE-specific-initrd-parsing.patch
  * Removed 0060-45ifcfg-Add-SUSE-specific-write-ifcfg-file.patch
  * Removed 0061-45ifcfg-Fixup-error-message-in-write-ifcfg-suse.patch
  * Removed 0075-95dasd_rules-enable-parsing-of-rd.dasd-commandline-p.patch
  * Removed 0076-Correctly-set-cio_ignore-for-dynamic-s390-rules.patch
  * Removed 0079-95dasd_rules-fixup-rd.dasd-parsing.patch
  * Removed 0080-95dasd_rules-print-out-rd.dasd-commandline.patch
  * Removed 0081-95dasd_mod-do-not-set-module-parameters-if-dasd_cio_.patch
  * Removed 0083-95zfcp_rules-Fixup-rd.zfcp-parsing.patch
  * Removed 0085-95zfcp_rules-print-out-rd.zfcp-commandline-parameter.patch
  * Removed 0086-95zfcp_rules-Auto-generate-udev-rule-for-ipl-device.patch
  * Removed 0087-95dasd_rules-Auto-generate-udev-rule-for-ipl-device.patch
  * Removed 0088-91zipl-Add-new-module-to-update-s390x-configuration.patch
  * Removed 0089-40network-create-var-lib-wicked-in-ifup.sh.patch
  * Removed 0090-dracut-caps-Remove-whole-caps-module.patch
  * Removed 0091-dracut-biosdevname-In-SUSE-biosdevname-package-is-in.patch
  * Removed 0094-Implement-shortcut-ip-ifname-static-for-static-confi.patch
  * Removed 0107-Fixup-typo-firmare-instead-of-firmware.patch
  * Removed 0108-91zipl-Store-commandline-correctly.patch
  * Removed 0109-95dasd_rules-Store-all-devices-in-commandline.patch
  * Removed 0110-95zfcp_rules-Store-all-devices-in-commandline.patch
  * Removed 0113-91zipl-Install-script-as-executable.patch
  * Removed 0114-91zipl-Translate-ext2-3-into-ext4.patch
  * Removed 0116-Mark-scripts-as-executable.patch
  * Removed 0117-95dasd_rules-Enable-the-device-before-checking-devic.patch
  * Removed 0118-95zfcp_rules-Enable-the-device-before-checking-devic.patch
  * Removed 0121-Adjust-initramfs-kernel.img-to-SUSE-default-initrd-k.patch
  * Removed 0123-95zfcp_rules-fix-typo-in-module_setup.patch
  * Removed 0124-40network-Update-iBFT-scanning-code-to-handle-IPv6.patch
  * Removed 0125-40network-separate-mask-and-prefix.patch
  * Removed 0126-01fips-Add-drbg-module-to-force-loaded-modules.patch
  * Removed 0128-90lvm-Install-dm-snapshot-module.patch
  * Removed 0130-nfs-Always-add-all-kernel-modules-for-kdump.patch
  * Removed 0131-40network-handle-prefixed-IP-addresses-correctly.patch
  * Removed 0132-40network-fixup-static-network-configuration.patch
  * Removed 0133-Allow-multiple-configurations-per-network-interface-.patch
  * Removed 0137-Switch-from-Mozilla-NSS-sha256hmac-checking-to-fipsc.patch
  * Removed 0138-fips_add_aesni-intel.patch
  * Removed 0139-fips-kernel-4.4-fixes.patch
  * Removed 0142-40network-Don-t-report-error-for-etc-sysconfig-netwo.patch
  * Removed 0144-90crypt-Fixed-crypttab_contains-to-also-work-with-de.patch
  * Removed 0145-40network-handle-ip-ifname-static-correctly.patch
  * Removed 0150-Find-kernel-modules-in-extra-and-weak-updates-path-a.patch
  * Removed 0157-Add-boot-zipl-to-host-devs-if-it-is-a-mount-point.patch
  * Removed 0158-Add-SUSE-kernel-module-dependencies-in-etc-modprobe.patch
  * Removed 0159-network-Try-to-load-xennet.patch
  * Removed 0160-s390-update_active_devices_initrd.patch
  * Removed 0161-95zfcp_rules-simplified-rd.zfcp-commandline-for-NPIV.patch
  * Removed 0162-network-Request-DHCP-lease-instead-of-getting-applyi.patch
  * Removed 0163-Install-etc-sysconfig-console-to-see-specific-fonts.patch
  * Removed 0164-Fix-initramfs-ver.img-vs-initrd-ver-in-dracut-initra.patch
  * Removed 0168-remove_plymouth_logo_file.patch
  * Removed 0169-network_set_mtu_macaddr_for_dhcp.patch
  * Removed 0170-iscsi-skip-ibft-invalid-dhcp.patch
  * Removed 0180-i18n_add_correct_fontmaps.patch
  * Removed 0182-fix-include-parsing.patch
  * Removed 0183-fix_add_drivers_hang.patch
  * Removed 0188-95dasd_rules-Install-collect-udev-helper-binary.patch
  * Removed 0190-replace-iscsistart-with-systemd-service-files.patch
  * Removed 0191-static_network_setup_return_zero.patch
  * Removed 0192-iscsi_set_boot_protocol_from_ifcfg.patch
  * Removed 0193-95iscsi-Set-number-of-login-retries.patch
  * Removed 0196-ibft-wait-for-session-on-all-paths.patch
  * Removed 0197-95iscsi-Do-not-require-network-for-qla4xxx-flash-ses.patch
  * Removed 0198-95iscsi-set-rd.iscsi.firmware-for-qla4xxx-sessions.patch
  * Removed 0199-rd-iscsi-waitnet-default-false.patch
  * Removed 0200-dracut_fix_multipath_without_config.patch
  * Removed 0201-fix_nfs_with_ip_instead_of_hostname.patch
  * Removed 0202-dracut_dmraid_use_udev.patch
  * Removed 0203-no-fail-builtin-module.patch
  * Removed 0204-mkinitrd-fix-monster.patch
  * Removed 0205-mdraid_ignore_hostonly.patch
  * Removed 0206-nfs_dns_alias.patch
  * Removed 0207-handle_module_aliases.patch
  * Removed 0208-no_forced_virtnet.patch
  * Removed 0209-fix_modules_load_d_hostonly.patch
  * Removed 0210-add_fcoe_uefi_check.patch
  * Removed 0212-fcoe_reorder_init_path.patch
  * Removed 0213-Fix-wrong-keymap-inclusion.patch
  * Removed 0214-95fcoe-Do-not-overwrite-FCoE-configuration.patch
  * Removed 0215-95fcoe-Do-not-complain-about-missing-etc-hba.conf.patch
  * Removed 0216-95fcoe-silence-lldpad-warnings.patch
  * Removed 0217-95fcoe-Allow-to-specify-the-FCoE-mode-via-the-fcoe-p.patch
  * Removed 0218-40network-allow-persistent-interface-names.patch
  * Removed 0219-95fcoe-use-interface-names-instead-of-MAC-addresses.patch
  * Removed 0220-95fcoe-always-set-AUTO_VLAN-for-fcoemon.patch
  * Removed 0221-95fcoe-Add-shutdown-script.patch
  * Removed 0222-90dm-Fixup-shutdown-script.patch
  * Removed 0223-90dm-fixup-dependency-cycle-between-MD-and-DM-shutdo.patch
  * Removed 0224-95iscsi-setup-bnx2i-offload-connections-properly.patch
  * Removed 0225-95fcoe-do-not-start-fcoemon-twice.patch
  * Removed 0300-dracut_dont_use_dpkg_defaults_on_SUSE.patch
  * Removed 0301-include_sysconfig_language.patch
  * Removed 0302-Revert-90multipath-add-hostonly-multipath.conf-in-ca.patch
  * Removed 0303-fix_multipath_check_hostonly.patch
  * Removed 0304-90multipath-Start-daemon-after-udev-settle.patch
  * Removed 0305-90multipath-load-dm_multipath-module-during-startup.patch
  * Removed 0306-90multipath-add-shutdown-script.patch
  * Removed 0307-90multipath-parse-kernel-commandline-option-multipat.patch
  * Removed 0308-mdraid_add_IMSM_NO_PLATFORM_env.patch
  * Removed 0309-90dmraid-do-not-delete-partitions.patch
  * Removed 0310-95resume-Do-not-resume-on-iSCSI.patch
  * Removed 0311-95iscsi-ip-ibft-is-deprecated.patch
  * Removed 0312-40network-Do-not-print-message-about-tmp-net.ibft0.c.patch
  * Removed 0313-90mdraid-Use-stock-MD-rules-to-assemble-RAID-arrays.patch
  * Removed 0314-nfs_do_not_pass_ifname_for_bonding_devices.patch
  * Removed 0402-driver-fail-summary.patch
  * Removed 0403-95lunmask-Add-module-to-handle-LUN-masking.patch
  * Removed 0404-dracut-emergency-optionally-print-fs-help.patch
  * Removed 0450-Strip-NUL-bytes-in-stream-before-push-in-string.patch
  * Removed 0451-systemd-initrd-add-initrd-root-device.target.patch
  * Removed 0452-Always-try-to-add-pinctrl-cherryview.patch
  * Removed 0453-Resolve-symbolic-links-for-i-and-k-parameters-bsc-90.patch
  * Removed 0454-Add-md4-and-arc4-modules-for-ntlm.patch
  * Removed 0500-Reset-IFS-variable.patch
  * Removed 0501-dasd_fix_ssid_bigger_zero.patch
  * Removed 0502-persistent_device_policy_param_enhance.patch
  * Removed 0503-dracut.sh-create-the-initramfs-non-world-readable-al.patch
  * Removed 0504-ibft-fix-boot-flag-check.patch
  * Removed 0505-Allow-booting-from-degraded-MD-RAID-arrays.patch
  * Removed 0506-Boot-on-s390x-with-fips-1-on-the-kernel-commnad-line.patch
  * Removed 0507-Set-TaskMax-inifinite-for-the-emergency-shell.patch
  * Removed 0508-90multipath-start-before-local-fs-pre.target.patch
  * Removed 0509-01fips-Remove-zlib-module-as-requirement.patch
  * Removed 0510-01fips-Some-modules-use-separators-other-than.patch
  * Removed 0511-01fips-ensure-fips-initialization-succeeds-on-s390-x.patch
  * Removed 0512-Make-binutils-optional-when-elfutils-are-available.patch
  * Removed 0513-Fix-regression-caused-by-6f9bf2b8ac436259bdccb110545.patch
  * Removed 0514-man-make-the-k-option-clear-using-mkinitrd.patch
  * Removed 0515-90kernel-modules-also-add-block-device-driver-revers.patch
  * Removed 0516-mkinitrd-suse.sh-Fix-prefix-calculation.patch
  * Removed 0517-95fcoe-fixup-fcoe-genrules.sh-for-VN2VN-mode.patch
  * Removed 0518-90kernel-modules-Fix-backlight-on-Cherrytrail-device.patch
  * Removed 0519-90kernel-modules-Ensure-phy-drivers-are-loaded-in-in.patch
  * Removed 0520-Ignore-module-resolution-errors.patch
  * Removed 0521-Ensure-udev-persistent-storage-compat-rules-get-crea.patch
  * Removed 0522-Fix-typo-from-commit-3f1cdb520.patch
  * Removed 0523-98dracut-systemd-Fix-module-force-loading-with-syste.patch
  * Removed 0524-Suppress-nonsensical-error-message-bsc-1032029.patch
  * Removed 0525-backport-bail-out-if-module-directory-does-not-exist.patch
  * Removed 0526-iscsiroot-call-handle_firmware-only-for-non-iface-in.patch
  * Removed 0527-switch-fips-checking-to-use-the-libkcapi-based-fipsc.patch
  * Removed 0528-Ensure-dracut.sh-responds-properly-to-hostonly_cmdli.patch
  * Removed 0529-systemd-add-missing-.slice-unit.patch
  * Removed 0530-dracut-systemd-dracut-cmdline-ask-fix-dracut-kernel-.patch
  * Removed 0531-dracut-systemd-.service-conflict-with-shutdown-targe.patch
  * Removed 0532-List-drivers-rather-than-looking-for-reverse-depende.patch
  * Removed 0533-instmods-check-modules.builtin-in-srcmods.patch
  * Removed 0534-ssh-client-Include-nss_-libraries.patch
  * Removed 0535-Sync-initramfs-after-creation.patch
  * Removed 0536-90multipath-drop-67-kpartx-compat.rules.patch
  * Removed 0537-dracut-init.sh-ignore-crc32.ko-in-builtin-test.patch
  * Removed 0538-Enable-core-dumps-with-systemd-from-initrd.patch
  * Removed 0539-Add-IMA-functionality-fate-323289.patch
  * Removed 0540-Check-the-proper-variable-for-a-custom-IMA-keys-dire.patch
  * Removed 0541-Make-sure-70-persistent-net.rules-is-included-in-ini.patch
  * Removed 0542-Include-crc32c-intel-module-when-using-btrfs.patch
  * Removed 0543-Remove-00systemd-bootchart.patch
  * Removed 0544-40network-Make-ip-dhcp-work.patch
  * Removed 0545-Add-early-microcode-support-for-AMD-family-16h.patch
  * Removed 0546-Support-Microcode-Updates-for-AMD-CPU-Family-0x17.patch
  * Removed 0547-Fix-task-limit-in-emergency.service-the-same-change-.patch
  * Removed 0548-95fcoe-Switch-back-to-using-fipvlan-for-bnx2fc.patch
  * Removed 0549-fcoe-up-Increase-sleeptime-to-13s.patch
  * Removed 0550-95fcoe-add-timeout-initqueue-entries.patch
  * Removed 0551-fips-use-lib-modules-uname-r-modules.fips.patch
  * Removed 0552-98integrity-support-validating-the-IMA-policy-file-s.patch
  * Removed 0553-98integrity-support-loading-x509-into-the-trusted-bu.patch
  * Removed 0554-98integrity-support-X.509-only-EVM-configuration.patch
  * Removed 0555-Avoid-executing-emergency-hooks-twice.patch
  * Removed 0556-95qeth_rules-Add-new-module-to-copy-qeth-rules.patch
  * Removed 0557-40network-make-arping-optional.patch
  * Removed 0558-40network-remove-brctl-dependency.patch
  * Removed 0559-Add-wickedd-duid.xml-and-iaid.xml-if-available.patch
  * Removed 0560-90kernel-modules-Ensure-PCI-host-modules-are-include.patch
  * Removed 0561-Add-the-qedi-driver-to-driver-list-for-iscsi-boot.patch
  * Removed 0562-Adjust-driver-list-to-modern-kernels.patch
  * Removed 0563-40network-collapse-arping-and-dhcp-calls-into-wicked.patch
  * Removed 0564-40network-Always-set-the-gw-variable.patch
  * Removed 0565-90kernel-modules-Include-Intel-Volume-Management-Dev.patch
  * Removed 0566-95nfs-If-no-server-is-configured-read-BOOTSERVERADDR.patch
  * Removed 0567-Fix-booting-with-fips-1-on-SLES-15.patch
  * Removed 0568-95multipath-Pickup-files-in-etc-multipath-conf.d.patch
  * Removed 0569-10i18n-Load-all-keymaps-for-a-given-locale.patch
  * Removed 0570-10i18n-Fix-possible-infinite-recursion.patch
  * Removed 0571-40network-Fix-static-network-setup.patch
  * Removed 0572-lsinitrd-no-more-cat-write-error-Broken-pipe.patch
  * Removed 0573-lsinitrd.sh-quote-filename-in-extract_files.patch
  * Removed 0574-s-find_btrfs_devs-btrfs_devs.patch
  * Removed 0580-check_for_CONFIG_ACPI_TABLE_UPGRADE.patch
  * Removed 0581-kernel-modules-add-nfit.patch
  * Removed 0582-98dracut-systemd-Start-systemd-vconsole-setup-before.patch
  * Removed 0583-99base-Allow-files-with-backslashes-in-hostonly-file.patch
  * Removed 0584-95dasd_rules-mark-dasd-rules-host_only.patch
  * Removed 0585-emergency-mode-use-sulogin.patch
  * Removed 0586-95zfcp_rules-parse-zfcp.sh-remove-rule-existence-check.patch
  * Removed 0587-Fix-a-missing-space-in-example-configs.patch
  * Removed 0588-Ensure-mmc-host-modules-get-included-properly.patch
  * Removed 0589-Fix-98dracut-systemd-dracut-emergency.sh.patch
  * Removed 0590-00systemd-check-if-systemd-version-is-a-number.patch
  * Removed 0591-91zipl-Don-t-use-contents-of-commented-lines.patch
  * Removed 0592-95iscsi-handle-qedi-like-bnx2i.patch
  * Removed 0593-dracut-only-copy-xattr-if-root.patch
  * Removed 0594-Check-SUSE-kernel-module-dependencies-recursively.patch
  * Removed 0595-iscsi-don-t-continue-waiting-if-the-root-device-is-p.patch
  * Removed 0596-network-stop-waiting-for-interfaces-if-root-device-i.patch
  * Removed 0597-iscsiroot-parse_iscsi_root-overwrites-command-line-a.patch
  * Removed 0598-iscsiroot-there-s-never-more-than-one-target-per-cal.patch
  * Removed 0599-iscsiroot-try-targets-only-once.patch
  * Removed 0600-iscsiroot-remove-bashisms.patch
  * Removed 0601-base-dracut-lib.sh-dev_unit_name-guard-against-dev-b.patch
* Thu Apr 25 2019 daniel.molkentin@suse.com
- dracut-lib.sh:dev_unit_name() guard against $dev beginning with "-" (bsc#1132448)
  * adds 0601-base-dracut-lib.sh-dev_unit_name-guard-against-dev-b.patch
* Wed Apr 24 2019 daniel.molkentin@suse.com
- 95iscsi: avoid error messages when building initrd, multipath timeouts
  (bsc#1130114, bsc#1130107, bsc#1121238)
  * adds 0595-iscsi-don-t-continue-waiting-if-the-root-device-is-p.patch
  * adds 0596-network-stop-waiting-for-interfaces-if-root-device-i.patch
  * adds 0597-iscsiroot-parse_iscsi_root-overwrites-command-line-a.patch
  * adds 0598-iscsiroot-there-s-never-more-than-one-target-per-cal.patch
  * adds 0599-iscsiroot-try-targets-only-once.patch
  * adds 0600-iscsiroot-remove-bashisms.patch
* Thu Mar 14 2019 daniel.molkentin@suse.com
- Bump version to 044.2 to provide a version to lock on to (bsc#1127891)
* Mon Mar 11 2019 daniel.molkentin@suse.com
- Check SUSE kernel module dependencies recursively (bsc#1127891)
  * adds 0594-Check-SUSE-kernel-module-dependencies-recursively.patch
* Thu Feb 28 2019 msuchanek@suse.de
- Handle non-versioned dependency in purge-kernels.
* Mon Feb 25 2019 daniel.molkentin@suse.com
- purge-kernels: Avoid endless loop when uninstalling kernels that depend on
  KMPs which in themselves depend on other packages (bsc#1125327)
* Fri Feb 15 2019 daniel.molkentin@suse.com
- Avoid "Failed to chown ... Operation not permitted" when run from non-root,
  by not copying xattrs. (osc#1092178)
  * adds 0593-dracut-only-copy-xattr-if-root.patch
* Tue Feb 12 2019 daniel.molkentin@suse.com
- Correct fix for displaying text on emergency consoles (boo#1124088)
  * removes 0589-Fix-displaying-text-on-emergency-consoles.patch
  * adds 0589-Fix-98dracut-systemd-dracut-emergency.sh.patch
- 95iscsi: handle qedi like bnx2i (bsc#1113712)
  * adds 0592-95iscsi-handle-qedi-like-bnx2i.patch
* Thu Feb  7 2019 daniel.molkentin@suse.com
- 91zipl: Don't use contents of commented lines (osc#1119499)
  * adds 0591-91zipl-Don-t-use-contents-of-commented-lines.patch
* Mon Feb  4 2019 daniel.molkentin@suse.com
- Fix displaying text on emergency consoles (boo#1124088)
  - adds 0589-Fix-displaying-text-on-emergency-consoles.patch
- Fix systemd version check, will be required for systemd v241
  - 0590-00systemd-check-if-systemd-version-is-a-number.patch
* Fri Jan 25 2019 daniel.molkentin@suse.com
- Remove invalid "FONT_MAP=none" from vconsole.conf (osc#1013573)
* Mon Jan 21 2019 daniel.molkentin@suse.com
- Ensure mmc host modules get included properly (bsc#1119037)
  * adds 0588-Ensure-mmc-host-modules-get-included-properly.patch
* Sun Jan 20 2019 daniel.molkentin@suse.com
- Fix a missing space in example configs (boo#1121251)
  * adds 0587-Fix-a-missing-space-in-example-configs.patch
* Fri Dec 21 2018 msuchanek@suse.com
- 95zfcp_rules/parse-zfcp.sh: remove rule existence check (bsc#1008352).
  * adds 0586-95zfcp_rules-parse-zfcp.sh-remove-rule-existence-check.patch
* Mon Dec 17 2018 jdelvare@suse.com
- dracut-installkernel: Stop keeping old kernel files as .old
  (boo#1112327)
  The .old kernel files are confusing grub2 which can't find a
  matching directory under /lib/modules. Furthermore, there is no
  guarantee that the new modules are fully compatible with the old
  kernel.
  If anything goes wrong with a new self-compiled kernel, the user
  can always boot back to the distribution kernel, so the .old
  backup files are not needed in the first place. Get rid of them
  to simplify and speed up the whole process.
* Fri Dec  7 2018 daniel.molkentin@suse.com
-  emergency mode: bring shell and all vital information to
  all ttys specified as console devices
  (FATE#325386, bsc#1053248, bsc#937555)
  * Adds 0585-emergency-mode-use-sulogin.patch
* Wed Oct 31 2018 daniel.molkentin@suse.com
- 98dracut-systemd: Start systemd-vconsole-setup before dracut-cmdline-ask
  (bsc#1055834)
  * adds 0582-98dracut-systemd-Start-systemd-vconsole-setup-before.patch
- Fixed Patch 581 to apply cleanly
  * Updates 0581-kernel-modules-add-nfit.patch
- Mark the DASD udev rules host-only and handle backslashes in paths for
  hostonly files (bsc#1090884)
  * adds 0583-99base-Allow-files-with-backslashes-in-hostonly-file.patch
  * adds 0584-95dasd_rules-mark-dasd-rules-host_only.patch
* Wed Oct 10 2018 daniel.molkentin@suse.com
- Add nfit module (bsc#1110519)
  * adds 0581-kernel-modules-add-nfit.patch
* Mon Sep 10 2018 msuchanek@suse.com
- Add kernel-syms to list of packages to remove with purge-kernels (bsc#1104090).
- Skip kernels that cannot be removed by purge-kernels due to dependencies and
  continue removing other kernels (bsc#1104090).
* Wed Aug 22 2018 msuchanek@suse.com
- Fix finding btrfs devices (bsc#1104178).
  * add 0574-s-find_btrfs_devs-btrfs_devs.patch
* Wed Jun 20 2018 trenn@suse.de
- Add fix to override ACPI tables via initrd, a kernel config variable
  changed name (bsc#1098448)
  This is mainline git commit 940169e8d8e500498a3f350b2b3f341ae6548492
  A 0580-check_for_CONFIG_ACPI_TABLE_UPGRADE.patch
* Thu Jun 14 2018 daniel.molkentin@suse.com
- 40network: Fix static network setup (bsc#1091099)
  * adds 0571-40network-Fix-static-network-setup.patch
- lsinitrd: Fix cat: write error: Broken pipe error (bsc#1094603)
  * adds 0572-lsinitrd-no-more-cat-write-error-Broken-pipe.patch
  * adds 0573-lsinitrd.sh-quote-filename-in-extract_files.patch
* Thu Jun 14 2018 daniel.molkentin@suse.com
- 95multipath: Pickup multipath files in /etc/multipath/conf.d (boo#1048551)
  * adds 0568-95multipath-Pickup-files-in-etc-multipath-conf.d.patch
- 10i18n: Load all keymaps for a given locale (boo#1065058)
  * adds 0569-10i18n-Load-all-keymaps-for-a-given-locale.patch
  * adds 0570-10i18n-Fix-possible-infinite-recursion.patch
* Wed Apr 25 2018 daniel.molkentin@suse.com
- 01fips: fix FIPS mode on SLES 15 (bsc#1074984)
  * adds 0567-Fix-booting-with-fips-1-on-SLES-15.patch
* Thu Apr 19 2018 daniel.molkentin@suse.com
- Do not attempt to run purge-kernels.service on ro rootfs (bsc#1087880)
* Thu Apr 19 2018 daniel.molkentin@suse.com
- 95nfs: If no server is configured, read BOOTSERVERADDR from wicked's leaseinf
  (bsc#1089332)
  * adds 0566-95nfs-If-no-server-is-configured-read-BOOTSERVERADDR.patch
* Thu Apr  5 2018 daniel.molkentin@suse.com
- Remove RH-specific s390 modules (bsc#1086216)
* Mon Mar 19 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Fri Mar 16 2018 daniel.molkentin@suse.com
- Instead of using arping, use wicked's own implementation (bsc#1078245)
  Follow-up patch to "disable arping", requires wicked 0.6.46.
  * adds 0563-40network-collapse-arping-and-dhcp-calls-into-wicked.patch
- Wicked: Properly add set gateway variable when using dhcp (bsc#1085614)
  * adds 0564-40network-Always-set-the-gw-variable.patch
- Allow booting from block devices using intel vmd (bsc#1079924)
  * adds 0565-90kernel-modules-Include-Intel-Volume-Management-Dev.patch
* Tue Mar 13 2018 daniel.molkentin@suse.com
- Enable aarch64 and adds critical drivers of ARM platform (bsc#1084272)
  * adds 0562-Adjust-driver-list-to-modern-kernels.patch
* Fri Mar  9 2018 daniel.molkentin@suse.com
- 95iscsi: Add the qedi driver to driver list for iscsi boot
  * adds 0561-Add-the-qedi-driver-to-driver-list-for-iscsi-boot.patch
* Wed Mar  7 2018 lpechacek@suse.com
- purge-kernels: Handle SLE 15 kernel live patches (bsc#108437)
* Thu Mar  1 2018 daniel.molkentin@suse.com
- 90kernel-modules: Ensure PCI host modules are included (boo#1079924)
  * adds 0560-90kernel-modules-Ensure-PCI-host-modules-are-include.patch
* Wed Feb 28 2018 daniel.molkentin@suse.com
- 40network: Add wickedd duid.xml and iaid.xml if available
  (bsc#1022872, bsc#1082832)
  * adds 0559-Add-wickedd-duid.xml-and-iaid.xml-if-available.patch
- 95qeth_rules: Fix file permissions (FATE#323440)
* Fri Feb 23 2018 daniel.molkentin@suse.com
- 40network: disable arping, it is no longer part of default installation (bsc#1078245)
  * Adds 0557-40network-make-arping-optional.patch
- 40network: replace brctl, it is longer part of default installation (bsc#1078245)
  * Adds 0558-40network-remove-brctl-dependency.patch
* Fri Feb  9 2018 daniel.molkentin@suse.com
- 95qeth_rules: Add new module to copy qeth rules (FATE#323440)
  * Adds 0556-95qeth_rules-Add-new-module-to-copy-qeth-rules.patch
- Avoid executing emergency hook twice
  * Adds 0555-Avoid-executing-emergency-hooks-twice.patch
* Thu Jan 25 2018 daniel.molkentin@suse.com
- support validating the IMA policy file signature, needed since Kernel 4.7
  * Adds 0552-98integrity-support-validating-the-IMA-policy-file-s.patch
- IMA: improve support for evm key loading (bsc#1077359, fate#323906)
  * Adds 0553-98integrity-support-loading-x509-into-the-trusted-bu.patch
  * Adds 0554-98integrity-support-X.509-only-EVM-configuration.patch
- FIPS: Adjust dependencies to work for cryptsetup 2.0 (bsc#1077070)
- Added a few more patch annotations
* Fri Jan 19 2018 daniel.molkentin@suse.com
- Fix typo for ima dependency (evmtcl vs evmctl) (bsc#1073466)
- Updated Patch annotation regarding their upstream state
* Wed Jan 10 2018 daniel.molkentin@suse.com
- FIPS: Try to fetch list of fips modules from the kernel's modules dir (bsc#1074984)
  * Adds 0551-fips-use-lib-modules-uname-r-modules.fips.patch
- Annotated patches regarding their upstream state
* Tue Jan  9 2018 daniel.molkentin@suse.com
- dracut-ima requires evmctl and keyutils (bsc#1073466)
* Fri Dec 15 2017 daniel.molkentin@suse.com
- Switch back to fipvlan for bnx2fc (bsc#1052840)
  * adds 0548-95fcoe-Switch-back-to-using-fipvlan-for-bnx2fc.patch
- 95fcoe: Allow bnc2x driver more time to complete DCB negotiation (bsc#1052840)
  * adds 0549-fcoe-up-Increase-sleeptime-to-13s.patch
- 95fcoe: add timeout initqueue entries (bsc#1052840)
  * adds 0550-95fcoe-add-timeout-initqueue-entries.patch
* Thu Dec 14 2017 daniel.molkentin@suse.com
- Fix task limit in emergency.service (same as in dracut-emergency.service) (bsc#1019938)
  * adds 0547-Fix-task-limit-in-emergency.service-the-same-change-.patch
* Wed Dec 13 2017 daniel.molkentin@suse.com
- Fix logic for applying 0541-Make-sure-70-persistent-net.rules-is-included-in-ini.patch
* Wed Dec 13 2017 daniel.molkentin@suse.com
- Support AMD CPU families 0x16 and 0x17 (bsc#1072424)
  * Adds 0545-Add-early-microcode-support-for-AMD-family-16h.patch
  * Adds 0546-Support-Microcode-Updates-for-AMD-CPU-Family-0x17.patch
* Fri Dec  8 2017 daniel.molkentin@suse.com
- Make ip=dhcp work. Previously, a network interface specifier was required.
  The new behaviour matches documented behaviour.
  Adds 0544-40network-Make-ip-dhcp-work.patch
* Wed Dec  6 2017 daniel.molkentin@suse.com
- Remove 00systemd-bootchart, which is gone from systemd for some time (bsc#1067279)
  Adds 0543-Remove-00systemd-bootchart.patch
- Ensure 0541-Make-sure-70-persistent-net.rules-is-included-in-ini.patch is
  not applied on Leap either
* Fri Nov  3 2017 daniel.molkentin@suse.com
- Ensure 0541-Make-sure-70-persistent-net.rules-is-included-in-ini.patch
  is not applied on SLE.
* Mon Oct 23 2017 daniel.molkentin@suse.com
- This is to support predictable interface names (boo#960669)
  * adds 0541-Make-sure-70-persistent-net.rules-is-included-in-ini.patch
- Include crc32c Intel module when using btrfs (bsc#1011554)
  * adds 0542-Include-crc32c-intel-module-when-using-btrfs.patch
* Tue Oct 17 2017 daniel.molkentin@suse.com
- Check the proper variable for a custom IMA keys directory (cherry-picked)
  Part of fate#323289.
  * adds 0540-Check-the-proper-variable-for-a-custom-IMA-keys-dire.patch
* Sun Oct  8 2017 jengelh@inai.de
- Reword dracut-ima description to avoid misunderstandings.
- Replace old RPM constructs.
* Thu Sep 28 2017 daniel.molkentin@suse.com
- Add IMA functionality (fate#323289)
  This is implemented as a sub module analogous to FIPS
  * adds 0539-Add-IMA-functionality-fate-323289.patch
* Tue Aug 29 2017 daniel.molkentin@suse.com
- 90multipath: Remove compat rule that is no longer needed (bsc#1054539)
  * adds 0536-90multipath-drop-67-kpartx-compat.rules.patch
- Don't detect crc32.ko as built-in (bsc#1054538)
  * adds 0537-dracut-init.sh-ignore-crc32.ko-in-builtin-test.patch
- Enable systemd-based core dumps for initrd (bsc#1054809)
  * adds 0538-Enable-core-dumps-with-systemd-from-initrd.patch
* Mon Aug 28 2017 mmarek@suse.com
- Add missing coreutils dependency for initrd macros (bsc#1055492).
* Fri Aug 18 2017 daniel.molkentin@suse.com
- Ensure that targets such as halt can be reached (bsc#1048698)
  * adds 0529-systemd-add-missing-.slice-unit.patch
  * adds 0530-dracut-systemd-dracut-cmdline-ask-fix-dracut-kernel-.patch
  * adds 0531-dracut-systemd-.service-conflict-with-shutdown-targe.patch
- Do not add too many drivers all at once (bsc#1037344)
  * adds 0532-List-drivers-rather-than-looking-for-reverse-depende.patch
- instmods: check modules.builtin in $srcmods (bsc#1048606)
  * adds 0533-instmods-check-modules.builtin-in-srcmods.patch
- ssh-client: ensure is usable in all cases (bsc#1021846)
  * adds 0534-ssh-client-Include-nss_-libraries.patch
- Sync initramfs after creation to ensure entigrity (bsc#1049113)
  * adds 0535-Sync-initramfs-after-creation.patch
* Wed Aug  2 2017 daniel.molkentin@suse.com
- Ensure dracut.sh responds properly to hostonly cmdline (bsc#1048748)
  * adds 0528-Ensure-dracut.sh-responds-properly-to-hostonly_cmdli.patch
* Thu Jul 13 2017 daniel.molkentin@suse.com
- switch fips checking to use the libkcapi based fipscheck toolset (bsc#1048565)
  * adds 0527-switch-fips-checking-to-use-the-libkcapi-based-fipsc.patch
* Wed Jul 12 2017 daniel.molkentin@suse.com
- iscsiroot: call handle_firmware only for non-iface invocations (bsc#1032284)
  * adds 0526-iscsiroot-call-handle_firmware-only-for-non-iface-in.patch
* Tue Jul 11 2017 daniel.molkentin@suse.com
- bail out if module directory does not exist (bsc#1043900)
  * adds 0525-backport-bail-out-if-module-directory-does-not-exist.patch
* Mon Jun 19 2017 daniel.molkentin@suse.com
- Suppress nonsensical error message (bsc#1032029)
  * adds 0524-Suppress-nonsensical-error-message-bsc-1032029.patch
* Fri Jun 16 2017 daniel.molkentin@suse.com
- 01fips: Fix typo (bsc#1033238)
  * adds 0522-Fix-typo-from-commit-3f1cdb520.patch
- 98dracut-systemd: Fix module force loading with systemd (bsc#986216)
  * adds 0523-98dracut-systemd-Fix-module-force-loading-with-syste.patch
* Wed Jun  7 2017 daniel.molkentin@suse.com
- Ship udev files required by systemd (bsc#1040153)
  * adds 0521-Ensure-udev-persistent-storage-compat-rules-get-crea.patch
- Bump package version to 044.1 to allow systemd to depend on this change
* Thu May 11 2017 daniel.molkentin@suse.com
- Revert: "Require version >= 3.18 btrfsprogs, rather than conflicting with
  an older one". Dracut should never depend on optional components
* Mon May  8 2017 daniel.molkentin@suse.com
- Ignore module resolution errors (e.g. with kgraft) (bsc#1037120)
  * adds 0520-Ignore-module-resolution-errors.patch
* Wed Apr 26 2017 daniel.molkentin@suse.com
- 90kernel-modules: Ensure phy drivers are loaded in initrd (bsc#1034893)
  * adds 0519-90kernel-modules-Ensure-phy-drivers-are-loaded-in-in.patch
* Wed Apr 26 2017 daniel.molkentin@suse.com
- 90kernel-modules: Fix backlight on Cherrytrail devices (boo#1034785)
  * adds 0518-90kernel-modules-Fix-backlight-on-Cherrytrail-device.patch
* Wed Apr 26 2017 daniel.molkentin@suse.com
- 95fcoe: fix rules generation (osc#1036323)
  * adds 0517-95fcoe-fixup-fcoe-genrules.sh-for-VN2VN-mode.patch
* Wed Apr 26 2017 daniel.molkentin@suse.com
- More correct patch description for 0512, no functional changes
  * updates 0512-Make-binutils-optional-when-elfutils-are-available.patch
* Wed Apr 26 2017 daniel.molkentin@suse.com
- Require version >= 3.18 btrfsprogs, rather than conflicting with
  an older one
* Tue Apr 25 2017 daniel.molkentin@suse.com
- Fix subnet calculation in mkinitrd (bsc#1035743)
  * adds 0516-mkinitrd-suse.sh-Fix-prefix-calculation.patch
* Fri Apr 21 2017 tchvatal@suse.com
- Conflict with older btrfsprogs < 3.18  bsc#1035518
  * otherwise when zypper duping we are not able to generate intrd
    until the btrfsprogs are updated, this way we force the app
    to be update beforehand (13.1 and SLE11 migrations)
* Thu Apr 20 2017 daniel.molkentin@suse.com
- Ensure hisi_sas_v2_hw gets included (bsc#1034597)
  * adds 0515-90kernel-modules-also-add-block-device-driver-revers.patch
* Fri Apr  7 2017 daniel.molkentin@suse.com
- Fix mdraid regression (bsc#1028542)
  * adds 0513-Fix-regression-caused-by-6f9bf2b8ac436259bdccb110545.patch
- man: make the -k option clear using mkinitrd (bsc#1012656)
  * adds 0514-man-make-the-k-option-clear-using-mkinitrd.patch
* Thu Apr  6 2017 daniel.molkentin@suse.com
- Fix typo in installkernel script (bsc#1032576)
* Mon Apr  3 2017 daniel.molkentin@suse.com
- Drop binutils dependency in favor of elfutils
  * add 0512-Make-binutils-optional-when-elfutils-are-available.patch
* Fri Mar 17 2017 daniel.molkentin@suse.com
- 01fips: Make init on non-x86_64, specifically s390x, pass (bsc#1021687)
  * add 0510-01fips-Some-modules-use-separators-other-than.patch
  * add 0511-01fips-ensure-fips-initialization-succeeds-on-s390-x.patch
* Thu Mar 16 2017 daniel.molkentin@suse.com
- installkernel: handle make bin-rpmpkg (bsc#1008648)
* Thu Mar  2 2017 daniel.molkentin@suse.com
- Do not pass ifname for bonding devices (bsc#995812)
  * add 0314-nfs_do_not_pass_ifname_for_bonding_devices.patch
* Thu Mar  2 2017 daniel.molkentin@suse.com
- Find devices by path for S390x (bsc#915218)
  * add s390x_persistent_device.conf
* Wed Mar  1 2017 daniel.molkentin@suse.com
- 01fips: Remove zlib module as requirement (bsc#1020063)
  * add 0509-01fips-Remove-zlib-module-as-requirement.patch
* Wed Feb  8 2017 daniel.molkentin@suse.com
- 90multipath: 90multipath: start before local-fs-pre.target
  (bsc#1005410, bsc#1006118, bsc#1007925)
  * add 0508-90multipath-start-before-local-fs-pre.target.patch
* Fri Feb  3 2017 daniel.molkentin@suse.com
- unlimit TaskMax for xfs_repair in emergency shell (bsc#1019938)
  * add 0507-Set-TaskMax-inifinite-for-the-emergency-shell.patch
* Thu Feb  2 2017 daniel.molkentin@suse.com
- Boot on s390x with fips=1 on the kernel commnad line (bnc#1021687)
  * add 0506-Boot-on-s390x-with-fips-1-on-the-kernel-commnad-line.patch
* Thu Jan 26 2017 daniel.molkentin@suse.com
- Allow booting from degrated MD arrays with systemd (bsc#1017695)
  * add 0505-Allow-booting-from-degraded-MD-RAID-arrays.patch
* Mon Jan 16 2017 daniel.molkentin@suse.com
- Add md4 and arc4 modules for ntlm authentication
  * add 0454-Add-md4-and-arc4-modules-for-ntlm.patch
* Mon Jan 16 2017 daniel.molkentin@suse.com
- Resolve symbolic links for -i and -k parameters (bsc#902375)
  * add 0453-Resolve-symbolic-links-for-i-and-k-parameters-bsc-90.patch
* Fri Jan  6 2017 mmarek@suse.cz
- purge-kernels: Handle kgraft patches (bsc#1017141)
  Cleanup unused code.
* Wed Dec 14 2016 Thomas.Blume@suse.com
- deal with incomplete ibft bootflag settings (bsc#1007648)
  * add 0504-ibft-fix-boot-flag-check.patch
* Mon Nov 28 2016 kukuk@suse.de
- Remove 0314-run-rpcbind.patch again, was solved by another
  change in rpcbind
* Tue Nov 15 2016 dmolkentin@suse.com
- Try to always add pinctrl-cherryview (bsc#998440)
  * add 0452-Always-try-to-add-pinctrl-cherryview.patch
* Sun Nov 13 2016 kukuk@suse.de
- nfs/rpcbind: rpcbind uses now /run/rpcbind for temporary data.
  Create the needed directory.
  * add 0314-run-rpcbind.patch
* Tue Nov  8 2016 daniel@molkentin.de
- systemd-initrd: Add initrd-root-device.target. Cherry-pick to get
  systemd v230 into factory (bsc1009089)
  * add 0451-systemd-initrd-add-initrd-root-device.target.patch
* Mon Nov  7 2016 dmolkentin@suse.de
- Bash cannot handle binary strigns with embedded NULs. This used
  to work by accident, it no longer does starting from bash 4.4.
  Strip NULs during all comparison operations as a workaround.
  Addresses bsc989218.
  * add 0450-Strip-NUL-bytes-in-stream-before-push-in-string.patch
* Mon Nov  7 2016 astieger@suse.com
- Do not create initramfs with world-readable permissions if
  early microcode update is used bsc#1008340 CVE-2016-8637
  0503-dracut.sh-create-the-initramfs-non-world-readable-al.patch
* Mon Oct 17 2016 hare@suse.de
- Add missing rules file for previous patch
  * modify 0313-90mdraid-Use-stock-MD-rules-to-assemble-RAID-arrays.patch
* Fri Oct 14 2016 hare@suse.de
- 90mdraid: Use stock MD rules to assemble RAID arrays (bsc#998860)
  * add 0313-90mdraid-Use-stock-MD-rules-to-assemble-RAID-arrays.patch
* Thu Oct 13 2016 hare@suse.de
- 95resume: Do not resume on iSCSI devices (bsc#999663)
  * add 0310-95resume-Do-not-resume-on-iSCSI.patch
- 95iscsi: ip=ibft is deprecated (bsc#1004437)
  * add 0311-95iscsi-ip-ibft-is-deprecated.patch
- 40network: do not print warning about non-existing file
  (bsc#1004437)
  * add 0312-40network-Do-not-print-message-about-tmp-net.ibft0.c.patch
* Mon Oct 10 2016 hare@suse.de
- 90dmraid: do not delete partitions (bsc#998860)
  * add 0309-90dmraid-do-not-delete-partitions.patch
* Fri Oct  7 2016 trenn@suse.de
- Give-persistent_policy-precedence-over-dev-mapper-names (bsc#908143)
  * add: 0502-persistent_device_policy_param_enhance.patch
- mdadm IMSM_NO_PLATFORM workaround for kdump (bsc#975404)
  * add: 0308-mdraid_add_IMSM_NO_PLATFORM_env.patch
* Wed Sep 28 2016 hare@suse.de
- 90multipath: parse commandline option 'multipath=off' (bsc#1001691)
  * add 0307-90multipath-parse-kernel-commandline-option-multipat.patch
* Wed Sep 28 2016 hare@suse.de
- 95fcoe: do not start fcoemon twice (bsc#1001512)
  * add 0225-95fcoe-do-not-start-fcoemon-twice.patch
* Tue Sep 27 2016 hare@suse.de
- Reformat patch headers:
  * modify 0199-rd-iscsi-waitnet-default-false.patch
  * modify 0200-dracut_fix_multipath_without_config.patch
  * modify 0210-add_fcoe_uefi_check.patch
  * modify 0212-fcoe_reorder_init_path.patch
- Rediff patches to apply cleanly:
  * modify 0124-40network-Update-iBFT-scanning-code-to-handle-IPv6.patch
  * modify 0133-Allow-multiple-configurations-per-network-interface-.patch
  * modify 0170-iscsi-skip-ibft-invalid-dhcp.patch
  * modify 0218-40network-allow-persistent-interface-names.patch
- Remove spurious whitespaces:
  * modify 0169-network_set_mtu_macaddr_for_dhcp.patch
- 40network: print out correct prefix (bsc#996141)
  * modify 0125-40network-separate-mask-and-prefix.patch
- 95iscsi: setup bnx2i offload connection correctly (bsc#997598)
  * add 0224-95iscsi-setup-bnx2i-offload-connections-properly.patch
- Rename patches to match sequence number:
  * old: 0019-40network-Fix-race-condition-when-wait-for-networks.patch
  * new: 0012-40network-Fix-race-condition-when-wait-for-networks.patch
  * old: 0066-40network-always-start-netroot-in-ifup.sh.patch
  * new: 0013-40network-always-start-netroot-in-ifup.sh.patch
* Mon Sep 19 2016 Thomas.Blume@suse.com
- rd.iscsi.waitnet should default to false in order for dracut to
  wait for the network devices (bsc#997598)
  * add 0199-rd-iscsi-waitnet-default-false.patch
* Fri Sep 16 2016 hare@suse.de
- 95multipath: Replace 'grep' with 'sed' for shutdown scripts
  (bsc#999220)
  * modify 0306-90multipath-add-shutdown-script.patch
* Thu Sep  1 2016 opensuse@dstoecker.de
- fix boot issues using RAID, bnc#970215
* Wed Aug 31 2016 trenn@suse.de
- Add missing whitespace for md raid suse kernel param parsing (bsc#970215)
  * modify: 0059-99suse-Add-SUSE-specific-initrd-parsing.patch
- Fix IFS separater in net-lib.sh (bsc#996141)
  * modify: 0125-40network-separate-mask-and-prefix.patch
* Fri Aug 26 2016 hare@suse.de
- Rename patch:
  * From 0211-fix_multipath_check_hostonly.patch
    to 0303-fix_multipath_check_hostonly.patch
- Rename patch:
  * From 0213-10i18n-keymap-find.patch
    to 0213-Fix-wrong-keymap-inclusion.patch
* Thu Aug 25 2016 hare@suse.de
- 95fcoe: Do not complain about missing /etc/hba.conf (bsc#980539)
  * Add 0215-95fcoe-Do-not-complain-about-missing-etc-hba.conf.patch
- 95fcoe: silence lldpad warnings
  * Add 0216-95fcoe-silence-lldpad-warnings.patch
- 95fcoe: Allow to specify the FCoE mode via the fcoe= parameter
  * Add 0217-95fcoe-Allow-to-specify-the-FCoE-mode-via-the-fcoe-p.patch
- 40network: allow persistent interface names (bsc#995284)
  * Add 0218-40network-allow-persistent-interface-names.patch
- 95fcoe: use interface names instead of MAC addresses
  * Add 0219-95fcoe-use-interface-names-instead-of-MAC-addresses.patch
- 95fcoe: always set AUTO_VLAN for fcoemon (bsc#995019)
  * Add 0220-95fcoe-always-set-AUTO_VLAN-for-fcoemon.patch
- 95fcoe: Add shutdown script (bsc#994860)
  * Add 0221-95fcoe-Add-shutdown-script.patch
- 90dm: Fixup shutdown script (bsc#994860)
  * Add 0222-90dm-Fixup-shutdown-script.patch
- 90dm: fixup dependency cycle between MD and DM shutdown (bsc#994860)
  * Add 0223-90dm-fixup-dependency-cycle-between-MD-and-DM-shutdo.patch
- 90multipath: Start daemon after udev settle (bsc#986734)
  * Add 0304-90multipath-Start-daemon-after-udev-settle.patch
- 90multipath: load dm_multipath module during startup
  * Add 0305-90multipath-load-dm_multipath-module-during-startup.patch
- 90multipath: add shutdown script (bsc#994860)
  * Add 0306-90multipath-add-shutdown-script.patch
* Tue Aug 23 2016 hare@suse.de
- Reformat patches and add patch header:
  * 0053-01fips-fixup-loading-issues.patch
  * 0126-01fips-Add-drbg-module-to-force-loaded-modules.patch
  * 0128-90lvm-Install-dm-snapshot-module.patch
  * 0133-Allow-multiple-configurations-per-network-interface-.patch
  * 0138-fips_add_aesni-intel.patch
  * 0168-remove_plymouth_logo_file.patch
  * 0169-network_set_mtu_macaddr_for_dhcp.patch
  * 0170-iscsi-skip-ibft-invalid-dhcp.patch
  * 0180-i18n_add_correct_fontmaps.patch
  * 0196-ibft-wait-for-session-on-all-paths.patch
  * 0201-fix_nfs_with_ip_instead_of_hostname.patch
  * 0300-dracut_dont_use_dpkg_defaults_on_SUSE.patch
  * fips-kernel-4.4-fixes.patch
- Rename patch:
  * from fips-kernel-4.4-fixes.patch
  * to 0139-fips-kernel-4.4-fixes.patch
* Fri Aug 19 2016 hare@suse.de
- Do not overwrite existing FCoE configuration (bsc#993861)
  * Add 0213-95fcoe-Do-not-overwrite-FCoE-configuration.patch
* Tue Aug  2 2016 trenn@suse.de
- Fix DASD SSID handling (bsc#989313)
  * Add 0501-dasd_fix_ssid_bigger_zero.patch
* Tue Aug  2 2016 mfasheh@suse.com
- Advise user of fs recovery options when we fail to mount (fate#320443)
  * Add 0404-dracut-emergency-optionally-print-fs-help.patch
* Mon Jul  4 2016 agraf@suse.com
- Add 32bit arm support to installkernel
* Fri Jun 17 2016 fvogt@suse.com
- Add 0213-10i18n-keymap-find.patch:
  - Fix choice of keymap for inclusion (bsc#942896)
  - Refresh 0301-include_sysconfig_language.patch
* Fri Jun  3 2016 trenn@suse.de
- FCOE fix bsc#982588
  * Add 0212-fcoe_reorder_init_path.patch
* Tue May 31 2016 meissner@suse.com
- fips-kernel-4.4-fixes.patch: adjust the kernel module list to
  match the SLES 12 SP2 kernel. (bsc#976577)
* Wed May  4 2016 hare@suse.de
- Port missing SLES patches
  * Add 0197-95iscsi-Do-not-require-network-for-qla4xxx-flash-ses.patch
  * Add 0198-95iscsi-set-rd.iscsi.firmware-for-qla4xxx-sessions.patch
  * Remove 0194-95iscsi-Do-not-require-network-for-qla4xxx-flash-ses.patch
  * Remove 0195-95iscsi-set-rd.iscsi.firmware-for-qla4xxx-sessions.patch
- Rewrite patch:
  * Add 0302-Revert-90multipath-add-hostonly-multipath.conf-in-ca.patch
  * Remove 0001-multipath_revert_mpathconf_binary_use.patch
- Update 0403-95lunmask-Add-module-to-handle-LUN-masking.patch
  to match upstream kernel submission (FATE#319786)
* Tue Apr 26 2016 trenn@suse.de
- Add IFS restoring where it has been lost due to mainline merging
  (bsc#977117)
  * Add 0500-Reset-IFS-variable.patch
* Mon Apr 25 2016 trenn@suse.de
- Make sure to install collect binary (bsc#976466)
  * Add: 0188-95dasd_rules-Install-collect-udev-helper-binary.patch
* Wed Apr 20 2016 trenn@suse.de
- Remove version from requires on subpackage
- Add a split provide because of the package split for SLE12 SP1 to SP2 upgrade
* Tue Apr 12 2016 trenn@suse.de
- Forward port of latest SLES patches (fate#320499)
  Add:
  * 0001-multipath_revert_mpathconf_binary_use.patch (fate#320499)
  * 0170-iscsi-skip-ibft-invalid-dhcp.patch (bsc#953361)
  * 0160-s390-update_active_devices_initrd.patch (bsc#939101)
  * 0161-95zfcp_rules-simplified-rd.zfcp-commandline-for-NPIV.patch (bsc#964456)
  * 0190-replace-iscsistart-with-systemd-service-files.patch (fate#319024)
  * 0191-static_network_setup_return_zero.patch (bsc#919179)
  * 0192-iscsi_set_boot_protocol_from_ifcfg.patch (bsc#919179)
  * 0193-95iscsi-Set-number-of-login-retries.patch (bsc#951003)
  * 0196-ibft-wait-for-session-on-all-paths.patch (bsc#951003)
  * 0403-95lunmask-Add-module-to-handle-LUN-masking.patch (FATE#319786)
  Added, but still commented in spec file (still needs adjusting):
- Fixup booting from qla4xxx (bsc#951003)
  * 0194-95iscsi-Do-not-require-network-for-qla4xxx-flash-ses.patch
  * 0195-95iscsi-set-rd.iscsi.firmware-for-qla4xxx-sessions.patch
* Wed Mar 30 2016 dmueller@suse.com
- dracut-installkernel: Fix for aarch64 (bsc#947670)
* Thu Mar 24 2016 trenn@suse.de
- Move dist config file to /usr/lib/dracut/dracut.conf.d (bsc#972143)
- Remove stale, unused patch file:
  0181-no_systemd_cryptsetup.patch
- Still create a debug config example in /etc/dracut.conf.d
* Fri Feb 12 2016 fvogt@suse.com
- Add 0211-fix_multipath_check_hostonly.patch:
  - Fix warning about multipath
* Wed Feb 10 2016 fvogt@suse.com
- Modify 0300-dracut_dont_use_dpkg_defaults_on_SUSE.patch:
  - Don't try to include plymouth if plymouth-dracut pkg. not installed
* Tue Feb  9 2016 fvogt@suse.com
- Add 0210-add_fcoe_uefi_check.patch:
  - Only install fcoe-uefi module if needed (boo#965477)
* Sat Feb  6 2016 fvogt@suse.com
- Fix 0208-no_forced_virtnet.patch:
  - On non-QEMU systems it returned non-zero, causing dracut to fail
  - Fixed boo#965477
  - dracut.spec: Remove 90qemu-net entirely instead of disabling
  - running_in_qemu was broken (reading output of >/dev/null)
* Mon Feb  1 2016 fvogt@suse.com
- Fix 0158-Add-SUSE-kernel-module-dependencies-in-etc-modprobe.patch:
  - Patch did not have any effect whatsoever
  - Fixes bsc#869496
  - Rename from 0158-Add-SUSE-kernel-module-dependencies-in-etc-modprobe..patch
* Thu Jan 28 2016 pwieczorkiewicz@suse.com
- Add 0169-network_set_mtu_macaddr_for_dhcp.patch:
  - Set MTU and LLADDR for DHCP if specified (boo#959803)
* Wed Jan 27 2016 fvogt@suse.com
- Modify 0017-45ifcfg-use-distro-specific-scripts.patch:
  - Also revert upstream commit f34e1d6b to not forcibly
    include network and ifcfg modules (bsc#960669)
- Refresh:
  - 0094-Implement-shortcut-ip-ifname-static-for-static-confi.patch
  - 0132-40network-fixup-static-network-configuration.patch
  - 0142-40network-Don-t-report-error-for-etc-sysconfig-netwo.patch
  - 0402-driver-fail-summary.patch
* Wed Jan 27 2016 fvogt@suse.com
- Add 0209-fix_modules_load_d_hostonly.patch:
  - Fix modules-load.d with hostonly (boo#962224)
* Tue Jan 26 2016 fvogt@suse.com
- Add 0208-no_forced_virtnet.patch:
    Don't include qemu-net modules without reason.
    Fix for bsc#960669
* Fri Jan 22 2016 fvogt@suse.com
- Refresh and merge:
    0133-Allow-multiple-configurations-per-network-interface-.patch
    0145-40network-handle-ip-ifname-static-correctly.patch
    0162-network-Request-DHCP-lease-instead-of-getting-applyi.patch
- Delete 0134-Remove-bootdev-warning-bnc-881112.patch:
  - ip=ibft got deprecated, so workaround not necessary
* Thu Jan 21 2016 fvogt@suse.com
- Add 0207-handle_module_aliases.patch:
    Handle module aliases correctly to not generate unbootable
    initrds with different kernel versions. Fix for boo#962694
* Thu Nov 26 2015 fvogt@suse.com
- Don't require bind-utils, it conflicts with
    minimal-base-conflicts
* Thu Nov 26 2015 fvogt@suse.com
- Add warning about pkgconfig file to rpmlintrc's ignore list
- Fix spec file:
  - Add dracut-catimages manpage to dracut-tools
  - Fix summary of dracut-tools subpackage
* Thu Nov 26 2015 fvogt@suse.com
- Remove 0400-use_fstab_systemd.patch
- Move dracut-catimages, /boot/dracut and /var/lib/dracut into
    dracut-tools subpackage
- Cleanup spec file
* Thu Nov 26 2015 fvogt@suse.com
- Refresh patches with line offsets:
    0017-45ifcfg-use-distro-specific-scripts.patch
    0048-40network-Only-enable-network-interfaces-if-explicit.patch
    0088-91zipl-Add-new-module-to-update-s390x-configuration.patch
    0121-Adjust-initramfs-kernel.img-to-SUSE-default-initrd-k.patch
    0150-Find-kernel-modules-in-extra-and-weak-updates-path-a.patch
    0157-Add-boot-zipl-to-host-devs-if-it-is-a-mount-point.patch
    0182-fix-include-parsing.patch
    0183-fix_add_drivers_hang.patch
    0203-no-fail-builtin-module.patc
* Wed Nov 25 2015 fvogt@suse.com
- Update to dracut-044
- Patches upstream, removed here:
    0119-Reset-IFS-variable.patch
    0120-mkinitrd-suse.sh-Bail-out-with-exit-1-if-initrd-cann.patch
    0122-Get_kernel_version_from_gz_file_for_arm.patch
    0165-Order-root-fsck-after-pre-mount.patch
    0184-fix_lvm_wc_warning.patch
    0185-dracut.sh-remove-_EARLY-from-CONFIG_MICROCODE_-check.patch
    0401-mount_option_mountpoint.patch
- Updated/Refreshed patches:
    0015-40network-replace-dhclient-with-wickedd-dhcp-supplic.patch
    0019-40network-Fix-race-condition-when-wait-for-networks.patch
    0056-81cio_ignore-handle-cio_ignore-commandline.patch
    0058-dracut-add-warning-when-including-unsupported-module.patch
    0066-40network-always-start-netroot-in-ifup.sh.patch
    0094-Implement-shortcut-ip-ifname-static-for-static-confi.patch
    0124-40network-Update-iBFT-scanning-code-to-handle-IPv6.patch
    0125-40network-separate-mask-and-prefix.patch
    0131-40network-handle-prefixed-IP-addresses-correctly.patch
    0132-40network-fixup-static-network-configuration.patch
    0144-90crypt-Fixed-crypttab_contains-to-also-work-with-de.patch
    0150-Find-kernel-modules-in-extra-and-weak-updates-path-a.patch
    0158-Add-SUSE-kernel-module-dependencies-in-etc-modprobe..patch
    0159-network-Try-to-load-xennet.patch
    0202-dracut_dmraid_use_udev.patch
    0203-no-fail-builtin-module.patch
    0402-driver-fail-summary.patch
* Wed Nov 25 2015 fvogt@suse.com
- Fix 0202-dracut_dmraid_use_udev.patch:
  - Statement was missing a program to execute
* Tue Nov 24 2015 fvogt@suse.com
- Add 0206-nfs_dns_alias.patch to fix boo#955592:
  - Fix dracut run on nfs root where NFS host is a DNS ALIAS
- Require bind-utils. host is used in some lines
* Thu Nov 19 2015 tiwai@suse.de
- Fix the wrong kernel config check for microcode with 4.4 kernel
  (boo#955712):
  0185-dracut.sh-remove-_EARLY-from-CONFIG_MICROCODE_-check.patch
* Tue Nov 17 2015 fvogt@suse.com
- Disable 0400-use_fstab_systemd.patch
  - Fully implementing this would take ages
  - Fix boo#948771
* Tue Nov 17 2015 fvogt@suse.com
- Add numbers to the filename of all patches:
  fips_add_aesni-intel.patch -> 0138-fips_add_aesni-intel.patch
  dracut_fix_multipath_without_config.patch -> 0200-dracut_fix_multipath_without_config.patch
  fix_nfs_with_ip_instead_of_hostname.patch -> 0201-fix_nfs_with_ip_instead_of_hostname.patch
  dracut_dmraid_use_udev.patch -> 0202-dracut_dmraid_use_udev.patch
  dracut_dont_use_dpkg_defaults_on_SUSE.patch -> 0300-dracut_dont_use_dpkg_defaults_on_SUSE.patch
* Mon Nov 16 2015 fvogt@suse.com
- Update description in dracut.spec
* Thu Nov 12 2015 fvogt@suse.com
- Add 0301-include_sysconfig_language.patch:
  - Include /etc/sysconfig/language instead of forcibly generating
    /etc/locale.conf
  - Workaround and partial fix for boo#927250
* Tue Nov 10 2015 fvogt@suse.com
- Add 0205-mdraid_ignore_hostonly.patch:
  - Always install mdraid modules (boo#935993)
* Tue Nov 10 2015 fvogt@suse.com
- Modify 0402-driver-fail-summary.patch
  - Add notice (bsc#952491)
  - Use mktemp instead of hardcoded filenames (bnc#935338)
- Modify 0144-90crypt-Fixed-crypttab_contains-to-also-work-with-de.patch
  - Use mktemp instead of hardcoded filenames (bnc#935338)
* Wed Nov  4 2015 fvogt@suse.com
- Add dracut-rpmlintrc
- Fix permissions of various scripts, as patch does not
    create executable files
* Wed Nov  4 2015 fvogt@suse.com
- Fix format of patch disablement
* Wed Nov  4 2015 fvogt@suse.com
- Add 0204-mkinitrd-fix-monster.patch:
  - Implement functionality of -A option
  - Without this patch, -A sets host_only=0,
    but host_only wasn't used
  - Translates into --no-host-only now
- References boo#935993
* Tue Nov  3 2015 fvogt@suse.com
- Add 0402-driver-fail-summary.patch:
  - Port 0169-Enabled-Warning-for-failed-kernel-modules-per-defaul.patch:
    Subject: Enable warning for failed kernel moduiles
    Enabled Warning for failed kernel modules per default
    and added summary of those to the end of dracut output
    References: bnc#886839
  - Disable inline warnings in favour of summary
* Tue Nov  3 2015 fvogt@suse.com
- Add 0203-no-fail-builtin-module.patch:
    Don't let inst1mod fail if module is built-in
  - Fixes bsc#935563
* Wed Oct 14 2015 trenn@suse.de
- Always install dm-snaphost module if lvm dracut module is needed,
  even if dm-snampshot is not loaded on the host yet (bsc#947518)
  A 0128-90lvm-Install-dm-snapshot-module.patch
* Tue Oct  6 2015 fvogt@suse.com
- Add patch 0184-fix_lvm_wc_warning.patch:
  - Upstream commit 08eca6 to get rid of missing wc warning
* Thu Oct  1 2015 fvogt@suse.com
- Fix 0181-no_systemd_cryptsetup.patch:
  - Password input without plymouth didn't work
* Thu Oct  1 2015 dimstar@opensuse.org
- Disable 0181-no_systemd_cryptsetup.patch: it breaks existing
  installations of encrypted / on LVM.
* Wed Sep 23 2015 fvogt@suse.com
- Fix 0182-fix-include-parsing.patch
- Didn't parse arguments with spaces correctly
* Wed Sep 23 2015 fvogt@suse.com
- Add patch 0183-fix_add_drivers_hang.patch:
  - Fix possible hang in dracut
    caused by add_drivers+=" " in dracut.conf (bsc#923116)
* Mon Sep 21 2015 fvogt@suse.com
- Add patch 0182-fix-include-parsing.patch:
  - Fix parsing of "-i" and "--include"
- Fixes boo#908452
* Mon Sep 21 2015 fvogt@suse.com
- Add patch 0181-no_systemd_cryptsetup.patch:
  - rd.luks.key is not implemented (properly) if systemd is enabled,
    so ignore systemd in 90crypt
- Fixes boo#915849
* Wed Sep 16 2015 fvogt@suse.com
- Fix systemd-vconsole-error properly (bsc#943312 and bsc#932981)
  Rewrite 0180-dracut-add-trivial-vconsole-fontmap.patch
  as 0180-i18n_add_correct_fontmaps.patch
* Mon Sep 14 2015 thomas.blume@suse.com
- fix systemd-vconsole-error in initrd (bsc#943312)
  Add 0180-dracut-add-trivial-vconsole-fontmap.patch
* Fri Sep 11 2015 fvogt@suse.com
- Add 0401-mount_option_mountpoint.patch:
    Make it possible to use a mountpoint as --mount parameter
* Fri Sep 11 2015 fvogt@suse.com
- Add experimental 0400-use_fstab_systemd.patch:
    Add entry for /sysroot in /etc/fstab instead of relying
    on root= and rootflags=
* Sun Aug 23 2015 seife+obs@b1-systems.com
- fix plymouth installation if dpkg package is installed
  - add dracut_dont_use_dpkg_defaults_on_SUSE.patch
* Mon Aug 17 2015 trenn@suse.de
- Do not recommend, but require binutils package. bsc#941928
* Sun Jul 26 2015 jengelh@inai.de
- get_kernel_version is required for /sbin/mkinitrd
* Thu Jul  2 2015 trenn@suse.de
- Update to version 043
  Minor change: add missing dmsquash-generator
* Wed Jun 24 2015 trenn@suse.de
- Fix dmraid issue bnc#905746
  A    dracut_dmraid_use_udev.patch
- Taken over from SLE12
  A    fips_add_aesni-intel.patch
- Do not touch /run vs /var/run bnc#922676
  D    0106-dracut-Enable-converting-of-directory-var-run-var-lo.patch
- Update dracut to version 042
  Remove these already included or unneeded patches:
  D    dracut_v041_to_HEAD.patch
  D    0011-Correct-paths-for-openSUSE.patch
  D    0068-95fcoe-uefi-Test-for-EFI-firmware.patch
  D    0170-enable-logitech-hidpp.patch
- Fix nfs mount if IPv4 is used in fstab instead of hostname
  A fix_nfs_with_ip_instead_of_hostname.patch
  Adjust/refresh:
  M    0015-40network-replace-dhclient-with-wickedd-dhcp-supplic.patch
  M    0016-Add-new-s390x-specific-rule-files.patch
  M    0017-45ifcfg-use-distro-specific-scripts.patch
  M    0019-40network-Fix-race-condition-when-wait-for-networks.patch
  M    0020-00warpclock-Set-correct-timezone.patch
  M    0021-95dcssblk-Add-new-module-for-DCSS-block-devices.patch
  M    0048-40network-Only-enable-network-interfaces-if-explicit.patch
  M    0053-01fips-fixup-loading-issues.patch
  M    0056-81cio_ignore-handle-cio_ignore-commandline.patch
  M    0057-01fips-Include-some-more-hmacs.patch
  M    0058-dracut-add-warning-when-including-unsupported-module.patch
  M    0059-99suse-Add-SUSE-specific-initrd-parsing.patch
  M    0060-45ifcfg-Add-SUSE-specific-write-ifcfg-file.patch
  M    0061-45ifcfg-Fixup-error-message-in-write-ifcfg-suse.patch
  M    0066-40network-always-start-netroot-in-ifup.sh.patch
  M    0075-95dasd_rules-enable-parsing-of-rd.dasd-commandline-p.patch
  M    0076-Correctly-set-cio_ignore-for-dynamic-s390-rules.patch
  M    0079-95dasd_rules-fixup-rd.dasd-parsing.patch
  M    0080-95dasd_rules-print-out-rd.dasd-commandline.patch
  M    0081-95dasd_mod-do-not-set-module-parameters-if-dasd_cio_.patch
  M    0083-95zfcp_rules-Fixup-rd.zfcp-parsing.patch
  M    0085-95zfcp_rules-print-out-rd.zfcp-commandline-parameter.patch
  M    0086-95zfcp_rules-Auto-generate-udev-rule-for-ipl-device.patch
  M    0087-95dasd_rules-Auto-generate-udev-rule-for-ipl-device.patch
  M    0088-91zipl-Add-new-module-to-update-s390x-configuration.patch
  M    0089-40network-create-var-lib-wicked-in-ifup.sh.patch
  M    0090-dracut-caps-Remove-whole-caps-module.patch
  M    0091-dracut-biosdevname-In-SUSE-biosdevname-package-is-in.patch
  M    0094-Implement-shortcut-ip-ifname-static-for-static-confi.patch
  M    0106-dracut-Enable-converting-of-directory-var-run-var-lo.patch
  M    0107-Fixup-typo-firmare-instead-of-firmware.patch
  M    0108-91zipl-Store-commandline-correctly.patch
  M    0109-95dasd_rules-Store-all-devices-in-commandline.patch
  M    0110-95zfcp_rules-Store-all-devices-in-commandline.patch
  M    0113-91zipl-Install-script-as-executable.patch
  M    0114-91zipl-Translate-ext2-3-into-ext4.patch
  M    0116-Mark-scripts-as-executable.patch
  M    0117-95dasd_rules-Enable-the-device-before-checking-devic.patch
  M    0118-95zfcp_rules-Enable-the-device-before-checking-devic.patch
  M    0119-Reset-IFS-variable.patch
  M    0120-mkinitrd-suse.sh-Bail-out-with-exit-1-if-initrd-cann.patch
  M    0121-Adjust-initramfs-kernel.img-to-SUSE-default-initrd-k.patch
  M    0122-Get_kernel_version_from_gz_file_for_arm.patch
  M    0123-95zfcp_rules-fix-typo-in-module_setup.patch
  M    0124-40network-Update-iBFT-scanning-code-to-handle-IPv6.patch
  M    0125-40network-separate-mask-and-prefix.patch
  M    0126-01fips-Add-drbg-module-to-force-loaded-modules.patch
  M    0130-nfs-Always-add-all-kernel-modules-for-kdump.patch
  M    0131-40network-handle-prefixed-IP-addresses-correctly.patch
  M    0132-40network-fixup-static-network-configuration.patch
  M    0137-Switch-from-Mozilla-NSS-sha256hmac-checking-to-fipsc.patch
  M    0142-40network-Don-t-report-error-for-etc-sysconfig-netwo.patch
  M    0144-90crypt-Fixed-crypttab_contains-to-also-work-with-de.patch
  M    0150-Find-kernel-modules-in-extra-and-weak-updates-path-a.patch
  M    0157-Add-boot-zipl-to-host-devs-if-it-is-a-mount-point.patch
  M    0158-Add-SUSE-kernel-module-dependencies-in-etc-modprobe..patch
  M    0159-network-Try-to-load-xennet.patch
  M    0163-Install-etc-sysconfig-console-to-see-specific-fonts.patch
  M    0164-Fix-initramfs-ver.img-vs-initrd-ver-in-dracut-initra.patch
  M    0165-Order-root-fsck-after-pre-mount.patch
  M    0168-remove_plymouth_logo_file.patch
  M    dracut_fix_multipath_without_config.patch
* Wed May 20 2015 trenn@suse.de
- Fix mkinitrd (get_kernel_version) for arm* arch by getting kernel version
  from vmlinux.*.gz file instead of [uz]Image file.
  Taken over from mkinitrd bnc#908454
  * Add patch 0122-Get_kernel_version_from_gz_file_for_arm.patch
- Fix nfs ip= setup in case of IP instead of host in root= name (bsc#931307)
- Honor allow_unsupported_modules setting
  From: Borislav Petkov <bp@suse.de>
  $ make install
  of a locally built kernel, you don't want dracut to do --check-supported
  for supported modules when you have "allow_unsupported_modules 1" in
  /etc/modprobe.d/10-unsupported-modules.conf.
  Teach /sbin/installkernel to pay attention to that setting.
  Use modprobe --showconfig too, which is going to be the proper way to do
  it starting with 12SP1.
* Fri May  8 2015 trenn@suse.de
- Add fix for multipath systems without multipathd.conf
  bsc#927719: Tumbleweed Snapshot blocked: no multipath support in 20150416\
    (likely dracut issue)
  bsc#930019: multipath is broken in dracut due to missing /etc/multipath.conf
  file (systemd multpath.service condition)
  * Added patch: dracut_fix_multipath_without_config.patch
* Tue Mar 24 2015 trenn@suse.de
- Update to dracut mainline version 041.
  Half of the patches got integrated mainline.
  Some others have been merged together when it made sense some have
  been left out, but are still in the repository as they need some special
  treating and mainline discussion whether/how they get added. These are
  also not urgently needed, but are debugging patches.
  I broke the rule here to mention every added/deleted/modified patch as
  every patch is touched and every 2nd  got removed (mainline integrated).
  I also re-ordered the patches in the PatchXY: area for easier merging them
  and get them discussed and posted mainline easier, topic by topic.
- Patches merged in the git tracking repository:
  0065-95iscsi-Fixup-bnx2i-offload-booting.patch
  0028-95udev-rules-Include-correct-sg3_utils-rules.patch
  0135-lvm-Fix-12819a579900b9691e2-check-for-existance-of-6.patch
  0100-Add-btrfs-rescue-utilities.patch
  0067-95fcoe-check-always-returns-255.patch
  0138-warpclock-Do-not-use-warpclock-module-on-S390-x-hwcl.patch
  0077-90multipath-add-missing-11-dm-mpath.rules-file.patch
  0042-Enhance-suse.conf-example-with-SUSE-specific-setting.patch
  0161-Fix-error-message-when-there-are-no-internal-kernel-.patch
  0111-90mdraid-Remove-line-for-offroot-detection.patch
  0129-Revert-commit-6ecab258710d158a7a6-and-only-do-not-wa.patch
  0041-mkinitd-suse-remove-hostonly-and-hostonly-cmdline.patch
  0030-95iscsi-Autodetect-iSCSI-firmware.patch
  0052-99base-Add-chown-binary.patch
  0105-95iscsi-parse-output-from-iscsiadm-correctly.patch
  0101-Print-stored-dracut-commandline-during-initramfs-bui.patch
  0096-dracut-Fix-error-local-can-only-be-used-in-a-functio.patch
  0043-40network-always-add-network-module.patch
  0035-Introduce-force-drivers-parameter-and-force_drivers-.patch
  0136-Revert-95udev-rules-add-persistent-network-rule.patch
  0143-iscsi-Fix-up-ipv6-in-brackets-iterate-over-all-possi.patch
  0167-do-not-symlink-var-log-to-run-log.patch
  0024-Fixup-mdraid-setup.patch
  0032-mkinitrd-suse.sh-Use-hostonly-and-hostonly-cmdline-c.patch
  0022-95udev-rules-add-persistent-network-rule.patch
  0166-load-xhci-pci.patch
  0047-95resume-skip-module-for-s390-x.patch
  0014-Update-dracut-manpage-for-GRUB-Legacy-and-GRUB2.patch
  0055-95fcoe-Only-install-fcoe-module-if-required.patch
  0078-Restore-original-IFS-value.patch
  0046-dracut-Do-not-wait-for-swap-device.patch
  0074-More-empty-cmdline-fixes.patch
  0112-99base-warn-on-invalid-command-for-initqueue.patch
  0034-dracut-Do-not-stop-installing-drivers-if-one-fails.patch
  0139-dracut.sh-check-for-logfile-logfile-option-and-creat.patch
  0127-99base-Increase-initqueue-timeout-in-non-systemd-cas.patch
  0104-Generate-fallback-mount-unit-for-root-filesystem.patch
  0154-resume-Also-allow-this-module-on-S390-again-s2disk-c.patch
  0149-dracut.sh-Fix-fstab-parsing-again.patch
  0027-90multipath-install-dracut-specific-service-file.patch
  0084-95rootfs-block-Correctly-terminate-commandline-param.patch
  dracut_v37_to_HEAD.patch
  0128-90lvm-Install-dm-snapshot-module.patch
  0063-90multipath-Install-libgcc_s-library.patch
  0062-95iscsi-Install-libgcc_s-library.patch
  0146-dracut.sh-corrected-logfile-check.patch
  0071-Fix-non-export-of-journal-dev-boot-options.patch
  0044-Add-find-to-debug-binaries.patch
  0039-Remove-force-parameter-from-mkinitrd.patch
  0026-90multipath-add-67-kpartx-compat.rules.patch
  0099-90multipath-Load-device_handler-modules-early-during.patch
  0029-90multipath-install-correct-multipath-rules.patch
  0031-90multipath-Fixup-service-file-for-booting.patch
  0036-95fcoe-Store-current-configuration-in-dracut-cmdline.patch
  A patch (dracut_v041_to_HEAD.patch) is being added without being properly referenced from the changelog.
  0151-Go-back-to-xz-again-pixz-may-use-too-much-memory-whi.patch
  0069-81cio_ignore-skip-module-if-cio_ignore-is-not-active.patch
  0070-81cio_ignore-rewrite-module.patch
  0033-95iscsi-Set-correct-iscsi_started-value-for-iSCSI-fi.patch
  0098-Do-not-call-lvm-for-non-LVM-device-mapper-devices.patch
  0023-systemd-always-tries-to-load-autofs4.patch
  0051-mkinitrd-suse-add-update-bootloader-message.patch
  0013-mkinitrd-suse-do-not-update-bootloader-if-no-kernel-.patch
  0115-Handle-module-alias-properly.patch
  0054-95iscsi-update-commandline-printing.patch
  0148-dracut.sh-Fix-LABEL-and-other-fstab-syntax.patch
  0122-btrfs-btrfs-dump-super-and-btrfs-select-super-do-not.patch
  0045-40network-add-missing-_arch-variable-declaration.patch
  0050-95iscsi-strip-one-set-of-quotes-when-calling-initque.patch
  0152-Add-a-comment-to-easily-add-debug-modules-also-add-v.patch
  0147-dracut.sh-Fix-UUID-fstab-parsing-in-case-mount-optio.patch
  0038-95fcoe-start-lldpad-separately.patch
  0082-00warpclock-check-for-sbin-hwclock.patch
  0155-iscsi-iscsi.initiator-and-others-can-and-must-only-s.patch
  0037-95fcoe-update-fcoe-interface-check.patch
  0141-iscsi-Avoid-bad-ip-route-call-on-empty-address.patch
  0049-95iscsi-Use-ip-ibft-for-ibft-autoconfiguration.patch
  0153-Only-add-network-module-on-request-and-on-dependenci.patch
  0097-Implement-rd.timeout-to-modify-the-device-timeout.patch
  0169-fix-systemd-vconsole.patch
  0073-Don-t-create-lots-of-empty-cmdline-files-for-hostonl.patch
  0103-Fixup-missing-separators-in-rootfs-block-cmdline.patch
  0064-90kernel-modules-install-scsi_dh_alua.patch
  0012-Check-for-plymouth-lib-directories.patch
  0092-dracut-nbd-Only-complain-of-missing-binary-in-hoston.patch
  0160-nfs-Add-ip-.-and-root-nfs.-parameters-to-internal-dr.patch
  0093-95iscsi-generate-commandline-for-software-iscsi.patch
  0040-95fcoe-skip-VLAN-devices-in-fcoe-up.patch
  0156-dracut.usage.asc-Remove-distro-specific-help-from-ma.patch
  0018-mkinitrd-suse-Fix-whitespaces-when-adding-drivers.patch
  0140-dracut.sh-Avoid-duplicate-devices-in-host_devs.patch
  0095-95iscsi-use-static-configuration-for-software-iscsi.patch
  0025-95udev-rules-Add-59-scsi-sg_utils.rules.patch
  0072-Also-export-root-boot-param-for-hostonly-cmdline-cas.patch
  0102-Align-dev_unit_name-with-systemd-s-function.patch
  0001-kernel-modules-Fix-storage-module-selection-for-sdhc.patch
- Added dracut_v041_to_HEAD.patch: new patch from v041 against our git
* Fri Feb 27 2015 sfalken@opensuse.org
- Add patch to load logitech-hidpp module in default initrd, fixes
  issues with not being able to enter LUKS password with logitech
  wireless keyboards (boo#918938)
  + Added: 0170-enable-logitech-hidpp.patch
* Mon Feb 23 2015 meissner@suse.com
- dracut-fix-systemd-vconsole.patch: patch from upstream to start
  the vconsole for new systemd.
  + Added 0169-fix-systemd-vconsole.patch
* Tue Feb 17 2015 sfalken@opensuse.org
- Add patch to remove PLYMOUTH_LOGO_FILE from
  modules.d/50plymouth/plymouth-populate-initrd.sh (bnc#910952)
  + 0168-remove_plymouth_logo_file.patch
* Mon Feb  9 2015 dimstar@opensuse.org
- Do no longer package 02caps: patch 90 takes care of removing it.
* Thu Feb  5 2015 meissner@suse.com
- regenerate the initrds on updating this package (or the -fips
  subpackage)
* Sun Feb  1 2015 tchvatal@suse.com
- Apply patch for systemd-journald SIGTERMing on boot bnc#915575
  * 0167-do-not-symlink-var-log-to-run-log.patch
* Sat Jan  3 2015 bwiedemann@suse.com
- add 0166-load-xhci-pci.patch
  load xhci-pci on Linux-3.18+ to allow USB-keyboard to give LUKS PW
  (bnc#911319)
* Wed Dec 17 2014 schwab@suse.de
- 0001-kernel-modules-Fix-storage-module-selection-for-sdhc.patch: fix
  storage module selection for sdhci/mmc/ahci
* Sat Nov 22 2014 arvidjaar@gmail.com
- add 0165-Order-root-fsck-after-pre-mount.patch
  ensure root fsck runs after dracut-pre-mount.service which calls
  resume (bnc#906592)
* Wed Oct 15 2014 trenn@suse.de
- dracut-initrd-restore.patch: dracut-shutdown.service invokes
  dracut-initramfs-restore script which will never work in
  openSUSE because initrd images are named initrd not initramfs.
  Patch is from: Cristian Rodríguez <crrodriguez@opensuse.org>
  * Add 0164-Fix-initramfs-ver.img-vs-initrd-ver-in-dracut-initra.patch
* Wed Oct  8 2014 spargaonkar@suse.com
- Overwrite/generate modules.dep file using depmod since the file
  modules.dep is not portable across releases (bsc#874621).
* Thu Oct  2 2014 trenn@suse.de
- Fix install-kernel with xen for self build kernels to show up in grub2
  properly (bsc#897901)
  * Modify dracut-installkernel (source file)
- Fix foreign fonts in plymouth and console (bnc#897972)
  * Add 0163-Install-etc-sysconfig-console-to-see-specific-fonts.patch
* Wed Sep 24 2014 trenn@suse.de
- Add ip= and root=nfs.. to dracut internal cmdline to make nfsroot working
  (bnc#896464)
  * Add 0160-nfs-Add-ip-.-and-root-nfs.-parameters-to-internal-dr.patch
- Fix error message in case there is no internal dracut cmdline added
  Simple fix
  * Add 0161-Fix-error-message-when-there-are-no-internal-kernel-.patch
- Request DHCP lease instead of getting/applying the offer
  No bug number, but Pawel rated this high prio. This should hit SLE12 still.
  * Add 0162-network-Request-DHCP-lease-instead-of-getting-applyi.patch
* Mon Sep 22 2014 trenn@suse.de
- Try to load xennet driver in network module (if loaded).
  bnc#896464, bnc#896259
  * Add 0159-network-Try-to-load-xennet.patch
* Thu Sep 11 2014 trenn@suse.de
- dracut.usage.asc: Remove distro specific help from manpage (bnc#895363)
  * Add 0156-dracut.usage.asc-Remove-distro-specific-help-from-ma.patch
- Add /boot/zipl to host devs if it is a mount point (bnc#892187)
  * Add 0157-Add-boot-zipl-to-host-devs-if-it-is-a-mount-point.patch
- Add SUSE kernel module dependencies (in /etc/modprobe.d/*) (bnc#895331)
  * Add 0158-Add-SUSE-kernel-module-dependencies-in-etc-modprobe..patch
* Thu Sep  4 2014 trenn@suse.de
- Network module may take quite a lot of initrd space. Do not add it
  unconditionally (bnc#892851)
  * Add 0153-Only-add-network-module-on-request-and-on-dependenci.patch
- S390x can do s2disk, allow resume module there
  (bnc#889795)
  * Add 0154-resume-Also-allow-this-module-on-S390-again-s2disk-c.patch
- Harden iscsi parameter checking. No bug report, but this problem
  was found during multipath testing and happens with 2 or more
  iscsi devices.
  * Add 0155-iscsi-iscsi.initiator-and-others-can-and-must-only-s.patch
* Fri Aug 29 2014 trenn@suse.de
- Do not blindly try to touch the logfile (bnc#893219)
  * Add 0146-dracut.sh-corrected-logfile-check.patch
- Only fix UUID= fstab parsing
  * Add 0147-dracut.sh-Fix-UUID-fstab-parsing-in-case-mount-optio.patch
- Also fix other parsing syntax in fstab like LABEL=
  * Add 0148-dracut.sh-Fix-LABEL-and-other-fstab-syntax.patch
- Fix up some bugs from previous commit
  * Add 0149-dracut.sh-Fix-fstab-parsing-again.patch
- bnc#893615
  * Add 0150-Find-kernel-modules-in-extra-and-weak-updates-path-a.patch
- pixz does need too much memory, go back to xz in a conservative way
  (bnc#893981)
  * Add 0151-Go-back-to-xz-again-pixz-may-use-too-much-memory-whi.patch
- Add some default tools to initrd when debug module is included and
  already provided an commented example line how to easily enable it.
  No functional change by default.
  * Add 0152-Add-a-comment-to-easily-add-debug-modules-also-add-v.patch
* Thu Aug 21 2014 trenn@suse.de
- dracut.sh: check for logfile (--logfile option) and create it if necessary
  Add 0139-dracut.sh-check-for-logfile-logfile-option-and-creat.patch
- Avoid duplicate names in host_devs
  Add 0140-dracut.sh-Avoid-duplicate-devices-in-host_devs.patch
- iscsi: Avoid bad ip route call on empty address
  Add 0141-iscsi-Avoid-bad-ip-route-call-on-empty-address.patch
- 40network: Don't report error for .../ifroute-* during module setup
  Add 0142-40network-Don-t-report-error-for-etc-sysconfig-netwo.patch
- iscsi: Fix up ipv6 in brackets , iterate over all needed iscsi mounts
  Add 0143-iscsi-Fix-up-ipv6-in-brackets-iterate-over-all-possi.patch
- 90crypt: Fixed crypttab_contains() to also work with device in /etc/crypttab
  Add 0144-90crypt-Fixed-crypttab_contains-to-also-work-with-de.patch
- 40network: handle 'ip=ifname:static' correctly (bnc#892801)
  Add 0145-40network-handle-ip-ifname-static-correctly.patch
* Thu Aug 14 2014 trenn@suse.de
- Allow multiple configurations per network interface (bnc#887906)
  Add 0133-Allow-multiple-configurations-per-network-interface-.patch
- Remove bootdev warning (bnc#881112)
  Add 0134-Remove-bootdev-warning-bnc-881112.patch
- check for existance of 69-dm-lvm-metad.rules in modules_setup.sh, lvm module
  (bnc#891791)
  Add 0135-lvm-Fix-12819a579900b9691e2-check-for-existance-of-6.patch
- Moved persistent network rule revert to another file (was not in github):
  Delete: 0133-Remove-70-persistent-net.rules.patch
  Add:    0136-Revert-95udev-rules-add-persistent-network-rule.patch
- dracut-use-fipscheck-openssl.patch: Switch from Mozilla NSS sha256hmac
  checking to fipscheck as recommended
  Add: 0137-Switch-from-Mozilla-NSS-sha256hmac-checking-to-fipsc.patch
- warpclock: Do not use warpclock module on S390(x), hwclock does not exist
  there (bnc#884513)
  Add 0138-warpclock-Do-not-use-warpclock-module-on-S390-x-hwcl.patch
* Tue Aug  5 2014 trenn@suse.de
- 99base: Increase initqueue timeout in non systemd case (bnc#887402)
  * Add: 0127-99base-Increase-initqueue-timeout-in-non-systemd-cas.patch
- 90lvm: Install dm-snapshot module (bnc#888530)
  * Add: 0128-90lvm-Install-dm-snapshot-module.patch
- Revert commit 6ecab258710d158a7a6 and only do not wait for swap via
  parameter (bnc#882812)
  * Add: 0129-Revert-commit-6ecab258710d158a7a6-and-only-do-not-wa.patch
- nfs: Always add all kernel modules for kdump (bnc#887906)
  * Add: 0130-nfs-Always-add-all-kernel-modules-for-kdump.patch
- 40network: handle prefixed IP addresses correctly (bnc#880108)
  * Add: 0131-40network-handle-prefixed-IP-addresses-correctly.patch
- 40network: fixup static network configuration
  * Add: 0132-40network-fixup-static-network-configuration.patch
- Remove 70-persistent-net.rules
  * Add: 0133-Remove-70-persistent-net.rules.patch
* Mon Jul 21 2014 hare@suse.de
- mkinitrd-suse.sh: Bail out with exit 1 if initrd cannot be generated
  (bnc#886630)
  * Add: 0120-mkinitrd-suse.sh-Bail-out-with-exit-1-if-initrd-cann.patch
- Adjust initramfs-$kernel.img to SUSE default: initrd-$kernel
  (bnc#882306)
  * Add: 0121-Adjust-initramfs-kernel.img-to-SUSE-default-initrd-k.patch
- btrfs: btrfs-dump-super and btrfs-select-super do not exist
  (bnc#886883)
  * Add: 0122-btrfs-btrfs-dump-super-and-btrfs-select-super-do-not.patch
- 95zfcp_rules: fix typo in module_setup (bnc#887582)
  * Add: 0123-95zfcp_rules-fix-typo-in-module_setup.patch
- 40network: Update iBFT scanning code to handle IPv6 (bnc#887542)
  * Add: 0124-40network-Update-iBFT-scanning-code-to-handle-IPv6.patch
- 40network: separate 'mask' and 'prefix' (bnc#887542)
  * Add: 0125-40network-separate-mask-and-prefix.patch
- 01fips: Add drbg module to force loaded modules (bnc#875855)
  * Add: 0126-01fips-Add-drbg-module-to-force-loaded-modules.patch
* Mon Jul 14 2014 trenn@suse.de
- Fixup executable bits of newly patched files manually in spec file
  bnc#887117
* Mon Jul 14 2014 hare@suse.de
- Mark all scripts as executable (bnc#887010)
  * Remove: 0116-81cio_ignore-Mark-scripts-as-executable
  * Add: 0116-Mark-scripts-as-executable.patch
- 95dasd_rules: Enable device before checking type
  * Add: 0117-95dasd_rules-Enable-the-device-before-checking-devic.patch
- 95zfcp_rules: Enable device before checking type
  * Add: 0118-95zfcp_rules-Enable-the-device-before-checking-devic.patch
- Reset IFS variable
  * Add: 0119-Reset-IFS-variable.patch
* Sat Jul 12 2014 hare@suse.de
- Handle module alias properly (bnc#886839)
  * Add: 0115-Handle-module-alias-properly.patch
- 81cio_ignore: Mark scripts as executable (bnc#887010)
  * Add: 0116-81cio_ignore-Mark-scripts-as-executable.patch
* Fri Jul 11 2014 hare@suse.de
- 91zipl: Translate 'ext2' into 'ext4' module
  * Add: 0114-91zipl-Translate-ext2-3-into-ext4.patch
* Thu Jul 10 2014 hare@suse.de
- Enable converting of directory /var/run /var/lock to symlinks
  (bnc#877680)
  * Add: 0106-dracut-Enable-converting-of-directory-var-run-var-lo.patch
- Fixup typo 'firmare' instead of 'firmware'
  * Add: 0107-Fixup-typo-firmare-instead-of-firmware.patch
- 91zipl: Store commandline correctly
  * Add: 0108-91zipl-Store-commandline-correctly.patch
- 95dasd_rules: Store all devices in commandline
  * 0109-95dasd_rules-Store-all-devices-in-commandline.patch
- 95zfcp_rules: Store all devices in commandline
  * Add: 0110-95zfcp_rules-Store-all-devices-in-commandline.patch
- 90mdraid: Remove line for 'offroot' detection
  * Add: 0111-90mdraid-Remove-line-for-offroot-detection.patch
- 99base: warn on invalid command for initqueue
  * Add: 0112-99base-warn-on-invalid-command-for-initqueue.patch
- 91zipl: Install script as executable
  * Add: 0113-91zipl-Install-script-as-executable.patch
* Tue Jul  8 2014 hare@suse.de
- Print stored dracut commandline during initramfs build
  * Add: 0101-Print-stored-dracut-commandline-during-initramfs-bui.patch
- Align dev_unit_name() with systemd's function
  * Add: 0102-Align-dev_unit_name-with-systemd-s-function.patch
- Fixup missing separators in rootfs-block cmdline
  * Add: 0103-Fixup-missing-separators-in-rootfs-block-cmdline.patch
- Generate fallback mount unit for root filesystem (bnc#855258)
  * Add: 0104-Generate-fallback-mount-unit-for-root-filesystem.patch
- 95iscsi: parse output from iscsiadm correctly (bnc#886199)
  * Add: 0105-95iscsi-parse-output-from-iscsiadm-correctly.patch
* Thu Jul  3 2014 dsterba@suse.cz
- 90btrfs: Install rescue utilities to initrd
  * Add: 0100-btrfs-add-initrd-rescue-utilities.patch
* Thu Jul  3 2014 hare@suse.de
- 40network: create /var/lib/wicked in ifup.sh (bnc#885141)
  * Add: 0089-40network-create-var-lib-wicked-in-ifup.sh.patch
- dracut: caps: Remove whole caps module
  * Add: 0090-dracut-caps-Remove-whole-caps-module.patch
- dracut: biosdevname: Only install if present
  * Add: 0091-dracut-biosdevname-In-SUSE-biosdevname-package-is-in.patch
- dracut: nbd: Only complain of missing binary in hostonly mode
  if rootfs is on nbd
  * Add: 0092-dracut-nbd-Only-complain-of-missing-binary-in-hoston.patch
- 95iscsi: generate commandline for software iscsi (bnc#880108)
  * Add: 0093-95iscsi-generate-commandline-for-software-iscsi.patch
- Implement shortcut 'ip=<ifname>:static' for static configuration
  * Add: 0094-Implement-shortcut-ip-ifname-static-for-static-confi.patch
- 95iscsi: use static configuration for software iscsi (bnc#884768)
  * Add: 0095-95iscsi-use-static-configuration-for-software-iscsi.patch
- dracut: Fix error: local: can only be used in a function
  * Add: 0096-dracut-Fix-error-local-can-only-be-used-in-a-functio.patch
- Implement 'rd.timeout' to modify the device timeout (bnc#878770)
  * Add: 0097-Implement-rd.timeout-to-modify-the-device-timeout.patch
- Do not call 'lvm' for non-LVM device-mapper devices
  * Add: 0098-Do-not-call-lvm-for-non-LVM-device-mapper-devices.patch
- 90multipath: Load device_handler modules early during boot (bnc#871617)
  * Add: 0099-90multipath-Load-device_handler-modules-early-during.patch
* Fri Jun 27 2014 hare@suse.de
- 91zipl: Add new module for s390x configuration changes (bnc#884743)
  * Add: 0088-91zipl-Add-new-module-to-update-s390x-configuration.patch
* Thu Jun 26 2014 hare@suse.de
- 95dasd_rules: Fixup rd.dasd parsing
  * Add: 0079-95dasd_rules-fixup-rd.dasd-parsing.patch
- 95dasd_rules: Print out rd.dasd command-line
  * Add: 0080-95dasd_rules-print-out-rd.dasd-commandline.patch
- 95dasd_mod: do not set module parameter
  * Add: 0081-95dasd_mod-do-not-set-module-parameters-if-dasd_cio_.patch
- 00warpclock: Check for /sbin/hwclock (bnc#884513)
  * Add: 0082-00warpclock-check-for-sbin-hwclock.patch
- 95zfcp_rules: Fixup rd.zfcp parsing
  * Add: 0083-95zfcp_rules-Fixup-rd.zfcp-parsing.patch
- 95rootfs_block: terminate commandline parameter
  * Add: 0084-95rootfs-block-Correctly-terminate-commandline-param.patch
- 95zfcp_rules: Print out rd.zfcp command-line
  * Add: 0085-95zfcp_rules-print-out-rd.zfcp-commandline-parameter.patch
- 95zfcp_rules: Auto-generate ipl device rule
  * Add: 0086-95zfcp_rules-Auto-generate-udev-rule-for-ipl-device.patch
- 95dasd_rules: Auto-generate ipl device rule
  * Add: 0087-95dasd_rules-Auto-generate-udev-rule-for-ipl-device.patch
* Mon Jun 23 2014 hare@suse.de
- More empty commandline fixes
  * Add: 0074-More-empty-cmdline-fixes.patch
- 95dasd_rules: enable parsing of rd.dasd= commandline parameter
  * Add: 0075-95dasd_rules-enable-parsing-of-rd.dasd-commandline-p.patch
- Correctly set cio_ignore for dynamic s390 rules
  * Add: 0076-Correctly-set-cio_ignore-for-dynamic-s390-rules.patch
- 90multipath: add missing 11-dm-mpath.rules file (bnc#883149)
  * Add: 0077-90multipath-add-missing-11-dm-mpath.rules-file.patch
- Restore original IFS value (bnc#883770)
  * Add: 0078-Restore-original-IFS-value.patch
* Wed Jun 18 2014 tbehrens@suse.com
- Fix non-export of journal dev boot options
  * Add: 0071-Fix-non-export-of-journal-dev-boot-options.patch
- Also export root= boot param for hostonly-cmdline
  * Add: 0072-Also-export-root-boot-param-for-hostonly-cmdline-cas.patch
- Don't create lots of empty cmdline files
  * Add: 0073-Don-t-create-lots-of-empty-cmdline-files-for-hostonl.patch
* Tue Jun 17 2014 hare@suse.de
- 81cio_ignore: rewrite module to not mount any filesystem
  (bnc#882685)
  * Add: 0070-81cio_ignore-rewrite-module.patch
* Tue Jun 17 2014 hare@suse.de
- 81cio_ignore: ignore module if cio_ignore is not specified
  (bnc#882685)
  * Add:
    0069-81cio_ignore-skip-module-if-cio_ignore-is-not-active.patch
* Mon Jun 16 2014 hare@suse.de
- 40network: always start netroot in ifup.sh (bnc#881235)
  * Add: 0066-40network-always-start-netroot-in-ifup.sh.patch
- 95fcoe: check() always returns 255
  * Add: 0067-95fcoe-check-always-returns-255.patch
- 95fcoe-uefi: Test for EFI firmware (bnc#882412)
  * Add: 0068-95fcoe-uefi-Test-for-EFI-firmware.patch
* Fri Jun 13 2014 hare@suse.de
- Rename patches to match git repository:
  * Old: more-fips-adjustments.patch
  * New: 0057-01fips-Include-some-more-hmacs.patch
  * Old: dracut-check-supported.patch
  * New: 0058-dracut-add-warning-when-including-unsupported-module.patch
- Add 99suse module to git repository:
  * Remove: parse-suse-initrd.sh
  * Remove: module-setup-initrd.sh
  * Add: 0059-99suse-Add-SUSE-specific-initrd-parsing.patch
- Add write-ifcfg-suse.sh to git repository:
  * Remove: write-ifcfg-suse.sh
  * Add: 0060-45ifcfg-Add-SUSE-specific-write-ifcfg-file.patch
- Fixup error messages in write-ifcfg-suse.sh (bnc#881286)
  * Add: 0061-45ifcfg-Fixup-error-message-in-write-ifcfg-suse.patch
- Add missing 'libgcc_s.so' library (bnc#881692):
  * Add: 0062-95iscsi-Install-libgcc_s-library.patch
  * Add: 0063-90multipath-Install-libgcc_s-library.patch
- Install missing scsi_dh_alua module (bnc#871617)
  * Add: 0064-90kernel-modules-install-scsi_dh_alua.patch
- 95iscsi: fixup bnx2i offload booting (bnc#855747)
  * Add: 0065-95iscsi-Fixup-bnx2i-offload-booting.patch
* Wed Jun 11 2014 jeffm@suse.com
- Add option to warn if unsupported modules are added to the initramfs
  - Enable this option for 'make install' when a kernel with
    CONFIG_SUSE_KERNEL_SUPPORTED enabled is used. (bnc#882332)
  - Add dracut-check-supported.patch
* Wed Jun 11 2014 meissner@suse.com
- include the several hmacs needed for FIPS integrity checking
  of cryptsetup, libgcrypt, libfipscheck1. Also add the openssl
  HMACs too as someone else seems to use those too.
  Add: more-fips-adjustments.patch
* Wed Jun  4 2014 hare@suse.de
- Rediff patches to match git repository
- 95fcoe: Check for FCoE devices prior to binaries
  * Modify 0055-95fcoe-Only-install-fcoe-module-if-required.patch
- 99base: Install chown instead of chgrp
  * Modify 0052-99base-Add-chown-binary.patch
- 95iscsi: do not try to detect iSCSI firmware during booting;
  should be handled via commandline parameter
  * Modify 0030-95iscsi-Autodetect-iSCSI-firmware.patch
- Rename patch:
  * old: 0051-mkinitrd-suse-add-update-booloader-message.patch
    new: 0051-mkinitrd-suse-add-update-bootloader-message.patch
* Wed Jun  4 2014 hare@suse.de
- Rename patches to match git repository:
  * old: 0013-Correct-paths-for-openSUSE.patch
    new: 0011-Correct-paths-for-openSUSE.patch
  * old: 0014-Check-for-plymouth-lib-directories.patch
    new: 0012-Check-for-plymouth-lib-directories.patch
  * old: dracut_do_not_update_booloader_if_no_kernel_is_found.patch
    new: 0013-mkinitrd-suse-do-not-update-bootloader-if-no-kernel-.patch
  * old: suse_grub_manpage.patch
    new: 0014-Update-dracut-manpage-for-GRUB-Legacy-and-GRUB2.patch
  * old: replace_dhclient_with_wickedd_dhcp_supplicants.patch
    new: 0015-40network-replace-dhclient-with-wickedd-dhcp-supplic.patch
  * old: 0015-add-new-s390x-specific-rule-files.patch
    new: 0016-Add-new-s390x-specific-rule-files.patch
  * old: change_write_ifcfg_to_suse.patch
    new: 0017-45ifcfg-use-distro-specific-scripts.patch
  * old: dracut-fix-whitespace-add-drivers_call.patch
    new: 0018-mkinitrd-suse-Fix-whitespaces-when-adding-drivers.patch
  * old: wait_for_network_race_condition_fix.patch
    new: 0019-40network-Fix-race-condition-when-wait-for-networks.patch
  * old: dracut-warpclock_module.patch
    new: 0020-00warpclock-Set-correct-timezone.patch
  * old: s390-dcssblk.patch
    new: 0021-95dcssblk-Add-new-module-for-DCSS-block-devices.patch
  * old: dracut-install-persistent-rule.patch
    new: 0022-95udev-rules-add-persistent-network-rule.patch
  * old: dracut-really-always-add-autofs4.patch
    new: 0023-systemd-always-tries-to-load-autofs4.patch
  * old: mdraid-setup.patch
    new: 0024-Fixup-mdraid-setup.patch
  * old: 0015-95udev-rules-Add-59-scsi-sg_utils.rules.patch
    new: 0025-95udev-rules-Add-59-scsi-sg_utils.rules.patch
  * old: 0016-90multipath-add-67-kpartx-compat.rules.patch
    new: 0026-90multipath-add-67-kpartx-compat.rules.patch
  * old: 0017-90multipath-install-dracut-specific-service-file.patch
    new: 0027-90multipath-install-dracut-specific-service-file.patch
  * old: 0020-95udev-rules-Include-correct-sg3_utils-rules.patch
    new: 0028-95udev-rules-Include-correct-sg3_utils-rules.patch
  * old: 0021-90multipath-install-correct-multipath-rules.patch
    new: 0029-90multipath-install-correct-multipath-rules.patch
  * old: add_dracuts_network_params_for_iscsi.patch
    new: 0030-95iscsi-Autodetect-iSCSI-firmware.patch
  * old: 0022-90multipath-Fixup-service-file-for-booting.patch
    new: 0031-90multipath-Fixup-service-file-for-booting.patch
  * old: 0023-mkinitrd-suse.sh-Use-hostonly-and-hostonly-cmdline-c.patch
    new: 0032-mkinitrd-suse.sh-Use-hostonly-and-hostonly-cmdline-c.patch
  * old: 0024-95iscsi-Set-correct-iscsi_started-value-for-iSCSI-fi.patch
    new: 0033-95iscsi-Set-correct-iscsi_started-value-for-iSCSI-fi.patch
  * old: 0025-dracut_continue_adding_modules_also_on_error.patch
    new: 0034-dracut-Do-not-stop-installing-drivers-if-one-fails.patch
  * old: 0026-force_to_add_and_load_kernel_modules_other_than_via_boot_param.patch
    new: 0035-Introduce-force-drivers-parameter-and-force_drivers-.patch
  * old: 0027-95fcoe-Store-current-configuration-in-dracut-cmdline.patch
    new: 0036-95fcoe-Store-current-configuration-in-dracut-cmdline.patch
  * old: 0028-95fcoe-update-fcoe-interface-check.patch
    new: 0037-95fcoe-update-fcoe-interface-check.patch
  * old: 0029-95fcoe-start-lldpad-separately.patch
    new: 0038-95fcoe-start-lldpad-separately.patch
  * old: 0030-dracut-mkinitd_cleanup_force_host_only_var.patch
    new: 0039-Remove-force-parameter-from-mkinitrd.patch
  * old: 0031-95fcoe-skip-VLAN-devices-in-fcoe-up.patch
    new: 0040-95fcoe-skip-VLAN-devices-in-fcoe-up.patch
  * old: 0033-dracut_hostonly_hostonly_cmdline_default.patch
    new: 0041-mkinitd-suse-remove-hostonly-and-hostonly-cmdline.patch
  * old: 0034-suse.conf.example_extend.patch
    new: 0042-Enhance-suse.conf-example-with-SUSE-specific-setting.patch
  * old: 0035-always_add_network.patch
    new: 0043-40network-always-add-network-module.patch
  * old: 0036-add_extra_debug_binaries.patch
    new: 0044-Add-find-to-debug-binaries.patch
  * old: 0037-fix_s390_network_modules_install.patch
    new: 0045-40network-add-missing-_arch-variable-declaration.patch
  * old: 0038-remove_waiting_for_swap_dev.patch
    new: 0046-dracut-Do-not-wait-for-swap-device.patch
  * old: 0039-s390_no_resume_module.patch
    new: 0047-95resume-skip-module-for-s390-x.patch
  * old: 0041-only_enable_network_if_explicitly_requested.patch
    new: 0048-40network-Only-enable-network-interfaces-if-explicit.patch
  * old: 0042-ibft_autoconfig_param.patch
    new: 0049-95iscsi-Use-ip-ibft-for-ibft-autoconfiguration.patch
  * old: 0043-fcoe_strip_quotes.patch
    new: 0050-95iscsi-strip-one-set-of-quotes-when-calling-initque.patch
  * old: 0044-Add_update_bootloader_msg.patch
    new: 0051-mkinitrd-suse-add-update-booloader-message.patch
  * old: 0045-add-chown_binary.patch
    new: 0052-99base-Add-chown-binary.patch
  * old: dracut-fips-module-loading-fixes.patch
    new: 0053-01fips-fixup-loading-issues.patch
  * old: 0046-ibft_update_cmdline_printing.patch
    new: 0054-95iscsi-update-commandline-printing.patch
  * old: 0047-only_install_fcoe_if_required.patch
    new: 0055-95fcoe-Only-install-fcoe-module-if-required.patch
  * old: 0048-cio_ignore.patch
    new: 0056-81cio_ignore-handle-cio_ignore-commandline.patch
* Mon Jun  2 2014 trenn@suse.de
- Mount zipl device on S390 (bnc#874902)
  Add 0048-cio_ignore.patch
* Mon Jun  2 2014 trenn@suse.de
- Only install fcoe if required
  and suppress require-binaries output
  Add 0047-only_install_fcoe_if_required.patch
- ibft: Correctly show ibft cmdline via print-cmdline
  Add 0046-ibft_update_cmdline_printing.patch
* Mon Jun  2 2014 meissner@suse.com
- dracut-fips-module-loading-fixes.patch: bnc#875855
  - adjust FIPS module list
  - on architecture specific modules, failing loading is not
    critical
- ship 98selinux, for people that want to use SELinux.
* Wed May 28 2014 trenn@suse.de
- Update to latest git HEAD: commit 0fa5dbedc5b222435f51f7460a81232ee120c4e1
  Tue May 20 13:23
  Modified dracut_v37_to_HEAD.patch
  Modified mdraid-setup.patch
  Modified dracut-install-persistent-rule.patch
  Removed  0032-98systemd-fixup-rootfs-generator-installation-path.patch
- Add /etc/dracut.d.conf/01-dist modifications to file instead of writing
  to it via rpm build section
  Add 0033-dracut_hostonly_hostonly_cmdline_default.patch
  Add 0034-suse.conf.example_extend.patch
- Cleanup mkinitrd-suse.sh:
  * Remove hostonly and hostonly-cmdline -> this is done via 01-dist config
    file now
- Always add network module based on modules_setup.sh check() function and not
  via 01-dist config file
  Add 0035-always_add_network.patch
- Add find to debug binaries - Useful and harmless
  Add 0036-add_extra_debug_binaries.patch
- Fix adding of network modules for s390 (bnc#879302)
  Add 0037-fix_s390_network_modules_install.patch
- Omit resume module on s390(x) - There is no suspend on s390
  Add 0039-s390_no_resume_module.patch
- Do not wait for swap - This causes trouble with Rudi's autobuild images:
  Add 0038-remove_waiting_for_swap_dev.patch
- Fcoe and ibft fixes (bnc#879038):
  Add 0041-only_enable_network_if_explicitly_requested.patch
  Add 0042-ibft_autoconfig_param.patch
  Add 0043-fcoe_strip_quotes.patch
- Print message when starting to update bootloader
  Add 0044-Add_update_bootloader_msg.patch
- ToDo: Pass hostonly variable earlier so that is always avail in check()
  function. Still already add:
  Add 0040-fcoe_fix_check_function.patch
- Add chown to initrd (bnc#879767)
  Add 0045-add-chown_binary.patch
- Use parallel pixz instead of xz binary to compress the initrd
* Tue May 20 2014 trenn@suse.de
- From Hannes Reinecke <hare@suse.com>:
  fixup rootfs-generator installation path (bnc#878714)
  Add 0032-98systemd-fixup-rootfs-generator-installation-path.patch
* Mon May 19 2014 trenn@suse.de
- Corrected previous patch
  Modified: 0031-95fcoe-skip-VLAN-devices-in-fcoe-up.patch
* Mon May 19 2014 trenn@suse.de
- From Hannes Reinecke <hare@suse.com>:
  skip VLAN devices in fcoe-up (bnc#878583)
  Add: 0031-95fcoe-skip-VLAN-devices-in-fcoe-up.patch
* Thu May 15 2014 trenn@suse.de
- By Hannes Reinecke <hare@suse.com>:
  - Fixup FCoE booting (bnc#877288)
  * Add 0027-95fcoe-Store-current-configuration-in-dracut-cmdline.patch
  * Add 0028-95fcoe-update-fcoe-interface-check.patch
  * Add 0029-95fcoe-start-lldpad-separately.patch
- Cleanup host_only variable using in mkinitrd
- Remove --force parameter from mkinitrd, we always force anyway
  * Add 0030-dracut-mkinitd_cleanup_force_host_only_var.patch
- Remove acpi parameter from mkinitrd, this is done differently nowadays
- Adjust manpage accordingly
* Wed May 14 2014 meissner@suse.com
- also do the service magic in %%post/%%postun, otherwise
  purge-kernels will not get enabled.
* Wed May  7 2014 trenn@suse.de
- Do not inst binaries explicitly into /bin or /usr/bin, it is already taken
  care of internally for that:
    Delete 0006-Install-bin-mount.patch
    Modify 0013-Correct-paths-for-openSUSE.patch
- Do not stop trying to load drivers (via add-drivers or filesystems) if one
  fails
    Add 0025-dracut_continue_adding_modules_also_on_error.patch
- Introduce force-drivers. mkinitrd should use this one instead of add-drivers
  later, if accepted mainline
    Add
  0026-force_to_add_and_load_kernel_modules_other_than_via_boot_param.patch
* Mon May  5 2014 hare@suse.de
- Update add_dracuts_network_params_for_iscsi.patch to detect
  be2iscsi firmware devices
- Remove obsolete patch fix-iscsi-firmware.sh
- Fixup iscsi firmware booting with be2iscsi (bnc#873448):
  Added 0024-95iscsi-Set-correct-iscsi_started-value-for-iSCSI-fi.patch
- Renamed mkinird_differ_host_and_cmdline_only_properly.patch to
  0023-mkinitrd-suse.sh-Use-hostonly-and-hostonly-cmdline-c.patch
* Wed Apr 30 2014 trenn@suse.de
- Update to lateste git HEAD 48b7ab1b35adf1f3f09f883ef14ea0a3fba1e468
    Added:     dracut_v37_to_HEAD.patch
    Modified:  0013-Correct-paths-for-openSUSE.patch
    Modified:  mdraid-setup.patch
    Modified:  replace_dhclient_with_wickedd_dhcp_supplicants.patch
    Deleted:   0018-fstab-do-not-mount-and-fsck-from-fstab-if-using-syst.patch
    Deleted:   0019-dracut-initqueue-service-runs-before-remote-fs-pre.t.patch
- Fix lvm and other possible not working thing due to new parameter:
  hostonly-cmdline which has to be active by default
    bnc#874000 bnc#874905 bnc#874363
    Added:     mkinird_differ_host_and_cmdline_only_properly.patch
- Make write-ifcfg-suse.sh more update robust
  Avoid rebasing of diff with every update touching this file by adding
  write-ifcfg-suse.sh as source file and copy/link in .spec file.
    Modified:  change_write_ifcfg_to_suse.patch
* Tue Apr 29 2014 meissner@suse.com
- consolidate -fips-aesni into -fips again. The problem due to it
  was split off upstream was solved in the kernel.
* Fri Apr 25 2014 meissner@suse.com
- Create new -fips and -fips-aesni subpackage for kernel
  integrity checking. bnc#856310 FATE#316930
- add spaces around "network" in 01-dist.conf, as the addmodules
  list is concatenated and you never know which config is before or
  after and what it does.
* Wed Apr 16 2014 hare@suse.de
- Enable multipath correctly during booting (bnc#873686)
  Add: 0022-90multipath-Fixup-service-file-for-booting.patch
* Mon Apr 14 2014 pwieczorkiewicz@suse.com
- fix-iscsi-firmware.patch:
  Fix according to dracut-037 updates (iscsistarted-iscsi:).
* Mon Apr 14 2014 pwieczorkiewicz@suse.com
- add_dracuts_network_params_for_iscsi.patch:
  Add missing dracut's cmdline parameters to make network mandatory
  and boot using iBFT when present. Without them iBFT booting does
  not work.
* Fri Apr 11 2014 hare@suse.de
- Install correct rule files for multipath support (bnc#873151)
  Add: 0020-95udev-rules-Include-correct-sg3_utils-rules.patch
  Add: 0021-90multipath-install-correct-multipath-rules.patch
* Thu Apr 10 2014 trenn@suse.de
- Do not always try to add iscsi module, let its check function decide
- Compress initrd with xz --check=crc32 -6 by default
* Wed Apr  9 2014 crrodriguez@opensuse.org
- Remove the bootchart module, note that we still keep
  the systemd-bootchart one which provides similar functionality.
* Wed Apr  9 2014 crrodriguez@opensuse.org
- Remove the busybox module we have all basic tools already
  in the initrd
- _unitdir is always defined nowadays, remove the conditionals.
* Wed Apr  9 2014 sfalken@opensuse.org
- Replaced dracut tarball with proper upstream tarball
  Add: dracut-037.tar.xz
* Tue Apr  8 2014 hare@suse.de
- Update dracut to 037
  * Add --hostonly_cmdline switch
  * Update --mount syntax
  * Include modules from /updates directory
  * Fixes for network setup
  * Some small fixes
- Rediff patches
- Include iscsiuio again (bnc#872474)
  Remove: remove-iscsiuio.patch
- Install 59-scsi-sg_utils.rules (bnc#872478)
  Add: 0015-95udev-rules-Add-59-scsi-sg_utils.rules.patch
- Install 67-kpartx-compat.rules (bnc#872662)
  Add: 0016-90multipath-add-67-kpartx-compat.rules.patch
- Install separate multipath service file (bnc#871610)
  Add: 0017-90multipath-install-dracut-specific-service-file.patch
- Do not fsck and mount from fstab if systemd is used (bnc#
  Add: 0018-fstab-do-not-mount-and-fsck-from-fstab-if-using-syst.patch
- Fixup initqueue for remote-fs
  Add: 0019-dracut-initqueue-service-runs-before-remote-fs-pre.t.patch
* Thu Apr  3 2014 crrodriguez@opensuse.org
- revert last change, ucode-intel is not mandatory and
  will get installed by default anyway, either via patterns
  or by modalias dependencies in the package itself.
* Thu Apr  3 2014 crrodriguez@opensuse.org
- Require package ucode-intel in x86*
* Tue Apr  1 2014 nfbrown@suse.com
- mdraid-setup.patch
  Make mdraid scripts work with latest mdadm.
  Without this, boot from DDF or IMSM array fails if
  one device is missing (bnc#866660)
* Fri Mar 28 2014 trenn@suse.de
- systemd always tries to load autofs4 otherwise it reports:
  Failed to insert module 'autofs4'
  dracut already adds it, but only if loaded already.
  Always load autofs4 even if not already loaded (bnc#869411)
  Add: dracut-really-always-add-autofs4.patch
* Tue Mar 25 2014 trenn@suse.de
- Fix installkernel script bnc#862990
* Fri Mar 14 2014 rmilasan@suse.com
- Add support for 70-persistent-net.rules in dracut (bnc#868375)
  Add: dracut-install-persistent-rule.patch
* Fri Mar 14 2014 trenn@suse.de
- CRITICAL: Fix add-drivers passing from mkinitrd to dracut bnc#868397
* Wed Mar 12 2014 trenn@suse.de
- Add s390 dcssblk driver and introduce rd.dcssblk= to pass mounts that should
  get activated at initrd stage fate#308263
  Add: s390-dcssblk.patch
* Fri Mar  7 2014 trenn@suse.de
- bnc#830060 - Dracut is missing warpclock/hwclock
  Add dracut-warpclock_module.patch
* Wed Mar  5 2014 pwieczorkiewicz@suse.com
- wait_for_network_race_condition_fix.patch:
  * In case of no network related params are specified, but rd.neednet=1
    is set, default initqueue action is to wait until one of the network
    interfaces is marked as set up properly. (bnc#866771)
  * It also helps with initqueue's race condition when network interface
    shows up late.
- replace_dhclient_with_wickedd_dhcp_supplicants.patch:
  Add a missing network setup flag. (bnc#866771)
* Mon Mar  3 2014 trenn@suse.de
- Merge all dracut-* packages to one dracut.rpm package.
  Subpackages only had one or two minor files not worth splitting a package
  or dracut-network had important modules which should (like former main
  dracut package) always get installed
- libcap does not exist and libcap2 or friends are not needed
  - > remove Requires: libcap
- Reorder (sort) the files section a bit
* Mon Mar  3 2014 trenn@suse.de
- Fix bug introduced with last commit: Bad whitespace logic when
  INITRD_MODULES contain more than one module.
* Thu Feb 27 2014 trenn@suse.de
- Make sure that --add-drivers is not called with whitespace string which
  will lead to a "read line" user input request and things may get stuck at
  installation.
  - Add: dracut-fix-whitespace-add-drivers_call.patch
- Remove s390 grub module again -> this will go into grub2 package
  (ask rw@suse.de for details)
  Delete/remove: s390_add-user-space-grub-rule.patch
- Add installkernel script which installs the kernel when:
  make install
  is invoked. The script from mkinitrd has been taken over and adopted.
  Added source: dracut-installkernel
  bnc#862990
* Fri Feb 21 2014 trenn@suse.de
- Fix syntax error -> missing then
- Correct path, it is /usr/bin/grub2-emu
* Mon Feb 17 2014 trenn@suse.de
- autofs4 is always included since mainline git commit: 314929920f27448b45bfd
  systemd: ensure autofs4 and ipv6 are included
- Always add network and iscsi dracut module, so that ibft, iscsi, nfsroot
  work as expected.
* Fri Feb 14 2014 pwieczorkiewicz@suse.com
- change_write_ifcfg_to_suse.patch:
  Detect the system flavor and write the ifcfg files accordingly.
* Fri Feb 14 2014 trenn@suse.de
  Originally by Hannes Reinecke (hare@suse.de):
- Install new s390x specific udev rules (bnc#856585)
  - Add: 0015-add-new-s390x-specific-rule-files.patch
- Do not check for non-existing dasd_configure for s390x (bnc#856585)
* Thu Feb 13 2014 jjolly@suse.com
- Added 95grub2 module for s390x
* Thu Feb 13 2014 pwieczorkiewicz@suse.com
- remove-iscsiuio.patch:
  Remove iscsiuio references as this one is not present in SLE-12.
* Thu Feb 13 2014 pwieczorkiewicz@suse.com
- fix-iscsi-firmware.patch:
  Fix iSCSI iBFT boot up problem introduced with mainline changes
* Thu Feb 13 2014 pwieczorkiewicz@suse.com
- replace_dhclient_with_wickedd_dhcp_supplicants.patch:
  Replace dhclient with wickedd-dhcp4 and wickedd-dhcp6. Script up dhcp
  functionality in ifup.sh.
* Thu Feb 13 2014 sfalken@opensuse.org
-Added bug number to previous changelog entry
* Thu Feb 13 2014 sfalken@opensuse.org
-Updated suse_grub_manpage.patch to further correct for incorrect grub configuration paths
  bnc#858448
* Wed Feb 12 2014 sfalken@opensuse.org
-Updated suse_grub_manpage.patch for dracut-036
* Wed Feb 12 2014 sfalken@opensuse.org
-Added patch to fix manpage to reflect openSUSE GRUB Legacy and GRUB2
- removed patches:
  * dracut_git_v034_to_head.patch
* Sun Feb  9 2014 tchvatal@suse.com
- Cleanup with spec-cleaner.
* Sun Feb  9 2014 tchvatal@suse.com
- Version bump to 036 removing the need for patching from git.
- removed patch:
  * dracut_git_v034_to_head.patch
* Fri Jan 31 2014 trenn@suse.de
- Do not show usage error when no kernel was found.
  This may happen several times at package installation time and floods
  the logs.
  Modify dracut_do_not_update_booloader_if_no_kernel_is_found.patch
* Tue Jan 14 2014 trenn@suse.de
- Correctly fix previous issue:
  Exit without calling update-bootloader (bnc#858268)
  Currently mkinitrd will always exit early without creating an initrd at all.
  Rebase: dracut_do_not_update_booloader_if_no_kernel_is_found.patch
- Remove an obsolete comment from .spec file
* Mon Jan 13 2014 trenn@suse.de
  Exit without calling update-bootloader (bnc#858268):
  Add:  dracut_do_not_update_booloader_if_no_kernel_is_found.patch
  Adding:
  Requires:       systemd-sysvinit
  which has reboot, halt and other binaries dracut likes to add to the initrd.
  Cleanup and adjust to latest mainline:
  Dropping as these are included in the latest update_git_v034_to_head patch:
  Drop: 0001-95dasd-Install-kernel-modules-only-once.patch
  Drop: 0002-95dasd-Only-install-module-if-normalize_dasd_arg-is-.patch
  Drop: 0003-95dasd_mod-make-dasd_cio_free-optional.patch
  Drop: 0004-95zfcp-Make-installation-optional.patch
  Drop: 0005-95znet-Make-installation-optional.patch
  Drop: 0007-Fixup-keymap-setting-for-openSUSE.patch
  Drop: 0008-Add-DASD-configuration-for-SuSE.patch
  Drop: 0009-Add-zfcp-scripts-for-SUSE.patch
  Drop: 0010-Make-logfile-configurable.patch
  Drop: 0011-mkinitrd-suse-Add-SUSE-compability-wrapper-for-dracu.patch
  Drop: 0012-mkinitrd-suse.8.asc-Add-manpage-for-SUSE-compat-mkin.patch
  Drop: 0015-Fixup-script-permissions.patch
  Drop: 0016-Remove-shebang-from-shell-completion-files.patch
  Drop: dracut-git-update.patch
  Rebase: 0013-Correct-paths-for-openSUSE.patch
  This is a rename of dracut-git-update.patch to:
  Add:  dracut_git_v034_to_head.patch
* Fri Dec 20 2013 trenn@suse.de
- Cleanup: Remove %%define replace_mkinitrd 1
  and related conditionals in .spec file -> One either has to install
  dracut or mkinitrd and it will stay like that.
* Wed Dec 18 2013 trenn@suse.de
- Add purge kernel service/feature which before was part of mkinitrd
  bnc#854348
* Thu Nov 28 2013 hare@suse.de
- Update with patches from git repository:
  * kernel-modules: add ohci-pci to the list of forced module installs
  * Run 'xz' and 'lzma' with multiple threads
  * systemd: do not exit the initqueue, if systemd asks a password
  * iscsi,nbd: do not fail in hostonly mode
  * dracut-functions.sh: Avoid loading unnecessary 32-bit libraries
    for 64-bit initrds
  * fips: also install /etc/system-fips in the initramfs
  * dracut.modules.7.asc: removed empty section
  * dracut.sh: fixed PATH shortener
  * dracut.spec: move /sbin/dracut to /usr/sbin/dracut
  * iscsi/nbd: do not try to mount the whole disk, if root= is missing
  * fips: include crct10dif_generic
  * Handle crypto modules with and without modaliases
  * usrmount/module-setup.sh: fixed typo
  * lvm: always install thin utils for lvm
  * kernel-modules(ARM): add mmc_block usb_storage to static list of
    kernel mods
  * dracut-functions.sh:check_block_and_slaves*() skip LVM internal devs
  * mkdir basic dirs in /run
  * network/fcoe: only redirect output to loginit.pipe, if exists
  * dracut.sh: no need to make subdirs in run
  * dracut.sh: also mkdir /run/lock, which is copied to
  * lvm: fix thin recognition
  * Add lzo, lz4 compression and read INITRD_COMPRESS
  * remove resume-genrules.sh
  * resume: fix swap detection in hostonly
  * base/init.sh: also mkdir /run/lock
  * dmsquash-live: add /dev/mapper/live-base
  * Doc: cleanup, extend and split and reuse
  * dracut.sh: do not bail out, if kernel modules dir is missing
  * 10i18n/parse-i18n.sh: parse rd.vconsole and rd.locale
  * */module-setup.sh: add comments for dracut called functions
  * lvm: install thin utils for non-hostonly
- Patches for S/390 support
  * 95dasd: Install kernel modules only once
  * 95dasd: Only install module if normalize_dasd_arg is present
  * 95dasd_mod: make dasd_cio_free optional
  * 95zfcp: Make installation optional
  * 95znet: Make installation optional
  * Install /bin/mount
  * Fixup keymap setting for openSUSE
  * Add DASD configuration for SuSE
  * Add zfcp scripts for SUSE
  * Make logfile configurable
  * Add SUSE compability wrapper for dracut
  * Add manpage for SUSE compat mkinitrd
  * Work around xsltproc bug
  * Correct paths for openSUSE
  * Check for plymouth lib directories
- Drop obsolete patches
- Install mkinitrd-suse
* Mon Oct 21 2013 hrvoje.senjan@gmail.com
- Remove not needed logrotate Requires
* Thu Oct 17 2013 crrodriguez@opensuse.org
- remove use_all_paths_udev.patch, /lib/udev.. is a symlink
  to /usr nowadays this confuses other parts of the code causing
  errors/warnings during the initrd generation.
* Mon Oct 14 2013 crrodriguez@opensuse.org
- version 034
  * fcoe: add FCoE UEFI boot device support
  * rootfs-block: add support for the rootfallback= kernel
  cmdline option
  * btrfs: use inst_hook to install the timeout hook
* Sun Oct 13 2013 tittiatcoke@gmail.com
- Correct patch mkinitrd-fix-boot-dir-detection. (";;" doesn't
  really work)
* Wed Oct  9 2013 tittiatcoke@gmail.com
- Updated the patch mkinitrd-fix-boot-dir-detection.patch to a
  more generic validation that the inidcated initrd file doesn't
  contain a path. If no path is given, then add the default
  boot_dir.
* Tue Oct  8 2013 tittiatcoke@gmail.com
- Fix again the mkinitrd script as that people don't seem to test.
  Added mkinitrd-fix-boot-dir-detection.patch so that an initrd
  is created.
* Mon Oct  7 2013 trenn@suse.de
- Update to mainline git version 033, b7d1b6f904a5b0bdd9a5ad19149f3.
- Remove all patches which went mainline:
  generalize_early_cpio.patch
  microcode_cleanup.patch
  acpi_override.patch
  mkinitrd_allow_no_option.patch
  mkinitrd_allow_multiple_args.patch
  quiet_options.patch
  implement_default.patch
  root_fs.patch
  suse_host_only.patch
- Fix missing root fs slash in lib/udev/rules.d resulting in:
  /var/tmp/initramfs.Lusf6flib/udev/rules.d
- bcache: removed, it's in the upstream bcache-tools package
  mainline git commit: 49268028b90f6344f79e3510d2
- Fix bad she-bang in mkinitrd_setup_dummy
* Fri Oct  4 2013 tittiatcoke@gmail.com
- Add patch mkinitrd_update_bootloader.diff so that after
  generating the initrd, the update-bootloader is called to update
  grub2.
* Fri Oct  4 2013 tittiatcoke@gmail.com
- Validate that the parameters passed with -i (initrd file) does
  not already contain the boot_dir.
* Fri Oct  4 2013 tittiatcoke@gmail.com
- Bring back the versioned Provides/Obsoletes for mkinitrd.
  Otherwise we run into issues as that udev is conflicting with
  mkinitrd < 2.7.0
* Wed Oct  2 2013 trenn@suse.de
- Remove Provides/Obsoletes: mkinitrd versioning.
  Simply obsolete and provide all mkinitrd versions.
* Wed Oct  2 2013 mvyskocil@suse.com
- Mark /etc/dracut.conf.d/02-early-microcode.conf as config file
* Wed Sep 25 2013 trenn@suse.de
- Add ACPI table override ability:
    generalize_early_cpio.patch #PATCH-FIX-UPSTREAM
    microcode_cleanup           #PATCH-FIX-UPSTREAM
    acpi_override.patch         #PATCH-FIX-UPSTREAM
- This will replace mkinitrd with dracut as the default initrd generator.
  Therefore Prefer: dracut tag in the project config of the repo is needed.
  Otherwise OSC does not know how to build installation-images
  (needing mkinitrd to build) and which package to take.
-  To switch back and try mkinitrd instead of dracut will be:
    Uninstall dracut:
  - rpm -e dracut --nodeps
    And install mkinitrd again:
  - zypper install mkinitrd
- Adjust mkinitrd-dracut.sh to SUSE mkinitrd:
  <none> : Before gives a "usage" error -> now scans /boot for kernels
    and builds corresponding inirtrds for them
  - i -k  : Pass a list of kernels and initrd targets
    (not sure it was worth the hassle to be able to pass)
  - b     : Boot directory to search for kernel images
  - d     : Change root file system. Not tested whether dracut's behavior
    matches exactly what our mkinitrd does.
  - s     : Dummy (should even be obsolete in latest mkinitrd)
  These patches have been submitted, but now feedback from mainline yet:
    mkinitrd_allow_no_option.patch
    mkinitrd_allow_multiple_args
    quiet_options
    implement_default
    root_fs
    suse_host_only
- Write caller and used parameters to syslog if mkinitrd is called.
  So that those can easily be fixed and checked for correctness.
  This should get reverted again before a bigger release.
    This patch will never show up mainline and should also get reverted
    from SUSE factory repo before the next release shows up:
    suse_only_logger
- Build host only images for default paths in SUSE for faster build and
  smaller images. Imply --force in this case as well.
  * suse_host_only.patch
* Sat Sep 21 2013 crrodriguez@opensuse.org
- save a few seconds on boot by always including the autofs4
  kernel module in the initrd
* Sat Sep 21 2013 crrodriguez@opensuse.org
- dracut 033
- improved hostonly device recognition
- improved hostonly module recognition
- do not install udev rules from /etc in generic mode
- fixed LABEL= parsing for swap devices
- fixed iBFT network setup
- removed caching of kernel cmdline
- bcache: support new blkid
- ifup with dhcp, if no "ip=" specified for the interface
- fixed ifup udev rules
* Mon Sep  9 2013 crrodriguez@opensuse.org
- After testing, we need to correct a major problem, /usr/bin/mount
  most be installed in /bin/mount on the initrd otherwise boot fails.
* Mon Sep  9 2013 crrodriguez@opensuse.org
- version 032
- add parameter --print-cmdline
- dracut now creates the initramfs without udevadm
  that means the udev database does not have to populated
  and the initramfs can be built in a chroot with
  /sys /dev /proc mounted.
- renamed dracut_install() to inst_multiple() for consistent naming
- if $libdirs is unset, fall back to ld.so.cache paths
- always assemble /usr device in initramfs
- bash module added (disable it, if you really want dash)
- continue to boot, if the main loop times out, in systemd mode
- removed inst*() shell pure versions, dracut-install binary is in charge now
- fixed ifcfg file generation for vlan
- do not include adjtime and localtime anymore
- fixed generation of zfcp.conf of CMS setups
- install vt102 terminfo
- dracut_install() is still there for backwards compat
- do not strip files in FIPS mode
- fixed iBFT interface configuration
- fs-lib: install fsck and fsck.ext*
- shutdown: fixed killall_proc_mountpoint()
- network: also wait for ethernet interfaces to setup
- fixed checking for FIPS mode
* Mon Aug  5 2013 crrodriguez@opensuse.org
- version 031_git201308011055
  * systemd: add support for kmod static devnodes
  * crypt: Wait for udev to settle before unlocking disk
  * systemd/dracut-pre-trigger.service: run after systemd-tmpfiles-setup-dev
  * systemd: use systemd in the initramfs, if installed on the system
* Sat Aug  3 2013 tittiatcoke@gmail.com
- Drop the buildrequire for the microcode_ctl. This package
  is no longer in Factory and with the latest kernel (3.11)
  no longer required.
* Sun Jul 28 2013 crrodriguez@opensuse.org
- version 030_git201307241235
  * systemd: Replace prefdm.service with display-manager.service
  * modsign: do not install, if no keys present
  * bcache: add support for bcache
  * Use systemd-cat for logging on systemd systems, if logfile is empty
* Sun Jul 21 2013 tittiatcoke@gmail.com
- Remove the http link for the Source0. Git snapshots can
  not be obtained that way.
* Wed Jul 17 2013 crrodriguez@opensuse.org
- Version 029_git201307171236
  * support early microcode loading in x86
* Thu Jun 27 2013 crrodriguez@opensuse.org
- Require pigz instead of gzip
* Tue Jun 18 2013 crrodriguez@opensuse.org
- version 029
  * fixes for the networking modules
  * fixes for systemd integration
  * fixes for the i18n module (removes dracut-font.patch now upstream)
* Thu Jun  6 2013 crrodriguez@opensuse.org
- version 027_git201306061213
  * setup correct system time and time zone in initrd
  * systemd integration bugfixes
  * lvm bugfixes.
* Wed May  8 2013 crrodriguez@opensuse.org
- Recommend pigz for faster/parallel compression
* Sat Apr 20 2013 crrodriguez@opensuse.org
- Ensure we use display-manager.service instead of prefdm.
* Mon Apr 15 2013 crrodriguez@opensuse.org
- Update to 027_git201304121327
  * much of patch correct-paths-for-opensuse.patch is no longer
  need so it has shrinked significantly.
  * since PRE-027 dracut requires systemd >= 199 reflect that in
  in the rpm buildRequires.
* Wed Apr  3 2013 tittiatcoke@gmail.com
- dracut-027
  * systemd module now requires systemd >= 199
  * dracut makes use of native systemd initrd units
  * added hooks for new-kernel-pkg and kernel-install
  * hostonly is now default for fedora
  * comply with the BootLoaderSpec paths
    http://www.freedesktop.org/wiki/Specifications/BootLoaderSpec
  * added rescue module
  * host_fs_types is now a hashmap
  * new dracut argument "--regenerate-all"
  * new dracut argument "--noimageifnotneeded"
  * new man page dracut.bootup
  * install all host filesystem drivers
  * use -D_FILE_OFFSET_BITS=64 to build dracut-install
* Tue Mar 19 2013 crrodriguez@opensuse.org
- Update to 026_git201303180829
  * bugfixes
  * adds bash completion Support
- Most importantly, fix the (silly) compatibility patch
  that changes the name from initramfs to initrd that went broken
  in last update (all initrds were suffixed by .img)
* Tue Mar 12 2013 crrodriguez@opensuse.org
-  dracut-026
- introduce /usr/lib/dracut/dracut.conf.d/ drop-in directory
  /usr/lib/dracut/dracut.conf.d/*.conf can be overwritten by the same
  filenames in /etc/dracut.conf.d.
  Packages should use /usr/lib/dracut/dracut.conf.d rather than
  /etc/dracut.conf.d for drop-in configuration files.
  /etc/dracut.conf and /etc/dracut.conf.d belong to the system administrator.
- uses systemd-198 native initrd units
- totally rely on the fstab-generator in systemd mode for block devices
- dracut systemd now uses dracut.target rather than basic.target
- dracut systemd services optimize themselves away
- fixed hostonly parameter generation
- turn off curl globbing (fixes IPv6)
- modify the udev rules on install and not runtime time
- enable initramfs building without kernel modules (fixed regression)
- in the initqueue/timeout,
  reset the main loop counter, as we see new udev events or initqueue/work
- fixed udev rule installation
* Fri Feb 22 2013 crrodriguez@opensuse.org
- Update to 025_git201302211113
  * Support out-of-tree and updated drivers in initramfs creation
  * shutdown: call "losetup -D" on shutdown
  * Mount /proc before including dracut-lib.sh.
  * dracut.sh: make /var/log a symlink to /run/log
  * systemd/dracut-pre-pivot.sh: remove /dev/root symlink after shell
  * kernel-modules: Add ehci support for kernel 3.8+
  * Other bugfixes
* Sun Feb  3 2013 crrodriguez@opensuse.org
- BuildRequires: pkgconfig(systemd) so %%{_unitdir} is defined
  and systemd integration works..
* Mon Jan 28 2013 crrodriguez@opensuse.org
- Require modutils instead of module-init-tools.
* Thu Jan 24 2013 hrvoje.senjan@gmail.com
- Update to release 025:
  + do not strip signed kernel modules
  + add sosreport script and generate /run/initramfs/sosreport.txt
  + make short uuid specification for allow-discards work
  + turn off RateLimit for the systemd journal
  + fixed MAC address assignment
  + add systemd checkisomd5 service
  + splitout drm kernel modules from plymouth module
  + add 'swapoff' to initramfs to fix shutdown/reboot
  + add team device support
  + add pre-shutdown hook
  + kill all processes in shutdown and report remaining ones
  + "--device" changed to "--add-device" and "add_device=" added
    for conf files
  + add memory usage trace to different hook points
  + cope with optional field #7 in /proc/self/mountinfo
  + lots of small bugfixes
* Thu Dec  6 2012 crrodriguez@opensuse.org
- dracut wants "strip" installed which is part of binutils
  recommend that package
* Mon Nov  5 2012 tittiatcoke@gmail.com
- Added additional patches to make dracut work in an openSUSE
  environment.
- Added patch (use_all_paths_udev.patch) to use both /usr/lib/udev
  and /lib/udev as long as not all packages migrated.
- Added patch (use_initrd_insteadof_initramfs.patch) to change
  the naming of the generated initrd file to be more openSUSE
- Added patch (use_sysconfig_values_correctly.patch) to read the
  correct keymap value from /etc/sysconfig. (.gz extension)
* Thu Nov  1 2012 tittiatcoke@gmail.com
- Update to release 024:
  + new dracut option "--device"
  + new dracut kernel command line options "rd.auto"
  + new dracut kernel command line options "rd.noverifyssl"
  + new dracut option "--kernel-cmdline" and "kernel_cmdline"
    option for default parameters
  + fixes for systemd and crypto
  + fix for kexec in shutdown, if not included in initramfs
  + create the initramfs non-world readable
  + prelink/preunlink in the initramfs
  + strip binaries in the initramfs by default now
  + various FIPS fixes
  + various dracut-install fixes
- Added patch (correct-paths-for-opensuse.patch) to ensure correct
  paths for openSUSE (Plymouth)
* Fri Sep 28 2012 fcrozat@suse.com
- Add initramfs-non-world-readable.patch: fix CVE-2012-4453
  (bnc#782734).
* Wed Aug  1 2012 fcrozat@suse.com
- Update to release 023:
  + resume from hibernate fixes
  + -N option for --no-hostonly
  + support for systemd crypto handling
  + new dracut module "crypt-loop"
  + deprecate the old kernel command line options
  + more documentation
  + honor CFLAGS for dracut-install build
  + multipath fixes
  + / is mounted according to rootflags parameter but forced ro at
    first. Later it is remounted according to /etc/fstab +
    rootflags parameter and "ro"/"rw".
  + support for xfs / reiserfs separate journal device
  + new "ro_mnt" option to force ro mount of / and /usr
  + root on cifs support
  + dracut-install: fixed issue for /var/tmp containing a symlink
  + only lazy resolve with ldd, if the /var/tmp partition is not
    mounted with "noexec".
  + i18n: fixed inclusion of "include" keymaps
- Drop dracut_makefile_cflags_pass.patch and separate-journal.patch
  (merged upstream)
* Mon Jul 23 2012 fcrozat@suse.com
- Update to release 022:
  + fixed host-only kernel module bug
- Changes from release 021:
  + fixed systemd in the initramfs (requires systemd >= 187)
  + dracut-install: massive speedup with /var on the same
    filesystem with COW copy.
  + dracut-install: moved to /usr/lib/dracut until it becomes a
    general purpose toot
  + new options: "rd.usrmount.ro" and "rd.skipfsck"
  + less mount/umount
  + apply "ro" on the kernel command line also to /usr
  + mount according to fstab, if neither "ro" or "rw" is specified
  + skip fsck for xfs and btrfs. remount is enough
  + give emergency_shell if /usr mount failed
  + dracut now uses getopt:
  - options can be position independent now!!
  - we can now use --option=<arg>
  + added option "--kver=<kernel-version>", and the image location
    can be omitted : dracut --kver 3.5.0-0.rc7.git1.2.fc18.x86_64
  + dracut.sh: for --include copy also the symbolic links
  + man pages: lsinitrd and mkinitrd added
  + network: We do not support renaming in the kernel namespace
    anymore (as udev does that not anymore). So, if a user wants to
    use ifname, he has to rename to a custom namespace. "eth[0-9]+"
    is not allowed anymore.
  + resume: moved the resume process to the initqueue.
    This should prevent accidently mounting the root file system.
  + improve running testsuite
- Clean up package to be openSUSE only package and follow openSUSE
  standard.
- Add dracut module to convert openSUSE/SLE initrd cmdline
  parameters into dracut parameters at boot time.
- Add separate-journal.patch: add support for separate journal for
  reiserfs and XFS.
* Thu Jul 12 2012 trenn@suse.de
- First check in of version 020
- Fix Makefile so that make -e CFLAGS="$RPM_OPT_FLAGS" can be passed
- Remove Requires on libcap
- some more changes, most sent mainline
