#
# spec file for package crypto-policies
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


# testsuite is disabled by default
%bcond_with testsuite
# manbuild is disabled by default
%bcond_with manbuild
%global _python_bytecompile_extra 0
Name:           crypto-policies
Version:        20230920.570ea89
Release:        150600.3.12.1
Summary:        System-wide crypto policies
License:        LGPL-2.1-or-later
Group:          Productivity/Networking/Security
URL:            https://gitlab.com/redhat-crypto/fedora-%{name}
Source0:        fedora-%{name}-%{version}.tar.gz
Source1:        README.SUSE
Source2:        crypto-policies.7.gz
Source3:        update-crypto-policies.8.gz
Source4:        fips-mode-setup.8.gz
Source5:        fips-finish-install.8.gz
Source6:        crypto-policies-rpmlintrc
%if %{without manbuild}
#PATCH-FIX-OPENSUSE Manpages build cycles and dependencies
# To reduce the build dependencies in Ring0, we have to compile the
# man pages locally (use --with testsuite) and add the built files
# crypto-policies.7.gz, update-crypto-policies.8.gz, fips-mode-setup.8.gz
# and fips-finish-install.8.gz as sources.
Patch1:         crypto-policies-no-build-manpages.patch
%endif
#PATCH-FIX-OPENSUSE Skip not needed LibreswanGenerator and SequoiaGenerator
Patch2:         crypto-policies-policygenerators.patch
#PATCH-FIX-OPENSUSE bsc#1209998 Mention the supported back-end policies
Patch3:         crypto-policies-supported.patch
#PATCH-FIX-OPENSUSE Revert a breaking change that introduces rh-allow-sha1-signatures
Patch4:         crypto-policies-revert-rh-allow-sha1-signatures.patch
#PATCH-FIX-OPENSUSE Remove version for pylint from Makefile
Patch5:         crypto-policies-pylint.patch
#PATCH-FIX-OPENSUSE Adpat the fips-mode-setup script for SUSE/openSUSE [jsc#PED-4578]
Patch6:         crypto-policies-FIPS.patch
#PATCH-FIX-OPENSUSE Skip NSS policy check if not installed mozilla-nss-tools [bsc#1211301]
Patch7:         crypto-policies-nss.patch
Patch8:         0008-policies-modules-update-AD-SUPPORT-add-AD-SUP.patch
#PATCH-FIX-UPSTREAM fips-mode-setup: tolerate fips dracut module presence w/o FIPS [bsc#1236165]
Patch9:         crypto-policies-fips-mode-setup-dracut.patch
#PATCH-FIX-UPSTREAM BSI: Update the BSI policy [jsc#PED-12880]
Patch10:        crypto-policies-BSI-switch-to-3072-minimum-RSA-key-size.patch
Patch11:        crypto-policies-BSI-Update-BSI-policy-for-new-2024-minimum-recommend.patch
BuildRequires:  python3-base >= 3.6
# The sequoia stuff needs python3-toml, removed until needed
# BuildRequires:  python3-toml
%if %{with manbuild}
BuildRequires:  asciidoc
%endif
%if %{with testsuite}
# The following packages are needed for the testsuite
BuildRequires:  bind
BuildRequires:  codespell
BuildRequires:  gnutls >= 3.6.0
BuildRequires:  java-devel
BuildRequires:  krb5-devel
BuildRequires:  libxslt
BuildRequires:  mozilla-nss-tools
BuildRequires:  openssl
BuildRequires:  perl
BuildRequires:  python3-coverage
BuildRequires:  python3-devel >= 3.6
BuildRequires:  python3-flake8
BuildRequires:  python3-pylint
BuildRequires:  python3-pytest
BuildRequires:  perl(File::Copy)
BuildRequires:  perl(File::Temp)
BuildRequires:  perl(File::Which)
BuildRequires:  perl(File::pushd)
%endif
%if 0%{?primary_python:1}
Recommends:     crypto-policies-scripts
%endif
Conflicts:      gnutls < 3.7.3
#Conflicts:      libreswan < 3.28
Conflicts:      nss < 3.90.0
#Conflicts:      openssh < 8.2p1
#!BuildIgnore:  crypto-policies
BuildArch:      noarch

%description
This package provides pre-built configuration files with
cryptographic policies for various cryptographic back-ends,
such as SSL/TLS libraries.

%package scripts
Summary:        Tool to switch between crypto policies
Requires:       %{name} = %{version}-%{release}
Recommends:     perl-Bootloader

%description scripts
This package provides a tool update-crypto-policies, which applies
the policies provided by the crypto-policies package. These can be
either the pre-built policies from the base package or custom policies
defined in simple policy definition files.

The package also provides a tool fips-mode-setup, which can be used
to enable or disable the system FIPS mode.

%prep
%autosetup -p1 -n fedora-%{name}-%{version}

# Make README.SUSE available for %%doc
cp -p %{SOURCE1} .

# Remove not needed policy generators
find -name libreswan.py -delete
find -name sequoia.py -delete

%build
export OPENSSL_CONF=''
sed -i "s/MIN_RSA_DEFAULT = .*/MIN_RSA_DEFAULT = 'RequiredRSASize'/" \
    python/policygenerators/openssh.py
grep "MIN_RSA_DEFAULT = 'RequiredRSASize'" python/policygenerators/openssh.py
%make_build

%install
mkdir -p -m 755 %{buildroot}%{_datarootdir}/crypto-policies/
mkdir -p -m 755 %{buildroot}%{_datarootdir}/crypto-policies/back-ends/
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/crypto-policies/back-ends/
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/crypto-policies/state/
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/crypto-policies/local.d/
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/crypto-policies/policies/
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/crypto-policies/policies/modules/
mkdir -p -m 755 %{buildroot}%{_bindir}

make DESTDIR=%{buildroot} DIR=%{_datarootdir}/crypto-policies MANDIR=%{_mandir} %{?_smp_mflags} install

install -p -m 644 default-config %{buildroot}%{_sysconfdir}/crypto-policies/config
touch %{buildroot}%{_sysconfdir}/crypto-policies/state/current
touch %{buildroot}%{_sysconfdir}/crypto-policies/state/CURRENT.pol

mkdir -p -m 755 %{buildroot}%{_mandir}/
mkdir -p -m 755 %{buildroot}%{_mandir}/man7/
mkdir -p -m 755 %{buildroot}%{_mandir}/man8/
%if %{without manbuild}
# Install the manpages from defined sources
cp %{SOURCE2} %{buildroot}%{_mandir}/man7/
cp %{SOURCE3} %{SOURCE4} %{SOURCE5} %{buildroot}%{_mandir}/man8/
%endif

# Install the executable scripts
install -p -m 755 update-crypto-policies %{buildroot}%{_bindir}/
install -p -m 755 fips-mode-setup %{buildroot}%{_bindir}/
install -p -m 755 fips-finish-install %{buildroot}%{_bindir}/

# Drop pre-generated GOST-ONLY policy, we do not need to ship them
rm -rf %{buildroot}%{_datarootdir}/crypto-policies/GOST-ONLY

# Drop libreswan config files
find  %{buildroot} -type f -name 'libreswan.*' -print -delete

# Drop FEDORA policies
rm -rf %{buildroot}%{_datarootdir}/crypto-policies/*FEDORA*

# Create back-end configs for mounting with read-only /etc/
for d in LEGACY DEFAULT FUTURE FIPS BSI ; do
    mkdir -p -m 755 %{buildroot}%{_datarootdir}/crypto-policies/back-ends/$d
    for f in %{buildroot}%{_datarootdir}/crypto-policies/$d/* ; do
        ln $f %{buildroot}%{_datarootdir}/crypto-policies/back-ends/$d/$(basename $f .txt).config
    done
done

for f in %{buildroot}%{_datarootdir}/crypto-policies/DEFAULT/* ; do
    ln -sf %{_datarootdir}/crypto-policies/DEFAULT/$(basename $f) %{buildroot}%{_sysconfdir}/crypto-policies/back-ends/$(basename $f .txt).config
done

%py3_compile %{buildroot}%{_datadir}/crypto-policies/python

# Install README.SUSE to %%doc
install -p -m 644 %{SOURCE1} %{buildroot}%{_sysconfdir}/crypto-policies

%check
%if %{with testsuite}
export OPENSSL_CONF=''
%make_build test
%make_build test-install test-fips-setup || :
%endif

%post -p <lua>
if not posix.access("%{_sysconfdir}/crypto-policies/config") then
    local policy = "DEFAULT"
    local cf = io.open("/proc/sys/crypto/fips_enabled", "r")
    if cf then
        if cf:read() == "1" then
            policy = "FIPS"
        end
        cf:close()
    end
    cf = io.open("%{_sysconfdir}/crypto-policies/config", "w")
    if cf then
        cf:write(policy.."\n")
        cf:close()
    end
    cf = io.open("%{_sysconfdir}/crypto-policies/state/current", "w")
    if cf then
        cf:write(policy.."\n")
        cf:close()
    end
    local policypath = "%{_datarootdir}/crypto-policies/"..policy
    for fn in posix.files(policypath) do
        if fn ~= "." and fn ~= ".." then
            local backend = fn:gsub(".*/", ""):gsub("%%..*", "")
            local cfgfn = "%{_sysconfdir}/crypto-policies/back-ends/"..backend..".config"
            posix.unlink(cfgfn)
            posix.symlink(policypath.."/"..fn, cfgfn)
        end
    end
end

cfg_path_libreswan = "%{_sysconfdir}/crypto-policies/back-ends/libreswan.config"
st = posix.stat(cfg_path_libreswan)
if st and st.type == "link" then
   posix.unlink(cfg_path_libreswan)
end

%posttrans scripts
%{_bindir}/update-crypto-policies --no-check >/dev/null 2>/dev/null || :

%files
%license COPYING.LESSER
%doc README.md NEWS CONTRIBUTING.md
%doc %{_sysconfdir}/crypto-policies/README.SUSE

%dir %{_sysconfdir}/crypto-policies/
%dir %{_sysconfdir}/crypto-policies/back-ends/
%dir %{_sysconfdir}/crypto-policies/state/
%dir %{_sysconfdir}/crypto-policies/local.d/
%dir %{_sysconfdir}/crypto-policies/policies/
%dir %{_sysconfdir}/crypto-policies/policies/modules/
%dir %{_datarootdir}/crypto-policies/

%ghost %config(missingok,noreplace) %{_sysconfdir}/crypto-policies/config

%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/gnutls.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/openssl.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/opensslcnf.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/openssl_fips.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/openssh.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/opensshserver.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/nss.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/bind.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/java.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/javasystem.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/krb5.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/libssh.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/sequoia.config
%ghost %config(missingok,noreplace) %verify(not mode) %{_sysconfdir}/crypto-policies/back-ends/rpm-sequoia.config
# %%verify(not mode) comes from the fact that these turn into symlinks and back to regular files at will.

%ghost %{_sysconfdir}/crypto-policies/state/current
%ghost %{_sysconfdir}/crypto-policies/state/CURRENT.pol

%{_mandir}/man7/crypto-policies.7%{?ext_man}
%{_datarootdir}/crypto-policies/LEGACY
%{_datarootdir}/crypto-policies/DEFAULT
%{_datarootdir}/crypto-policies/FUTURE
%{_datarootdir}/crypto-policies/FIPS
%{_datarootdir}/crypto-policies/BSI
%{_datarootdir}/crypto-policies/EMPTY
%{_datarootdir}/crypto-policies/back-ends
%{_datarootdir}/crypto-policies/default-config
%{_datarootdir}/crypto-policies/reload-cmds.sh
%{_datarootdir}/crypto-policies/policies

%files scripts
%{_bindir}/update-crypto-policies
%{_bindir}/fips-mode-setup
%{_bindir}/fips-finish-install
%{_mandir}/man8/update-crypto-policies.8%{?ext_man}
%{_mandir}/man8/fips-mode-setup.8%{?ext_man}
%{_mandir}/man8/fips-finish-install.8%{?ext_man}
%{_datarootdir}/crypto-policies/python

%changelog
* Thu Jul 10 2025 pmonreal@suse.com
- Update the BSI policy [jsc#PED-12880]
  * BSI: switch to 3072 minimum RSA key size [322f0ba4]
  * BSI: Update BSI policy for new 2024 minimum [64b9dddd]
  * Add patches:
  - crypto-policies-BSI-Update-BSI-policy-for-new-2024-minimum-recommend.patch
  - crypto-policies-BSI-switch-to-3072-minimum-RSA-key-size.patch
* Fri Feb 28 2025 pmonreal@suse.com
- Fix fips-mode-setup in EFI or Secure Boot mode. [bsc#1227637]
  * Rebase crypto-policies-FIPS.patch
* Fri Feb 28 2025 pmonreal@suse.com
- fips-mode-setup: tolerate fips dracut module presence w/o FIPS
  * Fixes the "Inconsistent state detected" warning when disabling
    the FIPS mode [bsc#1236165]
  * Upstream commit [gl#redhat-crypto/fedora-crypto-policies#78773542]
  * Add crypto-policies-fips-mode-setup-dracut.patch
* Wed Feb 12 2025 pmonreal@suse.com
- Remove dangling symlink for the libreswan config [bsc#1236858]
* Wed Jan 22 2025 scabrero@suse.de
- krb5: disallow aes256-cts-hmac-sha1-96 and aes128-cts-hmac-sha1-96
  kerberos encryption types from RFC3961 in FIPS mode, as its key
  derivation function is not certified; (jsc#PED-12018);
- Update AD-SUPPORT and add AD-SUPPORT-LEGACY subpolicies; (jsc#PED-12018);
  The AD-SUPPORT subpolicy will enable the aes256-cts-hmac-sha1-96
  and aes128-cts-hmac-sha1-96 encryption types necessary for AD.
  The Kerberos libraries will tell OpenSSL provider to bypass FIPS
  restrictions when loading the KRB5KDF module.
  The AD-SUPPORT-LEGACY will allow the use of RC4 encryption types
  in environments where either accounts or trusted domains objects
  were not yet migrated to AES.
- Add patch 0008-policies-modules-update-AD-SUPPORT-add-AD-SUP.patch
* Wed Sep 27 2023 pmonreal@suse.com
- nss: Skip the NSS policy check if the mozilla-nss-tools package
  is not installed. This avoids adding more dependencies in ring0.
  * Add crypto-policies-nss.patch [bsc#1211301]
* Fri Sep 22 2023 pmonreal@suse.com
- Update to version 20230920.570ea89:
  * fips-mode-setup: more thorough --disable, still unsupported
  * FIPS:OSPP: tighten beyond reason for OSPP 4.3
  * krb5: sort enctypes mac-first, cipher-second, prioritize SHA-2 ones
  * openssl: implement relaxing EMS in FIPS (NO-ENFORCE-EMS)
  * gnutls: prepare for tls-session-hash option coming
  * nss: prepare for TLS-REQUIRE-EMS option coming
  * NO-ENFORCE-EMS: add subpolicy
  * FIPS: set __ems = ENFORCE
  * cryptopolicies: add enums and __ems tri-state
  * docs: replace `FIPS 140-2` with just `FIPS 140`
  * .gitlab-ci: remove forcing OPENSSH_MIN_RSA_SIZE
  * cryptopolicies: add comments on dunder options
  * nss: retire NSS_OLD and replace with NSS_LAX 3.80 check
  * BSI: start a BSI TR 02102 policy [jsc#PED-4933]
  * Rebase patches:
  - crypto-policies-policygenerators.patch
  - crypto-policies-revert-rh-allow-sha1-signatures.patch
  - crypto-policies-FIPS.patch
* Fri Sep 15 2023 pmonreal@suse.com
- Conditionally recommend the crypto-policies-scripts package
  when python is not installed in the system [bsc#1215201]
* Thu Aug 31 2023 pmonreal@suse.com
- Tests: Fix pylint versioning for TW and fix the parsing of the
  policygenerators to account for the commented lines correctly.
  * Add crypto-policies-pylint.patch
  * Rebase crypto-policies-policygenerators.patch
* Tue Aug  1 2023 pmonreal@suse.com
- FIPS: Adapt the fips-mode-setup script to use the pbl command
  from the perl-Bootloader package to replace grubby. Add a note
  for transactional systems [jsc#PED-5041].
  * Rebase crypto-policies-FIPS.patch
* Fri Jul 14 2023 meissner@suse.com
- BSI.pol: Added a new BSI policy for BSI TR 02102* (jsc#PED-4933)
  derived from NEXT.pol
* Thu Jul 13 2023 pmonreal@suse.com
- Update to version 20230614.5f3458e:
  * policies: impose old OpenSSL groups order for all back-ends
  * Rebase patches:
  - crypto-policies-revert-rh-allow-sha1-signatures.patch
  - crypto-policies-supported.patch
* Thu May 25 2023 pmonreal@suse.com
- FIPS: Enable to set the kernel FIPS mode with fips-mode-setup
  and fips-finish-install commands, add also the man pages. The
  required FIPS modules are left to be installed by the user.
  * Rebase crypto-policies-FIPS.patch
* Wed May 24 2023 pmonreal@suse.com
- Revert a breaking change that introduces the config option
  rh-allow-sha1-signatures that is unkown to OpenSSL and fails
  on startup. We will consider adding this option to openssl.
  * https://gitlab.com/redhat-crypto/fedora-crypto-policies/-/commit/97fe4494
  * Add crypto-policies-revert-rh-allow-sha1-signatures.patch
* Mon May  8 2023 pmonreal@suse.com
- Update the update-crypto-policies(8) man pages and README.SUSE
  to mention the supported back-end policies. [bsc#1209998]
  * Add crypto-policies-supported.patch
* Mon May  8 2023 pmonreal@suse.com
- Update to version 20230420.3d08ae7:
  * openssl, alg_lists: add brainpool support
  * openssl: set Groups explicitly
  * codespell: ignore aNULL
  * rpm-sequoia: allow 1024 bit DSA and SHA-1 per FeSCO decision 2960
  * sequoia: add separate rpm-sequoia backend
  * crypto-policies.7: state upfront that FUTURE is not so interoperable
  * Makefile: update for asciidoc 10
  * Skip not needed LibreswanGenerator and SequoiaGenerator:
  - Add crypto-policies-policygenerators.patch
  * Remove crypto-policies-test_supported_modules_only.patch
  * Rebase crypto-policies-no-build-manpages.patch
* Fri Jan 20 2023 pmonreal@suse.com
- Update to version 20221214.a4c31a3:
  * bind: expand the list of disableable algorithms
  * libssh: Add support for openssh fido keys
  * .gitlab-ci.yml: install krb5-devel for krb5-config
  * sequoia: check using sequoia-policy-config-check
  * sequoia: introduce new back-end
  * Makefile: support overriding asciidoc executable name
  * openssh: make none and auto explicit and different
  * openssh: autodetect and allow forcing RequiredRSASize presence/name
  * openssh: remove _pre_8_5_ssh
  * pylintrc: update
  * Revert "disable SHA-1 further for a Fedora 38 Rawhide "jump scare"..."
  * disable SHA-1 further for a Fedora 38 Rawhide "jump scare"...
  * Makefile: exclude built manpages from codespell
  * add openssh HostbasedAcceptedAlgorithms
  * openssh: add RSAMinSize option following min_rsa_size
  * Revert ".gitlab-ci.yml: skip pylint (bz2069837)"
  * docs: add customization recommendation
  * tests/java: fix java.security.disableSystemPropertiesFile=true
  * policies: add FEDORA38 and TEST-FEDORA39
  * bind: control ED25519/ED448
  * openssl: disable SHA-1 signatures in FUTURE/NO-SHA1
  * .gitlab-ci.yml: skip pylint (bz2069837)
  * openssh: add support for sntrup761x25519-sha512@openssh.com
  * fips-mode-setup: fix one unrelated check to intended state
  * fips-mode-setup, fips-finish-install: abandon /etc/system-fips
  * Makefile: fix alt-policy test of LEGACY:AD-SUPPORT
  * fips-mode-setup: catch more inconsistencies, clarify --check
  * fips-mode-setup: improve handling FIPS plus subpolicies
  * .gitlab-ci.yml: use rawhide so that we get gnutls 3.7.3
  * gnutls: enable SHAKE, needed for Ed448
  * gnutls: use allowlisting
  * openssl: add newlines at the end of the output
  * FIPS:OSPP: relax -ECDSA-SHA2-512, -FFDHE-*
  * fips-mode-setup, fips-finish-install: call zipl more often
  * Add crypto-policies-rpmlintrc file to avoid files-duplicate,
    zero-length and non-conffile-in-etc warnings.
  * Rebase patches:
  - crypto-policies-FIPS.patch
  - crypto-policies-no-build-manpages.patch
  * Update README.SUSE
* Fri Sep 24 2021 pmonreal@suse.com
- Remove the scripts and documentation regarding
  fips-finish-install and test-fips-setup
  * Add crypto-policies-FIPS.patch
* Fri Sep 24 2021 pmonreal@suse.com
- Update to version 20210917.c9d86d1:
  * openssl: fix disabling ChaCha20
  * pacify pylint 2.11: use format strings
  * pacify pylint 2.11: specify explicit encoding
  * fix minor things found by new pylint
  * update-crypto-policies: --check against regenerated
  * update-crypto-policies: fix --check's walking order
  * policygenerators/gnutls: revert disabling DTLS0.9...
  * policygenerators/java: add javasystem backend
  * LEGACY: bump 1023 key size to 1024
  * cryptopolicies: fix 'and' in deprecation warnings
  * *ssh: condition ecdh-sha2-nistp384 on SECP384R1
  * nss: hopefully the last fix for nss sigalgs check
  * cryptopolicies: Python 3.10 compatibility
  * nss: postponing check + testing at least something
  * Rename 'policy modules' to 'subpolicies'
  * validation.rules: fix a missing word in error
  * cryptopolicies: raise errors right after warnings
  * update-crypto-policies: capitalize warnings
  * cryptopolicies: syntax-precheck scope errors
  * .gitlab-ci.yml, Makefile: enable codespell
  * all: fix several typos
  * docs: don't leave zero TLS/DTLS protocols on
  * openssl: separate TLS/DTLS MinProtocol/MaxProtocol
  * alg_lists: order protocols new-to-old for consistency
  * alg_lists: max_{d,}tls_version
  * update-crypto-policies: fix pregenerated + local.d
  * openssh: allow validation with pre-8.5
  * .gitlab-ci.yml: run commit-range against upstream
  * openssh: Use the new name for PubkeyAcceptedKeyTypes
  * sha1_in_dnssec: deprecate
  * .gitlab-ci.yml: test commit ranges
  * FIPS:OSPP: sign = -*-SHA2-224
  * scoped policies: documentation update
  * scoped policies: use new features to the fullest...
  * scoped policies: rewrite + minimal policy changes
  * scoped policies: rewrite preparations
  * nss: postponing the version check again, to 3.64
- Remove patches fixed upstream: crypto-policies-typos.patch
- Rebase: crypto-policies-test_supported_modules_only.patch
- Merge crypto-policies-asciidoc.patch into
    crypto-policies-no-build-manpages.patch
* Thu Feb 25 2021 pmonreal@suse.com
- Update to version 20210225.05203d2:
  * Disable DTLS0.9 protocol in the DEFAULT policy.
  * policies/FIPS: insignificant reformatting
  * policygenerators/libssh: respect ssh_certs
  * policies/modules/OSPP: tighten to follow RHEL 8
  * crypto-policies(7): drop not-reenableable comment
  * follow up on disabling RC4
* Thu Feb 25 2021 pmonreal@suse.com
- Remove not needed scripts: fips-finish-install fips-mode-setup
* Wed Feb 24 2021 pmonreal@suse.com
- Disable DTLS0.9 protocol in GnuTLS DEFAULT policy. [bsc#1180938]
  * The minimum DTLS protocol version in the DEFAULT and FUTURE
    policies is DTLS1.2.
  * Fixed upstream: 05203d21f6d0ea9bbdb351e4600f1e273720bb8e
* Wed Feb 17 2021 pmonreal@suse.com
- Update to version 20210213.5c710c0: [bsc#1180938]
  * setup_directories(): perform safer creation of directories
  * save_config(): avoid re-opening output file for each iteration
  * save_config(): break after first match to avoid unnecessary stat() calls
  * CryptoPolicy.parse(): actually stop parsing line on syntax error
  * ProfileConfig.parse_string(): correctly extended subpolicies
  * Exclude RC4 from LEGACY
  * Introduce rc4_md5_in_krb5 to narrow AD_SUPPORT
  * code style: fix 'not in' membership testing
  * pylintrc: tighten up a bit
  * formatting: avoid long lines
  * formatting: use f-strings instead of format()
  * formatting: reformat all python code with autopep8
  * nss: postponing the version check again, to 3.61
  * Revert "Unfortunately we have to keep ignoring the openssh check for sk-"
* Tue Feb  9 2021 dimstar@opensuse.org
- Use tar_scm service, not obs_scm: With crypto-policies entering
  Ring0 (distro bootstrap) we want to be sure to keep the buildtime
  deps as low as possible.
- Add python3-base BuildRequires: previously, OBS' tar service
  pulled this in for us.
* Mon Feb  8 2021 pmonreal@suse.com
- Add a BuildIgnore for crypto-policies
* Mon Feb  8 2021 pmonreal@suse.com
- Use gzip instead of xz in obscpio and sources
* Fri Feb  5 2021 pmonreal@suse.com
- Do not build the manpages to avoid build cycles
- Add crypto-policies-no-build-manpages.patch
* Tue Feb  2 2021 dimstar@opensuse.org
- Convert to use a proper git source _service:
  + To update, one just needs to update the commit/revision in the
    _service file and run `osc service dr`.
  + The version of the package is defined by the commit date of the
    revision, followed by the abbreviated git hash (The same
    revision used before results thus in a downgrade to 20210118,
    but as this is a alltime new package, this is acceptable.
* Tue Feb  2 2021 pmonreal@suse.com
- Update to git version 20210127
  * Bump Python requirement to 3.6
  * Output sigalgs required by nss >=3.59
  * Do not require bind during build
  * Break build cycles with openssl and gnutls
* Thu Jan 21 2021 pmonreal@suse.com
- Update to git version 20210118
  * Output sigalgs required by nss >=3.59
  * Bump Python requirement to 3.6
  * Kerberos 5: Fix policy generator to account for macs
  * Add AES-192 support (non-TLS scenarios)
  * Add documentation of the --check option
* Thu Jan 21 2021 pmonreal@suse.com
- Fix the man pages generation
- Add crypto-policies-asciidoc.patch
* Thu Jan 21 2021 pmonreal@suse.com
- Test only supported modules
- Add crypto-policies-test_supported_modules_only.patch
* Tue Dec 22 2020 pmonreal@suse.com
- Add crypto-policies-typos.patch to fix some typos
* Thu Nov 12 2020 vcizek@suse.com
- Initial packaging, git version 20200918 (jsc#SLE-15832)
