#
# spec file for package ntp
#
# Copyright (c) 2016 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir /var/adm/fillup-templates
%endif

%define ntpfaqversion 3.4
Name:           ntp
Version:        4.2.8p18
Release:        150600.20.3.1
Summary:        Network Time Protocol daemon (version 4)
License:        (MIT and BSD-3-Clause and BSD-4-Clause) and GPL-2.0
Group:          Productivity/Networking/Other
Url:            http://www.ntp.org/
# main source
Source0:        https://downloads.nwtime.org/ntp/4.2.8/ntp-%{version}.tar.gz
# configuration
Source1:        conf.logrotate.ntp
Source2:        conf.ntp.conf
Source3:        conf.ntpd.service
Source4:        conf.sysconfig.ntp
Source5:        conf.sysconfig.syslog-ntp
Source6:        conf.ntp.reg
Source7:        %{name}.firewall
Source8:        conf.start-ntpd
Source9:        conf.ntp-wait.service
# documentation
Source10:       NTP-FAQ-%{ntpfaqversion}.tar.bz2
Source12:       README.SUSE
Source13:       ntptime.8.gz
Source14:       ntp.xml
Source16:       ntp.NetworkManager
Patch1:         ntp-segfault_on_invalid_device.patch
Patch10:        ntp-strcat.patch
Patch11:        ntp-4.2.6p2-seed_file.patch
Patch15:        bnc#506908.diff
Patch16:        MOD_NANO.diff
Patch18:        bnc#574885.diff
Patch23:        ntp-openssl-version.patch
Patch27:        ntp-netlink.patch
Patch29:        ntp-pathfind.patch
Patch30:        ntp-move-kod-file.patch
Patch33:        ntp-sntp-libevent.patch
Patch35:        ntp-clarify-interface.patch
Patch36:        ntp-check-argv.patch
Patch37:        ntp-sntp-assert.patch

BuildRequires:  avahi-compat-mDNSResponder-devel
BuildRequires:  fdupes
BuildRequires:  libcap-devel
BuildRequires:  libevent-devel
BuildRequires:  openssl-devel
%if 0%{?suse_version} > 1320 || 0%{?sle_version} >= 120200
BuildRequires:  pps-tools-devel
%endif
BuildRequires:  readline-devel
BuildRequires:  pkgconfig(systemd)
Requires:       /bin/logger
Requires:       timezone
Requires(pre):  %fillup_prereq
Requires(pre):  %{_bindir}/chkconfig
Requires(pre):  %{_bindir}/diff
Requires(pre):  %{_bindir}/grep
Requires(pre):  pwdutils
Requires(post): /usr/bin/base64
Requires(post): /usr/bin/gawk
Suggests:       logrotate
Provides:       ntp-daemon
Provides:       xntp = %{version}
Provides:       xntp3 = %{version}
Obsoletes:      xntp < %{version}
Obsoletes:      xntp3 < %{version}
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%{?systemd_requires}
Conflicts:      openntpd

%description
The Network Time Protocol (NTP) is used to synchronize the time of a
computer client or server to another server or reference time source,
such as a radio, satellite receiver, or modem.

Ntpd is an operating system daemon that sets and maintains the system
time-of-day synchronized with Internet standard time servers.

%package doc
Summary:        Additional Package Documentation for ntp
Group:          Documentation/Other
Provides:       ntpdoc = %{version}
Provides:       xntp-doc = %{version}
Provides:       xntpdoc = %{version}
Obsoletes:      ntpdoc < %{version}
Obsoletes:      xntp-doc < %{version}
Obsoletes:      xntpdoc < %{version}

%description doc
The complete set of documentation for building and configuring an NTP
server or client. The documentation is in the form of HTML files
suitable for browsing and contains links to additional documentation at
various web sites.

What about NTP? Understanding and using the Network Time Protocol (A
first try on a non-technical Mini-HOWTO and FAQ on NTP). Edited by
Ulrich Windl and David Dalton.

%prep
%setup -q -n ntp-%{version}
# unpack ntp-faq
tar -x -C html -j -f %{SOURCE10}
%patch1
# copy README.SUSE
cp %{SOURCE12} .
%patch10 -p1
%patch11 -p1
%patch15
%patch16
%patch18
%patch23
%patch27
%patch29
%patch30
%patch33
%patch35
%patch36
%patch37

# fix DOS line breaks
sed -i 's/\r//g' html/scripts/{footer.txt,style.css}

%build
export RPM_OPT_FLAGS="$RPM_OPT_FLAGS -W -DOPENSSL_LOAD_CONF -Wall -Wstrict-prototypes -Wpointer-arith -Wno-unused-parameter -fno-strict-aliasing -fstack-protector"
%ifarch alpha s390x
export RPM_OPT_FLAGS="$RPM_OPT_FLAGS -O0"
%endif
%ifarch ia64
RPM_OPT_FLAGS="$RPM_OPT_FLAGS -ffast-math"
%endif
export CFLAGS="$RPM_OPT_FLAGS -fPIE"
export LDFLAGS="-pie"
%configure \
	--with-binsubdir=bin \
	--bindir=%{_sbindir} \
	--htmldir=%{_docdir}/ntp-doc \
        --disable-debugging \
	--enable-parse-clocks \
	--enable-all-clocks \
	--enable-linuxcaps \
	--enable-ipv6 \
	--with-sntp \
	--enable-ntp-signd \
	--disable-listen-read-drop \
	--with-lineeditlibs=readline \
	--with-crypto=openssl \
	--with-openssl-libdir=%{_libdir} \
	--with-openssl-incdir=%{_includedir} \
	--disable-thread-support \
	--without-threads \
	--enable-leap-smear \
	--enable-ntp-signd

make %{?_smp_mflags}

%install
make DESTDIR=%{buildroot} install %{?_smp_mflags}
# Change permissions
chmod 644 html/pic/neoclock4x.gif
%fdupes -s html
#
# default configuration
#
install -d %{buildroot}%{_localstatedir}/lib/ntp/{drift,etc,var/{lib,run/ntp},dev}
install -d %{buildroot}%{_localstatedir}/run
ln -s ../.. %{buildroot}%{_localstatedir}/lib/ntp%{_localstatedir}/lib/ntp
ln -s %{_sbindir}/service %{buildroot}%{_sbindir}/rcntpd
ln -s %{_sbindir}/service %{buildroot}%{_sbindir}/rcntp-wait
install -m 644 -D %{SOURCE1} %{buildroot}%{_sysconfdir}/logrotate.d/ntp
install -m 600 -D %{SOURCE2} %{buildroot}%{_sysconfdir}/ntp.conf
install -m 600 -D %{SOURCE2} %{buildroot}%{_localstatedir}/lib/ntp%{_sysconfdir}/ntp.conf.iburst
#
# boot scripts
#
install -m 0644 -D %{SOURCE3} %{buildroot}/%{_unitdir}/ntpd.service
install -m 0644 -D %{SOURCE9} %{buildroot}/%{_unitdir}/ntp-wait.service
install -d %{buildroot}%{_prefix}/sbin
install -m 755 -D %{SOURCE8} %{buildroot}%{_sbindir}/start-ntpd
%__install -d %{buildroot}/usr/lib/initscripts/legacy-actions/ntpd
for f in ntptimeset addserver; do
	F=%{buildroot}/usr/lib/initscripts/legacy-actions/ntpd/$f
	cat >$F <<-EOF
		#!/bin/bash
		exec /usr/sbin/start-ntpd $f "\$@"
	EOF
	chmod 755 $F
done
#
# fillup sysconfig.ntp
#
install -m 644 -D %{SOURCE4} %{buildroot}%{_fillupdir}/sysconfig.ntp
install -m 644 -D %{SOURCE5} %{buildroot}%{_fillupdir}/sysconfig.syslog-ntp
#
# install SLP reg file
#
install -m 644 -D %{SOURCE6} %{buildroot}%{_sysconfdir}/slp.reg.d/ntp.reg
#
# Install NetworkManager hook
#
install -m 755 -D %{SOURCE16} %{buildroot}%{_sysconfdir}/NetworkManager/dispatcher.d/ntp
#
# man pages
#
install -m 644 %{S:13} %{buildroot}/%{_mandir}/man8
#
# firewall
#
install -d %{buildroot}%{_sysconfdir}/sysconfig/SuSEfirewall2.d/services/
install -m 644 %{SOURCE7} %{buildroot}%{_sysconfdir}/sysconfig/SuSEfirewall2.d/services/%{name}
#
# Logfile
#
install -d %{buildroot}%{_localstatedir}/log/
touch %{buildroot}%{_localstatedir}/log/ntp
#
# service xml
#
install -d %{buildroot}%{_datadir}/omc/svcinfo.d/
install -m 644 %{SOURCE14} %{buildroot}%{_datadir}/omc/svcinfo.d/
install -m 755 scripts/ntp-wait/ntp-wait %{buildroot}%{_sbindir}/
install -d %{buildroot}/var/lib/ntp
install -m 644 /dev/null %{buildroot}/var/lib/ntp/kod

%pre
%{_sbindir}/groupadd -r ntp 2> /dev/null || :
%{_sbindir}/useradd -r -o -g ntp -u 74 -s /bin/false -c "NTP daemon" -d %{_localstatedir}/lib/ntp ntp 2> /dev/null || :
%{_sbindir}/usermod -g ntp ntp 2>/dev/null || :
test -L %{_localstatedir}/run/ntp  || rm -rf %{_localstatedir}/run/ntp && :
%service_add_pre ntp.service ntpd.service
%service_add_pre ntp-wait.service
if [ $FIRST_ARG -ne 1 -a ! -e "%{_localstatedir}/lib/systemd/migrated/ntpd" -a -e %{_localstatedir}/lib/systemd/sysv-convert/database ]; then
  sed -i -e 's,ntp\t,ntpd\t,g' %{_localstatedir}/lib/systemd/sysv-convert/database
fi

%preun
%service_del_preun ntpd.service
%service_del_preun ntp-wait.service

# no update? Then remove these files that aren't owned by the package
if [ ${FIRST_ARG:-0} -eq 0 ]; then
     test -e %{_localstatedir}/lib/ntp/drift/ntp.drift  && rm -f %{_localstatedir}/lib/ntp/drift/ntp.drift
     rm -f %{_localstatedir}/lib/ntp%{_sysconfdir}/* 2>/dev/null
     test -e %{_localstatedir}/log/ntp  && rm -f %{_localstatedir}/log/ntp
fi

%post

getntpconf() {
  # Get the value of a single-value ntp.conf directive, first match wins.
  awk 'NF >= 2 && $1 == option { print $2; exit } ' "option=$1" $NTPCONF
}

keyexists() {
  # Check whether a key with the given ID exists in the ntp keys file.
  awk '$1 == keyno {found = 1} END {exit !found}' "keyno=$1" $KEYSFILE
}

add_trustedkey() {
  # Merge the given key ID into the trustedkey directive.
  # Add the directive if it does not yet exist.
  FILE=$(mktemp -p /etc)
  gawk '
    NF >= 2 && $1 == "trustedkey" {
      n = split($0, a)
      for (i = 1; i <= n; i++) {
        if (a[i] == newkey) newkey = "";
        if (a[i] ~ /^#/ && newkey) {
          $(++j) = newkey; newkey = ""
        }
        $(++j) = a[i];
      }
      if (newkey) { $(++j) = newkey; newkey = "" }
    }
    { print }
    ENDFILE {
      if (newkey) { print "trustedkey", newkey }
    }
  ' "newkey=$1" $NTPCONF > $FILE
  if ! cmp --quiet $FILE $NTPCONF; then
     cat $FILE > $NTPCONF
  fi
  rm $FILE
}

NTPCONF=/etc/ntp.conf
KEYSFILE=$(getntpconf keys)
if test -z "$KEYSFILE"; then
  KEYSFILE=/etc/ntp.keys
  echo "keys $KEYSFILE" >> $NTPCONF
fi

if [ ! -f $KEYSFILE ]; then
  FILE=$(mktemp -p /etc)
  chmod 0640 $FILE
  chown root:ntp $FILE
  mv $FILE $KEYSFILE
fi

CONTROLKEY=$(getntpconf controlkey)
REQUESTKEY=$(getntpconf requestkey)

if test -z "$CONTROLKEY"; then
  if test -n "$REQUESTKEY"; then
    CONTROLKEY=$REQUESTKEY
  else
    for (( CONTROLKEY = 1; CONTROLKEY < 65535; CONTROLKEY++ )); do
      keyexists $CONTROLKEY || break
    done
  fi
  echo "controlkey $CONTROLKEY" >> $NTPCONF
fi

if test -z "$REQUESTKEY"; then
  REQUESTKEY=$CONTROLKEY;
  echo "requestkey $REQUESTKEY" >> $NTPCONF
fi

for KEYNO in $REQUESTKEY $CONTROLKEY; do
  if ! keyexists $KEYNO; then
    KEY=$(head -c 15 /dev/urandom | base64)
    echo "$KEYNO SHA1 $KEY" >> $KEYSFILE
  fi
done

add_trustedkey $REQUESTKEY
add_trustedkey $CONTROLKEY

# update from previous permissions
if [ -f %{_sysconfdir}/ntp.conf ]; then
  chown root:ntp %{_sysconfdir}/ntp.conf
fi
if [ -f %{_sysconfdir}/ntp.keys ]; then
  chown root:ntp %{_sysconfdir}/ntp.keys
fi
if [ -f %{_localstatedir}/lib/ntp%{_sysconfdir}/ntp.conf.iburst ]; then
  chown --from=ntp:root root:ntp %{_localstatedir}/lib/ntp%{_sysconfdir}/ntp.conf.iburst
fi
%{fillup_only -n ntp }
%{fillup_only -n syslog }
if [ ! -f %{_localstatedir}/log/ntp ]; then
	touch %{_localstatedir}/log/ntp
	chmod 644 %{_localstatedir}/log/ntp
fi
%service_add_post ntpd.service
%service_add_post ntp-wait.service
if [ ! -e "%{_localstatedir}/lib/systemd/migrated/ntpd" ]; then
  touch %{_localstatedir}/lib/systemd/migrated/ntpd
fi

%postun
%service_del_postun ntpd.service
%service_del_postun ntp-wait.service

%files
%defattr(-,root,root)
%doc COPYRIGHT ChangeLog NEWS README* TODO WHERE-TO-START conf
%attr(0640,root,ntp) %config(noreplace) %{_sysconfdir}/ntp.conf
%dir %{_sysconfdir}/slp.reg.d
%{_unitdir}/ntpd.service
%{_unitdir}/ntp-wait.service
%config(noreplace) %{_sysconfdir}/slp.reg.d/ntp.reg
%config %{_sysconfdir}/logrotate.d/ntp
%config %{_sysconfdir}/sysconfig/SuSEfirewall2.d/services/ntp
# own /etc/NetworkManager so we don't have to BuildDepend on NM
%dir %{_sysconfdir}/NetworkManager
%dir %{_sysconfdir}/NetworkManager/dispatcher.d
%config %{_sysconfdir}/NetworkManager/dispatcher.d/ntp
%{_sbindir}/*
%{_datadir}/ntp
%if 0%{?suse_version} > 1310
/usr/lib/initscripts/legacy-actions/ntpd
%else
/usr/lib/initscripts
%endif
%{_localstatedir}/lib/ntp
%attr(0640,root,ntp) %config(noreplace) %{_localstatedir}/lib/ntp%{_sysconfdir}/ntp.conf.iburst
%attr(0755,ntp,ntp) %dir %{_localstatedir}/lib/ntp/drift
%{_mandir}/man1/*
%{_mandir}/man5/*
%{_mandir}/man8/*
%{_fillupdir}/*
%attr(0755,ntp,root) %{_localstatedir}/lib/ntp%{_localstatedir}/run/ntp
%ghost %config(noreplace) %{_localstatedir}/log/ntp
%{_datadir}/omc/svcinfo.d/ntp.xml
/var/lib/ntp

%files doc
%defattr(-,root,root)
%doc %{_docdir}/ntp-doc

%changelog
* Fri Aug 29 2025 max@suse.com
- bsc#1247587: Fix a crash when calling "sntp -d".
  * ntp-sntp-assert.patch
- Update source URL.
* Fri Mar 21 2025 max@suse.com
- Update to 4.2.8p18
  * obsoletes Get-rid-of-EVP_MD_CTX_FLAG_NON_FIPS_ALLOW.patch
  * Multiple bug fixes and improvements. For details, see:
    /usr/share/doc/packages/ntp/ChangeLog
    http://www.ntp.org/support/securitynotice/4_2_8-series-changelog/
- bsc#1233890: chown refclock device to ntp user on startup.
- ntp-check-argv.patch: Improve the handling of the process name of
  the forked-off DNS resolver process.
* Wed Apr 24 2024 meissner@suse.com
- Get-rid-of-EVP_MD_CTX_FLAG_NON_FIPS_ALLOW.patch:
  Allow certain usages of MD5 in FIPS mode. (bsc#1222865)
* Wed Jun  7 2023 max@suse.com
- Update to 4.2.8p17:
  * Fix some regressions of 4.2.8p16
- Update to 4.2.8p16:
  * [Sec 3808] Assertion failure in ntpq on malformed RT-11 date
  * [Sec 3807], bsc#1210390, CVE-2023-26555:
    praecis_parse() in the Palisade refclock driver has a
    hypothetical input buffer overflow.
  * [Sec 3767] An OOB KoD RATE value triggers an assertion when
    debug is enabled.
  * Obsoletes: ntp-CVE-2023-26551.patch, ntp-sntp-dst.patch,
    ntp-ENOBUFS.patch
  * Multiple bug fixes and improvements. For details, see:
    /usr/share/doc/packages/ntp/ChangeLog
    http://www.ntp.org/support/securitynotice/4_2_8-series-changelog/
- Follow upstream's suggestion to build with debugging disabled:
  https://www.ntp.org/support/securitynotice/ntpbug3767/
* Fri May  5 2023 max@suse.com
- bsc#1210386: out-of-bounds writes in mstolfp()
  * CVE-2023-26551, CVE-2023-26552, CVE-2023-26553, CVE-2023-26554
  * Add ntp-CVE-2023-26551.patch
* Tue Jun 15 2021 max@suse.com
- bsc#1186431: Fix a typo in %%post .
* Thu May 20 2021 max@suse.com
- jsc#SLE-15482, ntp-clarify-interface.patch:
  Adjust the documentation to clarify that "interface ignore all"
  does not cover the wildcard and localhost addresses.
* Thu Apr 22 2021 max@suse.com
- bsc#1185171:
  Use /run instead of /var/run for PIDFile in ntpd.service.
* Thu Jun 25 2020 max@suse.com
- Update to 4.2.8p15
- Fixed security issues:
  * bsc#1169740, CVE-2020-11868:
    DoS on client ntpd using server mode packet
  * bsc#1171355, CVE-2018-8956: remote attackers may prevent a
    broadcast client from synchronizing its clock with a broadcast
    NTP server via spoofed mode 3 and mode 5 packets.
  * bsc#1172651, CVE-2020-13817: vulnerable to off-path attack
  * bsc#1173334, CVE-2020-15025: Remote DoS when CMAC key is used
- Bugfixes in 4.2.8p15 and 4.2.8p14 include:
  * [Bug 3667] decodenetnum fails with numeric port
  * [Bug 3666] avoid unlimited receive buffer allocation
  * [Bug 3660] Manycast orphan mode startup discovery problem.
  * [Bug 3655] ntpdc memstats hash counts
  * [Bug 3653] Refclock jitter RMS calculation
  * [Bug 3646] Avoid sync with unsync orphan
  * [Bug 3644] Unsynchronized server [...] selected as candidate
  * [Bug 3636] NMEA: combine time/date from multiple sentences
  * [Bug 3635] Make leapsecond file hash check optional
  * [Bug 3628] raw DCF decoding - improve robustness
  * [Bug 3620] memory leak in ntpq sysinfo
  * [Bug 3619] Honour drefid setting in cooked mode and sysinfo
  * [Bug 3617] Add support for ACE III and Copernicus II receivers
  * [Bug 3615] accelerate refclock startup
  * [Bug 3613] Propagate noselect to mobilized pool servers
  * [Bug 3612] Use-of-uninitialized-value in receive function
  * [Bug 3611] NMEA time interpreted incorrectly
  * [Bug 3609] Fixing wrong falseticker in case of non-statistic jitter
  * [Bug 3604] Wrong param byte order passing into
    record_raw_stats() in ntp_io.c
  * [Bug 3594] ntpd discards messages coming through nmead
  * [Bug 3593] ntpd discards silently nmea messages after the 5th string
  * [Bug 3590] Update refclock_oncore.c to the new GPS date API
  * [Bug 3583] synchronization error - set clock to base date
    if system time is before that limit
  * [Bug 3582] gpsdjson refclock fudgetime1 adjustment is doubled
  * [Bug 3580] Possible bug ntpq-subs (NULL dereference in dogetassoc)
  * [Bug 3577] Update refclock_zyfer.c to the new GPS date API
  * [Bug 3576] New GPS date function API
  * [Bug 3573] nptdate: missleading error message
  * [Bug 3569] cleanup MOD_NANO/STA_NANO handling for 'ntpadjtimex()'
  * [Bug 3550] Reproducible build: Respect SOURCE_DATE_EPOCH
  * [Bug 3542] ntpdc monlist parameters cannot be set
  * [Bug 3533] ntpdc peer_info ipv6 issues
  * [Bug 3531] make check: test-decodenetnum fails
  * [Bug 3515] Refactor ntpdmain() dispatcher loop and group
    common code
  * [Bug 3491] Signed values of LFP datatypes should always
    display a sign
  * [Bug 3490] Patch to support Trimble Resolution Receivers
  * [Bug 3473] RefID of refclocks should always be text format
  * [Bug 3094] ntpd trying to listen for broadcasts on a
    completely ipv6 network
  * [Bug 2420] ntpd doesn't run and exits with retval 0 when
    invalid user is specified with -u
  * [Bug 1433] runtime check whether the kernel really supports
    capabilities
  * Provide more detail on unrecognized config file parser tokens.
  * Startup log improvements.
- Obsoleted patches:
  * ntp-4.2.6p2-ntpq-speedup-782060.patch
  * ntp-daemonize.patch
  * ntp-reproducible.patch
- Silence an OpenSSL version warning (bsc#992038,bsc#1125401
  ntp-openssl-version.patch).
* Mon Mar 11 2019 max@suse.com
- Update to 4.2.8p13
  * CVE-2019-8936, bsc#1128525: Crafted null dereference attack in
    authenticated mode 6 packet.
  * Fix several bugs in the BANCOMM reclock driver.
  * Fix ntp_loopfilter.c snprintf compilation warnings.
  * Fix spurious initgroups() error message.
  * Fix STA_NANO struct timex units.
  * Fix GPS week rollover in libparse.
  * Fix incorrect poll interval in packet.
  * Add a missing check for ENABLE_CMAC.
* Tue Sep 11 2018 max@suse.com
- Update to 4.2.8p12 (bsc#1111853):
  * CVE-2018-12327, bsc#1098531: fixed stack buffer overflow in
    the openhost() command-line call of NTPQ/NTPDC.
  * Add further tweaks to improve the fix for CVE-2018-7170,
    bsc#1083424.
  * ntp-usrgrp-resolver.patch was integrated upstream.
- Don't run autoreconf anymore and remove all related hacks and
  BuildRequires.
* Tue Apr 24 2018 max@suse.com
- Refactor the key handling in %%post so that it does not overwrite
  user settings (bsc#1036505) and is more robust against ignored
  SIGPIPE (bsc#1090564).
* Sun Mar 18 2018 suse-beta@cboltz.de
- change example statsdir in ntp.conf to /var/log/ntpstats/ to match
  the AppArmor profile (boo#1076247)
* Wed Feb 28 2018 max@suse.com
- Update to 4.2.8p11 (bsc#1082210):
  * CVE-2016-1549: Sybil vulnerability: ephemeral association
    attack. While fixed in ntp-4.2.8p7, there are significant
    additional protections for this issue in 4.2.8p11.
  * CVE-2018-7182, bsc#1083426: ctl_getitem(): buffer read overrun
    leads to undefined behavior and information leak.
  * CVE-2018-7170, bsc#1083424: Multiple authenticated ephemeral
    associations.
  * CVE-2018-7184, bsc#1083422: Interleaved symmetric mode cannot
    recover from bad state.
  * CVE-2018-7185, bsc#1083420: Unauthenticated packet can reset
    authenticated interleaved association.
  * CVE-2018-7183, bsc#1083417: ntpq:decodearr() can write beyond
    its buffer limit.
  * Obsoletes these patches: ntp-sntp-a.patch, ntp-warnings.patch
- Remove dead code from conf.start-ntpd (bsc#1082063).
- Don't use libevent's cached time stamps in sntp.
  (bsc#1077445, ntp-sntp-libevent.patch)
* Thu Dec 21 2017 bwiedemann@suse.com
- Add ntp-reproducible.patch to make build reproducible (boo#1047218)
* Tue Dec 19 2017 max@suse.com
- Restart nptd if failed or aborted (FATE#315133).
- Do not try to set the HW clock when adding a server at runtime
  to avoid blocking systemd.
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Thu Apr  6 2017 max@suse.com
- Enable experimental leap smearing (fate#321003).
  See /usr/share/doc/packages/ntp/README.leapsmear for details.
* Thu Apr  6 2017 aj@ajaissle.de
- Fix spelling and default values in conf.sysconfig.ntp
* Wed Mar 22 2017 max@suse.com
- Update to 4.2.8p10 (bsc#1030050):
  * Sec 3389 / CVE-2017-6464 / VU#325339: NTP-01-016 NTP:
    Denial of Service via Malformed Config
  * Sec 3388 / CVE-2017-6462 / VU#325339: NTP-01-014 NTP:
    Buffer Overflow in DPTS Clock
  * Sec 3387 / CVE-2017-6463 / VU#325339: NTP-01-012 NTP:
    Authenticated DoS via Malicious Config Option
  * Sec 3386: NTP-01-011 NTP:
    ntpq_stripquotes() returns incorrect Value
  * Sec 3385: NTP-01-010 NTP:
    ereallocarray()/eallocarray() underused
  * Sec 3381: NTP-01-006 NTP: Copious amounts of Unused Code
  * Sec 3380: NTP-01-005 NTP: Off-by-one in Oncore GPS Receiver
  * Sec 3379 / CVE-2017-6458 / VU#325339: NTP-01-004 NTP:
    Potential Overflows in ctl_put() functions
  * Sec 3378 / CVE-2017-6451 / VU#325339: NTP-01-003
    Improper use of snprintf() in mx4200_send()
  * Sec 3377 / CVE-2017-6460 / VU#325339: NTP-01-002
    Buffer Overflow in ntpq when fetching reslist
  * Sec 3376: NTP-01-001 Makefile does not enforce Security Flags
  * Sec 3361 / CVE-2016-9042 / VU#325339: 0rigin (zero origin) DoS.
  * [Bug 3393] clang scan-build findings
  * [Bug 3363] Support for openssl-1.1.0 without compatibility modes
  * [Bug 3356] Bugfix 3072 breaks multicastclient
  * [Bug 3173] forking async worker: interrupted pipe I/O
  * [Bug 3139] (...) time_pps_create: Exec format error
  * [Bug 3107] Incorrect Logic for Peer Event Limiting
  * [Bug 3062] Change the process name of forked DNS worker
  * [Bug 2923] Trap Configuration Fail
  * [Bug 2896] Nothing happens if minsane < maxclock < minclock
  * [Bug 2851] allow -4/-6 on restrict line with mask
  * [Bug 2645] out-of-bound pointers in ctl_putsys and decode_bitflags
- Removed patches:
  * ntp-openssl-version.patch: fixed upstream
  * ntp-processname.patch: accepted upstream
  * ntp-trap.patch: accepted upstream
  * ntp-unbreak-multicast.patch: fixed upstream
- Remove spurious log messages (bsc#1014172, ntp-warnings.patch).
* Fri Mar 10 2017 max@suse.com
- Fix a problem with multicast clients.
  (bsc#1018940, ntp-unbreak-multicast.patch)
* Tue Feb 21 2017 kukuk@suse.de
- Move ntp-kod to /var/lib/ntp, because /var/db is not a
  standard directory and causes problems for transactional updates
  (ntp-move-kod-file.patch)
* Tue Jan 17 2017 max@suse.com
- Remove 50-ntp.list (bsc#1011919).
- Use system-wide libevent instead of local copy.
* Mon Nov 28 2016 max@suse.com
- Simplify ntpd's search for its own executable to prevent AppArmor
  warnings (bsc#956365, ntp-pathfind.patch).
* Mon Nov 21 2016 max@suse.com
- Update to 4.2.8p9:
  * CVE-2016-9311: Trap crash.
  * CVE-2016-9310: Mode 6 unauthenticated trap information
    disclosure and DDoS vector.
  * CVE-2016-7427: Broadcast Mode Replay Prevention DoS.
  * CVE-2016-7428: Broadcast Mode Poll Interval Enforcement DoS.
  * CVE-2016-7431: Regression: 010-origin: Zero Origin Timestamp
    Bypass.
  * CVE-2016-7434: Null pointer dereference in
    _IO_str_init_static_internal().
  * CVE-2016-7429: Interface selection attack.
  * CVE-2016-7426: Client rate limiting and server responses.
  * CVE-2016-7433: Reboot sync calculation problem.
  * Fix a spurious error message (obsoletes ntp-sigchld.patch).
  * Other bugfixes, see /usr/share/doc/packages/ntp/ChangeLog.
- Fix a regression in "trap" (bsc#981252, ntp-trap.patch).
- Reduce the number of netlink groups to listen on for changes to
  the local network setup (bsc#992606, ntp-netlink.patch).
- Fix segfault in "sntp -a" (bnc#1009434, ntp-sntp-a.patch).
- Silence an OpenSSL version warning (bsc#992038,
  ntp-openssl-version.patch).
* Wed Oct  5 2016 guillaume@opensuse.org
- Depend on pps-tools-devel only for openSUSE > 13.2
* Thu Aug 25 2016 josef.moellers@suse.com
- Make the resolver task change user and group IDs to the same
  values as the main task. (bnc#988028, ntp-usrgrp-resolver.patch)
* Tue Jun  7 2016 max@suse.com
- Keep the parent process alive until the daemon has finished
  initialisation, to make sure that the PID file exists when the
  parent returns (ntp-daemonize.patch).
- Update to 4.2.8p8 (bsc#982056):
  * CVE-2016-4953, bsc#982065: Bad authentication demobilizes
    ephemeral associations.
  * CVE-2016-4954, bsc#982066: Processing spoofed server packets.
  * CVE-2016-4955, bsc#982067: Autokey association reset.
  * CVE-2016-4956, bsc#982068: Broadcast interleave.
  * CVE-2016-4957, bsc#982064: CRYPTO_NAK crash.
- Change the process name of the forking DNS worker process to
  avoid the impression that ntpd is started twice.
  (bsc#979302, ntp-processname.patch).
- Don't ignore SIGCHILD because it breaks wait()
  (boo#981422, ntp-sigchld.patch).
- ntp-wait does not accept fractional seconds, so use 1 instead of
  0.2 in ntp-wait.service (boo#979981).
- Separate the creation of ntp.keys and key #1 in it to avoid
  problems when upgrading installations that have the file, but
  no key #1, which is needed e.g. by "rcntp addserver".
- Fix the TZ offset output of sntp during DST.
  (bsc#951559, ntp-sntp-dst.patch)
- Add /var/db/ntp-kod (bsc#916617).
- Add ntp-ENOBUFS.patch to limit a warning that might happen
  quite a lot on loaded systems (bsc#956773).
- Don't wait for 11 minutes to restart ntpd when it has died
  (boo#894031).
* Wed May  4 2016 max@suse.com
- Update to 4.2.8p7 (bsc#977446):
  * CVE-2016-1547, bsc#977459:
    Validate crypto-NAKs, AKA: CRYPTO-NAK DoS.
  * CVE-2016-1548, bsc#977461: Interleave-pivot
  * CVE-2016-1549, bsc#977451:
    Sybil vulnerability: ephemeral association attack.
  * CVE-2016-1550, bsc#977464: Improve NTP security against buffer
    comparison timing attacks.
  * CVE-2016-1551, bsc#977450:
    Refclock impersonation vulnerability
  * CVE-2016-2516, bsc#977452: Duplicate IPs on unconfig
    directives will cause an assertion botch in ntpd.
  * CVE-2016-2517, bsc#977455: remote configuration trustedkey/
    requestkey/controlkey values are not properly validated.
  * CVE-2016-2518, bsc#977457: Crafted addpeer with hmode > 7
    causes array wraparound with MATCH_ASSOC.
  * CVE-2016-2519, bsc#977458: ctl_getitem() return value not
    always checked.
  * integrate ntp-fork.patch
  * Improve the fixes for:
    CVE-2015-7704, CVE-2015-7705, CVE-2015-7974
- Restrict the parser in the startup script to the first
  occurrance of "keys" and "controlkey" in ntp.conf (boo#957226).
- Depend on pps-tools-devel to provide timepps.h header to enable
  Linux PPSAPI support to make GPS devices usefull. (boo#977563)
* Fri Mar 11 2016 max@suse.com
- CVE-2015-8158, bsc#962966: potential infinite loop in ntpq
- CVE-2015-8138, bsc#963002: Zero Origin Timestamp Bypass
- CVE-2015-7978, bsc#963000: Stack exhaustion in recursive
  traversal of restriction list.
- CVE-2015-7979, bsc#962784: off-path denial of service on
  authenticated broadcast mode
- CVE-2015-7977, bsc#962970: restriction list NULL pointer
  dereference
- CVE-2015-7976, bsc#962802: 'ntpq saveconfig' command allows
  dangerous characters in filenames
- CVE-2015-7975, bsc#962988: nextvar() missing length check in ntpq
- CVE-2015-7974, bsc#962960: Missing key check allows impersonation
  between authenticated peers
- CVE-2015-7973, bsc#962995: replay attack on authenticated
  broadcast mode
- CVE-2015-5300, bsc#951629: MITM attacker can force ntpd to make
  a step larger than the panic threshold
* Mon Mar  7 2016 hsk@imb-jena.de
- update to 4.2.8p6
  * fixes low- and medium-severity vulnerabilities
    4.2.8p6: CVE-2015-8158 CVE-2015-8138 CVE-2015-7978
    CVE-2015-7979 CVE-2015-7977 CVE-2015-7976 CVE-2015-7975
    CVE-2015-7974 CVE-2015-7973
    4.2.8p5: CVE-2015-5300
  * bug fixes
* Mon Jan 18 2016 wbauer@tmo.at
- Explicitely run /usr/sbin/sntp to synchronize in start-ntpd. When
  run as cron job, /usr/sbin/ is not in the path, which caused the
  synchronization to fail. (boo#962318)
* Fri Nov  6 2015 max@suse.com
- Fix ntp-4.2.6p2-ntpq-speedup-782060.patch to not pick arbitraty
  port numbers (bsc#782060).
* Thu Oct 29 2015 max@suse.com
- Update to 4.2.8p4 to fix several security issues (bsc#951608):
  * CVE-2015-7871: NAK to the Future: Symmetric association
    authentication bypass via crypto-NAK
  * CVE-2015-7855: decodenetnum() will ASSERT botch instead of
    returning FAIL on some bogus values
  * CVE-2015-7854: Password Length Memory Corruption Vulnerability
  * CVE-2015-7853: Invalid length data provided by a custom
    refclock driver could cause a buffer overflow
  * CVE-2015-7852 ntpq atoascii() Memory Corruption Vulnerability
  * CVE-2015-7851 saveconfig Directory Traversal Vulnerability
  * CVE-2015-7850 remote config logfile-keyfile
  * CVE-2015-7849 trusted key use-after-free
  * CVE-2015-7848 mode 7 loop counter underrun
  * CVE-2015-7701 Slow memory leak in CRYPTO_ASSOC
  * CVE-2015-7703 configuration directives "pidfile" and
    "driftfile" should only be allowed locally
  * CVE-2015-7704, CVE-2015-7705 Clients that receive a KoD should
    validate the origin timestamp field
  * CVE-2015-7691, CVE-2015-7692, CVE-2015-7702 Incomplete autokey
    data packet length checks
  * obsoletes ntp-memlock.patch.
- Add a controlkey line to /etc/ntp.conf if one does not already
  exist, to allow runtime configuration via ntpq.
- Use SHA1 instead of MD5 for symmetric keys (bsc#905885).
- Improve runtime configuration:
  * Read keytype from ntp.conf
  * Don't write ntp keys to syslog.
- Fix legacy action scripts to pass on command line arguments.
- Remove ntp.1.gz, it wasn't installed anymore.
- Remove ntp-4.2.7-rh-manpages.tar.gz and only keep ntptime.8.gz.
  The rest is partially irrelevant, partially redundant and
  potentially outdated (bsc#942587).
- Remove "kod" from the restrict line in ntp.conf (bsc#944300).
* Fri Sep  4 2015 max@suse.com
- Add "addserver" as a new legacy action.
- Fix the comment regarding addserver in ntp.conf (bnc#910063).
* Thu Aug 13 2015 max@suse.com
- Use ntpq instead of deprecated ntpdc in start-ntpd (bnc#936327).
- Add a controlkey to ntp.conf to make the above work.
- Don't let "keysdir" lines in ntp.conf trigger the "keys" parser.
- Disable mode 7 (ntpdc) again, now that we don't use it anymore.
* Thu Jul 16 2015 max@suse.com
- Update to version 4.2.8p3 which incorporates all security fixes
  and most other patches we have so far (fate#319040).
  More information on:
  http://archive.ntp.org/ntp4/ChangeLog-stable
- Disable chroot by default (bnc#926510).
- Enable ntpdc for backwards compatibility (bnc#920238).
* Tue Apr  7 2015 hsk@imb-jena.de
- update to 4.2.8p2
  * fixes CVE-2015-1798, CVE-2015-1799 (medium-severity
    vulnerabilities involving private key authentication)
  * bug fixes and enhancements
  * New script: update-leap
* Fri Mar 27 2015 max@suse.com
- /bin/logger is needed for runtime configuration (bnc#924451).
* Mon Mar 16 2015 hsk@imb-jena.de
- update to 4.2.8p1
  * fixes CVE-2014-9297, CVE-2014-9298
  * over 30 bugfixes and improvements
- update to 4.2.8
  * fixes CVE-2014-9293, CVE-2014-9294, CVE-2014-9295, CVE-2014-9296
  * changed Internal NTP Era counters
  * ntpdc responses disabled by default
  * over 1100 issues resolved between the 4.2.6 branch and 4.2.8
- adjusted patches to fit 4.2.8p1:
  ntp-segfault_on_invalid_device.patch bnc#506908.diff MOD_NANO.diff
- removed obsolete / now-in-upstream patches:
  ntpd-maxmonmen.patch ntp-code-cleanup.patch ntp-sntp-recverr.patch
  bnc#817893.patch ntp-CVE-2014-9295.patch ntp-CVE-2014-9296.patch
- changes to spec file:
  * added --datadir (for private perl module needed by ntp scripts)
    and --html-dir (html docs now get installed by "make install")
    to configure options
  * script ntp-wait has moved in source tree
* Mon Mar 16 2015 crrodriguez@opensuse.org
- *.service: Do not start ntpd when running on containers
  or when CAP_SYS_TIME was dropped from the default capability
  set ( see SYSTEMD-SYSTEM.CONF(5) for details)
* Sun Mar  8 2015 wbauer@tmo.at
- Explicitely run /usr/sbin/sntp to synchronize in start-ntpd. When
  run as cron job, /usr/sbin/ is not in the path, which caused the
  synchronization to fail. (boo#901751)
* Wed Jan 21 2015 dimstar@opensuse.org
- Add ntp.NetworkManager: install NetworkManager dipatcher hook:
  if the DHCP Server delivers NTP Servers, accept those and
  configure NTP using the information (boo#900982).
* Sun Jan  4 2015 mpluskal@suse.com
- Enable avahi support
* Fri Dec 19 2014 max@suse.com
- bnc#910764: VU#852879 ntp security fixes
  * A potential remote code execution problem was found inside
    ntpd. The functions crypto_recv() (when using autokey
    authentication), ctl_putdata(), and configure() where updated
    to avoid buffer overflows that could be
    exploited. (CVE-2014-9295)
  * Furthermore a problem inside the ntpd error handling was found
    that is missing a return statement. This could also lead to a
    potentially attack vector. (CVE-2014-9296)
- ntp-CVE-2014-9295.patch and ntp-CVE-2014-9296.patch will be
  obsoleted by the upcoming update to version 4.2.8.
* Tue Dec  2 2014 obs@botter.cc
- fix typo in version check regarding
  /usr/lib/initscripts/legacy-actions to fix build for <= 13.1
* Fri Sep 26 2014 max@suse.com
- Re-enable the ntptimeset legacy init script action (bnc#893406).
* Tue Sep  9 2014 crrodriguez@opensuse.org
- conf.ntpd.service: Must run with PrivateTmp set to true
* Tue Jul 15 2014 crrodriguez@opensuse.org
- Ensure systemd services conflict with systemd-timesyncd.service
  present in upcoming systemd releases.
* Wed Jun 18 2014 tchvatal@suse.com
- Try to fix broken migration from openSUSE-13.1
* Thu Jun 12 2014 max@suse.com
- Forward-port some bugs that got fixed for SLE11 (bnc#831311):
  * bnc#817893
  * bnc#482349
  * bnc#817893.patch
* Thu Jun  5 2014 tchvatal@suse.com
- Cleanup with spec cleaner for better readability
- Remove conditionals for < 12.2 distros as it does not work on
  them anyway.
* Mon May  5 2014 seife+obs@b1-systems.com
- fix start-ntpd again: service is now called ntpd, not ntp
* Tue Apr 29 2014 max@suse.com
- Remove /var/run/ntp from the package:
  http://lists.opensuse.org/opensuse-packaging/2014-04/msg00046.html
- Fix Provides/Obsoletes of package aliases.
- Add /usr/sbin/rc* links.
- Stay enabled across sysv to systemd migrations (bnc#875490).
* Sat Apr 19 2014 seife+obs@b1-systems.com
- fix "start-ntp addserver": start-ntp has no "status" method
* Thu Apr  3 2014 werner@suse.de
- Remove empty insserv call whic hhad only caused an error message
- Correct 50-ntp.list to include ntpd.service
* Mon Mar 31 2014 werner@suse.de
- Restart nptd if failed or aborted (FATE#315133)
* Thu Mar 27 2014 werner@suse.de
- Service unit files are no executables
* Thu Mar 27 2014 werner@suse.de
- Use correct ntp-wait script from source tar ball (bnc#864193)
- Implement new ntp-wait.service to provide time-sync.target
- A few cleanups on the new start script of ntpd
* Thu Mar 27 2014 kukuk@suse.de
- Add missing systemd %%pre macro
* Tue Mar  4 2014 varkoly@suse.com
- Add systemd configuration and start script
* Fri Feb 14 2014 max@suse.com
- bnc#863815, ntp-sntp-recverr.patch: Get sntp to recognize socket
  errors, so that it skips unreachable destinations immediately
  instead of trying to reach them for more than five minutes
  before finally timing out.
  This patch will probably be obsoleted by the next major upgrade,
  because the current development release takes a different
  approach to get a quick answer from one of the specified servers.
* Mon Jan 20 2014 max@suse.com
- CVE-2013-5211, bnc#857195: restrict query, configuration,
  modification access from world by default. Avoids that ntp can
  be used as a DDoS amplifier.
* Tue Oct 22 2013 varkoly@suse.com
- bnc#838458 ntp start script does not update /var/lib/ntp/etc/localtime file if /etc/localtime is symlink
* Mon Aug 19 2013 crrodriguez@opensuse.org
- Build with -DOPENSSL_LOAD_CONF , ntp must respect and use
  the system's openssl configuration.
* Sat Mar  9 2013 seife+obs@b1-systems.com
- fix build with automake-1.13
* Thu Feb 28 2013 varkoly@suse.com
- bnc#797351 - ntpd "listen-on" directive support is missing/broken;
  unable to restrict/secure listening IPs
* Tue Feb 26 2013 varkoly@suse.com
- bnc#793012 - NTP default to 'sync time on startup' conflicts with NetworkManager
* Fri Feb 22 2013 mhrusecky@suse.cz
- disable Undisciplined Local Clock in default conf file (bnc#784760)
* Fri Jan 18 2013 bwiedemann@suse.com
- Speedup ntpq (bnc#782060)
  +ntp-4.2.6p2-ntpq-speedup-782060.patch
* Thu Jan 17 2013 varkoly@suse.com
- bnc#450196 - ext3 - recovering journal on / on first boot on new kernel/fresh system updates
- bnc#774553 - ntp initscript: hwclock: With --noadjfile, you must specify either --utc or --localtime
* Fri Dec 14 2012 lnussel@suse.de
- logrotate is not strictly required for operation of ntp so change
  it to Suggested. That way the minimal installation doesn't draw in
  cron and postfix.
* Thu Aug  2 2012 rmilasan@suse.com
- Created the correct link to /run/ntp
* Thu Jul 19 2012 crrodriguez@opensuse.org
-  Openssl wanted but not properly detected, fixed.
* Wed Jul  4 2012 cfarrell@suse.com
- license update: (MIT and BSD-3-Clause and BSD-4-Clause) and GPL-2.0
  Properly categorise licenses and sync with Fedora declaration
* Mon Apr 23 2012 varkoly@suse.com
- bnc#758253 - L3: ntp fails if host has more than 1024 IP-addresses
  ntp#1180 - ntpd won't start with more than 1000 interfaces
* Mon Jan  9 2012 lmuelle@suse.com
- Remove superfluous remove of acconfig.h while build.
- BuildRequire autoconf to avoid implicit dependency for post-11.4 systems.
- Remove call to suse_update_config macro for post-11.4 systems.
* Mon Jan  9 2012 lmuelle@suse.com
- BuildRequire fdupes for post-10.1 systems.
- Do not call autoreconf for pre-10.2 systems.
* Mon Jan  9 2012 lmuelle@suse.de
- Update to version 4.2.6p5.
  - ntpd
  * Updated "nic" and "interface" IPv6 address handling to prevent
    mismatches with localhost [::1] and wildcard [::] which resulted from
    using the address/prefix format (e.g. fe80::/64)
  * Fix orphan mode stratum incorrectly counting to infinity
  * Orphan parent selection metric updated to includes missing ntohl()
  * Non-printable stratum 16 refid no longer sent to ntp
  * Duplicate ephemeral associations suppressed for broadcastclient and
    multicastclient without broadcastdelay
  * Exclude undetermined sys_refid from use in loopback TEST12
  * Exclude MODE_SERVER responses from KoD rate limiting
  * Include root delay in clock_update() sys_rootdisp calculations
  * get_systime() updated to exclude sys_residual offset (which only
    affected bits "below" sys_tick, the precision threshold)
  * sys.peer jitter weighting corrected in sys_jitter calculation
  - ntpq
  * -n option extended to include the billboard "server" column
  * IPv6 addresses in the local column truncated to prevent overruns
- Update to version 4.2.6p4.
  - Build system
  * Fix checking for struct rtattr
  * Upgrade required version of autogen and libopts for building
    from our source code repository
  - ntpd
  * Back-ported several fixes for Coverity warnings from ntp-dev
  * Fix a rare boundary condition in UNLINK_EXPR_SLIST()
  * Allow "logconfig =allall" configuration directive
  * Bind tentative IPv6 addresses on Linux
  * Correct WWVB/Spectracom driver to timestamp CR instead of LF
  * Improved tally bit handling to prevent incorrect ntpq peer status reports
  * Exclude the Undisciplined Local Clock and ACTS drivers from the initial
    candidate list unless they are designated a "prefer peer"
  * Prevent the consideration of Undisciplined Local Clock or ACTS drivers for
    selection during the 'tos orphanwait' period·
  * Prefer an Orphan Mode Parent over the Undisciplined Local Clock or ACTS
    drivers
  * Improved support of the Parse Refclock trusttime flag in Meinberg mode
  * Back-port utility routines from ntp-dev: mprintf(), emalloc_zero()
  * Code cleanup in libntpq
  - ntpdc
  * Fix timerstats reporting
  - ntpdate
  * Reduce time required to set clock
  * Allow a timeout greater than 2 seconds
  - sntp
  * Backward incompatible command-line option change:
  - l/--filelog changed -l/--logfile (to be consistent with ntpd)
  - Documentation
  * Update html2man. Fix some tags in the .html files
  * Distribute ntp-wait.html
* Mon Jan  9 2012 lmuelle@suse.de
- Remove superfluously used NTPD_PID_NOPREFIX from init script.
- Refresh patches to apply with no offset.
* Thu Nov 24 2011 varkoly@suse.com
- bnc#730374 - Hardware Clock does not get synchronized
* Wed Nov 23 2011 coolo@suse.com
- add libtool as buildrequire to avoid implicit dependency
* Thu Oct 27 2011 varkoly@suse.com
- bnc#656509 - don't use --bind on /var/lib/ntp/proc
* Fri Aug 26 2011 varkoly@suse.com
- bnc#699724 - ntpdate was replaced with a dud script
* Wed Jun  1 2011 varkoly@suse.de
- The default timeout for sntp is to long. This can stop booting
- bnc#689070 - ntp post install script always removes /etc/sysconfig/ntp
- bnc#688529 - (ntp) ntpq and ntpdc command history broken
- bnc#695598 - "Started sntp" in /var/log/messages
* Sun May  1 2011 hpj@urpla.net
- fix "rcntp ntptimeset"
  * never try to syncronize with local clocks (127.127.*), which led to
    sntp blocking until timeout elapsed (and probably blocking boot
    sequence for ~5 min per device..)
- fix DOS line breaks in some doc files
* Tue Apr 26 2011 varkoly@novell.com
- fix/improve init script
  * related to bugzilla 688132
  * "rcntp ntptimeset" could not parse servers from ntp.conf when IP proto
    was specified (server [-4|-6] hostname)
  * "rcntp ntptimeset" is now using ip proto parameter (-4|-6) if it's set in
    NTPD_OPTIONS and skip servers where the opposite proto is defined
* Fri Apr  1 2011 hpj@urpla.net
- replace remove-ntpdate.diff with sed script
- don't effectively zap existing /etc/sysconfig/ntp
- while at it, simplify /etc/sysconfig/ntp update
- improve NTP_PARSE_DEVICE documentation for /etc/sysconfig/ntp
- refresh all patches with offsets and fuzz
* Thu Feb  3 2011 mvidner@suse.cz
- updated the sntp syntax also in our ntpdate script (bnc#658255#c2)
* Tue Jan  4 2011 adrian@suse.de
- update to version 4.2.6p3
  * main feature, it really ! updates the time, old version was
    miscalculating the offset based on t21 and t34
* Tue Jan  4 2011 adrian@suse.de
- require $network startup before ntp. This is not enforced via
  $network_fs when no nfs and cifs is enabled
* Tue Dec 14 2010 ismail@namtrac.org
- bnc#657194 - compile with --enable-ntp-signd
* Mon Dec 13 2010 varkoly@novell.com
- bnc#658799 - ntp init script makes /proc readonly, blocking login
* Wed Dec  8 2010 varkoly@novell.com
- bnc#658255 - ntpd is not working and sntp complains about unknown options
* Tue Nov 30 2010 varkoly@novell.com
- update to 4.2.6p2
  * Major code clean up.
    1. The protostats statistics files have been very useful in exposing
    little twitches and turns when something hiccups, like a broken PPS
    signal. Most of what used to be syslog messages are now repackaged as
    protostats messages with optional syslog as well.
    2. Close inspection of the clock discipline behavior at long poll
    intervals (36 h) showed it not doing as well as it should.
    3. Autokey. The enhanced error checking was becoming a major pain. A way was found
    to toss out gobs of ugly fat code and replace the function with a much simpler
    and more comprehensive scheme.
    4. The interface code for the kernel PPS signal was not in sync with the
    kernel code itself. Some error checks were duplicated and some ineffective.
    5. The flake restrict bit turned out to be really interesting, especially
    with symmtric modes and of those especially those using Autokey.
  * Documentation updates
- New old feature: sync time on startup. If not needed NTPD_FORCE_SYNC_ON_STARTUP must
  be set to no in /etc/sysconfig/ntp
* Tue Sep 28 2010 aj@suse.de
- Handle /var/run as tmpfs
* Fri Apr 23 2010 varkoly@novell.com
- Set time by starting ntp via ntptimeset
* Fri Apr  9 2010 varkoly@novell.com
- rcntp timeset now gets the time via sntp inmediately
* Sun Mar 21 2010 novellbmw@lsmod.de
- fix read-only mount of proc in chroot
* Thu Mar 18 2010 varkoly@novell.com
- bnc#574885 - XEN is using many network interfaces and stopping and
  restarting XEN instances results in ntpd error "Cannot find existing
  interface for address ...".
* Wed Jan  6 2010 jengelh@medozas.de
- enable parallel build
* Wed Dec  9 2009 varkoly@suse.de
- update to ntp-4.2.4p8 to fix bnc#550316 - VUL-0: ntp DoS
- bnc#557716 - NTP PLL does not converge based on
  https://support.ntp.org/bugs/show_bug.cgi?id=1219
* Sat Nov 28 2009 seife@opensuse.org
- Also fix multiple mount on multiple "rcntp start" invocations
* Mon Aug 31 2009 tiwai@suse.de
- Really fix the multiple mount bug in ntp init script (bnc#517222)
* Mon Jul 20 2009 varkoly@suse.de
- bnc#517222 – Minor patch for ntp init-script
* Tue Jul 14 2009 aj@suse.de
- Add ntp-4.2.4p7-autoconf.patch to fix build failure.
* Fri Jul 10 2009 varkoly@suse.de
- bnc#515629 - NM_ONLINE_TIMEOUT does not work with parallel boot
- bnc#521044 - ntp init script: /etc/init.d/ntp: line 70: return: can
  only `return' from a function or sourced script
* Fri Jun 19 2009 varkoly@suse.de
- bnc#506908 - ntptrace doesn't work as non root user
- update to 4.2.4p7:
  * [Sec 1151] Remote exploit if autokey is enabled - CVE-2009-1252.
  * [Bug 1187] Update the copyright date.
  * [Bug 1191] ntpd fails on Win2000 - "Address already in use" after fix for [Sec 1149].
  * ntp.isc.org -> ntp.org cleanup.
  * [Bug 1178] Use prior FORCE_DNSRETRY behavior as needed at runtime,
  add configure --enable-ignore-dns-errors to be even more stubborn
  * [Bug 784] Make --enable-linuxcaps the default when available
  * [Bug 1179] error messages for -u/--user and -i lacking droproot
  * Updated JJY reference clock driver from Takao Abe
  * [Bug 1071] Log a message and exit before trying to use FD_SET with a
  descriptor larger than FD_SETSIZE, which will corrupt memory
  * On corruption of the iface list head in add_interface, log and exit
  * [Bug 1172] 4.2.4p7-RC{3,4} fail to build on linux.
  * flock-build script unportable 'set -m' use removed
  * [Bug 1167] use gcc -Winit-self only if it is understood
  * [Bug 787] Bug fixes for 64-bit time_t on Windows
  * [Bug 813] Conditional naming of Event
  * [Bug 1147] System errors should be logged to msyslog()
  * [Bug 1155] Fix compile problem on Windows with VS2005
  * [Bug 1156] lock_thread_to_processor() should be declared in header
  * [Bug 1157] quiet OpenSSL warnings, clean up configure.ac
  * [Bug 1158] support for aix6.1
  * [Bug 1160] MacOS X is like BSD regarding F_SETOWN
  * [Sec 1144] limited buffer overflow in ntpq.  CVE-2009-0159
  * [Sec 1149] use SO_EXCLUSIVEADDRUSE on Windows
  * [Bug 1131] UDP sockets should not use SIGPOLL on Solaris.
  * build system email address cleanup
  * [Bug 774] parsesolaris.c does not compile under the new Solaris
  * [Bug 873] Windows serial refclock proper TTY line discipline emulation
  * [Bug 1014] Enable building with VC9 (in Visual Studio 2008,
  Visual C++ 2008, or SDK)
  * [Bug 1117] Deferred interface binding under Windows works only correctly
  if FORCE_DNSRETRY is defined
  * [BUG 1124] Lock QueryPerformanceCounter() client threads to same CPU
  * DPRINTF macro made safer, always evaluates to a statement and will not
  misassociate an else which follows the macro.
* Wed May  6 2009 varkoly@suse.de
- bnc#468685 - ntpd causes 16 wakeups per second
* Wed Apr 29 2009 varkoly@suse.de
- bnc#492304 - ntpd man page refers to package xntp-doc (which does not exist)
- bnc#495496 – ntp misses prereq: /sbin/chkconfig
* Thu Jan  8 2009 varkoly@suse.de
- Fixed build errors with recent versions of openSSL.
- Fix incorrect check of EVP_VerifyFinal()'s return value.
  (bnc#459662 - VUL-0: ntp does not check return value of EVP_VerifyFinal)
* Fri Nov 14 2008 varkoly@suse.de
- (bnc#443228) - Successor of ntpdate (descriped in deprecation note) does not work
* Mon Nov 10 2008 varkoly@suse.de
- (bnc#443304) - netconfig: NTP server not set when using dhcpcd
* Fri Nov  7 2008 varkoly@suse.de
- (bnc#438630) - can't install from livecd - no ntp-server timeout
* Wed Oct 29 2008 varkoly@suse.de
- (bnc#439813) - autobuild does not run because time is appearently out of sync
* Fri Oct 24 2008 varkoly@suse.de
- Add ntp-wait script. This tests if the time is synchronized.
  Very important for time critical services like kerberos.
* Thu Oct 23 2008 varkoly@suse.de
- (bnc#437982) - /usr/sbin/ntpdate: line 27: shift: -1: shift count out of range
- (bnc#437968) - Typo and usability issue in deprecation output of ntpdate
* Fri Oct 17 2008 varkoly@suse.de
- clean up the sources to avoid a lot of compiler warnings
- fixing some unaligned accesses (bnc#430059)
* Mon Oct 13 2008 varkoly@suse.de
- (bnc#434529) - SLES11 Beta2: Firewall opens both TCP and UDP for ntp
- ntpdate is now a wrapper script around sntp. All parameters
  except for the time server will be ignored
* Wed Oct  8 2008 varkoly@suse.de
- Remove redundand patches
- Remove ntpdate because this is obsolete.
* Tue Oct  7 2008 schwab@suse.de
- Don't try to umount /proc.
- Fix error handling.
* Thu Oct  2 2008 varkoly@suse.de
- (bnc#431175) - ntpd hangs during init
* Fri Sep 26 2008 varkoly@suse.de
- (bnc#387236) - VUL-0: ntp complains about format/parity error
  for MD5 key 1, not used
  In the ntp 4.2.4p5  version this problem is solved.
  Only the 4.2.4-w32-time-authentification patch had caused it
  that that did not function.  Now we have droped this patch.
* Thu Sep 11 2008 varkoly@suse.de 
- (bnc#407804) - ntpd stalls boot process
* Tue Sep  9 2008 varkoly@suse.de
- (bnc#274833) - Cypress beta site would like to see NTP as a service to monitor under Health Monitor in NRM.
- update to 4.2.4p5 which
  * Month off by one in leap second message written to clockstats file fixed.
  * Built-in getpass() function also prompts for password if not built with DEBUG.
  * Fix memory leak when fetching system messages.
  * Wake up the resolver thread/process when a new interface has become available.
  * Correctly apply negative-sawtooth for oncore 12 channel receiver.
  * Startup code for original LinuxPPS removed.  LinuxPPS now conforms to the PPSAPI.
  * drop minimum time restriction for interface update interval.
  * Fix mismatching #ifdefs for builds without IPv6.
  * Update the copyright year.
  * Build system cleanup (make autogen-generated files writable).
  * nptdate timeout is too long if several servers are supplied.
  * ntpdate debug mode adjusts system clock when it shouldn't.
  * ntpdate(and ntptimeset) buffer overrun if HAVE_POLL_H isn't set
* Mon Sep  8 2008 varkoly@suse.de
- (bnc#423463) - 2 bugs found in ntpd init script
* Tue Jun 17 2008 varkoly@suse.de
- (bnc#398437) - ntp client has missing dependency to package timezone
- (bnc#397422) - ntp rpm throws an error when installing
* Mon May 26 2008 varkoly@suse.de
- (bnc#393305) – /etc/ntp.conf gets overwritten during an update
* Tue May 20 2008 varkoly@suse.de
- (bnc#388980) – "hang" on boot to runlevel 3
* Wed May 14 2008 anschneider@suse.de
- Create needed if-{up,down}.d symlinks during installation; [bnc#256291].
* Tue May  6 2008 coolo@suse.de
- Fix provides to get rename on distribution upgrade
* Tue Apr  1 2008 mt@suse.de
- Changed init script to avoid waiting for input on stdin
  when it trys to parse $NTP_KEYS file.
* Mon Mar 31 2008 schwab@suse.de
- Wait for ntpd to finish during ntptimeset.
* Wed Mar 26 2008 anschneider@suse.de
- Fix syntax errors in the init script.
* Tue Mar 25 2008 anschneider@suse.de
- Fix IPv6 support in chroot jail; [bnc#333525].
* Tue Mar 25 2008 anschneider@suse.de
- Fix broken init script; [bnc#365515];
* Tue Mar 25 2008 anschneider@suse.de
- Install SuSEfirewall2 service file into the right directory; [bnc#370482].
* Fri Mar 14 2008 aj@suse.de
- Make ntp.init LSB compliant.
- Fix permissions of image file.
- Use fdupes.
* Wed Mar 12 2008 schwab@suse.de
- Fix paren nesting.
* Tue Jan 22 2008 mskibbe@suse.de
- fix specfile
  o check for file before the file is removed
  o remove a "cut" error on some systems
  o fix provides conflict with openntp
- readd sysconfig varible NTPD_RUN_CHROOTED
- fix ifupdown script
* Wed Jan 16 2008 mskibbe@suse.de
- Fate #301836: NTP XML Service Description Document
* Mon Jan  7 2008 mskibbe@suse.de
- Bug 351059 - ntpd should not run with gid=0
* Mon Nov  5 2007 mskibbe@suse.de
- Bug 217032 - xntp rpm package name: eliminate x
- rename patches to a consistent layout ntp*.patch
* Thu Oct 18 2007 mskibbe@suse.de
- update to 2.4.4p4 which
  o Fix problems with the -6 flag.
  o Avoid ntpdc use of refid value as unterminated string.
  o Corrected display of pll offset on 64bit systems.
  o Corrected sign handling on 64bit in ntpdc loopinfo command.
  o avoid malloc() interrupted by SIGIO risk
  o cleanup shutdown while the file descriptor is still open.
  o use emalloc() to get a message at the end of the memory
  o don't access recv buffers after having them passed to the free list.
  o allow loopback interfaces to share addresses with other interfaces.
* Wed Aug 29 2007 mskibbe@suse.de
- Bug 283706 – ntpdate in the init script of ntp fails if the
  network interface is not active
- Bug 256291 - setting initial time and date via ntp and mounting
  of nfs shares with network manager fails
* Mon Jul  9 2007 mskibbe@suse.de
- update to 2.4.4p3 which
  o Broadcast address was not correctly set for interface addresses
  o reduce syslog noise, while there fix Enabled/Disable logging
    to reflect the actual configuration
  o Moved declaration of variable to top of function
  o Fix multicast client crypto authentication and make sure
    arriving multicast packets do not disturb the autokey dance
  o Don't write from source address length to wrong location
  o Upgraded autogen and libopts
  o ntpd should not read a .ntprc file
* Tue Jun  5 2007 mskibbe@suse.de
- file /var/log/ntp is not owned by any package (#280507)
* Mon Jun  4 2007 mskibbe@suse.de
- ntp pollutes the log on ia64 (#272938)
* Mon May 14 2007 mskibbe@suse.de
- readline support for ntp (#246428)
* Fri Apr 13 2007 mskibbe@suse.de
- "rcxntpd start" fails with "ntpd[8013]: crypto_setup: random seed
  file //.rnd not found" (#232512)
* Thu Mar 29 2007 rguenther@suse.de
- add pwdutils BuildRequires for postinstall script execution
* Thu Mar 22 2007 mskibbe@suse.de
- ntp patch broken/md5 keys unusable (#253635)
* Thu Mar  8 2007 mskibbe@suse.de
- ntpq man page is corrupt (#251136)
- xntp (server) - Ports for SuSEfirewall added via packages
  (#251672)
* Mon Mar  5 2007 schwab@suse.de
- Fix broken patch.
* Tue Feb 27 2007 mskibbe@suse.de
- update to version 4.2.4 which
  o update html help pages
  o sntp now uses the returned precision to control decimal places
  o Fix a lot of bugs
* Thu Jan 25 2007 mskibbe@suse.de
- ntpd pid file problems (#230273)
* Wed Jan 10 2007 mskibbe@suse.de
- W32Time authentication support in NTP (fate #300767)
* Wed Nov  8 2006 mskibbe@suse.de
- update to version 4.2.2p4 which
  o fix some bugs
* Thu Nov  2 2006 mskibbe@suse.de
- fix bug #207079 - NTP setup to start on boot fails everytime
* Tue Oct 17 2006 mskibbe@suse.de
- change init script and sysconfig file - it's now possible to
  synchronize time only if the service restart. (see Bug #211031)
* Mon Oct  9 2006 mskibbe@suse.de
- update to version 4.2.2p3 which
  o use the new format of the "send" emails
  o Change mode to -rwxrwxr-x
  o Clean up the ChangeLog generation
* Thu Aug 31 2006 mskibbe@suse.de
- fix bug #169052 - xntp: typo in man page
- fix bug #200178 - NTP error message at startup
* Tue Jul 25 2006 mskibbe@suse.de
- update to version 4.2.2p2 which
  o cleanup
  o fix some bugs
  o Resolve the ambiguity in the copyright file
  o fix for bug #158199 (ntpdate -q reports 0 offset on IPv6)
* Thu Jun 29 2006 jblunck@suse.de
- NetworkManager script: use start instead of try-restart (#188613).
* Tue Apr 18 2006 rml@suse.de
- NetworkManager ntp script: s/restart-iburst/try-restart-iburst/
  as the former is not a valid command.  Fixes Novell bug #163139.
* Thu Feb  2 2006 rml@suse.de
- Add NetworkManagerDispatcher script 'ntp' to automatically
  restart ntp whenever the network connection cycles
* Thu Jan 26 2006 hvogel@suse.de
- Use cp -L in chroot setup to always follow symbolic links
  [145169]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Jan 13 2006 hvogel@suse.de
- Make use of Stack Protector
* Fri Dec  2 2005 hvogel@suse.de
- update to snapshot 20050816
- fix some warnings
- better group handling
- fix local clock submission
- add manpages from redhat
* Mon Nov 21 2005 hvogel@suse.de
- add function to update the cmos clock before starting ntpd
  [#132918]
- clean up sysconfig file
* Sat Nov 12 2005 schwab@suse.de
- Add libcap-devel to nfb [#132236].
* Tue Nov  8 2005 dmueller@suse.de
- fix upgrading of xntp (fallout of ntp group change)
* Mon Nov  7 2005 hvogel@suse.de
- quote NTP_PARSE_DEVICE also
* Wed Oct 12 2005 hvogel@suse.de
- Add -fno-strict-aliasing
- create ntp group and use it [#127548]
- implement /dev/refclock-0 link workaround [#116701]
* Sun Sep 18 2005 kukuk@suse.de
- Add libcap-devel to nfb
* Thu Sep 15 2005 hvogel@suse.de
- fix typo in the init script usage message
* Thu Sep  8 2005 hvogel@suse.de
- pass the runlevel to the chkconfig test in post because we
  are in no runlevel during yast update and that resulted in the
  test always being false (no xntpd in runlevel "unknown")
  This fixes [#100413] for real.
* Thu Aug 25 2005 hvogel@suse.de
- Add the possibility to copy more files to the chroot. Needed for
  instance to use autokeys [#104873]
* Fri Aug  5 2005 ro@suse.de
- more work for update case: rename fillup vars from XNTPD to NTPD
- fix fillup calls
* Wed Aug  3 2005 mmj@suse.de
- make sure an enabled xntpd is also enabled after update if it was
  enabled before [#100413]
- old package will %%stop_on_removal for old name
* Wed Jul 13 2005 hvogel@suse.de
- rename most config files, init scripts and the like from xntpd to
  ntp to be in sync with other vendors/LSB
- simplify specfile and document it a bit
- always enable ipv6
- enable sntp
- make ntp.conf not world readable anymore. it may contain sensitive
  information
- remove the scripts from the package. they mostly dont work
* Thu Jun 30 2005 uli@suse.de
- build with -fPIE (not -fpie) to avoid GOT overflow on s390x
* Fri Jun 17 2005 hvogel@suse.de
- update to version 4.2.0a-20050303
- Compile with -fpie/-pie
* Tue May 17 2005 hvogel@suse.de
- fix option syntax in init script (Bug #83980)
* Thu Apr 28 2005 hvogel@suse.de
- enable ssl encryption (#81064)
* Thu Apr  7 2005 mmj@suse.de
- fix array decls to make gcc4 happy
* Mon Mar 14 2005 hvogel@suse.de
- change "running from init or not" detection to use INIT_VERSION
  instead of links = base. (Bug #71230)
* Thu Feb 10 2005 hvogel@suse.de
- Use group argument so ntpd runs as nogroup. (50684)
- Apply patch for so ntpd can also use groupnames. (50684)
* Wed Jan 26 2005 hvogel@suse.de
- fix segfault while trying to use a IPV6 address without a IPV6
  stack. Ignore the address instead. (Bug #47860)
* Thu Dec  9 2004 hvogel@suse.de
- we need try-restart-iburst not restart-iburst
* Wed Dec  8 2004 hvogel@suse.de
- add restart-iburst option to the init script so we can restart
  xntp from ip-up to prevent ntpd from loosing sync when the
  ip of an interface changes. (Bug #48654)
- use try-restart from skeleton
- simplify optflags usage
* Tue Nov 30 2004 hvogel@suse.de
- fix typo in the init script
- fix force-reload to use try-restart
- add monlist patch
* Tue Oct  5 2004 lmuelle@suse.de
- Use sbindir as prefix of ntpq in the ntptrace script, [#46861].
* Fri Sep 10 2004 mmj@suse.de
- It's +2 years ago something happened that would need our attten-
  tion when updating. So remove [#44352]
* Fri Sep 10 2004 pth@suse.de
- Fix documentation for ntptrace (#36636)
* Thu Aug  5 2004 pth@suse.de
- Update to the 20040617 snapshot.
- Don't pass '-u' to ntpdate in the init script (bug #41140)
- Fix code to not break strict aliasing.
* Tue Mar 30 2004 pth@suse.de
- Don't create temporary files in /tmp during post installation.
  Fixes #37435.
* Mon Mar 29 2004 mls@suse.de
- fix slp registration
* Thu Mar 11 2004 adrian@suse.de
- register ntpd via slp.reg.d file
* Tue Mar  9 2004 pth@suse.de
- Make syslog create a socket in ntpd's chroot jail so that
  ntpd can continue logging.
- Make configure option --enable-linuxcaps visible on linux hosts.
- pass --enable-linuxcaps to configure to enable running chroot.
* Fri Mar  5 2004 pth@suse.de
- Update to ntp 4.2.0a-20040225 as this version has support
  for running ntpd inside a chroot jail.
- Have syslog create an additional socket in the chroot jail.
- Remove patches obsoleted by the update :)
* Thu Feb 19 2004 kukuk@suse.de
- Cleanup neededforbuild
* Sat Jan 10 2004 adrian@suse.de
- add %%defattr
* Tue Sep  9 2003 pthomas@suse.de
- Don't include files possibly created at runtime, not even as ghost.
- On real uninstall remove files copied to the chroot by initscript
  and the log file.
- Also fixes 'rpm -V' output (#29596)
* Thu Sep  4 2003 pthomas@suse.de
- Fix segfault in ntpd on startup when a device can't be opened.
- Shorten the changelog a bit.
* Fri Aug 29 2003 pthomas@suse.de
- Fix options to tail and sort in example scripts. (#29652)
* Fri Aug 29 2003 kukuk@suse.de
- Call useradd -r to create system account [Bug #29611]
* Fri Aug 22 2003 pthomas@suse.de
- Fix configure.in,acinclude.m4 and Makefile.am  so that autoreconf can be
  run.
- Fix all cases of type-punning.
- Add -lcap where necessary.
- Fix bug in ntp-4.1.1-noroot.patch that made ntpd ignore an existing drift
  file instead of actually reading it (fixes bugzilla #27464).
* Thu Aug 21 2003 lmuelle@suse.de
- Add stop_on_removal and restart_on_update macros to preun and postun section
- Add XNTPD_RUN_CHROOTED to sysconfig file and init script
- Modify init script to setup chroot environment if needed
- Autoconvert ntp.conf in case of an old driftfile location
* Tue Aug 19 2003 mmj@suse.de
- Add sysconfig metadata [#28963]
* Wed Jul  2 2003 ma@suse.de
- Updated manpage (new home of the ntp project is at www.ntp.org).
* Tue May 20 2003 ma@suse.de
- Fixed manpages.
* Wed May 14 2003 mmj@suse.de
- %%ghost /var/log/ntp
* Thu May  1 2003 ma@suse.de
- rcxntpd script didn't handle leading blanks in /etc/ntp.conf (#19847)
* Tue Feb  4 2003 ma@suse.de
- ntp-4.1.1.broadcastclient.diff replaced by ntp1.bk.patch/ntp2.bk.patch.
  A more secure soloution, which will most probabely go into ntp-4.1.2.
* Wed Jan 29 2003 kukuk@suse.de
- Add sysconfig meta data [Bug #22705]
* Wed Jan 15 2003 ro@suse.de
- moved logrotate config here
* Wed Jan 15 2003 ma@suse.de
- Added ntp-4.1.1.broadcastclient.diff to enable broadcastclient mode,
  unless AUTOKEY is defined (which is off by default). Due to broken
  interface code, broadcastclient together with AUTOKEY does not work
  on Linux. [#22253]
* Tue Dec 10 2002 ihno@suse.de
- Corrected patch ntp-4.1.1-noroot.patch.
  removed : after x for optionlist [#21826]
* Mon Nov 11 2002 ma@suse.de
- fixed typo in /etc/sysconfig/xntp comment. (#21688)
* Mon Sep  9 2002 mmj@suse.de
- ntp.drift is moved, adjust specfile completely, and move it to
  the new place from /etc in case of update. [#19113]
* Wed Aug 28 2002 nashif@suse.de
- Added insserv, fillup to PreReq
* Fri Aug  9 2002 okir@suse.de
- added patch to make xntpd drop root privileges and chroot
- added XNTPD_OPTIONS to sysconfig file and rc script;
  set XNTPD_OPTIONS="-U ntp" initially
- added /var/lib/ntp owned by user ntp, and moved ntp.drift
  there.
* Tue Jun 25 2002 ro@suse.de
- fix directory permissions
* Mon May 27 2002 ma@suse.de
- Fixed segfault in ntpdate if no server suitable for
  synchronization found (#15589)
* Fri Apr  5 2002 ma@suse.de
- Overworked documentation in doc/packages/xntp (#15052)
* Sun Mar 10 2002 ma@suse.de
- Update to ntp-4.1.1 / NTP-FAQ-3.4
- SuSE specific files formerly created by SuSE-Config.diff are now
  shipped via ntp-4.1.1.SuSE-Config.tar.gz.
- Removed parts of ntpdate_overflow.diff, that are now included in the
  official source.
- Added new argument 'ntptimeset' to rcxntpd. If no ntpd is running,
  'rcxntpd ntptimeset' evaluates XNTPD_INITIAL_NTPDATE from
  /etc/sysconfig/xntp, and tries to set time and date via ntpdate, the
  same way as it is done at 'rcxntpd start'. But no ntpd is started.
  This might be usefull if the machine isn't permanently connected to
  the internet. "AUTO" value in XNTPD_INITIAL_NTPDATE requires parsing
  /etc/ntpd.conf, so 'ntpadte $XNTPD_INITIAL_NTPDATE' after dialup
  might not work.
- Added manual page to package xntpd, telling that documentation is
  available in HTML only, and located in package xntp-doc. (#14338)
* Mon Feb 11 2002 ma@suse.de
- Evaluation of XNTPD_INITIAL_NTPDATE from /etc/sysconfig/xntp was
  changed. A space-separated list of ntp servers to query for current
  time and date before the local xntpd is started, is still supported.
  Furthermore you may now set XNTPD_INITIAL_NTPDATE="AUTO", to query
  ALL servers and peers configured in /etc/ntpd.conf.
  You may as well restrict the total number of servers to be queried
  at startup by setting XNTPD_INITIAL_NTPDATE="AUTO-{NUMBER}".
  The new default value for XNTPD_INITIAL_NTPDATE is "AUTO-2", which
  will query only the first two servers listed in /etc/ntpd.conf.
* Mon Jan  7 2002 ma@suse.de
- Fixed example scripts referencing nslookup in wrong path (#12667)
- Fillup template renamed to sysconfig.xntp. Let init script source
  /etc/sysconfig/xntp instead of /etc/rc.config. (#12748)
* Mon Dec 17 2001 ma@suse.de
- ntpdate_overflow.diff: Brute force patch to handle condition where
  systemtime is more than MAX_INT32 seconds in the past. Due to the
  limited range of an INT32, the computed offset is negative, although
  systemtime is in the past. In this situation the measured offset
  must be interpreted as UNSIGNED_INT32, and the systemtime has to be
  adjusted in two steps, as we can't step more than MAX_INT32 seconds
  at once.
  Need for this patch arises on newer macs, which reset the time to
  1904 after a hard crash or when the powerbook battery was off for
  a while.(#12620)
* Fri Dec 14 2001 ro@suse.de
- removed START_XNTPD
* Thu Dec 13 2001 ma@suse.de
- ntpdate_overflow.diff: ntpdate failed, if systemtime is a long way off.
  I.e. more than MAX_INT32 seconds (presently before Nov 1933) or closer
  to this limit than to the actual time. In both cases ntpdate tried to
  adjust the time to Nov 1933. This succeeded for systemtimes before
  Nov 1933 and failed if ntpdate tried to set the time back.
  The patch does not enable ntpdate to set the correct date, if the
  systemtime is before the limit, but ntpdate will report an error and
  fail, instead of setting the systemtime to Nov 1933. Any systemtime
  after this limit will be set correctly. (#12620)
* Fri Sep 21 2001 ma@suse.de
- NTP-FAQ in xntp-doc updated to NTP-FAQ-3.2.
* Wed Aug 22 2001 ma@suse.de
- Removed the glibc22.patch (sparc/s390 only). Better fix configure,
  than trying to patch config.h afterwards :(
* Wed Aug 22 2001 ma@suse.de
- Update to ntp-4.1.0
  The latest NTPv4 'ntpdc' does not work with previous versions of ntpd
  and previous versions of 'ntpdc' do not work with latest ntpd. This
  situation is regrettable and may be fixed in future; however, it is
  necessary in order for the autokey function to retrieve canonical
  names and certificates from directory services such as Secure DNS.
  The standard NTP query program 'ntpq' is not affected by this.
- Previously applied bugfix/security patches are obsolete.
- ntpdate called from /etc/init.d/xntpd now uses an unprivileged port
  for outgoing packets. Might be we have to synchronise with hosts beyond
  a firewall, that that blocks incoming traffic to privileged ports.
- /etc/init.d/xntpd is now LSB compliant (#9114)
- Subpackage xntpdoc was renamed to xntp-doc.
- NTP-FAQ in xntp-doc updated to NTP-FAQ-3.1.
* Thu Jun 14 2001 bk@suse.de
- remove lx_sus22 from neededforbuild, not on s390x and obsolete
* Tue Jun 12 2001 bk@suse.de
- enable sparc and alpha changes on s390x too
* Tue Apr 17 2001 kukuk@suse.de
- Remove extra version from sub-package
* Fri Apr  6 2001 uli@suse.de
- fixed to build
* Thu Apr  5 2001 draht@suse.de
- fix last change because the patch against ntpd/ntp_control.c that
  I supplied was wrong.
* Thu Apr  5 2001 ma@suse.de
- incorporated sparc patches (Tue Feb 13-kukuk@suse.de):
  Add some ugly hacks to work on SPARC
- incorporated alpha patches (Wed Feb 28-sf@suse.de):
  compiling with -O0 on Alpha
- added root-hole patch to fix possible exploit in ntpd/ntp_control.c
* Thu Jan  4 2001 pthomas@suse.de
- Add missing period to README.SuSE and clarify it a bit.
* Mon Dec  4 2000 ma@suse.de
- update to NTP-FAQ-2.5
* Tue Nov 28 2000 ro@suse.de
- startscript fixed
* Mon Jul 10 2000 ma@suse.de
- update to NTP-FAQ-2.1
* Tue Apr  4 2000 ro@suse.de
- added suse_update_config macro
* Wed Mar  8 2000 ma@suse.de
- update to NTP-FAQ-1.7
* Sun Feb 27 2000 ro@suse.de
- renamed subpackage xntp-doc to xntpdoc
* Fri Feb 25 2000 ma@suse.de
- update to 4.0.99f
- Html documentation and NTP-FAQ have been moved into a separate
  package: xntp-doc
* Mon Nov  8 1999 ma@suse.de
- update to 4.0.98d
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Sep  9 1999 bs@suse.de
- fixed call of Check at the end of %%install section
* Wed Jul 14 1999 bs@suse.de
- call Check
* Wed Jul 14 1999 ma@suse.de
- added some hints for radio clocks in ntp.conf
* Wed Jul  7 1999 ma@suse.de
- update to ntp-4.0.93a
- still need to work on some scripts
- ntptime was removed from package; currently not supported
  under Linux
* Wed Mar 31 1999 ma@suse.de
- update to ntp-4.0.92c
* Fri Mar 26 1999 ro@suse.de
- fixed spec-naming
* Wed Mar 24 1999 ma@suse.de
- update to 3.5.93e
- ntptime now builds on glibc
- Additional patch from Ulrich Windl for DCF77 receiver
* Thu Jan 14 1999 ma@suse.de
- All references to '/lobal/bin/perl' below
  scripts/ changed to '/usr/bin/perl'.
* Thu Dec 10 1998 ma@suse.de
- 2 new variables for rc.config:
    [#]
    [#] Usually it's a good idea to get the current time and date
    [#] from some other ntp server, before xntpd is started.
    [#] If we should do so, provide a space-separated list of
    [#] ntp servers to query.
    [#]
    XNTPD_INITIAL_NTPDATE=""
    [#]
    [#] This allows you to alter the kernel TICK variable.
    [#]
    [#] WARNING: YOU MUST NOT CHANGE THIS VARIABLE!
    [#]
    [#] Believe me, it won't help to solve any problem you have
    [#] if you set it. On the contrary, you will run into trouble!
    [#]
    [#] It's just here for those few, who know why they do not
    [#] believe me ;)
    [#]
    XNTPD_KERNEL_TICK=""
- updated rc-script
* Mon Dec  7 1998 ro@suse.de
- updated rc-script
- pack ntptime for libc5
* Tue Oct  6 1998 ro@suse.de
- ntptime does not get built on glibc
* Thu Sep 17 1998 ro@suse.de
- ntp_machine.h: GLIBC has sys/stropts.h but not sys/streams.h !
* Tue Jul 21 1998 ma@suse.de
- Win and NT documentation removed
* Fri Jun 26 1998 ma@suse.de
- update to 3.5.93c
- changed /sbin/init.d/xntp: reload/restart option.
- added symlink /usr/sbin/rcxntpd -> ../../sbin/init.d/xntpd
- changed /etc/ntp.conf: more comments+examples; default loging
  to /var/log/ntp
- specfile & build:
  - using 'BuildRoot: /tmp/xntp'
  - Makefile.Linux removed
  - using dir conf.SuSE in source tree for scripts provided
    by S.u.S.E. (default ntp.conf, init.d/xntpd, fillup-templates..)
  - added /etc/drift and /var/log/ntp as %%ghost
* Wed Jun 10 1998 ma@suse.de
- Makefile.Linux: configure option --enable-step-slew removed.
  step-slew quite often seems to prevent xntpd from adjusting
  the system time correctly.
* Tue Mar  3 1998 florian@suse.de
- update to 3-5.92
* Mon Nov 24 1997 ro@suse.de
- changed /local/bin/perl to /usr/bin/perl in scripts/monitoring
  and in scripts/support/bin/monl
* Wed Nov 19 1997 florian@suse.de
- move html-docu into subdirectory and add some support scripts
* Mon Oct 27 1997 florian@suse.de
- update to version 3-5.91
- change some HAVE_TERMIOS to HAVE_TERMIOS_H
* Wed Jun 25 1997 florian@suse.de
- update to version 3-5.90.2
* Sun Jun  1 1997 bs@suse.de
- moved fillup stuff to var/adm/fillup-templates
* Sun Feb  2 1997 florian@suse.de
- update to new version 3.5-89
- better config files
* Thu Jan  2 1997 florian@suse.de
- update to version 3-5.86.12.2
- slightly better config file
* Thu Jan  2 1997 florian@suse.de
- update to new version 3-5.86.9
- add RAWDCF support
* Thu Jan  2 1997 bs@suse.de
- fillup added
- /sbin/init.d start-scripts
