#
# spec file for package rsyslog
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir /var/adm/fillup-templates
%endif

%define mark_daemon_restart %if 0%{?suse_version} > 1550 \
				/usr/lib/systemd/systemd-update-helper mark-restart-system-units rsyslog.service ||: \
			%else \
				/usr/bin/systemctl set-property "rsyslog.service" Markers=+needs-restart ||: \
			%endif

%define requires_file() %( readlink -f '%*' | LC_ALL=C xargs -r rpm -q --qf 'Requires: %%{name} >= %%{epoch}:%%{version}\\n' -f | sed -e 's/ (none):/ /' -e 's/ 0:/ /' | grep -v "is not")

Name:           rsyslog
Summary:        The enhanced syslogd for Linux and Unix
License:        Apache-2.0 AND GPL-3.0-or-later
Group:          System/Daemons
Version:        8.2406.0
Release:        150600.12.8.1
%bcond_without  udpspoof
%bcond_without  dbi
%bcond_without  pkgconfig
%if 0%{?suse_version} > 1230
%bcond_without  journal
%else
%bcond_with     journal
%endif
%bcond_without  gssapi
%bcond_without  gnutls
%bcond_without  openssl
%bcond_without  gcrypt
%bcond_without  mysql
%bcond_without  pgsql
%bcond_without  relp
%bcond_without  rfc3195
%bcond_without  snmp
%bcond_without  diagtools
%bcond_without  mmnormalize
%bcond_without  elasticsearch
%bcond_without  omhttpfs
%bcond_without  omamqp1
%bcond_without  tcl
%bcond_without  kafka
# https://github.com/rsyslog/rsyslog/issues/1355
%bcond_with	maxminddb
# contributed modules not built for various reasons
# --enable-mmgrok - grok not in factory
# TODO: ... doesnt have a proper configure check but wants hdfs.h
%bcond_with     hdfs
%bcond_with     mongodb
%bcond_with     hiredis
%bcond_with     zeromq

%define         rsyslogdocdir               %{_docdir}/%{name}
%if %{defined _rundir}
%define         rsyslog_rundir              %{_rundir}/rsyslog
%else
%define         rsyslog_rundir              %{_localstatedir}/run/rsyslog
%endif
%define         rsyslog_sockets_cfg         %{rsyslog_rundir}/additional-log-sockets.conf
%define         rsyslog_module_dir_nodeps   %{_libdir}/rsyslog/
%define         rsyslog_module_dir_withdeps %{_libdir}/rsyslog/
URL:            http://www.rsyslog.com/
# Upstream library deprecated and we want to support migration
Obsoletes:      %{name}-module-guardtime <= 8.38.0
Provides:       syslog
Provides:       sysvinit(syslog)
Conflicts:      otherproviders(syslog)
Requires(pre):  %fillup_prereq
Requires(pre):  syslog-service >= 2.0
%{?systemd_ordering}
BuildRequires:  pkgconfig(systemd) >= 209
%if %{with journal}
BuildRequires:  pkgconfig(libsystemd) >= 234
%endif
# for patch1
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
#
BuildRequires:  bison
BuildRequires:  curl-devel
BuildRequires:  flex
BuildRequires:  pcre-devel
BuildRequires:  pkgconfig
BuildRequires:  zlib-devel
%if %{with rfc3195}
%if %{with pkgconfig}
BuildRequires:  pkgconfig(liblogging-rfc3195) >= 1.0.1
%else
BuildRequires:  liblogging-devel
%endif
%endif
%if %{with pkgconfig}
BuildRequires:  pkgconfig(liblogging-stdlog) >= 1.0.1
%else
BuildRequires:  liblogging-devel
%endif
%if %{with omhttpfs}
BuildRequires:  curl-devel >= 7.0.0
%endif
%if %{with omamqp1}
%if %{with pkgconfig}
BuildRequires:  pkgconfig(libqpid-proton) >= 0.9
%else
BuildRequires:  qpid-proton-devel >= 0.9
%endif
%endif
%if %{with hiredis}
BuildRequires:  hiredis-devel >= 0.10.1
%endif
%if %{with mongodb}
# TODO: PKG_CHECK_MODULES(LIBMONGO_CLIENT, libmongo-client >= 0.1.4)
%endif
%if %{with zeromq}
BuildRequires:  czmq-devel >= 3.0.2
%endif
%if %{with kafka}
BuildRequires:  librdkafka-devel
Requires:       librdkafka1
%endif
%if %{with gssapi}
BuildRequires:  krb5-devel
%endif
%if %{with gnutls}
BuildRequires:  libgnutls-devel
%endif
%if %{with openssl}
BuildRequires:  pkgconfig(openssl)
%endif
%if %{with gcrypt}
BuildRequires:  libgcrypt-devel
%endif
%if %{with dbi}
BuildRequires:  libdbi-devel
%endif
%if %{with mysql}
BuildRequires:  mysql-devel
%endif
%if %{with snmp}
BuildRequires:  net-snmp-devel
%endif
%if %{with pgsql}
BuildRequires:  postgresql-devel
%endif
%if %{with relp}
# RELP support
%if %{with pkgconfig}
BuildRequires:  pkgconfig(relp) >= 1.2.14
%else
BuildRequires:  librelp-devel >= 1.2.14
%endif
%endif
%if %{with udpspoof}
# UDP spoof support
BuildRequires:  libnet-devel
%endif
%if %{with mmnormalize}
# mmnormalize support
%if %{with pkgconfig}
BuildRequires:  pkgconfig(lognorm) >= 2.0.3
%else
BuildRequires:  liblognorm-devel >= 2.0.3
%endif
%endif
%if %{with maxminddb}
BuildRequires:  pkgconfig(libmaxminddb)
%endif
#
# mmjsonparse needs liblognorm,
# but json check is unconditional
%if %{with pkgconfig}
BuildRequires:  pkgconfig(libestr) >= 0.1.9
BuildRequires:  pkgconfig(libfastjson) >= 0.99.8
BuildRequires:  pkgconfig(uuid) >= 2.21.0
%else
BuildRequires:  libestr-devel
BuildRequires:  libfastjson-devel >= 0.99.7
BuildRequires:  libuuid-devel
%endif
%if %{with tcl}
%if %{with pkgconfig}
BuildRequires:  pkgconfig(tcl)
%else
BuildRequires:  tcl-devel
%endif
%endif
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Source0:        https://www.rsyslog.com/files/download/%{name}/%{name}-%{version}.tar.gz
Source1:        rsyslog.sysconfig
Source2:        rsyslog.conf.in
Source3:        rsyslog.service
Source4:        rsyslog.d.remote.conf.in
Source5:        rsyslog-service-prepare.in
Source6:        usr.sbin.rsyslogd
Source7:        module-mysql
Source8:        module-snmp
Source9:        module-udpspoof
Source14:       https://www.rsyslog.com/files/download/rsyslog/rsyslog-doc-%{version}.tar.gz
Source16:       journald-rsyslog.conf
Source17:       acpid.frule
Source18:       firewall.frule
Source19:       NetworkManager.frule

# this is a dirty hack since % dir does only work for the specified directory and nothing above
# but I want to be able to switch this to /etc/apparmor.d once the profiles received more testing
%define APPARMOR_PROFILE_PATH /usr/share/apparmor/extra-profiles
%define APPARMOR_PROFILE_PATH_DIR_COMMANDS %dir /usr/share/apparmor \
                                           %dir /usr/share/apparmor/extra-profiles \
                                           %dir /usr/share/apparmor/extra-profiles/rsyslog.d

%description
Rsyslog is an enhanced multi-threaded syslogd supporting, among others,
MySQL, syslog/tcp, RFC 3195, permitted sender lists, filtering on any
message part, and fine grain output format control. It is quite
compatible to stock sysklogd and can be used as a drop-in replacement.
Its advanced features make it suitable for enterprise-class, encryption
protected syslog relay chains while at the same time being very easy to
setup for the novice user.

%package doc
Summary:        Additional documentation for rsyslog
Group:          System/Daemons

%description doc
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This package provides additional documentation for rsyslog.

%if %{with diagtools}

%package diag-tools
Requires:       %{name} = %{version}
Summary:        Diagnostic tools
Group:          System/Daemons

%description diag-tools
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This package provides additional diagnostic tools (small helpers,
usually not needed).

%endif

%if %{with gssapi}

%package module-gssapi
Requires:       %{name} = %{version}
Summary:        GSS-API support module for rsyslog
Group:          System/Daemons

%description module-gssapi
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides the support to receive syslog messages from the
network protected via Kerberos 5 encryption and authentication.

%endif

%if %{with mysql}

%package module-mysql
Requires:       %{name} = %{version}
Summary:        MySQL support module for rsyslog
Group:          System/Daemons

%description module-mysql
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This package provides a module with the support for logging into MySQL
databases.

%endif

%if %{with pgsql}

%package module-pgsql
Requires:       %{name} = %{version}
Summary:        PostgreSQL support module for rsyslog
Group:          System/Daemons

%description module-pgsql
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides the support for logging into PostgreSQL databases.

%endif

%if %{with dbi}

%package module-dbi
Requires:       %{name} = %{version}
Summary:        Database support via DBI
Group:          System/Daemons

%description module-dbi
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This package provides a module with the support for logging into DBI
supported databases.

%endif

%if %{with snmp}

%package module-snmp
Requires:       %{name} = %{version}
Summary:        SNMP support module for rsyslog
Group:          System/Daemons

%description module-snmp
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides the ability to send syslog messages as an SNMPv1 &
v2c traps.

%endif

%if %{with gnutls}

%package module-gtls
Requires:       %{name} = %{version}
Summary:        TLS encryption support module for rsyslog
Group:          System/Daemons

%description module-gtls
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides the ability for TLS encrypted TCP logging using
the GnuTLS library.
%endif

%if %{with openssl}

%package module-ossl
Requires:       %{name} = %{version}
Summary:        TLS encryption support module for rsyslog
Group:          System/Daemons

%description module-ossl
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides the ability for TLS encrypted TCP logging using
the OpenSSL library.
%endif

%if %{with gcrypt}

%package module-gcrypt
Requires:       %{name} = %{version}
Summary:        Libgcrypt log file encryption support module for rsyslog
Group:          System/Daemons

%description module-gcrypt
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides log file encryption support using libgcrypt and
a rsgtutil utility to manage the files.
%endif

%if %{with relp}

%package module-relp
Requires:       %{name} = %{version}
Summary:        RELP protocol support module for syslog
Group:          System/Daemons

%requires_file %{_libdir}/librelp.so

%description module-relp
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides Reliable Event Logging Protocol support.

%endif

%if %{with mmnormalize}

%package module-mmnormalize
Requires:       %{name} = %{version}
Summary:        Contains the mmnormalize support module for syslog
Group:          System/Daemons

%description module-mmnormalize
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides log normalizing support.

%endif

%if %{with udpspoof}

%package module-udpspoof
Requires:       %{name} = %{version}
Summary:        UDP spoof support module for syslog
Group:          System/Daemons

%description module-udpspoof
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides a UDP forwarder that allows changing the sender address.

%endif

%if %{with elasticsearch}

%package module-elasticsearch
Requires:       %{name} = %{version}
Summary:        ElasticSearch output module for syslog
Group:          System/Daemons

%description module-elasticsearch
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support to output to an ElasticSearch database.

%endif

%if %{with omhttpfs}

%package module-omhttpfs
Requires:       %{name} = %{version}
Summary:        HDFS via HTTP output module for syslog
Group:          System/Daemons

%description module-omhttpfs
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support to output to HDFS via HTTP.

%endif

%if %{with hdfs}

%package module-hdfs
Requires:       %{name} = %{version}
Summary:        HDFS output module for syslog
Group:          System/Daemons

%description module-hdfs
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support to output to an HDFS database.

%endif

%if %{with mongodb}

%package module-mongodb
Requires:       %{name} = %{version}
Summary:        MongoDB output module for syslog
Group:          System/Daemons

%description module-mongodb
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support to output to a MongoDB database.

%endif

%if %{with hiredis}

%package module-hiredis
Requires:       %{name} = %{version}
Summary:        Redis output module for syslog
Group:          System/Daemons

%description module-hiredis
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support to output to a Redis database.

%endif

%if %{with zeromq}

%package module-zeromq
Requires:       %{name} = %{version}
Summary:        ZeroMQ support module for syslog
Group:          System/Daemons

%description module-zeromq
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support for ZeroMQ.

%endif

%if %{with kafka}

%package module-kafka
Requires:       %{name} = %{version}
Summary:        Kafka support module for syslog
Group:          System/Daemons

%description module-kafka
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support for Kafka.

%endif

%if %{with omamqp1}
%package module-omamqp1
Requires:       %{name} = %{version}
Summary:        AMQP support module for syslog
Group:          System/Daemons

%description module-omamqp1
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides support for AMQP.
%endif

%if %{with tcl}
%package module-omtcl
Requires:       %{name} = %{version}
Summary:        TCL output module for rsyslog
Group:          System/Daemons

%description module-omtcl
Rsyslog is an enhanced multi-threaded syslog daemon. See rsyslog
package.

This module provides an output module for TCL.
%endif

%prep
%setup -q -a 14

%autopatch -p1

#
for file in rsyslog-service-prepare; do
	sed \
	-e 's;RUN_DIR;%{rsyslog_rundir};g' \
	-e 's;ADDITIONAL_SOCKETS;%{rsyslog_sockets_cfg};g' \
	"%{_sourcedir}/${file}.in" > "${file}"
done

%build
export CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing -W -Wall -I../grammar -I../../grammar"
# needs java
#        --enable-gui            \

# for patch1
autoreconf -fiv

%configure			\
	--with-moddirs=%{rsyslog_module_dir_withdeps} \
	--enable-option-checking	\
	--enable-largefile	\
	--enable-regexp		\
	--enable-klog		\
	--enable-kmsg		\
	--enable-inet		\
	--enable-unlimited-select	\
	--enable-rsyslogd	\
	--enable-liblogging-stdlog	\
%if %{with elasticsearch}
	--enable-elasticsearch	\
%endif
%if %{with kafka}
	--enable-imkafka		\
	--enable-omkafka		\
%endif
%if %{with omhttpfs}
	--enable-omhttpfs	\
%endif
%if %{with gnutls}
	--enable-gnutls		\
%endif
%if %{with openssl}
	--enable-openssl	\
%endif
%if %{with gssapi}
	--enable-gssapi-krb5	\
%endif
%if %{with dbi}
	--enable-libdbi		\
%endif
%if %{with mysql}
	--enable-mysql		\
%endif
%if %{with pgsql}
	--enable-pgsql		\
%endif
%if %{with relp}
	--enable-relp		\
%endif
%if %{with rfc3195}
        --enable-rfc3195        \
%endif
%if %{with snmp}
	--enable-snmp		\
	--enable-mmsnmptrapd	\
%endif
	--enable-mail		\
	--enable-imfile		\
	--enable-imptcp		\
	--enable-impstats	\
	--enable-omprog		\
	--enable-omuxsock	\
%if %{with udpspoof}
	--enable-omudpspoof	\
%endif
	--enable-omstdout	\
	--enable-pmlastmsg	\
	--enable-pmcisconames	\
	--enable-pmaixforwardedfrom	\
	--enable-pmsnare	\
	--enable-pmnull		\
	--enable-pmnormalize	\
	--enable-omruleset	\
	--enable-omhttp		\
%if %{with mmnormalize}
	--enable-mmnormalize \
	--enable-mmjsonparse	\
	--enable-mmaudit	\
%endif
%if %{with hdfs}
	--enable-omhdfs		\
%endif
%if %{with mongodb}
	--enable-ommongodb	\
%endif
%if %{with omamqp1}
	--enable-omamqp1	\
%endif
%if %{with hiredis}
	--enable-omhiredis	\
%endif
%if %{with zeromq}
	--enable-imzmq3		\
	--enable-omzmq3		\
%endif
%if %{with diagtools}
	--enable-imdiag		\
	--enable-diagtools	\
%endif
%if %{with journal}
	--enable-imjournal	\
	--enable-omjournal	\
%endif
	--enable-mmanon		\
	--enable-mmaudit	\
	--enable-mmkubernetes 	\
	--enable-mmjsonparse	\
	--enable-mmutf8fix	\
	--enable-mmcount	\
	--enable-mmsequence	\
	--enable-mmfields	\
	--enable-mmpstrucdata	\
	--enable-mmrfc5424addhmac \
	--enable-mmrm1stspace	\
	--enable-pmciscoios \
	--enable-pmpanngfw	\
%if %{with gcrypt}
	--enable-libgcrypt	\
%else
	--disable-libgcrypt	\
%endif
%if %{with tcl}
	--enable-omtcl		\
%endif
%if %{with maxminddb}
	--enable-mmdblookup	\
%endif
	--enable-usertools	\
	--disable-static

make %{?_smp_mflags:%{_smp_mflags}} V=1

%install
make install DESTDIR="%{buildroot}"  V=1
#
rm -f %{buildroot}%{rsyslog_module_dir_nodeps}/*.la
#
# move all modules linking libraries in /usr to /usr/lib[64]
# the user has to specify them with full path then...
install -d -m0755 %{buildroot}%{rsyslog_module_dir_withdeps}
if test "%{rsyslog_module_dir_nodeps}" != "%{rsyslog_module_dir_withdeps}" ; then
	for mod in  \
%if %{with gnutls}
		lmnsd_gtls.so \
%endif
%if %{with openssl}
		lmnsd_ossl.so \
%endif
%if %{with gcrypt}
		lmcry_gcry.so \
%endif
%if %{with gssapi}
		omgssapi.so imgssapi.so lmgssutil.so \
%endif
%if %{with dbi}
		omlibdbi.so \
%endif
%if %{with mysql}
		ommysql.so \
%endif
%if %{with pgsql}
		ompgsql.so \
%endif
%if %{with relp}
		imrelp.so omrelp.so \
%endif
%if %{with snmp}
		omsnmp.so \
%endif
%if %{with mmnormalize}
		mmnormalize.so  \
		mmjsonparse.so \
		mmaudit.so \
%endif
%if %{with elasticsearch}
		omelasticsearch.so \
%endif
%if %{with omhttpfs}
		omhttpfs.so \
%endif
%if %{with kafka}
		imkafka.so \
		omkafka.so \
%endif
	; do
		mv -f %{buildroot}%{rsyslog_module_dir_nodeps}/$mod \
		      %{buildroot}%{rsyslog_module_dir_withdeps}
	done
fi
%if !0%{?usrmerged}
	install -d -m0755 %{buildroot}/sbin
	ln -sf %{_sbindir}/rsyslogd $RPM_BUILD_ROOT/sbin/rsyslogd
%endif
# it is simply broken (bnc#890228)
rm -f $RPM_BUILD_ROOT%{_sbindir}/zpipe
#
install -m755 rsyslog-service-prepare %{buildroot}%{_sbindir}/
ln -svf service %buildroot/%{_sbindir}/rc%{name}
#
install -d -m0755 %{buildroot}%{_sysconfdir}/rsyslog.d
install -d -m0755 %{buildroot}%{_localstatedir}/run/rsyslog
install -d -m0755 %{buildroot}%{_localstatedir}/spool/rsyslog
for file in rsyslog.conf rsyslog.d.remote.conf ; do
	sed \
%ifarch s390 s390x
	-e 's;tty10;console;g' \
%endif
	-e 's;ADDITIONAL_SOCKETS;%{rsyslog_sockets_cfg};g' \
	-e 's;ETC_RSYSLOG_CONF;%{_sysconfdir}/rsyslog.conf;g' \
	-e 's;ETC_RSYSLOG_D_DIR;%{_sysconfdir}/rsyslog.d;g' \
	-e 's;ETC_RSYSLOG_D_GLOB;%{_sysconfdir}/rsyslog.d/*.conf;g' \
	-e 's;RSYSLOG_SPOOL_DIR;%{_localstatedir}/spool/rsyslog;g' \
	%{_sourcedir}/${file}.in > ${file}.$$
done
install    -m0600 rsyslog.conf.$$ \
                  %{buildroot}%{_sysconfdir}/rsyslog.conf
install    -m0600 rsyslog.d.remote.conf.$$ \
                  %{buildroot}%{_sysconfdir}/rsyslog.d/remote.conf
#
install -d -m0755 %{buildroot}%{_fillupdir}
install    -m0600 %{_sourcedir}/rsyslog.sysconfig \
                  %{buildroot}%{_fillupdir}/sysconfig.syslog-rsyslog
#
rm -f doc/Makefile*
install -d -m0755 %{buildroot}%{rsyslogdocdir}/html/
find ChangeLog README AUTHORS \
	\( -type d -exec install -m755 -d   %{buildroot}%{rsyslogdocdir}/\{\} \; \) \
     -o \( -type f -exec install -m644 \{\} %{buildroot}%{rsyslogdocdir}/\{\} \; \)
cp -av build/* %{buildroot}%{rsyslogdocdir}/html/
#
%if %{with mysql}
install -m644 plugins/ommysql/createDB.sql \
	%{buildroot}%{rsyslogdocdir}/mysql-createDB.sql
%endif
%if %{with pgsql}
install -m644 plugins/ompgsql/createDB.sql \
	%{buildroot}%{rsyslogdocdir}/pgsql-createDB.sql
%endif
install -d -m0755 %{buildroot}%{_unitdir}
install -m644 %{SOURCE3} %{buildroot}%{_unitdir}/
install -d -m0755 %{buildroot}%{_prefix}/lib/systemd/journald.conf.d
install -m644 %{SOURCE16} %{buildroot}%{_prefix}/lib/systemd/journald.conf.d/30-rsyslog.conf
# create ghosts
install -d -m0755 %{buildroot}%{rsyslog_rundir}
touch %{buildroot}%{rsyslog_sockets_cfg}
chmod 644 %{buildroot}%{rsyslog_sockets_cfg}
mkdir -p %{buildroot}%{APPARMOR_PROFILE_PATH}/rsyslog.d/
install -m0640 %{SOURCE6} %{buildroot}%{APPARMOR_PROFILE_PATH}/
install -m0600 %{SOURCE17} %{buildroot}%{_sysconfdir}/rsyslog.d/
install -m0600 %{SOURCE18} %{buildroot}%{_sysconfdir}/rsyslog.d/
install -m0600 %{SOURCE19} %{buildroot}%{_sysconfdir}/rsyslog.d/

%if %{with mysql}
  install -m0640 %{SOURCE7} %{buildroot}%{APPARMOR_PROFILE_PATH}/rsyslog.d/
%endif
%if %{with snmp}
  install -m0640 %{SOURCE8} %{buildroot}%{APPARMOR_PROFILE_PATH}/rsyslog.d/
%endif
%if %{with udpspoof}
  install -m0640 %{SOURCE9} %{buildroot}%{APPARMOR_PROFILE_PATH}/rsyslog.d/
%endif

%clean
if [ -n "%{buildroot}" ] && [ "%{buildroot}" != "/" ] ; then
	rm -rf "%{buildroot}"
fi

%pre
%{service_add_pre rsyslog.service}

%post
#
# update linker caches
#
/sbin/ldconfig
#
# remove obsolete variables
#
%{remove_and_set -n syslog SYSLOG_DAEMON SYSLOG_REQUIRES_NETWORK}
%{remove_and_set -n syslog RSYSLOGD_COMPAT_VERSION RSYSLOGD_NATIVE_VERSION}
#
# add RSYSLOGD_* variables
#
%{fillup_only -ns syslog rsyslog}
#
# Do not use multiple facilities with the same priority pattern.
# It causes start failure since rsyslog-6.4.x (bnc#780607).
#
# FIXME: it seems to be a valid syntax -> rsyslog bug?
#
if grep -qs '^local[0246],' etc/rsyslog.conf ; then
   sed -i -e 's/^local\([0246]\),/local\1.*;/g' etc/rsyslog.conf
fi
#
# create dirs, touch log default files
#
if [ "$1" = "1" ] ; then  # first install
mkdir -p var/log
touch var/log/messages;  chmod 640 var/log/messages
touch var/log/mail;      chmod 640 var/log/mail
touch var/log/mail.info; chmod 640 var/log/mail.info
touch var/log/mail.warn; chmod 640 var/log/mail.warn
touch var/log/mail.err;  chmod 640 var/log/mail.err
#
# touch the additional log files we are using
#
touch var/log/acpid;            chmod 640 var/log/acpid
touch var/log/firewall;         chmod 640 var/log/firewall
touch var/log/NetworkManager;   chmod 640 var/log/NetworkManager
#
# touch the additional log sockets config file
#
mkdir -p -m750 ".%{rsyslog_rundir}"
touch ".%{rsyslog_sockets_cfg}"
chmod 640 ".%{rsyslog_sockets_cfg}"
fi # first install
#
# Enable the rsyslogservice to be started by systemd
#
# This macro enables based on a systemctl preset config file only
%{service_add_post rsyslog.service}
# But we want to enable a syslog-daemon regardless of the preset;
# force the creation of a syslog.service alias link (bnc#790805).
# We do not check the obsolete SYSLOG_DAEMON variable as we want
# to switch when installing it and there is a provider conflict.
/usr/bin/systemctl -f enable rsyslog.service >/dev/null 2>&1 || :

#restart daemon at the end of the transaction
%mark_daemon_restart

%if %{with gssapi}

%post module-gssapi
%mark_daemon_restart
%endif

%if %{with mysql}

%post module-mysql
%mark_daemon_restart
%endif

%if %{with pgsql}

%post module-pgsql
%mark_daemon_restart
%endif

%if %{with dbi}

%post module-dbi
%mark_daemon_restart
%endif

%if %{with snmp}

%post module-snmp
%mark_daemon_restart
%endif

%if %{with gnutls}

%post module-gtls
%mark_daemon_restart
%endif

%if %{with openssl}

%post module-ossl
%mark_daemon_restart
%endif

%if %{with relp}

%post module-relp
%mark_daemon_restart
%endif

%if %{with mmnormalize}

%post module-mmnormalize
%mark_daemon_restart
%endif

%if %{with udpspoof}

%post module-udpspoof
%mark_daemon_restart
%endif

%if %{with elasticsearch}

%post module-elasticsearch
%mark_daemon_restart
%endif

%if %{with omhttpfs}

%post module-omhttpfs
%mark_daemon_restart
%endif

%if %{with hdfs}

%post module-hdfs
%mark_daemon_restart
%endif

%if %{with mongodb}

%post module-mongodb
%mark_daemon_restart
%endif

%if %{with hiredis}

%post module-hiredis
%mark_daemon_restart
%endif

%if %{with zeromq}

%post module-zeromq
%mark_daemon_restart
%endif

%if %{with kafka}

%post module-kafka
%mark_daemon_restart
%endif

%if %{with omamqp1}

%post module-omamqp1
%mark_daemon_restart
%endif

%if %{with gcrypt}

%post module-gcrypt
%mark_daemon_restart
%endif

%if %{with tcl}

%post module-omtcl
%mark_daemon_restart
%endif

%posttrans
/usr/bin/systemctl --marked reload-or-restart ||:

%preun
#
# stop the rsyslogd daemon when it is running
#
%{service_del_preun syslog.socket}
%{service_del_preun rsyslog.service}

%postun
#
# update linker caches
#
/sbin/ldconfig

%files
%defattr(-,root,root)
%dir %{_sysconfdir}/rsyslog.d
%config(noreplace) %attr(600,root,root) %{_sysconfdir}/rsyslog.conf
%config(noreplace) %attr(600,root,root) %{_sysconfdir}/rsyslog.d/remote.conf
%config(noreplace) %attr(600,root,root) %{_sysconfdir}/rsyslog.d/*.frule
%{_sbindir}/rsyslogd
%if !0%{?usrmerged}
/sbin/rsyslogd
%endif
%dir %{rsyslog_module_dir_nodeps}
%{rsyslog_module_dir_nodeps}/fmhash.so
%{rsyslog_module_dir_nodeps}/fmhttp.so
%{rsyslog_module_dir_nodeps}/imfile.so
%{rsyslog_module_dir_nodeps}/imklog.so
%{rsyslog_module_dir_nodeps}/imkmsg.so
%{rsyslog_module_dir_nodeps}/immark.so
%{rsyslog_module_dir_nodeps}/impstats.so
%{rsyslog_module_dir_nodeps}/imtcp.so
%{rsyslog_module_dir_nodeps}/imudp.so
%{rsyslog_module_dir_nodeps}/imuxsock.so
%{rsyslog_module_dir_nodeps}/lmnet.so
%{rsyslog_module_dir_nodeps}/lmnetstrms.so
%{rsyslog_module_dir_nodeps}/lmnsd_ptcp.so
%{rsyslog_module_dir_nodeps}/imptcp.so
%{rsyslog_module_dir_nodeps}/lmregexp.so
%{rsyslog_module_dir_nodeps}/lmtcpclt.so
%{rsyslog_module_dir_nodeps}/lmtcpsrv.so
%{rsyslog_module_dir_nodeps}/lmzlibw.so
%{rsyslog_module_dir_nodeps}/mmanon.so
%{rsyslog_module_dir_nodeps}/mmcount.so
%{rsyslog_module_dir_nodeps}/mmexternal.so
%{rsyslog_module_dir_nodeps}/mmfields.so
%{rsyslog_module_dir_nodeps}/mmkubernetes.so
%{rsyslog_module_dir_nodeps}/mmpstrucdata.so
%{rsyslog_module_dir_nodeps}/mmrfc5424addhmac.so
%{rsyslog_module_dir_nodeps}/mmsequence.so
%{rsyslog_module_dir_nodeps}/mmutf8fix.so
%{rsyslog_module_dir_nodeps}/mmrm1stspace.so
%{rsyslog_module_dir_nodeps}/ommail.so
%{rsyslog_module_dir_nodeps}/omhttp.so
%{rsyslog_module_dir_nodeps}/omprog.so
%{rsyslog_module_dir_nodeps}/omruleset.so
%{rsyslog_module_dir_nodeps}/omstdout.so
%{rsyslog_module_dir_nodeps}/omtesting.so
%{rsyslog_module_dir_nodeps}/omuxsock.so
%{rsyslog_module_dir_nodeps}/pmlastmsg.so
%{rsyslog_module_dir_nodeps}/pmaixforwardedfrom.so
%{rsyslog_module_dir_nodeps}/pmcisconames.so
%{rsyslog_module_dir_nodeps}/pmciscoios.so
%{rsyslog_module_dir_nodeps}/pmsnare.so
%{rsyslog_module_dir_nodeps}/pmnull.so
%{rsyslog_module_dir_nodeps}/pmnormalize.so
%{rsyslog_module_dir_nodeps}/pmpanngfw.so
%if %{with rfc3195}
%{rsyslog_module_dir_nodeps}/im3195.so
%endif
%if %{with journal}
%{rsyslog_module_dir_nodeps}/imjournal.so
%{rsyslog_module_dir_nodeps}/omjournal.so
%dir %{_prefix}/lib/systemd/journald.conf.d/
%{_prefix}/lib/systemd/journald.conf.d/30-rsyslog.conf
%endif
%dir %{rsyslog_module_dir_withdeps}
%{_mandir}/man5/rsyslog.conf.5*
%{_mandir}/man8/rsyslogd.8*
%license COPYING COPYING.ASL20 COPYING.LESSER
%dir %{rsyslogdocdir}
%doc %{rsyslogdocdir}/ChangeLog
%doc %{rsyslogdocdir}/README
%doc %{rsyslogdocdir}/AUTHORS
%dir %{_localstatedir}/spool/rsyslog
%{_fillupdir}/sysconfig.syslog-rsyslog
%attr(0755,root,root) %dir %ghost %{rsyslog_rundir}
%attr(0644,root,root) %ghost %{rsyslog_sockets_cfg}
%{_sbindir}/rsyslog-service-prepare
%{_unitdir}/rsyslog.service
%{_sbindir}/rc%{name}
%{APPARMOR_PROFILE_PATH_DIR_COMMANDS}
%config %{APPARMOR_PROFILE_PATH}/usr.sbin.rsyslogd

%files doc
%defattr(-,root,root)
%dir %{rsyslogdocdir}/
%doc %{rsyslogdocdir}/html/

%if %{with diagtools}

%files diag-tools
%defattr(-,root,root)
%{_sbindir}/msggen
%{_sbindir}/rsyslog_diag_hostname
%{rsyslog_module_dir_nodeps}/imdiag.so
%endif

%if %{with gssapi}

%files module-gssapi
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omgssapi.so
%{rsyslog_module_dir_withdeps}/imgssapi.so
%{rsyslog_module_dir_withdeps}/lmgssutil.so
%endif

%if %{with mysql}

%files module-mysql
%defattr(-,root,root)
%doc %{rsyslogdocdir}/mysql-createDB.sql
%{rsyslog_module_dir_withdeps}/ommysql.so
%config %{APPARMOR_PROFILE_PATH}/rsyslog.d/module-mysql
%endif

%if %{with pgsql}

%files module-pgsql
%defattr(-,root,root)
%doc %{rsyslogdocdir}/pgsql-createDB.sql
%{rsyslog_module_dir_withdeps}/ompgsql.so
%endif

%if %{with dbi}

%files module-dbi
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omlibdbi.so
%endif

%if %{with snmp}

%files module-snmp
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omsnmp.so
%{rsyslog_module_dir_nodeps}/mmsnmptrapd.so
%config %{APPARMOR_PROFILE_PATH}/rsyslog.d/module-snmp
%endif

%if %{with gnutls}

%files module-gtls
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/lmnsd_gtls.so
%endif

%if %{with openssl}

%files module-ossl
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/lmnsd_ossl.so
%endif

%if %{with relp}

%files module-relp
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/imrelp.so
%{rsyslog_module_dir_withdeps}/omrelp.so
%endif

%if %{with mmnormalize}

%files module-mmnormalize
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/mmnormalize.so
%{rsyslog_module_dir_withdeps}/mmjsonparse.so
%{rsyslog_module_dir_withdeps}/mmaudit.so
%endif

%if %{with udpspoof}

%files module-udpspoof
%defattr(-,root,root)
%{rsyslog_module_dir_nodeps}/omudpspoof.so
%config %{APPARMOR_PROFILE_PATH}/rsyslog.d/module-udpspoof
%endif

%if %{with elasticsearch}

%files module-elasticsearch
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omelasticsearch.so
%endif

%if %{with omhttpfs}

%files module-omhttpfs
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omhttpfs.so
%endif

%if %{with hdfs}

%files module-hdfs
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omhdfs.so
%endif

%if %{with mongodb}

%files module-mongodb
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/ommongodb.so
%endif

%if %{with hiredis}

%files module-hiredis
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omhiredis.so
%endif

%if %{with zeromq}

%files module-zeromq
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/imzmq3.so
%{rsyslog_module_dir_withdeps}/omzmq3.so
%endif

%if %{with kafka}

%files module-kafka
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/imkafka.so
%{rsyslog_module_dir_withdeps}/omkafka.so
%endif

%if %{with omamqp1}
%files module-omamqp1
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omamqp1.so
%endif

%if %{with gcrypt}

%files module-gcrypt
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/lmcry_gcry.so
%{_bindir}/rscryutil
%endif

%if %{with tcl}
%files module-omtcl
%defattr(-,root,root)
%{rsyslog_module_dir_withdeps}/omtcl.so*
%endif

%changelog
* Thu Sep 26 2024 thomas.blume@suse.com
- restart daemon after update at the end of the transaction
  (bsc#1230984)
* Tue Aug 27 2024 thomas.blume@suse.com
- Upgrade to rsyslog 8.2406.0
-patches replaced by upgrade (see details in upgrade logs below)
    0001-Avoid-crash-on-restart-in-imrelp-SIGTTIN-handler.patch
  * 2023-11-29: Revert "Update omlibdbi.c"
  * 2023-11-21: imkmsg: add params "readMode" and "expectedBootCompleteSeconds"
  * 2023-11-10: testbench: fix "typo" in test case
  * 2023-11-08: omazureeventhubs: Corrected handling of transport closed failures
  * 2023-10-31: imkmsg: add module param parseKernelTimestamp
  * 2023-11-03: imfile: remove state file on file delete fix
  * 2023-10-30: imklog bugfix: keepKernelTimestamp=off config param did not work
  * 2023-10-30: Netstreamdriver: deallocate certificate related resources
  * 2023-10-20: TLS subsystem: add remote hostname to error reporting
  * 2023-10-21: Fix forking issue do to close_range call
  * 2023-10-23: replace debian sample systemd service file by readme
  * 2023-10-20: testbench: bump zookeeper version to match current offering
  * 2023-10-20: Update rsyslog.service sample unit to the latest version used in Debian Trixie
  * 2023-10-20: Only keep a single rsyslog.service for Debian
  * 2023-10-20: Remove no longer used --with-systemdsystemunitdir configure switch
  * 2023-10-18: use logind instead of utmp for wall messages with systemd
  * 2023-10-11: Typo fixes
  * 2023-10-11: Drop CAP_IPC_LOCK capability
  * 2023-10-04: Add CAP_NET_RAW capability due to the omudpspoof module
  * 2023-10-03: Add new global config option "libcapng.enable"
  * 2023-10-02: tcp net subsystem: handle data race gracefully
  * 2023-08-31: Avoid crash on restart in imrelp SIGTTIN handler
  - replaces 0001-Avoid-crash-on-restart-in-imrelp-SIGTTIN-handler.patch
  * 2023-09-26: fix startup issue on modern systemd systems
  * 2023-09-14: Fix misspeling in message.
  * 2023-09-13: tcpflood bugfix: plain tcp send error not properly reported
  * 2023-09-12: omprog bugfix: Add CAP_DAC_OVERRIDE to the bounding set
  * 2023-08-02: testbench: cleanup and improve some more imfile tests
  * 2023-08-02: lookup tables: fix static analyzer issue
  * 2023-08-02: lookup tables bugfix: reload on HUP did not work when backgrounded
  * 2023-07-28: CI: fix and cleaup github workflow
  * 2023-03-07: imjournal: Support input module
  * 2023-07-28: testbench: make test more reliable
  * 2023-07-28: tcpflood: add -A option to NOT abort when sending fails
  * 2023-07-28: tcpflood: fix today's programming error
  * 2023-07-28: openssl: Replaced depreceated method SSLv23_method with TLS_method
  * 2023-07-27: testbench improvement: define state file directories for imfile tests
  * 2023-07-28: testbench: cleanup a test and some nitfixes to it
  * 2023-07-27: tcpflood bugfix: TCP sending was not implemented properly
  * 2023-07-26: testbench: make waiting for HUP processing more reliable
  * 2023-07-25: build system: make rsyslogd execute when --disable-inet is configured
  * 2023-07-25: CI: update zookeper download to newer version
  * 2023-07-10: ossl driver: Using newer INIT API for OpenSSL 1.1+ Versions
  * 2023-07-11: ossl: Fix CRL File Expire from 1 day to 100 years.
  * 2023-07-06: PR5175: Add TLS CRL Support for GnuTLS driver and OpenSSL 1.0.2+
  * 2022-05-13: omazureeventhubs: Initial implementation of new output module
  * 2023-07-03: TLS CRL Support Issue 5081
  * 2023-06-29: action.resumeintervalmax: the parameter was not respected
  * 2023-06-28: IMHIREDIS::FIXED:: Restore compatiblity with hiredis < v1.0.0
  * 2023-05-15: Add the 'batchsize' parameter to imhiredis
  * 2023-06-28: Clear undefined behavior in libgcry.c (GH #5167)
  * 2023-06-22: Do not try to drop capabilities when we don't have any
  * 2023-06-22: testbench: use newer zookeeper version in tests
  * 2023-06-22: build system: more precise error message on too-old lib
  * 2023-05-17: Fix quoting for omprog, improg, mmexternal
* Tue Jan 16 2024 thomas.blume@suse.com
- suppress installation errors when systemd is not running
  (bsc#1218799)
* Wed Dec 13 2023 thomas.blume@suse.com
- restart daemon after modules packages have been updated
  (bsc#1217292)
* Mon Oct  9 2023 thomas.blume@suse.com
- fix rsyslog crash in imrelp (bsc#1210286)
  * add: 0001-Avoid-crash-on-restart-in-imrelp-SIGTTIN-handler.patch
* Wed Jul 19 2023 thomas.blume@suse.com
-patches replaced by upgrade (see details in upgrade logs below)
  0001-fixing-the-deleteStateOnFileDelete-option.patch
  0001-imfile-Remove-inotify-watch-descriptor-on-inode-chan.patch
  0001-queue-Add-NULL-check-in-qDeqLinkedList.patch
  0001-testbench-add-test-for-legacy-permittedPeer-statemen.patch
  0002-imtcp-bugfix-legacy-config-directives-did-no-longer-.patch
  CVE-2022-24903.patch
- Upgrade to rsyslog 8.2306.0 (jsc#PED-4883)
  * 2023-06-09: mmnormalize bugfix: if msg cannot be parsed, parser chain is stopped
  * 2023-06-08: Add new global config option "libcapng.default"
  * 2023-06-08: imjournal: Add FileCreateMode module parameter
  * 2023-04-17: core bugfix: potential segfault on busy systems
  * 2023-05-11: GNUTls Driver: Fix memory leaks in gtlsInitCred
  * 2023-05-24: CI: update base ubuntu image for github actions
  * 2023-05-16: OMHIREDIS::ADDED:: New support for 'stream' mode
  * 2023-05-17: OMHIREDIS::ADDED:: new tests for existing functionalities
  * 2023-04-25: OMHIREDIS::FIXED:: Correctly suspend module in case of failure
  * 2023-05-17: OMHIREDIS::FIXED:: Synchronously try to authenticate
  * 2023-04-25: IMHIREDIS::ADDED:: New support for 'stream' mode
  * 2023-04-25: REDIS::ADDED:: Implement tests for imhiredis module
  * 2023-04-12: IMHIREDIS::CLEAN:: various improvements and fixes
    [#]## CHANGED
  - [IMHIREDIS] factorize code for different modes
  - [IMHIREDIS] Clean and improve logging lines
  - [IMHIREDIS] Poll extinction state less frequently for main thread (less aggresive)
  - [IMHIREDIS] Set 'key' action parameter to REQUIRED
  - [IMHIREDIS] Use known message length instead of calculating it when
    enqueuing message
    [#]## ADDED
  - [IMHIREDIS] Missing redis replies' types in enumeration
    [#]## FIXED
  - [IMHIREDIS] Correctly initialize instance object, especially for redisNodesList
  - [IMHIREDIS] Correctly print input mode's value in logs when set incorrectly
  * 2023-05-17: tests: mmexternal-SegFault-empty-jroot-vg.sh: fix typo
  * 2023-03-21: modify testbench test to detect wrong imptcp truncation
  * 2023-03-21: imptcp bugfix: spam log on oversize message
  * 2023-03-23: core/bugfix: using $uuid msg prop can deadlock rsyslog on shutdown
  * 2023-03-13: Remove halted LGTM badges on README
  * 2023-02-16: Do not preserve capabilities when changing credentials
  * 2023-01-23: CI/QA: do compile test both with NDEBUG set/unset
  * 2023-01-23: Fixed wrong type conversion in cstrLen() for debug mode as well
  * 2023-01-18: core/template: implement negative position.to
  * 2023-01-18: CI: fix github CodeQL settings
  * 2023-01-17: Remove CAP_DAC_OVERRIDE if privileges dropped
  * 2023-01-17: Adjust the capability set
  * 2023-01-13: substring function: enhancement and hardening
  * 2023-01-11: omfile: add action parameters "rotation.*"
  * 2023-01-11: CI: use newer version of zookeeper
  * 2023-01-09: ffaup fix : memory corruption with concurrent workers
  * 2023-01-02: openssl: fix undefined reference to CRYPTO_set_id_callback
  * 2022-12-30: testbench: add test for invalid json template generation
  * 2022-12-30: core bugfix: template system may generate invalid json
  * 2022-12-28: Fixed wrong type conversion in cstrLen()
  * 2022-12-08: Add CodeQL workflow for GitHub code scanning
- Upgrade to rsyslog 8.2212.0
  * 2022-12-05: testbench: make python http server based tests more reliable
  * 2022-12-05: omprog bugfix: invalid status handling at called program startup
  * 2022-11-29: testbench bugfix: wrong message injection object of instance 1
  * 2022-11-21: rsyslog.conf man page bugfix: description of selectors
  * 2022-11-18: imtcp bugfix: legacy config directives did no longer work
  - replaces 0002-imtcp-bugfix-legacy-config-directives-did-no-longer-.patch
  * 2022-11-16: ksi bugfix: sending of too many signing requests fixed.
  * 2022-11-14: bugfix: prevent potential segfault when switchung to queue emergency mode
  * 2022-11-02: imjournal: add second fallback to _COMM
  * 2022-10-25: core bugfix: local hostname invalid if no global() config object given
  * 2022-10-25: testbench bugfix: fixed timing issue that sometimes lead to test failure
- Upgrade to rsyslog 8.2208.0
  * 2022-08-09: ksi bugfix: request cache size and send timeout issue fixed.
  * 2022-08-09: imjournal bugfix: segmentation fault in close journal
  * 2022-08-09: net subsystem: support sha256 for StreamDriverAuthMode="x509/fingerprint"
  * 2022-08-05: imfile bugfix: message loss/duplication when monitored file is rotated
  * 2022-08-05: ksi bugfix: optimize processing of signer queue to fix delays.
  * 2022-08-04: ksi bugfix: possible crash fixed when several log files are opened.
  * 2022-08-04: openssl: add support to split tls commands by semicolon
  * 2022-08-04: openssl subsystem bugfix: build issue on Solaris
  * 2022-08-04: openssl: add more details to error messages
  * 2022-08-04: omclickhouse: capture additional exceptions
  * 2022-08-04: mmanon bugfix: Simplified and fixed IPv4 digit detection.
  * 2022-07-21: imptcp: slight tuning
  * 2022-07-20: template procesing/json: performance optimization
  * 2022-07-19: core bugfix: memory leak when free action worker data table
  * 2022-07-13: omfile: support for zstd compression
  * 2022-07-07: stream cleanup: move error message to debug log, only
  * 2022-07-04: mmdblookup bugfix: Don't crash Rsyslog on mmdb file errors
  * 2022-06-28: build error fix: libbson requires out-of-date language constructs
  * 2022-06-27: OpenSSL: fix depreacted API issues for OpenSSL 3.x
- Upgrade to rsyslog 8.2206.0
  * 2022-05-25: omelastisearch: allow omitting _type field
  * 2022-05-18: tcpsrv/imtcp: slight performance improvements
  * 2022-05-12: imptcp bugfix: worker thread starvation on extreme traffic
  * 2022-05-11: omelasticsearch: several support option for ElasticSearch 8
  - config params searchIndex and documentType can be empty
  - support for Data Stream API
  - new config param esVersion.major
  * 2022-05-09: tcp receiver bugfix: delay/potential hang on some error conditions
  * 2022-05-05: net bugfix: potential buffer overrun
  - replaces CVE-2022-24903.patch
    Advisory:
    https://github.com/rsyslog/rsyslog/security/advisories/GHSA-ggw7-xr6h-mmr8#advisory-comment-72243
  * 2022-05-05: imptcp: set OS worker thread name
  * 2022-04-26: mmanon bugfix: shortened IPv6 form not always anonymized
  * 2022-04-22: mmdblookup fix: wrong copy of buffer
  * 2022-04-22: mmdblookup: several enhancements
  - support arrays in MMDB entry
  - support escaped quotes '"' in MMDB entry
  - support '<' characters in MMDB entry, when in a field
  - support '}' characters in MMDB entry, when in a field
- Upgrade to rsyslog 8.2204.0
  * 2022-04-18: gnutls bugfix: possibility of infinite loop
  * 2022-04-17: core/bugfix: errorfile could grow over max configures size
  * 2022-04-17: omkafka bugfix: potential misadressing
  * 2022-04-06: added new "FullJSONFmt" standard template (with addtl fields)
  * 2022-04-04: imfile: potential processing delay
  * 2022-04-04: bugfix: cosmetic data races
  * 2022-04-01: add property options to support ISO week/year number
  * 2022-04-01: core bugfix: "action suspended" message was emitted even when turned off
  * 2022-03-31: testbench: add more tests for rscript comparison operations
  * 2022-03-31: core bugfix: make internal logs emitted during HUP procesing appear quicker
  * 2022-03-20: refactor: Move the parser directive to the main config
  * 2022-03-16: refactor: ake the main message queue part of the config
  * regression bugfix: rsyslog may segfault during startup
  * regression fix: script string comparison did not work correctly
- Upgrade to rsyslog 8.2202.0
  * 2022-02-11: Make action counter part of the config
  * 2022-02-09: imfile: Remove inotify watch descriptor on inode change detected
  - replaces 0001-imfile-Remove-inotify-watch-descriptor-on-inode-chan.patch
  * 2022-02-03: omelasticsearch: Fix indexSuccess impstats counter in bulkmode
  * 2022-01-28: rscript: literal numbers were not compared correctly
  * 2022-01-17: ompgsql: PGsslInUse not supported on old distros
  * 2021-12-31: ompgsql: allow connection params via connection string
  * 2022-01-17: CI: remove fedora 33 based testing
  * 2022-01-14: Terminate all tcpsrv threads properly
  * 2022-01-04: Move timezone specific variables to rsconf
  * 2022-01-13: Fixes #4395 by correctly checking for EPIPE.
  * 2022-01-12: Move rsyslog global parameters to rsconf_t struct
  * 2022-01-12: cleanup: remove unused variable
  * 2022-01-07: CI: cleanup journal test environment
  * 2022-01-06: CI: remove unnecessary dependency
  * 2022-01-05: Update omlibdbi.c
  * 2022-01-05: omhttp: Fix memory leak in lokirest batchmode
  * 2021-12-15: Clarify meaning of loadConf and RunConf
- Upgrade to rsyslog 8.2112.0
  * 2021-12-14: refactor:Deallocate outchannel resources in rsconf destructor
  * 2021-12-14: refactor: use runConf instead of loadConf in ratelimiting during runtime
  * 2021-11-22: new contribtion: URL parser module function using libfa
  * 2021-11-18: mmanon: relax IPv6 detection - improve anonymization
  * 2021-11-10: ruleset bugfix: ruleset queue was incorrectly named
  * 2021-11-10: omsnmp: update module to current IP best practices
  * 2021-10-27: ommysql: fix threading bug
  * 2021-10-25: testbench: false positive when impstats was not built
  * 2021-10-25: imtcp: add support for permittedPeers setting at input() level
  * 2021-10-25: testbench: add test for legacy permittedPeer statement
  - replaces 0001-testbench-add-test-for-legacy-permittedPeer-statemen.patch
- Upgrade to rsyslog 8.2110.0:
  * 2021-10-13: PrivDropToUser: fix abortOnIDResolutionFail handling #2
  * 2021-10-12: PrivDropToUser: fix abortOnIDResolutionFail handling
  * 2021-09-17: rscript fix: ruleset called async when ruleset had queue.type="direct"
  * 2021-10-07: tcpsrv: fix compilation without exceptions
  * 2021-09-29: build issue: handle undefined MAXPATHLEN, PATH_MAX
  * 2021-10-06: Fix typo in error message.
  * 2021-09-21: mmkubernetes bugfix: no connection retry to kubernetes APP
  * 2021-09-13: use correct api for es 6 and later
  * 2021-09-20: openssl: Correct gnutlsPriorityString (custom ciphers) behaviour
  * 2021-09-20: ksi bugfix: locking bug fixed in rsksiCtxOpenFile
  * 2021-09-13: Fix ElasticSearch Test broken by ES incompatibility
  * 2020-11-21: imhttp updates - query parameter ingestion & basic auth support
  * 2021-09-08: openssl: extended output information on connection failure
  * 2021-09-02: queue: Add NULL check in qDeqLinkedList
  - replaces 0001-queue-Add-NULL-check-in-qDeqLinkedList.patch
  * 2021-09-06: core bugfix: use of property $wday terminates string
  * 2021-09-02: gnutls: Propagate PrioritizeSAN when accepting a new connection
  * 2021-08-24: ratelimit: fix rate limiting for already parsed messages
  * 2021-08-23: config: implement script-equavalent for $PrivDrop* statements
- Upgrade to rsyslog 8.2108.0:
  * 2021-08-16: openssl tls: Improved error message output on tls failures.
  * 2021-07-01: imfile add `ignoreolderthanoption`
  * 2021-08-10: imklog: fix invalid memory adressing, could cause abort
  * 2021-08-09: omelasticsearch: fix incorrect mutex error handling regression
  * 2021-08-09: imfile bugfix: hash char invalidly added in readmode != 0
  * 2021-08-08: imudp: add socket type (IPv4 vs. 6) to input name
  * 2021-07-13: fixing the deleteStateOnFileDelete option
  - replaces 0001-fixing-the-deleteStateOnFileDelete-option.patch
  * 2021-07-07: CI: add test for imtcp not correctly starting up and a Solaris fix
  * 2021-08-05: omfwd: add capability for action-specific TLS certificate settings
  * 2021-07-01: imtcp: permit to use different certificate files per input/action
  * 2021-08-04: debug support: add indication of "being HUPed" to debug log
  * 2021-08-04: imptcp bugfix: keep alive interval was incorrectly set
  * 2021-07-22: Close file descriptor when freshStartTail is turned on
  * 2021-07-22: [omelasticsearch] Improve errorFile mutex handling
  * 2021-07-08: openssl network driver bugfix: small memory leak
  * 2021-07-07: tcpsrv bugfix: abort if no listener could be started
  * 2021-07-01: tcp subsystem: fix cosmetic memory leak on shutdown
  * 2021-07-01: fix typo in error message
  * 2021-06-30: OMMONGODB :: Fixes
  * 2021-06-29: mmkubernetes fix for apiserver error handling
  * 2021-06-21: omkafka updates
  * 2021-06-22: percentile module to track percentile metrics via impstats
  * 2021-06-17: CI: disable Travis CI for the time being
  * 2021-04-15: omhttp: Fix dynrestpath param in batch mode
  * 2021-06-14: add predefined template RSYSLOG_SyslogRFC5424Format
  * 2021-06-10: bugfix: _sender_stats reports integer counter as string
* Fri Jul 14 2023 thomas.blume@suse.com
- fix removal of imfile state files (bsc#1213212)
  * add 0001-fixing-the-deleteStateOnFileDelete-option.patch
* Wed Nov 30 2022 thomas.blume@suse.com
- fix parsing of legacy config syntax (bsc#1205275)
  * add:
    0001-testbench-add-test-for-legacy-permittedPeer-statemen.patch
    0002-imtcp-bugfix-legacy-config-directives-did-no-longer-.patch
* Mon Sep 12 2022 thomas.blume@suse.com
- remove $klogConsoleLogLevel setting from rsyslog.conf (bsc#1191833)
  * this legacy setting from pre-systemd times is obsolete and can
    block important systemd messages
* Fri Jul 29 2022 thomas.blume@suse.com
- fix segfault in qDeqLinkedList during shutdown (bsc#1199283)
  * add 0001-queue-Add-NULL-check-in-qDeqLinkedList.patch
* Tue May 31 2022 thomas.blume@suse.com
- Remove inotify watch descriptor in imfile on inode change detected
  (bsc#1198939)
  * add 0001-imfile-Remove-inotify-watch-descriptor-on-inode-chan.patch
* Fri May  6 2022 thomas.blume@suse.com
- (CVE-2022-24903) fix potential heap buffer overflow in modules for TCP
  syslog reception (bsc#1199061)
  * add CVE-2022-24903.patch
* Tue Feb 15 2022 thomas.blume@suse.com
- add service dependencies for remote logging (bsc#1194669)
- update config example in remote.conf to match upstream documentation
* Thu Jan 13 2022 thomas.blume@suse.com
- fix config parameters in specfile (bsc#1194593)
* Tue Jun 15 2021 michael@stroeder.com
- Upgrade to rsyslog 8.2106.0:
  * NOTE: the prime new feature is support for TLS and non-TLS connections
    via imtcp in parallel. Furthermore, most TLS parameters can now be overriden
    at the input() level. The notable exceptions are certificate files, something
    that is due to be implemented as next step.
  * 2021-06-14: new global option "parser.supportCompressionExtension"
    This permits to turn off rsyslog's single-message compression extension
    when it interferes with non-syslog message processing (the parser
    subsystem expects syslog messages, not generic text)
    closes https://github.com/rsyslog/rsyslog/issues/4598
  * 2021-05-12: imtcp: add more override config params to input()
    It is now possible to override all module parameters at the input() level. Module
    parameters serve as defaults. Existing configs need no modification.
  * 2021-05-06: imtcp: add stream driver parameter to input() configuration
    This permits to have different inputs use different stream drivers
    and stream driver parameters.
    closes https://github.com/rsyslog/rsyslog/issues/3727
  * 2021-04-29: imtcp: permit to run multiple inputs in parallel
    Previously, a single server was used to run all imtcp inputs. This
    had a couple of drawsbacks. First and foremost, we could not use
    different stream drivers in the varios inputs. This patch now
    provides a baseline to do that, but does still not implement the
    capability (in this sense it is a staging patch).
    Secondly, we now ensure that each input has at least one exclusive
    thread for processing, untangling the performance of multiple
    inputs from each other.
    see also: https://github.com/rsyslog/rsyslog/issues/3727
  * 2021-04-27: tcpsrv bugfix: potential sluggishnes and hang on shutdown
    tcpsrv is used by multiple other modules (imtcp, imdiag, imgssapi, and,
    in theory, also others - even ones we do not know about). However, the
    internal synchornization did not properly take multiple tcpsrv users
    in consideration.
    As such, a single user could hang under some circumstances. This was
    caused by improperly awaking all users from a pthread condition wait.
    That in turn could lead to some sluggish behaviour and, in rare cases,
    a hang at shutdown.
    Note: it was highly unlikely to experience real problems with the
    officially provided modules.
  * 2021-04-22: refactoring of syslog/tcp driver parameter passing
    This has now been generalized to a parameter block, which makes it much cleaner and
    also easier to add new parameters in the future.
  * 2021-04-22: config script: add re_match_i() and re_extract_i() functions
    This provides case-insensitive regex functionality.
    closes https://github.com/rsyslog/rsyslog/issues/4429
* Tue Apr 20 2021 michael@stroeder.com
- Upgrade to rsyslog 8.2104.0:
  * rainerscript: call getgrnam_r repeatedly to get all group members
    (bsc#1178490)
  * new contributed module imhiredis
  * new built-in function get_property() to access property vars
  * mmdblookup: add support for mmdb DB reload on HUP
  * script bugfix: empty array in foreach() improperly handled
  * imjournal bugfixes (handle leak, empty file)
  * new contributed function module fmunflatten
  * test bugfix: some tests did not work with newer TLS library versions
  * some improvements to project CI
* Fri Feb 26 2021 thomas.blume@suse.com
- update remote.conf example file to new 'Address' and 'Port' notation
  (bsc#1182653)
* Tue Feb 16 2021 michael@stroeder.com
- HTTPS URLs used for source
- Upgrade to rsyslog 8.2102.0:
  * omfwd: add stats counter for sent bytes
  * omfwd: add error reporting configuration option
  * action stats counter bugfix: failure count was not properly incremented
  * action stats counter bugfix: resume count was not incremented
  * omfwd bugfix: segfault or error if port not given
  * lookup table bugfix: data race on lookup table reload
  * testbench modernization
  * testbench: fix invalid sequence of kafka tests runs
  * testbench: fix kafkacat issues
  * testbench: fix year-dependendt clickhouse test
* Tue Dec  8 2020 michael@stroeder.com
- Upgrade to rsyslog 8.2012.0:
  * testbench bugfix: some tests did not work in make distcheck
  * immark: rewrite with many improvements
  * usability: re-phrase error message to help users better understand cause
  * add new system property $now-unixtimestamp
  * omfwd: add new rate limit option
  * omfwd bug: param "StreamDriver.PermitExpiredCerts" is not "off" by default
* Thu Nov 26 2020 lnussel@suse.de
- prepare usrmerge (boo#1029961)
* Mon Nov  9 2020 thomas.blume@suse.com
- fix location and naming of journald dropin (bsc#1178288)
* Wed Oct 28 2020 thomas.blume@suse.com
- remove legacy stuff from specfile
  * sysvinit is not supported anymore, so remove all tests
    related to systemv in the specfile
* Tue Oct 20 2020 michael@stroeder.com
- Upgrade to rsyslog 8.2010.0:
  * gnutls TLS subsystem bugfix: handshake error handling
  * core/msg bugfix: memory leak
  * core/msg bugfix: segfault in jsonPathFindNext() when <root> not an object
  * openssl TLS subsystem: improvments of error and status messages
  * add 'exists()' script function to check if variable exists
  * core bugfix: do not create empty JSON objects on non-existent key access
  * gnutls subsysem bugfix: potential hang on session closure
  * core/network bugfix: obey net.enableDNS=off when querying local hostname
  * core bugfix: potential segfault on query of PROGRAMNAME property
  * imtcp bugfix: broken connection not necessariy detected
  * new module: imhttp - http input
  * mmdarwin bugfix: potential zero uuid when reusing existing one
  * imdocker bugfix: build issue on some platforms
  * omudpspoof bugfix: make compatbile with Solaris build
  * testbench fix: python 3 incompatibility
  * core bugfix: segfault if disk-queue file cannot be created
  * cosmetic: fix dummy module name in debug output
  * config bugfix: intended warning emitted as error
* Sat Aug 29 2020 michael@stroeder.com
- Upgrade to rsyslog 8.2008.0
  Way too many changes since 8.39.0 to be listed here.
- Added custom unit file rsyslog.service because
  systemd service file was removed from upstream project
- Removed obsolete patches:
  * 0001-satisfy-gcc-flag-fno-common.patch
  * rsyslog-pgsql-pkg-config.patch
  * rsyslog-unit.patch
* Sat Jul 11 2020 kukuk@suse.com
- Use systemd_ordering instead of requiring to make rsyslog useable
  in containers.
* Wed Apr 15 2020 rjschwei@suse.com
- Fix the URL for bug reporting, should not point to novell.com
  (bsc#1173433)
* Thu Feb  6 2020 rtyler@brokenco.de
- Add support for omkafka which is now in Factory, and 15.x repos
* Thu Jan  9 2020 thomas.blume@suse.com
- avoid build error with gcc flag -fno-common (bsc#1160414)
  * add 0001-satisfy-gcc-flag-fno-common.patch
* Thu Jul 25 2019 matthias.gerstner@suse.com
- removal of SuSEfirewall2 service, since SuSEfirewall2 has been replaced by
  firewalld, see [1].
  [1]: https://lists.opensuse.org/opensuse-factory/2019-01/msg00490.html
* Tue Mar  5 2019 dimstar@opensuse.org
- Add rsyslog-pgsql-pkg-config.patch: use pkgconfig to find the
  right libraries/directories for postgresql. According to pgsql
  upstream, pg_config must only be used to buildpgsql modules.
* Fri Feb 22 2019 Thomas.Blume@suse.com
- set default permissions before include directives (bsc#1126233)
  * Logfile open modes depend on position in the config file, see
    https://www.rsyslog.com/doc/rsconf1_filecreatemode.html
* Wed Nov 21 2018 egotthold@suse.com
-  Upgrade to rsyslog 8.39.0
  * imfile: improve truncation detection
  * imjournal: work around journald excessive reloading behavior
  * errmsg: remove no longer needed code
  * queue bugfix: invalid error message on queue startup
  * bugfix imrelp: regression with legacy configuration startup fail
  * bugfix imudp: stall of connection and/or potential segfault
  * bugfix gcry crypto driver: small memleak
  * fix potential misadressing in encryption subsystem
  * ksi subsystem changes
  * bugfix core: regex compile error messages could be incorrect
  * bugfix core: potential hang on rsyslog termination
  * bugfix imkafka: system hang when backgrounded
  * bugfix imfile: file change was not reliably detected
  * bugfix imrelp: do not fail build if librelp does not have relpSrvSetLstnAddr
  * bugfix queue subsystem: DA queue did ignore encryption settings
  * bugfix KSI: lmsig-ksils12 module skips signing the last block
  * bugfix fmhash: function hash64mod sometimes returned wrong result
  * bugfix core/debug: data written to random fd 2 under some debug settings
* Tue Oct 16 2018 Thomas.Blume@suse.com
- rsyslog configuration cleanup by filter rules in separate files  (bug#1102720)
  * add parsing of additional filter rules in /etc/rsyslog.d/*.frule
  * add acpid.frule, firewall.frule, NetworkManager.frule
* Wed Oct 10 2018 kukuk@suse.de
- Enable ForwardToSyslog for journald to get syslog messages
  [bsc#1110456]
* Tue Sep 18 2018 michael@stroeder.com
- Update to rsyslog 8.38.0:
  * imfile: support for endmsg.regex
  * omhttp: new contribued module
  * imrelp: add support for seting address to bind to (#894)
  * ommysql: support mysql unix domain socket
  * omusrmsg: do not fall back to max username length of 8
  * various bug fixes and minor updates to other modules and core
  * various fixes for memory leaks
* Thu Jul 19 2018 Thomas.Blume@suse.com
- remove references to obsolete SYSLOG_REQUIRES_NETWORK
  variable (bsc#1101642)
* Wed Jun 27 2018 astieger@suse.com
- rsyslog 8.36.0:
  * Liblogging-stdlog deprecated
  * OpenSSL based TLS driver added in addition to GnuTLS
  * GnuTLS TLS driver: support intermediate certificates
  * imptcp: add ability to configure socket backlog
  * fmhash: new hash function module
  * updates and fixes to various modules
  * omfwd: add support for bind-to-address for UDP
  * mmkubernetes: new module
- updates and fixes to various modules
* Tue Jun 26 2018 Thomas.Blume@suse.com
- fix CVE-2015-3243 rsyslog: some log files are created world-readable
  (bsc#935393)
* Sat Mar 24 2018 astieger@suse.com
- rsyslog 8.33.1:
  * devcontainer: use some more sensible defaults
  * auto-detect if running inside a container (as pid 1)
  * config: add include() script object
  * template: add option to generate json "container"
  * core/template: add format jsonf to constant template entries
  * config: add ability to disable config parameter ("config.enable")
  * script: permit to use environment variables during configuration
  * new global config parameter "shutdown.enable.ctlc"
  * config optimizer: detect totally empty "if" statements and optimize them out
  * template: constant entry can now also be formatted as json field
  * omstdout: support for new-style configuration parameters added
  * core: set TZ on startup if not already set
  * imjournal bugfix: file handle leak during journal rotation
  * lmsig_ksils12 bugfix: dirOwner and dirGroup config was not respected
  * script bugfix: replace() function worked incorrectly in some cases
  * core bugfix: misadressing in external command parser
  * core bugfix: small memory leak in external command parser
  * core bugfix: string not properly terminated when RFC5424 MSGID is used
  * bugfix: strndup() compatibility layer func copies too much
- the upstream systemd unit file was changed to no longer write the
  rsyslog pid, as it is no longer required for tracking under
  systemd (-iNONE). Adjust rsyslog-unit.patch to match.
* Mon Mar 19 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Mon Feb 19 2018 Thomas.Blume@suse.com
- fix includes for apparmor profile (bsc#1080238)
* Fri Jan 26 2018 astieger@suse.com
- rsyslog 8.32.0
  * libfastjson 0.99.8 required
  * libczmq >= 3.0.2 is now required for omczmq
  * libcurl is now needed for rsyslog core
  * rsyslogd: add capability to specify that no pid file shall be written
  * core improvements and bug fixes
  * RainerScript improvements and bug fixes
  * build fixes, including gcc7 fixes
    drop 0001-imgssapi-fix-compiler-warnings.patch
  * various bug fixes in multiple modules
* Fri Jan 19 2018 rgerhards@adiscon.com
- remove build dependency on libee
* Thu Dec  7 2017 kukuk@suse.de
- Disable news by default, we don't need to clobber all systems
  with this for the very few remaining news servers
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Fri Nov 17 2017 astieger@suse.com
- Ensure user "news" exists - bsc#1068678
* Tue Nov 14 2017 astieger@suse.com
- rsyslog 8.30.0
  * changed behaviour: all variables are now case-insensitive by default
  * core: handle (JSON) variables in case-insensitive way
  * imjournal: made switching to persistent journal in runtime possible
  * mmanon: complete refactor and enhancements
  * imfile: add "fileoffset" metadata
  * RainerScript: add ltrim and rtrim functions
  * core: report module name when suspending action
  * core: add ability to limit number of error messages going to stderr
  * tcpsrv subsystem: improvate clarity of some error messages
  * imptcp: include module name in error msg
  * imtcp: include module name in error msg
  * tls improvement: better error message if certificate file cannot be read
  * omfwd: slightly improved error messages during config parsing
  * ommysql improvements
  * ommysql bugfix: do not duplicate entries on failed transaction
  * imtcp bugfix: parameter priorityString was ignored
  * template/bugfix: invalid template option conflict detection
  * core/actions: fix handling of data-induced errors
  * core/action bugfix: no "action suspended" message during retry processing
  * core/ratelimit bugfix: race can lead to segfault
  * core bugfix: rsyslog aborts if errmsg is generated in early startup
  * core bugfix: informational messages was logged with error severity
  * core bugfix: --enable-debugless build was broken
  * queue bugfix: file write error message was incorrect
  * omrelp bugfix:  segfault when rebindinterval parameter is used
  * omkafka bugfix: invalid load of failedmsg file on startup if disabled
  * kafka bugfix: problem on invalid kafka configuration values
  * imudp bugfix: UDP oversize message not properly handled
  * core bugfix: memory corruption during configuration parsing
  * core bugfix: race on worker thread termination during shutdown
  * omelasticsearch: avoid ES5 warnings while sending json in bulkmode
  * omelasticsearch bugfix: incompatibility with newer ElasticSearch version
  * imptcp bugfix: invalid mutex addressing on some platforms
  * imptcp bugfix: do not accept missing port in legacy listener definition
- build requirements:
  * libfastjson 0.99.7 is now mandatory
  * libsystemd-journal >= 234 is now recommended
- packaging:
  * add upstream build fix 0001-imgssapi-fix-compiler-warnings.patch
* Tue Aug  8 2017 astieger@suse.com
- rsyslog 8.29.0:
  * imptcp: add experimental parameter "multiline"
  * imptcp: framing-related error messages now also indicate remote peer
  * imtcp: framing-related error messages now also indicate remote peer
  * imptcp: add session statistics conunter
  * imtcp: add ability to specify GnuTLS priority string
  * impstats: add new ressoure counter "openfiles"
  * pmnormalize: new parser module
  * core/queue: provide informational messages on thread startup and shutdown
  * omfwd/udp: improve error reporting, depricate maxerrormessages parameter
  * core: add parameters debug.file and debug.whitelist
  * core/net.c: improve UDP socket creation error messages
  * omfwd/udp: add "udp.sendbuf" parameter
  * core: make rsyslog internal message rate-limiter configurable
  * omelasticsearch bugfixes and changed ES5 API support
    + avoid 404 during health check
    + avoid ES5 warnings while sending json
    + bugfix for memomry leak while writing error file
  * imfile bugfix: wildcard detection issue on path wildcards
  * omfwd bugfix: always give reason for suspension
  * omfwd bugfix: configured compression level was not properly used
  * imptcp bugfix: potential socket leak on session shutdown
  * omfwd/omudpspoof bugfix: switch udp client sockets to nonblocking mode
  * imklog: fix permitnonkernelfacility not working
  * impstats bugfix: impstats does not handle HUP
  * core bugfix: segfault after configuration errors
  * core/queue bugfixes
  * lmsig_ksi: removed pre-KSI_LS12 components
* Sun Jul 30 2017 michael@stroeder.com
  Version 8.28.0 [v8-stable] 2017-06-27
  * omfwd: add parameter "tcp_frameDelimiter"
  * omkafka: large refactor of kafka subsystem
  * imfile: improved handling of atomically renamed file (w/ wildcards)
  * imfile: add capability to truncate oversize messages or split into multiple
  * mmdblookup fixes and extensions
  * bugfix: fixed multiple memory leaks
  * imptcp: add new parameter "flowControl"
  * imrelp: add "maxDataSize" config parameter
  * multiple modules: gtls: improve error if certificate file can't be opened
  * omsnare: allow different tab escapes
  * omelasticsearch: converted to use libfastjson instead of json-c
  * imjournal: _PID fallback
  * added fallback for _PID proprety when SYSLOG_PID is not available
  * introduced new option "usepid" which sets which property should
    rsyslog use, it has 3 states system|syslog|both, default is both
  * deprecated "usepidfromsystem" option, still can be used
    and override the "usepid"
  * it is possible to revert previous default with usepid="syslog"
  * multiple modules: add better error messages when regcomp is failing
  * omhiredis: fix build warnings
  * imfile bugfix: files mv-ed in into directory were not handled
  * omprog bugfix: execve() incorrectly called
  * imfile bugfix: multiline timeout did not work if state file exists
  * lmsig_ksi-ls12 bugfix: build problems on some platforms
  * core bugfix: invalid object type assertion
  * regression fix: local hostname was not always detected properly...
  * bugfix: format security issues in zmq3 modules (bsc#1051798)
  * bugfix build system: add libksi only to those binaries that need it
  * bugfix KSI ls12 components: invalid tree height calculation
* Mon Jun  5 2017 tchvatal@suse.com
- Drop module-guardtime package
  * Upstream libgt died and it does not work with new openssl
* Thu May 18 2017 dziolkowski@suse.com
  Version 8.27.0 [v8-stable] 2017-05-16
- imkafka: add module
- imptcp enhancements:
  * optionally emit an error message if incoming messages are truncated
  * optionally emit connection tracking message (on connection create and
    close)
  * add "maxFrameSize" parameter to specify the maximum size permitted
    in octet-counted mode
  * add parameter "discardTruncatedMsg" to permit truncation of
    oversize messages
  * improve octect-counted mode detection: if the octet count is larger
    then the set frame size (or overly large in general), it is now
    assumed that octet-stuffing mode is used. This probably solves a
    number of issues seen in real deployments.
- imtcp enhancements:
  * add parameter "discardTruncatedMsg" to permit truncation of
    oversize messages
  * add "maxFrameSize" parameter to specify the maximum size permitted
    in octet-counted mode
- imfile bugfix: "file not found error" repeatedly being reported
  for configured non-existing file. In polling mode, this message
  appeared once in each polling cycle, causing a potentially very large
  amout of error messages. Note that they were usually emitted too
  infrequently to trigger the error message rate limiter, albeit often
  enough to be a major annoance.
- imfile: in inotify mode, add error message if configured file cannot
  be found
- imfile: add parameter "fileNotFoundError" to optinally disable
  "file not found" error messages
- core: replaced gethostbyname() with getaddrinfo() call
  Gethostbyname() is generally considered obsolete, is not reentrant and
  cannot really work with IPv6. Changed the only place in rsyslog where
  this call remained.
  Thanks to github user jvymazal for the patch
- omkafka: add "origin" field to stats output
  See also https://github.com/rsyslog/rsyslog/issues/1508
  Thanks to Yury Bushmelev for providing the patch.
- imuxsock: rate-limiting also uses process name
  both for the actual limit procesing as well as warning messages emitted
  see also https://github.com/rsyslog/rsyslog/pull/1520
  Thanks to github user jvymazal for the patch
- Added new module: KSI log signing ver. 1.2 (lmsig_ksi_ls12)
- rsylsog base functionality now builds on osx (Mac)
  Thanks to github user hdatma for his help in getting this done.
- build now works on solaris again
- imfile: fix cross-platform build issue
  see also https://github.com/rsyslog/rsyslog/issues/1494
  Thanks to Felix Janda for bug report and solution suggestion.
- bugfix core: segfault when no parser could parse message
* Thu Apr  6 2017 astieger@suse.com
- rsyslog 8.26.0:
  * liblognorm 2.0.3 is required for mmnormalize
  * enable internal error messages at all times
  * core: added logging name of source of rate-limited messages
  * omfwd: omfwd: add support for network namespaces
  * imrelp: honor input name if provided when submitting to impstats
  * imptcp: add ability to set owner/group/access perms for uds
  * mmnormalize: add ability to load a rulebase from action() parameter
  * pmrfc3164 improvements
    + permit to ignore leading space in MSG
    + permit to use at-sign in host names
    + permit to require tag to end in colon
  * add new global parameter "umask"
  * core: make use of -T command line option more secure
  * omfile: add error if both file and dynafile are set
  * bugfix: build problem on MacOS (not a supported platform)
  * regression fix: in 8.25, str2num() returned error on empty string
  * bugfix omsnmp: improper handling of new-style configuration parameters
  * bugfix: rsyslog identifies itself as "liblogging-stdlog" in internal messages
  * bugfix imfile: wrong files were monitored when using multiple imfile inputs
  * bugfix: setting net.aclResolveHostname/net.acladdhostnameonfail segfaults
  * bugfix: immark emitted error messages with text "imuxsock"
  * bugfix tcpflood: build failed if RELP was disabled
  * fix gcc6 compiler warnings
  * the output module array passing interface has been removed
* Mon Mar  6 2017 astieger@suse.com
- use 8.25.0 documentation tarball
* Thu Feb 23 2017 astieger@suse.com
- rsyslog 8.25.0:
  * imfile: add support for wildcards in directory names
  * add new global option "parser.PermitSlashInProgramname"
  * mmdblookup: fix build issues, code cleanup
  * improved debug output for queue corruption cases
  * an error message is now displayed when a directory owner cannot be set
  * rainerscript: add new function ipv42num
  * rainerscript: add new function num2ipv4
  * bugfix: ratelimiter does not work correctly is time is set back
  * core: fix potential message loss in old-style transactional interface
  * bugfix queue subsystem: queue corrupted if certain msg props are used
  * bugfix imjournal: fixed situation when time goes backwards
  * bugfix: bFlushOnTxEnd == 0 not honored when writing w/o async writer
  * bugfix core: str2num mishandling empty strings
  * bugfix rainerscript: set/unset statement do not check variable name validity
  * bugfix mmrm1stspace: last character of rawmsg property was doubled
  * bugfix imtcp: fix very small (cosmetic) memory leak
  * However, the leak breaks memleak checks in the testbench.
* Fri Feb 10 2017 ndas@suse.com
- sync bug and fate numbers from IBS changes.
* Sun Jan 15 2017 astieger@suse.com
- rsyslog 8.24.0(fate#320546):
  * mmrm1stspace: new module; removes first space in MSG if present
  * KSI signature provider: file permissions can now be specified
  * omzmq: new features
  * when the hostname is empty, we now use "localhost-empty-hostname"
  * omelasticsearch: remove "asyncrepl" config parameter
  * omfwd: Add support for bind-to-device (see below on same for imudp)
  * imudp: Add support for bind-to-device
  * imudp: limit rcvbufsize parameter to max 1GiB
  * rainerscript: implement new "call_indirect" statement
  * bugfix imjournal: make state file handling more robust
  * bugfix core: lookup table reload was not properly integrated
  * bugfix core: potential dealock on shutdown
  * bugfix ommongodb: did not work in v8 due to invalid indirection
  * bugfix ommongodb: fix tryResume handling
  * bugfix omfwd: retry processing was not done correctly, could stall
  * bugfix imuxsock: segfault non shutdown when $OmitLocalLogging is on
- contributed modules not enabled due to build issues:
  * mmdblookup: new maxminddb lookup message modify plugin
* Mon Dec 12 2016 dimstar@opensuse.org
- Replace pkgconfig(libsystemd-journal) BuildRequires with
  pkgconfig(libsystemd): the sub-libraries have been merged into
  libsystemd since 209 and have ultimately been removed since 230.
* Sun Dec  4 2016 astieger@suse.com
- rsyslog 8.23.0:
  * requiring libfastjson 0.99.3
  * KSI signatures: removed SHA2-224 hash algorithm
  * imfile: new timeout feature for multi-line reads
  * omfile: improve robustness against network file system failures
  * pmaixforwardedfrom: support for AIX syslogd -s option
  * omelasticsearch: add ability to specify max http request size
  * omelasticsearch: high availability addressing of ElasticSearch cluster
  * omelasticsearch: make compatible with ElasticSearch 2.x and 5.x
  * omhiredis: add dynakey attribute.
  * omtcl: new contributed module
  * RainerScript: provide a capability to set environment variables
  * lookup tables: improved error checking
  * queue subsystem: add configuration parameter "queue.samplinginterval"
  * various bug fixes
  * rsgtutil: option to specify KSI publications file certificate constraints
- includes changes from 8.22.0:
  * ompgsql: add template support
  * generate somewhat better error message on config file syntax error
- includes changes from 8.21.0:
  * CHANGE OF BEHAVIOUR:
    by default, internal messages are no longer logged via the internal
    bridge to rsyslog but via the syslog() API call [either directly or
    via liblogging). For the typical single-rsyslogd-instance installation this
    is mostly unnoticable (except for some additional latency). If multiple
    instances are run, only the "main" (the one processing system log messages)
    will see all messages. To return to the old behaviour, do either of those
    two:
    1) add in rsyslog.conf:
    global(processInternalMessages="on")
    2) export the environment variable RSYSLOG_DFLT_LOG_INTERNAL=1
    This will set a new default - the value can still be overwritten via
    rsyslog.conf (method 1). Note that the environment variable must be
    set in your **startup script**.
    For more information, please visit
    http://www.rsyslog.com/rsyslog-error-reporting-improved/
  * slightly improved TLS syslog error messages
  * queue subsystem: improved robustness
* Tue Jul 19 2016 astieger@suse.com
- rsyslog 8.20.0:
  * omrelp: add configurable connection timeout
  * pmrfc3164: add support for slashes in hostname
  * bugfix omfile: handle chown() failure correctly
  * omfile now better conveys status of unwritable files back to core
  * config files recursively including themselfes are now detected
  * refactored code to not emit compiler warnings in "strict mode"
  * bugfix: fix some issues with action CommitTransaction() handling
  * bugfix omqmqp1: connecting to the message bus fails on nonstandard port
  * testbench/CI enhancements
- Build requirements:
  * librelp 1.2.12
* Sat Jun  4 2016 astieger@suse.com
- rsyslog 8.19.0:
  * omelasticsearch: add option to permit unsigned certs
  * imrelp: better error codes on unvailablity of TLS options
  * default stack size for inputs has been explicitely set to 4MiB
  * performance improvements
  * miscellaneous minor cleanup
  * fix: potential misadressing in template config processing
  * bugfix omfile: async output file writing does not respect
    flushing
  * bugfix imfile: corrupted multi-line message when state data was
    persisted
  * bugfix imfile: missing newline after first line of multiline
    message
  * bugfix: dynstats unusedMetricTtl bug
  * bugfix build system: build was broken on SunOS
  * bugfix: afterRun entry point not correctly called
  * bugfix dynstats: do not leak file handles
  * bugfix omelasticsearch: disable libCURL signal handling
  * bugfix omelasticsearc: some regressions were fixed
  * improved wording: gnutls error message points to potential
    cause
* Tue Apr 19 2016 astieger@suse.com
- rsyslog 8.18.0(bnc#958728):
  * templates: add option to convert timestamps to UTC
  * omjournal: fix segfault (regression in 8.17.0)
  * imptcp: added AF_UNIX support
  * new template options
  * compressSpace
  * date-utc
  * redis: support for authentication
  * omkafka: makes kafka-producer on-HUP restart optional
  * imfile: new "FreshStartTail" input parameter
  * omjournal: fix libfastjson API issues
  * ommongodb: fix json API issues
  * dynamic stats subsystem: a couple of smaller changes
  * foreach loop: now also iterates over objects (not just arrays)
  * enhancement: queue subsystem is more robst in regard to some corruptions
  * enhancement: Allow rsyslog to bind UDP ports even w/out specific
    interface being up at the moment.
  * new External plugin for sending metrics to SPM Monitoring SaaS
  * bugfix imfile: fix memory corruption bug when appending @cee
  * bugfix: memory misallocation if position.from and position.to is used
    a negative amount of memory is tried to be allocated if position.from
    is smaller than the buffer size (at least with json variables). This
    usually leads to a segfault.
  * bugfix: fix potential memleak in TCP allowed sender definition
  * bugfix: $PrivDropToGroupID actually did a name lookup
  * bugfix: small memory leak in imfile
  * bugfix: double free in jsonmesg template
  * bugfix: incorrect formatting of stats when CEE/Json format is used
  * bugfix omfwd: new-style keepalive action parameters did not work
    due to being inconsistently spelled inside the code. Note that legacy
    parameters $keepalive... always worked
  * bugfix: memory leaks in logctl utility
  * bugfix omrelp: fix segfault if no port action parameter was given
  * bugfix imtcp: Messages not terminated by a NL were discarded
* Sun Mar 13 2016 astieger@suse.com
- rsyslog 8.17.0:
  * improve json variable performance
  * new experimental feature: lookup table suport
  * new feature: dynamic statistics counters
  * new contributed plugin: omampq1 for AMQP 1.0-compliant brokers
  * new set of UTC-based $now family of variables ($now-utc, $year-utc, ...)
  * simplified locking when accessing message and local variables
  * new global parameter "debug.unloadModules"
  * timestamp handling: guard against invalid dates
  * imfile: add "trimlineoverbytes" input paramter
  * ommongodb: add support for extended json format for dates
  * omjournal: add support for templates
  * imuxsock: add "ruleset" input parameter(fate#320667)
  * imptcp: performance improvements
  * improve interface definition in some modules, e.g. mmanon, mmsequence
  * rsgtutil: dump mode improvements
    + auto-detect signature file type
    + ability to dump hash chains for log extraction files
  * bugfix: unixtimestamp date format was incorrectly computed (leap year)
  * bugfix: date-ordinal date format was incorrectly computed (leap year)
  * bugfix: some race when shutting down input module threads
  * bugfix tcpflood: did not handle connection drops correct in TLS case
  * bugfix: abort if global parameter value was wrong
  * bugfix omkafka: fix potential NULL pointer addressing
  * bugfix impstats: @cee cookie was prefixed to wrong fromat (json vs. cee)
  * bugfix imfile: fix race during startup that could lead to some duplication
  * bugfix: potential loss of single message at queue shutdown
  * bugfix: potential deadlock with heavy variable access
  * bugfix ommysql: on some platforms, serverport parameter had no effect
  * bugfix omelasticsearch: invalid pointer dereference
  * bugfix omhiredis: serverport config parameter did not reliably work
  * bugfix rsgtutil: -h command line option did not work
  * bugfix lexer: hex numbers were not properly represented
  * bugfix TLS syslog: intermittent errors while sending data
  * bugfix imfile: abort on startup if no slash was present in file name param
  * bugfix rsgtutil: fixed abort when using short command line options
  * bugfix rsgtutil: invalid computation of log record extraction file
  * bugfix build system: KSI components could only be build if in default path
* Mon Feb  1 2016 astieger@suse.com
- rsyslog 8.16.0:
  * rsgtutil: Added extraction support including loglines and hash
    chains.
  * new system properties for $NOW properties based on UTC
  * various bug fixes and improvements
* Thu Jan 28 2016 mrueckert@suse.de
- fix build on sle11: use package name buildrequires instead of
  pkgconfig
* Tue Jan 12 2016 astieger@suse.com
- build with libfastjson (mandatory from 8.16.0)
* Sat Jan  2 2016 astieger@suse.com
- rsyslog 8.15.0:
  * KSI (incompatible changes):
    + KSI utilities: Added option to set publication url via
  - -publications-server. Required for signature verification.
    + UserID and UserKey can be set by parameter
    + Fixed wrong TLV container for KSI signatures from 0905 to 0906.
    + somewhat improved error messages
    + Update for and use libksi 3.4.0.x
  * New contributed modules:
    + pmpanngfw: for translating Palo Alto Networks logs
  * pmciscoios: support for asterisk before timestamp added
  * solr external output plugin much enhanced
  * omrabbitmq: improvements
  * add support for libfastjson (as a replacement for json-c)
  * pmciscoios: support for some format variations
  * improvments for 0mq modules:
    + omczmq - suspend / Retry handling
    + omczmq - improved efficiency
    + omczmq - added ability to set a timeout for sends
    + omczmq - set topics can be in separate frame (default) or
    part of message frame (configurable)
    + imczmq - ZMQ_ROUTER support
  * Note the upstream supported modules not enabled in SUSE package:
    + grok (mmgrok)
    + omkafka
  * add support for building with libfastjson
  * bugfix: invalid mutex handling in omfile async write mode
    could lead to segfault, even though highly unlikely (caught by
    testbench on a single platform) (bsc#1000488)
* Sat Nov  7 2015 astieger@suse.com
- rsyslog 8.14.0:
  * add property "rawmsg-after-pri"
  * bugfix: potential misadresseing in imfile
  * bugfix: re_extract RainerScript function did not work
* Thu Sep 24 2015 astieger@suse.com
- rsyslog 8.13.0:
  * ZeroMQ enhancements
  * Redis enhancements
  * mmnormalize: liblognorm error messages are now emitted via
    regular rsyslog error reporting mechanism (aka "are now logged")
  * networking improvements
- drop rsyslog-8.12.0-parallel-build.patch, is upstream
- drop rsyslog-8.12.0-gnutls.patch, same
* Wed Aug 26 2015 astieger@suse.com
- rsyslog 8.12.0:
  * Harmonize resetConfigVariables values and defaults
  * GT/KSI: fix some issues in signature file format and add conversion tool
  * bugfix: ommysql did not work when gnutls was enabled
  * bugfix omfile: potential memory leak on file close
  * bugfix omfile: potential race in dynafile detection/creation
  * bugfix omfile: Fix race-condition detection in path-creation code
  * bugfix parser subsystem: potential misadressing in SanitizeMsg()
  * imfile: files moved outside of directory are now (properly) handled
  * bugfix: imfile: segfault when using startmsg.regex
  * bugfix imfile: file table was corrupted when on file deletion
  * bugfix ompgsql: transaction were improperly handled
  * bugfix mmjsonparse: memory leak if non-cee-json message is processed
  * testbench: remove raciness from UDP based tests
  * testbench: added bash into all scripts makign it mandatory
  * bugfix testbench: Fixed problem building syslog_caller util when
    liblogging-stdlog is not available.
- add upstream patches:
  * rsyslog-8.12.0-gnutls.patch to fix build with gnutls
  * rsyslog-8.12.0-parallel-build.patch to fix parallel build
* Wed Jul  1 2015 astieger@suse.com
- rsyslog 8.11.0
- new features:
  * signature provider for Keyless Signature Infrastructure (KSI)
- bug fixes:
  * imfile: regex multiline mode ignored escapeLF option
  * omkafka: fixed several concurrency issues, most of them related
    to dynamic topics.
  * execonlywhenpreviousissuspended did not work correctly
  * core engine: ensured global variable atomicity
  * imfile: segfault when using startmsg.regex because of empty log
    line
* Tue May 19 2015 astieger@suse.com
- rsyslog 8.10.0:
  * imfile: add capability to process multi-line messages based on regex
  * pmrfc3164: add new parameter "detect.yearAfterTimestamp"
  * pmrfc3164: add new parameter "permit.squareBracesInHostname"
  * supplementary groups are now set when dropping privileges
  * imfile: added brace glob expansion to wildcard
  * zmq: add the ability for zeromq input and outputs to advertise their
    presence on UDP via the zbeacon API.
  * added omhttpfs: contributed module for writing to HDFS via HTTP
  * bug fixes
- packaging changes:
  * build with GnuTLS support again as 3.4.0 is now supported
* Thu Apr 30 2015 jengelh@inai.de
- Documentation does not depend on the presence of anything
* Mon Apr 27 2015 jsegitz@novell.com
- Adjusted apparmor profile based on the suggestions by Christian Boltz
  * Removed empty files: module-pgsql, module-relp, module-gssapi, module-gtls
  * Moved profiles to /usr/share/apparmor/extra-profiles/
  * Blocked capability block_suspend
  plus some other small fixes
* Mon Apr 20 2015 jsegitz@novell.com
- Adjusted apparmor profile to prevent aa-genprof failures
  (bnc#925512)
* Mon Apr 13 2015 astieger@suse.com
- disable GnuTLS support, does not build with GnuTLS 3.4.0
* Tue Apr  7 2015 astieger@suse.com
- rsyslog 8.9.0:
  - omprog: add option "hup.forward" to forwards HUP to external
    plugins
  - imuxsock: added capability to use regular parser chain
  - new sysSock.useSpecialParser module parameter
  - new sysSock.parseHostname module parameter
  - new useSpecialParser input parameter
  - new parseHostname input parameter
  - 0mq: improvements in input and output modules
  - imtcp: add support for ip based bind for imtcp -> param "address"
  - bugfix: MsgDeserialize out of sync with MsgSerialize for StrucData
  - bugfix imfile: partial data loss, especially in readMode != 0
  - bugfix: potential large memory consumption with failed actions
  - bugfix: omudpspoof: invalid default send template in RainerScript format
  - bugfix: size-based legacy config statements did not work properly
    on some platforms, they were incorrectly handled, resulting in all
    sorts of "interesting" effects (up to segfault on startup)
  - build system: added option --without-valgrind-testbench
    ... which provides the capability to either enforce or turn off
    valgrind use inside the testbench. Thanks to whissi for the patch.
  - rsyslogd: fix misleading typos in error messa
- remove upstreamed rsyslog-8.8.0-nonvoid-function-return.patch
* Sun Mar  1 2015 astieger@suse.com
- rsyslog 8.8.0:
  - omkafka: add support for dynamic topics and auto partitioning
  - imtcp/imptcp: support for broken Cisco ASA TCP syslog framing
  - omfwd: more detailled error messages in case of UDP send error
  - TLS syslog: enable capability to turn on GnuTLS debug logging
  - bugfix: $AbortOnUncleanConfig did not work
  - improve rsyslogd -v output and error message with meta information
  - bugfix imtcp: octet-counted framing cannot be turned off
  - bugfix: build problems on Illuminos
  - bugfix: invalid data size for iMaxLine global property
  - bugfix: negative values for maxMessageSize global parameter were permitted
- add upstream patch rsyslog-8.8.0-nonvoid-function-return.patch
  to fix compiler warnings/errors
* Fri Feb 13 2015 astieger@suse.com
- rsyslog 8.7.0:
  - add message metadata "system" to msg object
    this permits to store metadata alongside the message
  - imfile: add support for "filename" metadata
    this is useful in cases where wildcards are used
  - imptcp: make stats counter names consistent with what imudp, imtcp uses
  - added new module "omkafka" to support writing to Apache Kafka
  - omfwd: add new "udp.senddelay" parameter
  - mmnormalize enhancements
  - RainerScript "foreach" iterator and array reading support
    Thanks to Janmejay Singh for the patch.
  - now requires liblognorm >= 1.0.2
  - add support for systemd >= 209 library names
  - BSD "ntp" facility (value 12) is now also supported in filter
    Note: this patch was released under ASL 2.0 (see email-conversation).
  - bugfix: global(localHostName="xxx") was not respected in all modules
  - bugfix: emit correct error message on config-file-not-found
  - bugfix: impstats emitted invalid JSON format (if JSON was selected)
  - bugfix: (small) memory leak in omfile's outchannel code
  - bugfix: imuxsock did not deactivate some code not supported by platform
- includes changes from 8.6.0:
  - configuration-setting rsyslogd command line options deprecated
  - new and enhanced plugins for 0mq. These are currently experimantal.
  - empty rulesets have been permitted. They no longer raise a syntax error.
  - add parameter -N3 to enable config check of partial config file
    Use for config include files. Disables checking if any action exists at
    all.
  - rsyslogd -e option has finally been removed
    It is deprectated since many years.
  - testbench improvements
  - testbench is now by default disabled
  - add new RainerScript functions warp() and replace()
  - mmnormalize can now also work on a variable
  - new property date options for day ordinal and week number
  - remove --enable-zlib configure option, we always require it
  - slight source-tree restructuring: contributed modules are now in their
    own ./contrib directory. The idea is to make it clearer to the end user
    which plugins are supported by the rsyslog project (those in ./plugins).
  - bugfix: imudp makes rsyslog hang on shutdown when more than 1 thread used
  - bugfix: not all files closed on auto-backgrounding startup
  - bugfix: typo in queue configuration parameter
  - bugfix: unitialized buffer off-by-one error in hostname generation
  - bugfix imuxsock: possible segfault when SysSock.Use="off"
  - bugfix: RainerScript: invalid ruleset names were accepted
  - bugfix: some module entry points were not called for all modules
  - bugfix omlibdbi: connection was taken down in wrong thread
  - imttcp was removed because it was an incompleted experimental module
  - pmrfc3164sd because it was a custom module nobody used
  - omoracle was removed because it was orphaned and did not build/work
    for quite some years and nobody was interested in fixing it
- includes changes from 8.5.0:
  - imfile greatly refactored and support for wildcards added
  - PRI-handling code refactored for more clarity and robustness
  - ommail: add support for RainerScript config system [action() object]
  - refactored the auto-backgrounding method
  - make gntls tcp syslog driver emit more error messages
  - bugfix: imfile did not complain if configured file did not exist
  - bugfix: build failure on systems which don't have json_tokener_errors
  - imgssapi: log remote peer address in some error messages
- includes changes from 8.4.3:
  - ommail: minor bugfixes & improvements
  - bugfix imkmsg: infinite loop on OpenVZ VMs
  - bugfix: typo in queue configuration parameter made parameter unusable
  - bugfix: unitialized buffer off-by-one error in hostname generation
  - bugfix imfile: segfault on startup in "inotify" mode
  - bugfix imfile: could make rsyslog exit in inotify mode
  - bugfix: rsgtutil sometimes crashed in verify mode if file did not exist
  - bugfix imklog: pri was miscalculated
  - bugfix: imjournal did not build properly
  - bugfix: mmcount did no longer build
  - bugfix imuxsock: possible segfault when SysSock.Use="off"
- rsyslog Version 8.5.0 fixed bsc#992146
* Thu Dec  4 2014 andreas.stieger@gmx.de
-  set file permissions only on first install [boo#899316]
* Wed Oct 22 2014 heinemannj66@gmail.com
- Changed BuildRequires dependencies for SLES11SP3
  - BuildRequires:  libjson-c-devel
  - BuildRequires:  libestr-devel
  - BuildRequires:  liblogging-devel
  - BuildRequires:  librelp-devel
  - BuildRequires:  libee-devel
  - BuildRequires:  liblognorm-devel
  - BuildRequires:  libuuid-devel
* Sat Oct 18 2014 ledest@gmail.com
- fix shebang of rsyslog-service-prepare script
* Sat Oct  4 2014 andreas.stieger@gmx.de
- rsyslog Version 8.4.2 [v8-stable] 2014-10-02 [bnc#899756]
  This release primarily contains a correction for the previous fix
  for the PRI vulnerability which was incomplete.
  - bugfix: the fix for CVE-2014-3634 did not handle all cases
    This is corrected now. see also: CVE-2014-3683
  - fixed a build problem on some platforms
  - behaviour change: "msg" of messages with invalid PRI set to
    "rawmsg"
* Wed Oct  1 2014 mt@suse.de
- Removed broken zpipe utility from diag-tools package (bnc#890228)
* Tue Sep 30 2014 mt@suse.de
- update to rsyslog 8.4.1 [v8-stable] 2014-09-30 (bnc#897262)
  - imudp: add for bracketing mode, which makes parsing stats easier
  - permit at-sign in variable names
    closes: https://github.com/rsyslog/rsyslog/issues/110
  - bugfix: fix syntax error in anon_cc_numbers.py script
    Thanks to github user anthcourtney for the patch.
    closes: https://github.com/rsyslog/rsyslog/issues/109
  - bugfix: ompgsql: don't loose uncomitted data on retry
    Thanks to Jared Johnson and Axel Rau for the patch.
  - bugfix: imfile: if a state file for a different file name was set,
    that different file (name) was monitored instead of the configured
    one. Now, the state file is deleted and the correct file monitored.
    closes: https://github.com/rsyslog/rsyslog/issues/103
  - bugfix: omudpspoof: source port was invalid
    Thanks to Pavel Levshin for the patch
  - bugfix: build failure on systems which don't have json_tokener_errors
    Older versions of json-c need to use a different API (which don't exists
    on newer versions, unfortunately...)
    Thanks to Thomas D. for reporting this problem.
  - bugfix: omelasticsearch does not work with broken/changed ES 1.0+ API
    closes: https://github.com/rsyslog/rsyslog/issues/104
  - bugfix: mmanon did not properly anonymize IP addresses starting with '9'
    Thanks to defa-at-so36.net for reporting this problem.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=529
  - bugfix: build problems on SuSe Linux
    Thanks Andreas Stieger for the patch
  - bugfix: omelasticsearch error file did not work correctly on ES 1.0+
    due to a breaking change in the ElasticSearch API.
    see also: https://github.com/rsyslog/rsyslog/issues/104
  - bugfix: potential abort when a message with PRI > 191 was processed
    if the "pri-text" property was used in active templates, this could
    be abused to a remote denial of service from permitted senders
    see also: CVE-2014-3634
- removed patches obsoleted by this version:
  [- rsyslog-8.4.0_implicit_declaration.patch,
  - rsyslog-8.4.0-json-c-0.12-configure.patch,
  - rsyslog-8.4.0-json-c-0.12.patch]
- adopted patch for modified rsyslog.service:
  [* rsyslog-unit.patch]
* Mon Sep 22 2014 andreas.stieger@gmx.de
- fix build with json-c 0.12 with upstream patch
  rsyslog-8.4.0-json-c-0.12.patch
- json-c provides a compatibility pkg-config for "json". Add
  rsyslog-8.4.0-json-c-0.12-configure.patch to check for the
  required function directly.
* Wed Sep 17 2014 wagner-thomas@gmx.at
- added firewall template file
* Fri Aug 22 2014 mt@suse.de
- Stop syslog.socket in %%preun to avoid the daemon we uninstall
  gets started by a log message due to dependencies (bnc#840815).
* Thu Aug 21 2014 mrueckert@suse.de
- reenable gssapi module
* Thu Aug 21 2014 mrueckert@suse.de
- rsyslog 8.4.0 [v8-stable]
  - this is the new stable branch, which incorporates all
    enhancements of rsyslog 8.3.
- rsyslog 8.3.5 [v8-devel] 2014-08-05
  - mmjsonparse: support selectable cookie and target containers
    This permits to put different meanings into a json formatted
    syslog message, e.g. the "traditional" cee or cim data.
  - bugfix: mmjsonparse did not build with json-c < 0.10 This was a
    regression introduced some time in the past in order to support
    API changes in json-c. Now we check for the - rsyslog and use
    proper code.
  - omprog: emit error message via syslog() if loading binary fails
    This happens after forking, so omprog has no longer access to
    rsyslog's regular error reporting functions. Previously, this
    meant any error message was lost. Now it is emitted via regular
    syslog (which may end up in a different instance, if multiple
    instances run...)
  - couple of patches imported from v7-stable (7.6.4)
- rsyslog 8.3.4 [v8-devel] 2014-07-11
  - new pmciscoios parser supporting various Cisco IOS formats
  - RFC3164 timestamp parser now accepts timezones and subsecond
    resolution ... at least for some common formats and where we
    could do so without running risk of breaking proper formats (or
    introducing regressions)
  - new parser config object -- permits to define custom parser
    definitions
  - new tzinfo config object -- permits to define time zone offsets
    This is a utility object that currently is being used by some
    parsers.
  - bugfix: mishandling of input modules not supporting new input
    instances If they did not support this, accidently the output
    module part of the module union was written, leading to
    unpredictable results. Note: all core modules do support this
    interface, but some contributed or very old ones do not.
  - bugfix: double-free when ruleset() parser parameters were used
    While unlikely, this could cause stability issues even after
    the config phase.
- rsyslog 8.3.3 [v8-devel] 2014-06-26
  - unify input object naming imudp now supports "name" paramter,
    as other inputs do. "inputname" has been deprecated, but can
    still be used. Same applies to "appendport" subparamter".
    Thanks to "Nick Syslog" for the suggestion.
  - made the missing (contributed) modules build under v8 [import
    from 8.2.2] Modules:
  * mmrfc5424addhmac omrabbitmq omgssapi omhdfs omzmq3
  - added a cleanup process (janitor); permits to close omfile
    files after a timeout
  - make omgssapi build under v8.3 [import vom v8.2] note that we
    could do this to the stable, because there is NO regression
    chance at all: only omgssapi was changed, and this module did
    NOT work previously.
  - removed obsolete --disable-fsstnd configure option Thanks to
    Thomas D. for alerting us.  Closes:
    https://github.com/rsyslog/rsyslog/issues/72
- rsyslog 8.3.2 [v8-devel] 2014-05-02
  - new template options for date extraction:
  - year
  - month
  - day
  - wday
  - hour
  - minute
  - second
  - tzoffshour
  - tzoffsmin
  - tzoffsdirection
  - wdayname For string templates, these are property options and
    they are prefixed with "date-" (e.g. "date-year",
    "date-month", ...) see also:
    https://github.com/rsyslog/rsyslog/issues/65
  - bugfix: mmexternal remove framing char before processing JSON
    reply This did not have any real bad effects, but caused
    unnecessary processing, as empty replies were not properly
    detected. Otherwise, the bug was not noticible from the user's
    PoV.
  - bugfix: mmexternal segfault due to invalid free in non-json
    input mode closes: https://github.com/rsyslog/rsyslog/issues/70
  - bugfix: mmexternal segfault when external plugin sent invalid
    reply ... or no reply at all. This happened if the reply was
    imporper JSON.  Now, we emit an error message in those cases.
    see also: https://github.com/rsyslog/rsyslog/issues/69
  - bugfix: mmexternal did potentially pass incomplete data to
    restarted external plugin This could happen if EPIPE was
    returned "too late", in which case the beginning of the data
    could be lost.
  - bugfix: mmexternal did not properly process messages over 4KiB
    The data to be passed to the external plugin was truncated
    after 4KiB.  see: https://github.com/rsyslog/rsyslog/issues/64
  - imrelp: added support for per-listener ruleset and inputname
    see: https://github.com/rsyslog/rsyslog/pull/63 Thanks to
    bobthesecurityguy github user for the patch
- rsyslog 8.3.1 [v8-devel] 2014-04-24
  - external message modification interface now support modifying
    message PRI
  - "jsonmesg" property will include uuid only if one was
    previously generated This is primarily a performance
    optimization. Whenever the message uuid is gotten, it is
    generated when not already present. As we used the regular
    setter, this means that always the uuid was generated, which is
    quite time-consuming. This has now been changed so that it only
    is generated if it already exists. That also matches more
    closly the semantics, as "jsonmesg" should not make
    modifications to the message.  Note that the same applies to
    "fulljson" passing mode for external plugins.
  - added plugin to rewrite message facility and/or severity Name:
    fac-sever-rewrite.py
  - permits to build against json-c 0.12 Unfortunately, json-c had
    an ABI breakage, so this is necessary. Note that - rsyslogs
    prior to 0.12 had security issues (CVE-2013-6370,
    CVE-2013-6371) and so it is desirable to link against the new -
    rsyslog.  Thanks to Thomas D. for the patch. Note that at least
    some distros have fixed the security issue in older - rsyslogs
    of json-c, so this seems to apply mostly when building from
    sources.
  - bugfix: using UUID property could cause segfault
  - bugfix/mmexternal: memory leak
  - bugfix: memory leak when using "jsonmesg" property
  - bugfix: mmutf8fix did not detect two invalid sequences Thanks
    to Axel Rau for the patch.
  - bugfix: build problems with lexer.l on some platforms For some
    reason, the strdup() prototype and others are missing. I admit
    that I don't know why, as this happens only in 8.3.0+ and there
    is no indication of changes to the affected files. In any case,
    we need to fix this, and the current solution works at least as
    an interim one.
- rsyslog 8.3.0 [v8-devel] 2014-04-10
  - new plugin for anonymizing credit card numbers Thanks to Peter
    Slavov for providing the code.
  - external message modification modules are now supported They
    are bound via the new native module "mmexternal". Also, a
    sample skeleton for an external python message modification
    module has been added.
  - new $jsonmesg property with JSON representation of whole
    message object closes:
    https://github.com/rsyslog/rsyslog/issues/19
  - improved error message for invalid field extraction in string
    template see also:
    http://kb.monitorware.com/problem-with-field-based-extraction-t12299.html
  - fix build problems on Solaris
  - NOTE: a json-c API that we begun to use requires the compiler
    to be in c99 mode. By default, we select it automatically. If
    you modify this and use gcc, be sure to include "-std=c99" in
    your compiler flags. This seems to be necessary only for older
  - rsyslogs of gcc.
- rsyslog 8.2.3 [v8-stable] 2014-??-??
  - bugfix: ommysql: handle/mem leak upon termination of worker
    thread This could become bad if the (instance) worker threads
    are often started and terminated. But it takes quite a while to
    show effect.
- added documentation tarball and also install the html
  documentation
  new subpackage rsyslog-doc
- drop rsyslog-pid-file.patch: patch is included in update
- added rsyslog-8.4.0_implicit_declaration.patch:
  include sys/time.h for gettimeofday
* Wed Jul 16 2014 jsegitz@suse.com
- Preliminary AppArmor support. Since those profiles need to be tested
  properly they'll live in /etc/apparmor/profiles/extras.
- Added rsyslog-pid-file.patch to fix a regression that causes the pid
  file to be created in /etc
* Wed Jun  4 2014 andreas.stieger@gmx.de
- rsyslog 8.2.2 [v8-stable]
  * made contributed modules build under v8
- add mmrfc5424addhmac, was removed in upgrade to v8-stable series
- fix warning about missing symlink
  /usr/sbin/rcrsyslog -> /usr/sbin/service
* Mon May 19 2014 mt@suse.com
- rpm: use _rundir rpm macro if defined (bnc#873857)
* Sat May 17 2014 heinemannj66@gmail.com
- adjust default configuration to address warning:
  "rsyslogd-2307: warning: ~ action is deprecated, consider using
  the 'stop' statement instead"
* Wed May 14 2014 heinemannj66@gmail.com
- rsyslog 8.2.1 [v8-stable]
  * permits to build against json-c 0.12
    Unfortunately, json-c had an ABI breakage, so this is necessary. Note
    that versions prior to 0.12 had security issues (CVE-2013-6370,
    CVE-2013-6371) and so it is desirable to link against the new version.
    Thanks to Thomas D. for the patch. Note that at least some distros
    have fixed the security issue in older versions of json-c, so this
    seems to apply mostly when building from sources.
  * doc is no longer shipped as part of the rsyslog tarball
    Instead, the rsyslog-doc project creates its own tarball. This is the
    result of a mailing list discussion after the 8.2.0 release with a
    tarball-in-tarball approach, which was disliked by almost all distro
    maintainers. This move also has the advantage of de-coupling the
    release cycles of both projects a bit (which turned out to be a bit
    problematic in practice).
  * bugfix: mmutf8fix did not detect two invalid sequences
* Wed May 14 2014 heinemannj66@gmail.com
- rsyslog 8.2.0 [v8-stable]
  This starts a new stable branch based on 8.1.6 plus the following changes:
  * we now use doc from the rsyslog-doc project
    As such, the ./doc subtree has been removed. Instead, a cache of the
    rsyslog-doc project's files has been included in ./rsyslog-doc.tar.gz.
    Note that the exact distribution mode for the doc is still under
    discussion and may change in future releases.
    This was agreed upon on the rsyslog mailing list. For doc issues
    and corrections, be sure to work with the rsyslog-doc project. It is
    currently hosted at https://github.com/rsyslog/rsyslog-doc
  * add support for specifying the liblogging-stdlog channel spec
    new global parameter "stdlog.channelspec"
  * add "defaultnetstreamdrivercertfile" global variable to set a default
    for the certfile.
  * omelasticsearch: add new "usehttps" parameter for secured connections
  * "action resumed" message now also specifies module type
    which makes troubleshooting a bit easier. Note that we cannot output all
    the config details (like destination etc) as this would require much more
    elaborate code changes, which we at least do not like to do in the
    stable version.
  * add capability to override GnuTLS path in build process
  * better and more consistent action naming, action queues now always
    contain the word "queue" after the action name
  * bugfix: ompipe did resume itself even when it was still in error
* Wed May 14 2014 heinemannj66@gmail.com
- rsyslog 7.6.4 [v7-stable]
  * removed obsolete --disable-fsstnd configure option
  * permits to build against json-c 0.12
  * new omfile default module parameters:
    filecreatemode
    fileowner
    fileownernum
    filegroup
    filegroupnum
    dirowner
    dirownernum
    dirgroup
    dirgroupnum
  * bugfix: using UUID property could cause segfault
  * bugfix: mmutf8fix did not detect two invalid sequences
* Thu Mar 27 2014 andreas.stieger@gmx.de
- rsyslog 7.6.3 [v7-stable]
  * add capability to override GnuTLS path in build process
  * support (and require) librelp 1.2.5
  * bugfix: ompipe used invalid default template
  * bugfix: ompipe did emit many suspension messages for /dev/xconsole
* Thu Mar 20 2014 andreas.stieger@gmx.de
- rsyslog 7.6.2 [v7.6-stable]
  major updates of the 7.6 series:
  * imrelp/omrelp now support TLS & (zip) compression
  * impstats is now emitting resource usage counters, can directly
    emit delta values and can now be bound to a ruleset
  * mmpstrucdata is a new module to parse RFC5424 structured data
    into JSON message properties
  * mmutf8fix is a new module to fix invalid UTF-8 sequences
  * mmsequence is a new module that helps with action load balancing
  * new defaults for main/ruleset queues to be more enterprise-like
- For specific version changelogs, see
  * http://www.rsyslog.com/changelog-for-7-6-0-v7-stable/
  * http://www.rsyslog.com/changelog-for-7-6-1-v7-stable/
  * http://www.rsyslog.com/changelog-for-7-6-2-v7-stable/
- packaging changes:
  * drop rsyslog-7.4.6-omelasticsearch-atomic-instructions-ppc.patch
    committed upstream
  * build with rfc3195 support
* Thu Mar 20 2014 andreas.stieger@gmx.de
- rsyslog 7.4.10:
  - bugfix: json templates are improperly created
  - ompgsql bugfix: improper handling of auto-backgrounding mode
- contains changes from 7.4.9:
  - added ProcessInternalMessages global system parameter
  - bugfix: imuxsock input parameters were not accepted
  - bugfix: potential double-free in RainerScript equal comparison
  - bugfix: some RainerScript Json(Variable)/string comparisons were wrong
* Tue Feb 11 2014 andreas.stieger@gmx.de
- use liblognorm0 transitional package in Factory to fix build
  until rsyslog is updated to support liblognorm >= 1.0.0
* Fri Jan 24 2014 mt@suse.de
- Added Restart=on-abort to rsyslog.service (fate#315133)
* Wed Jan  8 2014 andreas.stieger@gmx.de
- update to 7.4.8 [v7.4-stable]
  - rsgtutil provides better error messages on unfinished signature
    blocks
  - bugfix: guard against control characters in internal (error)
    messages
  - bugfix: immark did emit messages under kern.=info instead of
    syslog.=info Note that his can potentially break exisiting
    configurations that rely on immark sending as kern.=info.
* Wed Dec 11 2013 andreas.stieger@gmx.de
- update to 7.4.7 [v7.4-stable] [bnc#855058]
- bugfix: limiting queue disk space did not work properly
- bugfix: linux kernel-like ratelimiter did not work properly with all
  inputs (for example, it did not work with imdup).
- bugfix: disk queues created files in wrong working directory
- bugfix: legacy directive $ActionQueueWorkerThreads was not honored
- bugfix: segfault on startup when certain script constructs are used
  e.g. "if not $msg ..."
- bugfix: imuxsock: UseSysTimeStamp config parameter did not work correctly
- bugfix: $SystemLogUseSysTimeStamp/$SystemLogUsePIDFromSystem did not work
- improved checking of queue config parameters on startup
- bugfix: call to ruleset with async queue did not use the queue
- bugfix: if imtcp is loaded and no listeners are configured (which is
  uncommon), rsyslog crashes during shutdown.
* Wed Nov  6 2013 mt@suse.de
- Fixed to avoid rebuild rscryutil.1 rsgtutil.1 on SLE-11.
* Mon Nov  4 2013 andreas.stieger@gmx.de
- fix ppc build, add patch from upstream to fix build on platforms
  without atomic instructions
  rsyslog-7.4.6-omelasticsearch-atomic-instructions-ppc.patch
* Thu Oct 31 2013 andreas.stieger@gmx.de
- update to 7.4.6 [v7.4-stable] [bnc#848574]
- bugfix: potential abort during HUP
- bugfix: imtcp flowControl parameter incorrectly defaulted to "off"
- now requires libestr 0.1.9 for number handling in RainerScript
- bugfix: memory leak in strlen() RainerScript function
- bugfix: buffer overrun if re_extract function was called for submatch 50
- bugfix: memleak in re_extract() function
- bugfix: potential abort in RainerScript optimizer
- bugfix: memory leak in omhiredis
- bugfix: segfault if variable was assigned to non-container subtree
* Mon Oct 28 2013 andreas.stieger@gmx.de
- update to 7.4.5 [v7.4-stable]
- mmanon: removed the check for specific "terminator characters"
- now requires libestr 0.1.8
- omelasticsearch: add failed.httprequests stats counter
- bugfix: invalid property filter was not properly disabled in ruleset
- bugfix: segfault if re_extract() function was used and no match found
- bugfix: potential misadressing on startup if property-filter was used
- bugfix: omelasticsearch: correct failed.http stats counter
- bugfix: omelasticsearch: did not correctly initialize stats counters
- bugfix: omelasticsearch: failed.es counter was only maintained in bulk mode
- bugfix: mmanon did not detect all IP addresses in rewrite mode
- bugfix: mmanon sometimes used invalid replacement char in simple mode
- bugfix: memory leak in mmnormalize
- bugfix: array-based ==/!= comparisions lead to invalid results
- bugfix: omprog blocked signals to executed programs
- bugfix: doc: imuxsock legacy param $SystemLogSocketParseTrusted was
  misspelled
- bugfix: imfile "facility" input parameter improperly handled
- bugfix: small memory leak in imfile when $ResetConfigVariables was used
- bugfix: segfault on startup if TLS was used but no CA cert set
- bugfix: segfault on startup if TCP TLS was used but no cert or key set
- bugfix: some more build problems with newer json-c versions
- bugfix: build system: libgcrypt.h needed even if libgrcypt was disabled
* Thu Sep 12 2013 andreas.stieger@gmx.de
- update to 7.4.4 [v7.4-stable]
- better error messages in GuardTime signature provider
- make rsyslog use the new json-c pkgconfig file if available
- bugfix: imfile parameter "persistStateInterval" was unusable
  due to a case typo in imfile; work-around was to use legacy config
- bugfix: TLV16 flag encoding error in signature files from GT provider
  This fixes a problem where the TLV16 flag was improperly encoded.
  Unfortunately, existing files already have the bug and may not properly
  be processed. The fix uses constants from the GuardTime API lib to
  prevent such problems in the future.
- bugfix: slightly malformed SMTP handling in ommail
- bugfix: segfault in omprog if no template was provided (now dflt is used)
- bugfix: segfault in ompipe if no template was provided (now dflt is used)
- bugfix: segfault in omsnmp if no template was provided (now dflt is used)
- bugfix: some omsnmp optional config params were flagged as mandatory
- bugfix: segfault in omelasticsearch when resuming queued messages
  after restarting Elasticsearch
- bugfix: imtcp addtlframedelimiter could not be set to zero
- doc bugfix: remove no-longer existing omtemplate from developer doc
  was specifically mentioned as a sample for creating new plugins
* Sat Jul 20 2013 andreas.stieger@gmx.de
- update to 7.4.3 [v7.4-stable]
  - bugfix: memory leak if disk queues were used and json data
    rresent
  - bugfix: CEE/json data was lost during disk queue operation
  - bugfix: potential segfault during startup on invalid config
  - bugfix: 100%% CPU utilization when DA queue became full
  - bugfix: omlibdbi did not properly close connection on some
    errors
  - cosmetic bugfix: file name buffer was not freed on disk queue
    destruction
* Fri Jul  5 2013 mt@suse.de
- Update to 7.4.2  [v7.4-stable] (bnc#828140,CVE-2013-4758):
  - bugfix: in RFC5425 TLS, multiple wildcards in auth could cause
    segfault
  - bugfix: RainerScript object required parameters were not properly
    checked - this clould result to segfaults on startup if parameters
    were missing.
  - bugfix: double-free in omelasticsearch
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=461
    a security advisory for this bug is available at:
    http://www.lsexperts.de/advisories/lse-2013-07-03.txt
    PLEASE NOTE: This issue only existed if omelasticsearch was used
    in a non-default configuration, where the "errorfile" parameter
    was specified. Without that parameter set, the bug could not be
    triggered. Thanks to Markus Vervier and Marius Ionescu for providing
    a detailled bug report. Special thanks to Markus for coordinating
    his security advisory with us.
  - bugfix: omrelp potential segfault at startup on invalid config
    parameters
  - bugfix: small memory leak when $uptime property was used
  - bugfix: potential segfault on rsyslog termination in imudp
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=456
  - bugfix: lmsig_gt abort on invalid configuration parameters
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=448
    Thanks to Risto Laanoja for the patch.
  - imtcp: fix typo in "listner" parameter, which is "listener"
    Currently, both names are accepted.
  - solved build problems on FreeBSD
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=457
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=458
    Thanks to Christiano for reproting and suggesting patches
  - solved build problems on CENTOS5
* Wed Jun 26 2013 mt@suse.de
- Use --enable-cached-man-pages configure option on SLES-11, where
  rst2man is not available and removed prebuilt man pages.
* Sat Jun 22 2013 andreas.stieger@gmx.de
- update to 7.4.1  [v7.4-stable]:
  - imjournal: add ratelimiting capability
  - bugfix imzmq3: potential segfault on startup
- includes changes from 7.4.0  [v7.4-stable]:
  - doc bugfix: ReadMode wrong in imfile doc, two values were swapped
  - imjournal: no longer do periodic wakeup
  - bugfix: potential hang *in debug mode* on rsyslogd termination
  - bugfix: $template statement with multiple spaces lead to invalid tpl name
  - 0mq fixes
- includes changes from version 7.3.15
  - bugfix: problem in build system (especially when cross-compiling)
  - bugfix: imjournal had problem with systemd journal API change
  - imjournal: now obtain and include PID
  - bugfix: .logsig files had tlv16 indicator bit at wrong offset
  - bugfix: omrelp legacy config parameters set a timeout of zero
    which lead the legacy config to be unusable.
  - bugfix: segfault on startup if a disk queue was configure without file
    name
  - bugfix: invalid addressing in string class (recent regression)
- packaging changes:
  - rebase rsyslog-unit.patch
  - move libee/liblognorm dependencies to mmnormalize conditional
* Fri Jun 14 2013 crrodriguez@opensuse.org
- Required version of pkgconfig(relp) is >= 1.0.3
- Requires version of libsystemd-journal is >= 197
- Notify systemd on sucessful startup of the daemon to avoid
  confusing behaviour such as :
  http://lists.opensuse.org/opensuse/2013-06/msg00603.html
* Mon May 13 2013 mt@suse.de
- Fixed SLES-11 build that does not have rst2man/python-docutils;
  added pre-built rscryutil.1 and rsgtutil.1 as sources because
  v7.3.14 does not ship them pre-built any more.
* Tue May  7 2013 mt@suse.de
- update to 7.3.14 [beta] 2013-05-06:
  - bugfix: some man pages were not properly installed either
    rscryutil or rsgtutil man was installed, but not both.
    Thanks to Marius Tomaschewski for the patch.
  - bugfix: potential segfault on startup when builtin module was
    specified in module() statement.
    Thanks to Marius Tomaschewski for reporting the bug.
  - bugfix: segfault due to invalid dynafile cache handling
    Accidently, the old-style cache size parameter was used when the
    dynafile cache was created in a RainerScript action. If the
    old-style size was lower than the one actually set, this lead to
    misadressing when the size was overrun, and that could lead to
    all kinds of “interesting things”, often in segfaults.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=440
* Tue Apr 30 2013 mt@suse.de
- Adopted config file to stop instead of deprecated "~" action.
* Tue Apr 30 2013 mt@suse.de
- Enabled log file signing module lmsig_gt using GuardTime as
  separate rsyslog-module-guardtime package.
- Moved previously enabled log file encryption module lmcry_gcry
  and its utility into a separate rsyslog-module-gcrypt package.
* Tue Apr 30 2013 mt@suse.de
- update to 7.3.13  [beta] 2013-04-29:
  - added omrabbitmq module (contributed, untested)
    Note: this is unsupported and as such was moved immediately
    into the beta version.
    Thanks to Vaclav Tomec for providing this module.
  - bugfix: build problem when –enable-encryption was not selected
    Thanks to Michael Biebl for fixing this.
  - doc bugfix: omfile parameter “VeryRobustZip” was documentas as
    “VeryReliableZip”
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=437
    Thanks to Thomas Doll for reporting this.
- update to 7.3.12  [devel] 2013-04-25:
  - added doc for omelasticsearch
    Thanks to Radu Gheorghe for the doc contribution.
  - omelasticsearch: _id field support for bulk operations
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=392
    Thanks to Jérôme Renard for the idea and patches.
  - max number of templates for plugin use has been increased to five
  - platform compatibility enhancement: solve compile issue with
    libgcrypt do not use GCRY_CIPHER_MODE_AESWRAP where not available
    fix compile on Solaris
    Thanks to Martin Carpenter for the patch.
  - bugfix: off-by-one error in handling local FQDN name (regression)
    A remporary buffer was allocated one byte too small. Did only
    affect startup, not actual operations. Came up during routine tests,
    and can have no effect once the engine runs. Introduced in 7.3.11.
  - bugfix: build problems on Solaris
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=436
  - bugfix: block size limit was not properly honored
  - bugfix: potential segfault in guardtime signature provider
    it could segfault if an error was reported by the GuardTime API,
    because an invalid free could happen then
- update to 7.3.11  [devel] 2013-04-23
  - added support for encrypting log files (lmcry_gcry plugin)
  - omhiredis: added support for redis pipeline support
    Thanks to Brian Knox for the patch.
  - bugfix:  $PreserveFQDN is not properly working
    Thanks to Louis Bouchard for the patch
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=426
  - bugfix: imuxsock aborted due to problem in ratelimiting code
    Thanks to Tomas Heinrich for the patch.
  - bugfix: imuxsock aborted under some conditions regression from
    ratelimiting enhancements – this was a different one to the one
    Tomas Heinrich patched.
  - bugfix: timestamp problems in imkmsg
- Enabled systemd imjournal,omjournal modules on > 12.3.
- Enabled mmanon, providing anonymization support
- Enabled lmcry_gcry.so, providing log file encryption support
  and the rscryutil utility to manage the encrypted log files.
- Removed obsolete --enable-pthreads configure option.
* Fri Apr 19 2013 andreas.stieger@gmx.de
- rsyslogd.conf removed from upstream tarball, no longer install as
  documentation.
- build requirement for libestr is >= 0.1.5
* Fri Apr 19 2013 mt@suse.de
- update to 7.2.7 [v7-stable] 2013-04-17:
  - rsyslogd startup information is now properly conveyed back to init
    when privileges are beging dropped. Actually, we have moved
    termination of the parent in front of the priv drop. So it shall
    work now in all cases. See code comments in commit for more details.
  - If forking, the parent now waits for a maximum of 60 seconds for
    termination by the child
  - improved debugging support in forked (auto-backgrounding) mode.
    The rsyslog debug log file is now continued to be written across the
    fork.
  - updated systemd files to match current systemd source
  - bugfix: failover/action suspend did not work correctly
    This was experienced if the retry action took more than one second
    to complete. For suspending, a cached timestamp was used, and if the
    retry took longer, that timestamp was already in the past. As a
    result, the action never was kept in suspended state, and as such no
    failover happened. The suspend functionalit now does no longer use
    the cached timestamp (should not have any performance implication,
    as action suspend occurs very infrequently).
  - bugfix: nested if/prifilt conditions did not work properly
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=415
  - bugfix: script == comparison did not work properly on JSON objects
    [backport from 7.3 branch]
  - bugfix: imudp scheduling parameters did affect main thread, not imudp
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=409
  - bugfix: imuxsock rate-limiting could not be configured via legacy conf
    Rate-limiting for the system socket could not be configured via legacy
    configuration directives. However, the new-style RainerScript config
    options worked.
    Thanks to Milan Bartos for the patch.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=390
  - bugfix: using group resolution could lead to endless loop
    Thanks to Tomas Heinrich for the patch.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=310
  - bugfix: $mmnormalizeuseramsg paramter was specified with wrong type
    Thank to Renzhong Zhang for alerting us of the problem.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=420
  - bugfix: RainerScript getenv() function caused segfault when var was
    not found.
    Thanks to Philippe Muller for the patch.
  - bugfix: several issues in imkmsg
    see bug tracker: http://bugzilla.adiscon.com/show_bug.cgi?id=421#c8
  - bugfix: imuxsock was missing SysSock.ParseTrusted module parameter
    To use that functionality, legacy rsyslog.conf syntax had to be used.
    Also, the doc was missing information on the "ParseTrusted" set of
    config directives.
  - bugfix: parameter action.execOnlyWhenPreviousIsSuspended was
    accidently of integer-type. For obvious reasons, it needs to be
    boolean. Note that this change can break existing configurations
    if they circumvented the problem by using 0/1 values.
  - doc bugfix: rsyslog.conf man page had invalid file format info
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=418
- update to 7.2.6 [v7-stable] 2013-03-05:
  - slightly improved config parser error messages when invalid escapes
    happen
  - bugfix: include files got included in the wrong order
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=411
    This happens if an $IncludeConfig directive was done on multiple
    files (e.g. the distro default of $IncludeConfig /etc/rsyslog.d/*.conf).
    In that case, the order of include file processing is reversed, which
    could lead to all sorts of problems.
    Thanks to Nathan Stratton Treadway for his great analysis of the
    problem, which made bug fixing really easy.
  - bugfix: omelasticsearch failed when authentication data was provided
    ... at least in most cases it emitted an error message:
    "snprintf failed when trying to build auth string"
    Thanks to Joerg Heinemann for alerting us.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=404
  - bugfix: some property-based filter were incorrectly parsed
    This usually lead to a syntax error on startup and rsyslogd not actually
    starting up. The problem was the regex, which did not care for double
    quote characters to follow in the action part - unfortunately something
    that can frequently happen with v6+ format. An example:
    :programname, isequal, "as" {action(type="omfile" ...) }
    Here, the part
    :programname, isequal, "as" {action(type="omfile"
    was treated as the property filter, and the rest as action part.
    Obviously, this did not work out. Unfortunately, such situations usually
    resulted in very hard to understand error messages.
* Tue Apr 16 2013 mt@suse.de
- Fixed service file to pass $RSYSLOGD_PARAMS to rsyslogd again.
* Sun Apr 14 2013 crrodriguez@opensuse.org
- Fix systemd units to do exactly what is documented as
  required --> http://www.freedesktop.org/wiki/Software/systemd/syslog
  In particular, it must not mess with the ordering of syslog.target
  this is done by removing the custom unit and adapting the upstream
  one with openSUSE additions (rsyslog-unit.patch)
* Fri Mar 29 2013 vcizek@suse.com
- restore SELinux label when creating xconsole (bnc#812447)
* Tue Feb 19 2013 mt@suse.de
- Fixed rsyslog.service file to support reload (bnc#803994)
* Tue Jan 15 2013 mt@suse.de
- Fixed relp build requires change, which broke SLE-11 build.
* Mon Jan 14 2013 andreas.stieger@gmx.de
- update to 7.2.5 [v7-stable]:
  - build system cleanup
  - bugfix: omelasticsearch did not properly compile on some platforms
    due to missing libmath
  - bugfix: on termination, actions were incorrectly called
  - bugfix: very large memory consumption (and probably out of memory) when
    FromPos was specified in template, but ToPos not.
  - bugfix: timeval2syslogTime cause problems on some platforms
    due to invalid assumption on structure data types.
  - bugfix: compile errors in im3195
  - bugfix: doGetFileCreateMode() had invalid validity check
  - bugfix: mmjsonparse errornously returned action error when no
    CEE cookie was present.
* Wed Jan  9 2013 mt@suse.com
- Enable rsyslog.service and create the syslog.service alias link
  in post install -- regardless of a preset config (bnc#790805).
- Check the existence of /etc/init.d/syslog script before calling
  the restart_on_update and stop_on_removal macros to avoid errors
  on update. Since openSUSE 12.3, no syslog init script is shipped
  (bnc#790298,bnc#750478).
* Mon Jan  7 2013 mt@suse.com
- Update to 7.2.4 [v7-stable] with following changes:
  - enhance: permit RFC3339 timestamp in local log socket messages
    Thanks to Sebastien Ponce for the patch.
  - imklog: added ParseKernelTimestamp parameter (import from 5.10.2)
    Thanks to Marius Tomaschewski for the patch.
  - fix missing functionality: ruleset(){} could not specify ruleset queue
    The "queue.xxx" parameter set was not supported, and legacy ruleset
    config statements did not work (by intention). The fix introduces the
    "queue.xxx" parameter set. It has some regression potential, but only
    for the new functionality. Note that using that interface it is possible
    to specify duplicate queue file names, which will cause trouble. This
    will be solved in v7.3, because there is a too-large regression
    potential for the v7.2 stable branch.
  - imklog: added KeepKernelTimestamp parameter (import from 5.10.2)
    Thanks to Marius Tomaschewski for the patch.
  - bugfix: imklog mistakenly took kernel timestamp subseconds as nanoseconds
    ... actually, they are microseconds. So the fractional part of the
    timestamp was not properly formatted. (import from 5.10.2)
    Thanks to Marius Tomaschewski for the bug report and the patch idea.
  - bugfix: supportoctetcountedframing parameter did not work in imptcp
  - bugfix: modules not (yet) supporting new conf format were not properly
    registered. This lead to a "module not found" error message instead of
    the to-be-expected "module does not support new style" error message.
    That invalid error message could be quite misleading and actually stop
    people from addressing the real problem (aka "go nuts" ;))
  - bugfix: template "type" parameter is mandatory (but was not)
  - bugfix: some message properties could be garbled due to race condition
    This happened only on very high volume systems, if the same message was
    being processed by two different actions. This was a regression caused
    by the new config processor, which did no longer properly enable msg
    locking in multithreaded cases. The bugfix is actually a refactoring of
    the msg locking code - we no longer do unlocked operations, as the use
    case for it has mostly gone away. It is potentially possible only at
    very low-end systems, and there the small additional overhead of doing
    the locking does not really hurt. Instead, the removal of that
    capability can actually slightly improve performance in common cases,
    as the code path is smaller and requires slightly less memory writes.
    That probably outperforms the extra locking overhead (which in the
    low-end case always happens in user space, without need for kernel
    support as we can always directly aquire the lock - there is no
    contention at all).
- Removed imklog-kernel-timestamp-parsing (bnc#783967) patch obsoleted
  by this version.
* Fri Nov 23 2012 mrueckert@suse.de
- fix zeromq support
* Fri Nov 23 2012 mrueckert@suse.de
- fix hiredis support
* Thu Nov 22 2012 mrueckert@suse.de
- enabled elastic search support (build enabled by default):
  - > new buildrequires curl devel
  - > new subpackage rsyslog-module-elasticsearch
- added --enable-unlimited-select
- added --enable-imttcp:
  - > this module is packaged in the main package as it has no
    new dependencies
- added --enable-imdiag
  - > this module is packaged in the diag package
- prepared adding support for hiredis, hdfs, mongodb and zeromq
* Thu Nov 22 2012 mt@suse.com
- Update to 7.2.3 (v7-stable) a release providing following fixes:
  - regression fix: rsyslogd terminated when wild-card $IncludeConfig did not
    find actual include files. For example, if this directive is present:
    $IncludeConfig /etc/rsyslog.d/*.conf
    and there are no *.conf files in /etc/rsyslog.d (but rsyslog.d exists),
    rsyslogd will emit an error message and terminate. Previous (and expected)
    behaviour is that an empty file set is no problem. HOWEVER, if the
    directory itself does not exist, this is flagged as an error and will
    load to termination (no startup).
    Unfortunately, this is often the case by default in many distros, so this
    actually prevents rsyslog startup.
  - doc improvements
  - enabled to build without libuuid, at loss of uuid functionality
    this enables smoother builds on older systems that do not support
    libuuid. Loss of functionality should usually not matter too much as
    uuid support has only recently been added and is very seldom used.
  - bugfix: omfwd did not properly support "template" parameter
  - bugfix: potential segfault when re_match() function was used
    Thanks to oxpa for the patch.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=371
  - bugfix: potential abort of imtcp on rsyslogd shutdown
  - bugfix: imzmq3 segfault with PULL subscription
    Thanks to Martin Nilsson for the patch.
  - bugfix: improper handling of backslash in string-type template()s
  - bugfix: leading quote (") in string-type template() lead to thight loop
    on startup
  - bugfix: no error msg on invalid field option in legacy/string template
  - bugfix: potential segfault due to invalid param handling in comparisons
    This could happen in RainerScript comparisons (like contains); in some
    cases an unitialized variable was accessed, which could lead to an
    invalid free and in turn to a segfault.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=372
    Thanks to Georgi Georgiev for reporting this bug and his great help
    in solving it.
  - bugfix: no error msg on unreadable $IncludeConfig path
  - bugfix: $IncludeConfig did not correctly process directories
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=376
    The testbench was also enhanced to check for these cases.
    Thanks to Georgi Georgiev for the bug report.
  - bugfix: make rsyslog compile on kfreebsd again
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=380
    Thanks to Guillem Jover for the patch.
  - bugfix: garbled message if field name was used with jsonf property option
    The length for the field name was invalidly computed, resulting in either
    truncated field names or including extra random data. If the random data
    contained NULs, the rest of the message became unreadable.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=374
  - bugfix: potential segfault at startup with property-based filter
    If the property name was followed by a space before the comma, rsyslogd
    aborted on startup. Note that no segfault could happen if the initial
    startup went well (this was a problem with the config parser).
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=381
  - bugfix: imfile discarded some file parts
    File lines that were incomplete (LF missing) *at the time imfile polled
    the file* were partially discarded. That part of the line that was read
    without the LF was discarded, and the rest of the line was submitted in
    the next polling cycle. This is now changed so that the partial content
    is saved until the complete line is read. Note that the patch affects
    only read mode 0.
    Thanks to Milan Bartos for providing the base idea for the solution.
- Merged also fixes for unreliable kernel timestamp regression (bnc#783967),
  which will be picked up in a later v7-stable release:
  - imklog: added $klogParseKernelTimestamp option (default off),
    wich reverts to the 5.8.x behavior to use receive time for the
    kernel messages instead to try parse and convert the kernel
    timestamp, what is not reliable on some hardware (intel i7/Xeon).
  - imklog: added $klogKeepKernelTimestamp option (default off),
    causing to not remove the kernel timestamp from the message
    after a successful conversion.
  - imklog: fixed a conversion bug causing a <1sec incorrectness
    of the message time when the kernel timestamp is parsed.
- Removed {} arround RSYSLOG_PARAMS variable in service file. systemd
  seems sometimes to not like it any more (bnc#788330).
* Tue Nov 20 2012 mt@suse.com
- Require syslog-service >= 2.0 on 12.3, otherwise < 2.0, which
  contain the /etc/init.d/syslog init script.
* Tue Nov 13 2012 mt@suse.com
- imuxsock: do not log EAGAIN in nonblocking recvfrom (bnc#734672)
* Mon Nov 12 2012 mt@suse.com
- Removed handling of the -c <compat version> option which is
  obsolete in rsyslog-7.x.
- Fixed build requires / deps to work on 12.x and SLE-11-SP2.
- Initialized RSYSLOG_PARAMS env variable in service file.
- Marked additional log socket config as ghost.
* Fri Nov  9 2012 mt@suse.com
- Readded things removed in previous change, that is compat version
  and params variable use, generation of additional (chroot) log
  sockets include file, xconsole handling in rsyslog.service.
- Fixed liblognorm conditional build flag dependencies, removed all
  suse version dependencies.
- Changed to install in /usr/sbin, compatibility link in /sbin.
- Added klogd to build conflicts to resolve build service deps
* Tue Nov  6 2012 tittiatcoke@gmail.com
- Enabled rsyslog own systemd service file. This to resolve the
  current issue with a non starting system logger with systemd 185.
  (see also bnc#788330)
* Mon Oct 29 2012 mt@suse.com
- Update to 7.2.1 (v7-stable), a pure bug-fixing release:
  - bugfix: ruleset()-object did only support a single statement
  - added -D rsyslogd option to enable config parser debug mode
  - improved syntax error messages by outputting the error token
  - the rsyslog core now suspeneds actions after 10 failures in
    a row. This was former the case after 1,000 failures and could
    cause rsyslog to be spammed/ressources misused.
    See the v6 compatibility doc for more details.
  - ommongodb rate-limits error messages to prevent spamming the
    syslog closes (for v7.2):
    http://bugzilla.adiscon.com/show_bug.cgi?id=366
- Enabled compilation of kmsg, the kernel’s new structured logging
  system modile, mmaudit the message modification module supporting
  Linux audit format and mmjsonparse providing the cee-enhanced
  syslog format support message modification module.
* Wed Oct 24 2012 mt@suse.com
- Update to 7.2.0 (v7-stable) a full structured-logging/CEE enabled
  version which provides following features compared to v5-stable:
  * greatly improved configuration language – the new language is
    much more intuitive than the legacy format. It will also prevent
    some typical mistakes simply be not permitting these invalid
    constructs. Note that legacy format is still fully supported
    (and you can of course do the same mistakes if you use legacy
    format).
  * greatly improved execution engine – with nested if/then/else
    constructs as well as the capability to modify variables during
    processing.
  * full support for structured logging and project lumberjack/CEE.
    this includes everything from being able to create, interpret
    and handle JSON-based structured log messages, including the
    ability to normalize legacy text log messages.
  * more plugins – like support for MongoDB, HDFS, and ElasticSearch
    as well as for the kernel’s new structured logging system.
  * higher performance – many optimizations all over the code, like
    5 to 10 times faster execution time for script-based filters,
    enhanced multithreaded TCP input plugin, DNS cache and many more.
* Wed Oct 17 2012 fcrozat@suse.com
- Fix build with new systemd location.
* Wed Oct 17 2012 mt@suse.com
- Use RFC-5424 conform log format with RFC-3339 high-precision
  timestamps by default, removed obsolete rsyslog.early.conf.
* Mon Sep 24 2012 andreas.stieger@gmx.de
- prevent installation with other providers of syslog (bnc#780608)
* Fri Sep 21 2012 mt@suse.com
- Changed default /etc/rsyslog.conf we install to not use multiple
  facilities with the same priority pattern in one statement using
  the comma operator. This started to cause a start failure with
  rsyslog-6.4.x (bnc#780607) and seems to be a bug in rsyslog.
  Upstream report http://bugzilla.adiscon.com/show_bug.cgi?id=358,
  switched to use alternative syntax using semicolon separator.
* Thu Sep 20 2012 andreas.stieger@gmx.de
- update to 6.4.2  [V6-STABLE] 2012-09-20:
  - bugfix: potential abort, if action queue could not be properly
    started
  - bugfix: remove invalid socket option call from imuxsock
  - bugfix: missing support for escape sequences in RainerScript
  - bugfix: config validation run did not always return correct
    return state
* Thu Sep 20 2012 andreas.stieger@gmx.de
- add rsyslog-6.4.1-CheckConnection-no-return-in-nonvoid-function.patch
  to fix rsyslog no-return-in-nonvoid-function netstrm.c:258 in
  CheckConnection()
* Mon Sep 17 2012 mt@suse.com
- Update to 6.4.1  [V6-STABLE] 2012-09-06:
  - bugfix: multiple main queues with same queue file name were not
    detected.  This lead to queue file corruption. While the root
    cause is a config error, it is a bug that this important and
    hard to find config error was not detected by rsyslog.
  - bugfix: “jsonf” property replacer option did generate invalid
    JSON in JSON, we have “fieldname”:”value”, but the option
    emitted “fieldname”=”value”. Interestingly, this was accepted
    by a couple of sinks, most importantly elasticsearch. Now the
    correct format is emitted, which causes a remote chance that
    some things that relied on the wrong format will break.
    Thanks to Miloslav Trmač for the patch
  - change $!all-json did emit an empty (thus non-JSON) string if
    no libee data was present. It now emits {} and thus valid JSON.
    There is a small risk that this may break some things that
    relied on the previous inconsistency. Thanks to Miloslav Trmač
    for the patch
  - bugfix: omusrsmsg incorrect return state & config warning
    handling. During config file processing, Omusrmsg often
    incorrectly returned a warning status, even when no warning was
    present (caused by uninitialized variable). Also, the core
    handled warning messages incorrectly, and treated them as
    errors. As a result, omusrmsg (most often) could not properly be
    loaded. Note that this only occurs with legacy config action
    syntax. This was a regression caused by an incorrect merge in to
    the 6.3.x codebase.
    Thanks to Stefano Mason for alerting us of this bug.
  - bugfix: Fixed TCP CheckConnection handling in omfwd.c. Interface
    needed to be changed in lower stream classes. Syslog TCP Sending
    is now resumed properly. Unfixed, that lead to non-detection of
    downstate of remote hosts.
* Tue Sep  4 2012 andreas.stieger@gmx.de
- License is (GPL-3.0+ and Apache-2.0), [bnc#778591]
- The template subpackage was never published, remove obsoletes
* Fri Aug 31 2012 andreas.stieger@gmx.de
- update to 6.4.0 [BETA] 2012-08-20
  This is the first version of the 6.4.0 stable branch.
  http://www.rsyslog.com/changelog/
- add rsyslog-6.3.11-glblCheckCnf-no-return-in-nonvoid-function.patch
  to fix compiler warning
- rsyslog-6.2.2-link-libestr.patch no longer required
- template functionality was removed upstream
* Mon Aug 27 2012 andreas.stieger@gmx.de
- add support for mmnormalize (via liblognorm) and template modules
* Tue Jul  3 2012 andreas.stieger@gmx.de
- update to 6.2.2 [V6-stable] 2012-06-13
  http://www.rsyslog.com/changelog-for-6-2-2-v6-stable/
- add rsyslog-6.2.2-link-libestr.patch to correctly link against
  libestr
* Sun Jul  1 2012 andreas.stieger@gmx.de
- updated to 5.8.12  [V5-stable] 2012-06-06
  - add small delay (50ms) after sending shutdown message
  - support for resolving huge groups
  - bugfix: delayble source could block action queue, even if there was
  - bugfix: disk queue was not persisted on shutdown, regression of fix to
  - bugfix/omudpspoof: problems, including abort, happend when run on
  - bugfix: if debug message could end up in log file when forking
  - bugfix/tcpflood: sending small test files did not work correctly
  - bugfix: potential hang due to mutex deadlock
  - bugfix: property PROCID empty instead of proper nilvalue if not present
* Mon May  7 2012 mt@suse.com
- Updated to 5.8.11 [V5-stable] 2012-05-03:
  - bugfix: ommysql did not properly init/exit the mysql runtime
    library this could lead to segfaults. Triggering condition:
    multiple action instances using ommysql. Thanks to Tomas
    Heinrich for reporting this problem and providing an initial
    patch (which my solution is based on, I need to add more code
    to clean the mess up).
  - bugfix: rsyslog did not terminate when delayable inputs were
    blocked due to unvailable sources. Fixes:
    http://bugzilla.adiscon.com/show_bug.cgi?id=299
    Thanks to Marcin M for bringing up this problem and Andre
    Lorbach for helping to reproduce and fix it.
  - bugfix: active input in “light delay state” could block
    rsyslog termination, at least for prolonged period of time
  - bugfix: imptcp input name could not be set. Config directive
    was accepted, but had no effect
    bugfix: assigned ruleset was lost when using disk queues
    This looked quite hard to diagnose for disk-assisted queues,
    as the pure memory part worked well, but ruleset info was lost
    for messages stored inside the disk queue.
  - bugfix: hostname was not requeried on HUP
    Thanks to Per Jessen for reporting this bug and Marius
    Tomaschewski for his help in testing the fix.
  - bugfix: inside queue.c, some thread cancel states were not
    correctly reset. While this is a bug, we assume it did have
    no practical effect because the reset as it was done was set
    to the state the code actually had at this point. But better
    fix this…
- Removed obsolete requery hostname patch
* Thu Apr 12 2012 mt@suse.com
- Added upstream patchset to requery hostname on HUP (bnc#755857)
- Removed obsolete rsyslog-5.8.7-systemd-log-socket.patch
- Updated to 5.8.10  [V5-stable] 2012-04-05:
  - bugfix: segfault on startup if $actionqueuefilename was missing
    for disk queue config. Thanks to Tomas Heinrich for the patch.
  - bugfix: segfault if disk-queue was started up with old queue file
    Thanks to Tomas Heinrich for the patch.
  - bugfix: memory leak in array passing output module mode
  by 5.8.9 [V5-stable] 2012-03-15:
  - added tool to recover disk queue if .qi file is missing
    (recover_qi.pl)
    Thanks to Kaiwang Chen for contributing this tool
  - bugfix: stopped DA queue was never processed after a restart
    due to a regression from statistics module.
  - added better doc for statsobj interface.
    Thanks to Kaiwang Chen for his suggestions and analysis in
    regard to the stats subsystem.
  by 5.8.8  [V5-stable] 2012-03-05:
  - bugfix: omprog made rsyslog abort on startup if not binary to
    execute was configured
  - bugfix: imklog invalidly computed facility and severity
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=313
    improves interop with systemd journal
* Mon Feb 20 2012 mt@suse.com
- Detect if we have to use the new /run/systemd/journal/syslog
  socket instead of the /dev/log under newer systemd versions.
  Obsoletes listen.conf installed by systemd (bnc#747871).
- updated to 5.8.7 [V5-stable]:
  - bugfix: instabilities when using RFC5424 header fields
    Thanks to Kaiwang Chen for the patch
  - bugfix: imuxsock did truncate part of received message if it did
    not contain a proper date. The truncation occured because we
    removed that part of the messages that was expected to be the date.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=295
  - bugfix: potential abort after reading invalid X.509 certificate
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=290
    Thanks to Tomas Heinrich for the patch
  - bugfix: stats counter were not properly initialized on creation
  - FQDN hostname for multihomed host was not always set to the correct
    name if multiple aliases existed. Thanks to Tomas Heinreich for the
    patch.
- updated to 5.8.6 [V5-stable]:
  - bugfix: missing whitespace after property-based filter was not
    detected
  - bugfix: $OMFileFlushInterval period was doubled - now using correct
    value
  - bugfix: ActionQueue could malfunction due to index error
    Thanks to Vlad Grigorescu for the patch
  - bugfix: $ActionExecOnlyOnce interval did not work properly
    Thanks to Tomas Heinrich for the patch
  - bugfix: race condition when extracting program name, APPNAME,
    structured data and PROCID (RFC5424 fields) could lead to invalid
    characters e.g. in dynamic file names or during forwarding (general
    malfunction ofthese fields in templates, mostly under heavy load)
  - bugfix: imuxsock did no longer ignore message-provided timestamp,
    if so configured (the *default*). Lead to no longer sub-second
    timestamps.
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=281
  - bugfix: omfile returns fatal error code for things that go really
    wrong previously, RS_RET_RESUME was returned, which lead to a loop
    inside the rule engine as omfile could not really recover.
  - bugfix: imfile did invalid system call under some circumstances
    when a file that was to be monitored did not exist BUT the state
    file actually existed. Mostly a cosmetic issue. Root cause was
    incomplete error checking in stream.c; so patch may affect other
    code areas.
  - bugfix: rsyslogd -v always said 64 atomics were not present
    thanks to mono_matsuko for the patch
- Changed /etc/rsyslog.early.conf to just include rsyslog.conf,
  fixed spec to use sd-daemon.[ch] from docs on 11.4 only.
* Mon Feb 20 2012 mt@suse.com
- Cleaned up the config files a bit, updated comments in config
  file, marked the /etc/rsyslog.early.conf obsolete.
  Note: rsyslog will be started early/before network using its normal
  /etc/rsyslog.conf config file (adopted scripts in syslog-service
  package). When any kind of remote logging is in use, then on-disk
  queues should be enabled. To start it after the network, please set
  the SYSLOG_REQUIRES_NETWORK=yes variable in /etc/sysconfig/syslog
  (bnc#728565).
* Wed Sep  7 2011 mrueckert@suse.de
- update to 5.8.5 [V5-stable]
  - bugfix/security: off-by-two bug in legacy syslog parser,
    CVE-2011-3200 bnc#714658
  - bugfix: mark message processing did not work correctly
  - bugfix: potential hang condition during tag emulation
  - bugfix: too-early string termination during tag emulation
  - bugfix: The NUL-Byte for the syslogtag was not copied in MsgDup
    (msg.c)
  - bugfix: fixed incorrect state handling for Discard Action
    (transactions) Note: This caused all messages in a batch to be
    set to COMMITTED, even if they were discarded.
* Wed Aug 24 2011 mt@suse.de
- Adopted to require new syslog-service package on 12.x, that
  provides the /etc/init.d/syslog LSB init script and systemd
  syslog.service service file. Removed rsyslog.service file
  installation from spec file. (fate#311316).
* Fri Aug 19 2011 mrueckert@suse.de
- Update to 5.8.4 [V5-stable]
  - bugfix: potential misadressing in property replacer
  - bugfix: memcpy overflow can occur in allowed sender checkig if
    a name is resolved to IPv4-mapped-on-IPv6 address Found by
    Ismail Dönmez at suse
  - bugfix: potential misadressing in property replacer
  - bugfix: MSGID corruption in RFC5424 parser under some
    circumstances closes:
    http://bugzilla.adiscon.com/show_bug.cgi?id=275
- remove rsyslog-5.8.0-memcpy.patch:
  applied upstream
- fix build for older distros:
  only buildrequire systemd-devel for newer than 11.4, use systemd
  for the others
* Fri Aug 19 2011 crrodriguez@opensuse.org
- Fix build with new gnutls
* Tue Aug  2 2011 aj@suse.de
- Require systemd-devel to follow package split.
* Wed Jul 13 2011 mrueckert@suse.de
- drop modules imtemplate and omtemplate, the 2 modules are base
  templates for people who want to develop their own modules.
* Tue Jul 12 2011 mrueckert@suse.de
- enabled a few more modules which dont pull extra dependencies:
  impstats, pmcisconames, pmaixforwardedfrom, pmsnare, pmrfc3164sd,
  omruleset, mmsnmptrapd
* Tue Jul 12 2011 mrueckert@suse.de
- guard the file list entry for rsyslog.service with
  if {with systemd}. Please keep the package working on older
  distros.
* Tue Jul 12 2011 mrueckert@suse.de
- upstream asked to change the syntax in the default config files
  to the new syntax:
  old: *.* * # (write to all)
  new: *.* :omusrmsg:*
  old: *.* $channel
  new: *.* :omfile:$channel
  from what i can see we are only affected with:
  old: *.emerg *
  new: *.emerg :omusrmsg:*
* Tue Jul 12 2011 mrueckert@suse.de
- Updated to 5.8.3  [V5-stable]
  - systemd support: set stdout/stderr to null - thx to Lennart for
    the patch
  - added support for the ":omusrmsg:" syntax in configuring user
    messages
  - added support for the ":omfile:" syntax in configuring user
    messages Note: previous outchannel syntax will generate a
    warning message. This may be surprising to some users, but it
    is quite urgent to alert them of the new syntax as v6 can no
    longer support the previous one.
* Tue Jun 21 2011 mt@suse.de
- Updated to 5.8.2 [V5-stable] (bnc#701282) a maintenance release,
  containing only stability fixes:
  - bugfix: problems in failover action handling
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=270
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=254
  - bugfix: mutex was invalidly left unlocked during action processing
    At least one case where this can occur is during thread shutdown,
    which may be initiated by lower activity. In most cases, this is
    quite unlikely to happen. However, if it does, data structures may be
    corrupted which could lead to fatal failure and segfault. I detected
    this via a testbench test, not a user report. But I assume that some
    users may have had unreproducable aborts that were cause by this bug.
  - bugfix: memory leak in imtcp & subsystems under some circumstances
    This leak is tied to error conditions which lead to incorrect cleanup
    of some data structures. [backport from v6]
  - bugfix/improvement:$WorkDirectory now gracefully handles trailing
    slashes
* Tue May 31 2011 aj@suse.de
- Add systemd service file back (bnc#696963).
* Fri May 27 2011 mt@suse.de
- Removed touch of obsolete /var/log/boot.log from spec post.
* Thu May 19 2011 mrueckert@suse.de
- update to 5.8.1
  - bugfix: invalid processing in QUEUE_FULL condition If the the
    multi-submit interface was used and a QUEUE_FULL condition
    occured, the failed message was properly destructed. However,
    the rest of the input batch, if it existed, was not processed.
    So this lead to potential loss of messages and a memory leak.
    The potential loss of messages was IMHO minor, because they
    would have been dropped in most cases due to the queue
    remaining full, but very few lucky ones from the batch may have
    made it. Anyhow, this has now been changed so that the rest of
    the batch is properly tried to be enqueued and, if not
    possible, destructed.
  - new module mmsnmptrapd, a sample message modification module
    This can be useful to reformat snmptrapd messages and also
    serves as a sample for how to write message modification
    modules using the output module interface. Note that we
    introduced this new functionality directly into the stable
    release, as it does not modify the core and as such cannot have
    any side-effects if it is not used (and thus the risk is solely
    on users requiring that functionality).
  - bugfix: rate-limiting inside imuxsock did not work 100%% correct
    reason was that a global config variable was invalidly accessed
    where a listener variable should have been used.  Also
    performance-improved the case when rate limiting is turned off
    (this is a very unintrusive change, thus done directly to the
    stable version).
  - bugfix: $myhostname not available in RainerScript (and no error
    message) closes:
    http://bugzilla.adiscon.com/show_bug.cgi?id=233
  - bugfix: memory and file descriptor leak in stream processing
    Leaks could occur under some circumstances if the file stream
    handler errored out during the open call. Among others, this
    could cause very big memory leaks if there were a problem with
    unreadable disk queue files. In regard to the memory leak, this
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=256
  - bugfix: doc for impstats had wrong config statements also,
    config statements were named a bit inconsistent, resolved that
    problem by introducing an alias and only documenting the
    consistent statements Thanks to Marcin for bringing up this
    problem.
  - bugfix: IPv6-address could not be specified in omrelp this was
    due to improper parsing of ":" closes:
    http://bugzilla.adiscon.com/show_bug.cgi?id=250
  - bugfix: TCP connection invalidly aborted when messages needed
    to be discarded (due to QUEUE_FULL or similar problem)
  - bugfix: $LocalHostName was not honored under all circumstances
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=258
  - bugfix(minor): improper template function call in syslogd.c
* Fri Apr 29 2011 idoenmez@novell.com
- Add rsyslog-5.6.5-memcpy.patch: fix overflowing memcpy call in
  runtime/net.c
* Wed Apr 27 2011 mrueckert@suse.de
- move most of the additional requirements and subpackages into
  conditionals so we can switch them on and off by more easily.
* Tue Apr 26 2011 mt@suse.de
- Dropped obsolete rsyslog-systemd-integration.bnc656104.diff
* Tue Apr 26 2011 mrueckert@suse.de
- dont ship the systemd service file for now.
* Sun Apr 24 2011 mrueckert@suse.de
- update to 5.8.0 (v5-tsable)
  This is the new v5-stable branch, importing all feature from the
  5.7.x versions. To see what has changed in regard to the previous
  v5-stable, check the entries for 5.7.x in
  /usr/share/doc/packages/rsyslog/ChangeLog.
  - bugfix: race condition in deferred name resolution
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=238
    Special thanks to Marcin for his persistence in helping to solve this
    bug.
  - bugfix: DA queue was never shutdown once it was started
    closes: http://bugzilla.adiscon.com/show_bug.cgi?id=241
- dropped patch rsyslog-deferred-dns-query-race.diff
  included in the release
- refreshed rsyslog-systemd-integration.bnc656104.diff:
  most of the patch went upstream just a small chunk left
- fixed the with_dbi conditional, it was using the build_with_relp.
- added a new conditional with_systemd and moved all the systemd
  specific things from suse_version >= 1140 to the with_systemd
  conditional. the patch line in the preamble should be
  unconditional.
* Fri Apr  8 2011 mt@suse.de
- bugfix: race condition in deferred name resolution (id=238)
  from v5.8.0 candidate.
* Thu Mar 24 2011 mt@suse.de
- Updated to 5.6.5 (v5-stable) with following bugfixes:
  * bugfix: failover did not work correctly if repeated msg
  reduction was on.
  affected directive: $ActionExecOnlyWhenPreviousIsSuspended on
  * bugfix: omlibdbi did not use password from rsyslog.conf
  closes: http://bugzilla.adiscon.com/show_bug.cgi?id=203
  * bugfix(kind of): tell users that config graph can currently
  not be generated
  closes: http://bugzilla.adiscon.com/show_bug.cgi?id=232
  * bugfix: discard action did not work under some circumstances
  fixes: http://bugzilla.adiscon.com/show_bug.cgi?id=217
  (bnc#676041)
  * bugfix: potential abort condition when $RepeatedMsgReduction
  were set to on as well as potentially in a number of other places
  where MsgDup() was used. This only happened when the imudp input
  module was used and it depended on name resolution not yet had
  taken place. (bnc#679030)
  * bugfix: fixed a memory leak and potential abort condition
  this could happen if multiple rulesets were used and some output
  batches contained messages belonging to more than one ruleset.
  fixes: http://bugzilla.adiscon.com/show_bug.cgi?id=226
  fixes: http://bugzilla.adiscon.com/show_bug.cgi?id=218
  * bugfix: memory leak when $RepeatedMsgReduction on was used
  bug tracker: http://bugzilla.adiscon.com/show_bug.cgi?id=225
  (bnc#681568)
- Merged systemd socket activation support
* Wed Feb  2 2011 mt@suse.de
- update to 5.6.3 (v5-stable) with following bugfixes (digest):
  * action processor released mememory too early, resulting in
  potential issue in retry cases (very unlikely).
  * batch processing flagged invalid message as "bad" under some
  circumstances
  * unitialized variable could cause issues under extreme
  conditions plus some minor nits.
  * batches which had actions in error were not properly retried
  in all cases
  * imfile did duplicate messages under some circumstances
- enabled plain tcp input, unix socket output, last message
  parser and the libdbi module as separate package.
- disabled systemd patch for openSUSE <= 11.3
* Thu Jan 20 2011 mt@suse.de
- Improved systemd socket activation support to allow multiple
  unix sockets and activation in forking mode (bnc#656197).
* Fri Dec  3 2010 mt@suse.de
- update to 5.6.2 (v5-stable) with following bugfixes:
  * compile failed on systems without epoll_create1()
    Thanks to David Hill for providing a fix.
  * atomic increment for msg object may not work correct on
    all platforms. Thanks to Chris Metcalf for the patch
  * replacements for atomic operations for non-int sized types
    had problems. At least one instance of that problem could
    potentially lead to abort (inside omfile).
- Increased mark frequency in rsyslog.conf to 1 hour
- Enabled duplicate message reduction in rsyslog.conf to catch
  at least buggy programs running amok and writting same message
  zillion times until the disk gets out of space (bnc#656197).
- Merged rsyslog-systemd-integration.bnc656104.diff (fuzz=0).
* Mon Nov 29 2010 mt@suse.de
- update to 5.6.1
  This release addresses a TLS bug, that has been bothering a lot
  of users lately. It stops rsyslog from looping, thus disabling
  functionality and bearing the risk of unresponsiveness of the
  whole system. Other issues have been fixed for imptcp, failing
  testbench, segfault on empty templates and failed compile.
  For more detailed information, please review the ChangeLog and
    http://bugzilla.adiscon.com/show_bug.cgi?id=194,
    http://bugzilla.adiscon.com/show_bug.cgi?id=204,
    http://bugzilla.adiscon.com/show_bug.cgi?id=206.
- applied systemd integration base patch (without the service and
  socket unit files, because we'll use same for all syslog damons)
  extracted from git master (bnc#656104).
* Sat Nov 20 2010 coolo@novell.com
- build with libnet-devel on 11.4
* Mon Nov 15 2010 chris@computersalat.de
- update to 5.6.0
  This release brings all changes and enhancements of the 5.5.x
  series to the v5-stable branch.
  - bugfix: a couple of problems that imfile had on some platforms,
    namely Ubuntu (not their fault, but occured there)
  - bugfix: imfile utilizes 32 bit to track offset. Most importantly,
    this problem can not experienced on Fedora 64 bit OS (which has
    64 bit long's!)
- removed obsolete patch
  - xconsole-pipe-loop
- rpmlint
  - name-repeated-in-summary C Rsyslog
* Wed Apr 28 2010 mt@suse.de
- Added $klogConsoleLogLevel 1 to the config, to use same default
  [KERNEL_LOGLEVEL in /etc/sysconfig/syslog] as klogd (bnc#593699).
- Improved filter to discard iptables msgs higher err on console,
  changed to set default file template instead per file, removed
  duplicate filters (bnc#593699).
* Tue Apr 27 2010 mt@suse.de
- Applied fix to avoid a tight send-retry loop in case there is
  nobody receiving the messages sent to the xconsole pipe
  (bnc#597293, http://bugzilla.adiscon.com/show_bug.cgi?id=186).
- Disabled relp support for < 11.3 (librelp is new)
- Fixed to create /var/run/rsyslog in post-install (rpmlint)
* Wed Apr 14 2010 mrueckert@suse.de
- dropped install_all_modules_in_lib conditional and all related
  code
- new subpackages
  - enable RELP support. new depdendency librelp
  - enable diagnotic tools.
  - enable UDP spoof support. new dependency libnet
- moved module paths to 2 variables defined on top of the spec
* Tue Apr 13 2010 mt@suse.de
- Updated to rsyslog version 5.4.0 (v5-stable). This version begins
  a new stable series based on the 5.3.x series, which has been
  proven rather well in practice. The new 5.4.0 contains fixes for
  all known problems. See ChangeLog file for a detailed history.
  The main new feature is speed: several optimizations were done,
  including support for epoll in tcp listeners.
- Added new lmzlibw.so and omruleset.so to the file list.
- Recompressed original tar.gz source archive using bzip2.
* Wed Sep  9 2009 mt@suse.de
- Added read-only RSYSLOGD_NATIVE_VERSION sysconfig/syslog variable,
  that is set to the native mode version number for the -c parameter
  while every installation and used in the /etc/init.d/syslog script,
  except the user overrides this default in RSYSLOGD_COMPAT_VERSION.
* Wed Sep  2 2009 mt@suse.de
- Updated to rsyslog version 4.4.1 (v4-stable), a bug-fixing release,
  providing some important fixes for issues that have only been
  detected after the beta phase. Some of them are serious (like a
  segfault when UDP messageforwarding is activated), so users of
  4.4.0 are urged to upgrade to this release. Changelog for 4.4.1:
  * features requiring Java are automatically disabled if Java
    is not present (thanks to Michael Biebl for his help!)
  * bugfix: invalid double-quoted PRI, among others in outgoing
    messages. This causes grief with all receivers.
    Bug tracker: http://bugzilla.adiscon.com/show_bug.cgi?id=147
  * bugfix: Java testing tools were required, even if testbench
    was disabled. This resulted in build errors if no Java was
    present on the build system, even though none of the selected
    option actually required Java. (I forgot to backport a similar
    fix to newer releases).
  * bugfix (backport): omfwd segfault. Note that the orginal (higher
    version) patch states this happens only when debugging mode is
    turned on. That statement is wrong: if debug mode is turned off,
    the message is not being emitted, but the division by zero in
    the actual parameters still happens.
- Removed jave2-devel-packages from build requires again
* Tue Sep  1 2009 mt@suse.de
- Updated to rsyslog version 4.4.0, the actual stable 4.4.x series.
  It provides several bugfixes, performance improvements and new
  features: It adds generic network stream server for syslog, the
  capability to rebind the send socket of the UDP output section,
  allows multiple tcp listeners, multiple recipients in ommail,
  new plugins as omprog, improved documentation and testbench
  with a config switch. Please review ChangeLog file for details.
- Removed obsolete moddirs patch (included in 4.4.0)
- Added java2-devel-packages to BuildRequires (for test suite)
- Enabled omprog and omtemplate plugins, added them and the
  lmstrmsrv plugin to the base-plugins file list.
* Mon Apr 20 2009 mt@suse.de
- Improved config file comments about usage of additional
  modules provided in separate rsyslog-module packages.
- Enabled GnuTLS (syslog-transport-tls) support module.
* Mon Apr 20 2009 mt@suse.de
- Updated to rsyslog 3.20.6 [v3-stable]
* Mon Dec 15 2008 mt@suse.de
- Security fix to honor $AllowedSender settings (bnc#457273).
- Security fix [DoS] from 3.20.2 to emit a discard message every
  minute only (when DisallowWarning enabled) instead of every time;
  this prevernts an attacker can fill the disk (bnc#457273).
* Wed Sep 10 2008 schwab@suse.de
- Run autoreconf.
* Tue Sep  9 2008 mt@suse.de
- Enabled mail, imfile and imtemplate modules
- Enabled snmp module, packaged as rsyslog-module-snmp
- Added patch to support multiple module directories,
  in our case /lib[64]/rsyslog:/usr/lib[64]/rsyslog
* Thu Sep  4 2008 mt@suse.de
- initial rsyslog 3.18.3 package
