#
# spec file for package branding-SLE
#
# Copyright (c) 2016 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           branding-SLE
Version:        15
Release:        150600.45.3.2
Provides:       branding
Conflicts:      otherproviders(branding)
Url:            http://github.com/openSUSE/branding
Source0:        SLE.tar.xz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%ifarch x86_64 %ix86
%define package_gfxboot 1
BuildRequires:  gfxboot-devel
%endif
%ifarch aarch64 %{ix86} x86_64 ppc ppc64 ppc64le
%define package_grub2_theme 1
%endif
Summary:        SLE Brand File
License:        BSD-3-Clause
Group:          System/Fhs
BuildRequires:  fdupes
BuildRequires:  fribidi
BuildRequires:  update-desktop-files
BuildArch:      noarch
BuildRequires:  update-bootloader-rpm-macros

%description
This package contains the file /etc/SUSE-brand, and its name is used as
a trigger for installation of correct vendor brand packages.

%define theme_name SLE

%if 0%{?package_gfxboot} > 0

%package        -n gfxboot-branding-SLE
Summary:        Graphical bootloader SLE theme
License:        BSD-3-Clause
Group:          System/Boot
PreReq:         gfxboot >= 4
Supplements:    packageand(gfxboot:branding-SLE)
Provides:       gfxboot-branding = %{version}
Provides:       gfxboot-theme = %{version}
Conflicts:      otherproviders(gfxboot-branding)
BuildArch:      noarch
Obsoletes:      gfxboot-branding-SLED < 12
Obsoletes:      gfxboot-branding-SLES < 12

%description -n gfxboot-branding-SLE
SUSE Linux Enterprise theme for gfxboot (graphical bootloader for grub).
%endif

%package -n wallpaper-branding-SLE
Summary:        SLE default wallpapers
License:        BSD-3-Clause
Group:          System/Fhs
Requires(post): update-alternatives
Requires(postun): update-alternatives
Provides:       wallpaper-branding = %{version}
Conflicts:      otherproviders(wallpaper-branding)
BuildArch:      noarch

%description -n wallpaper-branding-SLE
SUSE Linux Enterprise defaults wallpapers

%if 0%{?package_grub2_theme} > 0

%package -n grub2-branding-SLE
Summary:        SLE branding for GRUB2's graphical console
License:        CC-BY-SA-3.0
Group:          System/Fhs
Requires:       grub2
Provides:       grub2-branding = %{version}
Supplements:    packageand(grub2:branding-SLE)
Conflicts:      otherproviders(grub2-branding)
BuildArch:      noarch

%description -n grub2-branding-SLE
SUSE Linux Enterprise branding for the GRUB2's graphical console

%endif

%package -n plymouth-branding-SLE
Summary:        SLE branding for Plymouth bootsplash
License:        GPL-2.0+
Group:          System/Fhs
Requires:       plymouth-plugin-label
PreReq:         plymouth-plugin-script
PreReq:         plymouth-scripts
Supplements:    packageand(plymouth:branding-SLE)
Provides:       plymouth-branding = %{version}
Conflicts:      otherproviders(plymouth-branding)
BuildArch:      noarch

%description -n plymouth-branding-SLE
SUSE Linux Enterprise branding for the plymouth bootsplash

%package -n gdm-branding-SLE
Summary:        SLE branding for gdm
# To be in sync with upstream defaults, do branding as a patch for upstream file.
# WARNING: As this package conflicts with gdm-branding-openSUSE, you cannot
#          reuse build root. You have to build in a clean build root every time!
License:        GPL-2.0+
Group:          System/GUI/GNOME
BuildRequires:  gdm-branding-upstream
# For directory ownership:
BuildRequires:  gdm
%define gdm_version %(rpm -q --qf '%%{version}' gdm)
Requires:       gdm = %{gdm_version}
Requires:       gdm = %{gdm_version}
Provides:       gdm-branding = %{gdm_version}
Conflicts:      otherproviders(gdm-branding)
Supplements:    packageand(gdm:branding-SLE)
BuildArch:      noarch

%description -n gdm-branding-SLE
SUSE Linux Enterprise branding for the gdm

%prep
%setup -q -c
cp -a SLE/LICENSE COPYING

%build
cat >SUSE-brand <<EOF
SLE
VERSION = %{version}
EOF

%if 0%{?package_gfxboot} > 0
mkdir gfx
cp -a /usr/share/gfxboot/themes/openSUSE/ gfx/SLE
list=`cd SLE/gfxboot && find -type f`
for i in $list; do
  cp SLE/gfxboot/$i gfx/SLE/$i
done
pushd gfx/SLE
sed -i -e "s,product=.*,product=SUSE Linux Enterprise %{version}," config
sed -i -e "s,penguin=.*,penguin=0," src/gfxboot.cfg

export PATH=/usr/sbin:$PATH
make
popd
%endif

%install
mkdir -p %{buildroot}%{_sysconfdir}
cp SUSE-brand %{buildroot}%{_sysconfdir}/

mkdir -p %{buildroot}%{_datadir}/gdm/greeter/images/
mkdir -p %{buildroot}%{_sysconfdir}/gdm
install -m0644 SLE/gdm/custom.conf %{buildroot}%{_sysconfdir}/gdm/custom.conf
install -m0644 SLE/gdm/distributor.svg %{buildroot}%{_datadir}/gdm/greeter/images/

mkdir -p %{buildroot}%{_datadir}/gnome-shell/theme/
install -m0644 SLE/gdm/SLE-background.png %{buildroot}%{_datadir}/gnome-shell/theme/

# gfxboot themes will soon get a make install - promised by snwint
# gfxboot should use a link /etc/bootsplash/theme -> /usr/share/bootsplash
# like splashy 
if test -f gfx/SLE/bootlogo; then
    install -d -m 755 %{buildroot}/etc/bootsplash/themes/SLE/{bootloader,cdrom}
    cp gfx/SLE/bootlogo %{buildroot}/etc/bootsplash/themes/SLE/cdrom
    /usr/share/gfxboot/bin/unpack_bootlogo %{buildroot}/etc/bootsplash/themes/SLE/cdrom
    install -m 644 gfx/SLE/{message,po/*.tr,help-boot/*.hlp} %{buildroot}/etc/bootsplash/themes/SLE/bootloader
    /usr/share/gfxboot/bin/2hl --link --quiet %{buildroot}/etc/bootsplash/themes/SLE/*
    mkdir %{buildroot}/boot 
    touch %{buildroot}/boot/message 
fi

make -C SLE install DESTDIR=%{buildroot}

# Touch the file handled with update-alternatives
touch %{buildroot}/usr/share/wallpapers/SLE-default.xml

%fdupes %{buildroot}/usr/share/backgrounds

# remove 
%if 0%{?package_grub2_theme} < 1
rm -rf %{buildroot}/%{_datadir}/grub2
%endif

%check
make -C SLE check DESTDIR=%{buildroot}


%if 0%{?package_gfxboot} > 0

%post -n gfxboot-branding-SLE
gfxboot --update-theme SLE
%endif

%post -n wallpaper-branding-SLE
update-alternatives --install /usr/share/wallpapers/SLE-default.xml SLE-default.xml /usr/share/wallpapers/SLE-default-static.xml 5

%postun -n wallpaper-branding-SLE
# Note: we don't use "$1 -eq 0", to avoid issues if the package gets renamed
if [ ! -f /usr/share/wallpapers/SLE-default-static.xml ]; then
  update-alternatives --remove SLE-default.xml /usr/share/wallpapers/SLE-default-static.xml
fi

%if 0%{?package_grub2_theme} > 0
%post -n grub2-branding-SLE
%{_datadir}/grub2/themes/%theme_name/activate-theme
%if 0%{?update_bootloader_check_type_refresh_post:1}
%{update_bootloader_check_type_refresh_post grub2 grub2-efi}
%else
if test -e /boot/grub2/grub.cfg ; then
  %{_sbindir}/grub2-mkconfig -o /boot/grub2/grub.cfg || true
fi
%endif

%posttrans -n grub2-branding-SLE
%{?update_bootloader_posttrans}

%postun -n grub2-branding-SLE
if [ $1 = 0 ] ; then
  rm -rf /boot/grub2/themes/%theme_name
fi
%endif

%post -n plymouth-branding-SLE
export LIB=%{_libdir}
OTHEME="$(%{_sbindir}/plymouth-set-default-theme)"
if [ "$OTHEME" == "text" -o "$OTHEME" == "SLE" -o "$OTHEME" == "basedonopensuse" ]; then
   if [ ! -e /.buildenv ]; then
     %{_sbindir}/plymouth-set-default-theme SLE
     %{?regenerate_initrd_post}
   else
     %{_sbindir}/plymouth-set-default-theme SLE
   fi 
fi

%postun -n plymouth-branding-SLE
if [ $1 -eq 0 ]; then
    export LIB=%{_libdir}
    if [ "$(%{_sbindir}/plymouth-set-default-theme)" == "SLE" ]; then
        %{_sbindir}/plymouth-set-default-theme --reset
        %{?regenerate_initrd_post}
    fi
fi

%posttrans -n plymouth-branding-SLE
%{?regenerate_initrd_posttrans}

%files
%defattr(-,root,root)
%license COPYING
%{_sysconfdir}/SUSE-brand

%if 0%{?package_gfxboot} > 0

%files -n gfxboot-branding-SLE
%defattr(-,root,root)
%{_sysconfdir}/bootsplash
%ghost /boot/message
%endif

%files -n wallpaper-branding-SLE
%defattr(-,root,root)
%license COPYING
%ghost /usr/share/wallpapers/SLE-default.xml
/usr/share/gnome-background-properties/wallpaper-branding-SLE.xml
/usr/share/wallpapers/
# FIXME: It should be owned by a different package:
%dir /usr/share/gnome-background-properties/

%if 0%{?package_grub2_theme} > 0
%files -n grub2-branding-SLE
%defattr(-,root,root)
%{_datadir}/grub2
%dir /boot/grub2
%dir /boot/grub2/backgrounds
%dir /boot/grub2/themes
%ghost /boot/grub2/backgrounds/SLE
%ghost /boot/grub2/themes/SLE
%endif

%files -n plymouth-branding-SLE
%defattr(-, root, root)
%{_datadir}/plymouth/plymouthd.defaults
%{_datadir}/plymouth/themes/SLE/

%files -n gdm-branding-SLE
%defattr (-, root, root)
%config(noreplace) %{_sysconfdir}/gdm/custom.conf
%{_datadir}/gdm/greeter/images/distributor.svg
%dir %{_datadir}/gdm/greeter/images/
%{_datadir}/gnome-shell/theme/SLE-background.png
%dir %{_datadir}/gnome-shell/theme/

%changelog
* Mon Feb 10 2025 qzhao@suse.com
- Update plymouth theme to fix splash screen element placement issue.
  (bsc#1236818)
* Tue Jun  7 2022 mchang@suse.com
- Support %%posttrans with macros provided by update-bootloader-rpm-macros
  package (bsc#997317) (bsc#1199818)
* Mon Mar 22 2021 lidong.zhong@suse.com
- Replace the initrd update with generic macros(bsc#1183594)
* Thu Feb 11 2021 fcrozat@suse.com
- Update wallpapers (jsc#SLE-14772).
* Wed Feb 10 2021 fcrozat@suse.com
- Update bootloader (jsc#SLE-14772).
* Mon Jan 18 2021 fcrozat@suse.com
- Update wallpapers (jsc#SLE-14772).
* Tue Dec 15 2020 fcrozat@suse.com
- Update wallpapers and bootloaders (jsc#SLE-14772).
* Tue Dec 15 2020 fcrozat@suse.com
- Update wallpapers and bootloaders (jsc#SLE-14772).
* Thu Nov  5 2020 fcrozat@suse.com
- Update gfxboot branding (jsc#SLE-14772, bsc#1178192).
* Tue Oct 13 2020 xiaoguang.wang@suse.com
- Move branding image file from gnome-shell to gdm-branding
  (jsc#SLE-11720 bsc#1176304).
* Thu Oct  1 2020 fcrozat@suse.com
- Fix grub2 branding to better handle different screen ratio
  (bsc#1177138).
* Mon Sep 28 2020 fcrozat@suse.com
- Update gdm branding (jsc#SLE-14772).
* Fri Sep 25 2020 fcrozat@suse.com
- Add 4k backgrounds / screenlocks (jsc#SLE-14772).
- Update grub2 branding (jsc#SLE-14772).
* Wed Sep 16 2020 fcrozat@suse.com
- remove plymouth_parse_newlines.patch, merged in tarball
- update wallpapers and plymouth to new branding (jsc#SLE-14772).
- change the way plymouth defaults are handled (jsc#SLE-11637).
* Tue Mar 10 2020 oholecek@suse.com
- Add plymouth_parse_newlines.patch to parse "\n" in plymouth theme
  text to new lines (bsc#1165825).
* Tue Nov 19 2019 fcrozat@suse.com
- Rebuild for GNOME 3.34 (jsc#SLE-8245).
* Fri Feb  8 2019 fcrozat@suse.com
- Update grub theme to better cope with long menu entry
  (FATE#325760).
* Wed Apr  4 2018 hpj@suse.com
- Remove autostart file granting X11 access to root (bsc#1084737).
* Tue Jan 30 2018 fcrozat@suse.com
- Remove dynamic backgrounds subpackage.
* Mon Jan 29 2018 fcrozat@suse.com
- New design for SLE15[FATE#323736].
* Fri Dec  1 2017 qzhao@suse.com
- Add custom.conf to gdm-branding-SLE package: With a new line
  InitialSetupEnable=False, it will disable gnome-initial-setup
  run before gdm. Otherwise if a system without CJK language and
  without normal user could not be login(bnc#1067976).
- Move distributor.svg inside to source package together with
  custom.conf, because they are all gdm resources.
* Thu Nov  2 2017 hpj@suse.com
- Add an autostart file that runs on login and grants X11 access
  to root. This allows graphical applications to run as root,
  which is required for YaST (bsc#955101, fate#322297).
* Fri Oct 13 2017 fcrozat@suse.com
- No longer install by default dynamic-wallpaper if
  gnome-settings-daemon is installed.
* Wed Sep 20 2017 fcrozat@suse.com
- Update for SLE15.
- Kill kde-branding-SLE specfile.
* Thu Oct 13 2016 jreidinger@suse.com
- drop generating of yast2-qt-branding-SLE as it is not used on
  media and its content is already part of yast2-theme-SLE
  (bnc#992151)
* Thu Apr 28 2016 fcrozat@suse.com
- Add gdm-branding-SLE subpackage (FATE#318572).
* Fri Jun 26 2015 dmueller@suse.com
- Enable GRUB2 branding for aarch64 (FATE#318444)
* Thu Aug 14 2014 dvaleev@suse.com
- Build GRUB2 branding for ppc64le
* Wed Aug  6 2014 idonmez@suse.com
- Fix bnc#886811
* Mon Jul  7 2014 fcrozat@suse.com
- Update gfxboot branding
* Wed Jul  2 2014 fcrozat@suse.com
- Fix isolinux branding
* Mon Jun 30 2014 fcrozat@suse.com
- Updated isolinux branding.
* Mon Jun 23 2014 idonmez@suse.com
- New splash theme
* Mon Jun 16 2014 fcrozat@suse.com
- Updated wallpapers.
* Thu Jun  5 2014 fcrozat@suse.com
- Add Obsoletes to gfxboot-branding-SLE to easy update [bnc#881473]
* Thu May 15 2014 fcrozat@suse.com
- Update grub2 branding
- Remove BuildRequires on grub2, not needed
* Mon May  5 2014 snwint@suse.de
- no penguins (bnc #858503)
* Tue Feb 18 2014 fcrozat@suse.com
- Fix version for SLE.
* Mon Feb 17 2014 fcrozat@suse.com
- Ensure all brandings are called SLE
* Sat Feb 15 2014 sreeves@suse.com
- Initial package creation. Based on branding-openSUSE
    Last changelog entry from branding-openSUSE
    Sat Feb 15 00:10:42 UTC 2014 - sreeves@suse.com
  - Update openSUSE.tar.xz with git snapshot
