#
# spec file for package python311
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%global flavor base%{nil}
%if "%{flavor}" == "doc"
%define psuffix -documentation
%bcond_without doc
%bcond_with base
%bcond_with general
%endif
%if "%{flavor}" == "base"
%define psuffix -core
%bcond_with doc
%bcond_without base
%bcond_with general
%endif
%if "%{flavor}" == ""
%define psuffix %{nil}
%bcond_with doc
%bcond_with base
%bcond_without general
%endif

%if 0%{?do_profiling} && !0%{?want_reproducible_builds}
%bcond_without profileopt
%else
%bcond_with profileopt
%endif

# Only for Tumbleweed
# https://en.opensuse.org/openSUSE:Python:Externally_managed
%if 0%{?suse_version} > 1600
%bcond_without externally_managed
%else
%bcond_with externally_managed
%endif

%define         python_pkg_name python311
%if "%{python_pkg_name}" == "%{primary_python}"
%define primary_interpreter 1
%else
%define primary_interpreter 0
%endif

# Setting up variables
%define _version %(c=%{version}; echo ${c/[a-z]*/})
%define tar_suffix %(c=%{_version}; echo ${c#%{_version}})
%define python_version %(echo %{_version}|cut -d. -f1-2)
# based on the current source tarball
%define python_version_abitag %(c=%{python_version}; echo ${c//./})
# FIXME %%define python_version_soname %%(c=%%{python_version}; echo ${c//./_})
%define         python_version_soname   3_11
%if 0%(test -n "%{tar_suffix}" && echo 1)
%define _version %(echo "%{_version}~%{tar_suffix}")
%define tarversion %{version}
%else
%define tarversion %{version}
%endif
# We don't process beta signs well
%define         folderversion %{tarversion}
%define         tarname    Python-%{tarversion}
%define         sitedir         %{_libdir}/python%{python_version}
# three possible ABI kinds: m - pymalloc, d - debug build; see PEP 3149
%define         abi_kind   %{nil}
# python ABI version - used in some file names
%define         python_abi %{python_version}%{abi_kind}
# soname ABI tag defined in PEP 3149
%define         abi_tag    %{python_version_abitag}%{abi_kind}
# version part of "libpython" package
%define         so_major 1
%define         so_minor 0
%define         so_version %{python_version_soname}%{abi_kind}-%{so_major}_%{so_minor}
# rpm and python have different ideas about what is an arch-dependent name, so:
%if "%{__isa_name}" == "ppc"
%define archname %(echo %{_arch} | sed s/ppc/powerpc/)
%else
%define archname %{_arch}
%endif
# our arm has Hardware-Floatingpoint
%if "%{_arch}" == "arm"
%define armsuffix hf
%endif
# Decide whether we want to use mpdecimal
%if 0%{?suse_version} >= 1550
%bcond_without mpdecimal
%else
%bcond_with mpdecimal
%endif
# pyexpat.cpython-35m-x86_64-linux-gnu
# pyexpat.cpython-35m-powerpc64le-linux-gnu
# pyexpat.cpython-35m-armv7-linux-gnueabihf
# _md5.cpython-38m-x86_64-linux-gnu.so
%define dynlib() %{sitedir}/lib-dynload/%{1}.cpython-%{abi_tag}-%{archname}-%{_os}%{?_gnu}%{?armsuffix}.so
Name:           %{python_pkg_name}%{psuffix}
Version:        3.11.13
Release:        150600.3.35.1
Summary:        Python 3 Interpreter
License:        Python-2.0
URL:            https://www.python.org/
Source0:        https://www.python.org/ftp/python/%{folderversion}/%{tarname}.tar.xz
Source1:        https://www.python.org/ftp/python/%{folderversion}/%{tarname}.tar.xz.sigstore
Source2:        baselibs.conf
Source3:        README.SUSE
Source4:        externally_managed.in
Source7:        macros.python3
Source8:        import_failed.py
Source9:        import_failed.map
Source10:       pre_checkin.sh
Source11:       skipped_tests.py
Source19:       idle3.desktop
Source20:       idle3.appdata.xml
# content of bluez-devel:
# 1. sudo zypper --pkg-cache-dir /tmp install -f -d --no-recommends bluez-devel
# 2. rpm2cpio /tmp/*/*/bluez-devel-*.rpm|cpio -idu
# 3. mkdir Vendor && mv usr/include/* Vendor/
# 4. tar cJf bluez-devel-vendor.tar.xz Vendor/
Source21:       bluez-devel-vendor.tar.xz
Source98:       python311-rpmlintrc
# Tarball is signed by the GPG key of Pablo Galindo Salgado (0x64E628F8D684696D)
# https://keybase.io/pablogsal/pgp_keys.asc?fingerprint=a035c8c19219ba821ecea86b64e628f8d684696d
Source99:       python.keyring
# The following files are not used in the build.
# They are listed here to work around missing functionality in rpmbuild,
# which would otherwise exclude them from distributed src.rpm files.
Source100:      PACKAGING-NOTES
# PATCH-FEATURE-UPSTREAM F00251-change-user-install-location.patch bsc#[0-9]+ mcepl@suse.com
# Fix installation in /usr/local (boo#1071941), originally from Fedora
# https://src.fedoraproject.org/rpms/python3.12/blob/rawhide/f/00251-change-user-install-location.patch
# Set values of prefix and exec_prefix in distutils install command
# to /usr/local if executable is /usr/bin/python* and RPM build
# is not detected to make pip and distutils install into separate location
Patch02:        F00251-change-user-install-location.patch
# PATCH-FEATURE-UPSTREAM distutils-reproducible-compile.patch gh#python/cpython#8057 mcepl@suse.com
# Improve reproduceability
Patch03:        distutils-reproducible-compile.patch
# support finding packages in /usr/local, install to /usr/local by default
Patch04:        python-3.3.0b1-localpath.patch
# replace DATE, TIME and COMPILER by fixed definitions to aid reproducible builds
Patch05:        python-3.3.0b1-fix_date_time_compiler.patch
# Raise timeout value for test_subprocess
Patch07:        subprocess-raise-timeout.patch
# PATCH-FEATURE-UPSTREAM bpo-31046_ensurepip_honours_prefix.patch bpo#31046 mcepl@suse.com
# ensurepip should honour the value of $(prefix)
Patch08:        bpo-31046_ensurepip_honours_prefix.patch
# PATCH-FIX-SLE no-skipif-doctests.patch jsc#SLE-13738 mcepl@suse.com
# SLE-15 version of Sphinx doesn't know about skipif directive in doctests.
Patch09:        no-skipif-doctests.patch
# PATCH-FIX-SLE skip-test_pyobject_freed_is_freed.patch mcepl@suse.com
# skip a test failing on SLE-15
Patch10:        skip-test_pyobject_freed_is_freed.patch
# PATCH-FIX-SLE fix_configure_rst.patch bpo#43774 mcepl@suse.com
# remove duplicate link targets and make documentation with old Sphinx in SLE
Patch11:        fix_configure_rst.patch
# PATCH-FIX-UPSTREAM skip_if_buildbot-extend.patch gh#python/cpython#103053 mcepl@suse.com
# Skip test_freeze_simple_script
Patch13:        skip_if_buildbot-extend.patch
# PATCH-FIX-UPSTREAM bsc1221260-test_asyncio-ResourceWarning.patch bsc#1221260 mcepl@suse.com
# prevent ResourceWarning in test_asyncio tests
Patch15:        bsc1221260-test_asyncio-ResourceWarning.patch
# PATCH-FIX-OPENSUSE CVE-2023-52425-libexpat-2.6.0-backport.patch
# This problem on libexpat is patched on SLE without version
# update, this patch changes the tests to match the libexpat provided
# by SUSE
Patch16:        CVE-2023-52425-libexpat-2.6.0-backport.patch
Patch17:        CVE-2023-52425-remove-reparse_deferral-tests.patch
# PATCH-FIX-UPSTREAM bso1227999-reproducible-builds.patch bsc#1227999 mcepl@suse.com
# reproducibility patches
Patch19:        bso1227999-reproducible-builds.patch
# PATCH-FIX-UPSTREAM gh120226-fix-sendfile-test-kernel-610.patch gh#python/cpython#120226 mcepl@suse.com
# Fix test_sendfile_close_peer_in_the_middle_of_receiving on Linux >= 6.10 (GH-120227)
Patch22:        gh120226-fix-sendfile-test-kernel-610.patch
# PATCH-FIX-UPSTREAM Add platform triplets for 64-bit LoongArch gh#python/cpython#30939 glaubitz@suse.com
Patch24:        add-loongarch64-support.patch
# PATCH-FIX-UPSTREAM CVE-2025-6069-quad-complex-HTMLParser.patch bsc#1244705 mcepl@suse.com
# avoid quadratic complexity when processing malformed inputs with HTMLParser
Patch25:        CVE-2025-6069-quad-complex-HTMLParser.patch
# PATCH-FIX-UPSTREAM CVE-2025-8194-tarfile-no-neg-offsets.patch bsc#1247249 mcepl@suse.com
# tarfile now validates archives to ensure member offsets are non-negative
Patch26:        CVE-2025-8194-tarfile-no-neg-offsets.patch
BuildRequires:  autoconf-archive
BuildRequires:  automake
BuildRequires:  crypto-policies-scripts
BuildRequires:  fdupes
BuildRequires:  gmp-devel
BuildRequires:  lzma-devel
BuildRequires:  netcfg
BuildRequires:  openssl-devel
BuildRequires:  pkgconfig
BuildRequires:  xz
BuildRequires:  pkgconfig(bzip2)
BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(libffi)
BuildRequires:  pkgconfig(uuid)
BuildRequires:  pkgconfig(zlib)
#!BuildIgnore:  gdk-pixbuf-loader-rsvg
%if 0%{?suse_version} >= 1550
# The provider for python(abi) is in rpm-build-python
BuildRequires:  rpm-build-python
%endif
%if 0%{?suse_version} >= 1500 && 0%{?suse_version} < 1599
BuildRequires:  pkgconfig(libnsl)
BuildRequires:  pkgconfig(libtirpc)
%endif
%if %{with mpdecimal}
BuildRequires:  mpdecimal-devel
%endif
%if %{with doc}
BuildRequires:  python3-Sphinx >= 4.0.0
%if 0%{?suse_version} >= 1500
BuildRequires:  python3-python-docs-theme >= 2022.1
%endif
%endif
%if %{with general}
# required for idle3 (.desktop and .appdata.xml files)
BuildRequires:  appstream-glib
BuildRequires:  gcc-c++
BuildRequires:  gdbm-devel
BuildRequires:  gettext
BuildRequires:  readline-devel
BuildRequires:  sqlite-devel
BuildRequires:  timezone
BuildRequires:  pkgconfig(ncurses)
BuildRequires:  pkgconfig(tk)
BuildRequires:  pkgconfig(x11)
Requires:       %{python_pkg_name}-base = %{version}
Provides:       %{python_pkg_name}-readline
Provides:       %{python_pkg_name}-sqlite3
Recommends:     %{python_pkg_name}-curses
Recommends:     %{python_pkg_name}-dbm
Recommends:     %{python_pkg_name}-pip
%if %{primary_interpreter}
Provides:       python3 = %{python_version}
Provides:       python3-readline
Provides:       python3-sqlite3
%endif
%endif
%{?suse_build_hwcaps_libs}

%description
Python 3 is modern interpreted, object-oriented programming language,
often compared to Tcl, Perl, Scheme, or Java.  You can find an overview
of Python in the documentation and tutorials included in the python3-doc
package.

This package supplies rich command line features provided by readline,
and sqlite3 support for the interpreter core, thus forming a so called
"extended" runtime.
Installing "python3" is sufficient for the vast majority of usecases.
In addition, recommended packages provide UI toolkit support (python3-curses,
python3-tk), legacy UNIX database bindings (python3-dbm), and the IDLE
development environment (python3-idle).

%package -n %{python_pkg_name}-tk
Summary:        TkInter, a Python Tk Interface
Requires:       %{python_pkg_name} = %{version}
%if %{primary_interpreter}
Provides:       python3-tk = %{version}
%endif

%description -n %{python_pkg_name}-tk
Python interface to Tk. Tk is the GUI toolkit that comes with Tcl.

%package -n %{python_pkg_name}-curses
Summary:        Python Interface to the (N)Curses Library
Requires:       %{python_pkg_name} = %{version}
%if %{primary_interpreter}
Provides:       python3-curses
%endif

%description -n %{python_pkg_name}-curses
An easy to use interface to the (n)curses CUI library. CUI stands for
Console User Interface.

%package -n %{python_pkg_name}-dbm
Summary:        Python Interface to the GDBM Library
Requires:       %{python_pkg_name} = %{version}
%if %{primary_interpreter}
Provides:       python3-dbm
%endif

%description -n %{python_pkg_name}-dbm
An easy to use interface for Unix DBM databases, and more specifically,
the GNU implementation GDBM.

%package -n %{python_pkg_name}-idle
Summary:        An Integrated Development Environment for Python
Requires:       %{python_pkg_name} = %{version}
Requires:       %{python_pkg_name}-tk
%if %{primary_interpreter}
Provides:       python3-idle = %{version}
%endif

%description -n %{python_pkg_name}-idle
IDLE is a Tkinter based integrated development environment for Python.
It features a multi-window text editor with multiple undo, Python
colorizing, and many other things, as well as a Python shell window and
a debugger.

%package -n %{python_pkg_name}-doc
Summary:        Package Documentation for Python 3
Enhances:       %{python_pkg_name} = %{python_version}
%if %{primary_interpreter}
Provides:       python3-doc = %{version}
%endif

%description -n %{python_pkg_name}-doc
Tutorial, Global Module Index, Language Reference, Library Reference,
Extending and Embedding Reference, Python/C API Reference, Documenting
Python, and Macintosh Module Reference in HTML format.

%package -n %{python_pkg_name}-doc-devhelp
Summary:        Additional Package Documentation for Python 3 in devhelp format
%if %{primary_interpreter}
Provides:       python3-doc-devhelp = %{version}
%endif

%description -n %{python_pkg_name}-doc-devhelp
Tutorial, Global Module Index, Language Reference, Library Reference,
Extending and Embedding Reference, Python/C API Reference, Documenting
Python, and Macintosh Module Reference in format for devhelp.

%package -n %{python_pkg_name}-base
Summary:        Python 3 Interpreter and Stdlib Core
Requires:       libpython%{so_version} = %{version}
Recommends:     %{python_pkg_name} = %{version}
#Recommends:     python3-ensurepip
# python 3.1 didn't have a separate python-base, so it is wrongly
# not a conflict to have python3-3.1 and python3-base > 3.1
Obsoletes:      python3 < 3.2
# no Provides, because python3 is obviously provided by package python3
# python 3.4 provides asyncio
Provides:       %{python_pkg_name}-asyncio = %{version}
# python 3.6 provides typing
Provides:       %{python_pkg_name}-typing = %{version}
# python3-xml was merged into python3, now moved into -base
Provides:       %{python_pkg_name}-xml = %{version}
%if %{primary_interpreter}
Provides:       python3-asyncio = %{version}
Obsoletes:      python3-asyncio < %{version}
Provides:       python3-base = %{version}
Obsoletes:      python3-base < %{version}
Provides:       python3-typing = %{version}
Obsoletes:      python3-typing < %{version}
Provides:       python3-xml = %{version}
Obsoletes:      python3-xml < %{version}
%endif

%description -n %{python_pkg_name}-base
Python is an interpreted, object-oriented programming language, and is
often compared to Tcl, Perl, Scheme, or Java.  You can find an overview
of Python in the documentation and tutorials included in the python-doc
package.

This package contains the interpreter core and most commonly used modules
from the standard library. This is sufficient for many usecases, but it
excludes components that depend on external libraries, most notably XML,
database and UI toolkits support.

%package -n %{python_pkg_name}-tools
Summary:        Python Utility and Demonstration Scripts
Requires:       %{python_pkg_name}-base = %{version}
Provides:       %{python_pkg_name}-2to3 = %{version}
Provides:       %{python_pkg_name}-demo = %{version}
%if %{primary_interpreter}
Provides:       python3-2to3 = %{version}
Provides:       python3-demo = %{version}
Provides:       python3-tools = %{version}
Obsoletes:      python3-2to3 < %{version}
Obsoletes:      python3-demo < %{version}
%endif

%description -n %{python_pkg_name}-tools
A number of scripts that are useful for building, testing or extending Python,
and a set of demonstration programs.

%package -n %{python_pkg_name}-devel
Summary:        Include Files and Libraries Mandatory for Building Python Modules
Requires:       %{python_pkg_name}-base = %{version}
%if %{primary_interpreter}
Provides:       python3-devel = %{version}
%endif

%description -n %{python_pkg_name}-devel
The Python programming language's interpreter can be extended with
dynamically loaded extensions and can be embedded in other programs.

This package contains header files, a static library, and development
tools for building Python modules, extending the Python interpreter or
embedding Python in applications.

This also includes the Python distutils, which were in the Python
package up to version 2.2.2.

%package -n %{python_pkg_name}-testsuite
Summary:        Unit tests for Python and its standard library
Requires:       %{python_pkg_name} = %{version}
Requires:       %{python_pkg_name}-tk = %{version}
%if %{primary_interpreter}
Provides:       python3-testsuite = %{version}
%endif

%description -n %{python_pkg_name}-testsuite
Unit tests that are useful for verifying integrity and functionality
of the installed Python interpreter and standard library.
They are a documented part of stdlib, as a module 'test'.

%package -n libpython%{so_version}
Summary:        Python Interpreter shared library
Requires:       %{python_pkg_name}-base >= %{version}

%description -n libpython%{so_version}
Python is an interpreted, object-oriented programming language, and is
often compared to Tcl, Perl, Scheme, or Java.  You can find an overview
of Python in the documentation and tutorials included in the python-doc
(HTML) or python-doc-pdf (PDF) packages.

This package contains libpython3.2 shared library for embedding in
other applications.

%prep
%setup -q -n %{tarname}

%autopatch -p1 -M 08
%if 0%{?suse_version} <= 1500
%patch -P 09 -p1
%endif
%autopatch -p1 -m 10

# drop Autoconf version requirement
sed -i 's/^AC_PREREQ/dnl AC_PREREQ/' configure.ac

%if %{primary_interpreter}
# fix shebangs - convert /usr/local/bin/python and /usr/bin/env/python to /usr/bin/python3
for dir in Lib Tools; do
    # find *.py, filter to files that contain bad shebangs
    # break up "/""usr" like this to prevent replacing with %%{_prefix}
    find $dir -name '*.py' -type f -print0 \
        | xargs -0 grep -lE '^#! *(/''usr/.*bin/(env +)?)?python' \
        | xargs sed -r -i -e '1s@^#![[:space:]]*(/''usr/(local/)?bin/(env +)?)?python([0-9]+(\.[0-9]+)?)?@#!%{_bindir}/python3@'
done
%else
# For non-primary Python, just don't bother (bsc#1193179) and remove all
# those shebangs
for dir in Lib Tools; do
    find $dir -name '*.py' -type f -exec sed -i '1{/^#!.*python/ d}' '{}' \;
done
# We shortened the file Lib/pdb.py so we have to move the test breakpoint location
sed -i -e '/Breakpoint 3 at ...pdb.py:97/s/97/96/' Lib/test/test_pdb.py
%endif

# drop in-tree libffi and expat
rm -r Modules/_ctypes/libffi* Modules/_ctypes/darwin
# Cannot remove it because of gh#python/cpython#92875
# rm -r Modules/expat

# drop duplicate README from site-packages
rm Lib/site-packages/README.txt

# Add vendored bluez-devel files
tar xvf %{SOURCE21}

# Don't fail on warnings when building documentation
sed -i -e '/^SPHINXERRORHANDLING/s/-W//' Doc/Makefile

%build
%if %{with doc}
TODAY_DATE=`date -r %{SOURCE0} "+%%B %%d, %%Y"`
# TODO use not date of tarball but date of latest patch

cd Doc
sed -i "s/^today = .*/today = '$TODAY_DATE'/" conf.py
%make_build -j1 JOBS=1 html

# Build also devhelp files
sphinx-build -a -b devhelp . build/devhelp
rm -rfv build/devhelp/.doctrees
%else
%define _lto_cflags %{nil}
# use rpm_opt_flags
export OPT="%{optflags} -DOPENSSL_LOAD_CONF -fwrapv $(pkg-config --cflags-only-I libffi) -fno-semantic-interposition"

touch -r %{SOURCE0} Makefile.pre.in

autoreconf -fvi

%if 0%{?sles_version}
sed -e 's/-fprofile-correction//' -i Makefile.pre.in
%endif

export CFLAGS="%{optflags} -IVendor/"

%configure \
    --with-platlibdir=%{_lib} \
    --docdir=%{_docdir}/python \
    --enable-ipv6 \
    --enable-shared \
    --with-ensurepip=no \
    --with-system-ffi \
    --with-system-expat \
    --with-lto \
%if 0%{?suse_version} >= 1550 || 0%{?sle_version} >= 150400
    --with-ssl-default-suites=openssl \
%endif
%if %{with profileopt}
    --enable-optimizations \
%endif
%if %{with mpdecimal}
    --with-system-libmpdec \
%endif
    --enable-loadable-sqlite-extensions

# prevent make from trying to rebuild PYTHON_FOR_GEN stuff
# %%make_build -t Python/Python-ast.c \
        # Include/Python-ast.h \
        # Objects/typeslots.inc \
        # Python/opcode_targets.h \
        # Include/opcode.h
%make_build

%if %{with general}
%make_build
%endif
%if %{with base}
%if %{with profileopt}
    target=profile-opt
%else
    target=all
%endif
LD_LIBRARY_PATH=.:$LD_LIBRARY_PATH \
    %make_build $target
%endif
%endif

%check
export SUSE_VERSION="0%{?suse_version}"
export SLE_VERSION="0%{?sle_version}"
%if %{with general}
# exclude test_gdb -- it doesn't run in buildservice anyway, and fails on missing debuginfos
# when you install gdb into your test env
EXCLUDE="test_gdb"
# we patch out the message to recommend zypper in and thus this would fail
EXCLUDE="$EXCLUDE test_pydoc"

%ifarch %{arm} s390x
# test_multiprocessing_forkserver is racy
EXCLUDE="$EXCLUDE test_multiprocessing_forkserver"
%endif
%ifarch ppc ppc64 ppc64le
# exclue test_faulthandler due to bnc#831629
EXCLUDE="$EXCLUDE test_faulthandler"
%endif
# some tests break in QEMU
%if 0%{?qemu_user_space_build}
EXCLUDE="$EXCLUDE test_faulthandler test_multiprocessing_forkserver test_multiprocessing_spawn test_os test_posix test_signal test_socket test_subprocess"
%endif

# This test (part of test_uuid) requires real network interfaces
# so that ifconfig output has "HWaddr <something>".  Some kvm instances
# done have any such interface breaking the uuid module.
EXCLUDE="$EXCLUDE test_uuid"

# bsc#1195140 and bpo#37169 - test_capi is failing on openSUSE, and not sure why
EXCLUDE="$EXCLUDE test_capi"

# Limit virtual memory to avoid spurious failures
if test $(ulimit -v) = unlimited || test $(ulimit -v) -gt 10000000; then
  ulimit -v 11000000 || :
fi

# test_freeze_simple_script in test.test_tools.test_freeze.TestFreeze
# uses CONFIG_ARGS to run ./configure.
export CONFIG_ARGS="--enable-ipv6 --enable-shared --with-ensurepip=no \
    --with-system-ffi --with-system-expat --with-lto --enable-optimizations \
    --with-system-libmpdec --enable-loadable-sqlite-extensions"

export PYTHONPATH="$(pwd -P)/Lib"
# Use timeout, like make target buildbottest
# We cannot run tests parallel, because osc build environment doesn’t
# have /dev/shm
%make_build -j1 test TESTOPTS="-u curses -v -x $EXCLUDE --timeout=5400"
# use network, be verbose:
#make test TESTOPTS="-l -u network -v"
%endif

%install
%if %{with doc}
export PDOCS=%{buildroot}%{_docdir}/python%{python_version}
mkdir -p $PDOCS
# generated docs
rm Doc/build/*/.buildinfo
cp -r Doc/build/html $PDOCS
# misc
install -d -m 755 $PDOCS/Misc
rm Misc/README.AIX
for i in Misc/* ; do
  [ -f $i ] && install -c -m 644 $i $PDOCS/Misc/
done
# devhelp
mkdir -p %{buildroot}%{_datadir}/gtk-doc/html
cp -r Doc/build/devhelp %{buildroot}%{_datadir}/gtk-doc/html/Python%{python_version}
rm -rf %{buildroot}%{_datadir}/gtk-doc/html/Python%{python_version}/.doctrees
%endif
%if %{with general}
%make_install

# clean out stuff that is in python-base and subpackages

find %{buildroot}%{_bindir} -mindepth 1 -not -name "*idle3*" -print -delete
rm %{buildroot}%{_libdir}/lib*
rm -r %{buildroot}%{_libdir}/pkgconfig
rm -r %{buildroot}%{_mandir}/*
rm -r %{buildroot}%{_includedir}/*

rm -r %{buildroot}%{sitedir}/config*
find %{buildroot}%{sitedir} -name "*.egg-info" -delete
rm -r %{buildroot}%{sitedir}/__pycache__
rm -r %{buildroot}%{sitedir}/site-packages
rm %{buildroot}%{sitedir}/*.*

for module in \
    asyncio ctypes collections concurrent distutils email encodings \
    ensurepip html http re \
    importlib json logging multiprocessing pydoc_data unittest \
    urllib venv wsgiref lib2to3 test tomllib turtledemo \
    xml xmlrpc zoneinfo __phello__
do
    rm -r %{buildroot}%{sitedir}/$module
done

for library in \
    array _asyncio audioop binascii _bisect _bz2 cmath _codecs_* \
    _contextvars _crypt _csv _ctypes _datetime _decimal fcntl grp \
    _hashlib _heapq _json _lsprof _lzma math mmap _multibytecodec \
    _multiprocessing _opcode ossaudiodev _pickle _posixshmem \
    _posixsubprocess _queue _random resource select _ssl _socket spwd \
    _statistics _struct syslog termios _testbuffer _testimportmultiple \
    _testmultiphase unicodedata zlib _ctypes_test _testinternalcapi _testcapi \
    _typing _testclinic xxlimited xxlimited_35 \
    _xxtestfuzz _xxsubinterpreters _elementtree pyexpat _md5 _sha1 \
    _sha256 _sha512 _blake2 _sha3 _uuid _zoneinfo
do
    eval rm "%{buildroot}%{sitedir}/lib-dynload/$library.*"
done

# Idle is not packaged in base due to the appstream-glib dependency
# move idle config into /etc
install -d -m 755 %{buildroot}%{_sysconfdir}/idle%{python_version}
(
    cd %{buildroot}/%{sitedir}/idlelib/
    for file in *.def ; do
        mv $file %{buildroot}%{_sysconfdir}/idle%{python_version}/
        ln -sf %{_sysconfdir}/idle%{python_version}/$file  %{buildroot}/%{sitedir}/idlelib/
    done
)

# keep just idle3.X
rm %{buildroot}%{_bindir}/idle3

# install idle icons
for size in 16 32 48 ; do
    install -m 644 -D Lib/idlelib/Icons/idle_${size}.png \
    %{buildroot}%{_datadir}/icons/hicolor/${size}x${size}/apps/idle%{python_version}.png
done

# install idle desktop file
cp %{SOURCE19} idle%{python_version}.desktop
sed -i -e 's:idle3:idle%{python_version}:g' idle%{python_version}.desktop
install -m 644 -D -t %{buildroot}%{_datadir}/applications idle%{python_version}.desktop

cp %{SOURCE20} idle%{python_version}.appdata.xml
sed -i -e 's:idle3.desktop:idle%{python_version}.desktop:g' idle%{python_version}.appdata.xml
install -m 644 -D -t %{buildroot}%{_datadir}/metainfo idle%{python_version}.appdata.xml
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/idle%{python_version}.appdata.xml

%fdupes %{buildroot}/%{_libdir}/python%{python_version}
%endif
%if %{with base}
%make_install

# remove .a
find %{buildroot} -name "*.a" -delete

# install "site-packages" and __pycache__ for third parties
install -d -m 755 %{buildroot}%{sitedir}/site-packages
install -d -m 755 %{buildroot}%{sitedir}/site-packages/__pycache__
# and their 32bit counterparts explicitly
mkdir -p %{buildroot}%{_prefix}/lib/python%{python_version}/site-packages/__pycache__

# cleanup parts that don't belong
for dir in curses dbm sqlite3 tkinter idlelib; do
    find "%{buildroot}/%{sitedir}/$dir"/* -maxdepth 0 -name "test" -o -exec rm -rf {} +
done
rm -fv %{buildroot}%{dynlib nis}

# overwrite the copied binary with a link
ln -sf python%{python_version} %{buildroot}%{_bindir}/python3

# decide to ship python3 or just python3.X
%if !%{primary_interpreter}
# base
rm %{buildroot}%{_bindir}/python3
rm %{buildroot}%{_bindir}/pydoc3
rm %{buildroot}%{_mandir}/man1/python3.1
# devel
rm %{buildroot}%{_bindir}/python3-config
rm %{buildroot}%{_libdir}/libpython3.so
rm %{buildroot}%{_libdir}/pkgconfig/{python3,python3-embed}.pc
%endif

%if %{with externally_managed}
# PEP-0668 mark this as a distro maintained python
sed -e 's,__PYTHONPREFIX__,%{python_pkg_name},' -e 's,__PYTHON__,python%{python_version},' < %{SOURCE4} > %{buildroot}%{sitedir}/EXTERNALLY-MANAGED
%endif

# link shared library instead of static library that tools expect
ln -s ../../libpython%{python_abi}.so %{buildroot}%{_libdir}/python%{python_version}/config-%{python_abi}-%{archname}-%{_os}%{?_gnu}%{?armsuffix}/libpython%{python_abi}.so

# delete idle3, which has to many packaging dependencies for base
rm %{buildroot}%{_bindir}/idle3*

# delete the generic 2to3 binary if we are not primary
%if !%{primary_interpreter}
rm %{buildroot}%{_bindir}/2to3
%endif

# replace duplicate .pyo/.pyc with hardlinks
%fdupes %{buildroot}/%{sitedir}

# documentation
export PDOCS=%{buildroot}%{_docdir}/%{name}
install -d -m 755 $PDOCS
install -c -m 644 %{SOURCE3} $PDOCS/
install -c -m 644 README.rst $PDOCS/

# tools
for x in `find Tools/ \( -not -name Makefile \) -print | sort` ; do
  test -d $x && ( install -c -m 755 -d $PDOCS/$x ) \
             || ( install -c -m 644 $x $PDOCS/$x )
done
# gdb script is shipped with devel subpackage
rm -r $PDOCS/Tools/gdb
# clean up the bat files
find "$PDOCS" -name "*.bat" -delete

# put gdb helper script into place
install -m 755 -D Tools/gdb/libpython.py %{buildroot}%{_datadir}/gdb/auto-load/%{_libdir}/libpython%{python_abi}.so.%{so_major}.%{so_minor}-gdb.py

# install devel files to /config
#cp Makefile Makefile.pre.in Makefile.pre $RPM_BUILD_ROOT%%{sitedir}/config-%%{python_abi}/

# Remove -IVendor/ from python-config boo#1231795
sed -i 's/-IVendor\///' %{buildroot}%{_bindir}/python%{python_abi}-config

# RPM macros
%if %{primary_interpreter}
mkdir -p %{buildroot}%{_rpmconfigdir}/macros.d/
install -m 644 %{SOURCE7} %{buildroot}%{_rpmconfigdir}/macros.d/ # macros.python3
%endif

# import_failed hooks
FAILDIR=%{buildroot}/%{sitedir}/_import_failed
mkdir $FAILDIR
install -m 644 %{SOURCE8} %{SOURCE9} $FAILDIR # import_failed.*
LD_LIBRARY_PATH=. ./python -c "from py_compile import compile; compile('$FAILDIR/import_failed.py', dfile='%{sitedir}/_import_failed/import_failed.py')"
LD_LIBRARY_PATH=. ./python -O -c "from py_compile import compile; compile('$FAILDIR/import_failed.py', dfile='%{sitedir}/_import_failed/import_failed.py')"
(
    cd $FAILDIR
    while read package modules; do
        for module in $modules; do
            ln import_failed.py $module.py
            pushd __pycache__
            for i in import_failed*; do
                ln $i "$module${i#import_failed}"
            done
            popd
        done
    done < %{SOURCE9}
)
echo %{sitedir}/_import_failed > %{buildroot}/%{sitedir}/site-packages/zzzz-import-failed-hooks.pth
%endif

# For the purposes of reproducibility, it is necessary to eliminate any *.pyc files inside documentation dirs
if [ -d %{buildroot}%{_defaultdocdir} ] ; then
find %{buildroot}%{_defaultdocdir} -type f -name \*.pyc -ls -exec rm -vf '{}' \;
fi

%if %{with general}
%files -n %{python_pkg_name}-tk
%{sitedir}/tkinter
%exclude %{sitedir}/tkinter/test
%{dynlib _tkinter}

%files -n %{python_pkg_name}-curses
%{sitedir}/curses
%{dynlib _curses}
%{dynlib _curses_panel}

%files -n %{python_pkg_name}-dbm
%{sitedir}/dbm
%{dynlib _dbm}
%{dynlib _gdbm}

%files -n %{python_pkg_name}
%dir %{sitedir}
%dir %{sitedir}/lib-dynload
%{sitedir}/sqlite3
%exclude %{sitedir}/sqlite3/test
%{dynlib readline}
%{dynlib _sqlite3}
%if 0%{?suse_version} < 1599
%{dynlib nis}
%endif

%files -n %{python_pkg_name}-idle
%{sitedir}/idlelib
%dir %{_sysconfdir}/idle%{python_version}
%config %{_sysconfdir}/idle%{python_version}/*
%doc Lib/idlelib/README.txt
%doc Lib/idlelib/TODO.txt
%doc Lib/idlelib/extend.txt
%doc Lib/idlelib/ChangeLog
%{_bindir}/idle%{python_version}
%{_datadir}/applications/idle%{python_version}.desktop
%{_datadir}/metainfo/idle%{python_version}.appdata.xml
%{_datadir}/icons/hicolor/*/apps/idle%{python_version}.png
%dir %{_datadir}/icons/hicolor
%dir %{_datadir}/icons/hicolor/16x16
%dir %{_datadir}/icons/hicolor/32x32
%dir %{_datadir}/icons/hicolor/48x48
%dir %{_datadir}/icons/hicolor/*/apps
# endif for if general
%endif

%if %{with doc}
%files -n %{python_pkg_name}-doc
%dir %{_docdir}/python%{python_version}
%doc %{_docdir}/python%{python_version}/Misc
%doc %{_docdir}/python%{python_version}/html

%files -n %{python_pkg_name}-doc-devhelp
%dir %{_datadir}/gtk-doc
%dir %{_datadir}/gtk-doc/html
%doc %{_datadir}/gtk-doc/html/Python%{python_version}
%endif

%if %{with base}
%post -n libpython%{so_version} -p /sbin/ldconfig
%postun -n libpython%{so_version} -p /sbin/ldconfig

%files -n libpython%{so_version}
%{_libdir}/libpython%{python_abi}.so.%{so_major}.%{so_minor}

%files -n %{python_pkg_name}-tools
%{sitedir}/turtledemo
%if %{primary_interpreter}
%{_bindir}/2to3
%endif
%attr(755, root, root)%{_bindir}/2to3-%{python_version}
%doc %{_docdir}/%{name}/Tools

%files -n %{python_pkg_name}-devel
%{_libdir}/libpython%{python_abi}.so
%if %{primary_interpreter}
%{_libdir}/libpython3.so
%endif
%{_libdir}/pkgconfig/*
%{_includedir}/python%{python_abi}
%{sitedir}/config-%{python_abi}-*
%{_bindir}/python%{python_abi}-config
%if %{primary_interpreter}
%{_bindir}/python3-config
%endif
# Own these directories to not depend on gdb
%dir %{_datadir}/gdb
%dir %{_datadir}/gdb/auto-load
%dir %{_datadir}/gdb/auto-load%{_prefix}
%dir %{_datadir}/gdb/auto-load%{_libdir}
%{_datadir}/gdb/auto-load/%{_libdir}/libpython%{python_abi}.so.%{so_major}.%{so_minor}-gdb.py

%files -n %{python_pkg_name}-testsuite
%{sitedir}/test
%{sitedir}/*/test
%{sitedir}/*/tests
%{dynlib _ctypes_test}
%{dynlib _testbuffer}
%{dynlib _testcapi}
%{dynlib _testclinic}
%{dynlib _testinternalcapi}
%{dynlib _testimportmultiple}
%{dynlib _testmultiphase}
%{dynlib xxlimited}
# workaround for missing packages
%dir %{sitedir}/sqlite3
%dir %{sitedir}/tkinter

%files -n %{python_pkg_name}-base
# docs
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README.rst
%license LICENSE
%doc %{_docdir}/%{name}/README.SUSE
%if %{primary_interpreter}
%{_mandir}/man1/python3.1%{?ext_man}
%endif
%{_mandir}/man1/python%{python_version}.1%{?ext_man}
%if %{with externally_managed}
# PEP-0668
%{sitedir}/EXTERNALLY-MANAGED
%endif
# license text, not a doc because the code can use it at run-time
%{sitedir}/LICENSE.txt
# RPM macros
%if %{primary_interpreter}
%{_rpmconfigdir}/macros.d/macros.python3
%endif
# binary parts
%dir %{sitedir}/lib-dynload
%{dynlib array}
%{dynlib _asyncio}
%{dynlib audioop}
%{dynlib binascii}
%{dynlib _bisect}
%{dynlib _bz2}
%{dynlib cmath}
%{dynlib _codecs_cn}
%{dynlib _codecs_hk}
%{dynlib _codecs_iso2022}
%{dynlib _codecs_jp}
%{dynlib _codecs_kr}
%{dynlib _codecs_tw}
%{dynlib _contextvars}
%{dynlib _crypt}
%{dynlib _csv}
%{dynlib _ctypes}
%{dynlib _datetime}
%{dynlib _decimal}
%{dynlib _elementtree}
%{dynlib fcntl}
%{dynlib grp}
%{dynlib _hashlib}
%{dynlib _heapq}
%{dynlib _json}
%{dynlib _lsprof}
%{dynlib _lzma}
%{dynlib math}
%{dynlib mmap}
%{dynlib _multibytecodec}
%{dynlib _multiprocessing}
%{dynlib _opcode}
%{dynlib ossaudiodev}
%{dynlib _pickle}
%{dynlib _posixshmem}
%{dynlib _posixsubprocess}
%{dynlib pyexpat}
%{dynlib _queue}
%{dynlib _random}
%{dynlib resource}
%{dynlib select}
%{dynlib _socket}
%{dynlib spwd}
%{dynlib _ssl}
%{dynlib _statistics}
%{dynlib _struct}
%{dynlib syslog}
%{dynlib termios}
%{dynlib _typing}
%{dynlib unicodedata}
%{dynlib _uuid}
%{dynlib _xxsubinterpreters}
%{dynlib _xxtestfuzz}
%{dynlib xxlimited_35}
%{dynlib zlib}
%{dynlib _zoneinfo}
# hashlib fallback modules
%{dynlib _blake2}
%{dynlib _md5}
%{dynlib _sha1}
%{dynlib _sha256}
%{dynlib _sha512}
%{dynlib _sha3}
# python parts
%dir %{_prefix}/lib/python%{python_version}
%dir %{_prefix}/lib/python%{python_version}/site-packages
%dir %{_prefix}/lib/python%{python_version}/site-packages/__pycache__
%dir %{sitedir}
%dir %{sitedir}/site-packages
%dir %{sitedir}/site-packages/__pycache__
%exclude %{sitedir}/*/test
%exclude %{sitedir}/*/tests
%{sitedir}/*.py
%{sitedir}/asyncio
%{sitedir}/ctypes
%{sitedir}/collections
%{sitedir}/concurrent
%{sitedir}/distutils
%{sitedir}/email
%{sitedir}/encodings
%{sitedir}/ensurepip
%{sitedir}/html
%{sitedir}/http
%{sitedir}/importlib
%{sitedir}/json
%{sitedir}/lib2to3
%{sitedir}/logging
%{sitedir}/multiprocessing
%{sitedir}/pydoc_data
%{sitedir}/re
%{sitedir}/tomllib
%{sitedir}/unittest
%{sitedir}/urllib
%{sitedir}/venv
%{sitedir}/wsgiref
%{sitedir}/xml
%{sitedir}/xmlrpc
%{sitedir}/zoneinfo
%{sitedir}/__phello__
%{sitedir}/__pycache__
# import-failed hooks
%{sitedir}/_import_failed
%{sitedir}/site-packages/zzzz-import-failed-hooks.pth
# symlinks
%if %{primary_interpreter}
%{_bindir}/python3
%{_bindir}/pydoc3
%endif
# executables
%attr(755, root, root) %{_bindir}/pydoc%{python_version}
# %%attr(755, root, root) %%{_bindir}/python%%{python_abi}
%attr(755, root, root) %{_bindir}/python%{python_version}
# endif for if base
%endif

%changelog
* Fri Aug  1 2025 mcepl@cepl.eu
- Add CVE-2025-8194-tarfile-no-neg-offsets.patch which now
  validates archives to ensure member offsets are non-negative
  (gh#python/cpython#130577, CVE-2025-8194, bsc#1247249).
* Wed Jul  2 2025 mcepl@cepl.eu
- Add CVE-2025-6069-quad-complex-HTMLParser.patch to avoid worst
  case quadratic complexity when processing certain crafted
  malformed inputs with HTMLParser (CVE-2025-6069, bsc#1244705).
* Tue Jul  1 2025 daniel.garcia@suse.com
- Use one core to build doc. This will make sphinx doc build
  reproducible.
  bsc#1243155
* Mon Jun  9 2025 mcepl@cepl.eu
- Update to 3.11.13:
  - Security
  - gh-135034: Fixes multiple issues that allowed tarfile
    extraction filters (filter="data" and filter="tar")
    to be bypassed using crafted symlinks and hard links.
    Addresses CVE-2024-12718 (bsc#1244056), CVE-2025-4138
    (bsc#1244059), CVE-2025-4330 (bsc#1244060), and
    CVE-2025-4517 (bsc#1244032). Also addresses CVE-2025-4435
    (gh#135034, bsc#1244061).
  - gh-133767: Fix use-after-free in the “unicode-escape”
    decoder with a non-“strict” error handler (CVE-2025-4516,
    bsc#1243273).
  - gh-128840: Short-circuit the processing of long IPv6
    addresses early in ipaddress to prevent excessive memory
    consumption and a minor denial-of-service.
  - Library
  - gh-128840: Fix parsing long IPv6 addresses with embedded
    IPv4 address.
  - gh-134062: ipaddress: fix collisions in __hash__() for
    IPv4Network and IPv6Network objects.
  - gh-123409: Fix ipaddress.IPv6Address.reverse_pointer output
    according to RFC 3596, §2.5. Patch by Bénédikt Tran.
  - bpo-43633: Improve the textual representation of
    IPv4-mapped IPv6 addresses (RFC 4291 Sections 2.2, 2.5.5.2)
    in ipaddress. Patch by Oleksandr Pavliuk.
- Remove upstreamed patches:
  - gh-126572-test_ssl-no-stop-ThreadedEchoServer-OSError.patch
  - CVE-2025-4516-DecodeError-handler.patch
* Thu May 22 2025 mcepl@cepl.eu
- Add CVE-2025-4516-DecodeError-handler.patch fixing
  CVE-2025-4516 (bsc#1243273) blocking DecodeError handling
  vulnerability, which could lead to DoS.
* Sat May 17 2025 mcepl@cepl.eu
- Use extended %%autopatch.
* Sat May 10 2025 mcepl@cepl.eu
- Remove python-3.3.0b1-test-posix_fadvise.patch (not needed
  since kernel 3.6-rc1)
* Fri Apr 18 2025 mcepl@cepl.eu
- Update to 3.11.12:
  - gh-131809: Update bundled libexpat to 2.7.1
  - gh-131261: Upgrade to libexpat 2.7.0
  - gh-105704: When using urllib.parse.urlsplit() and
    urllib.parse.urlparse() host parsing would not reject domain
    names containing square brackets ([ and ]). Square brackets
    are only valid for IPv6 and IPvFuture hosts according to RFC
    3986 Section 3.2.2 (bsc#1236705, CVE-2025-0938,
    gh#python/cpython#105704).
  - gh-121284: Fix bug in the folding of rfc2047 encoded-words
    when flattening an email message using a modern email
    policy. Previously when an encoded-word was too long for
    a line, it would be decoded, split across lines, and
    re-encoded. But commas and other special characters in the
    original text could be left unencoded and unquoted. This
    could theoretically be used to spoof header lines using a
    carefully constructed encoded-word if the resulting rendered
    email was transmitted or re-parsed.
  - gh-80222: Fix bug in the folding of quoted strings
    when flattening an email message using a modern email
    policy. Previously when a quoted string was folded so that
    it spanned more than one line, the surrounding quotes and
    internal escapes would be omitted. This could theoretically
    be used to spoof header lines using a carefully constructed
    quoted string if the resulting rendered email was transmitted
    or re-parsed.
  - gh-119511: Fix a potential denial of service in the imaplib
    module. When connecting to a malicious server, it could
    cause an arbitrary amount of memory to be allocated. On many
    systems this is harmless as unused virtual memory is only
    a mapping, but if this hit a virtual address size limit
    it could lead to a MemoryError or other process crash. On
    unusual systems or builds where all allocated memory is
    touched and backed by actual ram or storage it could’ve
    consumed resources doing so until similarly crashing.
  - gh-127257: In ssl, system call failures that OpenSSL reports
    using ERR_LIB_SYS are now raised as OSError.
  - gh-121277: Writers of CPython’s documentation can now use
    next as the version for the versionchanged, versionadded,
    deprecated directives.
  - gh-106883: Disable GC during the _PyThread_CurrentFrames()
    and _PyThread_CurrentExceptions() calls to avoid the
    interpreter to deadlock.
- Remove upstreamed patch:
  - CVE-2025-0938-sq-brackets-domain-names.patch
- Add gh-126572-test_ssl-no-stop-ThreadedEchoServer-OSError.patch
  which makes test_ssl not to stop ThreadedEchoServer on OSError,
  which makes test_ssl pass with OpenSSL 3.5 (bsc#1241067,
  gh#python/cpython!126572)
* Wed Mar 12 2025 bwiedemann@suse.com
- Allow to disable PGO
* Mon Mar 10 2025 bwiedemann@suse.com
- Skip PGO with %%want_reproducible_builds (bsc#1239210)
* Tue Feb  4 2025 mcepl@cepl.eu
- Add CVE-2025-0938-sq-brackets-domain-names.patch which
  disallows square brackets ([ and ]) in domain names for parsed
  URLs (bsc#1236705, CVE-2025-0938, gh#python/cpython#105704)
* Mon Jan 27 2025 daniel.garcia@suse.com
- Configure externally_managed with a bcond
  https://en.opensuse.org/openSUSE:Python:Externally_managed
  bsc#1228165
* Wed Dec  4 2024 mcepl@cepl.eu
- Update to 3.11.11:
  - Tools/Demos
  - gh-123418: Update GitHub CI workflows to use OpenSSL 3.0.15
    and multissltests to use 3.0.15, 3.1.7, and 3.2.3.
  - Tests
  - gh-125041: Re-enable skipped tests for zlib on the
    s390x architecture: only skip checks of the compressed
    bytes, which can be different between zlib’s software
    implementation and the hardware-accelerated implementation.
  - Security
  - gh-126623: Upgrade libexpat to 2.6.4
  - gh-122792: Changed IPv4-mapped ipaddress.IPv6Address to
    consistently use the mapped IPv4 address value for deciding
    properties. Properties which have their behavior fixed are
    is_multicast, is_reserved, is_link_local, is_global, and
    is_unspecified.
  - Library
  - gh-124651: Properly quote template strings in venv
    activation scripts (bsc#1232241, CVE-2024-9287).
- Removed upstreamed patches:
  - CVE-2024-9287-venv_path_unquoted.patch
* Tue Dec  3 2024 adrian.glaubitz@suse.com
- Add add-loongarch64-support.patch to support loongarch64
* Mon Dec  2 2024 mcepl@suse.com
- Fix changelog
* Mon Nov 11 2024 daniel.garcia@suse.com
- Remove -IVendor/ from python-config boo#1231795
* Fri Nov  1 2024 mcepl@cepl.eu
- Add CVE-2024-9287-venv_path_unquoted.patch to properly quote
  path names provided when creating a virtual environment
  (bsc#1232241, CVE-2024-9287)
* Wed Oct  2 2024 mcepl@cepl.eu
- Drop .pyc files from docdir for reproducible builds
  (bsc#1230906).
* Mon Sep  9 2024 mcepl@cepl.eu
- Update to 3.11.10:
  - Security
  - gh-123678: Upgrade libexpat to 2.6.3
  - gh-121957: Fixed missing audit events around interactive
    use of Python, now also properly firing for ``python -i``,
    as well as for ``python -m asyncio``. The event in question
    is ``cpython.run_stdin``.
  - gh-122133: Authenticate the socket connection for the
    ``socket.socketpair()`` fallback on platforms where
    ``AF_UNIX`` is not available like Windows. Patch by
    Gregory P. Smith <greg@krypto.org> and Seth Larson
    <seth@python.org>. Reported by Ellie <el@horse64.org>
  - gh-121285: Remove backtracking from tarfile header parsing
    for ``hdrcharset``, PAX, and GNU sparse headers
    (bsc#1230227, CVE-2024-6232).
  - gh-118486: :func:`os.mkdir` on Windows now accepts
  * mode* of ``0o700`` to restrict the new directory to
    the current user. This fixes CVE-2024-4030 affecting
    :func:`tempfile.mkdtemp` in scenarios where the base
    temporary directory is more permissive than the default.
  - gh-116741: Update bundled libexpat to 2.6.2
  - Library
  - gh-123270: Applied a more surgical fix for malformed
    payloads in :class:`zipfile.Path` causing infinite loops
    (gh-122905) without breaking contents using legitimate
    characters (bsc#1229704, CVE-2024-8088).
  - gh-123067: Fix quadratic complexity in parsing ``"``-quoted
    cookie values with backslashes by :mod:`http.cookies`
    (bsc#1229596, CVE-2024-7592).
  - gh-122905: :class:`zipfile.Path` objects now sanitize names
    from the zipfile.
  - gh-121650: :mod:`email` headers with embedded newlines are
    now quoted on output. The :mod:`~email.generator` will now
    refuse to serialize (write) headers that are unsafely folded
    or delimited; see :attr:`~email.policy.Policy.verify_generated_headers`.
    (Contributed by Bas Bloemsaat and Petr Viktorin in
    :gh:`121650`; CVE-2024-6923, bsc#1228780).
  - gh-119506: Fix :meth:`!io.TextIOWrapper.write` method
    breaks internal buffer when the method is called again
    during flushing internal buffer.
  - gh-118643: Fix an AttributeError in the :mod:`email` module
    when re-fold a long address list. Also fix more cases of
    incorrect encoding of the address separator in the address
    list.
  - gh-113171: Fixed various false positives and false
    negatives in * :attr:`ipaddress.IPv4Address.is_private`
    (see these docs for details) *
    :attr:`ipaddress.IPv4Address.is_global` *
    :attr:`ipaddress.IPv6Address.is_private` *
    :attr:`ipaddress.IPv6Address.is_global` Also in the
    corresponding :class:`ipaddress.IPv4Network` and
    :class:`ipaddress.IPv6Network` attributes.
    Fixes bsc#1226448 (CVE-2024-4032).
  - gh-102988: :func:`email.utils.getaddresses` and
    :func:`email.utils.parseaddr` now return ``('', '')``
    2-tuples in more situations where invalid email addresses
    are encountered instead of potentially inaccurate
    values. Add optional *strict* parameter to these two
    functions: use ``strict=False`` to get the old behavior,
    accept malformed inputs. ``getattr(email.utils,
    'supports_strict_parsing', False)`` can be use to check if
    the *strict* paramater is available. Patch by Thomas Dwyer
    and Victor Stinner to improve the CVE-2023-27043 fix
    (bsc#1210638).
  - gh-67693: Fix :func:`urllib.parse.urlunparse` and
    :func:`urllib.parse.urlunsplit` for URIs with path starting
    with multiple slashes and no authority. Based on patch by
    Ashwin Ramaswami.
  - Core and Builtins
  - gh-112275: A deadlock involving ``pystate.c``'s
    ``HEAD_LOCK`` in ``posixmodule.c`` at fork is now
    fixed. Patch by ChuBoning based on previous Python 3.12 fix
    by Victor Stinner.
  - gh-109120: Added handle of incorrect star expressions, e.g
    ``f(3, *)``. Patch by Grigoryev Semyon
- Removed upstreamed patches:
  - CVE-2023-27043-email-parsing-errors.patch
  - CVE-2024-4032-private-IP-addrs.patch
  - CVE-2024-6923-email-hdr-inject.patch
  - CVE-2024-8088-inf-loop-zipfile_Path.patch
    (renamed from CVE-2024-8088-zipfile-Path-sanitization.patch)
  - CVE-2024-6232-ReDOS-backtrack-tarfile.patch
  - CVE-2024-7592-quad-complex-cookies.patch
* Mon Sep  2 2024 mcepl@cepl.eu
- Add gh120226-fix-sendfile-test-kernel-610.patch to avoid
  failing test_sendfile_close_peer_in_the_middle_of_receiving
  tests on Linux >= 6.10 (GH-120227).
* Wed Aug 28 2024 mcepl@cepl.eu
- Add CVE-2024-8088-inf-loop-zipfile_Path.patch to prevent
  malformed payload to cause infinite loops in zipfile.Path
  (bsc#1229704, CVE-2024-8088).
* Wed Aug  7 2024 mcepl@suse.com
- Add CVE-2024-6923-email-hdr-inject.patch to prevent email
  header injection due to unquoted newlines (bsc#1228780,
  CVE-2024-6923).
- %%{profileopt} variable is set according to the variable
  %%{do_profiling} (bsc#1227999)
* Mon Jul 22 2024 mcepl@cepl.eu
- Remove %%suse_update_desktop_file macro as it is not useful any
  more.
* Thu Jul 18 2024 mcepl@cepl.eu
- Adding bso1227999-reproducible-builds.patch fixing bsc#1227999
  adding reproducibility patches from gh#python/cpython!121872
  and gh#python/cpython!121883.
* Mon Jul 15 2024 mcepl@cepl.eu
- Stop using %%%%defattr, it seems to be breaking proper executable
  attributes on /usr/bin/ scripts (bsc#1227378).
* Tue Jul  2 2024 daniel.garcia@suse.com
- Update F00251-change-user-install-location.patch to make pip and
  modern tools install directly in /usr/local when used by the user.
  bsc#1225660
* Tue Jun 25 2024 mcepl@cepl.eu
- Add CVE-2024-4032-private-IP-addrs.patch to fix bsc#1226448
  (CVE-2024-4032) rearranging definition of private v global IP
  addresses.
* Wed May  1 2024 mcepl@suse.com
- Update CVE-2023-52425-libexpat-2.6.0-backport.patch
  so that it uses features sniffing, not just
  comparing version number. Include also
  support-expat-CVE-2022-25236-patched.patch.
- Add CVE-2023-52425-remove-reparse_deferral-tests.patch skipping
  failing tests.
- Refresh patches:
  - CVE-2023-27043-email-parsing-errors.patch
  - fix_configure_rst.patch
  - skip_if_buildbot-extend.patch
- Remove included patch:
  - support-expat-CVE-2022-25236-patched.patch
* Mon Apr 15 2024 daniel.garcia@suse.com
- Add CVE-2023-52425-libexpat-2.6.0-backport.patch to fix tests with
  patched libexpat below 2.6.0 that doesn't update the version number,
  just in SLE.
* Mon Apr  8 2024 daniel.garcia@suse.com
- Remove not needed upstream patches:
  * libexpat260.patch
  * CVE-2023-6597-TempDir-cleaning-symlink.patch, bsc#1219666
  * CVE-2024-0397-memrace_ssl.SSLContext_cert_store.patch
- Update to 3.11.9:
  * Security
  - gh-115398: Allow controlling Expat >=2.6.0 reparse deferral
    (CVE-2023-52425,  bsc#1219559) by adding five new methods:
    xml.etree.ElementTree.XMLParser.flush()
    xml.etree.ElementTree.XMLPullParser.flush()
    xml.parsers.expat.xmlparser.GetReparseDeferralEnabled()
    xml.parsers.expat.xmlparser.SetReparseDeferralEnabled()
    xml.sax.expatreader.ExpatParser.flush()
  - gh-115399: Update bundled libexpat to 2.6.0
  - gh-115243: Fix possible crashes in collections.deque.index()
    when the deque is concurrently modified.
  - gh-114572: ssl.SSLContext.cert_store_stats() and
    ssl.SSLContext.get_ca_certs() now correctly lock access to the
    certificate store, when the ssl.SSLContext is shared across
    multiple threads (bsc#1226447, CVE-2024-0397).
  * Core and Builtins
  - gh-116296: Fix possible refleak in object.__reduce__() internal
    error handling.
  - gh-116034: Fix location of the error on a failed assertion.
  - gh-115823: Properly calculate error ranges in the parser when
    raising SyntaxError exceptions caused by invalid byte sequences.
    Patch by Pablo Galindo
  - gh-112087: For an empty reverse iterator for list will be
    reduced to reversed(). Patch by Donghee Na.
  - gh-115011: Setters for members with an unsigned integer type now
    support the same range of valid values for objects that has a
    __index__() method as for int.
  - gh-96497: Fix incorrect resolution of mangled class variables
    used in assignment expressions in comprehensions.
  * Library
  - gh-117310: Fixed an unlikely early & extra Py_DECREF triggered
    crash in ssl when creating a new _ssl._SSLContext if CPython was
    built implausibly such that the default cipher list is empty or
    the SSL library it was linked against reports a failure from its
    C SSL_CTX_set_cipher_list() API.
  - gh-117178: Fix regression in lazy loading of self-referential
    modules, introduced in gh-114781.
  - gh-117084: Fix zipfile extraction for directory entries with the
    name containing backslashes on Windows.
  - gh-117110: Fix a bug that prevents subclasses of typing.Any to
    be instantiated with arguments. Patch by Chris Fu.
  - gh-90872: On Windows, subprocess.Popen.wait() no longer calls
    WaitForSingleObject() with a negative timeout: pass 0 ms if the
    timeout is negative. Patch by Victor Stinner.
  - gh-116957: configparser: Don’t leave ConfigParser values in an
    invalid state (stored as a list instead of a str) after an
    earlier read raised DuplicateSectionError or
    DuplicateOptionError.
  - gh-90095: Ignore empty lines and comments in .pdbrc
  - gh-116764: Restore support of None and other false values in
    urllib.parse functions parse_qs() and parse_qsl(). Also, they
    now raise a TypeError for non-zero integers and non-empty
    sequences.
  - gh-116811: In PathFinder.invalidate_caches, delegate to
    MetadataPathFinder.invalidate_caches.
  - gh-116600: Fix repr() for global Flag members.
  - gh-116484: Change automatically generated tkinter.Checkbutton
    widget names to avoid collisions with automatically generated
    tkinter.ttk.Checkbutton widget names within the same parent
    widget.
  - gh-116401: Fix blocking os.fwalk() and shutil.rmtree() on
    opening named pipe.
  - gh-116143: Fix a race in pydoc _start_server, eliminating a
    window in which _start_server can return a thread that is
    “serving” but without a docserver set.
  - gh-116325: typing: raise SyntaxError instead of AttributeError
    on forward references as empty strings.
  - gh-90535: Fix support of interval values > 1 in
    logging.TimedRotatingFileHandler for when='MIDNIGHT' and
    when='Wx'.
  - gh-115978: Disable preadv(), readv(), pwritev(), and writev() on
    WASI.
  - Under wasmtime for WASI 0.2, these functions don’t pass
    test_posix
    (https://github.com/bytecodealliance/wasmtime/issues/7830).
  - gh-88352: Fix the computation of the next rollover time in the
    logging.TimedRotatingFileHandler handler. computeRollover() now
    always returns a timestamp larger than the specified time and
    works correctly during the DST change. doRollover() no longer
    overwrite the already rolled over file, saving from data loss
    when run at midnight or during repeated time at the DST change.
  - gh-87115: Set __main__.__spec__ to None when running a script
    with pdb
  - gh-76511: Fix UnicodeEncodeError in email.Message.as_string()
    that results when a message that claims to be in the ascii
    character set actually has non-ascii characters. Non-ascii
    characters are now replaced with the U+FFFD replacement
    character, like in the replace error handler.
  - gh-75988: Fixed unittest.mock.create_autospec() to pass the call
    through to the wrapped object to return the real result.
  - gh-115881: Fix issue where ast.parse() would incorrectly flag
    conditional context managers (such as with (x() if y else z()):
    ...) as invalid syntax if feature_version=(3, 8) was passed.
    This reverts changes to the grammar made as part of gh-94949.
  - gh-115886: Fix silent truncation of the name with an embedded
    null character in multiprocessing.shared_memory.SharedMemory.
  - gh-115809: Improve algorithm for computing which rolled-over log
    files to delete in logging.TimedRotatingFileHandler. It is now
    reliable for handlers without namer and with arbitrary
    deterministic namer that leaves the datetime part in the file
    name unmodified.
  - gh-74668: urllib.parse functions parse_qs() and parse_qsl() now
    support bytes arguments containing raw and percent-encoded
    non-ASCII data.
  - gh-67044: csv.writer() now always quotes or escapes '\r' and
    '\n', regardless of lineterminator value.
  - gh-115712: csv.writer() now quotes empty fields if delimiter is
    a space and skipinitialspace is true and raises exception if
    quoting is not possible.
  - gh-115618: Fix improper decreasing the reference count for None
    argument in property methods getter(), setter() and deleter().
  - gh-115570: A DeprecationWarning is no longer omitted on access
    to the __doc__ attributes of the deprecated typing.io and
    typing.re pseudo-modules.
  - gh-112006: Fix inspect.unwrap() for types with the __wrapper__
    data descriptor.
  - gh-101293: Support callables with the __call__() method and
    types with __new__() and __init__() methods set to class
    methods, static methods, bound methods, partial functions, and
    other types of methods and descriptors in
    inspect.Signature.from_callable().
  - gh-115392: Fix a bug in doctest where incorrect line numbers
    would be reported for decorated functions.
  - gh-114563: Fix several format() bugs when using the C
    implementation of Decimal: * memory leak in some rare cases when
    using the z format option (coerce negative 0) * incorrect output
    when applying the z format option to type F (fixed-point with
    capital NAN / INF) * incorrect output when applying the # format
    option (alternate form)
  - gh-115197: urllib.request no longer resolves the hostname before
    checking it against the system’s proxy bypass list on macOS and
    Windows.
  - gh-115198: Fix support of Docutils >= 0.19 in distutils.
  - gh-115165: Most exceptions are now ignored when attempting to
    set the __orig_class__ attribute on objects returned when
    calling typing generic aliases (including generic aliases
    created using typing.Annotated). Previously only AttributeError
    was ignored. Patch by Dave Shawley.
  - gh-115133: Fix tests for XMLPullParser with Expat 2.6.0.
  - gh-115059: io.BufferedRandom.read1() now flushes the underlying
    write buffer.
  - gh-79382: Trailing ** no longer allows to match files and
    non-existing paths in recursive glob().
  - gh-114763: Protect modules loaded with importlib.util.LazyLoader
    from race conditions when multiple threads try to access
    attributes before the loading is complete.
  - gh-97959: Fix rendering class methods, bound methods, method and
    function aliases in pydoc. Class methods no longer have “method
    of builtins.type instance” note. Corresponding notes are now
    added for class and unbound methods. Method and function aliases
    now have references to the module or the class where the origin
    was defined if it differs from the current. Bound methods are
    now listed in the static methods section. Methods of builtin
    classes are now supported as well as methods of Python classes.
  - gh-112281: Allow creating union of types for typing.Annotated
    with unhashable metadata.
  - gh-111775: Fix importlib.resources.simple.ResourceHandle.open()
    for text mode, added missed stream argument.
  - gh-90095: Make .pdbrc and -c work with any valid pdb commands.
  - gh-107155: Fix incorrect output of help(x) where x is a lambda
    function, which has an __annotations__ dictionary attribute with
    a "return" key.
  - gh-105866: Fixed _get_slots bug which caused error when defining
    dataclasses with slots and a weakref_slot.
  - gh-60346: Fix ArgumentParser inconsistent with parse_known_args.
  - gh-100985: Update HTTPSConnection to consistently wrap IPv6
    Addresses when using a proxy.
  - gh-100884: email: fix misfolding of comma in address-lists
    over multiple lines in combination with unicode encoding
    (bsc#1238450 CVE-2025-1795)
  - gh-95782: Fix io.BufferedReader.tell(),
    io.BufferedReader.seek(), _pyio.BufferedReader.tell(),
    io.BufferedRandom.tell(), io.BufferedRandom.seek() and
    _pyio.BufferedRandom.tell() being able to return negative
    offsets.
  - gh-96310: Fix a traceback in argparse when all options in a
    mutually exclusive group are suppressed.
  - gh-93205: Fixed a bug in
    logging.handlers.TimedRotatingFileHandler where multiple
    rotating handler instances pointing to files with the same name
    but different extensions would conflict and not delete the
    correct files.
  - bpo-44865: Add missing call to localization function in
    argparse.
  - bpo-43952: Fix multiprocessing.connection.Listener.accept() to
    accept empty bytes as authkey. Not accepting empty bytes as key
    causes it to hang indefinitely.
  - bpo-42125: linecache: get module name from __spec__ if
    available. This allows getting source code for the __main__
    module when a custom loader is used.
  - gh-66543: Make mimetypes.guess_type() properly parsing of URLs
    with only a host name, URLs containing fragment or query, and
    filenames with only a UNC sharepoint on Windows. Based on patch
    by Dong-hee Na.
  - bpo-33775: Add ‘default’ and ‘version’ help text for
    localization in argparse.
  * Documentation
  - gh-115399: Document CVE-2023-52425 of Expat <2.6.0 under “XML
    vulnerabilities”.
  - gh-115233: Fix an example for LoggerAdapter in the Logging
    Cookbook.
  * Tests
  - gh-83434: Disable JUnit XML output (--junit-xml=FILE command
    line option) in regrtest when hunting for reference leaks (-R
    option). Patch by Victor Stinner.
  - gh-117187: Fix XML tests for vanilla Expat <2.6.0.
  - gh-115979: Update test_importlib so that it passes under WASI
    SDK 21.
  - gh-116307: Added import helper isolated_modules as CleanImport
    does not remove modules imported during the context.
  - gh-115720: Leak tests (-R, --huntrleaks) now show a summary of
    the number of leaks found in each iteration.
  - gh-115122: Add --bisect option to regrtest test runner: run
    failed tests with test.bisect_cmd to identify failing tests.
    Patch by Victor Stinner.
  - gh-115596: Fix ProgramPriorityTests in test_os permanently
    changing the process priority.
  - gh-115198: Fix test_check_metadata_deprecate in distutils tests
    with a newer Docutils.
  * Build
  - gh-116313: Get WASI builds to work under wasmtime 18 w/ WASI
    0.2/preview2 primitives.
  - gh-115167: Avoid vendoring vcruntime140_threads.dll when
    building with Visual Studio 2022 version 17.8.
  * Windows
  - gh-116773: Fix instances of <_overlapped.Overlapped object at
    0xXXX> still has pending operation at deallocation, the process
    may crash.
  - gh-91227: Fix the asyncio ProactorEventLoop implementation so
    that sending a datagram to an address that is not listening does
    not prevent receiving any more datagrams.
  - gh-115554: The installer now has more strict rules about
    updating the Python Launcher for Windows. In general, most users
    only have a single launcher installed and will see no
    difference. When multiple launchers have been installed, the
    option to install the launcher is disabled until all but one
    have been removed. Downgrading the launcher (which was never
    allowed) is now more obviously blocked.
  - gh-115543: Python Launcher for Windows can now detect Python
    3.13 when installed from the Microsoft Store, and will install
    Python 3.12 by default when PYLAUNCHER_ALLOW_INSTALL is set.
  - gh-115009: Update Windows installer to use SQLite 3.45.1.
  * IDLE
  - gh-88516: On macOS show a proxy icon in the title bar of editor
    windows to match platform behaviour.
  * Tools/Demos
  - gh-113516: Don’t set LDSHARED when building for WASI.
  * C API
  - gh-117021: Fix integer overflow in PyLong_AsPid() on non-Windows
    64-bit platforms.
* Sun Mar 24 2024 mcepl@cepl.eu
- Add reference to CVE-2024-0450 (bsc#1221854) to changelog.
* Fri Mar 22 2024 mcepl@cepl.eu
- Because of bsc#1189495 we have to revert use of %%autopatch.
* Tue Mar 12 2024 mcepl@cepl.eu
- Rewrite %%prep to use %%autosetup et al. for compatibility with
  rpm 4.20.
* Tue Mar 12 2024 mcepl@cepl.eu
- bsc#1221260 add bsc1221260-test_asyncio-ResourceWarning.patch
  to eliminate ResourceWarning which broke the test suite in
  test_asyncio.
* Wed Mar  6 2024 pmonreal@suse.com
- Use the system-wide crypto-policies [bsc#1211301]
  * Use the system default cipher list instead of hardcoded values
  * Add the --with-ssl-default-suites=openssl configure option
* Fri Feb 23 2024 mcepl@suse.com
- (bsc#1219666, CVE-2023-6597) Add
  CVE-2023-6597-TempDir-cleaning-symlink.patch (patch from
  gh#python/cpython!99930) fixing symlink bug in cleanup of
  tempfile.TemporaryDirectory.
* Tue Feb 20 2024 mcepl@cepl.eu
- Remove double definition of /usr/bin/idle%%%%{version} in
  %%%%files.
* Thu Feb 15 2024 daniel.garcia@suse.com
- Add upstream patch libexpat260.patch, Fix tests for XMLPullParser
  with Expat 2.6.0, gh#python/cpython#115289
* Thu Feb  8 2024 daniel.garcia@suse.com
- Update to 3.11.8:
  - Security
  - gh-113659: Skip .pth files with names starting with a dot or
    hidden file attribute.
  - Core and Builtins
  - gh-114887: Changed socket type validation in
    create_datagram_endpoint() to accept all non-stream sockets.
    This fixes a regression in compatibility with raw sockets.
  - gh-114388: Fix a RuntimeWarning emitted when assign an
    integer-like value that is not an instance of int to an
    attribute that corresponds to a C struct member of type T_UINT
    and T_ULONG. Fix a double RuntimeWarning emitted when assign a
    negative integer value to an attribute that corresponds to a C
    struct member of type T_UINT.
  - gh-89811: Check for a valid tp_version_tag before performing
    bytecode specializations that rely on this value being usable.
  - gh-113602: Fix an error that was causing the parser to try to
    overwrite existing errors and crashing in the process. Patch by
    Pablo Galindo
  - gh-113566: Fix a 3.11-specific crash when the repr of a Future
    is requested after the module has already been
    garbage-collected.
  - gh-106905: Use per AST-parser state rather than global state to
    track recursion depth within the AST parser to prevent potential
    race condition due to simultaneous parsing.
  - The issue primarily showed up in 3.11 by multithreaded users of
    ast.parse(). In 3.12 a change to when garbage collection can be
    triggered prevented the race condition from occurring.
  - gh-112716: Fix SystemError in the import statement and in
    __reduce__() methods of builtin types when __builtins__ is not a
    dict.
  - gh-105967: Workaround a bug in Apple’s macOS platform zlib
    library where zlib.crc32() and binascii.crc32() could produce
    incorrect results on multi-gigabyte inputs. Including when using
    zipfile on zips containing large data.
  - gh-94606: Fix UnicodeEncodeError when
    email.message.get_payload() reads a message with a Unicode
    surrogate character and the message content is not well-formed
    for surrogateescape encoding. Patch by Sidney Markowitz.
  - Library
  - gh-114965: Update bundled pip to 24.0
  - gh-114959: tarfile no longer ignores errors when trying to
    extract a directory on top of a file.
  - gh-109475: Fix support of explicit option value “–” in argparse
    (e.g. --option=--).
  - gh-110190: Fix ctypes structs with array on Windows ARM64
    platform by setting MAX_STRUCT_SIZE to 32 in stgdict. Patch by
    Diego Russo
  - gh-113280: Fix a leak of open socket in rare cases when error
    occurred in ssl.SSLSocket creation.
  - gh-77749: email.policy.EmailPolicy.fold() now always encodes
    non-ASCII characters in headers if utf8 is false.
  - gh-114492: Make the result of termios.tcgetattr() reproducible
    on Alpine Linux. Previously it could leave a random garbage in
    some fields.
  - gh-75128: Ignore an OSError in
    asyncio.BaseEventLoop.create_server() when IPv6 is available but
    the interface cannot actually support it.
  - gh-114257: Dismiss the FileNotFound error in
    ctypes.util.find_library() and just return None on Linux.
  - gh-101438: Avoid reference cycle in ElementTree.iterparse. The
    iterator returned by ElementTree.iterparse may hold on to a file
    descriptor. The reference cycle prevented prompt clean-up of the
    file descriptor if the returned iterator was not exhausted.
  - gh-104522: OSError raised when run a subprocess now only has
    filename attribute set to cwd if the error was caused by a
    failed attempt to change the current directory.
  - gh-109534: Fix a reference leak in
    asyncio.selector_events.BaseSelectorEventLoop when SSL
    handshakes fail. Patch contributed by Jamie Phan.
  - gh-114077: Fix possible OverflowError in
    socket.socket.sendfile() when pass count larger than 2 GiB on
    32-bit platform.
  - gh-114014: Fixed a bug in fractions.Fraction where an invalid
    string using d in the decimals part creates a different error
    compared to other invalid letters/characters. Patch by Jeremiah
    Gabriel Pascual.
  - gh-113951: Fix the behavior of tag_unbind() methods of
    tkinter.Text and tkinter.Canvas classes with three arguments.
    Previously, widget.tag_unbind(tag, sequence, funcid) destroyed
    the current binding for sequence, leaving sequence unbound, and
    deleted the funcid command. Now it removes only funcid from the
    binding for sequence, keeping other commands, and deletes the
    funcid command. It leaves sequence unbound only if funcid was
    the last bound command.
  - gh-113877: Fix tkinter method winfo_pathname() on 64-bit
    Windows.
  - gh-113781: Silence unraisable AttributeError when warnings are
    emitted during Python finalization.
  - gh-113594: Fix UnicodeEncodeError in email when re-fold lines
    that contain unknown-8bit encoded part followed by
    non-unknown-8bit encoded part.
  - gh-113538: In asyncio.StreamReaderProtocol.connection_made(),
    there is callback that logs an error if the task wrapping the
    “connected callback” fails. This callback would itself fail if
    the task was cancelled. Prevent this by checking whether the
    task was cancelled first. If so, close the transport but don’t
    log an error.
  - gh-85567: Fix resource warnings for unclosed files in pickle and
    pickletools command line interfaces.
  - gh-101225: Increase the backlog for
    multiprocessing.connection.Listener objects created by
    multiprocessing.manager and multiprocessing.resource_sharer to
    significantly reduce the risk of getting a connection refused
    error when creating a multiprocessing.connection.Connection to
    them.
  - gh-113543: Make sure that webbrowser.MacOSXOSAScript sends
    webbrowser.open audit event.
  - gh-113028: When a second reference to a string appears in the
    input to pickle, and the Python implementation is in use, we are
    guaranteed that a single copy gets pickled and a single object
    is shared when reloaded. Previously, in protocol 0, when a
    string contained certain characters (e.g. newline) it resulted
    in duplicate objects.
  - gh-113421: Fix multiprocessing logger for %%(filename)s.
  - gh-113358: Fix rendering tracebacks for exceptions with a broken
    __getattr__.
  - gh-113214: Fix an AttributeError during asyncio SSL protocol
    aborts in SSL-over-SSL scenarios.
  - gh-113246: Update bundled pip to 23.3.2.
  - gh-113199: Make http.client.HTTPResponse.read1 and
    http.client.HTTPResponse.readline close IO after reading all
    data when content length is known. Patch by Illia Volochii.
  - gh-113188: Fix shutil.copymode() and shutil.copystat() on
    Windows. Previously they worked differenly if dst is a symbolic
    link: they modified the permission bits of dst itself rather
    than the file it points to if follow_symlinks is true or src is
    not a symbolic link, and did not modify the permission bits if
    follow_symlinks is false and src is a symbolic link.
  - gh-61648: Detect line numbers of properties in doctests.
  - gh-112559: signal.signal() and signal.getsignal() no longer call
    repr on callable handlers. asyncio.run() and
    asyncio.Runner.run() no longer call repr on the task results.
    Patch by Yilei Yang.
  - gh-110190: Fix ctypes structs with array on PPC64LE platform by
    setting MAX_STRUCT_SIZE to 64 in stgdict. Patch by Diego Russo.
  - gh-79429: Ignore FileNotFoundError when remove a temporary
    directory in the multiprocessing finalizer.
  - gh-79325: Fix an infinite recursion error in
    tempfile.TemporaryDirectory() cleanup on Windows.
  - gh-110190: Fix ctypes structs with array on Arm platform by
    setting MAX_STRUCT_SIZE to 32 in stgdict. Patch by Diego Russo.
  - gh-81194: Fix a crash in socket.if_indextoname() with specific
    value (UINT_MAX). Fix an integer overflow in
    socket.if_indextoname() on 64-bit non-Windows platforms.
  - gh-75666: Fix the behavior of tkinter widget’s unbind() method
    with two arguments. Previously, widget.unbind(sequence, funcid)
    destroyed the current binding for sequence, leaving sequence
    unbound, and deleted the funcid command. Now it removes only
    funcid from the binding for sequence, keeping other commands,
    and deletes the funcid command. It leaves sequence unbound only
    if funcid was the last bound command.
  - gh-110345: Show the Tcl/Tk patchlevel (rather than version) in
    tkinter._test().
  - gh-109858: Protect zipfile from “quoted-overlap” zipbomb. It now
    raises BadZipFile when try to read an entry that overlaps with
    other entry or central directory (bsc#1221854, CVE-2024-0450).
  - gh-38807: Fix race condition in trace. Instead of checking if a
    directory exists and creating it, directly call os.makedirs()
    with the kwarg exist_ok=True.
  - gh-75705: Set unixfrom envelope in mailbox.mbox and
    mailbox.MMDF.
  - gh-105102: Allow ctypes.Union to be nested in ctypes.Structure
    when the system endianness is the opposite of the classes.
  - gh-104282: Fix null pointer dereference in
    lzma._decode_filter_properties() due to improper handling of BCJ
    filters with properties of zero length. Patch by Radislav
    Chugunov.
  - gh-102512: When os.fork() is called from a foreign thread (aka
    _DummyThread), the type of the thread in a child process is
    changed to _MainThread. Also changed its name and daemonic
    status, it can be now joined.
  - gh-91133: Fix a bug in tempfile.TemporaryDirectory cleanup,
    which now no longer dereferences symlinks when working around
    file system permission errors.
  - bpo-43153: On Windows, tempfile.TemporaryDirectory previously
    masked a PermissionError with NotADirectoryError during
    directory cleanup. It now correctly raises PermissionError if
    errors are not ignored. Patch by Andrei Kulakov and Ken Jin.
  - bpo-35332: The shutil.rmtree() function now ignores errors when
    calling os.close() when ignore_errors is True, and os.close() no
    longer retried after error.
  - bpo-35928: io.TextIOWrapper now correctly handles the decoding
    buffer after read() and write().
  - bpo-26791: shutil.move() now moves a symlink into a directory
    when that directory is the target of the symlink. This provides
    the same behavior as the mv shell command. The previous behavior
    raised an exception. Patch by Jeffrey Kintscher.
  - bpo-36959: Fix some error messages for invalid ISO format string
    combinations in strptime() that referred to directives not
    contained in the format string. Patch by Gordon P. Hemsley.
  - bpo-18060: Fixed a class inheritance issue that can cause
    segfaults when deriving two or more levels of subclasses from a
    base class of Structure or Union.
  - Documentation
  - gh-110746: Improved markup for valid options/values for methods
    ttk.treeview.column and ttk.treeview.heading, and for Layouts.
  - gh-95649: Document that the asyncio module contains code taken
    from v0.16.0 of the uvloop project, as well as the required MIT
    licensing information.
  - Tests
  - gh-109980: Fix test_tarfile_vs_tar in test_shutil for macOS,
    where system tar can include more information in the archive
    than shutil.make_archive.
  - gh-112769: The tests now correctly compare zlib version when
    zlib.ZLIB_RUNTIME_VERSION contains non-integer suffixes. For
    example zlib-ng defines the version as 1.3.0.zlib-ng.
  - gh-105089: Fix
    test.test_zipfile.test_core.TestWithDirectory.test_create_directory_with_write
    test in AIX by doing a bitwise AND of 0xFFFF on mode , so that
    it will be in sync with zinfo.external_attr
  - bpo-40648: Test modes that file can get with chmod() on Windows.
  - Build
  - gh-101778: Fix build error when there’s a dangling symlink in
    the directory containing ffi.h.
  - gh-112305: Fixed the check-clean-src step performed on out of
    tree builds to detect errant $(srcdir)/Python/frozen_modules/*.h
    files and recommend appropriate source tree cleanup steps to get
    a working build again.
  - bpo-11102: The os.major(), os.makedev(), and os.minor()
    functions are now available on HP-UX v3.
  - bpo-36351: Do not set ipv6type when cross-compiling.
  - IDLE
  - gh-96905: In idlelib code, stop redefining built-ins ‘dict’ and
    ‘object’.
  - gh-72284: Improve the lists of features, editor key bindings,
    and shell key bingings in the IDLE doc.
  - gh-113903: Fix rare failure of test.test_idle, in
    test_configdialog.
  - gh-113729: Fix the “Help -> IDLE Doc” menu bug in 3.11.7 and
    3.12.1.
  - gh-113269: Fix test_editor hang on macOS Catalina.
  - gh-112898: Fix processing unsaved files when quitting IDLE on
    macOS.
  - gh-103820: Revise IDLE bindings so that events from mouse button
    4/5 on non-X11 windowing systems (i.e. Win32 and Aqua) are not
    mistaken for scrolling.
  - bpo-13586: Enter the selected text when opening the “Replace”
    dialog.
  - Tools/Demos
  - gh-109991: Update GitHub CI workflows to use OpenSSL 3.0.13 and
    multissltests to use 1.1.1w, 3.0.13, 3.1.5, and 3.2.1.
  - gh-115015: Fix a bug in Argument Clinic that generated incorrect
    code for methods with no parameters that use the METH_METHOD |
    METH_FASTCALL | METH_KEYWORDS calling convention. Only the
    positional parameter count was checked; any keyword argument
    passed would be silently accepted.
- Remove upstreamed patches:
  - CVE-2024-0450-zipfile-avoid-quoted-overlap-zipbomb.patch
- Refresh all patches:
  - CVE-2023-27043-email-parsing-errors.patch
  - F00251-change-user-install-location.patch
  - bpo-31046_ensurepip_honours_prefix.patch
  - distutils-reproducible-compile.patch
  - fix_configure_rst.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
  - python-3.3.0b1-localpath.patch
  - python-3.3.0b1-test-posix_fadvise.patch
  - skip_if_buildbot-extend.patch
  - subprocess-raise-timeout.patch
  - support-expat-CVE-2022-25236-patched.patch
* Tue Dec 19 2023 daniel.garcia@suse.com
- Update patch fix_configure_rst.patch
- Update to 3.11.7:
  - Core and Builtins
  - gh-112625: Fixes a bug where a bytearray object could be cleared
    while iterating over an argument in the bytearray.join() method
    that could result in reading memory after it was freed.
  - gh-112388: Fix an error that was causing the parser to try to
    overwrite tokenizer errors. Patch by pablo Galindo
  - gh-112387: Fix error positions for decoded strings with
    backwards tokenize errors. Patch by Pablo Galindo
  - gh-112266: Change docstrings of __dict__ and __weakref__.
  - gh-109181: Speed up Traceback object creation by lazily compute
    the line number. Patch by Pablo Galindo
  - gh-102388: Fix a bug where iso2022_jp_3 and iso2022_jp_2004
    codecs read out of bounds
  - gh-111366: Fix an issue in the codeop that was causing
    SyntaxError exceptions raised in the presence of invalid syntax
    to not contain precise error messages. Patch by Pablo Galindo
  - gh-111380: Fix a bug that was causing SyntaxWarning to appear
    twice when parsing if invalid syntax is encountered later. Patch
    by Pablo galindo
  - gh-88116: Traceback location ranges involving wide unicode
    characters (like emoji and asian characters) now are properly
    highlighted. Patch by Batuhan Taskaya and Pablo Galindo.
  - gh-94438: Fix a regression that prevented jumping across is None
    and is not None when debugging. Patch by Savannah Ostrowski.
  - gh-110696: Fix incorrect error message for invalid argument
    unpacking. Patch by Pablo Galindo
  - gh-110237: Fix missing error checks for calls to PyList_Append
    in _PyEval_MatchClass.
  - gh-109216: Fix possible memory leak in BUILD_MAP.
  - Library
  - gh-112618: Fix a caching bug relating to typing.Annotated.
    Annotated[str, True] is no longer identical to Annotated[str,
    1].
  - gh-112509: Fix edge cases that could cause a key to be present
    in both the __required_keys__ and __optional_keys__ attributes
    of a typing.TypedDict. Patch by Jelle Zijlstra.
  - gh-94722: Fix bug where comparison between instances of DocTest
    fails if one of them has None as its lineno.
  - gh-112105: Make readline.set_completer_delims() work with
    libedit
  - gh-111942: Fix SystemError in the TextIOWrapper constructor with
    non-encodable “errors” argument in non-debug mode.
  - gh-109538: Issue warning message instead of having RuntimeError
    be displayed when event loop has already been closed at
    StreamWriter.__del__().
  - gh-111942: Fix crashes in io.TextIOWrapper.reconfigure() when
    pass invalid arguments, e.g. non-string encoding.
  - gh-111804: Remove posix.fallocate() under WASI as the underlying
    posix_fallocate() is not available in WASI preview2.
  - gh-111841: Fix truncating arguments on an embedded null
    character in os.putenv() and os.unsetenv() on Windows.
  - gh-111541: Fix doctest for SyntaxError not-builtin subclasses.
  - gh-110894: Call loop exception handler for exceptions in
    client_connected_cb of asyncio.start_server() so that
    applications can handle it. Patch by Kumar Aditya.
  - gh-111531: Fix reference leaks in bind_class() and bind_all()
    methods of tkinter widgets.
  - gh-111356: Added io.text_encoding(), io.DEFAULT_BUFFER_SIZE, and
    io.IncrementalNewlineDecoder to io.__all__.
  - gh-68166: Remove mention of not supported “vsapi” element type
    in tkinter.ttk.Style.element_create(). Add tests for
    element_create() and other ttk.Style methods. Add examples for
    element_create() in the documentation.
  - gh-111251: Fix _blake2 not checking for errors when
    initializing.
  - gh-111174: Fix crash in io.BytesIO.getbuffer() called repeatedly
    for empty BytesIO.
  - gh-111187: Postpone removal version for
    locale.getdefaultlocale() to Python 3.15.
  - gh-111159: Fix doctest output comparison for exceptions with
    notes.
  - gh-110910: Fix invalid state handling in asyncio.TaskGroup and
    asyncio.Timeout. They now raise proper RuntimeError if they are
    improperly used and are left in consistent state after this.
  - gh-111092: Make turtledemo run without default root enabled.
  - gh-110590: Fix a bug in _sre.compile() where TypeError would be
    overwritten by OverflowError when the code argument was a list
    of non-ints.
  - gh-65052: Prevent pdb from crashing when trying to display
    undisplayable objects
  - gh-110519: Deprecation warning about non-integer number in
    gettext now alwais refers to the line in the user code where
    gettext function or method is used. Previously it could refer to
    a line in gettext code.
  - gh-110378: contextmanager() and asynccontextmanager() context
    managers now close an invalid underlying generator object that
    yields more then one value.
  - gh-110365: Fix termios.tcsetattr() bug that was overwritting
    existing errors during parsing integers from term list.
  - gh-110196: Add __reduce__ method to IPv6Address in order to keep
    scope_id
  - gh-109747: Improve errors for unsupported look-behind patterns.
    Now re.error is raised instead of OverflowError or RuntimeError
    for too large width of look-behind pattern.
  - gh-109786: Fix possible reference leaks and crash when re-enter
    the __next__() method of itertools.pairwise.
  - gh-108791: Improved error handling in pdb command line
    interface, making it produce more concise error messages.
  - gh-73561: Omit the interface scope from an IPv6 address when
    used as Host header by http.client.
  - gh-86826: zipinfo now supports the full range of values in the
    TZ string determined by RFC 8536 and detects all invalid
    formats. Both Python and C implementations now raise exceptions
    of the same type on invalid data.
  - bpo-41422: Fixed memory leaks of pickle.Pickler and
    pickle.Unpickler involving cyclic references via the internal
    memo mapping.
  - bpo-40262: The ssl.SSLSocket.recv_into() method no longer
    requires the buffer argument to implement __len__ and supports
    buffers with arbitrary item size.
  - bpo-35191: Fix unexpected integer truncation in
    socket.setblocking() which caused it to interpret multiples of
    2**32 as False.
  - Documentation
  - gh-108826: dis module command-line interface is now mentioned in
    documentation.
  - Tests
  - gh-110367: Make regrtest --verbose3 option compatible with
  - -huntrleaks -jN options. The ./python -m test -j1 -R 3:3
  - -verbose3 command now works as expected. Patch by Victor
    Stinner.
  - gh-111309: distutils tests can now be run via unittest.
  - gh-111165: Remove no longer used functions run_unittest() and
    run_doctest() and class BasicTestRunner from the test.support
    module.
  - gh-110932: Fix regrtest if the SOURCE_DATE_EPOCH environment
    variable is defined: use the variable value as the random seed.
    Patch by Victor Stinner.
  - gh-110995: test_gdb: Fix detection of gdb built without Python
    scripting support. Patch by Victor Stinner.
  - gh-110918: Test case matching patterns specified by options
  - -match, --ignore, --matchfile and --ignorefile are now tested
    in the order of specification, and the last match determines
    whether the test case be run or ignored.
  - gh-110647: Fix test_stress_modifying_handlers() of test_signal.
    Patch by Victor Stinner.
  - gh-103053: Fix test_tools.test_freeze on FreeBSD: run “make
    distclean” instead of “make clean” in the copied source
    directory to remove also the “python” program. Patch by Victor
    Stinner.
  - gh-110167: Fix a deadlock in test_socket when server fails with
    a timeout but the client is still running in its thread. Don’t
    hold a lock to call cleanup functions in doCleanups(). One of
    the cleanup function waits until the client completes, whereas
    the client could deadlock if it called addCleanup() in such
    situation. Patch by Victor Stinner.
  - gh-110388: Add tests for tty.
  - gh-81002: Add tests for termios.
  - gh-110267: Add tests for pickling and copying PyStructSequence
    objects. Patched by Xuehai Pan.
  - gh-109974: Fix race conditions in test_threading lock tests.
    Wait until a condition is met rather than using time.sleep()
    with a hardcoded number of seconds. Patch by Victor Stinner.
  - gh-109972: Split test_gdb.py file into a test_gdb package made
    of multiple tests, so tests can now be run in parallel. Patch by
    Victor Stinner.
  - gh-104736: Fix test_gdb on Python built with LLVM clang 16 on
    Linux ppc64le (ex: Fedora 38). Search patterns in gdb “bt”
    command output to detect when gdb fails to retrieve the
    traceback. For example, skip a test if Backtrace stopped: frame
    did not save the PC is found. Patch by Victor Stinner.
  - gh-108927: Fixed order dependence in running tests in the same
    process when a test that has submodules (e.g. test_importlib)
    follows a test that imports its submodule (e.g.
    test_importlib.util) and precedes a test (e.g. test_unittest or
    test_compileall) that uses that submodule.
  - Build
  - gh-103053: “make check-clean-src” now also checks if the
    “python” program is found in the source directory: fail with an
    error if it does exist. Patch by Victor Stinner.
  - gh-109191: Fix compile error when building with recent versions
    of libedit.
  - IDLE
  - bpo-35668: Add docstrings to the IDLE debugger module. Fix two
    bugs: initialize Idb.botframe (should be in Bdb); in
    Idb.in_rpc_code, check whether prev_frame is None before trying
    to use it. Greatly expand test_debugger.
  - C API
  - gh-112438: Fix support of format units “es”, “et”, “es#”, and
    “et#” in nested tuples in PyArg_ParseTuple()-like functions.
  - gh-109521: PyImport_GetImporter() now sets RuntimeError if it
    fails to get sys.path_hooks or sys.path_importer_cache or they
    are not list and dict correspondingly. Previously it could
    return NULL without setting error in obscure cases, crash or
    raise SystemError if these attributes have wrong type.
* Mon Dec 18 2023 mcepl@cepl.eu
- Refresh CVE-2023-27043-email-parsing-errors.patch to
  gh#python/cpython!111116, fixing bsc#1210638 (CVE-2023-27043).
- Thus we can remove Revert-gh105127-left-tests.patch, which is
  now useless.
* Wed Nov 15 2023 daniel.garcia@suse.com
- Remove not needed patch 103213-fetch-CONFIG_ARGS.patch
- Refresh patches:
  - bpo-31046_ensurepip_honours_prefix.patch
  - fix_configure_rst.patch
- Update to 3.11.6:
  - Core and Builtins
  - gh-109351: Fix crash when compiling an invalid AST involving a
    named (walrus) expression.
  - gh-109207: Fix a SystemError in __repr__ of symtable entry
    object.
  - gh-109179: Fix bug where the C traceback display drops notes
    from SyntaxError.
  - gh-88943: Improve syntax error for non-ASCII character that
    follows a numerical literal. It now points on the invalid
    non-ASCII character, not on the valid numerical literal.
  - gh-108959: Fix caret placement for error locations for subscript
    and binary operations that involve non-semantic parentheses and
    spaces. Patch by Pablo Galindo
  - gh-108520: Fix
    multiprocessing.synchronize.SemLock.__setstate__() to properly
    initialize multiprocessing.synchronize.SemLock._is_fork_ctx.
    This fixes a regression when passing a SemLock accross nested
    processes.
  - Rename multiprocessing.synchronize.SemLock.is_fork_ctx to
    multiprocessing.synchronize.SemLock._is_fork_ctx to avoid
    exposing it as public API.
  - Library
  - gh-110036: On Windows, multiprocessing Popen.terminate() now
    catchs PermissionError and get the process exit code. If the
    process is still running, raise again the PermissionError.
    Otherwise, the process terminated as expected: store its exit
    code. Patch by Victor Stinner.
  - gh-110038: Fixed an issue that caused KqueueSelector.select() to
    not return all the ready events in some cases when a file
    descriptor is registered for both read and write.
  - gh-109631: re functions such as re.findall(), re.split(),
    re.search() and re.sub() which perform short repeated matches
    can now be interrupted by user.
  - gh-109593: Avoid deadlocking on a reentrant call to the
    multiprocessing resource tracker. Such a reentrant call, though
    unlikely, can happen if a GC pass invokes the finalizer for a
    multiprocessing object such as SemLock.
  - gh-109613: Fix os.stat() and os.DirEntry.stat(): check for
    exceptions. Previously, on Python built in debug mode, these
    functions could trigger a fatal Python error (and abort the
    process) when a function succeeded with an exception set. Patch
    by Victor Stinner.
  - gh-109375: The pdb alias command now prevents registering
    aliases without arguments.
  - gh-107219: Fix a race condition in concurrent.futures. When a
    process in the process pool was terminated abruptly (while the
    future was running or pending), close the connection write end.
    If the call queue is blocked on sending bytes to a worker
    process, closing the connection write end interrupts the send,
    so the queue can be closed. Patch by Victor Stinner.
  - gh-50644: Attempts to pickle or create a shallow or deep copy of
    codecs streams now raise a TypeError. Previously, copying failed
    with a RecursionError, while pickling produced wrong results
    that eventually caused unpickling to fail with a RecursionError.
  - gh-108987: Fix _thread.start_new_thread() race condition. If a
    thread is created during Python finalization, the newly spawned
    thread now exits immediately instead of trying to access freed
    memory and lead to a crash. Patch by Victor Stinner.
  - gh-108843: Fix an issue in ast.unparse() when unparsing
    f-strings containing many quote types.
  - gh-108682: Enum: raise TypeError if super().__new__() is called
    from a custom __new__.
  - gh-105829: Fix concurrent.futures.ProcessPoolExecutor deadlock
  - gh-64662: Fix support for virtual tables in
    sqlite3.Connection.iterdump(). Patch by Aviv Palivoda.
  - gh-107913: Fix possible losses of errno and winerror values in
    OSError exceptions if they were cleared or modified by the
    cleanup code before creating the exception object.
  - gh-104372: On Linux where subprocess can use the vfork() syscall
    for faster spawning, prevent the parent process from blocking
    other threads by dropping the GIL while it waits for the
    vfork’ed child process exec() outcome. This prevents spawning a
    binary from a slow filesystem from blocking the rest of the
    application.
  - gh-84867: unittest.TestLoader no longer loads test cases from
    exact unittest.TestCase and unittest.FunctionTestCase classes.
  - Documentation
  - gh-109209: The minimum Sphinx version required for the
    documentation is now 4.2.
  - gh-105052: Update timeit doc to specify that time in seconds is
    just the default.
  - gh-102823: Document the return type of x // y when x and y have
    type float.
  - Tests
  - gh-110031: Skip test_threading tests using thread+fork if Python
    is built with Address Sanitizer (ASAN). Patch by Victor Stinner.
  - gh-110088: Fix test_asyncio timeouts: don’t measure the maximum
    duration, a test should not measure a CI performance. Only
    measure the minimum duration when a task has a timeout or delay.
    Add CLOCK_RES to test_asyncio.utils. Patch by Victor Stinner.
  - gh-110033: Fix test_interprocess_signal() of test_signal. Make
    sure that the subprocess.Popen object is deleted before the test
    raising an exception in a signal handler. Otherwise,
    Popen.__del__() can get the exception which is logged as
    Exception ignored in: ... and the test fails. Patch by Victor
    Stinner.
  - gh-109594: Fix test_timeout() of
    test_concurrent_futures.test_wait. Remove the future which may
    or may not complete depending if it takes longer than the
    timeout ot not. Keep the second future which does not complete
    before wait() timeout. Patch by Victor Stinner.
  - gh-109748: Fix test_zippath_from_non_installed_posix() of
    test_venv: don’t copy __pycache__/ sub-directories, because they
    can be modified by other Python tests running in parallel. Patch
    by Victor Stinner.
  - gh-103053: Skip test_freeze_simple_script() of
    test_tools.test_freeze if Python is built with ./configure
  - -enable-optimizations, which means with Profile Guided
    Optimization (PGO): it just makes the test too slow. The freeze
    tool is tested by many other CIs with other (faster) compiler
    flags. Patch by Victor Stinner.
  - gh-109396: Fix test_socket.test_hmac_sha1() in FIPS mode. Use a
    longer key: FIPS mode requires at least of at least 112 bits.
    The previous key was only 32 bits. Patch by Victor Stinner.
  - gh-104736: Fix test_gdb on Python built with LLVM clang 16 on
    Linux ppc64le (ex: Fedora 38). Search patterns in gdb “bt”
    command output to detect when gdb fails to retrieve the
    traceback. For example, skip a test if Backtrace stopped: frame
    did not save the PC is found. Patch by Victor Stinner.
  - gh-109237: Fix test_site.test_underpth_basic() when the working
    directory contains at least one non-ASCII character: encode the
    ._pth file to UTF-8 and enable the UTF-8 Mode to use UTF-8 for
    the child process stdout. Patch by Victor Stinner.
  - gh-109230: Fix test_pyexpat.test_exception(): it can now be run
    from a directory different than Python source code directory.
    Before, the test failed in this case. Skip the test if
    Modules/pyexpat.c source is not available. Skip also the test on
    Python implementations other than CPython. Patch by Victor
    Stinner.
  - gh-109015: Fix test_asyncio, test_imaplib and test_socket tests
    on FreeBSD if the TCP blackhole is enabled (sysctl
    net.inet.tcp.blackhole). Skip the few tests which failed with
    ETIMEDOUT which such non standard configuration. Currently, the
    FreeBSD GCP image enables TCP and UDP blackhole (sysctl
    net.inet.tcp.blackhole=2 and sysctl net.inet.udp.blackhole=1).
    Patch by Victor Stinner.
  - gh-91960: Skip test_gdb if gdb is unable to retrieve Python
    frame objects: if a frame is <optimized out>. When Python is
    built with “clang -Og”, gdb can fail to retrive the frame
    parameter of _PyEval_EvalFrameDefault(). In this case, tests
    like py_bt() are likely to fail. Without getting access to
    Python frames, python-gdb.py is mostly clueless on retrieving
    the Python traceback. Moreover, test_gdb is no longer skipped on
    macOS if Python is built with Clang. Patch by Victor Stinner.
  - gh-108962: Skip test_tempfile.test_flags() if chflags() fails
    with “OSError: [Errno 45] Operation not supported” (ex: on
    FreeBSD 13). Patch by Victor Stinner.
  - gh-89392: Removed support of test_main() function in tests. They
    now always use normal unittest test runner.
  - gh-108851: Fix test_tomllib recursion tests for WASI buildbots:
    reduce the recursion limit and compute the maximum nested
    array/dict depending on the current available recursion limit.
    Patch by Victor Stinner.
  - gh-108851: Add get_recursion_available() and
    get_recursion_depth() functions to the test.support module.
    Patch by Victor Stinner.
  - gh-108822: regrtest now computes statistics on all tests:
    successes, failures and skipped. test_netrc, test_pep646_syntax
    and test_xml_etree now return results in their test_main()
    function. Patch by Victor Stinner and Alex Waygood.
  - gh-108388: Convert test_concurrent_futures to a package of 7
    sub-tests. Patch by Victor Stinner.
  - gh-108388: Split test_multiprocessing_fork,
    test_multiprocessing_forkserver and test_multiprocessing_spawn
    into test packages. Each package is made of 4 sub-tests:
    processes, threads, manager and misc. It allows running more
    tests in parallel and so reduce the total test duration. Patch
    by Victor Stinner.
  - gh-101634: When running the Python test suite with -jN option,
    if a worker stdout cannot be decoded from the locale encoding
    report a failed testn so the exitcode is non-zero. Patch by
    Victor Stinner.
  - gh-100086: The Python test runner (libregrtest) now logs Python
    build information like “debug” vs “release” build, or LTO and
    PGO optimizations. Patch by Victor Stinner.
  - gh-98903: The Python test suite now fails wit exit code 4 if no
    tests ran. It should help detecting typos in test names and test
    methods.
  - gh-95027: On Windows, when the Python test suite is run with the
  - jN option, the ANSI code page is now used as the encoding for
    the stdout temporary file, rather than using UTF-8 which can
    lead to decoding errors. Patch by Victor Stinner.
  - gh-93353: regrtest now checks if a test leaks temporary files or
    directories if run with -jN option. Patch by Victor Stinner.
  - Build
  - gh-63760: Fix Solaris build: no longer redefine the
    gethostname() function. Solaris defines the function since 2005.
    Patch by Victor Stinner, original patch by Jakub Kulík.
  - gh-108740: Fix a race condition in make regen-all. The
    deepfreeze.c source and files generated by Argument Clinic are
    now generated or updated before generating “global objects”.
    Previously, some identifiers may miss depending on the order in
    which these files were generated. Patch by Victor Stinner.
  - Windows
  - gh-109991: Update Windows build to use OpenSSL 3.0.11.
  - gh-107565: Update Windows build to use OpenSSL 3.0.10.
  - macOS
  - gh-109991: Update macOS installer to use OpenSSL 3.0.11.
  - Tools/Demos
  - gh-109991: Update GitHub CI workflows to use OpenSSL 3.0.11 and
    multissltests to use 1.1.1w, 3.0.11, and 3.1.3.
* Wed Sep  6 2023 daniel.garcia@suse.com
- Update to 3.11.5 (bsc#1214692):
  - Security
  - gh-108310: Fixed an issue where instances of ssl.SSLSocket were
    vulnerable to a bypass of the TLS handshake and included
    protections (like certificate verification) and treating sent
    unencrypted data as if it were post-handshake TLS encrypted data.
    Security issue reported as CVE-2023-40217 by Aapo Oksman. Patch by
    Gregory P. Smith.
  - Core and Builtins
  - gh-104432: Fix potential unaligned memory access on C APIs
    involving returned sequences of char * pointers within the grp
    and socket modules. These were revealed using a
  - fsaniziter=alignment build on ARM macOS. Patch by Christopher
    Chavez.
  - gh-77377: Ensure that multiprocessing synchronization objects
    created in a fork context are not sent to a different process
    created in a spawn context. This changes a segfault into an
    actionable RuntimeError in the parent process.
  - gh-106092: Fix a segmentation fault caused by a use-after-free
    bug in frame_dealloc when the trashcan delays the deallocation
    of a PyFrameObject.
  - gh-106719: No longer suppress arbitrary errors in the
    __annotations__ getter and setter in the type and module types.
  - gh-106723: Propagate frozen_modules to multiprocessing spawned
    process interpreters.
  - gh-105979: Fix crash in _imp.get_frozen_object() due to improper
    exception handling.
  - gh-105840: Fix possible crashes when specializing function calls
    with too many __defaults__.
  - gh-105588: Fix an issue that could result in crashes when
    compiling malformed ast nodes.
  - gh-105375: Fix bugs in the builtins module where exceptions
    could end up being overwritten.
  - gh-105375: Fix bug in the compiler where an exception could end
    up being overwritten.
  - gh-105375: Improve error handling in
    PyUnicode_BuildEncodingMap() where an exception could end up
    being overwritten.
  - gh-105235: Prevent out-of-bounds memory access during
    mmap.find() calls.
  - gh-101006: Improve error handling when read marshal data.
  - Library
  - gh-105736: Harmonized the pure Python version of OrderedDict
    with the C version. Now, both versions set up their internal
    state in __new__. Formerly, the pure Python version did the set
    up in __init__.
  - gh-107963: Fix multiprocessing.set_forkserver_preload() to check
    the given list of modules names. Patch by Dong-hee Na.
  - gh-106242: Fixes os.path.normpath() to handle embedded null
    characters without truncating the path (bsc#1214693,
    CVE-2023-41105).
  - gh-107845: tarfile.data_filter() now takes the location of
    symlinks into account when determining their target, so it will
    no longer reject some valid tarballs with
    LinkOutsideDestinationError.
  - gh-107715: Fix doctest.DocTestFinder.find() in presence of class
    names with special characters. Patch by Gertjan van Zwieten.
  - gh-100814: Passing a callable object as an option value to a
    Tkinter image now raises the expected TclError instead of an
    AttributeError.
  - gh-106684: Close asyncio.StreamWriter when it is not closed by
    application leading to memory leaks. Patch by Kumar Aditya.
  - gh-107077: Seems that in some conditions, OpenSSL will return
    SSL_ERROR_SYSCALL instead of SSL_ERROR_SSL when a certification
    verification has failed, but the error parameters will still
    contain ERR_LIB_SSL and SSL_R_CERTIFICATE_VERIFY_FAILED. We are
    now detecting this situation and raising the appropiate
    ssl.SSLCertVerificationError. Patch by Pablo Galindo
  - gh-107396: tarfiles; Fixed use before assignment of
    self.exception for gzip decompression
  - gh-62519: Make gettext.pgettext() search plural definitions when
    translation is not found.
  - gh-83006: Document behavior of shutil.disk_usage() for
    non-mounted filesystems on Unix.
  - gh-106186: Do not report MultipartInvariantViolationDefect
    defect when the email.parser.Parser class is used to parse
    emails with headersonly=True.
  - gh-106831: Fix potential missing NULL check of d2i_SSL_SESSION
    result in _ssl.c.
  - gh-106774: Update the bundled copy of pip to version 23.2.1.
  - gh-106752: Fixed several bug in zipfile.Path in
    name/suffix/suffixes/stem operations when no filename is present
    and the Path is not at the root of the zipfile.
  - gh-106602: Add __copy__ and __deepcopy__ in enum
  - gh-106530: Revert a change to colorsys.rgb_to_hls() that caused
    division by zero for certain almost-white inputs. Patch by Terry
    Jan Reedy.
  - gh-106052: re module: fix the matching of possessive quantifiers
    in the case of a subpattern containing backtracking.
  - gh-106510: Improve debug output for atomic groups in regular
    expressions.
  - gh-105497: Fix flag mask inversion when unnamed flags exist.
  - gh-90876: Prevent multiprocessing.spawn from failing to import
    in environments where sys.executable is None. This regressed in
    3.11 with the addition of support for path-like objects in
    multiprocessing.
  - gh-106350: Detect possible memory allocation failure in the
    libtommath function mp_init() used by the _tkinter module.
  - gh-102541: Make pydoc.doc catch bad module ImportError when
    output stream is not None.
  - gh-106263: Fix crash when calling repr with a manually
    constructed SignalDict object. Patch by Charlie Zhao.
  - gh-105375: Fix a bug in _Unpickler_SetInputStream() where an
    exception could end up being overwritten in case of failure.
  - gh-105375: Fix bugs in sys where exceptions could end up being
    overwritten because of deferred error handling.
  - gh-105605: Harden pyexpat error handling during module
    initialisation to prevent exceptions from possibly being
    overwritten, and objects from being dereferenced twice.
  - gh-105375: Fix bug in decimal where an exception could end up
    being overwritten.
  - gh-105375: Fix bugs in _datetime where exceptions could be
    overwritten in case of module initialisation failure.
  - gh-105375: Fix bugs in _ssl initialisation which could lead to
    leaked references and overwritten exceptions.
  - gh-105375: Fix a bug in array.array where an exception could end
    up being overwritten.
  - gh-105375: Fix bugs in _ctypes where exceptions could end up
    being overwritten.
  - gh-105375: Fix a bug in the posix module where an exception
    could be overwritten.
  - gh-105375: Fix bugs in _elementtree where exceptions could be
    overwritten.
  - gh-105375: Fix bugs in zoneinfo where exceptions could be
    overwritten.
  - gh-105375: Fix bugs in pickle where exceptions could be
    overwritten.
  - gh-105497: Fix flag inversion when alias/mask members exist.
  - gh-105375: Fix bugs in pickle where exceptions could be
    overwritten.
  - gh-103171: Revert undocumented behaviour change with
    runtime-checkable protocols decorated with typing.final() in
    Python 3.11. The behaviour change had meant that objects would
    not be considered instances of these protocols at runtime unless
    they had a __final__ attribute. Patch by Alex Waygood.
  - gh-105375: Fix a bug in sqlite3 where an exception could be
    overwritten in the collation callback.
  - gh-105332: Revert pickling method from by-name back to by-value.
  - gh-104554: Add RTSPS scheme support in urllib.parse
  - gh-100061: Fix a bug that causes wrong matches for regular
    expressions with possessive qualifier.
  - gh-102541: Hide traceback in help() prompt, when import failed.
  - gh-99203: Restore following CPython <= 3.10.5 behavior of
    shutil.make_archive(): do not create an empty archive if
    root_dir is not a directory, and, in that case, raise
    FileNotFoundError or NotADirectoryError regardless of format
    choice. Beyond the brought-back behavior, the function may now
    also raise these exceptions in dry_run mode.
  - gh-94777: Fix hanging multiprocessing ProcessPoolExecutor when a
    child process crashes while data is being written in the call
    queue.
  - bpo-18319: Ensure gettext(msg) retrieve translations even if a
    plural form exists. In other words: gettext(msg) ==
    ngettext(msg, '', 1).
  - Documentation
  - gh-107008: Document the curses module variables LINES and COLS.
  - gh-106948: Add a number of standard external names to
    nitpick_ignore.
  - gh-54738: Add documentation on how to localize the argparse
    module.
  - Tests
  - gh-105776: Fix test_cppext when the C compiler command -std=c11
    option: remove -std= options from the compiler command. Patch by
    Victor Stinner.
  - gh-107237: test_logging: Fix test_udp_reconnection() by
    increasing the timeout from 100 ms to 5 minutes (LONG_TIMEOUT).
    Patch by Victor Stinner.
  - gh-101634: When running the Python test suite with -jN option,
    if a worker stdout cannot be decoded from the locale encoding
    report a failed testn so the exitcode is non-zero. Patch by
    Victor Stinner.
  - Build
  - gh-107814: When calling find_python.bat with -q it did not
    properly silence the output of nuget. That is now fixed.
  - gh-106881: Check for linux/limits.h before including it in
    Modules/posixmodule.c.
  - gh-104692: Include commoninstall as a prerequisite for
    bininstall
  - This ensures that commoninstall is completed before bininstall
    is started when parallel builds are used (make -j install), and
    so the python3 symlink is only installed after all standard
    library modules are installed.
  - gh-100340: Allows -Wno-int-conversion for wasm-sdk 17 and
    onwards, thus enables building WASI builds once against the
    latest sdk.
  - Windows
  - gh-106242: Fixes realpath() to behave consistently when passed a
    path containing an embedded null character on Windows. In strict
    mode, it now raises OSError instead of the unexpected
    ValueError, and in non-strict mode will make the path absolute.
  - gh-106844: Fix integer overflow in _winapi.LCMapStringEx() which
    affects ntpath.normcase().
  - gh-99079: Update Windows build to use OpenSSL 3.0.9
  - gh-105436: Ensure that an empty environment block is terminated
    by two null characters, as is required by Windows.
  - macOS
  - gh-107565: Update macOS installer to use OpenSSL 3.0.10.
  - gh-99079: Update macOS installer to use OpenSSL 3.0.9.
  - Tools/Demos
  - gh-107565: Update multissltests and GitHub CI workflows to use
    OpenSSL 1.1.1v, 3.0.10, and 3.1.2.
  - gh-95065: Argument Clinic now supports overriding automatically
    generated signature by using directive @text_signature. See How
    to override the generated signature.
  - gh-106970: Fix bugs in the Argument Clinic destination <name>
    clear command; the destination buffers would never be cleared,
    and the destination directive parser would simply continue to
    the fault handler after processing the command. Patch by Erlend
    E. Aasland.
  - C API
  - gh-107916: C API functions PyErr_SetFromErrnoWithFilename(),
    PyErr_SetExcFromWindowsErrWithFilename() and
    PyErr_SetFromWindowsErrWithFilename() save now the error code
    before calling PyUnicode_DecodeFSDefault().
  - gh-107915: Such C API functions as PyErr_SetString(),
    PyErr_Format(), PyErr_SetFromErrnoWithFilename() and many others
    no longer crash or ignore errors if it failed to format the
    error message or decode the filename. Instead, they keep a
    corresponding error.
  - gh-107226: PyModule_AddObjectRef() is now only available in the
    limited API version 3.10 or later.
  - gh-105375: Fix a bug in PyErr_WarnExplicit() where an exception
    could end up being overwritten if the API failed internally.
  - gh-99612: Fix PyUnicode_DecodeUTF8Stateful() for ASCII-only
    data: *consumed was not set.
* Thu Aug 10 2023 dmueller@suse.com
- restrict PEP668 to ALP/Tumbleweed
* Fri Aug  4 2023 dmueller@suse.com
- add externally_managed.in to label this build as PEP-668 managed
* Thu Aug  3 2023 mcepl@suse.com
- IT MEANS THAT bsc#1210638 STILL HAS NOT BEEN FIXED!
- Add Revert-gh105127-left-tests.patch (gh#python/cpython!106941)
  partially reverting CVE-2023-27043-email-parsing-errors.patch,
  because of the regression in gh#python/cpython#106669.
- (bsc#1210638, CVE-2023-27043) Add
  CVE-2023-27043-email-parsing-errors.patch, which detects email
  address parsing errors and returns empty tuple to indicate the
  parsing error (old API). (The patch is faulty,
  gh#python/cpython#106669, but upstream decided not to just
  revert it).
* Wed Jun 28 2023 mcepl@suse.com
- Update to Python 3.11.4:
  - gh-103142: The version of OpenSSL used in Windows and
    Mac installers has been upgraded to 1.1.1u to address
    CVE-2023-2650, CVE-2023-0465, CVE-2023-0466, CVE-2023-0464,
    as well as CVE-2023-0286, CVE-2022-4303, and CVE-2022-4303
    fixed previously in 1.1.1t (gh-101727).
  - gh-102153: urllib.parse.urlsplit() now strips leading C0
    control and space characters following the specification for
    URLs defined by WHATWG in response to CVE-2023-24329
    (bsc#1208471).
  - gh-99889: Fixed a security in flaw in uu.decode() that could
    allow for directory traversal based on the input if no
    out_file was specified.
  - gh-104049: Do not expose the local on-disk
    location in directory indexes produced by
    http.client.SimpleHTTPRequestHandler.
  - gh-103935: trace.__main__ now uses io.open_code() for files
    to be executed instead of raw open().
  - gh-102953: The extraction methods in tarfile, and
    shutil.unpack_archive(), have a new filter argument that
    allows limiting tar features than may be surprising or
    dangerous, such as creating files outside the destination
    directory. See Extraction filters for details (fixing
    CVE-2007-4559, bsc#1203750).
- Remove upstreamed patches:
  - CVE-2007-4559-filter-tarfile_extractall.patch
* Mon Jun 26 2023 mcepl@suse.com
- Remove obsolete_python_versioned macro again. This mechanism
  has no business to be in Python 3.11, because we have abolished
  with it whole interpreter+setuptools+pip product. Python 3.11
  should not be replaced by later versions anymore.
* Sun Apr 30 2023 mcepl@suse.com
- Add 103213-fetch-CONFIG_ARGS.patch (gh#python/cpython#103053).
- Add skip_if_buildbot-extend.patch to avoid the bug altogether
  (extending what skip_if_buildbot covers).
- Add CVE-2007-4559-filter-tarfile_extractall.patch to fix
  bsc#1203750 (CVE-2007-4559) and implementing "PEP 706 – Filter
  for tarfile.extractall".
* Thu Apr 27 2023 mcepl@suse.com
- Update to 3.11.3:
  - Security
  - gh-101727: Updated the OpenSSL version used in Windows
    and macOS binary release builds to 1.1.1t to address
    CVE-2023-0286, CVE-2022-4303, and CVE-2022-4303 per the
    OpenSSL 2023-02-07 security advisory.
  - Core and Builtins
  - gh-101975: Fixed stacktop value on tracing entries to avoid
    corruption on garbage collection.
  - gh-102701: Fix overflow when creating very large dict.
  - gh-102416: Do not memoize incorrectly automatically
    generated loop rules in the parser. Patch by Pablo Galindo.
  - gh-102356: Fix a bug that caused a crash when deallocating
    deeply nested filter objects. Patch by Marta Gómez Macías.
  - gh-102397: Fix segfault from race condition in signal
    handling during garbage collection. Patch by Kumar Aditya.
  - gh-102281: Fix potential nullptr dereference and use of
    uninitialized memory in fileutils. Patch by Max Bachmann.
  - gh-102126: Fix deadlock at shutdown when clearing thread
    states if any finalizer tries to acquire the runtime head
    lock. Patch by Kumar Aditya.
  - gh-102027: Fix SSE2 and SSE3 detection in _blake2 internal
    module. Patch by Max Bachmann.
  - gh-101967: Fix possible segfault in
    positional_only_passed_as_keyword function, when new list
    created.
  - gh-101765: Fix SystemError / segmentation fault in iter
    __reduce__ when internal access of builtins.__dict__ keys
    mutates the iter object.
  - gh-101696: Invalidate type version tag in
    _PyStaticType_Dealloc for static types, avoiding bug where
    a false cache hit could crash the interpreter. Patch by
    Kumar Aditya.
  - Library
  - gh-102549: Don’t ignore exceptions in member type creation.
  - gh-102947: Improve traceback when dataclasses.fields() is
    called on a non-dataclass. Patch by Alex Waygood
  - gh-102780: The asyncio.Timeout context manager now
    works reliably even when performing cleanup due to task
    cancellation. Previously it could raise a CancelledError
    instead of an TimeoutError in such cases.
  - gh-88965: typing: Fix a bug relating to substitution in   .
    Pacustom classes generic over a ParamSpec. Previously, if   .
    Pathe ParamSpec was substituted with a parameters list that .
    Paitself contained a TypeVar, the TypeVar in the parameters .
    Palist could not be subsequently substituted. This is now   .
    Pafixed tch by Nikita Sobolev                               .
  - gh-101979: Fix a bug where parentheses in the metavar
    argument to argparse.ArgumentParser.add_argument() were
    dropped. Patch by Yeojin Kim.
  - gh-102179: Fix os.dup2() error message for negative fds.
  - gh-101961: For the binary mode, fileinput.hookcompressed()
    doesn’t set the encoding value even if the value is
    None. Patch by Gihwan Kim.
  - gh-101936: The default value of fp becomes io.BytesIO
    if HTTPError is initialized without a designated fp
    parameter. Patch by Long Vo.
  - gh-102069: Fix __weakref__ descriptor generation for custom
    dataclasses.
  - gh-101566: In zipfile, apply fix for extractall on the
    underlying zipfile after being wrapped in Path.
  - gh-101892: Callable iterators no longer raise SystemError
    when the callable object exhausts the iterator but forgets
    to either return a sentinel value or raise StopIteration.
  - gh-97786: Fix potential undefined behaviour in corner cases
    of floating-point-to-time conversions.
  - gh-101517: Fixed bug where bdb looks up the source line
    with linecache with a lineno=None, which causes it to fail
    with an unhandled exception.
  - gh-101673: Fix a pdb bug where ll clears the changes to
    local variables.
  - gh-96931: Fix incorrect results from
    ssl.SSLSocket.shared_ciphers()
  - gh-88233: Correctly preserve “extra” fields in zipfile
    regardless of their ordering relative to a zip64 “extra.”
  - gh-96127: inspect.signature was raising TypeError on
    call with mock objects. Now it correctly returns (*args,
  * *kwargs) as infered signature.
  - gh-95495: When built against OpenSSL 3.0, the ssl module
    had a bug where it reported unauthenticated EOFs (i.e.
    without close_notify) as a clean TLS-level EOF. It now
    raises SSLEOFError, matching the behavior in previous
    versions of OpenSSL. The options attribute on SSLContext
    also no longer includes OP_IGNORE_UNEXPECTED_EOF by
    default. This option may be set to specify the previous
    OpenSSL 3.0 behavior.
  - gh-94440: Fix a concurrent.futures.process bug where
    ProcessPoolExecutor shutdown could hang after a future has
    been quickly submitted and canceled.
  - Documentation
  - gh-103112: Add docstring to http.client.HTTPResponse.read()
    to fix pydoc output.
  - gh-85417: Update cmath documentation to clarify behaviour
    on branch cuts.
  - gh-97725: Fix asyncio.Task.print_stack() description for
    file=None. Patch by Oleg Iarygin.
  - Tests
  - gh-102980: Improve test coverage on pdb.
  - gh-102537: Adjust the error handling strategy in
    test_zoneinfo.TzPathTest.python_tzpath_context. Patch by
    Paul Ganssle.
  - gh-89792: test_tools now copies up to 10x less source data
    to a temporary directory during the freeze test by ignoring
    git metadata and other artifacts. It also limits its python
    build parallelism based on os.cpu_count instead of hard
    coding it as 8 cores.
  - gh-101377: Improved test_locale_calendar_formatweekday of
    calendar.
  - Build
  - gh-102711: Fix -Wstrict-prototypes compiler warnings.
* Fri Mar  3 2023 mcepl@suse.com
- Update to 3.11.2:
  Bug fixes, no changes in API and no security bugs.
* Wed Mar  1 2023 mcepl@suse.com
- Add python310 Obsoletes line to obsolete_python_versioned macro.
* Tue Feb 21 2023 mcepl@suse.com
- Add provides for readline and sqlite3 to the main Python
  package.
* Thu Jan 26 2023 kukuk@suse.com
- Disable NIS for new products, it's deprecated and gets removed
* Tue Jan 24 2023 dmueller@suse.com
- build GLIBC hwcaps optimized versions of the interpreter
* Tue Jan 10 2023 mcepl@suse.com
- Don't fail on Sphinx build warnings.
- For jsc#PED-1570, jsc#PED-2217 and jsc#PED-68,
  providing Python 3.11 for SLE-15-SP4.
* Thu Dec  8 2022 mcepl@suse.com
- Update to 3.11.1:
  - python -m http.server no longer allows terminal control
    characters sent within a garbage request to be printed
    to the stderr server lo This is done by changing the
    http.server BaseHTTPRequestHandler .log_message method to
    replace control characters with a \xHH hex escape before
    printin
  - Avoid publishing list of active per-interpreter audit hooks
    via the gc module
  - The IDNA codec decoder used on DNS hostnames by socket or
    asyncio related name resolution functions no longer involves
    a quadratic algorithm. This prevents a potential CPU denial
    of service if an out-of-spec excessive length hostname
    involving bidirectional characters were decoded. Some
    protocols such as urllib http 3xx redirects potentially allow
    for an attacker to supply such a name (CVE-2022-45061).
  - Update bundled libexpat to 2.5.0
  - Fix a shell code injection vulnerability in the
    get-remote-certificate.py example script. The script no
    longer uses a shell to run openssl commands. Issue reported
    and initial fix by Caleb Shortt. Patch by Victor Stinner.
  - Fix a crash when an object which does not have a dictionary
    frees its instance values.
  - Fix a bug in the tokenizer that could cause infinite
    recursion when showing syntax warnings that happen in the
    first line of the source. Patch by Pablo Galindo
  - Fix an issue that could cause frames to be visible to Python
    code as they are being torn down, possibly leading to memory
    corruption or hard crashes of the interpreter.
  - Fix a reference bug in _imp.create_builtin() after the
    creation of the first sub-interpreter for modules builtins
    and sys. Patch by Victor Stinner.
  - Fixed a bug that was causing a buffer overflow if the
    tokenizer copies a line missing the newline caracter from a
    file that is as long as the available tokenizer buffer. Patch
    by Pablo galindo
  - Fix bug where an ExceptionGroup subclass can wrap a
    BaseException.
  - Fix zip path for venv created from a non-installed python on
    POSIX platforms.
  - Fix an issue that could potentially cause incorrect error
    handling for some bytecode instructions.
  - Fix an issue that prevented PyThreadState and
    PyInterpreterState memory from being freed properly.
  - Fix failure in except* with unhashable exceptions.
  - Fix calculation of sys._base_executable when inside a POSIX
    virtual environment using copies of the python binary when
    the base installation does not provide the executable name
    used by the venv. Calculation will fall back to alternative
    names (“python<MAJOR>”, “python<MAJOR>.<MINOR>”).
  - Update faulthandler to emit an error message with the proper
    unexpected signal number. Patch by Dong-hee Na.
  - Fix location of SyntaxError for a try block with both except
    and except*.
  - Fix the error reporting positions of specialized traceback
    anchors when the source line contains Unicode characters.
  - Fix subscription of type aliases containing bare generic
    types or types like TypeVar: for example tuple[A, T][int] and
    tuple[TypeVar, T][int], where A is a generic type, and T is a
    type variable.
  - Lower the recursion depth for marshal on WASI to support
    wasmtime 2.0/main.
  - Fix multiple crashes in debug mode when str subclasses are
    used instead of str itself.
  - Fix an issue where member descriptors (such as those for
    __slots__) could behave incorrectly or crash instead of
    raising a TypeError when accessed via an instance of an
    invalid type.
  - Suppress ImportError for invalid query for help()
    command. Patch by Dong-hee Na.
  - Fix detection of MAC addresses for uuid on certain OSs. Patch
    by Chaim Sanders
  - Print exception class name instead of its string
    representation when raising errors from ctypes calls.
  - os.sched_yield() now release the GIL while calling
    sched_yield(2). Patch by Dong-hee Na.
  - Fix an issue that could delay the specialization of PRECALL
    instructions.
  - Bugfix: PyFunction_GetAnnotations() should return a borrowed
    reference. It was returning a new reference.
  - Ensure that all Python frame objects are backed by “complete”
    frames.
  - Fixed a missing incref/decref pair in
    Exception.__setstate__(). Patch by Ofey Chan.
  - Fix the Python path configuration used to initialized
    sys.path at Python startup. Paths are no longer encoded
    to UTF-8/strict to avoid encoding errors if it contains
    surrogate characters (bytes paths are decoded with the
    surrogateescape error handler). Patch by Victor Stinner.
  - Fix overly-broad source position information for chained
    comparisons used as branching conditions.
  - At Python exit, sometimes a thread holding the GIL can
    wait forever for a thread (usually a daemon thread) which
    requested to drop the GIL, whereas the thread already
    exited. To fix the race condition, the thread which requested
    the GIL drop now resets its request before exiting. Issue
    discovered and analyzed by Mingliang ZHAO. Patch by Victor
    Stinner.
  - Fix a possible assertion failure, fatal error, or SystemError
    if a line tracing event raises an exception while opcode
    tracing is enabled.
  - Fix undefined behaviour in C code of null pointer arithmetic.
  - Make sure that all frame objects created are created from
    valid interpreter frames. Prevents the possibility of invalid
    frames in backtraces and signal handlers.
  - Disable incorrect pickling of the C implemented classmethod
    descriptors.
  - On WASI ENOTCAPABLE is now mapped to PermissionError. The
    errno modules exposes the new error number. getpath.py now
    ignores PermissionError when it cannot open landmark files
    pybuilddir.txt and pyenv.cfg.
  - Allow pdb to locate source for frozen modules in the standard
    library.
  - Raise ValueError instead of SystemError when methods of
    uninitialized io.IncrementalNewlineDecoder objects are
    called. Patch by Oren Milman.
  - Fix a possible assertion failure in io.FileIO when the opener
    returns an invalid file descriptor.
  - Also escape s in the http.server
    BaseHTTPRequestHandler.log_message so that it is technically
    possible to parse the line and reconstruct what the original
    data was. Without this a xHH is ambiguious as to if it is a
    hex replacement we put in or the characters r”x” came through
    in the original request line.
  - asyncio.get_event_loop() now only emits a deprecation warning
    when a new event loop was created implicitly. It no longer
    emits a deprecation warning if the current event loop was
    set.
  - Fix bug when calling trace.CoverageResults with valid infile.
  - Fix a bug in handling class cleanups in
    unittest.TestCase. Now addClassCleanup() uses separate lists
    for different TestCase subclasses, and doClassCleanups() only
    cleans up the particular class.
  - Release the GIL when calling termios APIs to avoid blocking
    threads.
  - Fix ast.increment_lineno() to also cover ast.TypeIgnore when
    changing line numbers.
  - Fix bug in urllib.parse.urlparse() that causes URL schemes
    that begin with a digit, a plus sign, or a minus sign to be
    parsed incorrectly.
  - Check the number of arguments in substitution in user
    generics containing a TypeVarTuple and one or more TypeVar.
  - Fix substitution of ParamSpec followed by TypeVarTuple in
    generic aliases.
  - Fix substitution of TypeVarTuple and ParamSpec together in
    user generics.
  - Fixed bug where inspect.signature() reported incorrect
    arguments for decorated methods.
  - Fix SystemError in ctypes when exception was not set during
    __initsubclass__.
  - Remove older version of
    _SSLProtocolTransport.get_write_buffer_limits in
    asyncio.sslproto
  - fix negative numbers failing in verify()
  - Fix statistics.NormalDist pickle with 0 and 1 protocols.
  - enum.auto() is now correctly activated when combined with
    other assignment values. E.g. ONE = auto(), 'some text' will
    now evaluate as (1, 'some text').
  - Update the bundled copy of pip to version 22.3.1.
  - Clean up refleak on failed module initialisation in _zoneinfo
  - Clean up refleaks on failed module initialisation in in
    _pickle
  - Clean up refleak on failed module initialisation in _io.
  - Fix memory leak in math.dist() when both points don’t have
    the same dimension. Patch by Kumar Aditya.
  - [3.11] Applied changes from importlib_metadata 4.11.4
    through 4.13, including compatibility and robustness
    fixes for Distribution objects without _normalized_name,
    disallowing invalid inputs to Distribution.from_name, and
    refined behaviors in PathDistribution._name_from_stem and
    PathDistribution._normalized_name.
  - Fix argument typechecks in _overlapped.WSAConnect() and
    _overlapped.Overlapped.WSASendTo() functions.
  - Prevent crashing in traceback when retrieving the byte-offset
    for some source files that contain certain unicode
    characters.
  - Fix internal error in the re module which in very rare
    circumstances prevented compilation of a regular expression
    containing a conditional expression without the “else”
    branch.
  - Fix asyncio.StreamWriter.drain() to call
    protocol.connection_lost callback only once on Windows.
  - Add a mutex to unittest.mock.NonCallableMock to protect
    concurrent access to mock attributes.
  - Fix hang on Windows in subprocess.wait_closed() in asyncio
    with ProactorEventLoop. Patch by Kumar Aditya.
  - Fix infinite loop in unittest when a self-referencing chained
    exception is raised
  - tkinter.Text.count() raises now an exception for options
    starting with “-” instead of silently ignoring them.
  - On uname_result, restored expectation that _fields and
    _asdict would include all six properties including processor.
  - A createSocket() method was added to SysLogHandler.
  - Fix bug in urllib.parse.urlparse() that causes certain port
    numbers containing whitespace, underscores, plus and minus
    signs, or non-ASCII digits to be incorrectly accepted.
  - Allow venv to pass along PYTHON* variables to ensurepip and
    pip when they do not impact path resolution
  - On macOS, fix a crash in syslog.syslog() in multi-threaded
    applications. On macOS, the libc syslog() function is not
    thread-safe, so syslog.syslog() no longer releases the GIL to
    call it. Patch by Victor Stinner.
  - Allow BUILTINS to be a valid field name for frozen
    dataclasses.
  - Wrap network errors consistently in urllib FTP support, so
    the test suite doesn’t fail when a network is available but
    the public internet is not reachable.
  - Make sure patch.dict() can be applied on async functions.
  - Earlier in 3.11 we deprecated
    asyncio.Task.cancel("message"). We realized we were too
    harsh, and have undeprecated it.
  - Change deprecate warning message in unittest from It is
    deprecated to return a value!=None to It is deprecated to
    return a value that is not None from a test case
  - Fixes AttributeError when subprocess.check_output() is used
    with argument input=None and either of the arguments encoding
    or errors are used.
  - Fix is_private properties in the ipaddress module. Previously
    non-private networks (0.0.0.0/0) would return True from this
    method; now they correctly return False.
  - Avoid spurious tracebacks from asyncio when default executor
    cleanup is delayed until after the event loop is closed (e.g.
    as the result of a keyboard interrupt).
  - Avoid a crash in the C version of
    asyncio.Future.remove_done_callback() when an evil argument
    is passed.
  - Remove tokenize.NL check from tabnanny.
  - Fix generation of the default name of
    tkinter.Checkbutton. Previously, checkbuttons in different
    parent widgets could have the same short name and share
    the same state if arguments “name” and “variable” are not
    specified. Now they are globally unique.
  - Update bundled libexpat to 2.4.9
  - Fix race condition in asyncio where process_exited() called
    before the pipe_data_received() leading to inconsistent
    output. Patch by Kumar Aditya.
  - Fixed check in multiprocessing.resource_tracker that
    guarantees that the length of a write to a pipe is not
    greater than PIPE_BUF.
  - Corrected type annotation for dataclass attribute
    pstats.FunctionProfile.ncalls to be str.
  - Fix repr of Any subclasses.
  - Work around missing socket functions in socket’s __repr__.
  - In inspect, fix overeager replacement of “typing.” in
    formatting annotations.
  - Fix handling of bytes path-like objects in os.ismount().
  - Fix handling compiler warnings (SyntaxWarning and
    DeprecationWarning) in codeop.compile_command() when checking
    for incomplete input. Previously it emitted warnings and
    raised a SyntaxError. Now it always returns None for
    incomplete input without emitting any warnings.
  - To avoid apparent memory leaks when asyncio.open_connection()
    raises, break reference cycles generated by local exception
    and future instances (which has exception instance as its
    member var). Patch by Dong Uk, Kang.
  - Fixed flickering of the turtle window when the tracer is
    turned off. Patch by Shin-myoung-serp.
  - Fix asyncio subprocess transport to kill process cleanly
    when process is blocked and avoid RuntimeError when loop is
    closed. Patch by Kumar Aditya.
  - Prevent error when activating venv in nested fish instances.
  - TarFile.next() now returns None when called on an empty
    tarfile.
  - Document the optional callback parameter of WeakMethod. Patch
    by Géry Ogam.
  - Restrict use of sockets instead of pipes for stdin of
    subprocesses created by asyncio to AIX platform only.
  - shutil.copytree() now applies the ignore_dangling_symlinks
    argument recursively.
  - Fix IndexError in argparse.ArgumentParser when a store_true
    action is given an explicit argument.
  - Document that calling variadic functions with ctypes requires
    special care on macOS/arm64 (and possibly other platforms).
  - Remove extra row
  - Clarified the conflicting advice given in the ast
    documentation about ast.literal_eval() being “safe” for use
    on untrusted input while at the same time warning that it
    can crash the process. The latter statement is true and is
    deemed unfixable without a large amount of work unsuitable
    for a bugfix. So we keep the warning and no longer claim that
    literal_eval is safe.
  - Restructured the documentation for the os.wait* family of
    functions, and improved the docs for os.waitid() with more
    explanation of the possible argument constants.
  - Skip test_normalization() of test_unicodedata if it
    fails to download NormalizationTest.txt file from
    pythontest.net. Patch by Victor Stinner.
  - Correct test_marsh on (32 bit) x86: test_deterministic sets
    was failing.
  - Optional big memory tests in test_sqlite3 now catch the
    correct sqlite.DataError exception type in case of too large
    strings and/or blobs passed.
  - Fix a bug in the typing tests where a test relying
    on CPython-specific implementation details was not
    decorated with @cpython_only and was not skipped on other
    implementations.
  - Add tests for star-unpacking with PEP 646, and some other
    miscellaneous PEP 646 tests.
  - Added explicit coverage of Py_Initialize (and hence
    Py_InitializeEx) back to the embedding tests (all other
    embedding tests migrated to Py_InitializeFromConfig in Python
    3.11)
  - Some C API tests were moved into the new Lib/test/test_capi/
    directory.
  - Fix -Wimplicit-int, -Wstrict-prototypes, and
  - Wimplicit-function-declaration compiler warnings in
    configure checks.
  - Fix a compilation issue with GCC 12 on macOS.
  - Fix -Wimplicit-int compiler warning in configure check for
    PTHREAD_SCOPE_SYSTEM.
  - Fix a possible fd leak in Programs/_freeze_module.c
    introduced in Python 3.11.
  - Fix build with PYTHON_FOR_REGEN=python3.8.
  - Specify the full path to the source location for make
    docclean (needed for cross-builds).
  - Don’t use vendored libmpdec headers if --with-system-libmpdec
    is passed to configure. Don’t use vendored libexpat headers
    if --with-system-expat is passed to !configure.
  - Fix the build process of clang compiler for _bootstrap_python
    if LTO optimization is applied. Patch by Matthias Görgens and
    Dong-hee Na.
  - wasm32-emscripten builds for browsers now include
    concurrent.futures for asyncio and unittest.mock.
  - wasm32-emscripten platform no longer builds resource module,
    getresuid(), getresgid(), and their setters. The APIs are
    stubs and not functional.
  - Updated pegen regeneration script on Windows to find and
    use Python 3.9 or higher. Prior to this, pegen regeneration
    already required 3.9 or higher, but the script may have used
    lower versions of Python.
  - Fix a bug in the previous bugfix that caused IDLE to
    not start when run with 3.10.8, 3.12.0a1, and at least
    Microsoft Python 3.10.2288.0 installed without the Lib/test
    package. 3.11.0 was never affected.
  - The wasm_build.py script now pre-builds Emscripten ports,
    checks for broken EMSDK versions, and warns about pkg-config
    env vars.
  - The new tool Tools/wasm/wasm_builder.py automates configure,
    compile, and test steps for building CPython on WebAssembly
    platforms.
  - Fix handling of module docstrings in Tools/i18n/pygettext.py.
  - PyBUF_* constants were marked as part of Limited API
    of Python 3.11+. These were available in 3.11.0 with
    Py_LIMITED_API defined for 3.11, and are necessary to use the
    buffer API.
  - Fix use-after-free in Py_SetPythonHome(NULL),
    Py_SetProgramName(NULL) and _Py_SetProgramFullPath(NULL)
    function calls. Issue reported by Benedikt Reinartz. Patch by
    Victor Stinner.
  - Py_InitializeEx now correctly calls PyConfig_Clear after
    initializing the interpreter (the omission didn’t cause a
    memory leak only because none of the dynamically allocated
    config fields are populated by the wrapper function)
- Removed upstreamed patches:
  - 98437-sphinx.locale._-as-gettext-in-pyspecific.patch
  - CVE-2022-45061-DoS-by-IDNA-decode.patch
* Wed Nov  9 2022 mcepl@suse.com
- Add CVE-2022-45061-DoS-by-IDNA-decode.patch to avoid
  CVE-2022-45061 (bsc#1205244) allowing DoS by IDNA decoding
  extremely long domain names.
* Tue Oct 25 2022 mcepl@suse.com
- Update to 3.11.0 (overall changes from 3.10.*):
  - General changes
  - PEP 657 -- Include Fine-Grained Error Locations in
    Tracebacks
  - PEP 654 -- Exception Groups and except*
  - PEP 680 -- tomllib: Support for Parsing TOML in the
    Standard Library
  - gh-90908 -- Introduce task groups to asyncio
  - gh-34627 -- Atomic grouping ((?>...)) and possessive
    quantifiers (*+, ++, ?+, {m,n}+) are now supported in
    regular expressions.
  - The Faster CPython Project is already yielding some
    exciting results. Python 3.11 is up to 10-60%% faster than
    Python 3.10. On average, we measured a 1.22x speedup on the
    standard benchmark suite. See Faster CPython for details.
  - Typing and typing language changes
  - PEP 673 -- Self Type
  - PEP 646 -- Variadic Generics
  - PEP 675 -- Arbitrary Literal String Type
  - PEP 655 -- Marking individual TypedDict items as required
    or potentially-missing
  - PEP 681 -- Data Class Transforms
- (just changes from 3.11.0rc2):
  - Fix multiplying a list by an integer (list *= int): detect
    the integer overflow when the new allocated length is close
    to the maximum size. Issue reported by Jordan Limor. Patch by
    Victor Stinner.
  - On Linux the multiprocessing module returns to using
    filesystem backed unix domain sockets for communication
    with the forkserver process instead of the Linux abstract
    socket namespace. Only code that chooses to use the
    “forkserver” start method is affected. Abstract sockets have
    no permissions and could allow any user on the system in the
    same network namespace (often the whole system) to inject
    code into the multiprocessing forkserver process. This was
    a potential privilege escalation. Filesystem based socket
    permissions restrict this to the forkserver process user as
    was the default in Python 3.8 and earlier. This prevents
    Linux CVE-2022-42919.
  - Fix an issue where several frame objects could be backed by
    the same interpreter frame, possibly leading to corrupted
    memory and hard crashes of the interpreter.
  - Fix possible data corruption or crashes when accessing the
    f_back member of newly-created generator or coroutine frames.
  - Fix a crash occurring when PyEval_GetFrame() is called while
    the topmost Python frame is in a partially-initialized state.
  - Fix command line parsing: reject -X int_max_str_digits option
    with no value (invalid) when the PYTHONINTMAXSTRDIGITS
    environment variable is set to a valid limit. Patch by Victor
    Stinner.
  - Fix undefined behaviour in _testcapimodule.c.
  - When ValueError is raised if an integer is larger than the
    limit, mention the sys.set_int_max_str_digits() function in
    the error message. Patch by Victor Stinner.
  - Correctly raise SyntaxError on exception groups (PEP 654) on
    python versions prior to 3.11
  - Document some places where an assignment expression needs
    parentheses.
  - Update the bundled copies of pip and setuptools to versions
    22.3 and 65.5.0 respectively.
  - fix Flag to use boundary CONFORM
  - This restores previous Flag behavior of allowing flags with
    non-sequential values to be combined; e.g.
  - class Skip(Flag): TWO = 2 EIGHT = 8
  - Skip.TWO | Skip.EIGHT -> <Skip.TWO|EIGHT: 10>
  - Fix ! in c domain ref target syntax via a conf.py patch, so
    it works as intended to disable ref target resolution.
  - Update tutorial introduction output to use 3.10+ SyntaxError
    invalid range.
* Fri Oct 21 2022 mcepl@suse.com
- Add 98437-sphinx.locale._-as-gettext-in-pyspecific.patch to
  allow building of documentation with the latest Sphinx 5.3.0
  (gh#python/cpython#98366).
* Thu Sep 15 2022 mcepl@suse.com
- Update to 3.11.0rc2:
  - Converting between int and str in bases other than 2
    (binary), 4, 8 (octal), 16 (hexadecimal), or 32 such as base
    10 (decimal) now raises a ValueError if the number of digits
    in string form is above a limit to avoid potential denial of
    service attacks due to the algorithmic complexity. This is
    a mitigation for CVE-2020-10735.
    This new limit can be configured or disabled by environment
    variable, command line flag, or sys APIs. See the integer
    string conversion length limitation documentation. The
    default limit is 4300 digits in string form.
  - Fix case of undefined behavior in ceval.c
  - Do not expose KeyWrapper in _functools.
  - Ensure that tracing, sys.setrace(), is turned on
    immediately. In pre-release versions of 3.11, some tracing
    events might have been lost when turning on tracing in a
    __del__ method or interrupt.
  - Fix use after free in trace refs build mode. Patch by Kumar
    Aditya.
  - When loading a file with invalid UTF-8 inside a multi-line
    string, a correct SyntaxError is emitted.
  - Make sure that incomplete frames do not show up in
    tracemalloc traces.
  - Remove two cases of undefined behavior, by adding NULL
    checks.
  - Fix possible NULL pointer dereference in
    _PyThread_CurrentFrames. Patch by Kumar Aditya.
  - Fix AttributeError missing name and obj attributes in
    object.__getattribute__(). Patch by Philip Georgi.
  - Loading a file with invalid UTF-8 will now report the broken
    character at the correct location.
  - Fixed a bug that caused _PyCode_GetExtra to return garbage
    for negative indexes. Patch by Pablo Galindo
  - Fix a deadlock in PyGILState_Ensure() when allocating new
    thread state. Patch by Kumar Aditya.
  - PyType_Ready() now initializes ht_cached_keys and performs
    additional checks to ensure that type objects are properly
    configured. This avoids crashes in 3rd party packages that
    don’t use regular API to create new types.
  - Skip over incomplete frames in PyThreadState_GetFrame().
  - Fix format string in _PyPegen_raise_error_known_location that
    can lead to memory corruption on some 64bit systems. The
    function was building a tuple with i (int) instead of n
    (Py_ssize_t) for Py_ssize_t arguments.
  - Fix misleading contents of error message when converting an
    all-whitespace string to float.
  - ast.parse() will no longer parse function definitions with
    positional-only params when passed feature_version less than
    (3, 8). Patch by Shantanu Jain.
  - Fix incorrect error message in the io module.
  - Fix the faulthandler implementation of
    faulthandler.register(signal, chain=True) if the sigaction()
    function is not available: don’t call the previous signal
    handler if it’s NULL. Patch by Victor Stinner.
  - Correct conversion of numbers.Rational’s to float.
  - Fix TypeVarTuple.__typing_prepare_subst__. TypeError was not
    raised when using more than one TypeVarTuple, like [*T, *V]
    in type alias substitutions.
  - Fix asyncio.streams.StreamReaderProtocol to keep a strong
    reference to the created task, so that it’s not garbage
    collected
  - Fix a performance regression in logging
    TimedRotatingFileHandler. Only check for special files when
    the rollover time has passed.
  - Fix unused localName parameter in the Attr class in
    xml.dom.minidom.
  - Fix incorrect condition that causes sys.thread_info.name to
    be wrong on pthread platforms.
  - Remove an incompatible change from bpo-28080 that caused a
    regression that ignored the utf8 in ZipInfo.flag_bits. Patch
    by Pablo Galindo.
  - Fix asyncio.Runner to call asyncio.set_event_loop() only
    once to avoid calling attach_loop() multiple times on child
    watchers. Patch by Kumar Aditya.
  - Fix unittest.IsolatedAsyncioTestCase to set event loop before
    calling setup functions. Patch by Kumar Aditya.
  - When a task catches asyncio.CancelledError and raises some
    other error, the other error should generally not silently be
    suppressed.
  - Fail gracefully if EPERM or ENOSYS is raised when loading
    crypt methods. This may happen when trying to load MD5 on a
    Linux kernel with FIPS enabled.
  - Allow asyncio.StreamWriter.drain() to be awaited concurrently
    by multiple tasks. Patch by Kumar Aditya.
  - Fix ast.unparse() when ImportFrom.level is None
  - Improve discoverability of the higher level
    concurrent.futures module by providing clearer links from the
    lower level threading and multiprocessing modules.
  - What’s New 3.11 now has instructions for how to provide
    compiler and linker flags for Tcl/Tk and OpenSSL on RHEL 7
    and CentOS 7.
  - Mitigate the inherent race condition from using
    find_unused_port() in testSockName() by trying to find an
    unused port a few times before failing. Patch by Ross Burton.
  - Build and test with OpenSSL 1.1.1q
- Use support-expat-CVE-2022-25236-patched.patch from the current
  version of gh#python/cpython#93900 instead of the old
  support-expat-245.patch.
- Reapply fix_configure_rst.patch.
* Mon Sep  5 2022 schwab@suse.de
- Increase testsuite timeout for test_freeze_simple_script
* Sat Aug 20 2022 mcepl@suse.com
- fix import_failed.map to refer to the python 3.11 package versions
* Sat Aug 20 2022 mcepl@suse.com
- Update to 3.11.0rc1:
  - Core and Builtins
  - Update code object hashing and equality to consider all
    debugging and exception handling tables. This fixes an
    issue where certain non-identical code objects could be
    “deduplicated” during compilation.
  - _PyPegen_Parser_New now properly detects token memory
    allocation errors. Patch by Honglin Zhu.
  - Run Python code in tracer/profiler function at full
    speed. Fixes slowdown in earlier versions of 3.11.
  - Emit a warning in debug mode if an object does not call
    PyObject_GC_UnTrack() before deallocation. Patch by Pablo
    Galindo.
  - Prevented crashes in the AST constructor when
    compiling some absurdly long expressions like
    "+0"*1000000. RecursionError is now raised instead. Patch
    by Pablo Galindo
  - ast.AST node positions are now validated when provided to
    compile() and other related functions. If invalid positions
    are detected, a ValueError will be raised.
  - Fix error detection in some builtin functions when keyword
    argument name is an instance of a str subclass with
    overloaded __eq__ and __hash__. Previously it could cause
    SystemError or other undesired behavior.
  - Library
  - Update bundled pip to 22.2.2.
  - Fix asyncio.TaskGroup to propagate exception when
    asyncio.CancelledError was replaced with another exception
    by a context manger. Patch by Kumar Aditya and Guido van
    Rossum.
  - Update bundled pip to 22.2.1.
  - Fix GC crash when deallocating _lsprof.Profiler by
    untracking it before calling any callbacks. Patch by Kumar
    Aditya.
  - Fix asyncio.run() for asyncio.Task implementations without
    uncancel() method. Patch by Kumar Aditya.
  - Fix check for existence of os.EFD_CLOEXEC, os.EFD_NONBLOCK
    and os.EFD_SEMAPHORE flags on older kernel versions where
    these flags are not present. Patch by Kumar Aditya.
  - Fix concurrent.futures.Executor.map() to cancel the
    currently waiting on future on an error - e.g. TimeoutError
    or KeyboardInterrupt.
  - Ensure that timeouts scheduled with asyncio.Timeout that
    have already expired are delivered promptly.
  - Suppress writing an XML declaration in open files
    in ElementTree.write() with encoding='unicode' and
    xml_declaration=None.
  - Fix findtext in the xml module to only give an empty string
    when the text attribute is set to None.
  - Documentation
  - Fix stylesheet not working in Windows CHM htmlhelp docs
    and add warning that they are deprecated. Contributed by
    C.A.M. Gerlach.
  - Update library documentation with availability information
    on WebAssembly platforms wasm32-emscripten and wasm32-wasi.
  - Use consistent syntax for platform availability. The
    directive now supports a content body and emits a warning
    when it encounters an unknown platform.
  - Document a limitation in ThreadPoolExecutor where its exit
    handler is executed before any handlers in atexit.
  - Tests
  - Lib/test/test_asyncio/test_ssl.py exposed a bug in the
    macOS kernel where intense concurrent load on non-blocking
    sockets occasionally causes errno.ENOBUFS (“No buffer space
    available”) to be emitted. FB11063974 filed with Apple, in
    the mean time as a workaround buffer size used in tests on
    macOS is decreased to avoid intermittent failures. Patch by
    Fantix King.
  - Fix problem with test_ssl test_get_ciphers on systems that
    require perfect forward secrecy (PFS) ciphers.
  - Add a regression test for re exponentional slowdown when
    using rjsmin.
  - Build
  - Fix a regression in configure script that caused some
    header checks to ignore custom CPPFLAGS. The regression was
    introduced in gh-94802.
  - wasm32-wasi builds no longer depend on WASIX’s pthread
    stubs. Python now has its own stubbed pthread API.
  - Python now detects missing dup function in WASI and works
    around some missing errno, select, and socket constants.
  - Python now skips missing socket functions and methods on
    WASI. WASI can only create sockets from existing fd /
    accept and has no netdb.
  - Platforms wasm32-unknown-emscripten and wasm32-unknown-wasi
    have been promoted to PEP 11 tier 3 platform support.
  - IDLE
  - Document handling of extensions in Save As dialogs.
  - Include prompts when saving Shell (interactive input and
    output).
  - Fix the Shell context menu copy-with-prompts bug of copying
    an extra line when one selects whole lines.
  - In the Edit menu, move Select All and add a new separator.
  - Enable using IDLE’s module browser with .pyw files.
  - Add .pyi as a recognized extension for IDLE on macOS. This
    allows opening stub files by double clicking on them in the
    Finder.
  - C API
  - Restore the 3.10 behavior for multiple inheritance of C
    extension classes that store their dictionary at the end of
    the struct.
  - Added PyCode_GetVarnames(), PyCode_GetCellvars() and
    PyCode_GetFreevars() for accessing co_varnames, co_cellvars
    and co_freevars respectively via the C API.
* Tue Jul 26 2022 mcepl@suse.com
- Update to 3.11.0b5:
  - Core and Builtins
  - gh-93351: ast.AST node positions are now validated when
    provided to compile() and other related functions. If
    invalid positions are detected, a ValueError will be
    raised.
  - gh-94438: Fix an issue that caused extended opcode
    arguments and some conditional pops to be ignored when
    calculating valid jump targets for assignments to the
    f_lineno attribute of frame objects. In some cases, this
    could cause inconsistent internal state, resulting in a
    hard crash of the interpreter.
  - gh-95060: Undocumented PyCode_Addr2Location function now
    properly returns when addrq argument is less than zero.
  - gh-95113: Replace all EXTENDED_ARG_QUICK instructions
    with basic EXTENDED_ARG instructions in unquickened
    code. Consumers of non-adaptive bytecode should be able to
    handle extended arguments the same way they were handled in
    CPython 3.10 and older.
  - gh-91409: Fix incorrect source location info caused by
    certain optimizations in the bytecode compiler.
  - gh-94036: Fix incorrect source location info for some
    multi-line attribute accesses and method calls.
  - gh-94739: Allow jumping within, out of, and across
    exception handlers in the debugger.
  - gh-94949: ast.parse() will no longer parse parenthesized
    context managers when passed feature_version less than (3,
    9). Patch by Shantanu Jain.
  - gh-94947: ast.parse() will no longer parse assignment
    expressions when passed feature_version less than (3,
    8). Patch by Shantanu Jain.
  - gh-91256: Ensures the program name is known for help text
    during interpreter startup.
  - gh-94869: Fix the column offsets for some expressions in
    multi-line f-strings ast nodes. Patch by Pablo Galindo.
  - gh-94822: Fix an issue where lookups of metaclass
    descriptors may be ignored when an identically-named
    attribute also exists on the class itself.
  - gh-91153: Fix an issue where a bytearray item assignment
    could crash if it’s resized by the new value’s __index__()
    method.
  - gh-90699: Fix reference counting bug in
    bool.__repr__(). Patch by Kumar Aditya.
  - Library
  - gh-95087: Fix IndexError in parsing invalid date in the
    email module.
  - gh-95199: Upgrade bundled setuptools to 63.2.0.
  - gh-95194: Upgrade bundled pip to 22.2.
  - gh-95132: Fix a sqlite3 regression where *args and **kwds
    were incorrectly relayed from connect() to the Connection
    factory. The regression was introduced in 3.11a1 with PR
    24421 (gh-85128). Patch by Erlend E. Aasland.`
  - gh-93157: Fix fileinput module didn’t support errors option
    when inplace is true.
  - gh-95105: wsgiref.types.InputStream.__iter__() should
    return Iterator[bytes], not Iterable[bytes]. Patch by
    Shantanu Jain.
  - gh-94857: Fix refleak in
    _io.TextIOWrapper.reconfigure. Patch by Kumar Aditya.
  - gh-94821: Fix binding of unix socket to empty address
    on Linux to use an available address from the abstract
    namespace, instead of “0”.
  - gh-89988: Fix memory leak in pickle.Pickler when looking up
    dispatch_table. Patch by Kumar Aditya.
  - bpo-47025: Drop support for bytes on sys.path.
  - Tests
  - gh-95212: Make multiprocessing test case
    test_shared_memory_recreate parallel-safe.
  - Build
  - gh-94847: Fixed _decimal module build issue on GCC when
    compiling with LTO and pydebug. Debug builds no longer
    force inlining of functions.
  - gh-94841: Fix the possible performance regression of
    PyObject_Free() compiled with MSVC version 1932.
  - gh-94801: configure now uses custom flags like ZLIB_CFLAGS
    and ZLIB_LIBS when searching for headers and libraries.
  - gh-94773: deepfreeze.py now supports code object with
    frozensets that contain incompatible, unsortable types.
  - C API
  - gh-94930: Fix SystemError raised when
    PyArg_ParseTupleAndKeywords() is used with # in (...) but
    without PY_SSIZE_T_CLEAN defined.
  - gh-94864: Fix PyArg_Parse* with deprecated format units “u”
    and “Z”. It returned 1 (success) when warnings are turned
    into exceptions.
  - gh-94731: Python again uses C-style casts for
    most casting operations when compiled with
    C++. This may trigger compiler warnings, if they
    are enabled with e.g. -Wold-style-cast `` or
    ``-Wzero-as-null-pointer-constant options for g++.
* Thu Jul 21 2022 mcepl@suse.com
- Switch from %%primary_interpreter to prjconf-defined
  %%primary_python (gh#openSUSE/python-rpm-macros#127).
* Thu Jul 14 2022 mcepl@suse.com
- Update to 3.11.0b4:
- Fixes many bugs and adds following more significant changes
- Security
  - gh-68966: The deprecated mailcap module now refuses to inject
    Coreunsafe text (filenames, MIME types, parameters) into
    shell Corecommands. Instead of using such text, it will
    warn and act Coreas if a match was not found (or for test
    commands, as if the Coretest failed). and Builtins
  - gh-93516: Lazily create a table mapping bytecode offsets to
    line numbers to speed up calculation of line numbers when
    tracing.
  - gh-93461: importlib.invalidate_caches() now drops entries
    from sys.path_importer_cache with a relative path as
    name. This solves a caching issue when a process changes its
    current working directory.
  - FileFinder no longer inserts a dot in the path, e.g.
    /egg/./spam is now /egg/spam.
  Library
  - gh-93896: Fix asyncio.run() and
    unittest.IsolatedAsyncioTestCase to always the set event loop
    as it was done in Python 3.10 and earlier. Patch by Kumar
    Aditya.
  - gh-94101: Manual instantiation of ssl.SSLSession objects is
    no longer allowed as it lead to misconfigured instances that
    crashed the interpreter when attributes where accessed on
    them.
  - gh-83658: Make multiprocessing.Pool raise an exception if
    maxtasksperchild is not None or a positive int.
  - gh-61162: Clarify sqlite3 behavior when Using the connection
    as a context manager.
  Tools/Demos
  - gh-94538: Fix Argument Clinic output to custom file
    destinations. Patch by Erlend E. Aasland.
  C API
  - gh-93937: The following frame functions and type are now
    directly available with #include <Python.h>, it’s no longer
    needed to add #include <frameobject.h>:
    PyFrame_Check()
    PyFrame_GetBack()
    PyFrame_GetBuiltins()
    PyFrame_GetGenerator()
    PyFrame_GetGlobals()
    PyFrame_GetLasti()
    PyFrame_GetLocals()
    PyFrame_Type
* Tue May 31 2022 mcepl@suse.com
- Update to 3.11.0b2:
  - many small updates
- Add patch support-expat-245.patch:
  * Support Expat >= 2.4.4 (jsc#SLE-21253)
* Tue May 10 2022 mcepl@suse.com
- Refresh bluez-devel-vendor.tar.xz
- Fix building with system-expat (gh#python/cpython#92875). Nope,
  it didn't work, worked around it.
* Mon May  9 2022 mcepl@suse.com
- Update to pre-release version 3.11.0b1:
  - PEP 657 – Include Fine-Grained Error Locations in Tracebacks
  - PEP 654 – Exception Groups and except*
  - PEP 673 – Self Type
  - PEP 646 – Variadic Generics
  - PEP 680– tomllib: Support for Parsing TOML in the Standard Library
  - PEP 675– Arbitrary Literal String Type
  - PEP 655– Marking individual TypedDict items as required or potentially-missing
  - bpo-46752– Introduce task groups to asyncio
  - The Faster Cpython Project is already yielding some exciting
    results. Python 3.11 is up to 10-60%% faster than Python
    3.10. On average, we measured a 1.22x speedup on the standard
    benchmark suite. See
    https://docs.python.org/3.11/whatsnew/3.11.html#faster-cpython
    for details.
* Thu May  5 2022 mcepl@suse.com
- Switch primary_interpreter from python38 to python310
* Sat Mar 26 2022 mcepl@suse.com
- Update to 3.10.4:
  - bpo-46968: Check for the existence of the “sys/auxv.h” header
    in faulthandler to avoid compilation problems in systems
    where this header doesn’t exist. Patch by Pablo Galindo
  - bpo-23691: Protect the re.finditer() iterator from
    re-entering.
  - bpo-42369: Fix thread safety of zipfile._SharedFile.tell() to
    avoid a “zipfile.BadZipFile: Bad CRC-32 for file” exception
    when reading a ZipFile from multiple threads.
  - bpo-38256: Fix binascii.crc32() when it is compiled to use
    zlib’c crc32 to work properly on inputs 4+GiB in length
    instead of returning the wrong result. The workaround prior
    to this was to always feed the function data in increments
    smaller than 4GiB or to just call the zlib module function.
  - bpo-39394: A warning about inline flags not at the start of
    the regular expression now contains the position of the flag.
  - bpo-47061: Deprecate the various modules listed by PEP 594:
  - aifc, asynchat, asyncore, audioop, cgi, cgitb, chunk, crypt,
    imghdr, msilib, nntplib, nis, ossaudiodev, pipes, smtpd,
    sndhdr, spwd, sunau, telnetlib, uu, xdrlib
  - bpo-2604: Fix bug where doctests using globals would fail
    when run multiple times.
  - bpo-45997: Fix asyncio.Semaphore re-aquiring FIFO order.
  - bpo-47022: The asynchat, asyncore and smtpd modules have been
    deprecated since at least Python 3.6. Their documentation and
    deprecation warnings and have now been updated to note they
    will removed in Python 3.12 (PEP 594).
  - bpo-46421: Fix a unittest issue where if the command was
    invoked as python -m unittest and the filename(s) began with
    a dot (.), a ValueError is returned.
  - bpo-40296: Fix supporting generic aliases in pydoc.
- Update to 3.10.3:
  - bpo-46940: Avoid overriding AttributeError metadata
    information for nested attribute access calls. Patch by Pablo
    Galindo.
  - bpo-46852: Rename the private undocumented
    float.__set_format__() method to float.__setformat__() to fix
    a typo introduced in Python 3.7. The method is only used by
    test_float. Patch by Victor Stinner.
  - bpo-46794: Bump up the libexpat version into 2.4.6
  - bpo-46820: Fix parsing a numeric literal immediately (without
    spaces) followed by “not in” keywords, like in 1not in x. Now
    the parser only emits a warning, not a syntax error.
  - bpo-46762: Fix an assert failure in debug builds when a ‘<’,
    ‘>’, or ‘=’ is the last character in an f-string that’s
    missing a closing right brace.
  - bpo-46724: Make sure that all backwards jumps use the
    JUMP_ABSOLUTE instruction, rather than JUMP_FORWARD with an
    argument of (2**32)+offset.
  - bpo-46732: Correct the docstring for the __bool__() method.
    Patch by Jelle Zijlstra.
  - bpo-46707: Avoid potential exponential backtracking when
    producing some syntax errors involving lots of brackets.
    Patch by Pablo Galindo.
  - bpo-40479: Add a missing call to va_end() in
    Modules/_hashopenssl.c.
  - bpo-46615: When iterating over sets internally in
    setobject.c, acquire strong references to the resulting items
    from the set. This prevents crashes in corner-cases of
    various set operations where the set gets mutated.
  - bpo-45773: Remove two invalid “peephole” optimizations from
    the bytecode compiler.
  - bpo-43721: Fix docstrings of getter, setter, and deleter to
    clarify that they create a new copy of the property.
  - bpo-46503: Fix an assert when parsing some invalid N escape
    sequences in f-strings.
  - bpo-46417: Fix a race condition on setting a type __bases__
    attribute: the internal function add_subclass() now gets the
    PyTypeObject.tp_subclasses member after calling
    PyWeakref_NewRef() which can trigger a garbage collection
    which can indirectly modify PyTypeObject.tp_subclasses. Patch
    by Victor Stinner.
  - bpo-46383: Fix invalid signature of _zoneinfo’s module_free
    function to resolve a crash on wasm32-emscripten platform.
  - bpo-46070: Py_EndInterpreter() now explicitly untracks all
    objects currently tracked by the GC. Previously, if an object
    was used later by another interpreter, calling
    PyObject_GC_UnTrack() on the object crashed if the previous
    or the next object of the PyGC_Head structure became
    a dangling pointer. Patch by Victor Stinner.
  - bpo-46339: Fix a crash in the parser when retrieving the
    error text for multi-line f-strings expressions that do not
    start in the first line of the string. Patch by Pablo Galindo
  - bpo-46240: Correct the error message for unclosed parentheses
    when the tokenizer doesn’t reach the end of the source when
    the error is reported. Patch by Pablo Galindo
  - bpo-46091: Correctly calculate indentation levels for lines
    with whitespace character that are ended by line continuation
    characters. Patch by Pablo Galindo
  - bpo-43253: Fix a crash when closing transports where the
    underlying socket handle is already invalid on the Proactor
    event loop.
  - bpo-47004: Apply bugfixes from importlib_metadata 4.11.3,
    including bugfix for EntryPoint.extras, which was returning
    match objects and not the extras strings.
  - bpo-46985: Upgrade pip wheel bundled with ensurepip (pip
    22.0.4)
  - bpo-46968: faulthandler: On Linux 5.14 and newer, dynamically
    determine size of signal handler stack size CPython allocates
    using getauxval(AT_MINSIGSTKSZ). This changes allows for
    Python extension’s request to Linux kernel to use AMX_TILE
    instruction set on Sapphire Rapids Xeon processor to succeed,
    unblocking use of the ISA in frameworks.
  - bpo-46955: Expose asyncio.base_events.Server as
    asyncio.Server. Patch by Stefan Zabka.
  - bpo-23325: The signal module no longer assumes that SIG_IGN
    and SIG_DFL are small int singletons.
  - bpo-46932: Update bundled libexpat to 2.4.7
  - bpo-25707: Fixed a file leak in
    xml.etree.ElementTree.iterparse() when the iterator is not
    exhausted. Patch by Jacob Walls.
  - bpo-44886: Inherit asyncio proactor datagram transport from
    asyncio.DatagramTransport.
  - bpo-46827: Support UDP sockets in asyncio.loop.sock_connect()
    for selector-based event loops. Patch by Thomas Grainger.
  - bpo-46811: Make test suite support Expat >=2.4.5
  - bpo-46252: Raise TypeError if ssl.SSLSocket is passed to
    transport-based APIs.
  - bpo-46784: Fix libexpat symbols collisions with user
    dynamically loaded or statically linked libexpat in embedded
    Python.
  - bpo-39327: shutil.rmtree() can now work with VirtualBox
    shared folders when running from the guest operating-system.
  - bpo-46756: Fix a bug in
    urllib.request.HTTPPasswordMgr.find_user_password() and
    urllib.request.HTTPPasswordMgrWithPriorAuth.is_authenticated()
    which allowed to bypass authorization. For example, access to
    URI example.org/foobar was allowed if the user was authorized
    for URI example.org/foo.
  - bpo-46643: In typing.get_type_hints(), support evaluating
    stringified ParamSpecArgs and ParamSpecKwargs annotations.
    Patch by Gregory Beauregard.
  - bpo-45863: When the tarfile module creates a pax format
    archive, it will put an integer representation of timestamps
    in the ustar header (if possible) for the benefit of older
    unarchivers, in addition to the existing full-precision
    timestamps in the pax extended header.
  - bpo-46676: Make typing.ParamSpec args and kwargs equal to
    themselves. Patch by Gregory Beauregard.
  - bpo-46672: Fix NameError in asyncio.gather() when initial
    type check fails.
  - bpo-46655: In typing.get_type_hints(), support evaluating
    bare stringified TypeAlias annotations. Patch by Gregory
    Beauregard.
  - bpo-45948: Fixed a discrepancy in the C implementation of the
    xml.etree.ElementTree module. Now, instantiating an
    xml.etree.ElementTree.XMLParser with a target=None keyword
    provides a default xml.etree.ElementTree.TreeBuilder target
    as the Python implementation does.
  - bpo-46521: Fix a bug in the codeop module that was
    incorrectly identifying invalid code involving string quotes
    as valid code.
  - bpo-46581: Brings ParamSpec propagation for GenericAlias in
    line with Concatenate (and others).
  - bpo-46591: Make the IDLE doc URL on the About IDLE dialog
    clickable.
  - bpo-46400: expat: Update libexpat from 2.4.1 to 2.4.4
  - bpo-46487: Add the get_write_buffer_limits method to
    asyncio.transports.WriteTransport and to the SSL transport.
  - bpo-45173: Note the configparser deprecations will be removed
    in Python 3.12.
  - bpo-46539: In typing.get_type_hints(), support evaluating
    stringified ClassVar and Final annotations inside Annotated.
    Patch by Gregory Beauregard.
  - bpo-46491: Allow typing.Annotated to wrap typing.Final and
    typing.ClassVar. Patch by Gregory Beauregard.
  - bpo-46436: Fix command-line option -d/--directory in module
    http.server which is ignored when combined with command-line
    option --cgi. Patch by Géry Ogam.
  - bpo-41403: Make mock.patch() raise a TypeError with
    a relevant error message on invalid arg. Previously it
    allowed a cryptic AttributeError to escape.
  - bpo-46474: In importlib.metadata.EntryPoint.pattern, avoid
    potential REDoS by limiting ambiguity in consecutive
    whitespace.
  - bpo-46469: asyncio generic classes now return
    types.GenericAlias in __class_getitem__ instead of the same
    class.
  - bpo-46434: pdb now gracefully handles help when __doc__ is
    missing, for example when run with pregenerated optimized
    .pyc files.
  - bpo-46333: The __eq__() and __hash__() methods of
    typing.ForwardRef now honor the module parameter of
    typing.ForwardRef. Forward references from different modules
    are now differentiated.
  - bpo-46246: Add missing __slots__ to
    importlib.metadata.DeprecatedList. Patch by Arie Bovenberg.
  - bpo-46266: Improve day constants in calendar.
  - Now all constants (MONDAY … SUNDAY) are documented, tested,
    and added to __all__.
  - bpo-46232: The ssl module now handles certificates with bit
    strings in DN correctly.
  - bpo-43118: Fix a bug in inspect.signature() that was causing
    it to fail on some subclasses of classes with
    a __text_signature__ referencing module globals. Patch by
    Weipeng Hong.
  - bpo-26552: Fixed case where failing asyncio.ensure_future()
    did not close the coroutine. Patch by Kumar Aditya.
  - bpo-21987: Fix an issue with tarfile.TarFile.getmember()
    getting a directory name with a trailing slash.
  - bpo-20392: Fix inconsistency with uppercase file extensions
    in MimeTypes.guess_type(). Patch by Kumar Aditya.
  - bpo-46080: Fix exception in argparse help text generation if
    a argparse.BooleanOptionalAction argument’s default is
    argparse.SUPPRESS and it has help specified. Patch by Felix
    Fontein.
  - bpo-44439: Fix .write() method of a member file in ZipFile,
    when the input data is an object that supports the buffer
    protocol, the file length may be wrong.
  - bpo-45703: When a namespace package is imported before
    another module from the same namespace is created/installed
    in a different sys.path location while the program is
    running, calling the importlib.invalidate_caches() function
    will now also guarantee the new module is noticed.
  - bpo-24959: Fix bug where unittest sometimes drops frames from
    tracebacks of exceptions raised in tests.
  - bpo-44791: Fix substitution of ParamSpec in Concatenate with
    different parameter expressions. Substitution with a list of
    types returns now a tuple of types. Substitution with
    Concatenate returns now a Concatenate with concatenated lists
    of arguments.
  - bpo-14156: argparse.FileType now supports an argument of ‘-’
    in binary mode, returning the .buffer attribute of
    sys.stdin/sys.stdout as appropriate. Modes including ‘x’ and
    ‘a’ are treated equivalently to ‘w’ when argument is ‘-’.
    Patch contributed by Josh Rosenberg
  - bpo-46463: Fixes escape4chm.py script used when building the
    CHM documentation file
  - bpo-46913: Fix test_faulthandler.test_sigfpe() if Python is
    built with undefined behavior sanitizer (UBSAN): disable
    UBSAN on the faulthandler_sigfpe() function. Patch by Victor
    Stinner.
  - bpo-46708: Prevent default asyncio event loop policy
    modification warning after test_asyncio execution.
  - bpo-46678: The function make_legacy_pyc in
    Lib/test/support/import_helper.py no longer fails when
    PYTHONPYCACHEPREFIX is set to a directory on a different
    device from where tempfiles are stored.
  - bpo-46616: Ensures test_importlib.test_windows cleans up
    registry keys after completion.
  - bpo-44359: test_ftplib now silently ignores socket errors to
    prevent logging unhandled threading exceptions. Patch by
    Victor Stinner.
  - bpo-46542: Fix a Python crash in test_lib2to3 when using
    Python built in debug mode: limit the recursion limit. Patch
    by Victor Stinner.
  - bpo-46576: test_peg_generator now disables compiler
    optimization when testing compilation of its own C extensions
    to significantly speed up the testing on non-debug builds of
    CPython.
  - bpo-46542: Fix test_json tests checking for RecursionError:
    modify these tests to use support.infinite_recursion(). Patch
    by Victor Stinner.
  - bpo-13886: Skip test_builtin PTY tests on non-ASCII
    characters if the readline module is loaded. The readline
    module changes input() behavior, but test_builtin is not
    intented to test the readline module. Patch by Victor
    Stinner.
  - bpo-38472: Fix GCC detection in setup.py when
    cross-compiling. The C compiler is now run with LC_ALL=C.
    Previously, the detection failed with a German locale.
  - bpo-46513: configure no longer uses AC_C_CHAR_UNSIGNED macro
    and pyconfig.h no longer defines reserved symbol
    __CHAR_UNSIGNED__.
  - bpo-45296: Clarify close, quit, and exit in IDLE. In the File
    menu, ‘Close’ and ‘Exit’ are now ‘Close Window’ (the current
    one) and ‘Exit’ is now ‘Exit IDLE’ (by closing all windows).
    In Shell, ‘quit()’ and ‘exit()’ mean ‘close Shell’. If there
    are no other windows, this also exits IDLE.
  - bpo-45447: Apply IDLE syntax highlighting to pyi files. Patch
    by Alex Waygood and Terry Jan Reedy.
  - bpo-46433: The internal function _PyType_GetModuleByDef now
    correctly handles inheritance patterns involving static
    types.
  - bpo-14916: Fixed bug in the tokenizer that prevented
    PyRun_InteractiveOne from parsing from the provided FD.
- Remove upstreamed patches:
  - support-expat-245.patch
* Tue Feb 22 2022 steven.kowalik@suse.com
- Add patch support-expat-245.patch:
  * Support Expat >= 2.4.5
* Tue Feb 15 2022 mcepl@suse.com
- bsc#1195831 Obsolete older "most modern" versions of python
  packages (python39 for python310 and so forth). For next
  versions it is necessary just to edit the macro.
* Tue Jan 25 2022 mcepl@suse.com
- Remove second superfluous BR rpm-build-python
* Tue Jan 25 2022 mcepl@suse.com
- Remove second superfluous BR rpm-build-python
- Add fix_configure_rst.patch, which removes duplicate link
  targets and make documentation with old Sphinx in SLE
- Skip test_capi (bsc#1195140 and bpo#37169)
* Wed Jan 19 2022 mcepl@suse.com
- Update to 3.10.2:
  Bugfix only
  - bpo#46347 memory leak in PyEval_EvalCodeEx (especially
    visible with Cython code)
  - and many others
* Wed Dec  8 2021 mcepl@suse.com
- Upgrade to 3.10.1 (jsc#SLE-18038):
  - PEP 623 – Deprecate and prepare for the removal of the wstr
    member in PyUnicodeObject.
  - PEP 604 – Allow writing union types as X | Y
  - PEP 612 – Parameter Specification Variables
  - PEP 626 – Precise line numbers for debugging and other tools.
  - PEP 618 – Add Optional Length-Checking To zip.
  - bpo-12782: Parenthesized context managers are now officially
    allowed.
  - PEP 632 – Deprecate distutils module.
  - PEP 613 – Explicit Type Aliases
  - PEP 634 – Structural Pattern Matching: Specification
  - PEP 635 – Structural Pattern Matching: Motivation and
    Rationale
  - PEP 636 – Structural Pattern Matching: Tutorial
  - PEP 644 – Require OpenSSL 1.1.1 or newer
  - PEP 624 – Remove Py_UNICODE encoder APIs
  - PEP 597 – Add optional EncodingWarning
- Patches readjusted:
  - bpo-31046_ensurepip_honours_prefix.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
* Sat Dec  4 2021 mcepl@suse.com
- Remove pdb_adjust_breakpoints.patch and instead just adjust location
  of the test breakpoint in Lib/test/test_pdb.py via sed, because we
  have shortened Lib/pdb.py by removing the shebang (bpo#45964).
* Thu Dec  2 2021 mcepl@suse.com
- Add pdb_adjust_breakpoints.patch fixing expectd results in
  test_pdb_breakpoints_preserved_across_interactive_sessions
  (bpo#45964).
* Mon Nov 29 2021 mcepl@suse.com
- Remove shebangs from from python-base libraries in _libdir
  (bsc#1193179).
- Readjust patches:
  - bpo-31046_ensurepip_honours_prefix.patch
  - decimal.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
* Tue Nov 16 2021 mcepl@suse.com
- Move rpm-build-python construct to correct place.
* Wed Oct 13 2021 dimstar@opensuse.org
- BuildRequire rpm-build-python: The provider to inject python(abi)
  has been moved there. rpm-build pulls rpm-build-python
  automatically in when building anything against python3-base, but
  this implies that the initial build of python3-base does not
  trigger the automatic installation.
* Tue Oct  5 2021 mcepl@suse.com
- Final release of 3.10.0:
  Complete list on https://www.python.org/downloads/release/python-3100/,
  but highlights are:
  - PEP 623 – Deprecate and prepare for the removal of the wstr
    member in PyUnicodeObject.
  - PEP 604 – Allow writing union types as X | Y
  - PEP 612 – Parameter Specification Variables
  - PEP 626 – Precise line numbers for debugging and other
    tools.
  - PEP 618 – Add Optional Length-Checking To zip.
  - PEP 632 – Deprecate distutils module.
  - PEP 613 – Explicit Type Aliases
  - PEP 634 – Structural Pattern Matching: Specification
  - PEP 635 – Structural Pattern Matching: Motivation and
    Rationale
  - PEP 636 – Structural Pattern Matching: Tutorial
  - PEP 644 – Require OpenSSL 1.1.1 or newer
  - PEP 624 – Remove Py_UNICODE encoder APIs
  - PEP 597 – Add optional EncodingWarning
  - bpo-12782: Parenthesized context managers are now officially
    allowed.
* Mon Aug 30 2021 mcepl@suse.com
- Switch on option --with-system-libmpdec (bsc#1189356).
* Fri Aug 27 2021 schwab@suse.de
- Reenable profileopt with qemu emulation, test_faulthandler is no longer
  run during profiling
* Thu Aug 12 2021 schwab@suse.de
- test_faulthandler is still problematic under qemu linux-user emulation,
  disable it there
* Wed Aug 11 2021 mcepl@suse.com
- Update to 3.10.0rc1 (the penultimate prerelease), which contains
  plenty of small bugfixes among others:
  - bpo#38605: from __future__ import annotations (PEP 563) used to be
    on this list in previous pre-releases but it has been postponed to
    Python 3.11 due to some compatibility concerns.
  - bpo-44600: Fix incorrect line numbers while tracing some failed
    patterns in match statements. Patch by Charles Burkland.
  - plenty of modifications in types.Union
* Wed Jul 21 2021 mcepl@suse.com
- Update to 3.10.0b4:
  https://docs.python.org/3.10/whatsnew/changelog.html#python-3-10-0-beta-4
- Remove python3-imp-returntype.patch which has been upstreamed.
* Mon Jun  7 2021 mcepl@suse.com
- Update to 3.10.0b2:
  - PEP 623 -- Deprecate and prepare for the removal of the wstr
    member in PyUnicodeObject.
  - PEP 604 -- Allow writing union types as X | Y
  - PEP 612 -- Parameter Specification Variables
  - PEP 626 -- Precise line numbers for debugging and other
    tools.
  - PEP 618 -- Add Optional Length-Checking To zip.
  - bpo-12782: Parenthesized context managers are now officially
    allowed.
  - PEP 632 -- Deprecate distutils module.
  - PEP 613 -- Explicit Type Aliases
  - PEP 634 -- Structural Pattern Matching: Specification
  - PEP 635 -- Structural Pattern Matching: Motivation and
    Rationale
  - PEP 636 -- Structural Pattern Matching: Tutorial
  - PEP 644 -- Require OpenSSL 1.1.1 or newer
  - PEP 624 -- Remove Py_UNICODE encoder APIs
  - PEP 597 -- Add optional EncodingWarning
- Removed patches (assumed upstream):
  - sphinx-update-removed-function.patch
* Sat Jun  5 2021 mcepl@suse.com
- Revert previous skip over test_capi
- Add skip-test_pyobject_freed_is_freed.patch to skip failing
  test on SLE-15.
* Fri Jun  4 2021 dmueller@suse.com
- allow build with Sphinx >= 3.x
* Wed Jun  2 2021 dcermak@suse.com
- Exclude test_capi on Leap (test fails there)
* Fri May 21 2021 mcepl@suse.com
- Stop providing "python" symbol (bsc#1185588), which means
  python2 currently.
* Wed May  5 2021 mcepl@suse.com
- Update to 3.9.5:
  * Security
  - bpo-43434: Creating a sqlite3.Connection object now also
    produces a sqlite3.connect auditing event. Previously this
    event was only produced by sqlite3.connect() calls. Patch
    by Erlend E. Aasland.
  - bpo-43882: The presence of newline or tab characters in
    parts of a URL could allow some forms of attacks.
  - Following the controlling specification for URLs defined by
    WHATWG urllib.parse() now removes ASCII newlines and tabs
    from URLs, preventing such attacks.
  - bpo-43472: Ensures interpreter-level audit hooks receive
    the cpython.PyInterpreterState_New event when called
    through the _xxsubinterpreters module.
  - bpo-36384: ipaddress module no longer accepts any leading
    zeros in IPv4 address strings. Leading zeros are ambiguous
    and interpreted as octal notation by some libraries. For
    example the legacy function socket.inet_aton() treats
    leading zeros as octal notatation. glibc implementation of
    modern inet_pton() does not accept any leading zeros. For
    a while the ipaddress module used to accept ambiguous
    leading zeros.
  - bpo-43075: Fix Regular Expression Denial of Service (ReDoS)
    vulnerability in urllib.request.AbstractBasicAuthHandler.
    The ReDoS-vulnerable regex has quadratic worst-case
    complexity and it allows cause a denial of service when
    identifying crafted invalid RFCs. This ReDoS issue is on
    the client side and needs remote attackers to control the
    HTTP server.
  - bpo-42800: Audit hooks are now fired for frame.f_code,
    traceback.tb_frame, and generator code/frame attribute
    access.
  * Core and Builtins
  - bpo-43105: Importlib now resolves relative paths when
    creating module spec objects from file locations.
  - bpo-42924: Fix bytearray repetition incorrectly copying
    data from the start of the buffer, even if the data is
    offset within the buffer (e.g. after reassigning a slice at
    the start of the bytearray to a shorter byte string).
  * Library
  - bpo-43993: Update bundled pip to 21.1.1.
  - bpo-43937: Fixed the turtle module working with non-default
    root window.
  - bpo-43930: Update bundled pip to 21.1 and setuptools to
    56.0.0
  - bpo-43920: OpenSSL 3.0.0: load_verify_locations() now
    returns a consistent error message when cadata contains no
    valid certificate.
  - bpo-43607: urllib can now convert Windows paths with \\?\
    prefixes into URL paths.
  - bpo-43284: platform.win32_ver derives the windows version
    from sys.getwindowsversion().platform_version which in turn
    derives the version from kernel32.dll (which can be of
    a different version than Windows itself). Therefore change
    the platform.win32_ver to determine the version using the
    platform module’s _syscmd_ver private function to return an
    accurate version.
  - bpo-42248: [Enum] ensure exceptions raised in _missing__
    are released
  - bpo-43799: OpenSSL 3.0.0: define OPENSSL_API_COMPAT 1.1.1
    to suppress deprecation warnings. Python requires OpenSSL
    1.1.1 APIs.
  - bpo-43794: Add ssl.OP_IGNORE_UNEXPECTED_EOF constants
    (OpenSSL 3.0.0)
  - bpo-43789: OpenSSL 3.0.0: Don’t call the password callback
    function a second time when first call has signaled an
    error condition.
  - bpo-43788: The header files for ssl error codes are now
    OpenSSL version-specific. Exceptions will now show correct
    reason and library codes. The make_ssl_data.py script has
    been rewritten to use OpenSSL’s text file with error codes.
  - bpo-43655: tkinter dialog windows are now recognized as
    dialogs by window managers on macOS and X Window.
  - bpo-43534: turtle.textinput() and turtle.numinput() create
    now a transient window working on behalf of the canvas
    window.
  - bpo-43522: Fix problem with hostname_checks_common_name.
    OpenSSL does not copy hostflags from struct SSL_CTX to
    struct SSL.
  - bpo-42967: Allow bytes separator argument in
    urllib.parse.parse_qs and urllib.parse.parse_qsl when
    parsing str query strings. Previously, this raised
    a TypeError.
  - bpo-43176: Fixed processing of a dataclass that inherits
    from a frozen dataclass with no fields. It is now correctly
    detected as an error.
  - bpo-41735: Fix thread locks in zlib module may go wrong in
    rare case. Patch by Ma Lin.
  - bpo-36470: Fix dataclasses with InitVars and replace().
    Patch by Claudiu Popa.
  - bpo-32745: Fix a regression in the handling of ctypes’
    ctypes.c_wchar_p type: embedded null characters would cause
    a ValueError to be raised. Patch by Zackery Spytz.
  * Documentation
  - bpo-43959: The documentation on the PyContextVar C-API was
    clarified.
  - bpo-43938: Update dataclasses documentation to express that
    FrozenInstanceError is derived from AttributeError.
  - bpo-43755: Update documentation to reflect that
    unparenthesized lambda expressions can no longer be the
    expression part in an if clause in comprehensions and
    generator expressions since Python 3.9.
  - bpo-43739: Fixing the example code in
    Doc/extending/extending.rst to declare and initialize the
    pmodule variable to be of the right type.
  * Tests
  - bpo-43961: Fix
    test_logging.test_namer_rotator_inheritance() on Windows:
    use os.replace() rather than os.rename(). Patch by Victor
    Stinner.
  - bpo-43842: Fix a race condition in the SMTP test of
    test_logging. Don’t close a file descriptor (socket) from
    a different thread while asyncore.loop() is polling the
    file descriptor. Patch by Victor Stinner.
  - bpo-43811: Tests multiple OpenSSL versions on GitHub
    Actions. Use ccache to speed up testing.
  - bpo-43791: OpenSSL 3.0.0: Disable testing of legacy
    protocols TLS 1.0 and 1.1. Tests are failing with
    TLSV1_ALERT_INTERNAL_ERROR.
- Refreshed patches:
  - bpo-31046_ensurepip_honours_prefix.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
- Add vendorized files from bluez-devel to enable building support for
  Bluetooth.
* Sun May  2 2021 code@bnavigator.de
- Make sure to close the import_failed.map file after the exception
  has been raised in order to avoid ResourceWarnings when the
  failing import is part of a try...except block.
* Wed Apr 28 2021 mcepl@suse.com
- Update to 3.9.4:
  - bpo#43710: Reverted the fix for https://bugs.python.org/issue42500
    as it changed the PyThreadState struct size and broke the 3.9.x ABI
    in the 3.9.3 release (visible on 32-bit platforms using binaries
    compiled using an earlier version of Python 3.9.x headers).
  - bpo#26053: Fixed bug where the pdb interactive run command echoed
    the args from the shell command line, even if those have been
    overridden at the pdb prompt.
  - bpo#42988 (bsc#1183374) CVE-2021-3426: Remove the getfile
    feature of the pydoc module which could be abused to read
    arbitrary files on the disk (directory traversal
    vulnerability). Moreover, even source code of Python modules
    can contain sensitive data like passwords. Vulnerability
    reported by David Schwörer.
  - bpo#43285: ftplib no longer trusts the IP address value
    returned from the server in response to the PASV command by
    default. This prevents a malicious FTP server from using the
    response to probe IPv4 address and port combinations on the
    client network. Code that requires the former vulnerable
    behavior may set a trust_server_pasv_ipv4_address attribute
    on their ftplib.FTP instances to True to re-enable it.
  - bpo#43439: Add audit hooks for gc.get_objects(),
    gc.get_referrers() and gc.get_referents(). Patch by Pablo
    Galindo.
  - bpo#43660: Fix crash that happens when replacing sys.stderr
    with a callable that can remove the object while an exception
    is being printed. Patch by Pablo Galindo.
  - bpo#43555: Report the column offset for SyntaxError for
    invalid line continuation characters. Patch by Pablo Galindo.
  - bpo#43517: Fix misdetection of circular imports when using
    from pkg.mod import attr, which caused false positives in
    non-trivial multi-threaded code.
  - bpo#35883: Python no longer fails at startup with a fatal
    error if a command line argument contains an invalid Unicode
    character. The Py_DecodeLocale() function now escapes byte
    sequences which would be decoded as Unicode characters
    outside the [U+0000; U+10ffff] range.
  - bpo#43406: Fix a possible race condition where
    PyErr_CheckSignals tries to execute a non-Python signal
    handler.
  - bpo#42500: Improve handling of exceptions near recursion
    limit. Converts a number of Fatal Errors in RecursionErrors.
  - bpo#43433: xmlrpc.client.ServerProxy no longer ignores query
    and fragment in the URL of the server.
  - bpo#35930: Raising an exception raised in a “future” instance
    will create reference cycles.
  - bpo#43577: Fix deadlock when using ssl.SSLContext debug
    callback with ssl.SSLContext.sni_callback().
  - bpo#43521: ast.unparse can now render NaNs and empty sets.
  - bpo#43423: subprocess.communicate() no longer raises an
    IndexError when there is an empty stdout or stderr IO buffer
    during a timeout on Windows.
  - bpo#27820: Fixed long-standing bug of smtplib.SMTP where
    doing AUTH LOGIN with initial_response_ok=False will fail.
    The cause is that SMTP.auth_login _always_ returns a password
    if provided with a challenge string, thus non-compliant with
    the standard for AUTH LOGIN. Also fixes bug with the test for
    smtpd.
  - bpo#43332: Improves the networking efficiency of http.client
    when using a proxy via set_tunnel(). Fewer small send calls
    are made during connection setup.
  - bpo#43399: Fix ElementTree.extend not working on iterators
    when using the Python implementation
  - bpo#43316: The python -m gzip command line application now
    properly fails when detecting an unsupported extension. It
    exits with a non-zero exit code and prints an error message
    to stderr.
  - bpo#43260: Fix TextIOWrapper can not flush internal buffer
    forever after very large text is written.
  - bpo#42782: Fail fast in shutil.move() to avoid creating
    destination directories on failure.
  - bpo#37193: Fixed memory leak in socketserver.ThreadingMixIn
    introduced in Python 3.7.
  - bpo#43199: Answer “Why is there no goto?” in the Design and
    History FAQ.
  - bpo#43407: Clarified that a result from time.monotonic(),
    time.perf_counter(), time.process_time(), or
    time.thread_time() can be compared with the result from any
    following call to the same function - not just the next
    immediate call.
  - bpo#27646: Clarify that ‘yield from <expr>’ works with any
    iterable, not just iterators.
  - bpo#36346: Update some deprecated unicode APIs which are
    documented as “will be removed in 4.0” to “3.12”. See PEP 623
    for detail.
  - bpo#37945: Fix test_getsetlocale_issue1813() of test_locale:
    skip the test if setlocale() fails. Patch by Victor Stinner.
  - bpo#41561: Add workaround for Ubuntu’s custom OpenSSL
    security level policy.
  - bpo#43288: Fix test_importlib to correctly skip Unicode file
    tests if the fileystem does not support them.
  - bpo#43617: Improve configure.ac: Check for presence of
    autoconf-archive package and remove our copies of M4 macros.
  - bpo#42225: Document that IDLE can fail on Unix either from
    misconfigured IP masquerage rules or failure displaying
    complex colored (non-ascii) characters.
  - bpo#43283: Document why printing to IDLE’s Shell is often
    slower than printing to a system terminal and that it can be
    made faster by pre-formatting a single string before
    printing.
* Fri Feb 19 2021 mcepl@suse.com
- Update to 3.9.2:
  - bpo#42938 (bsc#1181126): Avoid static buffers when computing
    the repr of ctypes.c_double and ctypes.c_longdouble
    values. This issue was assigned CVE-2021-3177.
  - bpo#42967 (bsc#1182379): Fix web cache poisoning
    vulnerability by defaulting the query args separator to &,
    and allowing the user to choose a custom separator. This
    issue was assigned CVE-2021-23336.
- Upstreamed patches were removed:
  - CVE-2021-3177-buf_ovrfl_PyCArg_repr.patch
  - bsc1167501-invalid-alignment.patch
  - skip_random_failing_tests.patch
  - CVE-2019-5010-null-defer-x509-cert-DOS.patch
* Tue Feb  9 2021 steven.kowalik@suse.com
- Add Obsoletes for python3-base when primary interpreter is set to
  properly replace it during upgrades.  (bsc#1181324)
* Mon Feb  8 2021 mcepl@suse.com
- Update to 3.9.1:
  Security bugs:
  - Prevented potential DoS attack via CPU and RAM exhaustion
    when processing malformed Apple Property List files in binary
    format.
  - The plistlib module no longer accepts entity declarations in
    XML plist files to avoid XML vulnerabilities. This should not
    affect users as entity declarations are not used in regular
    plist files.
  - Add volatile to the accumulator variable in
    hmac.compare_digest, making constant-time-defeating
    optimizations less likely.
  Core and Builtins
  - Allow assignment expressions in set literals and set
    comprehensions as per PEP 572. Patch by Pablo Galindo.
  - Fix a regression introduced by the new parser, where an
    unparenthesized walrus operator was not allowed within
    generator expressions.
  - types.GenericAlias objects can now be the targets of
    weakrefs.
  - Fixed a bug in the PEG parser that was causing crashes in
    debug mode. Now errors are checked in left-recursive rules to
    avoid cases where such errors do not get handled in time and
    appear as long-distance crashes in other places.
  - Fixed a possible crash in the PEG parser when checking for
    the ‘!=’ token in the barry_as_flufl rule. Patch by Pablo
    Galindo.
  - Fix handling of errors during creation of PyFunctionObject,
    which resulted in operations on uninitialized memory. Patch
    by Yonatan Goldschmidt.
  - Fix a bug in the parser, where a curly brace following
    a primary didn’t fail immediately. This led to invalid
    expressions like a {b} to throw a SyntaxError with a wrong
    offset, or invalid expressions ending with a curly brace like
    a { to not fail immediately in the REPL.
  - Fix possible buffer overflow in the new parser when checking
    for continuation lines. Patch by Pablo Galindo.
  - Run the parser two times. On the first run, disable all the
    rules that only generate better error messages to gain
    performance. If there’s a parse failure, run the parser
    a second time with those enabled.
  - Document the default implementation of object.__eq__.
  - Fix peephole optimizer misoptimize conditional jump
    + JUMP_IF_NOT_EXC_MATCH pair.
  - The garbage collector now tracks all user-defined classes.
    Patch by Brandt Bucher.
  - Fixed potential issues with removing not completely
    initialized module from sys.modules when import fails.
  - Star-unpacking is now allowed for with item’s targets in the
    PEG parser.
  - Fixed stack overflow in issubclass() and isinstance() when
    getting the __bases__ attribute leads to infinite recursion.
  - When loading a native module and a load failure occurs,
    prevent a possible UnicodeDecodeError when not running in
    a UTF-8 locale by decoding the load error message using the
    current locale’s encoding.
  - Correctly count control blocks in ‘except’ in compiler.
    Ensures that a syntax error, rather a fatal error, occurs for
    deeply nested, named exception handlers.
  Library
  - types.GenericAlias will now raise a TypeError when attempting
    to initialize with a keyword argument. Previously, this would
    cause the interpreter to crash if the interpreter was
    compiled with debug symbols. This does not affect
    interpreters compiled for release. Patch by Ken Jin.
  - CGIHTTPRequestHandler.run_cgi() HTTP_ACCEPT improperly
    parsed. Replace the special purpose getallmatchingheaders
    with generic get_all method and add relevant tests.
  - inspect.findsource() now raises OSError instead of IndexError
    when co_lineno of a code object is greater than the file
    length. This can happen, for example, when a file is edited
    after it was imported. PR by Irit Katriel.
  - Fix handling of trailing comments by inspect.getsource().
  - ChainMap.__iter__ no longer calls __getitem__ on underlying
    maps
  - TracebackException no longer holds a reference to the
    exception’s traceback object. Consequently, instances of
    TracebackException for equivalent but non-equal exceptions
    now compare as equal.
  - We fixed an issue in pickle.whichmodule in which importing
    multiprocessing could change the how pickle identifies which
    module an object belongs to, potentially breaking the
    unpickling of those objects.
  - Clarify the error message for asyncio.IncompleteReadError
    when expected is None.
  - Extracting a symlink from a tarball should succeed and
    overwrite the symlink if it already exists. The fix is to
    remove the existing file or symlink before extraction. Based
    on patch by Chris AtLee, Jeffrey Kintscher, and Senthil
    Kumaran.
  - Fixed tkinter.ttk.Style.map(). The function accepts now the
    representation of the default state as empty sequence (as
    returned by Style.map()). The structure of the result is now
    the same on all platform and does not depend on the value of
    wantobjects.
  - Fix various issues with typing.Literal parameter handling
    (flatten, deduplicate, use type to cache key). Patch provided
    by Yurii Karabas.
  - Fix the threading.Thread class at fork: do nothing if the
    thread is already stopped (ex: fork called at Python exit).
    Previously, an error was logged in the child process.
  - The onerror callback from shutil.rmtree now receives correct
    function when os.open fails.
  - Fix os.sendfile() on illumos.
  - Fixed writing binary Plist files larger than 4 GiB.
  - The repr() of typing types containing Generic Alias Types
    previously did not show the parameterized types in the
    GenericAlias. They have now been changed to do so.
  - webbrowser: Ignore NotADirectoryError when calling
    xdg-settings.
  - binhex.binhex() consisently writes macOS 9 line endings.
  - Fix a stack overflow error for asyncio Task or Future repr().
  - The overflow occurs under some circumstances when a Task or
    Future recursively returns itself.
  - Fix memory leak in subprocess.Popen() in case an uid (gid)
    specified in user (group, extra_groups) overflows uid_t
    (gid_t).
  - Improve asyncio.wait function to create the futures set just
    one time.
  - InvalidFileException and RecursionError are now the only
    errors caused by loading malformed binary Plist file
    (previously ValueError and TypeError could be raised in some
    specific cases).
  - Pickling heap types implemented in C with protocols 0 and
    1 raises now an error instead of producing incorrect data.
  - plistlib: fix parsing XML plists with hexadecimal integer
    values
  - Fix an incorrectly formatted error from
    _codecs.charmap_decode() when called with a mapped value
    outside the range of valid Unicode code points. PR by Max
    Bernstein.
  - Fix pickling pure Python datetime.time subclasses. Patch by
    Dean Inwood.
  - Fixed a bug that was causing ctypes.util.find_library() to
    return None when triying to locate a library in an
    environment when gcc>=9 is available and ldconfig is not.
    Patch by Pablo Galindo
  - C14N 2.0 serialisation in xml.etree.ElementTree failed for
    unprefixed attributes when a default namespace was defined.
  - Fix a bug in the symtable module that was causing
    module-scope global variables to not be reported as both
    local and global. Patch by Pablo Galindo.
  - str() for the type attribute of the tkinter.Event object
    always returns now the numeric code returned by Tk instead of
    the name of the event type.
  - fix tkinter.EventType Enum so all members are strings, and
    none are tuples
  - Fix SQLite3 segfault when backing up closed database. Patch
    contributed by Peter David McCormick.
  - Fix the tarfile module to write only basename of TAR file to
    GZIP compression header.
  - Allow ctypes.wintypes to be imported on non-Windows systems.
  - shutil.which() now ignores empty entries in PATHEXT instead
    of treating them as a match.
  - Fix time-of-check/time-of-action issue in
    subprocess.Popen.send_signal.
  - Fix --outfile for cProfile / profile not writing the output
    file in the original directory when the program being
    profiled changes the working directory. PR by Anthony
    Sottile.
  - ZipFile truncates files to avoid corruption when a shorter
    comment is provided in append (“a”) mode. Patch by Jan Mazur.
  - Fixed KeyError exception when flattening an email to a string
    attempts to replace a non-existent Content-Transfer-Encoding
    header.
  Documentation
  - Fix the URL for the IMAP protocol documents.
  - Document __format__ functionality for IP addresses.
  - Clarify that subscription expressions are also valid for
    certain classes and types in the standard library, and for
    user-defined classes and types if the classmethod
    __class_getitem__() is provided.
  - Documented generic alias type and types.GenericAlias. Also
    added an entry in glossary for generic types.
  - In Programming FAQ “Sequences (Tuples/Lists)” section, add
    “How do you remove multiple items from a list”.
  - Fix RemovedInSphinx40Warning when building the documentation.
    Patch by Dong-hee Na.
  - Update the refcounts info of PyType_FromModuleAndSpec.
  - Fix tarfile’s extractfile documentation
  - Document some restrictions on the default string
    representations of numeric classes.
  Tests
  - Reenable test_gdb on gdb 9.2 and newer:
    https://bugzilla.redhat.com/show_bug.cgi?id=1866884 bug is
    fixed in gdb 10.1.
  - Fix test_asyncio.test_call_later() race condition: don’t
    measure asyncio performance in the call_later() unit test.
    The test failed randomly on the CI.
  - Include _testinternalcapi module in Windows installer for
    test suite
  - Fix test_logging.test_race_between_set_target_and_flush():
    the test now waits until all threads complete to avoid
    leaking running threads.
  - Avoid a test failure in test_lib2to3 if the module has
    already imported at the time the test executes. Patch by
    Pablo Galindo.
  - Tests for CJK codecs no longer call eval() on content
    received via HTTP.
  - Fix test_site.test_license_exists_at_url(): call
    urllib.request.urlcleanup() to reset the global
    urllib.request._opener. Patch by Victor Stinner.
  - test_ssl: skip test_min_max_version_mismatch when TLS 1.0 is
    not available
  - Add tests for SIGINT handling in the runpy module.
  - Fixed a failure in test_tk.test_widgets.ScaleTest happening
    when executing the test with Tk 8.6.10.
  Build
  - Fix a race condition in “make regen-all” when make -jN option
    is used to run jobs in parallel. The clinic.py script now
    only use atomic write to write files. Moveover, generated
    files are now left unchanged if the content does not change,
    to not change the file modification time.
  - Update Py_UNREACHABLE to use __builtin_unreachable() if only
    the compiler is able to use it. Patch by Dong-hee Na.
  - Addressed three compiler warnings found by undefined behavior
    sanitizer (ubsan).
  IDLE
  - Fix reporting offset of the RE error in searchengine.
  - Get docstrings for IDLE calltips more often by using
    inspect.getdoc.
  - Mostly finish using ttk widgets, mainly for editor, settings,
    and searches. Some patches by Mark Roseman.
  - Use ‘IDLE Shell’ as shell title
  - Rewrite the Calltips doc section.
  - In calltips, stop reminding that ‘/’ marks the end of
    positional-only arguments.
  - Typing opening and closing parentheses inside the parentheses
    of a function call will no longer cause unnecessary
    “flashing” off and on of an existing open call-tip, e.g. when
    typed in a string literal.
  C API
  - Fix potential crash in deallocating method objects when
    dynamically allocated PyMethodDef’s lifetime is managed
    through the self argument of a PyCFunction.
  - Py_FileSystemDefaultEncodeErrors and Py_UTF8Mode are
    available again in limited API.
- Readjustet and reapplied patches:
  - CVE-2021-3177-buf_ovrfl_PyCArg_repr.patch
  - bpo-31046_ensurepip_honours_prefix.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
  - skip_random_failing_tests.patch
  - sphinx-update-removed-function.patch
* Fri Jan 29 2021 mcepl@suse.com
- Add CVE-2021-3177-buf_ovrfl_PyCArg_repr.patch fixing
  bsc#1181126 (CVE-2021-3177) buffer overflow in PyCArg_repr in
  _ctypes/callproc.c, which may lead to remote code execution.
* Tue Jan  5 2021 mcepl@suse.com
- (bsc#1180125) We really don't Require python-rpm-macros package.
  Unnecessary dependency.
* Wed Dec 16 2020 mcepl@suse.com
- Make python39-doc building again
- Add no-skipif-doctests.patch, because SLE-15 version of Sphinx
  doesn't know about skipif directive in doctests.
* Sat Dec 12 2020 mcepl@suse.com
- Update sphinx-update-removed-function.patch patch to the latest
  version in python36.
* Thu Dec 10 2020 code@bnavigator.de
- Last try before this results in an editwar:
  * remove importlib_resources and importlib-metadata
    provides/obsoletes
  * import importlib_resources is not the same as
    import importlib.resources, same for metadata
  * The backport packages from PyPI needed for older flavors are
    specified as such for setuptools or in pyproject.toml. If a
    package requires them they typically add them with a python
    version qualifier and the packages have their own version
    numbers.
* Sat Dec  5 2020 mcepl@suse.com
- Add patch sphinx-update-removed-function.patch to no longer call
  a now removed function and to make documentation build independent of
  the Sphinx version (bsc#1179630, gh#python/cpython#13236).
* Fri Nov 13 2020 mcepl@suse.com
- Don't require packages which break build on SLE-15 although we really
  don't need them (python3-python-docs-theme and
  python3-sphinxcontrib-qthelp).
* Fri Oct  9 2020 dimstar@opensuse.org
- Fix build with RPM 4.16: error: bare words are no longer
  supported, please use "...":  x86 == ppc.
* Tue Oct  6 2020 mcepl@suse.com
- Update to the final version 3.9.0:
  Complete changelog with all (many)
  changes from previous version is on
  https://docs.python.org/release/3.9.0/whatsnew/3.9.html
  Changes from the previous RC versions (not that many) are on
  https://docs.python.org/release/3.9.0/whatsnew/changelog.html#changelog
* Fri Sep 25 2020 dimstar@opensuse.org
- Buildrequire timezone only for general flavor. It's used in this
  flavor for the test suite.
* Wed Sep  2 2020 mcepl@suse.com
- Update to 3.9.0rc1:
  * Core and Builtins
  - bpo-38156: Handle interrupts that come after EOF
    correctly in PyOS_StdioReadline.
  * Library
  - bpo-41497: Fix potential UnicodeDecodeError in dis
    module.
  - bpo-41490: Update ensurepip to install pip 20.2.1 and
    setuptools 49.2.1.
  - bpo-41467: On Windows, fix asyncio recv_into() return
    value when the socket/pipe is closed (BrokenPipeError):
    return 0 rather than an empty byte string (b'').
  - bpo-41425: Make tkinter doc example runnable.
  - bpo-41384: Raise TclError instead of TypeError when an
    unknown option is passed to tkinter.OptionMenu.
  - bpo-38731: Fix NameError in command-line interface of
    py_compile.
  - bpo-41317: Use add_done_callback() in
    asyncio.loop.sock_accept() to unsubscribe reader early on
    cancellation.
  - bpo-41364: Reduce import overhead of uuid.
  - bpo-41341: Recursive evaluation of typing.ForwardRef in
    get_type_hints.
  - bpo-41182: selector: use DefaultSelector based upon
    implementation
  - bpo-40726: Handle cases where the end_lineno is None on
    ast.increment_lineno().
  * Documentation
  - bpo-41045: Add documentation for debug feature of
    f-strings.
  - bpo-41314: Changed the release when from __future__
    import annotations becomes the default from 4.0 to 3.10
    (following a change in PEP 563).
  * Windows
  - bpo-41492: Fixes the description that appears in UAC
    prompts.
  - bpo-40948: Improve post-install message to direct people
    to the “py” command.
  - bpo-41412: The installer will now fail to install on
    Windows 7 and Windows 8. Further, the UCRT dependency is
    now always downloaded on demand.
  - bpo-40741: Update Windows release to include SQLite
    3.32.3.
  * IDLE
  - bpo-41468: Improve IDLE run crash error message (which
    users should never see).
  - bpo-41373: Save files loaded with no line ending, as when
    blank, or different line endings, by setting its line
    ending to the system default. Fix regression in 3.8.4 and
    3.9.0b4.
* Tue Sep  1 2020 mcepl@suse.com
- Synchronize formatting and fixes with python38.
* Thu Aug 20 2020 schwab@suse.de
- Increase testsuite timeout to account for super long running
  test_peg_generator
* Tue Jul 21 2020 callumjfarmer13@gmail.com
- Removed CVE-2019-20907_tarfile-inf-loop.patch: fixed in upstream
- Removed recursion.tar: contained in upstream
- Update to 3.9.0b5:
  - bpo-41304: Fixes python3x._pth being ignored on Windows, caused
    by the fix for bpo-29778 (CVE-2020-15801).
  - bpo-41162: Audit hooks are now cleared later during
    finalization to avoid missing events.
  - bpo-29778: Ensure python3.dll is loaded from correct locations
    when Python is embedded (CVE-2020-15523).
  - bpo-39603: Prevent http header injection by rejecting control
    characters in http.client.putrequest(…).
  - bpo-41295: Resolve a regression in CPython 3.8.4 where defining
    “__setattr__” in a multi-inheritance setup and
    calling up the hierarchy chain could fail if builtins/extension
    types were involved in the base types.
  - bpo-41247: Always cache the running loop holder when running
    asyncio.set_running_loop.
  - bpo-41252: Fix incorrect refcounting in
    _ssl.c’s _servername_callback().
  - bpo-41215: Use non-NULL default values in the PEG parser
    keyword list to overcome a bug that was '
    preventing Python from being properly compiled when using the
    XLC compiler. Patch by Pablo Galindo.
  - bpo-41218: Python 3.8.3 had a regression where compiling with
    ast.PyCF_ALLOW_TOP_LEVEL_AWAIT would
    aggressively mark list comprehension with CO_COROUTINE. Now only
    list comprehension making use of async/await will tagged as so.
  - bpo-41175: Guard against a NULL pointer dereference within
    bytearrayobject triggered by the bytearray() + bytearray() operation.
  - bpo-39960: The “hackcheck” that prevents sneaking around a type’s
    __setattr__() by calling the superclass method was
    rewritten to allow C implemented heap types.
  - bpo-41288: Unpickling invalid NEWOBJ_EX opcode with the
    C implementation raises now UnpicklingError instead of crashing.
  - bpo-39017: Avoid infinite loop when reading specially crafted
    TAR files using the tarfile module (CVE-2019-20907, bsc#1174091).
  - bpo-41235: Fix the error handling in ssl.SSLContext.load_dh_params().
  - bpo-41207: In distutils.spawn, restore expectation that
    DistutilsExecError is raised when the command is not found.
  - bpo-39168: Remove the __new__ method of typing.Generic.
  - bpo-41194: Fix a crash in the _ast module: it can no longer be
    loaded more than once. It now uses a global state rather than a module state.
  - bpo-39384: Fixed email.contentmanager to allow set_content() to set a
    null string.
  - bpo-41300: Save files with non-ascii chars.
    Fix regression released in 3.9.0b4 and 3.8.4.
  - bpo-37765: Add keywords to module name completion list.
    Rewrite Completions section of IDLE doc.
  - bpo-40170: Revert PyType_HasFeature() change: it reads
    again directly the PyTypeObject.tp_flags
    member when the limited C API is not used, rather than always calling
    PyType_GetFlags() which hides implementation details.
* Mon Jul 20 2020 mcepl@suse.com
- Add CVE-2019-20907_tarfile-inf-loop.patch fixing bsc#1174091
  (CVE-2019-20907, bpo#39017) avoiding possible infinite loop
  in specifically crafted tarball.
  Add recursion.tar as a testing tarball for the patch.
* Fri Jul 17 2020 callumjfarmer13@gmail.com
- Changed bpo-31046_ensurepip_honours_prefix.patch to include fix from py3.8
* Thu Jul 16 2020 callumjfarmer13@gmail.com
- Spec file fixes
- Re-added subprocess-raise-timeout.patch: now compatible
- Removed bpo34022-stop_hash-based_invalidation_w_SOURCE_DATE_EPOCH.patch: contained in upstream
* Wed Jul 15 2020 tchvatal@suse.com
- Fix minor issues found in the staging.
* Wed Jul 15 2020 tchvatal@suse.com
- Do not set ourselves as primary interpreter
* Tue Jul 14 2020 mcepl@suse.com
- Update to 3.9.0b4:
  - PEP 584, Union Operators in dict
  - PEP 585, Type Hinting Generics In Standard Collections
  - PEP 593, Flexible function and variable annotations
  - PEP 602, Python adopts a stable annual release cadence
  - PEP 615, Support for the IANA Time Zone Database in the
    Standard Library
  - PEP 616, String methods to remove prefixes and suffixes
  - PEP 617, New PEG parser for CPython
  - bpo#38379, garbage collection does not block on resurrected
    objects;
  - bpo#38692, os.pidfd_open added that allows process
    management without races and signals;
  - bpo#39926, Unicode support updated to version 13.0.0;
  - bpo#1635741, when Python is initialized multiple times in
    the same process, it does not leak memory anymore;
  - A number of Python builtins (range, tuple, set, frozenset,
    list, dict) are now sped up using PEP 590 vectorcall;
  - A number of Python modules (_abc, audioop, _bz2, _codecs,
    _contextvars, _crypt, _functools, _json, _locale, operator,
    resource, time, _weakref) now use multiphase initialization
    as defined by PEP 489;
  - A number of standard library modules (audioop, ast, grp,
    _hashlib, pwd, _posixsubprocess, random, select, struct,
    termios, zlib) are now using the stable ABI defined by
    PEP 384.
- Remove upstreamed patches:
  - F00102-lib64.patch
  - SUSE-FEDORA-multilib.patch
  - OBS_dev-shm.patch
  - subprocess-raise-timeout.patch
  - bpo36302-sort-module-sources.patch
  - bpo40784-Fix-sqlite3-deterministic-test.patch
* Fri Jul 10 2020 tchvatal@suse.com
- Update pre_checkin.sh and regenerate
* Fri Jul 10 2020 tchvatal@suse.com
- Convert few dependencies to their pkgconfig counterparts
* Fri Jul 10 2020 tchvatal@suse.com
- Remove release requirement on libpython, it is not really needed
  to be equal as the abi changes with versions
* Fri Jul 10 2020 tchvatal@suse.com
- Add provides python3-bla on all the subpkgs in case we are
  primary provider of the functionality
* Fri Jul 10 2020 tchvatal@suse.com
- Remove unversioned files from devel subpkg too
- Remove main python3 files from -base based whether we are
  primary interpreter or not
- Fix idle to be co-installable
- Add condition to be primary to provide/obsolete python3-*
- Fix doc to build in versioned folder so the pythons can be
  installed next to each other
* Fri Jul 10 2020 tchvatal@suse.com
- Revert the full versioning of calls on the macros. These
  are generic so they should really just call python3 X
* Fri Jul 10 2020 tchvatal@suse.com
- For the doc package we can build with generic flavor, we don't
  need the our-interpreter based one
* Fri Jul 10 2020 tchvatal@suse.com
- Add provides for pytohn3X-typing/etc to allow BR on those still
  to work when needed
* Fri Jul 10 2020 tchvatal@suse.com
- Change macros.python3 to use full versioned 3.8 instead of just 3
  for python interpreter
* Wed Jul  1 2020 tchvatal@suse.com
- Reduce some now unused conditionals
* Wed Jul  1 2020 tchvatal@suse.com
- Redux the -base dependencies to match up pre-merge layout
* Wed Jul  1 2020 tchvatal@suse.com
- Generate baselibs in pre-checkin too
* Wed Jul  1 2020 tchvatal@suse.com
- Generate the importlib-failed using pre_checking again
- Add back the information about skipped tests on the pre_checkin
  output
* Tue Jun 30 2020 tchvatal@suse.com
- Use %%python_pkg_name instead of hardcoding python3 where
  applicable
- Sort out preamble with spec-cleaner
* Mon Jun 29 2020 mcepl@suse.com
- Calculate required variables instead of relying on their continuous manual update
* Thu Jun 25 2020 tchvatal@suse.com
- Fix the -base module build again to generate only the deps
  we need
* Wed Jun 17 2020 mcepl@suse.com
- Replace OBS_dev-shm.patch with the upstream PR#20944
* Wed Jun 10 2020 tchvatal@suse.com
- Use the %%{python_pkg_name} on more places to allow easier
  multiversioning
- Switch to _multibuild approach for easier maintenance of this
  package. All is now in one spec file with 3 conditionals:
  * bcond_with base
  * bcond_with doc
  * bcond_with general
* Mon Jun  8 2020 mcepl@suse.com
- add requires python3-base on libpython subpackage (bsc#1167008)
* Fri Jun  5 2020 dmueller@suse.com
- build against Sphinx 2.x until python is compatible with
  Sphinx 3.x (see gh#python/cpython#19397, bpo#40204)
* Fri May 29 2020 andreas.stieger@gmx.de
- Fix build with SQLite 3.32 (bpo#40783)
  add bpo40784-Fix-sqlite3-deterministic-test.patch
* Sun May 17 2020 callumjfarmer13@gmail.com
- Update to version 3.8.3:
  - Complete list of changes is available at
    https://docs.python.org/release/3.8.3/whatsnew/changelog.html#python-3-8-3-final,
    but most of them are just bugfixes.
  - Removed patch CVE-2020-8492-urllib-ReDoS.patch: contained in upstream
* Thu Apr 16 2020 mcepl@suse.com
- Add #!BuildIgnore: gdk-pixbuf-loader-rsvg to python3 SPEC
* Thu Mar 26 2020 mcepl@suse.com
- Add patch bsc1167501-invalid-alignment.patch
  (bsc#1167501, bpo#40052) to fix alignment in abstract.h header file.
* Wed Mar 11 2020 schwab@suse.de
- Update list of skipped tests for qemu linux-user build, test_setegid
  (test.test_os.PosixUidGidTests) is confusing it
* Thu Mar  5 2020 mcepl@suse.com
- Update to 3.8.2:
  - Complete list of changes is available at
    https://docs.python.org/release/3.8.2/whatsnew/changelog.html#python-3-8-2-final,
    but most of them are just bugfixes.
  - Updated patches:
  - F00102-lib64.patch
  - OBS_dev-shm.patch
  - SUSE-FEDORA-multilib.patch
  - subprocess-raise-timeout.patch
* Sat Feb  8 2020 mcepl@suse.com
- Add CVE-2020-8492-urllib-ReDoS.patch fixing the security bug
  "Python urrlib allowed an HTTP server to conduct Regular
  Expression Denial of Service (ReDoS)" (bsc#1162367)
* Sat Feb  8 2020 mcepl@suse.com
- Add Requires: libpython%%{so_version} == %%{version}-%%{release}
  to python3-base to keep both packages always synchronized
  (bsc#1162224).
* Mon Feb  3 2020 tchvatal@suse.com
- Do not pull in bluez in base again, explain the cycle,
  it needs to be solved by bluez maintainer for us by providing
  just the headers separately
* Mon Feb  3 2020 tchvatal@suse.com
- Reame idle icons to idle3 in order to not conflict with python2
  variant of the package
  * renamed the icons
  * renamed icon load in desktop file
* Thu Jan 16 2020 tchvatal@suse.com
- Add importlib_resources provide/obsolete as it is integral
  part of the lang since 3.7 release
* Mon Jan 13 2020 mliska@suse.cz
- Add -fno-semantic-interposition as it brings speed up:
  https://fedoraproject.org/wiki/Changes/PythonNoSemanticInterpositionSpeedup
* Thu Dec 19 2019 mcepl@suse.com
- Update to 3.8.1:
  - This is mainly bugfix release and no significant changes to
    API are expected. The full changelog is available on
    https://docs.python.org/3.8/whatsnew/changelog.html#python-3-8-1
  - Remove bpo-38688_shutil.copytree_prevent-infinite-recursion.patch,
    which is included in the upstream tarball.
* Thu Dec 19 2019 mcepl@suse.com
- Add bpo-31046_ensurepip_honours_prefix.patch which makes
  ensurepip to honour the value of $(prefix). Proposed fix for
  bpo#31046..
* Tue Dec 10 2019 tchvatal@suse.com
- Move bluez-devel dependency to base as it is needed for
  socket.AF_BLUETOOTH and otherwise does not work
* Mon Dec  2 2019 mcepl@suse.com
- Reintroduce QtHelp with the help of the new BR
  python-sphinxcontrib-qthelp.
* Mon Oct 21 2019 stefan.bruens@rwth-aachen.de
- Fix SUSE-FEDORA-multilib.patch, the platform agnostic infix for
  library installation is "lib", not "dir".
* Thu Oct 17 2019 stefan.bruens@rwth-aachen.de
- Move idle subpackage build from python3-base to python3.
  appstream-glib required for packaging introduces considerable
  extra dependencies and a build loop via rust/librsvg.
- Correct installation of idle IDE icons:
  + idle.png is not the target directory
  + non-GNOME-specific icons belong into icons/hicolor
- Add required Name key to idle3 desktop file
* Tue Oct 15 2019 mcepl@suse.com
- Update to the final release 3.8.0. .
  - New Features:
  - Assignment expressions
  - Positional-only parameters
  - Parallel filesystem cache for compiled bytecode files
  - Debug build uses the same ABI as release build
  - f-strings support = for self-documenting expressions and
    debugging
  - PEP 578: Python Runtime Audit Hooks
  - PEP 587: Python Initialization Configuration
  - Vectorcall: a fast calling protocol for CPython
  - Pickle protocol 5 with out-of-band data buffers
  - New modules:
  - importlib.metadata
  - Improved modules:
  - ast asyncio, builtins, collections, curses, ctypes,
    datetime, functools, gc, gettext, gzip, idelib and IDLE,
    inspect, io, json.tool, math, mmap, multiprocessing, os,
    os.path, pathlib, pickle, plistlib, py_compile, shlex,
    shutil, socket, ssl, statistics, sys, tarfile, threading,
    tokenize, tkinter, time, typing, unicodedata, unittest,
    venv, weakref, xml
  - C API improvements
  - bdist_winnst command has been deprecated (use bdist_wheel)
- https://docs.python.org/3.8/whatsnew/3.8.html remains rest of
  changes including documentation on how to port your programs to
  the current version of Python.
* Mon Oct 14 2019 mcepl@suse.com
- Add idle3.appdata.xml and idle3.desktop (originally from
  Fedora) to make Idle3 full GUI desktop application.
  (bsc#1153830)
* Wed Oct  9 2019 mgorse@suse.com
- Drop intltool from BuildRequires. Doesn't appear to be used.
* Wed Oct  9 2019 tchvatal@suse.com
- Add folder version to allow tarball downloads even for beta/rc
  releases
* Tue Oct  8 2019 mcepl@suse.com
- Revert patches from Fedora (F00102-lib64.patch and
  F00251-change-user-install-location.patch) into their original
  prisitine Fedora versions, SUSE-FEDORA-multilib.patch refreshed
  accordingly.
* Mon Oct  7 2019 mcepl@suse.com
- Correct quotation of platsubdir in Lib/distutils/command/install.py
* Thu Oct  3 2019 mcepl@suse.com
- Replace python-3.6.0-multilib.patch with two patches from
  Fedora (F00102-lib64.patch and
  F00251-change-user-install-location.patch), and our own
  SUSE-FEDORA-multilib.patch to allow better cooperation with
  Fedora and better upstreaming.
- Add OBS_dev-shm.patch fixing bpo#38377
* Thu Oct  3 2019 tchvatal@suse.com
- Pull in just gettext and let solver to sort out between:
  gettext-runtime-mini and gettext-runtime
* Wed Oct  2 2019 mcepl@suse.com
- Update to 3.8.0rc1. Overall changes from 3.7:
  - PEP 572, Assignment expressions
  - PEP 570, Positional-only arguments
  - PEP 587, Python Initialization Configuration (improved
    embedding)
  - PEP 590, Vectorcall: a fast calling protocol for CPython
  - PEP 578, Runtime audit hooks
  - PEP 574, Pickle protocol 5 with out-of-band data
  - Typing-related: PEP 591 (Final qualifier), PEP 586 (Literal
    types), and PEP 589 (TypedDict)
  - Parallel filesystem cache for compiled bytecode
  - Debug builds share ABI as release builds, also the 'm' ABI
    tag was removed (irrelevant since 3.4), bpo#36707
  - f-strings support a handy = specifier for debugging
  - continue is now legal in finally: blocks
  - on Windows, the default asyncio event loop is now
    ProactorEventLoop
  - on macOS, the spawn start method is now used by default in
    multiprocessing
  - multiprocessing can now use shared memory segments to avoid
    pickling costs between processes
  - typed_ast is merged back to CPython
  - LOAD_GLOBAL is now 40%% faster
  - pickle now uses Protocol 4 by default, improving performance
- Refreshed patches:
  - CVE-2019-5010-null-defer-x509-cert-DOS.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
  - python-3.6.0-multilib.patch
  - subprocess-raise-timeout.patch
* Wed Sep 25 2019 bwiedemann@suse.com
- Add bpo36302-sort-module-sources.patch (boo#1041090)
* Tue Sep 10 2019 tchvatal@suse.com
- Try harder obsoleting importlib-metadata
* Fri Aug 30 2019 mcepl@suse.com
- Update to 3.8.0b4:
  Many bugfixes, full list on
  https://docs.python.org/3.8/whatsnew/changelog.html#python-3-8-0-beta-4
* Thu Aug 29 2019 guillaume.gardet@opensuse.org
- Re-enable test_threading on aarch64
* Sat Aug 17 2019 jayvdb@gmail.com
- Remove xrpm from subpackage tk description
* Tue Aug  6 2019 mcepl@suse.com
- Update to 3.8.0b3:
  Many bugfixes, full list on
  https://docs.python.org/3.8/whatsnew/changelog.html#python-3-8-0-beta-3
- Patches reapplied:
  - python-3.3.0b1-fix_date_time_compiler.patch
  - python-3.3.0b1-test-posix_fadvise.patch
  - python-3.6.0-multilib.patch
  - subprocess-raise-timeout.patch
* Tue Jul 23 2019 mcepl@suse.com
- Add Provides: python3-importlib-metadata
* Sun Jul  7 2019 mcepl@suse.com
- Update to 3.8.0b2:
  Many bugfixes, full list on
  https://docs.python.org/3.8/whatsnew/changelog.html#python-3-8-0-beta-2
- Patches included in upstream:
  - bpo-37169_PyObject_IsFreed.patch
- Patches reapplied:
  - 00251-change-user-install-location.patch
  - distutils-reproducible-compile.patch
  - python-3.3.0b1-localpath.patch
  - python-3.6.0-multilib.patch
* Tue Jul  2 2019 schwab@suse.de
- Update list of skipped tests for qemu linux-user build
- Don't do profiling in qemu linux-user build
* Wed Jun  5 2019 mcepl@suse.com
- Update to 3.8.0b1 (changes since 3.7.*):
  - PEP 572, Assignment expressions
  - PEP 570, Positional-only arguments
  - PEP 587, Python Initialization Configuration (improved embedding)
  - PEP 590, Vectorcall: a fast calling protocol for CPython
  - PEP 578, Runtime audit hooks
  - PEP 574, Pickle protocol 5 with out-of-band data
  - Typing-related: PEP 591 (Final qualifier), PEP 586 (Literal
    types), and PEP 589 (TypedDict)
  - Parallel filesystem cache for compiled bytecode
  - Debug builds share ABI as release builds
  - f-strings support a handy = specifier for debugging
  - continue is now legal in finally: blocks
  - multiprocessing can now use shared memory segments to avoid
    pickling costs between processes
  - typed_ast is merged back to CPython
  - LOAD_GLOBAL is now 40%% faster
  - pickle now uses Protocol 4 by default, improving performance
- Remove patches which were included in the upstream:
  - 00251-change-user-install-location.patch
  - 00316-mark-bdist_wininst-unsupported.patch
  - CVE-2019-9947-no-ctrl-char-http.patch
  - raise_SIGING_not_handled.patch
* Wed May 22 2019 mliska@suse.cz
- Set _lto_cflags to nil as the package is using LTO via --enable-lto.
  That will prevent to propage LTO for Python modules that are
  built in a separate package.
* Sat May  4 2019 mcepl@suse.com
- Update to 3.8.0.a3:
  - PEP 572: Assignment Expressions.
  - Other (mostly small) changes are on
    https://docs.python.org/3.8/whatsnew/changelog.html#python-3-8-0-alpha-3
* Mon Apr 29 2019 mcepl@suse.com
- bsc#1130840 (CVE-2019-9947): add CVE-2019-9947-no-ctrl-char-http.patch
  Address the issue by disallowing URL paths with embedded
  whitespace or control characters through into the underlying
  http client request. Such potentially malicious header
  injection URLs now cause a ValueError to be raised.
* Wed Apr 10 2019 mcepl@suse.com
- Fix metadata of patches.
- Rename boo1071941-make-install-in-sep-loc.patch to
  00251-change-user-install-location.patch which is the original
  name, so it can be looked up in the Fedora VCS.
* Tue Apr  9 2019 jayvdb@gmail.com
- Mark distutils bdist_wininst command unsupported
  with 00316-mark-bdist_wininst-unsupported.patch
- Remove Windows bdist_wininst executables from runtime package
* Mon Apr  8 2019 mcepl@suse.com
- Update to 3.7.3, which is the maintenance release without any
  significant changes in API.
  - Updated patches:
  - CVE-2019-5010-null-defer-x509-cert-DOS.patch
  - distutils-reproducible-compile.patch
  - python-3.3.0b1-fix_date_time_compiler.patch
  - python-3.6.0-multilib.patch
  - raise_SIGING_not_handled.patch
* Wed Mar 20 2019 mcepl@suse.com
- Remove building of Qt Develop help files.
* Fri Mar 15 2019 mcepl@suse.com
- Return distutils-reproducible-compile.patch which is still
  missing (still unfinished bpo#29708).
* Mon Feb 25 2019 mcepl@suse.com
- Update to 3.8.0a2:
  * List of all (mostly small) changes are on
    https://docs.python.org/3.8/whatsnew/changelog.html#python-3-8-0-alpha-2
* Tue Feb 12 2019 mcepl@suse.com
- Build nis module again.
* Tue Feb 12 2019 mcepl@suse.com
- Update to 3.8.0a1:
  * The most visible change so far is probably the
    implementation of PEP 572: Assignment Expressions. For
    a detailed list of changes, see:
    https://docs.python.org/3.8/whatsnew/changelog.html
  * Recover building of nis module properly in python3 package
- Update patches:
  * CVE-2019-5010-null-defer-x509-cert-DOS.patch
  * python-3.3.0b1-fix_date_time_compiler.patch
  * python-3.3.0b1-test-posix_fadvise.patch
  * python-3.6.0-multilib.patch
  * raise_SIGING_not_handled.patch
* Wed Jan 30 2019 mcepl@suse.com
- Put LICENSE file where it belongs (bsc#1121852)
* Sat Jan 19 2019 mcepl@suse.com
- bsc#1122191: add CVE-2019-5010-null-defer-x509-cert-DOS.patch
  fixing bpo-35746.
  An exploitable denial-of-service vulnerability exists in the
  X509 certificate parser of Python.org Python 2.7.11 / 3.7.2.
  A specially crafted X509 certificate can cause a NULL pointer
  dereference, resulting in a denial of service. An attacker can
  initiate or accept TLS connections using crafted certificates
  to trigger this vulnerability.
* Tue Jan  8 2019 tchvatal@suse.com
- Do not require full gettext in order to avoid pulling in the
  glib2 as a dependency
* Tue Jan  8 2019 tchvatal@suse.com
- Update to 3.7.2:
  * bugfix release:
    https://docs.python.org/3.7/whatsnew/changelog.html#changelog
* Wed Jan  2 2019 mcepl@suse.com
- Stop applying python-3.6.0-multilib-new.patch (which is still
  WIP), and apply the old proven python-3.6.0-multilib.patch
  instead.
* Wed Dec 19 2018 toddrme2178@gmail.com
- Use upstream-recommended %%{_rpmconfigdir}/macros.d directory
  for the rpm macros.
* Mon Dec 17 2018 mcepl@suse.com
- Upgrade to 3.7.2rc1:
  * bugfix release, for the full list of all changes see
    https://docs.python.org/3.7/whatsnew/changelog.html#changelog
- Make run of the test suite more verbose
* Tue Dec 11 2018 jengelh@inai.de
- Write summaries without em dashes.
* Mon Dec  3 2018 mcepl@suse.com
- Remove python-3.3.0b1-curses-panel.patch it is unnecessary anymore.
- Add boo1071941-make-install-in-sep-loc.patch to make pip and
  distutils in user environment install into separate location
  (boo#1071941)
  Set values of prefix and exec_prefix in distutils install
  command to /usr/local if executable is /usr/bin/python* and RPM
  build is not detected to make pip and distutils install into
  separate location
- Remove finally python-3.3.3-skip-distutils-test_sysconfig_module.patch
- Remove distutils-reproducible-compile.patch which doesn't make
  really much difference in reproducibility (see
  gh#python/cpython#8057 and discussion there).
* Fri Nov 30 2018 mcepl@suse.com
- Rename Stop_hash-based_invalidation_w_SOURCE_DATE_EPOCH.patch
  to bpo34022-stop_hash-based_invalidation_w_SOURCE_DATE_EPOCH.patch
* Wed Nov  7 2018 mcepl@suse.com
- Add dependency on bluez-devel to build support for Bluetooth
  (boo#1109998)
* Tue Nov  6 2018 mcepl@suse.com
- Add devhelp subpackage and split qthelp into another
  subpackage.
* Wed Oct 24 2018 mcepl@suse.com
- Remove python-3.0b1-record-rpm.patch and
  Python-3.0b1-record-rpm.patch, as they are not needed anymore
* Tue Oct 23 2018 mcepl@suse.com
- Switch off test_threading for optimization builds.
* Mon Oct 22 2018 mcepl@suse.com
- Update to python-3.7.1. This is just a brief overview, complete
  changelog available at
  https://docs.python.org/3.7/whatsnew/changelog.html#python-3-7-1-final:
    Library
    bpo-34970: Protect tasks weak set manipulation in asyncio.all_tasks()
- Patches already accepted upstream are removed:
  * 00307-allow-to-call-Py_Main-after-Py_Initialize.patch
  * 00308-tls-1.3.patch
- New patches added:
  * Stop_hash-based_invalidation_w_SOURCE_DATE_EPOCH.patch
  * raise_SIGING_not_handled.patch
- All other patches refreshed via quilt.
* Mon Oct 22 2018 mcepl@suse.com
- Add raise_SIGING_not_handled.patch to fix bsc#1094814
* Wed Oct 17 2018 tchvatal@suse.com
- Add patch to fix importlib return types:
  * python3-imp-returntype.patch
* Mon Oct 15 2018 mcepl@suse.com
- bpo-34022 still not completely fixed, so we have to keep
  excluding test_cmd_line_script,
  test_multiprocessing_main_handling, and test_runpy from the
  test suite.
* Sun Oct 14 2018 mcepl@suse.com
- Update to python 3.7.1~rc2:
    Core and Builtins
    bpo-34879: Fix a possible null pointer dereference in
    bytesobject.c. Patch by Zackery Spytz.
    bpo-34854: Fixed a crash in compiling string annotations
    containing a lambda with a keyword-only argument that
    doesn’t have a default value.
    bpo-34320: Fix dict(od) didn’t copy iteration order of
    OrderedDict.
    Library
    bpo-34769: Fix for async generators not finalizing when event
    loop is in debug mode and garbage collector runs in another
    thread.
    bpo-34922: Fixed integer overflow in the digest() and
    hexdigest() methods for the SHAKE algorithm in the hashlib
    module.
    bpo-34900: Fixed unittest.TestCase.debug() when used to call
    test methods with subtests. Patch by Bruno Oliveira.
    bpo-34871: Fix inspect module polluted sys.modules when parsing
    __text_signature__ of callable.
    bpo-34872: Fix self-cancellation in C implementation of
    asyncio.Task
    bpo-34819: Use a monotonic clock to compute timeouts in
    Executor.map() and as_completed(), in order to prevent
    timeouts from deviating when the system clock is adjusted.
    bpo-34334: In QueueHandler, clear exc_text from LogRecord to
    prevent traceback from being written twice.
    bpo-6721: Acquire the logging module’s commonly used internal
    locks while fork()ing to avoid deadlocks in the child
    process.
    bpo-34172: Fix a reference issue inside multiprocessing.Pool
    that caused the pool to remain alive if it was deleted
    without being closed or terminated explicitly.
    Documentation
    bpo-32174: chm document displays non-ASCII charaters properly on
    some MBCS Windows systems.
    Tests
    bpo-32962: Fixed test_gdb when Python is compiled with flags
  - mcet -fcf-protection -O0.
    C API
    bpo-34910: Ensure that PyObject_Print() always returns -1 on
    error. Patch by Zackery Spytz.
* Fri Oct 12 2018 mcepl@suse.com
- Add Stop_hash-based_invalidation_w_SOURCE_DATE_EPOCH.patch to
  fix problems with SOURCE_DATE_EPOCH variable (bpo-34022)
* Mon Sep 17 2018 tchvatal@suse.com
- Add patch to fix build with tls1.3 supported openssl
  * 00308-tls-1.3.patch
- Add patch to fix Py_Main calls after Py_initialize
  * 00307-allow-to-call-Py_Main-after-Py_Initialize.patch
* Mon Sep  3 2018 mcepl@suse.com
- Add -fwrapv to OPTS, which is default for python3 anyway
  See for example https://github.com/zopefoundation/persistent/issues/86
  for bugs which are caused by avoiding it.
* Tue Jul 10 2018 mcepl@suse.com
- Fix ownership of _contextvars, _queue, and _xxtestfuzz
* Tue Jul  3 2018 mcepl@suse.com
- Switch off LTO for distros with older GCC
- Fix %%files
* Fri Jun 29 2018 tchvatal@suse.com
- Add dependency over libuuid-devel
* Thu Jun 28 2018 mimi.vx@gmail.com
- update to python 3.7.0
    Complete overview of changes is available on
    https://docs.python.org/3/whatsnew/3.7.html, these are just
    highlights:
  * PEP 563, postponed evaluation of type annotations.
  * async and await are now reserved keywords.
  * New library modules:
    contextvars: PEP 567 – Context Variables
    dataclasses: PEP 557 – Data Classes
    importlib.resources
  * New built-in features:
    PEP 553, the new breakpoint() function.
  * Python data model improvements:
    PEP 562, customization of access to module attributes.
    PEP 560, core support for typing module and generic types.
    the insertion-order preservation nature of dict objects
    has been declared to be an official part of the Python
    language spec.
  * Significant improvements in the standard library:
    The asyncio module has received new features, significant
    usability and performance improvements.
    The time module gained support for functions with
    nanosecond resolution.
  * CPython implementation improvements:
    Avoiding the use of ASCII as a default text encoding:
    PEP 538, legacy C locale coercion
    PEP 540, forced UTF-8 runtime mode
    PEP 552, deterministic .pycs
    the new development runtime mode
    PEP 565, improved DeprecationWarning handling
  * C API improvements:
    PEP 539, new C API for thread-local storage
  * Documentation improvements:
    PEP 545, Python documentation translations
    New documentation translations: Japanese, French, and Korean.
- drop python3-sorted_tar.patch
- drop 0001-allow-for-reproducible-builds-of-python-packages.patch
- refresh python-3.6.0-multilib-new.patch
- refresh subprocess-raise-timeout.patch
  * new C API for thread-local storage
  * Deterministic pyc files
  * Built-in breakpoint()
  * Data Classes
  * Core support for typing module and generic types
  * Customization of access to module attributes
  * Postponed evaluation of annotations
  * Time functions with nanosecond resolution
  * Improved DeprecationWarning handling
  * Context Variables
  * Avoiding the use of ASCII as a default text encoding
    (PEP 538, legacy C locale coercion and PEP 540, forced UTF-8 runtime mode)
  * The insertion-order preservation nature of dict objects is now
    an official part of the Python language spec.
  * Notable performance improvements in many areas.
* Thu May 17 2018 hpj@urpla.net
- disable lto with gcc versions below 7 (results in link failures)
* Mon Apr 30 2018 jengelh@inai.de
- Use faster find subcommand execution strategies.
* Fri Apr 20 2018 tchvatal@suse.com
- Do not mention the testsuite disabling in opts as it was moved to
  main pkg so base is test-free
* Tue Apr 17 2018 tchvatal@suse.com
- As we run in main python package do not generate the pre_checkin
  from both now
* Mon Apr 16 2018 tchvatal@suse.com
- Move the tests from base to generic package wrt bsc#1088573
  * We still fail the whole distro if python3 is not build
  * The other archs than x86_64 took couple of hours to unblock
    build of other software, this way we work around the issue
- Some tests are still run in -base for the LTO tweaking, but at
  least it is not run twice
* Sat Mar 31 2018 mimi.vx@gmail.com
- update to 3.6.5
  * bugfix release
  * see Misc/NEWS for details
- drop ctypes-pass-by-value.patch
- drop fix-localeconv-encoding-for-LC_NUMERIC.patch
- refresh python-3.6.0-multilib-new.patch
* Wed Mar  7 2018 adam@mizerski.pl
- Created %%so_major and %%so_minor macros
- Put Tools/gdb/libpython.py script into proper place and ship it with devel
  subpackage.
* Tue Feb 20 2018 schwab@suse.de
- ctypes-pass-by-value.patch: Fix pass by value for structs on aarch64
* Tue Feb 20 2018 bwiedemann@suse.com
- Add python3-sorted_tar.patch (boo#1081750)
* Tue Feb 20 2018 tchvatal@suse.com
- Drop python3-tk and python3-idle recommends to reduce python3
  always pulling X stack bsc#1081751
* Wed Feb  7 2018 tchvatal@suse.com
- Add patch to fix glibc 2.27 fail bsc#1079761:
  * fix-localeconv-encoding-for-LC_NUMERIC.patch
* Mon Feb  5 2018 normand@linux.vnet.ibm.com
- Update skip_random_failing_tests.patch (for PowerPC)
  to avoid test_call_later failure
* Wed Jan 24 2018 jmatejek@suse.com
- move XML modules and python3-xml provide to python3-base
  (fixes bsc#1077230)
- move ensurepip to base
* Thu Jan 18 2018 normand@linux.vnet.ibm.com
- Add skip_random_failing_tests.patch only for PowerPC
* Wed Jan  3 2018 jmatejek@suse.com
- update to 3.6.4
  * bugfix release, over a hundred bugs fixed
  * see Misc/NEWS for details
- drop upstreamed python3-ncurses-6.0-accessors.patch
- drop PYTHONSTARTUP hooks that cause spurious startup errors
  * fixes bsc#1070738
  * the relevant feature (REPL history) is now built into Python itself
* Sat Dec  2 2017 dimstar@opensuse.org
- Install 2to3-%%{python_version} executable (override defattr of
  the -tools package). 2to3 (unversioned) is a symlink and does not
  carry permissions (bsc#1070853).
* Thu Nov 16 2017 mimi.vx@gmail.com
- move 2to3 to python3-tools package
* Wed Oct 11 2017 jmatejek@suse.com
- update to 3.6.3
  * bugfix release, over a hundred bugs fixed
  * see Misc/NEWS for details
- drop upstreamed 0001-3.6-bpo-30714-ALPN-changes-for-OpenSSL-1.1.0f-3093.patch
* Wed Sep 20 2017 dmueller@suse.com
- drop python-2.7-libffi-aarch64.patch: this patches the intree
  copy of libffi which is unused/deleted in the line afterwards
- fix build against system libffi: include flags weren't set
  so it actually used the in-tree libffi headers.
* Thu Sep 14 2017 vcizek@suse.com
- Fix test broken with OpenSSL 1.1 (bsc#1042670)
  * add 0001-3.6-bpo-30714-ALPN-changes-for-OpenSSL-1.1.0f-3093.patch
* Tue Sep  5 2017 jengelh@inai.de
- Update RPM group for python documentation.
* Thu Aug 31 2017 schwab@suse.de
- fix missing %%{?armsuffix}
* Wed Aug 30 2017 jmatejek@suse.com
- distutils-reproducible-compile.patch: ensure distutils order files
  before compiling, which works around bsc#1049186
* Thu Aug 17 2017 kukuk@suse.de
- Add libnsl-devel build requires for glibc obsoleting libnsl
* Thu Aug  3 2017 jmatejek@suse.com
- update to 3.6.2
  * bugfix release, over a hundred bugs fixed
  * see Misc/NEWS for details
- drop upstreamed test-socket-aead-kernel49.patch
- add Provides: python3-typing (fixes bsc#1050653)
- drop duplicate Provides: python3
* Mon Jun 26 2017 jmatejek@suse.com
- drop db-devel from requirements
* Tue Jun 20 2017 asn@cryptomilk.org
- Add missing link to python library in config dir (bsc#1040164)
* Thu Mar 23 2017 jmatejek@suse.com
- update to 3.6.1
  * bugfix release, over a hundred bugs fixed
  * never add import location's parent directory to sys.path
  * switch to git for version control, build changes related to that
  * fix "failed to get random numbers" on old kernels (bsc#1029902)
  * several crashes and memory leaks corrected
  * f-string are no longer accepted as docstrings
* Mon Mar 13 2017 jmatejek@suse.com
- prevent regenerating AST at build-time more robustly
- add "--without profileopt" and "--without testsuite" options to python3-base
  to allow short circuiting when working on the package
* Sat Feb 25 2017 bwiedemann@suse.com
- Add 0001-allow-for-reproducible-builds-of-python-packages.patch
  upstream https://github.com/python/cpython/pull/296
* Wed Feb  8 2017 jmatejek@suse.com
- reenable test_socket with AEAD patch (test-socket-aead-kernel49.patch)
- reintroduce %%py3_soflags macro (and better named %%cpython3_soabi equivalent)
* Wed Jan 11 2017 jmatejek@suse.com
- update to 3.6.0
  * PEP 498 Formated string literals
  * PEP 515 Underscores in numeric literals
  * PEP 526 Syntax for variable annotations
  * PEP 525 Asynchronous generators
  * PEP 530 Asynchronous comprehensions
  * PEP 506 New "secrets" module for safe key generation
  * less memory consumed by dicts
  * dtrace and systemtap support
  * improved asyncio module
  * better defaults for ssl
  * new hashing algorithms in hashlib
  * bytecode format changed to allow more optimizations
  * "async" and "await" are on track to be reserved words
  * StopIteration from generators is deprecated
  * support for openssl < 1.0.2 is deprecated
  * os.urandom now blocks when getrandom() blocks
  * huge number of new features, bugfixes and optimizations
  * see https://docs.python.org/3.6/whatsnew/3.6.html for details
- rework multilib patch: drop Python-3.5.0-multilib.patch, implement
  upstreamable python-3.6.0-multilib-new.patch
- refresh python-3.3.0b1-localpath.patch, subprocess-raise-timeout.patch
- drop upstreamed Python-3.5.1-fix_lru_cache_copying.patch
- finally drop python-2.6b1-canonicalize2.patch that was not applied in source
  and only kept around in case we needed it in the future. (which we don't, as it seems)
- update import_failed map and baselibs
- build ctypes against system libffi
  (buildrequire libffi-devel in python3-base)
- add new key to keyring (signed by keys already in keyring)
- introduced common configure section between python3 and python3-base
- moved pyconfig.h and Makefile to devel subpackage as distutils no longer
  need it at runtime
- added python-rpm-macros dependency, regenerated macros file, drop macros.python3.py
  because it is not used now
- improve summaries and descriptions (fixes bsc#917607)
- enabled Link-Time Optimization, see what happens
- including skipped_tests.py in pre_checkin.sh run
- run specs through spec-cleaner, rearrange sections
* Fri Apr 22 2016 jmatejek@suse.com
- move _hashlib and _ssl modules and tests to python3-base
- recommend python3
* Tue Mar 15 2016 schwab@suse.de
- Skip test_asyncio under qemu_user_space_build
* Mon Mar  7 2016 toddrme2178@gmail.com
- Add  Python-3.5.1-fix_lru_cache_copying.patch
  Fix copying the lru_cache() wrapper object.
  Fixes deep-copying lru_cache regression, which worked on
  previous versions of python but fails on python 3.5.
  This fixes a bunch of packages in devel:languages:python3.
  See: https://bugs.python.org/issue25447
* Sun Jan 24 2016 arichardson.kde@gmail.com
- Build the docs in .qch format as well
* Wed Dec  9 2015 toddrme2178@gmail.com
- update to 3.5.1
  * bugfix-only release, dozens of bugs fixed
- Drop upstreamed Python-3.5.0-_Py_atomic_xxx-symbols.patch
- "Python3" to "Python 3" in summary
  * This seems cleaner and fixes and rpmlint warning
* Wed Oct 14 2015 toddrme2178@gmail.com
- Add Python-3.5.0-_Py_atomic_xxx-symbols.patch
  This fixes a build error for many packages that use the Python,
  C-API.
  This patch is already accepted upstream and is slated to appear in
  python 3.5.1.
* Tue Sep 29 2015 jmatejek@suse.com
- update to 3.5.0
  * coroutines with async/await syntax
  * matrix multiplication operator `@`
  * unpacking generalizations
  * new modules `typing` and `zipapp`
  * type annotations
  * .pyo files replaced by custom suffixes for optimization levels in __pycache__
  * support for memory BIO in ssl module
  * performance improvements in several modules
  * and many more
- removals and behavior changes
  * deprecated `__version__` is removed
  * support for .pyo files was removed
  * system calls are auto-retried on EINTR
  * bare generator expressions in function calls now cause SyntaxError
    (change "f(x for x in i)" to "f((x for x in i))" to fix)
  * removed undocumented `format` member of private `PyMemoryViewObject` struct
  * renamed `PyMemAllocator` to `PyMemAllocatorEx`
- redefine %%dynlib macro to reflect that modules now have arch+os as part of name
- module `time` is now built-in
- dropped upstreamed patches:
  python-3.4.1-fix-faulthandler.patch
  python-3.4.3-test-conditional-ssl.patch
  python-fix-short-dh.patch (also dropped dh2048.pem required for this patch)
- updated patch Python-3.3.0b2-multilib.patch to Python-3.5.0-multilib.patch
- python-ncurses-6.0-accessors.patch taken from python 2 to fix build failure
  with new gcc + ncurses
* Wed Sep  9 2015 dimstar@opensuse.org
- Add python3-ncurses-6.0-accessors.patch: Fix build with
  NCurses 6.0 and OPAQUE_WINDOW set to 1.
* Mon Aug 24 2015 jmatejek@suse.com
- improve import_failed hook to do the right thing when invoking
  missing modules with "python3 -m modulename" (boo#942751)
* Thu Jul 23 2015 fisiu@opensuse.org
- Build with --enable-loadable-sqlite-extensions to make it works
  as geospatial database.
* Wed Jul  1 2015 dimstar@opensuse.org
- Fix source list for previous change (add dh2048.pem).
* Wed Jun 24 2015 meissner@suse.com
- dh2048.pem: added generated 2048 dh parameter set to fix
  ssl test (bsc#935856)
- python-fix-short-dh.patch: replace the 512 bits dh parameter set
  by 2048 bits to fix build with new openssl 1.0.2c (bsc#935856)
* Tue May 19 2015 schwab@suse.de
- ctypes-libffi-aarch64.patch: remove upstreamed patch
- python-2.7-libffi-aarch64.patch: Fix argument passing in libffi for
  aarch64
* Thu May 14 2015 jmatejek@suse.com
- drop the PDF subpackage
  (removes the massive texlive dependency, and most likely nobody is
  using the PDFs anyway)
* Thu May 14 2015 jmatejek@suse.com
- python-3.4.3-test-conditional-ssl.patch - restore tests failing because
  test_urllib was unconditionally importing ssl (without really needing it)
- restore functionality of multilib patch
- drop libffi-ppc64le.diff because upstream completely changed everything
  yet again (sorry ppc64 folks :| )
* Fri May  1 2015 mailaender@opensuse.org
- Update to version 3.4.3
- Drop upstreamed CVE-2014-4650-CGIHTTPServer-traversal.patch
  (bpo#21766)
* Wed Mar 25 2015 rguenther@suse.com
- Add python-3.4.1-fix-faulthandler.patch, upstream patch for bogus
  faulthandler which fails with GCC 5.
* Sun Jan 11 2015 p.drouand@gmail.com
- asyncio has been merged in python3 main package; provide and
  obsolete it
- Remove obsolete AUTHORS section
- Remove redundant %%clean section
* Sat Oct 18 2014 crrodriguez@opensuse.org
- Only pkgconfig(x11) is required for build, not the whole
  set of packages provided by xorg-x11-devel metapackage.
* Mon Oct 13 2014 jmatejek@suse.com
- add %%python3_version rpm macro for Fedora compatibility
- add missing argument in import_failed, rename Novell Bugzilla
  to SUSE Bugzilla
* Thu Jul 31 2014 dimstar@opensuse.org
- Rename rpmlintrc to %%{name}-rpmlintrc.
  Follow the packaging guidelines.
* Wed Jul 23 2014 jmatejek@suse.com
- CVE-2014-4650-CGIHTTPServer-traversal.patch: CGIHTTPServer file
  disclosure and directory traversal through URL-encoded characters
  (CVE-2014-4650, bnc#885882)
* Tue Jul 22 2014 jmatejek@suse.com
- drop python-3.4.1-SUSE-ensurepip.patch for compatibility reasons,
  reinstate bundled copies of pip and setuptools
  (fixes bnc#885662)
- add more files as sources to silence the validator
* Wed May 21 2014 jmatejek@suse.com
- update to 3.4.1
  * bugfix-only release, over 300 bugs fixed
- drop upstreamed python-3.4.0rc2-sqlite-3.8.4-tests.patch
- drop upstreamed CVE-2014-2667-mkdir.patch
- include Python release manager keyring and signature file
  for the source archive (thus renumbering of source files)
  (see https://www.python.org/download/#openpgp-public-keys )
- move ensurepip to python3, because it transitively requires ssl
* Fri Apr  4 2014 jmatejek@suse.com
- CVE-2014-2667-mkdir.patch: race condition with reseting umask
  in os.makedirs
  (CVE-2014-2667, bnc#871152)
- updated multilib patch to include ~/.local/lib64 (bnc#637176)
* Wed Mar 26 2014 jmatejek@suse.com
- raise timeout value for test_subprocess to 10s (might fix
  intermittent build failures in OBS)
* Mon Mar 24 2014 dmueller@suse.com
- remove blacklisting of test_posix on aarch64: qemu bug is fixed
* Mon Mar 17 2014 jmatejek@suse.com
- update to 3.4.0 final
- drop upstreamed python-3.4rc2-importlib.patch
* Sun Mar 16 2014 schwab@suse.de
- Only build with profile-opt if profiling is enabled
- Update test exclusion lists:
  * test_ctypes no longer fails on arm
  * test_io no longer fails on ppc*
  * test_multiprocessing has been split in multiple tests
  * test_posix and test_signal fail due to qemu bugs
* Fri Mar 14 2014 andreas.stieger@gmx.de
- Fix build with SQLite 3.8.4 [bnc#867887], fixing SQLite tests,
  adding python-2.7.6-sqlite-3.8.4-tests.patch
* Thu Feb 27 2014 jmatejek@suse.com
- update to 3.4.0 rc2
  * pre-release bugfixes
  * improvements to asyncio library
- drop upstreamed tracemalloc_gcov.patch
- python-3.4rc2-importlib.patch fixes backwards-incompatibility
  in the reworked importlib module that blocks build of vim
* Fri Jan 17 2014 jmatejek@suse.com
- initial commit of 3.4.0 beta 3
  * new stdlib modules: pathlib, enum, statistics, tracemalloc
  * asynchronous IO with new asyncio module
  * introspection data for builtins
  * subprocesses no longer inherit open file descriptors
  * standardized metadata for packages
  * internal hashing changed to SipHash
  * new pickle protocol
  * improved handling of codecs
  * TLS 1.2 support
  * major speed improvements for internal unicode handling
  * many bugfixes and optimizations
- see porting guide at:
  http://docs.python.org/3.4/whatsnew/3.4.html#porting-to-python-3-4
- moved several modules to -testsuite subpackage
- updated list of binary extensions, refreshed patches
- tracemalloc_gcov.patch fixes profile-based optimization build
- updated packages and pre_checkin.sh to use ~-version notation
  for prereleases
- fix-shebangs part of build process moved to common %%prep
- drop python-3.3.2-no-REUSEPORT.patch (upstreamed)
- update baselibs for new soname
- TODOs:
  * require python-pip, make ensurepip work with zypper
* Wed Dec  4 2013 matz@suse.de
- add ppc64le (ELFv2) support for libffi copy for ctypes module
- Adjust Python-3.3.0b2-multilib.patch for ppc64le (make sys.lib be
  "lib64").
- added patches:
  * libffi-ppc64le.diff
* Tue Dec  3 2013 adrian@suse.de
- add ppc64le rules
* Fri Nov 22 2013 speilicke@suse.com
- Add python-3.3.3-skip-distutils-test_sysconfig_module.patch:
  + Disable global and distutils sysconfig comparison test, we deviate
    from the default depending on optflags
* Tue Nov 19 2013 jmatejek@suse.com
- update to 3.3.3
  * bugfix-only release
  * many SSL-related fixes
  * upstream fix for CVE-2013-4238
  * upstream fixes for CVE-2013-1752
- move example module xxlimited to python3-testsuite
- drop CVE-2013-4238_py33.patch - it is upstreamed
- remove --with-wide-unicode config option, it is now the default
  (and only) choice
- don't touch anything between make and makeinstall
- drop python-3.2b2-buildtime-generate.patch - the issue was caused
  by touching things between make and makeinstall
- link pycache entries for import_failed hooks properly
* Tue Oct 15 2013 crrodriguez@opensuse.org
- build with -DOPENSSL_LOAD_CONF for the same reasons
  described in the python2 package.
* Fri Aug 16 2013 jmatejek@suse.com
- handle NULL bytes in certain fields of SSL certificates
  (CVE-2013-4238, bnc#834601)
* Thu Aug  8 2013 dvaleev@suse.com
- Exclue test_faulthandler from tests on powerpc due to bnc#831629
* Thu Jun 13 2013 jmatejek@suse.com
- update to 3.3.2
  * bugfix-only release
  * fixes several regressions introduced in 3.3.1
- switch to xz compression
- move _lzma module to python3-base
- python-3.3.2-no-REUSEPORT.patch to fix build on kernels without SO_REUSEPORT
* Mon Apr 29 2013 schwab@suse.de
- Readd missing bits from ctypes-libffi-aarch64.patch
* Sat Apr 13 2013 idonmez@suse.com
- Update to version 3.3.1
  * Fix the –enable-profiling configure switch.
  * In IDLE, close the replace dialog after it is used.
- Too many bugfixes to list here,
  see See http://hg.python.org/cpython/file/v3.3.0/Misc/NEWS
- Refresh Python-3.3.0b2-multilib.patch
- Refresh python-3.2b2-buildtime-generate.patch
- Drop upstream patches: ctypes-libffi-aarch64.patch,
  python-3.2.3rc2-pypirc-secure.patch, python-3.3.0-getdents64.patch
* Mon Apr  8 2013 speilicke@suse.com
- Exclude sqlite/test and tk/test directories from the respective
  sub-packages. These are owned by the testsuite sub-package already
* Fri Apr  5 2013 idonmez@suse.com
- Add Source URL, see https://en.opensuse.org/title=SourceUrls
* Wed Apr  3 2013 jmatejek@suse.com
- remove spurious modification of python-3.3.0b1-localpath.patch
  that would force installation into /usr/local.
  this fixes bnc#809831
* Thu Mar 28 2013 jmatejek@suse.com
- replace broken movetogetdents64.diff patch with a correct one
  from upstream repo (python-3.3.0-getdents64.patch)
* Fri Mar  1 2013 dmueller@suse.com
- add ctypes-libffi-aarch64.patch:
  * import aarch64 support for libffi in _ctypes module
- add aarch64 to the list of lib64 based archs
- add movetogetdents64.diff:
  * port to getdents64, as SYS_getdents is not implemented everywhere
* Tue Feb 26 2013 saschpe@suse.de
- /etc/rpm/macros.python3 is no %%config, it is not meant to be changed
  by users.
- Add rpmlintrc with some obvious filters
* Mon Jan 28 2013 jmatejek@suse.com
- update baselibs for new version of libpython3
* Thu Nov 29 2012 jmatejek@suse.com
- fix include path in macros (bnc#787526)
- implement failed import handlers for modules that live in
  subpackages - e.g. "import ssl" will now throw a sensible error
  message telling you to install "python3"
* Wed Nov 28 2012 jmatejek@suse.com
- merge python3-xml into python3
- merge python3-2to3 library into python3-base
  and the 2to3 binary into python3-devel
  (python3-devel is now in conflict with python-2to3, which
  will be dropped)
- enable --with-system-expat for python3, making the xml modules
  (and thus python3) depend on expat
- reconfigure tests to disable network and GUI resources, which
  the upstream apparently thought is a good idea to enable by default.
  this fixes build failures in Factory
- add lzma-devel to build the _lzma module
- moved %%dynlib macro definition to common section
* Mon Nov  5 2012 coolo@suse.com
- buildrequire timezone for the test suite
* Mon Oct 29 2012 dmueller@suse.com
- disable more checks for qemu builds as they use syscalls not
  implemented yet
* Thu Oct 25 2012 Rene.vanPaassen@gmail.com
- exclude test_math for SLE 11; math library fails on negative
  gamma function values close to integers and 0, probably
  due to imprecision in -lm on SLE_11_SP2.
* Tue Oct 16 2012 coolo@suse.com
- buildrequire libbz2-devel explicitly
* Mon Oct  8 2012 jmatejek@suse.com
- remove distutils.cfg (bnc#658604)
  * this changes default prefix for distutils to /usr
  * see ML for details:
  http://lists.opensuse.org/opensuse-packaging/2012-09/msg00254.html
* Mon Oct  1 2012 idonmez@suse.com
- Update to final 3.3.0 release
  * See http://hg.python.org/cpython/file/v3.3.0/Misc/NEWS
* Thu Sep 27 2012 idonmez@suse.com
- Correct dependency for python3-testsuite,
  python3-tkinter -> python3-tk
* Thu Aug 23 2012 jmatejek@suse.com
- update to 3.3.0 RC1
* Fri Aug  3 2012 jmatejek@suse.com
- update to 3.3.0 beta 1
  * flexible string representation, no longer distinguishing
    between wide and narrow Unicode builds
  * importlib-based import system
  * virtualenv support in core
  * namespace packages
  * explicit Unicode literals for easier porting
  * key-sharing dict implementation reduces memory footprint
    of OO code
  * hash randomization on by default
  * many other new bugfixes and features, check NEWS for details
- pre_checkin.sh now autofills various version strings in specs
- ship hashlib's fallback modules - those uselessly take up space
  when real _hashlib.so from python3 is present, but the space wasted
  is only 114kB and it provides python3-base with a working hashlib
  module.
  (also, this fixes bnc#743787)
* Fri Jul 27 2012 dvaleev@suse.com
- skip test_io on ppc
- drop test_io ppc patch
* Thu Jun 28 2012 saschpe@suse.de
- Satisfy source_validator by uncommenting an otherwise unused "Patch"
  line
* Tue Jun 12 2012 adrian@suse.de
- fix logic of checks exclusion
* Fri May 18 2012 idonmez@suse.com
- update to 3.2.3
  * No changes since rc2
* Thu Mar 29 2012 jmatejek@suse.com
- update to 3.2.3rc2
  * fixes several security issues:
  * CVE-2012-0845, bnc#747125
  * CVE-2012-1150, bnc#751718
  * CVE-2011-4944, bnc#754447
  * CVE-2011-3389, bnc#754677
- fix for insecure .pypirc (CVE-2011-4944, bnc#754447)
- disable test_gdb because it is broken by our gdb
* Thu Feb 16 2012 dvaleev@suse.com
- skip broken test_io test on ppc
* Wed Jan 18 2012 jmatejek@suse.com
- update to 3.2.2
  * bugfix-only release
  * reports "linux2" as sys.platform regardless of Linux kernel
- added pre_checkin.sh to copy common spec sections to python3.spec
- added PACKAGING-NOTES with some helpful info for packagers
* Sun Dec 25 2011 idonmez@suse.com
- Use system ffi, included one is broken see
  http://bugs.python.org/issue11729 and
  http://bugs.python.org/issue12081
* Fri Dec  9 2011 jmatejek@suse.com
- license.opensuse.org-compatible license headers
* Fri Dec  2 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Thu Nov 24 2011 agraf@suse.com
- fix ARM build (exclude some test cases which break for us)
* Tue Aug 16 2011 termim@gmail.com
- use sysconfig module to get py3_incdir, py3_abiflags,
  py3_soflags, python3_sitelib and python3_sitearch
* Mon Jul 18 2011 jmatejek@novell.com
- update to 3.2.1
  * bugfix-only release, no major changes
- fix build on linux3 platform
- remove upstreamed pybench patch
- install /usr/lib directories in all cases to prevent spurious
  "directory not owned" in dependent packages
* Wed Jun 15 2011 jmatejek@novell.com
- replaced dynamic so version with manual so version, because
  autobuild does not support autogeneration
* Tue May 24 2011 jmatejek@novell.com
- generate macros.python3 at compile-time with fixed values
- don't include bogus values in pyconfig.h, as they can break
  third-party packages (bnc#673071)
* Tue May 17 2011 jmatejek@novell.com
- added Obsoletes: python3 < 3.1 so that the transition from
  non-split to split packages goes smoothly
* Fri May 13 2011 jmatejek@novell.com
- fixed RPM macros to use python3 instead of python
- updated to build --with-wide-unicode (for compatibility with
  fedora and our own python 2.x series)
* Thu Apr 21 2011 termim@gmail.com
- fix python3-base build failure due to pybench.py crash by
  python-3.2-pybench.patch
- move pyconfig.h from python3-devel to python3-base package to
  make python3-base functional again
* Wed Mar 23 2011 termim@gmail.com
- update to python 3.2
  * stable ABI, ABI-tagged .so files
  * concurrent.futures and many other new or upgraded modules
  * PYC repository directories ( __pycache__ )
  * python WSGI 1.0.1
  * Unicode 6.0.0 support
  * a great number of bugfixes and assorted improvements
* Tue Feb  8 2011 matejcik@suse.cz
- update to python 3.2 RC2
- renamed python3-demo to python3-tools, because the demo part
  became much smaller than the tools part
- added rpm macros
* Tue Jan 18 2011 jmatejek@novell.com
- update to python 3.2 beta 2, see NEWS for details
- split off -base package with less dependencies, and a shlib-policy
  compliant libpython3 package
- mostly rewritten the spec file with more detailed comments
- cleaned up lists of patches
