#
# spec file for package pkg-config
#
# Copyright (c) 2017 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           pkg-config
Version:        0.29.2
Release:        150600.15.6.3
Summary:        A library management system
License:        GPL-2.0+
Group:          System/Packages
Url:            http://pkgconfig.freedesktop.org/
Source:         http://pkgconfig.freedesktop.org/releases/%{name}-%{version}.tar.gz
BuildRequires:  glib2-devel
# Old name for version <= 0.17 and SuSE Linux <= 10.2 & CODE10
# Mandriva 2009 and Fedora 11 still use old name "pkgconfig"
Provides:       pkgconfig = %{version}
Obsoletes:      pkgconfig < 0.21
# pkg-config has a virtual internal pkg-config.pc file, so we should provide it
Provides:       pkgconfig(pkg-config) = %{version}
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
The pkg-config program is used to retrieve information about installed
libraries in the system. It is typically used to compile and link
against one or more libraries.

%prep
%setup -q

%build
%configure\
    GLIB_CFLAGS='-I/usr/include/glib-2.0 -I%{_libdir}/glib-2.0/include' GLIB_LIBS='-lglib-2.0' \
%if "%{_lib}" == "lib"
    --with-pc_path=/usr/local/lib/pkgconfig:/usr/local/share/pkgconfig:%{_libdir}/pkgconfig:%{_datadir}/pkgconfig:/opt/kde3/%{_lib}/pkgconfig
%else
    --with-pc_path=/usr/local/%{_lib}/pkgconfig:/usr/local/lib/pkgconfig:/usr/local/share/pkgconfig:%{_libdir}/pkgconfig:%{_datadir}/pkgconfig:/opt/kde3/%{_lib}/pkgconfig
%endif
make %{?_smp_mflags}

%install
%make_install
# We'll put it with the other docs
rm %{buildroot}%{_datadir}/doc/pkg-config/pkg-config-guide.html

%files
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README ChangeLog pkg-config-guide.html
%{_bindir}/pkg-config
%ifarch s390 s390x
%{_bindir}/*-ibm-linux-gnu*-pkg-config
%else
%{_bindir}/*-suse-linux-gnu*-pkg-config
%endif
%dir %{_datadir}/aclocal
%{_datadir}/aclocal/pkg.m4
%doc %{_mandir}/man1/pkg-config.*

%changelog
* Wed Mar  5 2025 ismael.luceno@suse.com
- Build with system GLib instead of bundled GLib (bsc#1237374).
* Tue Apr 25 2017 dimstar@opensuse.org
- Update to version 0.29.2:
  + Improved pkg-config's recursive package list expansion
    performance.
  + Handle an empty prefix setting correctly when --define-prefix
    is used (fdo#97453).
  + Lazily load pc files instead of reading all available pc files
    during initialization (fdo#98215).
  + Check the CPATH environment variable when determining system
    include paths like GCC does. Document the system search path
    behavior (fdo#99224).
  + Make PKG_CHECK_MODULES show the module list rather than the
    variable prefix in configure output (fdo#98334).
  + Fix bundled glib build with GCC 6 (fdo#98334).
  + Handle -isystem and -idirafter when PKG_CONFIG_SYSROOT_DIR is
    set (fdo#97337).
  + Check the INCLUDE environment variable when determining system
    include paths on Windows builds when --msvc-syntax is used
    (fdo#94729).
- Drop pkg-config-gdate-fix.patch: fixed upstream.
* Wed Mar 15 2017 mliska@suse.cz
- Add pkg-config-gdate-fix.patch: enable building with GCC7, taken
  from upstream.
* Sat Mar  5 2016 zaitor@opensuse.org
- Update to version 0.29.1:
  + Fixed a regression from 0.29 with unquoting values queried with
  - -variable. In some cases, this would cause shell special
    characters to be escaped in ways they weren't before. Instead,
    the unquoting only occurs if the value appears to be quoted
    (fdo#93284).
  + Add support for building pkg-config with Microsoft Visual
    Studio (fdo#92489).
  + Allow overriding pkg-config variables with environment
    variables. By setting an environment variable of the form
    PKG_CONFIG_$PACKAGE_$VARIABLE, a pkg-config variable can be set
    globally without always having to pass --define-variable
    (fdo#90917).
  + Honor -Wl,-framework in addition to -framework so that multiple
    frameworks are handled on OSX (fdo#1278).
  + Fix the OSX build using --with-internal-glib (fdo#92902).
* Thu Oct  1 2015 zaitor@opensuse.org
- Update to version 0.29:
  + Fixed a regression from 0.28 in system -L flag handling. If the
    pc file has multiple system -L flags, every other flag will be
    left as is (fdo#78077).
  + Quoting of variables queried through --variable is removed so
    that the output can be used verbatim in subsequent shell
    commands (fdo#67904).
  + Fixed a regression from 0.28 in -L flag handling on Windows. A
    .libs suffix was inadvertantly being added to the library path.
  + Added a --validate option to check pc file syntax. This works
    just like --exists, but package dependencies are disabled
    (fdo#7000).
  + Added the PKG_PREREQ autoconf macro. Whereas
    PKG_PROG_PKG_CONFIG is used to check the version of the
    pkg-config tool, this is used to check the version of the
    pkg-config autoconf macros in use.
  + Added the PKG_CHECK_MODULES_STATIC autoconf macro. This will
    temporarily add --static to the pkg-config calls while invoking
    PKG_CHECK_MODULES (fdo#19541).
  + Many fixes to the testsuite for Windows. It should now pass for
    a MinGW, Cygwin, and cross-compiled MinGW using Wine for test
    execution (fdo#66939).
  + More consistent handling of prefix redefinition. On Windows,
    the prefix was always being redefined based on the pc file
    path. This feature can now be enabled or disabled at runtime on
    all platforms using the --define-prefix and
  - -dont-define-prefix options (fdo#63602).
  + Continue listing packages with --list-all even if there are
    errors in pc files (fdo#26615).
  + Various documentation improvements (fdo#62018, fdo#62374,
    fdo#66155).
  + Fixed a bug when multiple -isystem arguments are used
    (fdo#72584).
  + pkg-config is now built with largefile support to ensure that
    it works correctly on filesystems with 64 bit inodes
    (fdo#90078).
  + Bugs fixed: fdo#7000, fdo#19541, fdo#26615, fdo#62018,
    fdo#62374, fdo#63602, fdo#66155, fdo#66939, fdo#67904,
    fdo#70690, fdo#72584, fdo#78077, fdo#80378, fdo#80380,
    fdo#89267, fdo#90078, fdo#90437, fdo#92002.
* Wed Feb  5 2014 ro@suse.de
- Fix filelist for s390 (it is ibm-linux there).
* Fri Jun 28 2013 dmueller@suse.com
- fix filelist glob for armv6hl/armv6hl (which is a gnueabi target)
* Thu Apr  4 2013 dvaleev@suse.com
- Don't redefine _arch, but use file pattern instead. This ensures
  we don't have to run fixing each and every arch.
* Tue Feb  5 2013 p.drouand@gmail.com
- Update to version 0.28:
  + Fixed a pair of long-standing and intertwined bugs involving
    unwanted removal of flags:
  - Other Libs flags like -Wl are now kept in context order
    with -l flags.
  - Aggressive removal of all duplicate arguments has been scaled
    back so that just consecutive duplicate arguments are
    removed. One result of this change is that some flags could
    be repeated in the final output, especially flags from
    non-pkg-config packages like -lm. Since pkg-config rarely has
    enough knowledge here about the right thing to do, we throw
    the duplicate arguments at the compiler/linker and trust it
    will do the right thing.
  + Fixed an old bug to allow circular Requires. This fix brings
    along a small behavior change in that pkg-config resolves
    requires depth first, causing some lower level flags to show up
    earlier in the output than previously.
  + Cleaned up many corner-case bugs and ambiguous behavior in
    pkg-config's interface.
  + New autoconf macro PKG_CHECK_VAR for reading variables from .pc
    files.
  + Default to suppressing -L/lib and/or -L/lib64 like their /usr
    counterparts.
  + To help support multiarch scenarios out of the box,
    $host-pkg-config is now installed unless --disable-host-tool
    is passed to configure.
  + Added optional gcov usage through the --with-gcov configure
    option. As a result, many more tests were added to greatly
    increase the coverage of the code to 86%% of executed lines on a
    Fedora 18 machine.
  + Bugs fixed: fdo#130, fdo#7331, fdo#16101, fdo#17053, fdo#19950,
    fdo#34504, fdo#48098, fdo#54231, fdo#54271, fdo#54379,
    fdo#54384, fdo#54386, fdo#54388, fdo#54389, fdo#54390,
    fdo#54391, fdo#54427, fdo#54463, fdo#54716, fdo#57078,
    fdo#58363, fdo#59435.
* Mon Aug 27 2012 dimstar@opensuse.org
- Update to version 0.27.1:
  + Various fixes for using the internal glib snapshot. It should
    now be usable pretty much everywhere with the exception that
    universal builds are not supported on OS X.
  + Remove usage of gettext from the internal glib to avoid gettext
    and libintl dependencies
  + Update internal glib snapshot to 2.32.4
  + Fix check for POSIX shell used in tests to work better
  + Handle spaces in autodetected prefix on Windows
  + Bugs fixed: fdo#3550, fdo#51883, fdo#52031, fdo#53493.
* Wed Jul 18 2012 dimstar@opensuse.org
- Update to version 0.27:
  + Drop usage of popt for equivalent API in glib2
  + Add back an internal snapshot of glib2 to break circular
    dependency
  + Fix --exists to check for Requires and Requires.private.
  + Various fixes for MinGW which should allow it to be used
    unpatched on that system
  + New autoconf macros PKG_INSTALLDIR and PKG_NOARCH_INSTALLDIR to
    help determine the .pc file install directory
  + Fix handling of --exact/atleast/max-version vs. =/>=/<=
  + Fix errors in man page source
  + Ensure testing only searches in the check directory
  + Bump glib requirement to 2.16 to avoid deprecated
    g_win32_get_package_installation_subdirectory()
  + Autotools refresh and update
  + Use g_alloca from glib instead of figuring out alloca ourselves
  + Remove search for setresuid & setreuid only needed for internal
    popt
  + Bugs fixed: fdo#833, fdo#2458, fdo#5214, fdo#5326, fdo#5703,
    fdo#6074, fdo#8653, fdo#9135, fdo#9143, fdo#9584, fdo#10652,
    fdo#11464, fdo#14396, fdo#17053, fdo#23922, fdo#28776,
    fdo#29011, fdo#29801, fdo#31699, fdo#31700, fdo#32622,
    fdo#34382, fdo#37266, fdo#39646, fdo#41081, fdo#43149,
    fdo#44843, fdo#45599, fdo#45742, fdo#48743
- Changes from version 0.26:
  + Build system fixes
  + More tests
  + pkg.m4 fixups which makes autoconf 2.66 happier.
  + Drop support for legacy -config scripts.  Those should already
    be gone and cause problems in cross-compilation environments.
  + Drop embedded glib
  + Fix up pkg.m4 to handle the case of --exists working and
  - -cflags or --libs failing.
  + Various documentation updates
  + Allow $() through without escaping it.
  + Add --with-system-include-path instead of hard-coding
    /usr/include.
- Pass --with-internal-glib to configure. We don't want to have a
  build cycle with glib, so we use the interal version.
- Clean up spec-file using spec-cleaner and manually.
- Drop pkg-config-dnl.patch: fixed upstream.
* Fri Dec 30 2011 zaitor@opensuse.org
- Own %%{_datadir}/aclocal to fix build without automake/autoconf.
* Sat Sep 18 2010 vuntz@opensuse.org
- Update pkg-config-dnl.patch with the fix from git.
* Sat Sep 18 2010 coolo@novell.com
- Readd pkg-config-dnl.patch, see
  http://lists.gnu.org/archive/html/autoconf/2010-07/msg00035.html
* Sat Aug 14 2010 ro@suse.de
- drop pkg-config-dnl.patch, already in 0.25
* Thu Aug 12 2010 vuntz@opensuse.org
- Update to version 0.25:
  + 0.24 included a too strict whitespace/shell metacharacter
    filter leading to some legal characters like = and : being
    escaped in the output. This has been fixed.
  + When building with newer and external libpopt, it would be
    confused over being asked to split an empty string, leading to
    errors with packages that included empty fields in their .pc
    files.
  + Make the COPYING file explicitly GPLv2. The COPYING file in
    0.24 was inadvertently GPLv3 rather than the correct GPLv2.
  + Minor changes to documentation
- Changes from version 0.24:
  + Fix up bug in PKG_CONFIG_SYSROOT handling which mangled non-I
    and non-L arguments
  + Put /usr/lib/pkgconfig and /usr/share/pkgconfig into the
    default search path when no prefix is passed to configure.
  + Portability fixes for Windows and NetBSD
  + Various man page updates
  + Add logging support to log how pkg-config is being called.
  + Skip Requires.private unless we need them for Cflags
  + Add a variable, pc_path to the compiled-in pkg-config package
    that you can query for the compiled-in PKG_CONFIG_PC_PATH.
  + Various updates to pkg.m4.
  + Update rpmvercmp with bugfixes from upstream.
  + Add introductory guide to pkg-config.
  + Add listing of variables in a package
  + Make it possible to use external popt.
  + Add --print-provides and --print-requires(-private) options
  + Add support for paths containing whitespace and shell
    metacharacters
- Drop pkg-config-reqprov.patch: fixed upstream. Note that upstream
  has a slightly different behavior: where we had --print-requires,
  upstream chose to split the command in --print-requires and
  - -print-requires-private. This means we need a rpm package that
  provides a /usr/lib/rpm/pkgconfigdeps.sh fixed for this.
- Add pkg-config-dnl.patch to fix issues with autoconf 2.66, taken
  from Fedora.
* Thu Jul 22 2010 vuntz@opensuse.org
- Provide pkgconfig(pkg-config) since pkg-config has a virtual
  internal pkg-config.pc file.
- Use %%makeinstall macro.
- Remove code for old versions of openSUSE (<= 9.3)
- Remove AutoReqProv: it's default now.
- Remove calls to %%suse_update_config and autoconf, and do not set
  CFLAGS.
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Mon Apr 12 2010 mls@suse.de
- Add pkg-config-reqprov.patch to support automatic pkgconfig
  dependency creation, upstream fdo#2458.
* Thu Jan 31 2008 rodrigo@suse.de
- Update to version 0.23:
  * Add support for setting sysroot through PKG_CONFIG_SYSROOT_DIR
    in the environment
  * Update included glib to 1.2.10
  * Other minor fixes, including a segfault
* Thu Feb  8 2007 sbrabec@suse.cz
- Updated to version 0.21:
  * Cosmetic fixes of from pkg.m4.
  * Documentation fixes.
  * Always add the Cflags from dependent packages.
  * Added internal pkg-config package.
- Fixed Obsoletes (#243508).
- Use --with-pc_path instead of environment variables.
* Mon Jan 29 2007 sbrabec@suse.cz
- Removed references to /opt/gnome.
- Simplified PKG_CONFIG_PATH (#235310).
- Added support for /usr/local/lib64.
* Wed Jan 17 2007 sbrabec@suse.cz
- Use macros after its definition (#235134).
* Tue Dec 19 2006 sbrabec@suse.cz
- Disabled indirect deps.
* Fri Sep  1 2006 sbrabec@suse.cz
- Package renamed to pkg-config.
- Spec file cleanup.
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 18 2006 sbrabec@suse.cz
- Updated to version 0.20.
* Mon Aug  1 2005 gekker@suse.de
- Add gnome and kde paths to /etc/profile.d/pkgconfig.*sh
* Thu Jul 28 2005 jpr@suse.de
- update to version 0.19
* Thu Jul 21 2005 gekker@suse.de
- Update to version 0.18.1
* Wed Jun  8 2005 sbrabec@suse.cz
- Added /usr/share/pkgconfig to filelist for released products.
* Tue May 24 2005 sbrabec@suse.cz
- Fixed buffer overflow in popthelp.c (#85433).
* Wed May 18 2005 sbrabec@suse.cz
- Enabled indirect dependencies.
* Tue May 17 2005 sbrabec@suse.cz
- Updated to version 0.17.2.
- Platform independent package support in PKG_CONFIG_PATH (#83201).
* Sat Dec 11 2004 schwab@suse.de
- Fix buffer underflow.
* Mon Aug  9 2004 ro@suse.de
- fixed profile.d snippets
* Tue Apr 20 2004 ro@suse.de
- added missing function declaration to pkg.h
* Mon Mar 22 2004 sbrabec@suse.cz
- Added /usr/local to PKG_CONFIG_PATH to simplify self compilation.
* Fri Jan 16 2004 pth@suse.de
- Quote PKG_CHECK_MODULES.
* Sat Jan 10 2004 adrian@suse.de
- add %%defattr
* Wed Jan 29 2003 hhetter@suse.de
- pkgconfig tool updated to version 0.15.0, from changes:
  * add PKG_CONFIG_LIBDIR for cross-compiling
  * add --libs-only-other/--cflags-only-other
  * apply man page fixes
  * C portability fix
  * fix to win32 build
* Thu Oct 24 2002 sbrabec@suse.cz
- Update to version 0.14.0.
* Mon Apr 15 2002 hhetter@suse.de
- updated to version 0.12.0 as of GNOME desktop beta3
* Thu Feb  7 2002 hhetter@suse.de
- updated to version 0.10.0
* Wed Feb  6 2002 coolo@suse.de
- use DESTDIR correctly
* Fri Feb  1 2002 coolo@suse.de
- use the %%suse_ macros to update for config.* and libtool,
  use %%_libdir
* Thu Sep 27 2001 hhetter@suse.de
- updated to version 0.8.0
  * documentation, man-page updates
  * portability fixes
* Wed Jul  4 2001 egger@suse.de
- Initial SuSE build.
