#
# spec file for package kdump
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%bcond_with calibrate

%if 0%{?is_opensuse}
%if 0%{suse_version} > 1500
%define distro_prefix tumbleweed.%{_arch}
%else
%define distro_prefix leap%{sle_version}.%{_arch}
%endif
%else
%if 0%{suse_version} >= 1600
%define distro_prefix alp%{suse_version}.%{_arch}
%else
%define distro_prefix sle%{sle_version}.%{_arch}
%endif
%endif

%ifarch aarch64
%define qemu qemu-arm qemu-uefi-aarch64
%else
%ifarch %arm
%define qemu qemu-arm
%else
%ifarch %ix86 x86_64
%define qemu qemu-x86
%else
%ifarch %power64
%define qemu qemu-ppc
%else
%ifarch riscv64
%define qemu qemu-extra
%else
%define qemu qemu-%{_target_cpu}
%endif
%endif
%endif
%endif
%endif

%define dracutlibdir %{_prefix}/lib/dracut

Name:           kdump
Version:        2.0.6+git25.g1dbf786
Release:        150600.3.14.1
Summary:        Kernel crash dump scripts and utilities
License:        GPL-2.0-or-later
Group:          System/Kernel
URL:            https://github.com/openSUSE/kdump
Source:         %{name}-%{version}.tar.xz
Source1:        calibrate.conf.all
BuildRequires:  asciidoc
BuildRequires:  cmake >= 3.7
BuildRequires:  gcc-c++
BuildRequires:  pkgconfig
BuildRequires:  util-linux-systemd
BuildRequires:  pkgconfig(systemd)
BuildRequires:  pkgconfig(udev)
#!BuildIgnore:  fop
%if %{with calibrate}
BuildRequires:  %qemu
BuildRequires:  dhcp-client
BuildRequires:  dracut >= 047
BuildRequires:  iputils
BuildRequires:  kernel-default
BuildRequires:  lftp
BuildRequires:  makedumpfile
BuildRequires:  openssh-clients
BuildRequires:  pciutils
BuildRequires:  procps
BuildRequires:  python3
%ifnarch s390x
BuildRequires:  qemu-ipxe
BuildRequires:  qemu-vgabios
%endif
%endif
Requires:       /usr/bin/sed
Requires:       dracut >= 047
Requires:       kexec-tools
Requires:       makedumpfile
%ifarch ppc64 ppc64le
Requires:       servicelog
BuildRequires:  servicelog
%endif

# FIXME: use proper Requires(pre/post/preun/...)
PreReq:         %fillup_prereq
PreReq:         /usr/bin/mkdir
PreReq:         /usr/bin/rm
PreReq:         /usr/bin/touch
Recommends:     cifs-utils
Recommends:     lftp
Recommends:     nfs-client
Recommends:     openssh-clients
Suggests:       mailx
# update should detect the split-off from kexec-tools
Provides:       kexec-tools:%{_initddir}/kdump
ExcludeArch:    s390 ppc %arm32
%if 0%{?sle_version}
ExcludeArch:    %ix86
%endif
%{?systemd_ordering}

%description
kdump is a package that includes several scripts for kdump, including
the kdump service and configuration files

The kernel package and this package are all that are required for a
crash dump to occur. However, if you wish to debug the crash dump
yourself you will need several debugging packages installed for each
kernel flavor and release you wish to debug.

For example, if you are debugging kernel-default, you will need:
- kernel-default-debuginfo
- kernel-default-devel
- kernel-default-devel-debuginfo

These packages are not needed to create the dump and can be installed
after a crash dump has occured.

%prep
%setup -q
cp %{SOURCE1} calibrate.conf.all

%build
export CXXFLAGS="%{optflags} -std=c++11"
%cmake \
%if %{with calibrate}
	-DCALIBRATE=ON
%else
	-DCALIBRATE=OFF
%endif

# run make directly instead of cmake_build, which would run make in parallel
# and try to group output, preventing any debugging output from qemu if it
# fails to exit
make VERBOSE=1

%check
%ctest

%install
%cmake_install
# empty directory
mkdir -p %{buildroot}%{_localstatedir}/crash
mkdir -p %{buildroot}%{_localstatedir}/lib/kdump

%if !%{with calibrate}
# get distro_prefix-prefixed lines from calibrate.conf.all
grep "^%distro_prefix:" calibrate.conf.all | cut -f 2- -d: > %{buildroot}/usr/lib/kdump/calibrate.conf
if ! test -s %{buildroot}/usr/lib/kdump/calibrate.conf; then
echo "no calibration data for %distro_prefix in calibrate.conf.all, see packaging/suse/calibrate/README"
false
fi
%else
# save the distro_prefix
echo "GENERATED_ON=%{distro_prefix}" >> %{buildroot}/usr/lib/kdump/calibrate.conf
echo "generated calibrate.conf:"
cat  %{buildroot}/usr/lib/kdump/calibrate.conf
%endif

# symlink for init script
ln -s %{_sbindir}/service %{buildroot}%{_sbindir}/rckdump

%pre
%service_add_pre kdump.service
%service_add_pre kdump-early.service
%service_add_pre kdump-notify.service
exit 0

%post
# change only permission if the file exists before /etc/sysconfig/kdump
# has been created from %%{_fillupdir}/sysconfig.kdump
change_permission=0
if [ ! -f %{_sysconfdir}/sysconfig/kdump ] ; then
    change_permission=1
fi
%{fillup_only -n kdump}
%service_add_post kdump.service
%service_add_post kdump-early.service
%service_add_post kdump-notify.service
# ensure newly added kdump-*.service is-enabled matches prior state
if [ -x %{_bindir}/systemctl ] && %{_bindir}/systemctl is-enabled kdump.service &>/dev/null ; then
	%{_bindir}/systemctl reenable kdump.service || :
fi
if [ "$change_permission" = 1 ]; then
    chmod 0600 %{_sysconfdir}/sysconfig/kdump
fi
# if /var/log/dump is empty, make it a symlink to /var/crash
if test -d %{_localstatedir}/log/dump && rmdir %{_localstatedir}/log/dump >/dev/null 2>&1 ||
        ! test -d %{_localstatedir}/log/dump ; then
    ln -snf %{_localstatedir}/crash %{_localstatedir}/log/dump
fi
%ifarch ppc64 ppc64le
servicelog_notify --remove --command=/usr/lib/kdump/kdump-migrate-action.sh
servicelog_notify --add --command=/usr/lib/kdump/kdump-migrate-action.sh --match='refcode="#MIGRATE" and serviceable=0' --type=EVENT --method=pairs_stdin
%endif
exit 0

%preun
%ifarch ppc64 ppc64le
if [ $1 -eq 0 ]; then
	# removal, not upgrade
	servicelog_notify --remove --command=/usr/lib/kdump/kdump-migrate-action.sh
fi
%endif
echo "Stopping kdump ..."
%service_del_preun kdump.service
%service_del_preun kdump-early.service
%service_del_preun kdump-notify.service
exit 0

%postun
if [ $1 -gt 0 ]; then
	# upgrade
	# force regeneration of kdumprd
	touch %{_sysconfdir}/sysconfig/kdump
else
	# removal
	# delete symbolic link
	rm %{_localstatedir}/log/dump >/dev/null 2>&1 || true
fi
%service_del_postun kdump.service
%service_del_postun kdump-early.service
%service_del_postun kdump-notify.service
exit 0

%files
%defattr(-,root,root)
%license COPYING
%doc README NEWS
%{_sbindir}/kdumptool
%{_sbindir}/mkdumprd
%{_mandir}/man5/kdump.5%{?ext_man}
%{_mandir}/man7/kdump.7%{?ext_man}
%{_mandir}/man8/mkdumprd.8%{?ext_man}
%{_fillupdir}/sysconfig.kdump
%dir %{dracutlibdir}
%dir %{dracutlibdir}/modules.d
%{dracutlibdir}/modules.d/*
%dir /usr/lib/kdump
/usr/lib/kdump/*
%{_unitdir}/kdump.service
%{_unitdir}/kdump-early.service
%{_unitdir}/kdump-notify.service
%{_sbindir}/rckdump
%dir /var/lib/kdump

%changelog
* Tue Mar  4 2025 jbohac@suse.com
- upgrade to version kdump-2.0.6+git25.g1dbf786
  * fix bonding options (bsc#1235933)
  * don't use wicked to read bond and bridge config (bsc#1235933)
  * prevent KDUMP_NET_TIMEOUT busy loop when DNS fails
  * limit dump file permissions (bsc#1237497, bsc#1237529)
* Fri Feb  7 2025 jbohac@suse.com
- upgrade to version kdump-2.0.6+git20.gf8ecc01:
  * fix KDUMP_AUTO_RESIZE (bsc#1236921)
* Fri Jan 31 2025 jbohac@suse.com
- upgrade to version kdump-2.0.6+git20.gf8ecc01:
  * dracut: fix filtering ro keys in kdump_bond_config (bsc#1233137)
* Tue Jan  7 2025 jbohac@suse.com
- upgrade to version kdump-2.0.6+git19.ge6e33ae:
  * allow negative KDUMP_KEEP_OLD_DUMPS (bsc#1234845)
* Wed May 15 2024 jbohac@suse.com
- upgrade to version kdump-2.0.6+git18.g6fc4531:
  * fadump: use fadump=nocma when user data not filtered out (bsc#1224214)
  * spec: differentiate between uninstall and upgrade in postun/preun (bsc#1191410)
  * spec: return success from pre, post, preun and postun scriplets
    (bsc#1222228)
  * fix spec file BuildRequires for calibraiton builds
  * update calibrate values for SLE-15-SP6
* Thu Mar 28 2024 jbohac@suse.com
- upgrade to version 2.0.3+git10.gfdb71b2
  * add a note to README.txt about the flattened format (bsc#1221374)
  * use the same persistent device links as dracut (bsc#1222009, bsc#1219471)
  * remove dracut parse-root.sh hook (bsc#1221288)
* Wed Mar  6 2024 jbohac@suse.com
- upgrade to version 2.0.1+git9.gbab000b:
  * prevent mounting root in fadump (bsc#1219958)
* Fri Feb 16 2024 jbohac@suse.com
- branched off SLE-15-SP6
- upgrade to version 2.0.1+git2.g4335432:
  * always use nr_cpus, not maxcpus (bsc#1218180)
* Thu Jan 18 2024 jbohac@suse.com
- upgrade to version 2.0.1
  * load.sh: fix fadump (bsc#1218589)
* Sat Dec 16 2023 schwab@suse.de
- Update calibrate values for riscv64
* Wed Dec 13 2023 jbohac@suse.com
- upgrade to version 2.0.0
  * add support for riscv64 (bsc#1204214)
  * mkdumprd: fix the check for updated SSH keys
  * prefer by-path and device-mapper aliases (bsc#1217617)
  * udev: don't reload kdump if kernel handles hotplug (jsc#PED-5077)
* Tue Oct 31 2023 jbohac@suse.com
- upgrade to version 1.9.8
  * drop obsolete dependency on systemd-sysvinit (bsc#1216745)
* Tue Oct 17 2023 jbohac@suse.com
- upgrade to version 1.9.7
  * prevent dracut emergency shell
  * s390: consolidate low-level network configuration with zdev
  * s390: Explicitly request zFCP devices
* Wed Sep  6 2023 jbohac@suse.com
- update calibrate values, newly added SLE15-SP6 values
* Fri Aug 25 2023 jbohac@suse.com
- upgrade to version 1.9.6
  * use newer /sys/kernel/fadump/ instead of /sys/kernel/fadump_
  * use kexec -a which falls back to kexec_load(2) automatically
  * update s390 udev rules
  * drop systemd device timeout generator
* Fri Jul 28 2023 jbohac@suse.com
- upgrade to version 1.9.5
  * SELinux: temporary hack for bsc#1213721
* Thu Jul 27 2023 jbohac@suse.com
- upgrade to version 1.9.4
  * fix FADUMP initramfs when not created by mkdumprd
  * FADUMP: let dracut de-duplicate initrd by preserving modification times
  * mkdumprd: only regenerate FADUMP initrds when needed
  * mkdumprd: exit when destination not writable (transactional updates)
  * mkdumprd: don't call update-bootloader
* Wed Jun 28 2023 jbohac@suse.com
- upgrade to version 1.9.3
  * fix calibrate
  * update kdump(7) manpage
  * turn missing ssh, lftp or host key into a fatal error
  * depend on openssh-clients not openssh
- refreshed calibrate values
* Wed Jun 14 2023 jbohac@suse.com
- upgrade to version 1.9.2
  * adapt kdumptool to work with YaST
  * wait for SMTP server to become reachable
* Wed Jun 14 2023 jbohac@suse.com
- upgrade to version 1.9.1
  * reimplement e-mail notifications
* Thu Jun  8 2023 jbohac@suse.com
- upgrade to version 1.9
  * complete rewrite of kdump-save and parts of initrd generation
  * mounts are now entirely handled by dracut
  * deprecated: split dumps (saving to more than one targets at once)
  * deprecated: KDUMPTOOL_FLAGS option removed; original XENALLDOMAINS is now
    the default, disable with MAKEDUMPFILE_OPTIONS=-X
  * deprecated: notification e-mails
  * deprecated: copying of the kernel image (KDUMP_COPY_KERNEL)
  * FTP and SFTP are now handled by lftp, added to the spec file as Recommends:
  * SSH and SFTP now support passwords provided in the URL
  * fixed KDUMP_SSH_HOST_KEY, now needs to include the key type
  * new KDUMP_DUMPFORMAT=raw, will save an unmodified /proc/vmcore
  * the output directory name is now YYYY-MM-DD-HH-MM, i.e. the separator between
    HH and MM changed
  * unified default KDUMP_SAVEDIR across config, code and man to /var/crash
  * ping is now used to detect network is up; disable with KDUMP_NET_TIMEOUT=0
  * all the yes/no options changed to true/false; yes/no/1/0 still accepted
  * put the kdump initrd in /var/lib/kdump/initrd
  * use default kernel symlink (/boot/vmlinuz) instead of kernel autodetection
  * KDUMP_KERNELVER can specify an absolute path to a kernel image
  * improved mkdumprd detection of changed settings
  * removed all of kdumptool except the calibrate subcommand
  * cleaned up dependencies (ssh now only Recommended)
* Wed May 31 2023 jbohac@suse.com
- bumped version update to v1.0.3
* Wed May 24 2023 jbohac@suse.com
- Honor the KDUMP_VERBOSE setting in kdump-save
- fix distro prefix for ALP
- add calibrate values for ALP (copied from TW)
* Sat Feb 25 2023 petr@tesarici.cz
- add calibrate values for Leap 15.5
* Fri Feb 24 2023 jbohac@suse.com
- revert back to using rd.neednet=1 to enable network (bsc#1206015)
- kdumptool calibrate: add even more margin to reservation
  calculations (bsc#1207061)
- don't skip infiniband interfaces (bsc#1186745)
  (not a complete fix, requires a patch in dracut as well)
* Sat Jan 21 2023 jbohac@suse.com
- Run kdump.service only after kdump-early.service is done
  (boo#1196335)
- fixed calibrate build on s390
- minor fixes
* Tue Jan 10 2023 jbohac@suse.com
- improve the generation of calibrate.conf
  * print the qemu messages and trackrss log during calibrate
  * use static IP address for calibration
  * all calibrate.conf variants now stored in a single file
  * added a README and a helper script for updating calibrate.conf
  * prevent dracut from running emergency shell
  * fix s390x build dependencies
- fix deleting of a temporary file in dracut/module-setup.sh
- look for nsswitch.conf in /etc and /usr/etc
- never run a debugging shell when KDUMP_CONTINUE_ON_ERROR is set
- remove build dependency for wicked
- fix package summary in the spec file
* Tue Dec  6 2022 jbohac@suse.com
- maintain the spec file in git
* Fri Nov 25 2022 jbohac@suse.com
- Make the kdump-save.service reboot after kdump-save is finished
  (bsc#1204000)
* Tue Nov 22 2022 jbohac@suse.com
- fix renaming of qeth interfaces (bsc#1204743, bsc#1144337)
- ppc64: rebuild initrd image after migration (bsc#1191410)
- kdumptool calibrate: modify fadump suggestions (jsc#IBM-1027)
* Thu Sep 29 2022 dmueller@suse.com
- update to kdump-1.0.2+git20:
  * Use inst_binary to install kdump-save
* Thu Sep 29 2022 dmueller@suse.com
- disable build on arm 32bit (bsc#1203888)
* Wed Aug 31 2022 jbohac@suse.com
- mkdumprd: replace mkinitrd with native dracut (bsc#1202443)
* Fri Jul  8 2022 jbohac@suse.com
- fix network-related dracut options handling for fadump case
- drop the elevator=deadline kernel option (bsc#1193211)
- fix broken URL in manpage (bsc#1187312)
* Wed May  4 2022 jbohac@suse.com
- kdumptool calibrate: add more margin to reservation calculations
  (bsc#1196728)
* Tue Apr 12 2022 jbohac@suse.com
- remount filesystem r/w for fadump (bsc#1197125)
- stop reloading FADump on CPU hot-add event
* Thu Mar 31 2022 jbohac@suse.com
- pull sources directly from git using obs_scm
- fix bsc#1190299, bsc#1186272
- add support for Zstandard compression algorithm
- remove patches included in upstream git:
  kdump-calibrate-include-af_packet.patch,
  kdump-calibrate-fix-nic-naming.patch,
  kdump-calibrate.conf-depends-on-kdumptool.patch
* Tue Feb  8 2022 ptesarik@suse.com
- Exclude i586 from SLE builds.
* Tue Feb  1 2022 ptesarik@suse.com
- kdump-calibrate.conf-depends-on-kdumptool.patch: calibrate.conf:
  Add dependency on kdumptool.
- kdump-calibrate-fix-nic-naming.patch: calibrate: Fix network
  interface naming.
- kdump-calibrate-include-af_packet.patch: calibrate: Explicitly
  include af_packet in the test initrd.
* Tue Feb  1 2022 ptesarik@suse.com
- Update to 1.0.2
  * Adjust crash kernel reservation at boot time (jsc#SLE-18441).
- All remaining patches have been upstreamed:
  * kdump-fillupdir-fixes.patch
  * kdump-use-pbl.patch
  * kdump-calibrate-Ignore-malformed-VMCOREINFO.patch
* Fri Jan 21 2022 ptesarik@suse.com
- kdump-calibrate-Ignore-malformed-VMCOREINFO.patch: calibrate:
  Ignore malformed VMCOREINFO lines (address occasional OBS build
  failures).
* Fri Jan 21 2022 ptesarik@suse.com
- Update to 1.0
  * Estimate kdump memory requirements at build time
    (jsc#SLE-18441).
- Remove patches that have been upstreamed:
  * kdump-0.9.2-mkdumprd-properly-pass-compression-params.patch
* Mon Jan  3 2022 lpechacek@suse.com
- kdump-0.9.2-mkdumprd-properly-pass-compression-params.patch: Fix
  malformation in passing Dracut compression parameters in mkdumprd
  (bsc#1193765).
- Refresh existing patches.
* Thu Dec  9 2021 ptesarik@suse.com
- Sync with SLE15-SP4 changelog. These patches were never applied
  to Factory:
  * kdump-avoid-endless-loop-EAI_AGAIN.patch
  * kdump-calibrate-Add-LUKS2-Argon2-requirements-to-the-reser.patch
  * kdump-calibrate-Fix-kernel-command-line-parsing.patch
  * kdump-do-not-add-rd.neednet.patch
  * kdump-Do-not-list-all-block-devices-if-no-block-devices-ar.patch
  * kdump-ensure-initrd.target.wants-directory.patch
  * kdump-Enumerate-all-BTRFS-devices-for-btrfs-mount-points.patch
  * kdump-Implement-KString-isHexNumber.patch
  * kdump-install-etc-resolv.conf-using-resolved-path.patch
  * kdump-Mount-and-device-resolution-using-libmount-and-lsblk.patch
  * kdump-remove-console-hvc0-from-commandline.patch
  * kdump-set-serial-console-from-Xen-cmdline.patch
* Wed Dec  8 2021 ptesarik@suse.com
- Update to 0.9.2
  * Isolate fadump initrd within the default one (jsc#SLE-18272)
  * Bug fixes
  * Code cleanups
- Remove patches that have been upstreamed:
  * kdump-mounts.cc-Include-sys-ioctl.h.patch
  * kdump-Add-bootdev-to-dracut-command-line.patch
  * kdump-do-not-iterate-past-end-of-string.patch
  * kdump-fix-incorrect-exit-code-checking.patch
  * kdump-avoid-endless-loop-on-EAI_AGAIN.patch
  * kdump-install-real-resolv.conf.patch
  * kdump-Store-kdump-initrd-in-kernel-image-path.patch
- Remove patches that have been solved differently:
  * kdump-on-error-option-yesno.patch
* Thu Nov 25 2021 ptesarik@suse.com
- kdump-Store-kdump-initrd-in-kernel-image-path.patch: Fix kdumprd
  location for usrmerge kernels (boo#1190920).
* Fri May 28 2021 ptesarik@suse.com
- Fix use of DNS in the panic environment (bsc#1183070):
  * kdump-avoid-endless-loop-on-EAI_AGAIN.patch: Avoid an endless
    loop when resolving a hostname fails with EAI_AGAIN.
  * kdump-install-real-resolv.conf.patch: Install /etc/resolv.conf
    using its resolved path.
* Fri May 28 2021 ptesarik@suse.com
- kdump-fix-incorrect-exit-code-checking.patch: Fix incorrect exit
  code checking after "local" with assignment (bsc#1184616,
  LTC#192282)
* Fri May 28 2021 ptesarik@suse.com
- kdump-do-not-iterate-past-end-of-string.patch: Fix a crash caused
  by iterating past end of string (bsc#1186037).
* Thu Apr  8 2021 ptesarik@suse.com
- kdump-Add-bootdev-to-dracut-command-line.patch: Add 'bootdev=' to
  dracut command line (bsc#1182309).
* Fri Mar  5 2021 ptesarik@suse.com
- kdump-mounts.cc-Include-sys-ioctl.h.patch: mounts.cc: Include
  <sys/ioctl.h>.
* Fri Mar  5 2021 ptesarik@suse.com
- Update to 0.9.1
  * Add build dependency on libmount
  * Drop build dependency on OpenSSL
  * Build with --stdc=c++11
  * Bug fixes (bsc#1173914, bsc#1177196, bsc#1180513)
- Remove patches that have been upstreamed:
  * kdump-block-initrd-parse-etc.service.patch
  * kdump-fadump-avoid-multipath-optimizations.patch
  * kdump-split-cmdline-purpose-wise.patch
  * kdump-fadump-fix-network-bring-up.patch
  * kdump-fadump-add-udev-support.patch
  * kdump-turn-off-NUMA-in-kdump-kernel.patch
  * kdump-remove-noefi-and-acpi_rsdp-for-efi-firmware.patch
  * kdump-Restore-only-static-routes-in-kdump-initrd.patch
  * kdump-fallback-re-register-fadump-from-userspace.patch
  * kdump-recover-from-missing-CRASHTIME.patch
  * kdump-fix-multipath-user_friendly_names.patch
  * kdump-Add-skip_balance-option-to-BTRFS-mounts.patch
  * kdump-kdumprd-Look-for-boot-image-and-boot-Image.patch
  * kdump-savedump-search-also-for-vmlinux.xz.patch
  * kdump-preserve-white-space.patch
  * kdump-Clean-up-the-use-of-current-vs-boot-network-iface.patch
  * kdump-Use-a-custom-namespace-for-physical-NICs.patch
  * kdump-clean-up-kdump-mount-points.patch
  * kdump-skip-mounts-if-no-proc-vmcore.patch
  * kdump-nss-modules.patch
  * kdump-Add-force-option-to-KDUMP_NETCONFIG.patch
  * kdump-Add-fence_kdump_send-when-fence-agents-installed.patch
  * kdump-FENCE_KDUMP_SEND-variable.patch
  * kdump-Document-fence_kdump_send.patch
  * kdump-powerpc-no-reload-on-CPU-removal.patch
  * kdump-prefer-by-path-and-device-mapper.patch
  * kdump-calibrate-Update-values.patch
  * kdump-activate-udev-rules-late-during-boot.patch
  * kdump-make-sure-that-the-udev-runtime-directory-exists.patch
  * kdump-make-sure-that-initrd.target.wants-directory-exists.patch
  * kdump-check-explicit-ip-options.patch
  * kdump-query-systemd-network.service.patch
* Fri Mar  5 2021 ptesarik@suse.com
- kdump-query-systemd-network.service.patch: Query systemd
  network.service to find out if wicked is used (bsc#1182309).
- kdump-check-explicit-ip-options.patch: Do not add
  network-related dracut options if ip= is set explicitly
  (bsc#1182309).
* Tue Sep 22 2020 jslaby@suse.com
- add kdump-make-sure-that-initrd.target.wants-directory-exists.patch
  (bsc#1172670)
- clean up spec file
  * systemd is available on all distros the package builds on
  * use %%cmake* macros for build/test/install
- use %%systemd_ordering only if defined
- it now builds as back as SLE 12
* Tue Jul 21 2020 kukuk@suse.com
- Make dracut and sed normal requires as we don't use them in
  %%pre/%%post install. Use file requires for sed.
* Thu Jun  4 2020 kukuk@suse.com
- Don't PreRequire coreutils but the tools we really need
* Mon Mar 30 2020 ptesarik@suse.com
- kdump-make-sure-that-the-udev-runtime-directory-exists.patch:
  Make sure that the udev runtime directory exists (bsc#1164713).
* Mon Jan 27 2020 mwilck@suse.com
- kdump-activate-udev-rules-late-during-boot.patch: Activate
  kdump udev rules late during boot (bsc#1154837)
* Fri Jan 24 2020 dimstar@opensuse.org
- Use BuildRequire(udev) instead of udev: allow OBS to shortcut
  through the -mini flavors.
- Use systemd_ordering instead of systemd_requires: systemd is not
  a strict requirement, but if the system is going to use it, we
  want it to beinstalled prior to kdump.
* Tue Dec 17 2019 ptesarik@suse.com
- kdump-calibrate-Update-values.patch: calibrate: Update values
  (bsc#1130529).
* Tue Dec 17 2019 ptesarik@suse.com
- kdump-prefer-by-path-and-device-mapper.patch: Prefer by-path and
  device-mapper aliases over kernel device names (bsc#1101149,
  LTC#168532).
* Fri Dec 13 2019 ptesarik@suse.com
- kdump-powerpc-no-reload-on-CPU-removal.patch: powerpc: Do not
  reload on CPU hot removal (bsc#1133407, LTC#176111).
* Fri Dec 13 2019 ptesarik@suse.com
- kdump-Add-force-option-to-KDUMP_NETCONFIG.patch: Add ":force"
  option to KDUMP_NETCONFIG (bsc#1108919).
- kdump-Add-fence_kdump_send-when-fence-agents-installed.patch: Add
  fence_kdump_send when fence-agents installed (bsc#1108919).
- kdump-FENCE_KDUMP_SEND-variable.patch: Use var for path of
  fence_kdump_send and remove the unnecessary PRESCRIPT check
  (bsc#1108919).
- kdump-Document-fence_kdump_send.patch: Document kdump behaviour
  for fence_kdump_send (bsc#1108919).
* Mon Dec  9 2019 ptesarik@suse.com
- kdump-nss-modules.patch: Improve the handling of NSS
  (bsc#1021846).
* Mon Dec  9 2019 ptesarik@suse.com
- kdump-skip-mounts-if-no-proc-vmcore.patch: Skip kdump-related
  mounts if there is no /proc/vmcore (bsc#1102252, bsc#1125011).
- kdump-clean-up-kdump-mount-points.patch: Make sure that kdump
  mount points are cleaned up (bsc#1102252, bsc#1125011).
* Fri Dec  6 2019 ptesarik@suse.com
- kdump-Clean-up-the-use-of-current-vs-boot-network-iface.patch:
  Clean up the use of current vs. boot network interface names
  (bsc#1094444, bsc#1116463, bsc#1141064).
- kdump-Use-a-custom-namespace-for-physical-NICs.patch: Use a
  custom namespace for physical NICs (bsc#1094444, bsc#1116463,
  bsc#1141064).
* Fri Dec  6 2019 ptesarik@suse.com
- kdump-preserve-white-space.patch: Preserve white space when
  removing kernel command line options (bsc#1117652).
* Tue Nov 12 2019 jslaby@suse.com
- add kdump-savedump-search-also-for-vmlinux.xz.patch (bnc#1155921)
* Wed Jun 12 2019 dimstar@opensuse.org
- BuildRequire pkgconfig(systemd) instead of systemd: allow OBS to
  shortcut the build queues by allowing usage of systemd-mini
* Fri Apr 26 2019 ptesarik@suse.com
- kdump-kdumprd-Look-for-boot-image-and-boot-Image.patch: kdumprd:
  Look for /boot/image-* and /boot/Image-* (bsc#1132799).
* Tue Apr 16 2019 ptesarik@suse.com
- kdump-Add-skip_balance-option-to-BTRFS-mounts.patch: Add
  skip_balance option to BTRFS mounts (bsc#1108255).
* Wed Mar 20 2019 ptesarik@suse.com
- Use %%license instead of %%doc (bsc#1082318, bsc#1129947).
* Wed Mar 20 2019 ptesarik@suse.com
- kdump-fix-multipath-user_friendly_names.patch: Fix multipath
  configuration with user_friendly_names and/or aliases
  (bsc#1111207, LTC#171953, bsc#1125218, LTC#175465).
* Wed Mar 20 2019 ptesarik@suse.com
- kdump-recover-from-missing-CRASHTIME.patch: Recover from missing
  CRASHTIME= in VMCOREINFO (bsc#1112387).
* Wed Mar 20 2019 ptesarik@suse.com
- kdump-fallback-re-register-fadump-from-userspace.patch:
  Re-register FADUMP from userspace if the kernel cannot do it
  (bsc#1108170, LTC#171288, bsc#1094016, LTC#168050)
* Wed Mar 20 2019 ptesarik@suse.com
- kdump-Restore-only-static-routes-in-kdump-initrd.patch: Restore
  only static routes in kdump initrd (bsc#1093795).
* Wed Mar 20 2019 ptesarik@suse.com
- kdump-on-error-option-yesno.patch: Support yes/no style for
  KDUMP_CONTINUE_ON_ERROR (bsc#1083155).
* Wed Mar 20 2019 ptesarik@suse.com
- kdump-use-pbl.patch: Replace obsolete perl-Bootloader library
  with a simpler script (bsc#1050349).
* Wed Mar 20 2019 ptesarik@suse.com
- Ensure added kdump-early.service is enabled properly after update
  (bsc#1021484).
* Thu Mar  7 2019 ptesarik@suse.com
- kdump-remove-noefi-and-acpi_rsdp-for-efi-firmware.patch: Remove
  noefi and acpi_rsdp for EFI firmware (bsc#1123940).
* Fri Oct  5 2018 ptesarik@suse.com
- kdump-turn-off-NUMA-in-kdump-kernel.patch: Turn off NUMA in the
  kdump kernel (bsc#1109784, bsc#1102609).
* Fri Oct  5 2018 ptesarik@suse.com
- kdump-fadump-add-udev-support.patch: fadump: add udev event
  support for fadump (bsc#1108170).
* Fri Oct  5 2018 ptesarik@suse.com
- kdump-fadump-avoid-multipath-optimizations.patch: fadump: avoid
  multipath optimizations that break regular boot (bsc#1101730).
- kdump-split-cmdline-purpose-wise.patch: cmdline: split kdump
  cmdline purpose wise (bsc#1101730).
- kdump-fadump-fix-network-bring-up.patch: fadump: fix network
  bring up issue during default boot (bsc#1101730).
* Wed May 16 2018 mbrugger@suse.com
- fix URL of upstream project
* Fri May  4 2018 ptesarik@suse.com
- kdump-block-initrd-parse-etc.service.patch: Block
  initrd-parse-etc.service until dump is saved (bsc#1091186).
* Fri May  4 2018 ptesarik@suse.com
- Remove kernel-ELF-aarch64: Included in upstream tarball.
* Thu May  3 2018 ptesarik@suse.com
- Update to 0.9.0
  o Remove support for mkinitrd(8).
- Drop patches now in mainline:
  o kdump-Don-t-split-by-default.patch
  o kdump-Dont-exit-even-if-initrd-is-not-built.patch
  o kdump-KDUMP_SSH_IDENTITY-cfg.patch
  o kdump-KDUMP_SSH_IDENTITY.patch
  o kdump-Limit-kdump-cpus-to-number-provided-by-config.patch
  o kdump-Routable-preferred-source-address.patch
  o kdump-URLTransfer-complete-target.patch
  o kdump-aarch64.patch
  o kdump-activate-QETH-devices.patch
  o kdump-additional-mounts-in-dracut-module.patch
  o kdump-always-copy-timezone.patch
  o kdump-always-kexec_load-if-kexec_file_load-fails.patch
  o kdump-always-pass-kernelver-to-dracut.patch
  o kdump-bail-out-if-no-default-interface.patch
  o kdump-bind-mount-sysroot.patch
  o kdump-bootloader-filter-out-KDUMPTOOL_FLAGS.patch
  o kdump-calibrate-adjust-sizeof-struct-page.patch
  o kdump-calibrate-do-not-add-KDUMP_PHYS_LOAD-to-RAM.patch
  o kdump-calibrate-update-kernel-text-data-size.patch
  o kdump-calibrate-update-user-space-requirements.patch
  o kdump-cmake-compat.patch
  o kdump-do-not-check-bind-mount.patch
  o kdump-do-not-free-fadump-memory-when-immediate-reboot-is-requested.patch
  o kdump-do-not-touch-dracut-vars-if-not-kdumprd.patch
  o kdump-explicitly-request-zFCP-devices.patch
  o kdump-fail-if-fadump-cannot-be-registered.patch
  o kdump-fix-m_threads-missing-initialization.patch
  o kdump-fix-missing-index-of-kdump_Host.patch
  o kdump-fix-save_dump-to-NFS.patch
  o kdump-fix-service-files.patch
  o kdump-invoke-subcommand-destructors-on-exit.patch
  o kdump-kdump_echo-and-kdump_logger-helpers.patch
  o kdump-move-class-SystemCPU-to-header-file.patch
  o kdump-multithreading-by-default.patch
  o kdump-no-crashkernel-in-Xen-PV-DomU.patch
  o kdump-no-xen-secondary-kernel.patch
  o kdump-nokaslr.patch
  o kdump-nsswitch.conf-filtering.patch
  o kdump-pass-IPv6-address-prefix-separately.patch
  o kdump-pass-all-IP-routes-to-kdump-environment.patch
  o kdump-pre-generate-mount-units.patch
  o kdump-prepend-IP-address.patch
  o kdump-remount-sysroot-readwrite.patch
  o kdump-remove-IPv6-brackets-for-getaddrinfo.patch
  o kdump-run-mkinitrd-if-fadump-is-active.patch
  o kdump-skip-IPv4-if-no-address.patch
  o kdump-source-save_dump.patch
  o kdump-treat-KDUMP_CPUS-0-as-all-available-CPUs.patch
  o kdump-try-both-kexec_load-and-kexec_file_load.patch
  o kdump-use-bus-id-to-identify-qeth-devices.patch
  o kdump-x86_64-kexec-file-syscall.patch
- Remove kdump-cmake-compat.patch: Since mkinitrd support has been
  removed, compatibility with SLE11 is no longer needed.
* Wed May  2 2018 ptesarik@suse.com
- kdump-do-not-touch-dracut-vars-if-not-kdumprd.patch: Do not touch
  any dracut variables when generating a non-kdump initrd
  (bsc#1091304).
* Fri Apr 20 2018 ptesarik@suse.com
- kdump-additional-mounts-in-dracut-module.patch: Handle additional
  mounts in the kdump dracut module (bsc#1089917).
- kdump-run-mkinitrd-if-fadump-is-active.patch: Run mkinitrd if
  fadump is active (bsc#1089917).
* Fri Apr  6 2018 ptesarik@suse.com
- kdump-pass-IPv6-address-prefix-separately.patch: IPv6 setup: pass
  address prefix in separate dracut arg (bsc#1062026).
- kdump-pass-all-IP-routes-to-kdump-environment.patch: IP setup:
  pass all routes to kdump environment (bsc#1062026).
- kdump-remove-IPv6-brackets-for-getaddrinfo.patch: Routable: do
  not pass bracketed IPv6 to getaddrinfo (bsc#1062026).
- kdump-skip-IPv4-if-no-address.patch: IP setup: don't bother with
  IPv4 if there are no addresses (bsc#1062026).
* Fri Apr  6 2018 ptesarik@suse.com
- kdump-use-bus-id-to-identify-qeth-devices.patch: Use bus id to
  identify qeth devices (bsc#1085617).
* Tue Mar 13 2018 ptesarik@suse.com
- kdump-always-copy-timezone.patch: Always copy timezone data into
  kdumprd (bsc#1081646).
* Tue Feb 27 2018 ptesarik@suse.com
- kdump-no-crashkernel-in-Xen-PV-DomU.patch: Do not reserve
  crashkernel on Xen PV DomU (bsc#989792).
* Tue Feb 27 2018 ptesarik@suse.com
- kdump-nokaslr.patch: Add 'nokaslr' to the kdump kernel command
  line (bsc#1075937).
* Fri Feb 23 2018 ptesarik@suse.com
- kdump-always-kexec_load-if-kexec_file_load-fails.patch: Try
  kexec_load(2) if kexec_file_load(2) fails for any reason
  (bsc#1080916).
* Thu Feb 22 2018 ptesarik@suse.com
- kdump-calibrate-do-not-add-KDUMP_PHYS_LOAD-to-RAM.patch:
  calibrate: Do not add KDUMP_PHYS_LOAD to required RAM.
- kdump-bootloader-filter-out-KDUMPTOOL_FLAGS.patch: bootloader:
  Filter out KDUMPTOOL_FLAGS (bsc#1072584).
* Fri Feb  9 2018 ptesarik@suse.com
- kdump-nsswitch.conf-filtering.patch
* Fri Feb  9 2018 ptesarik@suse.com
- kdump-fix-missing-index-of-kdump_Host.patch: Fix missing index of
  kdump_Host (bsc#1002617).
* Fri Feb  9 2018 ptesarik@suse.com
- kdump-bail-out-if-no-default-interface.patch: Bail out of
  kdump_check_net if no default interface is found (bsc#1058202).
* Thu Feb  8 2018 ptesarik@suse.com
- kdump-calibrate-adjust-sizeof-struct-page.patch: calibrate:
  Adjust sizeof(struct page).
- kdump-calibrate-update-kernel-text-data-size.patch: calibrate:
  Update kernel text+data size.
- kdump-calibrate-update-user-space-requirements.patch: calibrate:
  Update user-space requirements.
* Fri Jan 26 2018 ptesarik@suse.com
- kdump-fix-m_threads-missing-initialization.patch: Fix m_threads
  missing initialization (bsc#1047609).
* Tue Jan 16 2018 ptesarik@suse.com
- kdump-try-both-kexec_load-and-kexec_file_load.patch: Try both
  kexec_load(2) and kexec_file_load(2) (bsc#951144).
* Tue Jan 16 2018 ptesarik@suse.com
- kdump-kdump_echo-and-kdump_logger-helpers.patch: load.sh:
  introduce kdump_echo and kdump_logger helpers (bsc#951144).
* Mon Nov 27 2017 rbrown@suse.com
- Add kdump-fillupdir-fixes.patch and correct specfile to build
  with new fillupdir location
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Wed Nov 15 2017 msuchanek@suse.com
- kdump-Dont-exit-even-if-initrd-is-not-built.patch: fadump restart does not
  always rebuild initramfs but may need to re-register (bsc#1047781).
- kdump-Limit-kdump-cpus-to-number-provided-by-config.patch (bsc#1036223, bsc#1068234).
- kdump-Don-t-split-by-default.patch (bsc#1036223, bsc#1068234).
* Thu Jun 29 2017 ptesarik@suse.com
- kdump-activate-QETH-devices.patch: Activate QETH network devices
  (bsc#1038669).
* Tue Jun 27 2017 ptesarik@suse.com
- Drop kdump-do-not-reload-FADUMP-on-CPU-memory-hotplug.patch:
  Reload is needed even with fadmp (bsc#1040567).
* Mon Jun 26 2017 ptesarik@suse.com
- kdump-fail-if-fadump-cannot-be-registered.patch: Fail at startup
  if fadump cannot be registered (bsc#1040567).
- kdump-do-not-reload-FADUMP-on-CPU-memory-hotplug.patch: Do not
  reload on CPU/memory hotplug when using FADUMP (bsc#1040567).
* Fri Jun 23 2017 ptesarik@suse.com
- kdump-explicitly-request-zFCP-devices.patch: Explicitly request
  zFCP devices in kdump initrd (bsc#1008352).
* Fri Jun 23 2017 ptesarik@suse.com
- kdump-move-class-SystemCPU-to-header-file.patch: Move class
  SystemCPU to a header file (bsc#1036223).
- kdump-treat-KDUMP_CPUS-0-as-all-available-CPUs.patch: Treat
  KDUMP_CPUS=0 as "all available CPUs" (bsc#1036223).
- kdump-multithreading-by-default.patch: Use multithreading by
  default (bsc#1036223).
* Thu Jun 22 2017 ptesarik@suse.com
- kdump-fix-save_dump-to-NFS.patch: Fix save_dump to NFS targets
  (bsc#1045541).
- kdump-invoke-subcommand-destructors-on-exit.patch: Invoke
  subcommand destructors on exit (bsc#1045541).
* Fri Jun 16 2017 msuchanek@suse.com
- kdump-do-not-free-fadump-memory-when-immediate-reboot-is-requested.patch
  Releasing fadump memory can take a long time so skip it when
  rebooting anyway (bsc#1040610).
* Thu Jun 15 2017 msuchanek@suse.com
- kdump-do-not-check-bind-mount.patch: Do not request filesystem
  check on bind mounts (bsc#1034169).
- kdump-remount-sysroot-readwrite.patch: Also remount writable
  any mounts that were already mounted readonly by systemd
  (bsc#1034169).
* Wed Jun 14 2017 ptesarik@suse.com
- kdump-Routable-preferred-source-address.patch: Routable: parse
  and store preferred source address (FATE#321844).
- kdump-URLTransfer-complete-target.patch: Use the complete target
  URL for URLTransfer (FATE#321844).
- kdump-prepend-IP-address.patch: Prepend IP address to remote
  target subdirectory (FATE#321844).
* Thu Jun  8 2017 ptesarik@suse.com
- kdump-fix-service-files.patch: Fix kdump-related services
  (bsc#1021484).
* Thu Jun  8 2017 ptesarik@suse.com
- kernel-ELF-aarch64: Test data for aarch64 findkernel.
- kdump-KDUMP_SSH_IDENTITY.patch: Update with later upstream fixes.
* Wed Jun  7 2017 ptesarik@suse.com
- kdump-aarch64.patch: kdumptool: add aarch64 (bsc#1033464).
* Thu Jun  1 2017 msuchanek@suse.com
- kdump-source-save_dump.patch: save_dump.sh is designed to be
  sourced and has numerous toplevel return statements. Source it
  from the service definition as well to prevent bash complaints.
  (bcs#1034169).
* Wed May 17 2017 ptesarik@suse.com
- kdump-x86_64-kexec-file-syscall.patch: add -s on x86_64 for
  signature verification of kernel. (fate#315018, bsc#884453)
* Wed May 17 2017 ptesarik@suse.com
- kdump-bind-mount-sysroot.patch: Convert sysroot to a bind mount
  in kdump initrd (bsc#976864).
- kdump-pre-generate-mount-units.patch: Pre-generate kdump mount
  units (bsc#942895).
- kdump-always-pass-kernelver-to-dracut.patch: Always pass kernel
  version to dracut (bsc#900418).
- kdump-no-xen-secondary-kernel.patch: Avoid Xenlinux (aka
  traditional, Xenified or SUSE) kernels as kdump kernel
  (bsc#900418, bsc#974270).
* Tue May 16 2017 ptesarik@suse.com
- kdump-KDUMP_SSH_IDENTITY.patch: Add KDUMP_SSH_IDENTITY config
  option (FATE#321583).
- kdump-KDUMP_SSH_IDENTITY-cfg.patch: Add KDUMP_SSH_IDENTITY to the
  config file template (FATE#321583).
* Sat Feb 18 2017 kukuk@suse.de
- Don't require insserv if we use systemd
* Wed Oct  5 2016 ptesarik@suse.com
- Remove kdump-helpers from Provides. This was needed to allow
  upgrading in SLE10, but this distribution is discontinued now.
* Wed Oct  5 2016 ptesarik@suse.com
- kdump-cmake-compat.patch: Build fix for pre-3.0.2 cmake.
* Wed Oct  5 2016 ptesarik@suse.com
- Update to 0.8.16
  o Improve systemd integration (FATE#319020, bsc#900134,
    bsc#909515, bsc#936363, bsc#936475, bsc#936489, bsc#942895,
    bsc#943902, bsc#944606, bsc#947825, bsc#948913).
  o Use OpenSSH for SSH and SFTP (FATE#318874, bsc#917747).
  o Improve 'kdumptool calibrate' (FATE#318842, bsc#882082,
    bsc#947539, bsc#952141, bsc#953732).
  o Improve network initialization (bsc#943214, bsc#944201,
    bsc#980328).
  o Fix FADUMP with systemd (bsc#917846, bsc#923790, bsc#944699).
  o Fix saving to XFS (bsc#964206).
  o Use full path to dracut (bsc#989972, bsc#990200,
    CVE-2016-5759).
  o Documentation updates (bsc#987862, bsc#997104).
  o Various smaller fixes (bsc#905690, bsc#927451, bsc#932339,
    bsc#934581, bsc#941088, bsc#946242, bsc#948956, bsc#951844,
    bsc#952149, bsc#970708, bsc#973213, bsc#984799, bsc#986081).
- Drop patches now in mainline:
  o 0001-multipath-Write-proper-regex-into-multipath-conf.patch
  o kdump-add-IPv6-KDUMP_NETCONFIG-modes.patch
  o kdump-bootloader-grub2.patch
  o kdump-calibrate-systemd-initramfs.patch
  o kdump-calibrate-systemd-runtime.patch
  o kdump-count-const-slabs.patch
  o kdump-count-framebuffer.patch
  o kdump-enable-fadump-ppc64le.patch
  o kdump-fadump-bootloader-always.patch
  o kdump-fadump-keep-sysroot.patch
  o kdump-get-multipath-wwid-from-sysfs.patch
  o kdump-move-network-setup-to-module-setup.patch
  o kdump-remove-root-and-resume.patch
  o kdump-split-kdump_default_netdev.patch
  o kdump-systemd-support.patch
  o kdump-use-fstab-device.patch
- Drop obsolete patches:
  o kdump-0.8.15-fix-shebang.patch
* Thu Feb 11 2016 rguenther@suse.com
- explicitely build with -std=gnu++98
* Sun Nov 23 2014 ledest@gmail.com
- fix shebang in rc.kdump.functions
- add patches:
  * kdump-0.8.15-fix-shebang.patch
* Sun Nov  9 2014 ledest@gmail.com
- fix bashisms in post/postun scripts
* Fri Sep 26 2014 ptesarik@suse.cz
- kdump-enable-fadump-ppc64le.patch: Enable FADUMP on ppc64le
  (bsc#889192).
- kdump-fadump-bootloader-always.patch: Always turn on fadump if
  KDUMP_FADUMP is true (bsc#889192).
- kdump-bootloader-grub2.patch: kdump-Bootloader: add support for
  GRUB2 (bsc#889192).
- kdump-fadump-keep-sysroot.patch: Keep /sysroot mount point if
  fadump is on (bsc#889192).
- kdump-get-multipath-wwid-from-sysfs.patch: Refresh.
* Fri Sep 26 2014 ptesarik@suse.cz
- kdump-add-IPv6-KDUMP_NETCONFIG-modes.patch: Refresh: Fix ip
  error messages when KDUMP_NETCONFIG=auto (bnc#885897).
* Tue Sep 23 2014 ptesarik@suse.cz
- kdump-split-kdump_default_netdev.patch: Cleanup: Split
  kdump_default_netdev (bnc#885897).
- kdump-move-network-setup-to-module-setup.patch: Move dracut
  network command line to module-setup.sh (bnc#885897).
- kdump-add-IPv6-KDUMP_NETCONFIG-modes.patch: Add KDUMP_NETCONFIG
  modes to support IPv6 (bnc#885897).
* Mon Sep 22 2014 ptesarik@suse.cz
- kdump-get-multipath-wwid-from-sysfs.patch: Get required multipath
  wwids from sysfs (bnc#883883).
* Thu Sep 18 2014 ptesarik@suse.cz
- kdump-remove-root-and-resume.patch: Remove root= and resume= from
  the kdump kernel command line (bnc#883883).
- kdump-systemd-support.patch: Dracut-systemd support (bnc#883883).
- kdump-calibrate-systemd-runtime.patch: Calibrate: update
  user-space run-time requirements for systemd (bnc#883883).
- kdump-calibrate-systemd-initramfs.patch: Calibrate: update the
  initramfs size (bnc#883883).
* Tue Sep  9 2014 ptesarik@suse.cz
- kdump-count-const-slabs.patch: Add missing addition.
* Mon Sep  8 2014 ptesarik@suse.cz
- kdump-count-const-slabs.patch: Take constant-size slabs into
  account for "kdump calibrate" (bnc#879460).
* Mon Sep  8 2014 ptesarik@suse.cz
- kdump-count-framebuffer.patch: Take framebuffer size into account
  for "kdumptool calibrate" (bnc#879460).
* Fri Sep  5 2014 ptesarik@suse.cz
- kdump-use-fstab-device.patch: Use device from /etc/fstab to mount
  / and /boot (bnc#892451).
* Mon Sep  1 2014 juwolf@suse.com
- Write proper regex into multipath.conf to prevent syntax error there
  (bnc#883883)
  Add: 0001-multipath-Write-proper-regex-into-multipath-conf.patch
* Mon Aug 18 2014 ptesarik@suse.cz
- specfile: Remove call to mkinitrd_setup. With dracut, this is
  completely useless; with mkinitrd, the setup script is run
  automatically after a new mkinitrd script is installed.
* Fri Jul  4 2014 ptesarik@suse.cz
- Switch from mkinitrd to dracut for SLES12 and openSUSE > 13.1.
* Fri Jul  4 2014 ptesarik@suse.cz
- Update to 0.8.15
  o Disable memory cgroup in kdump kernel
  o Limit the number of CPUs on all architectures
  o Increase udevd memory requirements
  o If possible, use wicked to determine network mode
  o Take number of possible CPUs into account for calibrate
- kdump-disable-memory-cgroup.patch: Dropped.
* Mon Jun 16 2014 ptesarik@suse.cz
- kdump-disable-memory-cgroup.patch: disable memory cgroup in the
  kdump kernel (bnc#881091).
* Mon Jun 16 2014 ptesarik@suse.cz
- Update to 0.8.14
  o Disable ACPI memory hotplug in kdump kernel (bnc#881091).
  o Update kernel and initrd estimates
  o Install mount-kdump.sh to dracut module directory (bnc#881851).
- Remove version number from rpmlintrc.
* Fri May 30 2014 ptesarik@suse.cz
- Update to 0.8.13
  o Store current configuration if KDUMP_NETCONFIG is static
    (bnc#876212).
  o Modify kdump udev rules to work with systemd
    (bnc#874992, bnc#809209).
  o Support percent-encoded URLs for KDUMP_SAVEDIR (bnc#869590).
- kdump-fix-udev-rules.patch: Dropped.
- kdump-urldecode.patch: Dropped.
* Tue May 20 2014 ptesarik@suse.cz
- kdump-urldecode.patch: Perform percent decoding on target URL
  (bnc#869590).
* Mon May 19 2014 ptesarik@suse.cz
- kdump-fix-udev-rules.patch: Avoid entering failed state on CPU
  hotplug (bnc#874992, bnc#809209).
* Fri May 16 2014 ptesarik@suse.cz
- Update to 0.8.12
  o Add "ssh" target protocol to transfer the file over the
    standard input to a remote host using the standard ssh client
    (bnc#868704).
  o Prevent double mount of the root file system (bnc#875738).
  o Allow taking remote dumps without mounting any file systems
- specfile: update URL
* Mon May  5 2014 ptesarik@suse.cz
- Update to 0.8.11
  o Use fast xz compression with dracut (bnc#870549)
  o Mount boot/root partition only if needed
  o Copy required programs to the initrd (bnc#874571).
- kdump-0.8.10-dracut-xz-opt.patch: Dropped.
* Tue Apr 15 2014 ptesarik@suse.cz
- kdump-0.8.10-dracut-xz-opt.patch: Use fast xz compression with
  dracut (bnc#870549).
* Fri Mar 28 2014 ptesarik@suse.cz
- specfile cleanup: remove blocks for pre-openSUSE11.0
- fix location of the udev files (see sr 227790).
* Thu Mar 27 2014 ptesarik@suse.cz
- Update to 0.8.10
  o Support snappy compression algorithm (FATE#315726)
  o Improved algorithm for "calibrate"
  o Network support for dracut
  o Filter out DomU pages, when dumping a Xen virtualization host
    (bnc#864910)
  o Do not try to copy separate debuginfo files (bnc#869971)
  o Unit test for FilePath::listDir() (SUSE Test Initiative)
  o delete_dumps: ignore non-kdump directories (FATE#313185)
  o fixed the testsuite on non-x86
- include and run the test suite
- kdump-ledblink-background.patch: Dropped.
- kdump-initrd-network.patch: Dropped.
- kdump-0.8.10-detect-xen-dumps.patch: Dropped.
* Tue Mar 18 2014 ptesarik@suse.cz
- kdump-0.8.9-detect-xen-dumps.patch: fix uninitialized variable;
  without the fix, '-X' is (almost) always added.
* Tue Mar 18 2014 ptesarik@suse.cz
- drop dependency on dracut-network again, because this subpackage
  has been merged with the main dracut package
* Mon Mar 17 2014 ptesarik@suse.cz
- kdump-initrd-network.patch: fix KDUMP_NETCONFIG="auto"
* Mon Mar 17 2014 ptesarik@suse.cz
- add dependency on dracut-network in SLE12 and Factory
- kdump-initrd-network.patch: include dracut 'network' module if
  network is required
* Fri Mar 14 2014 ptesarik@suse.cz
- kdump-0.8.9-detect-xen-dumps.patch: Add '-X' to makedumpfile when
  dumping a Xen host (bnc#864910).
* Fri Mar 14 2014 ptesarik@suse.cz
- kdump-ledblink-background.patch: Run kdumptool in the background.
* Wed Mar  5 2014 juwolf@suse.com
- kdump-initrd-network.patch: Added dracut network activation in
  initrd to mkdumprd.
* Tue Mar  4 2014 juwolf@suse.com
- kdump-ledblink-background.patch: Fixed wrong argument for
  ledblink.
* Sun Mar  2 2014 ptesarik@suse.cz
- %%filelist simplified as suggested by tcech@suse.cz.
* Fri Feb 28 2014 ptesarik@suse.cz
- Update to 0.8.9
  o fix dracut support
  o fix dump save when /boot is not a mount point
- kdumptool_find_kernel.patch: Dropped.
* Fri Feb 28 2014 ptesarik@suse.cz
- Update to 0.8.8
  o dracut support
  o new kdumptool command: calibrate
  o new kdumptool flag: NOSPLIT
  o better support for SMP dumps
- kdump-0.8.7-bsp.patch: Dropped.
- kdump-0.8.7-calibrate.patch: Dropped.
- kdump-0.8.7-nr_cpus.patch: Dropped.
* Fri Feb 14 2014 ptesarik@suse.cz
- kdump-0.8.7-nr_cpus.patch: Use nr_cpus instead of maxcpus with
  recent kernels. (FATE#315725).
- kdump-0.8.7-bsp.patch: Add disable_cpu_apicid for BSP to the
  commandline (bnc#861981).
- kdump-0.8.7-calibrate.patch: Implement kdump memory calibration
  (FATE#315241).
* Fri Feb 14 2014 juwolf@suse.com
- Added patch kdumptool_find_kernel.patch: kdumptool argument order was
  wrong in debug mode
* Fri Jan 24 2014 mpost@suse.com
- Removed s390x from the list of excluded architectures.
* Mon Jan 13 2014 ptesarik@suse.cz
- Update to 0.8.7
  o Change libelf interface to elfutils (libelf1)
  o Fix parsing of command line options
  o New tests
  o Many code cleanups
* Fri Dec  6 2013 ptesarik@suse.cz
- Update to 0.8.6
  o IPv6 support (FATE 316563)
  o unmount filesystems before rebooting kdump environment
* Fri Sep 13 2013 ptesarik@suse.cz
- Update to 0.8.5
  o See NEWS for a complete list of changes.
- kdump.spec: add newly installed files
* Wed Sep  4 2013 fcrozat@suse.com
- Add kdump.service to properly handle kdump initscript with
  systemd.
* Wed Jan  2 2013 ptesarik@suse.cz
- Fix the broken package rename from kdump-helpers.
* Wed Jan  2 2013 ptesarik@suse.cz
- Update to 0.8.2
  o FATE#314283: kdump: log-only mode
  o checking of SSH keys
  o lots of cleanups and bugfixes
- Drop the following patches (included in upstream now):
  o kdump-fix-gcc46.diff
  o kdump-gcc47.patch
  o kdump-save-log
  o kdump-add-none-format
  o kdump-udev-rule
  o kdump-usrmerge.patch
- kdump-format-list: Dropped (wrong).
* Sun Oct  7 2012 crrodriguez@opensuse.org
- Since the /usr merge, the mkinitrd bits are broken
  since tools have changed locations.
- Recommend nfs-client and cifs-utils too.
* Wed Apr 11 2012 jeffm@suse.com.
- kdump: Add 'none' format
- kdump: Allow format to be a list
- kdump: Save dmesg during dump
- kdump: Use correct script location in udev rule
* Sat Mar 17 2012 dimstar@opensuse.org
- Add kdump-gcc47.patch: Fix build with gcc 4.7.
* Sun Jun  5 2011 bernhard@bwalle.de
- Fix build with gcc 4.6.
* Wed Apr 27 2011 jeffm@suse.de
- Updated description to reference packages required for debugging
  (bnc#690194).
* Fri Jan 23 2009 bwalle@suse.de
- Update to 0.8.1
  o Fix invalid syntax in CMakeLists.txt.
  o Fix manpage, the command is called read_ikconfig and not
    print_ikconfig (bnc #468782).
  o Remove the documentation about the non-working network
    configuration in Xen since that has been fixed meanwhile.
  o Make it possible to exit the shell spawned in the initrd with
    'exit' to boot in the kdump system for debugging.
* Wed Jan 14 2009 bwalle@suse.de
- Update to 0.8.0
  o Call asciidoc a2x with -L to fix manual page generation
    problems with asciidoc 8.3.x.
* Thu Dec 11 2008 bwalle@suse.de
- Add BuildIgnore for 'fop' which breaks the Java dependency
  that is not needed for asciidoc generating just manual pages
  (improve build speed).
* Wed Dec  3 2008 bwalle@suse.de
- Update to 0.7.4
  o Don't update bootloader in mkdumprd(8).
- Don't build on s390, s390x and ppc because there is no kdump
  on that architectures.
* Mon Nov 24 2008 bwalle@suse.de
- Update to 0.7.3
  o Document kdump problems on Xen.
  o Don't display the full mkinitrd output.
  o Warn about zero-size vmcore.
  o Default to the auto-detected kernel when mkdumprd is called
    without arguments instead of defaulting to the running kernel.
  o Parse VMCOREINFO_XEN when present with 'read_vmcoreinfo'.
  o Pass the kernel release of the crashed kernel via command line
    in case of Xen.
  o Improve error handling when no crash kernel release is
    available when saving the dump.
* Fri Nov 21 2008 bwalle@suse.de
- Update to 0.7.2
  o Don't use the FQDN but only the hostname to avoid DNS lookups
    and errors on wrongly configured systems (bnc#442830).
  o Fix empty KDUMP_SAVEDIR line when replacing the symbolic link
    with the absolute path.
  o Don't set sysctl kernel.unknown_nmi_panic=1 by default
    (bnc#388736).
  o Mention kernel.panic_on_unrecovered_nmi in the kdump(7)
    manpage.
* Thu Nov 20 2008 bwalle@suse.de
- Update to 0.7.1
  o Document 256M limit on ppc64 for large machines in kdump(7).
* Wed Nov 19 2008 bwalle@suse.de
- Only regenerate the initrd once after update. But make sure that
  it always gets regenerated.
- Update to 0.7.0
  o Add read_ikconfig command.
  o Add find_kernel command in kdumptool, replacing the find code
    in the init script. Needed to prefer the default kernel even
    if the maxcpus kernel (or a realtime kernel) is currently
    booted (bnc#444658).
  o Implement KDUMP_VERBOSE = 16 to debug kdump find_kernel.
  o Make boot.kdump dependent on boot.localnet to have a correct
    hostname (bnc#442830).
  o Fix stripping of the crashkernel command line again
    (bnc#444687).
  o Don't include test cases in the release tarball. They are
    very incomplete and contain too huge test data.
  o Honor TMPDIR and set that to disk space instead of the ramdisk
    when saving the dump in the initrd.
* Thu Nov 13 2008 bwalle@suse.de
- Update to 0.6.7
  o Strip the whole crashkernel option when loading the kdump
    kernel, not only parts of them, also when the extended
    crashkernel syntax has been used.
* Wed Nov 12 2008 bwalle@suse.de
- Update to 0.6.6
  o Fix wrong path when modifying the /etc/sysconfig/kdump file
    when creating the kdump initrd.
  o Prepend a space before MAKEDUMPFILE_OPTIONS so that there's
    always a space between command and the first argument.
  o Fix finding of the kernel image (/boot/vmlinuz) with rootdir.
* Tue Nov 11 2008 bwalle@suse.de
- Update to 0.6.5
  o Fix copying of debug info when --root is specified and the
    debug file resides in GLOBALDEBUGDIR/EXECDIR/DEBUGFILE
    (bnc#443828).
* Tue Nov 11 2008 bwalle@suse.de
- Fix string in %%preun (kexec -> kdump).
- Regenerate the kdump initrd on next startup after the kdump
  package has been updated.
* Sun Nov  2 2008 bwalle@suse.de
- Update to 0.6.4
  o change default location for KDUMP_SAVEDIR to "/var/crash"
  o actually check <version>-kdump before <version>-<flavour> when
    looking for a suitable kdump kernel
  o boot.kdump: Use the full kernel release (obtained with
    /sbin/get_kernel_version) to build the initrd name also when
    symlinks are used (bnc#438218)
  o Assume a default terminal size of 80x25 (for printing the
    horizontal line)
  o Check the exit status of kdumptool
  o Implement support for resolving symbolic links inside a root
    directory (--root=...) when saving the dump. (bnc#431492)
  o Don't print a (red) info message that email failed if both
    KDUMP_SMTP_SERVER and KDUMP_NOTIFICATION_TO are empty.
  o If KDUMP_SAVEDIR points to a local file, resolve symlinks when
    creating the initrd because in theory the file system that
    contains parts of the symlinks is not mounted in initrd.
  o Fix KDUMP_NETCONFIG=auto by calling mkinitrd with right
    parameters.
  o Create core dumps in the initrd when kdumptool crashes.
  o Fix std::logic_error in Email::send() that caused kdumptool to
    terminate unexpectedly.
  o Set the hostname of the SMTP session based on the --fqdn
    parameter.
  o Don't report a failure in the email when there is no one.
- Drop following patches (folded in 0.6.4):
  o kdump-2860e7a5d481633aca345b07db28d95fdb04d649
    Add documentation for "Extended crashkernel commandline"
  o kdump-56814cf5d03dff1d6233de996e79e1dd54cf5144
    boot.kdump: Use the full kernel release for initrd name
  o kdump-8580f201f2f759eb78c646a6b98727b4508101d3
    Reflect 'boot.kdump' in kdump(7)
  o kdump-8712f642965d13539148e385aefb805e3464b62d
    Actually check <version>-kdump before <version>-<flavour> when
    looking for a suitable kdump kernel
  o kdump-f4cf2ef3cc3e6414d7d9386de0ebf7d633cbfed5
    Change default location of KDUMP_SAVEDIR to "/var/crash"
* Tue Oct 28 2008 schwab@suse.de
- Fix %%post failure.
* Sun Oct 26 2008 bwalle@suse.de
- Use the full kernel release (obtained with get_kernel_version)
  to build the initrd name also when symlinks are used
  (bnc#438218).
* Wed Oct 22 2008 bwalle@suse.de
- Actually check <version>-kdump before <version>-<flavour> when
  looking for a suitable kdump kernel.
* Fri Oct 17 2008 bwalle@suse.de
- /etc/sysconfig/kdump should be only readable as root since it
  may contain passwords (bnc#436042).
* Wed Oct 15 2008 bwalle@suse.de
- Reflect 'boot.kdump' in kdump(7).
- Add rpmlintrc: The init script name is correct.
* Mon Oct 13 2008 bwalle@suse.de
- Add documentation for "Extended crashkernel commandline"
  (bnc#430276).
* Wed Sep  3 2008 crrodriguez@suse.de
- use RPM_OPT_FLAGS everywhere [FATE #300498]
* Sat Aug 23 2008 bwalle@suse.de
- /var/crash is now part of the filesystem RPM (removing %%dir)
* Mon Aug 18 2008 bwalle@suse.de
- also create /var/log/dump link when the /var/log/dump directory
  did not exist
- delete /var/log/dump link in %%postun
* Mon Aug 18 2008 bwalle@suse.de
- change default for KDUMP_SAVEDIR to "/var/crash"
* Fri Aug 15 2008 bwalle@suse.de
- update to 0.6.3
  o make the kdump init script a boot script ("boot.kdump")
  o fix init script comments
  o add meta information to manpages
* Tue Aug 12 2008 bwalle@suse.de
- update to 0.6.2
  o correct init script: remove remote FS dependency and also add
    "Should-Stop"
* Sat Aug  9 2008 bwalle@suse.de
- update to 0.6.1
  o add kdump(7) manual page
* Thu Aug  7 2008 bwalle@suse.de
- update to 0.6.0
  o add vmcore(5) manual page
  o implement email support
- use PreReq for mkinitrd instead of BuildRequires
* Mon Aug  4 2008 bwalle@suse.de
- Don't report ELF32 as "invalid ELF class"
* Fri Aug  1 2008 bwalle@suse.de
- update to 0.5.5
  o make dependency to libssh2 optional
* Thu Jul 31 2008 bwalle@suse.de
- update to 0.5.4
  o always create empty ${tmp_mnt}/etc/fstab.kdump
  o change execution state to 'boot'
  o use UUID for fstab.kdump
  o open a shell if something fails and KDUMP_CONTINUE_ON_ERROR is
    true
  o don't include JFS to initrd
  o don't add -s '' parameter to mkinitrd call if the boot splash
    script is not available
  o handle more programs in $KDUMP_REQUIRED_PROGRAMS correct
  o move original /etc/fstab back
- add %%config to udev rule
* Mon Jul 28 2008 bwalle@suse.de
- update to 0.5.3
  o don't exit with error code when the dump directory does not yet
    exist in the 'delete_dumps' command
  o fix syntax error in init/boot-kdump.sh
* Mon Jul 28 2008 bwalle@suse.de
- call mkinitrd_setup in %%post and %%postun
* Mon Jul 28 2008 bwalle@suse.de
- update to 0.5.2
  o copy required programs (KDUMP_REQUIRED_PROGRAMS) in initrd
  o mount dump partition and boot partition in initrd
  o don't exit with error code when the dump directory does not yet
    exist in the 'delete_dumps' command
* Thu Jul 24 2008 bwalle@suse.de
- update to 0.5.1
  o add 'print_target' sub command
  o implement SSH public/private key authentication
* Wed Jul 23 2008 bwalle@suse.de
- update to 0.5.0 (FATE #303043)
  o initrd-based dumping
  o basically rewrite
* Fri Jun 13 2008 bwalle@suse.de
- update to 0.3.4
  o try also $(uname -i) to find the makedumpfile.config in
    /usr/src/linux-${version}-obj/${arch}/${flavour}
  o filter "mem" kernel parameter before loading the kdump kernel
    (bnc#393324)
- delete kdump-clarify-README: merged in new version
- delete kdump-default-nmi: merged in new version
- delete kdump-reload-memory-hotplug: merged in new version
- delete kdump-fix-kernel-detection: merged in new version
* Sun Jun  1 2008 bwalle@suse.de
- set KDUMP_KERNELVER="" on i386 instead of KDUMP_KERNELVER="kdump"
  (with "kdump", the kdump kernel cannot be loaded without manually
  editing the configuration file (bnc#396221)
* Mon May 26 2008 bwalle@suse.de
- fix load of kdump kernel when KDUMP_KERNELVER="kdump" on ppc64
  (bnc#394216)
* Tue May 20 2008 bwalle@suse.de
- fix typo when checking the result of kdump_kernel_loaded
* Mon May 19 2008 bwalle@suse.de
- implement "try-restart" command and use that implementation also
  for "condrestart"
- add udev rules to reload kdump configuration on memory or CPU
  hotplug (bnc#389658)
- set panic_on_unrecovered_nmi only when it exists
* Tue May 13 2008 bwalle@suse.de
- set panic_on_unrecovered_nmi as default (bnc#388736)
* Fri Apr 18 2008 bwalle@suse.de
- clarified README that memory sizes are only recommended values
  (bnc#380577)
* Wed Feb 20 2008 bwalle@suse.de
- use "-o NumberOfPasswordPrompts=0 -o CheckHostIP=no -o
  StrictHostKeyChecking=no" when calling ssh because the user may
  not be able to confirm the questions (bnc#355973)
- require "$network" in init script so than when runlevel 3 is set
  in /etc/sysconfig/kdump, network is available to the kdump
  scripts (bnc#293171)
- update version to 0.2.3
* Sun Jan 13 2008 bwalle@suse.de
- don't add initrd blink stuff for openSUSE <= 10.2 because
  there was no modular initrd script
* Tue Jan  8 2008 bwalle@suse.de
- log the result of kexec call to avoid the impression that loading
  kdump kernel succeeded even if kexec terminated non-zero (350289)
- don't set kernel.panic_on_oops to 1 if kexec failed (350289)
- updated version to 0.3.2
- require kexec-tools
* Wed Dec 12 2007 bwalle@suse.de
- check the disk space afterwards if makedumpfile is used since
  it's not possible to know the dump image size in advance
- updated version to 0.3.1
* Mon Nov 12 2007 tiwai@suse.de
- fix PreReq for insserv and fillup
* Tue Nov  6 2007 bwalle@suse.de
- add "coreutils" and "sed" to PreReq to make rpmlint happy
* Thu Oct 11 2007 bwalle@suse.de
- rename kdump-helpers to kdump
- added GDB helpers, init script and sysconfig file
  (formerly all in the kexec-tools package)
- added README (formerly README.SUSE in the kexec-tools package)
- fix compile warning in src/read-debuglink.c
- log save message to syslog if $KDUMP_VERBOSE & 1 > 0 (#331118)
- improve algorithm for finding the kdump kernel
- updated version to 0.3.0
* Mon Sep  3 2007 bwalle@suse.de
- don't use locking for NFS (#307178)
* Wed Aug 29 2007 bwalle@suse.de
- added Recommends: makedumpfile
* Mon Aug 13 2007 bwalle@suse.de
- run bootloader after modifying initrd
* Fri Jul 27 2007 bwalle@suse.de
- update to 0.2.4 (#302257)
  o implement KDUMP_KEEP_OLD_DUMPS = -2 for deleting all dumps
    (except the latest, which is saved afterwards
* Mon Jul  2 2007 tiwai@suse.de
- changed from libelf to libelf0-devel in buildrequires.
* Mon Jun 18 2007 bwalle@suse.de
- update to 0.2.3
  o fixed read-debuglink
  o changed NFS URL, no separation between share and directory
  o added kdump-led_blink to blink LEDs (for broken VGA console)
  o added mkinitrd script (for blink) and /sbin/mkinitrd to
    %%postin and %%postun
* Mon Jun 11 2007 bwalle@suse.de
- update to 0.2.2
  o add read-debuglink
* Sun Jun 10 2007 bwalle@suse.de
- update to 0.2.1
  o add manpages for all programs
* Mon May 28 2007 bwalle@suse.de
- first version
