#
# spec file for package suse-module-tools
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

# missing in SLE15 (systemd-rpm-macros)
%{!?_modulesloaddir: %global _modulesloaddir /usr/lib/modules-load.d}

# Location for modprobe and depmod .conf files
%global modprobe_dir /lib/modprobe.d
%global depmod_dir /lib/depmod.d
%global with_boot_sysctl 1
%global dracutlibdir %{_prefix}/lib/dracut
%global sysctl_dropin %{_unitdir}/systemd-sysctl.service.d/50-kernel-uname_r.conf
%global systemd_units %{?with_boot_sysctl:boot-sysctl.service} %{?with_kernel_sysctl:kernel-sysctl.service}

# List of legacy file systems to be blacklisted by default
%global fs_blacklist adfs affs bfs befs cramfs efs erofs exofs f2fs freevxfs hfs hfsplus hpfs jffs2 jfs kafs minix nilfs2 ntfs ntfs3 omfs orangefs pstore qnx4 qnx6 reiserfs romfs sysv ufs zonefs

# List of all files installed under modprobe.d
# Note: this list contains files installed by previous versions, like 00-system-937216.conf!
%global modprobe_conf_files 00-system 00-system-937216 10-unsupported-modules 50-blacklist 60-blacklist_fs-* 99-local
%global modprobe_conf_rpmsave %(echo "%{modprobe_conf_files}" | sed 's,\\([^ ]*\\),%{_sysconfdir}/modprobe.d/\\1.conf.rpmsave,g')

Name:           suse-module-tools
Version:        15.6.11
Release:        150600.3.9.2
Summary:        Configuration for module loading and SUSE-specific utilities for KMPs
License:        GPL-2.0-or-later
Group:          System/Base
URL:            https://github.com/openSUSE/suse-module-tools
Source0:        %{name}-%{version}.tar.xz
Source1:        %{name}.rpmlintrc
BuildRequires:  systemd-rpm-macros
Requires:       /usr/bin/grep
Requires:       /usr/bin/gzip
Requires:       /usr/bin/sed
Requires:       coreutils
Requires:       findutils
Requires:       systemd-rpm-macros
Requires:       rpm
Requires:       util-linux
Requires(post): /usr/bin/grep
Requires(post): /usr/bin/sed
Requires(post): coreutils
Provides:       suse-kernel-rpm-scriptlets = 0
Provides:       udev-extra-rules = 0.3.0
Obsoletes:      udev-extra-rules < 0.3.0
Provides:       system-tuning-common-SUSE = 0.3.0
Obsoletes:      system-tuning-common-SUSE < 0.3.0
# Use weak dependencies for dracut and kmod in order to
# keep Ring0 lean. In normal deployments, these packages
# will be available anyway.
Recommends:     dracut
Recommends:     kmod
# This release requires the dracut module 90nvdimm
Conflicts:      dracut < 49.1
# SLE/Leap: conflict with usrmerge
Conflicts:      filesystem >= 16

%description
This package contains helper scripts for KMP installation and
uninstallation, as well as default configuration files for depmod and
modprobe.

%prep
%setup -q

%build
sed -i 's/@FS_BLACKLIST@.*/%{fs_blacklist}/' README.md

%install
install -d -m 755 "%{buildroot}%{modprobe_dir}"
install -d -m 755 "%{buildroot}%{_sysconfdir}/modprobe.d"

cat > "%{buildroot}%{_sysconfdir}/modprobe.d/README" <<EOF
Local configuration for modprobe(8)
===================================

The distribution-provided modprobe configuration files have moved to %{modprobe_dir}.
To modify the configuration, copy files from %{modprobe_dir} to this directory
(%{_sysconfdir}/modprobe.d) and edit them here.

See also %{modprobe_dir}/README, %{_defaultdocdir}/%{name}/README.md, and the
man page modprobe.d(5).
EOF

install -pm644 -t "%{buildroot}%{modprobe_dir}" modprobe.conf/common/*.conf
if [ -d modprobe.conf/%{_arch} ]; then
    install -pm644 -t "%{buildroot}%{modprobe_dir}" modprobe.conf/%{_arch}/*.conf
fi
%ifarch i386
install -pm644 -t "%{buildroot}%{modprobe_dir}" modprobe.conf/x86_64/*.conf
%endif
%ifarch ppc64le
install -pm644 -t "%{buildroot}%{modprobe_dir}" modprobe.conf/ppc64/*.conf
%endif

install -d -m 755 "%{buildroot}/%{depmod_dir}"
install -d -m 755 "%{buildroot}%{_sysconfdir}/depmod.d"
install -pm 644 "depmod-00-system.conf" "%{buildroot}%{depmod_dir}/00-system.conf"

# "/usr/lib/module-init-tools" name hardcoded in other packages
install -d -m 755 "%{buildroot}/usr/lib/module-init-tools"
install -pm 755 -t "%{buildroot}/usr/lib/module-init-tools/" \
	weak-modules2 driver-check.sh unblacklist lsinitrd-quick

# rpm macros and helper
# The RPM Macros have been moved to the package rpm-config-SUSE after CODE15, thus are no longer
# shipped here
install -d -m 755 "%{buildroot}%{_rpmmacrodir}"
install -pm 644 "macros.initrd" "%{buildroot}%{_rpmmacrodir}"
install -pm 755 "regenerate-initrd-posttrans" "%{buildroot}/usr/lib/module-init-tools/"
install -d -m 755 "%{buildroot}/usr/lib/module-init-tools/kernel-scriptlets"
install -pm 755 "kernel-scriptlets/cert-script" "%{buildroot}/usr/lib/module-init-tools/kernel-scriptlets"
install -pm 755 "kernel-scriptlets/inkmp-script" "%{buildroot}/usr/lib/module-init-tools/kernel-scriptlets"
install -pm 755 "kernel-scriptlets/kmp-script" "%{buildroot}/usr/lib/module-init-tools/kernel-scriptlets"
install -pm 755 "kernel-scriptlets/rpm-script" "%{buildroot}/usr/lib/module-init-tools/kernel-scriptlets"
for i in "pre" "preun" "post" "posttrans" "postun" ; do
    ln -s cert-script %{buildroot}/usr/lib/module-init-tools/kernel-scriptlets/cert-$i
    ln -s inkmp-script %{buildroot}/usr/lib/module-init-tools/kernel-scriptlets/inkmp-$i
    ln -s kmp-script %{buildroot}/usr/lib/module-init-tools/kernel-scriptlets/kmp-$i
    ln -s rpm-script %{buildroot}/usr/lib/module-init-tools/kernel-scriptlets/rpm-$i
done

install -d -m 755 %{buildroot}%{dracutlibdir}/dracut.conf.d
install -pm 644 10-unblacklist.conf %{buildroot}%{dracutlibdir}/dracut.conf.d
install -d -m 755 "%{buildroot}%{_prefix}/bin"
install -pm 755 kmp-install "%{buildroot}%{_bindir}/"

# systemd service(s) to load kernel-specific sysctl settings
install -d -m 755 "%{buildroot}%{_unitdir}/systemd-sysctl.service.d"
echo '[Unit]' >"%{buildroot}%{sysctl_dropin}"
%if %{with kernel_sysctl}
install -pm 644 kernel-sysctl.service "%{buildroot}%{_unitdir}"
echo 'Wants=kernel-sysctl.service' >>"%{buildroot}%{sysctl_dropin}"
%endif
%if %{with boot_sysctl}
install -pm 644 boot-sysctl.service "%{buildroot}%{_unitdir}"
echo 'Wants=boot-sysctl.service' >>"%{buildroot}%{sysctl_dropin}"
%endif

install -d -m 755 "%{buildroot}%{_modulesloaddir}"
for _x in modules-load.d/*.conf; do
    [ -e "$_x" ] || continue
    install -pm 644 -t "%{buildroot}%{_modulesloaddir}" "$_x"
done

%ifarch ppc64 ppc64le
install -d -m 755 %{buildroot}/usr/lib/systemd/system-generators
install -pm 755 udev-trigger-generator %{buildroot}/usr/lib/systemd/system-generators
%endif

# udev rules (formerly system-tuning-common-SUSE, udev-extra-rules)
install -d -m 755 %{buildroot}%{_udevrulesdir}
install -pm 644 udevrules/*.rules %{buildroot}%{_udevrulesdir}

mkdir -p %{buildroot}%{_defaultlicensedir}

for mod in %{fs_blacklist}; do
    echo "\
# DO NOT EDIT THIS FILE!
#
# The $mod file system is blacklisted by default because it isn't actively
# supported by SUSE.
blacklist $mod
# The filesystem can be un-blacklisted by running \"modprobe $mod\".
# See README.md in the %{name} package for details.
install $mod /usr/lib/module-init-tools/unblacklist $mod; /sbin/modprobe --ignore-install $mod
" \
	>%{buildroot}%{modprobe_dir}/60-blacklist_fs-"$mod".conf
done

%pre
%service_add_pre %{systemd_units}
# Avoid restoring old .rpmsave files in %posttrans
for f in %{modprobe_conf_rpmsave}; do
    if [ -f ${f} ]; then
	mv -f ${f} ${f}.%{name}
    fi
done
if [ -f %{_sysconfdir}/depmod.d/00-system.conf.rpmsave ]; then
    mv -f %{_sysconfdir}/depmod.d/00-system.conf.rpmsave \
          %{_sysconfdir}/depmod.d/00-system.conf.rpmsave.%{name}
fi
exit 0

%post
%udev_rules_update
%service_add_post %{systemd_units}
exit 0

%preun
%service_del_preun %{systemd_units}
exit 0

%postun
%udev_rules_update
%service_del_postun_without_restart %{systemd_units}
exit 0

%posttrans
# If the user had modified any of the configuration files installed under
# /etc, they'll now be renamed to .rpmsave files. Restore them.
for f in %{modprobe_conf_rpmsave}; do
    if [ -f ${f} ]; then
	mv -fv ${f} ${f%.rpmsave}
    fi
done
if [ -f %{_sysconfdir}/depmod.d/00-system.conf.rpmsave ]; then
    mv -fv %{_sysconfdir}/depmod.d/00-system.conf.rpmsave \
           %{_sysconfdir}/depmod.d/00-system.conf
fi
exit 0

%files
%defattr(-,root,root)

%license LICENSE
%doc README.md
%{modprobe_dir}
%dir %{_sysconfdir}/modprobe.d
%{depmod_dir}
%dir %{_sysconfdir}/depmod.d
%{_sysconfdir}/modprobe.d/README
%{_rpmmacrodir}/macros.initrd
%{_bindir}/kmp-install
/usr/lib/module-init-tools
%{_unitdir}/*.service
%{_unitdir}/systemd-sysctl.service.d
%{_modulesloaddir}
%{_udevrulesdir}
%dir %{dracutlibdir}
%{dracutlibdir}/dracut.conf.d
%ifarch ppc64 ppc64le
/usr/lib/systemd/system-generators
%endif

%changelog
* Mon Jul  7 2025 mwilck@suse.com
- Update to version 15.6.11:
  * spec file: add missing util-linux requirement (bsc#1241038)
  * regenerate-initrd-posttrans: Fix SKIP_REGENERATE_INITRD_ALL
  (bsc#1228929)
* Mon Jun 24 2024 mwilck@suse.com
- Update to version 15.6.10:
  * udevrules: activate CPUs on hotplug for s390, too (bsc#1224400)
* Wed May 22 2024 mwilck@suse.com
- Update to version 15.6.9:
  * Include unblacklist in initramfs (bsc#1224320)
  * regenerate-initrd-posttrans: run update-bootloader --refresh for XEN
    (bsc#1223278)
  * 60-io-scheduler.rules: test for "scheduler" sysfs attribute (boo#1216717)
  * README: Update blacklist description (gh#openSUSE/suse-module-tools#71)
* Mon Feb  5 2024 mwilck@suse.com
- Update to version 15.6.8:
  * macros.initrd: %%regenerate_initrd_post: don't fail if mkdir is unavailable
    (boo#1217979)
  * Don't rebuild existing initramfs images if the environment variable
    SKIP_REGENERATE_ALL=1 is set (boo#1192014)
* Thu Jan 11 2024 mwilck@suse.com
- Update to version 15.6.7:
  * rpm-script: add symlink /boot/.vmlinuz.hmac (bsc#1217775)
* Mon Dec 18 2023 mwilck@suse.com
- Update to version 15.6.6:
  * add blacklist entry for reiserfs (jsc#PED-6167)
* Thu Dec 14 2023 mwilck@suse.com
- Update to version 15.6.5:
  * Add more modules to file system blacklist (jsc#PED-6167)
    Blacklisted filesystem modules that aren't officially supported
    by SUSE: f2fs, hfsplus, jfss2, kafs, ntfs3, orangefs, pstore, romfs, zonefs.
    This affects Leap and SLED only, as these modules aren't shipped
    for SLE anyway. As usual, the blacklist entries can be removed
    by running an explicit "modrobe $FS_MODULE" command.
* Wed Nov 22 2023 mwilck@suse.com
- Update to version 15.6.4:
  * modprobe.d: use softdep to load sd_mod and sg (bsc#1206070)
* Fri Sep 29 2023 mwilck@suse.com
- Update to version 15.6.3:
  * blacklist RNDIS modules (bsc#1205767, jsc#PED-5731, CVE-2023-23559)
  * modprobe.d: Blacklist cls_tcindex module (bsc#1210335, CVE-2023-1829)
* Fri Sep  1 2023 mwilck@suse.com
- Update to version 15.6.2:
  * Revert "weak-modules2: only use kernel version under /run/regenerate-initrd"
    (bsc#1214877)
* Tue Aug 15 2023 mwilck@suse.com
- Update to version 15.6.1:
  * change wording in filesystem blacklist files
    (gh#openSUSE/suse-module-tools#71)
  * rpm-script: update bootloader after creating initramfs
    (boo#1213822)
  * Drop support for usrmerged distro (boo#1206798)
  * rpm-script: check for regenerate-initrd-posttrans in %%posttrans
    (boo#1212957)
  * rpm-script: skip run_bootloader check (boo#1208117)
  * get rid of weak-modules (bsc#1202353)
  * Remove last mentions of mkinitrd
  * cert-script: skip cert handling if efivarfs is not writable
    (bsc#1201066, bsc#1213428)
  * weak-modules2: only use kernel version under /run/regenerate-initrd
    (boo#1201387)
* Thu Feb  2 2023 mwilck@suse.com
- Update to version 15.5.1:
  * modprobe.conf: s390x: remove softdep on fbcon (boo#1207853)
* Wed Jan 25 2023 mwilck@suse.com
- Update to version 15.5.0:
  * version adapted, code is identical to 15.4.15
* Mon Nov 21 2022 mwilck@suse.com
- Update to version 15.4.15: Backport bug fixes from factory
  * driver-check.sh, unblacklist: convert egrep to grep -E (bsc#1203092)
  * kernel-scriptlets: don't pass flags to weak-modules2 (bsc#1195391)
  * driver-check.sh: avoid false positive error messages (boo#1200107)
* Mon Nov 21 2022 mwilck@suse.com
- Update to version 15.4.14:
  * 80-hotplug-cpu-mem.rules: use CONST{arch} (bsc#1204423)
* Fri Nov  4 2022 mwilck@suse.com
- Update to version 15.4.13:
  * 80-hotplug-cpu-mem.rules: restrict cpu rule to x86_64 (bsc#1204423)
* Fri Jan 28 2022 mwilck@suse.com
- Update to version 15.4.12:
  * Add /etc/modprobe.d/README on SLE/Leap (bsc#1195051)
  * rpm-script: force-copy kernel to /boot (boo#1194501)
* Tue Jan  4 2022 mwilck@suse.com
- Update to version 15.4.11:
  * cdrom: Disable autoclose by default (boo#1165047).
  * Make regenerate-initrd-posttrans compatible with Dracut's
    UEFI mode (unified kernel image)
* Mon Dec 20 2021 mwilck@suse.com
- Update to version 15.4.10:
  * same as Factory version 16.0.17
  * 60-io-scheduler.rules: add rules for virtual devices
    (boo#1193759)
  * 60-io-scheduler.rules: enforce "none" for loop devices
    (boo#1193759)
  * install some modprobe.d files only for relevant architectures
    (apm_bios, sonypi, toshiba, legacy rtc) (bsc#1192974)
* Mon Dec 13 2021 mwilck@suse.com
- Update to version 15.4.9:
  * same as Factory version 16.0.16
  * modprobe.d: split conf files (jsc#SLE-21626, boo#1193059)
  - Rather than shipping two large files with modprobe.d options
    (00-system.conf and 50-blacklist.conf), ship multiple small
    per-module files. This makes it easier for users to override
    distribution defaults.
  * blacklist isst_if_mbox_msr (bsc#1187196)
  * boot-sysctl: make sure file exists (fix for containers)
  * remove blacklist entry for snd_bt87x (bsc#1192974, bsc#51718)
* Tue Nov  9 2021 mwilck@suse.com
- Update to version 15.4.8:
  * Same as Factory version 16.0.14
  * add udev rules from udev-extra-rules (formerly system-tuning-common-SUSE).
    Both packages are now both obsoleted by suse-module-tools.
    (jsc#SLE-21032)
  * 60-io-scheduler.rules: don't use BFQ for real multiqueue devices
    (jsc#SLE-21032, bsc#1192161)
  * 60-io-scheduler.rules: use "none" for multipath components
    (bsc#1192161)
* Fri Oct 22 2021 mwilck@suse.com
- Update to version 15.4.7:
  * fixup "rpm-script: fix bad exit status in OpenQA (bsc#1191922)"
* Fri Oct 22 2021 mwilck@suse.com
- Update to version 15.4.6:
  * rpm-script: fix bad exit status in OpenQA (bsc#1191922)
  * cert-script: Deal with existing $cert.delete file (bsc#1191804).
  * cert-script: Ignore kernel keyring for kernel certificates (bsc#1191480).
  * cert-script: Only print mokutil output in verbose mode.
* Mon Oct  4 2021 mwilck@suse.com
- Update to version 15.4.5:
  * inkmp-script(postun): don't pass  existing files to weak-modules2
    (boo#1191200)
  * kernel-scriptlets: skip cert scriptlet on non-UEFI systems
    (boo#1191260)
* Fri Oct  1 2021 mwilck@suse.com
- Update to version 15.4.4:
  * Import kernel scriptlets from kernel-source
    (bsc#1189841, bsc#1190598)
  * Provide "suse-kernel-rpm-scriptlets"
* Thu Aug 19 2021 mwilck@suse.com
- Update to version 15.4.3:
  * fix problem that initrd may not be rebuilt after installing
    kernel-$flavor-extra (bsc#1189441)
* Fri Aug 13 2021 mwilck@suse.com
- Update to version 15.4.2
- Move config files to /lib/modprobe.d and /lib/depmod.d
  (jsc#SLE-20639)
  * "modprobe $FS" for a blacklisted file system now offers to
    unblacklist the module permanently
  * disabled automatic un-blacklisting of filesystem modules loaded
    at installation time
- Replace mkinitrd with dracut everywhere (jsc#SLE-20348)
- Add faster substitute for lsinitrd to speed up weak-modules2
  (jsc#SLE-9078)
- Enable f2fs
- Add a "Supplements" dependency on dkms to the "legacy" submodule
  (dkms needs "weak-modules")
- modprobe.d cleanups and fixes:
  * Unify ppc64 and ppc64le
  * Delete files for obsolete architectures
  * Remove obsolete SUSE_INITRD statements (bsc#1161343)
  * Remove dma=none setting for parport_pc (bsc#1177695)
- Add README.md
* Tue Jul  6 2021 mwilck@suse.com
- Update to version 15.3.8:
  * modprobe.d: Remove dma=none setting for parport_pc
    (bsc#1177695)
* Thu Jun 17 2021 mwilck@suse.com
- Update to version 15.3.7:
  * Fix treatment of compressed modules (bsc#1187093)
* Thu Apr 22 2021 mwilck@suse.com
- Update to version 15.3.6:
  * dm-crypt requires essiv in SLE15 SP3 (boo#1183063 bsc#1184134 ltc#192244).
* Fri Nov 20 2020 mwilck@suse.com
- Add bugref for bsc#1174287 and bsc#1172745
  * The workaround for these was in 15.3.5 already.
* Mon Nov  2 2020 mwilck@suse.com
- Update to version 15.3.5:
  * Skip coldplug for memory devices on ppc64le, using generator
* Tue Aug 25 2020 mwilck@suse.com
- Update to version 15.3.4:
  * spec: rework dependencies
* Mon Aug  3 2020 mwilck@suse.com
- Update to version 15.3.4:
  * rework dependencies to reduce system size for small OS
* Fri Jun  5 2020 mwilck@suse.com
- Reverted back to tar_scm source service
  (obs_scm doesn't work well for Ring0 packages)
* Wed May 27 2020 mwilck@suse.com
- Update to version 15.3.3:
  * spec: remove SLE/openSUSE difference in allow_unsupported_modules
  (jsc#SLE-12255)
  * spec: use same fs_blacklist on SLE and openSUSE
  (jsc#SLE-12255, jsc#SLE-3926)
  * spec: use br_netfilter softdep only for SLE12
  (jsc#SLE-12255, bsc#1166531, boo#1158817, bsc#937216)
* Fri Apr 17 2020 mwilck@suse.com
- Update to version 15.3.2:
  * modprobe.conf.common: eliminate circular uas/usb-storage dependency
  (bsc#1168661)
* Mon Jan 20 2020 mwilck@suse.com
- Update to version 15.2.10:
  * ppc64le: fix dependency of papr_scm
    (bsc#1142152, ltc#176292, FATE#327775).
* Wed Jan 15 2020 mwilck@suse.com
- Update to version 15.2.9:
  * 00-system.conf: move br_netfilter softdep to separate file
    (boo#1158817)
* Thu Jan  9 2020 mwilck@suse.com
- Update to version 15.2.8:
  * Add modprobe.conf.s390x (bsc#1132798)
* Thu Nov  7 2019 mwilck@suse.com
- Update to version 15.2.7:
  * spec file: avoid %%{_libexecdir}
* Thu Nov  7 2019 mwilck@suse.com
- Update to version 15.2.6:
  * modprobe.conf: add dependency of papr_scm on libnvdimm
    (bsc#1142152, ltc#176292, FATE#327775).
* Fri Aug 16 2019 mwilck@suse.com
- Update to version 15.2.5:
  * remove 'modhash' - moved to mokutil package (jsc#SLE-6094)
* Mon Jul 15 2019 mwilck@suse.com
- Update to version 15.2.4:
  * sg.conf: avoid file conflict with system-tuning-common-SUSE
* Mon Jul  1 2019 mwilck@suse.com
- Update to version 15.2.3:
  * softdep of bridge on br_netfilter (bsc#937216, bsc#1134819)
* Tue Jun 18 2019 mwilck@suse.com
- Update to version 15.2.2:
  * kmp-install, driver-check.sh, weak-modules2:
    Support for compressed kernel modules (bsc#1135854)
* Fri Jun 14 2019 mwilck@suse.com
- Update to version 15.2.1:
- Install sg.conf under /usr/lib/modules-load.d (bsc#1036463)
  * sg.conf: avoid file conflict with systemd
* Fri Jun 14 2019 mwilck@suse.com
- Update to version 15.2.0:
  * weak-modules2: emit "inconsistent" warning only if replacement fails
  (bsc#1127155)
* Fri May 17 2019 dimstar@opensuse.org
- Only ship RPM macros up to suse_version 1500: after that, the
  macros can be found in the rpm-config-SUSE package.
* Fri May 10 2019 dimstar@opensuse.org
- Move RPM macros to %%_rpmmacrodir.
* Thu Mar 14 2019 mwilck@suse.com
- Update to version 15.1.13:
  * spec file: add conflicts for dracut < 44.2 (bsc#1127891)
* Thu Mar 14 2019 mwilck@suse.com
- Update to version 15.1.12 (git 1ab0b84):
  * modprobe.conf.common: add csiostor->cxgb4 dependency
    (bsc#1100989)
  * Load fbcon together with virtio_gpu on s390 (bsc#1121996,
    fate#327159)
* Mon Feb 18 2019 mwilck@suse.com
- Update to version 15.1.11 (git 54df192):
  * spec file: use more gentle wording in blacklist files
  * spec file: drop jffs2 and ubifs from blacklist
* Fri Feb  8 2019 mwilck@suse.com
- Update to version 15.1.10 (git b28b13d):
- implemented fs blacklisting logic (jsc#SLES-4085, fate#326832)
* Thu Jan 31 2019 mwilck@suse.com
- Update to version 15.1.0 (git 6b07b88):
  * 50-blacklist.conf is not added in Leap before 15.1.
  fix conditionals and bump version accordingly.
* Wed Jan 30 2019 mwilck@suse.com
- Update to version 15.0.20 (git 1396df5):
- Fix driver-check.sh (boo#1123697, boo#1123704)
- add /etc/modprobe.d/50-blacklist.conf from sysconfig package
  (boo#1107611)
- Remove hard dependency on mkinitrd (boo#1123721)
- Make sure code works also without kmod-compat
- Replace file dependency on /sbin/depmod by weak package dependency
* Mon Dec 10 2018 mwilck@suse.com
- Move "weak-modules" script to -legacy subpackage to avoid
  dependency on binutils (bsc#1116665)
* Fri Dec  7 2018 adrian@suse.de
- Require mkinitrd (provided also by dracut) directly instead of
  file requires. This is fixing image build failures
* Wed Nov  7 2018 mwilck@suse.com
- Update to version 15.0.1 (git 5c63319):
- Use /etc/modules-load.d/sg.conf for sg driver autoloading
  (bsc#1036463)
  * added /etc/modules-load.d/sg.conf
* Mon Nov  5 2018 mwilck@suse.com
- version 15.0 (git 6ce3011)
- modsign-verify: support for parsing PKCS#7 signatures
  (bsc#1111300, bsc#1105495)
- Fix logic for unsupported modules (bsc#1111183)
  * SLES15: allow unsupported modules only if kernel-default-extra
  from SLE-WE module is installed
  * Always allow unsupported modules on Leap 15 and Factory
  * No change for SLE12 / Leap 42.x and below
  * 10-unsupported-modules.conf: improved comments
  * fix %%config(noreplace) logic for 10-unsupported-modules.conf
- added udev rule 81-sg.rules to make sure the sg module is
  always loaded (bsc#1036463)
* Wed Jul 26 2017 tchvatal@suse.com
- Use path dependency that is not parsed by obs to ensure we
  are not pulling systemd everywhere
* Mon Jun 19 2017 tchvatal@suse.com
- Set url to github project and repack using obs service
- Cleanup a bit with spec-cleaner
- Grep os-release and not deprecated SuSE-release
* Thu Sep  8 2016 dmueller@suse.com
- blacklist efifb on aarch64 (bsc#996080)
* Fri May 27 2016 mmarek@suse.cz
- Run dos2unix on the modhash script.
* Thu May 26 2016 jlee@suse.com
- Add modhash tool to calculate hash of signed module.
  It strips X.509 or PKCS#7 signature before hash kernel module.
  (fate#319460)
* Wed May 25 2016 mmarek@suse.cz
- Remove -x bit from 50-kernel-uname_r.conf (bsc#981291).
* Fri Apr 29 2016 mmarek@suse.cz
- Ignore failures when loading the kernel sysctl (bsc#977715).
* Thu Apr 28 2016 mmarek@suse.com
- Add a systemd service to load /boot/sysctl.conf-`uname -r`
  (bsc#977715).
* Fri Apr  1 2016 mmarek@suse.cz
- Skip KMPs built from the kernel spec file directly (fate#319339)
- Bump version number to 12.4
* Tue Feb 23 2016 lnussel@suse.de
- add missing requirements on module-init-tools, findutils and gzip,
  mkinitrd (bnc#965830)
* Fri Jan 15 2016 bpoirier@suse.com
- Add module option ib_mthca.catas_reset_disable=1 on ppc64le (bsc#456389).
* Tue Oct 13 2015 mmarek@suse.cz
- Revert change for fate#319339, as some 3rd party KMPs are built
  with a modified template (bsc#949862).
* Tue Sep  8 2015 trenn@suse.de
- Use /run instead of deprecated /var/run
  This can have sever consequences if this package uses /var/run. It may
  be installed before filesystem package generating the /run tmpfs and
  predict it to generate the link /var/run -> /run. Later dracut convertfs
  kicks in to generate it, but it has issues. bsc#922676
* Thu Aug 13 2015 mmarek@suse.cz
- Only handle KMPs that are built using the %%kernel_module_package
  macro (preparatory work for fate#319339).
* Tue Jun 23 2015 mmarek@suse.cz
- Use absolute path to mkinitrd (bsc#935566)
* Fri May 16 2014 mmarek@suse.cz
- Add kgraft/ to the depmod search list (fate#313296)
* Mon May  5 2014 tonyj@suse.com
- Add support for ARM zImage to weak-modules2
* Tue Apr 15 2014 mmarek@suse.cz
- weak-modules2: Use lsinitrd to list the modules in an initrd, so
  that initrds with early microcode work (bnc#873209, bnc#873113).
* Fri Apr  4 2014 mmarek@suse.cz
- weak-modules2: Run mkinitrd in posttrans if $INITRD_IN_POSTTRANS
  is set (fate#313506)
* Fri Apr  4 2014 mmarek@suse.cz
- regenerate-initrd-posttrans: Run mkinitrd_setup
* Fri Apr  4 2014 mmarek@suse.cz
- Add macros for regenerating the initrd in %%posttrans
  (fate#313506).
* Mon Mar 31 2014 mmarek@suse.cz
- Use softdep to order {u,o,e}hci-hcd drivers.
- Drop ia64 modprobe config.
* Fri Mar 28 2014 mmarek@suse.cz
- Add kmp-install tool for easier installation of SolidDriver KMPs
  (fate#314581).
* Tue Mar 11 2014 mmarek@suse.cz
- Add modsign-verify tool to verify signatures of modules
  (fate#314507).
* Tue Mar 11 2014 mmarek@suse.cz
- weak-modules2: Support XZ compressed initrds (bnc#778119,
  bnc#867312)
* Mon Mar 10 2014 mmarek@suse.cz
- The package cannot be noarch, because it installs different
  configs for different architectures.
- Install 10-unsupported-modules.conf unconditionally, kmod has
  been patched.
* Fri Feb  7 2014 rsalevsky@suse.com
- load the uas driver simulsimultaneously with the usb_storage driver and vice versa (bnc#862397)
* Wed May 29 2013 schwab@suse.de
- weak-modules{,2}: also look for Image-$krel for aarch64
* Sun Mar 17 2013 crrodriguez@opensuse.org
- The "allow_unsupported_modules" feature, does not belong too
  openSUSE, kmod (and hence udev and systemd) do not understand
  it in anyway. limit to SLE only.
* Wed Nov 14 2012 jengelh@inai.de
- New package. Split SUSE-specific scripts from module-init-tools,
  so that we can actually get a system with kmod-compat running.
