#
# spec file
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define skip_python2 1
%global flavor %{nil}
%if "%{flavor}" == "test"
%define psuffix -test
%bcond_without test
%bcond_with wheel
%endif
%if "%{flavor}" == "wheel"
%define psuffix -wheel
%bcond_with test
%bcond_without wheel
%endif
%if "%{flavor}" == ""
%define psuffix %{nil}
%bcond_with test
%bcond_with wheel
%endif

# in order to avoid rewriting for subpackage generator
%define mypython python
%{?sle15_python_module_pythons}
Name:           python-setuptools%{psuffix}
Version:        67.7.2
Release:        150400.3.19.1
Summary:        Download, build, install, upgrade, and uninstall Python packages
License:        Apache-2.0 AND MIT AND BSD-2-Clause AND Python-2.0
URL:            https://github.com/pypa/setuptools
Source:         https://files.pythonhosted.org/packages/source/s/setuptools/setuptools-%{version}.tar.gz
Patch0:         sort-for-reproducibility.patch
# PATCH-FIX-OPENSUSE fix-get-python-lib-python38.patch bsc#1204395
Patch2:         fix-get-python-lib-python38.patch
# PATCH-FIX-UPSTREAM gh#pypa/setuptools#3917
Patch3:         use-tarfile-extraction_filter.patch
# PATCH-FIX-UPSTREAM CVE-2024-6345 bsc#1228105
Patch4:         CVE-2024-6345-code-execution-via-download-funcs.patch
# PATCH-FIX-UPSTREAM CVE-2025-47273.patch bsc#1243313, gh#pypa/setuptools@250a6d17978f
Patch5:         CVE-2025-47273.patch
BuildRequires:  %{python_module base >= 3.7}
BuildRequires:  fdupes
BuildRequires:  python-rpm-macros
Requires(post): update-alternatives
Requires(postun):update-alternatives
BuildArch:      noarch
%if %{with wheel}
Requires:       %mypython(abi) = %python_version
%endif
%if %{with test}
BuildRequires:  %{python_module build}
BuildRequires:  %{python_module devel}
BuildRequires:  %{python_module filelock >= 3.4.0}
BuildRequires:  %{python_module ini2toml-lite >= 0.9}
BuildRequires:  %{python_module jaraco.envs >= 2.2}
BuildRequires:  %{python_module jaraco.path >= 3.2.0}
BuildRequires:  %{python_module pip >= 19.1}
BuildRequires:  %{python_module pip-run >= 8.8}
BuildRequires:  %{python_module pytest >= 6}
BuildRequires:  %{python_module pytest-timeout}
BuildRequires:  %{python_module pytest-xdist}
BuildRequires:  %{python_module setuptools = %{version}}
BuildRequires:  %{python_module setuptools-wheel = %{version}}
BuildRequires:  %{python_module tomli-w >= 1.0.0}
BuildRequires:  %{python_module virtualenv >= 13.0.0}
BuildRequires:  %{python_module wheel}
%endif
%if 0%{?suse_version} || 0%{?fedora_version} >= 24
Recommends:     ca-certificates-mozilla
%endif
%if %{with wheel}
BuildRequires:  %{python_module wheel}
%endif
%python_subpackages

%description
setuptools is a collection of enhancements to the Python distutils that
allow you to build and distribute Python packages,
especially ones that have dependencies on other packages.

%prep
%autosetup -p1 -n setuptools-%{version}

%build
%if ! %{with wheel}
%python_build
%else
%python_exec setup.py bdist_wheel --universal
%endif

%install
%if !%{with test} && !%{with wheel}
%python_install
%python_expand %fdupes %{buildroot}%{$python_sitelib}
%endif

%if %{with wheel}
%python_expand install -D -m 0644 -t %{buildroot}%{$python_sitelib}/../wheels dist/*.whl
%endif

%check
%if %{with test}
%python_expand export PRE_BUILT_SETUPTOOLS_WHEEL=%{$python_sitelib}/../wheels/setuptools-%{version}-py2.py3-none-any.whl
export LANG=en_US.UTF-8
# tests need imports from local source dir
export PYTHONPATH=$(pwd)
# no online comparisons in obs
donttest="(test_apply_pyproject_equivalent_to_setupcfg and https)"
# test_pbr_integration tries to install pbr from network using pip
donttest+=" or test_pbr_integration"
%pytest -rfE -n auto -k "not ($donttest)"
%endif

%if !%{with test}
%files %{python_files}
%if !%{with wheel}
%license LICENSE
%doc CHANGES.rst README.rst
%{python_sitelib}/setuptools
%{python_sitelib}/setuptools-%{version}*-info
%dir %{python_sitelib}/pkg_resources
%{python_sitelib}/pkg_resources/*
%{python_sitelib}/_distutils_hack
%{python_sitelib}/distutils-precedence.pth
%endif

%if %{with wheel}
%dir %{python_sitelib}/../wheels
%{python_sitelib}/../wheels/*
%endif
%endif

%changelog
* Mon May 19 2025 daniel.garcia@suse.com
- Add patch CVE-2025-47273.patch to fix A path traversal
  vulnerability.
  (bsc#1243313, CVE-2025-47273, gh#pypa/setuptools@250a6d17978f)
* Mon Aug 12 2024 steven.kowalik@suse.com
- Add patch CVE-2024-6345-code-execution-via-download-funcs.patch:
  * Sanitize any VCS URL we download. (CVE-2024-6345, bsc#1228105)
* Thu May  4 2023 mcepl@suse.com
- Testing must be single-spec as well.
* Wed May  3 2023 steven.kowalik@suse.com
- Update to 67.7.2:
  * #3902: Fixed wrong URLs used in warnings and logs.
  * #3898: Fixes setuptools.dist:invalid_unless_false when value is false
    don’t raise error
  * #3849: Overhaul warning system for better visibility.
  * #3884: Add a stacklevel parameter to warnings.warn() to provide more
    information to the user.
- Add patch use-tarfile-extraction_filter.patch:
  * Set an extraction_filter to avoid a warning.
* Fri Apr 21 2023 dmueller@suse.com
- add sle15_python_module_pythons (jsc#PED-68)
* Sun Apr 16 2023 dmueller@suse.com
- update to 67.6.1:
  * #3865: Fixed ``_WouldIgnoreField`` warnings for ``scripts``
    and ``gui_scripts``, when ``entry-points`` is not listed in dynamic.
  * #3875: Update code generated by ``validate-pyproject`` to use
    v0.12.2.
  * This should fix default license patterns when
    ``pyproject.toml`` is used.
* Sun Mar 26 2023 mcepl@suse.com
- Refresh sort-for-reproducibility.patch
* Thu Mar  9 2023 steven.kowalik@suse.com
- Update to 67.6.0:
  * Deprecations
    + #3434: Added deprecation warning for pkg_resources.declare_namespace.
  * Breaking Changes
    + #3741: Removed patching of distutils._msvccompiler.gen_lib_options for
    compatibility with Numpy < 1.11.2 -- by :user:`mgorny`
    + #2497: Support for PEP 440 non-conforming versions has been removed.
  * Changes
    + #3804: Added caching for supported wheel tags.
    + #3846: Added pruning heuristics to PackageFinder based on exclude.
    + #3843: Although pkg_resources has been discouraged for use, some
    projects still consider pkg_resources viable for usage. This change
    makes it clear that pkg_resources should not be used, emitting a
    DeprecationWarning when imported.
    + #3809: Merge with distutils@8c3c3d29, including fix for
    sysconfig.get_python_inc() (pypa/distutils#178), fix for segfault on
    MinGW (pypa/distutils#196), and better has_function
    support (pypa/distutils#195, #3648).
    + #3795: Ensured that __file__ is an absolute path when executing setup.py
    as part of setuptools.build_meta.
    + #3685: Fix improper usage of deprecated/removed pkgutil APIs in
    Python 3.12+.
    + #3769: Replace 'appdirs' with 'platformdirs'.
  * Misc
    + #3838: Improved error messages for pyproject.toml validations.
    + #3839: Fixed pkg_resources errors caused when parsing metadata of
    packages that are already installed but do not conform with PEP 440.
    + #3823: Fixes egg_info code path triggered during integration with pip.
    + #3782: Fixed problem with file directive in tool.setuptools.dynamic
    when value is a simple string instead of list.
* Thu Nov 24 2022 daniel.garcia@suse.com
- Update to 65.6.3:
  * #3709: Fix condition to patch distutils.dist.log to only apply when using
    distutils from the stdlib.
- v65.6.2
  * No significant changes.
* Wed Nov 23 2022 daniel.garcia@suse.com
- Update to 65.6.1:
  * #3689: Document that distutils.cfg might be ignored unless
    SETUPTOOLS_USE_DISTUTILS=stdlib.
  * #3678: Improve clib builds reproducibility by sorting sources -- by
    :user:`danigm`, fixing bsc#1201127
  * #3684: Improved exception/traceback when invalid entry-points are
    specified.
  * #3690: Fixed logging errors: 'underlying buffer has been detached' (issue
    [#1631]).
  * #3693: Merge pypa/distutils@3e9d47e with compatibility fix for
    distutils.log.Log.
  * #3704: Fix temporary build directories interference with auto-discovery.
- v65.6.0:
  * #3674: Sync with pypa/distutils@e0787fa, including pypa/distutils#183
    updating distutils to use the Python logging framework.
* Mon Nov 14 2022 daniel.garcia@suse.com
- Delete remove_mock.patch, that's not needed anymore, it's upstreamed
- Update to 65.5.1:
  * #3638: Drop a test dependency on the mock package, always use
    :external+python:py:mod:`unittest.mock` -- by :user:`hroncok`
  * #3659: Fixed REDoS vector in package_index.
* Wed Oct 19 2022 daniel.garcia@suse.com
- Skip test_pbr_integration because it tries to install pbr using pip from
  network
* Wed Oct 19 2022 daniel.garcia@suse.com
- Add fix-get-python-lib-python38.patch to fix get_python_lib() method in
  python3.8 bsc#1204395
- Update to version 65.5.0:
  * #3624: Fixed editable install for multi-module/no-package src-layout
    projects.
  * #3626: Minor refactorings to support distutils using stdlib logging module.
  * #3419: Updated the example version numbers to be compliant with PEP-440 on
    the "Specifying Your Project’s Version" page of the user guide.
  * #3569: Improved information about conflicting entries in the current
    working directory and editable install (in documentation and as an
    informational warning).
  * #3576: Updated version of validate_pyproject.
- v65.4.1
  * #3613: Fixed encoding errors in expand.StaticModule when system default
    encoding doesn't match expectations for source files.
  * #3617: Merge with pypa/distutils@6852b20 including fix for
    pypa/distutils#181.
- v65.4.0
  * #3609: Merge with pypa/distutils@d82d926 including support for
    DIST_EXTRA_CONFIG in pypa/distutils#177.
- v65.3.0
  * #3547: Stop ConfigDiscovery.analyse_name from splatting the
    Distribution.name attribute -- by :user:`jeamland`
  * #3554: Changed requires to requests in the pyproject.toml example in the
    :doc:`Dependency management section of the Quickstart guide
    <userguide/quickstart>` -- by :user:`mfbutner`
  * #3561: Fixed accidental name matching in editable hooks.
- v65.2.0
  * #3553: Sync with pypa/distutils@22b9bcf, including fixed cross-compiling
    support and removing deprecation warning per pypa/distutils#169.
- v65.1.1
  * #3551: Avoided circular imports in meta path finder for editable installs
    when a missing module has the same name as its parent.
- v65.1.0
  * #3536: Remove monkeypatching of msvc9compiler.
  * #3538: Corrected documentation on how to use the legacy-editable mode.
- v65.0.2
  * #3505: Restored distutils msvccompiler and msvc9compiler modules and marked
    as deprecated (pypa/distutils@c802880).
- v65.0.1
  * #3529: Added clarification to :doc:`/userguide/quickstart` about support to
    setup.py.
  * #3526: Fixed backward compatibility of editable installs and custom
    build_ext commands inheriting directly from distutils.
  * #3528: Fixed buid_meta.prepare_metadata_for_build_wheel when given
    metadata_directory is ".".
- v65.0.0
  * #3505: Removed 'msvccompiler' and 'msvc9compiler' modules from distutils.
  * #3521: Remove bdist_msi and bdist_wininst commands, which have been
    deprecated since Python 3.9. Use older Setuptools for these behaviors if
    needed.
  * #3519: Changed the note in keywords documentation regarding editable
    installations to specify which setuptools version require a minimal
    setup.py file or not.
- v64.0.3
  * #3515: Fixed "inline" file copying for editable installations and optional
    extensions.
  * #3517: Fixed editable_wheel to ensure other commands are finalized before
    using them. This should prevent errors with plugins trying to use different
    commands or reinitializing them.
  * #3517: Augmented filter to prevent transient/temporary source files from
    being considered package_data or data_files.
- v64.0.2
  * #3506: Suppress errors in custom build_py implementations when running
    editable installs in favor of a warning indicating what is the most
    appropriate migration path. This is a transitional measure. Errors might be
    raised in future versions of setuptools.
  * #3512: Added capability of handling namespace packages created
    accidentally/purposefully via discovery configuration during editable
    installs. This should emulate the behaviour of a non-editable installation.
- v64.0.1
  * #3497: Fixed editable_wheel for legacy namespaces.
  * #3502: Fixed issue with editable install and single module distributions.
  * #3503: Added filter to ignore external .egg-info files in manifest.
  * Some plugins might rely on the fact that the .egg-info directory is
    produced inside the project dir, which may not be the case in editable
    installs (the .egg-info directory is produced inside the metadata directory
    given by the build frontend via PEP 660 hooks).
- v64.0.0
  * #3380: Passing some types of parameters via --global-option to setuptools
    PEP 517/PEP 660 backend is now considered deprecated. The user can pass the
    same arbitrary parameter via --build-option (--global-option is now
    reserved for flags like --verbose or --quiet).
  * Both --build-option and --global-option are supported as a transitional
    effort (a.k.a. "escape hatch"). In the future a proper list of allowed
    config_settings may be created.
  * #3265: Added implementation for editable install hooks (PEP 660).
  * #3380: Improved the handling of the config_settings parameter in both PEP
    517 and PEP 660 interfaces:
  * #3392: Exposed get_output_mapping() from build_py and build_ext
    subcommands. This interface is reserved for the use of setuptools
    Extensions and third part packages are explicitly disallowed to calling it.
    However, any implementation overwriting build_py or build_ext are required
    to honour this interface.
  * #3412: Added ability of collecting source files from custom build
    sub-commands to sdist. This allows plugins and customization scripts to
    automatically add required source files in the source distribution.
  * #3414: Users can temporarily specify an environment variable
    SETUPTOOLS_ENABLE_FEATURES=legacy-editable as a escape hatch for the PEP
    660 behavior. This setting is transitional and may be removed in the
    future.
  * #3484: Added transient compat mode to editable installs. This more will be
    temporarily available (to facilitate the transition period) for those that
    want to emulate the behavior of the develop command (in terms of what is
    added to sys.path). This mode is provided "as is", with limited support,
    and will be removed in future versions of setuptools.
  * #3414: Updated :doc:`Development Mode </userguide/development_mode>` to
    reflect on the implementation of PEP 660.
- v63.4.3
  * #3496: Update to pypa/distutils@b65aa40 including more robust support for
    library/include dir handling in msvccompiler (pypa/distutils#153) and test
    suite improvements.
- v63.4.2
  * #3453: Bump vendored version of :pypi:`pyparsing` to 3.0.9.
  * #3481: Add warning for potential install_requires and extras_require
    misconfiguration in setup.cfg
  * #3487: Modified pyproject.toml validation exception handling to make
    relevant debugging information easier to spot.
- v63.4.1
  * #3482: Sync with pypa/distutils@274758f1c02048d295efdbc13d2f88d9923547f8,
    restoring compatibility shim in bdist.format_commands.
- v63.4.0
  * #2971: upload_docs command is deprecated once again.
  * #3443: Installed sphinx-hoverxref extension to show tooltips on internal an
    external references. -- by :user:`humitos`
  * #3444: Installed sphinx-notfound-page extension to generate nice 404 pages.
  - - by :user:`humitos`
  * #3480: Merge with pypa/distutils@c397f4c
- v63.3.0
  * #3475: Merge with pypa/distutils@129480b, including substantial delinting
    and cleanup, some refactoring around compiler logic, better messaging in
    cygwincompiler (pypa/distutils#161).
* Sat Jul 16 2022 arun@gmx.de
- update to version 63.2.0:
  * Changes
    + #3395: Included a performance optimization:
    setuptools.build_meta no longer tries to :func:`compile` the
    setup script code before :func:`exec`-ing it.
  * Misc
    + #3435: Corrected issue in macOS framework builds on Python 3.9
    not installed by homebrew (pypa/distutils#158).
* Thu Jul 14 2022 code@bnavigator.de
- Remove dependency on packaging -- boo#1178257
- Enable ini2toml[lite] tests
* Wed Jul 13 2022 code@bnavigator.de
- Update to version 63.1.0
  * #3430: Merge with pypa/distutils@152c13d including
    pypa/distutils#155 (improved compatibility for editable
    installs on homebrew Python 3.9), pypa/distutils#150 (better
    handling of runtime_library_dirs on cygwin), and
    pypa/distutils#151 (remove warnings for namespace packages).
- v63.0.0
  * #3421: Drop setuptools' support for installing an entrypoint
    extra requirements at load time:
  - the functionality has been broken since v60.8.0.
  - the mechanism to do so is deprecated (fetch_build_eggs).
  - that use case (e.g. a custom command class entrypoint) is
    covered by making sure the necessary build requirements are
    declared. Documentation changes
  * #3397: Fix reference for keywords to point to the Core Metadata
    Specification instead of PEP 314 (the live standard is kept
    always up-to-date and consolidates several PEPs together in a
    single document).
- v62.6.0
  * #3253: Enabled using file: for requirements in setup.cfg -- by
    :user:`akx` (this feature is currently considered to be in beta
    stage).
  * #3255: Enabled using file: for dependencies and
    optional-dependencies in pyproject.toml -- by :user:`akx` (this
    feature is currently considered to be in beta stage).
  * #3391: Updated attr: to also extract simple constants with type
    annotations -- by :user:`karlotness`
- v62.5.0
  * #3347: Changed warnings and documentation notes about
    experimental aspect of pyproject.toml configuration: now
    [project] is a fully supported configuration interface, but the
    [tool.setuptools] table and sub-tables are still considered to
    be in beta stage.
  * #3383: In _distutils_hack, suppress/undo the use of local
    distutils when select tests are imported in CPython.
  * #3385: Modules used to parse and evaluate configuration from
    pyproject.toml files are intended for internal use only and
    that not part of the public API.
- v62.4.0
  * #3256: Added setuptools.command.build command to match
    distutils.command.build -- by :user:`isuruf`
  * #3366: Merge with pypa/distutils@75ed79d including reformat
    using black, fix for Cygwin support (pypa/distutils#139), and
    improved support for cross compiling (pypa/distutils#144 and
    pypa/distutils#145).
- v62.3.4
  * #3354: Improve clarity in warning about unlisted namespace
    packages.
- v62.3.3
  * #3336: Modified test_setup_install_includes_dependencies to
    work with custom PYTHONPATH –- by :user:`hroncok`
- v62.3.2
  * #3328: Include a first line summary to some of the existing
    multi-line warnings.
- v62.3.1
  * #3320: Fixed typo which causes namespace_packages to raise an
    error instead of warning.
- v62.3.0
  * #3262: Formally added deprecation messages for
    namespace_packages. The methodology that uses pkg_resources and
    namespace_packages for creating namespaces was already
    discouraged by the :doc:`setuptools docs
    </userguide/package_discovery>` and the :doc:`Python Packaging
    User Guide <PyPUG:guides/packaging-namespace-packages>`,
    therefore this change just make the deprecation more official.
    Users can consider migrating to native/implicit namespaces (as
    introduced in PEP 420).
  * #3308: Relying on include_package_data to ensure sub-packages
    are automatically added to the build wheel distribution (as
    "data") is now considered a deprecated practice. This behaviour
    was controversial and caused inconsistencies (#3260). Instead,
    projects are encouraged to properly configure packages or use
    discovery tools. General information can be found in
    :doc:`userguide/package_discovery`.
  * #1806: Allowed recursive globs (**) in package_data. -- by
    :user:`nullableVoidPtr`
  * #3206: Fixed behaviour when both install_requires (in setup.py)
    and dependencies (in pyproject.toml) are specified. The
    configuration in pyproject.toml will take precedence over
    setup.py (in accordance with PEP 621). A warning was added to
    inform users.
  * #3274: Updated version of vendored pyparsing to 3.0.8 to avoid
    problems with upcoming deprecation in Python 3.11.
  * #3292: Added warning about incompatibility with old versions of
    importlib-metadata.
- v62.2.0
  * #3299: Optional metadata fields are now truly optional.
    Includes merge with pypa/distutils@a7cfb56 per
    pypa/distutils#138.
  * #3282: Added CI cache for setup.cfg examples used when testing
    setuptools.config.
- v62.1.0
  * #3249: Simplified package_dir obtained via auto-discovery.
- v62.0.0
  * #3151: Made setup.py develop --user install to the user site
    packages directory even if it is disabled in the current
    interpreter.
  * #3153: When resolving requirements use both canonical and
    normalized names -- by :user:`ldaniluk`
  * #3167: Honor unix file mode in ZipFile when installing wheel
    via install_as_egg -- by :user:`delijati`
  * #3088: Fixed duplicated tag with the dist-info command.
  * #3247: Fixed problem preventing readme specified as dynamic in
    pyproject.toml from being dynamically specified in setup.py.
- v61.3.1
  * #3233: Included missing test file setupcfg_examples.txt in
    sdist.
  * #3233: Added script that allows developers to download
    setupcfg_examples.txt prior to running tests. By caching these
    files it should be possible to run the test suite offline.
- v61.3.0
  * #3229: Disabled automatic download of trove-classifiers to
    facilitate reproducibility.
  * #3229: Updated pyproject.toml validation via validate-pyproject
    v0.7.1.
  * #3229: New internal tool made available for updating the code
    responsible for the validation of pyproject.toml. This tool can
    be executed via tox -e generate-validation-code.
- v61.2.0
  * #3215: Ignored a subgroup of invalid pyproject.toml files that
    use the [project] table to specify only requires-python
    (transitional).
  * Warning: Please note that future releases of setuptools will
    halt the build process if a pyproject.toml file that does not
    match the PyPA Specification
    <PyPUG:specifications/declaring-project-metadata> is given.
  * #3215: Updated pyproject.toml validation, as generated by
    validate-pyproject==0.6.1.
  * #3218: Prevented builds from erroring if the project specifies
    metadata via pyproject.toml, but uses other files (e.g.
    setup.py) to complement it, without setting dynamic properly.
  * Important: This is a transitional behaviour. Future releases of
    setuptools may simply ignore externally set metadata not backed
    by dynamic or even halt the build with an error.
  * #3224: Merge changes from pypa/distutils@e1d5c9b1f6
  + #3223: Fixed missing requirements with environment markers when
    optional-dependencies is set in pyproject.toml.
- v61.1.1
  * #3212: Fixed missing dependencies when running setup.py
    install. Note that calling setup.py install directly is still
    deprecated and will be removed in future versions of
    setuptools. Please check the release notes for
    :ref:`setup_install_deprecation_note`.
- v61.1.0
  * #3206: Changed setuptools.convert_path to an internal function
    that is not exposed as part of setuptools API. Future releases
    of setuptools are likely to remove this function.
  * #3202: Changed behaviour of auto-discovery to not explicitly
    expand package_dir for flat-layouts and to not use relative
    paths starting with ./.
  * #3203: Prevented pyproject.toml parsing from overwriting
    dist.include_package_data explicitly set in setup.py with
    default value.
  * #3208: Added a warning for non existing files listed with the
    file directive in setup.cfg and pyproject.toml.
  * #3208: Added a default value for dynamic classifiers in
    pyproject.toml when files are missing and errors being ignored.
  * #3211: Disabled auto-discovery when distribution class has a
    configuration attribute (e.g. when the setup.py script contains
    setup(..., configuration=...)). This is done to ensure
    extension-only packages created with
    numpy.distutils.misc_util.Configuration are not broken by the
    safe guard behaviour to avoid accidental multiple top-level
    packages in a flat-layout.
  * Note Users that don't set packages, py_modules, or
    configuration are still likely to observe the auto-discovery
    behavior, which may halt the build if the project contains
    multiple directories and/or multiple Python files directly
    under the project root. To disable auto-discovery please
    explicitly set either packages or py_modules. Alternatively you
    can also configure :ref:`custom-discovery`.
- v61.0.0
  * #3068: Deprecated setuptools.config.read_configuration,
    setuptools.config.parse_configuration and other functions or
    classes from setuptools.config.
  * Users that still need to parse and process configuration from
    setup.cfg can import a direct replacement from
    setuptools.config.setupcfg, however this module is transitional
    and might be removed in the future (the setup.cfg configuration
    format itself is likely to be deprecated in the future).
  * #2894: If you purposefully want to create an "empty
    distribution", please be aware that some Python files (or
    general folders) might be automatically detected and included.
  * Projects that currently don't specify both packages and
    py_modules in their configuration and contain extra folders or
    Python files (not meant for distribution), might see these
    files being included in the wheel archive or even experience
    the build to fail.
  * You can check details about the automatic discovery (and how to
    configure a different behaviour) in
    :doc:`/userguide/package_discovery`.
  * #3067: If the file pyproject.toml exists and it includes
    project metadata/config (via [project] table or
    [tool.setuptools]), a series of new behaviors that are not
    backward compatible may take place:
  - The default value of include_package_data will be considered
    to be True.
  - Setuptools will attempt to validate the pyproject.toml file
    according to PEP 621 specification.
  - The values specified in pyproject.toml will take precedence
    over those specified in setup.cfg or setup.py.
  * #2887: [EXPERIMENTAL] Added automatic discovery for py_modules
    and packages -- by :user:`abravalheri`.
  - Setuptools will try to find these values assuming that the
    package uses either the src-layout (a src directory
    containing all the packages or modules), the flat-layout
    (package directories directly under the project root), or the
    single-module approach (an isolated Python file, directly
    under the project root).
  - The automatic discovery will also respect layouts that are
    explicitly configured using the package_dir option.
  - For backward-compatibility, this behavior will be observed
    only if both py_modules and packages are not set. (Note:
    specifying ext_modules might also prevent auto-discover from
    taking place)
  - If setuptools detects modules or packages that are not
    supposed to be in the distribution, please manually set
    py_modules and packages in your setup.cfg or setup.py file.
    If you are using a flat-layout, you can also consider
    switching to src-layout.
  * #2887: [EXPERIMENTAL] Added automatic configuration for the
    name metadata -- by :user:`abravalheri`.
  - Setuptools will adopt the name of the top-level package (or
    module in the case of single-module distributions), only when
    name is not explicitly provided.
  - Please note that it is not possible to automatically derive a
    single name when the distribution consists of multiple
    top-level packages or modules.
  * #3066: Added vendored dependencies for :pypi:`tomli`,
    :pypi:`validate-pyproject`.
  - These dependencies are used to read pyproject.toml files and
    validate them.
  * #3067: [EXPERIMENTAL] When using pyproject.toml metadata, the
    default value of include_package_data is changed to True.
  * #3068: [EXPERIMENTAL] Add support for pyproject.toml
    configuration (as introduced by PEP 621). Configuration
    parameters not covered by standards are handled in the
    [tool.setuptools] sub-table.
  - In the future, existing setup.cfg configuration may be
    automatically converted into the pyproject.toml equivalent
    before taking effect (as proposed in #1688). Meanwhile users
    can use automated tools like :pypi:`ini2toml` to help in the
    transition.
  - Please note that the legacy backend is not guaranteed to work
    with pyproject.toml configuration.
  * #3125: Implicit namespaces (as introduced in PEP 420) are now
    considered by default during :doc:`package discovery
    </userguide/package_discovery>`, when setuptools configuration
    and project metadata are added to the pyproject.toml file.
  - To disable this behaviour, use namespaces = False when
    explicitly setting the [tool.setuptools.packages.find]
    section in pyproject.toml.
  - This change is backwards compatible and does not affect the
    behaviour of configuration done in setup.cfg or setup.py.
  * #3152: [EXPERIMENTAL] Added support for attr: and cmdclass
    configurations in setup.cfg and pyproject.toml when package_dir
    is implicitly found via auto-discovery.
  * #3178: Postponed importing ctypes when hiding files on Windows.
    This helps to prevent errors in systems that might not have
    libffi installed.
  * #3179: Merge with pypa/distutils@267dbd25ac
- v60.10.0
  * #2971: Deprecated upload_docs command, to be removed in the
    future.
  * #3137: Use samefile from stdlib, supported on Windows since
    Python 3.2.
  * #3170: Adopt nspektr (vendored) to implement
    Distribution._install_dependencies.
  * #3120: Added workaround for intermittent failures of backend
    tests on PyPy. These tests now are marked with XFAIL, instead
    of erroring out directly.
  * #3124: Improved configuration for :pypi:`rst-linker` (extension
    used to build the changelog).
  * #3133: Enhanced isolation of tests using virtual environments -
    PYTHONPATH is not leaking to spawned subprocesses -- by
    :user:`befeleme`
  * #3147: Added options to provide a pre-built setuptools wheel or
    sdist for being used during tests with virtual environments.
    Paths for these pre-built distribution files can now be set via
    the environment variables: PRE_BUILT_SETUPTOOLS_SDIST and
    PRE_BUILT_SETUPTOOLS_WHEEL.
- v60.9.2
  * #3035: When loading distutils from the vendored copy, rewrite
    __name__ to ensure consistent importing from inside and out.
- v60.9.1
  * #3102: Prevent vendored importlib_metadata from loading
    distributions from older importlib_metadata.
  * #3103: Fixed issue where string-based entry points would be
    omitted.
  * #3107: Bump importlib_metadata to 4.11.1 addressing issue with
    parsing requirements in egg-info as found in PyPy.
- v60.9.0
  * #2876: In the build backend, allow single config settings to be
    supplied.
  * #2993: Removed workaround in distutils hack for get-pip now
    that pypa/get-pip#137 is closed.
  * #3085: Setuptools no longer relies on pkg_resources for entry
    point handling.
  * #3098: Bump vendored packaging to 21.3.
  * Removed bootstrap script.
  * Warning: Users trying to install the unmaintained
    :pypi:`pathlib` backport from PyPI/sdist/source code may find
    problems when using setuptools >= 60.9.0. This happens because
    during the installation, the unmaintained implementation of
    pathlib is loaded and may cause compatibility problems (it does
    not expose the same public API defined in the Python standard
    library). Whenever possible users should avoid declaring
    pathlib as a dependency. An alternative is to pre-build a wheel
    for pathlib using a separated virtual environment with an older
    version of setuptools and install the library directly from the
    pre-built wheel.
- v60.8.2
  * #3091: Make concurrent.futures import lazy in vendored
    more_itertools package to a avoid importing threading as a side
    effect (which caused gevent/gevent#1865). -- by
    :user:`maciejp-ro`
- v60.8.1
  * #3084: When vendoring jaraco packages, ensure the namespace
    package is converted to a simple package to support zip
    importer.
- v60.8.0
  * #3085: Setuptools now vendors importlib_resources and
    importlib_metadata and jaraco.text. Setuptools no longer relies
    on pkg_resources for ensure_directory nor parse_requirements.
- v60.7.1
  * #3072: Remove lorem_ipsum from jaraco.text when vendored.
- v60.7.0
  * #3061: Vendored jaraco.text and use line processing from that
    library in pkg_resources.
  * #3070: Avoid AttributeError in easy_install.create_home_path
    when sysconfig.get_config_vars values are not strings.
- v60.6.0
  * #3043: Merge with pypa/distutils@bb018f1ac3 including
    consolidated behavior in sysconfig.get_platform
    (pypa/distutils#104).
  * #3057: Don't include optional Home-page in metadata if no url
    is specified. -- by :user:`cdce8p`
  * #3062: Merge with pypa/distutils@b53a824ec3 including improved
    support for lib directories on non-x64 Windows builds.
  * #3054: Used Py3 syntax super().__init__() -- by
    :user:`imba-tjd`
- v60.5.4
  * #3009: Remove filtering of distutils warnings.
  * #3031: Suppress distutils replacement when building or testing
    CPython.
- v60.5.3
  * #3026: Honor sysconfig variables in easy_install.
- v60.5.2
  * #2993: In _distutils_hack, for get-pip, simulate existence of
    setuptools.
- v60.5.1
  * #2918: Correct support for Python 3 native loaders.
- v60.5.0
  * #2990: Set the .origin attribute of the distutils module to the
    module's __file__.
- v60.4.0
  * #2839: Removed requires sorting when installing wheels as an
    egg dir.
  * #2953: Fixed a bug that easy install incorrectly parsed Python
    3.10 version string.
  * #3006: Fixed startup performance issue of Python interpreter
    due to imports of costly modules in _distutils_hack -- by
    :user:`tiran`
  * #2862: Added integration tests that focus on building and
    installing some packages in the Python ecosystem via pip -- by
    :user:`abravalheri`
  * #2952: Modified "vendoring" logic to keep license files.
  * #2968: Improved isolation for some tests that where
    inadvertently using the project root for builds, and therefore
    creating directories (e.g. build, dist, *.egg-info) that could
    interfere with the outcome of other tests -- by
    :user:`abravalheri`.
  * #2968: Introduced new test fixtures venv,
    venv_without_setuptools, bare_venv that rely on the jaraco.envs
    package. These new test fixtures were also used to remove the
    (currently problematic) dependency on the pytest_virtualenv
    plugin.
  * #2968: Removed tmp_src test fixture. Previously this fixture
    was copying all the files and folders under the project root,
    including the .git directory, which is error prone and
    increases testing time. Since tmp_src was used to populate
    virtual environments (installing the version of setuptools
    under test via the source tree), it was replaced by the new
    setuptools_sdist and setuptools_wheel fixtures (that are build
    only once per session testing and can be shared between all the
    workers for read-only usage).
- v60.3.1
  * #3002: Suppress AttributeError when detecting get-pip.
- v60.3.0
  * #2993: In _distutils_hack, bypass the distutils exception for
    pip when get-pip is being invoked, because it imports
    setuptools.
  * #2989: Merge with pypa/distutils@788cc159. Includes fix for
    config vars missing from sysconfig.
- v60.2.0
  * #2974: Setuptools now relies on the Python logging
    infrastructure to log messages. Instead of using
    distutils.log.*, use logging.getLogger(name).*.
  * #2987: Sync with
    pypa/distutils@2def21c5d74fdd2fe7996ee4030ac145a9d751bd,
    including fix for missing get_versions attribute (#2969), more
    reliance on sysconfig from stdlib.
  * #2962: Avoid attempting to use local distutils when the
    presiding version of Setuptools on the path doesn't have one.
  * #2983: Restore 'add_shim' as the way to invoke the hook. Avoids
    compatibility issues between different versions of Setuptools
    with the distutils local implementation.
- v60.1.1
  * #2980: Bypass distutils loader when setuptools module is no
    longer available on sys.path.
- v60.1.0
  * #2958: In distutils_hack, only add the metadata finder once. In
    ensure_local_distutils, rely on a context manager for reliable
    manipulation.
  * #2963: Merge with pypa/distutils@a5af364910. Includes revisited
    fix for pypa/distutils#15 and improved MinGW/Cygwin support
    from pypa/distutils#77.
- v60.0.5
  * #2960: Install schemes fall back to default scheme for headers.
- v60.0.4
  * #2954: Merge with pypa/distutils@eba2bcd310. Adds platsubdir to
    config vars available for substitution.
- v60.0.3
  * #2940: Avoid KeyError in distutils hack when pip is imported
    during ensurepip.
- v60.0.2
  * #2938: Select 'posix_user' for the scheme unless falling back
    to stdlib, then use 'unix_user'.
- v60.0.1
  * #2944: Add support for extended install schemes in
    easy_install.
- v60.0.0
  * #2896: Setuptools once again makes its local copy of distutils
    the default. To override, set SETUPTOOLS_USE_DISTUTILS=stdlib.
- v59.8.0
  * #2935: Merge
    pypa/distutils@460b59f0e68dba17e2465e8dd421bbc14b994d1f.
- v59.7.0
  * #2930: Require Python 3.7
- v59.6.0
  * #2925: Merge with pypa/distutils@92082ee42c including
    introduction of deprecation warning on Version classes.
- v59.4.0
  * #2893: Restore deprecated support for newlines in the Summary
    field.
- v59.3.0
  * #2906: In ensure_local_distutils, re-use DistutilsMetaFinder to
    load the module. Avoids race conditions when
    _distutils_system_mod is employed.
- v59.2.0
  * #2875: Introduce changes from pypa/distutils@514e9d0, including
    support for overrides from Debian and pkgsrc, unlocking the
    possibility of making SETUPTOOLS_USE_DISTUTILS=local the
    default again.
- v59.1.1
  + #2885: Fixed errors when encountering LegacyVersions.
- v59.1.0
  * #2497: Update packaging to 21.2.
  * #2877: Back out deprecation of setup_requires and replace
    instead by a deprecation of setuptools.installer and
    fetch_build_egg. Now setup_requires is still supported when
    installed as part of a PEP 517 build, but is deprecated when an
    unsatisfied requirement is encountered.
- v59.0.1
  * #2880: Removed URL requirement for pytest-virtualenv in
    setup.cfg. PyPI rejects packages with dependencies external to
    itself. Instead the test dependency was overwritten via tox.ini
- v59.0.0
  * #2856: Support for custom commands that inherit directly from
    distutils is deprecated. Users should extend classes provided
    by setuptools instead.
  * #2870: Started failing on invalid inline description with line
    breaks :class:`ValueError` -- by :user:`webknjaz`
  * #2698: Exposed exception classes from distutils.errors via
    setuptools.errors.
  * #2866: Incorporate changes from pypa/distutils@f1b0a2b.
- v58.5.3
  * #2849: Add fallback for custom build_py commands inheriting
    directly from :mod:`distutils`, while still handling
    include_package_data=True for sdist.
- v58.5.2
  * #2847: Suppress 'setup.py install' warning under bdist_wheel.
- v58.5.1
  * #2846: Move PkgResourcesDeprecationWarning above
    implicitly-called function so that it's in the namespace when
    version warnings are generated in an environment that contains
    them.
- v58.5.0
  * #1461: Fix inconsistency with include_package_data and
    packages_data in sdist by replacing the loop breaking mechanism
    between the sdist and egg_info commands -- by
    :user:`abravalheri`
- v58.4.0
  * #2497: Officially deprecated PEP 440 non-compliant versions.
- Refresh patches
  * sort-for-reproducibility.patch
  * remove_mock.patch
- Do not replace the vendored imports from .extern anymore
  * Upstream vendors more packages than before and we need to avoid
    buildcycles, too.
  * The vendored stuff was packaged all the time.
  * Update License tag for vendored stuff.
  * Drop remove-more-itertools-dependency-cycle.patch
* Fri Mar 25 2022 steven.kowalik@suse.com
- Refresh remove_mock.patch to add a missing file to it.
* Mon Feb  7 2022 dmueller@suse.com
- update to 58.3.0:
  * ``setup.py install`` and ``easy_install`` commands are now officially
    deprecated. Use other standards-based installers (like pip) and builders (like
    build). Workloads reliant on this behavior should pin to this major version of
    Setuptools.
  * #1988: Deprecated the ``bdist_rpm`` command.
  * #2785: Replace confirparser's readfp with read_file, deprecated since Python 3.2.
  * #2823: Officially deprecated support for ``setup_requires``. Users are
    encouraged instead to migrate to PEP 518 ``build-system.requires`` in
    ``pyproject.toml``. Users reliant on ``setup_requires`` should consider
    pinning to this major version to avoid disruption.
  * #2762: Changed codecov.yml to configure the threshold to be lower
  * #2757: Add windows arm64 launchers for scripts generated by easy_install.
  * #2800: Added ``--owner`` and ``--group`` options to the ``sdist`` command,
    for specifying file ownership within the produced tarball (similarly
    to the corresponding distutils ``sdist`` options).
  * #2792: Document how the legacy and non-legacy versions are compared, and
    reference to the `PEP 440 <https://www.python.org/dev/peps/pep-0440/>`_
    scheme.
  * #2773: Retain case in setup.cfg during sdist.
  * #2777: Build does not fail fast when ``use_2to3`` is supplied but set to a
    false value.
  * #2769: Build now fails fast when ``use_2to3`` is supplied.
  * #2765: In Distribution.finalize_options, suppress known removed entry points
    to avoid issues with older Setuptools.
  * #2086: Removed support for 2to3 during builds. Projects should port to a
    unified codebase or pin to an older version of Setuptools using PEP 518
    build-requires.
  * #2712: Added implicit globbing support for `[options.data_files]` values.
  * #2737: fix various syntax and style errors in code snippets in docs
* Thu Dec 23 2021 dimstar@opensuse.org
- Remove unzip BuildRequires: the tarball is proper gz compressed,
  no zip files to decompress here.
* Thu Jul 22 2021 arun@gmx.de
- update to version 57.4.0:
  * Changes
    + #2722: Added support for SETUPTOOLS_EXT_SUFFIX environment
    variable to override the suffix normally detected from the
    sysconfig module.
- changes from version 57.3.0:
  * Changes
    + #2465: Documentation is now published using the Furo theme.
- changes from version 57.2.0:
  * Changes
    + #2724: Added detection of Windows ARM64 build environments using
    the VSCMD_ARG_TGT_ARCH environment variable.
- changes from version 57.1.0:
  * Changes
    + #2692: Globs are now sorted in 'license_files' restoring
    reproducibility by eliminating variance from disk order.
    + #2714: Update to distutils at pypa/distutils@e2627b7.
    + #2715: Removed reliance on deprecated ssl.match_hostname by
    removing the ssl support. Now any index operations rely on the
    native SSL implementation.
  * Documentation changes
    + #2604: Revamped the backward/cross tool compatibility section to
    remove some confusion. Add some examples and the version since
    when entry_points are supported in declarative
    configuration. Tried to make the reading flow a bit leaner,
    gather some informations that were a bit dispersed.
* Mon Jul  5 2021 alarrosa@suse.com
- Add patch to remove a dependency cycle between
  python-more-itertools and python-setuptools (which requires the
  former just for one simple function):
  * remove-more-itertools-dependency-cycle.patch
* Fri Jun 25 2021 code@bnavigator.de
- Update to 57.0.0
  * big changelog since 44.1, see CHANGES.rst.
- No python2 support anymore.
- Refresh sort-for-reproducibility.patch and remove_mock.patch.
- Drop importlib.patch, fixed upstream.
- Remove testdata.tar.gz, packaged upstream.
- Update requirements.
  * New Ring-1 dep: python-jaraco.path <-- python-singledispatch
* Thu Jun 17 2021 code@bnavigator.de
- Add python dist provides for setuptools, pkg_resources and
  easy_install: work around boo#1186870
- Dont create a package for -test flavor
* Fri Jan 22 2021 mcepl@suse.com
- We cannot remove vendored packages when generating setuptools
  wheel (bsc#1177127).
* Tue Dec  8 2020 mcepl@suse.com
- Add remove_mock.patch to remove dependency on the external mock
  package.
* Mon Nov 16 2020 mcepl@suse.com
- Avoid duplicite wheel name in the generated package, and we actually
  don't need a subpackage at all.
* Thu Nov 12 2020 mcepl@suse.com
- Make wheel a separate build run to avoid the setuptools/wheel build
  cycle.
* Tue Nov 10 2020 mcepl@suse.com
- Add wheel subpackage with the generated wheel for this package
  (bsc#1176262, CVE-2019-20916).
* Thu Aug 13 2020 mimi.vx@gmail.com
- update to 44.1.0
  * Set sys.argv[0] in setup script run by build_meta.__legacy__
  * Fix for Python 4: replace unsafe six.PY3 with six.PY2
  * Fixed a bug in the “setuptools.finalize_distribution_options” hook
    that lead to ignoring the order attribute of entry points managed
    by this hook.
  * Avoid loading working set during Distribution.finalize_options prior
    to invoking _install_setup_requires, broken since v42.0.0.
* Tue Jun 23 2020 code@bnavigator.de
- use local source dir for pytest imports
  gh#openSUSE/python-rpm-macros#48
* Mon Apr  6 2020 mcepl@suse.com
- Fix License to the correct MIT
* Fri Mar 13 2020 tchvatal@suse.com
- Fix build without python2
* Tue Feb  4 2020 mimi.vx@gmail.com
- update to 44.0.0
- last version with python2 support
- add testdata.tar.gz -> missing data for testsuite
  * Drop support for Python 3.4.
  * include pyproject.toml in source distribution by default.
    Projects relying on the previous behavior where pyproject.toml
  * Setuptools once again declares 'setuptools' in the build-system.requires
    and adds PEP 517 build support by declaring itself as the build-backend
  * Fix support for easy_install's find-links option in setup.cfg
  * Build dependencies (setup_requires and tests_require) now install transitive
    dependencies indicated by extras.
  * Mark the easy_install script and setuptools command as deprecated, and use
    pip when available to fetch/build wheels for missing setup_requires/tests_require
    requirements, with the following differences in behavior:
    + support for python_requires
    + better support for wheels (proper handling of priority with respect to PEP 425 tags)
    + PEP 517/518 support
    + eggs are not supported
    + no support for the allow_hosts easy_install option (index_url/find_links are still honored)
    + pip environment variables are honored (and take precedence over easy_install options)
  * Removed the "upload" and "register" commands in favor of twine.
  * Add support for the license_files option in setup.cfg to automatically
    include multiple license files in a source distribution.
  * Update handling of wheels compatibility tags: * add support for manylinux2010
  * fix use of removed 'm' ABI flag in Python 3.8 on Windows
  * Fix empty namespace package installation from wheel.
  * Setuptools now exposes a new entry point hook "setuptools.finalize_distribution_options",
    enabling plugins like setuptools_scm to configure options on the distribution
    at finalization time.
* Mon Nov 11 2019 mimi.vx@gmail.com
- update to 41.6.0
- add importlib.patch
  * Replace usage of deprecated imp module with local
    re-implementation in setuptools._imp
  * Fix pkg_resources.Requirement hash/equality implementation
  * Fix tests when running under python3.10.
  * drop 'deprecated' documentation (test command, ez_setup, EasyInstall)
* Thu Oct 17 2019 stefan.bruens@rwth-aachen.de
- Remove runtime dependency for the full python3 package, as the
  actually required SSL module is in python3-base. For python(2),
  SSL is in the "full" python package. Avoids build loops and
  shortens the dependency chain for e.g. rust.
* Wed Oct 16 2019 tchvatal@suse.com
- Try to use system packages rather than the vendored variants
* Wed Oct 16 2019 tchvatal@suse.com
- Add patch to sort outputs for better reproducability:
  * sort-for-reproducibility.patch
- Add missing dep on ordered-set as it is now in the vendored
  dir too
* Fri Oct 11 2019 mcalabkova@suse.com
- Update to 41.4.0
  * In declarative config, now traps errors when invalid python_requires
    values are supplied.
  * When storing extras, rely on OrderedSet to retain order of extras
    as indicated by the packager, which will also be deterministic
    on Python 2.7 (with PYTHONHASHSEED unset) and Python 3.6+.
  * Fixed failing integration test triggered by 'long_description_content_type' in packaging.
* Sat Sep 14 2019 jayvdb@gmail.com
- Define LANG in %%check to fix openSUSE/SLE 15 testsuite
* Wed Aug 21 2019 tchvatal@suse.com
- Switch to multibuild to enable testsuite
* Wed Aug 21 2019 tchvatal@suse.com
- Update to 41.2.0:
  * #479: Remove some usage of the deprecated imp module.
  * #1565: Changed html_sidebars from string to list of string as per https://www.sphinx-doc.org/en/master/changes.html#id58
  * #1697: Moved most of the constants from setup.py to setup.cfg
  * #1756: Forse metadata-version >= 1.2. when project urls are present.
* Sat May  4 2019 arun@gmx.de
- update to version 41.0.1:
  * #1671: Fixed issue with the PEP 517 backend that prevented
    building a wheel when the dist/ directory contained existing .whl
    files.
  * #1709: In test.paths_on_python_path, avoid adding unnecessary
    duplicates to the PYTHONPATH.
  * #1741: In package_index, now honor "current directory" during a
    checkout of git and hg repositories under Windows
* Tue Apr 16 2019 mimi.vx@gmail.com
- update to 41.0.0
  * #1735: When parsing setup.cfg files, setuptools now requires the files
    to be encoded as UTF-8. Any other encoding will lead to a UnicodeDecodeError.
    This change removes support for specifying an encoding using a 'coding: '
    directive in the header of the file, a feature that was introduces in 40.7.
    Given the recent release of the aforementioned feature, it is assumed that
    few if any projects are utilizing the feature to specify an encoding
    other than UTF-8.
* Sun Feb 10 2019 arun@gmx.de
- update to version 40.8.0:
  * #1652: Added the build_meta:__legacy__ backend, a "compatibility
    mode" PEP 517 backend that can be used as the default when
    build-backend is left unspecified in pyproject.toml.
  * #1635: Resource paths are passed to pkg_resources.resource_string
    and similar no longer accept paths that traverse parents, that
    begin with a leading /. Violations of this expectation raise
    DeprecationWarnings and will become errors. Additionally, any
    paths that are absolute on Windows are strictly disallowed and
    will raise ValueErrors.
  * #1536: setuptools will now automatically include licenses if
    setup.cfg contains a license_file attribute, unless this file is
    manually excluded inside MANIFEST.in.
- changes from version 40.7.3:
  * #1670: In package_index, revert to using a copy of splituser from
    Python 3.8. Attempts to use urllib.parse.urlparse led to problems
    as reported in #1663 and #1668. This change serves as an
    alternative to #1499 and fixes #1668.
* Sat Feb  2 2019 arun@gmx.de
- update to version 40.7.2:
  * #1666: Restore port in URL handling in package_index.
- changes from version 40.7.1:
  * #1660: On Python 2, when reading config files, downcast options
    from text to bytes to satisfy distutils expectations.
- changes from version 40.7.0:
  * #1551: File inputs for the license field in setup.cfg files now
    explicitly raise an error.
  * #1180: Add support for non-ASCII in setup.cfg (#1062). Add support
    for native strings on some parameters (#1136).
  * #1499: setuptools.package_index no longer relies on the deprecated
    urllib.parse.splituser per Python #27485.
  * #1544: Added tests for PackageIndex.download (for git URLs).
  * #1625: In PEP 517 build_meta builder, ensure that sdists are built
    as gztar per the spec.
* Thu Jan 17 2019 dimstar@opensuse.org
- BuildIgnore python[23]-pyparsing: python-packaging requires it
  for some actions it could perform, but we don't make use of these
  here. Ignoring this dependency allows us to break open a
  BuildCycle.
* Thu Dec 13 2018 tbechtold@suse.com
- update to 40.6.3:
  * #1594: PEP 517 backend no longer declares setuptools as a dependency
  as it can be assumed.
* Thu Dec  6 2018 tchvatal@suse.com
- Fix fdupes call
* Thu Nov 22 2018 arun@gmx.de
- update to version 40.6.2:
  * #1592: Fix invalid dependency on external six module (instead of
    vendored version).
- changes from version 40.6.1:
  * #1590: Fixed regression where packages without author or
    author_email fields generated malformed package metadata.
- changes from version 40.6.0:
  * #1541: Officially deprecated the requires parameter in setup().
  * #1519: In pkg_resources.normalize_path, additional path
    normalization is now performed to ensure path values to a
    directory is always the same, preventing false positives when
    checking scripts have a consistent prefix to set up on Windows.
  * #1545: Changed the warning class of all deprecation warnings;
    deprecation warning classes are no longer derived from
    DeprecationWarning and are thus visible by default.
  * #1554: build_meta.build_sdist now includes setup.py in source
    distributions by default.
  * #1576: Started monkey-patching get_metadata_version and
    read_pkg_file onto distutils.DistributionMetadata to retain the
    correct version on the PKG-INFO file in the (deprecated) upload
    command.
  * #1533: Restricted the recursive-include setuptools/_vendor to
    contain only .py and .txt files.
  * #1395: Changed Pyrex references to Cython in the documentation.
  * #1456: Documented that the rpmbuild packages is required for the
    bdist_rpm command.
  * #1537: Documented how to use setup.cfg for src/ layouts
  * #1539: Added minimum version column in setup.cfg metadata table.
  * #1552: Fixed a minor typo in the python 2/3 compatibility
    documentation.
  * #1553: Updated installation instructions to point to pip install
    instead of ez_setup.py.
  * #1560: Updated setuptools distribution documentation to remove
    some outdated information.
  * #1564: Documented setup.cfg minimum version for version and
    project_urls.
  * #1572: Added the concurrent.futures backport futures to the Python
    2.7 test suite requirements.
* Tue Oct 30 2018 arun@gmx.de
- update to version 40.5.0:
  * #1335: In pkg_resources.normalize_path, fix issue on Cygwin when
    cwd contains symlinks.
  * #1502: Deprecated support for downloads from Subversion in
    package_index/easy_install.
  * #1517: Dropped use of six.u in favor of u"" literals.
  * #1520: Added support for data_files in setup.cfg.
  * #1525: Fixed rendering of the deprecation warning in easy_install
    doc.
* Sun Sep 30 2018 arun@gmx.de
- update to version 40.4.3:
  * #1480: Bump vendored pyparsing in pkg_resources to 2.2.1.
- changes from version 40.4.2:
  * #1497: Updated gitignore in repo.
- changes from version 40.4.1:
  * #1480: Bump vendored pyparsing to 2.2.1.
- changes from version 40.4.0:
  * #1481: Join the sdist --dist-dir and the build_meta sdist
    directory argument to point to the same target (meaning the build
    frontend no longer needs to clean manually the dist dir to avoid
    multiple sdist presence, and setuptools no longer needs to handle
    conflicts between the two).
- changes from version 40.3.0:
  * #1402: Fixed a bug with namespace packages under Python 3.6 when
    one package in current directory hides another which is
    installed.
  * #1427: Set timestamp of .egg-info directory whenever egg_info
    command is run.
  * #1474: build_meta.get_requires_for_build_sdist now does not
    include the wheel package anymore.
  * #1486: Suppress warnings in pkg_resources.handle_ns.
  * #1479: Remove internal use of six.binary_type.
* Sat Sep  1 2018 arun@gmx.de
- update to version 40.2.0:
  * #1466: Fix handling of Unicode arguments in PEP 517 backend
- changes from version 40.1.1:
  * #1465: Fix regression with egg_info command when tagging is used.
* Sat Aug 25 2018 jengelh@inai.de
- Use noun phrase in summary.
* Sat Aug 18 2018 arun@gmx.de
- specfile:
  * removed devel for noarch package
- update to version 40.1.0:
  * #1410: Deprecated upload and register commands.
  * #1312: Introduced find_namespace_packages() to find PEP 420
    namespace packages.
  * #1420: Added find_namespace: directive to config parser.
  * #1418: Solved race in when creating egg cache directories.
  * #1450: Upgraded vendored PyParsing from 2.1.10 to 2.2.0.
  * #1451: Upgraded vendored appdirs from 1.4.0 to 1.4.3.
  * #1388: Fixed "Microsoft Visual C++ Build Tools" link in exception
    when Visual C++ not found.
  * #1389: Added support for scripts which have unicode content.
  * #1416: Moved several Python version checks over to using six.PY2
    and six.PY3.
  * #1441: Removed spurious executable permissions from files that
    don't need them.
* Thu Jul 12 2018 arun@gmx.de
- update to version 40.0.0:
  * #1342: Drop support for Python 3.3.
  * #1366: In package_index, fixed handling of encoded entities in
    URLs.
  * #1383: In pkg_resources VendorImporter, avoid removing packages
    imported from the root.
  * #1379: Minor doc fixes after actually using the new release
    process.
  * #1385: Removed section on non-package data files.
  * #1403: Fix developer's guide.
  * #1404: Fix PEP 518 configuration: set build requirements in
    pyproject.toml to ["wheel"].
* Mon May 21 2018 arun@gmx.de
- update to version 39.2.0:
  * #1359: Support using "file:" to load a PEP 440-compliant package
    version from a text file.
  * #1360: Fixed issue with a mismatch between the name of the package
    and the name of the .dist-info file in wheel files
  * #1364: Add __dir__() implementation to
    pkg_resources.Distribution() that includes the attributes in the
    _provider instance variable.
  * #1365: Take the package_dir option into account when loading the
    version from a module attribute.
  * #1353: Added coverage badge to README.
  * #1356: Made small fixes to the developer guide documentation.
  * #1357: Fixed warnings in documentation builds and started
    enforcing that the docs build without warnings in tox.
  * #1376: Updated release process docs.
  * #1343: The setuptools specific long_description_content_type,
    project_urls and provides_extras fields are now set consistently
    after any distutils setup_keywords calls, allowing them to
    override values.
  * #1352: Added tox environment for documentation builds.
  * #1354: Added towncrier for changelog managment.
  * #1355: Add PR template.
  * #1368: Fixed tests which failed without network connectivity.
  * #1369: Added unit tests for PEP 425 compatibility tags support.
  * #1372: Stop testing Python 3.3 in Travis CI, now that the latest
    version of wheel no longer installs on it.
* Sun May  6 2018 arun@gmx.de
- update to version 39.1.0:
  * #1340: Update all PyPI URLs to reflect the switch to the new
    Warehouse codebase.
  * #1337: In pkg_resources, now support loading resources for modules
    loaded by the SourcelessFileLoader.
  * #1332: Silence spurious wheel related warnings on Windows.
* Tue Apr 24 2018 jgonzalez@suse.com
- build python3 subpackage (FATE#323875)
* Mon Mar 19 2018 tchvatal@suse.com
- Version update to 39.0.1:
  * Fix utf parsing with python2
  * Various other fixes
* Sat Mar 17 2018 arun@gmx.de
- update to version 39.0.0:
  * #1296: Setuptools now vendors its own direct dependencies, no
    longer relying on the dependencies as vendored by pkg_resources.
  * #296: Removed long-deprecated support for iteration on Version
    objects as returned by pkg_resources.parse_version. Removed the
    SetuptoolsVersion and SetuptoolsLegacyVersion names as well. They
    should not have been used, but if they were, replace with Version
    and LegacyVersion from packaging.version.
- changes from version 38.7.0:
  * #1288: Add support for maintainer in PKG-INFO.
- changes from version 38.6.1:
  * #1292: Avoid generating Provides-Extra in metadata when no extra
    is present (but environment markers are).
* Sat Mar 17 2018 arun@gmx.de
- update to version 38.6.0:
  * #1286: Add support for Metadata 2.1 (PEP 566).
* Thu Mar  8 2018 arun@gmx.de
- update to version 38.5.2:
  * #1285: Fixed RuntimeError in pkg_resources.parse_requirements on
    Python 3.7 (stemming from PEP 479).
* Wed Mar  7 2018 aplanas@suse.com
- Allows Recommends and Suggest in Fedora
* Tue Feb 27 2018 aplanas@suse.com
- Recommends only for SUSE
* Tue Feb  6 2018 arun@gmx.de
- update to version 38.5.1:
  * #1271: Revert to Cython legacy build_ext behavior for
    compatibility.
- changes from version 38.5.0:
  * #1229: Expand imports in build_ext to refine detection of Cython
    availability.
  * #1270: When Cython is available, build_ext now uses the
    new_build_ext.
* Sun Feb  4 2018 arun@gmx.de
- update to version 38.4.1:
  * #1257: In bdist_egg.scan_module, fix ValueError on Python 3.7.
* Sat Jan  6 2018 arun@gmx.de
- specfile:
  * update copyright year
- update to version 38.4.0:
  * #1231: Removed warning when PYTHONDONTWRITEBYTECODE is enabled.
- changes from version 38.3.0:
  * #1210: Add support for PEP 345 Project-URL metadata.
  * #1207: Add support for long_description_type to setup.cfg
    declarative config as intended and documented.
* Sun Dec 31 2017 arun@gmx.de
- update to version 38.2.5:
  * #1232: Fix trailing slash handling in pkg_resources.ZipProvider.
* Wed Dec  6 2017 arun@gmx.de
- update to version 38.2.4:
  * #1220: Fix data_files handling when installing from wheel.
* Sun Dec  3 2017 arun@gmx.de
- update to version 38.2.3:
  * fix Travis' Python 3.3 job.
- changes from version 38.2.2:
  * #1214: fix handling of namespace packages when installing from a
    wheel.
* Mon Nov 27 2017 mimi.vx@gmail.com
- update to 38.2.1
  * fix encoding handling of metadata when installing from a wheel
* Sun Nov 26 2017 arun@gmx.de
- update to version 38.2.0:
  * #1200: easy_install now support installing from wheels: they will
    be installed as standalone unzipped eggs.
- changes from version 38.1.0:
  * #1208: Improve error message when failing to locate scripts in
    egg-info metadata.
- changes from version 38.0.0:
  * #458: In order to support deterministic builds, Setuptools no
    longer allows packages to declare install_requires as unordered
    sequences (sets or dicts).
* Wed Nov 22 2017 arun@gmx.de
- update to version 37.0.0:
  * #878: Drop support for Python 2.6. Python 2.6 users should rely on
    'setuptools < 37dev'.
- changes from version 36.8.0:
  * #1190: In SSL support for package index operations, use SNI where
    available.
- changes from version 36.7.3:
  * #1175: Bug fixes to build_meta module.
* Fri Nov 17 2017 jengelh@inai.de
- Trim bias from description.
* Wed Nov 15 2017 arun@gmx.de
- specfile:
  * add missing url field
- update to version 36.7.2:
  * #701: Fixed duplicate test discovery on Python 3.
* Sat Nov 11 2017 arun@gmx.de
- update to version 36.7.1:
  * #1193: Avoid test failures in bdist_egg when
    PYTHONDONTWRITEBYTECODE is set.
- changes from version 36.7.0:
  * #1054: Support setup_requires in setup.cfg files.
- changes from version 36.6.1:
  * #1132: Removed redundant and costly serialization/parsing step in
    EntryPoint.__init__.
  * #844: bdist_egg --exclude-source-files now tested and works on
    Python 3.
* Fri Oct 13 2017 arun@gmx.de
- update to version 36.6.0:
  * #1143: Added setuptools.build_meta module, an implementation of
    PEP-517 for Setuptools-defined packages.
  * #1143: Added dist_info command for producing dist_info metadata.
* Tue Sep 19 2017 tbechtold@suse.com
- update to 36.5.0:
  * #170: When working with Mercurial checkouts, use Windows-friendly
    syntax for suppressing output.
  * Inspired by #1134, performed substantial refactoring of
    ``pkg_resources.find_on_path`` to facilitate an optimization
    for paths with many non-version entries.
  * #1075: Add new ``Description-Content-Type`` metadata field. `See here for
    documentation on how to use this field.
    <https://packaging.python.org/specifications/#description-content-type>`_
  * #1068: Sort files and directories when building eggs for
    deterministic order.
  * #196: Remove caching of easy_install command in fetch_build_egg.
    Fixes issue where ``pytest-runner-N.N`` would satisfy the installation
    of ``pytest``.
  * #1129: Fix working set dependencies handling when replacing conflicting
    distributions (e.g. when using ``setup_requires`` with a conflicting
    transitive dependency, fix #1124).
  * #1133: Improved handling of README files extensions and added
    Markdown to the list of searched READMES.
  * #1135: Improve performance of pkg_resources import by not invoking
    ``access`` or ``stat`` and using ``os.listdir`` instead.
  * #1131: Make possible using several files within ``file:`` directive
    in metadata.long_description in ``setup.cfg``.
  * fix #1105: Fix handling of requirements with environment
    markers when declared in ``setup.cfg`` (same treatment as
    for #1081).
  * #462: Don't assume a directory is an egg by the ``.egg``
    extension alone.
  * #1093: Fix test command handler with extras_require.
  * #1112, #1091, #1115: Now using Trusty containers in
    Travis for CI and CD.
  * #1092: ``pkg_resources`` now uses ``inspect.getmro`` to
    resolve classes in method resolution order.
  * #1102: Restore behavior for empty extras.
* Mon Jul 24 2017 michael@stroeder.com
- update to 36.2.2
  v36.2.2
-------
  * #1099: Revert commit a3ec721, restoring intended purpose of
  extras as part of a requirement declaration.
  v36.2.1
-------
  * fix #1086
  * fix #1087
  * support extras specifiers in install_requires requirements
  v36.2.0
-------
  * #1081: Environment markers indicated in ``install_requires``
  are now processed and treated as nameless ``extras_require``
  with markers, allowing their metadata in requires.txt to be
  correctly generated.
  * #1053: Tagged commits are now released using Travis-CI
  build stages, meaning releases depend on passing tests on
  all supported Python versions (Linux) and not just the latest
  Python version.
  v36.1.1
-------
  * #1083: Correct ``py31compat.makedirs`` to correctly honor
  ``exist_ok`` parameter.
  * #1083: Also use makedirs compatibility throughout setuptools.
  v36.1.0
-------
  * #1083: Avoid race condition on directory creation in
  ``pkg_resources.ensure_directory``.
  * Removed deprecation of and restored support for
  ``upload_docs`` command for sites other than PyPI.
  Only warehouse is dropping support, but services like
  `devpi <http://doc.devpi.net/latest/>`_ continue to
  support docs built by setuptools' plugins. See
  `this comment <https://bitbucket.org/hpk42/devpi/issues/388/support-rtd-model-for-building-uploading#comment-34292423>`_
  for more context on the motivation for this change.
* Thu Jun  8 2017 dmueller@suse.com
- update to 36.0.1
  * #1042: Fix import in py27compat module that still
    referenced six directly, rather than through the externs
    module (vendored packages hook).
  * #980 and others: Once again, Setuptools vendors all
    of its dependencies. It seems to be the case that in
    the Python ecosystem, all build tools must run without
    any dependencies (build, runtime, or otherwise). At
    such a point that a mechanism exists that allows
    build tools to have dependencies, Setuptools will adopt
    it.
  * #1015: Fix test failures on Python 3.7.
  * #1024: Add workaround for Jython #2581 in monkey module.
  * #992: Revert change introduced in v34.4.1, now
    considered invalid.
  * #1016: Revert change introduced in v35.0.0 per #1014,
    referencing #436. The approach had unintended
    consequences, causing sdist installs to be missing
    files.
- remove fix-sle11-test-failure.patch: this doesn't build for
  SLE11 anymore, so no need to patch it anymore
* Thu Feb 23 2017 jmatejek@suse.com
- update to 34.2.0
  * dependencies are no longer vendored and setuptools can't bootstrap
    without them
  * drop support for python 2.6 and 3.2
  * declarative config option for setup.cfg
  * nspkg.pth files for development
  * switch to zip format for source dist
  * ensure extras are honored when building the working set
  * add support for reading dist-info metadata
  * support for PEP440 version specifiers
- added build-time and run-time dependencies to appdirs and packaging,
  ensured these packages build without setuptools
- drop upstreamed setuptools-certpath.patch
- drop unneeded setuptools-5.4.1-create-sitedir.patch
- add fdupes
- change source file to zip, add unzip dependency
* Thu Feb 16 2017 jmatejek@suse.com
- update for multipython build
* Mon Dec 12 2016 hpj@urpla.net
- make sure, that setuptools-certpath.patch is applied
  unconditionally (fixes traceback in setuptools/ssl_support.py)
* Sat Oct  8 2016 tbechtold@suse.com
- update to 28.3.0:
  * #809: In ``find_packages()``, restore support for excluding
    a parent package without excluding a child package.
  * #805: Disable ``-nspkg.pth`` behavior on Python 3.3+ where
    PEP-420 functionality is adequate. Fixes pip #1924.
  * #803: Bump certifi to 2016.9.26.
  * #733: Do not search excluded directories for packages.
    This introduced a backwards incompatible change in ``find_packages()``
    so that ``find_packages(exclude=['foo']) == []``, excluding subpackages of ``foo``.
    Previously, ``find_packages(exclude=['foo']) == ['foo.bar']``,
    even though the parent ``foo`` package was excluded.
  * #795: Bump certifi.
  * #719: Suppress decoding errors and instead log a warning
    when metadata cannot be decoded.
  * #790: In MSVC monkeypatching, explicitly patch each
    function by name in the target module instead of inferring
    the module from the function's ``__module__``. Improves
    compatibility with other packages that might have previously
    patched distutils functions (i.e. NumPy).
  * #794: In test command, add installed eggs to PYTHONPATH
    when invoking tests so that subprocesses will also have the
    dependencies available. Fixes `tox 330
    <https://github.com/tox-dev/tox/issues/330>`_.
  * #795: Update vendored pyparsing 2.1.9.
  * #520 and #513: Suppress ValueErrors in fixup_namespace_packages
    when lookup fails.
  * Nicer, more consistent interfaces for msvc monkeypatching.
  * #779 via #781: Fix circular import.
  * #778: Fix MSVC monkeypatching.
  * Introduce the (private) ``monkey`` module to encapsulate
    the distutils monkeypatching behavior.
  * Now use Warehouse by default for
    ``upload``, patching ``distutils.config.PyPIRCCommand`` to
    affect default behavior.
    Any config in .pypirc should be updated to replace
    https://pypi.python.org/pypi/
    with
    https://upload.pypi.org/legacy/
    Similarly, any passwords stored in the keyring should be
    updated to use this new value for "system".
    The ``upload_docs`` command will continue to use the python.org
    site, but the command is now deprecated. Users are urged to use
    Read The Docs instead.
  * #776: Use EXT_SUFFIX for py_limited_api renaming.
  * #774 and #775: Use LegacyVersion from packaging when
    detecting numpy versions.
  * Re-release of 26.1.0 with pytest pinned to allow for automated
    deployment and thus proper packaging environment variables,
    fixing issues with missing executable launchers.
* Wed Aug 31 2016 jmatejek@suse.com
- fix certificate handling with certifi, add support for SUSE's
  CA bundle (setuptools-certpath.patch, fixes boo#993968)
- remove shebang lines, strip executable bit from README, to silence
  the easy rpmlint warnings
* Tue Aug 30 2016 tbechtold@suse.com
- update to 26.1.1:
  * Re-release of 26.1.0 with pytest pinned to allow for automated
    deployement and thus proper packaging environment variables,
    fixing issues with missing executable launchers.
  * #763: ``pkg_resources.get_default_cache`` now defers to the
    `appdirs project <https://pypi.org/project/appdirs>`_ to
    resolve the cache directory. Adds a vendored dependency on
    appdirs to pkg_resources.
  * #748: By default, sdists are now produced in gzipped tarfile
    format by default on all platforms, adding forward compatibility
    for the same behavior in Python 3.6 (See Python #27819).
  * #459 via #736: On Windows with script launchers,
    sys.argv[0] now reflects
    the name of the entry point, consistent with the behavior in
    distlib and pip wrappers.
  * #752 via #753: When indicating ``py_limited_api`` to Extension,
    it must be passed as a keyword argument.
  * Add Extension(py_limited_api=True). When set to a truthy value,
    that extension gets a filename apropriate for code using Py_LIMITED_API.
    When used correctly this allows a single compiled extension to work on
    all future versions of CPython 3.
    The py_limited_api argument only controls the filename. To be
    compatible with multiple versions of Python 3, the C extension
    will also need to set -DPy_LIMITED_API=... and be modified to use
    only the functions in the limited API.
  * #739 Fix unquoted libpaths by fixing compatibility between
    `numpy.distutils` and `distutils._msvccompiler`
    for numpy < 1.11.2 (Fix issue #728, error also fixed in Numpy).
  * #731: Bump certifi.
  * Style updates. See #740, #741, #743, #744, #742, #747.
  * #735: include license file.
  * #612 via #730: Add a LICENSE file which needs to be provided by the terms of
  the MIT license.
  * #725: revert `library_dir_option` patch (Error is related to
    `numpy.distutils` and make errors on non Numpy users).
  * #720
  * #723: Improve patch for `library_dir_option`.
  * #717
  * #713
  * #707: Fix Python 2 compatibility for MSVC by catching errors properly.
  * #715: Fix unquoted libpaths by patching `library_dir_option`.
  * #714 and #704: Revert fix as it breaks other components
    downstream that can't handle unicode. See #709, #710,
    and #712.
  * #704: Fix errors when installing a zip sdist that contained
    files named with non-ascii characters on Windows would
    crash the install when it attempted to clean up the build.
  * #646: MSVC compatibility - catch errors properly in
    RegistryInfo.lookup.
  * #702: Prevent UnboundLocalError when initial working_set
    is empty.
  * #686: Fix issue in sys.path ordering by pkg_resources when
    rewrite technique is "raw".
  * #699: Fix typo in msvc support.
  * #609: Setuptools will now try to download a distribution from
    the next possible download location if the first download fails.
    This means you can now specify multiple links as ``dependency_links``
    and all links will be tried until a working download link is encountered.
  * #688: Fix AttributeError in setup.py when invoked not from
    the current directory.
  * Cleanup of setup.py script.
  * Fixed documentation builders by allowing setup.py
    to be imported without having bootstrapped the
    metadata.
  * More style cleanup. See #677, #678, #679, #681, #685.
  * #674: Default ``sys.path`` manipulation by easy-install.pth
    is now "raw", meaning that when writing easy-install.pth
    during any install operation, the ``sys.path`` will not be
    rewritten and will no longer give preference to easy_installed
    packages.
    To retain the old behavior when using any easy_install
    operation (including ``setup.py install`` when setuptools is
    present), set the environment variable:
    SETUPTOOLS_SYS_PATH_TECHNIQUE=rewrite
    This project hopes that that few if any environments find it
    necessary to retain the old behavior, and intends to drop
    support for it altogether in a future release. Please report
    any relevant concerns in the ticket for this change.
  * #398: Fix shebang handling on Windows in script
    headers where spaces in ``sys.executable`` would
    produce an improperly-formatted shebang header,
    introduced in 12.0 with the fix for #188.
  * #663, #670: More style updates.
  * #516: Disable ``os.link`` to avoid hard linking
    in ``sdist.make_distribution``, avoiding errors on
    systems that support hard links but not on the
    file system in which the build is occurring.
  * #667: Update Metadata-Version to 1.2 when
    ``python_requires`` is supplied.
  * #631: Add support for ``python_requires`` keyword.
  * More style updates. See #660, #661, #641.
  * #659: ``setup.py`` now will fail fast and with a helpful
    error message when the necessary metadata is missing.
  * More style updates. See #656, #635, #640,
    [#644], #650, #652, and #655.
  * Updated style in much of the codebase to match
    community expectations. See #632, #633, #634,
    [#637], #639, #638, #642, #648.
  * If MSVC++14 is needed ``setuptools.msvc`` now redirect
    user to Visual C++ Build Tools web page.
  * #625 and #626: Fixes on ``setuptools.msvc`` mainly
    for Python 2 and Linux.
  * Pull Request #174: Add more aggressive support for
    standalone Microsoft Visual C++ compilers in
    msvc9compiler patch.
    Particularly : Windows SDK 6.1 and 7.0
    (MSVC++ 9.0), Windows SDK 7.1 (MSVC++ 10.0),
    Visual C++ Build Tools 2015 (MSVC++14)
  * Renamed ``setuptools.msvc9_support`` to
    ``setuptools.msvc``.
  Re-release of v23.2.0, which was missing the intended
  commits.
  * #623: Remove used of deprecated 'U' flag when reading
    manifests.
* Mon Jul  4 2016 dev@stellardeath.org
- Update fix-sle11-test-failure.patch to new line numbers and
  indentation
* Mon Jul  4 2016 tbechtold@suse.com
- Use pypi.io for Source url
* Thu Jun 30 2016 tbechtold@suse.com
-  update to 23.1.0:
  * #619: Deprecated ``tag_svn_revision`` distribution
    option.
  * #611: Removed ARM executables for CLI and GUI script
    launchers on Windows. If this was a feature you cared
    about, please comment in the ticket.
  * #604: Removed docs building support. The project
    now relies on documentation hosted at
    https://setuptools.readthedocs.io/.
  * #604: Restore repository for upload_docs command
    to restore publishing of docs during release.
  * #589: Upload releases to pypi.io using the upload
    hostname and legacy path.
  * #589: Releases are now uploaded to pypi.io (Warehouse)
    even when releases are made on Twine via Travis.
  * #589: Releases are now uploaded to pypi.io (Warehouse).
  * #190: On Python 2, if unicode is passed for packages to
    ``build_py`` command, it will be handled just as with
    text on Python 3.
  * #598: Setuptools now lists itself first in the User-Agent
    for web requests, better following the guidelines in
    `RFC 7231
    <https://tools.ietf.org/html/rfc7231#section-5.5.3>`_.
  * Minor fixes to changelog and docs.
  * #261: Exclude directories when resolving globs in
    package_data.
  * #539: In the easy_install get_site_dirs, honor all
    paths found in ``site.getsitepackages``.
  * #572: In build_ext, now always import ``_CONFIG_VARS``
    from ``distutils`` rather than from ``sysconfig``
    to allow ``distutils.sysconfig.customize_compiler``
    configure the OS X compiler for ``-dynamiclib``.
  * Removed ez_setup.py from Setuptools sdist. The
    bootstrap script will be maintained in its own
    branch and should be generally be retrieved from
    its canonical location at
    https://bootstrap.pypa.io/ez_setup.py.
  * #553: egg_info section is now generated in a
    deterministic order, matching the order generated
    by earlier versions of Python. Except on Python 2.6,
    order is preserved when existing settings are present.
  * #556: Update to Packaging 16.7, restoring support
    for deprecated ``python_implmentation`` marker.
  * #555: Upload command now prompts for a password
    when uploading to PyPI (or other repository) if no
    password is present in .pypirc or in the keyring.
  * #548: Update certify version to 2016.2.28
  * #545: Safely handle deletion of non-zip eggs in rotate
    command.
  * Issue #544: Fix issue with extra environment marker
    processing in WorkingSet due to refactor in v20.7.0.
  * Issue #543: Re-release so that latest release doesn't
    cause déjà vu with distribute and setuptools 0.7 in
    older environments.
  * Refactored extra enviroment marker processing
    in WorkingSet.
  * Issue #533: Fixed intermittent test failures.
  * Issue #536: In msvc9_support, trap additional exceptions
    that might occur when importing
    ``distutils.msvc9compiler`` in mingw environments.
  * Issue #537: Provide better context when package
    metadata fails to decode in UTF-8.
  * Issue #523: Restored support for environment markers,
    now honoring 'extra' environment markers.
  * Issue #523: Disabled support for environment markers
    introduced in v20.5.
  * Issue #503: Restore support for PEP 345 environment
    markers by updating to Packaging 16.6.
  * New release process that relies on
    `bumpversion <https://github.com/peritus/bumpversion>`_
    and Travis CI for continuous deployment.
  * Project versioning semantics now follow
    `semver <https://semver.org>`_ precisely.
    The 'v' prefix on version numbers now also allows
    version numbers to be referenced in the changelog,
    e.g. https://pythonhosted.org/setuptools/history.html#v20-6-0.
  * BB Pull Request #185, #470: Add support for environment markers
    in requirements in install_requires, setup_requires,
    tests_require as well as adding a test for the existing
    extra_requires machinery.
  * Issue #422: Moved hosting to
    `Github <https://github.com/pypa/setuptools>`_
    from `Bitbucket <https://bitbucket.org/pypa/setuptools>`_.
    Issues have been migrated, though all issues and comments
    are attributed to bb-migration. So if you have a particular
    issue or issues to which you've been subscribed, you will
    want to "watch" the equivalent issue in Github.
    The Bitbucket project will be retained for the indefinite
    future, but Github now hosts the canonical project repository.
  * Issue #519: Remove import hook when reloading the
    ``pkg_resources`` module.
  * BB Pull Request #184: Update documentation in ``pkg_resources``
    around new ``Requirement`` implementation.
  * BB Pull Request #179: ``pkg_resources.Requirement`` objects are
    now a subclass of ``packaging.requirements.Requirement``,
    allowing any environment markers and url (if any) to be
    affiliated with the requirement
  * BB Pull Request #179: Restore use of RequirementParseError
    exception unintentionally dropped in 20.2.
* Wed Mar  9 2016 tbechtold@suse.com
- update to 20.2.2:
  * Issue #502: Correct regression in parsing of multiple
    version specifiers separated by commas and spaces.
  * Issue #499: Restore compatiblity for legacy versions
    by bumping to packaging 16.4.
  * Changelog now includes release dates and links to PEPs.
  * Pull Request #173: Replace dual PEP 345 _markerlib implementation
    and PEP 426 implementation of environment marker support from
    packaging 16.1 and PEP 508. Fixes Issue #122.
    See also Pull Request #175, Pull Request #168, and
    Pull Request #164. Additionally:
  - ``Requirement.parse`` no longer retains the order of extras.
  - ``parse_requirements`` now requires that all versions be
    PEP-440 compliant, as revealed in #499. Packages released
    with invalid local versions should be re-released using
    the proper local version syntax, e.g. ``mypkg-1.0+myorg.1``.
  * Update ``upload_docs`` command to also honor keyring
    for password resolution.
  * Added support for using passwords from keyring in the upload
    command.
  * Issue #118: Once again omit the package metadata (egg-info)
    from the list of outputs in ``--record``. This version of setuptools
    can no longer be used to upgrade pip earlier than 6.0.
  * `Off-project PR <https://github.com/jaraco/setuptools/pull/32>`_:
    For FreeBSD, also honor root certificates from ca_root_nss.
* Mon Feb  1 2016 toddrme2178@gmail.com
- update to version 19.6.2:
  * Issue #491: Correct regression incurred in 19.4 where a
    double-namespace package installed using pip would cause a
    TypeError.
- update to version 19.6.1:
  * Restore compatibility for PyPy 3 compatibility lost in 19.4.1
    addressing Issue #487.
  * "setuptools.launch" shim now loads scripts in a new namespace,
    avoiding getting relative imports from the setuptools package on
    Python 2.
- update to version 19.6:
  * Added a new entry script "setuptools.launch", implementing the
    shim found in "pip.util.setuptools_build". Use this command to
    launch distutils-only packages under setuptools in the same way
    that pip does, causing the setuptools monkeypatching of distutils
    to be invoked prior to invoking a script. Useful for debugging or
    otherwise installing a distutils-only package under setuptools
    when pip isn't available or otherwise does not expose the desired
    functionality. For example::
    $ python -m setuptools.launch setup.py develop
  * Issue #488: Fix dual manifestation of Extension class in extension
    packages installed as dependencies when Cython is present.
- update to version 19.5:
  * Issue #486: Correct TypeError when getfilesystemencoding
    returns None.
  * Issue #139: Clarified the license as MIT.
  * Pull Request #169: Removed special handling of command
    spec in scripts for Jython.
- changes from version 19.4.1:
  * Issue #487: Use direct invocation of "importlib.machinery" in
    "pkg_resources" to avoid missing detection on relevant platforms.
- update to version 19.4:
  * Issue #341: Correct error in path handling of package data files
    in "build_py" command when package is empty.
  * Distribute #323, Issue #141, Issue #207, and Pull Request #167:
    Another implementation of "pkg_resources.WorkingSet" and
    "pkg_resources.Distribution" that supports replacing an extant
    package with a new one, allowing for setup_requires dependencies
    to supersede installed packages for the session.
- update to version 19.3:
  * Issue #229: Implement new technique for readily incorporating
    dependencies conditionally from vendored copies or primary
    locations. Adds a new dependency on six.
- update to version 19.2:
  * Pull Request #163: Add get_command_list method to Distribution.
  * Pull Request #162: Add missing whitespace to multiline string
    literals.
- update to version 19.1.1:
  * Issue #476: Cast version to string (using default encoding) to
    avoid creating Unicode types on Python 2 clients.
  * Issue #477: In Powershell downloader, use explicit rendering of
    strings, rather than rely on "repr", which can be incorrect
    (especially on Python 2).
- changes from version 19.1:
  * Issue #215: The bootstrap script "ez_setup.py" now automatically
    detects the latest version of setuptools (using PyPI JSON API)
    rather than hard-coding a particular value.
  * Issue #475: Fix incorrect usage in _translate_metadata2.
- changes from version 19.0:
  * Issue #442: Use RawConfigParser for parsing .pypirc file.
    Interpolated values are no longer honored in .pypirc files.
- update to version 18.8.1:
  * Issue #440: Prevent infinite recursion when a SandboxViolation or
    other UnpickleableException occurs in a sandbox context with
    setuptools hidden. Fixes regression introduced in Setuptools 12.0.
- changes from version 18.8:
  * Deprecated ``egg_info.get_pkg_info_revision``.
  * Issue #471: Don't rely on repr for an HTML attribute value in
    package_index.
  * Issue #419: Avoid errors in FileMetadata when the metadata directory
    is broken.
  * Issue #472: Remove deprecated use of 'U' in mode parameter
    when opening files.
- update to version 18.7.1:
  * Issue #469: Refactored logic for Issue #419 fix to re-use metadata
    loading from Provider.
- update to version 18.7:
  * Update dependency on certify.
  * Pull Request #160: Improve detection of gui script in
    "easy_install._adjust_header".
  * Made "test.test_args" a non-data property; alternate fix
    for the issue reported in Pull Request #155.
  * Issue #453: In "ez_setup" bootstrap module, unload all
    "pkg_resources" modules following download.
  * Pull Request #158: Honor `PEP-488
    <https://www.python.org/dev/peps/pep-0488/>`_ when excluding
    files for namespace packages.
  * Issue #419 and Pull Request #144: Add experimental support for
    reading the version info from distutils-installed metadata rather
    than using the version in the filename.
- update to version 18.6.1:
  * Issue #464: Correct regression in invocation of superclass on
    old-style class on Python 2.
- changes from version 18.6:
  * Issue #439: When installing entry_point scripts under development,
    omit the version number of the package, allowing any version of
    the package to be used.
- update to version 18.5:
  * In preparation for dropping support for Python 3.2, a warning is now
    logged when pkg_resources is imported on Python 3.2 or earlier
    Python 3 versions.
  * `Add support for python_platform_implementation environment marker
    <https://github.com/jaraco/setuptools/pull/28>`_.
  * `Fix dictionary mutation during iteration
    <https://github.com/jaraco/setuptools/pull/29>`_.
* Thu Oct 22 2015 toddrme2178@gmail.com
- Update to 18.4
  * Test command now always invokes unittest,
    even if no test suite is supplied.
* Tue Oct  6 2015 hpj@urpla.net
- update to 18.3.2:
  * Correct another regression in setuptools.findall
    where the fix for Python #12885 was lost.
- update to 18.3.1:
  * Issue #425: Correct regression in setuptools.findall.
- update to 18.3:
  * Setuptools now allows disabling of the manipulation of the sys.path
    during the processing of the easy-install.pth file. To do so, set
    the environment variable ``SETUPTOOLS_SYS_PATH_TECHNIQUE`` to
    anything but "rewrite" (consider "raw"). During any install operation
    with manipulation disabled, setuptools packages will be appended to
    sys.path naturally.
    Future versions may change the default behavior to disable
    manipulation. If so, the default behavior can be retained by setting
    the variable to "rewrite".
  * Issue #257: ``easy_install --version`` now shows more detail
    about the installation location and Python version.
  * Refactor setuptools.findall in preparation for re-submission
    back to distutils.
* Thu Aug 20 2015 tbechtold@suse.com
- update to 18.2:
  * Issue #412: More efficient directory search in ``find_packages``.
* Tue Aug 11 2015 tbechtold@suse.com
- update to 18.1:
  * Upgrade to vendored packaging 15.3.
* Mon Aug  3 2015 jmatejek@suse.com
- update to 18.0.1 for fate#319032
  * see full changelog in CHANGES.txt
* Mon Jul 20 2015 dmueller@suse.com
- update to 18.0.1:
  * Issue #401: Fix failure in test suite.
  * Dropped support for builds with Pyrex. Only Cython is supported.
  * Issue #288: Detect Cython later in the build process, after
    ``setup_requires`` dependencies are resolved.
  * Issue #396: Fixed test failure on OS X.
  * Pull Request #136: Remove excessive quoting from shebang headers
    for Jython.
* Mon Jun 22 2015 tbechtold@suse.com
- update to 17.1.1:
  * Backed out unintended changes to pkg_resources, restoring removal of
    deprecated imp module
* Mon Jun  8 2015 tbechtold@suse.com
- update to 17.1:
  * Issue #380: Add support for range operators on environment
    marker evaluation.
  * Issue #378: Do not use internal importlib._bootstrap module.
  * Issue #390: Disallow console scripts with path separators in
    the name. Removes unintended functionality and brings behavior
    into parity with pip.
  * Pull Request #130: Better error messages for errors in
    parsed requirements.
  * Pull Request #133: Removed ``setuptools.tests`` from the
    installed packages.
  * Issue #373: Provisionally expose
    ``pkg_resources._initialize_master_working_set``, allowing for
    imperative re-initialization of the master working set.
* Wed May 27 2015 jmatejek@suse.com
- fix vulnerability in non-RFC6125-compliant host name matching
  (bsc#930189, setuptools-1.1.7-match-hostname.patch)
* Mon Apr 27 2015 mcihar@suse.cz
- Disable testsuite as this causes build cycle
* Wed Apr 22 2015 tbechtold@suse.com
- update to 15.1:
  * Updated Packaging to 15.1 to address Packaging #28.
  * Fix ``setuptools.sandbox._execfile()`` with Python 3.1.
- Remove fix-type-error.patch . Applied upstream
* Sat Apr 11 2015 hpj@urpla.net
- openSUSE versions up to 12.2 are affected as well from:
  AssertionError: error: must supply either home or prefix/exec-prefix -- not both
  raise version check of applying fix-sle11-test-failure.patch accordingly
* Fri Mar 27 2015 tbechtold@suse.com
- update to 15.0:
  * Pull Request #126: DistributionNotFound message now lists the package or
    packages that required it. E.g.::
    pkg_resources.DistributionNotFound: The 'colorama>=0.3.1' distribution
    was not found and is required by smlib.log.
    Note that zc.buildout once dependended on the string rendering of this
    message to determine the package that was not found. This expectation
    has since been changed, but older versions of buildout may experience
    problems. See Buildout #242 for details.
  * Issue #307: Removed PEP-440 warning during parsing of versions
    in ``pkg_resources.Distribution``.
  * Issue #364: Replace deprecated usage with recommended usage of
    ``EntryPoint.load``.
  * Issue #254: When creating temporary egg cache on Unix, use mode 755
    for creating the directory to avoid the subsequent warning if
    the directory is group writable.
  * Issue #137: Update ``Distribution.hashcmp`` so that Distributions with
    None for pyversion or platform can be compared against Distributions
    defining those attributes.
  * Issue #360: Removed undesirable behavior from test runs, preventing
    write tests and installation to system site packages.
  * Pull Request #125: Add ``__ne__`` to Requirement class.
  * Various refactoring of easy_install.
  * Bootstrap script now accepts ``--to-dir`` to customize save directory or
    allow for re-use of existing repository of setuptools versions. See
    Pull Request #112 for background.
  * Issue #285: ``easy_install`` no longer will default to installing
    packages to the "user site packages" directory if it is itself installed
    there. Instead, the user must pass ``--user`` in all cases to install
    packages to the user site packages.
    This behavior now matches that of "pip install". To configure
    an environment to always install to the user site packages, consider
    using the "install-dir" and "scripts-dir" parameters to easy_install
    through an appropriate distutils config file.
  * Issue #359: Include pytest.ini in the sdist so invocation of py.test on the
    sdist honors the pytest configuration.
    Re-release of 13.0. Intermittent connectivity issues caused the release
    process to fail and PyPI uploads no longer accept files for 13.0.
  * Issue #356: Back out Pull Request #119 as it requires Setuptools 10 or later
    as the source during an upgrade.
  * Removed build_py class from setup.py. According to 892f439d216e, this
    functionality was added to support upgrades from old Distribute versions,
    0.6.5 and 0.6.6.
  * Pull Request #119: Restore writing of ``setup_requires`` to metadata
    (previously added in 8.4 and removed in 9.0).
  * Documentation is now linked using the rst.linker package.
  * Fix ``setuptools.command.easy_install.extract_wininst_cfg()``
    with Python 2.6 and 2.7.
  * Issue #354. Added documentation on building setuptools
    documentation.
  * Issue #345: Unload all modules under pkg_resources during
    ``ez_setup.use_setuptools()``.
  * Issue #336: Removed deprecation from ``ez_setup.use_setuptools``,
    as it is clearly still used by buildout's bootstrap. ``ez_setup``
    remains deprecated for use by individual packages.
  * Simplified implementation of ``ez_setup.use_setuptools``.
  * Pull Request #118: Soften warning for non-normalized versions in
    Distribution.
  * Issue #339: Correct Attribute reference in ``cant_write_to_target``.
  * Issue #336: Deprecated ``ez_setup.use_setuptools``.
  * Issue #335: Fix script header generation on Windows.
  * Fixed incorrect class attribute in ``install_scripts``. Tests would be nice.
  * Issue #331: Fixed ``install_scripts`` command on Windows systems corrupting
    the header.
  * Restore ``setuptools.command.easy_install.sys_executable`` for pbr
    compatibility. For the future, tools should construct a CommandSpec
    explicitly.
  * Issue #188: Setuptools now support multiple entities in the value for
    ``build.executable``, such that an executable of "/usr/bin/env my-python" may
    be specified. This means that systems with a specified executable whose name
    has spaces in the path must be updated to escape or quote that value.
  * Deprecated ``easy_install.ScriptWriter.get_writer``, replaced by ``.best()``
    with slightly different semantics (no force_windows flag).
  * Issue #327: Formalize and restore support for any printable character in an
    entry point name.
  * Expose ``EntryPoint.resolve`` in place of EntryPoint._load, implementing the
    simple, non-requiring load. Deprecated all uses of ``EntryPoint._load``
    except for calling with no parameters, which is just a shortcut for
    ``ep.require(); ep.resolve();``.
    Apps currently invoking ``ep.load(require=False)`` should instead do the
    following if wanting to avoid the deprecating warning::
    getattr(ep, "resolve", lambda: ep.load(require=False))()
  * Pip #2326: Report deprecation warning at stacklevel 2 for easier diagnosis.
  * Issue #281: Since Setuptools 6.1 (Issue #268), a ValueError would be raised
    in certain cases where VersionConflict was raised with two arguments, which
    occurred in ``pkg_resources.WorkingSet.find``. This release adds support
    for indicating the dependent packages while maintaining support for
    a VersionConflict when no dependent package context is known. New unit tests
    now capture the expected interface.
  * Interop #3: Upgrade to Packaging 15.0; updates to PEP 440 so that >1.7 does
    not exclude 1.7.1 but does exclude 1.7.0 and 1.7.0.post1.
  * Issue #323: Fix regression in entry point name parsing.
  * Deprecated use of EntryPoint.load(require=False). Passing a boolean to a
    function to select behavior is an anti-pattern. Instead use
    ``Entrypoint._load()``.
  * Substantial refactoring of all unit tests. Tests are now much leaner and
    re-use a lot of fixtures and contexts for better clarity of purpose.
  * Issue #320: Added a compatibility implementation of
    ``sdist._default_revctrl``
    so that systems relying on that interface do not fail (namely, Ubuntu 12.04
    and similar Debian releases).
  * Issue #319: Fixed issue installing pure distutils packages.
  * Issue #313: Removed built-in support for subversion. Projects wishing to
    retain support for subversion will need to use a third party library. The
    extant implementation is being ported to `setuptools_svn
    <https://pypi.python.org/pypi/setuptools_svn>`_.
  * Issue #315: Updated setuptools to hide its own loaded modules during
    installation of another package. This change will enable setuptools to
    upgrade (or downgrade) itself even when its own metadata and implementation
    change.
  * Prefer vendored packaging library `as recommended
    <https://github.com/jaraco/setuptools/commit/170657b68f4b92e7e1bf82f5e19a831f57
    44af67#commitcomment-9109448>`_.
  * Issue #312: Restored presence of pkg_resources API tests (doctest) to sdist.
  * Issue #314: Disabled support for ``setup_requires`` metadata to avoid issue
    where Setuptools was unable to upgrade over earlier versions.
  * Pull Request #106: Now write ``setup_requires`` metadata.
  * Issue #311: Decoupled pkg_resources from setuptools once again.
    ``pkg_resources`` is now a package instead of a module.
  * Issue #306: Suppress warnings about Version format except in select scenarios
    (such as installation).
  * Pull Request #85: Search egg-base when adding egg-info to manifest.
  * Upgrade ``packaging`` to 14.5, giving preference to "rc" as designator for
    release candidates over "c".
  * PEP-440 warnings are now raised as their own class,
    ``pkg_resources.PEP440Warning``, instead of RuntimeWarning.
  * Disabled warnings on empty versions.
  * Upgrade ``packaging`` to 14.4, fixing an error where there is a
    different result for if 2.0.5 is contained within >2.0dev and >2.0.dev even
    though normalization rules should have made them equal.
  * Issue #296: Add warning when a version is parsed as legacy. This warning will
    make it easier for developers to recognize deprecated version numbers.
  * Issue #296: Restored support for ``__hash__`` on parse_version results.
  * Issue #296: Restored support for ``__getitem__`` and sort operations on
    parse_version result.
  * Issue #296: Restore support for iteration over parse_version result, but
    deprecated that usage with a warning. Fixes failure with buildout.
  * Implement `PEP 440 <http://legacy.python.org/dev/peps/pep-0440/>`_ within
    pkg_resources and setuptools. This change
    deprecates some version numbers such that they will no longer be installable
    without using the ``===`` escape hatch. See `the changes to test_resources
    <https://bitbucket.org/pypa/setuptools/commits/dcd552da643c4448056de84c73d56da6
    d70769d5#chg-setuptools/tests/test_resources.py>`_
    for specific examples of version numbers and specifiers that are no longer
    supported. Setuptools now "vendors" the `packaging
    <https://github.com/pypa/packaging>`_ library.
  * Issue #80, Issue #209: Eggs that are downloaded for ``setup_requires``,
    ``test_requires``, etc. are now placed in a ``./.eggs`` directory instead of
    directly in the current directory. This choice of location means the files
    can be readily managed (removed, ignored). Additionally,
    later phases or invocations of setuptools will not detect the package as
    already installed and ignore it for permanent install (See #209).
    This change is indicated as backward-incompatible as installations that
    depend on the installation in the current directory will need to account for
    the new location. Systems that ignore ``*.egg`` will probably need to be
    adapted to ignore ``.eggs``. The files will need to be manually moved or
    will be retrieved again. Most use cases will require no attention.
  * Issue #268: When resolving package versions, a VersionConflict now reports
    which package previously required the conflicting version.
  * Issue #262: Fixed regression in pip install due to egg-info directories
    being omitted. Re-opens Issue #118.
  * Issue #259: Fixed regression with namespace package handling on ``single
    version, externally managed`` installs.
  * Issue #100: When building a distribution, Setuptools will no longer match
    default files using platform-dependent case sensitivity, but rather will
    only match the files if their case matches exactly. As a result, on Windows
    and other case-insensitive file systems, files with names such as
    'readme.txt' or 'README.TXT' will be omitted from the distribution and a
    warning will be issued indicating that 'README.txt' was not found. Other
    filenames affected are:
  - README.rst
  - README
  - setup.cfg
  - setup.py (or the script name)
  - test/test*.py
    Any users producing distributions with filenames that match those above
    case-insensitively, but not case-sensitively, should rename those files in
    their repository for better portability.
  * Pull Request #72: When using ``single_version_externally_managed``, the
    exclusion list now includes Python 3.2 ``__pycache__`` entries.
  * Pull Request #76 and Pull Request #78: lines in top_level.txt are now
    ordered deterministically.
  * Issue #118: The egg-info directory is now no longer included in the list
    of outputs.
  * Issue #258: Setuptools now patches distutils msvc9compiler to
    recognize the specially-packaged compiler package for easy extension module
    support on Python 2.6, 2.7, and 3.2.
  * Issue #237: ``pkg_resources`` now uses explicit detection of Python 2 vs.
    Python 3, supporting environments where builtins have been patched to make
    Python 3 look more like Python 2.
  * Issue #240: Based on real-world performance measures against 5.4, zip
    manifests are now cached in all circumstances. The
    ``PKG_RESOURCES_CACHE_ZIP_MANIFESTS`` environment variable is no longer
    relevant. The observed "memory increase" referenced in the 5.4 release
    notes and detailed in Issue #154 was likely not an increase over the status
    quo, but rather only an increase over not storing the zip info at all.
  * Issue #242: Use absolute imports in svn_utils to avoid issues if the
    installing package adds an xml module to the path.
  * Issue #239: Fix typo in 5.5 such that fix did not take.
  * Issue #239: Setuptools now includes the setup_requires directive on
    Distribution objects and validates the syntax just like install_requires
    and tests_require directives.
  * Issue #236: Corrected regression in execfile implementation for Python 2.6.
- Enable testsuite run during build. Added BuildRequires needed for that
- Refresh setuptools-5.4.1-create-sitedir.patch
- Add fix-type-error.patch: Fix error during test run
- Add fix-sle11-test-failure.patch: Fix error during test run on SLE11SP3
* Thu Jan 15 2015 lchiquitto@suse.de
- Add package to SLE 12 SDK (FATE#318137, bnc#913229)
* Wed Jul 23 2014 sleep_walker@suse.cz
- bump to 5.4.1
  Changes between 5.4.1 and 3.6
  * Python #7776: (ssl_support) Correct usage of host for validation when
    tunneling for HTTPS.
  * Issue #154: pkg_resources will now cache the zip manifests rather than
    re-processing the same file from disk multiple times, but only if the
    environment variable PKG_RESOURCES_CACHE_ZIP_MANIFESTS is set. Clients
    that package many modules in the same zip file will see some improvement
    in startup time by enabling this feature. This feature is not enabled by
    default because it causes a substantial increase in memory usage.
  * Issue #185: Make svn tagging work on the new style SVN metadata. Thanks
    cazabon!
  * Prune revision control directories (e.g .svn) from base path as well as
    sub-directories.
  * Added a Developer Guide to the official documentation.
  * Some code refactoring and cleanup was done with no intended behavioral
    changes.
  * During install_egg_info, the generated lines for namespace package .pth
    files are now processed even during a dry run.
  * Issue #202: Implemented more robust cache invalidation for the
    ZipImporter, building on the work in Issue #168. Special thanks to Jurko
    Gospodnetic and PJE.
  * Issue #220: Restored script templates.
  * Renamed script templates to end with .tmpl now that they no longer need to
    be processed by 2to3. Fixes spurious syntax errors during build/install.
  * Issue #218: Re-release of 3.8.1 to signal that it supersedes 4.x.
  * Incidentally, script templates were updated not to include the
    triple-quote escaping.
  * Issue #213: Use legacy StringIO behavior for compatibility under pbr.
  * Issue #218: Setuptools 3.8.1 superseded 4.0.1, and 4.x was removed from
    the available versions to install.
  * Issue #210: setup.py develop now copies scripts in binary mode rather than
    text mode, matching the behavior of the install command.
  * Extend Issue #197 workaround to include all Python 3 versions prior to
  * Issue #193: Improved handling of Unicode filenames when building
    manifests.
- drop not applying patch setuptools-0.6c9-create-sitedir.patch
- introduce applying patch with the same effect setuptools-5.4.1-create-sitedir.patch
* Thu May  8 2014 toddrme2178@gmail.com
- Update to version 3.6
  * Issue #203: Honor proxy settings for Powershell downloader in the bootstrap
    routine.
- Update to version 3.5.2
  * Issue #168: More robust handling of replaced zip files and stale caches.
    Fixes ZipImportError complaining about a 'bad local header'.
- Update to version 3.5.1
  * Issue #199: Restored ``install._install`` for compatibility with earlier
    NumPy versions.
- Update to version 3.5
  * Issue #195: Follow symbolic links in find_packages (restoring behavior
    broken in 3.4).
  * Issue #197: On Python 3.1, PKG-INFO is now saved in a UTF-8 encoding instead
    of ``sys.getpreferredencoding`` to match the behavior on Python 2.6-3.4.
  * Issue #192: Preferred bootstrap location is now
    https://bootstrap.pypa.io/ez_setup.py (mirrored from former location).
* Thu Apr 17 2014 toddrme2178@gmail.com
- Update to version 3.4.4
  * Issue #184: Correct failure where find_package over-matched
    packages when directory traversal isn't short-circuited.
- Update to version 3.4.3
  * Issue #183: Really fix test command with Python 3.1.
- Update to version 3.4.2
  * Issue #183: Fix additional regression in test command on
    Python 3.1.
- Update to version 3.4.1
  * Issue #180: Fix regression in test command not caught
    by py.test-run tests.
- Update to version 3.4
  * Issue #176: Add parameter to the test command to support a
    custom test runner: --test-runner or -r.
  * Issue #177: Now assume most common invocation to install
    command on platforms/environments without stack support
    (issuing a warning). Setuptools now installs naturally on
    IronPython. Behavior on CPython should be unchanged.
- Remove %%check, which now depends on pytest and thus introduces
  a dependency loop (setuptools->pytest->py->setuptools)
* Thu Mar 20 2014 speilicke@suse.com
- Update to version 3.3:
  * Add ``include`` parameter to ``setuptools.find_packages()``.
- Changes from version 3.2:
  * Pull Request #39: Add support for C++ targets from Cython ``.pyx`` files.
  * Issue #162: Update dependency on certifi to 1.0.1.
  * Issue #164: Update dependency on wincertstore to 0.2.
* Fri Jan 31 2014 speilicke@suse.com
- Update to version 2.1:
  * Issue #129: Suppress inspection of '*.whl' files when searching for files
    in a zip-imported file.
  * Issue #131: Fix RuntimeError when constructing an egg fetcher.
- Changes from version 2.0.2:
  * Fix NameError during installation with Python implementations (e.g. Jython)
    not containing parser module.
  * Fix NameError in sdist:re_finder.
- Changes from version 2.0.1:
  * Issue #124: Fixed error in list detection in upload_docs.
- Changes from version 2.0:
  * Issue #121: Exempt lib2to3 pickled grammars from DirectorySandbox.
  * Issue #41: Dropped support for Python 2.4 and Python 2.5. Clients requiring
    setuptools for those versions of Python should use setuptools 1.x.
  * Removed setuptools.command.easy_install.HAS_USER_SITE. Clients
    expecting this boolean variable should use site.ENABLE_USER_SITE
    instead.
  * Removed pkg_resources.ImpWrapper. Clients that expected this class
    should use pkgutil.ImpImporter instead.
- Changes from version 1.4.2:
  * Issue #116: Correct TypeError when reading a local package index on Python
    3.
- Changes from version 1.4.1:
  * Issue #114: Use sys.getfilesystemencoding for decoding config in
    bdist_wininst distributions.
  * Issue #105 and Issue #113: Establish a more robust technique for
    determining the terminal encoding
- Changes from version 1.4:
  * Issue #27: easy_install will now use credentials from .pypirc if
    present for connecting to the package index.
  * Pull Request #21: Omit unwanted newlines in package_index._encode_auth
    when the username/password pair length indicates wrapping.
- Changes from version 1.3.2:
  * Issue #99: Fix filename encoding issues in SVN support.
- Changes from version 1.3.1:
  * Remove exuberant warning in SVN support when SVN is not used.
- Changes from version 1.3:
  * Address security vulnerability in SSL match_hostname check as reported in
    Python #17997.
  * Prefer backports.ssl_match_hostname
    <https://pypi.python.org/pypi/backports.ssl_match_hostname>_ for backport
    implementation if present.
  * Correct NameError in ssl_support module (socket.error).
- Changes from version 1.2:
  * Issue #26: Add support for SVN 1.7. Special thanks to Philip Thiem for the
    contribution.
  * Issue #93: Wheels are now distributed with every release. Note that as
    reported in Issue #108, as of Pip 1.4, scripts aren't installed properly
    from wheels. Therefore, if using Pip to install setuptools from a wheel,
    the easy_install command will not be available.
  * Setuptools "natural" launcher support, introduced in 1.0, is now officially
    supported.
- Changes from version 1.1.7:
  * Fixed behavior of NameError handling in 'script template (dev).py' (script
    launcher for 'develop' installs).
  * ez_setup.py now ensures partial downloads are cleaned up following
    a failed download.
  * Distribute #363 and Issue #55: Skip an sdist test that fails on locales
    other than UTF-8.
- New dependency on python-xml
- Fix update-alternatives usage
* Fri Nov  8 2013 aj@ajaissle.de
- New upstream version
  * Fixed behavior of NameError handling in 'script template (dev).py' (script launcher for 'develop' installs).
  * ez_setup.py now ensures partial downloads are cleaned up following a failed download.
  * Distribute #363 and Issue #55: Skip an sdist test that fails on locales other than UTF-8.
* Fri Oct 11 2013 speilicke@suse.com
- Update to version 1.1.6:
  + Distribute #349: sandbox.execfile now opens the target file in binary
    mode, thus honoring a BOM in the file when compiled.
- Changes from version 1.1.5:
  + Issue #69: Second attempt at fix (logic was reversed).
- Changes from version 1.1.4:
  + Issue #77: Fix error in upload command (Python 2.4).
- Changes from version 1.1.3:
  + Fix NameError in previous patch.
- Changes from version 1.1.2:
  + Issue #69: Correct issue where 404 errors are returned for URLs with
    fragments in them (such as #egg=).
- Changes from version 1.1.1:
  + Issue #75: Add --insecure option to ez_setup.py to accommodate
    environments where a trusted SSL connection cannot be validated.
  + Issue #76: Fix AttributeError in upload command with Python 2.4.
- Changes from version 1.1:
  + Issue #71 (Distribute #333): EasyInstall now puts less emphasis on the
    condition when a host is blocked via --allow-hosts.
  + Issue #72: Restored Python 2.4 compatibility in ez_setup.py.
- Changes from version 1.0:
  + Issue #60: On Windows, Setuptools supports deferring to another launcher,
    such as Vinay Sajip's pylauncher <https://bitbucket.org/pypa/pylauncher>_
    (included with Python 3.3) to launch console and GUI scripts and not install
    its own launcher executables. This experimental functionality is currently
    only enabled if  the SETUPTOOLS_LAUNCHER environment variable is set to
    "natural". In the future, this behavior may become default, but only after
    it has matured and seen substantial adoption. The SETUPTOOLS_LAUNCHER
    also accepts "executable" to force the default behavior of creating launcher
    executables.
  + Issue #63: Bootstrap script (ez_setup.py) now prefers Powershell, curl, or
    wget for retrieving the Setuptools tarball for improved security of the
    install. The script will still fall back to a simple urlopen on
    platforms that do not have these tools.
  + Issue #65: Deprecated the Features functionality.
  + Issue #52: In VerifyingHTTPSConn, handle a tunnelled (proxied)
    connection.
  + Backward-Incompatible Changes:
    This release includes a couple of backward-incompatible changes, but most if
    not all users will find 1.0 a drop-in replacement for 0.9.
  - Issue #50: Normalized API of environment marker support. Specifically,
    removed line number and filename from SyntaxErrors when returned from
    pkg_resources.invalid_marker. Any clients depending on the specific
    string representation of exceptions returned by that function may need to
    be updated to account for this change.
  - Issue #50: SyntaxErrors generated by pkg_resources.invalid_marker are
    normalized for cross-implementation consistency.
  - Removed --ignore-conflicts-at-my-risk and --delete-conflicting
    options to easy_install. These options have been deprecated since 0.6a11.
- Unify changes format
* Sun Aug 18 2013 toddrme2178@gmail.com
- Re-add Requires: python.  Not needed for recent releases, but a
  lot of SLE packages fail without it.
* Mon Jul 29 2013 speilicke@suse.com
- Update to version 0.9.8:
  + Issue #53: Fix NameErrors in _vcs_split_rev_from_url.
- Changes from version 0.9.7:
  + Issue #49: Correct AttributeError on PyPy where a hashlib.HASH object does
    not have a .name attribute.
  + Issue #34: Documentation now refers to bootstrap script in code repository
    referenced by bookmark.
  + Add underscore-separated keys to environment markers (markerlib).
- Changes from version 0.9.6:
  + Issue #44: Test failure on Python 2.4 when MD5 hash doesn't have a .name
    attribute.
- Changes from version 0.9.5:
  + Python #17980: Fix security vulnerability in SSL certificate validation.
- Changes from version 0.9.4:
  + Issue #43: Fix issue (introduced in 0.9.1) with version resolution when
    upgrading over other releases of Setuptools.
- Changes from version 0.9.3:
  + Issue #42: Fix new AttributeError introduced in last fix.
- Changes from version 0.9.2:
  + Issue #42: Fix regression where blank checksums would trigger an
    AttributeError.
- Changes from version 0.9.1:
  + Distribute #386: Allow other positional and keyword arguments to os.open.
  + Corrected dependency on certifi mis-referenced in 0.9.
- Changes from version 0.9:
  + package_index now validates hashes other than MD5 in download links.
- Changes from version 0.8:
  + Code base now runs on Python 2.4 - Python 3.3 without Python 2to3
    conversion.
* Thu Jul 18 2013 speilicke@suse.com
- Use update-alternatives to be parallel-installable with python3-setuptools
* Tue Jun 25 2013 speilicke@suse.com
- Update to version 0.7.4:
  + Issue #20: Fix comparison of parsed SVN version on Python 3.
- Changes from version 0.7.3:
  + Issue #1: Disable installation of Windows-specific files on non-Windows systems.
  + Use new sysconfig module with Python 2.7 or >=3.2.
- Changes from version 0.7.2:
  + Issue #14: Use markerlib when the parser module is not available.
  + Issue #10: ez_setup.py now uses HTTPS to download setuptools from PyPI.
- Changes from version 0.7.1:
  + Fix NameError (Issue #3) again - broken in bad merge.
- Changes from version 0.7:
  + Merged Setuptools and Distribute. See docs/merge.txt for details.
  + Index URL now defaults to HTTPS.
  + Added experimental environment marker support. Now clients may designate a
    PEP-426 environment marker for "extra" dependencies. Setuptools uses this
    feature in setup.py for optional SSL and certificate validation support
    on older platforms. Based on Distutils-SIG discussions, the syntax is
    somewhat tentative. There should probably be a PEP with a firmer spec before
    the feature should be considered suitable for use.
  + Added support for SSL certificate validation when installing packages from
    an HTTPS service.
- Use upstream URL, SDPX style licenses
- Provide/obsolete python-distribute, which merged into setuptools-0.7.x
* Sat Dec 11 2010 saschpe@gmx.de
- re-generated spec file with py2pack based on old spec file:
  + now builds on Fedora and Mandriva
* Wed Sep  1 2010 jmatejek@novell.com
- update to dev snapshot 0.6c12 - RPM version is set
  to 0.6c11.99.r84273 so that version 0.6c12 will be an upgrade when
  it comes
- this should fix "AttributeError: 'NoneType' object has no attribute 'clone'"
  errors with python 2.7
* Tue Jan 12 2010 alexandre@exatati.com.br
- Removed obsolete python-setuptools-distutils-log.diff from sources.
* Tue Nov 10 2009 alexandre@exatati.com.br
- update to version 0.6c11
  + Fix "bdist_wininst upload" trying to upload same file twice
- additional changes from 0.6c10
  + Fix for the Python 2.6.3 build_ext API change
  + Ensure C libraries (as opposed to extensions) are also built when doing bdist_egg
  + Support for SVN 1.6
* Wed Nov  4 2009 matejcik@suse.cz
- removed obsolete python-setuptools-distutils-log patch
* Wed Aug 12 2009 matejcik@suse.cz
- improved noarch selection macro
* Fri Jul 31 2009 matejcik@suse.cz
- added noarch for suse > 11.1
* Fri Apr  3 2009 matejcik@suse.cz
- fixed spec compatibility with older versions
* Mon Mar 30 2009 matejcik@suse.cz
- update to 0.6c9
  + python 2.6 compatibility fixes
- added patch to create install path if it doesn't exist
- removed python-devel from requires
* Wed Oct 22 2008 skh@suse.de
- add python-setuptools-distutils-log.diff:
  setuptools/command/sdist.py: import distutils.log [bnc#428177]
- add python-setuptools-svn15.diff:
  setuptools/command/egg_info.py: recognize svn format version 1.5 magic
  number [also bnc#428177]
* Mon Aug 18 2008 cthiel@suse.de
- update to version 0.6c8
  + Prevent --help-commands and other junk from showing under Python 2.5
    when running easy_install --help.
  + Fixed GUI scripts sometimes not executing on Windows
  + Fixed not picking up dependency links from recursive dependencies.
  + Only make .py, .dll and .so files executable when unpacking
    eggs
  + Changes for Jython compatibility
- changes in version 0.6c7
  + ftp: download URLs now work correctly.
  + The default --index-url is now http://pypi.python.org/simple, to
    use the Python Package Index's new simpler (and faster!) REST API.
* Tue Aug  7 2007 cthiel@suse.de
- update to version 0.6c6
  + EasyInstall no longer aborts the installation process if a URL it wants
    to retrieve can't be downloaded, unless the URL is an actual package
    download.  Instead, it issues a warning and tries to keep going.
  + Fixed distutils-style scripts originally built on Windows having their
    line endings doubled when installed on any platform.
  + Added --local-snapshots-ok flag, to allow building eggs from
    projects installed using setup.py develop.
  + Fixed not HTML-decoding URLs scraped from web pages
* Fri Feb 16 2007 cthiel@suse.de
- initial package (version 0.6c5)
