#
# spec file for package dhcp
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


#Compat macro for new _fillupdir macro introduced in Nov 2017
%if ! %{defined _fillupdir}
  %define _fillupdir /var/adm/fillup-templates
%endif

%define isc_version   4.3.6-P1
%define susefw2dir    %{_sysconfdir}/sysconfig/SuSEfirewall2.d/services
%define omc_prefix    /usr/share/omc
%define omc_svcdir    %{omc_prefix}/svcinfo.d
# always on
%define with_ldap         1
# on sles, but sles_version is gone
%define with_ldapcasa     0%{?sles_version} >= 10 || (%suse_version >= 1110 && %suse_version < 1140)
# doc package is new on 11.3
%define with_doc_package  %suse_version >= 1130

Name:           dhcp
%if %{with_ldap}
%if %{with_ldapcasa}
BuildRequires:  CASA-devel
%endif
BuildRequires:  openldap2-devel
%endif
BuildRequires:  dos2unix
BuildRequires:  libtool
Version:        4.3.6.P1
Release:        150000.6.22.1
Summary:        Common Files Used by ISC DHCP Software
License:        BSD-3-Clause
Group:          Productivity/Networking/Boot/Servers
Url:            http://www.isc.org/software/dhcp
Source0:        dhcp-%{isc_version}.tar.gz
Source1:        dhcp-%{isc_version}.tar.gz.asc
Source2:        %{name}.keyring
#
Source10:       dhcpd.script
Source11:       dhcrelay.script
Source12:       dhcpd.service
Source13:       dhcpd6.service
Source14:       dhcrelay.service
Source15:       dhcrelay6.service
Source17:       sysconfig.dhcpd
Source18:       sysconfig.dhcrelay
Source19:       if-up.d.dhcpd-restart-hook
#
Source20:       dhclient.conf
Source21:       dhclient6.conf
Source22:       dhcpd.conf
Source23:       dhcpd6.conf
Source26:       sysconfig.syslog-dhcpd
Source27:       dhclient-script
#
Source30:       dhcpd.xml
Source31:       dhcpd6.xml
Source32:       SuSEfirewall2.dhcp-server
Source33:       SuSEfirewall2.dhcp6-server
#
Source41:       dhcp.README
Source43:       DDNS-howto.txt
Source44:       contrib.tar.gz
Source45:       examples.tar.gz
Source46:       slp.reg.d.dhcp.reg
Patch1:         0001-dhcp-4.1.1-default-paths.patch
# paranoia patch is included now, but not the
# additional patch by thomas@suse.de not ...
Patch2:         0002-dhcp-4.1.1-paranoia.patch
Patch3:         0003-dhcp-4.2.2-man-includes.patch
Patch4:         0004-dhcp-4.1.1-tmpfile.patch
Patch5:         0005-dhcp-4.1.1-dhclient-exec-filedes.patch
Patch6:         0006-dhcp-4.3.2-dhclient-send-hostname-or-fqdn.patch
# PATCH-FIX-UPSTREAM lpf-bind-msg-fix bnc#617795
Patch7:         0007-dhcp-4.1.1-P1-lpf-bind-msg-fix.patch
# PATCH-FIX-SLE dhclient-option-checks bnc#675052
Patch8:         0008-dhcp-4.2.2-dhclient-option-checks.patch
# PATCH-FIX-OPENSUSE close-on-exec bnc#732910
Patch9:         0009-dhcp-4.2.6-close-on-exec.patch
# PATCH-FIX-OPENSUSE quiet-dhclient bnc#711420
Patch10:        0010-dhcp-4.2.2-quiet-dhclient.patch
# PATCH-FIX-OPENSUSE dhcp-4.2.x-chown-server-leases bnc#868253
Patch12:        0012-dhcp-4.2.x-chown-server-leases.bnc868253.patch
# PATCH-FIX-SLE dhcp-4.2.x-dhcpv6-decline-on-DAD-failure bnc#872609
Patch13:        0013-dhcp-4.2.x-dhcpv6-decline-on-DAD-failure.872609.patch
# PATCH-FIX-SLE dhclient6-unsigned-lifetimes-for-script bsc#926159
Patch14:        0014-dhclient6-unsigned-lifetimes-for-script-bsc-926159.patch
# PATCH-FIX-SLE Expose-next-server-DHCPv4-option-to-dhclient-script bsc#928390
Patch15:        0015-Expose-next-server-DHCPv4-option-to-dhclient-script.patch
# PATCH-FIX-SLE infiniband-support bnc#870535,bsc#909189,bsc#910984
Patch16:        0016-infiniband-support.patch
# PATCH-FIX-SLE server-no-success-report-before-send bsc#919959
Patch17:        0017-server-no-success-report-before-send.919959.patch
# PATCH-FIX-SLE client-fail-on-script-pre-init-error bsc#912098
Patch18:        0018-client-fail-on-script-pre-init-error-bsc-912098.patch
# PATCH-FIX-SLE dhcp-4.2.4-P1-interval bsc#947780
Patch20:        0020-dhcp-4.x.x-fixed-improper-lease-duration-checking.patch
Patch21:        0021-dhcp-ip-family-symlinks.patch
Patch22:        dhcp-CVE-2019-6470.patch
Patch23:        dhcp-CVE-2021-25217.patch
Patch24:        dhcp-CVE-2022-2928.patch
Patch25:        dhcp-CVE-2022-2929.patch
##
PreReq:         /bin/touch /sbin/chkconfig sysconfig
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  automake

%package server
Summary:        ISC DHCP Server
Group:          Productivity/Networking/Boot/Servers
Requires:       dhcp = %{version}
Requires:       net-tools
Requires(pre):  group(nogroup)
PreReq:         %fillup_prereq /bin/cat /bin/mkdir /bin/cp /usr/sbin/useradd

%package client
Summary:        ISC DHCP Client
Group:          Productivity/Networking/Boot/Clients
Requires:       /usr/bin/host
Requires:       /usr/bin/touch
Requires:       dhcp = %{version}
%if 0%{?suse_version} >= 1330
Requires:       hostname
%else
Requires:       net-tools
%endif
Requires:       iproute2
Requires:       iputils

%package relay
Summary:        ISC DHCP Relay Agent
Group:          Productivity/Networking/Boot/Servers
Requires:       dhcp = %{version}
Requires:       net-tools
PreReq:         %fillup_prereq /bin/cat /bin/mkdir /bin/cp 

%package devel
Summary:        Header Files and Libraries for dhcpctl API
Group:          Development/Libraries/C and C++
Requires:       dhcp = %{version}

%if %{with_doc_package}

%package doc
Summary:        Documentation
Group:          Productivity/Networking/Boot/Servers
%endif

%description
This package contains common programs used by both the ISC DHCP
server ("dhcp-server" package) and client ("dhcp-client") as the
omshell and common manual pages.

Authors:
--------
    Internet Systems Consortium, Inc. <info@isc.org>


%description server
This package contains the ISC DHCP server.

Please read the documentation in /usr/share/doc/packages/dhcp-server
regarding configuration of the DHCP server.

Authors:
--------
    Internet Systems Consortium, Inc. <info@isc.org>


%description client
This is an alternative DHCP client, the ISC DHCP client for Linux. Like
"dhcpcd" (the client that is installed by default), it can be used to
configure the network setup.  IP address, hostname, routing,
nameserver, netmask, and broadcast can be dynamically assigned while
booting the machine.

It is configurable via the configuration file /etc/dhclient.conf and
you can define your own 'hooks' to be used by the /sbin/dhclient-script
(which is called by the daemon).

Authors:
--------
    Internet Systems Consortium, Inc. <info@isc.org>

%description relay
This is the ISC DHCP relay agent. It can be used as a 'gateway' for
DHCP messages across physical network segments. This is necessary
because requests can be broadcast, and they will normally not be
routed.


Authors:
--------
    Internet Systems Consortium, Inc. <info@isc.org>

%if %{with_doc_package}

%description doc
This package contains additional documentation files provided with
the software. The manual pages are in the corresponding packages.

Authors:
--------
    Internet Systems Consortium, Inc. <info@isc.org>

%endif

%description devel
This package contains all of the libraries and headers for developing
with the Internet Software Consortium (ISC) dhcpctl API.

Authors:
--------
    Internet Systems Consortium, Inc. <info@isc.org>


%prep
%setup -q -n %{name}-%{isc_version} -a 44 -a 45
##
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9
%patch10 -p1
%patch12 -p1
%patch13 -p1
%patch14
%patch15 -p1
%patch16
%patch17 -p1
%patch18 -p1
%patch20
%patch21
%patch22
%patch23
%patch24
%patch25
##
find . -type f -name \*.cat\* -exec rm -f {} \;
dos2unix contrib/ms2isc/*
# Remove GPL licensed files to make sure,
# they're not used to build (bnc#714004).
pushd bind
gunzip -c bind.tar.gz | tar xf -
rm -rf bind-*/contrib/dbus
bind_dir=$(ls -1d bind-*)
for i in /usr/share/automake-*/config.{sub,guess} ; do
	install -v -m755 $i $bind_dir/
done
# use the year from source gzip header instead of current one to make reproducible rpms
year=$(perl -e 'sysread(STDIN, $h, 8); print (1900+(gmtime(unpack("l",substr($h,4))))[5])' < bind.tar.gz)
sed -i "s/stdout, copyright, year/stdout, copyright, \"-$year\"/" $bind_dir/lib/dns/gen.c
popd
##

%build
%if %suse_version >= 1210
CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -W -Wall -Wno-unused"
%else
CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -W -Wall -fno-strict-aliasing -Wno-unused"
%endif
%ifarch ppc ppc64 s390x
  # bugs 134590, 171532
  CFLAGS="$CFLAGS -fsigned-char"
%endif
%ifarch ia64 %sparc alpha s390x ppc64 x86_64
  CFLAGS="$CFLAGS -fPIE" 
%else
  CFLAGS="$CFLAGS -fpie" 
%endif
%if %suse_version >= 1210
LDFLAGS="-Wl,-z,relro,-z,now -pie"
%else
LDFLAGS="-pie"
%endif
FFLAGS="$CFLAGS"
CXXFLAGS="$CFLAGS"
export RPM_OPT_FLAGS LDFLAGS
export CFLAGS FFLAGS CXXFLAGS
#
%{?suse_update_config:%{suse_update_config -f}}
#libtoolize --force
#autoreconf -f -i
#
%configure \
	--enable-dhcpv6 \
	--enable-failover \
	--enable-paranoia \
	--enable-early-chroot \
	--enable-secs-byteorder \
%if %{with_ldap}
	--with-ldap \
	--with-ldapcrypto \
%if %{with_ldapcasa}
	--with-ldapcasa \
%endif
%endif
	--with-cli-pid-file=%{_localstatedir}/run/dhclient.pid \
	--with-cli-lease-file=%{_localstatedir}/lib/dhcp/dhclient.leases \
	--with-cli6-pid-file=%{_localstatedir}/run/dhclient6.pid \
	--with-cli6-lease-file=%{_localstatedir}/lib/dhcp6/dhclient.leases \
	--with-srv-pid-file=%{_localstatedir}/run/dhcpd.pid \
	--with-srv-lease-file=%{_localstatedir}/lib/dhcp/db/dhcpd.leases \
	--with-srv6-pid-file=%{_localstatedir}/run/dhcpd6.pid \
	--with-srv6-lease-file=%{_localstatedir}/lib/dhcp6/db/dhcpd6.leases
#
: building bind sources
make -C bind all
cat bind/configure.log
cat bind/build.log
cat bind/install.log
: building dhcp sources
make %{?_smp_mflags}

%check
# check example config, see if it runs
./server/dhcpd -4 -t -cf $RPM_SOURCE_DIR/dhcpd.conf
./server/dhcpd -6 -t -cf $RPM_SOURCE_DIR/dhcpd6.conf
# check syntax in our scripts
bash -n $RPM_SOURCE_DIR/dhcpd.script
bash -n $RPM_SOURCE_DIR/dhcrelay.script
bash -n $RPM_SOURCE_DIR/dhclient-script

%install
export RPM_BUILD_ROOT
make install DESTDIR="$RPM_BUILD_ROOT"
#
# directories
install -d -m0755 $RPM_BUILD_ROOT/sbin
install -d -m0755 $RPM_BUILD_ROOT%{_sysconfdir}/dhcpd{,6}.d
install -d -m0755 $RPM_BUILD_ROOT/%{susefw2dir}
install -d -m0755 $RPM_BUILD_ROOT/%{omc_svcdir}
%if %{with_ldap}
install -d -m0755 $RPM_BUILD_ROOT%{_sysconfdir}/openldap/schema
%endif
install -d -m0755 $RPM_BUILD_ROOT%{_localstatedir}/run
install -d -m0755 $RPM_BUILD_ROOT%{_fillupdir}
# chroot jail
install -d -m0755 $RPM_BUILD_ROOT%{_localstatedir}/lib/{dhcp,dhcp6}/etc
install -d -m0755 $RPM_BUILD_ROOT%{_localstatedir}/lib/{dhcp,dhcp6}/dev
install -d -m0755 $RPM_BUILD_ROOT%{_localstatedir}/lib/{dhcp,dhcp6}/%_lib
install -d -m0755 $RPM_BUILD_ROOT%{_localstatedir}/lib/{dhcp,dhcp6}/var/run
install -d -m0755 $RPM_BUILD_ROOT%{_localstatedir}/lib/{dhcp,dhcp6}/db
# move the dhclient binary to /sbin
mv -f $RPM_BUILD_ROOT/usr/sbin/dhclient $RPM_BUILD_ROOT/sbin/
# provide a ...6 link, so we know it supports DHCPv6
ln -sf dhcpd      $RPM_BUILD_ROOT%{_sbindir}/dhcpd6
ln -sf dhcrelay   $RPM_BUILD_ROOT%{_sbindir}/dhcrelay6
ln -sf dhclient   $RPM_BUILD_ROOT/sbin/dhclient6
# install our adopted config examples and dhclient-script:
install    -m0644 $RPM_SOURCE_DIR/dhcpd.conf      $RPM_BUILD_ROOT%{_sysconfdir}/
install    -m0644 $RPM_SOURCE_DIR/dhcpd6.conf     $RPM_BUILD_ROOT%{_sysconfdir}/
install    -m0644 $RPM_SOURCE_DIR/dhclient.conf   $RPM_BUILD_ROOT%{_sysconfdir}/
install    -m0644 $RPM_SOURCE_DIR/dhclient6.conf  $RPM_BUILD_ROOT%{_sysconfdir}/
install    -m0754 $RPM_SOURCE_DIR/dhclient-script $RPM_BUILD_ROOT/sbin/
# helper / wrapper scripts
install -d -m0755 $RPM_BUILD_ROOT/usr/lib/dhcp
install    -m0755 $RPM_SOURCE_DIR/dhcpd.script              \
                  $RPM_BUILD_ROOT/usr/lib/dhcp/dhcpd
sed -e 's/@LIBDIR@/%{_lib}/g' -i $RPM_BUILD_ROOT/usr/lib/dhcp/dhcpd
install    -m0755 $RPM_SOURCE_DIR/dhcrelay.script           \
                  $RPM_BUILD_ROOT/usr/lib/dhcp/dhcrelay
# service units
install -d -m0755 $RPM_BUILD_ROOT%{_unitdir}
install    -m0644 $RPM_SOURCE_DIR/dhcpd.service             \
                  $RPM_BUILD_ROOT%{_unitdir}/dhcpd.service
install    -m0644 $RPM_SOURCE_DIR/dhcpd6.service            \
                  $RPM_BUILD_ROOT%{_unitdir}/dhcpd6.service
install    -m0644 $RPM_SOURCE_DIR/dhcrelay.service          \
                  $RPM_BUILD_ROOT%{_unitdir}/dhcrelay.service
install    -m0644 $RPM_SOURCE_DIR/dhcrelay6.service         \
                  $RPM_BUILD_ROOT%{_unitdir}/dhcrelay6.service
# rcservice links
ln -sf %{_sbindir}/service $RPM_BUILD_ROOT%{_sbindir}/rcdhcpd
ln -sf %{_sbindir}/service $RPM_BUILD_ROOT%{_sbindir}/rcdhcpd6
ln -sf %{_sbindir}/service $RPM_BUILD_ROOT%{_sbindir}/rcdhcrelay
ln -sf %{_sbindir}/service $RPM_BUILD_ROOT%{_sbindir}/rcdhcrelay6
%if %suse_version > 1310
# rcservice actions
legacy_actionsdir=$RPM_BUILD_ROOT/usr/lib/initscripts/legacy-actions
cat >dhcpd.action <<'EOF'
#!/bin/bash
exec /usr/lib/dhcp/dhcpd -4 ${0##*/}
EOF
install -d -m0755 ${legacy_actionsdir}/dhcpd
install    -m0755 dhcpd.action  ${legacy_actionsdir}/dhcpd/syntax-check
ln -sf            syntax-check  ${legacy_actionsdir}/dhcpd/check-syntax
ln -sf            syntax-check  ${legacy_actionsdir}/dhcpd/check-lease
rm -f             dhcpd.action
cat >dhcpd.action <<'EOF'
#!/bin/bash
exec /usr/lib/dhcp/dhcpd -6 ${0##*/}
EOF
install -d -m0755 ${legacy_actionsdir}/dhcpd6
install    -m0755 dhcpd.action  ${legacy_actionsdir}/dhcpd6/syntax-check
ln -sf            syntax-check  ${legacy_actionsdir}/dhcpd6/check-syntax
ln -sf            syntax-check  ${legacy_actionsdir}/dhcpd6/check-lease
rm -f             dhcpd.action
%endif
# sysconfig files
install    -m0644 $RPM_SOURCE_DIR/sysconfig.dhcpd           \
                  $RPM_BUILD_ROOT%{_fillupdir}/
install    -m0644 $RPM_SOURCE_DIR/sysconfig.syslog-dhcpd    \
                  $RPM_BUILD_ROOT%{_fillupdir}/
install    -m0644 $RPM_SOURCE_DIR/sysconfig.dhcrelay        \
                  $RPM_BUILD_ROOT%{_fillupdir}/
# another config files and scripts
%if %{with_ldap}
install    -m0644 contrib/ldap/dhcp.schema                       \
                  $RPM_BUILD_ROOT%{_sysconfdir}/openldap/schema
%endif
install    -m0644 $RPM_SOURCE_DIR/dhcpd.xml                 \
                  $RPM_SOURCE_DIR/dhcpd6.xml                \
                  $RPM_BUILD_ROOT/%{omc_svcdir}/
install    -m0644 $RPM_SOURCE_DIR/SuSEfirewall2.dhcp-server \
                  $RPM_BUILD_ROOT/%{susefw2dir}/dhcp-server
install    -m0644 $RPM_SOURCE_DIR/SuSEfirewall2.dhcp6-server \
                  $RPM_BUILD_ROOT/%{susefw2dir}/dhcp6-server
install -d -m0755 $RPM_BUILD_ROOT/etc/sysconfig/network/if-up.d
install -d -m0755 $RPM_BUILD_ROOT/etc/sysconfig/network/scripts
install    -m0755 $RPM_SOURCE_DIR/if-up.d.dhcpd-restart-hook \
                  $RPM_BUILD_ROOT/etc/sysconfig/network/scripts/dhcpd-restart-hook
ln -sf            ../scripts/dhcpd-restart-hook \
                  $RPM_BUILD_ROOT/etc/sysconfig/network/if-up.d/60-dhcpd-restart-hook
# slp support
install -d -m0755 $RPM_BUILD_ROOT%{_sysconfdir}/slp.reg.d
install    -m0644 $RPM_SOURCE_DIR/slp.reg.d.dhcp.reg           \
                  $RPM_BUILD_ROOT%{_sysconfdir}/slp.reg.d/dhcp.reg
# fix manual page permissions
find $RPM_BUILD_ROOT/%{_mandir} -type f | xargs chmod 644
# copy some documentation and examples from src dir
install    -m0644 $RPM_SOURCE_DIR/dhcp.README         README.SUSE
install    -m0644 $RPM_SOURCE_DIR/DDNS-howto.txt      .
cp                doc/examples/* ./examples/
rm -f             doc/{References.xml,Makefile*}
rm -f             contrib/dhcp.spec
rm -f             $RPM_BUILD_ROOT/etc/{dhcpd,dhclient}.conf.example
find contrib doc/examples -type f | xargs chmod -x
# install bind libs+includes needed for dhcp-devel
pushd bind
install -d -m0755 $RPM_BUILD_ROOT%_includedir/dhcp/
for i in include/* ; do
	cp -r $i $RPM_BUILD_ROOT%_includedir/dhcp/
done
install -d -m0755 $RPM_BUILD_ROOT%_libdir/dhcp/
for l in lib/lib*.a ; do
	install -m0644 $l $RPM_BUILD_ROOT%_libdir/dhcp/
done
popd
# move also all dhcp-devel files to dhcp subdirectories
mv $RPM_BUILD_ROOT%_includedir/{dhcpctl,isc-dhcp,omapip} \
   $RPM_BUILD_ROOT%_includedir/dhcp/
mv $RPM_BUILD_ROOT%_libdir/lib*.* \
   $RPM_BUILD_ROOT%_libdir/dhcp/

%pre server
/usr/sbin/useradd -r -g nogroup -s /bin/false -c "DHCP server daemon" -d /var/lib/dhcp dhcpd 2> /dev/null ||:
%service_add_pre dhcpd.service
%service_add_pre dhcpd6.service

%post server
%{fillup_only -n   dhcpd dhcpd}
%{fillup_only -ans syslog dhcpd}
%service_add_post dhcpd.service
%service_add_post dhcpd6.service
# FIXME: update?
if [ ${FIRST_ARG:-0} -gt 1 ]; then
    if grep -q '^DHCPD_RUN_AS=.*nobody' etc/sysconfig/dhcpd; then
	tmpfile=$(mktemp -q etc/sysconfig/dhcpd.XXXXXX)
	sed 's|^DHCPD_RUN_AS=.*|DHCPD_RUN_AS="dhcpd"|' etc/sysconfig/dhcpd \
	  > $tmpfile && mv $tmpfile etc/sysconfig/dhcpd
	rm -f $tmpfile
    fi
    if grep -q '^DHCPD_BINARY=.*dhcpd\..*' etc/sysconfig/dhcpd; then
	tmpfile=$(mktemp -q etc/sysconfig/dhcpd.XXXXXX)
	sed 's|^DHCPD_BINARY=.*|DHCPD_BINARY=""|' etc/sysconfig/dhcpd \
	  > $tmpfile && mv $tmpfile etc/sysconfig/dhcpd
	rm -f $tmpfile
    fi
fi

%preun server
%service_del_preun dhcpd.service
%service_del_preun dhcpd6.service

%postun server
%service_del_postun dhcpd.service
%service_del_postun dhcpd6.service

%pre relay
%service_add_pre dhcrelay.service
%service_add_pre dhcrelay6.service

%post relay
#
%{rename_sysconfig_variable -f etc/sysconfig/dhcrelay
	DHCRELAY6_LOWER_INTERFACES_ARGS DHCRELAY6_LOWER_INTERFACES}
%{rename_sysconfig_variable -f etc/sysconfig/dhcrelay
	DHCRELAY6_UPPER_INTERFACES_ARGS DHCRELAY6_UPPER_INTERFACES}
#
%{fillup_only -n dhcrelay dhcrelay}
%service_add_post dhcrelay.service
%service_add_post dhcrelay6.service

%preun relay
%service_del_preun dhcrelay.service
%service_del_preun dhcrelay6.service

%postun relay
%service_del_postun dhcrelay.service
%service_del_postun dhcrelay6.service

%post client
test -e %{_localstatedir}/lib/dhcp/dhclient.leases   || \
  touch %{_localstatedir}/lib/dhcp/dhclient.leases
test -e %{_localstatedir}/lib/dhcp6/dhclient6.leases || \
  touch %{_localstatedir}/lib/dhcp6/dhclient6.leases

%clean
if ! test -f /.buildenv; then rm -rf $RPM_BUILD_ROOT; fi

%files
%defattr(-,root,root)
%config %{susefw2dir}/dhcp-server
%config %{susefw2dir}/dhcp6-server
%{_bindir}/omshell
%doc %{_mandir}/man1/omshell.1.gz
%doc %{_mandir}/man5/dhcp-eval.5.gz
%doc %{_mandir}/man5/dhcp-options.5.gz

%files server
%defattr(-,root,root)
%{_sbindir}/dhcpd
%{_sbindir}/dhcpd6
%{_sbindir}/rcdhcpd
%{_sbindir}/rcdhcpd6
%{_unitdir}/dhcpd.service
%{_unitdir}/dhcpd6.service
%if %suse_version > 1310
%dir /usr/lib/initscripts/legacy-actions/dhcpd
/usr/lib/initscripts/legacy-actions/dhcpd/*
%dir /usr/lib/initscripts/legacy-actions/dhcpd6
/usr/lib/initscripts/legacy-actions/dhcpd6/*
%endif
%config(noreplace) %{_sysconfdir}/dhcpd.conf
%config(noreplace) %{_sysconfdir}/dhcpd6.conf
%attr(755,root,root) %dir %config(noreplace) %ghost %{_sysconfdir}/dhcpd.d/
%attr(755,root,root) %dir %config(noreplace) %ghost %{_sysconfdir}/dhcpd6.d/
%dir /usr/lib/dhcp
/usr/lib/dhcp/dhcpd
%dir %{_localstatedir}/lib/dhcp
%dir %{_localstatedir}/lib/dhcp/etc
%dir %{_localstatedir}/lib/dhcp/dev
%dir %{_localstatedir}/lib/dhcp/%_lib
%dir %{_localstatedir}/lib/dhcp/var
%dir %{_localstatedir}/lib/dhcp/var/run
%attr(755,dhcpd,root) %dir %{_localstatedir}/lib/dhcp/db
%dir %{_localstatedir}/lib/dhcp6
%dir %{_localstatedir}/lib/dhcp6/etc
%dir %{_localstatedir}/lib/dhcp6/dev
%dir %{_localstatedir}/lib/dhcp6/%_lib
%dir %{_localstatedir}/lib/dhcp6/var
%dir %{_localstatedir}/lib/dhcp6/var/run
%attr(755,dhcpd,root) %dir %{_localstatedir}/lib/dhcp6/db
%doc %{_mandir}/man8/dhcpd.8.gz
%doc %{_mandir}/man5/dhcpd.conf.5.gz
%doc %{_mandir}/man5/dhcpd.leases.5.gz
%if %{with_ldap}
%dir %{_sysconfdir}/openldap
%dir %{_sysconfdir}/openldap/schema
%attr(0644, root, root) %config %{_sysconfdir}/openldap/schema/dhcp.schema
%endif
%dir %{_sysconfdir}/slp.reg.d
%config(noreplace) %{_sysconfdir}/slp.reg.d/dhcp.reg
%{omc_svcdir}/dhcpd.xml
%{omc_svcdir}/dhcpd6.xml
%{_sysconfdir}/sysconfig/network/scripts/dhcpd-restart-hook
%{_sysconfdir}/sysconfig/network/if-up.d/60-dhcpd-restart-hook
%{_fillupdir}/sysconfig.dhcpd
%{_fillupdir}/sysconfig.syslog-dhcpd
%if %{with_doc_package}

%files doc
%defattr(-,root,root)
%endif
%doc LICENSE README RELNOTES
%doc README.* DDNS-howto.txt doc/*
%doc contrib examples

%files client 
%defattr(-,root,root)
/sbin/dhclient
/sbin/dhclient6
/sbin/dhclient-script
%config(noreplace) %{_sysconfdir}/dhclient.conf
%config(noreplace) %{_sysconfdir}/dhclient6.conf
%doc %{_mandir}/man5/dhclient.conf.5.gz
%doc %{_mandir}/man5/dhclient.leases.5.gz
%doc %{_mandir}/man8/dhclient.8.gz
%doc %{_mandir}/man8/dhclient-script.8.gz
%dir %{_localstatedir}/lib/dhcp
%dir %{_localstatedir}/lib/dhcp6

%files relay 
%defattr(-,root,root)
%{_sbindir}/dhcrelay
%{_sbindir}/dhcrelay6
%{_sbindir}/rcdhcrelay
%{_sbindir}/rcdhcrelay6
%dir /usr/lib/dhcp
/usr/lib/dhcp/dhcrelay
%{_unitdir}/dhcrelay.service
%{_unitdir}/dhcrelay6.service
%doc %{_mandir}/man8/dhcrelay.8.gz
%{_fillupdir}/sysconfig.dhcrelay

%files devel
%defattr(-,root,root)
%dir %_libdir/dhcp
%_libdir/dhcp/lib*
%dir %{_prefix}/include/dhcp
%{_prefix}/include/dhcp/*
%doc %{_mandir}/man3/omapi.3.gz
%doc %{_mandir}/man3/dhcpctl.3.gz

%changelog
* Mon Jan 13 2025 jorik.cronenberg@suse.com
- bsc#1192020: Add 'Requires(pre): group(nogroup)' to fix user
  creation in pre scriptlet for dhcp-server.
* Tue Oct  4 2022 max@suse.com
- bsc#1203988, CVE-2022-2928, dhcp-CVE-2022-2928.patch:
  An option refcount overflow exists in dhcpd
- bsc#1203989, CVE-2022-2929, dhcp-CVE-2022-2929.patch:
  DHCP memory leak
* Tue Apr 26 2022 max@suse.com
- bsc#1198657: properly handle DHCRELAY(6)_OPTIONS.
* Thu May 27 2021 max@suse.com
- Oops, when upgrading to 4.3.6-P1 in 2018 only isc_version was
  bumped, but not the RPM package version.
* Wed May 26 2021 max@suse.com
- CVE-2021-25217, bsc#1186382, dhcp-CVE-2021-25217.patch: A buffer
  overrun in lease file parsing code can be used to exploit a
  common vulnerability shared by dhcpd and dhclient.
* Thu Apr 22 2021 max@suse.com
- bsc#1185157:
  Use /run instead of /var/run for PIDFile in dhcrelay.service.
* Thu Aug  1 2019 max@suse.com
- bsc#1134078, CVE-2019-6470, dhcp-CVE-2019-6470.patch:
  DHCPv6 server crashes regularly.
- Add compile option --enable-secs-byteorder to avoid duplicate
  lease warnings [bsc#1089524].
* Mon Jul  8 2019 max@suse.com
- bsc#1136572: Use IPv6 when called as dhclient6, dhcpd6, and
  dhcrelay6 (0021-dhcp-ip-family-symlinks.patch).
* Thu Mar  8 2018 max@suse.com
- Update to dhcp-4.3.6-P1:
  * CVE-2018-5733, bsc#1083303: reference count overflow in dhcpd.
  * CVE-2018-5732, bsc#1083302: buffer overflow bug in dhclient.
  * Plugged a socket descriptor leak in OMAPI
  * The server now allows the client identifier (option 61) to own
    leases in more than one subnet concurrently [ISC-Bugs #41358].
  * When replying to a DHCPINFORM, the server will now include
    options specified at the pool scope, provided the ciaddr field
    of the DHCPINFORM is populated.
    [ISC-Bugs #43219] [ISC-Bugs #45051].
  * When memory allocation fails in a repeated way the process
    writes "Run out of memory." on the standard error and exists
    with status 1  [ISC-Bugs #32744].
  * The new lmdb (Lightning Memory DataBase) bind9 configure
    option is now disabled by default to avoid the presence of
    this library to be detected which can lead to a link failure.
    [ISC-Bugs #45069]
  * The linux interface discovery code has been modified to use
    getifaddrs() as is done for BSD and OS-X.
    [ISC-Bugs #28761] and others.
  * Fixed a bug in OMAPI that causes omshell to crash when a
    name-value pair with a zero length value is shipped in an
    object [ISC-Bugs #29108].
  * On 64-bit platforms, dhclient now generates the correct value
    for the script environment variable, "expiry", the lease
    expiry value exceeds 0x7FFFFFFF [ISC-Bugs #43326].
  * Common timer logic was modified to cap the maximum timeout
    values at 0x7FFFFFFF - 1 [ISC-Bugs #28038].
  * DHCP6 FQDN option unpacking code now correctly handles values
    that contain spaces, special, or non-printable characters.
    [ISC-Bugs #43592]
  * When running in -6 mode, dhclient can enforce the require
    option statement and will discard offered leases that do not
    contain all the required options specified in the client
    configuration [ISC-Bugs #41473].
  * Altered DHCPv4 lease time calculation to avoid roll over
    errors on 64-bit OS systems when using -1 or large values
    for default-lease-time [ISC-Bugs #41976],
  * Added --dad-wait-time parameter to dhclient [ISC-Bugs #36169].
  * The server nows checks both the address and length of a
    prefix delegation when attempting to match it to a prefix
    pool [ISC-Bugs #35378].
  * Modified DDNS support initialization such that DNS related
    ports will only be opened by the server (dhcpd) at startup
    if ddns-update-style is not "none"; by dhclient only if and
    when the it first attempts an update; and never by dhcrelay.
    [ISC-Bugs #45290] [ISC-Bugs #33377]
  * Added error logging to two memory allocation failure checks.
    [ISC-Bugs #41185]
  * Corrected a dhclient -6 issue that caused the client to crash
    with an "Impossible condition" error after de-preferencing its
    only IA binding [ISC-Bugs #44373].
  * By defining CALL_SCRIPT_ON_ONETRY_FAIL in includes/site.h,
    dhclient will now call the script with reason set to FAIL when
    run with -1 (one try) and there are no server responses.
    [ISC-bugs #18183]
  * The server now detects failover peers that are not referenced
    in at least one pool when run with the command line option for
    test mode, -T [ISC-Bugs #29892].
  * Linux script updated [ISC-bugs #19430] [ISC-bugs #18111].
  * Changed severity of the log message indicating UDP checksum
    errors in the received packets from 'info' to 'debug'.
    [ISC-bugs #41757]
  * Corrected a bug which could cause the server to sporadically
    crash while loading lease files with the lease-id-format is
    set to "hex" [ISC-Bugs #43185].
- Obsoleted patches:
  * 0011-Fixed-linux-interface-discovery-using-getifaddrs.patch
  * 0019-dhcp-4.2.4-P1-interval.patch
  * 0021-master-Plugs-a-socket-descriptor-leak-in-OMAPI.patch
  * 0022-Optimized-if-and-when-DNS-client-context-and-ports.patch
* Fri Jan 19 2018 ndas@suse.de
- Optimized if and when DNS client context and ports
  are initted (bsc#1073935)
  [+0022-Optimized-if-and-when-DNS-client-context-and-ports.patch]
* Tue Jan 16 2018 ndas@suse.de
- Plugs a socket descriptor leak in OMAPI(bsc#1076119, CVE-2017-3144)
  [ +0021-master-Plugs-a-socket-descriptor-leak-in-OMAPI.patch]
* Fri Jan  5 2018 obs@botter.cc
- add PIDFile= setting to dhcrelay.service, without this systemd
  stops the service immediately after starting
* Wed Dec 13 2017 mchandras@suse.de
- Drop old sysvinit support from the spec file. All the supported
  openSUSE distributions are systemd based so there isn't much point
  in keeping sysvinit support and files around.
* Thu Nov 23 2017 rbrown@suse.com
- Replace references to /var/adm/fillup-templates with new
  %%_fillupdir macro (boo#1069468)
* Fri Jul 14 2017 dimstar@opensuse.org
- Replace net-tools Requires in dhcp-client with hostname on
  suse_version >= 1330 (CODE15): net-tools does no longer provide
  any tool referenced by dhclient-script, but we require hostname
  (which is also a dependency to net-tools, thus hiding the issue).
* Thu Jul 13 2017 bwiedemann@suse.com
- use .gz year instead of current one to make build reproducible
* Thu Jul  6 2017 ndas@suse.de
- fixed a typo in nis-servers option name breaking the config file introduced
  in previous change to workaround issues in NetworkManager parser.
- Update to dhcp-4.3.5
  - Corrected a bug which could cause the server to sporadically crash while
    loading lease files with the lease-id-format is set to "hex".  Our thanks
    to Jay Ford, University of Iowa for reporting the issue.
    [ISC-Bugs #43185]
  - Eliminated a noisy, but otherwise harmless debug log statment that may
    appear during server startup when building with --enable-binary-leases
    and configuring multiple pools in a shared network.  Thanks to Fernando
    Soto from BlueCat Networks for reporting the issue and supplying a patch.
    [ISC-Bugs #43262]
  - Fixed util/bindvar.sh error handling.
    [ISC-Bugs #41973]
  - Correct error message in relay to use remote id length instead
    of circuit id length.
    [ISC-Bugs #42556]
  - Add logic to test directory Makefiles to avoid copying Attfile(s)
    when building within the source tree.  This eliminates a noisy but
    otherwise harmless error message when running "make check".
    [ISC-Bugs #41883]
  - Leases are now scrubbed of certain prior use information when pool
    re-balancing reassigns them from one FO peer to the other.  This
    corrects an issue where leases that were offered but not used
    by the client retained the client hostname from the original
    client. Thanks to Pavel Polacek, Jan Evangelista Purkyne University
    for reporting the issue.
    [ISC-Bugs #42008]
  - In the LDAP code and schema add some missing '6' characters to use
    the v6 instead of the v4 versions.  Thanks to Denis Taranushin for
    reporting this issue and supplying its patch.
    [ISC-Bugs #42666]
  - Correct how the pick-first-value expression is written to a lease
    file.  Previously it was written as a concat expression due to
    a cut and paste error.
    [ISC-Bugs #42253]
  - Modify the DDNS code to clean up the PTR record even if there
    are issues while cleaning up the A or AAAA records.
    [ISC-Bugs #23954]
  - Added global configuration parameter, abandon-lease-time, which determines
    the amount of time a lease remains abandoned.  The default is 84600 seconds.
    Additionaly, the server now conducts a ping check (if ping checks are
    enabled) prior to offering an abandoned lease to client.  Our thanks to
    David Zych at University of Illinois for reporting the issue and working
    with us to produce a viable solution.
    [ISC-Bugs #41815]
  - Correct handling of interface names during interface discovery. This
    addresses an issue where interface names of 15 characters in length
    could lead to crashes or interface recognition errors during startup
    of dhcpd, dhclient, and dhcrelay.
    [ISC-Bugs #42226]
  - Updates to contrib/dhcp-lease-list.pl to make it more friendly.
    The updates are: looking for the lease file in more places and skipping
    the "processing complete" output when creating machine readable
    output.  Thanks to Cameron Paine (cbp at null dot net) for the
    patch.
    [ISC-Bugs #42113]
  - When reusing a lease for dhcp-cache-threshold return the hostname
    to the original lease.  Also if the host pointer, UID or hardware address
    change don't allow reuse of the lease.
    Thanks to Michael Vincent for reporting this and helping us
    verify the problem and fix.
    [ISC-Bugs #42849]
  - Change dmalloc to use a size_t as the length argument to bring it
    in line with the call it will make to malloc().
    [ISC-Bugs #40843]
  - If the failover socket can't be bound, close it.  Otherwise if the
    user configures an incorrect address in the failover stanza the
    server will continue to open new sockets every 90 seconds until
    it runs out.
    [ISC-Bugs #42452]
  - Add DHCPv4-mode, dhcrelay command line options, "-iu" and "-id", that
    allow interfaces to be upstream or downstream respectively.  Upstream
    interfaces will accept and forward only BOOTP replies, while downstream
    interfaces will accept and forward only BOOTP requests.
    [ISC-Bugs #41547]
  - Clean up some memory references in the vendor-class construct.
    [ISC-Bugs #42984]
    [*0006-dhcp-4.3.2-dhclient-send-hostname-or-fqdn.patch,
  * 0011-Fixed-linux-interface-discovery-using-getifaddrs.patch,
  * 0013-dhcp-4.2.x-dhcpv6-decline-on-DAD-failure.872609.patch,
  * 0016-infiniband-support.patch,
  * 0017-server-no-success-report-before-send.919959.patch]
* Mon Jul  3 2017 zaitor@opensuse.org
- Set all requested dhcp options on a single line, so they are
  actually requested (boo#1046969, boo#1047004).
* Mon Mar 13 2017 ndas@suse.de
- Relax permission of dhclient-script for libguestfs(bsc#987170)
* Fri Feb 10 2017 kukuk@suse.de
- Require insserv only if needed
- Fix requires of client subpackage
* Thu Aug  4 2016 ralf.habacker@freenet.de
- Add config file for registering dhcp server in slp (bsc#992072)
* Thu May 19 2016 mchandras@suse.de
- Use /usr/sbin/arping instead of /sbin/arping in the dhcp scripts.
  /sbin/arping is a symlink to /usr/sbin/arping in order to ease the
  transition for the /usr merge. Newest releases of iputils may only
  install utilities in /usr/* so this dependency will no longer be valid.
  Moreover, we replace the '/sbin/arping' dependency with 'iputils'.
* Tue Jan 26 2016 ndas@suse.de
- Update to dhcp-4.3.3-P1 correcting bounds checking when
  receiving a packet (bsc#961305,CVE-2015-8605,ISC-Bugs#41267).
- adjusted interval check.
  [*0019-dhcp-4.2.4-P1-interval.patch]
- Fixed improper lease duration checking. Also added fixes for integer
  overflows in the date and time handling code(bsc#936923, bsc#880984).
  [+0020-dhcp-4.x.x-fixed-improper-lease-duration-checking.patch]
- fixed service files to start dhcpd after slapd (bsc#956159)
- dhclient-script: complain in the log about conflicts, added
  a see log messages to the dhclient log message (bsc#960506)
  [* 0018-client-fail-on-script-pre-init-error-bsc-912098.patch]
* Tue Oct 13 2015 mt@suse.de
- Applied a patch by Jiri Popelka catching dhcp server aborts with
  "Unable to set up timer: out of range" on very long or infinite
  timer intervals / lease lifetimes (bsc#947780)
  [+ 0019-dhcp-4.2.4-P1-interval.patch]
- Corrected patch references in and a missed (bsc#919959) patch
  description in previous changelog entry.
* Mon Sep 14 2015 mt@suse.de
- Update to dhcp-4.3.3 (fate#319067) provinding many bug fixes,
  features and obsoletes several patches we were using before.
  For complete changelog, please read the RELNOTES file shipped
  along with this package or online at:
  https://kb.isc.org/article/AA-01297/82/DHCP-4.3.3-Release-Notes.html
- Replaced hostname patch with a dhcpv6 and fqdn aware variant:
  [- 0006-dhcp-4.2.5-dhclient-send-hostname-rml.patch,
  + 0006-dhcp-4.3.2-dhclient-send-hostname-or-fqdn.patch]
- Removed obsolete patches included upstream now:
  [- 0007-dhcp-4.2.6-ldap-mt01.patch,
  - 0009-dhcp-4.2.6-xen-checksum.patch,
  - 0013-dhcp-4.2.3-P1-dhclient-log-pid.patch,
  - 0015-Ignore-SIGPIPE-to-not-die-in-socket-code.patch,
  - 0016-server-log-DHCPv6-addresses-assigned-to-clients.patch,
  - 0019-dhcp-4.2.x-ldap-debug-write.bnc835818.patch,
  - 0021-dhcp-4.2.4-P2-bnc878846-conf-to-ldap.patch,
  - 0022-dhcp-4.2.x-contrib-conf-to-ldap-reorder.886094.patch,
  - 0023-dhcp-4.2.x-ddns-tsig-hmac-sha-support.890731.patch,
  - 0025-dhcp-4.2.x-dhcpv6-retransmission-until-MRD.872609.patch,
  - 0026-dhcp-4.2.x-disable-unused-ddns-port-in-server.891655.patch]
- Adjusted patch numbers in the spec file:
  [- 0008-dhcp-4.1.1-P1-lpf-bind-msg-fix.patch,
  - 0010-dhcp-4.2.2-dhclient-option-checks.patch,
  - 0011-dhcp-4.2.6-close-on-exec.patch,
  - 0012-dhcp-4.2.2-quiet-dhclient.patch,
  - 0014-Fixed-linux-interface-discovery-using-getifaddrs.patch,
  - 0020-dhcp-4.2.x-chown-server-leases.bnc868253.patch,
  - 0024-dhcp-4.2.x-dhcpv6-decline-on-DAD-failure.872609.patch,
  + 0007-dhcp-4.1.1-P1-lpf-bind-msg-fix.patch,
  + 0008-dhcp-4.2.2-dhclient-option-checks.patch,
  + 0009-dhcp-4.2.6-close-on-exec.patch,
  + 0010-dhcp-4.2.2-quiet-dhclient.patch,
  + 0011-Fixed-linux-interface-discovery-using-getifaddrs.patch,
  + 0012-dhcp-4.2.x-chown-server-leases.bnc868253.patch,
  + 0013-dhcp-4.2.x-dhcpv6-decline-on-DAD-failure.872609.patch]
- Fixed to not pass DHCPv6 address lifetimes a positive (unsigned
  32bit) integers to scripts and properly format timestamps as long
  to not break them on 64bit architectures (bsc#926159).
  [+ 0014-dhclient6-unsigned-lifetimes-for-script-bsc-926159.patch]
- dhclient: expose next-server DHCPv4 option to script (bsc#928390)
  [+ 0015-Expose-next-server-DHCPv4-option-to-dhclient-script.patch]
- Replaced infiniband support patch with fixed variant (bsc#910984):
  [- 0017-dhcp-4.2.6-lpf-ip-over-ib-support.patch,
  - 0018-dhcp-4.2.6-improved-xid.patch,
  - 0027-dhcp-4.2.x-handle-ifa_addr-NULL.909189.patch,
  + 0016-infiniband-support.patch]
- Moved dhcp-devel package include files and static libraries
  to /usr/include/dhcp and /usr/lib/dhcp subdirectories.
  DHCP requires a specific bind library version and conflicts
  with the files shipped by bind-devel package, which is not
  source and binary compatible (bsc#910686).
- Corrected changes to provide complete patch file references.
- Fixed server to not report success before send (bsc#919959)
  [+ 0017-server-no-success-report-before-send.919959.patch]
- Fixed dhclient to check pre-init results reported by dhclient-script
  and fail if pre-init fails for a requested interface (bsc#912098).
  [+ 0018-client-fail-on-script-pre-init-error-bsc-912098.patch]
* Tue Feb  3 2015 coolo@suse.com
- do not check scripts not in the src.rpm
* Wed Dec 10 2014 mt@suse.de
- Applied fix by Jiri Slaby to not crash in interface discovery
  when the interface address is NULL, which has been introduced
  by the infiniband support patch (bsc#909189,bsc#870535).
  [+ 0027-dhcp-4.2.x-handle-ifa_addr-NULL.909189.patch]
* Tue Dec  9 2014 ledest@gmail.com
- fix bashisms in dhcprelay script
* Thu Nov 20 2014 mt@suse.de
- Applied contrib/ldap/dhcpd-conf-to-ldap patch by Ales Novak to
  reorder config to add all global options or option declarations
  to the dhcpService object instead to create new service object
  (bsc#886094,ISC-Bugs#37876).
  [+ 0022-dhcp-4.2.x-contrib-conf-to-ldap-reorder.886094.patch]
- Applied an upstream patch by Thomas Markwalder adding missed
  mapping of SHA TSIG algorithm names to their constants to enable
  hmac-sha1, hmac_sha224, hmac_sha256, hmac_sha384 and hmac_sha512
  authenticated dynamic DNS updates (bsc#890731, ISC-Bugs#36947).
  [+ 0023-dhcp-4.2.x-ddns-tsig-hmac-sha-support.890731.patch]
- Decline IPv6 addresses on Duplicate Address Detection failure
  and stop client message exchanges on reached MRD rather than
  at some point after it. Applied fedora patches by Jiri Popelka
  and added DAD reporting via exit 3 to the dhclient-script and
  a fix to use correct address variables in the DEPREF6 action
  (bsc#872609,ISC-Bugs#26735,ISC-Bugs#21238).
  [+ 0024-dhcp-4.2.x-dhcpv6-decline-on-DAD-failure.872609.patch,
  + 0025-dhcp-4.2.x-dhcpv6-retransmission-until-MRD.872609.patch]
- Applied backport patch by William Preston avoiding to bind ddns
  socket in the server when ddns-update-style is none (bsc#891655).
  [+ 0026-dhcp-4.2.x-disable-unused-ddns-port-in-server.891655.patch]
- Applied patch for the contrib/ldap/dhcpd-conf-to-ldap script
  fixing subclass statement handling (bnc#878846,[ISC-Bugs #36409])
  [+ 0021-dhcp-4.2.4-P2-bnc878846-conf-to-ldap.patch]
- Updated licence statement and FSF address in our scripts.
- Added missed service_add_pre macro calls for dhcrelay services
* Fri Nov 14 2014 dimstar@opensuse.org
- No longer perform gpg validation; osc source_validator does it
  implicit:
  + Drop gpg-offline BuildRequires.
  + No longer execute gpg_verify.
* Tue Sep  2 2014 ro@suse.de
- sanitize release line in specfile
* Mon Aug 18 2014 mt@suse.de
- Disabled /sbin/service legacy-action hooks on openSUSE <= 13.1,
  which does not support it and causes build failure (bnc#891961).
* Fri Jul 18 2014 mt@suse.de
- Fixed to require iproute2 in dhcp-client package (bnc#885399)
- Disarmed dhclient-script when wicked is the network service,
  as wicked is using an another dhcp client (runtime conflict),
  NetworkManager an own script and sysconfig-network is gone on
  sles12 and opensuse > 13.1, so it is obsolete and unsupported.
* Tue Jun 10 2014 mt@suse.de
- Fixed /etc/sysconfig/dhcpd fillup in dhcp server post-install.
- Fixed dhcp server start script to use correct libdir (bnc#868250)
- Fixed dhcp server to chown leases to run user at start (bnc#868253)
  [+ 0020-dhcp-4.2.x-chown-server-leases.bnc868253.patch]
- Fixed to write missed dhcp-ldap debug level messages (bnc#835818)
  [+ 0019-dhcp-4.2.x-ldap-debug-write.bnc835818.patch]
- Fixed unsupported dhclient-script used by sysconfig ifup to provide
  a function to calculate netmask. NetworkManager provides an own one.
* Wed May 21 2014 jsegitz@novell.com
- added necessary macros for systemd files
* Thu Apr 24 2014 dmueller@suse.com
- remove gpg-offline dependency (blocks rebuilds) as checking
  is already done by source validator
* Fri Mar 28 2014 mt@suse.de
- Applied fixes for DHCP over IPoIB by Mellanox (bnc#870535)
  [+ 0017-dhcp-4.2.6-lpf-ip-over-ib-support.patch,
  + 0018-dhcp-4.2.6-improved-xid.patch]
* Mon Mar 17 2014 mt@suse.com
- Added support for custom for rcdhcpd[6] check-syntax,check-lease
  and syntax-check actions (bnc#868713).
* Mon Feb 10 2014 mt@suse.com
- Initially switched to use systemd service files under systemd
  and enabled Restart=on-abort (fate#315133).
- Update to ISC dhcp-4.2.6 release. See RELNOTES file for the
  complete list of changes -- digest of fixes not in dhcp-4.2.5:
  - Tidy up receive packet processing.
    Thanks to Brad Plank of GTA for reporting the issue and
    suggesting a possible patch. [ISC-Bugs #34447]
  - Fix the socket handling for DHCPv6 clients to allow multiple
    instances of a client on a single machine to work properly.
    Previously only one client would receive the packets.
    Thanks to Jiri Popelka at Red Hat for the bug report and a
    potential patch. [ISC-Bugs #34784]
  - Added support for gentle shutdown after signal is received.
    [ISC-Bugs #32692] [ISC-Bugs 34945]
  - Enhance the DHCPv6 server logging to include the addresses
    that are assigned to the clients.  This can be enabled by
    defining LOG_V6_ADDRESSES in site.h. [ISC-Bugs #26377]
  - Fix an operation in the DDNS code to be a bitwise instead
    of logical or. [ISC-Bugs #35138]
- Merged patches for dhcp-4.2.6 version to apply without fuzzy,
  prepended patch number prefixes to match spec file patch nr,
  added patch markup tags / bug numbers to the spec file.
- Applied contrib-lease-path pach to contrib.tar.gz
  [- contrib-lease-path.diff]
- Changed to require automake and use its config.sub and guess
  files instead of maintaining a patch.
  [- config-guess-sub-update.patch]
- Enabled to log DHCPv6 addresses assigned by server to clients
  [+ 0016-server-log-DHCPv6-addresses-assigned-to-clients.patch]
- Cleaned up documentation, rpmlint adjustments.
* Fri Jan 10 2014 mt@suse.com
- Test if /etc/sysconfig/network/scripts/functions exists before
  sourcing it (fate#316768,bnc#856591).
* Mon Nov 18 2013 mt@suse.com
- Fixed path to systemctl in dhclient-script (bnc#847778).
* Fri Sep 27 2013 mt@suse.com
- Added /etc/bindresvport.blacklist to dhcp server chroot file
  lists as it seems to block its start in some cases (bnc#842360).
* Tue Sep 10 2013 mt@suse.com
- Fixed to reload syslog on hostname changes using systemctl as
  there is no /etc/init.d/syslog script since syslog-service-2.0
  (bnc#830467).
* Fri Apr 26 2013 mmeister@suse.com
- Added autoreconf -i option to fix build for the new automake
* Tue Apr  2 2013 mt@suse.com
- Install missed bind include files and libraries in dhcp-devel;
  conflicts to bind-devel providing different versions (bnc#805162).
* Thu Mar 28 2013 mt@suse.com
- Use manual patch command for config-guess-sub-update.patch
  again as patch macro does not work on older distributions.
* Wed Mar 27 2013 mt@suse.com
- Update to ISC dhcp-4.2.5-P1 release, which contains updated
  bind-9.8.4-P2 sources with removed regex.h check in configure
  (bnc#811934, CVE-2013-2266).
- Changed spec make the bind export library build output visible.
* Tue Mar 12 2013 mt@suse.com
- Added dhcp6-server service template for SuSEfirewall2 (bnc#783002)
* Sun Mar  3 2013 schwab@suse.de
- config-guess-sub-update.patch:
  Update config.guess/sub for aarch64
* Fri Jan 11 2013 mt@suse.com
- Update to ISC dhcp-4.2.5 release. See RELNOTES file for the
  complete list of changes -- digest of fixes not in dhcp-4.2.4-P2:
  - Correct code to calculate rebind timing values in client
    [ISC-Bugs #29062]
  - Fix some issues in the code for parsing and printing options.
    [ISC-Bugs #22625,#27289,#27296,#27314]
  - Update the memory leakage debug code to work with v6.
    [ISC-Bugs #30297]
  - Relax the requirements for deleting an A or AAAA record.
    This relaxation was codified in RFC 4703. [ISC-Bugs #30734]
  - Modify the failover code to handle incorrect peer names better.
    [ISC-Bugs #30320]
  - Fix a set of issues that were discovered via a code inspection
    tool. [ISC-Bugs #23833]
  - Parsing unquoted base64 strings improved. [ISC-Bugs #23048]
  - The client now passes information about the options it requested
    from the server to the script code via environment variables.
    These variables are of the form requested_<option_name>=1 with
    the option name being the same as used in the new_* and old_*
    variables. [ISC-Bugs #29068]
  - Check the status value when trying to read from a connection to
    see if it may have been closed.  If it appears closed don't try
    to read from it again.  This avoids a potential busy-wait like
    loop when the peer names are mismatched. [ISC-Bugs #31231]
  - Remove an unused variable to keep compilers happy.
    [ISC-Bugs #31983]
- Removed obsolete parsing and printing option patch
  [dhcp-4.2.4-parsing-and-printing-options.patch]
- Merged dhcp-4.2.2-dhclient-send-hostname-rml.diff
  [dhcp-4.2.5-dhclient-send-hostname-rml.patch]
- Fixed discovery of interfaces, which have only addresses with
  a label assigned (linux 2.0 "alias interfaces" compatibility)
  by switching to use the getifaddrs() as on BSD (bnc#791289,
  reported upstream as [ISC-Bugs #31992]).
  [dhcp-4.2.4-interface-discovery-using-getifaddrs.patch]
- Applied a patch to ignore SIGPIPE instead to die in socket code
  before the errno==EPIPE checks are reached (bnc#794578, upstream
  report [ISC-Bugs #32222])
  [dhcp-4.2.4-P2-do-not-die-on-sigpipe.patch]
- Updated ldap patch to 4.2.5-ldap-mt01 providing following fixes:
  - Fixed parse buffer handling code to not avoid truncation of
    config > ~8k from bigger ldap objects. Fixed to free the ldap
    config buffer passed to the config parser and append new config,
    while the parser is in saved state (bnc#788787).
  - Fixed subclass name-ref and data quoting/escaping (bnc#788787).
  - Fixed memory leaks on ldap_read_config errors (bnc#788787).
  - Fixed a memleak while subnet range processing, fixed to reset
    bufix variable in ldap_read_function to 0 and to set buflen to
    the complete length (do not discard last character, usually \n).
    This caused a parsing error at further run of the function,
    e.g. while processing the second dhcpService container that the
    dhcpServer object may refer to (bnc#784640).
  [dhcp-4.2.5-ldap-mt01.patch.bz2]
- Fixed dhclient-script to discard MTU lower-equal 576 rather
  than lower-than (bnc#791280).
- Verify GPG source archive signatures.
* Thu Sep 20 2012 mt@suse.com
- Update to ISC dhcp-4.2.4-P2 release, providing a security fix for
  an issue with the use of lease times was found and fixed.  Making
  certain changes to the end time of an IPv6 lease could cause the
  server to abort.  Thanks to Glen Eustace of Massey University,
  New Zealand for finding this issue.
  ([ISC-Bugs #30281], CVE: CVE-2012-3955, bnc#780167)
* Wed Jul 25 2012 mt@suse.com
- Update to ISC dhcp-4.2.4-P1 release, providing following security
  fixes (bnc#772924):
  - Previously the server code was relaxed to allow packets with zero
    length client ids to be processed.  Under some situations use of
    zero length client ids can cause the server to go into an infinite
    loop. As such ids are not valid according to RFC 2132 section 9.14
    the server no longer accepts them.  Client ids with a length of 1
    are also invalid but the server still accepts them in order to
    minimize disruption.  The restriction will likely be tightened in
    the future to disallow ids with a length of 1.
    Thanks to Markus Hietava of Codenomicon CROSS project for the
    finding this issue and CERT-FI for vulnerability coordination.
    [ISC-Bugs #29851] CVE: CVE-2012-3571
  - When attempting to convert a DUID from a client id option
    into a hardware address handle unexpected client ids properly.
    Thanks to Markus Hietava of Codenomicon CROSS project for the
    finding this issue and CERT-FI for vulnerability coordination.
    [ISC-Bugs #29852] CVE: CVE-2012-3570
  - A pair of memory leaks were found and fixed.  Thanks to Glen
    Eustace of Massey University, New Zealand for finding this issue.
    [ISC-Bugs #30024] CVE: CVE-2012-3954
- Moved lease file check to a separate action so it is not used in
  restart -- it can fail when the daemon rewrites the lease causing
  a restart failure then (bnc#762108 regression).
- Request dhcp6.sntp-servers in /etc/dhclient6.conf and forward to
  netconfig for processing (bnc#770236).
- Removed RFC 4833 TZ options from client requests [unused].
* Tue Jun 19 2012 mt@suse.com
- Update to ISC dhcp-4.2.4 release, fixing a dhcpv6 server assert
  crash while accessing lease on heap (bnc#767661) and providing
  the following fixes:
  - Rotate the lease file when running in v6 mode.
    Thanks to Christoph Moench-Tegeder at Astaro for the
    report and the first version of the patch. [ISC-Bugs #24887]
  - Fixed the code that checks if an address the server is planning
    to hand out is in a reserved range.  This would appear as the
    server being out of addresses in pools with particular ranges.
    [ISC-Bugs #26498]
  - In the DDNS code handle error conditions more gracefully and
    add more logging code. The major change is to handle unexpected
    cancel events from the DNS client code. [ISC-Bugs #26287]
  - Tidy up the receive calls and eliminate the need for found_pkt.
    [ISC-Bugs #25066]
  - Add support for Infiniband over sockets to the server and
    relay code.  We've tested this on Solaris and hope to expand
    support for Infiniband in the future.  This patch also corrects
    some issues we found in the socket code. [ISC-Bugs #24245]
  - Add a compile time check for the presence of the noreturn attribute
    and use it for log_fatal if it's available.  This will help code
    checking programs to eliminate false positives. [ISC-Bugs #27539]
  - Fixed many compilation problems ("set, but not used" warnings) for
    gcc 4.6 that may affect Ubuntu 11.10 users. [ISC-Bugs #27588]
  - Modify the code that determines if an outstanding DDNS request
    should be cancelled.  This patch results in cancelling the
    outstanding request less often.  It fixes the problem caused
    by a client doing a release where  the TXT and PTR records
    weren't removed from the DNS. [ISC-BUGS #27858]
  - Use offsetof() instead of sizeof() to get the sizes for
    dhcpv6_relay_packet and dhcpv6_packet in several more places.
    Thanks to a report from Bruno Verstuyft and Vincent Demaertelaere
    of Excentis. [ISC-Bugs #27941]
  - Remove outdated note in the description of the bootp keyword about
    the option not satisfying the requirement of failover peers for
    denying dynamic bootp clients. [ISC-bugs #28574]
  - Multiple items to clean up IPv6 address processing. When processing
    an IA that we've seen check to see if the addresses are usable
    (not in use by somebody else) before handing it out.
    When reading in leases from the file discard expired addresses.
    When picking an address for a client include the IA ID in
    addition to the client ID to generally pick different addresses
    for different IAs. [ISC-Bugs #23138] [ISC-Bugs #27945]
    [ISC-Bugs #25586] [ISC-Bugs #27684]
  - Remove unnecessary checks in the lease query code and clean up
    several compiler issues (some dereferences of NULL and treating
    an int as a boolean). [ISC-Bugs #26203]
  - Fix the NA and PD allocation code to handle the case where a client
    provides a preference and the server doesn't have any addresses or
    prefixes available.  Previoulsy the server ignored the request with
    this patch it replies with a NoAddrsAvail or NoPrefixAvail response.
    By default the code performs according to the errata of August 2010
    for RFC 3315 section 17.2.2; to enable the previous style see the
    section on RFC3315_PRE_ERRATA_2010_08 in includes/site.h.
    This option may be removed in the future. Thanks to Jiri Popelka at
    Red Hat for the patch. [ISC-Bugs #22676]
  - Fix up some issues found by static analysis. A potential memory leak
    and NULL dereference in omapi. The use of a boolean test instead of
    a bitwise test in dst. [ISC-Bugs #28941]
- Replaced our patches with a complete and upstream verified patch:
  - Fix some issues in the code for parsing and printing options.
    [ISC-Bugs #27314] - properly parse a zero length option from
    a lease file.
    [ISC-Bugs #22796] - properly determine if we parsed a 16 or
    32 bit value in evaluate_numeric_expression (extract-int).
    [ISC-Bugs #22625] - properly print options that have several
    fields followed by an array of something for example "fIa"
    [ISC-Bugs #27289] - properly parse options in declarations
    that have several fields followed by an array of something
    for example "fIa"
  This patch obsoletes the following (bnc#739696) patches:
  - dhclient: parse_option_param: Bad format a
  - zero-length option lease parse error in dhclient6
- Merged ldap and options check patches for the new version
- Fixed dhcp-server init script to check syntax and fail while
  force-reload and restart to avoid stopping of running daemon
  followed by start failure (bnc#762108). Added libgcc_s.so to
  chroot, so the server can report assert/crash line.
* Wed Mar 28 2012 mt@suse.com
- Added RFC 4833 TimeZone PosixString and Name declarations to
  server and client configs [not used yet].
* Mon Mar 19 2012 mt@suse.com
- dhcp-server: fixed to escape all values used in constructed
  ldap filters as a DN may contain e.g. asterisks (bnc#721829,
  [ISC-Bugs #28545]).
* Fri Jan 13 2012 mt@suse.com
- Updated to ISC dhcp-4.2.3-P2 release, providing a DDNS security fix:
  Modify the DDNS handling code. In a previous patch we added logging
  code to the DDNS handling.  This code included a bug that caused it
  to attempt to dereference a NULL pointer and eventually segfault.
  While reviewing the code as we addressed this problem, we determined
  that some of the updates to the lease structures would not work as
  planned since the structures being updated were in the process of
  being freed: these updates were removed.  In addition we removed an
  incorrect call to the DDNS removal function that could cause a failure
  during the removal of DDNS information from the DNS server.
  Thanks to Jasper Jongmans for reporting this issue.
  ([ISC-Bugs #27078], CVE: CVE-2011-4868, bnc#741239)
- Fixed close-on-exec patch to not set it on stderr (bnc#732910)
- Fixed incorrect "a" array type option parsing causing to discard
  e.g. classless static routes from lease file [reported as ISC-Bug
  27289] and zero-length option parsing such as dhcp6.rapid-commit
  in dhclient6 [reported as ISC-Bug 27314] (bnc#739696).
- Fixed dhclient to include its pid number in syslog messages.
- Fixed to use P2 in the spec version, not in the release tag.
* Fri Dec  9 2011 mt@suse.com
- Updated to ISC dhcp-4.2.3-P1 release, providing security fix for
  a DoS due to processing certain regular expressions (bnc#735610)
  and several important DDNS related fixes:
  * Add a check for a null pointer before calling the regexec function.
    Without out this check we could, under some circumstances, pass
    a null pointer to the regexec function causing it to segfault.
    Thanks to a report from BlueCat Networks. [ISC-Bugs #26704]
    CVE-2011-4539.
  * Fix the code that checks for an existing DDNS transaction to
    cancel when removing DDNS information, so that we will continue
    with the processing if we have a lease even if it doesn't have an
    outstanding transaction.  [ISC-Bugs #24682]
  * Add AM_MAINTAINER_MODE to configure.ac to avoid rebuilding
    configuration files.  [ISC-Bugs #24107]
  * Add support for passing DDNS information to a DNS server over
    an IPv6 address.  [ISC-Bugs #22647]
  * Enhanced patch for 23595 to handle IPv4 fixed addresses more
    cleanly.  [ISC-Bugs #23595]
- Refreshed ldap patch
* Fri Sep 30 2011 coolo@suse.com
- add libtool as buildrequire to make the spec file more reliable
* Tue Sep  6 2011 mt@suse.com
- Commented out all configuration examples in /etc/dhcpd.conf and
  dhcp6.conf (bnc#715473).
- Enabled dhcp6.rapid-commit in /etc/dhclient6.conf config file.
- Removed useless provides/obsoletes from spec file.
* Wed Aug 31 2011 mt@suse.com
- Set the DHCPD_CONF_INCLUDE_FILES and the DHCPD6_CONF_INCLUDE_FILES
  variables to /etc/dhcpd.d and /etc/dhcpd6.d by default, so there
  are well-defined directories expected to contain additional config
  files (bnc#690585).
* Mon Aug 29 2011 mt@suse.de
- Updated to ISC dhcp-4.2.2 release, providing two security fixes
  (CVE-2011-2748,CVE-2011-2749,[ISC-Bugs #24960],bnc#712653), that
  allowed remote attackers to cause a denial of service (a daemon
  exit) via crafted BOOTP packets. Further also DNS update fix to
  detect overlapping pools or misconfigured fixed-address entries,
  that caused a server crash during DNS update and other fixes.
  For a complete list, please see the RELNOTES file provided in
  the package and also available online at http://www.isc.org/.
- Merged/adopted dhclient option-checks, send-hostname-rml, ldap
  patch, xen-checksum, close-on-exec patches and removed obsolete
  in6_pktinfo-prototype and relay-no-ip-on-interface patches.
- Moved server pid files into chroot directory even chroot is
  not used and create a link in /var/run, so it can write one
  when started as user without chroot and avoid stop problems
  when the chroot sysconfig setting changed (bnc#712438).
- Disabled log-info level messages in dhclient(6) quiet mode to
  avoid excessive logging of non-critical messages (bnc#711420).
- Fixed dhclient-script to not remove alias IP when it didn't
  changed to not wipe out iptables connmark when renewing the
  lease (bnc#700771). Thanks to James Carter for the patch.
- Fixed DDNS-howto.txt reference in the config file; it has been
  moved to the dhcp-doc package (bnc#697279).
- Removed GPL licensed files (bind-*/contrib/dbus) from bind.tgz
  to ensure, they're not used to build non-GPL dhcp (bnc#714004).
- Changed to apply strict-aliasing/RELRO for >= 12.x only
* Wed Jul 20 2011 crrodriguez@opensuse.org
- Correct previous change.
* Wed Jul 20 2011 crrodriguez@opensuse.org
- THis is a long running network daemon, link with
  full RELRO security enhancements.
- remove -fno-strict-aliasing from CFLAGS, no longer needed.
* Tue May 17 2011 crrodriguez@opensuse.org
- Import redhat's patch to open all needed FDs  with O_CLOEXEC
  so they dont leak.
* Thu May 12 2011 mt@suse.de
- Removed obsolete sles8 compatibility dependencies, fixed
  to avoid non-functional sles_version conditionals.
* Tue May 10 2011 mt@suse.de
- Fixed to not introduce separate dhcp-doc package on sles,
  use versioned provides/obsoletes, improved conditionals.
* Tue May  3 2011 mt@suse.de
- Fixed dhclient-script typo causing ISC DHCPv6 client to execute
  ifup pre-down scripts also while renew, when the ipv6 address
  did not changed (bnc#690859).
* Fri Apr 29 2011 mt@suse.de
- Implemented optional ldap connect retry loop during the initial
  startup of the dhcp server in cases where the ldap server is not
  yet started. Set the ldap-init-retry <num> option in dhcpd.conf
  to enable it (bnc#627617). Merged in the actual ldap patch.
- Cleaned up init script error reporting, no -TERM for killproc.
* Wed Apr 27 2011 mt@suse.de
- Updated to ISC dhcp-4.2.1-P1 release, that provides most of the
  dhclient pretty escape and string option checks. Merged to use
  relaxed domain-name option check causing a regression, when the
  server is misusing it to provide a domain list (compatibility to
  attic clients) and does not provide it via domain-search option;
  pretty escape semicolon as well (bnc#675052, CVE-2011-0997).
* Thu Mar 31 2011 mt@suse.de
- Discard string options such as host and domain names containing
  disallowed characters or beeing too long. This proctive patch
  limits root-path to a-zA-Z0-9, #%%+-_:.,@~/\[]= and a space
  (bnc#675052, CVE-2011-0997).
* Thu Mar 31 2011 mt@suse.de
- Updated to ISC DHCP 4.2.1 release (bnc#680298), that provides
  following fixes (digest):
  * Several fixes to OMAPI, cleanup of dereferenced pointers in
    the omapi handle, handling of pipe failures and status code
    in omapi signal handler that may cause connect failure and
    100%% CPU use.
  * Handle some DDNS corner cases better
  * Several fixes to lease input and output
  * Corrected side effect of printing all data strings as hex.
  * Host record references leaks causing applying config to all
    innocent clients.
  * Memory leak when parsing a domain name
  * Fixes to configuration parsing including infinite loop.
  * Fixed for unexpected abort caused by a DHCPv6 decline.
  For the complete list see the RELNOTES file, that is available
  also online at http://ftp.isc.org/isc/dhcp/dhcp-4.2.1-RELNOTES.
- Removed obsolete optional-value-infinite-loop, no-libcrypto
  and CVE-2011-0413.bnc667655 patches.
- Merged the dhclient-send-hostname and ldap patches.
* Mon Feb 21 2011 mt@suse.de
- dhclient-script: fixed typo causing that only global settings
  to set hostname and default route were applied for primary
  and never per interface settings (bnc#673792).
* Fri Feb 18 2011 mt@suse.de
- Added dhcp-4.2.0-xen-checksum.patch by David Cantrell to handle
  xen partial UDP checksums (bnc#668194).
* Wed Feb  2 2011 mt@suse.de
- Applied security fix for unexpected abort caused by a DHCPv6
  decline message (CVE-2011-0413, VU#686084, bnc#667655).
- Fixed dhclient.conf to request the domain-search option.
* Mon Dec 13 2010 mt@suse.de
- Updated to ISC DHCP 4.2.0-P2, a security release fixing the
  handling of connection requests on the failover port.
  Previously a connection request from a source that wasn't
  listed as a failover peer would cause the server to become
  non-responsive. ([ISC-Bugs #22679] CERT: VU#159528 CVE:
  CVE-2010-3616, bnc#659059).
* Tue Dec  7 2010 mt@suse.de
- Enable ldap CASA support on SLE only.
* Tue Nov 30 2010 mt@suse.de
- Fixed to use same/correct dhcrelay6 interface variables in the
  sysconfig file and in the dhcrelay6 init script.
* Mon Nov 29 2010 mt@suse.de
- Updated to ISC DHCP 4.2.0-P1 release, providing a security fix to
  handle a relay forward message with an unspecified address in the
  link address field. Previously such a message would cause the
  server to crash. Thanks to a report from John Gibbons.
  [ISC-Bugs #21992] CERT: VU#102047 CVE: CVE-2010-3611 (bnc#650902)
  The 4.2.0 version is a feature release, implementing asynchronous
  DDNS processing and includes "The LDAP Patch".
  For a complete list of changes from any previous release, please
  consult the RELNOTES file within the source distribution or on
  the ISC website: http://www.isc.org/software/dhcp/420
- Fixed compilation to avoid segfaults as soon as ldap is enabled,
  merged our ldap patches from 4.1.x branch.
* Tue Nov  2 2010 mt@suse.de
- Fixed a dhcrelay segfault while receiving packets on interfaces
  without any IPv4 address assigned (bnc#631305, reported upsteam
  as [ISC-Bugs #22409]).
- Fixed a common infinite loop while parsing options with optional
  parts in the value such as in slp-service-scope option (bnc#643845,
  reported upsteam as [ISC-Bugs #22410]).
- Fixed init scripts to report correct LSB codes in status action,
  when the config file or the binary do not exists (bnc#640336).
- Fixed syntax of a check in the rcdhcrelay[6] (bnc#648580)
- Avoid pid check error message in the rcdhcpd[6] (bnc#646875)
* Wed Sep 29 2010 mt@suse.de
- Fixed server lease file path in contrib/listlease and leasestate
  changed to extract contrib and examples using setup macro.
* Wed Aug  4 2010 mt@suse.de
- Renamed rfc3442-classless-static-routes_raw in /etc/dhclient.conf
  to rfc3442-classless-static-routes for compatibility with the
  NetworkManager making use of /etc/dhclient.conf now and adopted
  /sbin/dhclient-script (bnc#625770).
* Tue Jul 27 2010 mt@suse.de
- Fixed ldap option number conflicting with new options (bnc#625358)
* Fri Jul  2 2010 mt@suse.de
- Added a fix for an lpf bind error messages making it easier to
  localize problems (bnc#617795)
* Mon Jun 14 2010 mt@suse.de
- Updated to ISC DHCP 4.1.1-P1 patch release, which contains
  a pair of bug fixes including one for a security related bug
  (bnc#612546, CVE-2010-2156):
  * A bug was fixed that could cause the DHCPv6 server to
    advertise/assign a previously allocated (active) lease to a
    client that has changed subnets, despite being on different
    shared networks. Dynamic prefixes specifically allocated in
    shared networks also now are not offered if the client has
    moved. [ISC-Bugs #21152]
  * Accept a client id of length 0 while hashing. Previously the
    server would exit if it attempted to hash a zero length client
    id, providing attackers with a simple denial of service attack.
    [ISC-Bugs #21253]
* Tue May 18 2010 mt@suse.de
- Added rc.dhcrelay6 as source in the spec file
* Tue May 11 2010 mt@suse.de
- Fixed dhcprelay scripts to source sysconfig file correctly
- Fixed spec file typo in arping path require, enabled ldap
- Fixed a dhclient option name and new/old ip address check
* Fri May  7 2010 mt@suse.de
- Updated to ISC DHCP 4.1.1, the current 4.x series production
  release, providing DHCPv6 client/server/relay implementation.
  The programs act in DHCPv6 mode, when the -6 start option is set.
  We install separate init scripts with a 6 at the end to handle
  them, that is /etc/init.d/dhcpd6 and dhrelay6. Further, there is
  also a link to the binaries with a 6 at the end, e.g. dhclient6,
  making it visible, that the installed version supports DHCPv6.
- Moved additional documentation to a separate dhcp-doc package.
- Changed to provide config files and scripts as source files
  instead of patches to the ISC scripts.
- Adopted spec file and config/scripts, merged in all patches.
- Implemented RFC 3442 classless static routes support in the
  dhclient-script (bnc#555870).
* Thu Apr 29 2010 mt@suse.de
- Updated to ISC DHCP 3.1-ESV, an extended support version release
  which includes a small number of bug fixes (bnc#592178) over the
  3.1.3 version:
  * Modified the handling of a connection to avoid releasing the
    omapi io object for the connection while it is still in use.
    One symptom from this error was a segfault when a failover
    secondary attempted to connect to the failover primary if
    their clocks were not synchronized.
  * Fix test in dhcp_interface_signal_handler to check that the
    inner handler has a signal_handler before calling it.
  * When using 'ignore client-updates;', the FQDN returned to the
    client is no longer truncated to one octet.
  * Clean up some compiler warnings - ticket 19054.
- Fixed vlan interface check in dhcpd-restart-hook if-up.d script
  (bnc#599702)
- Touch dhclient.leases in post-install script instead to provide
  an empty file, versioned provides/obsoletes (rpmlint warnings).
* Fri Mar 12 2010 mt@suse.de
- Fixed dhclient-script to call ifup -o dhcp and signal "complete"
  to ifup when all configuration is done (bnc#585380,bnc#518219).
* Thu Jan  7 2010 jengelh@medozas.de
- Enable parallel building
- Use large PIE model on all SPARC flavors
* Mon Dec 14 2009 mt@suse.de
- Fixed dhclient-script to use correct sysconfig run dir path
  to not to break the defaultroute/hostname setup (bnc#555095).
- Don't request any specific lease-time by default (bnc#516459).
* Fri Oct 16 2009 mt@suse.de
- Fixed dhclient-script to forward new_domain_search as DNSSEARCH
  to netconfig.
* Tue Oct 13 2009 mt@suse.de
- Updated to dhcp-3.1.3 maintenance release fixing several issues
  (a digest, see RELNOTES for the complete list):
  * Remove infinite loop in token_print_indent_concat().
  * A parser bug was fixed that segfaulted if site-option-space
    was tried to be used interchangeably with vendor-option-space.
  * Two uninitialized stack structures are now memset to zero,
    thanks to patch from David Cantrell at Red Hat.
  * Memory leak in the load_balance_mine() function is fixed. This
    would leak ~20-30 octets per DHCPDISCOVER packet while failover
    was in use and in normal state.
  * Fixed setting hostname in Linux hosts that require hostname
    argument to be double-quoted.  Also allow server-provided
    hostname to override hostnames 'localhost' and '(none)'.
  * Added client support for setting interface MTU and metric,
    thanks to Roy "UberLord" Marples <roy@marples.name>.
  * Fixed failover reconnection retry code to continue to retry to
    reconnect rather than restarting the listener.
  * Fixed a bug where an OMAPI socket disconnection message would
    not result in scheduling a failover reconnection, if the link
    had not negotiated a failover connect yet (e.g.: connection
    refused, asynch socket connect() timeouts).
  * Versions 3.0.x syntax with multiple name->code option
    definitions is now supported.  Note that, similarly to 3.0.x,
    for by-code lookups only the last option definition is used.
  * Fixed a fenceposting bug when a client had two host records
    configured, one using 'uid' and the other using 'hardware
    ethernet'. CVE-2009-1892
- Updated to dhcp-3.1.3-ldap-patch-mt-01 including previous fixes.
- Merged dhclient script, removed obsolete CVE-2009-1892 fix.
* Tue Sep 29 2009 mt@suse.de
- Replaced mt-02 ldap patch from old git repository with equivalent
  one (dhcp-3.1.2p1-ldap-patch-mt-02) from a new repository with
  fixed patch history (http://www.suse.de/~mt/git/dhcp-ldap.git/).
* Wed Aug 12 2009 mt@suse.de
- Added dhcpd-restart-hook if-up.d script that restarts dhcp server
  while network restart when a virtual interfaces as bridge, bond
  or vlan goes up again (bnc#517810).
* Wed Jul 29 2009 mt@suse.de
- Applied fix for a dhcp client id DoS (CVE-2009-1892, bnc#519413).
* Wed Jul 29 2009 mt@suse.de
- Updated to dhcp-3.1.2p1 maintenance release fixing following
  issues:
  * A stack overflow vulnerability was fixed in dhclient that could
    allow remote attackers to execute arbitrary commands as root on
    the system, or simply terminate the client, by providing an
    over-long subnet-mask option.
  * A double-dereference in dhclient transmission of DHCPDECLINEs
    was repaired.
  * Fix handling of -A and -a flags in dhcrelay; it was failing
    to expand packet size as needed to add relay agent options.
  * Corrected list of failover state values in dhcpd man page.
  * Fixed a bug that caused some request types to be logged
    incorrectly.
  * Fixed a coredump when adding a class via OMAPI.
  * Clients that sent a parameter request list containing the
    routers option before the subnet mask option were receiving
    only the latter. Fixed.
  * The server wasn't always sending the FQDN option when it should.
  * A partner-down failover server no longer emits 'peer holds all
    free leases' if it is able to newly-allocate one of the peer's
    leases.
  * A cosmetic bug in DHCPDECLINE processing was fixed which caused
    all successful DHCPDECLINEs to be logged as "not found" rather
    than "abandoned".
  * Some failover debugging #defines have been better defined and
    some high frequency messages moved to a deeper debugging symbol.
  * The CLTT parameter in failover is now only updated by client
    activity, and not by failover binding updates.
  * Failover BNDUPD messages are now discarded if they conflict with
    an update that has been trasnmitted, but not acknowledged.
  * A bug cleaning up unknown-xxx temporary option definitions was
    fixed.
- Removed obsolete dhclient-no-dereference-twice patch
- Improved dhclient-script to apply global dhcp settings, when
  there is no interface config (bnc#480922).
- Enabled casa support in dhcp-ldap for >= sles 10 and => 11.1.
- Updated dhcp-3.1.2p1-ldap-patch-mt.11.2-02 merging all patches
  flying around --  see http://www.suse.de/~mt/git/dhcp-ldap.git
  and the git changelog at the begin of the patch.
* Mon Jan 19 2009 mt@suse.de
- Fixed dhclient-script to apply a dhcp provided MTU (bnc#467358).
* Thu Jan 15 2009 mt@suse.de
- Fix message about missed service/server association (bnc#392354).
- Applied missed patch with support for dhcpFailOverPeer objects
  (failover peering definition) by S Kalyanasundaram (fate#303198).
* Thu Jan 15 2009 mt@suse.de
- Fixed init script to copy nsswitch.conf and all libnss libs to
  the chroot jail to fix resolving via /etc/hosts (bnc#462851).
* Tue Dec 16 2008 mt@suse.de
- Fixed init scripts Required-Start/Stop tags to require network-
  remotefs script, so all interfaces are up while start.
* Wed Nov 26 2008 coolo@suse.de
- prereq sysconfig to avoid warnings about missing
  /etc/sysconfig/dhcp
* Mon Nov 24 2008 mt@suse.de
- Removed network-number request from dhclient.conf (bnc#443788).
* Tue Nov 11 2008 mt@suse.de
- Fixed dhclient-script to apply DHCLIENT_SET_HOSTNAME and
  SET_DEFAULT_ROUTE policy correctly and inclusive of per
  interface setings (bnc#426650).
- Fixed dhclient-script to make sure, the host name is set
  as short-name even dhcp provides fqdn (bnc#418168)
- Fixed dhclient-script to translate all known dhcp options
  to netconfig variables and unknown with dhclient prefix.
- Fixed dhclient.conf to request all netbios dhcp-options,
  added also nds and mtu options.
* Fri Sep 12 2008 mt@suse.de
- Removed one of two option_state_dereference calls in dhclient.c
  causing null pointer messages (not critical) in the log.
- Fixed a forgotten fi typo in the dhclient-script
* Mon Sep  8 2008 mt@suse.de
- Updated to dhcp-3.1.1, providing following major new features
  compared to its 3.0.x derivative:
  * A significantly enhanced Failover protocol implementation,
    which:
    + Implements MAC Address Affinity to reduce the frequency
    of clients being assigned new IP addresses;
    + Supports the assignment of failover-protected addresses
    to legacy BOOTP clients;
    + Implements a dynamic lease reservation system that provides
    improved accounting of the use of fixed address assignments,
    by allocating fixed addresses out of the pool of dynamic leases
    + Improves tools and reduces operator oversight necessary for
    maintaining a functioning system.
  * Support for DHCP leasequery, and the VIVCO/VIVSO options, which
    makes easy and comfortable integration with DOCSIS devices and
    the environment in which they are used.
  * Management of class and subclass statements via OMAPI
  * Several server configuration options related to dynamic DNS
    behavior
  * Other new configuration functions, including "execute()",
    which runs a shell command from within a dhcpd or dhclient
    configuration file
  For a full list of new features added in this release, please
  observe the changes list.
- Adopted/merged patches, dropped obsolete dhcdbd (NM) patches.
* Fri Aug 22 2008 mt@suse.de
- Adopted dhclient-script and manual page to use /sbin/netconfig
  that is replacing the modify_resolvconf mechanizm by default.
* Wed Aug 20 2008 mt@suse.de
- Updated to dhcp-3.0.7, a maintenance release containing several
  bug fixes; since the 3.0.6 release this are:
  * Fixed "--version" flag in dhcrelay.
  * Clarified error message when lease limit exceeded
  * Fixed a buffer overflow error which could have allowed a denial
    of service under unusual server configurations
  * Bug in octal parsing fixed. Thanks to Bernd Fuhrmann for the
    report and fix.
  * The warning logged when an address range doesn't fit in the
    subnets they were declared has been updated to be more helpful
    and identify the typo in configuration that created the
    spanning addresses.
  * The 'min-secs' configuration parameter's log message has been
    updated to be more helpful.
  * Fixed a bug in which write_lease() might report a failure
    incorrectly.
  * Bug in server configuration parser caused server to get stuck
    on startup for certain bad pool declarations. Thanks to
    Guillaume Knispel for the bug report and fix.
  * Fixed file descriptor leak on listen failure. Thanks to Tom
    Clark.
  * Failover binding acks are now transmitted before new binding
    updates (which may, very rarely, be related to a lease on the
    ack queue).  This eliminates a lease database inconsistency
    bug, as the remote system relies upon the most recent message
    it received from its peer.
  * POOLREQ messages received within 30 seconds of one another are
    ignored.
  * 'lease imbalance' messages are not logged unless rebalance was
    actually attempted ("ten percent" rule).
  * A bug was fixed where the 'giaddr' may be used to find the
    client's subnet rather than its own 'ciaddr'.
  * A log message was introduced to clarify the situation where a
    failover 'address' parameter (the server's local address) did
    not resolve to an IPv4 address.
  * When server is configured with options that it overrides, a
    warning is issued when the configuration file is read, rather
    than at the time the option is overridden. This was important,
    because the warning was given every time the option was
    overridden, which could create a lot of unnecessary logging.
  * When a failover server suspects it has encountered a peer
    running a version 3.1.x failover server, a warning that the
    failover wire protocol is incompatible is printed.
  * The failover server no longer issues a floating point error
    if it encounters a previously undefined option code.
  * A memory leak when using omapi has been fixed.
- Adopted dhcp-send-hostname-rml patch
- Removed obsolete dhcp-3.0.5-pool_eof patch
- Merged changes between server:isc-dhcp and openSUSE:Factory
- Removed down parameter from ifconfig calls in dhclient-script
  because it destroys bonding interfaces and also conflicts with
  an dhcpv6 client running on same interface (bnc#410905).
* Wed Aug 20 2008 skalyanasundaram@novell.com
- Added missing DNs (dhcpZoneDN, dhcpFailOverPeerDN) to list of
  external references.
* Fri Jun 27 2008 mt@suse.de
- Added /etc/openldap directory to the file list of the dhcp-server
  package, because it is not provided by the ldap package any more.
* Fri May 23 2008 mt@suse.de
- Don't set parts of host error messages as hostname (bnc#389668).
* Mon May 19 2008 mt@suse.de
- Documentation updates for DDNS-howto.txt (bnc#359977).
* Fri Apr  4 2008 mt@suse.de
- Changed the list of dhcp options required by the dhcp-client in
  the server response to not to enforce the domain-name-servers
  option availiability (bnc#331964).
- Fixed too long error messages server init script (bnc#353589).
- Renamed/renumbered patches modifying the dhclient.conf file.
- Fixed the dhclient-script to add explicit host route to default
  gateway when it is not reachable via interface route created by
  ifconfig based on the IP and netmask (e.g. /32) values provided
  by dhcp server (bnc#266215).
- Fixed ntp configuration feature in dhclient-script to try-restart
  the ntp service to apply the server changes. Changed to use new
  per interface server list to avoid merge problems (bnc#375746).
* Tue Apr  1 2008 mkoenig@suse.de
- remove dir /usr/share/omc/svcinfo.d as it is provided now
  by filesystem
* Tue Dec  4 2007 mt@suse.de
- Bug #343069: Added dhcp-server compatibility workaround to search
  for lower- and upper-case MAC addresses in the dhcpHWAddress LDAP
  attributes. New patch: dhcp-3.0.6-ldap-patch_hwaddr-icase.dif
* Mon Nov 19 2007 mt@suse.de
- Disabled script setting in the /etc/dhclient.conf,
  because it overrides the -sf command line option.
* Fri Aug 24 2007 mt@suse.de
- Removed getcfg interface config to interface name conversions
* Mon Jul 30 2007 thoenig@suse.de
- dhcp-3.0.3-dhclient-script-dhcdbd.patch: dbus-send is now located
  in /bin
* Thu Jul 19 2007 mt@suse.de
- Updated to 3.0.6, a maintenance release containing fixes
  for bugs discovered since DHCP 3.0.5, but no new features.
  See the RELNOTES file for full list of changes.
- Adopted dhcp-3.0rc10.filedes.dif patch
  new patch file name: dhcp-3.0.6-dhclient-exec-filedes.dif
- Bug #289933: Let dhclient request netbios-name-servers as well;
  old patch file name: dhcp-3.0.5-dhclient-nis-ntp.patch
  new patch file name: dhcp-3.0.6-dhclient-requests-conf.patch
- Removed $local_fs from init-scripts, included in $remote_fs.
* Wed Jun 27 2007 anschneider@suse.de
- Added support for ntpd runtime configuration
  new patch file: dhcp-3.0.6-dhclient-script-ntp-runtime.patch
* Wed Jun 27 2007 lmuelle@suse.de
- Let dhclient request ntp-servers by default.
* Tue May 22 2007 mt@suse.de
- Bug 275592: Added ldap and ndsd to the Should-Start/Stop LSB
  init info tags of the dhcp-server init script.
- Bug #241113: Added copying of /etc/openldap/ldap.conf and
  more base libraries into the chroot jail.
* Mon May 14 2007 mt@suse.de
- Bug #265337: Fix to generate proper "host ... {" block begin
  brace even if no harware address is specified for the host.
  New patch file: dhcp-3.0.5-ldap-patch_host_brace.dif
- Bug #258493: Fix to support new dhcpServerDN reference in
  dhcpService object search filter.
  New patch file: dhcp-3.0.5-ldap-patch_server_dn.dif
- Fixed LSB init info to use LSB 2.0 Should-Start/Should-Stop.
* Thu Mar 15 2007 mt@suse.de
- Bug #181212: Improved dhcp init-script to copy directories
  specified in the DHCPD_CONF_INCLUDE_FILES sysconfig variable
  into the chroot jail.
* Wed Mar 14 2007 mt@suse.de
- Bug #247365: Added installation of dhcp-server SuSEfirewall2
  service definition file.
* Tue Mar 13 2007 mt@suse.de
- Updated to dhcp-3.0.5-ldap-patch.gz, released on 2007-02-23
  fixing a parsing bug in dhcpd-conf-to-ldap.pl script to handle
  correctly quoted string containing spaces.
  Further, it includes our fixes and obsoletes following patches:
  * dhcp-3.0.5-ldap-patch-strncat.dif
  * dhcp-3.0.5-ldap-patch-casa-fix.dif
  * dhcp-3.0.5-ldap-patch-dhcp-cn.dif
  * dhcp-3.0.5-ldap-patch-schema.dif
  * dhcp-3.0.5-ldap-patch-nomd5.dif
  * dhcp-3.0.5-ldap-patch-referrals.dif
  * dhcp-3.0.5-ldap-patch-ssl-opts.dif
  * dhcp-3.0.5-ldap-patch-ldap_read.dif
- Bug #250153: Fix for object order related parse error, that
  occured in case an dhcp-ldap object referencing a dhcp-tsigkey,
  class or failoverpeer object was parsed before the declaration
  of the referenced objects, because of the order in ldap result.
  New patch file: dhcp-3.0.5-ldap-patch_object-order.dif
* Tue Feb 20 2007 mt@suse.de
- Bug #162186: Added check for EOF in parse_pool_statement to
  avoid endless recursion loop between parse_pool_statement
  and parse_statement when a closing right brace "}" is missed
  at the end of a pool declaration in /etc/dhcpd.conf.
  New patch file: dhcp-3.0.5-pool_eof.dif
- Fixed ldap_read_function to avoid returning of empty strings
  causing parsing errors in ldap-dynamic mode.
  New patch file: dhcp-3.0.5-ldap-patch-ldap_read.dif
* Thu Jan 25 2007 mt@suse.de
- Updated to dhcp-3.0.5-ldap-patch.gz, providing several fixes:
  * unbind from the LDAP server after the config file has been ran
    if the server is being ran in static mode
  * fixed ldap_read_function bug where the entire configuration
    was not being processed
  and extensions / enhancements:
  * added functions for reading config values from the config
    file to clean up the ldap_start() function.
  * new ldap-server-cn option that will be used to locate the
    data in ldap; defaults to the hostname as before (FATE #227).
  * while host is added in the ldap-method dynamic mode, try to
    find if it belongs to a group and apply the group options too.
  * modifies the dhcpHWAddress attribute to case-insensitive, adds
    several new objectclasses, e.g. dhcpLocator, dhcpTsigKey,
    dhcpDnsZone,dhcpFailOver to the dhcp.schema.
  * implements support for dhcpTsigKey, dhcpDnsZone and related.
  * implements auth password query via casa.
- Adopted ldap-patch-strncat, removed ldap-patch-nossl obsoleted by
  ldap-patch-nomd5. New patch: dhcp-3.0.5-ldap-patch-strncat.dif
- Added dhcp-3.0.5-ldap-patch-nomd5.dif linking the dhcp-server
  with md5 functions from openssl library instead of own copy.
- Added dhcp-3.0.5-ldap-patch-casa-fix.dif, fixing casa support
- Added dhcp-3.0.5-ldap-patch-dhcp-cn.dif, renaming the dhcpd.conf
  ldap-server-cn option to more clear ldap-dhcp-server-cn.
- dhcp-3.0.5-ldap-patch-schema.dif
- Added dhcp-3.0.5-ldap-patch-referrals.dif, implementing support
  for LDAP referrals, introducing new "ldap-referrals <on|off>"
  option in dhcpd.conf.
- Added dhcp-3.0.5-ldap-patch-ssl-opts.dif enabling/implementing
  TLS/LDAPS support. Adds new "ldap-ssl <on|off|ldaps|start_tls>"
  and several "ldap-tls-*" options for dhcpd.conf. By default, the
  server trys to use TLS if possible, but continues without if not.
* Tue Jan  9 2007 mt@suse.de
- Added installation of dhcpd.xml, dhcpd service description
  for omc xml-service-provider, fate #301710.
- fix of the ldap-patch strncat fix, bug #202648
* Wed Nov  8 2006 mt@suse.de
- fix for strncat usage in ldap-patch, bug #202648
* Tue Nov  7 2006 mt@suse.de
- updated to 3.0.5, bug #212310:
  * This release is a maintenance release that seeks to correct bugs
    introduced in 3.0.4 or prior. The most important of these bugs
    is for 64-bit time_t systems that was introduced in 3.0.4.
  * If you are upgrading from ISC DHCP 3.0.3 or prior and are using
    failover, please take special care of the 'atsfp' values now
    included on failover-controlled leases. See the RELNOTES file.
- adopted dhcp-3.0.4-tmpfile.dif (now dhcp-3.0.5-tmpfile.dif)
- added to provide gpg signature of the tar archive as rpm-source
* Tue Oct 17 2006 poeml@suse.de
- there is no SuSEconfig.syslog script anymore, thus remove the
  YaST hint from the sysconfig template
* Fri Jun  9 2006 poeml@suse.de
- upstream 3.0.4:
  * fix an insidious bug in the failover implementation which, if
    left unchecked, could result in tying up all leases in
    transitional states (such as released, reset, or expired)
  * fix a confusing (wrong) syslog line, logged by during DDNS update
  * The server now tries harder to survive the condition where it is
    unable to open a new lease file to rewrite the lease state
    database.
  * several other small bug fixes
- update ldap patch. It now supports ldap over ssl, but we don't
  enable it and add dhcp-3.0.4-ldap-patch-nossl.dif, because at the
  moment there seems to be a choice between linking dhclient
  against ldap+ssl libs (not in /lib) or risking clash between
  openssl and isc's md5 symbols. (At least, I assume that this is
  the reason why the ldap patch now removes the isc implementation
  from the build.) Thus, I readd the patch which added ldap libs to
  LIBS in the server subdir only, via ./configure
- if /etc/sysconfig/dhcpd:DHCPD_INTERFACE is set to "ANY", dhcpd
  will now autodetect available network interfaces
* Fri Jun  2 2006 poeml@suse.de
- allow for build on SUSE Linux 9.3 and older (no -fpie)
- clean up all CFLAGS/DEBUG_FLAGS definitions
* Tue May 16 2006 poeml@suse.de
- add s390x to the list of platforms to compile with -fsigned-char
  to avoid the dhclient.conf parse error "expecting a statement"
  [#171532], [#134590]
* Thu May  4 2006 rml@suse.de
- Add "-H" flag for setting hostname (Novell major bug #139532)
* Wed Mar 29 2006 poeml@suse.de
- fix two further include paths in dhcpctl.3 and omapi.3
* Wed Mar 29 2006 poeml@suse.de
- package the static libdst.a library [#158271]
- fix the include path in dhcpctl.3 and omapi.3 [#158271]
* Fri Jan 27 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 25 2006 poeml@suse.de
- dereference links when copying stuff into the chroot jail [#145169]
* Mon Jan 23 2006 thoenig@suse.de
- dropped dhcp-3.0.3-dhclient-nm_active-01-thoenig.patch.  Correct
  solution is being implemented in NetworkManager
* Sat Jan 14 2006 thoenig@suse.de
- replaced 'nis-domain-servers' by 'nis-servers' in
  dhcp-3.0.3-dhclient-nis-01-thoenig.patch (follow-up #134160)
* Fri Jan 13 2006 thoenig@suse.de
- add 'nis-domain' and 'nis-domain-servers' to 'request'
  dhclient.conf (dhcp-3.0.3-dhclient-nis-01-thoenig.patch).  If
  the DHCP reply contains information about NIS, NM will set those.
  (#134160)
- extended /sbin/dhclient-script to set domain name and host name.
  This will only happen if the relevant options in
  /etc/sysconfig/network/dhcp are set.
  (dhcp-3.0.3-dhclient-nm_active-01-thoenig.patch) (#134160)
* Mon Nov 28 2005 poeml@suse.de
- compile with -fsigned-char on ppc/ppc64, avoiding the
  dhclient.conf parse error "expecting a statement" [#134590]
* Sun Sep 25 2005 ro@suse.de
- define LDAP_DEPRECATED in CFLAGS
* Wed Aug  3 2005 poeml@suse.de
- update to 3.0.3
  * A bug was fixed in BOOTPREQUEST handling code wherein stale
    references to host records would be left behind on leases that
    were not allocated to the client currently booting (eg in the
    case where the host was denied booting).
  * The dhcpd.conf.5 manpage was updated to be more clear in
    regards to multiple host declarations (thanks to Vincent
    McIntyre).  'Interim' style dynamic updates were also
    retouched.
  * dhclient.conf documentation for interface {} was updated to
    reflect recent discussion on the dhcp-hackers mailing list.
- update ldap patch, patches merged upstream
- compile with LPF instead of bsd sockets. Provide optional binary
  compiled with bsd sockets.
- README: describe how to serve option 119 (searchlist), add dns
  compression tool
* Tue Jul 12 2005 hare@suse.de
- build with pie/PIE depending on architecture.
* Thu Jun 30 2005 gekker@suse.de
- Add -DEXTENDED_NEW_OPTION_INFO to CFLAGS for rml
* Tue Jun 28 2005 gekker@suse.de
- Add support for dhcdbd, patches from RH via rml
* Mon Jun 20 2005 ro@suse.de
- build with pie/fpie
* Mon Jun 13 2005 kukuk@suse.de
- Don't use kernel types in user space
* Fri Apr  8 2005 poeml@suse.de
- update to 3.0.3b1 release. Changes since 3.0.2:
  * A bug was fixed where a server might load balance a DHCP REQUEST to its
    peer after already choosing not to load balance the preceeding DISCOVER.
    The peer cannot allocate the originating server's lease.
  * In the case where a secondary server lost its stable storage while the
    primary was still in communications-interrupted, and came back online,
    the lease databases would not be fully transferred to the secondary.
    This was due to the secondary errantly sending an extra UPDREQ message
    when the primary made its state transition to PARTNER-DOWN known.
  * The package will now compile cleanly in gcc 3.3 and 3.4.  As a side effect,
    lease structures will be 9 bytes smaller on all platforms.  Thanks to
    Jason Vas Dias at Redhat.
  * Interface discovery code in DISCOVER_UNCONFIGURED mode is now
    properly restricted to only detecting broadcast interfaces.  Thanks
    to a patch from Jason Vas Dias at RedHat.
  * decode_udp_ip_header was changed so that the IP address was copied out
    to a variable, rather than referenced by a pointer.  This enforces 4-byte
    alignment of the 32-bit IP address value.  Thanks to a patch from Dr.
    Peter Poeml.
  * An incorrect log message was corrected thanks to a patch from
    Dr. Peter Poeml.
  * A bug in DDNS was repaired, where if the server's first DDNS action was
    a DDNS removal rather than a DDNS update, the resolver library's
    retransmit timer and retry timer was set to the default, implying a
    15 second timeout interval.  Which is a little excessive in a synchronous,
    single-threaded system.  In all cases, ISC DHCP should now hold fast to
    a 1-second timeout, trying only once.
  * The siaddr field was being improperly set to the server-identifier when
    responding to DHCP messages.  RFC2131 clarified the siaddr field as
    meaning the 'next server in the bootstrap process', eg a tftp server.
    The siaddr field is now left zeroed unless next-server is configured.
  * mockup_lease() could have returned in an error condition (or in the
    condition where no fixed-address was found matching the shared
    network) with stale references to a host record.  This is probably not
    a memory leak since host records generally never die anyway.
  * A bug was repaired where failover servers would let stale client identifiers
    persist on leases that were reallocated to new clients not sending an id.
  * Binding scopes ("set var = value;") are now removed from leases allocated
    by failover peers if the lease had expired.  This should help reduce the
    number of stale binding scopes on leases.
  * A small memory leak was closed involving client identifiers larger than
    7 bytes, and failover.
  * Configuring a subnet in dhcpd.conf with a subnet mask of 32 bits might
    cause an internal function to overflow heap.  Thanks to Jason Vas Dias
    at Redhat.
  * Some inconsistencies in treating numbers that the lexer parsed as 'NUMBER'
    or 'NUMBER_OR_NAME' was repaired.  Hexadecimal parsing is affected, and
    should work better.
  * In several cases, parse warnings were being issued before the lexical
    token had been advanced to the token whose value was causing an error...
    causing parse warnings to claim the problem is on the wrong token.
  * Host declarations matching on client identifier for dynamic leases will
    no longer match fixed-address host declarations (this is now identical
    to behaviour for host records matching on hardware address).
- print error if binary DHCPD_BINARY is not found [#76392]
- remove patches incorporated upstreams
- update ssh forced command example in dhcpsync man page
* Mon Feb 21 2005 poeml@suse.de
- update to 3.0.2 release. Changes since 3.0.2rc3:
  * A previously undocumented configuration directive,
    'local-address', was documented in the dhcpd.conf manpage.
* Tue Feb  8 2005 mt@suse.de
- Bug #49433: try to reconnect to ldap server if it was down;
  ignore SIGPIPE while ldap_unbind called on closed handle.
  = new patch file: dhcp-3.0.2-ldap-reconnect.mt.dif.gz
* Tue Dec  7 2004 poeml@suse.de
- update to 3.0.2rc3. Changes since rc2:
  * Two variables introduced in 3.0.2b1 were used without being
    initialized in the case where neither the FILE nor SNAME fields
    were available for overloading.  This was repaired.
  * A heretofore believed to be impossible corner case of the
    option overloading implementation turned out to be possible
    ("Unable to sort overloaded options after 10 tries.").  The
    implementation was reworked to consider the case of an option
    so large it would require more than three chunks to fit.
  * Many other instances of variables being used without being
    initialized were repaired.
  * An uninitialized variable in omapi_io_destroy() led to the
    discovery that this function may result in orphaned pointers
    (and hence, a memory leak).
- refresh the unaligned.patch
* Tue Nov 30 2004 poeml@suse.de
- update to 3.0.2rc2. Changes since 3.0.1:
  * allocate_lease() was rewritten to repair a bug in which the server would
    try to allocate an ABANDONED lease when FREE leases were available.
  * Some dhcp-eval.5 manpage formatting was repaired.
  * A bug was fixed in the server's 'option overloading' implementation,
    where options loaded into the 'file' and 'sname' packet fields were
    not aligned precisely as rfc2131 dictates.
  * The FreeBSD client script was changed to support the case where a domain
    name was not provided by the server.
  * A memory leak in 'omshell' per each command line parsed was
    repaired, thanks to a patch from Jarkko Torppa.
  * Log functions writing to stderr were adjusted to use the STDERR_FILENO
    system definition rather than '2'.  This is a no-op for 90%% of platforms.
  * One call to trace_write_packet_iov() counted the number of io vectors
    incorrectly, causing inconsistent tracefiles.  This was fixed.
  * Some expression parse failure memory leaks were closed.
  * A host byte order problem in tracefiles was repaired.
  * Pools configured in DHCPD for failover possessing permission lists that
    previously were assumed to not include dyanmic bootp clients are now
    a little more pessimistic.  The result is, dhcpd will nag you about just
    about most pools that possess a 'allow' statement with no 'deny' that
    would definitely match a dynamic bootp client.
  * The 'ddns-update-style' configuration warning bit now insists that
    the configuration be globally scoped.
  * Two memory leaks in dhclient were closed thanks to a patch from Felix
    Farkas.
  * Some minor but excellently pedantic documentation errors were fixed
    thanks to a patch from Thomas Klausner.
  * Bugs in operator precedence in executable statements have been repaired
    once again.  More legal syntaxes should be parsed legally.
  * Failing to initialize a tracefile for any reason if a tracefile was
    specified is now a fatal error.  Thanks to a patch from Albert Herranz.
  * Corrected a bug in which the number of leases transferred as calculated
    by the failover primary and sent to peers in POOLRESP responses may be
    incorrect.  This value is not believed to be used by other failover
    implementations, excepting perhaps as logged information.
  * Corrected a bug in which 'dhcp_failover_send_poolresp()' was in fact
    sending POOLREQ messages instead of POOLRESP mesasges.  This message
    was essentially ignored since failover secondaries effectively do not
    respond to POOLREQ messages.
  * Type definitions for various bitwidths of integers in the sunos5-5
    build of ISC DHCP have been fixed.  It should compile and run more
    easily when built in 64-bit for this platform.
  * "allow known-clients;" is now a legal syntax, to avoid confusion.
  * If one dhcp server chooses to 'load balance' a request to its failover
    peer, it first checks to see if it believes said peer has a free
    lease to allocate before ignoring the DISCOVER.
  * log() was logging a work buffer, rather than the value returned by
    executing the statements configured by the user.  In some cases,
    the work buffer and the intended results were the same.  In some other
    cases, they were not.  This was fixed thanks to a patch from Gunnar
    Fjone and directconnect.no.
  * Compiler warnings for some string type conversions was fixed, thanks
    to Andreas Gustafsson.
  * The netbsd build environments were simplified to one, in which
  - Wconversion is not used, thanks to Andreas Gustafsson.
  * How randomness in the backoff-cutoff dhclient configuration variable
    is implemented was better documented in the manpage, and the behaviour
    of dhclient in REQUEST timeout handling was changed to match that of
    DISCOVER timeout handling.
  * Omapi was hardened against clients that pass in null values, thanks
    to a patch from Mark Jason Dominus.
  * A bug was fixed in dhclient that kept it from doing client-side
    ddns updates.  Thanks to a patch from Andreas Gustafsson, which
    underwent some modification after review by Jason Vas Dias.
  * Failover implementations disconnected due to the network between
    them (rather than one of the two shutting down) will now try to
    re-establish the failover connection every 5 seconds, rather than
    to simply try once and give up until one of them is restarted.
    Thanks to a patch from Ulf Ekberg from Infoblox, and field testing
    by Greger V. Teigre which led to an enhancement to it.
  * A problem that kept DHCP Failover secondaries from tearing down
    ddns records was repaired.  Thanks to a patch from Ulf Ekberg from
    Infoblox.
  * 64bit pointer sizes are detected properly on FreeBSD now.
  * A bug was repaired where the DHCP server would leave stale references
    to host records on leases it once thought about offering to certain
    clients.  The result would be to apply host and 'known' scopes to the
    wrong clients (possibly denying booting).  NOTE:  The 'mis-host' patch
    that was being circulated as a workaround is not the way this bug was
    fixed.  If you were a victim of this bug in 3.0.1, you are cautioned
    to proceed carefully and see if it fixes your problem.
  * A bug was repaired in the server's DHCPINFORM handling, where it
    tried to divine the client's address from the source packet and
    would get it wrong.  Thanks to Anshuman Singh Rawat.
  * A log message was introduced to help illuminate the case where the
    server was unable to find a lease to assign to any BOOTP client.
    Thanks to Daniel Baker.
  * A minor dhcpd.conf.5 manpage error was fixed.
- update ldap patch (11/8/2004 version)
* Thu Nov 11 2004 ro@suse.de
- fixed file list for devel package
* Thu Sep 23 2004 poeml@suse.de
- sysconfig.dhcpd, sysconfig.dhcrelay: give examples how to use
  configuration names instead of interface names
* Thu Aug  5 2004 poeml@suse.de
- update to 3.0.1
  * The global variable 'cur_time' was centralized and is now
    uniformly of a type #defined in system-dependent headers. It
    had previously been defined in one of many places as a 32-bit
    value, and this causes mayhem on 64-bit big endian systems. It
    probably wasn't too healthy on little endian systems either.
  * A printf format string error introduced in rc14 was repaired.
  * AIX system-dependent header file was altered to only define
    NO_SNPRINTF if the condition used to #ifdef in vsnprintf in
    AIX' header files is false.
  * The Alpha/OSF system-dependent header file was altered to
    define NO_SNPRINTF on OS revisions older than 4.0G.
  * omapip/test.c had string.h added to its includes.
- drop obsolete dhcp-curtimetype.patch
- cope with missing files during chroot setup (e.g., if no
  resolv.conf exists) [#40728]
- remove duplicated option "-cf" from usage output
- add notes about the used raw socket API to README
* Fri Jul 16 2004 poeml@suse.de
- update to 3.0.1rc14
- remove obsolete patches and adapt dhcp-3.0.1rc13-tmpfile.dif
- dhcpsync: use try-restart (so the server isn't started if it has
  been stopped)
- remove notify messages that are sent to root
- check if dhcpd was active at boot time before update and
  restore runlevel links if needed [#41215], and PreRequires for
  that
* Mon Jun 14 2004 poeml@suse.de
- security fixes [#41975]:
  - fix buffer overflow in the DHCP server that can be exploited by
    the client by specifying multiple 'hostnames' to execute
    arbitrary code or at least crash the server. VU#317350
  - add patch to use vsnprintf() instead of vsprintf() calls.
    VU#654390
* Fri May 14 2004 poeml@suse.de
- fix sysconfig comment and DHCPD_RUN_AS default [#40174]
* Thu May 13 2004 poeml@suse.de
- improve security of the chroot jail setup by creating a dedicated
  user id for the server, and move the leases database into a
  subdirectory (/var/lib/dhcp/db). With the exception of that
  subdirectory the chroot jail is now owned by root. [#40174]  Use
  mkstemp to create temporary files. [#40267]
- don't use startproc to start dhcpd, because startproc waits a
  fixed time (100 msec) until it decides whether the service is
  running or not. Now that dhcpd might have to contact an LDAP
  server first to read its configuration, starting up can take
  longer than that, and the init script would falsely report
  "success" even when the server cannot start up due to broken
  configuration or non-existant interfaces. Increasing the
  startproc timeout (-t) is not a real alternative because, because
  it would imply a fixed dely to the init script, and it might
  still be too short.  [#40350]
* Tue May  4 2004 poeml@suse.de
- convert configuration names in DHCPD_INTERFACE /
  DHCRELAY_INTERFACES into interface names [#39718]
- fix service restart for the case where the binary has been
  switched for backward compatibility during updating.
- do not change DHCPD_BINARY for backward compatibility if updating
  from 9.0. This and the last change complete the fix for [#38422]
  and take care of updates from 8.1-9.1 with and without YOU
  updates.
* Fri Apr 30 2004 poeml@suse.de
- additionally package the dhcpd binary that uses the Linux packet
  filter API. New option DHCPD_BINARY in sysconfig.dhcpd. [#38422]
- when updating from a previous package using LPF API, retain the
  old behaviour. Fix init script so that 'stop' works also after a
  switch of DHCPD_BINARY.
* Thu Apr 22 2004 mt@suse.de
- updated to dhcp-3.0.1rc13-ldap-patch also obsolating the
  patches: dhcp-ldap-fix01.dif, dhcpd-conf-to-ldap.pl.dif
- added dhcp-3.0.1rc13-ldap.mt.dif, providing diverse fixes
  and basic failover support for server/ldap.c
- added dhcpd-conf-to-ldap.mt.dif providing failover support
  to dhcpd.conf convert script
* Thu Mar 25 2004 mt@suse.de
- applied dhcp-3.0.1rc12-ldap-patch adding support to store
  dhcp configuration in ldap (incl. draft ldap schema).
  further patches:
  - dhcp-ldap-fix01.dif: fixes for server/ldap.c (debuging
    output, support for block statements, ...)
  - dhcpd-conf-to-ldap.pl.dif: fixes for convert script
* Wed Feb 25 2004 poeml@suse.de
- the genDDNSkey script has been moved to the bind-utils package
- update the DDNS-howto.txt
- package leases.awk (dhcpd.leases analyzer) (courtesy of Jeff Wilson)
- update to 3.0.1rc13
  - Fixed a bug in omapi lease lookup function, to form the
    hardware address for the hash lookup correctly
  - The 'ping timeout' debugs from rc12 were removed to -DDEBUG
    only
  - Fixed a case where leases read from the leases database do not
    properly over-ride previously read leases.
  - Fixed a bug where dhcrelay was sending relayed responses back
    to the broadcast address, but with the source's unicast mac
    address.  Should now conform to rfc2131 section 4.1.
  - Fixed a crash bug in dhclient where dhcpd servers that do not
    provide renewal times results in an FPE.  As a side effect,
    dhclient can now properly handle 0xFFFFFFFF (-1) expiry times
    supplied by servers.
  - dhcpctl.3 manpage was tweaked.
- the files CHANGES and COPYRIGHT have vanished, package LICENSE
  instead
* Sun Jan 11 2004 adrian@suse.de
- build as user
* Tue Nov 18 2003 poeml@suse.de
- if starting dhcpd in chroot jail, and a pid file is present in
  the jail, and the pid file does not contain a pid of a running
  dhcpd process, but that of another _running_ process, remove
  that pid file. [#32603]
- fix typo in dhcp.LIESMICH
- DDNS-howto.txt: adjust changed path
- DDNS-howto.txt: instead of the shell variables (they were copy
  and paste'd from a script), use a real example (makes it easier)
- add a comment in sysconfig.dhcpd that entire directories may be
  included
- dhcpsync: if run from the commandline, do not use an identity
  that ssh-agent may hold, but use $KEY instead
- dhcpsync.8: add a note about a know limitation
* Tue Nov 18 2003 poeml@suse.de
- fix wrong ServiceRestart tags in sysconfig/dhcrelay [#32062]
* Fri Oct 17 2003 uli@suse.de
- fixed data type mismatch in libomapi, only harmful on 64-bit
  BE systems (ppc64, s390x, bug #32123)
* Mon Sep  8 2003 poeml@suse.de
- update to 3.0.1rc12
  - a failover bug relating to identifying peers by name length
    instead of by name was fixed
  - declaring failover configs within shared-network statements
    should no longer result in error
  - a problem with lease expiry times in failover configurations
    was fixed
  - reverse dns PTR record updates with values containing spaces
    are now permitted
  - problems with long option processing fixed
  - fixes to minires so that updates of KEY records will work
  - memory leak in configuration parsing closed
  - non-broadcast or point-to-point interfaces are now ignored
  - options not yet known by the dhcpd or dhclient now appear as
    e.g. "unknown-144" rather than "#144" in the leases file, to
    avoid the hash marks
  - dhclient no longer uses shell commands to kill another instance
    of itself, it sends the signal directly.
  - the -nw command line option to dhclient now works
- dhcp-3.0.1rc10-dhcrelay-limit-hopcount.dif included upstreams
- added contrib/ms2isc (converts Microsoft DHCP server configuration)
* Mon Sep  8 2003 poeml@suse.de
- mark dhclient's lease database %%config(noreplace)
* Wed Sep  3 2003 kukuk@suse.de
- Really fix [#29405], server should not provide and obsolete dhcp.
* Wed Aug 27 2003 poeml@suse.de
- don't provide/require dhcp-base. Require dhcp instead [#29405]
* Tue Aug 26 2003 poeml@suse.de
- add Config: syslog-ng to sysconfig.syslog-dhcpd
* Fri Aug 15 2003 poeml@suse.de
- use -Wall -Wno-unused
- add -fno-strict-aliasing, due to warnings about code where
  dereferencing type-punned pointers will break strict aliasing
- add activation metadata to sysconfig template [#28864, [#28865],
  [#28950]
* Tue Aug 12 2003 poeml@suse.de
- rc.dhcpd, rc.dhcrelay: implement try-restart correctly
- cleaned up the root mail, and the READMEs [#27214], [#26266]
- send the root mail only on update [#27214]
- have no default value in /etc/sysconfig/dhcpd:DHCPD_INTERFACE
- in client's %%post, send a mail only when rc.config is encountered
- clean buildroot, but not in chroot buildsystem
- the SuSE string is now replaced by UnitedLinux where appropriate
- rename the "dhcp-base" package to "dhcp", so there is a binary
  package matching the name of the source package [#17668]
- use the lately added macros only on newer distributions
* Wed Jul 30 2003 poeml@suse.de
- new macros for stop/restart of services on rpm update/removal
* Mon Jul 28 2003 poeml@suse.de
- when copying include files into the chroot jail, create
  subdirectories as needed, thus retaining the path to the files
* Sun Jul 27 2003 poeml@suse.de
- don't explicitely strip binaries since RPM handles it, and may
  keep the stripped information somewhere
* Mon Jun 16 2003 poeml@suse.de
- add some notes to DDNS-howto.txt, kindly provided by Andrew Beames
- fix typo in genDDNSKey.sh
* Wed May 21 2003 mmj@suse.de
- Implement try-restart correctly in init-script
* Mon May 19 2003 poeml@suse.de
- update to 3.0.1rc11, relevant fixes are
  - Potential buffer overflows in minires repaired.
  - A correction of boolean parsing syntax validation - some illegal syntaxes
  that worked before are now detected and produce errs, some legal syntaxes
  that errored before will now work properly.
  - Some search-and-replace errors that caused some options to change their
  names was repaired.
  - Shu-min Chang of the Intel corporation has contributed a perl script and
  module that converts the MS NT4 DHCP configuration to a ISC DHCP3
  configuration file.
  - Applied the remainder of the dhcpctl memory leak patch provided by Bill
  Squier at ReefEdge, Inc.  (groo@reefedge.com).
  - Missing non-optional failover peer configurations will now result in a soft
  error rather than a null dereference.
- use BSD sockets instead of LPF (makes iptables filtering of
  packages possible for server and relay. It doesn't work on the
  client, though, so that one requires seperate compilation.) See
  Message-Id: <5.1.0.14.0.20030408175011.00b9c7c0@pop.itd.nrl.navy.mil>
* Thu Mar 13 2003 poeml@suse.de
- rcdhcpd, rcdcrelay: do not write the startup log to a world
  writable directory [#25241]
* Mon Mar  3 2003 poeml@suse.de
- don't try to copy libraries into the chroot jail that do not
  exist (any longer) [#24533]
- remove the %%ghost filelist entries for pid files and chroot jail
  contents [#20030]. Clean up the libraries from the jail when the
  server is stopped.
- dhcrelay: add patch from Florian Lohoff (slightly modified),
  that makes the maximal hop count of forwarded packages
  configurable (-c maxcount), sets the default to 4, and rejects
  packages with a hop count higher than maxcount (CAN-2003-0039,
  http://www.kb.cert.org/vuls/id/149953). Add a variable to
  /etc/sysconfig/dhcrelay to pass such additional options.
* Wed Feb 12 2003 mmj@suse.de
- Added sysconfig metadata [#22631] [#22632] [#22696]
* Tue Dec 10 2002 okir@suse.de
- Added security patch from ISC
* Thu Dec  5 2002 poeml@suse.de
- update to 3.0.1rc10. relevant fixes:
  - A Linux-specific Token Ring detection problem was fixed.
  - Hashes removed from as-yet-unknown agent options, having those
    options appear in reality before we know about them will no
    longer produce self-corrupting lease databases.
  - dhclient will use the proper port numbers now when using the -g
    option.
  - A order-of-operations bug with 2 match clauses in 1 class
    statement is fixed thanks to a patch from Andrew Matheson.
  - A fix to the dhcp ack process which makes certain group options
    will be included in the first DHCPOFFER message was made thanks
    to a patch from Ling Gou.
  - A few memory leaks were repaired thanks to patches from Bill
    Squier at ReefEdge, Inc.  (groo@reefedge.com).
  - A fix for shared-networks that sometimes give clients options
    for the wrong subnets (in particular, 'option routers') was
    applied, thanks to Ted Lemon for the patch.
  - Omshell's handling of dotted octets as values was changed such
    that dots one after the other produce zero values in the
    integer string.
- due to the upstream fixes: drop the reactivate-tr-support.dif and
  format.dif
- retrofitted the (server) package to work for old distributions
  down to 7.2
* Fri Nov 29 2002 schwab@suse.de
- Fix unaligned access.
* Mon Nov  4 2002 poeml@suse.de
- update DDNS-howto.txt for BIND9
- add genDDNSKey.sh to create a key for BIND8/9
- add comments about DDNS to the dhcpd.conf [#18419], and
  directives to disable DDNS by default
- change defaults in the sample configuration
* Thu Aug 29 2002 poeml@suse.de
- fix permissions of man pages
* Sun Aug 18 2002 poeml@suse.de
- re-add token ring support that got lost ("tr0:unknown hardware
  address type 800"). With 2.4 kernel, ARPHRD_IEEE802 (6) has been
  renamed to ARPHRD_IEEE802_TR (800). Known bug in 3.0.1rc9.
- move PreReq tag to the subpackages, where it is actually needed
  [#17822, #17821]
* Mon Aug 12 2002 poeml@suse.de
- dhcp-client: add missing Requires on /usr/bin/host
* Mon Aug 12 2002 poeml@suse.de
- Fix requires of dhcp-devel subpackage
- add some helpful scripts, courtesy of Kevin C. Miller
* Thu Aug  1 2002 poeml@suse.de
- use PreReq
* Wed Jul 17 2002 poeml@suse.de
- add a sysconfig.syslog-dhcpd template to make syslogd open an
  additional socket (inside the chroot dir of dhcpd)
* Thu Jul 11 2002 poeml@suse.de
- fix typo in %%post, introduced with last change
* Thu Jul 11 2002 poeml@suse.de
- add Version: tags to the subpackages to satisfy the build system,
  because dhcp has no main package [#16318]
- run in chroot and as user nobody per default
- fix wrong pathnames in mail to root [#15601]
- install example dhcpd.conf [#9122]
- improve example configuration files [#12563]
- init scripts: update INIT INFO, using the new tags from
  /etc/init.d/skeleton
* Tue May 21 2002 poeml@suse.de
- dhclient-script:
  - source the right sysconfig files (/etc/sysconfig/network/)
    [#15871]
  - use KEEP_SEARCHLIST option (thanks Sumit Bose)
  - improve the indentation
* Thu May 16 2002 poeml@suse.de
- add documentation about configuration for dynamical DNS updates
* Mon May 13 2002 poeml@suse.de
- fix last change (rediff dhcp-3.0.1rc9.format.dif)
* Mon May 13 2002 poeml@suse.de
- update to 3.0.1rc9
  - fixes a format string vulnerability in the server that could
    lead to a remote root compromise
    (see http://www.cert.org/advisories/CA-2002-12.html)
  - fixes a memory leak in the client and some other minor bugs
- fix some printf arguments in server/omapi.c
- fix small typo (x390x -> s390x)
* Mon Apr 29 2002 sf@suse.de
- changed Makefile.conf to be able to add LIBDIR
- added LIBDIR to make install to put libs into the correct path
- use -DPTRSIZE_64BIT on x86_64
* Mon Apr 22 2002 poeml@suse.de
- update to 3.0.1rc8. Most significant changes are (see RELNOTES):
  - Don't allow a lease that's in the EXPIRED, RELEASED or RESET
    state to be renewed.
  - Implement lease stealing for cases where the primary has fewer
    leases than the secondary, as called for by the standard.
  - Fix a bug where if an option universe contained no options, the
    DHCP server could dump core (Walter Steiner).
  - Fix a bug in the handling of encapsulated options.
  - Fix an uninitialized memory bug in the DHCP client.
- use -DPTRSIZE_64BIT on x390x and ppc64, too
- create /etc/resolv.conf with a file mask of 644, regardless of
  the umask [Bug #15915]. Patch by Joerg Mayer.
- the scripts dir is now called CLIENTBINDIR in the Makefiles, and
  correctly set to /sbin --> drop 2 hunks from dhcp-3.0rc10.dif
* Tue Mar 26 2002 ro@suse.de
- Fix handling of initscript links and START_* variable [Bug #13755]
* Sun Feb 10 2002 poeml@suse.de
- drop the sysconfig/network/dhcp template. It's in the syconfig
  package now.
- strip /sbin/dhclient
* Mon Feb  4 2002 poeml@suse.de
- rename dhcp subpackage to dhcp-base, add dhcp-server subpackage
- rename dhclient to dhcp-client and dhcrelay to dhcp-relay
- remove Conflicts tag dhclient <-> dhcpcd
- use %%defattr(-, root, root) for all subpackages
- update copyright info (GmbH --> AG)
- update sysconfig.dhclient (.dhcp-dhclient now), and let it be
  filled up into /etc/sysconfig/network/config
* Wed Jan 30 2002 poeml@suse.de
- add /sbin/dhclient, accidentally deleted from filelist lately
* Sun Jan 27 2002 ro@suse.de
- remove START_DHCPD on update
- use fillup_only where no initscript is handled
* Sun Jan 27 2002 poeml@suse.de
- use %%_lib and %%_libdir
- update rc.dhcpd to use %%_libdir when setting up chroot dir
- dhcpsync: name of slave can be given as argument; update man page
- rc.dhcpd: no longer source rc.config
- don't try insserv on dhclient init script -- it's dropped
- tell fillup to use "dhcpd" instead of the package name (dhcp)
* Thu Jan 24 2002 poeml@suse.de
- update to 3.0.1rc6
  - Fix the off-by-one error in the MAC-address checking code for
    DHCPRELEASE that was added in 3.0.1rc5.
  - Fix a bug where client-specific information was not being
    discarded from the lease when it expired or was released,
    resulting in problems if the lease was reallocated to a
    different client.
  - merge pools if possible
  - workaround for some Lexmark printers that send a double-NUL-
    terminated host-name option, which would break DNS updates.
  - no longer log fallback_discard messages
- dhcp-3.0.1rc5-release.dif obsolete hereby
- drop dhclient init script (obsoleted by /sbin/if*-dhcp)
* Tue Jan 15 2002 poeml@suse.de
- update to 3.0.1rc5
  - Fix a bug that would cause the DHCP server to spin if asked to
    parse a certain kind of incorrect statement.
  - Fix a related bug that would prevent an error from being
    reported in the same case.
  - Additional documentation.
  - Make sure that the hardware address matches the lease when
    processing a DHCPRELEASE message.
- add dhcp-3.0.1rc5-release.dif that corrects an error by one in
  the code that finds a lease that is being RELEASEd
- use ddns-update-style interim instead of ad-hoc when testing
- make sure that dhcpd is started after xntpd (failover needs
  correct system time)
- drop version 2 of dhcpd and dhcrelay
* Wed Dec 12 2001 ro@suse.de
- removed START_ variables, moved rc.config.d -> sysconfig
* Tue Nov  6 2001 poeml@suse.de
- update to 3.0.1rc4
- add dhcpsync and dhcpync.8 (script to sync DHCP failover config.)
- update rc.dhclient script from the one used in the dhcpcd package
- client: don't check if a device is there; terminate anyway
- small addition to the examples; update README.upgrade
* Wed Oct 31 2001 poeml@suse.de
- update to 3.0.1rc2
- add a README.upgrade
* Thu Oct 25 2001 poeml@suse.de
- update to 3.0.1rc1
- remove our #undef use_LPF patch for 2.0pl5; it seems to cause
  problems (stopping responding) with more than one network card
- mark /etc/dhclient.conf with noreplace tag
* Sun Sep 16 2001 poeml@suse.de
- fix stupid bug in rc.dhcpd where rc.config is sourced too late
* Fri Sep 14 2001 poeml@suse.de
- fix #9962 where "exit 1" instead of "return" in dhclient-script
  would confuse dhclient (which then DECLINEd the lease)
* Tue Aug 28 2001 poeml@suse.de
- make sure that files are really copied to the chroot dir
* Mon Aug 27 2001 poeml@suse.de
- add libnss_dns6.so.2 as ghost to the file list to remove it
  from the chroot dir when uninstalling the package
- rc.dhcpd: remove empty pid files to avoid warnings by
  checkproc/killproc (dhcpd sometimes leaves them if it does not
  want to start due to wrong syntax)
- rc.dhcpd: to save time, source rc.config only when necessary
- add dhcpd.conf examples
* Fri Aug 24 2001 poeml@suse.de
- update to 3.0rc12 (fixes some failover state transitions; other
  failover fixes; always returns a subnet selection option if one
  is sent)
- change dhclient-script to ignore lines that are commented out
  when grepping for variables and eval-ing them
* Mon Jul 16 2001 poeml@suse.de
- add filedes.dif that gives scripts executed from dhclient-script
  their own filedescriptors (patch by Brian Somers
  <brian@Awfulhak.org>)
- correct typo in rc.dhcpd
* Mon Jul  2 2001 poeml@suse.de
- update to 3.0rc10
- change default in rc.config.d.dhcrelay
- add /usr/sbin/svtest, /usr/bin/omshell, and omshell man pages
- new variable in rc.dhcpd.config: $DHCPD_CONF_INCLUDE_FILES, for
  dhcpd.conf include files to be copied to $chroot/etc/
* Tue May 22 2001 poeml@suse.de
- update to 3.0rc7 (failover and OMAPI fixes, see RELNOTES)
* Wed May 16 2001 poeml@suse.de
- on 64 bit archs, define -DPTRSIZE_64BIT
- fix missing include
* Fri May 11 2001 poeml@suse.de
- if resolv.conf does not exist, touch it; so that there is a file
  to back up and restore later and the temporary resolv.conf would
  not persist after stopping the client [#8078]
- use the modify_resolvconf tool to cleanup old backup files before
  starting the daemon, because it does it intelligently [#8077]
* Tue May  8 2001 poeml@suse.de
- don't provide empty /etc/rc.config.d/dhcpd.rc.config because that
  inhibits the correct removal of variables from rc.config
- mention correct version numbers in mail to root (now using
  version macro)
- fix a typo and a nonsense comment in rc.config.d.dhcpd
* Mon May  7 2001 poeml@suse.de
- update to 3.0rc4 (bugfixes)
- add empty dir /var/lib/dhcp/dev and documentation about how to
  ensure that logging from the chroot jail works [#6906]
* Tue Apr 24 2001 poeml@suse.de
- update to 3.0rc2pl1: fixes bugs in the failover implementation
  and a memory smash that happens when fixed-address leases are
  used
- Read dhcp client script hooks if they exist, rather than only if
  they're executable.
- new file: 3.0b1 lease conversion script
* Sun Apr 15 2001 poeml@suse.de
- Init scripts: get try-restart ("restart when running") right
- client:
  - dhclient-script is now correctly installed to /sbin (thus,
    don't mv dhclient-script from /etc/ to /sbin/, thereby
    overwriting it with the one from v2)
  - move rcdhclient conveniency link to /sbin/ (same as in dhcpcd)
  - update info header for resolv.conf acc. to guidelines
- server:
  - don't run in chroot environment and as nobody by default
  - add missing %%postun for subpackages to rearrange runlevel
    links after deinstalling
* Mon Apr  9 2001 poeml@suse.de
- update to 3.0b2pl24
- don't use rc_status -u in init scripts (option was dropped)
- always run test of dhcpd
* Wed Mar 28 2001 poeml@suse.de
- update to 3.0b2pl18
  * trim chroot/non-root patch and the other security patches into
    dhcp-3.0b2pl18.paranoia.dif
  * build stable version of server (2.0pl5) and include the binary
    as well as the man pages with '-2' suffix (same for dhcrelay)
- split off subpackages: dhcrelay, dhcp-devel
- reworked all init scripts
  * adhere to LSB and use new rc.status functions
  * rc.dhcpd: at start, copy conf file and libs to chroot dir
  * rc.dhcpd: add syntax check
  * rc.dhcrelay: make interface configurable
  * rc.dhclient: improve resolv.conf handling
- dhclient: catch TERM to restore resolv.conf before quitting
- create /etc/rc.config.d/dhcrelay.rc.config
- create /etc/rc.config.d/dhclient.rc.config
- clean up Provides/Conflicts
- rework SuSE-fillup templates (and rename them)
- mark libraries for chroot dir as %%ghost
- when ABUILD_RUN_TEST_SUITES is true, start dhcpd for a simple
  test
* Fri Mar 16 2001 poeml@suse.de
- add dhcpd-thomas.diff from <thomas@suse.de>
  * query for the real UID and not for the effective UID
  * drop supplementary GID's
  * avoid potential buffer overflow
- copy dhcpd.conf instead of moving it
- add $syslog to Required-Start in server init script
- fix Required-Start in client init script
- bzipped sources
* Wed Jan 31 2001 poeml@suse.de
- dhcpd.conf will no longer be installed in /etc/ but placed in the
  docdir, since it is a nonfunctional example file
- test for etc/SuSE-release in %%post
- fix removal of variables from rc.config which failed sometimes
- update {README,LIESMICH}.SuSE
* Mon Jan 29 2001 poeml@suse.de
- added paranoia patch by Ari Edelkind to allow dhcpd run chrooted
  in /var/lib/dhcp and as nobody/nogroup. Both is optional.
- moved dhcpd.conf to /var/lib/dhcp/etc/. The file will also be
  moved by %%post
- moved rc.config options to rc.config.d/dhcpd.rc.config
  (existing variables are moved there by %%post)
- added some syntax checking via undocumented -t switch, and write
  log file during startup
- renamed start script from dhcp to dhcpd
- removed /var/run/dhcpd.pid from the package
- tag some %%configs with (noreplace)
- use BuildRoot
- added "Provides: dhcp2"+"Conflicts: dhcp3" in anticipation of v3
- added {README,LIESMICH}.SuSE and the paranoia patch to the docs
* Tue Jan 16 2001 draht@suse.de
- format string security bugs in syslog(3) calls fixed.
* Thu Jan 11 2001 poeml@suse.de
- in runlevel 2, start only the client, not the server/relay
- tell insserv to start after $named
- improved comments
* Thu Jan  4 2001 fober@suse.de
- package dhclient requires net-tools, not net_tool
- removed superfluous Provides dhclient in package dhclient
* Wed Nov 29 2000 poeml@suse.de
- Update to dhcp-2.0pl5.tar.gz
- This includes a security fix that applies to the DHCP client *only*
* Tue Nov 28 2000 poeml@suse.de
- adapted spec file to use /etc/init.d for the scripts instead of
  /sbin/init.d and let insserv create the links
- extracted source files from diff and placed them separately
- included paranoia (non-root/chroot) patch by ari edelkind. This
  needs testing, and possibly an adapted start script
* Mon Jul 24 2000 schwab@suse.de
- Fix argument type of dhcp_option_ev_name.
* Mon Jul 24 2000 schwab@suse.de
- Set DEBUG, not COPTS.
* Thu Jul 20 2000 zoz@suse.de
- updated to dhcp-2.0pl3
* Wed Jul 19 2000 schwab@suse.de
- Fix handling of abandoned leases with BOOTP.
- Properly handle default lease timeout.
* Fri Jul 14 2000 werner@suse.de
- make dchpd quiet
* Thu Jul 13 2000 zoz@suse.de
- changed test for availability of device in rcdhlient:
  now using ifconfig, so automatically loading of modules
  will be triggered (Bug 3415)
- patched dhclient.c do to a possible root exploit bug
  (patch from Pavel Kankovsky <peak@argo.troja.mff.cuni.cz>)
  Still to be improved, waiting for Ted Lemon to rework it.
* Tue Jul 11 2000 zoz@suse.de
- reworked rcdhclient once again.
* Tue Jul  4 2000 zoz@suse.de
- update to dhcp-2.0.pl2
- dhclient: hostname will only be set, if there is a
  DHCLIENT_SET_HOSTNAME=yes (default =no)
  in /etc/rc.config. (fixes bug 2807 and 3146)
* Tue Jun 27 2000 zoz@suse.de
- update to dhcp-2.0.pl1
- moved /var/state/dhcp to /var/lib/dhcp
- moved manpages to %%{_mandir}
- changed rcdhclient: DHCLIENT is obsolete now. It will be started
  if it finds any IFCONFIG_x=dhcpclient
* Mon Apr 10 2000 schwab@suse.de
- Treat Linux 2.3 as linux-2.2 configuration.
* Thu Jan 27 2000 grimmer@suse.de
- added "Provides: dhcp_client" and "Conflicts: dhcpcd" to
  dhclient section in spec file
- added "Provides: dhcp_server" to dhcp section
- corrected typo in rc.config variables
- added Group Tag and version macro to spec file
- changed Summary: to "ISC DHCP client"
- moved man pages to /usr/share/man
* Wed Nov 17 1999 rolf@suse.de
- now set hostname in dhclient-script [BUG#1262]
* Fri Nov  5 1999 rolf@suse.de
- reduced waiting time to 1 second
- wait 5 seconds after dhclient start to acquire an IP adress so the
  following scripts have a working network setup
* Thu Nov  4 1999 rolf@suse.de
- changes from Josh for @home cablenet
* Thu Oct 28 1999 rolf@suse.de
- added changes by Lenz Grimmer to use
  ifconfig $NETDEV 0.0.0.0 up
  for device setup
* Mon Oct 25 1999 rolf@suse.de
- applied patch of Bernhard Bender <Bernhard.Bender@elsa.de>
  to use the correct interface.
- added client latency time and rc.config entry
* Mon Sep 27 1999 bs@suse.de
- fixed requirements for sub packages
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Mon Jul 19 1999 bs@suse.de
- changed comment for rc.config
* Mon Jul 19 1999 bs@suse.de
- fix from werner@suse.de for /sbin/init.d/dhclient
* Fri Jul 16 1999 ro@suse.de
- added new dhclient-script from werner
* Wed Jun 23 1999 rolf@suse.de
- new version 2.0
- apply fix from Michael Hasenstein
* Mon Mar  8 1999 ro@suse.de
- fixed man5-path
* Fri Feb 26 1999 rolf@suse.de
- new version 2.0b1pl16 (stable beta)
- leases are now stored in /var/state/dhcp/ (thanks to Ted Lemmon)
- correct paths in manpages
- PID files as %%ghost in filelist
* Wed Feb 17 1999 rolf@suse.de
- new version 2.0b1pl13
* Wed Dec  9 1998 rolf@suse.de
- added 	/usr/sbin/rcdhcp
  /usr/sbin/rcdhcrelay
  /usr/sbin/rcdhclient
* Tue Nov 24 1998 rolf@suse.de
- new init scripts for SuSE Linux 6.0
* Thu Nov 12 1998 bs@suse.de
- minor changes for new rpm
* Thu Sep 24 1998 rolf@suse.de
- new version 2.0b1pl6 (stable beta)
- now with dhcp client and dhcp relay agent
- added init scripts for relay agent and client
- changed from $NETDEV_0 to $DHCPD_INTERFACE
* Fri Jun 26 1998 rolf@suse.de
- new version 1.0pl2 fixes two potential input buffer overrun problems
  that were missed in Patchlevel 1
* Mon May 18 1998 rolf@suse.de
- new security patch 1.0pl1 included
  changed /sbin/init.d/dhcp to run on $NETDEV_0
* Wed Dec 10 1997 rolf@suse.de
- new version 1.0.0  this is not beta any more!
* Thu Oct 16 1997 rolf@suse.de
- switched to dhcp.spec instead of Makefile.Linux
* Thu Sep 11 1997 rolf@suse.de
- Upddate to Version 5 beta 16 and made entry for rc.config and
  /sbin/init.d for startup/shutdown
  There is no dhcp client in this package anymore.
* Thu Jun 12 1997 rolf@suse.de
- build the package for the first time
