#
# spec file for package hwdata
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


Name:           hwdata
Version:        0.394
Release:        150000.3.77.2
Summary:        Hardware identification and configuration data
License:        GPL-2.0-or-later
URL:            https://github.com/vcrhonek/hwdata
Source0:        https://github.com/vcrhonek/hwdata/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz
Source1:        merge-pciids.pl
Requires(post): coreutils
Requires(post): perl
Conflicts:      pciutils-ids
Provides:       pciutils-ids = 20200529
Obsoletes:      pciutils-ids < 20200529
BuildArch:      noarch

%description
hwdata contains various hardware identification and configuration data,
such as the pci.ids and usb.ids databases.

%prep
%autosetup

%build
%configure
# nothing to build

%install
%make_install

# create symlink for smooth transition from pciutils-ids package
mkdir %{buildroot}%{_datadir}/pci.ids.d
ln -s %{_datadir}/hwdata/pci.ids \
  %{buildroot}%{_datadir}/pci.ids.d/pci.ids.dist

install -Dpm 0755 %{SOURCE1} \
  %{buildroot}%{_bindir}/merge-pciids
install -Dpm 0644 /dev/null \
  %{buildroot}%{_datadir}/pci.ids

# not needed at all
rm -rf %{buildroot}/%{_libdir}/modprobe.d

%post
if [ -x %{_bindir}/merge-pciids -a -x %{_bindir}/perl ]; then
  %{_bindir}/merge-pciids
else
  # This should only happen in autobuild
  echo "WARNING: merge-pciids or perl not found"
  cp -p %{_datadir}/pci.ids.d/pci.ids.dist %{_datadir}/pci.ids
fi

%files
%license LICENSE COPYING
%{_bindir}/merge-pciids
%{_datadir}/pkgconfig/hwdata.pc
%dir %{_datadir}/%{name}
%{_datadir}/hwdata/iab.txt
%{_datadir}/hwdata/oui.txt
%{_datadir}/hwdata/pci.ids
%{_datadir}/hwdata/pnp.ids
%{_datadir}/hwdata/usb.ids
%dir %{_datadir}/pci.ids.d
%{_datadir}/pci.ids.d/pci.ids.dist
%ghost %{_datadir}/pci.ids

%changelog
* Tue Apr 29 2025 mpluskal@suse.com
- Update to version 0.394:
  * Update pci and vendor ids
* Sat Mar 22 2025 andrea.manzini@suse.com
- Update to version 0.393:
  * Update pci, usb and vendor ids
  * Fix usb.ids encoding and a couple of typos
  * Fix configure to honor --prefix
* Tue Feb 18 2025 mpluskal@suse.com
- Update to version 0.392:
  * Update pci and vendor ids
* Wed Jan  8 2025 mpluskal@suse.com
- Update to version 0.391:
  * Update pci and vendor ids
* Wed Dec  4 2024 mpluskal@suse.com
- update to 0.390:
  * Update pci and vendor ids
* Thu Nov  7 2024 mpluskal@suse.com
  update to 0.389:
  * Update pci and vendor ids
* Mon Aug 26 2024 mpluskal@suse.com
- update to 0.385:
  * Update pci and vendor ids
* Mon Jun 17 2024 dmueller@suse.com
- update to 0.383:
  * Update pci and vendor ids
* Wed May 15 2024 mpluskal@suse.com
- update to 0.382:
  * Update pci, usb and vendor ids
* Tue Mar  5 2024 mpluskal@suse.com
- update to 0.380:
  * Update pci, usb and vendor ids
* Fri Feb 16 2024 mpluskal@suse.com
- update to 0.379:
  * Update pci, usb and vendor ids
* Wed Jan 10 2024 mpluskal@suse.com
- update to 0.378:
  * Update pci, usb and vendor ids
* Mon Dec  4 2023 dmueller@suse.com
- update to 0.377:
  * Fixed trailing spaces in pnp.ids
* Wed Nov 15 2023 dmueller@suse.com
- update to 0.376:
  * Update pci, usb and vendor ids
* Tue Aug 22 2023 andrea.manzini@suse.com
- update to 0.373:
  * Update pci, usb and vendor ids
* Tue Jul 11 2023 mpluskal@suse.com
- update to 0.372:
  * Update pci, usb and vendor ids
* Fri Jun  9 2023 mpluskal@suse.com
- update to 0.371:
  * Update pci, usb and vendor ids
* Tue May 16 2023 mpluskal@suse.com
- update to 0.370:
  * Update pci, usb and vendor ids
* Mon Apr  3 2023 dmueller@suse.com
- update to 0.369:
  * Update pci, usb and vendor ids
* Tue Mar  7 2023 mpluskal@suse.com
- update to 0.368:
  * Update pci, usb and vendor ids
* Thu Feb  2 2023 dmueller@suse.com
- update to 0.367:
  * Update pci, usb and vendor ids
* Wed Jan  4 2023 dmueller@suse.com
- update to 0.366:
  * Update pci, usb and vendor ids
* Tue Dec  6 2022 mpluskal@suse.com
- update to 0.365:
  + Updated pci, usb and vendor ids.
* Tue Nov 15 2022 mpluskal@suse.com
- update to 0.364:
  + Updated pci, usb and vendor ids.
* Thu Oct 13 2022 mpluskal@suse.com
- update to 0.363:
  + Updated pci, usb and vendor ids.
* Wed Sep 14 2022 mpluskal@suse.com
- update to 0.362:
  + Updated pci, usb and vendor ids.
* Mon Jul 11 2022 dmueller@suse.com
- update to 0.361:
  + Updated pci, usb and vendor ids.
* Wed Jun  1 2022 mpluskal@suse.com
- Update to version 0.360 (bsc#1200110):
  + Updated pci, usb and vendor ids.
* Wed May 11 2022 mpluskal@suse.com
- Update to version 0.359:
  + Updated pci, usb and vendor ids.
* Tue Apr 19 2022 mpluskal@suse.com
- Update to version 0.358 (bsc#1196332):
  + Updated pci, usb and vendor ids.
* Tue Mar  8 2022 mpluskal@suse.com
- Update to version 0.357 (bsc#1196332):
  + Updated pci, usb and vendor ids.
* Tue Feb  8 2022 mpluskal@suse.com
- Update to version 0.356:
  + Updated pci, usb and vendor ids.
* Wed Jan  5 2022 mpluskal@suse.com
- Update to version 0.355 (bsc#1194338):
  + Updated pci, usb and vendor ids.
* Tue Dec  7 2021 mpluskal@suse.com
- Update to version 0.354:
  + Updated pci, usb and vendor ids.
* Thu Nov 11 2021 mpluskal@suse.com
- Update to version 0.353 (bsc#1192587):
  + Updated pci, usb and vendor ids.
* Wed Oct  6 2021 mpluskal@suse.com
- Update to version 0.352 (bsc#1191375):
  + Updated pci, usb and vendor ids.
* Thu Sep  2 2021 mpluskal@suse.com
- Update to version 0.351 (bsc#1190091):
  + Updated pci, usb and vendor ids.
* Tue Aug  3 2021 mpluskal@suse.com
- Update to version 0.350 (bsc#1189005):
  + Updated pci, usb and vendor ids.
* Thu Jul  8 2021 mpluskal@suse.com
- Update to version 0.349 (bsc#1187948):
  + Updated pci, usb and vendor ids.
* Wed Jun  2 2021 mpluskal@suse.com
- Update to version 0.348 (bsc#1186749):
  + Updated pci, usb and vendor ids.
* Thu May  6 2021 mpluskal@suse.com
- Update to version 0.347 (bsc#1185697):
  + Updated pci, usb and vendor ids.
* Tue Apr  6 2021 mpluskal@suse.com
- Update to version 0.346:
  + Updated pci, usb and vendor ids.
  + Resolves boo#1182482 jsc#SLE-13791 bnc#1170160
* Mon Mar  1 2021 mpluskal@suse.com
- Update to version 0.345:
  + Updated pci, usb and vendor ids.
  + Resolves boo#1182482 jsc#SLE-13791 bnc#1170160
* Tue Feb  2 2021 mpluskal@suse.com
- Update to version 0.344:
  + Updated pci, usb and vendor ids.
* Thu Jan  7 2021 mpluskal@suse.com
- Add merge-pciids.pl to fully duplicate behavior of pciutils-ids
  * Resolves SLE issue bsc#1180422 bsc#1180482
* Wed Jan  6 2021 mpluskal@suse.com
- Update to version 0.343:
  + Updated pci, usb and vendor ids.
* Mon Dec  7 2020 mpluskal@suse.com
- Update to version 0.342:
  + Updated pci, usb and vendor ids.
* Thu Nov  5 2020 mpluskal@suse.com
- Update to version 0.341:
  + Updated pci, usb and vendor ids.
* Thu Oct  8 2020 mpluskal@suse.com
- Update to version 0.340:
  + Updated pci, usb and vendor ids.
* Mon Sep 14 2020 mpluskal@suse.com
- Update to version 0.339:
  + Updated pci, usb and vendor ids.
* Tue Aug 11 2020 mpluskal@suse.com
- Update to version 0.338:
  + Updated pci, usb and vendor ids.
* Thu Jul 16 2020 mpluskal@suse.com
- Update to version 0.337:
  + Updated pci, usb and vendor ids.
* Tue Jun  2 2020 dimstar@opensuse.org
- Update to version 0.336:
  + Updated pci, usb and vendor ids.
* Wed May  6 2020 mpluskal@suse.com
- Update to version 0.335:
  * Updated pci, usb and vendor ids.
* Wed Apr 22 2020 mpluskal@suse.com
- Fix previous changelog entries
* Tue Apr  7 2020 mpluskal@suse.com
- Update to version 0.334 (bsc#1168806):
  * Updated pci, usb and vendor ids.
* Tue Mar  3 2020 mpluskal@suse.com
- Update to version 0.333:
  * Updated pci, usb and vendor ids.
* Mon Feb  3 2020 mpluskal@suse.com
- Update to version 0.332:
  * Updated pci, usb and vendor ids.
* Tue Jan  7 2020 mpluskal@suse.com
- Update to version 0.331:
  * Updated pci, usb and vendor ids.
* Mon Dec  2 2019 mpluskal@suse.com
- Update to version 0.330:
  * Updated pci, usb and vendor ids.
* Tue Nov  5 2019 mpluskal@suse.com
- Update to version 0.329:
  * Updated pci, usb and vendor ids.
* Wed Oct 16 2019 mpluskal@suse.com
- Update to version 0.328:
  * Updated pci, usb and vendor ids.
* Tue Aug 13 2019 mpluskal@suse.com
- Update to version 0.326:
  * Updated pci, usb and vendor ids.
* Wed Jul 10 2019 mpluskal@suse.com
- Update to version 0.325:
  * Updated pci, usb and vendor ids.
* Wed Jun 12 2019 mpluskal@suse.com
- Update to version 0.324:
  * Updated pci, usb and vendor ids.
* Fri May  3 2019 mpluskal@suse.com
- Update to version 0.323:
  * Updated pci, usb and vendor ids.
* Tue Apr 16 2019 mpluskal@suse.com
- Update to version 0.322:
  * Updated pci, usb and vendor ids.
* Fri Mar 29 2019 mpluskal@suse.com
- Update to version 0.321:
  * Updated pci, usb and vendor ids.
* Thu Feb 14 2019 mpluskal@suse.com
- Replace pciutils-ids package
  * Provide compat symlink
* Tue Feb 12 2019 mpluskal@suse.com
- Update to version 0.320 (bsc#1121410):
  * Updated pci, usb and vendor ids.
* Thu Jan 10 2019 mpluskal@suse.com
- Update to version 0.319:
  * Updated pci, usb and vendor ids.
* Fri Dec 14 2018 mpluskal@suse.com
- Update to version 0.318:
  * Updated pci, usb and vendor ids.
* Wed Sep 26 2018 mpluskal@suse.com
- Update to version 0.315:
  * Updated pci, usb and vendor ids.
* Thu Aug 30 2018 mpluskal@suse.com
- Update to version 0.314:
  * Updated pci, usb and vendor ids.
* Mon Jul  9 2018 mpluskal@suse.com
- Update to version 0.313:
  * Updated pci, usb and vendor ids.
* Wed May  9 2018 mpluskal@suse.com
- Update to version 0.312:
  * Updated pci, usb and vendor ids.
* Tue Apr  3 2018 mpluskal@suse.com
- Update to version 0.311:
  * Updated pci, usb and vendor ids.
* Thu Mar  8 2018 mpluskal@suse.com
- Update to version 0.310:
  * Updated pci, usb and vendor ids.
* Fri Jan  5 2018 mpluskal@suse.com
- Update to version 0.308:
  * Updated pci, usb and vendor ids.
* Wed Dec  6 2017 mpluskal@suse.com
- Update to version 0.307:
  * Updated pci, usb and vendor ids.
* Fri Nov  3 2017 mpluskal@suse.com
- Update to version 0.306:
  * Updated pci, usb and vendor ids.
* Mon Oct  2 2017 mpluskal@suse.com
- Update to version 0.305
* Fri Sep  8 2017 mpluskal@suse.com
- Update to version 0.304
* Wed Aug  2 2017 mpluskal@suse.com
- Update to version 0.303
* Tue Jul 11 2017 mpluskal@suse.com
- Update to version 0.302
* Mon Jun 12 2017 mpluskal@suse.com
- Update to version 0.301
* Wed May 10 2017 mpluskal@suse.com
- Update to version 0.300 (boo#1038809)
* Sat Apr 15 2017 mpluskal@suse.com
- Update to version 0.299
- Update project and download urls
- Cleanup spec file with spec-cleaner
* Mon Sep 28 2015 mc@suse.de
- version 0.282
- updated pci, usb and vendor ids
* Sat Sep 13 2014 mc@suse.de
- version 0.269
- updated pci, usb and vendor ids
* Sat Jul 12 2014 mc@suse.com
- update to version 0.267
- updated pci, usb and vendor ids
* Sat Jan 18 2014 mc@suse.com
- update to version 0.258
- updated pci and oui ids
- remove blacklist.conf
* Sat Jan 18 2014 mc@suse.de
- initial release
