#
# spec file
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define flavor SLE
%if "%{flavor}" == ""
%define branding_name %{nil}
ExclusiveArch:  %{nil}
%else
%define branding_name %{flavor}
%define dash -
%if "%{flavor}" == "SLE"
%define build_SLE 1
%else
%define build_openSUSE 1
%endif
%if (0%{?build_SLE} && 0%{?is_opensuse}) || (0%{?build_openSUSE} && ! 0%{?is_opensuse})
# Don't build SLE branding on openSUSE and vice-versa
ExclusiveArch:  %{nil}
%endif
%endif
%define gio_real_package %(rpm -q --qf '%%{name}' --whatprovides gio)
%define gio_version %(rpm -q --qf '%%{version}' %{gio_real_package})
Name:           glib2-branding%{?dash}%{branding_name}
Summary:        General-Purpose Utility Library -- %{branding_name} default configuration
License:        BSD-3-Clause
Group:          System/GUI/GNOME
URL:            http://www.gtk.org/
Source:         glib2-branding-gnome_defaults.conf
Source1:        glib2-branding-COPYING
Source2:        glib2-branding.gschema.override.in
# We need glib2-branding-upstream else, the call to SuSEconfig.glib2 fails
BuildRequires:  glib2-branding-upstream
BuildRequires:  glib2-devel
BuildRequires:  wallpaper-branding-%{branding_name}
BuildArch:      noarch
%if 0%{?build_openSUSE}
Version:        42.1
Release:        150600.35.2.1
%else
Version:        15
Release:        150600.35.2.1
%endif

%description
This package provides %{branding_name} defaults for settings stored with
GSettings and applications used by the MIME system.

%package -n gio-branding-%{branding_name}
Summary:        %{branding_name} definitions of default settings and applications
Group:          System/GUI/GNOME
Requires:       %{gio_real_package} = %{gio_version}
Recommends:     sound-theme-freedesktop
# For wallpaper
Recommends:     (wallpaper-branding-%{branding_name} if gnome-shell)
Supplements:    packageand(%{gio_real_package}:branding-%{branding_name})
Conflicts:      gio-branding
Provides:       glib2-branding-%{branding_name} = %{version}
Obsoletes:      glib2-branding-%{branding_name} < %{version}
Provides:       gio-branding = %{gio_version}
%glib2_gsettings_schema_requires
%if 0%{?build_SLE}
# Obsolete SLE11 packages to resolve file conflicts on sle11->sle12 upgrade
Obsoletes:      glib2-branding-SLED
Obsoletes:      glib2-branding-SLES
%endif

%description -n gio-branding-%{branding_name}
This package provides %{branding_name} defaults for settings stored with
GSettings and applications used by the MIME system.

%prep
%setup -q -T -c %{name}-%{version}
cp -a %{SOURCE0} gnome_defaults.conf
cp -a %{SOURCE1} COPYING
cp -a %{SOURCE2} glib2-branding.gschema.override.in

%build
test -f %{_datadir}/wallpapers/%{branding_name}-default.xml
sed "s,@@WALLPAPER_URI@@,file://%{_datadir}/wallpapers/%{branding_name}-default.xml,;s,@@LOCKSCREEN_URI@@,file://%{_datadir}/wallpapers/%{branding_name}-default-static-lockscreen.xml,"  glib2-branding.gschema.override.in > glib2-branding.gschema.override
#for sound theme
%if 0%{?build_openSUSE}
sed "s:@@IF_openSUSE@@::g" < glib2-branding.gschema.override | \
%if 0%{?sle_version}
    sed "s:@@IF_LEAP@@::g" | \
%endif
    grep -v ^@@IF_ > 20_%{branding_name}-branding.gschema.override
%endif
%if 0%{?build_SLE}
sed "s:@@IF_SLE@@::g" < glib2-branding.gschema.override | grep -v ^@@IF_ > 20_%{branding_name}-branding.gschema.override
%endif

%install
install -d %{buildroot}%{_sysconfdir}
install -m0644 gnome_defaults.conf %{buildroot}%{_sysconfdir}/
install -d %{buildroot}%{_datadir}/glib-2.0/schemas
install -m0644 20_%{branding_name}-branding.gschema.override %{buildroot}%{_datadir}/glib-2.0/schemas/

%files -n gio-branding-%{branding_name}
%license COPYING
%config (noreplace) %{_sysconfdir}/gnome_defaults.conf
%{_datadir}/glib-2.0/schemas/20_%{branding_name}-branding.gschema.override

%changelog
* Wed Apr 19 2023 dimstar@opensuse.org
- prefer org.gnome.TextEditor.desktop instead of gedit.
  patterns-gnome was changed to install TextEditor (boo#1210648).
* Tue Dec 20 2022 dimstar@opensuse.org
- Prefer file-roller over nautilus for archives.
* Thu Dec  1 2022 dimstar@opensuse.org
- Adjust desktop file names of preferred applications:
  + evince.desktop => org.gnome.evince.desktop (since GNOME 3.30).
  + eog.desktop => org.gnome.eog.desktop (since GNOME 3.36).
  + file-roller.desktop => org.gnome.FileRoller.desktop
- Fix name to impress: libreoffice-impress.destop.
* Mon Oct 17 2022 milachew@mail.lv
- Fix default openSUSE wallpaper is not present in dark mode (boo#1204138).
* Tue Mar 15 2022 yfjiang@suse.com
- Update .gschema.override.in: Change default libreoffice startup
  entry to libreoffice-startcenter.desktop according to the
  libreoffice update (bsc#1195836, bsc#1196951).
* Sat Feb 12 2022 bjorn.lie@gmail.com
- Drop gnome-documents from favorite-apps for both openSUSE and
  SLED, package is archived upstream.
* Mon Aug 23 2021 dimstar@opensuse.org
- Update for libreoffice-* desktop files no longer dropping the
  libreoffice- prefix.
* Sun Oct 11 2020 callumjfarmer13@gmail.com
- Add priority of 20 to gschema override, otherwise you can't
  override it
* Fri Sep 18 2020 fcrozat@suse.com
- Update .gschema.override.in (jsc#SLE-14772):
  * add different key for screenlock
  * update background color for SLE.
* Mon May 18 2020 dimstar@opensuse.org
- Only recommend wallpaper-branding-%%{branding_name} when
  gnome-shell is present. Allows gio to be installed on text-only
  systems without pulling wallpapers in (boo#1162600).
* Fri Mar 13 2020 qkzhu@suse.com
- Update .gschema.override.in:
  + Set sleep-inactive-ac-timeout, sleep-inactive-battery-timeout to
    0 for Leap to be consistent with SLE and old versions (bsc#1158497).
* Tue Jan  7 2020 qkzhu@suse.com
- Update .gschema.override.in:
  + Delete unused settings-daemon.plugins.power keys.
  + Set sleep-inactive-ac-timeout, sleep-inactive-battery-timeout to
    0 for SLE to be consistent with old versions (bsc#1158497).
* Tue Oct 29 2019 mgorse@suse.com
- Add super+f1 key binding for help to match GNOME default.
* Mon Oct 28 2019 dimstar@opensuse.org
- Fix keyassignment for help: the schema was changed to array of
  strings, as multiple keys can now be bound.
* Wed Nov  7 2018 dimstar@opensuse.org
- Update gnome_defaults: evince.desktop has been renamed to
  org.gnome.Evince.desktop with GNOME 3.30.
* Fri Jun 29 2018 qkzhu@suse.com
- Recommend sound-theme-freedesktop by both openSUSE and SLE.
  (bsc#1097595)
* Thu May  3 2018 yfjiang@suse.com
- Update .gschema.override.in: referring the implementation of
  bsc#1077332, fully enable gnome-software notification which is
  now used on both leap15 and sle15 to replace the legacy g-s-d
  notification method (boo#1090042).
* Wed Feb 28 2018 dimstar@opensuse.org
- Modernize spec-file by calling spec-cleaner
* Fri Dec 22 2017 dimstar@opensuse.org
- Update .gschema.override.in: evolution.desktop has been renamed
  to org.gnome.Evolution.desktop (for GNOME 3.28).
* Wed Dec 20 2017 dimstar@opensuse.org
- Revert "Update .gschema.override.in: evolution.desktop has been
  renamed to org.gnome.Evolution.desktop.": This will only be valid
  with GNOME 3.28.
* Tue Dec 19 2017 dimstar@opensuse.org
- Use variable flavor instead of BUILD_FLAVOR: obs is only
  replacing the first occurence.
* Fri Dec 15 2017 dimstar@opensuse.org
- Rename base package to glib2-branding and add SLE and openSUSE as
  multibuild flavors. There is no other difference to the previous
  glib2-branding-{openSUSE,SLE} packages.
- Drop pre_checkin.sh: no longer needed with multibuild.
* Wed Dec 13 2017 xwang@suse.com
-  Update .gschema.override.in to show application menu on title
  bar in sle-classic session (bgo#746592 bsc#1070090).
* Mon Oct 23 2017 dimstar@opensuse.org
- Update .gschema.override.in: evolution.desktop has been renamed
  to org.gnome.Evolution.desktop.
* Fri Oct 20 2017 fcrozat@suse.com
- Update SLE version to 15.
- Remove post/postun scripts, no longer needed with file triggers.
- Update favorites applications on SLE15, we switched to pidgin and
  gnome-photos.
* Tue Jul 18 2017 yfjiang@suse.com
- Update .gschema.override.in to set small icon size on Desktop and
  nautilus in Leap, which is consistent with SLE (bsc#1043604).
* Wed Oct 19 2016 dimstar@opensuse.org
- Enable freedesktop sound theme by default (boo#1004919):
  + Set org.gnome.desktop.sound/theme-name to 'freedesktop' for
    openSUSE.
  + Recommend sound-theme-freedesktop by gio-branding-openSUSE.
- Introdue @@IF_LEAP@@ logic into the .gschema.override.in file:
  IF_LEAP is true if building for 'openSUSE' and sle_version is set
  in prjconf. Apply IF_LEAP to the GNOME Software update
  notifications.
* Wed Sep  7 2016 zaitor@opensuse.org
- Once again disable GNOME Software update notifications (automatic
  download of patches; openSUSE relies on gnome-settings-daemon's
  internal update plugin for update notifications) (boo#997572).
* Thu Jul 14 2016 dimstar@opensuse.org
- Do not attempt to build -openSUSE on SLE and -SLE on openSUSE:
  trick the .spec file to ExclusiveArch: %%nil in this case.
* Fri Jul  1 2016 fezhang@suse.com
- Make gnome-settings-daemon housekeeping plugin ignore /boot/efi
  [bsc#919217].
  Summary from bsc#919217:
  "On a default UEFI installation, /boot/efi is created with a size
  of 156MB. It will cause gnome-settings-daemon to popup a warning,
  if logged as root (not 100%% sure when logged as a regular user)
  that a partition has less than than 1GB of free space.
  /boot/efi should be added to default schema
  org.gnome.settings-daemon.plugin.housekeeping ignore-paths"
* Wed Jun 29 2016 fcrozat@suse.com
- Resync with glib2-branding-SLE and simplify specfile.
- Replaces Requires by Recommends on wallpaper-branding-openSUSE:
  gio-branding-openSUSE is required by glib2, which is causing
  openSUSE wallpaper as hard dependency on non-graphical install.
  (boo#993969).
* Mon Jun 20 2016 fcrozat@suse.com
- Add some settings from SLE12 SP2, not enabled when building on
  openSUSE (default zoom on nautilus).
- Update favorite applications default to use new names from
  upstream, prevent writing some defaults to dconf (partially fixes
  bsc#979947).
* Tue Mar 15 2016 fcrozat@suse.com
- Fix KeySym assigned for Help, XF86Help doesn't exist anymore.
* Sat Feb 13 2016 zaitor@opensuse.org
- Drop org.gnome.settings-daemon.plugins.media-keys/toggle-mute
  since we dropped the patch making this needed.
* Tue Nov 10 2015 badshah400@gmail.com
- The touchpad schemas migrated to org.gnome.desktop.peripherals
  from org.gnome.settings-daemon.peripherals, adapt tap-to-click
  setting accordingly (boo#954526).
- The "disable-while-typing" key no longer exists, remove it
  accordingly.
* Mon Oct 12 2015 zaitor@opensuse.org
- Bump version to 42.1, to prepare for next version of openSUSE.
* Sat Sep 19 2015 dimstar@opensuse.org
- Drop org.gnome.settings-daemon.plugins.power/button-power
  override: this settings has been removed in GNOME 3.17.92.
* Thu Feb 26 2015 dimstar@opensuse.org
- Drop org.gnome.eog.ui/external-editor reference: EOG 3.15 no
  longer supports this.
* Mon Nov  3 2014 badshah400@gmail.com
- Gedit desktop file got renamed to org.gnome.gedit.desktop,
  update gnome_defaults.conf accordingly (boo#904010).
* Wed Oct  8 2014 badshah400@gmail.com
- Replace rhythmbox by gnome-music in favourite applications
  (see
  http://lists.opensuse.org/opensuse-gnome/2014-10/msg00013.html )
- Remove alternative-status-menu as default enabled extension: we
  do not install it by default any more.
* Sat Aug 23 2014 zaitor@opensuse.org
- Bump version to 13.2, to prepare for next version of openSUSE.
* Fri Aug 22 2014 dimstar@opensuse.org
- Replace nautilus.desktop in gnome_defaults.conf with
  org.gnome.Nautilus.desktop, following upstreams renaming of the
  .desktop file in GNOME 3.14.
* Thu Jul  3 2014 fcrozat@suse.com
- Merge SLE12 specific changes (not enabled on openSUSE):
  + Enable back audible-bell on SLE12 [bnc#871584]
  + Change Favorites on gnome-shell:
  * Remove rhythmbox
  * Replace Libreoffice Writer with Libreoffice Start Center
  * Add Yelp
  + Change the default action of pressing power button to
    'shutdown'.
  + Lock the screensaver after 300 seconds.
* Mon Nov 11 2013 dimstar@opensuse.org
- Update gnome_defaults: nautilus-folder-handlder has been dropped
  a while ago and the functionality merged into nautilus directly.
  This never really caused any issue, as nautilus was one of the
  few .desktop files registering a inode/directory MimeType. Since
  GNOME 3.10, baobab does that as well, resulting in situations
  where baobab can be prefered (the Mime handling is
  pseudo-random). (bnc#849914).
- Add %%mime_database_post//%%mime_database_postun macros to post
  and postun, to ensure installation triggers updating the mime
  database.
* Sun Sep 22 2013 dimstar@opensuse.org
- Set the same background for the lockscreen by default as we use
  as regular background.
* Sun Sep  8 2013 zaitor@opensuse.org
- Bump version to 13.1, to prepare for next version of openSUSE.
* Mon Mar 25 2013 dimstar@opensuse.org
- Drop org.gnome.settings-daemon.plugins.power/sleep-display-ac
  setting: it's no longer known by GNOME 3.8.
* Thu Feb 14 2013 badshah400@gmail.com
- Replace banshee with rhythmbox in the list of favourite apps
  shown in the gnome-shell dash.
* Sun Jan 13 2013 dimstar@opensuse.org
- Update gnome_defaults.conf: no longer instruct to start
  SuSEconfig, but instruct to run suse-update-mime-defaults
  (bnc#796169).
* Wed Jan  9 2013 aj@suse.de
- Update version number to 12.3.
* Mon Nov 12 2012 dimstar@opensuse.org
- No longer set
  org.gnome.settings-daemon.plugins.updates/auto-update-type: this
  setting was removed from the schema during GNOME 3.6 development.
  (gnome-settings-daemon commit 7cd4aad).
* Wed Jul  4 2012 badshah400@gmail.com
- Change GSettings default for tap-to-click settings:
  + Set org.gnome.settings-daemon.peripherals.touchpad/tap-to-click
    to true to enable tap-to-click by default (see
    (bnc#554884, fate#310811, also recent discussion at
    http://lists.opensuse.org/opensuse-factory/2012-06/msg01087.html)
  + Also change
    org.gnome.settings-daemon.peripherals.touchpad/disable-while-typing
    to true to prevent accidental tap-cliking while the user is
    typing.
* Fri Jun  8 2012 vuntz@opensuse.org
- Remove gdm-branding-openSUSE Requires from gio-branding-openSUSE:
  this results in gdm getting installed for everyone, including
  non-GNOME users. Instead, rely on the fact that gdm will not
  break if the logo defined in our GSettings default doesn't exist.
* Mon Jun  4 2012 rbrownccb@opensuse.org
- Change GSettings default:
  + Change org.gnome.login-screen/logo to new gdm banner artwork.
- For openSUSE, add Requires for gdm-branding-openSUSE
* Fri May 25 2012 vuntz@opensuse.org
- Change GSettings default:
  + Change org.gnome.shell/enabled-extensions to new id of the
    alternative-status-menu extension.
* Wed May 23 2012 vuntz@opensuse.org
- Bump version to 12.2, to prepare for next version of openSUSE.
* Fri Mar  9 2012 vuntz@opensuse.org
- Change GSettings default:
  + Disable audible bell
    (org.gnome.desktop.wm.preferences/audible-bell): it's more
    annoying than useful.
  + Add comments to help people who want to change the window
    manager theme.
* Wed Dec 21 2011 vuntz@opensuse.org
- Change GSettings default:
  + Stop changing epiphany homepage
    (org.gnome.Epiphany/homepage-url): there's no such setting
    anymore.
* Wed Nov  9 2011 vuntz@opensuse.org
- Change GSettings default:
  + Set org.gnome.settings-daemon.plugins.updates/auto-update-type
    to 'none' as automatically installing security updates pops out
    a polkit dialog with no context for the user. See discussion in
    bnc#729218.
* Fri Oct 28 2011 malcolmlewis@opensuse.org
- Change GSettings default: add alt-status-menu to be enabled by
  default (org.gnome.shell/enabled-extensions).
* Thu Oct 13 2011 vuntz@opensuse.org
- Remove %%{release} from the glib2 versioned Requires, to not have
  to rebuild this package each time glib2 rebuilds to keep it
  installable.
* Wed Oct 12 2011 gber@opensuse.org
- Adapt Xfce default applications, mousepad was replaced by
  leafpad, xarchiver and parole are no longer installed by default.
* Wed Oct  5 2011 vuntz@opensuse.org
- Change GSettings default: add gnome-documents to the favorite
  apps in gnome-shell (org.gnome.shell/favorite-apps). This is
  consistent with what upstream does.
* Tue Oct  4 2011 vuntz@opensuse.org
- Change GSettings default:
  + Set org.gnome.settings-daemon.plugins.media-keys/toggle-mute to
    false, porting an old default we had in gconf2-branding.
  + Add a comment about org.gnome.login-screen/logo so that people
    know it can be set. Leave it unset for now since it doesn't
    look that good.
* Thu Sep 22 2011 vuntz@opensuse.org
- For openSUSE, change BuildRequires and Requires for
  desktop-data-openSUSE to wallpaper-branding-openSUSE since the
  wallpaper moved there. Also, do not version the Requires, since
  the filename for the default wallpaper is not versioned.
* Thu Sep 22 2011 vuntz@opensuse.org
- Change GSettings default:
  - Stop setting org.gnome.power-manager/notify-idle-sleep: we
    don't have the patch that introduces this key anymore right
    now, and leaving the override produces lots of warnings. See
    bnc#708182.
- Bump dependency on desktop-data-openSUSE to 12.1 now that
  desktop-data-openSUSE got a version bump.
* Wed Sep  7 2011 kirill.kirillov@gmail.com
- Add brasero as default application for iso files (fix
  bnc#650400)
* Tue Aug 30 2011 vuntz@opensuse.org
- Change GSettings default:
  + Stop changing org.gnome.nautilus.preference/preview-sound: this
    is now gone with nautilus 3.1.90.
* Thu Jul  7 2011 vuntz@opensuse.org
- Change GSettings default:
  + org.gnome.shell/favorite-apps: set to [ 'firefox.desktop',
    'evolution.desktop', 'empathy.desktop', 'banshee.desktop',
    'shotwell.desktop', 'writer.desktop', 'nautilus.desktop' ]
  + this enables us to drop default-applications.patch from
    gnome-shell.
  + fix bnc#689610.
* Wed Jul  6 2011 vuntz@opensuse.org
- Change GSettings defaults:
  + org.freedesktop.Tracker.Miner.Files/index-removable-devices:
    set to false (so we can remove
    tracker-removeable-media-off.patch from the tracker package)
  + org.gnome.eog.ui/external-editor: set to gimp.desktop, since we
    want to use GIMP as default there.
* Wed Jul  6 2011 vuntz@opensuse.org
- Rework the package to only build the openSUSE branding package,
  or the SLE branding packages, but not all of them at once. Use a
  %%build_for_openSUSE define for that, which is used to also define
  a %%build_for_SLE helper.
- Create gio-branding-{openSUSE,SLED,SLES} subpackages, and do not
  create glib2-branding-{openSUSE,SLED,SLES} subpackages anymore:
  the data we add here is related only to gio, not to the whole
  glib.
- The gio-branding-{openSUSE,SLED,SLES} subpackage have appropriate
  Provides/Obsoletes for glib2-branding-{openSUSE,SLED,SLES}, to
  enable smooth upgrades.
- Update glib2-branding-openSUSE-gnome_defaults.conf to define
  default handlers for URI schemes (after migration of this
  settings from gconf to the MIME system):
  + Add firefox.desktop as default handler for
    x-scheme-handler/{http,https,ftp}
  + Add evolution.desktop as default handler for
    x-scheme-handler/mailto
  + Add yelp.desktop as default handler for all MIME types it
    handles (ie, the help-related URI schemes)
- Add default values for GSettings schemas:
  + Add glib2-branding.gschema.override.in file. This file is
    populated with default values based on the old gconf2-branding
    package.
  + Process glib2-branding.gschema.override.in in %%install to
    correctly define the wallpaper, and remove
    openSUSE/SLE-specific defaults.
  + Change glib2 BuildRequires to glib2-devel, since we need the
    %%glib2_gsettings_schema_* macros.
  + Create post/postun scripts for all packages, using the
    %%glib2_gsettings_schema_post(un) macros.
  + This fixes bnc#676301 and bnc#687780.
- Add Requires for desktop-data-{openSUSE,SLED} to
  gio-branding-{openSUSE,SLED,SLES} to make sure the wallpaper is
  installed.
- Bump version to 12.1.
- Update summary and description.
- Add Url tag.
* Fri Jan 14 2011 gber@opensuse.org
- added defaults for the XFCE and LXDE desktops
* Thu Jan 13 2011 vuntz@opensuse.org
- Update glib2-branding-openSUSE-gnome_defaults.conf:
  MozillaFirefox.desktop has been renamed to firefox.desktop.
* Fri Oct  8 2010 vuntz@opensuse.org
- Bump version to 11.4.
* Thu Jul 22 2010 vuntz@opensuse.org
- Add glib2 and glib2-branding-upstream BuildRequires, so we can
  get the right version of glib2, which is needed to provide the
  right version of glib2-branding.
- Bump version to 11.3.
- Change the order of the packageand() in Supplements to fix
  rpmlint warnings.
* Mon May 25 2009 vuntz@novell.com
- Merge change from SLED: Prefer LinDVD for DVD and mpeg video
  playback and prefer flashplayer for its mimetypes, when installed
  (bnc#473050)
* Tue Feb 17 2009 gburt@suse.de
- moonlight-media-player was renamed to moonshine (bnc#466649)
* Thu Jan 15 2009 gburt@suse.de
- Prefer moonlight-media-player for WM mimetypes (bnc#466649)
* Wed Nov 12 2008 vuntz@novell.com
- Force impress.desktop for application/vnd.sun.xml.impress and
  application/vnd.oasis.opendocument.presentation since evince can
  also read them. Should fix bnc#439586.
* Tue Nov  4 2008 sbrabec@suse.cz
- Create SLES and SLED clones of the package (bnc#438887).
* Mon Oct  6 2008 sbrabec@suse.cz
- Conflict with other branding providers (FATE#304881).
* Fri Jul 25 2008 sbrabec@suse.cz
- nautilus-folder-handler added to gnome-defaults.conf (bnc#410728)
* Fri Jul 18 2008 jpr@novell.com
- Use banshee-1.desktop instead of banshee.desktop (bnc#406741)
* Mon May  5 2008 sbrabec@suse.cz
- Prefer eog over evince for image/tiff (bnc#346517).
* Wed Apr 30 2008 sbrabec@suse.cz
- Prefer gedit over writer for text/plain (bnc#382168).
* Mon Apr 14 2008 sbrabec@suse.cz
- Use packageand form of branding supplement and removed self
  conflict.
* Wed Apr  9 2008 sbrabec@suse.cz
- Split gnome_defaults.conf to a separate branding-style package,
  so branding vendors can easily change default applications.
- Prefer both software installers over file-roller in
  gnome_defaults.conf (bnc#377979, fate#302267).
