#
# spec file for package fipscheck
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define lname libfipscheck1
%global soversion 1.2.1
%global somajor 1
Name:           fipscheck
Version:        1.7.0
Release:        150600.3.3.2
Summary:        A library for integrity verification of FIPS validated modules
License:        BSD-2-Clause
Group:          Development/Libraries/C and C++
URL:            https://github.com/LairdCP/fipscheck
Source0:        fipscheck-%version.tar.bz2
Source1:        baselibs.conf
Patch0:         fipscheck-fix_check_openssl_version.patch
Patch1:         fipscheck-fix_incorrect_length_type.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
BuildRequires:  pkgconfig(openssl)
Requires:       %{lname} = %{version}

%description
FIPSCheck is a library for integrity verification of FIPS validated
modules. The package also provides helper binaries for creation and
verification of the HMAC-SHA256 checksum files.

%package -n %{lname}
Summary:        Library files for %{name}
Group:          System/Libraries
Requires:       %{_bindir}/fipscheck

%description -n %{lname}
This package contains the FIPSCheck library.

%package devel
Summary:        Development files for %{name}
Group:          Development/Libraries/C and C++
Requires:       %{lname} = %{version}

%description devel
This package contains development files for %{name}.

%prep
%setup -q
%patch -P0 -p1
%patch -P1 -p1

%build
%configure --disable-static

make %{?_smp_mflags} LDFLAGS="-Wl,-z,relro"

# Add generation of HMAC checksums of the final stripped binaries
%define __spec_install_post \
    %{?__debug_package:%{__debug_install_post}} \
    %{__arch_install_post} \
    %__os_install_post \
    %{buildroot}%{_bindir}/fipshmac %{buildroot}%{_bindir}/fipscheck \
    %{buildroot}%{_bindir}/fipshmac %{buildroot}/%{_libdir}/libfipscheck.so.%{soversion} \
    ln -s .libfipscheck.so.%{soversion}.hmac %{buildroot}/%{_libdir}/.libfipscheck.so.%{somajor}.hmac \
%{nil}

%install
%make_install
find %{buildroot} -type f -name "*.la" -delete -print

%post -n %{lname} -p /sbin/ldconfig
%postun -n %{lname} -p /sbin/ldconfig

%files
%license COPYING
%doc ChangeLog README AUTHORS
%{_bindir}/fipscheck
%{_bindir}/.fipscheck.hmac
%{_bindir}/fipshmac

%files -n %{lname}
%{_libdir}/libfipscheck.so.*
%{_libdir}/.libfipscheck.so.*
%{_mandir}/man8/*.8%{?ext_man}

%files devel
%{_includedir}/fipscheck.h
%{_libdir}/libfipscheck.so
%{_mandir}/man3/*.3%{?ext_man}

%changelog
* Mon Jul  8 2024 mjambor@suse.com
- Backport upstream patches fipscheck-fix_check_openssl_version.patch
  and fipscheck-fix_incorrect_length_type.patch to fix C99 violations
  which are errors by default with GCC 14 [boo#1221714] - although the
  first one looks like it possibly fixes some more substantial error.
* Wed Nov  2 2022 meissner@suse.com
- updated to 1.7.0 (from a different supplier)
  - openssl 3 support
- dropped fipscheck-dont_generate_manpages.patch (not needed)
- dropped fipscheck-fips.h_not_needed.patch (not needed)
* Fri Nov 20 2020 lnussel@suse.de
- move libs to %%_libdir (boo#1029961)
* Mon Sep 16 2019 vcizek@suse.com
- Remove #include of unused fips.h to fix build with OpenSSL 1.1.1
  (bsc#1149792)
  * add fipscheck-fips.h_not_needed.patch
- Drop obsolete openssl-1_1-port.patch (upstream)
* Thu Jan  3 2019 vcizek@suse.com
- Use the shipped manpages instead of building them with xmlto
  in order to avoid a build cycle (fipscheck, xmlto, libxslt, libgcrypt)
  * add fipscheck-dont_generate_manpages.patch
- fix build on older distributions
* Thu Sep 20 2018 jsikes@suse.de
- Changed source back to http now that current release folder
  has current tarball.
* Tue Sep 11 2018 jsikes@suse.de
- Updated fipscheck to 1.5.0
  * Changed source to local file since latest official release
    is not in the official releases directory.
  * Downgraded libopenssl-devel to libopenssl-1_0_0-devel because
    1.0.2 supports FIPS.
* Mon Jun 12 2017 daniel.molkentin@suse.com
- Port to OpenSSL 1.1 (bsc#1042649)
  Adds openssl-1_1-port.patch
* Mon Apr 13 2015 jengelh@inai.de
- Set RPM groups anew. Drop implicit cleaning parts.
* Mon Jun  2 2014 meissner@suse.com
- add baselibs.conf
* Tue May 27 2014 meissner@suse.com
- updated to 1.4.1
  - added manpages
  - fipscheck/fipshmac: Add -s option to specify the hmac suffix
  - fipshmac: Add '-d' option to specify where to put the .hmac files
  - various bugfixes
* Tue Jan 21 2014 cfarrell@suse.com
- license update: BSD-2-Clause
  See LICENSE
* Mon Jan 20 2014 meissner@suse.com
- imported a generic fips helper to verify fips modules, linked
  to openssl.
