#
# spec file for package libaio
#
# Copyright (c) 2024 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%define lname	libaio1
Name:           libaio
Version:        0.3.113
Release:        150600.15.3.1
Summary:        Linux-Native Asynchronous I/O Access Library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
URL:            https://pagure.io/libaio
Source:         https://pagure.io/libaio/archive/libaio-%{version}/libaio-libaio-%{version}.tar.gz
Source2:        baselibs.conf
Patch1:         fix-splice-signature.patch

%description
The Linux-native asynchronous I/O facility ("async I/O", or "aio") has
a richer API and capability set than the simple POSIX async I/O
facility. This library provides the Linux-native API for async I/O. The
POSIX async I/O facility requires this library to provide
kernel-accelerated async I/O capabilities, as do applications that
require the Linux-native async I/O API.

%package -n %{lname}
Summary:        Linux-Native Asynchronous I/O Access Library
Group:          System/Libraries
Obsoletes:      libaio < %{version}-%{release}
Provides:       libaio = %{version}-%{release}

%description -n %{lname}
The Linux-native asynchronous I/O facility ("async I/O", or "aio") has
a richer API and capability set than the simple POSIX async I/O
facility. This library provides the Linux-native API for async I/O. The
POSIX async I/O facility requires this library to provide
kernel-accelerated async I/O capabilities, as do applications that
require the Linux-native async I/O API.

%package devel
Summary:        Development Files for Linux-native Asynchronous I/O Access
Group:          Development/Libraries/C and C++
Requires:       %{lname} = %{version}
Requires:       glibc-devel

%description devel
This package provides header files to include, and libraries to link
with, for the Linux-native asynchronous I/O facility ("async I/O", or
"aio").

%prep
%autosetup -p1 -n %{name}-%{name}-%{version}

%build
%define _lto_cflags %nil
CFLAGS="%{optflags}" %make_build

%install
%make_install libdir=%{_libdir}
rm %{buildroot}%{_libdir}/*.a

%check
# qemu-linux-user does not emulate io_setup syscall, so none of the testsuite makes sense
%if ! 0%{?qemu_user_space_build}
CFLAGS="%{optflags}" %make_build partcheck
%endif

%post -n %{lname} -p /sbin/ldconfig
%postun -n %{lname} -p /sbin/ldconfig

%files -n %{lname}
%license COPYING
%{_libdir}/libaio.so.*

%files devel
%{_includedir}/libaio.h
%{_libdir}/libaio.so

%changelog
* Thu Feb 29 2024 pgajdos@suse.com
- Use %%autosetup macro. Allows to eliminate the usage of deprecated
  %%patchN
* Thu Mar 23 2023 mliska@suse.cz
- Make the package respect %%optflags and disable LTO.
* Fri Sep 23 2022 dmueller@suse.com
- skip testsuite on qemu_linux_user builds
* Tue Jul 12 2022 dmueller@suse.com
- add fix-splice-signature.patch to fix build on 32bit
* Thu Apr 28 2022 dmueller@suse.com
- update to 0.3.113:
  * cases/16.t: loongarch only supports eventfd2
  * Add loongarch to supported architectures in libaio.spec
  * Add endian detection and bit width detection for loongarch
  * Use generic syscall number schema for loongarch
  * Fix struct io_iocb_vector padding for 32bit architectures
  * struct io_iocb_sockaddr padding for 32bit architectures
  * Verify structure padding is correct at build time
  * harness: add test for aio poll missed events
* Mon Feb 15 2021 lduncan@suse.com
- Update to version libaio0.3.112+29.696a5e6483ba:
  * Fix test issue with gcc-11 (bsc#1181869)
  * harness: Skip the test if io_pgetevents() is not implemented
  * harness: Print better error messages on error conditions in 22.t
  * harness: Fix PROT_WRITE mmap check
  * harness: fix read into PROT_WRITE mmap test
  * harness: skip 22.p if async_poll isn't supported
  * harness: Handle -ENOTSUP from io_submit() with RWF_NOWAIT
  * harness: Add fallback code for filesystems not supporting O_DIRECT
  * harness: add support for skipping tests
  * harness: Make the test exit with a code matching the pass/fail state
* Tue Aug 27 2019 normand@linux.vnet.ibm.com
-  Add _constraints for PowerPC to avoid OOM at build time
* Wed Jul 31 2019 tchvatal@suse.com
- Update to 0.3.112:
  * Various patches for architectures/etc
- Update url
- Update install
- Enable tests
- Remove mostly merged patches or differently fixed issues:
  * libaio-aarch64-support.diff
  * libaio-generic-arch.diff
  * libaio-optflags.diff
  * 00_arches.patch
  * 00_arches_sh.patch
  * 01_link_libgcc.patch
  * 02_libdevdir.patch
  * 03_man_errors.patch
  * riscv-support.patch
* Wed Apr 24 2019 mliska@suse.cz
- Disable LTO (boo#1133233).
* Thu Jan 31 2019 schwab@suse.de
- riscv-support.patch: Add support for RISC-V
* Thu May 24 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Sun Apr 17 2016 meissner@suse.com
- libaio-optflags.diff: readd -stdlib to allow -fstack-protector-strong
  builds (unclear why it was not allowed)
- 01_link_libgcc.patch, 02_libdevdir.patch: refreshed
* Tue Aug 26 2014 fcrozat@suse.com
- Add obsoletes/provides to baselibs.conf (bsc#881698)
* Fri Mar  1 2013 dmueller@suse.com
- Add libaio-aarch64-support.diff:
  * add support for aarch64
- Add libaio-generic-arch.diff:
  * support all archtes (also aarch64)
* Fri Feb 17 2012 coolo@suse.com
- fix baselibs.conf after shlib split
* Thu Feb 16 2012 mvyskocil@suse.cz
- fix typo versoin/version
* Mon Feb 13 2012 coolo@suse.com
- patch license to follow spdx.org standard
* Mon Nov 28 2011 jengelh@medozas.de
- Remove redundant/unwanted tags/section (cf. specfile guidelines)
- Employ shlib packaging
* Mon Nov 28 2011 ro@suse.de
- fix lib64 platform check
* Wed Oct  5 2011 uli@suse.com
- cross-build fix: use %%__cc macro
* Fri Sep 30 2011 adrian@suse.de
- drop debian arm hack to fix build on arm ;)
* Tue Mar 15 2011 jengelh@medozas.de
- Update to libaio 0.3.109
  * add ARM architecture support (grabbed from Debian arches tree)
  * replace check of __i386__ with __LP64__ in test harness
- refreshed patches
* Fri Feb 12 2010 jengelh@medozas.de
- fix more symbolic links to not include a /usr/src/ prefix
* Sat Jan 23 2010 jengelh@medozas.de
- update to libaio 0.3.107
- add more patches from Debian to fix compile errors on SPARC
- package baselibs.conf
* Sun Aug  2 2009 jansimon.moeller@opensuse.org
- add ARM support to libaio sources
* Tue Mar  3 2009 crrodriguez@suse.de
- remove static libraries
- fix -devel package dependencies
* Wed Dec 10 2008 olh@suse.de
- use Obsoletes: -XXbit only for ppc64 to help solver during distupgrade
  (bnc#437293)
* Thu Dec  4 2008 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Thu Sep 27 2007 hare@suse.de
- Fix dangling symlink (#307063)
* Thu Aug  2 2007 hare@suse.de
- Use RPM_OPT_FLAGS
- Fix installation directories
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Thu May  5 2005 schwab@suse.de
- Fix ia64 assembler.
* Wed Apr 27 2005 kukuk@suse.de
- Update to version 0.3.104
* Wed Dec  1 2004 kukuk@suse.de
- Update to version 0.3.102 [#44374]
* Tue Apr 20 2004 meissner@suse.de
- fixed ppc64 alignment problems. [#38801/LTC#7503]
* Fri Mar 12 2004 kukuk@suse.de
- Update to 0.3.98 [Bug #35266]
* Tue Mar  2 2004 ro@suse.de
- use -fPIC for shared objects on ppc
* Sun Jan 11 2004 adrian@suse.de
- add %%defattr and %%run_ldconfig
* Wed Oct  1 2003 schwab@suse.de
- Fix for ia64.
* Wed Apr 23 2003 coolo@suse.de
- fix build for lib64
* Wed Apr 23 2003 coolo@suse.de
- use BuildRoot
* Fri Apr 11 2003 ro@suse.de
- fix header to be includable with glibc (#26033)
* Thu Apr  3 2003 kukuk@suse.de
- Add missing "const" to libaio.h [#26030]
* Tue Oct  1 2002 meissner@suse.de
- Fixed __syscall_return for ppc.
* Fri Sep 20 2002 fehr@suse.de
- Add syscall defines for x86_64
- add Andreas fix for testsuite main program to compile on x86_64
- add another fix to make testsuite build again on ia64
* Thu Sep 19 2002 schwab@suse.de
- Add missing bits for ia64.
* Tue Sep 17 2002 ro@suse.de
- removed bogus self-provides
* Wed Sep  4 2002 fehr@suse.de
- make package from  libaio-0.3.15-2.5
