#
# spec file for package wget
#
# Copyright (c) 2020 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%bcond_with	regression_tests
Name:           wget
Version:        1.20.3
Release:        150600.19.12.1
Summary:        A Tool for Mirroring FTP and HTTP Servers
License:        GPL-3.0-or-later
Group:          Productivity/Networking/Web/Utilities
URL:            https://www.gnu.org/software/wget/
Source:         https://ftp.gnu.org/gnu/wget/%{name}-%{version}.tar.gz
Source1:        https://ftp.gnu.org/gnu/wget/%{name}-%{version}.tar.gz.sig
Source2:        https://savannah.gnu.org/project/memberlist-gpgkeys.php?group=wget&download=1#/wget.keyring
Patch0:         wgetrc.patch
Patch1:         wget-libproxy.patch
Patch6:         wget-1.14-no-ssl-comp.patch
# PATCH-FIX-OPENSUSE fix pod syntax for perl 5.18 coolo@suse.de
Patch7:         wget-fix-pod-syntax.diff
Patch8:         wget-errno-clobber.patch
Patch9:         remove-env-from-shebang.patch
Patch10:        0001-possibly-truncate-pathname-components.patch
Patch11:        properly-re-implement-userinfo-parsing.patch
# PATCH-FIX-UPSTREAM - CVE-2024-10524
Patch12:        drop-support-for-shorthand-URLs.patch
# PATCH-FIX-OPENSUSE do not propagate Authorization when redirect CVE-2021-31879 
Patch13:        wget-do-not-propagate-credentials.patch
BuildRequires:  automake
BuildRequires:  gpgme-devel >= 0.4.2
BuildRequires:  libcares-devel
BuildRequires:  libidn2-devel
BuildRequires:  libpng-devel
BuildRequires:  makeinfo
BuildRequires:  openssl-devel
BuildRequires:  pkgconfig >= 0.9.0
# FIXME: use proper Requires(pre/post/preun/...)
PreReq:         %{install_info_prereq}
%if %{?suse_version} > 1110
BuildRequires:  pkgconfig
BuildRequires:  pkgconfig(libmetalink)
BuildRequires:  pkgconfig(libpcre2-8)
BuildRequires:  pkgconfig(libpsl)
BuildRequires:  pkgconfig(uuid)
%else
BuildRequires:  libmetalink-devel
BuildRequires:  libpsl-devel
BuildRequires:  libuuid-devel
BuildRequires:  pcre-devel
%endif
%if 0%{?suse_version} > 1110
BuildRequires:  libproxy-devel
%endif
%if %{with regression_tests}
# For the Testsuite
BuildRequires:  perl-HTTP-Daemon
BuildRequires:  perl-IO-Socket-SSL
%endif

%description
Wget enables you to retrieve WWW documents or FTP files from a server.
This can be done in script files or via the command line.

%lang_package

%prep
%setup -q
%patch0 -p1
%if 0%{?suse_version} > 1110
%patch1 -p1
%endif
%patch6
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%build
%if 0%{?suse_version} > 1110
# only wget-libproxy.patch needs this
autoreconf --force
%endif
%configure \
	--with-ssl=openssl \
	--with-cares \
	--with-metalink
%make_build
sed -i 's/\/usr\/bin\/env perl -w/\/usr\/bin\/perl -w/' util/rmold.pl

%check
%if %{with regression_tests}
%make_build -C tests/ check
%endif

%install
%make_install
%find_lang %{name} %{?no_lang_C}

%post
%install_info --info-dir=%{_infodir} %{_infodir}/%{name}.info.gz

%postun
%install_info_delete --info-dir=%{_infodir} %{_infodir}/%{name}.info.gz

%files 
%license COPYING
%doc AUTHORS NEWS README MAILING-LIST
%doc doc/sample.wgetrc util/rmold.pl
%{_mandir}/*/wget*
%{_infodir}/wget*
%config(noreplace) %{_sysconfdir}/wgetrc
%{_bindir}/*

%files lang -f %{name}.lang

%changelog
* Tue Dec  3 2024 valentin.lefebvre@suse.com
- If wget for an http URL is redirected to a different site (hostname
  parts of URLs differ), then any "Authenticate" and "Cookie" header
  entries are discarded.
  [bsc#1185551, wget-do-not-propagate-credentials.patch,
  bsc#1230795, CVE-2021-31879]
* Wed Nov 27 2024 valentin.lefebvre@suse.com
- Drop support for shorthand URLs
  * Breaking change to fix CVE-2024-10524.
  [+ drop-support-for-shorthand-URLs.patch, bsc#1233773]
* Thu Oct 24 2024 valentin.lefebvre@suse.com
- Update 0001-possibly-truncate-pathname-components.patch
  * Take the patch from savannah repository where the checking of the file
    length doesn't include path length.
  * [bsc#1204720, bsc#1231661]
* Tue Jun 18 2024 valentin.lefebvre@suse.com
- Fix mishandled semicolons in the userinfo subcomponent could lead to an
  insecure behavior in which data that was supposed to be in the userinfo
  subcomponent is misinterpreted to be part of the host subcomponent.
  [bsc#1226419, CVE-2024-38428, properly-re-implement-userinfo-parsing.patch]
* Mon Mar  4 2024 mgorse@suse.com
- Update wget-libproxy.patch: ensure to properly use libproxy
  cflags from pkg-config. Fixes build against libproxy 0.5.
* Tue Nov  8 2022 valentin.lefebvre@suse.com
- Update 0001-possibly-truncate-pathname-components.patch
  * Truncate file name even if no directory structure
  * [bsc#1204720]
* Thu May 27 2021 josef.moellers@suse.com
- When running recursively, wget will verify the length of the whole
  URL when saving the files. This will make it overwrite files with
  truncated names, throwing the "The name is too long, ... trying to
  shorten" messages. The patch moves the length check code to a
  separate function and call it from the append_dir_structure() for each
  path element.
  [ bsc#1181173, 0001-possibly-truncate-pathname-components.patch]
* Thu Mar 12 2020 info@paolostivanin.com
- split lang files into separate lang package
- add remove-env-from-shebang.patch
* Fri Apr  5 2019 josef.moellers@suse.com
- Upgrade to GNU wget 1.20.3:
  * Finally fixed the buffer overflow vulnerability
  * obsoletes patch wget-buffer-overflow-CVE-2019-5953.patch
  [bsc#1131493, CVE-2019-5953]
* Wed Apr  3 2019 seanlew@opensuse.org
- GNU wget 1.20.2:
  * NTLM authentication will retry under certain cases
  * Fixed a buffer overflow vulnerability
* Fri Jan 11 2019 mpluskal@suse.com
- Use pcre2
- Make building more verbose
* Fri Dec 28 2018 astieger@suse.com
- GNU wget 1.20.1:
  * --xattr is no longer default since it introduces privacy issues
  * --xattr saves the Referer as scheme/host/port,
    user/pw/path/query/fragment are no longer saved to prevent
    privacy issues
  * --xattr saves the Original URL without user/password to prevent
    privacy issues
  * all of the above fix CVE-2018-20483 (bsc#1120382)
* Fri Nov 30 2018 josef.moellers@suse.com
- Version update to 1.20:
  * Add new option `--retry-on-host-error` to treat local errors as
    transient and hence Wget will retry to download the file after
    a brief waiting period.
  * multiple potential resource leaks as found by static analysis.
  * Wget will now not create an empty wget-log file when running
    with -q and -b. switches together
  * When compiled using the GnuTLS = 3.6.3, Wget now has support
    for TLSv1.3.
  * Now there is support for using libpcre2 for regex pattern
    matching.
  * When downloading over FTP recursively, one can now use the
  - -accept,reject -regex switches to fine-tune the downloaded
    files.
  * Building Wget from the git sources now requires autoconf 2.63
    or above. Building from the Tarballs works as it used to.
  [bsc#1167919, wget-ignore-void-retvalue.patch]
* Mon May  7 2018 josef.moellers@suse.com
- GNU wget 1.19.5:
  * Fix cookie injection (CVE-2018-0494, bsc#1092061)
  * Enable TLS1.3 with recent OpenSSL environment
  * New option --ciphers to set GnuTLS / OpenSSL ciphers directly
  * Updated CSS grammar to CSS 2.2
  * Fixed several memleaks found by OSS-Fuzz
  * Fixed several buffer overflows found by OSS-Fuzz
  * Fixed several integer overflows found by OSS-Fuzz
  * Several minor bug fixes
  [bsc#1092061, CVE-2018-0494, wget-ignore-void-retvalue.patch]
* Fri Feb 16 2018 josef.moellers@suse.com
- Original package had sources lzip compressed. Downloaded .gz
  compressed file including signature file.
* Mon Jan 22 2018 avindra@opensuse.org
- GNU wget 1.19.4:
  * Support for Content-Encoding and Transfer-Encoding have been
    marked as experimental and disabled by default
- includes 1.19.3:
  * Prevent erroneous decompression of .gz and .tgz files with
    broken servers
  * Added support for HTTP 308 Permanent Redirect response
  * Fix segfault in some cases where the Content-Type header is
    not sent
  * Support OpenSSL 1.1 builds without using deprecated features
  * Several minor bug fixes
- switch to lz release (smaller)
- cleanup with spec-cleaner
* Fri Oct 27 2017 astieger@suse.com
- GNU wget 1.19.2:
  * CVE-2017-13089: Stack overflow in HTTP protocol handling (bsc#1064715)
  * CVE-2017-13090: Heap overflow in HTTP protocol handling (bsc#1064716)
  * New option --compression for gzip Content-Encoding
  * New option --[no]-netrc to control .netrc parsing
  * Added GNU extensions to .netrc parsing
  * Improved IDNA 2003 compatibility
  * Fix VPATH issues
  * Improved and extended the test suite
  * Support Wayback Machine's X-Archive-Orig-last-modified
  * Several bug fixes
- drop upstreamed patches:
  * wget-CVE-2017-6508.patch
  * wget-416-but-file-not-complete.patch
- unfuzz wget-errno-clobber.patch
* Thu Sep 21 2017 josef.moellers@suse.com
- Retry http GET when server responds with "416 Requested Range
  Not Satisfiable" but file is not complete.
  [boo#1058204, wget-416-but-file-not-complete.patch]
* Tue Mar  7 2017 josef.moellers@suse.com
- src/url.c (url_parse): Reject control characters in host part
  of URL
  (CVE-2017-6508, wget-CVE-2017-6508.patch, bsc#1028301)
* Thu Feb 16 2017 josef.moellers@suse.com
- Update to wget-1.19.1, mainly bug fixes
  * Add support for --retry-on-http-error
  * tests/WgetTests.pm: Add --no-config to wget invocation
  * Fix regression in .netrc auth in src/http.c
  * Fix memory leak in src/iri.c
  * Remove skipping libunistring with --disable-iri
  * bootstrap.conf: Add gnulib module wcwidth
  * Fix include/define clash with gnulib's unlink module
* Sat Feb  4 2017 astieger@suse.com
- build with libidn2 to actually support IDNA2008 - FATE#321897
* Fri Feb  3 2017 josef.moellers@suse.com
- Update to wget-1.19:
  * New option --use-askpass=COMMAND. Fetch user/password by calling
    an external program.
  * Use IDNA2008 (+ TR46 if available) through libidn2
  * When processing a Metalink header, --metalink-index=<number> allows
    to process the header's application/metalink4+xml files.
  * When processing a Metalink file, --trust-server-names enables the
    use of the destination file names specified in the Metalink file,
    otherwise a safe destination file name is computed.
  * When processing a Metalink file, enforce a safe destination path.
    Remove any drive letter prefix under w32, i.e. 'C:D:file'.  Call
    libmetalink's metalink_check_safe_path() to prevent absolute,
    relative, or home paths:
    https://tools.ietf.org/html/rfc5854#section-4.1.2.1
    https://tools.ietf.org/html/rfc5854#section-4.2.8.3
  * When processing a Metalink file, --directory-prefix=<prefix> sets
    the top of the retrieval tree to prefix for Metalink downloads.
  * When processing a Metalink file, reject downloaded files which don't
    agree with their own metalink:size value:
    https://tools.ietf.org/html/rfc5854#section-4.2.16
  * When processing a Metalink file, with --continue resume partially
    downloaded files and keep fully downloaded files even if they fail
    the verification.
  * When processing a Metalink file, create the parent directories of a
    "path/file" destination file name:
    https://tools.ietf.org/html/rfc5854#section-4.1.2.1
    https://tools.ietf.org/html/rfc5854#section-4.2.8.3
  * On a recursive download, append a .tmp suffix to temporary files
    that will be deleted after being parsed, and create them
    readable/writable only by the owner.
  * New make target 'check-valgrind'
  * Fix several bugs
  * Fix compatibility issues
* Thu Jul 28 2016 josef.moellers@suse.com
- Save/restore errno within CLOSE_FINISH and CLOSE_INVALIDATE.
  (wget-errno-clobber.patch, boo#983660)
* Fri Jul 22 2016 dimstar@opensuse.org
- Update wget-libproxy.patch: use libproxy's px_proxy_factory_free
  instead of regular free in order to ensure the module destructors
  are correctly running (boo#967601).
* Thu Jun  9 2016 astieger@suse.com
- GNU wget 1.18:
  * On server redirects to a FTP resource, use the original URL to
    get the local file name by default. CVE-2016-4971 (boo#984060)
    This introduces a backward-incompatibility for HTTP->FTP
    redirects and any script that relies on the old  behaviour must
    use --trust-server-names.
  * Check the HSTS file is not world-writable before using it.
  * Parse <img srcset> attributes on a recursive download.
  * Fix problem with SNI server names having trailing dot(s)
  * New options --bind-dns-address and --dns-servers.
  * Convert non-ASCII URIs to the locale's codeset when creating
    files. Encoding of remote files and URIs is taken from
  - -remote-encoding, defaulting to UTF-8.  The result is that
    non-ASCII URIs and files downloaded via HTTP/HTTPS and FTP will
    have names on the local filesystem that correspond to their
    remote names.
- build with gpgme, libcares2
* Sat Dec 12 2015 astieger@suse.com
- GNU wget 1.17.1:
  * Fix compile error when IPv6 is disabled or SSL is not present
  * Fix HSTS memory leak
  * Fix progress output in non-C locales
  * Fix SIGSEGV when -N and --content-disposition are used together
  * Add --check-certificate=quiet to tell wget to not print any
    warning about invalid certificates
* Wed Nov 18 2015 astieger@suse.com
- GNU wget 1.17:
  * Remove FTP passive to active fallback due to privacy concerns.
    [boo#944858] CVE-2015-7665 was assigned to this problem in a
    tails context
  * Add support for --if-modified-since.
  * Add support for metalink through --input-metalink and
  - -metalink-over-http.
  * Add support for HSTS through --hsts and --hsts-file.
  * Add option to restrict filenames under VMS.
  * Add support for --rejected-log which logs to a separate file the
    reasons why URLs are being rejected and some context around it.
  * Add support for FTPS.
  * Do not download/save file on error when --spider enabled
  * Add --convert-file-only option. This option converts only the
    filename part of the URLs, leaving the rest of the URLs
    untouched.
- packaging changes:
  * enable metalink support (in ring1)
  * use system pcre (in ring 0)
  * use system libuuid (in ring 1)
  * build with libpsl for cookie domain checking (new)
* Mon Mar  9 2015 astieger@suse.com
- GNU wget 1.16.3:
  * Fix a regression introduced by wget 1.16.2 that --quiet is not
    really quiet anymore.
* Tue Mar  3 2015 astieger@suse.com
- GNU wget 1.16.2:
  * Allow progress bar on stderr when -o is used.
  * Accept 5-digit port numbers in FTP EPSV responses.
  * Support older versions of flex.
  * Updated translations.
- drop wget-1.14-openssl-no-intern.patch, now upstream
* Wed Dec 24 2014 andreas.stieger@gmx.de
- GNU wget 1.16.1:
  * Add --enable-assert configure option.
  * Use pkg-config to check for libraries presence.
  * Do not limit --secure-protocol=auto|pfs to TLSv1.0.
  * Add --secure-protocol=TLSv1_1|TLSv1_2 .
  * Full C89 source code compliance.
  * Select and use the most secure authentication scheme with HTTP
    connections.
  * Fix issues with turkish locales.
  * Handle 504 Gateway Timeout.
  * New option --crl-file to load Certificate Revocation Lists.
  * Add valgrind support to tests suite.
  * Fix an off-by-one problem in the progress bar (introduced in 1.16).
- refresh wget-libproxy.patch
* Wed Oct 29 2014 andreas.stieger@gmx.de
- GNU wget 1.16:
  This release contains a fix for symlink attack which could allow
  a malicious ftp server to create arbitrary files, directories or
  symbolic links and set their permissions when retrieving a
  directory recursively through FTP. [CVE-2014-4877] [boo#902709]
  * No longer create local symbolic links by default
  - -retr-symlinks=no option restores previous behaviour
  * Use libpsl for verifying cookie domains.
  * Default progress bar output changed.
  * Introduce --show-progress to force display the progress bar.
  * Introduce --no-config.  The wgetrc files will not be read.
  * Introduce --start-pos to allow starting downloads from a specified position.
  * Fix a problem with ISA Server Proxy and keep-alive connections.
- refresh wget-libproxy.patch for upstream changes
- make some dependencies only required for testsuite optional
* Sun Jun  8 2014 andreas.stieger@gmx.de
- Disable the testsuite
* Tue Jan 21 2014 kpetsch@suse.com
- Enabled the testsuite
- Modified libproxy.patch to include Makefile in tests/
* Sun Jan 19 2014 andreas.stieger@gmx.de
- GNU wget 1.15
  * Add support for --method.
  * Add support for file names longer than MAX_FILE.
  * Support FTP listing for the FTP Server on Windows Server 2008 R2.
  * Fix a regression when -c and --content-disposition are used together.
  * Support shorthand URLs in an input file.
  * Fix -c with servers that don't specify a content-length.
  * Add support for MD5-SESS
  * Do not fail on non fatal GNU TLS alerts during handshake.
  * Add support for --https-only.  When used wget will follow only
  * HTTPS links in recursive mode.
  * Support Perfect-Forward Secrecy in --secure-protocol.
  * Fix a problem with some IRI links that are not followed when contained in a
  * HTML document.
  * Support some FTP servers that return an empty list with "LIST -a".
  * Specify Host with the HTTP CONNECT method.
  * Use the correct HTTP method on a redirection.
- verify source tarball signatures
- modified patches:
  * wget-1.14-openssl-no-intern.patch for upstream changes
  * wget-fix-pod-syntax.diff for upstream changes
* Thu Jun 20 2013 coolo@suse.com
- add wget-fix-pod-syntax.diff to fix build with perl 5.18
* Thu May  2 2013 p.drouand@gmail.com
- Update to version 1.14
  + add support for content-on-error.  It allows to store the HTTP
    payload on 4xx or 5xx errors.
  + add support for WARC files.
  + fix a memory leak problem in the GNU TLS backend.
  + autoreconf works again for distributed tarballs.
  + print some diagnostic messages to stderr not to stdout.
  + report stdout close errors.
  + accept the --report-speed option.
  + enable client certificates when GNU TLS is used.
  + add support for TLS Server Name Indication.
  + accept the arguments --accept-reject and --reject-regex.
  + the GNU TLS backend honors correctly the timeout value.
  + add support for RFC 2617 Digest Access Authentication.
- Drop patchs obsoleted by upstream
  + wget-sni.patch
  + wget-stdio.h.patch
- Rebase patchs to work with upstream
  + wget-openssl-no-intern.patch > wget-1.14-openssl-no-intern.patch
  + wget-no-ssl-comp.patch > wget-1.14-no-ssl-comp.patch
* Thu May  2 2013 seife+obs@b1-systems.com
- add makeinfo BuildRequires to fix build
* Fri Apr  5 2013 idonmez@suse.com
- Add Source URL, see https://en.opensuse.org/SourceUrls
* Mon Nov 12 2012 crrodriguez@opensuse.org
- wget-no-ssl-comp.patch: Since the apperance of the "CRIME attack"
  (CVE-2012-4929) HTTPS clients must not negotatiate ssl compression.
* Thu Sep 27 2012 crrodriguez@opensuse.org
- Add wget-openssl-no-intern.patch to Build with OPENSSL_NO_SSL_INTERN,
  which is openssl's poor man's version of visibility, to avoid breaking
  applications ABI on library internal changes.
* Fri Jul 27 2012 aj@suse.de
- Fix build with missing gets declaration (glibc 2.16)
* Wed Mar 21 2012 dimstar@opensuse.org
- Adjust wget-libproxy.patch: give debug output only when
  opt.debug is set to non-zero values, so when -d is specified.
  Fix bnc#753242.
* Fri Dec  2 2011 coolo@suse.com
- add automake as buildrequire to avoid implicit dependency
* Wed Oct 19 2011 max@suse.com
- New version: 1.13.4:
  * Now --timestamping and --continue work well together.
  * Return a network failure when FTP downloads fail and
  - -timestamping is specified.
  * Support HTTP/1.1
  * Fix some portability issues.
  * Handle properly malformed status line in a HTTP response.
  * Ignore zero length domains in $no_proxy.
  * Exit with failure if -k is specified and -O is not a regular
    file.
  * Cope better with unclosed html tags.
  * Print diagnostic messages to stderr, not stdout.
  * Do not use an additional HEAD request when
  - -content-disposition is used, but use directly GET.
  * Report the average transfer speed correctly when multiple
    URLs are specified and -c influences the transferred data
    amount.
  * By default, on server redirects, use the original URL to get
    the local file name. Close CVE-2010-2252.  This introduces a
    backward-incompatibility; any script that relies on the old
    behaviour must use --trust-server-names.
  * Fix a problem when -k is used and some URLs are specified
    trough CSS.
  * Convert correctly URLs that need to be encoded to local files
    when following links.
  * Use persistent connections with proxies supporting them.
  * Print the total download time as part of the summary for
    recursive downloads.
  * Now it is possible to specify a different startup
    configuration file trough the --config option.
  * Fix an infinite loop with the error '<filename> has sprung
    into existence' on a network error and -nc is used.
  * Now --adjust-extension does not modify the file extension if
    the file ends in .htm.
  * Support HTTP/1.1 307 redirects keep request method.
  * Now --no-parent doesn't fetch undesired files if HTTP and
    HTTPS are used by the same host on different pages.
  * Do not attempt to remove the file if it is not in the accept
    rules but it is the output destination file.
  * Introduce `show_all_dns_entries' to print all IP addresses
    corresponding to a DNS name when it is resolved.
- Adjuct patches to the new version.
- wget-1.12-nosslv2.patch got included upstream.
* Sat Oct 15 2011 crrodriguez@opensuse.org
- fix typo in sni patch , in the IPV6 case should be
  is_valid_ipv6_address() instead of is_valid_ipv4_address()
- Add comment to the patch referencing upstream tracker.
* Fri Oct 14 2011 crrodriguez@opensuse.org
-  Update nosslv2 patch with the version in upstream
-  Wget now supports SNI (server name indication), patch
  based on a 2 year old fix submitted to upstream list
  that somehow fell through the cracks.
* Sat Apr  9 2011 crrodriguez@opensuse.org
- SSLv2 is being disabled in openSSL, allow painless obsoletion.
- Support IDN.
* Sun Aug 15 2010 dimstar@opensuse.org
- Update to version 1.12:
  + SECURITY FIX: It had been possible to trick Wget into accepting
    SSL certificates that don't match the host name, through the
    trick of embedding NUL characters into the certs' common name
  + Added support for CSS. This includes:
  - Parsing links from CSS files, and from CSS content found in
    HTML style tags and attributes.
  - Supporting conversion of links found within CSS content, when
  - -convert-links is specified.
  - Ensuring that CSS files end in the ".css" filename extension,
    when --convert-links is specified.
  + Added support for Internationalized Resource Identifiers
  + Wget now provides more sensible exit status codes when
    downloads don't proceed as expected
  + --default-page option (and associated wgetrc command) added to
    support alternative default names for index.html.
  + --ask-password option (and associated wgetrc command) added to
    support password prompts at the console.
  + The --input-file option now also handles retrieving links from
    an external file.
  + The output generated by the --version option now includes
    information on how it was built, and the set of configure-time
    options that were selected.
  + --html-extension has been renamed to --adjust-extension, to
    reflect the fact that it now also applies to CSS content
  + An "ascii" specifier is now accepted by --restrict-file-names,
    which forces the percent-encoding of all non-ASCII bytes
  + Several previously existing, but undocumented .wgetrc options
    are now documented.
- Drop upstream fixed wget-nullcerts.patch.
- Minor spec-cleanups using spec-cleaner
- Use smp_mflags
- Add libproxy-devel BuildRequires and enable libproxy support
  using wget-libproxy.patch.
- Add pkg-config BuildRequire to succeed with the bootstrap on
  openSUSE < 11.3.
* Wed Dec 16 2009 jengelh@medozas.de
- Enable parallel building
* Tue Aug 11 2009 max@suse.de
- Fix vulnerability against SSL certificates with a zero byte in
  the common name field (wget-nullcerts.patch, bnc#528298).
* Mon Sep  1 2008 max@suse.de
- New version 1.11.4:
  * Fixed a problem in authenticating over HTTPS through a proxy.
    (Regression in 1.11 over 1.10.2.)
  * The combination of -r or -p with -O, which was disallowed in 1.11,
    has been downgraded to a warning in 1.11.2.
  * Further improvements to progress bar displays in non-English
    locales (too many spaces could be inserted, causing the display to
    scroll).
  * Successive invocations of Wget on FTP URLS, with
  - -no-remove-listing and --continue, was causing Wget to append,
    rather than replace, information in the .listing file, and thereby
    download the same files multiple times. Fixed in 1.11.2.
  * Wget 1.11 no longer allowed ".." to persist at the beginning of
    URLs, for improved conformance with RFC 3986. However, this
    behavior presents problems for some FTP setups, and so they are now
    preserved again, for FTP URLs only.
  * Downgraded -N with -O to a warning, rather than an error.
  * Fixed a crash on some systems, due to Wget casting a
    pointer-to-long to a pointer-to-time_t.
  * Fixed an issue (apparently a regression) where -O would refuse to
    download when -nc was given, even though the file didn't exist.
  * Fixed a situation where Wget could abort with --continue if the
    remote server gives a content-length of zero when the file exists
    locally with content.
* Wed Apr 30 2008 max@suse.de
- Let the resolver (/etc/gai.conf) decide whether to prefer IPv4
  or IPv6 if a host has addresses of both kinds (bnc#310224).
- Passive FTP is the default now, so we don't need to set it
  explicitly anymore.
* Wed Apr 23 2008 max@suse.de
- New version 1.11.1:
  * Migration to the GPLv3+ license.
  * Improvements to the HTTP password authentication code, bringing
    it a little closer to RFC compliance (more is needed).
  * Basic support for respecting filenames specified via
    `Content-Disposition' headers (turned on with --content-disposition,
    but please read the documentation).
  * An --ignore-case option to make wildcard- and suffix-matching
    case-sensitive.
  * Progress bar now displays correctly in non-English locales (and a
    related assertion failure was fixed).
  * Added option --auth-no-challenge, to support broken pre-1.11
    authentication-before-server-challenge, which turns out to still
    be useful for some limited cases.
  * Documentation of accept/reject lists in the manual's "Types of
    Files" section now explains various aspects of their behavior that
    may be surprising, and notes that they may change in the future.
  * Documentation of --no-parents now explains how a trailing slash,
    or lack thereof, in the specified URL, will affect behavior.
- Purged lots of obsolete patches and cleaned up the spec file.
* Sun Feb 24 2008 crrodriguez@suse.de
- make use of find_lang macro
* Wed Mar 28 2007 max@suse.de
- Fixes a null pointer dereference (#231063, CVE-2006-6719)
* Thu Jun 22 2006 max@suse.de
- Removed the unneeded fix for CAN-2004-1487
  (bugs #179369 and #185214).
- Filter escape responses from the HTTP server (CAN-2004-1488,
  bug #185265).
* Wed Feb  1 2006 max@suse.de
- Fixed (hacked) restart of interrupted FTP transactions (#144410).
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Mon Jan 16 2006 mmj@suse.de
- Compile with -fstack-protector
* Fri Oct 14 2005 mmj@suse.de
- Update to wget 1.10.2
* Mon Sep 19 2005 mmj@suse.de
- Fix strict aliasing issues
* Tue Aug 30 2005 mmj@suse.de
- Update to wget-1.10.1 which is a bugfix release [#113682]
* Mon Jun 13 2005 mmj@suse.de
- Update to wget-1.10 which has LFS and non-experimental IPv6,
  among many other improvements and bugfixes
* Tue Apr 26 2005 mmj@suse.de
- Fix the way fnmatch matches [#75791]
* Fri Apr  8 2005 mmj@suse.de
- Add sanitizing URLs patch
- Add other patches
* Thu Mar 31 2005 mmj@suse.de
- Don't double UTF-8 encode german messages [#74544]
* Fri Feb 11 2005 mmj@suse.de
- Roll back to wget-1.9.1 since the wget tree with LFS support is
  too buggy. We rather want a functioning wget. [#47965]
* Mon Jan 31 2005 ro@suse.de
- texi2html changed behaviour, adapt filelist
* Thu Dec  2 2004 mmj@suse.de
- Update to 20041113 wget-LFS snapshot
- Fix NULL pointer assertion [#48748]
* Mon Nov 15 2004 mmj@suse.de
- Use another version of the fix below
* Sun Nov 14 2004 mmj@suse.de
- Add fix for using proxies [#47965]
* Mon Oct 18 2004 mmj@suse.de
- locale no should correctly be nb so rename po/no* to po/nb*
* Mon Sep 27 2004 mmj@suse.de
- Use LFS patch from Leonid Petrov [#37967] [#45084]
* Mon Jun 28 2004 mmj@suse.de
- Fix what appears to be a copy/paste error in the dual-family
  IPv4+IPv6 patch [#42503].
* Thu Apr  1 2004 mmj@suse.de
- Enable download of files > 2 GB [#37967]
- Remove old crufty comments
* Fri Feb 20 2004 pth@suse.de
- Correctly set the charset for de.po to utf-8. Fixes #34708.
* Sun Feb  1 2004 mmj@suse.de
- Update to 1.9.1 which is a bugfix release
* Sat Jan 10 2004 adrian@suse.de
- build as user
* Tue Oct 28 2003 mmj@suse.de
- Add patch for dual-family IPv4+IPv6 support from Ari Edelkind
* Mon Oct 27 2003 mmj@suse.de
- Update to version 1.9 and remove patches, which was included
  upstream. 1.9 news:
  o specify what POST method be used for HTTP
  o IPv6 support is available, although it's still experimental
  o The `--timeout' option now also affects DNS lookup and
    establishing the TCP connection
  o Download speed shown by the progress bar is based on the data
    recently read, rather than the average speed of the entire
    download
  o It is now possible to connect to FTP servers through FWTK
    firewalls
  o The new option `--retry-connrefused' makes Wget retry
    downloads even in the face of refused connections
  o The new option `--dns-cache=off' may be used to prevent Wget
    from caching DNS lookups
  o Wget no longer escapes characters in local file names based
    on whether they're appropriate in URLs
  o Handling of HTML comments has been dumbed down to conform to
    what users expect and other browsers do: instead of being
    treated as SGML declaration, a comment is terminated at the
    first occurrence of "-->"
  o Wget now correctly handles relative URIs that begin with "//"
  o Boolean options in `.wgetrc' and on the command line now
    accept values "yes" and "no" along with the traditional "on"
    and "off"
  o It is now possible to specify decimal values for timeouts,
    waiting periods, and download rate.
* Tue Jul 15 2003 pthomas@suse.de
- Add security fix to unconditionally terminate the filename
  in url.c(compose_file_name).
* Thu Apr 24 2003 ro@suse.de
- fix install_info --delete call and move from preun to postun
* Tue Apr  1 2003 schwab@suse.de
- Define _GNU_SOURCE to fix missing declarations.
* Thu Mar  6 2003 ro@suse.de
- fix build with current autoconf
* Thu Mar  6 2003 pthomas@suse.de
- Add missing change log entry.
* Wed Mar  5 2003 pthomas@suse.de
- Add security fix that makes wget check for '..' and '/' in
  file names.
* Wed Feb 12 2003 kukuk@suse.de
- Remove ps and pdf documenation, info, man and html are enough.
  [Bug #23592]
* Tue Feb 11 2003 mmj@suse.de
- Use %%install_info macro [#23468]
- Don't remove $RPM_BUILD_ROOT without checking it's not "/"
* Thu Oct 24 2002 pthomas@suse.de
- Change wgetrc to make wget use passive_ftp per default.
* Wed Aug  7 2002 mmj@suse.de
- Update to 1.8.2 which is a bugfix release.
* Wed Jul 10 2002 okir@suse.de
- added patch for IPv6 support
* Tue May 14 2002 meissner@suse.de
- replaced assert msecs>=0 by if (msecs<0) msecs=0. (stupid assert)
* Thu Jan 31 2002 ro@suse.de
- changed neededforbuild <libpng> to <libpng-devel-packages>
* Mon Jan 14 2002 bk@suse.de
- marked wgetrc as noreplace, format is compatible to older versions
* Mon Jan  7 2002 pthomas@suse.de
- Upgrade to 1.8.1
* Thu Dec 13 2001 pthomas@suse.de
- Upgrade to 1.8
- Regenerate pdf_doc.diff
- Drop ppc specific patch as it's not needed anymore.
- Install all HTML pages and not only the table of contents.
- Pass DESTDIR on from the toplevel Makefile.
* Mon Aug 20 2001 olh@suse.de
- add wget-1.7.ppc.diff to fix segfault on ppc
* Fri Jun  8 2001 pthomas@suse.de
- Upgrade to 1.7.
- Add a target to doc/Makefile to build a PDF version of the
  documentation.
- Compile with SSL support (for HTTPS).
* Fri May 25 2001 bjacke@suse.de
- apply and enable IPv6 patch
- add Debian's manpage
* Wed May  9 2001 mfabian@suse.de
- bzip2 sources
* Fri Mar 30 2001 pthomas@suse.de
- Apply my patch accepted for wget 1.7 that replaces ctype.h
  with safe-ctype.h, a locale independent version of ctype.h
  taken from libiberty. This makes setting LC_CTYPE safe.
* Thu Mar  8 2001 ke@suse.de
- Build and install a printable manual (PDF).
* Thu Mar  1 2001 pthomas@suse.de
- Set LC_CTYPE along with LC_MESSAGES to correctly display
  messages in locales other then C/POSIX.
* Wed Feb 14 2001 schwab@suse.de
- Fix large file support (#2647).
* Mon Jan 22 2001 ke@suse.de
- Update to version 1.6.
- wget.spec: Use proper rpm macros.
- Add README.SuSE
- Drop security patch (cf. 1999-02-09 and README.SuSE); not needed any
  longer.
- Lost large file support (cf. README.SuSE); reopen #2647.
* Fri Jun  9 2000 schwab@suse.de
- Change all values that count bytes from long to unsigned long (#2647).
* Sun Feb 20 2000 ke@suse.de
- General spec file cleanup:
- add group tag.
- use various macros (%%{version}, %%{_infodir}).
- ./configure -> %%build.
* Sat Oct  2 1999 ke@suse.de
- Add more PO files from
  http://www.iro.umontreal.ca/~pinard/po/HTML/domain-wget.html.
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Tue Feb  9 1999 ke@suse.de
- Security fix (proposed by marc).
* Sun Jan 17 1999 ke@suse.de
- apply patch (new de.po).
- fix BuildRoot.
* Thu Sep 24 1998 ke@suse.de
- Update: wget-1.5.3 (bug fix release).
* Fri Jun 26 1998 ke@suse.de
- Update: wget-1.5.2 (bug fix release).
- Make BuildRoot work.
* Tue May 12 1998 ke@suse.de
- update: wget-1.5.1 (bug fix release).
* Fri Apr 24 1998 ke@suse.de
- enable NLS.
* Thu Apr 23 1998 ke@suse.de
- update: wget-1.5.0.
* Sat Jun 21 1997 ke@suse.de
  * patch from Hrvoje Niksic to prevent crashes if you are using
  proxy authorization.
* Mon May 19 1997 ke@suse.de
  * new package: wget-1.4.5
