#
# spec file for package systemd-rpm-macros
#
# Copyright (c) 2020 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


Name:           systemd-rpm-macros
Version:        16
Release:        150000.7.42.1
Summary:        RPM macros for systemd
License:        LGPL-2.1+
Group:          Development/Tools/Building
Url:            http://en.opensuse.org/openSUSE:Systemd_packaging_guidelines
Source0:        macros.systemd
Requires:       coreutils
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch
#!BuildIgnore:  util-linux
#!BuildIgnore:  %{name}

# We need our own definition of %{_unitdir}.
%{?load:%{S:0}}

%description
Starting with openSUSE 12.1, several RPM macros must be used to package systemd
services files. This package provides these macros.

%prep

%build

%install
install -Dm644 %{S:0} %{buildroot}%{_rpmconfigdir}/macros.d/macros.systemd
mkdir -p %{buildroot}%{_unitdir}

%files
%defattr(-,root,root)
%{_rpmconfigdir}/macros.d/macros.systemd
%dir %{_unitdir}

%changelog
* Tue Jul  8 2025 fbui@suse.com
- Bump version to 16
* Tue Jul  8 2025 fbui@suse.com
- Introduce %%udev_trigger_with_reload() for packages that need to trigger events
  in theirs scriplets. The new macro automatically triggers a reload of the udev
  rule files as this step is often overlooked by packages (bsc#1237143).
* Wed Feb 21 2024 fbui@suse.com
- Bump version to 15
* Wed Feb 21 2024 fbui@suse.com
- Order packages that requires systemd after systemd-sysvcompat when this part
  of the transaction (bsc#1217964)
  systemd-sysvcompat has been introduced recently and contains the compatibility
  scripts used to support SysV init scripts. Make sure that the packages ordered
  after systemd are also ordered after systemd-sysvcompat so theirs rpm
  scriptlets can still rely on the compat scripts.
  On distributions where systemd-sysvcompat doesn't exist, the new ordering
  constraint should be a nop.
* Fri Sep 29 2023 fbui@suse.com
- Bump version to 14
* Fri Sep 29 2023 fbui@suse.com
- Switch to `systemd-hwdb` tool when updating the HW database. It's been
  introduced in systemd v219 and replaces the deprecated command `udevadm hwdb`.
* Wed May 10 2023 fbui@suse.com
- Bump version to 13
* Wed May 10 2023 fbui@suse.com
- Fix %%sysctl_apply() and %%binfmt_apply() so they are disabled when called from
  a chroot (bsc#1211272)
* Thu Feb 16 2023 fbui@suse.com
- Bump version to 12
* Thu Feb 16 2023 fbui@suse.com
- Don't emit a warning when the flag file in /var/lib/systemd/migrated/ is not
  present as it's expected (bsc#1208079).
* Thu Mar  3 2022 fbui@suse.com
- Bump version to 11
* Thu Mar  3 2022 fbui@suse.com
- Make %%_modprobedir point to /lib/modprobe.d (bsc#1196275 bsc#1196406)
  Until SLE15-SP3:QU2, /usr/lib/modprobe.d path was not supported by kmod and
  since SLE15-SP4 /etc/modprobe.d/README has references to /lib/modprobe.d...
* Wed Jan 19 2022 fbui@suse.com
- Bump version to 10
* Wed Jan 19 2022 fbui@suse.com
- %%sysusers_create_inline was wrongly marked as deprecated
- %%sysusers_create can be useful in certain cases and won't go away until we'll
  move to file triggers. So don't mark it as deprecated too
* Wed Nov 17 2021 fbui@suse.com
- Bump version to 9
* Wed Nov 17 2021 fbui@suse.com
- Introduce %%_systemd_util_dir
  It's a backport of upstream commit 3bc66bfa0136e370a8f7b06c3b69a52f5636ef82.
* Fri Jul 16 2021 fbui@suse.com
- Bump to version 8
* Fri Jul 16 2021 fbui@suse.com
- Make use of "Suggests:" in %%systemd_ordering
  Until libzypp supports "OrderWithRequires:", we need to specify a
  similar ordering constraint that can be understood by the dep solver
  as well. Hence the use of "Suggests:" in %%systemd_ordering
  (workaround for bsc#1187332).
* Fri Jul 16 2021 fbui@suse.com
- Introduce %%sysusers_create_package
  %%sysusers_create and %%sysusers_create_inline are now deprecated and
  the new macro should be used instead.
  Upstream commit 07a7d4a0040d221ff09e527e91c112b4ffab1dba.
* Tue May 25 2021 fbui@suse.com
- %%sysusers_create_inline: use here-docs instead of echo (bsc#1186282)
  Upstream commit dd2490ae12ad1e1795ecbf8f8944b950da9c8d06.
* Fri Mar  5 2021 fbui@suse.com
- Bump to version 7
* Fri Mar  5 2021 fbui@suse.com
- Remove confusing --user before --global in %%systemd_user_preun
  It's actually a backport of upstream commit
  28d36da64a7a23a55e8d0a139f2620384fd058b3
- Update a few comments
* Fri Mar  5 2021 fbui@suse.com
- Don't pass -f to rm to make sure that rm failures will be logged
  But also make sure to not abort the scriptlet prematurely if rm
  fails.
* Fri Mar  5 2021 alarrosa@suse.com
- Add a %%systemd_user_pre macro (boo#1183051, boo#1183012)
  It creates a /run/systemd/rpm/needs-user-preset/$service file for
  each new service being installed so %%systemd_user_post can call
  `systemctl --global preset $service` properly for newly installed
  user services (even when it's introduced via a package update).
* Fri Mar  5 2021 alarrosa@suse.com
- Fix %%systemd_user_post (boo#1183051, boo#1182661)
  The --global parameter was handled as if it was another service name
  so %%systemd_user_post wasn't working properly. Replace
  %%systemd_user_post with the code from %%service_add_post it was being
  expanded to but correctly passing --global to systemctl.
* Fri Mar  5 2021 fbui@suse.com
- Tabify %%service_del_postun_without_restart
  To make it consistent with the other macros.
  No functional change.
* Fri Feb 12 2021 fbui@suse.com
- Bump to version 6
* Fri Feb 12 2021 fbui@suse.com
- Make upstream %%systemd_{pre,post,preun,postun} aliases to their SUSE
  counterparts
  Packagers can now choose to use the upstream or the SUSE variants
  indifferently. For consistency the SUSE variants should be preferred
  since almost all SUSE packages already use them but the upstream
  versions might be usefull in certain cases where packages need to
  support multiple distros based on RPM.
* Fri Feb 12 2021 fbui@suse.com
- Improve the logic used to apply the presets (bsc#1177039)
  Before presests were applied at a) package installation b) new units
  introduced via a package update (but after making sure that it was
  not a SysV initscript being converted).
  The problem is that a) didn't handle package a renaming or split
  properly since the package with the new name is installed rather
  being updated and therefore the presets were applied even if they
  were already with the old name.
  We now cover this case (and the other ones) by applying presets only
  if the units are new and the services are not being migrated. This
  regardless of whether this happens during an install or an update.
* Tue Nov 24 2020 fbui@suse.com
- Bump to version 5 (bsc#1179020)
  This milestone makes systemd rpm macros mostly identical between
  SLE12-SP2 and SLE15.
* Tue Nov 24 2020 fbui@suse.com
- Rename the tag file used to detect when presets need to be applied
  Rather than placing these tags directly under /run, let's place them
  under /run/systemd/rpm. This also has the benefit to make the
  workaround for bsc#1059627 no more needed.
* Fri Nov 13 2020 fbui@suse.com
- Bump version to 4.2
* Fri Nov 13 2020 fbui@suse.com
- Deprecate '-f'/'-n' options
  When used with %%service_del_preun, support for these options will be
  dropped as DISABLE_STOP_ON_REMOVAL support will be removed on the
  next version of SLE (jsc#SLE-8968)
  When used with %%service_del_postun, they should be replaced with
  their counterpart
  %%service_del_postun_with_restart/%%service_del_postun_without_restart
* Fri Nov 13 2020 fbui@suse.com
- Introduce %%service_del_postun_with_restart()
  It's the counterpart of %%service_del_postun_without_restart() and
  replaces the '-f' option of %%service_del_postun().
* Fri Nov 13 2020 fbui@suse.com
- Dont apply presets when migrating from a disabled initscript (bsc#1178481)
* Fri Nov 13 2020 fbui@suse.com
- Test for the presence of systemctl only once in %%service_add_{post,pre}
  No functional changes.
* Fri Nov 13 2020 fbui@suse.com
- Make rpmbuild load our own macros.systemd to import %%{%%_unitdir} properly
  Ideally we should also own other %%{_*dir} paths...
- Stop owning /usr/lib/systemd directory as no package other than
  systemd is supposed to put files there.
* Fri Sep 25 2020 fbui@suse.com
- Bump version to 4.1
* Fri Sep 25 2020 fbui@suse.com
- Backport missing macros of directory paths from upstream
  + %%_environmentdir
  + %%_modulesloaddir
  + %%_modprobedir
* Fri Sep 25 2020 fbui@suse.com
- Make sure %%_restart_on_update_never and %%_stop_on_removal_never
  don't expand to the empty string (bsc#1176932)
  Otherwise sequences like the following code:
    if [ ... ]; then
    %%_restart_on_update_never
    fi
  would result in the following incorrect shell syntax:
    if [ ... ]; then
    fi
* Fri Sep 11 2020 fbui@suse.com
- Introduce %%service_del_postun_without_restart (bsc#1173034)
  This new interface is preferred over the use of %%service_del_postun
  with '-f' and '-n' options. It's been in Factory since a year and a
  half.
* Wed Feb 14 2018 fbui@suse.com
- Fix %%systemd_post(): it's never called during package removal
  Also make it useful by restoring its original implementation.
* Mon Feb 12 2018 fbui@suse.com
- Import more definitions from upstream (v237)
* Mon Jan 22 2018 dimstar@opensuse.org
- Fix system_user_post macro for usage with RPM 4.14, backport from
  https://github.com/systemd/systemd/commit/e67ba783.
* Thu Dec 14 2017 fbui@suse.com
- Move macros.systemd in /usr/lib/rpm
  The file is not supposed to be customized by the user.
* Wed Dec 13 2017 fbui@suse.com
- Make %%systemd_add_pre() more similar to %%systemd_add_post()
  The main advantage is that we pass only one argument to
  systemd-sysv-convert script. The later can now be improved/rewritten
  to handle only one argument and return a useful exit status.
* Wed Dec 13 2017 fbui@suse.com
- Make sure to apply presets if packages start shipping units during upgrades (bsc#1071543)
  If a package started shipping units during upgrade only sysv
  migration was done. However if the package didn't ship any sysv
  scripts before no presets were applied.
  Now during upgrades, preset are always applied (still only during
  the first time the units are installed) then followed by the sysv
  migration machinery.
  The downside of this is that migrated services can have symlinks in
  both runlevel.target.wants/ (created by the sysv migration) and in
  the directory specified by the [Install] sections (created by
  "systemctl preset")...
  The whole thing should be rewritten.
* Fri Dec  1 2017 fbui@suse.com
- Make sure to clean up "new-in-upgrade" tag file (bsc#1059627)
  The tag file might have been incorrectly left by a preceding update.
* Wed Nov 22 2017 fbui@suse.com
- Restore previous changes
* Fri Nov 17 2017 fbui@suse.com
- Revert previous changes
  Also added reasons why the previous changes would be needed.
* Fri Nov 17 2017 kukuk@suse.de
- Don't execute systemd-tmpfiles if we run in transactional update
  mode
  If you do transactional updates, it doesn't make any sense to
  execute the tmpfiles. They will only create a lot of directories,
  files or symlinks in empty directories without any use and later
  hidden under the real mount points. With transactional updates, you
  should do such things always during the boot phase, as designed by
  systemd (and like Fedora and RHEL doing, but in their use case it's
  in my opinion a bug).
* Thu Nov  2 2017 fbui@suse.com
- Remove a useless test in %%service_add_pre()
  The test was placed where the condition '[ "$FIRST_ARG" -gt 1 ]' was
  always true.
* Fri Jun  2 2017 dimstar@opensuse.org
- BuildIgnore systemd-rpm-macros: a small cycle that can be
  avoided. system-rpm-macros is being pulled in by rpm-build as
  conveniance to the packagers.
* Fri Jun  2 2017 fbui@suse.com
- Reference bsc#956849 to please the new OBS 'sanity' check (bsc#1041386)
  %%tmpfiles_create is already part of the version shipped by Factory
  so there's nothing to do here execpt mentioning (bsc#956849).
* Fri Mar 10 2017 fbui@suse.com
- Kill preset macros
  The last users have been fixed so these macros are no more used by
  any package.
  The introduction of them was a bad idea and only the branding preset
  package is still using a similar mechanism but at least it's now
  self contained in this package. Also the package calls now a shell
  script instead of rpm macros.
  Upstream is working on making this completely obsolete so the preset
  branding package could be cleaned up for good.
* Wed Jan 11 2017 jengelh@inai.de
- RPM group fix
* Fri Jun  3 2016 Thomas.Blume@suse.com
- %%service_add_post() suppress daemon-reload when in installation
  system (bsc#982343)
* Thu Mar  3 2016 werner@suse.de
- Allow the packagers to specify the options -f and -n on the
  macros %%service_del_preun(), %%service_del_postun(), %%systemd_post(),
  and %%systemd_preun() (boo#968405)
* Sat Feb 27 2016 dimstar@opensuse.org
- Also honor DISABLE_STOP_ON_REMOVAL and DISABLE_RESTART_ON_UPDATE
  when specified by a package directly in the .spec file. Some
  package know that a restart of their service is fatal
  (boo#968405).
* Fri Nov 20 2015 werner@suse.de
- Support of DISABLE_STOP_ON_REMOVAL and DISABLE_RESTART_ON_UPDATE
  from /etc/sysconfig/service (bsc#955996)
* Fri Sep 18 2015 sbrabec@suse.com
- Skip %%systemd_preset_* during the clean installation to prevent
  presetting of all services (boo#946216).
* Tue Aug  4 2015 sbrabec@suse.com
- Add %%systemd_preset_pre and %%systemd_preset_posttrans that will
  do one shot presetting of all services with changed system
  preset. It makes possible to to fix bad default service state
  (bnc#900935#c46, FATE#318949, FATE#317727, bnc#921075).
- Increment version to 3.
* Mon Jun 15 2015 jengelh@inai.de
- Check for presence/executability of systemd programs before
  executing them, and do not suppress warnings/errors resulting
  from them.
* Fri Jan  9 2015 jengelh@inai.de
- Update with new macros from systemd 218
- Remove empty sections from specfile
* Tue Nov 18 2014 werner@suse.de
- Mark /etc/rpm/macros.systemd as configuration file
* Tue Nov 18 2014 werner@suse.de
- Apply then delete patch systemd-daemon-reload-before-service-restart.patch
- Add orignal systemd macros as well (boo#807164)
* Wed Oct 15 2014 thomas.blume@suse.com
- make systemd aware of changed unit file content after update
  add systemd-daemon-reload-before-service-restart.patch
* Thu Mar 27 2014 werner@suse.de
- Add a %%_ntpunitsdir macro
* Thu Mar 27 2014 fcrozat@suse.com
- Add support to not restart services if running in YaST2 or
  if DISABLE_RESTART_ON_UPDATE is set to yes [bnc#858429]
* Fri Feb 28 2014 werner@suse.de
- Require coreutils as rm and touch are used
* Fri Feb  7 2014 werner@suse.de
- Make systemd rpm macros package a separate to avoid rebuild of
  the full package tree if systemd package change
* Thu Jul  4 2013 fcrozat@suse.com
- Resync with systemd v205 macros
* Mon Jun 17 2013 mhrusecky@suse.com
- New package with systemd rpm macros to avoid unnecessary build time
  dependencies
