#
# spec file for package shadow
#
# Copyright (c) 2021 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%if ! %{defined _distconfdir}
  %define _distconfdir %{_sysconfdir}
%else
  %define no_config 1
%endif

Name:           shadow
Version:        4.8.1
Release:        150600.17.9.1
Summary:        Utilities to Manage User and Group Accounts
License:        BSD-3-Clause AND GPL-2.0-or-later
Group:          System/Base
URL:            https://github.com/shadow-maint/shadow
Source:         https://github.com/shadow-maint/shadow/releases/download/%{version}/shadow-%{version}.tar.xz
Source1:        pamd.tar.bz2
Source2:        README.changes-pwdutils
Source3:        useradd.local
Source4:        userdel-pre.local
Source5:        userdel-post.local
Source6:        shadow.service
Source7:        shadow.timer
Source42:       https://github.com/shadow-maint/shadow/releases/download/%{version}/shadow-%{version}.tar.xz.asc
Source43:       %{name}.keyring
# SOURCE-FEATURE-SUSE shadow-login_defs-check.sh sbrabec@suse.com -- Supplementary script that verifies coverage of variables in shadow-login_defs-unused-by-pam.patch and other patches.
Source44:       shadow-login_defs-check.sh
# PATCH-FIX-SUSE shadow-login_defs-unused-by-pam.patch kukuk@suse.com -- Remove variables that have no use with PAM.
Patch0:         shadow-login_defs-unused-by-pam.patch
# PATCH-FEATURE-SUSE userdel-script.patch kukuk@suse.com -- Add support for USERDEL_PRECMD and USERDEL_POSTCMD.
Patch1:         userdel-script.patch
# PATCH-FEATURE-SUSE useradd-script.patch kukuk@suse.com -- Add support for USERADD_CMD.
Patch2:         useradd-script.patch
# PATCH-FEATURE-SUSE chkname-regex.patch kukuk@suse.com -- Username restriction by regex.
Patch3:         chkname-regex.patch
# PATCH-FEATURE-SUSE useradd-default.patch kukuk@suse.com -- Change useradd defaults group to 1000.
Patch4:         useradd-default.patch
# PATCH-FEATURE-SUSE shadow-util-linux.patch sbrabec@suse.com -- Add support for util-linux specific variables, delete shadow login, su runuser specific.
Patch5:         shadow-util-linux.patch
# PATCH-FEATURE-FEDORA shadow-4.1.5.1-userdel-helpfix.patch christian.brauner@mailbox.org -- Give a hint about what happens when you force the removal of a user.
Patch6:         shadow-4.1.5.1-userdel-helpfix.patch
# PATCH-FIX-FEDORA shadow-4.1.5.1-logmsg.patch kukuk@suse.com -- Fix error message.
Patch7:         shadow-4.1.5.1-logmsg.patch
# PATCH-FEATURE-SUSE shadow-login_defs-comments.patch kukuk@suse.com -- Adjust login.defs comments.
Patch13:        shadow-login_defs-comments.patch
# PATCH-FEATURE-SUSE shadow-login_defs-suse.patch kukuk@suse.com -- Customize login.defs.
Patch14:        shadow-login_defs-suse.patch
# PATCH-FEATURE-SUSE Copy also skeleton files from /usr/etc/skel (boo#1173321)
Patch15:        useradd-userkeleton.patch
# PATCH-FIX-SUSE useradd audit event user id field cannot be interpreted  (boo#1205502)
Patch16:        shadow-4.8.1-AUDIT_NO_ID.patch
# PATCH-FIX-SUSE disable_new_audit_function.patch adam.majer@suse.de -- Disable newer libaudit functionality for older distributions.
Patch20:        disable_new_audit_function.patch
Patch21:        shadow-CVE-2023-29383.patch
# PATCH-FEATURE-UPSTREAM mvetter@suse.com -- Add --prefix support to passwd, chpasswd, chage (bsc#1206627)
Patch22:        shadow-4.8.1-add-prefix-passwd-chpasswd-chage.patch
# PATCH-FIX-UPSTREAM mvetter@suse.com -- Change lock mechanism to file locking (bsc#1213189)
Patch23:        shadow-4.8.1-lock-mechanism.patch
# PATCH-FIX-UPSTREAM mvetter@suse.com -- Fix potential password leak (bsc#1214806)
Patch24:        shadow-CVE-2023-4641.patch
# PATCH-FIX-UPSTREAM mvetter@suse.com -- Fix TOCTOU race conditions (bsc#916845) (bsc#1228770)
Patch25:        shadow-CVE-2013-4235.patch
# PATCH-FIX-UPSTREAM gus.kenion@suse.com -- Fix UID warnings in useradd (bsc#1230972)
Patch26:        shadow-bsc1230972-useradd-warning.patch
BuildRequires:  audit-devel > 2.3
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libacl-devel
BuildRequires:  libattr-devel
BuildRequires:  libeconf-devel
BuildRequires:  libselinux-devel
BuildRequires:  libsemanage-devel
BuildRequires:  libtool
BuildRequires:  pam-devel
BuildRequires:  xz
Requires(pre):  group(root)
Requires(pre):  group(shadow)
Requires(pre):  permissions
Requires(pre):  user(root)
Provides:       pwdutils = 3.2.20
Obsoletes:      pwdutils <= 3.2.19
Requires:       login_defs >= %{version}
Provides:       useradd_or_adduser_dep

%description
This package includes the necessary programs for converting plain
password files to the shadow password format and to manage user and
group accounts.

%package -n login_defs
Summary:        login.defs configuration file
Group:          System/Base
BuildArch:      noarch
# Virtual provides for supported variables in login.defs.
# It prevents references to unknown variables.
# Upgrade them only if shadow-util-linux.patch or
# encryption_method_nis.patch has to be ported!
# Call shadow-login_defs-check.sh before!
Provides:       login_defs-support-for-pam = 1.3.1
Provides:       login_defs-support-for-util-linux = 2.37

%description -n login_defs
This package contains the default login.defs configuration file
as used by util-linux, pam and shadow.

%prep
%setup -q -a 1
%patch0
%patch1
%patch2
%patch3
%patch4
%patch5
%patch6
%patch7
%patch13
%patch14
%patch15
%patch16 -p1
%if 0%{?suse_version} < 1330
%patch20 -p1
%endif
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1

iconv -f ISO88591 -t utf-8  doc/HOWTO > doc/HOWTO.utf8
mv -v doc/HOWTO.utf8 doc/HOWTO

%build
export CFLAGS="%{optflags} -fpie"
export LDFLAGS="-pie"

autoreconf -fvi
%configure \
  --disable-shadowgrp \
  --enable-account-tools-setuid \
  --with-audit \
  --with-libpam \
  --with-sha-crypt \
  --with-acl \
  --with-attr \
  --with-nscd \
  --with-selinux \
  --without-libcrack \
  --disable-shared \
  --with-group-name-max-length=32 \
  --enable-vendordir=%{_distconfdir}
make %{?_smp_mflags} V=1

%install
cp %{SOURCE2} .
%make_install gnulocaledir=%{buildroot}/%{_datadir}/locale MKINSTALLDIRS=`pwd`/mkinstalldirs

# install useradd.local, userdel.local, ...
install -m 0755 %{SOURCE3} %{buildroot}/%{_sbindir}/
install -m 0755 %{SOURCE4} %{buildroot}/%{_sbindir}/
install -m 0755 %{SOURCE5} %{buildroot}/%{_sbindir}/
install -Dm644 %{SOURCE6} %{buildroot}%{_unitdir}/shadow.service
install -Dm644 %{SOURCE7} %{buildroot}%{_unitdir}/shadow.timer

# add empty /etc/sub{u,g}id files
touch %{buildroot}/%{_sysconfdir}/subuid
touch %{buildroot}/%{_sysconfdir}/subgid

# Remove binaries we don't use.
rm %{buildroot}/%{_bindir}/groups
rm %{buildroot}/%{_mandir}/man1/groups.*
rm %{buildroot}/%{_mandir}/*/man1/groups.*

rm %{buildroot}/%{_sbindir}/grpconv
rm %{buildroot}/%{_mandir}/man8/grpconv.*
rm %{buildroot}/%{_mandir}/*/man8/grpconv.*
rm %{buildroot}/%{_sbindir}/grpunconv
rm %{buildroot}/%{_mandir}/man8/grpunconv.*
rm %{buildroot}/%{_mandir}/*/man8/grpunconv.*

rm %{buildroot}/%{_sbindir}/groupmems
rm %{buildroot}/%{_mandir}/man8/groupmems.*
rm %{buildroot}/%{_mandir}/*/man8/groupmems.*
rm %{buildroot}%{_sysconfdir}/pam.d/groupmems

rm %{buildroot}/%{_bindir}/login
rm %{buildroot}/%{_mandir}/man1/login.*
rm %{buildroot}/%{_mandir}/*/man1/login.*
rm %{buildroot}%{_sysconfdir}/pam.d/login

rm %{buildroot}/%{_bindir}/su
rm %{buildroot}/%{_mandir}/man1/su.*
rm %{buildroot}/%{_mandir}/*/man1/su.*
rm %{buildroot}/%{_mandir}/man5/suauth.*
rm %{buildroot}/%{_mandir}/*/man5/suauth.*
rm %{buildroot}%{_sysconfdir}/pam.d/su

rm %{buildroot}/%{_bindir}/faillog
rm %{buildroot}/%{_mandir}/man5/faillog.*
rm %{buildroot}/%{_mandir}/*/man5/faillog.*
rm %{buildroot}/%{_mandir}/man8/faillog.*
rm %{buildroot}/%{_mandir}/*/man8/faillog.*

rm %{buildroot}/%{_sbindir}/logoutd
rm %{buildroot}/%{_mandir}/man8/logoutd.*
rm %{buildroot}/%{_mandir}/*/man8/logoutd.*
rm %{buildroot}/%{_sbindir}/nologin
rm %{buildroot}/%{_mandir}/man8/nologin.*
rm %{buildroot}/%{_mandir}/*/man8/nologin.*

rm %{buildroot}/%{_sbindir}/chgpasswd
rm %{buildroot}/%{_mandir}/man8/chgpasswd.*
rm %{buildroot}/%{_mandir}/*/man8/chgpasswd.*
rm %{buildroot}%{_sysconfdir}/pam.d/chgpasswd

rm %{buildroot}/%{_mandir}/man3/getspnam.*
rm %{buildroot}/%{_mandir}/*/man3/getspnam.*
rm %{buildroot}/%{_mandir}/man5/gshadow.5*
rm %{buildroot}/%{_mandir}/*/man5/gshadow.5*
rm %{buildroot}/%{_mandir}/man5/passwd.5*
rm %{buildroot}/%{_mandir}/*/man5/passwd.5*

rm -rf %{buildroot}%{_mandir}/{??,??_??}

# Move /etc to /usr/etc
if [ ! -d %{buildroot}%{_distconfdir} ]; then
    mkdir -p %{buildroot}%{_distconfdir}
    mv %{buildroot}%{_sysconfdir}/{login.defs,pam.d} %{buildroot}%{_distconfdir}
fi

%find_lang shadow

%pre
%service_add_pre shadow.service shadow.timer
for i in pam.d/chage pam.d/chfn pam.d/chpasswd pam.d/chsh pam.d/groupadd pam.d/groupdel pam.d/groupmod pam.d/newusers pam.d/passwd pam.d/useradd pam.d/userdel pam.d/usermod; do
  test -f /etc/${i}.rpmsave && mv -v /etc/${i}.rpmsave /etc/${i}.rpmsave.old ||:
done

%pre -n login_defs
test -f /etc/login.defs.rpmsave && mv -v /etc/login.defs.rpmsave /etc/login.defs.rpmsave.old ||:

%post
%set_permissions %{_bindir}/chage
%set_permissions %{_bindir}/chfn
%set_permissions %{_bindir}/chsh
%set_permissions %{_bindir}/expiry
%set_permissions %{_bindir}/gpasswd
%set_permissions %{_bindir}/newgrp
%set_permissions %{_bindir}/passwd
%set_permissions %{_bindir}/newgidmap
%set_permissions %{_bindir}/newuidmap

%service_add_post shadow.service shadow.timer

%verifyscript
%verify_permissions %{_bindir}/chage
%verify_permissions %{_bindir}/chfn
%verify_permissions %{_bindir}/chsh
%verify_permissions %{_bindir}/expiry
%verify_permissions %{_bindir}/gpasswd
%verify_permissions %{_bindir}/newgrp
%verify_permissions %{_bindir}/passwd
%verify_permissions %{_bindir}/newgidmap
%verify_permissions %{_bindir}/newuidmap

%preun
%service_del_preun shadow.service shadow.timer

%postun
%service_del_postun shadow.service shadow.timer

%posttrans
%if %{defined no_config}
# Migration to /usr/etc
for i in pam.d/chage pam.d/chfn pam.d/chpasswd pam.d/chsh pam.d/groupadd pam.d/groupdel pam.d/groupmod pam.d/newusers pam.d/passwd pam.d/useradd pam.d/userdel pam.d/usermod; do
  test -f /etc/${i}.rpmsave && mv -v /etc/${i}.rpmsave /etc/${i} ||:
done
%endif

%posttrans -n login_defs
# rpmsave file can be created by
# - change of owning package (SLE15 SP2->SP3, Leap 15.2->15.3)
# - Migration to /usr/etc (after SLE15 and Leap 15)
test -f /etc/login.defs.rpmsave && mv -v /etc/login.defs.rpmsave /etc/login.defs ||:

%files -f shadow.lang
%license COPYING
%doc NEWS doc/HOWTO README README.changes-pwdutils
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/default/useradd
%verify(not md5 size mtime) %config(noreplace) %{_sysconfdir}/subuid
%verify(not md5 size mtime) %config(noreplace) %{_sysconfdir}/subgid
%if %{defined no_config}
%{_distconfdir}/pam.d/chage
%{_distconfdir}/pam.d/chfn
%{_distconfdir}/pam.d/chsh
%{_distconfdir}/pam.d/passwd
%{_distconfdir}/pam.d/useradd
%{_distconfdir}/pam.d/chpasswd
%{_distconfdir}/pam.d/groupadd
%{_distconfdir}/pam.d/groupdel
%{_distconfdir}/pam.d/groupmod
%{_distconfdir}/pam.d/newusers
%{_distconfdir}/pam.d/useradd
%{_distconfdir}/pam.d/userdel
%{_distconfdir}/pam.d/usermod
%else
%config %{_sysconfdir}/pam.d/chage
%config %{_sysconfdir}/pam.d/chfn
%config %{_sysconfdir}/pam.d/chsh
%config %{_sysconfdir}/pam.d/passwd
%config %{_sysconfdir}/pam.d/useradd
%config %{_sysconfdir}/pam.d/chpasswd
%config %{_sysconfdir}/pam.d/groupadd
%config %{_sysconfdir}/pam.d/groupdel
%config %{_sysconfdir}/pam.d/groupmod
%config %{_sysconfdir}/pam.d/newusers
%config %{_sysconfdir}/pam.d/useradd
%config %{_sysconfdir}/pam.d/userdel
%config %{_sysconfdir}/pam.d/usermod
%endif
%verify(not mode) %attr(2755,root,shadow) %{_bindir}/chage
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/chfn
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/chsh
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/expiry
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/gpasswd
%verify(not mode) %attr(4755,root,root) %{_bindir}/newgrp
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/passwd
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/newgidmap
%verify(not mode) %attr(4755,root,shadow) %{_bindir}/newuidmap
%{_bindir}/lastlog
%{_bindir}/sg
%attr(0755,root,root) %{_sbindir}/groupadd
%attr(0755,root,root) %{_sbindir}/groupdel
%attr(0755,root,root) %{_sbindir}/groupmod
%{_sbindir}/grpck
%{_sbindir}/pwck
%attr(0755,root,root) %{_sbindir}/useradd
%attr(0755,root,root) %{_sbindir}/userdel
%attr(0755,root,root) %{_sbindir}/usermod
%{_sbindir}/pwconv
%{_sbindir}/pwunconv
%attr(0755,root,root) %{_sbindir}/chpasswd
%attr(0755,root,root) %{_sbindir}/newusers
%{_sbindir}/vipw
%{_sbindir}/vigr
%verify(not md5 size mtime) %config(noreplace) %{_sbindir}/useradd.local
%verify(not md5 size mtime) %config(noreplace) %{_sbindir}/userdel-pre.local
%verify(not md5 size mtime) %config(noreplace) %{_sbindir}/userdel-post.local
%{_mandir}/man1/chage.1%{?ext_man}
%{_mandir}/man1/chfn.1%{?ext_man}
%{_mandir}/man1/chsh.1%{?ext_man}
%{_mandir}/man1/expiry.1%{?ext_man}
%{_mandir}/man1/gpasswd.1%{?ext_man}
%{_mandir}/man1/newgrp.1%{?ext_man}
%{_mandir}/man1/passwd.1%{?ext_man}
%{_mandir}/man1/sg.1%{?ext_man}
%{_mandir}/man3/shadow.3%{?ext_man}
%{_mandir}/man5/shadow.5%{?ext_man}
%{_mandir}/man8/chpasswd.8%{?ext_man}
%{_mandir}/man8/groupadd.8%{?ext_man}
%{_mandir}/man8/groupdel.8%{?ext_man}
%{_mandir}/man8/groupmod.8%{?ext_man}
%{_mandir}/man8/grpck.8%{?ext_man}
%{_mandir}/man8/lastlog.8%{?ext_man}
%{_mandir}/man8/newusers.8%{?ext_man}
%{_mandir}/man8/pwck.8%{?ext_man}
%{_mandir}/man8/pwconv.8%{?ext_man}
%{_mandir}/man8/pwunconv.8%{?ext_man}
%{_mandir}/man8/useradd.8%{?ext_man}
%{_mandir}/man8/userdel.8%{?ext_man}
%{_mandir}/man8/usermod.8%{?ext_man}
%{_mandir}/man8/vigr.8%{?ext_man}
%{_mandir}/man8/vipw.8%{?ext_man}
%{_mandir}/man5/subuid.5%{?ext_man}
%{_mandir}/man5/subgid.5%{?ext_man}
%{_mandir}/man1/newgidmap.1%{?ext_man}
%{_mandir}/man1/newuidmap.1%{?ext_man}

%{_unitdir}/*

%files -n login_defs
%if %{defined no_config}
%attr(0644,root,root) %{_distconfdir}/login.defs
%else
%attr(0644,root,root) %config %{_sysconfdir}/login.defs
%endif
%{_mandir}/man5/login.defs.5%{?ext_man}

%changelog
* Mon Oct 14 2024 gus.kenion@suse.com
- bsc#1230972: Add useradd warnings when requested UID is outside
  the default range
- add shadow-bsc1230972-useradd-warning.patch
* Fri Aug  2 2024 mvetter@suse.com
- bsc#1228770: Fix not copying of skel files
  Update shadow-CVE-2013-4235.patch
* Mon Jul 22 2024 mvetter@suse.com
- bsc#916845 (CVE-2013-4235): Fix TOCTOU race condition
  Add shadow-CVE-2013-4235.patch
* Fri Sep  8 2023 mvetter@suse.com
- bsc#1214806 (CVE-2023-4641):
  Fix potential password leak
- Add shadow-CVE-2023-4641.patch
* Tue Jul 11 2023 mvetter@suse.com
- bsc#1213189: Change lock mechanism to file locking to prevent
  lock files after power interruptions
- Add shadow-4.8.1-lock-mechanism.patch
* Tue Jul  4 2023 mvetter@suse.com
- bsc#1206627: Add --prefix support to passwd, chpasswd and chage
  Needed for YaST
- Add shadow-4.8.1-add-prefix-passwd-chpasswd-chage.patch
* Tue Apr 18 2023 mvetter@suse.com
- bsc#1210507 (CVE-2023-29383):
  Check for control characters
- Add shadow-CVE-2023-29383.patch
* Fri Nov 18 2022 fstrba@suse.com
- Added patch:
  * shadow-4.8.1-AUDIT_NO_ID.patch
    + fix bsc#1205502: useradd audit event user id field cannot
    be interpreted
* Wed Jan 12 2022 sbrabec@suse.com
- The legacy code does not support /etc/login.defs.d used by YaST.
  Enable libeconf to read it (bsc#1192954).
* Wed Nov 17 2021 sbrabec@suse.com
- shadow-util-linux.patch:
  * Add support for LOGIN_KEEP_USERNAME from util-linux >= 2.37.
- Refresh shadow-login_defs-suse.patch.
* Thu Jan 28 2021 sbrabec@suse.com
- Do not require libeconf-devel on products without /usr/etc.
* Thu Jan 21 2021 kukuk@suse.com
- Split login.defs configuration file into own sub-package, which
  allows to install util-linux or pam on small embedded/edge
  systems or container without the need to pull in the full shadow
  suite.
* Wed Nov 11 2020 fvogt@suse.com
- Amend patches/useradd-userkeleton.patch to also write into
  existing directories and prefer files from /etc
* Wed Nov 11 2020 werner@suse.de
- Add patch useradd-userkeleton.patch to extend original C code
  of useradd to handle /usr/etc/skel (boo#1173321)
- Remove /usr/etc/skel support in useradd.local script
* Mon Nov  2 2020 werner@suse.de
- Change again useradd.local script to let it work even for system
  accounts and work together with SELinux (bsc#1178296)
- Change patch useradd-script.patch to support the four arguments
  used by the useradd.local script (bsc#1178296)
* Fri Oct  9 2020 werner@suse.de
- Add support for /usr/etc/skel to useradd.local script (boo#1173321)
* Thu Oct  8 2020 sbrabec@suse.com
- shadow-login_defs-check.sh: Fix the regexp to get a real variable
  list (boo#1164274).
* Tue Sep  8 2020 sbrabec@suse.com
- login.defs: Add support for new util-linux-2.36 login variable
  MOTD_FIRSTONLY (shadow-util-linux.patch).
- shadow-login_defs-comments.patch: Remove duplicated
  LASTLOG_UID_MAX.
- shadow-login_defs-check.sh: Update for new build system.
- shadow-util-linux.patch: Restore lost chunk: SYSLOG_SU_ENAB is
  not used in SUSE Linux.
- Refresh shadow-login_defs-suse.patch and
  shadow-login_defs-comments.patch.
* Fri May 22 2020 fvogt@suse.com
- Use pure #!/bin/sh in:
  * useradd.local
  * userdel-post.local
  * userdel-pre.local
* Fri Jan 24 2020 mvetter@suse.com
- Update to 4.8.1:
  * selinux: include stdio
  * man: don't suggest making groupmems user-writeable
  * Makefile: bail out on error in for loops
  * Adding logging of SSH_ORIGINAL_COMMAND to nologin
  * add new HOME_MODE login.defs option
  * Add tty logging to useradd
  * Useradd: make non-executable shell check only a warning
  * Update Dutch translation
  * user_busy: Do not mistake a regular user process for a namespaced one
  * Revert "Honor --sbindir and --bindir for binary installation"
- Remove shadow-4.8-shell-check.patch: included
- Remove shadow-4.8-selinux-include.patch: upstreamed
* Mon Jan 20 2020 mvetter@suse.com
- Set 0755 for chpasswd, groupadd, groupdel, groupmod, newusers,
  useradd, userdel, usermod explicitly.
* Thu Jan 16 2020 mvetter@suse.com
- bsc#1160729: Make valid shell check only a warning
  * Add shadow-4.8-shell-check.patch
* Tue Dec 17 2019 mvetter@suse.com
- Update to 4.8:
  * Initial optional bcrypt support.
  * Make build/install of 'su' optional.
  * Fix for vipw not resuming correctly when suspended
  * Sync password field descriptions in manpages
  * Check for valid shell argument in useradd
  * Allow translation of new strings through POTFILES.in
  * Migrate to itstool for translations
  * Migrate to new SELinux api
  * Support --enable-vendordir
  * pwck: Only check homedir if set and not a system user
  * Support nonstandard usernames
  * sget{pw,gr}ent: check for data at EOL
  * Add YYY-MM-DD support in chage
  * Fix failing chmod calls for suidubins
  * Fix --sbindir and --bindir for binary installations
  * Fix LASTLOG_UID_MAX in login.defs
  * Fix configure error with dash
- Remove because upstreamed:
  * libeconf.patch
  * shadow-usermod-variable.patch
- Rebase:
  * shadow-login_defs-unused-by-pam.patch
  * chkname-regex.patch
  * shadow-util-linux.patch
  * shadow-login_defs-comments.patch
- Add shadow-4.8-selinux-include.patch
  See https://github.com/shadow-maint/shadow/pull/200
* Mon Oct  7 2019 kukuk@suse.de
- libeconf.patch: Add support for libeconf and /usr/etc for
  login.defs.
- Move first configuration files and pam config files to /usr/etc
* Mon Sep  2 2019 mvetter@suse.com
- bsc#1144060: Add pam_keyinit.so to /etc/pam.d configuration files
  to support kernel keyring feature
- Update pamd.tar.bz2 with pam configuration files accordingly
* Mon Aug 19 2019 kukuk@suse.de
- encryption_method_nis.patch: drop, DES should really not be used
  anymore anywhere, even with NIS
- shadow-login_defs-suse.patch: remove encryption NIS entry
* Fri Jul 26 2019 sbrabec@suse.com
- Fix incorrect variable name in usermod
  (shadow-usermod-variable.patch).
- shadow-login_defs-comments.patch:
  * Drop SHA_CRYPT_*_ROUNDS that are in the upstream login.defs.
  * Add missing LASTLOG_UID_MAX.
  * Refresh shadow-login_defs-suse.patch.
- Port shadow-login_defs-check.sh to match the current spec file
  and login.defs.
* Thu Jul 25 2019 kukuk@suse.de
- Provide "useradd_or_adduser_dep" for sysuser-shadow
* Sat Jul 20 2019 sbrabec@suse.com
- shadow-login_defs-suse.patch: Set ALWAYS_SET_PATH default to
  "yes" (bsc#353876#c7).
* Fri Jul 19 2019 sbrabec@suse.com
- Fix comment about patch in spec file
* Fri Jun 14 2019 mvetter@suse.com
- Update to 4.7:
  * Spawn: don't loop forever on ECHILD
  * Do not fail locking if there is a stale lockfile (Tomas Mraz)
  * Use lckpwdf if prefix not set (Tomas Mraz)
  * Build: check correct DocBook version (Jan Tojnar)
  * Usermod: Print 'no changes' to stdout, not stderr (Serge Hallyn)
  * Add support for btrfs subvolumes for home (Adam Majer)
  * Fix chpasswd long line handling (Nathan Ruiz)
  * Use secure_getenv for gettime (Chris Lamb)
  * Make sp_lstchg reproducible (Chris Lamb)
  * Do not crash commonio_close if db file is not open (Tomas Mraz)
  * Don't flush nscd and sssd cache in read-only mode (Charlie Vuillemez)
  * French manpage update (Alban VIDAL)
  * Fix manpage defaults for SUB_UID/GID_COUNT (Tomas Mraz)
  * Sync po files from shadow.pot (Alban VIDAL)
  * Usermod: guard against unsafe chown of homedir contents (Tomas Mraz)
  * Add LASTLOG_UID_MAX to login.defs (Tomas Mraz)
  * new[ug]idmap file capabilities support (Giuseppe Scrivano and Christian Brauner)
  * Fix segfault in useradd (bsc#1141113, Tomas Mraz)
  * Coverity issues (Tomas Mraz)
  * Flush sssd caches (Jakub Hrozek)
  * Log UID in nologin (Vladimir Ivanov)
  * run pam_getenvlist after setup_env in su.c (Michael Vogt)
  * Support systems with only utmpx (A. Wilcox)
  * Fix unguarded ENABLE_SUBIDS code (Jan Chren (rindeal))
  * Update po/zh_CN translation (Lion Yang)
  * Create parent dirs for useradd -m (Michael Vetter)
  * Prevent usermod segv
  * Fix usermod crash (fariouche)
- Remove btrfs-subvolumes.patch (fate#316134):
  upstreamed: https://github.com/shadow-maint/shadow/pull/149
- Remove useradd-mkdirs.patch (bsc#865563):
  upstreamed https://github.com/shadow-maint/shadow/pull/112
- Remove shadow-4.6.0-fix-usermod-prefix-crash.patch
  upstreamed https://github.com/shadow-maint/shadow/issues/110
- Remove shadow-4.6-bsc1141113-useradd-segfault.patch
  (SLE15 SP3 and openSUSE Leap 15.3 only)
  upstreamed https://github.com/shadow-maint/shadow/issues/125
- Rebase userdel-script.patch
- Rebase useradd-script.patch
- Rebase shadow-util-linux.patch
* Thu May 30 2019 mpluskal@suse.com
- Make building more verbose
- Use spec-cleaner
* Thu May  2 2019 lnussel@suse.de
- don't specify MOTD_FILE in login.defs but fall back to built in
  defaults of login (boo#1133929)
* Tue Apr 30 2019 sbrabec@suse.com
- Split shadow-login_defs.patch hunks to its logical components
  (bsc#1121197):
  * shadow-login_defs-unused-by-pam.patch
  * shadow-login_defs-comments.patch
  * shadow-util-linux.patch
  * shadow-login_defs-suse.patch
  * Move appropriate hunks to chkname-regex.patch and
    encryption_method_nis.patch
  * Remove GROUPADD_CMD that is not supported (bsc#1121197#c14).
- Split getdef-new-defs.patch hunks to its logical components
  (bsc#1121197):
  * encryption_method_nis.patch
  * chkname-regex.patch
  * shadow-util-linux.patch
    Add support for login: ALWAYS_SET_PATH and LOGIN_PLAIN_PROMPT.
  * useradd-script.patch, userdel-script.patch
  * Remove duplicated definitions of MOTD_FILE and ENV_PATH.
- Add shadow-login_defs-unused-check.sh to allow verification of
  login.defs variable usage (bsc#1121197).
- Add virtual symbols for login.defs compatibility (bsc#1121197).
* Wed Jan 23 2019 adam.majer@suse.de
- btrfs-subvolumes.patch: implement support for creating user home
  directories on btrfs subvolumes (fate#316134)
* Wed Oct 31 2018 vrothberg@suse.com
- Add empty /etc/sub{u,g}id files. useradd and usermod add entries for users
  only when those files exist. Having those entries is a requirement to create
  user namespaces, for instance, when running podman as a non-root user.
* Mon May 14 2018 mvetter@suse.com
- Update to 4.6:
  * Newgrp: avoid unnecessary lookups
  * Make language less binary
  * Add error when turning off man switch
  * Spelling fixes
  * Make userdel work with -R
  * newgidmap: enforce setgroups=deny if self-mapping a group
  * Norwegian bokmål translation
  * pwck: prevent crash by not passing O_CREAT
  * WITH_TCB fixes from Mandriva
  * Fix pwconv and grpconv entry skips
  * Fix -- slurping in su
  * add --prefix option
- Remove CVE-2018-7169.patch: upstreamed
- Remove shadow-4.1.5.1-pam_group.patch: upstreamed
- Update userdel-script.patch: change due to prefix
- Update useradd-mkdirs.patch: change due to prefix
  Additionally changed in that patch (bsc#1106914):
  * Test for strdup() failure
  * Directory to 0755 instead 0777
- Add shadow-4.6.0-fix-usermod-prefix-crash.patch:
  Fixes crash in usermod when called with --prefix.
  See https://github.com/shadow-maint/shadow/issues/110
* Thu Feb 22 2018 fvogt@suse.com
- Use %%license (boo#1082318)
* Fri Feb 16 2018 kbabioch@suse.com
- Added CVE-2018-7169.patch: Fixed an privilege escalation in newgidmap,
  which allowed an unprivileged user to be placed in a user namespace where
  setgroups(2) is allowed. (CVE-2018-7169 bsc#1081294)
* Wed Nov  8 2017 mvetter@suse.com
- bsc#1061838:
  Revert: Requires: group(mail)
  Introduced circular dependency
* Fri Oct 13 2017 adam.majer@suse.de
- Revert accidentalied prerequisites.
  Use PreReq for permissions
* Thu Oct 12 2017 schwab@suse.de
- Prequire group(shadow), group(root), user(root)
* Mon Oct  9 2017 mvetter@suse.com
- bsc#1061838:
  Add Requires for group(mail)
* Thu Sep 14 2017 mvetter@suse.com
- boo#1048645:
  Set suid bit for newuidmap and newgimap
* Thu Sep 14 2017 mvetter@suse.com
- Revert the changes for bsc#1023895 back
  Pulls in too many deps into ring0.
  Next version of shadow plans to have no conditional man pages.
* Fri Sep  8 2017 mvetter@suse.com
- run spec-cleaner
- bsc#1023895:
  man page contained invalid options because they depend
  on compile flags and we shipped pre built ones.
  New BuildRequires: docbook-xsl-stylesheets docbook_4 xml2po
  xsltproc
* Thu Jun  8 2017 kukuk@suse.de
- Adjust requires (we need user/group root instead of aaa_base now)
* Mon May 22 2017 adam.majer@suse.de
- New upstream version 4.5
- Refreshed patches:
  * shadow-login_defs.patch
  * chkname-regex.patch
  * getdef-new-defs.patch
  * useradd-mkdirs.patch
- Upstreamed patches:
  * shadow-4.1.5.1-manfix.patch
  * shadow-4.1.5.1-errmsg.patch
  * shadow-4.1.5.1-backup-mode.patch
  * shadow-4.1.5.1-audit-owner.patch
  * shadow-4.2.1-defs-chroot.patch
  * shadow-4.2.1-merge-group.patch
  * Fix-user-busy-errors-at-userdel.patch
  * useradd-clear-tallylog.patch
- shadow-4.1.5.1-pam_group.patch
  dynamically added users via pam_group are not listed in groups
  databases but are still valid
- shadow.keyring: update keyring with current maintainer's keyid
  only - Serge Hallyn 'F1D08DB778185BF784002DFFE9FEEA06A85E3F9D'
- disable_new_audit_function.patch:
  Disable newer libaudit functionality for older distributions
* Mon Feb 20 2017 josef.moellers@suse.com
- useradd: call external program "/sbin/pam_tally2" to reset
  failed login counter in "/var/log/tallylog"
  (bsc#980486, useradd-clear-tallylog.patch)
* Wed Nov  2 2016 meissner@suse.com
- add keyring, three public keys from https://pkg-shadow.alioth.debian.org/download.php
* Tue Oct 18 2016 mvetter@suse.com
- bsc#1002975: Use permissions according to permissions package
  and dont try to manipulate them in %%files section.
* Wed Sep 14 2016 mvetter@suse.com
- boo#994486: Include shadow.5 manpage
  Previously this was provided by man-pages package in
  the man-pages-addons tarball which got removed later on.
* Tue May 31 2016 mvetter@suse.com
- Add package dependency for aaa_base, fixing bnc#899409
  (was done by tbehrens@suse.com but not submitted to Factory)
* Mon May 30 2016 mvetter@suse.com
- shadow 4.2.1 requested by fate#320422
- bsc#979069: Dont include shadow-4.1.5.1-bug935203-manpage.patch
- Dont set SUID bit yet. Once bsc#979282 is through, which will adapt the permissions package, we can enable the SUID bits.
  Remove the files used to circumvent the check.
- Remove:
  * shadow-rpmlintrc
  * shadow-subids
  * shadow-subids.easy
  * shadow-subids.secure
  * shadow-subids.paranoid
* Thu May 19 2016 christian.brauner@mailbox.org
- Update to shadow-4.2.1:
  - add support for subuids/subgids via newuidmap/newgidmap
- Rename chkname-regex.diff to chkname-regex.patch
- Rename encryption_method_nis.diff to encryption_method_nis.patch
- Rename getdef-new-defs.diff to getdef-new-defs.patch
- Rename shadow-login_defs.diff to shadow-login_defs.patch
- Rename userdel-scripts.diff to userdel-script.patch
- Rename useradd-script.diff to useradd-script.patch
- Rename useradd-default.diff to useradd-default.patch
- Rename useradd-mkdirs.diff to useradd-mkdirs.patch
- Add fixes from Red Hat/Fedora:
  - shadow-4.1.5.1-audit-owner.patch.patch:
  - log owner changes for home directory
  - shadow-4.1.5.1-userdel-helpfix.patch.patch:
  - give a hint about what happens when you force the removal of a user
  - shadow-4.2.1-defs-chroot.patch.patch:
  - initialize uid_t uid_min and uid_t uid_max not before we need them
  - shadow-4.2.1-merge-group.patch.patch:
  - simplify by using a single call to snprintf()
- Add upstream fix
  - Fix-user-busy-errors-at-userdel.patch:
  - call sub_uid_close()
* Fri Jan 15 2016 fvogt@suse.com
- Moved call from %%verifyscript into %%post:
  * Caused call to %%service_add_post shadow.service shadow.timer
    during rpm -qV shadow
* Wed Jul 15 2015 jkeil@suse.de
- Add systemd unit files to continuously check password & groupfile integrity
  * Idea from Arch Linux
  * pending request to systemd-presets-branding-openSUSE to enable by default
* Mon Mar 31 2014 tbehrens@suse.com
- Add patch useradd-mkdirs.diff: fix for bnc#865563, create all parts
  of the path
* Fri Nov 22 2013 werner@suse.de
- Stop any systemd user manager instance in case a user entry will
  be deleted (bnc#849870).  Nevertheless a running process requires
  the option --force for the userdel command.
* Tue Nov 12 2013 kukuk@suse.de
- Add ENCRYPT_METHOD_NIS for pam_unix.so (encryption_method_nis.diff)
* Tue Sep 17 2013 kukuk@suse.de
- Add some fixes from Fedora:
  - shadow-4.1.5.1-backup-mode.patch: open backup file with correct
    permissions.
  - shadow-4.1.5.1-logmsg.patch: fix error message
  - shadow-4.1.5.1-errmsg.patch: print error reason
  - shadow-4.1.5.1-manfix.patch: fix manual page
* Tue Feb  5 2013 kukuk@suse.de
- Cleanup login.defs and enable ENCRYPT_METHOD [bnc#802006]
* Tue Nov 13 2012 kukuk@suse.de
- Fix getdef default variables (getdef-new-defs.diff)
* Tue Nov 13 2012 kukuk@suse.de
- Fix default group value in /etc/default/useradd
  (useradd-default.diff)
* Thu Sep 27 2012 kukuk@suse.de
- Implement CHARACTER_CLASS support
  (chkname-regex.diff)
* Wed Sep 26 2012 kukuk@suse.de
- Add support for useradd.local
  (useradd-script.diff)
* Tue Sep 25 2012 kukuk@suse.de
- Fix spec file
- Adjust login.defs
  (shadow-login_defs.diff)
- Add userdel*.local script support and scrips
  (userdel-scripts.diff)
* Mon Sep 24 2012 kukuk@suse.de
- Initial package [FATE#314473]
