#
# spec file for package util-linux
#
# Copyright (c) 2023 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

%global flavor systemd%{nil}

# Parts description:
# core: libraries, all binaries except those dependent on libsystemd
# systemd: binaries dependent on systemd, man pages (generator is dependent on ruby)
# python: Python bindings

%if "%{flavor}" == ""
%define psuffix -core
%define ulbuild base
%define ulsubset core
%define core %nil
%endif
# flavor == ""

%if "%{flavor}" == "systemd"
%define ulbuild base
%define ulsubset systemd
%define core %exclude
%endif
# flavor == systemd

# All python flavors are built separately. No module can be built together with base.
# This is a limitation of %%python_subpackages.
%if "%{flavor}" == "python"
%define ulbuild python
%endif
# flavor == python

%if 0%{?suse_version} < 1550
%define ul_extra_bin_sbin 1
%else
%define ul_extra_bin_sbin 0
%endif
# suse_version < 1550

%define ul_suid 4755

%define _name   util-linux

%if ! %{defined _distconfdir}
%define _distconfdir %{_sysconfdir}
%else
%define no_config 1
%endif
# ! _distconfdir

%if "%ulsubset" == "core"
Name:           util-linux
Summary:        A collection of basic system utilities (core part)
Group:          System/Base
%endif
# ulsubset == core

%if "%ulsubset" == "systemd"
Name:           util-linux-systemd
Summary:        A collection of basic system utilities (systemd dependent part)
Group:          System/Base
%endif
# ulsubset == systemd

%if "%ulbuild" == "python"
%{?!python_module:%define python_module() python-%{**} python3-%{**}}
Name:           python-libmount
Summary:        Python bindings for the libmount library
Group:          Development/Languages/Python
%endif
# ulbuild == python

Version:        2.39.3
Release:        150600.4.12.2
License:        GPL-2.0-or-later
URL:            https://www.kernel.org/pub/linux/utils/util-linux/
Source:         https://www.kernel.org/pub/linux/utils/util-linux/v2.39/util-linux-%{version}.tar.xz
Source1:        util-linux-rpmlintrc
Source2:        util-linux-login_defs-check.sh
Source6:        etc_filesystems
Source7:        baselibs.conf
Source8:        login.pamd
Source9:        remote.pamd
Source10:       su.pamd
Source11:       su.default
Source12:       https://www.kernel.org/pub/linux/utils/util-linux/v2.39/util-linux-%{version}.tar.sign
Source13:       %{_name}.keyring
Source14:       runuser.pamd
Source15:       runuser-l.pamd
Source16:       su-l.pamd
Source51:       blkid.conf
# PATCH-EXTEND-UPSTREAM: Let `su' handle /sbin and /usr/sbin in path
Patch0:         make-sure-sbin-resp-usr-sbin-are-in-PATH.diff
Patch1:         libmount-print-a-blacklist-hint-for-unknown-filesyst.patch
Patch2:         Add-documentation-on-blacklisted-modules-to-mount-8-.patch
# PATCH-FIX-SUSE util-linux-bash-completion-su-chsh-l.patch bsc1172427 -- Fix "su -s" bash completion.
Patch4:         util-linux-bash-completion-su-chsh-l.patch
# PATCH-FIX-SUSE Revert-libblkid-try-LUKS2-first-when-probing.patch bsc#1224393
Patch5:         Revert-libblkid-try-LUKS2-first-when-probing.patch
# PATCH-FIX-SECURITY util-linux-wall-CVE-2024-28085.patch bsc1221831 CVE-2024-28085 sbrabec@suse.com -- Properly neutralize escape sequences in wall.
Patch6:         util-linux-wall-CVE-2024-28085.patch
# PATCH-FIX-UPSTREAM util-linux-more-exit-if-POLLERR-and-POLLHUP-on-stdin-is-received.patch bsc1220117 rgoldwyn@suse.com -- Processes not cleaned up after failed SSH session are using up 100% CPU
Patch7:         util-linux-more-exit-if-POLLERR-and-POLLHUP-on-stdin-is-received.patch
# PATCH-FIX-UPSTREAM util-linux-chcpu-document-zVM-limitations.patch bsc1218609 sbrabec@suse.com -- Document limitations of chcpu --deconfigure on IBM z/VM.
Patch8:         util-linux-chcpu-document-zVM-limitations.patch
# PATCH-FIX-UPSTREAM util-linux-chcpu-document-zVM-limitations-generated.patch bsc1218609 sbrabec@suse.com -- Document limitations of chcpu --deconfigure on IBM z/VM. (patch generated file)
Patch9:         util-linux-chcpu-document-zVM-limitations-generated.patch
# PATCH-FEATURE-UPSTREAM util-linux-lscpu-add-ARM-cores-neoverse3.patch bsc1223605 sbrabec@suse.com -- lscpu: Add missing ARM-cores.
Patch10:        util-linux-lscpu-add-ARM-cores-neoverse3.patch
# PATCH-FIX-UPSTREAM util-linux-libsmartcols-fix-reduction-stages-use.patch bsc1225598 sbrabec@suse.com -- Fix hang of lscpu -e.
Patch11:        util-linux-libsmartcols-fix-reduction-stages-use.patch
# PATCH-FIX-UPSTREAM util-linux-umount-losetup-lazy-destruction.patch bsc1159034 sbrabec@suse.com -- Document unexpected side effects of lazy destruction.
Patch12:        util-linux-umount-losetup-lazy-destruction.patch
# PATCH-FIX-UPSTREAM util-linux-umount-losetup-lazy-destruction-generated.patch bsc1159034 sbrabec@suse.com -- Document unexpected side effects of lazy destruction. (patch generated file)
Patch13:        util-linux-umount-losetup-lazy-destruction-generated.patch
# PATCH-FIX-UPSTREAM util-linux-agetty-prevent-cursor-escape.patch bsc1194818 sbrabec@suse.com -- Prevent cursor escape using arrows or escape sequences.
Patch14:        util-linux-agetty-prevent-cursor-escape.patch
# PATCH-FIX-UPSTREAM util-linux-lscpu-skip-aarch64-decode.patch bsc1229476 sbrabec@suse.com -- Skip aarch64 decode path for rest of the architectures.
Patch15:        util-linux-lscpu-skip-aarch64-decode.patch
BuildRequires:  audit-devel
BuildRequires:  bc
BuildRequires:  binutils-devel
BuildRequires:  fdupes
BuildRequires:  file-devel
BuildRequires:  gettext-devel
BuildRequires:  libcap-ng-devel
BuildRequires:  libeconf-devel
BuildRequires:  libselinux-devel
BuildRequires:  libsepol-devel
BuildRequires:  libtool
BuildRequires:  ncurses-devel
BuildRequires:  pam-devel
BuildRequires:  pkg-config
BuildRequires:  readline-devel
%if 0%{?suse_version} < 1600
BuildRequires:  utempter-devel
%endif
BuildRequires:  zlib-devel
Requires(post): permissions
Requires(verify):permissions
# util-linux is part of VMInstall, but we can well build without it
# Helps shorten a cycle and eliminate a bootstrap issue
#!BuildIgnore:  util-linux

%ifarch ppc ppc64 ppc64le
BuildRequires:  librtas-devel
%endif
#arch ppc

%if "%ulsubset" == "systemd"
BuildRequires:  bash-completion
BuildRequires:  systemd-devel
BuildRequires:  socat
BuildRequires:  systemd-rpm-macros
BuildRequires:  pkgconfig(libsystemd)
BuildRequires:  rubygem(asciidoctor)
Supplements:    (util-linux and systemd)
# Split-provides for upgrade from SLE < 12 and openSUSE <= 13.1
Provides:       util-linux:/bin/logger
# man pages were moved to -systemd subpackage with 2.38.x (SLE15 SP6, Leap 15.6)
Conflicts:      util-linux < 2.38
%systemd_requires
%endif
# ulsubset == systemd

%if "%ulsubset" == "core"
Provides:       fsck-with-dev-lock = %{version}
# bnc#651598:
Provides:       util-linux(fake+no-canonicalize)
Provides:       eject = 2.1.0
Provides:       login = 4.0
Provides:       rfkill = 0.5
# File conflict of eject (up to 12.3 and SLE11).
Obsoletes:      eject <= 2.1.0
# File conflict of login (up to 12.1 and SLE11).
Obsoletes:      login <= 4.0
# File conflict (man page) of rfkill (up to Leap 15 and SLE 15).
Obsoletes:      rfkill <= 0.5
# util-linux-2.34 integrates hardlink (up to Leap 15.1 and SLE15 SP1).
# The last version was 1.0+git.e66999f.
Provides:       hardlink = 1.1
Obsoletes:      hardlink < 1.1
# bnc#805684:

%ifarch s390x
Obsoletes:      s390-32
Provides:       s390-32
%endif
# arch s390x

Supplements:    filesystem(minix)
# All login.defs variables require support from shadow side.
# Upgrade this symbol version only if new variables appear!
# Verify by shadow-login_defs-check.sh from shadow source package.
Recommends:     login_defs-support-for-util-linux >= 2.37
%endif
# ulsubset == core

%if "%ulbuild" == "base"
# The problem with inconsistent /proc/self/mountinfo read is fixed in kernel 5.8.
# util-linux >= 2.37 no more contain work-around.
Conflicts:      kernel < 5.8
%endif
# ulbuild == base

%if "%ulbuild" == "python"
BuildRequires:  %{python_module devel}
BuildRequires:  rubygem(asciidoctor)
%python_subpackages
%endif
# ulbuild == python

%if "%ulbuild" == "python"
%description
This package contains the Python bindings for util-linux libmount
library.
%endif
# ulbuild == python

%if "%ulbuild" == "base"
%description
This package contains a large variety of low-level system utilities
that are necessary for a Linux system to function. It contains the
mount program, the fdisk configuration tool, and more.
%endif
# ulbuild == base

#################
# Core packages #
#################
%if "%ulsubset" == "core"
%ifarch s390 s390x ia64 m68k sparc
%package -n util-linux-extra
Summary:        A collection of basic system utilities - extra utilities
License:        GPL-2.0-or-later
Group:          System/Base

%description -n util-linux-extra
This package contains an util-linux tools that have no real use on a
particular platform. It contains programs that are not well usable for the
platform, but they can be required by scripts or third party tools.
%endif

%package -n libblkid1
Summary:        Filesystem detection library
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n libblkid1
Library for filesystem detection.

%package -n libblkid-devel
Summary:        Development files for the filesystem detection library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libblkid1 = %{version}

%description -n libblkid-devel
Files needed to develop applications using the library for filesystem
detection.

%package -n libblkid-devel-static
Summary:        Development files for the filesystem detection library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libblkid-devel = %{version}

%description -n libblkid-devel-static
Files needed to develop applications using the library for filesystem
detection.

%package -n libfdisk1
Summary:        Filesystem detection library
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n libfdisk1
Library for filesystem detection.

%package -n libfdisk-devel
Summary:        Development files for the filesystem detection library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libfdisk1 = %{version}

%description -n libfdisk-devel
Files needed to develop applications using the library for filesystem
detection.

%package -n libfdisk-devel-static
Summary:        Development files for the filesystem detection library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libfdisk-devel = %{version}

%description -n libfdisk-devel-static
Files needed to develop applications using the library for filesystem
detection.

%package -n libmount1
Summary:        Device mount library
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n libmount1
Library designed to be used in low-level utils like
mount(8) and /usr/sbin/mount.<type> helpers.

%package -n libmount-devel
Summary:        Development files for libmount
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libmount1 = %{version}

%description -n libmount-devel
Files to develop applications using the libmount library.

%package -n libmount-devel-static
Summary:        Development files for libmount
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libmount-devel = %{version}

%description -n libmount-devel-static
Files to develop applications using the libmount library.

%package -n libsmartcols1
Summary:        Column-based text sort engine
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n libsmartcols1
Library to sort human readable column-based text output.

%package -n libsmartcols-devel
Summary:        Development files for libsmartcols
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libsmartcols1 = %{version}

%description -n libsmartcols-devel
Files to develop applications using the libsmartcols library.

%package -n libsmartcols-devel-static
Summary:        Development files for libsmartcols
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       libsmartcols-devel = %{version}

%description -n libsmartcols-devel-static
Files to develop applications using the libsmartcols library.

%package -n libuuid1
Summary:        Library to generate UUIDs
License:        BSD-3-Clause
Group:          System/Libraries
# declare presence of the new ABI call __uuid_generate_time_cont
# Required for seamless update from older versions (SLE15 SP4, Leap 15.4 and older).
Provides:       libuuid__uuid_generate_time_cont

%description -n libuuid1
A library to generate universally unique IDs (UUIDs).

%package -n libuuid-devel
Summary:        Development files for libuuid
License:        BSD-3-Clause
Group:          Development/Libraries/C and C++
Requires:       libuuid1 = %{version}

%description -n libuuid-devel
Files to develop applications using the library to generate universally
unique IDs (UUIDs).

%package -n libuuid-devel-static
Summary:        Development files for libuuid
License:        BSD-3-Clause
Group:          Development/Libraries/C and C++
Requires:       libuuid-devel = %{version}

%description -n libuuid-devel-static
Files to develop applications using the library to generate universally
unique IDs (UUIDs).

%lang_package
%endif
# ulsubset == core

####################
# Systemd packages #
####################
%if "%ulsubset" == "systemd"
%package -n util-linux-tty-tools
Summary:        Tools for writing to TTYs
License:        BSD-3-Clause
Requires(pre):  group(tty)
Requires(post): permissions
Requires(verify):permissions
Provides:       util-linux:%{_bindir}/mesg
Provides:       util-linux:%{_bindir}/wall
Provides:       util-linux:%{_bindir}/write
# File conflict: /usr/bin/mesg /usr/bin/wall
Conflicts:      busybox-util-linux

%description -n util-linux-tty-tools
Tools that write to TTYs that the current user does not own.

%package -n uuidd
Summary:        Helper daemon to guarantee uniqueness of time-based UUIDs
License:        GPL-2.0-or-later
Group:          System/Filesystems
Requires(pre):  group(uuidd)
# uuidd restart requires the ABI of the new libuuid
# Required for seamless update from older versions (SLE15 SP4, Leap 15.4 and older).
Requires(post): libuuid__uuid_generate_time_cont
# uuidd bash-completion moved to a correct package
Conflicts:      util-linux < 2.25
# uuid-runtime appeared in SLE11 SP1 to SLE11 SP3
Provides:       uuid-runtime = %{version}
Obsoletes:      uuid-runtime <= 2.19.1
Requires:       group(uuidd)
Requires:       user(uuidd)
%systemd_requires

%description -n uuidd
The uuidd package contains a userspace daemon (uuidd) which guarantees
uniqueness of time-based UUID generation even at very high rates on
SMP systems.
%endif
# ulsubset == systemd

%prep
%setup -q -n %{_name}-%{version}
cp -a %{S:2} .
%autopatch -p1
# This test randomly fails or keeps hanging task inside build chroot (tested on 2.38).
rm tests/ts/lsns/ioctl_ns

%build
%global _lto_cflags %{_lto_cflags} -ffat-lto-objects
export SUID_CFLAGS="-fpie"
export SUID_LDFLAGS="-pie"
export LDFLAGS="-Wl,-z,relro,-z,now"
export CFLAGS="%{optflags} -D_GNU_SOURCE"
export CXXFLAGS="%{optflags} -D_GNU_SOURCE"

# Here we define a build function. For the base build, we use it as it
# is. For python build, we use it repeatedly for all flavors.
function configure_and_build() {

# configure options depending on ulbuild and ulsubset values
configure_options=""

%if "%ulbuild" == "python"
%define _configure ../configure
configure_options+="--disable-all-programs "
configure_options+="--with-python "
configure_options+="--enable-pylibmount "
configure_options+="--enable-libmount "
configure_options+="--enable-libblkid "
%endif
# ulbuild == python

%if "%ulbuild" == "base"
configure_options+="--enable-all-programs "
configure_options+="--without-python "
%endif
# ulbuild == base

%if "%ulsubset" == "core"
configure_options+="--without-systemd "
%endif
# ulsubset == core

%if "%ulsubset" == "systemd"
configure_options+="--with-systemd "
%endif
# ulsubset == systemd

#AUTOPOINT=true GTKDOCIZE=true autoreconf -vfi
# All dirs needs to be specified, as %%configure does not derive them
# from %%_prefix, and bootstrap build will fall back to /usr.
%configure\
	--prefix=%{_prefix}\
	--exec-prefix=%{_exec_prefix}\
	--disable-silent-rules\
	--bindir=%{_bindir}\
	--sbindir=%{_sbindir}\
	--sysconfdir=%{_sysconfdir}\
	--datadir=%{_datadir}\
	--includedir=%{_includedir}\
	--libdir=%{_libdir}\
	--libexecdir=%{_libexecdir}\
	--mandir=%{_mandir}\
	--infodir=%{_infodir}\
	--docdir=%{_docdir}/%{name}\
	--disable-makeinstall-chown\
	--disable-makeinstall-setuid\
	--with-audit\
	--with-btrfs\
	--with-gnu-ld\
	--with-ncursesw\
	--with-readline\
	--with-selinux\
%if 0%{?suse_version} < 1600
	--with-utempter\
%endif
	--with-bashcompletiondir=%{_datadir}/bash-completion/completions\
	--with-systemdsystemunitdir=%{_unitdir}\
	--enable-libuuid-force-uuidd\
	--enable-sulogin-emergency-mount\
	--disable-use-tty-group\
	--disable-rpath\
	--disable-chfn-chsh\
	--disable-newgrp\
	--disable-vipw\
	--disable-pg\
	--enable-fs-paths-default="/sbin:/usr/sbin"\
	--enable-static\
	--with-vendordir=%{_distconfdir} \
	--disable-libmount-mountfd-support \
	$configure_options
make %{?_smp_mflags}
}

################
# Python build #
################
%if "%ulbuild" == "python"
%{python_expand export PYTHON=$python
mkdir -p build.$python
cd build.$python
configure_and_build
cd ..
}
%endif
# ulbuild == python

##############
# Base build #
##############
%if "%ulbuild" == "base"
configure_and_build
%endif
# ulbuild == base

%if "%ulsubset" == "core"
bash ./util-linux-login_defs-check.sh
#BEGIN SYSTEMD SAFETY CHECK
# With systemd, some utilities are built differently. Keep track of these
# sources to prevent building of systemd-less versions.
#
# WARNING: Never edit following line without doing all suggested in the echo below!
UTIL_LINUX_KNOWN_SYSTEMD_DEPS='./login-utils/lslogins.c ./misc-utils/findmnt.c ./misc-utils/logger.c ./misc-utils/lsblk-properties.c ./misc-utils/uuidd.c '
UTIL_LINUX_FOUND_SYSTEMD_DEPS=$(find . -type f -name "*.c" -exec grep -l '#.*if.*HAVE_LIB\(SYSTEMD\|\UDEV\)' '{}' '+' | LC_ALL=C sort | tr '\n' ' ')
if test "$UTIL_LINUX_KNOWN_SYSTEMD_DEPS" != "$UTIL_LINUX_FOUND_SYSTEMD_DEPS" ; then
	echo "List of utilities depending on systemd have changed.
Please check the new util-linux-systemd file list, file removal and update of Conflicts for safe update!
Then update %%core and/or %%exclude in the file list to build what is needed.
Only then you can safely update following spec file line:
UTIL_LINUX_KNOWN_SYSTEMD_DEPS='$UTIL_LINUX_FOUND_SYSTEMD_DEPS'"
	exit 1
fi
#END SYSTEMD SAFETY CHECK
%endif
# ulsubset == core

%install
################
# Base install #
################
%if "%ulbuild" == "base"
%make_install
mkdir -p %{buildroot}{%{_distconfdir}/default,%{_pam_vendordir},%{_sysconfdir}/issue.d}
install -m 644 %{SOURCE51} %{buildroot}%{_sysconfdir}/blkid.conf
install -m 644 %{SOURCE8} %{buildroot}%{_pam_vendordir}/login
install -m 644 %{SOURCE9} %{buildroot}%{_pam_vendordir}/remote
%if 0%{?suse_version} <= 1500
sed -i '/^session/s/common-session-nonlogin/common-session/g' %{SOURCE14}
%endif
install -m 644 %{SOURCE14} %{buildroot}%{_pam_vendordir}/runuser
install -m 644 %{SOURCE15} %{buildroot}%{_pam_vendordir}/runuser-l
%if 0%{?suse_version} <= 1500
sed -i '/^session/s/common-session-nonlogin/common-session/g' %{SOURCE10}
%endif
install -m 644 %{SOURCE10} %{buildroot}%{_pam_vendordir}/su
install -m 644 %{SOURCE16} %{buildroot}%{_pam_vendordir}/su-l
install -m 644 %{SOURCE11} %{buildroot}%{_distconfdir}/default/su
sed 's/\bsu\b/runuser/g' <%{SOURCE11} >runuser.default
install -m 644 runuser.default %{buildroot}%{_distconfdir}/default/runuser
rm -fv "%{buildroot}/%{_sbindir}/raw" "%{buildroot}/sbin/raw" \
	"%{buildroot}/%{_mandir}/man8/raw.8"*
install -m 644 %{SOURCE6} %{buildroot}%{_sysconfdir}/filesystems
echo -e "#!/bin/sh\n/sbin/blockdev --flushbufs \$1" > %{buildroot}%{_sbindir}/flushb
chmod 755 %{buildroot}%{_sbindir}/flushb

# arch dependent

%if "%ulsubset" != "core"
%ifarch s390 s390x
rm -f %{buildroot}%{_sysconfdir}/fdprm
rm -f %{buildroot}%{_bindir}/setterm
rm -f %{buildroot}%{_sbindir}/fdformat
rm -f %{buildroot}%{_sbindir}/hwclock
rm -f %{buildroot}%{_sbindir}/tunelp
rm -f %{buildroot}%{_mandir}/man8/fdformat.8*
rm -f %{buildroot}%{_mandir}/man8/hwclock.8*
rm -f %{buildroot}%{_mandir}/man8/tunelp.8*
%endif
# arch s390

%ifarch ia64 %sparc m68k
rm -f %{buildroot}%{_mandir}/man8/cfdisk.8*
rm -f %{buildroot}%{_mandir}/man8/sfdisk.8*
rm -f %{buildroot}%{_sbindir}/cfdisk
rm -f %{buildroot}%{_sbindir}/sfdisk
%endif
# arch ia64 sparc m68k

%ifarch ia64 m68k
rm -f %{buildroot}%{_sbindir}/fdisk
rm -f %{buildroot}%{_mandir}/man8/fdisk.8*
%endif
# arch ia64 m68k
%endif
# ulsubset != core

# create list of setarch(8) symlinks
find  %{buildroot}%{_mandir}/man8 -regextype posix-egrep  \
  -regex ".*(linux32|linux64|s390|s390x|i386|ppc|ppc64|ppc32|sparc|sparc64|sparc32|sparc32bash|mips|mips64|mips32|ia64|x86_64|parisc|parisc32|parisc64|uname26)\.8.*" \
  -printf "%{_mandir}/man8/%f*\n" >> %{name}.files
find  %{buildroot}%{_bindir}/ -regextype posix-egrep -type l \
  -regex ".*(linux32|linux64|s390|s390x|i386|ppc|ppc64|ppc32|sparc|sparc64|sparc32|sparc32bash|mips|mips64|mips32|ia64|x86_64|parisc|parisc32|parisc64|uname26)$" \
  -printf "%{_bindir}/%f\n" >> %{name}.files
mkdir -p %{buildroot}/run/uuidd

%if "%ulsubset" == "systemd"
# clock.txt from uuidd is a ghost file
# FIXME: This could also be used by libuuid, but for now we only
# create it for uuidd. See boo#1206690.
mkdir -p %{buildroot}%{_sharedstatedir}/libuuid/
touch %{buildroot}%{_sharedstatedir}/libuuid/clock.txt
%endif
# ulsubset == systemd, ulbuild == base

%if %{ul_extra_bin_sbin}
mkdir -p %{buildroot}{/bin,/sbin}
for i in dmesg findmnt kill logger lsblk more mount su umount; do
	if test -f "%{buildroot}%{_bindir}/$i" ; then
		ln -s "%{_bindir}/$i" "%{buildroot}/bin/"
	fi
done
for i in agetty blockdev cfdisk ctrlaltdel fdisk fsck.minix fsck.cramfs\
 hwclock losetup mkfs mkfs.bfs mkfs.minix mkfs.cramfs mkswap nologin\
 pivot_root raw sfdisk swapoff swapon blkid findfs fsck switch_root\
 wipefs fsfreeze swaplabel fstrim chcpu; do
	if test -f "%{buildroot}%{_sbindir}/$i" ; then
		ln -s "%{_sbindir}/$i" "%{buildroot}/sbin/"
	fi
done
# login is always and only in /bin
mv %{buildroot}%{_bindir}/login %{buildroot}/bin/
%endif
# ul_extra_bin_sbin, ulbuild == base

%if "%ulsubset" == "core"
%find_lang %{_name} %{name}.lang
%else
# ulsubset != core, ulbuild == base
echo -n "" >%{name}.lang
ln -sf /sbin/service %{buildroot}%{_sbindir}/rcuuidd
ln -sf /sbin/service %{buildroot}%{_sbindir}/rcfstrim
%endif
# ulsubset == core, ulbuild == base

%endif
# ulbuild == base

##################
# Python install #
##################
%if "%ulbuild" == "python"
%{python_expand cd build.$python
%make_install
rm %{buildroot}%{$python_sitearch}/libmount/*.*a
cd ..
}
# There is a limitation: python module needs to build much more, and install even more. Delete it.
rm -r %{buildroot}{%{_bindir},%{_mandir},%{_datadir},%{_includedir},%{_libdir}/{lib,pkg}*}
%endif
# ulbuild == python

# fdupes for all multibuild flavors
# Link duplicate manpages or python bindings.
%fdupes %{buildroot}%{_prefix}

##############
# Base check #
##############
%if "%ulbuild" == "base"
%check
# Perform testsuite with the standard build only.
# mark some tests "known_fail"
#
%if 0%{?qemu_user_space_build}
export TS_OPT_fdisk_gpt_known_fail="yes"
export TS_OPT_fdisk_oddinput_known_fail="yes"
export TS_OPT_fdisk_sunlabel_known_fail="yes"
export TS_OPT_fincore_count_known_fail="yes"
export TS_OPT_libfdisk_gpt_known_fail="yes"
export TS_OPT_misc_flock_known_fail="yes"
export TS_OPT_misc_ionice_known_fail="yes"
export TS_OPT_misc_swaplabel_known_fail="yes"
export TS_OPT_kill_name_to_number_known_fail="yes"
export TS_OPT_kill_print_pid_known_fail="yes"
export TS_OPT_kill_queue_known_fail="yes"
export TS_OPT_uuid_uuidd_known_fail="yes"
# unsupported syscall in script(1) ... might be fixed in qemu
export TS_OPT_script_known_fail="yes"
# may segfault on qemu-user-space
export TS_OPT_misc_setarch_known_fail="yes"
%endif
# qemu_user_space_build

# Succeeds in local build, fails in OBS.
export TS_OPT_hardlink_options_known_fail="yes"
export TS_OPT_lsfd_mkfds_rw_character_device_known_fail="yes"
export TS_OPT_lsfd_mkfds_symlink_known_fail="yes"
# Started to fail after release. lsfd testsuite is known to be broken in 2.39.x.
export TS_OPT_lsfd_column_ainodeclass_known_fail="yes"
export TS_OPT_lsfd_column_name_known_fail="yes"
export TS_OPT_lsfd_column_type_known_fail="yes"
# This does not work with a chroot build: / is not a mountpoint
export TS_OPT_misc_mountpoint_known_fail="yes"
%ifarch ppc64le
# It seems that the test file does not appear in kernel cache at all.
export TS_OPT_fadvise_drop_known_fail="yes"
%endif
#
# hacks
export PATH="$PATH:/sbin:/usr/sbin"
#
# do the check but don't abort yet
result="0"
make %{?_smp_mflags} check || result="1"
#
# always show test diffs (inclusive known_fail) and exit result
diffs_files="$(find tests/diff -type f | sort)"
echo "$diffs_files" | xargs -r cat
exit "$result"

%if "%ulsubset" == "core"
%verifyscript
%verify_permissions -e %{_bindir}/mount -e %{_bindir}/umount
%verify_permissions -e %{_bindir}/su
%endif
%if 0
# ulsubset == core, ulbuild == base
%endif

%if "%ulsubset" == "systemd"
%verifyscript -n util-linux-tty-tools
%verify_permissions -e %{_bindir}/wall -e %{_bindir}/write
%endif
%if 0
# ulsubset == systemd, ulbuild == base
%endif

%endif
%if 0
# ulbuild == base

###################
# Core pre & post #
###################
%endif
%if "%ulsubset" == "core"
%pre
# move outdated pam.d/*.rpmsave files away
for i in login remote runuser runuser-l su su-l ; do
    test -f /etc/pam.d/${i}.rpmsave && mv -v /etc/pam.d/${i}.rpmsave /etc/pam.d/${i}.rpmsave.old ||:
done

%post
%set_permissions %{_bindir}/mount %{_bindir}/umount
%set_permissions %{_bindir}/su

%if ! %{defined no_config}
#
# If outdated PAM file is detected, issue a warning.
for PAM_FILE in login remote runuser runuser-l su su-l ; do
	if test -f %{_sysconfdir}/pam.d/$PAM_FILE.rpmnew ; then
		echo "Your %{_sysconfdir}/pam.d/$PAM_FILE is outdated. Please check %{_sysconfdir}/pam.d/$PAM_FILE.rpmnew!" >&2
	fi
done
#
# /etc/default/su is tagged as noreplace.
# But we want to migrate variables to /etc/login.defs (bsc#1121197).
# Perform one-time config replace.
# Applies for: Update from SLE11, online update for SLE15 SP1, Leap15.1.
# Not needed for /etc/default/runuser. It was first packaged after the change.
if ! grep -qs "^# /etc/default/su is an override" %{_sysconfdir}/default/su ; then
	if test -f %{_sysconfdir}/default/su.rpmnew ; then
		if ! test -f %{_sysconfdir}/default/su.rpmorig ; then
			cp -a %{_sysconfdir}/default/su %{_sysconfdir}/default/su.rpmorig
		fi
		mv %{_sysconfdir}/default/su.rpmnew %{_sysconfdir}/default/su
		echo "One time clean-up of %{_sysconfdir}/default/su was performed." >&2
		echo "Original contents was saved to %{_sysconfdir}/default/su.rpmorig." >&2
		echo "Please edit %{_sysconfdir}/login.defs or %{_sysconfdir}/default/su to restore your customization." >&2
	fi
fi
%endif
%if 0
# !defined no_config
%endif

%if %{defined no_config}

%posttrans
# Migration to /usr/etc.
for i in  login remote runuser runuser-l su su-l; do
  test -f /etc/pam.d/${i}.rpmsave && mv -v /etc/pam.d/${i}.rpmsave /etc/pam.d/${i} ||:
done
%endif

%post -n libblkid1 -p /sbin/ldconfig

%postun -n libblkid1 -p /sbin/ldconfig

%post -n libmount1 -p /sbin/ldconfig

%postun -n libmount1 -p /sbin/ldconfig

%post -n libsmartcols1 -p /sbin/ldconfig

%postun -n libsmartcols1 -p /sbin/ldconfig

%post -n libuuid1 -p /sbin/ldconfig

%postun -n libuuid1 -p /sbin/ldconfig

%post -n libfdisk1 -p /sbin/ldconfig

%postun -n libfdisk1 -p /sbin/ldconfig

%endif

%if "%ulsubset" == "systemd"
%if 0
# ulsubset == core, pre & post
######################
# Systemd pre & post #
######################
%endif
%pre
%service_add_pre fstrim.service fstrim.timer

%post
%service_add_post fstrim.service fstrim.timer

%preun
%service_del_preun fstrim.service fstrim.timer

%postun
%service_del_postun fstrim.service fstrim.timer

%pre -n uuidd

%if 0%{?suse_version} < 1330
getent group uuidd >/dev/null || /usr/sbin/groupadd -r uuidd
getent passwd uuidd >/dev/null || \
	/usr/sbin/useradd -r -g uuidd -c "User for uuidd" \
	-d %{_localstatedir}/run/uuidd uuidd
%endif
%if 0
# suse_version < 1330
%endif

%{service_add_pre uuidd.socket uuidd.service}

%post -n uuidd
# Fix running instance paths during live upgrade from
# Leap = 15, SLE = 15 (boo#1113188).
# Useful for Tumbleweed or zypper dup only.
mv /run/run/uuidd /run/uuidd >/dev/null 2>&1 || :
rmdir --ignore-fail-on-non-empty /run/run >/dev/null 2>&1 || :
%{service_add_post uuidd.socket uuidd.service}

%preun -n uuidd
%{service_del_preun uuidd.socket uuidd.service}

%postun -n uuidd
%{service_del_postun uuidd.socket uuidd.service}

%post -n util-linux-tty-tools
%set_permissions %{_bindir}/wall %{_bindir}/write

%endif
%if 0
# ulsubset == systemd, pre & post
##############
# Base files #
##############
%endif
%if "%ulbuild" == "base"
%files -n %{name} -f %{name}.files
%defattr(-,root,root)

%if %{defined no_config}
%core %{_pam_vendordir}/login
%core %{_pam_vendordir}/remote
%core %{_pam_vendordir}/runuser
%core %{_pam_vendordir}/runuser-l
%core %{_pam_vendordir}/su
%core %{_pam_vendordir}/su-l

%if 0%{?suse_version} <= 1520
%core %dir %{_distconfdir}/default
%endif
# suse_version <= 1520

%core %{_distconfdir}/default/runuser
%core %{_distconfdir}/default/su

%else
# ! defined no_config

%core %config(noreplace) %{_pam_vendordir}/login
%core %config(noreplace) %{_pam_vendordir}/remote
%core %config(noreplace) %{_pam_vendordir}/runuser
%core %config(noreplace) %{_pam_vendordir}/runuser-l
%core %config(noreplace) %{_pam_vendordir}/su
%core %config(noreplace) %{_pam_vendordir}/su-l
%core %config(noreplace) %{_sysconfdir}/default/runuser
%core %config(noreplace) %{_sysconfdir}/default/su
%endif
# defined no_config

%config %dir %{_sysconfdir}/issue.d

%if %{ul_extra_bin_sbin}
%core /bin/kill
%core /bin/su
%core /bin/dmesg
%core /bin/more
%core /bin/mount
%core /bin/umount
%core /bin/login
%core /sbin/agetty
%core /sbin/blockdev
%core /sbin/ctrlaltdel
%core /sbin/fsck.minix
%core /sbin/fsck.cramfs
%core /sbin/losetup
%core /sbin/mkfs
%core /sbin/mkfs.bfs
%core /sbin/mkfs.minix
%core /sbin/mkfs.cramfs
%core /sbin/mkswap
%core /sbin/nologin
%core /sbin/pivot_root
%core /sbin/swapoff
%core /sbin/swapon
%core /sbin/blkid
%core /sbin/findfs
%core /sbin/fsck
%core /sbin/switch_root
%core /sbin/wipefs
%core /sbin/fsfreeze
%core /sbin/swaplabel
%core /sbin/fstrim
%core /sbin/chcpu
%if "%ulsubset" != "systemd"
%exclude /bin/findmnt
%exclude /bin/logger
%exclude /bin/lsblk
%endif
%endif
# ul_extra_bin_sbin

%core %{_bindir}/kill
%core %verify(not mode) %attr(%ul_suid,root,root) %{_bindir}/su
%core %{_bindir}/eject
%core %{_bindir}/cal
%core %{_bindir}/chmem
%core %{_bindir}/choom
%core %{_bindir}/chrt
%core %{_bindir}/col
%core %{_bindir}/colcrt
%core %{_bindir}/colrm
%core %{_bindir}/column
%core %{_bindir}/dmesg
%core %{_bindir}/fadvise
%core %{_bindir}/fallocate
%core %{_bindir}/fincore

%core %{_bindir}/flock
%core %{_bindir}/getopt
%core %{_bindir}/hardlink
%core %{_bindir}/hexdump
%core %{_bindir}/ionice
%core %{_bindir}/ipcmk
%core %{_bindir}/ipcrm
%core %{_bindir}/ipcs
%core %{_bindir}/irqtop
%core %{_bindir}/isosize

%if 0%{?suse_version} >= 1599
# last provided by wtmpdb, btmp support dropped
%exclude %{_bindir}/last
%exclude %{_bindir}/lastb
%else
%core %{_bindir}/last
%core %{_bindir}/lastb
%endif
# 0%{?suse_version} >= 1599

%core %{_bindir}/line
%core %{_bindir}/look

%if !%{ul_extra_bin_sbin}
%core %{_bindir}/login
%endif
# ul_extra_bin_sbin

%core %{_bindir}/lscpu
%core %{_bindir}/lsfd
%core %{_bindir}/lsipc
%core %{_bindir}/lsirq
%core %{_bindir}/lslocks
%core %{_bindir}/lsmem
%core %{_bindir}/lsns
%core %{_bindir}/mcookie
%core %{_bindir}/more
%core %verify(not mode) %attr(%ul_suid,root,root) %{_bindir}/mount
%core %{_bindir}/namei
%core %{_bindir}/nsenter
%core %{_bindir}/pipesz
%core %{_bindir}/prlimit
%core %{_bindir}/rename
%core %{_bindir}/renice
%core %{_bindir}/rev
%core %{_bindir}/script
%core %{_bindir}/scriptlive
%core %{_bindir}/scriptreplay
%core %{_bindir}/setarch
%core %{_bindir}/setpriv
%core %{_bindir}/setsid
%core %{_bindir}/taskset
%core %{_bindir}/uclampset
%core %{_bindir}/ul
%core %verify(not mode)%attr(%ul_suid,root,root)  %{_bindir}/umount
%core %{_bindir}/unshare
%core %{_bindir}/mountpoint
%core %{_bindir}/utmpdump
%core %{_bindir}/uuidgen
%core %{_bindir}/uuidparse
%core %{_bindir}/uname26
%core %{_bindir}/waitpid
%core %{_bindir}/wdctl
%core %{_sbindir}/addpart
%core %{_sbindir}/agetty
%core %{_sbindir}/blkid
%core %{_sbindir}/blkdiscard
%core %{_sbindir}/blkpr

# blkzone depends on linux/blkzoned.h
%if 0%{?suse_version} >= 1330
%core %{_sbindir}/blkzone
%endif
# suse_version >= 1330

%core %{_sbindir}/blockdev
%core %{_sbindir}/chcpu
%core %{_sbindir}/ctrlaltdel
%core %{_sbindir}/delpart
%core %{_sbindir}/findfs
%core %{_sbindir}/fsck
%core %{_sbindir}/fsck.minix
%core %{_sbindir}/fsck.cramfs
%core %{_sbindir}/fsfreeze
%core %{_sbindir}/fstrim
%core %{_sbindir}/ldattach
%core %{_sbindir}/losetup
%core %{_sbindir}/mkfs
%core %{_sbindir}/mkfs.bfs
%core %{_sbindir}/mkfs.minix
%core %{_sbindir}/mkfs.cramfs
%core %{_sbindir}/mkswap
%core %{_sbindir}/nologin
%core %{_sbindir}/partx
%core %{_sbindir}/pivot_root
%core %{_sbindir}/resizepart
%core %{_sbindir}/rfkill
%core %{_sbindir}/rtcwake
%core %{_sbindir}/runuser
%core %{_sbindir}/sulogin
%core %{_sbindir}/swaplabel
%core %{_sbindir}/swapoff
%core %{_sbindir}/swapon
%core %{_sbindir}/switch_root
%core %{_sbindir}/wipefs
%core %{_bindir}/whereis
%core %{_sbindir}/zramctl
%core %{_sbindir}/flushb
%core %{_sbindir}/readprofile
# These directories should be owned by bash-completion. But we don't want to
# install them on build, so own these two directories:
%core %dir %{_datadir}/bash-completion
%core %dir %{_datadir}/bash-completion/completions

%exclude %{_datadir}/bash-completion/completions/uuidd

# wtmpdb
%if 0%{?suse_version} >= 1599
%exclude %{_datadir}/bash-completion/completions/last
%exclude %{_datadir}/bash-completion/completions/lastb
%endif

# tty-tools package
%exclude %{_datadir}/bash-completion/completions/wall
%exclude %{_datadir}/bash-completion/completions/write
%exclude %{_datadir}/bash-completion/completions/mesg
%exclude %{_mandir}/man1/mesg.1.gz
%exclude %{_mandir}/man1/wall.1.gz
%exclude %{_mandir}/man1/write.1.gz
%exclude %{_bindir}/mesg
%exclude %{_bindir}/wall
%exclude %{_bindir}/write

# util-linux documentation files
%doc Documentation/blkid.txt
%doc Documentation/cal.txt
%doc Documentation/col.txt
%doc Documentation/deprecated.txt
%doc Documentation/getopt.txt
%doc Documentation/howto-debug.txt
%doc Documentation/hwclock.txt
%doc Documentation/modems-with-agetty.txt
%doc Documentation/mount.txt
%doc Documentation/pg.txt
%{_docdir}/%{name}/getopt-example.*
%exclude %{_sbindir}/uuidd

#
# Files not common for all architectures
%ifnarch ia64 m68k

%if %{ul_extra_bin_sbin}
%core /sbin/fdisk
%endif
# ul_extra_bin_sbin

%core %{_sbindir}/fdisk
%core %{_mandir}/man8/fdisk.8.gz
%endif
# narch ia64 m68k

%ifnarch %sparc ia64 m68k
%core %{_mandir}/man8/cfdisk.8.gz
%core %{_mandir}/man8/sfdisk.8.gz

%if %{ul_extra_bin_sbin}
%core /sbin/cfdisk
%core /sbin/sfdisk
%endif
# ul_extra_bin_sbin

%core %{_sbindir}/cfdisk
%core %{_sbindir}/sfdisk
%endif
# narch sparc ia64 m68k

%ifnarch s390 s390x
%core %{_sbindir}/fdformat

%if %{ul_extra_bin_sbin}
%core /sbin/hwclock
%endif
# ul_extra_bin_sbin

%core %{_sbindir}/hwclock
%core %{_bindir}/setterm
%core %{_sbindir}/tunelp
%core %{_mandir}/man8/fdformat.8.gz
%core %{_mandir}/man8/hwclock.8.gz
%core %{_mandir}/man8/tunelp.8.gz
%endif
# narch s390

%core %{_mandir}/man1/kill.1.gz
%core %{_mandir}/man1/su.1.gz
%core %{_mandir}/man1/cal.1.gz
%core %{_mandir}/man1/choom.1.gz
%core %{_mandir}/man1/chrt.1.gz
%core %{_mandir}/man1/col.1.gz
%core %{_mandir}/man1/colcrt.1.gz
%core %{_mandir}/man1/colrm.1.gz
%core %{_mandir}/man1/column.1.gz
%core %{_mandir}/man1/dmesg.1.gz
%core %{_mandir}/man1/eject.1.gz
%core %{_mandir}/man1/fadvise.1.gz
%core %{_mandir}/man1/fallocate.1.gz
%core %{_mandir}/man1/fincore.1.gz
%core %{_mandir}/man1/flock.1.gz
%core %{_mandir}/man1/getopt.1.gz
%core %{_mandir}/man1/hardlink.1.gz
%core %{_mandir}/man1/hexdump.1.gz
%core %{_mandir}/man1/ipcrm.1.gz
%core %{_mandir}/man1/ipcs.1.gz

%if 0%{?suse_version} >= 1599
%exclude %{_mandir}/man1/last.1.gz
%exclude %{_mandir}/man1/lastb.1.gz
%else
%core %{_mandir}/man1/last.1.gz
%core %{_mandir}/man1/lastb.1.gz
%endif
# 0%{?suse_version} >= 1599

%core %{_mandir}/man1/line.1.gz
%core %{_mandir}/man1/login.1.gz
%core %{_mandir}/man1/look.1.gz
%core %{_mandir}/man1/lscpu.1.gz
%core %{_mandir}/man1/lsfd.1.gz
%core %{_mandir}/man1/lsipc.1.gz
%core %{_mandir}/man1/lsirq.1.gz
%core %{_mandir}/man1/lsmem.1.gz
%core %{_mandir}/man1/mcookie.1.gz
%core %{_mandir}/man1/more.1.gz
%core %{_mandir}/man1/namei.1.gz
%core %{_mandir}/man1/nsenter.1.gz
%core %{_mandir}/man1/ionice.1.gz
%core %{_mandir}/man1/irqtop.1.gz
%core %{_mandir}/man1/pipesz.1.gz
%core %{_mandir}/man1/prlimit.1.gz
%core %{_mandir}/man1/rename.1.gz
%core %{_mandir}/man1/rev.1.gz
%core %{_mandir}/man1/renice.1.gz
%core %{_mandir}/man1/setpriv.1.gz
%core %{_mandir}/man1/setsid.1.gz
%core %{_mandir}/man1/script.1.gz
%core %{_mandir}/man1/scriptlive.1.gz
%core %{_mandir}/man1/scriptreplay.1.gz
%core %{_mandir}/man1/setterm.1.gz
%core %{_mandir}/man1/taskset.1.gz
%core %{_mandir}/man1/ul.1.gz
%core %{_mandir}/man1/unshare.1.gz
%core %{_mandir}/man1/whereis.1.gz
%core %{_mandir}/man1/ipcmk.1.gz
%core %{_mandir}/man1/mountpoint.1.gz
%core %{_mandir}/man1/runuser.1.gz
%core %{_mandir}/man1/uclampset.1.gz
%core %{_mandir}/man1/utmpdump.1.gz
%core %{_mandir}/man1/uuidgen.1.gz
%core %{_mandir}/man1/uuidparse.1.gz
%core %{_mandir}/man1/waitpid.1.gz
%core %{_mandir}/man5/adjtime_config.5.gz
%core %{_mandir}/man5/fstab.5.gz
%core %{_mandir}/man5/terminal-colors.d.5.gz
%core %{_mandir}/man8/addpart.8.gz
%core %{_mandir}/man8/agetty.8.gz

%if 0%{?suse_version} >= 1330
%core %{_mandir}/man8/blkzone.8.gz
%endif
# suse_version >= 1330

%core %{_mandir}/man8/blockdev.8.gz
%core %{_mandir}/man8/blkpr.8.gz
%core %{_mandir}/man8/chmem.8.gz
%core %{_mandir}/man8/ctrlaltdel.8.gz
%core %{_mandir}/man8/delpart.8.gz
%core %{_mandir}/man8/blkid.8.gz
%core %{_mandir}/man8/blkdiscard.8.gz
%core %{_mandir}/man8/switch_root.8.gz
%core %{_mandir}/man8/mkfs.bfs.8.gz
%core %{_mandir}/man8/mkfs.minix.8.gz
%core %{_mandir}/man8/findfs.8.gz
%core %{_mandir}/man8/fsck.8.gz
%core %{_mandir}/man8/fsck.cramfs.8.gz
%core %{_mandir}/man8/fsck.minix.8.gz
%core %{_mandir}/man8/isosize.8.gz
%core %{_mandir}/man8/ldattach.8.gz
%core %{_mandir}/man8/losetup.8.gz
%core %{_mandir}/man8/lslocks.8.gz
%core %{_mandir}/man8/lsns.8.gz
%core %{_mandir}/man8/mkfs.8.gz
%core %{_mandir}/man8/mkfs.cramfs.8.gz
%core %{_mandir}/man8/mkswap.8.gz
%core %{_mandir}/man8/mount.8.gz
%core %{_mandir}/man8/nologin.8.gz
%core %{_mandir}/man8/fsfreeze.8.gz
%core %{_mandir}/man8/swaplabel.8.gz
%core %{_mandir}/man8/readprofile.8.gz
%core %{_mandir}/man8/rfkill.8.gz
%core %{_mandir}/man8/chcpu.8.gz
%core %{_mandir}/man8/partx.8.gz
%core %{_mandir}/man8/pivot_root.8.gz
%core %{_mandir}/man8/rtcwake.8.gz
%core %{_mandir}/man8/setarch.8.gz
%core %{_mandir}/man8/swapoff.8.gz
%core %{_mandir}/man8/swapon.8.gz
%core %{_mandir}/man8/umount.8.gz
%core %{_mandir}/man8/wipefs.8.gz
%core %{_mandir}/man8/zramctl.8.gz
%core %{_mandir}/man8/fstrim.8.gz
%core %{_mandir}/man8/resizepart.8.gz
%core %{_mandir}/man8/sulogin.8.gz
%core %{_mandir}/man8/wdctl.8.gz

##############
# Core files #
##############

%if "%ulsubset" == "core"
# Common files for all archs
%doc AUTHORS ChangeLog README NEWS
%license README.licensing
%license COPYING
%license Documentation/licenses/*
%config(noreplace) %{_sysconfdir}/filesystems
%config(noreplace) %{_sysconfdir}/blkid.conf

%{_datadir}/bash-completion/completions/*
%exclude %{_datadir}/bash-completion/completions/findmnt
%exclude %{_datadir}/bash-completion/completions/logger
%exclude %{_datadir}/bash-completion/completions/lsblk
%exclude %{_datadir}/bash-completion/completions/lslogins

%exclude %{_bindir}/findmnt
%exclude %{_bindir}/logger
%exclude %{_bindir}/lsblk
%exclude %{_bindir}/lslogins

%exclude %{_mandir}/man8/findmnt.8.gz
%exclude %{_mandir}/man1/logger.1.gz
%exclude %{_mandir}/man8/lsblk.8.gz
%exclude %{_mandir}/man1/lslogins.1.gz

%exclude %{_mandir}/man8/uuidd.8.gz
%endif
# ulsubset == core, ulbuild == base

#################
# Systemd files #
#################
%if "%ulsubset" == "systemd"
%exclude %config(noreplace) %{_sysconfdir}/filesystems
%exclude %config(noreplace) %{_sysconfdir}/blkid.conf

%exclude %config %dir %{_sysconfdir}/issue.d

%if %{ul_extra_bin_sbin}
/bin/findmnt
/bin/logger
/bin/lsblk
%endif
# ul_extra_bin_sbin

%{_bindir}/findmnt
%{_bindir}/logger
%{_bindir}/lsblk
%{_bindir}/lslogins

%{_mandir}/man8/findmnt.8.gz
%{_mandir}/man1/logger.1.gz
%{_mandir}/man8/lsblk.8.gz
%{_mandir}/man1/lslogins.1.gz

# Exclude core binaries bash-completion
%exclude %{_datadir}/bash-completion/completions/addpart
%exclude %{_datadir}/bash-completion/completions/blkdiscard
%exclude %{_datadir}/bash-completion/completions/blkid
%exclude %{_datadir}/bash-completion/completions/blkzone
%exclude %{_datadir}/bash-completion/completions/blockdev
%exclude %{_datadir}/bash-completion/completions/cal
%exclude %{_datadir}/bash-completion/completions/cfdisk
%exclude %{_datadir}/bash-completion/completions/chcpu
%exclude %{_datadir}/bash-completion/completions/chmem
%exclude %{_datadir}/bash-completion/completions/chrt
%exclude %{_datadir}/bash-completion/completions/col
%exclude %{_datadir}/bash-completion/completions/colcrt
%exclude %{_datadir}/bash-completion/completions/colrm
%exclude %{_datadir}/bash-completion/completions/column
%exclude %{_datadir}/bash-completion/completions/ctrlaltdel
%exclude %{_datadir}/bash-completion/completions/delpart
%exclude %{_datadir}/bash-completion/completions/dmesg
%exclude %{_datadir}/bash-completion/completions/eject
%exclude %{_datadir}/bash-completion/completions/fallocate
%exclude %{_datadir}/bash-completion/completions/fadvise
%exclude %{_datadir}/bash-completion/completions/fdformat
%exclude %{_datadir}/bash-completion/completions/fdisk
%exclude %{_datadir}/bash-completion/completions/fincore
%exclude %{_datadir}/bash-completion/completions/findfs
%exclude %{_datadir}/bash-completion/completions/flock
%exclude %{_datadir}/bash-completion/completions/fsck
%exclude %{_datadir}/bash-completion/completions/fsck.cramfs
%exclude %{_datadir}/bash-completion/completions/fsck.minix
%exclude %{_datadir}/bash-completion/completions/fsfreeze
%exclude %{_datadir}/bash-completion/completions/fstrim
%exclude %{_datadir}/bash-completion/completions/getopt
%exclude %{_datadir}/bash-completion/completions/hardlink
%exclude %{_datadir}/bash-completion/completions/hexdump
%exclude %{_datadir}/bash-completion/completions/hwclock
%exclude %{_datadir}/bash-completion/completions/ionice
%exclude %{_datadir}/bash-completion/completions/ipcmk
%exclude %{_datadir}/bash-completion/completions/ipcrm
%exclude %{_datadir}/bash-completion/completions/ipcs
%exclude %{_datadir}/bash-completion/completions/irqtop
%exclude %{_datadir}/bash-completion/completions/isosize
%exclude %{_datadir}/bash-completion/completions/last
%exclude %{_datadir}/bash-completion/completions/lastb
%exclude %{_datadir}/bash-completion/completions/ldattach
%exclude %{_datadir}/bash-completion/completions/look
%exclude %{_datadir}/bash-completion/completions/losetup
%exclude %{_datadir}/bash-completion/completions/lscpu
%exclude %{_datadir}/bash-completion/completions/lsipc
%exclude %{_datadir}/bash-completion/completions/lsirq
%exclude %{_datadir}/bash-completion/completions/lslocks
%exclude %{_datadir}/bash-completion/completions/lsmem
%exclude %{_datadir}/bash-completion/completions/lsns
%exclude %{_datadir}/bash-completion/completions/mcookie
%exclude %{_datadir}/bash-completion/completions/mkfs
%exclude %{_datadir}/bash-completion/completions/mkfs.bfs
%exclude %{_datadir}/bash-completion/completions/mkfs.cramfs
%exclude %{_datadir}/bash-completion/completions/mkfs.minix
%exclude %{_datadir}/bash-completion/completions/mkswap
%exclude %{_datadir}/bash-completion/completions/more
%exclude %{_datadir}/bash-completion/completions/mount
%exclude %{_datadir}/bash-completion/completions/mountpoint
%exclude %{_datadir}/bash-completion/completions/namei
%exclude %{_datadir}/bash-completion/completions/nsenter
%exclude %{_datadir}/bash-completion/completions/partx
%exclude %{_datadir}/bash-completion/completions/pipesz
%exclude %{_datadir}/bash-completion/completions/pivot_root
%exclude %{_datadir}/bash-completion/completions/prlimit
%exclude %{_datadir}/bash-completion/completions/readprofile
%exclude %{_datadir}/bash-completion/completions/rename
%exclude %{_datadir}/bash-completion/completions/renice
%exclude %{_datadir}/bash-completion/completions/resizepart
%exclude %{_datadir}/bash-completion/completions/rev
%exclude %{_datadir}/bash-completion/completions/rfkill
%exclude %{_datadir}/bash-completion/completions/rtcwake
%exclude %{_datadir}/bash-completion/completions/runuser
%exclude %{_datadir}/bash-completion/completions/script
%exclude %{_datadir}/bash-completion/completions/scriptlive
%exclude %{_datadir}/bash-completion/completions/scriptreplay
%exclude %{_datadir}/bash-completion/completions/setarch
%exclude %{_datadir}/bash-completion/completions/setpriv
%exclude %{_datadir}/bash-completion/completions/setsid
%exclude %{_datadir}/bash-completion/completions/setterm
%exclude %{_datadir}/bash-completion/completions/sfdisk
%exclude %{_datadir}/bash-completion/completions/su
%exclude %{_datadir}/bash-completion/completions/swaplabel
%exclude %{_datadir}/bash-completion/completions/swapoff
%exclude %{_datadir}/bash-completion/completions/swapon
%exclude %{_datadir}/bash-completion/completions/taskset
%exclude %{_datadir}/bash-completion/completions/tunelp
%exclude %{_datadir}/bash-completion/completions/uclampset
%exclude %{_datadir}/bash-completion/completions/ul
%exclude %{_datadir}/bash-completion/completions/umount
%exclude %{_datadir}/bash-completion/completions/unshare
%exclude %{_datadir}/bash-completion/completions/utmpdump
%exclude %{_datadir}/bash-completion/completions/uuidgen
%exclude %{_datadir}/bash-completion/completions/uuidparse
%exclude %{_datadir}/bash-completion/completions/waitpid
%exclude %{_datadir}/bash-completion/completions/wdctl
%exclude %{_datadir}/bash-completion/completions/whereis
%exclude %{_datadir}/bash-completion/completions/wipefs
%exclude %{_datadir}/bash-completion/completions/zramctl

%{_datadir}/bash-completion/completions/findmnt
%{_datadir}/bash-completion/completions/logger
%{_datadir}/bash-completion/completions/lsblk
%{_datadir}/bash-completion/completions/lslogins

# uuidd sub-package
%exclude %{_sbindir}/uuidd
%exclude %{_datadir}/bash-completion/completions/uuidd

%exclude %{_datadir}/locale
%exclude %{_includedir}/*
%exclude %{_libdir}/lib*.*
%exclude %{_libdir}/pkgconfig/*.pc
%exclude %{_docdir}/%{name}/getopt-example.*
# packaged in core step
%exclude %{_mandir}/man3/libblkid.3.gz
%exclude %{_mandir}/man3/uuid.3.gz
%exclude %{_mandir}/man3/uuid_*.3.gz

# exclude setarch from systemd package
%exclude %{_bindir}/linux32
%exclude %{_bindir}/linux64
%exclude %{_bindir}/s390
%exclude %{_bindir}/s390x
%exclude %{_bindir}/i386
%exclude %{_bindir}/ppc
%exclude %{_bindir}/ppc64
%exclude %{_bindir}/ppc32
%exclude %{_bindir}/sparc
%exclude %{_bindir}/sparc64
%exclude %{_bindir}/sparc32
%exclude %{_bindir}/sparc32bash
%exclude %{_bindir}/mips
%exclude %{_bindir}/mips64
%exclude %{_bindir}/mips32
%exclude %{_bindir}/ia64
%exclude %{_bindir}/x86_64
%exclude %{_bindir}/parisc
%exclude %{_bindir}/parisc32
%exclude %{_bindir}/parisc64
%exclude %{_bindir}/uname26

%exclude %{_mandir}/man8/linux32.8.gz
%exclude %{_mandir}/man8/linux64.8.gz
%exclude %{_mandir}/man8/s390.8.gz
%exclude %{_mandir}/man8/s390x.8.gz
%exclude %{_mandir}/man8/i386.8.gz
%exclude %{_mandir}/man8/ppc.8.gz
%exclude %{_mandir}/man8/ppc64.8.gz
%exclude %{_mandir}/man8/ppc32.8.gz
%exclude %{_mandir}/man8/sparc.8.gz
%exclude %{_mandir}/man8/sparc64.8.gz
%exclude %{_mandir}/man8/sparc32.8.gz
%exclude %{_mandir}/man8/sparc32bash.8.gz
%exclude %{_mandir}/man8/mips.8.gz
%exclude %{_mandir}/man8/mips64.8.gz
%exclude %{_mandir}/man8/mips32.8.gz
%exclude %{_mandir}/man8/ia64.8.gz
%exclude %{_mandir}/man8/x86_64.8.gz
%exclude %{_mandir}/man8/parisc.8.gz
%exclude %{_mandir}/man8/parisc32.8.gz
%exclude %{_mandir}/man8/parisc64.8.gz
%exclude %{_mandir}/man8/uname26.8.gz

%{_sbindir}/rcfstrim
%{_unitdir}/fstrim.service
%{_unitdir}/fstrim.timer
%endif
# ulsubset systemd

#######################
# Core packages files #
#######################
%if "%ulsubset" == "core"
%ifarch s390 s390x ia64 m68k sparc
%files -n util-linux-extra
#
# Files not common for all architectures
%ifarch ia64 m68k

%if %{ul_extra_bin_sbin}
%core /sbin/fdisk
%endif
# ul_extra_bin_sbin

%core %{_sbindir}/fdisk
%core %{_mandir}/man8/fdisk.8.gz
%endif
# arch ia64 m68k

%ifarch %sparc ia64 m68k
%core %{_mandir}/man8/cfdisk.8.gz
%core %{_mandir}/man8/sfdisk.8.gz

%if %{ul_extra_bin_sbin}
%core /sbin/cfdisk
%core /sbin/sfdisk
%endif
# ul_extra_bin_sbin

%core %{_sbindir}/cfdisk
%core %{_sbindir}/sfdisk
%endif
# arch sparc ia64 m68k

%ifarch s390 s390x
%core %{_sbindir}/fdformat

%if %{ul_extra_bin_sbin}
%core /sbin/hwclock
%endif
# ul_extra_bin_sbin

%core %{_sbindir}/hwclock
%core %{_bindir}/setterm
%core %{_sbindir}/tunelp
%core %{_mandir}/man8/fdformat.8.gz
%core %{_mandir}/man8/hwclock.8.gz
%core %{_mandir}/man8/tunelp.8.gz
%endif
# arch s390
%endif
# arch s390 s390x ia64 m68k sparc

%files -n libblkid1
%{_libdir}/libblkid.so.1
%{_libdir}/libblkid.so.1.*

%files -n libfdisk1
%{_libdir}/libfdisk.so.1
%{_libdir}/libfdisk.so.1.*

%files -n libmount1
%{_libdir}/libmount.so.1
%{_libdir}/libmount.so.1.*

%files -n libsmartcols1
%{_libdir}/libsmartcols.so.1
%{_libdir}/libsmartcols.so.1.*

%files -n libuuid1
%{_libdir}/libuuid.so.1
%{_libdir}/libuuid.so.1.*

# devel, lang and uuidd files are not packaged in staging mode
# and packaged separately in full mode
# FIXME: Is it needed?
# HACK: We have to use "%%files -n" here, otherwise python lua code will
# issue an error, even if it is inside a false condition.
%files -n %{name}-lang -f %{name}.lang

%files -n libblkid-devel
%{_libdir}/libblkid.so
%dir %{_includedir}/blkid
%{_includedir}/blkid/blkid.h
%{_libdir}/pkgconfig/blkid.pc
%{_mandir}/man3/libblkid.3.gz

%files -n libblkid-devel-static
%{_libdir}/libblkid.*a

%files -n libfdisk-devel
%{_libdir}/libfdisk.so
%dir %{_includedir}/libfdisk
%{_includedir}/libfdisk/libfdisk.h
%{_libdir}/pkgconfig/fdisk.pc

%files -n libfdisk-devel-static
%{_libdir}/libfdisk.*a

%files -n libmount-devel
%{_libdir}/libmount.so
%dir %{_includedir}/libmount
%{_includedir}/libmount/libmount.h
%{_libdir}/pkgconfig/mount.pc

%files -n libmount-devel-static
%{_libdir}/libmount.*a

%files -n libsmartcols-devel
%{_libdir}/libsmartcols.so
%dir %{_includedir}/libsmartcols
%{_includedir}/libsmartcols/libsmartcols.h
%{_libdir}/pkgconfig/smartcols.pc

%files -n libsmartcols-devel-static
%{_libdir}/libsmartcols.*a

%files -n libuuid-devel
%{_libdir}/libuuid.so
%dir %{_includedir}/uuid
%{_includedir}/uuid/uuid.h
%{_libdir}/pkgconfig/uuid.pc
%{_mandir}/man3/uuid*

%files -n libuuid-devel-static
%{_libdir}/libuuid.*a
%endif
# ulsubset == core

##########################
# Systemd packages files #
##########################
%if "%ulsubset" == "systemd"
%files -n uuidd
%{_sbindir}/uuidd
%attr(-,uuidd,uuidd) %dir %{_sharedstatedir}/libuuid
%attr(-,uuidd,uuidd) %ghost %{_sharedstatedir}/libuuid/clock.txt
%attr(-,uuidd,uuidd) %ghost %dir /run/uuidd
%{_datadir}/bash-completion/completions/uuidd
%{_mandir}/man8/uuidd.8.gz
%{_sbindir}/rcuuidd
%{_unitdir}/uuidd.service
%{_unitdir}/uuidd.socket

%files -n util-linux-tty-tools
%{_bindir}/mesg
%verify(not mode) %attr(0755,root,tty) %{_bindir}/wall
%verify(not mode) %attr(0755,root,tty) %{_bindir}/write
%{_mandir}/man1/mesg.1.gz
%{_mandir}/man1/wall.1.gz
%{_mandir}/man1/write.1.gz

%{_datadir}/bash-completion/completions/wall
%{_datadir}/bash-completion/completions/write
%{_datadir}/bash-completion/completions/mesg

%endif
# ulsubset == systemd

%endif
# ulbuild == base

################
# Python files #
################
%if "%ulbuild" == "python"
%files %{python_files}
%{python_sitearch}/libmount
%endif
# ulbuild == python

%changelog
* Tue Sep  3 2024 sbrabec@suse.com
- Skip aarch64 decode path for rest of the architectures
  (bsc#1229476, util-linux-lscpu-skip-aarch64-decode.patch).
* Tue Jul 23 2024 sbrabec@suse.com
- agetty: Prevent login cursor escape (bsc#1194818,
  util-linux-agetty-prevent-cursor-escape.patch).
* Thu Jun 20 2024 sbrabec@suse.com
- Document unexpected side effects of lazy destruction
  (bsc#1159034, util-linux-umount-losetup-lazy-destruction.patch,
  util-linux-umount-losetup-lazy-destruction-generated.patch).
* Thu Jun 20 2024 sbrabec@suse.com
- Don't delete binaries not common for all architectures. Create an
  util-linux-extra subpackage instead, so users of third party
  tools can use them. (bsc#1222285)
* Sun Jun  9 2024 sbrabec@suse.com
- Fix hang of lscpu -e (bsc#1225598,
  util-linux-libsmartcols-fix-reduction-stages-use.patch).
* Thu May 23 2024 sbrabec@suse.com
- lscpu: Add more ARM cores (bsc#1223605,
  util-linux-lscpu-add-ARM-cores-neoverse3.patch).
* Tue May 21 2024 sbrabec@suse.com
- Document that chcpu -g is not supported on IBM z/VM (bsc#1218609,
  util-linux-chcpu-document-zVM-limitations.patch,
  util-linux-chcpu-document-zVM-limitations-generated.patch).
* Fri May 17 2024 mwilck@suse.com
- Fix misdetection of LUKS2 partition on MD RAID
  (bsc#1224393, boo#1213227, boo#1213361)
  * add Revert-libblkid-try-LUKS2-first-when-probing.patch
* Mon May  6 2024 rgoldwyn@suse.com
- bsc#1220117: Processes not cleaned up after failed SSH session are using up 100%% CPU
  + util-linux-more-exit-if-POLLERR-and-POLLHUP-on-stdin-is-received.patch
* Wed Mar 27 2024 sbrabec@suse.com
- Properly neutralize escape sequences in wall
  (util-linux-wall-CVE-2024-28085.patch, bsc#1221831,
  CVE-2024-28085).
* Fri Feb  9 2024 sbrabec@suse.com
- Add file conflict of util-linux-tty-tools and busybox-util-linux.
* Tue Jan 23 2024 sbrabec@suse.com
- Upgrade to version 2.39.3 (PED-7694):
  * libblkid: add support for bcachefs sub-device labels
  * libblkid: detect large bcachefs superblocks
  * libblkid: validate that NTFS sector_size is a power of two
  * libblkid: report endianness for VXFS
  * libmount: Fix regression when mounting with atime
  * libmount: accept '\' as escape for options separator
  * libmount: gracefully handle NULL path in mnt_resolve_target()
  * libmount: report statx in features list
  * libsmartcols: handle nameless tables in export format
  * libuuid: avoid truncation of clocks.txt to improve performance
  * lscpu: fix caches separator for --parse=<list>
  * lscpu: Add Phytium FTC862 cpu model
  * lsfd: fix the form for the optional argument of --inet option
    in manpage
  * lsfd: avoid a case of undefined behavior
  * lsfd: fix a memory leak
  * lslogins: fix -y option formatting in manpage
  * more: avoid an out-of-bound access
  * setpriv: fix some group argument completion
  * setterm: avoid restoring flags from uninitialized memory
  * umount: handle bindmounts during --recursive
  * other changes, see:
    https://mirrors.edge.kernel.org/pub/linux/utils/util-linux/v2.39/v2.39.3-ReleaseNotes
  * Changes from 2.39.2:
  * libblkid: fix topology chain types mismatch
  * libmount:
  * handle failure to apply flags as part of a mount operation
  * improve EPERM interpretation
  * update documentation for MNT_ERR_APPLYFLAGS
  * use mount(2) for remount on Linux < 5.14
  * use some MS_* flags as superblock flags
  * setarch: add PER_LINUX_FDPIC fallback
  * uuidd: improve man page for -cont-clock
  * wall: do not error for ttys that do not exist
  * zramctl: add hint about supported algorithms
  * other changes, see:
    https://mirrors.edge.kernel.org/pub/linux/utils/util-linux/v2.39/v2.39.2-ReleaseNotes
  * Changes from 2.39.1:
  * Various bug fixes including problem with parsing mount options.
    https://www.kernel.org/pub/linux/utils/util-linux/v2.39/v2.39.1-ReleaseNotes
  * Changes from 2.39:
  * blkpr: New command to run persistent reservations ioctls on a device.
  * pipesz: New command to set or examine pipe and FIFO buffer sizes.
  * waitpid: New command to wait for arbitrary processes.
  * mount, libmount: Supports new file descriptors based mount kernel API.
  * mount, libmount: New mount options X-mount.idmap=, X-mount.auto-fstypes,
    X-mount.{owner,group,mode}=, rootcontext=@target.
  * renice: Supports posix-compliant -n (via POSIXLY_CORRECT) and add a new
    option --relative.
  * dmesg: Supports subsecond granularity for --since and --until.
  * dmesg: Option --level accepts '+' prefix or postfix for a level name to specify
    all higher or all lower levels.
  * blkid, libblkid: Supports bcachefs.
  * fstrim: New option --types to filter out by filesystem types.
  * lsblk: --nvme and --virtio are new options to filter out devices.
  * lsblk: Improves detection of hotplug and removable status.
  * nsenter: New option --env for allowing environment variables inheritance.
  * namei: New option -Z to report SELinux contexts.
  * Many other new features and fixes. For complete list see
    https://kernel.org/pub/linux/utils/util-linux/v2.39/v2.39-ReleaseNotes
  * Changes from 2.38.1:
  * column: fix buffer overflow when -l specified, fix greedy mode
  on -l
  * dmesg: fix --since and --until
  * libmount: when moving a mount point, all sub mount entries in
    utab should also be updated (bsc#1198731)
  * libuuid: improve cache handling (bsc#1201959, PED-1150)
  * lsblk: fix JSON output when without --bytes
  * lsfd:fix crash triggered by an empty filter expression
  * sulogin: fix includes (obsoletes linux-fs.patch)
  * Many other fixes, improvements and code cleanup. For the
    complete list see
    https://www.kernel.org/pub/linux/utils/util-linux/v2.38/v2.38.1-ReleaseNotes
  * Changes from 2.38:
  * first release with translated util-linux man-pages
  * mount: new options --mkdir as shortcut for X-mount.mkdir
  * mount, libmount: new mount options X-mount.subdir=
  * lsfd: new command
  * dmesg: new option --json to print kernel log in JSON format
  * libfdisk: improved to set correct CHS addresses in MBR
  * fstrim: ignores all /ect/fstab entries with X-fstrim.notrim
    (jsc#SLE-17942)
  * hardlink: now supports reflinks and new option --method=
  * hwclock: new command line options --param-get and --param-set
  * irqtop: new option --cpu-stat
  * libblkid: supports zoned disks for btrfs
  * lsblk: new options --noempty to ignore all devices with zero
    size, and --zoned to print information about zones
  * mkswap: new option --quiet
  * nsenter: new option --wdns to change working directory within
    namespace
  * rename: new options --all and --last to replace all or last
    occurrences of expression rather than the first one
  * su: now resets RLIMIT_AS, RLIMIT_{NICE,RTPRIO}, RLIMIT_FSIZE
    and RLIMIT_NOFILE reourse limits.
  * unshare: new options --map-users= and --map-groups= to map
    block of group IDs; new option --map-auto to map the first
    block of user IDs owned by the effective user from /etc/subuid
  * wdctl: new options --setpregovernor to set pre-timeout governor
    name, and --setpretimeout to set watchdog pre-timeout in
    seconds
  * Many other new features and fixes. For the complete list see
    https://www.kernel.org/pub/linux/utils/util-linux/v2.38/v2.38-ReleaseNotes
- Port patches/libmount-print-a-blacklist-hint-for-unknown-filesyst.patch
- Drop upstreamed patches: util-linux-sulogin4bsc1175514.patch,
  blockdev-remove-nbsp.patch,
  util-linux-fstrim-implement-X-fstrim.notrim.patch,
  util-linux-uuidd-fix-lock-state.patch,
  util-linux-libuuid-extend-cache.patch (better upstream
  implementation exists),
  util-linux-uuidd-prevent-root-owning.patch (it should not happen
  in the re-implemented libuuid),
  util-linux-agetty-resolve-tty-if-stdin-is-specified.patch,
  util-linux-libmount-moving-mount-point-sub-mounts.patch,
  util-linux-libmount-fix-and-improve-utab-on-ms_move.patch,
  util-linux-libuuid-uuid_parse-overrun.patch,
  util-linux-libuuid-improve-cache-handling.patch,
  util-linux-libuuid-continuous-clock-handling.patch,
  util-linux-libuuid-check-clock-value.patch,
  util-linux-fix-tests-when-at-symbol-in-path.patch,
  util-linux-flock-limitations.patch,
  util-linux-libuuid-avoid-truncate-clocks.txt-to-improve-perform.patch.
- Disable failing check fadvise/drop on ppc64le (test file does not
  appear in the kernel cache at all).
* Tue Jan 23 2024 ailiop@suse.com
- Add upstream patch
  util-linux-libuuid-avoid-truncate-clocks.txt-to-improve-perform.patch
  bsc#1207987 gh#util-linux/util-linux@1d98827edde4
* Thu Jan 18 2024 sbrabec@suse.com
- Minor multibuild fixes (PED-307):
  * Restore /bin symlinks in util-linux-systemd.
  * Restore compatibility supplements and split-provides.
  * Update safety check instructions.
  * Prevent propagating of structured comments to scriptlets.
* Sun Nov  5 2023 antonio.teixeira@suse.com
- Convert to multibuild (PED-307)
* Tue Jan 24 2023 pgajdos@suse.com
- added patches [bsc#1197437]
  fix https://git.kernel.org/pub/scm/utils/util-linux/util-linux.git/patch/?id=f4d9018183ff9a6cd6a77bf33461b60570ec7622
  + util-linux-flock-limitations.patch
* Tue Jan  3 2023 david.anes@suse.com
- Disable broken test in IBS (builds fine locally) (bsc#1206740)
* Fri Dec  9 2022 david.anes@suse.com
- Fix tests not passing when '@' character is in build path:
  Fixes rpmbuild %%checks fail when @ in the directory path (bsc#1194038).
- Add util-linux-fix-tests-when-at-symbol-in-path.patch
* Thu Dec  1 2022 sbrabec@suse.com
- libuuid continuous clock handling for time based UUIDs:
  Prevent use of the new libuuid ABI by uuidd %%post before update
  of libuuid1 (bsc#1205646).
- util-linux-uuidd-prevent-root-owning.patch: Use chown --quiet
  to prevent error message if /var/lib/libuuid/clock.txt does not
  exist.
* Tue Oct 18 2022 sbrabec@suse.com
- Fix file conflict during upgrade (boo#1204211).
* Mon Sep 19 2022 sbrabec@suse.com
- Update to version 2.37.4 (PED-1869):
  * Fix security issue in chsh(1) and chfn(8) (CVE-2022-0563).
    SUSE is not affected (bsc#1196241).
  * CVE-2021-3996 (bsc#1194976, obsoletes
    util-linux-libmount-fix-deleted-suffix-CVE-2021-3996.patch)
    Improper UID check in libmount allows an unprivileged user to unmount FUSE
    filesystems of users with similar UID.
  * CVE-2021-3995 (bsc#1194976, obsoletes
    util-linux-libmount-check-fuse-umount-CVE-2021-3995.patch)
    This issue is related to parsing the /proc/self/mountinfo file allows an
    unprivileged user to unmount other user's filesystems that are either
    world-writable themselves or mounted in a world-writable directory.
- linux-fs.patch: Fix conflict between <linux/fs.h> and <sys/mount.h>
* Mon Sep 19 2022 sbrabec@suse.com
- libuuid improvements (bsc#1201959, PED-1150):
  * libuuid: Fix range when parsing UUIDs
    (util-linux-libuuid-uuid_parse-overrun.patch).
  * Improve cache handling for short running applications-increment
    the cache size over runtime
    (util-linux-libuuid-improve-cache-handling.patch).
  * Implement continuous clock handling for time based UUIDs
    (util-linux-libuuid-continuous-clock-handling.patch).
  * Check clock value from clock file to provide seamless libuuid
    update (util-linux-libuuid-check-clock-value.patch).
* Fri Jun 24 2022 sbrabec@suse.com
- agetty: Resolve tty name even if stdin is specified (bsc#1197178,
  util-linux-agetty-resolve-tty-if-stdin-is-specified.patch).
- libmount: When moving a mount point, update all sub mount entries
  in utab (bsc#1198731,
  util-linux-libmount-moving-mount-point-sub-mounts.patch,
  util-linux-libmount-fix-and-improve-utab-on-ms_move.patch).
* Fri Mar 18 2022 sbrabec@suse.com
- Extend cache in uuid_generate_time_generic() (bsc#1194642#c51,
  util-linux-libuuid-extend-cache.patch).
* Fri Mar  4 2022 sbrabec@suse.com
- Prevent root owning of /var/lib/libuuid/clock.txt
  (bsc#1194642, util-linux-uuidd-prevent-root-owning.patch).
* Thu Mar  3 2022 sbrabec@suse.com
- Make uuidd lock state file usable and time based UUIDs safe again
  (bsc#1194642, util-linux-uuidd-fix-lock-state.patch).
* Thu Mar  3 2022 sbrabec@suse.com
- Fix "su -s" bash completion
  (bsc#1172427, util-linux-bash-completion-su-chsh-l.patch).
* Mon Jan 31 2022 sbrabec@suse.com
- Implement "X-fstrim.notrim" fstab mount option that skips fstrim
  for selected device (jsc#SLE-17942,
  util-linux-fstrim-implement-X-fstrim.notrim.patch).
* Mon Jan 24 2022 sbrabec@suse.com
- Fix unauthorized umount (CVE-2021-3995, CVE-2021-3996,
  bsc#1194976,
  util-linux-libmount-check-fuse-umount-CVE-2021-3995.patch,
  util-linux-libmount-fix-deleted-suffix-CVE-2021-3996.patch).
* Sat Dec 18 2021 sbrabec@suse.com
- blockdev: Remove NBSP character in values (bsc#1188507#c31,
  blockdev-remove-nbsp.patch).
* Tue Dec 14 2021 sbrabec@suse.com
- The legacy code does not support /etc/login.defs.d used by YaST.
  Enable libeconf to read it (bsc#1192954).
* Wed Nov 17 2021 sbrabec@suse.com
- Update to version 2.37.2:
  * No longer uses Groff to maintain man-pages.
  * New implementation of hardlink.
  * lscpu reimplemented.
  * uclampset: new util to manipulate the utilization clamping
    attributes of the system or a process.
  * hexdump automatically uses -C when called as "hd".
  * dmesg supports new command-line options --since and --until.
  * findmnt supports new command-line options --shadowed to print
    only filesystems over-mounted by another filesystem.
  * mount supports --read-only command-line option for non-root
    users too.
  * umount(8) can umount also all over-mounted filesystems (more
    filesystems on the the same mount point) when executed with
  - -recursive.
  * libfdisk (and fdisk, sfdisk, cfdisk) supports partition type
    names on input, ignoring the case of the characters and all
    non-alphanumeric and non-digit characters in the name
    (e.g. type="Linux /usr x86" is the same as type="linux usr-x86"
    for sfdisk).
  * libmount no longer contains a workaround to detect inconsistent
    /proc/self/mountinfo reads.
  * libblkid supports "probing hints" now. The hints are the
    optional way how to force probing functions to check for
    example another location -- for example specific session on
    multi-session UDF. The command blkid(8) supports this
    functionality with a new --hint option. The library has been
    also extended to support others ISO9660 and UDF identifiers.
  * blkzone provides a new "capacity" command.
  * cfdisk is possible to start in read-only mode by a new
    command-line option --read-only
  * lsblk provides new columns FSROOTS, and MOUNTPOINTS. The column
    MOUNTPOINTS is used in the default output now and this new
    column prints all mount points where the device is used (btrfs
    subvolumes, bind mounts, etc).
  * losetup uses LOOP_CONFIG ioctl now.
  * column supports a new command-line option --table-columns-limit
    to specify a maximal number of the input columns. The last
    column will contain all remaining line data if the limit is
    smaller than the number of the columns in the input data.
  * Obsoletes util-linux-ipcs-shmall-overflow-1.patch,
    util-linux-ipcs-shmall-overflow-2.patch,
    util-linux-ipcs-shmall-overflow-ts.patch,
    util-linux-ipcutils-overflow-CVE-2021-37600.patch.
  * Many other new features and fixes. For the complete list see
    https://www.kernel.org/pub/linux/utils/util-linux/v2.37/v2.37-ReleaseNotes
    https://www.kernel.org/pub/linux/utils/util-linux/v2.37/v2.37.1-ReleaseNotes
    https://www.kernel.org/pub/linux/utils/util-linux/v2.37/v2.37.2-ReleaseNotes
- Update util-linux-login_defs-check.sh and
  login_defs-support-for-util-linux to version 2.37
  (new variable LOGIN_KEEP_USERNAME).
- INCOMPATIBLE CHANGE: Remove the raw utility altogether, as it is
  not even built any more with the latest kernel.
* Thu Oct  7 2021 sbrabec@suse.com
- ipcutils: Avoid potential memory allocation overflow
  (bsc#1188921, CVE-2021-37600,
  util-linux-ipcutils-overflow-CVE-2021-37600.patch).
- Add bc to BuildRequires to run more complete testsuite,
  fix testsuite (bsc#1178236#c19,
  util-linux-ipcs-shmall-overflow-ts.patch).
* Fri Mar 19 2021 sbrabec@suse.com
- ipcs: Avoid overflows (bsc#1178236,
  util-linux-ipcs-shmall-overflow-1.patch,
  util-linux-ipcs-shmall-overflow-2.patch).
* Tue Feb 16 2021 sbrabec@suse.com
- Update to version 2.36.2:
  * agetty: tty eol defaults to REPRINT
  * fsck.cramfs: fix fsck.cramfs crashes on blocksizes > 4K
  * lib/caputils: add fall back for last cap using prctl.
  * lib/signames: change license to public domain
  * libfdisk:
  * (dos) fix last possible sector calculation
  * (script) ignore empty values for start and size
  * ignore 33553920 byte optimal I/O size
  * libmount:
  * add vboxsf, virtiofs to pseudo filesystems
  * do not canonicalize ZFS source dataset
  * don't use "symfollow" for helpers on user mounts (boo#1181750,
    obsoletes util-linux-libmount-dont-use-symfollow.patch)
  * fix /{etc,proc}/filesystems use
  * login: use full tty path for PAM_TTY
  * lsblk: read SCSI_IDENT_SERIAL also from udev
  * rfkill: stop execution when rfkill device cannot be opened
  * setpriv: allow using [-+]all for capabilities.
  * su: use full tty path for PAM_TTY
  * switch_root: check if mount point to move even exists
  * umount:
  * ignore --no-canonicalize,-c for non-root users
  * Show the 'r' option in the help menu
  * Code cleanups and documentation improvements.
  * Translation updates.
* Wed Feb 10 2021 sbrabec@suse.com
- libmount: don't use "symfollow" for helpers on user mounts
  (boo#1181750, util-linux-libmount-dont-use-symfollow.patch)
* Tue Feb  9 2021 jengelh@inai.de
- Override GTKDOCIZE with /bin/true so we can run autoreconf
  without needing gtk-doc as a dependency.
* Thu Feb  4 2021 sbrabec@suse.com
- Merge package with SLE15 SP3 and openSUSE Leap 15.3:
  Obsoletes upstreamed patches:
- libblkid: Do not trigger CDROM autoclose (v2.35, bsc#1084671,
  util-linux-libblkid-cdrom-autoclose-1.patch,
  util-linux-libblkid-cdrom-autoclose-2.patch,
  util-linux-libblkid-cdrom-autoclose-3.patch).
- lscpu: avoid segfault on PowerPC systems with valid hardware
  configurations
  (v2.36.1, bsc#1175623, bsc#1178554, bsc#1178825,
  lscpu-avoid-segfault-on-PowerPC-systems-with-valid-h.patch)
- Fix for SG#57988, bsc#1174942 (v2.36):
  libmount-fix-mount-a-EBUSY-for-cifs.patch: Fix warning on mounts
  to CIFS with mount –a.
- blockdev: Do not fail --report on kpartx-style partitions on
  multipath (v2.36,
  bsc#1168235, util-linux-blockdev-report-dm.patch).
- nologin: Add support for -c to prevent error from su -c
  (v2.35, bsc#1151708, util-linux-nologin-su-c.patch).
- Add libmount-Avoid-triggering-autofs-in-lookup_umount_fs.patch:
  Avoid triggering autofs in lookup_umount_fs_by_statfs
  (v2.36 boo#1168389)
- mount: fall back to device node name if /dev/mapper link not found
  (v2.34, bsc#1149911)
  * Add patch: util-linux-canonicalize-coverity-scan.patch
- De-duplicate fstrim -A properly (v2.34, bsc#1127701,
  util-linux-fstrim-A-1.patch, util-linux-fstrim-A-3.patch,
  util-linux-fstrim-A-4.patch).
- Do not trim read-only volumes
  (v2.34, boo#1106214, util-linux-fstrim-A-2.patch,
  util-linux-fstrim-A-4.patch).
- libmount: To prevent incorrect behavior, recognize more pseudofs
  and netfs (v2.34, bsc#1122417,
  util-linux-libmount-pseudofs.patch).
- agetty: Return previous response of agetty for special characters
  (v2.34, bsc#1085196, bsc#1125886,
  util-linux-agetty-smart-reload-13.patch,
  util-linux-agetty-smart-reload-14.patch).
- Fix problems in reading of login.defs values (v2.34, bsc#1121197,
  util-linux-login_defs-priority1.patch,
  util-linux-login_defs-priority2.patch,
  util-linux-login_defs-SYS_UID.patch).
* Thu Feb  4 2021 sbrabec@suse.com
- Build with libudev support to support non-root users
  (boo#1169006).
- Move findmnt and lsblk to util-linux-systemd, as they use libudev
  (bsc#1169006#c10).
* Fri Jan 29 2021 sbrabec@suse.com
- Do not require libeconf-devel on products without /usr/etc.
* Mon Jan 25 2021 lnussel@suse.de
- s/--enable-vendordir/--with-vendordir/
- remove pam_securetty line again. As long as there is no agreement
  from pam side having it would fail openQA (boo#1033626)
* Sat Jan 16 2021 sbrabec@suse.com
- Update to version 2.36.1:
  * chrt: use SCHED_FLAG_RESET_ON_FORK for sched_setattr()
  * fallocate: fix --dig-holes at end of files
  * fdisk: always report fdisk_create_disklabel() errors
  * flock: keep -E exit status more restrictive
  * fstrim: remove fstab condition from fstrim.timer
  * hexdump: automatically use -C when called as hd
  * hwclock: add fallback if SYS_settimeofday does not exist, fix
    SYS_settimeofday fallback
  * libblkid: allow a lot of mac partitions, fix Atari prober logic,
    limit amount of parsed partitions
  * more libfdisk improvements
  * losetup: avoid infinite busy loop, increase limit of setup
    attempts
  * lsblk: fix -T optional argument, fix SCSI_IDENT_SERIAL, print
    zero rather than empty SIZE, read ID_SCSI_IDENT_SERIAL if
    available
  * lscpu: Add FUJITSU aarch64 A64FX cpupart, Even more Arm part
    numbers, avoid segfault on PowerPC systems with valid hardware
    configurations (bsc#1175623)
  * mount: Add support for "nosymfollow" mount option.
  * pg: fix wcstombs()
  * sfdisk: correct --json --dump false exclusive, fix backward
  - -move-data
  * vipw: fix short write handling in copyfile
  * whereis: fix out of boundary read, support zst compressed man
    pages
  * minor code improvements and fixes
  * minor licensing changes
  * improve docs
- Require both group(uuidd) and user(uuidd).
* Thu Nov 26 2020 jengelh@inai.de
- Do search /usr/sbin for mount helpers. (This drops /sbin/fs,
  /sbin/fs.d, which we do not use in openSUSE.)
* Fri Nov 20 2020 lnussel@suse.de
- prepare usrmerge (boo#1029961)
* Wed Nov  4 2020 werner@suse.de
- Modernize patch util-linux-sulogin4bsc1175514.patch
  * Try to autoconfigure broken serial lines
* Fri Oct 30 2020 werner@suse.de
- Add patch util-linux-sulogin4bsc1175514.patch
  Avoid sulogin failing on not existing or not functional console
  devices (bsc#1175514)
* Wed Sep 16 2020 sbrabec@suse.com
- Fix default permissions of wall and write.
- Update to version 2.36:
  * blkdiscard(8) refuses to proceed if filesystem or RAID
    signatures are found in interactive mode (executed on a
    terminal). The option --force is required to the discard
    data.
  * new commands irqtop(1) and lsirq(1)to monitor kernel
    interrupts.
  * cal(1) provides a new --vertical command line option.
  * blkzone(8) implements open/close/finish commands now.
  * unshare(1) and nsenter(1) commands support the time namespace
    now.
  * agetty(8) now supports multiple paths in the option
  - -issue-file.
  * fdisk(8), sfdisk(8), cfdisk(8), mkswap(8) and wipefs(8) now
    support block devices locking by flock(2), new command line
    option --lock and $LOCK_BLOCK_DEVICE environmental variable.
  * dmesg(1) new command line option --follow-new to wait and
    print only new kernel messages.
  * fdisk(8) new command line option --list-details and
  - -noauto-pt.
  * fdisk(8) and sfdisk(8) support user-friendly aliases for
    partition types.
  * fstrim(8) supports new command line option --listed-in.
  * libfdisk provides API to relocate GPT backup header. New
    command line option "sfdisk --relocate".
  * mount(8) now supports mount by ID= tag.
  * login(1) supports list of "message of the day".
  * All tools which read /etc/login.defs is possible to compile
    with libeconf now.
  * more(1) has been refactored.
  * man pages cleanup
  * other fixes and improvements, see:
    https://mirrors.edge.kernel.org/pub/linux/utils/util-linux/v2.36/v2.36-ReleaseNotes
- Refresh Add-documentation-on-blacklisted-modules-to-mount-8-.patch.
- Drop upstreamed libeconf.patch,
  libmount-Avoid-triggering-autofs-in-lookup_umount_fs.patch.
- util-linux-login_defs-check.sh: Perform all steps to integrate
  MOTD_FIRSTONLY.
- Update baselibs.conf.
* Fri May 22 2020 fvogt@suse.com
- Use plain #!/bin/sh for flushb
* Thu May 21 2020 mcalabkova@suse.com
- Include pam_securetty in login.pamd again (bsc#1033626)
- Update to 2.35.2
  * make glibc 2.31 compatible
- Dropped unneeded patch libfdisk-script-accept-sector-size.patch
* Wed May 13 2020 fvogt@suse.com
- Add patch to fix sfdisk not reading its own scripts:
  * libfdisk-script-accept-sector-size.patch
- Use %%autopatch
* Fri May  8 2020 fvogt@suse.com
- Fix verification of mount, su and umount (bsc#1166948)
* Mon Apr  6 2020 sbrabec@suse.com
- Update to version 2.35.1:
  * agetty: add --show-issue, support for /run/issue and
  * fdisk: Correct handling of hybrid MBR, cleanup wipe warning,
    use 'r' to return from MBR to GPT.
  * lsblk: FSVER column,
    drop e3bb9bfb76c17b1d05814436ced62c05c4011f48.patch.
  * lscpu: Add HiSilicon aarch64 tsv110 cpupart, add a new columns
    to --cache.
  * mount: add --target-prefix.
  * mountpoint: add --nofollow option.
  * script: add --echo, --log-in, --logging-format, --log-out and
  - -log-timing.
  * scriptlive: new command.
  * scriptreplay: add --log-* options, --cr-mode, --stream,
  - -summary, -T --log-timing.
  * sfdisk: add progress bars.
  * unshare: add --keep-caps and --map-current-user options.
  * Many other fixes and improvements, see:
    https://mirrors.edge.kernel.org/pub/linux/utils/util-linux/v2.35/v2.35-ReleaseNotes
    https://mirrors.edge.kernel.org/pub/linux/utils/util-linux/v2.35/v2.35.1-ReleaseNotes
- Refresh libeconf.patch.
* Mon Apr  6 2020 iforster@suse.com
- Add libmount-Avoid-triggering-autofs-in-lookup_umount_fs.patch:
  Avoid triggering autofs in lookup_umount_fs_by_statfs
  (boo#1168389)
* Tue Oct  8 2019 kukuk@suse.de
- libeconf.patch: fix a long int error on 32bit
* Tue Oct  1 2019 kukuk@suse.de
- libeconf.patch: Add support for libeconf
- Move /etc/pam.d/* to /usr/etc/pam.d
- Remove migration code for su from coreutils to util-linux, not
  needed anymore
* Thu Sep 19 2019 lnussel@suse.de
- Do not recommend lang package. The lang package already has a
  supplements.
* Fri Aug 30 2019 olaf@aepfle.de
- lsblk: force to print PKNAME for partition with
  e3bb9bfb76c17b1d05814436ced62c05c4011f48.patch
* Mon Aug 19 2019 kukuk@suse.de
- Remove outdated buildignore for pwdutils, had no effect with
  shadow anyways
* Tue Aug  6 2019 sbrabec@suse.com
- Issue a warning for outdated pam files
  (bsc#1082293, boo#1081947#c68).
- Fix comments and unify look of PAM files (login.pamd,
  remote.pamd, runuser-l.pamd, runuser.pamd, su-l.pamd, su.pamd).
* Wed Jul 31 2019 sbrabec@suse.com
- Update to version 2.34:
  * new command hardlink
  * rewrite of lsblk, now supports --dedup
  * support for FUSE in umount
  * support for "--all -o remount" in mount
  * su: prefer /etc/default/su over /etc/login.defs and ENV_SUPATH
    over ENV_ROOTPATH (bsc#1121197), improved --pty
  * unshare: add -S/--setuid, -G/--setgid, -R/--root and -w/--wd
  * fstrim: do not suppress warnings unless --quiet is used
  * lscpu: print 'Frequency boost' and 'Vulnerability' fields, add
  - -caches
  * logger: merge multiple MESSAGE= lines
  * libblkid: do not depend on libuuid, supports DRBD9 detection
  * libsmartcols: support N:M relationships in tree-like output
  * fstrim and uuidd systemd services: hardening settings to
    improve security and service isolation
  * fstrim: trim root filesystem on --fstab, check for read-only
    filesystems on --all and --fstab (boo#1106214).
  * fstrim -A: properly de-duplicate sub-volumes (boo#1127701).
  * Obsoletes util-linux-login_defs-priority1.patch,
    util-linux-login_defs-priority2.patch and
    util-linux-login_defs-SYS_UID.patch.
  * Many Other fixes, see
    https://www.kernel.org/pub/linux/utils/util-linux/v2.34/v2.34-ReleaseNotes
- Provide and obsolete hardlink package.
- util-linux-login_defs-check.sh: Update checksum, login now
  supports LASTLOG_UID_MAX.
* Mon Jul 22 2019 sbrabec@suse.com
- Fix /etc/default/su comments and create /etc/default/runuser
  (bsc#1121197#31).
- Remove /etc/default/su migration from coreutils.
* Mon Jul  1 2019 sbrabec@suse.com
- Fix license of libraries: LGPL-2.1-or-later and BSD-3-Clause for
  libuuid (bsc#1135708).
* Thu Jun 20 2019 mliska@suse.cz
- Use FAT LTO objects in order to provide proper static library (boo#1138795).
* Tue Jun 18 2019 sbrabec@suse.com
- raw.service: Add RemainAfterExit=yes (bsc#1135534).
* Thu May  9 2019 sbrabec@suse.com
- Update to version 2.33.2 (bsc#1134337):
  * agetty: Fix 8-bit processing in get_logname() (bsc#1125886).
  * mount: Fix "mount" output for net file systems (bsc#1122417).
  * Many Other fixes, see
    https://www.kernel.org/pub/linux/utils/util-linux/v2.33/v2.33.2-ReleaseNotes
* Thu May  2 2019 sbrabec@suse.com
- Fix problems in reading of login.defs values (bsc#1121197,
  util-linux-login_defs-priority1.patch,
  util-linux-login_defs-priority2.patch,
  util-linux-login_defs-SYS_UID.patch).
- Perform one-time reset of /etc/default/su (bsc#1121197).
- Add virtual symbols for login.defs compatibility (bsc#1121197).
- Add login.defs safety check util-linux-login_defs-check.sh
  (bsc#1121197).
* Mon Mar  4 2019 sbrabec@suse.com
- Integrate pam_keyinit pam module to login
  (boo#1081947, login.pamd, remote.pamd).
* Mon Mar  4 2019 dimstar@opensuse.org
- Drop bc BuildRequires: not needed.
* Thu Feb 21 2019 mwilck@suse.com
-  libmount: remove jffs2 and ubifs from blacklist (jsc#SLE-4085).
* Thu Feb  7 2019 mwilck@suse.com
- libmount: print a blacklist hint for "unknown filesystem type"
  (jsc#SLE-4085, fate#326832), and add documentation
  * add libmount-print-a-blacklist-hint-for-unknown-filesyst.patch
  * add Add-documentation-on-blacklisted-modules-to-mount-8-.patch
* Tue Jan 22 2019 sbrabec@suse.com
- Update to version 2.33.1:
  * agetty fixes (drop util-linux-agetty-smart-reload-10.patch,
    util-linux-agetty-smart-reload-11.patch,
    util-linux-agetty-smart-reload-12.patch).
  * Other minor fixes and documentation updates.
* Fri Jan  4 2019 sbrabec@suse.com
- agetty: Fixes for reload issue only if it is really needed
  (bsc#1085196, boo#1120298,
  util-linux-agetty-smart-reload-10.patch,
  util-linux-agetty-smart-reload-11.patch,
  util-linux-agetty-smart-reload-12.patch).
* Mon Dec 10 2018 sbrabec@suse.com
- Drop rfkill-block@.service and rfkill-unblock@.service that
  functionally conflict with systemd-rfkill@.service
  (boo#1092820#c13).
* Wed Nov 21 2018 sbrabec@suse.com
- Update to version 2.33:
  * choom: new command to adjust and display the current OOM-killer
    score.
  * libsmartcols has been improved to differentiate between
    numbers, booleans and strings in JSON output.
  * fstrim(8): trim all mounted filesystems from /etc/fstab
    (-A|--fstab), new command line option --dry-run.
  * hwclock(8) new command line option --delay.
  * mount umount, libmount allow to mount and umount filesystem in
    another namespace.
  * rename(1) new command line option --interactive.
  * setarch(8) does not require architecture when modify
    personality like ADDR_NO_RANDOMIZE. The architecture argument
    is optional now.
  * command su(1) new command line option --whitelist-environment.
  * setpriv(1) new command line option --reset-env and --pdeathsig.
  * fdisk(8), sfdisk(8): print disk model name to simplify device
    identification.
  * column --table-empty-lines" allows to use empty lines in
    formatted output.
  * wipefs improved to postpone BLKRRPART ioctl until all magic
    strings are wiped.
  * script(1) extended to store more information about terminal
    size and type to the typescript header. New command line
    option --output-limit.
  * libblkid provides BitLocker and basic APFS detection now.
  * lsblk is possible to execute against /sys and /proc dumps with
  - -sysroot is specified.
  * agetty(8) reload issue only if it is really needed
    (bsc#1085196).
- Drop klogconsole in favor of dmesg --console-level plus
  setlogcons (kbd) (boo#1116277).
* Fri Oct 26 2018 sbrabec@suse.com
- Fix runstatedir path (to /run) (boo#1113188#c1).
* Fri Oct 12 2018 sbrabec@suse.com
- Create empty /etc/issue.d for the new agetty feature.
* Thu Sep 27 2018 sbrabec@suse.com
- Drop obsolete downstream ppc utilities
  chrp-addnote and mkzimage_cmdline (boo#1109284).
- Drop obsolete setctsid (boo#1109290).
* Mon Aug  6 2018 sbrabec@suse.com
- Update to version 2.32.1:
  * cal(1) has been improved and extended.
  * libblkid has been extended to support LUKS2, Micron mpool, VDO
    and Atari partition table.
  * rfkill(8) has been moved to /usr/sbin.
  * dmesg(1) provides better support for multi-line messages, new
    command line option --force-prefix.
  * fallocate(1) --dig-holes is faster and more effect now.
  * fdisk(8) provides access to Protective MBR accessible from main
    menu. Sun label support has been improved.
  * lscpu(1) provides more details about ARM CPUs now
    (FATE#326453).
  * lsmem(1) supports memory zone awareness now (FATE#324252,
    drop util-linux-lsmem-memory-zone-1.patch,
    util-linux-lsmem-memory-zone-2.patch,
    util-linux-lsmem-memory-zone-3.patch).
  * lsns(8) provides netnsid and nsfs columns now.
  * rtcwake(8) waits stdin to settle down before entering a system
    sleep.
  * Many fixes and improvements, see
    https://www.kernel.org/pub/linux/utils/util-linux/v2.32/v2.32-ReleaseNotes
    https://www.kernel.org/pub/linux/utils/util-linux/v2.32/v2.32.1-ReleaseNotes
    (drop util_linux_bigendian.patch, util-linux-cramfs.patch,
    util-linux-fincore-count.patch,
    util-linux-sysfs-nvme-devno.patch, util-linux-lscpu-loop.patch,
    util-linux-libmount-umount-a-segfault.patch,
    util-linux-libmount-mount-a-nfs-bind-mount.patch,
    util-linux-lscpu-chcpu-new-cpu-macros.patch,
    util-linux-chcpu-cpu-count.patch).
* Tue Jul  3 2018 sbrabec@suse.com
- Switch python-libmount to python3-libmount.
* Tue May 22 2018 tchvatal@suse.com
- Do not run rfkill-block@.service and rfkill-unblock@service as it
  is just template without parameter bsc#1092820 bsc#1093176
* Thu May 10 2018 sbrabec@suse.com
- Fix lscpu and chcpu on systems with >1024 cores
  (bnc#1091164, util-linux-lscpu-chcpu-new-cpu-macros.patch).
- Fix CPU count in chcpu
  (bnc#1091164, util-linux-chcpu-cpu-count.patch).
* Thu Apr 19 2018 sbrabec@suse.com
- Backport three upstream patches:
  * Fix crash loop in lscpu
    (bsc#1072947, util-linux-lscpu-loop.patch).
  * Fix possible segfault of umount -a
    (util-linux-libmount-umount-a-segfault.patch).
  * Fix mount -a on NFS bind mounts (bsc#1080740,
    util-linux-libmount-mount-a-nfs-bind-mount.patch).
* Thu Apr 12 2018 sbrabec@suse.com
- Integrate pam_keyinit pam module (boo#1081947, su-l.pamd,
  runuser-l.pamd, runuser.pamd).
* Wed Apr  4 2018 sbrabec@suse.com
- su.default: Set ALWAYS_SET_PATH default to "yes" (bsc#353876#c7);
  add one-time wrapper forcing ALWAYS_SET_PATH on upgrade.
* Tue Mar 20 2018 kukuk@suse.de
- Use %%license instead of %%doc [bsc#1082318]
* Fri Feb  9 2018 sbrabec@suse.com
- Fix lsblk on NVMe
  (bsc#1078662, util-linux-sysfs-nvme-devno.patch).
* Wed Jan 31 2018 sbrabec@suse.com
- Update to version 2.31.1:
  * blkid: Add support for LUKS2 and new LABEL attributes.
  * move rfkill to /usr/sbin (boo#1076134).
  * fsck.cramfs: Fix bus error on broken file system.
  * hwclock: add iso-8601 overflow check
  * libmount:
  * Allow MNT_FORCE and MNT_DETACH at umount
  * add nsfs between pseudo filesystems
  * lscpu: Treat read failure on Xen Hypervisor properties as
    non-fatal
  * sha1: endian fixes (affects util_linux_bigendian.patch)
  * documentation updates
  * other fixes and improvements
- Fix regressions in 2.31.1:
  * sha1 on s390* (update util_linux_bigendian.patch)
  * fsck.cramfs on ppc64le (util-linux-cramfs.patch)
  * fincore/count (disable, util-linux-fincore-count.patch)
* Sun Jan 21 2018 jengelh@inai.de
- Combine %%service_* calls again.
* Thu Jan 18 2018 bwiedemann@suse.com
- Provide /usr/sbin/rfkill from rfkill package (boo#1076134)
* Tue Jan 16 2018 normand@linux.vnet.ibm.com
- Add util_linux_bigendian.patch solve two failing tests on ppc64
  (sha1, uuid/oids)
* Fri Jan 12 2018 sbrabec@suse.com
- Integrate rfkill-block@.service and rfkill-unblock@.service from
  rfkill package (boo#1074250#c4).
- Remove unneeded release based conflicts and obsolescences
  (boo#1074250#c18).
- Remove sysvinit requirement.
* Mon Jan  1 2018 antoine.belvire@opensuse.org
- Fix Obsoletes for rfkill (boo#1074250).
* Mon Dec 18 2017 sbrabec@suse.com
- Update bash completion conflict to cover rfkill file conflict.
* Mon Dec  4 2017 sbrabec@suse.com
- lsmem: Add support for zone awareness (bsc#1065471, FATE#324252,
  util-linux-lsmem-memory-zone-1.patch,
  util-linux-lsmem-memory-zone-2.patch,
  util-linux-lsmem-memory-zone-3.patch).
- Drop util-linux-losetup-Add-support-for-setting-logical-blocksize.patch.
  Different implementations exists in the new kernel, and it has
  a conflicting implementation in util-linux.
* Mon Nov 20 2017 sbrabec@suse.com
- Update to version 2.31:
  * New utilities: uuidparse, rfkill.
  * su has been refactored and extended to create pseudo terminal
    (new option --pty, CVE-2016-2779, bsc#968674). This new
    EXPERIMENTAL feature provides better isolation between root's
    terminal and an unprivileged su.
  * libuuid: Improved to match
  * libuuid, uuidgen: support hash-based UUIDs v3 (md5) and v5
    (sha1) as specified by RFC-4122. Provide UUID templates for
    dns, url, oid, or x500.
  * libblkid: Extended support for DM-integrity, HPE (aka
    extended-XFS) and UBI superblock. New API to hide already
    detected signatures.
  * libfdisk: New API to modify grain, make possible to completely
    disable dialog driven partitioning.
  * libsmartcols: New API to move columns.
  * column: --table-header-repeat to repeat table headers.
  * libfdisk: Use BLKPG ioctls to inform the kernel about changes.
  * fdisk: Improved ^C and ^D behavior.
  * cfdisk: Dialog to resize partition.
  * look: Follow the WORDLIST environment variable.
  * losetup: Added support for --sector-size (FATE#319010).
  * script: Follow the usual semantics for stop/continue signals.
  * setpriv: New command line options --ambient-caps and
  - -init-groups.
  * hwclock: Reduce system shutdown times, log --systz when using
    libaudit.
  * Other bug fixes.
- Drop upstreamed util-linux-use-tinfow.patch.
- Refreshed make-sure-sbin-resp-usr-sbin-are-in-PATH.diff.
* Thu Sep 21 2017 jengelh@inai.de
- Update RPM categories and summaries.
  Do not ignore errors from useradd.
* Tue Sep 19 2017 sbrabec@suse.com
- Link against tinfow instead of tinfo
  (bsc#1056171, util-linux-use-tinfow.patch).
* Fri Sep 15 2017 werner@suse.de
- Ensure libreadline usage as well as _GNU_SOURCE
* Tue Sep 12 2017 sbrabec@suse.com
- Fix prerequirement of groups tty and uuidd (boo#1057937).
* Thu Jul 20 2017 sweet_f_a@gmx.de
- Update to version 2.30.1:
  Bugfix release, more details at:
  https://www.kernel.org/pub/linux/utils/util-linux/v2.30/v2.30.1-ReleaseNotes
- Drop upstreamed patch
  util-linux-lscpu-cleanup-DMI-detection-return-codes.patch
* Mon Jul  3 2017 schwab@suse.de
- Make sure group tty is defined
* Sun Jun 11 2017 lnussel@suse.de
- don't conflict with sysvinit-tools in Tumblweed anymore. Needed for Leap 15
  which wants to use a different release number scheme (lp150.x which produces
  lower numbers than the conflict).
* Thu Jun  8 2017 sweet_f_a@gmx.de
- Update to version 2.30:
  * Many changes and improvements, most notably:
  * The libblkid library has been improved for hybrid CDROM/DVD
    media.
  * The deprecated command tailf has been removed. Use "tail -f"
    from coreutils.
  * blkzone -- NEW COMMAND to run zone commands on block devices
    that support Zoned Block Commands (ZBC) or Zoned-device ATA
    Commands (ZAC).
  * fincore -- NEW COMMAND to count pages of file contents in
    core (memory).
  * lsmem -- NEW COMMAND to list the ranges of available memory
    with their online status.
  * The command fallocate -- supports an "insert range" operation
    now.
  * The command "column -t|--table" has been modified to use
    libsmartcols. It now provides nearly all of that library's
    functionality from the command line.
  * Security issues:
  * hwclock - no longer makes any internal permission checks. The
    System Administrator must set proper permissions to control
    user access to the RTC. It is NOT recommended to use SUID.
  * CVE-2016-2779 - This security issue is NOT FIXED yet.
  * More details at:
    https://www.kernel.org/pub/linux/utils/util-linux/v2.30/v2.30-ReleaseNotes
- Drop upstreamed patch
  arm64-lscpu-use-sysfs-for-table-access-if-available.patch
- Refreshed patch
  util-linux-losetup-Add-support-for-setting-logical-blocksize.patch
- fix compiler warnings for mkzimage_cmdline
* Thu Jun  8 2017 msuchanek@suse.com
- When when hypervisor_decode_sysfw fails continue with other
  detection methods (bsc#1042991, bsc#1039360, bsc#1033718)
  + util-linux-lscpu-cleanup-DMI-detection-return-codes.patch
* Wed Apr 12 2017 agraf@suse.com
- Prefer sysfs exported SMBIOS3 tables in lscu (bsc#1033718)
  + arm64-lscpu-use-sysfs-for-table-access-if-available.patch
* Thu Apr  6 2017 sbrabec@suse.com
- To cover release numbers of both SLE12 SP3 and Leap 42.3, relax
  release based conflict with bash-completion from 13.1 to 10.
* Tue Apr  4 2017 sweet_f_a@gmx.de
- fix util-linux-losetup-Add-support-for-setting-logical-blocksize.patch
  - -logical-blocksize was behaving like --nooverlap
* Fri Mar 17 2017 sbrabec@suse.com
- Conflict with old systemd-presets-branding to ensure correct
  preset migration (boo#1029775, bsc#1012850).
* Thu Mar 16 2017 sbrabec@suse.com
- Drop "codepage" fstab migration needed for SuSE Linux < 9.1
  (bsc#51950 (suse#36950)).
* Tue Feb 28 2017 sbrabec@suse.com
- Keep dependency on insserv and fillup for compatibilitiy reasons
  in Leap 42.3. Too many poorly written packages depend on it.
  (Marked as "sysv compatibility hack".)
* Wed Feb 22 2017 sweet_f_a@gmx.de
- Update to version 2.29.2:
  * su(1) security issue CVE-2017-2616 (bsc#1023041)
  * minor bugfixes and enhancements
* Fri Feb 10 2017 fbui@suse.com
- presets are managed by the branding presets package (bsc#1012850)
  The default activation state is defined by the branding preset
  package.
  This also get rid of the only use of the rpm preset macros so we can
  kill them.
* Wed Feb  8 2017 sbrabec@suse.com
- Merge SLE12 SP3 changes to make the package compatible with
  Tumbleweed, SLE12 SP3 and Leap 42.3.
- Drop patch tests-script-race-on-force-only.patch from SLE12 SP3
  and Leap 42.3. Upstream has a different workaround.
  https://github.com/karelzak/util-linux/issues/296
- INCOMPATIBLE CHANGE for SLE12 SP3 and Leap 42.3:
  losetup -L changes its meaning from SLE12 SP1&SP2 specific
  - -logical-blocksize to the upstream --nooverlap).
  - -logical-blocksize can be used only with long option
  (bsc#966891).
- Include SLE12 + Leap 42 exclusive feature, implemented by
  hare@suse.de:
  * losetup: Add support for setting logical blocksizes
    (bsc#931634, FATE#319010)
    + util-linux-losetup-Add-support-for-setting-logical-blocksize.patch
  SLE12 & Leap 42 specific changes:
  * Fix for SLE12: bsc#956540, SLE12 SP1: bsc#953691, Leap 42.1:
    boo#954482, was obsoleted by the systemd update, and skipped.
  * Remove --enable-ncurses that is intended to force non-wide
    ncurses (boo#978993).
  * Make release-dependent conflict with old sysvinit-tools SLE
    specific, as it is required only for SLE 11 upgrade,
    and breaks openSUSE staging builds (boo#994399).
  * Obsolete these patches, now upstreamed:
  * Drop upstreamed patches
    (tests-script-race-on-force-only.patch,
    util-linux-libmount-ignore-redundant-slashes.patch,
    util-linux-sfdisk-show-pt-geometry-1.patch,
    util-linux-sfdisk-show-pt-geometry-2.patch,
    util-linux-sfdisk-show-pt-geometry-3.patch,
    util-linux-libblkid-partition-loop.patch,
    util-linux-libblkid-wipe-offset.patch,
    util-linux-mount-reuse-loop-1.patch,
    util-linux-mount-reuse-loop-2.patch,
    util-linux-mount-reuse-loop-3.patch,
    util-linux-mount-reuse-loop-4.patch,
    util-linux-loop-reuse-01.patch, util-linux-loop-reuse-02.patch,
    util-linux-loop-reuse-03.patch, util-linux-loop-reuse-04.patch,
    util-linux-loop-reuse-05.patch, util-linux-loop-reuse-06.patch,
    util-linux-loop-reuse-07.patch, util-linux-loop-reuse-08.patch,
    util-linux-loop-reuse-09.patch, util-linux-loop-reuse-10.patch,
    util-linux-loop-reuse-12.patch, util-linux-loop-reuse-13.patch,
    util-linux-loop-reuse-14.patch, util-linux-loop-reuse-15.patch,
    util-linux-loop-reuse-16.patch, util-linux-loop-reuse-17.patch,
    util-linux-loop-reuse-18.patch, util-linux-loop-reuse-19.patch,
    util-linux-loop-reuse-20.patch,
    util-linux-libmount-cifs-is_mounted.patch).
  * Refreshed patches
    (make-sure-sbin-resp-usr-sbin-are-in-PATH.diff,
    util-linux-losetup-Add-support-for-setting-logical-blocksize.patch).
* Tue Feb  7 2017 sbrabec@suse.com
- Update to version 2.29.1:
  * lscpu: add aarch64 specific names
  * lubmount: Disable disable ro/rw mtab checks (bsc#1012632)
  * More details at:
    https://www.kernel.org/pub/linux/utils/util-linux/v2.29/v2.29.1-ReleaseNotes
* Tue Feb  7 2017 sbrabec@suse.com
- Replace raw initscript by a systemd service doing the same thing.
  Based on previous work of fcrozat@suse.com (FATE#321122).
* Thu Jan  5 2017 sweet_f_a@gmx.de
- don't install bash-completions for uninstalled binaries (chfn,
  chsh, newgrp, pg)
- for now remove procps dependency  which is only needed for tests
  because it pulls systemd
* Thu Dec 15 2016 fbui@suse.com
- Replace pkgconfig(libsystemd-*) with pkgconfig(libsystemd)
  libsystemd-* libs were deprecated and are gone now.
* Wed Dec  7 2016 sbrabec@suse.com
- Remove no more supported --enable-libmount-force-mountinfo.
  There is --enable-libmount-support-mtab, disabled by default,
  exactly as we need.
* Tue Nov  8 2016 sweet_f_a@gmx.de
- Update to version 2.29 (FATE#322090)
  * cal: possible to specify month by name (e.g. "cal January
    2017") and use relative placeholders (cal "+1 month")
  * fdisk(8) allows to wipe newly created partitions; the feature
    is possible to control by new command line option
  - -wipe-partitions[==auto|never|default].
  * findmnt --verify: the command scans /etc/fstab and tries to
    verify the configuration.
  * mount(8) now rejects requests to create another device and
    mount filesystem for the same backing file. The command
    `losetup --nooverlap` reuses loop device if already exists
    for the same backing file. All the functionality calculate
    with offset and sizelimit options of course, so it's fine to
    have multiple regions (partitions) in the same image file and
    mount all of them in the same time. The restriction is that
    the regions should not overlap.
  * lscpu supports the "drawer" topology for IBM S/390.
  * sfdisk: Support for deprecated --show-pt-geometry (bsc#990531).
  * libmount: various issues with cifs mount
    (bsc#982331, bsc#987176).
  * libblkid: Prevent infinite loop DoS while parsing DOS partition
    tables (bsc#988361, CVE-2016-5011).
  * More details at:
    http://karelzak.blogspot.de/2016/10/util-linux-v229-whats-new.html
    https://www.kernel.org/pub/linux/utils/util-linux/v2.29/v2.29-ReleaseNotes
- refresh make-sure-sbin-resp-usr-sbin-are-in-PATH.diff
* Wed Sep  7 2016 sweet_f_a@gmx.de
- Update to version 2.28.2, bugfix release, see
  https://www.kernel.org/pub/linux/utils/util-linux/v2.28/v2.28.2-ReleaseNotes
* Thu Aug 11 2016 sweet_f_a@gmx.de
- Update to version 2.28.1, bugfix release, see
  https://www.kernel.org/pub/linux/utils/util-linux/v2.28/v2.28.1-ReleaseNotes
- Remove util-linux-libblkid-wipe-offset.patch (upstream)
- use the new configure option --enable-libuuid-force-uuidd
  instead of sed'ing configure.ac
* Thu Aug 11 2016 olaf@aepfle.de
- Install klogconsole with read permissions (bnc#990837)
* Mon Jul 11 2016 dimstar@opensuse.org
- BuildIgnore util-linux: it's part of VMInstall, hence part of
  every package build. util-linux itself can be built without its
  own presence though. Helps with some rare bootstrap issues (when
  librtas changes soname for example).
- Drop usage of gpg-offline: this has long been migrated to a
  source service that checks signatures on checkin already (osc
  service lr source_validatory).
* Mon Jun 13 2016 dimstar@opensuse.org
- Do not BuildRequires bash-completion: this is tempting, but it
  pulls bash-completion and its entire dependency stack into Ring0,
  which is inacceptable. Pass the correct path
  (%%{_datdir}/bash-completion/completions) via
  - -with-bashcompletiondir to configure.
* Thu May 19 2016 sbrabec@suse.com
- blkid: Wipe corect area for probes with offset (bsc#976141,
  util-linux-libblkid-wipe-offset.patch).
* Tue Apr 26 2016 sbrabec@suse.com
- Remove incorrect --with-bashcompletiondir that breaks
  bash-completion, use path in bash-completion.pc instead
  (boo#977259).
* Fri Apr 22 2016 sbrabec@suse.com
- Add librtas-devel to BuildRequires on Power platforms. Needed for
  proper function of lscpu (bsc#975082).
* Wed Apr 13 2016 sweet_f_a@gmx.de
- fix build for openSUSE >= 13.1 (inclusive SLE 12)
- drop build for openSUSE < 13.1
- remove old build conditions: sysvinit_tools, enable_su and
  enable_eject
- cosmetics: reorder configure options
* Wed Apr 13 2016 sweet_f_a@gmx.de
- Update to version 2.28 (bsc#974301):
  * Many changes and improvements, most notably:
  * Now cfdisk, sfdisk and fdisk wipe all filesystem and RAID
    signatures when creating a new disk label in interactive
    mode. See --wipe[=auto|never|always].
  * lsns -- this NEW COMMAND lists information about all
    currently accessible namespaces or about the given namespace.
  * The command sfdisk supports new operations --delete,
  - -move-data and --reorder.
  * The command blkdiscard supports a new option --zeroout to
    zero-fill rather than discard a specified area.
  * The command cal supports a new option --span to span the date
    when displaying multiple months.
  * The command chrt supports the DEADLINE scheduling class and
    the new options --sched-runtime --sched-period and
  - -sched-deadline.
  * The command logger supports RFC 5424 structured data through
    the new options --sd-id and --sd-param.
  * The command losetup supports a new option --direct-io.
  * The command lsblk allows to sort output by unprinted columns.
  * The command mount applies the nofail mount option to
    ENOMEDIUM errors.
  * The commands nsenter and unshare support a new option
  - -cgroup for work with cgroups namespaces (CLONE_NEWCGROUP).
  * The library libmount has been improved to properly detect
    already mounted btrfs subvolumes (bsc#947494, bsc#972684).
  * The library libsmartcols has been massively improved to print
    table ranges, multi-line cells, table titles and to support
    continuous printing.
  * The package build system and code have been improved to be
    more portable to non-Linux systems (BSD, OSX).
  * The package does not provide fallback solutions for
    openat-family functions anymore.
  * The python binding for libsmartcols is available in separate
    project at https://github.com/ignatenkobrain/python-smartcols
  * Other bug fixes (bsc#970404, bsc#975082, FATE#318444).
  * Security issue: CVE-2016-2779 is NOT FIXED yet.
- Remove old util-linux-noenc-suse.patch
* Tue Dec  1 2015 sweet_f_a@gmx.de
- enable last binary
* Wed Nov 11 2015 sweet_f_a@gmx.de
- Update to version 2.27.1, bugfix release, see
  https://www.kernel.org/pub/linux/utils/util-linux/v2.27/v2.27.1-ReleaseNotes
  (fixes bsc#950778, FATE#320552).
* Wed Nov 11 2015 schwab@suse.de
- Change condition for known fail markers from test for armv6 and aarch64
  architecture to test for qemu user-space build
* Wed Sep 23 2015 sbrabec@suse.com
- Update to version 2.27:
  * Many changes and improvements, most notably:
  * lsipc: new command
  * unshare provides a new option --propagation=
  * mount(8) supports read-only binds in one (not atomic) step by
    "bind,ro".
  * GNU readline support in fdisk and sfdisk.
  * JSON support in libsmartcols and findmnt, losetup, lsblk,
    lslocks, sfdisk and lsipc.
  * script has been massively improved to be more robust and less
    complex (bsc#888678, bsc#930236).
  * sulogin supports locked root accounts by --force
    (bsc#968733, bsc#963399).
  * colors support by default. It is possible to change this
    with --disable-colors-default.
  * more information in cfdisk
  * fdisk provides new commands 'F' and 'i'
  * cal supports the new options --twelve and --months <n>
  * rtcwake supports a news option --list-modes and --date, no
    support RTC_ALM_READ and RTC_ALM_SET fallbacks any more.
  * Many fixes, most notably:
  * fsck: now supports -r {fd} (bsc#923777, bsc#903738)
  * Fix fsck -C {fd} parsing (bsc#923777, bsc#903738)
  * better handling of multi-path devices
    (bsc#880468, bsc#924994)
  * flock: improve timeout handling (bsc#926945)
  * lsblk: display mountpoint even for top-level device
    (bsc#943415)
  * colcrt: fix buffer overflow (bsc#949754, CVE-2015-5218)
* Wed Aug 19 2015 sbrabec@suse.com
- Add licenses.
* Tue Aug  4 2015 sbrabec@suse.com
- Add %%systemd_preset_pre and %%systemd_preset_posttrans that will
  do one shot presetting of uuidd.service on upgrade.
  (bnc#900935#c46, FATE#318949, FATE#317727).
- Remove one shot presetting hacks.
* Mon May 25 2015 crrodriguez@opensuse.org
- Build with --enable-libmount-force-mountinfo the rationale is
  identical to the following commit message --> http://bit.ly/1eqf5GO
  The default behaviour is undesirable and fragile when using
  systemd.
* Fri May  1 2015 sweet_f_a@gmx.de
- Update to util-linux-2.26.2:
  * many fixes, most notable for logger, *fdisks and mount
  * (lib)mount, add support for MS_LAZYTIME
- disable libmount/lock test to avoid random timeouts
- socat is needed for logger tests
* Fri Mar 13 2015 sweet_f_a@gmx.de
- Update to util-linux-2.26.1:
  * cal(1): do not segfault when TERM is not defined or wrong
    (bnc#903440)
  * logger(1): major fixes and enhancements
  * agetty(8): support /usr/lib/os-release too
  * some more fixes, mostly minor ones, see ReleaseNotes
- re-enable fixed tests (fdisk/bsd, ppc64le)
* Wed Feb 25 2015 sbrabec@suse.cz
- Update to util-linux-2.26:
  * based on the git master branch of util-linux, remove backported
    patches (util-linux-libblkid-unsafe-chars.patch,
    util-linux-libblkid-overflow.patch)
  * zramctl(8): this NEW COMMAND allows to control /dev/zramN
    devices
  * agetty(8): supports new option --reload to force already
    running agetty processes to reprint the /etc/issue file
  * cfdisk(8), sfdisk(8) and fdisk(8): support sfdisk-compatible
    scripts; it's possible to save your partitioning layout to text
    files and (re)use it in all fdisks
  * fdisk(8), sfdisk(8): support new command-line option "--output
    <list>" to specify output columns for --list or print commands,
    do not abort when fdisk -l when device cannot be opened
    [bnc#886790], [bnc#893712], [bnc#890351]
  * nsenter(1): has been updated to work with the latest kernel
    changes in user namespaces supports new command-line option
  - -preserve-credentials
  * unshare(1): has been updated to work with the latest kernel
    changes in user namespaces supports new command-line option
    "--setgroups=<deny|allow>"
  * swapon(8): supports new command-line option "-o <list>" with
    the same semantics as -o for mount(8); it's now possible to
    specify swap options on the command line by the same string as
    in fstab
  * fdformat(8): supports new command-line options --from and --to
    to specify tracks and --repair for broken floppies
  * getopt(1): has been updated to the latest version (originally
    maintained outside of util-linux) and refactored
  * ldattach(8): has been improved to support GSM0710 and intro
    modem commands
  * logger(1): supports new command-line option --id= to specify
    PID (or another ID) allows to specify --rfc3164 or --rfc5424
    syslog protocols
  * lscpu: recognizes Unisys s-Par as hypervisor (FATE#318231)
  * libfdisk: the library is distributed as a shared library with a
    stable API and a standard header file
  * libmount: provides a new simple API to monitor mount-table
    changes (including changes in userspace mount options)
  * libmount: Fix mount point lookup (and mount -a) if the path
    contains // (bsc#931955).
- Fix lack of I18N support in util-linux-systemd (mis-compilation).
* Sun Feb 22 2015 crrodriguez@opensuse.org
- Build with FULL RELRO.
* Tue Feb 10 2015 sweet_f_a@gmx.de
- define upstream source for klogconsole to remove patches
  * klogconsole-quiet.patch
  * klogconsole.diff
- remove openSUSE 13.1 specific eject permissions, did not worked
  anyway since eject-fpie.patch was removed
- always call autoreconf, not only for splitted packages, skip
  autopoint (gettext)
* Fri Feb  6 2015 dimstar@opensuse.org
- Do not try to unregister an info file (ipc.info.gz) which we do
  not own. Already in May 2011, we stopped registering it: "do not
  register ipc.info.gz (not provided by this package)".
* Wed Feb  4 2015 sbrabec@suse.cz
- libblkid: care about unsafe chars and possible buffer overflow
  in cache (CVE-2014-9114, util-linux-libblkid-unsafe-chars.patch,
  util-linux-libblkid-overflow.patch, bsc#907434)
* Thu Jan 29 2015 sweet_f_a@gmx.de
- Update to version 2.25.2: mostly minor fixes
  (including boo#908742)
- re-enable utmpdump and ipcs tests for all archs
* Thu Jan 15 2015 schwab@linux-m68k.org
- Use util-linux:/bin/logger as split-provide,
  /usr/lib/systemd/system/fstrim.service didn't exist in 13.1
* Sat Jan 10 2015 jengelh@inai.de
- Remove pam_securetty.so from /etc/pam.d/login. By definition,
  local logins are always secure. Remote logins actually use
  /etc/pam.d/remote by way of `/bin/login -h` (such as rlogind).
  This solves the problem that root logins are erroneously rejected
  when using kmscon(8) or `machinectl login`, because they use
  ptys.
* Tue Nov 11 2014 schwab@suse.de
- Remove known fail marker for fdisk/bsd on ppc, ppc64, s390, s390x
* Fri Oct 17 2014 sbrabec@suse.cz
- Fix mis-compilation of libuuid without uuidd support
  (bnc#900935).
- Fix uuidd socket activation (bnc#900935).
- Remove obsolete sysvinit script for uuidd.
- Remove no more needed uuidd permissions stuff.
- Replace PreReq for obsolete pwdutils by names of binaries.
- Add fstrim service scripts and rcfstrim helper.
* Mon Sep  8 2014 sbrabec@suse.cz
- Install runuser and runuser-l PAM file
  (runuser.pamd, bnc#892079, bnc#894833).
* Wed Sep  3 2014 sbrabec@suse.cz
- Update to version 2.25.1:
  * bug fixes (removed util-linux-bash-completion-blockdev.patch,
    util-linux-slash-in-format-string.patch)
  * translation updates
  * correct support for plurals
  * gpt: use real sector size to set PTMAGIC_OFFSET
  * gpt: add Microsoft Storage Spaces GUID
  * libmount: use -t for type.subtype in helpers API
  * erase all traces of the long-obsolete xiafs
* Tue Aug 26 2014 schwab@suse.de
- Always mark ipcs/limits and misc/setarch as known failure
* Tue Aug 26 2014 pgajdos@suse.com
- fix parsing of slash in the format string [bnc#889934] (internal)
- added patches:
  * util-linux-slash-in-format-string.patch
* Thu Aug 21 2014 sbrabec@suse.cz
- Remove hacks for format_spec_file and source_validator
  (bnc#891152, bnc#891829).
- Use macro defined summary that passes both SLE and openSUSE
  check-in QA scripts (invented by Ruediger Oertel).
* Fri Aug  8 2014 sbrabec@suse.cz
- Update to version 2.25
  (using work of Ruediger Meier <sweet_f_a@gmx.de>):
  * based on the git master branch of util-linux
  * many fixes (including bnc#869355, bnc#871951 and
    bnc#871698#c49)
  * new Python binding sub-package for libmount: python-libmount
  * new library: libsmartcols
  * new commands: lslogins, setpriv
  * add fstrim systemd timer
  * better systemd integration
  * DROPPED command:
  * cytune: Upstream decided to remove tool untested for years
    that supports this old hardware.
- Dropped patches included in the upstream:
    (*git) Included with no changes
    (+git) Included with improvements
    (!git) Included with differences
  * support-other-tty-lines-not-vconsole.patch           (*b9c7390)
  * agetty-fooled-on-serial-line-due-plymouth.patch,
  * sulogin-fooled-on-tty-line-due-plymouth.patch        (*bb280f7)
  * agetty-on-s390-on-dev-3270-tty1-line.patch           (*f2bcda5)
  * sulogin-does-not-find-any-console.patch              (*624b204)
  * util-linux-setarch-uname26.patch                     (*f6eb160)
  * util-linux-ng-2.16-squashfs3-detect.patch            (*11402f5)
  * util-linux-lscpu-improve-hypervisor-detection.patch
    (!b774473, b32488c, 5bd31c6, 0f0c558, 96ce475)
    WARNING, INCOMPATIBLE CHANGE: "lscpu -p" no more reports
    hypervisor, as it breaks standard behavior. Use standard output
    instead! (FATE#310255)
  * blkid-stop-scanning-on-I-O-error.patch               (+296d96e)
  * blkid-convert-superblocks-to-new-calling-convention.patch
    (+37f4060)
  * util-linux-libblkid-ext-probe.patch                  (*a1ca32f)
  * util-linux-hwclock-drift-check.patch                 (*f196fd1)
  * util-linux-hwclock-adjtime-check.patch               (*db8fc5f)
- Dropped obsolete patch:
  * util-linux-2.23.1-eject-fpie.patch      (eject is no more SUID)
  * util-linux-2.24-fdisk_remove_bogus_warnings.patch
    (upstream fixed it in a different way)
  * util-linux-HACK-boot.localfs.diff
    (MOUNT_PRINT_SOURCE is no more referenced)
- Ported and renamed:
  * util-linux-2.23.1-noenc-suse.diff
  - > util-linux-noenc-suse.patch
- Split spec file to three stages:
  * util-linux.spec: Everything that do not need python or systemd.
  * util-linux-systemd.spec: Stuff that needs systemd:
    util-linux-systemd and uuidd
    NOTE: Not building systemd-less variants of utilities.
  * python-libmount.spec: Just python-libmount
- Move bash-completion files to correct packages.
- Add patch util-linux-bash-completion-blockdev.patch.
- Add hacks to prevent damaging of spec files by format_spec_file
  (bnc#891152, also edited util-linux-rpmlintrc).
* Sat Jul 26 2014 dimstar@opensuse.org
- Really fix devel-static requires (libblkid-devel-static).
* Sat Jul 26 2014 coolo@suse.com
- fix requires of devel-static packages
* Thu Jul 24 2014 dsterba@suse.cz
- enable build of libmount-devel-static, libuuid-devel-static and
  libblkid-devel-static
* Tue May 27 2014 sweet_f_a@gmx.de
- use nologin from upstream (was added in 2.24)
- remove unknown configure options
- remove unused and outdated suse READMEs
- require bc for checks
* Fri May 16 2014 sweet_f_a@gmx.de
- Prevent excessive clock drift calculations (bnc#871698,
  util-linux-prevent-excessive-clock-drift-calculations.patch),
  committed by sbrabec@suse.cz
* Thu May  8 2014 werner@suse.de
- Modify patch support-other-tty-lines-not-vconsole.patch to
  make it work on virtual console
- Modify patch agetty-on-s390-on-dev-3270-tty1-line.patch
  to add the missed 3270 support upstream
* Wed May  7 2014 werner@suse.de
- Add patch support-other-tty-lines-not-vconsole.patch
  to be able to support console lines like xvc and hvc
* Thu Apr 24 2014 sweet_f_a@gmx.de
- Update to util-linux-2.24.2:
  addpart:
  * minor man page improvements
  blockdev:
  * Some minor corrections to the manual
  build-sys:
  * don't connect _DEPENDENCIES and _LIBADD
  * fix .h.in usage in libblkid and libmount
  * libmount/python/__init__.py is always a dist file
  chcpu:
  * cleanup return codes
  * cleanup stdout/stderr usage
  delpart:
  * minor man page improvements
  dmesg:
  * -w output not line-buffered
  * don't report EPIPE
  docs:
  * update AUTHORS file
  fallocate:
  * Clarify that space can also be deallocated
  fdformat:
  * Some minor change to the manual
  fdisk:
  * don't colorize "foo " prefixes
  flock:
  * use nfs4 fallback on EBADF too
  fsck:
  * Some typographical corrections to the manual
  fsck.minix:
  * A few typographical corrections to the manual
  fstrim:
  * add hint to man page
  getopt:
  * getopt.1 The usual doc dir is /usr/share/doc, not .../docs
  hwclock:
  * fix possible hang and other set_hardware_clock_exact() issues
  include/closestream:
  * don't wipe errno on EPIPE
  ipcs:
  * cleanup jumplabel stlyes
  * fix ipc_msg_get_info fallback case
  * fix ipc_sem_get_info fallback case
  * fix ipc_shm_get_info fallback case
  * fix memleak in ipc_*_get_info functions
  isosize:
  * A few typographical changes to the manual
  last:
  * fix minor typos in the man page
  lib/sysfs:
  * make dirent d_type usage more robust
  libblkid:
  * add extra checks to XFS prober
  libfdisk:
  * fix logical partition reorder command
  * make qsort_r() optional
  * properly implement read-only mode
  libmount:
  * FS id and parent ID could be zero
  * accept (deleted) path suffix in mountinfo file
  * initialize *root to NULL in mnt_table_get_root_fs
  login:
  * fix minor typos in the man page
  losetup:
  * wait for udev
  lscpu:
  * cleanup, use _PATH_SYS_CPU/NODE
  * don't abort if cache size is unknown
  * don't assume filesystem supports d_type when searching for NUMA nodes
  * read_hypervisor_dmi  only fallback to memory scan on x86/x86_64
  mkfs:
  * Some typographical changes to the manual
  mkfs.bfs:
  * One typographical correction to the manual
  mkfs.cramfs:
  * Some typographical corrections to the manual
  mkfs.minix:
  * Some typographical changes in the manual
  mkswap:
  * Some minor typographical corrections to the manual
  more:
  * improve formatting and wording of man page and help text
  mount:
  * apply "nofail" to MNT_ERR_NOSOURCE libmount error
  * fix --all and nofail return code
  * mount.8 Some typographical and prefix corrections to the manual
  * remove obsolete and confusing statement from mount.8
  * update mount.8 about barrier mount options defaults
  nologin:
  * minor man page improvements
  nsenter:
  * fix set{gid,uid} order,drop supplementary groups
  partx:
  * Improve the typesetting of the manual
  * make dirent d_type usage more robust
  po:
  * merge changes
  * update cs.po (from translationproject.org)
  * update da.po (from translationproject.org)
  * update de.po (from translationproject.org)
  raw:
  * Improve the typesetting of the manual
  renice:
  * correct max priority in renice man page
  runuser:
  * fix minor typos in the man page
  script:
  * Also flush writes to timing file.
  * time from end of read() call partially fixes #58
  scriptreplay:
  * no need to skip first time value or last bytes fixes #58
  setarch:
  * Fix ppc64le architectures
  setpriv:
  * Fix --apparmor-profile
  su:
  * don't use kill(0, ...) when propagate signal
  * fix minor typos in the man page
  sulogin:
  * minor man page improvements
  swaplabel:
  * Improve the typesetting of the manual
  * wrong version number in check
  switch_root:
  * make dirent d_type usage more robust
  * verify initramfs by f_type, not devno
  tests:
  * add fdisk 'f' command MBR test
  * add lscpu dump for ppc cpu with no cache size
  * clean up backport
  * cleanup, remove unused lscpu output
  * update Py parse mountinfo test
  * update libmount tabdiff tests
  * use old output format
  umount:
  * fix typo in usage
  * more robust success message for --all
  unshare:
  * include libmount.h to provide missing MS_* defines
  utmpdump:
  * minor man page improvements
  vipw:
  * minor man page improvements
- remove tty3270-on-serial-line-of-s390.patch (was already upstream
  since 2.24.1)
- remove barrier_documentation.patch (applied upstream)
- rebase blkid-convert-superblocks-to-new-calling-convention.patch
* Thu Apr 17 2014 sbrabec@suse.cz
- Enable socket activation needed by systemd service (bnc#872807).
* Fri Apr 11 2014 sbrabec@suse.cz
- libblkid: Drop the broken ext2/ext3/ext4 discrimination logic
  (util-linux-libblkid-ext-probe.patch, bnc#864703).
* Fri Apr 11 2014 hare@suse.de
- Abort blkid probing on I/O errors (bnc#859062,
  blkid-stop-scanning-on-I-O-error.patch,
  blkid-convert-superblocks-to-new-calling-convention.patch,
  http://www.spinics.net/lists/util-linux-ng/msg08976.html)
* Tue Apr  1 2014 sweet_f_a@gmx.de
- remove unnecessarily added patches from SLE11:
  * util-linux-update-default-commit-interval.patch, openSUSE  has
    never changed the default and neither will SLE12
  * sfdisk-warn-about-2TB-limit.patch, fixed by upstream years ago
  * umount-avoid-readlink.patch, this patch only affects unused
    code and the used code does not have this bug
- edit util-linux-lscpu-improve-hypervisor-detection.patch to not
  change the default behaviour of "lscpu -p" as documented in it's
  man page. Now this patch only affects the summary output.
* Mon Mar 17 2014 sbrabec@suse.cz
- Merge fixes and features from SLE11 (bnc#831868):
  * Detect squashfs version <= 3 as squashfs3 and version >= 4 as
    squashfs. (mszeredi@suse.cz,
    util-linux-ng-2.16-squashfs3-detect.patch, bnc#666893)
  * add sfdisk-warn-about-2TB-limit.patch (puzel@novell.com,
    bnc#495657)
  * Document barrier option in mount.8 (jack@suse.cz,
    hvogel@suse.de,
    util-linux-ng-2.19.1-barrier_documentation.patch, bnc#489740)
  * lscpu: improve hypervisor detection (puzel@novell.com,
    fate#310255)
  - util-linux-lscpu-improve-hypervisor-detection.patch
  * umount: avoid calling readlink on mountpoints if not necessary
  - add: umount-avoid-readlink.patch (puzel@suse.com, bnc#794529)
  * fix file conflict between util-linux and s390-32
    (puzel@suse.com, bnc#805684)
  * util-linux-update-default-commit-interval.patch:
    mount(8): update default commit interval (puzel@suse.com,
    bnc#809480)
  * Obsolete no more packaged uuid-runtime.
- Add uname26 (util-linux-setarch-uname26.patch, FATE#313476).
* Thu Mar  6 2014 werner@suse.de
- Modify the patches
  agetty-fooled-on-serial-line-due-plymouth.patch
  sulogin-fooled-on-tty-line-due-plymouth.patch
  to be able to disable plymouth if not already terminated due to
  a hanging network service (bnc#866860)
* Sun Feb  9 2014 andreas.stieger@gmx.de
- util-linux 2.24.1
- agetty:
  * support the special terminal on first serial line on a S/390
- blkdiscard:
  * BLKSSZGET fills in an int, not a uint64
- blkid:
  * escape quotes in the output
  * simple typo
- blockdev:
  * don't use HDIO_GETGEO
- build-sys:
  * add --with-smack to config-gen.d
  * fstrim depends on libmount
- chsh, chfn:
  * add info about non-local support to the man pages
- dmesg:
  * fix --raw zero timestamp for kmsg
- docs:
  * add patching process to howto-contribute.txt
  * update AUTHORS file
  * update links to http //git.kernel.org/ web repository views
  - fdisk:
  * don't care about partition type
  * fix printf stuff
  * fix usage(), -l [<disk>]
- flock:
  * Change the 'exit status' man page section to make more sense
- fsck:
  * add ext4 to list of filesystems with progress bars in fsck man page
- fstrim:
  * add --all to discard all filesystem
  * cleanup usage()
- lib/path:
  * add path_strdup()
- libblkid:
  * (nilfs2) check also backup superblock
  * detect alone PMBR
  * fix memory leak in blkid_parse_tag_string()
  * fix swap-area version
- libfdisk:
  * (dos) be more verbose when change bootable flag
  * (dos) fix free part counter
  * (dos) warn on type 0
  * (gpt) add /home GUID
  * (gpt) improve and cleanup recovery code
  * (gpt) recover from corrupted primary/backup PT
  * (sgi) generate partname according to partition position
  * (sun) fix end sectors with +1 error
- libmount:
  * add efivarfs to the list of pseudo filesystems
  * add mnt_tag_is_valid()
  * cleanup fix_optstr() regards to selinux and smack
  * fix typo in smack path
  * remove smackfs* option when SMACK not enabled
- lsblk:
  * fix -D segfault
- lscpu:
  * sort NUMA nodes to keep output human readable
  * support discontinuous NUMA nodes
  * support non sequentially numbering of CPUs
- man:
  * Syntax and spelling fixes
- mkfs.minix:
  * fix fscanf() format string [coverity scan]
- mkswap:
  * fix compiler warning [-Wunused-variable]
  * remove cruft from the man page
- mount:
  * add note about "noauto" to --all description
  * correct mount man page default iso9660 permission
  * fix man mount page type
  * improve -s man mage info
  * make NAME=value tags usable for non-root
  * mount.8 fix grammar
  * update man page ext3/4 mount options
- partx:
  * fix --update ranges and out of order tables
- po:
  * merge changes
  * update da.po (from translationproject.org)
  * update de.po (from translationproject.org)
  * update pt_BR.po (from translationproject.org)
  * update zh_CN.po (from translationproject.org)
- pylibmount:
  * correctly import from pylibmount.so
  * import directly from pylibmount in tests
  * remove unncessary subdirectory
- script:
  * don't call TIOCGWINSZ in signal handler
  * restore errno in signal handler
  * use poll() rather then O_NONBLOCK
- setpriv:
  * simplify usage()
- setterm:
  * fix -dump man page info
- sulogin:
  * use dirent->d_type when scans /dev
- taskset:
  * fix PERMISSIONS section of taskset man page
- tests:
  * update blkid swap tests
  * update build-sys tests
  * update lscpu tests
- textual:
  * small inprovements to usage and man page of fstrim
- umount:
  * fix umount by tag for non-roots
- unshare:
  * add more hints about mount namespaces to the man page
- wipefs:
  * call BLKRRPART when erase partition table
- removed patches:
  * blkdiscard-BLKSSZGET-fills-in-an-int.patch, applied upstream
- modified patches:
  * tty3270-on-serial-line-of-s390.patch, one hunk applied
    upstream
* Fri Feb  7 2014 werner@suse.de
- Add patch sulogin-does-not-find-any-console.patch to enable sulogin
  to find suitable console device even if first is not usable (bnc#862078)
* Thu Feb  6 2014 werner@suse.de
- Avoid that hanging plymouth locks terminal lines that is
  add patch sulogin-fooled-on-tty-line-due-plymouth.patch and
  modify patch agetty-fooled-on-serial-line-due-plymouth.patch
  to remove any lock which had been left over.
* Tue Feb  4 2014 werner@suse.de
- Modify patch agetty-on-s390-on-dev--3270-tty1-line.patch and
  patch tty3270-on-serial-line-of-s390.patch to handle 3270
  terminals
- Really do not verify /usr/bin/eject
* Mon Feb  3 2014 werner@suse.de
- Add patch agetty-on-s390-on-dev--3270-tty1-line.patch
  to let agetty detect /dev/3270/tty1 as device not as baud rate
* Tue Jan 28 2014 speilicke@suse.com
- Don't verify /usr/bin/eject, it lost the SUID bit and was dropped
  from /etc/permissions (bnc#824406)
* Thu Jan 23 2014 werner@suse.de
- Change patch agetty-fooled-on-serial-line-due-plymouth.patch
  to sleep instead of sending breaks to terminal (bnc#774126).
* Mon Jan 13 2014 fcrozat@suse.com
- Ensure localstatedir value used by configure is /run (changed to that
  value upstream since 2012).
* Fri Jan 10 2014 werner@suse.de
- Add patch
  agetty-fooled-on-serial-line-due-plymouth.patch
  even with TTYReset=no it seems with systemd or plymouth the termios
  flags become changed from under the first agetty on a serial system
  console as the flags are locked (bnc#774126).
* Tue Dec 10 2013 sweet_f_a@gmx.de
- Update to util-linux-2.24
  + Release highlights (2.24)
  fdisk(8):
  * the code has been completely refactored and moved to libfdisk
    (the library does not have a stable API yet)
  * user interface has been unified for all label types and it
    supports colors
  * GPT disk UUID, partition UUID and partition name modification
    is supported now
  pylibmount:
  * this new library provides PYTHON BINDINGS for libmount;
    use --with-python[=2|3] to enable the bindings
  last(1) and lastb(1):
  * the NEW IMPLEMENTATION has been merged from sysvinit to
    util-linux and extended; now it supports command line options
  - -present, --since, and --time-format
  * use --enable-deprecated-last to enable the old util-linux
    last(1) implementation
  swapon(8):
  * the option --discard= and fstab mount option discard= allow
    to explicitly specify 'pages' or 'once' discard policy. If no
    policy is selected, the default behavior is to enable both.
    See swapon.8 man page for more details.
  libblkid and blkid(8):
  * supports LOGUUID= for external logs (e.g. extN and XFS)
  * generates a pseudo PARTUUID= for MBR partitions (based on MBR
    Id, Linux kernel supports the same concept for root= command
    line option)
  agetty(8):
  * supportes new issue file \S escape code to read information
    from /etc/os-release
  * the option -L allows to completely control CLOCAL flag
  dmesg(1):
  * supports new command line option --time-format to specify
    time format
  * supports new iso-8601 time format
  hexdump(1):
  * supports long options now
  wall(1):
  * the command is compatible with sysvinit implementation now
  logger(1):
  * supports new command line option --prio-prefix when logging
    stdin
  lscpu(1):
  * allows to detect more hypervisor types and provides info
    about Max and Min CPU Mhz
  unshare(8):
  * supports new command line options --fork and --mount-proc for
    pid namespaces
  wipefs(8):
  * now wipes superblocks with incorrect checksums too
  * supports new command line option --backup to backup erased
    data to $HOME/wipefs-<devname>-<offset>.bak
  nologin(8):
  * this command has been merged into util-linux, the command
    politely refuses a login.
- Removed following patches now upstream
  * eject-scsi-check-host_status-and-driver_status.patch
  * more-fix-buffer-overflow.patch
  * more-check-for-buffer-size-when-write-multibyte-char.patch
  * more-guarantee-space-for-multibyte.patch
- Removed following patch because now pkg-config does that
  * fdisk-tinfo.patch
- Refreshed following patches with updating version string
  * util-linux-2.23.1-fdisk_remove_bogus_warnings.patch
- Added enable_last condition in case we don't want to use the last
  binary from sysvinit-tools in future
- Upstream moved getopt examples from datadir to docdir but we keep
  the old location because we would need to fix the manpage first.
* Fri Nov 29 2013 werner@suse.de
- Add patch
  tty3270-on-serial-line-of-s390.patch
  to better support the first and second serial line on s390/x
* Sun Nov  3 2013 schwab@linux-m68k.org
- blkdiscard-BLKSSZGET-fills-in-an-int.patch: Fix type mismatch in
  blkdiscard
* Fri Oct 25 2013 sbrabec@suse.cz
- Drop SUID flag for eject (bnc#824406).
* Wed Oct  9 2013 schwab@suse.de
- No *fdisk on m68k
* Wed Oct  2 2013 sbrabec@suse.cz
- Safely migrate su config files from coreutils to util-linux
  (bnc#814626#c18).
* Fri Sep 27 2013 mgorse@suse.com
- Add more-check-for-buffer-size-when-write-multibyte-char.patch and
  more-guarantee-space-for-multibyte.patch -- check for buffer space with
  multi-byte chars (BNC#829720).
* Fri Sep 27 2013 mgorse@suse.com
- Add more-fix-buffer-overflow.patch (bnc#829720).
* Fri Sep 13 2013 werner@suse.de
- Avoid build require gpg-offline twice
* Wed Sep 11 2013 sbrabec@suse.cz
- Update to version 2.23.2:
  nsenter(1):
  * this NEW COMMAND provides command line interface to setns()
    Linux syscall and allows to run program with namespaces of
    other processes
  unshare(1):
  * supports new PID and USER namespaces
  fdisk(8):
  * provides experimental support for GUID Partition Table (GPT),
    the implementation is still not complete and some (unimportant)
    features are missing.
  * ~50%% of fdisk code has been refactored, this task is going to
    be complete in the next release. The goal is to have libfdisk
    shared between all fdisks.
  partx(8):
  * supports new "update" command (implemented by
    BLKPG_RESIZE_PARTITION ioctl)
  mount(8):
  * supports new userspace mount option x-mount.mkdir[=<mode>] to
    create mountpoints on demand
  * the support for propagation flags has been improved, now the
    flags could be specified in /etc/fstab and used together with
    regular mount options. It's also possible to specify more
    propagation flags together. This EXPERIMENTAL feature is
    implemented by additional mount(2) syscalls, because Linux does
    not allow to use propagation flags with another options or more
    flags together.
  umount(8):
  * supports new command line option --recursive to recursively
    unmount all sub-mounts for the specified mountpoint * supports
    new command line option --all-targets to unmount all
    mountpoints in the current namespace for the specified
    filesystem * the options --recursive and --all-targets could be
    used together
  dmesg(1):
  * supports new command line options --color, --human and
  - -nopager, the --human option enables relative times, colors and
  pager support.
  su(1):
  * supports new command line options --group and --supp-group to
    specify primary and supplementary groups
  chfn(1) and chsh(1):
  * the commands could be linked with libuser to support non-local
    accounts modification (e.g. LDAP, etc).
  kill(1):
  * the command has been improved to be compatible with procps
    version, the procps version is deprecated now, the util-linux
    version is enabled by default.
  blkdiscard(8):
  * this NEW COMMAND discard sectors on a device (for example on
    SSD disks)
  sulogin(8):
  * provides multi-console feature from SysVinit
  findmnt(8):
  * provides new columns FREQ, PASSNO, ID, OPT-FIELDS, PROPAGATION
  lslocks(8):
  * provides new column BLOCKER and detects blocked locks
  lsblk(8):
  * supports new command line option --scsi and new columns HCTL,
    TRANsport VENDOR and REVision
  swapon(8) and losetup(8):
  * the commands prints basic overview by default if no option
    specified
  column(1):
  * supports new command line option --output-separator to specify
    table output delimiter
  rename(1):
  * supports new command line option --symlink to rename symlink
    target
  hwclock(8):
  * supports new command line option --compare to periodically
    compare the Hardware Clock to the System Time (based on
    adjtimex -c)
  ipcs(1):
  * supports new command line options --bytes and --human
  wipefs(1):
  * supports new command line option --force to force erase on used
    devices
- Removed upstreamed patches (mkfs.bfs_cleanup_64bit.patch-Patch,
  mkfs.bfs_cleanup_endian.patch)
* Mon Jul  1 2013 mail@bernhard-voelker.de
- Correct condition for Conflicts of sysvinit-tools.
* Mon Jul  1 2013 werner@suse.de
- Correct version in source URL path.
* Fri Jun 28 2013 sbrabec@suse.cz
- Fix Provides and Obsoletes of eject.
- Conflict with old coreutils and sysvinit-tools with conflicting
  files to guarantee seamless upgrade.
- Remove Provides and Obsoletes of packages that do not exist since
  SuSE Linux 8.
- Include upstreamed patch from SUSE eject package:
  Check eject host_status and driver_status when using SG_IO
  (eject-scsi-check-host_status-and-driver_status.patch,
  bnc#358033).
* Wed Jun 19 2013 coolo@suse.com
- rely on systemd-rpm-macros instead of the full thing
* Wed Jun 12 2013 mail@bernhard-voelker.de
- util-linux.spec: remove previously added "moving-su-trickery" again
  as a su-less coreutils packet is in Base:Build and Factory now.
* Fri Jun  7 2013 mail@bernhard-voelker.de
- util-linux.spec: work around su(1) PAM problems based on su(1)
  being provided by both the coreutils and the util-linux package.
  Fix macro typo in %%post and %%verifyscript sections related to su(1):
    s/sysvinit_tools/enable_su/
* Thu Jun  6 2013 werner@suse.de
- Add make-sure-sbin-resp-usr-sbin-are-in-PATH.diff, that is include
  the old "let `su' handle /sbin and /usr/sbin in path"
- Provide the new eject utility to avoid file conflict with old
  eject package
* Wed Jun  5 2013 werner@suse.de
- Update to util-linux-2.23.1
  + Release highlights (2.22)
  su(1):
  * has been merged from coreutils into util-linux
  * utils-linux version uses /etc/pam.d/su-l PAM config file for --login
    (e.g. "su -") session.
  sulogin(8):
  * has been merged from sysvinit into util-linux
  utmpdump(1):
  * has been merged from sysvinit into util-linux
  eject(1):
  * has been merged from inactive upstream from sf.net and Fedora into util-linux
  * supports new options --manualeject, --force and --no-partitions-unmount
  lslocks(1)
  * this NEW COMMAND prints local system locks and it's replacement to very
    long time unmaintained lslk(1)
  wdctl(8):
  * this NEW COMMAND shows hardware watchdog status
  libuuid:
  * does NOT EXECUTE uuidd on demand, the daemon has to be started by
    init scripts / systemd
  uuidd:
  * supports socket activation (for systemd)
  * supports new options -no-fork, --no-pid and --socket-activation
  + Release highlights (2.23)
  blkdiscard(8):
  * this NEW COMMAND discard sectors on a device (for example on SSD disks)
  sulogin(8):
  * provides multi-console feature from SysVinit
- Removed following patches now upstream
  * 0001-Test-for-secure_getenv-too.patch
  * 0001-include-bitops.h-Use-the-operating-system-byteswappi.patch
  * add-canonicalize_path_restricted.patch
  * fdiskbsdlabel.patch
  * libmount-add-MNT_ERR_LOOPDEV.patch
  * libmount-add-special-MNT_ERR-codes.patch
  * libmount-don-t-use-nosuid-noexec-nodev-for-cifs-user.patch
  * login-close-tty-before-vhangup.patch
  * mount-new-add-loopdev-specific-error-message.patch
  * mount-new-allow-sloppy-for-non-root.patch
  * mount-new-improve-error-messages.patch
  * mount-new-use-MNT_ERR-for-error-messages.patch
  * mount-sanitize-paths-from-non-root-users.patch
  * util-linux-2.21.2-noenc.diff
  * umount-sanitize-paths-from-non-root-users.patch
- Removed following patch which otherwise cause to break build
  * util-linux-2.20-libmount-deps.patch
- Refreshed following patches with updating version string
  * util-linux-2.23.1-fdisk_remove_bogus_warnings.patch
  * util-linux-2.23.1-noenc-suse.diff
- Add util-linux-2.23.1-eject-fpie.patch to compile and link eject
  with PIE
* Wed May 29 2013 ihno@suse.com
- fixing mkfs.bfs to make it 64bit and endian clean.
  adding the patches mkfs.bfs_cleanup_64bit.patch and
  mkfs.bfs_cleanup_endian.patch
* Sun Mar 17 2013 jengelh@inai.de
- Split "which", "time" and "adjtimex" off util-linux
* Sat Feb 16 2013 schwab@suse.de
- fdiskbsdlabel.patch:
  Fix fdisk compilation on aarch64
* Tue Feb  5 2013 crrodriguez@opensuse.org
- 0001-Test-for-secure_getenv-too.patch:
  Current glibc in 12.3/factory no longer exports internal
  function __secure_getenv() but has secure_getenv() instead.
* Mon Jan  7 2013 puzel@suse.com
- add-canonicalize_path_restricted.patch,
  mount-sanitize-paths-from-non-root-users.patch,
  umount-sanitize-paths-from-non-root-users.patch:
  prevent leaking information about existence of folders
  (bnc#797002, CVE-2013-0157)
* Fri Dec 28 2012 crrodriguez@opensuse.org
- 0001-include-bitops.h-Use-the-operating-system-byteswappi.patch
  Use OS byteswapping macros, this patch is functionally identical
  to the version submitted upstream with the exception it excludes
  code that target non-linux systems.
* Wed Sep 19 2012 jslaby@suse.com
- login: close tty before vhangup (bnc#778842)
  login-close-tty-before-vhangup.patch
* Fri Jun 22 2012 kukuk@suse.de
- Remove pam_lastlog from login.pamd, login is doing it itself.
  [bnc#768067]
* Wed Jun 20 2012 lnussel@suse.de
- add a hack for boot.localfs to determine the devices to wait for
* Fri Jun 15 2012 puzel@suse.com
- improve error messages from new mount (bnc#767208)
  - backport patches from upstream git:
  - mount-new-add-loopdev-specific-error-message.patch
  - mount-new-use-MNT_ERR-for-error-messages.patch
  - libmount-add-special-MNT_ERR-codes.patch
  - mount-new-improve-error-messages.patch
  - libmount-add-MNT_ERR_LOOPDEV.patch
* Fri Jun 15 2012 lnussel@suse.de
- remove encryption options completely as upstream will do that as
  well in the next release (bnc#748879).
* Thu Jun 14 2012 puzel@suse.com
- fix automount with quota (rh#825836)
  - mount-new-allow-sloppy-for-non-root.patch
- fix wrong mount options for CIFS mounts (bnc#766157)
  - libmount-don-t-use-nosuid-noexec-nodev-for-cifs-user.patch
* Thu May 31 2012 sweet_f_a@gmx.de
- require binutils-devel because "which" wants to find libiberty.a
- remove which-lib64.patch because it's broken and couldn't find
  libiberty.a whithin /usr/lib64
- which doesn't need autoreconf anymore
* Tue May 29 2012 puzel@suse.com
- switch to new libmount-based mount(8)
* Fri May 25 2012 puzel@suse.com
- update to util-linux-2.21.2
  - bugfix release
- drop sfdisk-fix-calculation-due-to-type-mismatch.patch
  (fixed upstream)
* Fri May 25 2012 puzel@suse.com
- build with RPM_OPT_FLAGS again (removed by mistake)
* Thu Apr 12 2012 puzel@suse.com
- fix miscalculation in sfdisk on ix86 (bnc#754789)
  - add sfdisk-fix-calculation-due-to-type-mismatch.patch
* Sat Mar 31 2012 puzel@suse.com
- update to util-linux-2.21.1
  - bugfix release
* Fri Mar 16 2012 fcrozat@suse.com
- Fix Obsoletes / Provides for login.
* Tue Mar 13 2012 kukuk@suse.de
- Enable /bin/login and obsolete old fork now merged back
  (not moved to /usr/bin until all problems are solved to
  avoid that root is not able to login).
* Tue Mar  6 2012 rschweikert@suse.com
- keep binaries in /usr tree (UsrMerge project)
* Tue Feb 21 2012 puzel@suse.com
- update to util-linux-2.21
  chcpu(8):
  - new command
  prlimit(1):
  - new command
  losetup(8):
  - the command has been rewritten, features:
  * supports 64bit ioctls only
  * losetup -a does not require root permissions
  * uses new /dev/loop-control kernel API
  * supports new command line option --partscan to enable
    kernel partition table parser
  agetty(8):
  - supports new command line options --nohints to disable hints
    about Num, Caps and Scroll Locks
  - supports new command line option --remote to add a hostname
    to the login(1) command line
  dmesg(1):
  - supports new command line options --file to read the log from
    a file rather than from kernel buffer
  fallocate(8):
  - supports new command line options --punch-hole to punch holes
    in the file
  findmnt(8):
  - supports alternative location of the fstab file
  ipcrm(8):
  - supports new command line option --all to remove all resources
  lscpu(1):
  - supports new command line options --all, --offline and
  - -online to list all, offline or online CPUs
  - supports s390 topology description (polarization, books, ...)
  partx(8):
  - supports partitioned loop devices
  wipefs(8):
  - allows to zap partition tables
  - supports new command line option "--type <list>" to wipe only
    specified filesystems, RAIDs or partition table types
  libblkid:
  - provides new function blkid_do_wipe() to remove all
    signatures from the given block device.
- disable elvtune (works only with 2.4 kernel)
- drop patches which are upstream now:
  - drop fsck-use-FS-blacklist-for-non-all-mode-too.patch
  - drop util-linux-dmesg-fix-printing-of-multibyte-characters.patch
  - libmount-ignore-tailing-slash-in-netfs-source-paths.patch
  - libmount-fix-chdir-to-parent-for-restricted-user-umo.patch
- update to adjtimex-1.29
- use fdupes to symlink duplicate manpages
- disabled make check for time (noop)
- libraries back to %%{_libdir}, /usr merge project (by
  crrodriguez@opensuse.org)
- drop cryptoloop support (provided by dm-crypt)
  - util-linux-2.17.1-mount_losetup_crypto.patch
* Tue Feb  7 2012 jengelh@medozas.de
- Remove redundant tags/sections
* Sun Dec 25 2011 coolo@suse.com
- do not call %%suse_update_config
* Mon Nov 21 2011 aj@suse.de
- add fdisk-tinfo.patch to fix build with newer curses.
* Tue Nov 15 2011 coolo@suse.com
- add libtool as buildrequire to avoid implicit dependency
* Wed Nov  9 2011 puzel@suse.com
- add libmount-ignore-tailing-slash-in-netfs-source-paths.patch and
  libmount-fix-chdir-to-parent-for-restricted-user-umo.patch:
  fix umounting network filesystems as plain user (bnc#728480)
* Tue Nov  8 2011 puzel@suse.com
- add fsck-use-FS-blacklist-for-non-all-mode-too.patch (bnc#728645)
* Wed Nov  2 2011 puzel@suse.com
- add util-linux-dmesg-fix-printing-of-multibyte-characters.patch
  (bnc#725993)
* Thu Oct 20 2011 puzel@suse.com
- update to util-linux-2.20.1
  - bugfix release
- drop patches (in upstream):
  - util-linux-sfdisk-manpage-fix.patch
  - util-linux-lib-sysfs-deinit.patch
  - fdisk-dont-shorten-long-path-to-disk.patch
* Wed Oct 12 2011 puzel@suse.com
- add fdisk-dont-shorten-long-path-to-disk.patch (bnc#722959)
* Tue Oct  4 2011 uli@suse.com
- cross-build fix: use %%__cc, %%configure macros
- set bindir explicitly when installing
- (cross-?)build fix: disable build dependency on SELINUX_LIBS
  in libmount
* Tue Sep 13 2011 puzel@suse.com
- add util-linux-lib-sysfs-deinit.patch (bnc#714151)
* Mon Aug 29 2011 puzel@suse.com
- update to util-linux-2.20
  - cleanups, bugfixes
- build with --enable-ddate
- add util-linux-sfdisk-manpage-fix.patch
* Thu Aug 25 2011 rguenther@novell.com
- BuildIgnore pwdutils.
* Wed Aug 17 2011 puzel@novell.com
- update to util-linux-2.20-rc2
  - bugfixes
- drop patches:
  - util-linux-fix-manpages.patch
  - util-linux-wall-build-with-pie.patch
  - util-linux-2.20-rc1-agetty-fixes.patch
  - util-linux-2.20-rc1-hexdump-segfault.patch
  - util-linux-2.20-rc-fix-dmesg.patch
* Wed Aug 10 2011 puzel@novell.com
- add util-linux-2.20-rc1-hexdump-segfault.patch (bnc#710877)
* Wed Aug 10 2011 puzel@novell.com
- add util-linux-2.20-rc-fix-dmesg.patch (bnc#710417)
* Wed Aug 10 2011 puzel@novell.com
- add util-linux-2.20-rc1-agetty-fixes.patch (bnc#711240)
* Mon Aug  1 2011 puzel@novell.com
- update to util-linux-2.20-rc1
  - Release highlights
  agetty(8):
  - mingetty features have been merged to agetty
  chrt(1), taskset(1):
  - supports new command line option "--all-tasks" to set or
    retrieve the scheduling attributes of all the tasks (threads)
    for a given PID
  dmesg(1):
  - supports new command line options: --clear, --console-on,
  - -console-off, --ctime, --decode, --facility=<list>,
  - -level=<list>, --show-delta, --notime, --kernel and
  - -userspace
  fdisk(8):
  - improved dialogs to be more user-friendly
  findmnt(8), partx(8), lsblk(8)
  - support new command line option "--pairs" to enable
    key="value" output format
  findmnt(8):
  - supports new command line options "--poll" and "--timeout" to
    monitor /proc/self/mountinfo changes
  ionice(1):
  - supports human-readable scheduling class names, for example:
    ionice -c best-effort $PID
  kill(1):
  - supports new command line option "-q <sigval>" to use
    sigqueue(2)
  - supports real-time signals in formats RT<n>, RTMIN+<n> and
    RTMAX-<n>
  lsblk(8):
  - supports new columns
  - supports new command line option "-D" to print device discard
    topology
  lscpu(8):
  - improved support for s390 boxes
  mkfs.minix:
  - supports minix version 3
  simpleinit:
  - this set of deprecated utils has been REMOVED
  wall(1):
  - support new command line option "--timeout" to specify write
    timeout to terminals in seconds.
- add util-linux-fix-manpages.patch
- add util-linux-wall-build-with-pie.patch
- package /sbin/rcuuidd
* Tue May  3 2011 puzel@novell.com
- update to util-linux-2.19.1
  - numerous bugfixes, including (bnc#690486 and bnc#690488)
- drop umount-by-imgname.patch (merged upstream)
- cleanup: do not register ipc.info.gz (not provided by
  this package)
* Thu Apr 14 2011 puzel@novell.com
- merge util-linux-2.17.1-losetup-honor-documented-c-option and
  util-linux-2.17.1-mount_losetup_crypto.patch)
* Mon Feb 21 2011 puzel@novell.com
- add umount-by-imgname.patch (bnc#666161)
* Thu Feb 10 2011 puzel@novell.com
- update to util-linux-2.19
  - uuid fixes
  - cleanups, documentation and translation updates
- drop util-linux-2.19-rc1-loop-offset.diff (fixed in upstream, by
  different patch)
* Wed Jan 26 2011 puzel@novell.com
- update to util-linux-2.19-rc3
  - bugfixes
* Tue Jan 25 2011 lnussel@suse.de
- don't mess with /etc/mtab in %%post. aaa_base does that for us
  already.
* Fri Jan 21 2011 lnussel@suse.de
- fix parsing offset= followed by more options (bnc#666150)
* Tue Jan 18 2011 bwiedemann@novell.com
- fix bnc#664873
* Thu Jan  6 2011 puzel@novell.com
- update to util-linux-2.19-rc1
- important changes:
  * lsblk(8):
  - this NEW COMMAND lists information about all or selected block
    devices in tree-like format.
  * partx(8):
  - this command has been rewritten to use libblkid for partition
    tables parsing. It supports aix, bsd, dos, gpt, mac, minix,
    sgi, solaris_x86, sun, ultrix and unixware now.
  - supports new command line option "--show" to list partitions in
    new format
  - prints UUID and name for GPT and mac partitions
  * findmnt(8):
  - supports new command line option "--submounts" to list all
    submounts for selected mountpoint(s)
  * agetty(8):
  - supports new command line options "-c" and "-s" to reuse
    already initialized tty cflags and existing baud rate
  * mount(8), umount(8):
  - could be linked with libmount (--enable-libmount-mount) to
    manage userspace mount options outside /etc/mtab on systems
    where the file is a symlink to /proc/mounts. (EXPERIMENTAL,
    enabled in openSUSE package)
  * losetup(8), mount(8):
  - uses /sys/dev/block/<device>/loop/backing_file rather than
    loopdev ioctls (requires kernel >= 2.6.37)
  * fsck(8):
  - supports new command line option "-l" to lock whole-disk device
    by exclusive flock(2). This option is recommended when more
    fsck(8) instances are executed in the same time.
  * rtcwake(8):
  - supports new mode "show" to print the current RTC alarm time
  * fstrim(8):
  - this NEW COMMAND allows to discard unused blocks on a mounted
    filesystem (wrapper for FITRIM ioctl)
  * swapon(8):
  - supports new options "discard" and "nofail"
- in post, replace /etc/mtab with a symlink to /proc/mounts/self
- drop following patches (in upstream)
  - util-linux-swapon-btrfs-limitations
  - util-linux-agetty-s-option.patch
  - util-linux-fsck-l-option.patch
  - util-linux-2.18-no-canonicalize-fix.patch
  - util-linux-swapon-canonicalize-swap-device.patch
- fix uuidd Summary and Description
- build with --enable-libmount-mount (new option)
- use set_permissions macros
- run spec-cleaner
* Tue Dec 14 2010 puzel@novell.com
- add util-linux-swapon-canonicalize-swap-device.patch
  (bnc#641142)
* Thu Dec  2 2010 mszeredi@suse.cz
- mount: don't canonicalize "spec" with --no-canonicalize option
  [bnc#651598]
* Thu Dec  2 2010 mszeredi@suse.cz
- add Provides: util-linux(fake+no-canonicalize) [bnc#651598]
* Tue Nov 30 2010 puzel@novell.com
- update util-linux-2.17.1-mount_losetup_crypto.patch (bnc#655804)
* Fri Nov 26 2010 kay.sievers@novell.com
- add Provides: fsck-with-dev-lock
* Thu Nov 25 2010 kay.sievers@novell.com
- add 'fsck -l' option needed for systemd
* Tue Nov 16 2010 cristian.rodriguez@opensuse.org
- disable silent rules
* Thu Nov 11 2010 kay.sievers@novell.com
- add 'agetty' -s option needed for systemd's serial console setup
* Tue Sep 28 2010 aj@suse.de
- uuidd rc file already creates /var/run/uuidd, mark it as %%ghost
  in spec file.
* Fri Jul  9 2010 puzel@novell.com
- update to util-linux-ng-2.18
  - do not provide rdev, ramsize, vidmode and rootflags commands
    anymore
  - fdisk does not use cylinders as display units by default
  - libmount: new library; its API is still officially unstable
  - new commands: findmnt, fsfreeze, swaplabel
  - blkid: new option "-i" to print I/O limits
  - full release notes:
    https://www.kernel.org/pub/linux/utils/util-linux/v2.18/v2.18-ReleaseNotes
- update to adjtimex-1.28
- update to which-2.20
- drop util-linux-2.14.1-mount_skip_sync.patch (fixed upstream)
- drop util-linux-addpart-use-atoll.patch (fixed upstream)
- drop util-linux-mount-detect-ro-mount.patch (fixed upstream)
- drop adjtimex-1.20-nosyscall.diff (fixed upstream)
- cleanup specfile a bit
* Mon Jun 28 2010 jengelh@medozas.de
- use %%_smp_mflags
* Thu Jun 24 2010 jeffm@suse.de
- document btrfs limitation with swapfiles (bnc#616617)
* Tue Jun 22 2010 bg@novell.com
- hppa specific binaries are parisc{,32,64}
* Tue Jun  1 2010 puzel@novell.com
- do not run uuidd as root, but uuidd:uuidd (bnc#604168)
* Fri May 28 2010 puzel@novell.com
- add util-linux-mount-detect-ro-mount.patch (bnc#481123)
* Tue May 11 2010 puzel@novell.com
- add util-linux-addpart-use-atoll.patch (bnc#603328)
* Tue Apr  6 2010 hvogel@novell.com
- update to version 2.17.2
  - fix small typo in v2.17.1-ReleaseNotes
  - fix -b <sectorsize> fdisk
  - fix typo in ionice
  - fix display of device size, fix infinite loop when probe chain
    bails out early, more robust minix probing, remove "0x" prefix
    from DRBD UUID, reset BLKID_TINY_DEV flag in
    blkid_probe_set_device, support alignment_offset=-1 in libblkid
  - fix cpuid opcode detection in lscpu
  - more explicitly explain fstab usage in mount.8, posix option
    of vfat is obsolete, properly ignore comments in
    /etc/filesystems in mount
  - update ja.po, pl.po, update vi.po
  - remove " (deleted)" from filenames from /proc/swaps
  - cleanup usage() and man page of wipefs
* Wed Mar 10 2010 jeffm@suse.de
- Properly honor documented -c option (bnc#583677)
* Tue Mar  2 2010 lnussel@suse.de
- drop freeramdisk (bnc#584565)
- drop hostid (bnc#584562)
* Tue Feb 23 2010 lnussel@suse.de
- new version 2.17.1
  - new commands: wipefs, unshare, fallocate
  - fdisk: DOS-compatible mode marked deprecated
  - honor nofail option in fsck
  - libblkid overhaul
  - lots of bug fixes
- fix self-obsoletes
- compile suid programs using -fpie
- drop -DCONFIG_SMP for s390 as it doesn't seem to be used anyways
* Sun Dec 13 2009 jengelh@medozas.de
- add baselibs.conf as a source
* Sun Dec  6 2009 jengelh@medozas.de
- enabled parallel build
* Mon Nov 30 2009 meissner@suse.de
- exclude sparc correctly -> %%sparc bnc#559180
* Sun Nov 15 2009 meissner@suse.de
- refreshed patches with fuzz=0
* Mon Oct 26 2009 crrodriguez@opensuse.org
- fsck during boot up fails with Too many open files [bnc#503008]
* Tue Oct 20 2009 dmueller@suse.de
- fix typo in baselibs.conf change
* Tue Oct 13 2009 aj@suse.de
- Fix requires of 32-bit devel packages.
* Tue Sep 29 2009 hvogel@novell.com
- finaly remove the mount mtab locking patch:
  * util-linux-2.14.1-mount_race.patch
  It causes too much regressions.
* Mon Jul 13 2009 kay.sievers@novell.com
- update to final 2.16 release
  - fix libdir issues in pkgconfig files
  - fix location of uuidd run directory
  - improve libuuid handling if uuidd is installed but not setuid
- add blkid.conf file to:
  - disable the sequential /dev scanner
  - move cache to /dev/.blkid.tab to get file out of /etc
    and prevent the cache file to survive a reboot
* Wed Jul  8 2009 meissner@novell.com
- added baselibs.conf for libblkid* and libuuid*
* Sun Jun 28 2009 kay.sievers@novell.com
- update to version 2.16
- switch from libvolume_id to new libblkid
- provide fsck
- provide libblkid
- provide libuuid
- provide setarch
- provide separate uuidd package
- remove patches:
    util-linux-2.14.1-lscpu.patch (upstream)
    util-linux-2.14.1-lscpu_add_hypervisor_detection.patch (upstream)
    util-linux-2.14.1-lscpu_sysroot_option.patch (upstream)
    util-linux-2.14.1-sys-utils_lscpu_exit.patch (upstream)
    util-linux-2.14.2-schedutils_fix_email.patch (upstream)
    util-linux-2.12r-fdisk_cyl.patch (upstream)
    util-linux-2.14.1-mount_swap_pagesize.patch (--fixpg option)
    util-linux-2.14.2-schedutils_ionice_enosys.patch (-t option)
    util-linux-2.14.1-hwclock_adjust_and_hctosys.patch (--systz)
* Thu Apr 16 2009 werner@suse.de
- Move /usr/sbin/adjtimex to /sbin/adjtimex to be able to check the
  kernel time variables even without /usr mounted
* Mon Feb 16 2009 mkoenig@suse.de
- remove util-linux-2.14.1-fdisk_cylinder.patch
  fixed upstream
* Thu Feb 12 2009 mkoenig@suse.de
- update to version 2.14.2
  chrt:
  * support CFS SCHED_IDLE priority and document it
  fdisk:
  * cannot create partition with starting beyond 1 TB
  * remove obsolete information from man page
  hwclock:
  * remove "cli" and "sti" from i386 CMOS code
  * remove x86_64-specific bogon
  losetup:
  * add warning about read-only mode
  * missing EBUSY error hint message
  more:
  * minor fixes to magic()
  mount:
  * add i_version support
  * add info about /proc/mounts to mount.1
  * add info about semantics of read-only mount to mount.8
  * add rootcontext= SELinux mount option
  * clean up SPEC canonicalization
  * create separate section for fs-independent options in mount.8
  * finalize support of quoted LABELs/UUIDs
  * mtab created multiple times with -a option
  * suggest to use blockdev --setro rather than losetup
- catch ENOSYS in ionice to allow execution in virtualized
  environments which don't support ioprio_{get,set} calls [bnc#444637]
- umount: fix suid check for user mounted loop devices [bnc#461732]
- fix doc [bnc#456375]
- remove patches:
  util-linux-2.13.1-fdisk_cfdisk_yesno.patch
  util-linux-2.13-hwclock_rtc_wait_busy_tempfix.patch
  util-linux-2.14.1-disk-utils_mkfs.minix_file_size_detection.patch
  util-linux-2.14.1-fdisk_missing_include.patch
  util-linux-2.14.1-mount_loop_ro_fix.patch
* Sat Feb  7 2009 schwab@suse.de
- Fix info dir entry for which.
* Wed Jan  7 2009 mkoenig@suse.de
- fix locking problem for external mount helpers when type
  is not given [bnc#459839]
* Tue Dec  2 2008 mkoenig@suse.de
- raw: do not stat the raw devices when binding, since they
  are created dynamically [bnc#450675]
* Thu Nov 27 2008 dmueller@suse.de
- mount: fix hang on trying to find a free loop device
  if one of them has a stale nfs handle mounted (bnc#449646)
* Mon Nov 24 2008 mkoenig@suse.de
- mount: fix locking patch to not break -n [bnc#447937]
* Thu Nov 20 2008 mkoenig@suse.de
- mount: enhance mount/umount mtab locking and lock the whole
  read mtab/syscall/write mtab process to avoid mtab corruption
  with highly concurrent mount/umount calls [bnc#444966]
- add arch/powerpc/boot/addnote.c from kernel 2.6.27
  as /usr/bin/chrp-addnote [bnc#443859]
- umount: skip sync() in umount -a if no umount happened [bnc#447036]
- hwclock: allow --adjust and --hctosys simultaneously [bnc#441106]
* Fri Nov  7 2008 mkoenig@suse.de
- fdisk: support +cylinder notation [bnc#441871]
- check for EACCES when using ro fallback when loop mounting
  a readonly image
- fix uninitialized variable in swapon pagesize detection
* Mon Oct 27 2008 mkoenig@suse.de
- fdisk: add missing includes [bnc#438670]
* Thu Oct 23 2008 mkoenig@suse.de
- swapon: add swap pagesize detection [bnc#433028]
- lscpu: fix return code [bnc#437367]
- mkfs.minix: fix device size detection [bnc#437980]
- lscpu: update to most recent version for hypervisor detection
* Thu Oct  2 2008 mkoenig@suse.de
- add lscpu tool from current util-linux-ng git,
  needed for fate#303051
- replace hypervisor detection tool with the solution blessed by
  upstream, which adds hv detection as lscpu feature [fate#303051]
* Wed Sep 24 2008 mkoenig@suse.de
- add new tool /bin/hypervisor for x86, x86_64
  from Ky Srinivasan <ksrinivasan@novell.com>
  to detect the presence of a hypervisor [fate#303051]
* Wed Sep 10 2008 mkoenig@suse.de
- update to version 2.14.1
  * fdisk: don't check for GPT when asked for disk size only
  * losetup: remove unnecessary minor number check
  * rtcwake: prefer RTC_WKALM_SET over RTC_ALM_SET
  * scriptreplay: new implementation is out-of-sync
  * selinux: is_selinux_enabled() returns 0, 1 and -1
  * umount: improve "-d" option for autoclear loops
- remove patch
  util-linux-2.14-loop_autoclear.patch
* Wed Aug 20 2008 mkoenig@suse.de
- enable SELinux support [fate#303662]
* Mon Aug 18 2008 mrueckert@suse.de
- remove outdated options in the fillup_and_insserv call
* Mon Aug 18 2008 mkoenig@suse.de
- raw: fix init script tags
* Mon Jul  7 2008 mkoenig@suse.de
- update which to version 2.19
  * Upgraded code from bash to version 3.2. This DOES has influence
    on how Which behaves under certain circumstances.
  * When the environment variable HOME is not set, the home directory
    is now read from /etc/passwd or set to '/' if no home directory
    could be found (this now matches the tilde lib used in bash)
  * Changed the license to GPLv3
  * Add support for shells that output '{' on the same line as the
    function name in the output of 'declare -f' (ie zsh).
- fix build
* Wed Jul  2 2008 mkoenig@suse.de
- replace util-linux-2.14-mount_ignore_ENXIO_in_del_loop.patch
  with upstream version
  util-linux-2.14-loop_autoclear.patch
* Fri Jun 27 2008 schwab@suse.de
- Fix lib64 check.
* Wed Jun 25 2008 mkoenig@suse.de
- update to version 2.14
  most important changes:
  * new command ldattach
  mount:
  * support auto-destruction of loop devices
  losetup:
  * new option -j
  * supports unlimited number of loop devices
  * new option --sizelimit to set data end
  * option -s (short form of --show) now deprecated
  mkswap:
  * new option -U to set UUID explicitly
  fdisk:
  * calculate partition size in 2^N [bnc#381270]
  hwclock:
  * new option --adjfile to override default /etc/adjtime
- readd scriptreplay, implemented now in C
- add retry for mount if ENOMEDIUM is returned [bnc#390204]
- ignore ENXIO in del_loop, because they might have been
  auto-destructed
- removed patches:
  util-linux-2.13.1-canonicalize_loopfile_name.patch
  util-linux-2.13.1-mkfs.minix_add_sectorsize_check.patch
  util-linux-2.13.1-mkfs.minix_device_size_cleanup.patch
  util-linux-2.13.1-mount_getfs_fix.patch
  util-linux-2.13.1-prevent_loop_mounting_the_same_file_twice.patch
  util-linux-2.13-fdisk_cfdisk_ncursesw.patch
  util-linux-mount_opt_nofail.patch
  util-linux-ng-2.13-swapon-swsuspend.patch
* Thu Apr  3 2008 mkoenig@suse.de
- cfdisk: accept english answer [bnc#369043]
- use upstream getfs fix
* Wed Mar 26 2008 coolo@suse.de
- actually require the split out package
* Sun Mar 23 2008 coolo@suse.de
- splitting out 60%% of the size of the package:
  creating lang subpackage
* Wed Feb 13 2008 bg@suse.de
- don't try to package parisc*.8 manual pages
* Mon Feb 11 2008 mkoenig@suse.de
- update to version 2.13.1 again
- fix broken util-linux-2.13.1-getfs_fix.patch
* Sun Feb 10 2008 lrupp@suse.de
- revert to 2.13.0.1+git20071121
  breaks current 'mount' call in Buildservice
* Thu Feb  7 2008 mkoenig@suse.de
- update to version 2.13.1:
  mount:
  * -L|-U segfault when label or uuid doesn't exist
  * chain of symlinks to fstab causes use of pointer after free
  * don't call canonicalize(SPEC) for cifs, smbfs and nfs
  * improve error message when helper program not present
  losetup:
  * fix errno usage
  mkswap:
  * possible to crash with SELinux relabeling support
  sfdisk:
  * allow partitioning drives of over 2^31 sectors
  hwclock:
  * check for ENODEV
- mount: fix problem with device canonicalization when using
  persistent name in fstab but call mount with real bd name
- patches merged:
  util-linux-2.13-mount_fd_leak.patch
* Tue Dec 18 2007 mkoenig@suse.de
- add temporary workaround for broken RTC update interrupts
  [#338419]
* Mon Dec  3 2007 ro@suse.de
- remove "arch", in coreutils now
* Thu Nov 29 2007 lnussel@suse.de
- update crypto patch
  * fix mount buffer overflow when reading the passphrase (#332148)
  * add loop_fish2 compatability code to losetup/mount again (#332095)
  * change default hash size for 128bit keys to sha256 again
* Wed Nov 21 2007 mkoenig@suse.de
- update to git20071121:
  add sector size check for mkfs.minix [#308256]
  fix canonicalization for cifs [#338375]
- provide Short-Description for raw init script
- add rpmlintrc
* Tue Nov 20 2007 mkoenig@suse.de
- fix raw path in init script
* Tue Nov  6 2007 mkoenig@suse.de
- update to 2.13.0.1+git20071106
- prevent loop mounting the same file twice [#240653]
- merged upstream:
  util-linux-2.13-mount_helper_fix.patch
  util-linux-2.13-hwclock_rtc_option.patch
* Thu Oct  4 2007 bg@suse.de
- don't use parisc, parisc32 and parisc64.
* Mon Oct  1 2007 mkoenig@suse.de
- update to version 2.13
  merged upstream:
  util-linux-2.12r-disk_utils_mkfs_open_exclusive.patch
  util-linux-2.13-loop.patch
  util-linux-2.13-mount_create_mtab.patch
  util-linux-2.13-schedutils_error_handling.patch
  util-linux-2.13-sys_utils_build_rdev_x86_64.patch
- fix hwclock --rtc option [#326106]
- fix setuid/setgid mixup and error checking [#327022]
* Fri Sep 14 2007 mkoenig@suse.de
- link cfdisk against libncursesw instead libncurses to fix
  broken utf-8 characters [#307353]
* Wed Aug 29 2007 mkoenig@suse.de
- fix fd leaks in previous patch
* Tue Aug 28 2007 lnussel@suse.de
- add support for specifying the key length and password hash
  algorithm [#304861]
* Fri Aug 24 2007 mkoenig@suse.de
- avoid duplicates of root fs if defined with LABEL in fstab
  [#297959]
- fix ionice error handling [#301675]
* Thu Aug 16 2007 ssommer@suse.de
- free loop devices when mount fails [#297172]
* Wed Jul 25 2007 mkoenig@suse.de
- update to git20070725
- removed patches (merged upstream):
  util-linux-2.12r-mount_mount.8_xfs_update.patch
  util-linux-2.12r-sys_utils_readprofile_mapfile.patch
  util-linux-2.12r-disk_utils_mkswap_fix.patch
  util-linux-2.13-schedutils_ionice_idle.patch
* Tue Jul 17 2007 mkoenig@suse.de
- updated to version 2.13-rc2:
  * add wakertc
- cleanup ionice usage [#270251]
- enable hwclock audit support [#280113]
- removed patches (merged/fixed upstream)
  util-linux-login_utils_wall.patch
  util-linux-mount_mount.8-acl.patch
  util-linux-2.12r-mount_mtab_update.patch
  util-linux-2.13-schedutils_chrt.patch
  util-linux-2.13-sys_utils_arch.patch
  util-linux-2.12a-mount_mountpointwithcolon.patch
  util-linux-2.12a-mount_procswapcheck.patch
  util-linux-2.12q-mount_umount2_not_static.patch
* Fri Jul 13 2007 mkoenig@suse.de
- replace hotplug with nofail option and fix it to not use
  syscall reserved values.
- removed patch
  util-linux-2.11z-hwclock_geteuid.patch
  it is intentional that suid hwclock capabilities are limited
- removed patch (fixed upstream)
  util-linux-2.12q-mount_--move.patch
* Mon Jul  9 2007 mkoenig@suse.de
- add libuuid-devel to BuildRequires to let mkswap use UUIDs
* Thu Jul  5 2007 mkoenig@suse.de
- use %%config(noreplace) for /etc/filesystems
- Keep rdev stuff for x86_64
  util-linux-2.13-sys_utils_build_rdev_x86_64.patch
- removed patches (merged upstream)
  util-linux-2.12r-misc_utils_cal_formatting.patch
  util-linux-2.12q-sys_utils_ionice.patch
* Thu Jul  5 2007 mkoenig@suse.de
- update to 2.13-rc1:
  * mount fixes
  * agetty: add 'O' escape code to display domain name
  * blockdev: add BLKFRAGET/BLKFRASET ioctls
  * fdisk: many significant improvements and fixes to Sun label handling
  * update po files
- removed patches (merged upstream):
  util-linux-2.11q-fdisk_fs_mac.patch
  util-linux-2.12r-fdisk_fdiskwrap.patch
  util-linux-2.12r-mount_racy_loop.patch
  util-linux-2.13-misc_utils_cal_ncurses.patch
  util-linux-2.13-mount_volumeid_label.patch
- use %%find_lang
* Thu Jun 21 2007 mkoenig@suse.de
- use encoded label names with volume_id [#232929]
  util-linux-2.13-mount_volumeid_label.patch
* Thu Jun 14 2007 mkoenig@suse.de
- mkzimage_cmdline: activate commandline if used with -s [#279935]
* Wed Jun 13 2007 mkoenig@suse.de
- schedutils: let chrt accept pid 0 for current process and
  fix some documentation bugs [#266879]
  util-linux-2.13-schedutils_chrt.patch
* Wed Jun  6 2007 mkoenig@suse.de
- update to git20070530
- removed patches
  util-linux-2.13-mount_volume_id.patch
  util-linux-2.12r-mount_by_uuid.patch
  util-linux-2.13-build_gnu_source.patch
- fix build with ncurses
* Tue Jun  5 2007 mkoenig@suse.de
- update to git20070509
  mount: NFS code removed (use mount.nfs{,4} from nfs-utils)
- remove sm-notify (nfs-utils)
- removed patches
  util-linux-2.11u-mount_nfs_mount_acl.patch
  util-linux-2.12-mount_base_nfsv4.patch
  util-linux-2.12-mount_mountfallback.patch
  util-linux-2.12-mount_nfs_tcp.patch
  util-linux-2.12q-mount_strict_aliasing.patch
  util-linux-2.12r-mount_nfs_remount_options.patch
  util-linux-2.12r-mount_rpcsec_gss.patch
  util-linux-2.12r-mount_sec_manpage.patch
  util-linux-2.12r-mount_umount_nosysfs.patch
  util-linux-2.13-mount_nfs_timeo.patch
  util-linux-mount_nfs.8.patch
  util-linux-mount_warn_nfsudp.patch
* Tue Jun  5 2007 pth@suse.de
- Update to which-2.16, mainly because regenerating configure
  with newer autotools works.
- Fix the patch for AC_CHECK_STATICLIB
- Our distribution doesn't install libiberty.a, so pass
  - -disable-iberty to configure of which to not use a libiberty from
  somewhere else.
* Mon Jun  4 2007 pth@suse.de
- Make configure of which search for static libs in lib64 subdirs.
* Mon Apr 23 2007 mkoenig@suse.de
- update to git20070412
- remove chkdupexe and scriptreplay to get rid of the
  perl dependency [#265757]
  util-linux-2.13-build_no_perl_dependency.patch
- upstream integration of umount helper support [#252089]
- merged patches:
  util-linux-2.13-misc_utils_add_man_scriptreplay.patch
  util-linux-2.13-tests_missing_include.patch
* Mon Apr 16 2007 mkoenig@suse.de
- fix initialization of offset in
  util-linux-2.12r-mount_racy_loop.patch [#264225]
* Tue Apr 10 2007 mkoenig@suse.de
- update to version git20070330 of new forked development tree
- removed Suse crypto patches for losetup [FATE#302001]
- removed binaries:
    /bin/guessfstype
    /sbin/sln
    /usr/bin/setfdprm
- removed obsolete patches:
  * guessfstype2.patch
  * loop-AES-v3.0a-util-linux-2.12p.diff
  * mount-nfs-nonreserved
  * stupid-programmer.diff
  * util-linux-nodiratime.diff
  * util-linux-2.12-multipleraw.diff
  * util-linux-2.12-enablereplaybuild.diff
  * util-linux-2.12-mount_guessfstype.diff
  * util-linux-2.12h-mtablock.diff
  * util-linux-2.12i-x86_64intel.diff
  * util-linux-2.12q-null.diff
  * util-linux-2.12r.diff
  * util-linux-2.12r-fdisk_llseek.patch
  * util-linux-2.12r-mount-doubleslashessourceprefix-cifs.diff
  * util-linux-2.12r-mount_external_prog_on_guess.patch
  * util-linux-2.12r-nonfsmountfallback.diff
  * util-linux-2.12r-pagesize.patch
  * util-linux-2.12r-partx_enable.patch
  * util-linux-2.12r-partx_gpt_warning.patch
- add patches:
  * util-linux-2.13-misc_utils_add_man_scriptreplay.patch
    install man page for scriptreplay
  * util-linux-2.13-tests_missing_include.patch
    fix missing header in tests/mnt_test_sysinfo.c
  * util-linux-2.13-sys_utils_arch.patch
    keep /bin/arch
  * util-linux-2.13-build_gnu_source.patch
    build with _GNU_SOURCE
  * util-linux-2.13-build_fix_intel_check.patch
    detect also x86_64 as INTEL architecture
- rename patches to identify them clearly by subsystem
- schedutils now part of util-linux itself
* Wed Apr  4 2007 mkoenig@suse.de
- add Supplements line [FATE#301966]
* Mon Mar 26 2007 rguenther@suse.de
- add ncurses-devel and zlib-devel BuildRequires
* Thu Mar 15 2007 mkoenig@suse.de
- mount: Let swapon automatically reinitialize a suspended
  swap partition [#254437]
* Fri Mar  9 2007 mkoenig@suse.de
- mount: fix mtablock patch to avoid mtab corruption [#226783]
* Thu Mar  8 2007 mkoenig@suse.de
- partx: fix warning for too long literal
* Wed Mar  7 2007 rguenther@suse.de
- fix changelog entry order
* Tue Feb 27 2007 mkoenig@suse.de
- fix missing return code in
  util-linux-2.12r-losetup_password.patch
- mount: fix race condition in mount -o loop [#242750]
* Mon Feb 12 2007 mkoenig@suse.de
- remove legacy warnings from fdisk [#241372]
* Fri Feb  2 2007 mkoenig@suse.de
- do not use O_EXCL for mkfs.cramfs [#241466]
* Wed Jan 31 2007 mkoenig@suse.de
- let mkfs tools open with O_EXCL [#238687]
* Tue Dec 12 2006 mkoenig@suse.de
- provide different return codes for losetup with encryption
  for empty and too short passwords. [#197493]
* Tue Dec  5 2006 mkoenig@suse.de
- default swap to V1 in any case [#205956]
  patch: util-linux-2.12r-mkswap_fix.patch
- do not append addr option with each nfs remount [#130625]
  patch: util-linux-2.12r-nfs_remount_options.patch
- add README.largedisk about fdisk partition size constraints
  [#153657]
* Tue Nov  7 2006 mkoenig@suse.de
- enable partx [#214992]
* Tue Oct 10 2006 mkoenig@suse.de
- Round up partition end LBA to a cylinder boundary during
  add_partition() [#174892]
- Fix readprofile on ppc64 [#179122]
- Fix cal formatting bug [#203469]
* Mon Oct  9 2006 mkoenig@suse.de
- Fix llseek issues.
- swapon.c: Do not use PAGE_SIZE macro.
* Mon Aug 21 2006 mkoenig@suse.de
- Added sysfs to list of filesystems not to unmount with
  umount -a, resolves #190385
* Mon Jun 12 2006 kay.sievers@suse.de
- use libvolume_id from provided as a rpm by udev 094
* Wed May 17 2006 jeffm@suse.com
- Fixed support for calling external programs w/o -t <type>,
  it would add mtab twice [#176582]
* Mon Apr 24 2006 hvogel@suse.de
- document xfs dmapi mount options better [#158955]
* Fri Apr 21 2006 olh@suse.de
- add mkzimage_cmdline to edit CHRP zImage kernel cmdline (168313)
* Tue Apr 18 2006 hvogel@suse.de
- fix number of supported raw devices [#165570]
* Wed Mar 29 2006 olh@suse.de
- clearify comments about mac disk label handling in fdisk
* Tue Mar 28 2006 hvogel@suse.de
- more fixes for the fdiskwrap patch [#160822]
* Tue Mar 21 2006 okir@suse.de
- Update nfs(5) manpage to document security flavors [#159368]
* Mon Mar 20 2006 hvogel@suse.de
- fix numbers of supported raw devices to match the kernel
  [#158203]
- make NFSv3 client support RPCSEC_GSS [#158401]
- fix that if the user doesn't specify -t <fstype>
  mount.fstype will never be called. [#155147]
* Fri Mar 10 2006 hvogel@suse.de
- Fix init.d/raw script to parse device names with , in them
  correctly [#155653]
* Thu Mar  9 2006 hare@suse.de
- Fix potential security hole in libvolume_id (#133256)
* Mon Mar  6 2006 hvogel@suse.de
- patch fdiskmaclabel.h too
* Thu Mar  2 2006 hvogel@suse.de
- axboe made fdisk not wrap at 2TB [#153657]
* Fri Feb 17 2006 lmuelle@suse.de
- Use cifs instead of smbfs if the source starts with // and we do not set a
  different fs type.
* Sun Feb 12 2006 olh@suse.de
- cosmetic fix for option_hotplug declaration
  fix unininitalized string for unknown filesystems (#148855)
* Fri Feb 10 2006 hvogel@suse.de
- mount should not put / in the mtab twice if mount -f / is called
  [#148409]
- fix hostid printf [#149163]
* Wed Feb  1 2006 olh@suse.de
- dont invent our own MS_FLAGS (#147132)
* Wed Feb  1 2006 ro@suse.de
- fix typo in previous change, binary negation is "~"
* Fri Jan 27 2006 sscheler@suse.de
- fixed mount hotplug option (#143352). now we don't send the
  MS_HOTPLUG flag to the kernel any longer, because the kernel
  doesn't know this option (EINVAL) and actually doesn't need to
  know about it.
* Fri Jan 27 2006 olh@suse.de
- remove clock symlink, hwclock exists since 7 years
* Fri Jan 27 2006 olh@suse.de
- lsprop and nvsetenv moved to powerpc-utils [#144758]
* Thu Jan 26 2006 hvogel@suse.de
- Make nfsboot world readable [#145418]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Tue Jan 24 2006 mmj@suse.de
- Remove faulty nfs fallback code [#139019]
* Mon Jan 16 2006 mmj@suse.de
- Add patch for nsetenv to fix short reads/short writes [#142546]
* Wed Jan 11 2006 mmj@suse.de
- Update sm-notify [#141542]
* Wed Jan  4 2006 mmj@suse.de
- Update to 2.12r including since 2.12q:
  o cfdisk: fix a segfault with ReiserFS partitions
  o umount: disallow -r option for non-root users
* Tue Nov 22 2005 mmj@suse.de
- install proper renice manpage [#132470]
* Tue Nov 15 2005 uli@suse.de
- umount2 is not static (only fails on ARM, surprisingly)
- added ARM ionice syscalls
* Fri Nov 11 2005 hare@suse.de
- Fix reverse-mapping of by-UUID and by-LABEL mounts.
* Thu Nov 10 2005 hare@suse.de
- Fix a mishandling of by-UUID mounts.
- Use libvolume_id from udev.
* Sat Oct 22 2005 mmj@suse.de
- Increase lsprop.c max property size to 4k [#128155]
* Mon Oct 10 2005 mmj@suse.de
- Add -fno-strict-aliasing to nfsmount_xdr.c
* Mon Oct  3 2005 mmj@suse.de
- Teach the mount manual page about nodiratime [#118987]
* Thu Sep 29 2005 mmj@suse.de
- Patch from jakub007@go2.pl to make mount --move update
  /etc/mtab correctly [#115129]
* Tue Sep 13 2005 mmj@suse.de
- Only allow root to pass -r to umount [#116741]
* Mon Sep  5 2005 mmj@suse.de
- MAC -> Mac [#104081]
* Fri Sep  2 2005 mmj@suse.de
- Don't package manual executable [#114849]
* Thu Sep  1 2005 mmj@suse.de
- Add patch for device-mapper mount by label support [#75966]
* Wed Aug 31 2005 ro@suse.de
- provide and obsolete schedutils
* Tue Aug 23 2005 hvogel@suse.de
- update ionice patch by axboe so that ionice will complain about
  missing sys_ioprio_set support, but it will still
  execute the process.
* Mon Aug 22 2005 hvogel@suse.de
- Fix rpm verify output [#105807]
  (ghost entry for /var/lib/nfs/state)
* Mon Aug 22 2005 schwab@suse.de
- Fix stupid buffer overflow bug in cfdisk [#66020].
* Wed Aug 17 2005 hare@suse.de
- Add option 'hotplug' to mount (#104405)
* Mon Aug 15 2005 schwab@suse.de
- Always build with RPM_OPT_FLAGS.
* Thu Aug 11 2005 mmj@suse.de
- Patch from Patrick Kirsch to make fdisk detect MAC-fs [#104081]
* Wed Aug  3 2005 mmj@suse.de
- Merge schedutils to here (it's happened upstream already)
* Tue Aug  2 2005 mmj@suse.de
- Support for s390 and s390x
* Mon Aug  1 2005 mmj@suse.de
- It's not __ppc_ and __ppc64__ but __powerpc__ and __powerpc64__
* Mon Aug  1 2005 mmj@suse.de
- Add ionice binary from Jens Axboe
* Wed Jun 29 2005 mmj@suse.de
- Document load and clearly issues about NFS over UDP [#80263]
- Don't compile with -fsigned-char [#93886]
* Tue May 31 2005 okir@suse.de
- Added NFSv4 support
* Mon May  9 2005 hvogel@suse.de
- move hashalot and cryptsetup tools to util-linux-crypto
* Tue Apr 12 2005 mmj@suse.de
- bump TCP timeo to 600 [#76198]
* Tue Mar 29 2005 mmj@suse.de
- Add awareness of twofishSL92 [#74359]
- Update hashalot to version 0.3
* Mon Mar 14 2005 okir@suse.de
- Changed sm-notify to recognize host names as well as addresses.
* Thu Mar 10 2005 mmj@suse.de
- Don't strip anything explicitly
- Don't compile with -fno-strict-aliasing [#66020]
* Fri Feb  4 2005 schwab@suse.de
- Fix stupid programmer.
* Mon Jan 24 2005 meissner@suse.de
- implicit strcmp / strerror in setctsid fixed.
- 0 -> NULL in an execl
* Fri Jan 21 2005 mmj@suse.de
- Sleep after inserting the raw module to make sure it's ready [#49807]
- Update to 2.12q including since 2.12p:
  o New upstream maintainer - Adrian Bunk <bunk_at_stusta_dot_de>
  o sfdisk: add -G option
  o Updated translations
* Tue Jan 18 2005 okir@suse.de
- Updated sm-notify; try not to stall bootup my moving the NSM
  state update after we've backgrounded (#49072).
* Mon Jan 10 2005 mmj@suse.de
- Update adjtimex to 1.20
- Update to util-linux-2.12p including since 2.12i:
  o cfdisk: fix number of new partition when partitions not in disk order
  o fdisk: fix Sun label handling in sector mode
  o mkfs: never truncate filename (not that that ever happened)
  o more: fix redraw flaw
  o lomount: revert patch from 2.12j
  o lptune.8: -T option is obsolete
  o mkswap, mkswap.8, swapon: support labels
  o umount: allow user unmounting repeatedly mounted nfs mounts
  o cfdisk: recognize JFS, support reiserfs labels
  o mount: fix option parsing bug
  o mount.8: several updates
  o swapon.8: document -v option
  o Makefile: remove cat-id-tbl.c upon make clean
  o fdisk: fixed a bug that would cause a non-update of a sun disklabel
  o fdisk: use sectorsize instead of 512 for SGI
  o hwclock: actually use HAVE_tm_gmtoff
  o swapon: fix priority handling
  o umount: refuse to unmount an empty string
  o configure, MCONFIG: detect gcc 3.4.0 and use -mtune option
  o configure: do not run ./conftest (for cross compilation)
  o fsck.cramfs: try to get correct PAGE_CACHE_SIZE
  o losetup: try to give better error messages
  o readprofile: default map file is /boot/System.map
  o rdev.8: added historical info on ramdisk
  o cal: highlight today
  o lomount: stop reading passwd at NUL, fix lo_encrypt key_size
  o losetup: add -f option to find an unused loop device
  o more: code cleanup
  o mount: add "group" mount option
  o sfdisk: fix 2.6.8 BLKRRPART ioctl damage
  o swapon: let swapon -a skip the swapfiles marked "noauto"
  o umount: fix problem with empty mtab
  o umount: use special umount program if it exists
  o new flock binary
  o New messages
* Tue Nov 30 2004 mmj@suse.de
- Install ramsize, rdev, rootflags and vidmode on x86-64 [#48633]
* Fri Nov 12 2004 schwab@suse.de
- Don't install *fdisk on ia64.
* Fri Nov 12 2004 ro@suse.de
- correct permissions handling for wall and write
* Tue Nov  9 2004 mmj@suse.de
- Fix segfault with mount -l [#48029]
* Fri Nov  5 2004 mmj@suse.de
- Update to util-linux-2.12i including:
  o MCONFIG: fix build conditions
  o chfn, chsh: add error checking
  o cytune: use local header cyclades.h
  o fdisk: fix default SGI volume header size
  o fstab.c: use strsignal() instead of sys_siglist[]
  o hwclock: use <sys/io.h> when available on i386
  o hwclock: dont try KDGHWCLK on archs other than __m68k__
  o sfdisk: correct typo in __attribute__used nonsense
  o sfdisk: use PACKED on __arm__
  o sfdisk: fix warning printout
* Thu Nov  4 2004 mmj@suse.de
- Update to util-linux-2.12h including:
  o cfdisk: avoid crash if no partition table
  o elvtune: tell user that this only works on 2.4 kernels
  o lomount: clear passwords after use
  o mount: accept comments (specified by comment=) in fstab
  o mount: support ocfs, ocfs2
  o [u]mount: be more careful with malloc, try to avoid OOM with
    many mounts
  o sfdisk: __attribute__used nonsense to support gcc 3.4
  o shutdown: do not unmount various virtual filesystems
  o mount.8: added recent ext2 mount options
  o mount: support jfs mount-by-label, improve reiserfs support
  o sfdisk: remove strange "ends in a digit" heuristic
  o *fdisk: use common disksize() routine
* Tue Oct 19 2004 mmj@suse.de
- Add patch from SGI for fdisk label [#47368]
* Tue Sep 28 2004 mmj@suse.de
- And another one [#46201]
* Wed Sep 15 2004 mmj@suse.de
- Add patch from Andries to fix cfdisk [#44996]
* Tue Sep  7 2004 mmj@suse.de
- Update to util-linux-2.12c including:
  o mount.8: added recent ext2 mount options
  o mount: support jfs mount-by-label, improve reiserfs support
  o sfdisk: remove strange "ends in a digit" heuristic
  o *fdisk: use common disksize() routine [#44678]
* Wed Aug 25 2004 mmj@suse.de
- Update to util-linux-2.12b including:
  o  chsh: improved error message
  o  dmesg: ask kernel proper buffer size
  o  losetup: handle 64-bit offsets
  o  blockdev: also report BLKGETSIZE64 result [#43464]
  o  blockdev, elvtune, fdisk: handle new kernel _IOR,_IOW defines
  o  fdisk: remove strange "ends in a digit" heuristic
  o  fdisk: also list Solaris as possible type for 0x82
  o  mount: added --rbind option
  o  mount: use blkid library
  o  mount: support reiserfs mount by label
  o  mount: attempt to use the right definition of dev_t in struct
    loopinfo
  o  mount.8: jfs mount options added
  o  readprofile: new -s option
  o  rename.1: added ref to mmv.1
  o  replay: renamed to scriptreplay; correct typos
  o  script: do not use locale for time delay floating point number
    format
  o  sfdisk: error messages to stderr
  o  New Catalan, Dutch, Finnish, French, German, Spanish, Swedish,
    Turkish, Ukrainian messages
- Update the loop-AES patch, thanks to Sumit Bose
- Change the minimum password length to 8 chars
* Tue Aug 24 2004 mmj@suse.de
- Fix signed/unsigned bug in lsprop [#44048]
* Wed Aug 18 2004 mmj@suse.de
- Readd patch that got lost to make fdisk -l work better with
  RAID controllers [#43485]
* Mon Aug  9 2004 mmj@suse.de
- Add an improved version of the dmesg bufsize patch.
* Tue Jun 22 2004 mmj@suse.de
- Add patch to try and guess a filesystem type before blindly
  assuming it's nfs because of the colon [#42097]
* Mon Jun 14 2004 agruen@suse.de
- Formatting error in mount.8 manual page.
* Wed Jun  9 2004 mmj@suse.de
- Add patch from Olaf Kirch to make protocol selection for mount
  independent of protocol selection for NFS, and picks what is
  available (preferring TCP over UDP) [#41735]
* Wed Jun  9 2004 mls@suse.de
- add '-f' option to setctsid
* Thu May 27 2004 okir@suse.de
- sm-notify now binds to a reserved port
* Sat May 15 2004 mmj@suse.de
- Add documentation about raw device handling [#39037]
* Mon May 10 2004 mmj@suse.de
- Make dmesg dump entire buffer. Patch from Andries/odabrunz [#39761]
* Thu May  6 2004 mmj@suse.de
- Also check if the device is the same when doing swapon. Could be
  the same block device with 2 different names [#39436]
* Wed May  5 2004 mmj@suse.de
- Do a /sbin/modprobe raw when invoking raw devices [#39037]
* Tue Apr 20 2004 mmj@suse.de
- Update to 2.12a including:
  o fdisk: fix for kernels 2.4.15-2.4.17
  o fdisk: fix when all partitions are in use
  o hwclock: add a timeout when waiting for a clock update
  o ipcs: compilation fix
  o ipcs: shminfo.shmall gives pages
  o mount: efs support
  o partx: bigendian fix
  o readprofile: support for 64-bit addresses
  o setterm: fix klogctl error message
  o setterm.1: clarification
  o sfdisk: fix check for is_ide_cdrom_or_tape
  o umount: skip proc, devfs, devpts on umount -a
* Mon Apr 19 2004 mmj@suse.de
- Add patch for unlimited raw devices [#39037]
* Thu Apr 15 2004 mmj@suse.de
- Make sm-notify be more quiet when nothing wrong, and log to sys-
  log when something is.
* Tue Apr  6 2004 mmj@suse.de
- Don't use startproc for sm-notify [#38481]
* Mon Apr  5 2004 mmj@suse.de
- Removing elvtune alltogether was a bit drastic, since it of
  course works fine with 2.4 kernels. So print a warning in case
  the BLKELVGET ioctl returns something indicating 2.6 kernels.
* Thu Apr  1 2004 mmj@suse.de
- Don't package elvtune anymore since it's obsolete now that io
  scheduler can be tuned in /sys/block/hdX/queue/iosched/* [#37869]
* Wed Mar 31 2004 mmj@suse.de
- Apply util-linux-2.12a fixes for hwclock and readprofile. The
  hwclock bit is a timout fix which hopefully fixes [#35877]
- Move sm-notify to here from nfs-utils [#36737]
* Mon Mar 29 2004 mmj@suse.de
- Adjust warnings about Crypto-API
* Sun Mar 28 2004 mmj@suse.de
- Add patch to make script allways use the same LC_NUMERIC [#35476]
* Fri Mar 26 2004 od@suse.de
- Add setctsid by Werner Fink [#37177]
* Fri Mar 26 2004 mmj@suse.de
- Mount option "code" is now "codepage" so update /etc/fstab in
  postinstall [#36950]
* Fri Mar 26 2004 mmj@suse.de
- Remove false statement in nfs.5 about the linux kernel not
  supporting nfs over tcp [#37060]
* Wed Mar 17 2004 mmj@suse.de
- Use correct permissions for README.hashalot [#36303]
* Mon Mar  8 2004 mmj@suse.de
- Enable build of replay [#35434]
* Wed Feb 25 2004 mmj@suse.de
- Use loop-AES-v2.0f-util-linux-2.12.diff instead of losetup patch
  added earlier. Thanks Sumit Bose!
* Thu Feb 19 2004 mmj@suse.de
- Add cryptsetup script from Christophe Saout, for usage with the
  new dm-crypt.
* Mon Feb 16 2004 mmj@suse.de
- Add losetup patch and hashalot program from Ben Slusky
* Sun Feb  1 2004 kukuk@suse.de
- Remove newgrp again (will use POSIX conform version)
* Fri Jan 16 2004 kukuk@suse.de
- Add pam-devel to neededforbuild
* Mon Jan 12 2004 mmj@suse.de
- Adjust the nfs.5 manual page to reflect we're mounting nfs over
  tcp pr. default.
- Collapse two similar patches 2 one.
* Fri Dec 19 2003 garloff@suse.de
- Fix by okir for previous patch.
* Fri Dec 19 2003 garloff@suse.de
- Add patch to fallback to UDP if TCP NFS mount fails.
* Tue Dec  2 2003 mmj@suse.de
- Make patch to guess if a CD is a CD-Extra [#30316]
- Adjust patch that moves ext2/3 in front of vfat
- Regenerate patches (filename still tells when they were added)
* Tue Nov 18 2003 mmj@suse.de
- Mount NFS over TCP pr. default [#33018]
* Thu Nov 13 2003 mmj@suse.de
- Update to util-linux-2.12 including:
  o losetup: -p option specifies fd for passphrase
  o fdisk: sgi layout fix
  o mount: -p option specifies fd for passphrase
  o mount: recognize some PCDOS floppies
  o umount: in "umount name", first try to interpret "name" as a mount point
  o translations updates for several languages
  o cfdisk: localize the Y/N answer, improve printing localized messages
  o cfdisk: make various variables long long - some disks are close to 2 TB
  o cfdisk: use BLKGETSIZE64
  o fdisk: make various variables unsigned to lengthen the life of 32-bit vars
  o fdisk: some sgi fixes
  o fdisk: k=1000, K=1024
  o fdisk: removed last occurrences of HDIO_REQ
  o fdisk: use BLKGETSIZE64
  o hwclock: fix rtc test
  o login: set a timeout on printing the timeout message
  o md5: x86_64 fix
  o more: POSIX fixes
  o mount: do not supply MS_MGC_VAL when there are conflicting flags
  o mount: ncp and smb are called smbfs and ncpfs - global change
  o mount: add support for xvm mount by label
  o mount: correct hfs magic recognition
  o mount: keep original umask - it influences the mount call
  o raw.8: documented unbinding of raw devices
  o readprofile: fixed off-by eight error
  o script: add -c option
  o sfdisk.8: added an example of partitioning with logical partitions
  o sfdisk: only add a AA55 signature for DOS-type partition tables
  o tailf: new
* Tue Oct 21 2003 mmj@suse.de
- Correct permissions
* Tue Oct 21 2003 ja@suse.cz
- added support for cryptoloop in 2.6.x kernels.
* Wed Oct 15 2003 mmj@suse.de
- Don't build as root
* Mon Oct 13 2003 kukuk@suse.de
- Enable newgrp
* Thu Oct  2 2003 kukuk@suse.de
- Fix compiling with kernel 2.6.0-test6 header files
* Tue Aug 12 2003 mmj@suse.de
- Update to pmac-utils-2.1 sources and only include nvsetenv
* Tue Aug 12 2003 mmj@suse.de
- Add mount_guessfstype support for PCDOS [#27814]
* Wed Jun 18 2003 ak@suse.de
- support noreserved option for NFS (#27428)
* Thu Jun  5 2003 mmj@suse.de
- Rearrange the specfile wrt. archs
* Tue May 13 2003 mmj@suse.de
- Use %%defattr
- Remove files we don't package
* Wed May  7 2003 mmj@suse.de
- Rearrange the do_guess_fstype() code to look for ext2/3 before
  vfat [#26581]
* Thu Apr 24 2003 ro@suse.de
- fix install_info --delete call and move from preun to postun
* Mon Apr 14 2003 pthomas@suse.de
- Get rid of the syscall for adjtimex in selective cases and
  just call the glibc wrapper. Fixes build on s390.
* Mon Apr 14 2003 pthomas@suse.de
- Use geteuid instead of getuid in hwclock to enable making
  hwclock suid root.
* Mon Apr  7 2003 mmj@suse.de
- Only delete info entries when removing last version.
* Thu Mar 13 2003 mmj@suse.de
- Apply patch to make sfdisk not destroy BSD slices [#25093]
* Mon Mar  3 2003 mmj@suse.de
- Remove superflous umask(033); calls [#23292]
* Mon Mar  3 2003 ro@suse.de
- add missing info dir entries
* Tue Feb 18 2003 agruen@suse.de
- Add description of the effect of `mount -t nfs -o noacl' on
  the use of the GETACL and SETACL remote procedure calls to
  the nfs(5) manual page.
* Mon Feb 17 2003 mmj@suse.de
- It's called smbfs not smb [#23697]
* Thu Feb 13 2003 mmj@suse.de
- Readd patch for passphrase timeout that got lost [#23527]
* Fri Feb  7 2003 mmj@suse.de
- The install_info macros need PreReq: %%install_info_prereq
* Fri Feb  7 2003 ro@suse.de
- added install_info macros
* Tue Feb  4 2003 ro@suse.de
- don't package /bin/kill (part of coreutils now)
* Tue Feb  4 2003 meissner@suse.de
- Include tarball with pmac-utils manpages, so we do not need
  sgmltool and all its dependents.
* Wed Jan 29 2003 mmj@suse.de
- Update to util-linux-2.11z including:
  * Translation updates
  * mount: fix LABEL= handling for user umount, don't abort on read
    error with photocds and add dmask and fmask vfat mount options
  * setterm: accept devfs name
  * simpleinit: security: refuse initctl_fd if FD_CLOEXEC fails
  * umount: allow user umount after mount by label or uuid
* Wed Jan 22 2003 sf@suse.de
- removed last patch, added new (correct) patch
* Wed Jan 22 2003 sf@suse.de
- removed eliminate_doubles() from mkfs.cramfs.c
  for x86_64, as it segfaults.
  (makes the images slightly larger, about 10%%)
* Tue Jan 21 2003 mmj@suse.de
- Added description of ISO mount options to mount.8 [#22915]
* Mon Dec  2 2002 mmj@suse.de
- Update the ReiserFS patch from Chris Mason
* Fri Nov 29 2002 mmj@suse.de
- Fix missing #include <errno.h>
* Thu Nov 28 2002 mmj@suse.de
- Make readprofile also try to locate the System.map in
  /boot/System.map-`uname -r` [#22168]
* Wed Nov 27 2002 mmj@suse.de
- Update to util-linux-2.11y including:
  o Translation updates
  o fdisk,cfdisk: cosmetic fixes
  o mount,umount: fix LABEL= handling for non-root [#17322]
  o more: kill external help file
  o simpleinit: security: refuse initctl_fd if setting FD_CLOEXEC
    fails (patch we had, now folded upstream)
* Wed Nov 20 2002 mmj@suse.de
- Update to util-linux-2.11x including:
  o Translation updates for several languages
  o cfdisk: correct error printout
  o fdisk: allow addition of a new partition when logicals all used
    but primary free
  o hwclock: detect systime jumps backward during setting hwclock
  o Merge of the cramfs bloksize patch
  o mount: new --rbind flag, for recursive loopback mounts
  o mount, umount: new -O option
  o setpwnam.c: open temp pw file with O_EXCL
  o simpleinit: fix for "spawn too fast"
  o swapon: new -e option
* Tue Nov 19 2002 mmj@suse.de
- Fix multistring assignment in adjtimex
* Mon Nov 11 2002 ro@suse.de
- changed neededforbuild <sp> to <opensp>
- changed neededforbuild <sp-devel> to <>
* Thu Oct 31 2002 mmj@suse.de
- Add -b option to mkfs.cramfs (needed for biarch architectures)
* Wed Oct 30 2002 ro@suse.de
- hack time to build on alpha
* Tue Oct 22 2002 mmj@suse.de
- Add correction to the ReiserFS patch that fixes the case where it
  was possible but unlikely to detect a logged copy of a super on a
  dedicated logging device as the real thing. From Chris Mason.
* Tue Oct 22 2002 mmj@suse.de
- Update to util-linux-2.11w including:
  o fdisk and cfdisk fixes
  o more bigendian fix
  o translation updates
  o > 2GB swapspace
  o mount umask, cramfs and ocfs stuff
* Tue Oct  8 2002 mmj@suse.de
- Only enable below patch on ix86 and x86_64
* Mon Oct  7 2002 mmj@suse.de
- Make small bugfix to below patch
* Fri Oct  4 2002 mmj@suse.de
- Apply patch to enable > 2GB swap (redhat) [#20533]
* Wed Oct  2 2002 mmj@suse.de
- Add one-liner security fix to mount and umount.
* Mon Sep 23 2002 mmj@suse.de
- Readd fix for klogconsole that got lost [#19834]
* Fri Sep 13 2002 mmj@suse.de
- Added patch from Oracle to mount ocfs by label [#19262]
* Thu Sep 12 2002 mmj@suse.de
- more: Do not cast char * to int and back [#18896]
* Sat Aug 31 2002 olh@suse.de
- add mount_cramfs_be.diff to allow mount -oloop cramfsfile loopdir
* Mon Aug 26 2002 mmj@suse.de
- Make mode not 666 when writing /etc/mtab [#18342]
* Mon Aug 26 2002 meissner@suse.de
- quieten klogconsole if the console does not support TIOCLINUX [#12516]
* Thu Aug 22 2002 mmj@suse.de
- Added patch from Andreas Gruenbacher for nfs-access-acl [#18183]
* Wed Aug 21 2002 mmj@suse.de
- Fixed an mtab locking bug with patch from Olaf Kirch [#17637]
* Mon Aug 19 2002 mmj@suse.de
- Updated reiserfs patch from Chris Mason
- Added patch for mount.8, thanks Andreas Gruenbacher
* Thu Aug 15 2002 mmj@suse.de
- Correct PreReq:
* Mon Aug  5 2002 mmj@suse.de
- Update to 2.11u which includes:
  o Danish, German, Spanish, Swedish and Turkish updates.
  o configure: for fsck.cramfs, mkfs.cramfs: add test for libz
  o text-utils/Makefile: pg fix
  o agetty: use same test as login does to find utmp entry
  o fdisk: fix for fdisk on empty disk
  o mount updates
* Tue Jul 23 2002 schwab@suse.de
- Fix mkfs.cramfs for architectures with non-4k pages.
* Tue Jul 16 2002 mmj@suse.de
- Merged base into util-linux
* Mon Jul 15 2002 mmj@suse.de
- Added JFSv2 patch from Christoph Hellwig for volume label. Does
  for JFS, what below patch does for ReiserFS.
* Sun Jul 14 2002 adrian@suse.de
- fix ul-2.10m-sgi-fdisk.diff patch to apply again
* Thu Jul 11 2002 mmj@suse.de
- Added patch from Chris Mason for volume label on reiserfs
* Wed Jul 10 2002 olh@suse.de
- add mkfs.cramfs and fsck.cramfs to file list
* Wed Jul 10 2002 mmj@suse.de
- Fixed nfs.5 to tell nfsver defaults to 3 [#16815]
* Mon Jul  8 2002 mmj@suse.de
- Update to 2.11t which includes
  * fdformat: remove test on major
  * fdisk, hwclock and swap polishing
  * Lots of translations
  * cramfs tools includes from the kernel
  * swap{on,off} honours /proc/swaps
  * mount small fixups
* Fri Jul  5 2002 kukuk@suse.de
- Use %%ix86 macro
* Mon Jul  1 2002 bk@suse.de
- get raw built on s390 and s390x
- remove %%ifarchs s390 s390x for fdisk(needed for SCSI disks)
* Mon Jun 17 2002 mmj@suse.de
- Added a fix for simpleinit exploit.
* Thu Jun 13 2002 olh@suse.de
- disable hwclock ppc patch, maybe obsolete with recent kernels
* Thu May 16 2002 mmj@suse.de
- Added manpage guessfstype(8)
* Thu May  9 2002 mmj@suse.de
- Updated to util-linux-2.11r, including translations, x86-64 sup-
  port and small bugfixes.
* Sat Apr 13 2002 mmj@suse.de
- Updated to util-linux-2.11q, includes bugfixes.
- util-linux-mkswap.patch for ia64 was folded into mainline
* Fri Apr 12 2002 stepan@suse.de
- added x86-64 support.
* Thu Apr  4 2002 ihno@suse.de
- corrected printf to report shared memories sizes bigger than
  2 GByte correct (Bug #15585). It was reportet on s390x, but
  should effect other 64-Bit systems as well.
* Tue Mar 19 2002 mmj@suse.de
- Updated to 2.11o. The hexdump patch have been dropped since it
  was folded to mainline util-linux.
* Fri Mar 15 2002 schwab@suse.de
- Fix mkswap for ia64.
* Mon Mar  4 2002 draht@suse.de
- permissions fixes for write(1) and wall(1)
* Fri Feb  1 2002 mmj@suse.de
- Moved /usr/bin/logger to /bin/logger (needed by sysconfig)
* Mon Jan 28 2002 mmj@suse.de
- Added the guessfstype binary from msvec/fehr
* Thu Jan 24 2002 ro@suse.de
- modified fillup_and_insserv call (perl-hack not needed here)
* Mon Jan 21 2002 mmj@suse.de
- Merge NetBSD hexdump changes, fixes bugzilla #12801
* Thu Jan 10 2002 ro@suse.de
- removed ACTIVATE_RAW_DEV
* Mon Dec 31 2001 adrian@suse.de
- add patch for mips to create SGI partition tables with fdisk
* Tue Dec 18 2001 bjacke@suse.de
- add adjtimex
* Mon Dec 10 2001 mmj@suse.de
- Update to util-linux-2.11n
* Tue Nov 20 2001 mmj@suse.de
- Added a patch to 'wall' to remove unwanted newline (#12181)
* Wed Nov  7 2001 kukuk@suse.de
- Remove unneeded SPARC patch for hwclock
* Sat Oct 13 2001 kukuk@suse.de
- Update to util-linux 2.11l
* Tue Sep 11 2001 garloff@suse.de
- Fixed some dutch translations. (bug #10276)
* Mon Sep 10 2001 olh@suse.de
- marry fdisk and AIX label again...
  add lsprop for ppc
  dumps the device tree in a human readable format
* Mon Sep  3 2001 kukuk@suse.de
- Update to version 2.11i:
  - blockdev: corrected ioctl numbers
  - cal: fixed for multibyte locales
  - line: new
  - mount: added vxfs magic
* Sat Sep  1 2001 kukuk@suse.de
- Let mount follow symlinks again
* Wed Aug 29 2001 kukuk@suse.de
- Add new option to losetup manual page
* Tue Aug 28 2001 draht@suse.de
- added timeout support for losetup (-t <timeout>)
* Mon Aug 27 2001 kukuk@suse.de
- Add raw rc scripts, too
* Sun Aug 26 2001 bjacke@suse.de
- added raw binary and put rawio into obsoletes and provides
* Sat Aug 25 2001 kukuk@suse.de
- Fix path in getopt.1 manual page to example directory [Bug #9831]
* Fri Aug 24 2001 kukuk@suse.de
- Small fix for hwclock on newer SPARCs
* Mon Aug 13 2001 ro@suse.de
- changed neededforbuild <sp_libs> to <sp-devel>
* Mon Jul 30 2001 kukuk@suse.de
- Update to util-linux-2.11h
- Add nologin program
* Tue Jul 10 2001 kukuk@suse.de
- Remove swapdev from filelist
* Tue Jul 10 2001 kukuk@suse.de
- Update to util-linux-2.11g
* Wed Jun  6 2001 bk@suse.de
- added s390x to all ifnarch s390
* Fri Apr 20 2001 kukuk@suse.de
- Fix wall bug (character 80, 160, 240, are missing) [Bug #6962]
* Mon Mar 26 2001 kukuk@suse.de
- Add exception for broken i2o disk device numbering scheme, kernel
  hacker are not able to fix this and make it right [Bug #5881].
* Sat Mar 24 2001 kukuk@suse.de
- Update to util-linux 2.11b
* Thu Mar 15 2001 kukuk@suse.de
- Fix changing of partitions with ID 0 on SPARC
- Remove duplicate mount patch
* Wed Mar 14 2001 schwab@suse.de
- Don't use _syscallX on ia64.
- Fix missing includes.
* Wed Mar 14 2001 kukuk@suse.de
- Update to version 2.11a
* Fri Mar  2 2001 kukuk@suse.de
- enable write again
* Mon Feb 12 2001 kukuk@suse.de
- cmos.c: Use sys/io.h, fix PowerPC hack
* Tue Feb  6 2001 ro@suse.de
- wall.c: include time.h
* Mon Feb  5 2001 kukuk@suse.de
- Split hex to extra package
- Update to util-linux-2.10s
* Fri Feb  2 2001 werner@suse.de
- Make swapon/swapoff more handy:
  * Ignore swap files on ro mounted file systems
  * If -a is given ignore already active devices at swapon
  * If -a is given ignore not active devices at swapoff
* Wed Jan 24 2001 ro@suse.de
- added Provides: util
* Fri Jan 12 2001 garloff@suse.de
- Apply patch to lomount to allow all kerneli crypt algos to be
  passed and allow to pass passwd with -k.
- losetup seems to support >2GB files just fine (#5433)
* Tue Jan  2 2001 kukuk@suse.de
- Save permissions of /etc/mtab [Bug #5027]
* Tue Dec  5 2000 kukuk@suse.de
- Search first in /etc/filesystems, then in /proc/filesystems
* Tue Dec  5 2000 kukuk@suse.de
- Use AIX/fdisk patch from util-linux-2.10r
- Backport "guess filesystems" from util-linux-2.10r
* Tue Dec  5 2000 schwab@suse.de
- Don't use _syscallX on ia64.
* Mon Dec  4 2000 olh@suse.de
- fix diff again
* Sat Dec  2 2000 olh@suse.de
- no segfaults with AIX disklabels
* Wed Nov 29 2000 uli@suse.de
- fixed to build on PPC
* Mon Nov 27 2000 schwab@suse.de
- Fix broken casts in hwclock.
* Thu Nov 23 2000 bk@suse.de
- temporary disable pivot_root on s390(2.4 kernel is not yet built)
* Wed Nov 22 2000 schwab@suse.de
- Add pivot_root to file list.
* Mon Nov 20 2000 kukuk@suse.de
- Fix pmac-utils to compile with new kernel
* Fri Nov 17 2000 kukuk@suse.de
- Fix hwclock to compile on PPC
* Wed Nov 15 2000 kukuk@suse.de
- Update util-linux to 2.10q, merge flushb.diff
* Thu Nov  2 2000 kukuk@suse.de
- Remove some of the last specfile changes
* Wed Nov  1 2000 olh@suse.de
- update pmac-utils for new powermacs, cleanup specfile
* Fri Oct 20 2000 kukuk@suse.de
- Update util-linux to 2.10p
- Rename package from util to util-linux
* Wed Sep 27 2000 kukuk@suse.de
- Allow NFS v3 with 2.2.17.SuSE
* Tue Sep 26 2000 kukuk@suse.de
- Fix mount for new NFS kernel patch
* Sat Sep  9 2000 kukuk@suse.de
- Remove tcsh dependency
- Update to util-linux 2.10o, use of /etc/filesystems is still broken
* Fri Aug 25 2000 pthomas@suse.de
- use %%{_mandir} and %%{_infodir} exclusively. This allows building
  from source rpm on platforms other than 7.0.
* Tue Jul 18 2000 bk@suse.de
- s390: removed dasdfmt and silo, %%ifnarch s390 for some non-s390 things.
* Tue May 30 2000 bk@suse.de
- added dasdfmt and silo on s390
* Mon May 15 2000 kukuk@suse.de
- util-linux: Update to 2.10m
* Wed Apr 26 2000 kukuk@suse.de
- flusb: Don't use kernel headers, even if we don't need them!
* Wed Apr 19 2000 kukuk@suse.de
- util-linux: Update to 2.10l
* Mon Apr 17 2000 kukuk@suse.de
- util-linux: Update to 2.10k
* Thu Apr 13 2000 kukuk@suse.de
- Move /sbin/setserial to /bin/setserial, add compat link to
  /sbin. This fixes [Bug 1084] and is necessary for FHS 2.1
* Wed Apr 12 2000 kukuk@suse.de
- Fix util-linux for Alpha
* Wed Apr 12 2000 kukuk@suse.de
- util-linux: Update to 2.10j
* Sat Apr  1 2000 bk@suse.de
- suse s390 team added support for s390
* Thu Mar 30 2000 uli@suse.de
- hwclock/PPC: added support for MK48T559 RTC chip used in MTX+ boards
* Fri Mar 24 2000 kukuk@suse.de
- Add Linux LVM partition tag to fdisk
- Fix a lot of more possible buffer overruns
- Fix some fdisk sunlabel bugs
- added BuildRoot fixes from nadvorni@suse.cz
* Wed Mar 22 2000 kukuk@suse.de
- Update util-linux to 2.10h
- Add clock again for non PPC platforms
* Fri Mar 17 2000 uli@suse.de
- now contains both hwclock and clock on PPC (/sbin/init.d/boot
  chooses what to run at runtime)
* Tue Mar 14 2000 schwab@suse.de
- Add support for ia64.
* Thu Mar  9 2000 kukuk@suse.de
- fdisk: Fix -l for Mylex RAID controller
* Tue Mar  7 2000 kukuk@suse.de
- etc/filesystems: Add minix and reiserfs
* Tue Mar  7 2000 kukuk@suse.de
- mount: fix endian problem with minix fs
* Tue Feb 15 2000 kukuk@suse.de
- mount: Add hack for PPC/syscall mount problem
* Sun Feb 13 2000 bk@suse.de
- let rdev continue in case it stubles over a bad file in /dev (/dev/snd fix)
* Fri Feb  4 2000 kukuk@suse.de
- Make PPC clock parameter compatible to hwclock
* Thu Feb  3 2000 kukuk@suse.de
- Fix filelist for SPARC
* Thu Feb  3 2000 kukuk@suse.de
- util-linux: Update to 2.10f (mount security fix)
* Sun Jan 23 2000 kukuk@suse.de
- util-linux: Update to 2.10e
* Tue Jan 18 2000 kukuk@suse.de
- mount now looks at first in /etc/filesystems and then in
  /proc/filesystems
* Tue Jan 18 2000 ro@suse.de
- fixed pmac-utils to build with 2.3 as well
* Tue Jan 18 2000 kukuk@suse.de
- Fix a lot of fdisk buffer overruns [Bug 1642]
* Mon Jan 17 2000 kukuk@suse.de
- Fix setserial for Linux 2.3.40
- Remove write, is now in nkitb
- Build minix and bfs tools for SPARC
- Fix some buffer overflows in fdisk
* Fri Dec 17 1999 kukuk@suse.de
- util-linux: Update to 2.10d
- hex: Update to 1.2
- Move manual pages to /usr/share/man
* Tue Nov 30 1999 uli@suse.de
- re-added hwclock link for PPC (2nd try)
* Tue Nov 30 1999 uli@suse.de
- re-added hwclock link for PPC
* Mon Nov 15 1999 kukuk@suse.de
- util-linux: Update to 2.10b
* Sat Nov 13 1999 kukuk@suse.de
- setserial: Add Patch for Sparc
- Fix filelist for Sparc
* Wed Oct 27 1999 garloff@suse.de
- added flushb (moved here from ddrescue).
- fix bug in logger (remove trailing newlines).
* Fri Oct 22 1999 kukuk@suse.de
- util-linux: Remove old patches for mk_loop_h
* Sat Oct 16 1999 kukuk@suse.de
- util-linux: Update to 2.9z
* Fri Oct  8 1999 kukuk@suse.de
- Update to util-linux-2.9y (execpt fdisk)
* Tue Sep 14 1999 uli@suse.de
- added PMac-specific utils for PPC
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Aug 26 1999 uli@suse.de
- disabled hayesesp for PPC
* Wed Aug 25 1999 kukuk@suse.de
- Don't install tsort, its now in textutils 2.0
* Tue Aug 24 1999 kukuk@suse.de
- Update to util-linux-2.9w (execpt fdisk)
* Mon Aug  9 1999 kukuk@suse.de
- Update to util-linux-2.9v (execpt fdisk)
* Tue Jul 20 1999 garloff@suse.de
- Added hex from Erich S. Raymond
* Mon Jul 12 1999 kukuk@suse.de
- Add fdisk patch from Klaus G. Wagner
- Add mount patch from util-linux 2.9u
* Tue Jul  6 1999 kukuk@suse.de
- update to util-linux-2.9t
* Fri Jun 25 1999 kukuk@suse.de
- update to util-linux-2.9s
* Wed Mar  3 1999 ro@suse.de
- hwclock.c: always use busywait to get rtctime
  (it's hard to find out at runtime if we will get an irq)
* Mon Mar  1 1999 ro@suse.de
- update to util-linux-2.9i
- update to setserial-2.15
- using diffs from jurix and add-ons from kgw for compaq smart raid
* Mon Feb  1 1999 ro@suse.de
- rdev is not built on alpha
* Mon Jan 18 1999 florian@suse.de
- fixed one broken case to delete a partition in fdisk
* Sun Dec 13 1998 bs@suse.de
- fixed file list
* Thu Dec 10 1998 fehr@suse.de
- fix bug in fdisk
* Tue Dec  8 1998 ro@suse.de
- removed last from filelist
- added link /sbin/clock -> hwclock
* Tue Nov  3 1998 ro@suse.de
- fdisksunlabel: don't include scsi/scsi.h for glibc-2.0
* Fri Oct 30 1998 ro@suse.de
- update to 2.9 / added hostid from previous diff
- copied some glibc changes from previous diff (strcpy..)
* Thu Sep 17 1998 ro@suse.de
- define _GNU_SOURCE when using getopt
* Mon Aug 31 1998 ro@suse.de
- full switch to util-linux 2.8
--  sync has moved to pkg fileutils
--  chroot has moved to pkg sh_utils (has been there for a while)
--  adopted hostid from previous suse-pkg
* Mon Aug 24 1998 ro@suse.de
- switched to use mount from util-linux-2.8
* Tue Jun 23 1998 ro@suse.de
- added fdisk, sfdisk, cfdisk from util-linux-2.8
  (including man-pages,readmes)
* Mon Nov 17 1997 ro@suse.de
- changed /local/bin/perl5 in chkdupexe to /usr/bin/perl
* Fri Oct 31 1997 ro@suse.de
- temporarily removed mount-hacker
* Wed Oct 29 1997 florian@suse.de
- add changes from ms@suse.de for hostid.c
* Tue May 20 1997 florian@suse.de
- only support kernel 2.0.x for nfs mounts, please use /bin/mount-hacker
  for kernel 2.1.x
* Wed Apr 30 1997 florian@suse.de
- update to mount 2.6g
* Sun Apr 13 1997 florian@suse.de
- update to new version util-linux 2.6
- update to new version mount 2.6e
* Thu Jan  2 1997 florian@suse.de
- update to mount 2.5p
* Thu Jan  2 1997 florian@suse.de
- Update auf neue Version von mount 2.5o.
* Thu Jan  2 1997 florian@suse.de
- updated to new version mount 2.5m
- (u)mount now gives much better error messages
* Thu Jan  2 1997 bs@suse.de
  compile setterm with libtermcap and not libncurses
  use newer mount instead of the old version in util-linux
  (security fix)
