# Generated by rust2rpm 27
%bcond check 1

# Enable gpg signature verification by default
%bcond gpgcheck 1

# prevent library files from being installed
%global cargo_install_lib 0

%global soname libkryoptic_pkcs11

%if 0%{?rhel}
# RHEL: Use bundled deps as it doesn't ship Rust libraries
%global bundled_rust_deps 1
%global __brp_mangle_shebangs_exclude_from ^/usr/src/debug/.*$
%else
# Fedora: Use only system Rust libraries
%global bundled_rust_deps 0
%endif


Name:           kryoptic
Version:        1.3.0
Release:        %autorelease
Summary:        PKCS #11 software token written in Rust

SourceLicense:  GPL-3.0-or-later
# Apache-2.0
# Apache-2.0 OR BSL-1.0
# Apache-2.0 OR MIT
# BSD-2-Clause OR Apache-2.0 OR MIT
# BSD-3-Clause
# GPL-3.0-or-later
# MIT
# MIT OR Apache-2.0
# MIT-0 OR Apache-2.0
# Unlicense OR MIT
License: Apache-2.0 AND (Apache-2.0 OR BSL-1.0) AND (Apache-2.0 OR MIT) AND (BSD-2-Clause OR Apache-2.0 OR MIT) AND (BSD-3-Clause) AND (GPL-3.0-or-later) AND (MIT) AND (MIT OR Apache-2.0) AND (MIT-0 OR Apache-2.0) AND (Unlicense OR MIT)
# LICENSE.dependencies contains a full license breakdown

URL:            https://github.com/latchset/kryoptic
Source0:        https://github.com/latchset/kryoptic/releases/download/v%{version}/%{name}-%{version}.tar.gz
Source1:        https://github.com/latchset/kryoptic/releases/download/v%{version}/%{name}-vendor-%{version}.tar.gz
%if %{with gpgcheck}
Source2:        https://github.com/latchset/kryoptic/releases/download/v%{version}/%{name}-%{version}.tar.gz.asc
Source3:        https://github.com/latchset/kryoptic/releases/download/v%{version}/%{name}-vendor-%{version}.tar.gz.asc
Source4:        https://people.redhat.com/~ssorce/simo_redhat.asc
%endif

BuildRequires:  openssl-devel
%if %{with gpgcheck}
BuildRequires: gnupg2
%endif

%if 0%{?bundled_rust_deps}
BuildRequires:  rust-toolset
BuildRequires:  clang
# vendored rustqlite
BuildRequires:  sqlite-devel
%else
BuildRequires:  cargo-rpm-macros >= 26
%endif


%global _description %{expand:
A PKCS #11 software token written in Rust.}

%description %{_description}

%package tools
Requires:       %{name}%{?_isa} = %{version}-%{release}
Summary:        Supporting tools for kryoptic software token

%description tools
Supporting tools for kryoptic software token.
Most notably a migration tool for the SoftHSM database.

%prep
%if %{with gpgcheck}
%{gpgverify} --keyring='%{SOURCE4}' --signature='%{SOURCE2}' --data='%{SOURCE0}'
%{gpgverify} --keyring='%{SOURCE4}' --signature='%{SOURCE3}' --data='%{SOURCE1}'
%endif
%autosetup -p1 -N %{?bundled_rust_deps:-a1}
%if 0%{?bundled_rust_deps}
%cargo_prep -v vendor

# don't lock the dependencies
rm -f Cargo.lock
%else
%cargo_prep

%generate_buildrequires
%cargo_generate_buildrequires -f nssdb,pqc
%endif

%build
export CONFDIR=%{_sysconfdir}
%cargo_build -f nssdb,pqc -- --all
%{cargo_license_summary -f nssdb,pqc}
%{cargo_license -f nssdb,pqc} > LICENSE.dependencies

%install
# Have to cd because the macro already defines --path . and cargo install
# in workspaces does not take a --all, requires to install each package
# explicitly, and we care only for the tools, as install does not install
# cdylib package outputs.
pushd tools
%cargo_install -f kryoptic-lib/nssdb,kryoptic-lib/pqc,kryoptic-lib/standard,kryoptic-lib/dynamic -- --bin softhsm_migrate
popd
install -Dp target/rpm/%{soname}.so $RPM_BUILD_ROOT%{_libdir}/pkcs11/%{soname}.so

mkdir -p $RPM_BUILD_ROOT%{_datadir}/p11-kit/modules/
echo "module: %{soname}.so" > $RPM_BUILD_ROOT%{_datadir}/p11-kit/modules/kryoptic.module

%if %{with check}
%check
%if 0%{?rhel}
%cargo_test -f nssdb,pqc -- -- --exact --skip tests::signatures::test_rsa_signatures
%else
%cargo_test -f nssdb,pqc
%endif
%endif

%files
%license LICENSE.txt
%license LICENSE.dependencies
%doc README.md
%dir %{_libdir}/pkcs11
%{_libdir}/pkcs11/%{soname}.so
# Co-owned with p11-kit so it is not hard dependency
%dir %{_datadir}/p11-kit
%dir %{_datadir}/p11-kit/modules
%{_datadir}/p11-kit/modules/kryoptic.module


%files tools
%{_bindir}/softhsm_migrate

%changelog
%autochangelog
