import { _ as _async_to_generator } from "@swc/helpers/_/_async_to_generator";
import { _ as _ts_generator } from "@swc/helpers/_/_ts_generator";
export var random = function(bytes) {
    return _async_to_generator(function() {
        return _ts_generator(this, function(_state) {
            return [
                2,
                crypto.getRandomValues(new Uint8Array(bytes))
            ];
        });
    })();
};
export var customAlphabet = function(alphabet) {
    var defaultSize = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 21;
    var mask = (2 << Math.log(alphabet.length - 1) / Math.LN2) - 1;
    var step = -~(1.6 * mask * defaultSize / alphabet.length);
    return function() {
        var size = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : defaultSize;
        return _async_to_generator(function() {
            var id, bytes, i;
            return _ts_generator(this, function(_state) {
                id = '';
                while(true){
                    bytes = crypto.getRandomValues(new Uint8Array(step));
                    i = step;
                    while(i--){
                        id += alphabet[bytes[i] & mask] || '';
                        if (id.length === size) return [
                            2,
                            id
                        ];
                    }
                }
                return [
                    2
                ];
            });
        })();
    };
};
export var nanoid = function() {
    var size = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 21;
    return _async_to_generator(function() {
        var id, bytes, byte;
        return _ts_generator(this, function(_state) {
            id = '';
            bytes = crypto.getRandomValues(new Uint8Array(size));
            while(size--){
                byte = bytes[size] & 63;
                if (byte < 36) {
                    id += byte.toString(36);
                } else if (byte < 62) {
                    id += (byte - 26).toString(36).toUpperCase();
                } else if (byte < 63) {
                    id += '_';
                } else {
                    id += '-';
                }
            }
            return [
                2,
                id
            ];
        });
    })();
};
