/**
 * Generate secure URL-friendly unique ID. The non-blocking version.
 *
 * By default, the ID will have 21 symbols to have a collision probability
 * similar to UUID v4.
 *
 * ```js
 * import { nanoid } from 'nanoid/async'
 * nanoid().then(id => {
 *   model.id = id
 * })
 * ```
 *
 * @param size Size of the ID. The default size is 21.
 * @returns A promise with a random string.
 */ /**
 * Generate an array of random bytes collected from hardware noise.
 *
 * ```js
 * import { random } from 'nanoid/async'
 * random(5).then(bytes => {
 *   bytes //=> [10, 67, 212, 67, 89]
 * })
 * ```
 *
 * @param bytes Size of the array.
 * @returns A promise with a random bytes array.
 */ export { };
