#!/usr/bin/env node
import { nanoid, customAlphabet } from "../index.js";
function print(msg) {
    process.stdout.write(msg + '\n');
}
function error(msg) {
    process.stderr.write(msg + '\n');
    process.exit(1);
}
if (process.argv.includes('--help') || process.argv.includes('-h')) {
    print("\n  Usage\n    $ nanoid [options]\n  Options\n    -s, --size       Generated ID size\n    -a, --alphabet   Alphabet to use\n    -h, --help       Show this help\n  Examples\n    $ nanoid --s 15\n    S9sBF77U6sDB8Yg\n    $ nanoid --size 10 --alphabet abc\n    bcabababca");
    process.exit();
}
var alphabet, size;
for(var i = 2; i < process.argv.length; i++){
    var arg = process.argv[i];
    if (arg === '--size' || arg === '-s') {
        size = Number(process.argv[i + 1]);
        i += 1;
        if (Number.isNaN(size) || size <= 0) {
            error('Size must be positive integer');
        }
    } else if (arg === '--alphabet' || arg === '-a') {
        alphabet = process.argv[i + 1];
        i += 1;
    } else {
        error('Unknown argument ' + arg);
    }
}
if (alphabet) {
    var customNanoid = customAlphabet(alphabet, size);
    print(customNanoid());
} else {
    print(nanoid(size));
}
