export { urlAlphabet } from "./url-alphabet/index.js";
export var random = function(bytes) {
    return crypto.getRandomValues(new Uint8Array(bytes));
};
export var customRandom = function(alphabet, defaultSize, getRandom) {
    var mask = (2 << Math.log(alphabet.length - 1) / Math.LN2) - 1;
    var step = -~(1.6 * mask * defaultSize / alphabet.length);
    return function() {
        var size = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : defaultSize;
        var id = '';
        while(true){
            var bytes = getRandom(step);
            var j = step;
            while(j--){
                id += alphabet[bytes[j] & mask] || '';
                if (id.length === size) return id;
            }
        }
    };
};
export var customAlphabet = function(alphabet) {
    var size = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 21;
    return customRandom(alphabet, size, random);
};
export var nanoid = function() {
    var size = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 21;
    return crypto.getRandomValues(new Uint8Array(size)).reduce(function(id, byte) {
        byte &= 63;
        if (byte < 36) {
            id += byte.toString(36);
        } else if (byte < 62) {
            id += (byte - 26).toString(36).toUpperCase();
        } else if (byte > 62) {
            id += '-';
        } else {
            id += '_';
        }
        return id;
    }, '');
};
