/*
 * This software was developed at the National Institute of Standards
 * and Technology by employees of the Federal Government in the course
 * of their official duties. Pursuant to title 17 Section 105 of the
 * United States Code this software is not subject to copyright
 * protection and is in the public domain.
 * We would appreciate acknowledgement if the software is used.
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int DSA_signature = 0;
int DSA_parameter_inheritance = 0;
int nameConstraints_directoryName = 0;
int nameConstraints_rfc822Name = 0;
int nameConstraints_DNS = 0;
int nameConstraints_URI = 0;
int distributionPoints_onlySomeReasons = 0;
int distributionPoints_nameRelativeToIssuer = 0;
int indirectCRLs = 0;
int DeltaCRLs = 0;
int anyPolicyOID = 0;
int inhibitAnyPolicy = 0;
int initial_inhibit_any_policy = 0;
int policyMappings = 0;
int inhibitPolicyMapping = 0;
int initial_inhibit_policy_mapping = 0;


struct path_validation_input {
    char *trust_anchor;
    char *end_entity_certificate;
    char *end_entity_smime;
    char *end_entity_pkcs12;
    char *user_initial_policy_set;
    int   initial_policy_mapping_inhibit;
    int   initial_explicit_policy;
    int   initial_any_policy_inhibit;
};

#define	VALID		0
#define	INVALID_PATH	1
#define	REVOKED		2
#define	STATUS_UNKNOWN	3


char *get_title()
{
    static char name_string[200];

    int nameConstraints_package;
    int policyMapping_package;
    int anyPolicy_package;
    int DSA_package;
    int Bridge_Enabled_PVM;
    int Advanced_CRLs;
    int i, j;

    nameConstraints_package = (nameConstraints_directoryName && nameConstraints_rfc822Name) ? 1 : 0;

    policyMapping_package = (policyMappings && inhibitPolicyMapping && initial_inhibit_policy_mapping) ? 1 : 0;

    anyPolicy_package = (anyPolicyOID && inhibitAnyPolicy && initial_inhibit_any_policy) ? 1 : 0;

    DSA_package = (DSA_signature && DSA_parameter_inheritance) ? 1 : 0;

    Advanced_CRLs = (indirectCRLs && distributionPoints_onlySomeReasons) ? 1 : 0;

    Bridge_Enabled_PVM = (nameConstraints_package && policyMapping_package && anyPolicy_package) ? 1 : 0;

    if (Bridge_Enabled_PVM) {
	sprintf(name_string, "Bridge-Enabled PVM");

	if (Advanced_CRLs) {
	    strcat(name_string, " with Advanced CRLs");

	    i = DeltaCRLs + DSA_package;

	    if (i > 1) {
		strcat(name_string, ",");
	    }

	    if (DeltaCRLs) {
		if (i == 1)
		    strcat(name_string, " and");
		strcat(name_string, " Delta-CRLs");
		if (i > 1)
		    strcat(name_string, ",");
		i--;
	    }

	    if (DSA_package) {
		strcat(name_string, " and DSA");
	    }

	} else {
	    /* !Advanced_CRLs */

	    i = j = indirectCRLs + distributionPoints_onlySomeReasons + DeltaCRLs + DSA_package;

	    if (i > 0) {
		strcat(name_string, " with");
	    }

	    if (indirectCRLs) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Indirect CRLs");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (distributionPoints_onlySomeReasons) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Reasons");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (DeltaCRLs) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Delta-CRLs");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (DSA_package) {
		if (j == 1)
		    strcat(name_string, " DSA");
		else
		    strcat(name_string, " and DSA");
	    }
	}
    } else {
	sprintf(name_string, "Enterprise PVM");

	if (Advanced_CRLs) {
	    strcat(name_string, " with Advanced CRLs");

	    i = DeltaCRLs + nameConstraints_package + policyMapping_package + anyPolicy_package + DSA_package;
	    
	    if (i > 1) {
		strcat(name_string, ",");
	    }

	    if (nameConstraints_package) {
		if (i == 1)
		    strcat(name_string, " and");
		strcat(name_string, " Name Constraints");
		if (i > 1)
		    strcat(name_string, ",");
		i--;
	    }

	    if (policyMapping_package) {
		if (i == 1)
		    strcat(name_string, " and");
		strcat(name_string, " Policy Mapping");
		if (i > 1)
		    strcat(name_string, ",");
		i--;
	    }

	    if (anyPolicy_package) {
		if (i == 1)
		    strcat(name_string, " and");
		strcat(name_string, " anyPolicy");
		if (i > 1)
		    strcat(name_string, ",");
		i--;
	    }

	    if (DeltaCRLs) {
		if (i == 1)
		    strcat(name_string, " and");
		strcat(name_string, " Delta-CRLs");
		if (i > 1)
		    strcat(name_string, ",");
		i--;
	    }

	    if (DSA_package) {
		strcat(name_string, " and DSA");
	    }
	} else {
	    i = j = DeltaCRLs + nameConstraints_package + policyMapping_package + anyPolicy_package +
		    indirectCRLs + distributionPoints_onlySomeReasons + DSA_package;
	    
	    if (i > 0) {
		strcat(name_string, " with");
	    }

	    if (nameConstraints_package) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Name Constraints");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (policyMapping_package) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Policy Mapping");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (anyPolicy_package) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " anyPolicy");
		if (i > 1)
		    strcat(name_string, ",");
		i--;
	    }

	    if (indirectCRLs) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Indirect CRLs");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (distributionPoints_onlySomeReasons) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Reasons");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (DeltaCRLs) {
		if ((i == 1) && (j > 1))
		    strcat(name_string, " and");
		strcat(name_string, " Delta-CRLs");
		if ((i > 1) && (j > 2))
		    strcat(name_string, ",");
		i--;
	    }

	    if (DSA_package) {
		if (j == 1)
		    strcat(name_string, " DSA");
		else
		    strcat(name_string, " and DSA");
	    }
	}
    }

    return(name_string);
}


void
print_header(FILE *f)
{
    fprintf(f, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\"><title>PKITS Test Matrix</title></head><body>\n");
    fprintf(f, "<div style=\"text-align: center;\">\n");
    fprintf(f, "<h1>%s</h1>\n", get_title());
    fprintf(f, "<div style=\"text-align: left;\">In addtion to the minimum requirements\n");
    fprintf(f, "for an Enterprise Path Validation Module, these tests assume that the\n");
    fprintf(f, "PWM implements the following features:<br>\n");
    fprintf(f, "<br>\n");
    fprintf(f, "<table style=\"text-align: left; width: 100%%;\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\">\n");
    fprintf(f, "  <tbody>\n");
    fprintf(f, "    <tr>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\">DSA:<br>\n\n");

    if (DSA_signature)
	fprintf(f, "      <div style=\"margin-left: 40px;\">DSA signature verification<br>\n");
    else
	fprintf(f, "      <div style=\"margin-left: 40px;\"><span style=\"text-decoration: line-through;\">DSA signature verification</span><br>\n");

    if (DSA_parameter_inheritance)
	fprintf(f, "DSA parameter inheritance<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">DSA parameter inheritance</span><br>\n");

    fprintf(f, "      </div>\n\n");
    fprintf(f, "      <br>\n\n");
    fprintf(f, "Name Constraints:<br>\n\n");

    if (nameConstraints_directoryName)
	fprintf(f, "      <div style=\"margin-left: 40px;\">directoryName<br>\n\n");
    else
	fprintf(f, "      <div style=\"margin-left: 40px;\"><span style=\"text-decoration: line-through;\">directoryName</span><br>\n\n");

    if (nameConstraints_rfc822Name)
	fprintf(f, "rfc822Name<br>\n\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">rfc822Name</span><br>\n\n");

    if (nameConstraints_DNS)
	fprintf(f, "dNSname<br>\n\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">dNSname</span><br>\n\n");

    if (nameConstraints_URI)
	fprintf(f, "uniformResourceIdentifier<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">uniformResourceIdentifier</span><br>\n");

    fprintf(f, "      </div>\n\n");
    fprintf(f, "      <br>\n\n");
    fprintf(f, "Distribution Points:<br>\n\n");

    if (distributionPoints_onlySomeReasons)
	fprintf(f, "      <div style=\"margin-left: 40px;\">onlySomeReasons<br>\n");
    else
	fprintf(f, "      <div style=\"margin-left: 40px;\"><span style=\"text-decoration: line-through;\">onlySomeReasons</span><br>\n");

    if (distributionPoints_nameRelativeToIssuer)
	fprintf(f, "nameRelativeToIssuer<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">nameRelativeToIssuer</span><br>\n");

    if (indirectCRLs)
	fprintf(f, "indirect CRLs<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">indirect CRLs</span><br>\n");

    fprintf(f, "      </div>\n\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\">\n");

    if (DeltaCRLs)
	fprintf(f, "      <div style=\"margin-left: 40px;\">delta-CRLs<br>\n");
    else
	fprintf(f, "      <div style=\"margin-left: 40px;\"><span style=\"text-decoration: line-through;\">delta-CRLs</span><br>\n");

    fprintf(f, "      <br>\n");
    fprintf(f, "Policy Processing:<br>\n");

    if (anyPolicyOID)
	fprintf(f, "<div style=\"margin-left: 40px;\">anyPolicy OID<br>\n");
    else
	fprintf(f, "<div style=\"margin-left: 40px;\"><span style=\"text-decoration: line-through;\">anyPolicy OID</span><br>\n");

    if (inhibitAnyPolicy)
	fprintf(f, "inhibitAnyPolicy<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">inhibitAnyPolicy</span><br>\n");

    if (initial_inhibit_any_policy)
	fprintf(f, "initial-inhibit-any-policy<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">initial-inhibit-any-policy</span><br>\n");

    if (policyMappings)
	fprintf(f, "policyMappings<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">policyMappings</span><br>\n");

    if (inhibitPolicyMapping)
	fprintf(f, "inhibitPolicyMapping<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">inhibitPolicyMapping</span><br>\n");

    if (initial_inhibit_policy_mapping)
	fprintf(f, "initial-inhibit-policy-mapping<br>\n");
    else
	fprintf(f, "<span style=\"text-decoration: line-through;\">initial-inhibit-policy-mapping</span><br>\n");

    fprintf(f, "</div>\n");
    fprintf(f, "      </div>\n\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "    </tr>\n");
    fprintf(f, "  </tbody>\n");
    fprintf(f, "</table>\n");
    fprintf(f, "<br>\n");
    fprintf(f, "<br>\n");
    fprintf(f, "</div>\n");
    fprintf(f, "<br>\n\n");
    fprintf(f, "</div>\n");
    fprintf(f, "<br>\n");
    fprintf(f, "<table cellpadding=\"2\" cellspacing=\"2\" border=\"1\" style=\"text-align: left; width: 100%%;\">\n");
    fprintf(f, "  <tbody>\n");
    fprintf(f, "    <tr>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><span style=\"font-weight: bold;\">Test</span><br>\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><span style=\"font-weight: bold;\">Expected Result</span><br>\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><span style=\"font-weight: bold;\">Actual Result</span><br>\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "    </tr>\n");
}


void
print_test_entry(FILE *f, char *title, struct path_validation_input *inputs, int result,  char *expected_result)
{
    fprintf(f, "    <tr>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\">%s<br>\n", title);
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\">%s<br>\n", expected_result);
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><br>\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "    </tr>\n");
}

void
print_notest_entry(FILE *f, char *title, struct path_validation_input *inputs, int result, char *expected_result)
{
    fprintf(f, "    <tr>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><span style=\"color: rgb(153, 153, 153); font-style: italic;\">%s</span><br>\n", title);
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><span style=\"font-style: italic; color: rgb(153, 153, 153);\">%s</span><br>\n", expected_result);
    fprintf(f, "      </td>\n");
    fprintf(f, "      <td style=\"vertical-align: top;\"><span style=\"font-style: italic; color: rgb(153, 153, 153);\">This test does not need to be run</span><br>\n");
    fprintf(f, "      </td>\n");
    fprintf(f, "    </tr>\n");
}


void
print_trailer(FILE *f)
{
    fprintf(f, "  </tbody>\n");
    fprintf(f, "</table>\n");
    fprintf(f, "<br>\n");
    fprintf(f, "</body></html>\n");
}


void
generate_HTML(char *file_name)
{
    FILE *f;
    struct path_validation_input default_inputs;
    struct path_validation_input P1_inputs;
    struct path_validation_input P2_inputs;
    struct path_validation_input P3_inputs;
    struct path_validation_input P6_inputs;
    struct path_validation_input PanyPolicy_iep_inputs;
    struct path_validation_input P1_iep_inputs;
    struct path_validation_input P2_iep_inputs;
    struct path_validation_input P12_iep_inputs;
    struct path_validation_input PanyPolicy_ipmi_inputs;
    struct path_validation_input PanyPolicy_iiap_inputs;


    f = fopen(file_name, "w");

    if (f == NULL) return;

    print_header(f);

    /* default inputs */
    default_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    default_inputs.user_initial_policy_set = NULL;
    default_inputs.initial_policy_mapping_inhibit = 0;
    default_inputs.initial_explicit_policy = 0;
    default_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with user-initial-policy-set = {NIST-test-policy-1} */
    P1_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P1_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.1";
    P1_inputs.initial_policy_mapping_inhibit = 0;
    P1_inputs.initial_explicit_policy = 0;
    P1_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with user-initial-policy-set = {NIST-test-policy-2} */
    P2_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P2_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.2";
    P2_inputs.initial_policy_mapping_inhibit = 0;
    P2_inputs.initial_explicit_policy = 0;
    P2_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with user-initial-policy-set = {NIST-test-policy-3} */
    P3_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P3_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.3";
    P3_inputs.initial_policy_mapping_inhibit = 0;
    P3_inputs.initial_explicit_policy = 0;
    P3_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with user-initial-policy-set = {NIST-test-policy-6} */
    P6_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P6_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.6";
    P6_inputs.initial_policy_mapping_inhibit = 0;
    P6_inputs.initial_explicit_policy = 0;
    P6_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with initial-explicit-policy set */
    PanyPolicy_iep_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    PanyPolicy_iep_inputs.user_initial_policy_set = NULL;
    PanyPolicy_iep_inputs.initial_policy_mapping_inhibit = 0;
    PanyPolicy_iep_inputs.initial_explicit_policy = 1;
    PanyPolicy_iep_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with initial-explicit-policy set and user-initial-policy-set = {NIST-test-policy-1} */
    P1_iep_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P1_iep_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.1";
    P1_iep_inputs.initial_policy_mapping_inhibit = 0;
    P1_iep_inputs.initial_explicit_policy = 1;
    P1_iep_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with initial-explicit-policy set and user-initial-policy-set = {NIST-test-policy-2} */
    P2_iep_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P2_iep_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.2";
    P2_iep_inputs.initial_policy_mapping_inhibit = 0;
    P2_iep_inputs.initial_explicit_policy = 1;
    P2_iep_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with initial-explicit-policy set and user-initial-policy-set = {NIST-test-policy-1, NIST-test-policy-2} */
    P12_iep_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    P12_iep_inputs.user_initial_policy_set = "2.16.840.1.101.3.2.1.48.1, 2.16.840.1.101.3.2.1.48.2";
    P12_iep_inputs.initial_policy_mapping_inhibit = 0;
    P12_iep_inputs.initial_explicit_policy = 1;
    P12_iep_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with initial-policy-mapping-inhibit set */
    PanyPolicy_ipmi_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    PanyPolicy_ipmi_inputs.user_initial_policy_set = NULL;
    PanyPolicy_ipmi_inputs.initial_policy_mapping_inhibit = 1;
    PanyPolicy_ipmi_inputs.initial_explicit_policy = 0;
    PanyPolicy_ipmi_inputs.initial_any_policy_inhibit = 0;

    /* default inputs, but with initial-inhibit-any-policy set */
    PanyPolicy_iiap_inputs.trust_anchor = "TrustAnchorRootCertificate.crt";
    PanyPolicy_iiap_inputs.user_initial_policy_set = NULL;
    PanyPolicy_iiap_inputs.initial_policy_mapping_inhibit = 0;
    PanyPolicy_iiap_inputs.initial_explicit_policy = 0;
    PanyPolicy_iiap_inputs.initial_any_policy_inhibit = 1;



    /* 4.1.1 Valid Signatures Test1 */
    default_inputs.end_entity_certificate = "ValidCertificatePathTest1EE.crt";
    default_inputs.end_entity_smime = "SignedValidSignaturesTest1.eml";
    default_inputs.end_entity_pkcs12 = "ValidCertificatePathTest1EE.p12";

    print_test_entry(f, "4.1.1 Valid Signatures Test1", &default_inputs, VALID, "Validate Successfully");

    /* 4.1.2 Invalid CA Signature Test2 */
    default_inputs.end_entity_certificate = "InvalidCASignatureTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidCASignatureTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidCASignatureTest2EE.p12";

    print_test_entry(f, "4.1.2 Invalid CA Signature Test2", &default_inputs, INVALID_PATH, "Reject - Invalid signature on intermediate certificate");

    /* 4.1.3 Invalid EE Signature Test3 */
    default_inputs.end_entity_certificate = "InvalidEESignatureTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidEESignatureTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvalidEESignatureTest3EE.p12";

    print_test_entry(f, "4.1.3 Invalid EE Signature Test3", &default_inputs, INVALID_PATH, "Reject - Invalid signature on end entity certificate");

    /* 4.1.4 Valid DSA Signatures Test4 */
    default_inputs.end_entity_certificate = "ValidDSASignaturesTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidDSASignaturesTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidDSASignaturesTest4EE.p12";

    if (DSA_signature)
	print_test_entry(f, "4.1.4 Valid DSA Signatures Test4", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.1.4 Valid DSA Signatures Test4", &default_inputs, INVALID_PATH, "Reject - Application can not process DSA signatures");

    /* 4.1.5 Valid DSA Parameter Inheritance Test5 */
    default_inputs.end_entity_certificate = "ValidDSAParameterInheritanceTest5EE.crt";
    default_inputs.end_entity_smime = "SignedValidDSAParameterInheritanceTest5.eml";
    default_inputs.end_entity_pkcs12 = "ValidDSAParameterInheritanceTest5EE.p12";

    if (DSA_signature && DSA_parameter_inheritance)
	print_test_entry(f, "4.1.5 Valid DSA Parameter Inheritance Test5", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.1.5 Valid DSA Parameter Inheritance Test5", &default_inputs, INVALID_PATH, "Reject");

    /* 4.1.6 Invalid DSA Signature Test6 */
    default_inputs.end_entity_certificate = "InvalidDSASignatureTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDSASignatureTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDSASignatureTest6EE.p12";

    if (DSA_signature)
	print_test_entry(f, "4.1.6 Invalid DSA Signature Test6", &default_inputs, INVALID_PATH, "Reject - Invalid signature on end entity certificate");
    else
	print_notest_entry(f, "4.1.6 Invalid DSA Signature Test6", &default_inputs, INVALID_PATH, "Reject - Invalid signature on end entity certificate");

    /* 4.2.1 Invalid CA notBefore Date Test1 */
    default_inputs.end_entity_certificate = "InvalidCAnotBeforeDateTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidCAnotBeforeDateTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidCAnotBeforeDateTest1EE.p12";

    print_test_entry(f, "4.2.1 Invalid CA notBefore Date Test1", &default_inputs, INVALID_PATH, "Reject - notBefore date in intermediate certificate is after the current date");

    /* 4.2.2 Invalid EE notBefore Date Test2 */
    default_inputs.end_entity_certificate = "InvalidEEnotBeforeDateTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidEEnotBeforeDateTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidEEnotBeforeDateTest2EE.p12";

    print_test_entry(f, "4.2.2 Invalid EE notBefore Date Test2", &default_inputs, INVALID_PATH, "Reject - notBefore date in end entity certificate is after the current date");

    /* 4.2.3 Valid pre2000 UTC notBefore Date Test3 */
    default_inputs.end_entity_certificate = "Validpre2000UTCnotBeforeDateTest3EE.crt";
    default_inputs.end_entity_smime = "SignedValidpre2000UTCnotBeforeDateTest3.eml";
    default_inputs.end_entity_pkcs12 = "Validpre2000UTCnotBeforeDateTest3EE.p12";

    print_test_entry(f, "4.2.3 Valid pre2000 UTC notBefore Date Test3", &default_inputs, VALID, "Validate Successfully");

    /* 4.2.4 Valid GeneralizedTime notBefore Date Test4 */
    default_inputs.end_entity_certificate = "ValidGeneralizedTimenotBeforeDateTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidGeneralizedTimenotBeforeDateTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidGeneralizedTimenotBeforeDateTest4EE.p12";

    print_test_entry(f, "4.2.4 Valid GeneralizedTime notBefore Date Test4", &default_inputs, VALID, "Validate Successfully");

    /* 4.2.5 Invalid CA notAfter Date Test5 */
    default_inputs.end_entity_certificate = "InvalidCAnotAfterDateTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidCAnotAfterDateTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidCAnotAfterDateTest5EE.p12";

    print_test_entry(f, "4.2.5 Invalid CA notAfter Date Test5", &default_inputs, INVALID_PATH, "Reject - notAfter date in intermediate certificate is before the current date");

    /* 4.2.6 Invalid EE notAfter Date Test6 */
    default_inputs.end_entity_certificate = "InvalidEEnotAfterDateTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidEEnotAfterDateTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvalidEEnotAfterDateTest6EE.p12";

    print_test_entry(f, "4.2.6 Invalid EE notAfter Date Test6", &default_inputs, INVALID_PATH, "Reject - notAfter date in end entity certificate is before the current date");

    /* 4.2.7 Invalid pre2000 UTC EE notAfter Date Test7 */
    default_inputs.end_entity_certificate = "Invalidpre2000UTCEEnotAfterDateTest7EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpre2000UTCEEnotAfterDateTest7.eml";
    default_inputs.end_entity_pkcs12 = "Invalidpre2000UTCEEnotAfterDateTest7EE.p12";

    print_test_entry(f, "4.2.7 Invalid pre2000 UTC EE notAfter Date Test7", &default_inputs, INVALID_PATH, "Reject - notAfter date in end entity certificate is before the current date");

    /* 4.2.8 Valid GeneralizedTime notAfter Date Test8 */
    default_inputs.end_entity_certificate = "ValidGeneralizedTimenotAfterDateTest8EE.crt";
    default_inputs.end_entity_smime = "SignedValidGeneralizedTimenotAfterDateTest8.eml";
    default_inputs.end_entity_pkcs12 = "ValidGeneralizedTimenotAfterDateTest8EE.p12";

    print_test_entry(f, "4.2.8 Valid GeneralizedTime notAfter Date Test8", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.1 Invalid Name Chaining EE Test1 */
    default_inputs.end_entity_certificate = "InvalidNameChainingTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidNameChainingEETest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidNameChainingTest1EE.p12";

    print_test_entry(f, "4.3.1 Invalid Name Chaining EE Test1", &default_inputs, INVALID_PATH, "Reject - names do not chain");

    /* 4.3.2 Invalid Name Chaining Order Test2 */
    default_inputs.end_entity_certificate = "InvalidNameChainingOrderTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidNameChainingOrderTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidNameChainingOrderTest2EE.p12";

    print_test_entry(f, "4.3.2 Invalid Name Chaining Order Test2", &default_inputs, INVALID_PATH, "Reject - names do not chain");

    /* 4.3.3 Valid Name Chaining Whitespace Test3 */
    default_inputs.end_entity_certificate = "ValidNameChainingWhitespaceTest3EE.crt";
    default_inputs.end_entity_smime = "SignedValidNameChainingWhitespaceTest3.eml";
    default_inputs.end_entity_pkcs12 = "ValidNameChainingWhitespaceTest3EE.p12";

    print_test_entry(f, "4.3.3 Valid Name Chaining Whitespace Test3", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.4 Valid Name Chaining Whitespace Test4 */
    default_inputs.end_entity_certificate = "ValidNameChainingWhitespaceTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidNameChainingWhitespaceTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidNameChainingWhitespaceTest4EE.p12";

    print_test_entry(f, "4.3.4 Valid Name Chaining Whitespace Test4", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.5 Valid Name Chaining Capitalization Test5 */
    default_inputs.end_entity_certificate = "ValidNameChainingCapitalizationTest5EE.crt";
    default_inputs.end_entity_smime = "SignedValidNameChainingCapitalizationTest5.eml";
    default_inputs.end_entity_pkcs12 = "ValidNameChainingCapitalizationTest5EE.p12";

    print_test_entry(f, "4.3.5 Valid Name Chaining Capitalization Test5", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.6 Valid Name Chaining UIDs Test6 */
    default_inputs.end_entity_certificate = "ValidNameUIDsTest6EE.crt";
    default_inputs.end_entity_smime = "SignedValidNameChainingUIDsTest6.eml";
    default_inputs.end_entity_pkcs12 = "ValidNameUIDsTest6EE.p12";

    print_test_entry(f, "4.3.6 Valid Name Chaining UIDs Test6", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.7 Valid RFC3280 Mandatory Attribute Types Test7 */
    default_inputs.end_entity_certificate = "ValidRFC3280MandatoryAttributeTypesTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValidRFC3280MandatoryAttributeTypesTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValidRFC3280MandatoryAttributeTypesTest7EE.p12";

    print_notest_entry(f, "4.3.7 Valid RFC3280 Mandatory Attribute Types Test7", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.8 Valid RFC3280 Optional Attribute Types Test8 */
    default_inputs.end_entity_certificate = "ValidRFC3280OptionalAttributeTypesTest8EE.crt";
    default_inputs.end_entity_smime = "SignedValidRFC3280OptionalAttributeTypesTest8.eml";
    default_inputs.end_entity_pkcs12 = "ValidRFC3280OptionalAttributeTypesTest8EE.p12";

    print_notest_entry(f, "4.3.8 Valid RFC3280 Optional Attribute Types Test8", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.9 Valid UTF8String Encoded Names Test9 */
    default_inputs.end_entity_certificate = "ValidUTF8StringEncodedNamesTest9EE.crt";
    default_inputs.end_entity_smime = "SignedValidUTF8StringEncodedNamesTest9.eml";
    default_inputs.end_entity_pkcs12 = "ValidUTF8StringEncodedNamesTest9EE.p12";

    print_test_entry(f, "4.3.9 Valid UTF8String Encoded Names Test9", &default_inputs, VALID, "Validate Successfully");

    /* 4.3.10 Valid Rollover from PrintableString to UTF8String Test10 */
    default_inputs.end_entity_certificate = "ValidRolloverfromPrintableStringtoUTF8StringTest10EE.crt";
    default_inputs.end_entity_smime = "SignedValidRolloverfromPrintableStringtoUTF8StringTest10.eml";
    default_inputs.end_entity_pkcs12 = "ValidRolloverfromPrintableStringtoUTF8StringTest10EE.p12";

    print_notest_entry(f, "4.3.10 Valid Rollover from PrintableString to UTF8String Test10", &default_inputs, VALID, "The certification path is valid. However, a PVM that implements the minimum name comparison rules in RFC 3280 will reject the certification path since it will not recognize that names chain correctly");

    /* 4.3.11 Valid UTF8String Case Insensitive Match Test11 */
    default_inputs.end_entity_certificate = "ValidUTF8StringCaseInsensitiveMatchTest11EE.crt";
    default_inputs.end_entity_smime = "SignedValidUTF8StringCaseInsensitiveMatchTest11.eml";
    default_inputs.end_entity_pkcs12 = "ValidUTF8StringCaseInsensitiveMatchTest11EE.p12";

    print_notest_entry(f, "4.3.11 Valid UTF8String Case Insensitive Match Test11", &default_inputs, VALID, "The certification path is valid. However, a PVM that implements the minimum name comparison rules in RFC 3280 will reject the certification path since it will not recognize that names chain correctly");

    /* 4.4.1 Missing CRL Test1 */
    default_inputs.end_entity_certificate = "InvalidMissingCRLTest1EE.crt";
    default_inputs.end_entity_smime = "SignedMissingCRLTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidMissingCRLTest1EE.p12";

    print_test_entry(f, "4.4.1 Missing CRL Test1", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.2 Invalid Revoked CA Test2 */
    default_inputs.end_entity_certificate = "InvalidRevokedCATest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRevokedCATest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidRevokedCATest2EE.p12";

    print_test_entry(f, "4.4.2 Invalid Revoked CA Test2", &default_inputs, REVOKED, "Reject - an intermediate certificate has been revoked.");

    /* 4.4.3 Invalid Revoked EE Test3 */
    default_inputs.end_entity_certificate = "InvalidRevokedEETest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRevokedEETest3.eml";
    default_inputs.end_entity_pkcs12 = "InvalidRevokedEETest3EE.p12";

    print_test_entry(f, "4.4.3 Invalid Revoked EE Test3", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.4.4. Invalid Bad CRL Signature Test4 */
    default_inputs.end_entity_certificate = "InvalidBadCRLSignatureTest4EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidBadCRLSignatureTest4.eml";
    default_inputs.end_entity_pkcs12 = "InvalidBadCRLSignatureTest4EE.p12";

    print_test_entry(f, "4.4.4. Invalid Bad CRL Signature Test4", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.5 Invalid Bad CRL Issuer Name Test5 */
    default_inputs.end_entity_certificate = "InvalidBadCRLIssuerNameTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidBadCRLIssuerNameTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidBadCRLIssuerNameTest5EE.p12";

    print_test_entry(f, "4.4.5 Invalid Bad CRL Issuer Name Test5", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.6 Invalid Wrong CRL Test6 */
    default_inputs.end_entity_certificate = "InvalidWrongCRLTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidWrongCRLTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvalidWrongCRLTest6EE.p12";

    print_test_entry(f, "4.4.6 Invalid Wrong CRL Test6", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.7 Valid Two CRLs Test7 */
    default_inputs.end_entity_certificate = "ValidTwoCRLsTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValidTwoCRLsTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValidTwoCRLsTest7EE.p12";

    print_test_entry(f, "4.4.7 Valid Two CRLs Test7", &default_inputs, VALID, "Validate Successfully");

    /* 4.4.8 Invalid Unknown CRL Entry Extension Test8 */
    default_inputs.end_entity_certificate = "InvalidUnknownCRLEntryExtensionTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidUnknownCRLEntryExtensionTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidUnknownCRLEntryExtensionTest8EE.p12";

    print_test_entry(f, "4.4.8 Invalid Unknown CRL Entry Extension Test8", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.4.9 Invalid Unknown CRL Extension Test9 */
    default_inputs.end_entity_certificate = "InvalidUnknownCRLExtensionTest9EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidUnknownCRLExtensionTest9.eml";
    default_inputs.end_entity_pkcs12 = "InvalidUnknownCRLExtensionTest9EE.p12";

    print_test_entry(f, "4.4.9 Invalid Unknown CRL Extension Test9", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.4.10 Invalid Unknown CRL Extension Test10 */
    default_inputs.end_entity_certificate = "InvalidUnknownCRLExtensionTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidUnknownCRLExtensionTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvalidUnknownCRLExtensionTest10EE.p12";

    print_test_entry(f, "4.4.10 Invalid Unknown CRL Extension Test10", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.11 Invalid Old CRL nextUpdate Test11 */
    default_inputs.end_entity_certificate = "InvalidOldCRLnextUpdateTest11EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidOldCRLnextUpdateTest11.eml";
    default_inputs.end_entity_pkcs12 = "InvalidOldCRLnextUpdateTest11EE.p12";

    print_test_entry(f, "4.4.11 Invalid Old CRL nextUpdate Test11", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.12 Invalid pre2000 CRL nextUpdate Tesst12 */
    default_inputs.end_entity_certificate = "Invalidpre2000CRLnextUpdateTest12EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpre2000CRLnextUpdateTest12.eml";
    default_inputs.end_entity_pkcs12 = "Invalidpre2000CRLnextUpdateTest12EE.p12";

    print_test_entry(f, "4.4.12 Invalid pre2000 CRL nextUpdate Tesst12", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.4.13 Valid GeneralizedTime CRL nextUpdate Test13 */
    default_inputs.end_entity_certificate = "ValidGeneralizedTimeCRLnextUpdateTest13EE.crt";
    default_inputs.end_entity_smime = "SignedValidGeneralizedTimeCRLnextUpdateTest13.eml";
    default_inputs.end_entity_pkcs12 = "ValidGeneralizedTimeCRLnextUpdateTest13EE.p12";

    print_test_entry(f, "4.4.13 Valid GeneralizedTime CRL nextUpdate Test13", &default_inputs, VALID, "Validate Successfully");

    /* 4.4.14 Valid Negative Serial Number Test14 */
    default_inputs.end_entity_certificate = "ValidNegativeSerialNumberTest14EE.crt";
    default_inputs.end_entity_smime = "SignedValidNegativeSerialNumberTest14.eml";
    default_inputs.end_entity_pkcs12 = "ValidNegativeSerialNumberTest14EE.p12";

    print_test_entry(f, "4.4.14 Valid Negative Serial Number Test14", &default_inputs, VALID, "Validate Successfully");

    /* 4.4.15 Invalid Negative Serial Number Test15 */
    default_inputs.end_entity_certificate = "InvalidNegativeSerialNumberTest15EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidNegativeSerialNumberTest15.eml";
    default_inputs.end_entity_pkcs12 = "InvalidNegativeSerialNumberTest15EE.p12";

    print_test_entry(f, "4.4.15 Invalid Negative Serial Number Test15", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.4.16 Valid Long Serial Number Test16 */
    default_inputs.end_entity_certificate = "ValidLongSerialNumberTest16EE.crt";
    default_inputs.end_entity_smime = "SignedValidLongSerialNumberTest16.eml";
    default_inputs.end_entity_pkcs12 = "ValidLongSerialNumberTest16EE.p12";

    print_test_entry(f, "4.4.16 Valid Long Serial Number Test16", &default_inputs, VALID, "Validate Successfully");

    /* 4.4.17 Valid Long Serial Number Test17 */
    default_inputs.end_entity_certificate = "ValidLongSerialNumberTest17EE.crt";
    default_inputs.end_entity_smime = "SignedValidLongSerialNumberTest17.eml";
    default_inputs.end_entity_pkcs12 = "ValidLongSerialNumberTest17EE.p12";

    print_test_entry(f, "4.4.17 Valid Long Serial Number Test17", &default_inputs, VALID, "Validate Successfully");

    /* 4.4.18 Invalid Long Serial Number Test18 */
    default_inputs.end_entity_certificate = "InvalidLongSerialNumberTest18EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidLongSerialNumberTest18.eml";
    default_inputs.end_entity_pkcs12 = "InvalidLongSerialNumberTest18EE.p12";

    print_test_entry(f, "4.4.18 Invalid Long Serial Number Test18", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.4.19 Valid Separate Certificate and CRL Keys Test19 */
    default_inputs.end_entity_certificate = "ValidSeparateCertificateandCRLKeysTest19EE.crt";
    default_inputs.end_entity_smime = "SignedValidSeparateCertificateandCRLKeysTest19.eml";
    default_inputs.end_entity_pkcs12 = "ValidSeparateCertificateandCRLKeysTest19EE.p12";

    print_test_entry(f, "4.4.19 Valid Separate Certificate and CRL Keys Test19", &default_inputs, VALID, "Validate Successfully");

    /* 4.4.20 Invalid Separate Certificate and CRL Keys Test20 */
    default_inputs.end_entity_certificate = "InvalidSeparateCertificateandCRLKeysTest20EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSeparateCertificateandCRLKeysTest20.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSeparateCertificateandCRLKeysTest20EE.p12";

    print_test_entry(f, "4.4.20 Invalid Separate Certificate and CRL Keys Test20", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.4.21 Invalid Separate Certificate and CRL Keys Test21 */
    default_inputs.end_entity_certificate = "InvalidSeparateCertificateandCRLKeysTest21EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSeparateCertificateandCRLKeysTest21.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSeparateCertificateandCRLKeysTest21EE.p12";

    print_test_entry(f, "4.4.21 Invalid Separate Certificate and CRL Keys Test21", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.5.1 Valid Basic Self-Issued Old With New Test1 */
    default_inputs.end_entity_certificate = "ValidBasicSelfIssuedOldWithNewTest1EE.crt";
    default_inputs.end_entity_smime = "SignedValidBasicSelfIssuedOldWithNewTest1.eml";
    default_inputs.end_entity_pkcs12 = "ValidBasicSelfIssuedOldWithNewTest1EE.p12";

    print_test_entry(f, "4.5.1 Valid Basic Self-Issued Old With New Test1", &default_inputs, VALID, "Validate Successfully");

    /* 4.5.2 Invalid Basic Self-Issued Old With New Test2 */
    default_inputs.end_entity_certificate = "InvalidBasicSelfIssuedOldWithNewTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidBasicSelfIssuedOldWithNewTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidBasicSelfIssuedOldWithNewTest2EE.p12";

    print_test_entry(f, "4.5.2 Invalid Basic Self-Issued Old With New Test2", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.5.3 Valid Basic Self-Issued New With Old Test3 */
    default_inputs.end_entity_certificate = "ValidBasicSelfIssuedNewWithOldTest3EE.crt";
    default_inputs.end_entity_smime = "SignedValidBasicSelfIssuedNewWithOldTest3.eml";
    default_inputs.end_entity_pkcs12 = "ValidBasicSelfIssuedNewWithOldTest3EE.p12";

    print_test_entry(f, "4.5.3 Valid Basic Self-Issued New With Old Test3", &default_inputs, VALID, "Validate Successfully");

    /* 4.5.4 Valid Basic Self-Issued New With Old Test4 */
    default_inputs.end_entity_certificate = "ValidBasicSelfIssuedNewWithOldTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidBasicSelfIssuedNewWithOldTest4.em";
    default_inputs.end_entity_pkcs12 = "ValidBasicSelfIssuedNewWithOldTest4EE.p12";

    print_test_entry(f, "4.5.4 Valid Basic Self-Issued New With Old Test4", &default_inputs, VALID, "Validate Successfully");

    /* 4.5.5 Invalid Basic Self-Issued New With Old Test5 */
    default_inputs.end_entity_certificate = "InvalidBasicSelfIssuedNewWithOldTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidBasicSelfIssuedNewWithOldTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidBasicSelfIssuedNewWithOldTest5EE.p12";

    print_test_entry(f, "4.5.5 Invalid Basic Self-Issued New With Old Test5", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.5.6 Valid Basic Self-Issued CRL Signing Key Test6 */
    default_inputs.end_entity_certificate = "ValidBasicSelfIssuedCRLSigningKeyTest6EE.crt";
    default_inputs.end_entity_smime = "SignedValidBasicSelfIssuedCRLSigningKeyTest6.eml";
    default_inputs.end_entity_pkcs12 = "ValidBasicSelfIssuedCRLSigningKeyTest6EE.p12";

    print_test_entry(f, "4.5.6 Valid Basic Self-Issued CRL Signing Key Test6", &default_inputs, VALID, "Validate Successfully");

    /* 4.5.7 Invalid Basic Self-Issued CRL Signing Key Test7 */
    default_inputs.end_entity_certificate = "InvalidBasicSelfIssuedCRLSigningKeyTest7EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidBasicSelfIssuedCRLSigningKeyTest7.eml";
    default_inputs.end_entity_pkcs12 = "InvalidBasicSelfIssuedCRLSigningKeyTest7EE.p12";

    print_test_entry(f, "4.5.7 Invalid Basic Self-Issued CRL Signing Key Test7", &default_inputs, REVOKED, "Reject - the end entity certificate has been revoked");

    /* 4.5.8 Invalid Basic Self-Issued CRL Signing Key Test8 */
    default_inputs.end_entity_certificate = "InvalidBasicSelfIssuedCRLSigningKeyTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidBasicSelfIssuedCRLSigningKeyTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidBasicSelfIssuedCRLSigningKeyTest8EE.p12";

    print_test_entry(f, "4.5.8 Invalid Basic Self-Issued CRL Signing Key Test8", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.1 Invalid Missing basicConstraints Test1 */
    default_inputs.end_entity_certificate = "InvalidMissingbasicConstraintsTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidMissingbasicConstraintsTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidMissingbasicConstraintsTest1EE.p12";

    print_test_entry(f, "4.6.1 Invalid Missing basicConstraints Test1", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.2 Invalid cA False Test2 */
    default_inputs.end_entity_certificate = "InvalidcAFalseTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcAFalseTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcAFalseTest2EE.p12";

    print_test_entry(f, "4.6.2 Invalid cA False Test2", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.3 Invalid cA False Test3 */
    default_inputs.end_entity_certificate = "InvalidcAFalseTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcAFalseTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcAFalseTest3EE.p12";

    print_test_entry(f, "4.6.3 Invalid cA False Test3", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.4 Valid basicConstraints Not Critical Test4 */
    default_inputs.end_entity_certificate = "ValidbasicConstraintsNotCriticalTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidbasicConstraintsNotCriticalTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidbasicConstraintsNotCriticalTest4EE.p12";

    print_test_entry(f, "4.6.4 Valid basicConstraints Not Critical Test4", &default_inputs, VALID, "Validate Successfully");

    /* 4.6.5 Invalid pathLenConstraint Test5 */
    default_inputs.end_entity_certificate = "InvalidpathLenConstraintTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpathLenConstraintTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidpathLenConstraintTest5EE.p12";

    print_test_entry(f, "4.6.5 Invalid pathLenConstraint Test5", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.6 Invalid pathLenConstraint Test6 */
    default_inputs.end_entity_certificate = "InvalidpathLenConstraintTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpathLenConstraintTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvalidpathLenConstraintTest6EE.p12";

    print_test_entry(f, "4.6.6 Invalid pathLenConstraint Test6", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.7 Valid pathLenConstraint Test7 */
    default_inputs.end_entity_certificate = "ValidpathLenConstraintTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValidpathLenConstraintTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValidpathLenConstraintTest7EE.p12";

    print_test_entry(f, "4.6.7 Valid pathLenConstraint Test7", &default_inputs, VALID, "Validate Successfully");

    /* 4.6.8 Valid pathLenConstraint Test8 */
    default_inputs.end_entity_certificate = "ValidpathLenConstraintTest8EE.crt";
    default_inputs.end_entity_smime = "SignedValidpathLenConstraintTest8.eml";
    default_inputs.end_entity_pkcs12 = "ValidpathLenConstraintTest8EE.p12";

    print_test_entry(f, "4.6.8 Valid pathLenConstraint Test8", &default_inputs, VALID, "Validate Successfully");

    /* 4.6.9 Invalid pathLenConstraint Test9 */
    default_inputs.end_entity_certificate = "InvalidpathLenConstraintTest9EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpathLenConstraintTest9.eml";
    default_inputs.end_entity_pkcs12 = "InvalidpathLenConstraintTest9EE.p12";

    print_test_entry(f, "4.6.9 Invalid pathLenConstraint Test9", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.10 Invalid pathLenConstraint Test10 */
    default_inputs.end_entity_certificate = "InvalidpathLenConstraintTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpathLenConstraintTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvalidpathLenConstraintTest10EE.p12";

    print_test_entry(f, "4.6.10 Invalid pathLenConstraint Test10", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.11 Invalid pathLenConstraint Test11 */
    default_inputs.end_entity_certificate = "InvalidpathLenConstraintTest11EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpathLenConstraintTest11.eml";
    default_inputs.end_entity_pkcs12 = "InvalidpathLenConstraintTest11EE.p12";

    print_test_entry(f, "4.6.11 Invalid pathLenConstraint Test11", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.12 Invalid pathLenConstraint Test12 */
    default_inputs.end_entity_certificate = "InvalidpathLenConstraintTest12EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidpathLenConstraintTest12.eml";
    default_inputs.end_entity_pkcs12 = "InvalidpathLenConstraintTest12EE.p12";

    print_test_entry(f, "4.6.12 Invalid pathLenConstraint Test12", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.13 Valid pathLenConstraint Test13 */
    default_inputs.end_entity_certificate = "ValidpathLenConstraintTest13EE.crt";
    default_inputs.end_entity_smime = "SignedValidpathLenConstraintTest13.eml";
    default_inputs.end_entity_pkcs12 = "ValidpathLenConstraintTest13EE.p12";

    print_test_entry(f, "4.6.13 Valid pathLenConstraint Test13", &default_inputs, VALID, "Validate Successfully");

    /* 4.6.14 Valid pathLenConstraint Test14 */
    default_inputs.end_entity_certificate = "ValidpathLenConstraintTest14EE.crt";
    default_inputs.end_entity_smime = "SignedValidpathLenConstraintTest14.eml";
    default_inputs.end_entity_pkcs12 = "ValidpathLenConstraintTest14EE.p12";

    print_test_entry(f, "4.6.14 Valid pathLenConstraint Test14", &default_inputs, VALID, "Validate Successfully");

    /* 4.6.15 Valid Self-Issued pathLenConstraint Test15 */
    default_inputs.end_entity_certificate = "ValidSelfIssuedpathLenConstraintTest15EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedpathLenConstraintTest15.eml";
    default_inputs.end_entity_pkcs12 = "ValidSelfIssuedpathLenConstraintTest15EE.p12";

    print_test_entry(f, "4.6.15 Valid Self-Issued pathLenConstraint Test15", &default_inputs, VALID, "Validate Successfully");

    /* 4.6.16 Invalid Self-Issued pathLenConstraint Test16 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedpathLenConstraintTest16EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedpathLenConstraintTest16.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedpathLenConstraintTest16EE.p12";

    print_test_entry(f, "4.6.16 Invalid Self-Issued pathLenConstraint Test16", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.6.17 Valid Self-Issued pathLenConstraint Test17 */
    default_inputs.end_entity_certificate = "ValidSelfIssuedpathLenConstraintTest17EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedpathLenConstraintTest17.eml";
    default_inputs.end_entity_pkcs12 = "ValidSelfIssuedpathLenConstraintTest17EE.p12";

    print_test_entry(f, "4.6.17 Valid Self-Issued pathLenConstraint Test17", &default_inputs, VALID, "Validate Successfully");

    /* 4.7.1 Invalid keyUsage Critical keyCertSign False Test1 */
    default_inputs.end_entity_certificate = "InvalidkeyUsageCriticalkeyCertSignFalseTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidkeyUsageCriticalkeyCertSignFalseTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidkeyUsageCriticalkeyCertSignFalseTest1EE.p12";

    print_test_entry(f, "4.7.1 Invalid keyUsage Critical keyCertSign False Test1", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.7.2 Invalid keyUsage Not Critical keyCertSign False Test2 */
    default_inputs.end_entity_certificate = "InvalidkeyUsageNotCriticalkeyCertSignFalseTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidkeyUsageNotCriticalkeyCertSignFalseTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidkeyUsageNotCriticalkeyCertSignFalseTest2EE.p12";

    print_test_entry(f, "4.7.2 Invalid keyUsage Not Critical keyCertSign False Test2", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.7.3 Valid keyUsage Not Critical Test3 */
    default_inputs.end_entity_certificate = "ValidkeyUsageNotCriticalTest3EE.crt";
    default_inputs.end_entity_smime = "SignedValidkeyUsageNotCriticalTest3.eml";
    default_inputs.end_entity_pkcs12 = "ValidkeyUsageNotCriticalTest3EE.p12";

    print_test_entry(f, "4.7.3 Valid keyUsage Not Critical Test3", &default_inputs, VALID, "Validate Successfully");

    /* 4.7.4 Invalid keyUsage Critical cRLSign False Test4 */
    default_inputs.end_entity_certificate = "InvalidkeyUsageCriticalcRLSignFalseTest4EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidkeyUsageCriticalcRLSignFalseTest4.eml";
    default_inputs.end_entity_pkcs12 = "InvalidkeyUsageCriticalcRLSignFalseTest4EE.p12";

    print_test_entry(f, "4.7.4 Invalid keyUsage Critical cRLSign False Test4", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.7.5 Invalid keyUsage Not Critical cRLSign False Test5 */
    default_inputs.end_entity_certificate = "InvalidkeyUsageNotCriticalcRLSignFalseTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidkeyUsageNotCriticalcRLSignFalseTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidkeyUsageNotCriticalcRLSignFalseTest5EE.p12";

    print_test_entry(f, "4.7.5 Invalid keyUsage Not Critical cRLSign False Test5", &default_inputs, INVALID_PATH, "Reject - invalid certification path");

    /* 4.8.1 All Certificates Same Policy Test1, subtest 1 */
    PanyPolicy_iep_inputs.end_entity_certificate = "ValidCertificatePathTest1EE.crt";
    PanyPolicy_iep_inputs.end_entity_smime = "SignedAllCertificatesSamePolicyTest1.eml";
    PanyPolicy_iep_inputs.end_entity_pkcs12 = "ValidCertificatePathTest1EE.p12";

    print_test_entry(f, "4.8.1 All Certificates Same Policy Test1, subtest 1", &default_inputs, VALID, "Validate Successfully [Run if application can be configured as specified (i.e., if <i>initial-policy-set</i> can be <i>any-policy</i> when <i>initial-explicit-policy</i> is set). Otherwise indicate that test could not be run.]");

    /* 4.8.1 All Certificates Same Policy Test1, subtest 2 */
    P1_iep_inputs.end_entity_certificate = "ValidCertificatePathTest1EE.crt";
    P1_iep_inputs.end_entity_smime = "SignedAllCertificatesSamePolicyTest1.eml";
    P1_iep_inputs.end_entity_pkcs12 = "ValidCertificatePathTest1EE.p12";

    print_test_entry(f, "4.8.1 All Certificates Same Policy Test1, subtest 2", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.1 All Certificates Same Policy Test1, subtest 3 */
    P2_iep_inputs.end_entity_certificate = "ValidCertificatePathTest1EE.crt";
    P2_iep_inputs.end_entity_smime = "SignedAllCertificatesSamePolicyTest1.eml";
    P2_iep_inputs.end_entity_pkcs12 = "ValidCertificatePathTest1EE.p12";

    print_test_entry(f, "4.8.1 All Certificates Same Policy Test1, subtest 3", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.1 All Certificates Same Policy Test1, subtest 4 */
    P12_iep_inputs.end_entity_certificate = "ValidCertificatePathTest1EE.crt";
    P12_iep_inputs.end_entity_smime = "SignedAllCertificatesSamePolicyTest1.eml";
    P12_iep_inputs.end_entity_pkcs12 = "ValidCertificatePathTest1EE.p12";

    print_test_entry(f, "4.8.1 All Certificates Same Policy Test1, subtest 4", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.2 All Certificates No Policies Test2, subtest 1 */
    default_inputs.end_entity_certificate = "AllCertificatesNoPoliciesTest2EE.crt";
    default_inputs.end_entity_smime = "SignedAllCertificatesNoPoliciesTest2.eml";
    default_inputs.end_entity_pkcs12 = "AllCertificatesNoPoliciesTest2EE.p12";

    print_test_entry(f, "4.8.2 All Certificates No Policies Test2, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.2 All Certificates No Policies Test2, subtest 2 */
    PanyPolicy_iep_inputs.end_entity_certificate = "AllCertificatesNoPoliciesTest2EE.crt";
    PanyPolicy_iep_inputs.end_entity_smime = "SignedAllCertificatesNoPoliciesTest2.eml";
    PanyPolicy_iep_inputs.end_entity_pkcs12 = "AllCertificatesNoPoliciesTest2EE.p12";

    print_test_entry(f, "4.8.2 All Certificates No Policies Test2, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy [<i>initial-policy-set</i> may be set to {NIST-test-policy-1, NIST-test-policy-2, NIST-test-policy-3, NIST-test-policy-4, NIST-test-policy-5, NIST-test-policy-6} if it can not be set to <i>any-policy</i>]");

    /* 4.8.3 Different Policies Test3, subtest 1 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest3EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest3.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest3EE.p12";

    print_test_entry(f, "4.8.3 Different Policies Test3, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.3 Different Policies Test3, subtest 2 */
    PanyPolicy_iep_inputs.end_entity_certificate = "DifferentPoliciesTest3EE.crt";
    PanyPolicy_iep_inputs.end_entity_smime = "SignedDifferentPoliciesTest3.eml";
    PanyPolicy_iep_inputs.end_entity_pkcs12 = "DifferentPoliciesTest3EE.p12";

    print_test_entry(f, "4.8.3 Different Policies Test3, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy [Run if application can be configured as specified (i.e., if <i>initial-policy-set</i> can be <i>any-policy</i> when <i>initial-explicit-policy</i> is set). Otherwise indicate that test could not be run.]");

    /* 4.8.3 Different Policies Test3, subtest 3 */
    P12_iep_inputs.end_entity_certificate = "DifferentPoliciesTest3EE.crt";
    P12_iep_inputs.end_entity_smime = "SignedDifferentPoliciesTest3.eml";
    P12_iep_inputs.end_entity_pkcs12 = "DifferentPoliciesTest3EE.p12";

    print_test_entry(f, "4.8.3 Different Policies Test3, subtest 3", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.4 Different Policies Test4 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest4EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest4.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest4EE.p12";

    print_test_entry(f, "4.8.4 Different Policies Test4", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.5 Different Policies Test5 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest5EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest5.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest5EE.p12";

    print_test_entry(f, "4.8.5 Different Policies Test5", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.6 Overlapping Policies Test6, subtest 1 */
    default_inputs.end_entity_certificate = "OverlappingPoliciesTest6EE.crt";
    default_inputs.end_entity_smime = "SignedOverlappingPoliciesTest6.eml";
    default_inputs.end_entity_pkcs12 = "OverlappingPoliciesTest6EE.p12";

    print_test_entry(f, "4.8.6 Overlapping Policies Test6, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.6 Overlapping Policies Test6, subtest 2 */
    P1_inputs.end_entity_certificate = "OverlappingPoliciesTest6EE.crt";
    P1_inputs.end_entity_smime = "SignedOverlappingPoliciesTest6.eml";
    P1_inputs.end_entity_pkcs12 = "OverlappingPoliciesTest6EE.p12";

    print_test_entry(f, "4.8.6 Overlapping Policies Test6, subtest 2", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.6 Overlapping Policies Test6, subtest 3 */
    P2_inputs.end_entity_certificate = "OverlappingPoliciesTest6EE.crt";
    P2_inputs.end_entity_smime = "SignedOverlappingPoliciesTest6.eml";
    P2_inputs.end_entity_pkcs12 = "OverlappingPoliciesTest6EE.p12";

    print_test_entry(f, "4.8.6 Overlapping Policies Test6, subtest 3", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.7 Different Policies Test7 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest7EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest7.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest7EE.p12";

    print_test_entry(f, "4.8.7 Different Policies Test7", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.8 Different Policies Test8 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest8EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest8.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest8EE.p12";

    print_test_entry(f, "4.8.8 Different Policies Test8", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.9 Different Policies Test9 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest9EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest9.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest9EE.p12";

    print_test_entry(f, "4.8.9 Different Policies Test9", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.10 All Certificates Same Policies Test10, subtest 1 */
    default_inputs.end_entity_certificate = "AllCertificatesSamePoliciesTest10EE.crt";
    default_inputs.end_entity_smime = "SignedAllCertificatesSamePoliciesTest10.eml";
    default_inputs.end_entity_pkcs12 = "AllCertificatesSamePoliciesTest10EE.p12";

    print_test_entry(f, "4.8.10 All Certificates Same Policies Test10, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.10 All Certificates Same Policies Test10, subtest 2 */
    P1_inputs.end_entity_certificate = "AllCertificatesSamePoliciesTest10EE.crt";
    P1_inputs.end_entity_smime = "SignedAllCertificatesSamePoliciesTest10.eml";
    P1_inputs.end_entity_pkcs12 = "AllCertificatesSamePoliciesTest10EE.p12";

    print_test_entry(f, "4.8.10 All Certificates Same Policies Test10, subtest 2", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.10 All Certificates Same Policies Test10, subtest 3 */
    P2_inputs.end_entity_certificate = "AllCertificatesSamePoliciesTest10EE.crt";
    P2_inputs.end_entity_smime = "SignedAllCertificatesSamePoliciesTest10.eml";
    P2_inputs.end_entity_pkcs12 = "AllCertificatesSamePoliciesTest10EE.p12";

    print_test_entry(f, "4.8.10 All Certificates Same Policies Test10, subtest 3", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.11 All Certificates AnyPolicy Test11, subtest 1 */
    default_inputs.end_entity_certificate = "AllCertificatesanyPolicyTest11EE.crt";
    default_inputs.end_entity_smime = "SignedAllCertificatesAnyPolicyTest11.eml";
    default_inputs.end_entity_pkcs12 = "AllCertificatesanyPolicyTest11EE.p12";

    print_notest_entry(f, "4.8.11 All Certificates AnyPolicy Test11, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.11 All Certificates AnyPolicy Test11, subtest 2 */
    P1_inputs.end_entity_certificate = "AllCertificatesanyPolicyTest11EE.crt";
    P1_inputs.end_entity_smime = "SignedAllCertificatesAnyPolicyTest11.eml";
    P1_inputs.end_entity_pkcs12 = "AllCertificatesanyPolicyTest11EE.p12";

    if (anyPolicyOID)
	print_test_entry(f, "4.8.11 All Certificates AnyPolicy Test11, subtest 2", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.8.11 All Certificates AnyPolicy Test11, subtest 2", &default_inputs, INVALID_PATH, "Reject - path only valid under anyPolicy OID");

    /* 4.8.12 Different Policies Test12 */
    default_inputs.end_entity_certificate = "DifferentPoliciesTest12EE.crt";
    default_inputs.end_entity_smime = "SignedDifferentPoliciesTest12.eml";
    default_inputs.end_entity_pkcs12 = "DifferentPoliciesTest12EE.p12";

    print_test_entry(f, "4.8.12 Different Policies Test12", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.13 All Certificates Same Policies Test13, subtest 1 */
    P1_inputs.end_entity_certificate = "AllCertificatesSamePoliciesTest13EE.crt";
    P1_inputs.end_entity_smime = "SignedAllCertificatesSamePoliciesTest13.eml";
    P1_inputs.end_entity_pkcs12 = "AllCertificatesSamePoliciesTest13EE.p12";

    print_test_entry(f, "4.8.13 All Certificates Same Policies Test13, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.13 All Certificates Same Policies Test13, subtest 2 */
    P2_inputs.end_entity_certificate = "AllCertificatesSamePoliciesTest13EE.crt";
    P2_inputs.end_entity_smime = "SignedAllCertificatesSamePoliciesTest13.eml";
    P2_inputs.end_entity_pkcs12 = "AllCertificatesSamePoliciesTest13EE.p12";

    print_test_entry(f, "4.8.13 All Certificates Same Policies Test13, subtest 2", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.13 All Certificates Same Policies Test13, subtest 3 */
    P3_inputs.end_entity_certificate = "AllCertificatesSamePoliciesTest13EE.crt";
    P3_inputs.end_entity_smime = "SignedAllCertificatesSamePoliciesTest13.eml";
    P3_inputs.end_entity_pkcs12 = "AllCertificatesSamePoliciesTest13EE.p12";

    print_test_entry(f, "4.8.13 All Certificates Same Policies Test13, subtest 3", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.14 AnyPolicy Test14, subtest 1 */
    P1_inputs.end_entity_certificate = "AnyPolicyTest14EE.crt";
    P1_inputs.end_entity_smime = "SignedAnyPolicyTest14.eml";
    P1_inputs.end_entity_pkcs12 = "AnyPolicyTest14EE.p12";

    if (anyPolicyOID)
	print_test_entry(f, "4.8.14 AnyPolicy Test14, subtest 1", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.8.14 AnyPolicy Test14, subtest 1", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.14 AnyPolicy Test14, subtest 2 */
    P2_inputs.end_entity_certificate = "AnyPolicyTest14EE.crt";
    P2_inputs.end_entity_smime = "SignedAnyPolicyTest14.eml";
    P2_inputs.end_entity_pkcs12 = "AnyPolicyTest14EE.p12";

    if (anyPolicyOID)
	print_test_entry(f, "4.8.14 AnyPolicy Test14, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.8.14 AnyPolicy Test14, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.8.15 User Notice Qualifier Test15 */
    default_inputs.end_entity_certificate = "UserNoticeQualifierTest15EE.crt";
    default_inputs.end_entity_smime = "SignedUserNoticeQualifierTest15.eml";
    default_inputs.end_entity_pkcs12 = "UserNoticeQualifierTest15EE.p12";

    print_notest_entry(f, "4.8.15 User Notice Qualifier Test15", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.16 User Notice Qualifier Test16 */
    default_inputs.end_entity_certificate = "UserNoticeQualifierTest16EE.crt";
    default_inputs.end_entity_smime = "SignedUserNoticeQualifierTest16.eml";
    default_inputs.end_entity_pkcs12 = "UserNoticeQualifierTest16EE.p12";

    print_notest_entry(f, "4.8.16 User Notice Qualifier Test16", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.17 User Notice Qualifier Test17 */
    default_inputs.end_entity_certificate = "UserNoticeQualifierTest17EE.crt";
    default_inputs.end_entity_smime = "SignedUserNoticeQualifierTest17.eml";
    default_inputs.end_entity_pkcs12 = "UserNoticeQualifierTest17EE.p12";

    print_notest_entry(f, "4.8.17 User Notice Qualifier Test17", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.18 User Notice Qualifier Test18, subtest 1 */
    P1_inputs.end_entity_certificate = "UserNoticeQualifierTest18EE.crt";
    P1_inputs.end_entity_smime = "SignedUserNoticeQualifierTest18.eml";
    P1_inputs.end_entity_pkcs12 = "UserNoticeQualifierTest18EE.p12";

    print_notest_entry(f, "4.8.18 User Notice Qualifier Test18, subtest 1", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.18 User Notice Qualifier Test18, subtest 2 */
    P2_inputs.end_entity_certificate = "UserNoticeQualifierTest18EE.crt";
    P2_inputs.end_entity_smime = "SignedUserNoticeQualifierTest18.eml";
    P2_inputs.end_entity_pkcs12 = "UserNoticeQualifierTest18EE.p12";

    print_notest_entry(f, "4.8.18 User Notice Qualifier Test18, subtest 2", &default_inputs, VALID, "Validate Successfully");

    /* 4.8.19 User Notice Qualifier Test19 */
    default_inputs.end_entity_certificate = "UserNoticeQualifierTest19EE.crt";
    default_inputs.end_entity_smime = "SignedUserNoticeQualifierTest19.eml";
    default_inputs.end_entity_pkcs12 = "UserNoticeQualifierTest19EE.p12";

    print_notest_entry(f, "4.8.19 User Notice Qualifier Test19", &default_inputs, VALID, "This certification path may be rejected since the end entity certificate contains a policy qualifier with an explicitText string that is longer than 200 characters.  This certification path may be validated successfully if the length violation is ignored.");

    /* 4.8.20 CPS Pointer Qualifier Test20 */
    PanyPolicy_iep_inputs.end_entity_certificate = "CPSPointerQualifierTest20EE.crt";
    PanyPolicy_iep_inputs.end_entity_smime = "SignedCPSPointerQualifierTest20.eml";
    PanyPolicy_iep_inputs.end_entity_pkcs12 = "CPSPointerQualifierTest20EE.p12";

    print_test_entry(f, "4.8.20 CPS Pointer Qualifier Test20", &default_inputs, VALID, "Validate Successfully [Test should be run with <i>initial-explicit-policy</i> set (<i>initial-policy-set</i> may be set to {NIST-test-policy-1, NIST-test-policy-2, NIST-test-policy-3, NIST-test-policy-4, NIST-test-policy-5, NIST-test-policy-6} if it can not be set to <i>any-policy</i>).]");

    /* 4.9.1 Valid RequireExplicitPolicy Test1 */
    default_inputs.end_entity_certificate = "ValidrequireExplicitPolicyTest1EE.crt";
    default_inputs.end_entity_smime = "SignedValidRequireExplicitPolicyTest1.eml";
    default_inputs.end_entity_pkcs12 = "ValidrequireExplicitPolicyTest1EE.p12";

    print_test_entry(f, "4.9.1 Valid RequireExplicitPolicy Test1", &default_inputs, VALID, "Validate Successfully");

    /* 4.9.2 Valid RequireExplicitPolicy Test2 */
    default_inputs.end_entity_certificate = "ValidrequireExplicitPolicyTest2EE.crt";
    default_inputs.end_entity_smime = "SignedValidRequireExplicitPolicyTest2.eml";
    default_inputs.end_entity_pkcs12 = "ValidrequireExplicitPolicyTest2EE.p12";

    print_test_entry(f, "4.9.2 Valid RequireExplicitPolicy Test2", &default_inputs, VALID, "Validate Successfully");

    /* 4.9.3 Invalid RequireExplicitPolicy Test3 */
    default_inputs.end_entity_certificate = "InvalidrequireExplicitPolicyTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRequireExplicitPolicyTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvalidrequireExplicitPolicyTest3EE.p12";

    print_test_entry(f, "4.9.3 Invalid RequireExplicitPolicy Test3", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.9.4 Valid RequireExplicitPolicy Test4 */
    default_inputs.end_entity_certificate = "ValidrequireExplicitPolicyTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidRequireExplicitPolicyTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidrequireExplicitPolicyTest4EE.p12";

    print_test_entry(f, "4.9.4 Valid RequireExplicitPolicy Test4", &default_inputs, VALID, "Validate Successfully");

    /* 4.9.5 Invalid RequireExplicitPolicy Test5 */
    default_inputs.end_entity_certificate = "InvalidrequireExplicitPolicyTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRequireExplicitPolicyTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidrequireExplicitPolicyTest5EE.p12";

    print_test_entry(f, "4.9.5 Invalid RequireExplicitPolicy Test5", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.9.6 Valid Self-Issued requireExplicitPolicy Test6 */
    default_inputs.end_entity_certificate = "ValidSelfIssuedrequireExplicitPolicyTest6EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedrequireExplicitPolicyTest6.eml";
    default_inputs.end_entity_pkcs12 = "ValidSelfIssuedrequireExplicitPolicyTest6EE.p12";

    print_test_entry(f, "4.9.6 Valid Self-Issued requireExplicitPolicy Test6", &default_inputs, VALID, "Validate Successfully");

    /* 4.9.7 Invalid Self-Issued requireExplicitPolicy Test7 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedrequireExplicitPolicyTest7EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedrequireExplicitPolicyTest7.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedrequireExplicitPolicyTest7EE.p12";

    print_test_entry(f, "4.9.7 Invalid Self-Issued requireExplicitPolicy Test7", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.9.8 Invalid Self-Issued requireExplicitPolicy Test8 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedrequireExplicitPolicyTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedrequireExplicitPolicyTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedrequireExplicitPolicyTest8EE.p12";

    print_test_entry(f, "4.9.8 Invalid Self-Issued requireExplicitPolicy Test8", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");

    /* 4.10.1 Valid Policy Mapping Test1, subtest 1*/
    P1_inputs.end_entity_certificate = "ValidPolicyMappingTest1EE.crt";
    P1_inputs.end_entity_smime = "SignedValidPolicyMappingTest1.eml";
    P1_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest1EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.1 Valid Policy Mapping Test1, subtest 1", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.10.1 Valid Policy Mapping Test1, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension [Test using the default settings (i.e., <i>initial-policy-set</i> = <i>any-policy</i>)");

    /* 4.10.1 Valid Policy Mapping Test1, subtest 2*/
    P2_inputs.end_entity_certificate = "ValidPolicyMappingTest1EE.crt";
    P2_inputs.end_entity_smime = "SignedValidPolicyMappingTest1.eml";
    P2_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest1EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.1 Valid Policy Mapping Test1, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.1 Valid Policy Mapping Test1, subtest 2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.1 Valid Policy Mapping Test1, subtest 3*/
    PanyPolicy_ipmi_inputs.end_entity_certificate = "ValidPolicyMappingTest1EE.crt";
    PanyPolicy_ipmi_inputs.end_entity_smime = "SignedValidPolicyMappingTest1.eml";
    PanyPolicy_ipmi_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest1EE.p12";

    if (initial_inhibit_policy_mapping)
	print_test_entry(f, "4.10.1 Valid Policy Mapping Test1, subtest 3", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.1 Valid Policy Mapping Test1, subtest 3", &default_inputs, INVALID_PATH, "Test can not be run");

    /* 4.10.2 Invalid Policy Mapping Test2, subtest 1 */
    default_inputs.end_entity_certificate = "InvalidPolicyMappingTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidPolicyMappingTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidPolicyMappingTest2EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.2 Invalid Policy Mapping Test2, subtest 1", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.2 Invalid Policy Mapping Test2, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.2 Invalid Policy Mapping Test2, subtest 2 */
    PanyPolicy_ipmi_inputs.end_entity_certificate = "InvalidPolicyMappingTest2EE.crt";
    PanyPolicy_ipmi_inputs.end_entity_smime = "SignedInvalidPolicyMappingTest2.eml";
    PanyPolicy_ipmi_inputs.end_entity_pkcs12 = "InvalidPolicyMappingTest2EE.p12";

    if (initial_inhibit_policy_mapping)
	print_test_entry(f, "4.10.2 Invalid Policy Mapping Test2, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.2 Invalid Policy Mapping Test2, subtest 2", &default_inputs, INVALID_PATH, "Test can not be run");

    /* 4.10.3 Valid Policy Mapping Test3, subtest 1 */
    P1_inputs.end_entity_certificate = "ValidPolicyMappingTest3EE.crt";
    P1_inputs.end_entity_smime = "SignedValidPolicyMappingTest3.eml";
    P1_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest3EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.3 Valid Policy Mapping Test3, subtest 1", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.3 Valid Policy Mapping Test3, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.3 Valid Policy Mapping Test3, subtest 2 */
    P2_inputs.end_entity_certificate = "ValidPolicyMappingTest3EE.crt";
    P2_inputs.end_entity_smime = "SignedValidPolicyMappingTest3.eml";
    P2_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest3EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.3 Valid Policy Mapping Test3, subtest 2", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.10.3 Valid Policy Mapping Test3, subtest 2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.4 Invalid Policy Mapping Test4 */
    default_inputs.end_entity_certificate = "InvalidPolicyMappingTest4EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidPolicyMappingTest4.eml";
    default_inputs.end_entity_pkcs12 = "InvalidPolicyMappingTest4EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.4 Invalid Policy Mapping Test4", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.4 Invalid Policy Mapping Test4", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.5 Valid Policy Mapping Test5, subtest 1 */
    P1_inputs.end_entity_certificate = "ValidPolicyMappingTest5EE.crt";
    P1_inputs.end_entity_smime = "SignedValidPolicyMappingTest5.eml";
    P1_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest5EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.5 Valid Policy Mapping Test5, subtest 1", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.10.5 Valid Policy Mapping Test5, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.5 Valid Policy Mapping Test5, subtest 2 */
    P6_inputs.end_entity_certificate = "ValidPolicyMappingTest5EE.crt";
    P6_inputs.end_entity_smime = "SignedValidPolicyMappingTest5.eml";
    P6_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest5EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.5 Valid Policy Mapping Test5, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.5 Valid Policy Mapping Test5, subtest 2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.6 Valid Policy Mapping Test6, subtest 1 */
    P1_inputs.end_entity_certificate = "ValidPolicyMappingTest6EE.crt";
    P1_inputs.end_entity_smime = "SignedValidPolicyMappingTest6.eml";
    P1_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest6EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.6 Valid Policy Mapping Test6, subtest 1", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.10.6 Valid Policy Mapping Test6, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.6 Valid Policy Mapping Test6, subtest 2 */
    P6_inputs.end_entity_certificate = "ValidPolicyMappingTest6EE.crt";
    P6_inputs.end_entity_smime = "SignedValidPolicyMappingTest6.eml";
    P6_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest6EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.6 Valid Policy Mapping Test6, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.10.6 Valid Policy Mapping Test6, subtest 2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.7 Invalid Mapping From anyPolicy Test7 */
    default_inputs.end_entity_certificate = "InvalidMappingFromanyPolicyTest7EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidMappingFromanyPolicyTest7.eml";
    default_inputs.end_entity_pkcs12 = "InvalidMappingFromanyPolicyTest7EE.p12";

    if (policyMappings && anyPolicyOID)
	print_test_entry(f, "4.10.7 Invalid Mapping From anyPolicy Test7", &default_inputs, INVALID_PATH, "Reject - intermediate certificate includes a policyMappings extension in which anyPolicy appears as an issuerDomainPolicy");
    else if (anyPolicyOID)
	print_notest_entry(f, "4.10.7 Invalid Mapping From anyPolicy Test7", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.7 Invalid Mapping From anyPolicy Test7", &default_inputs, VALID, "Validate Successfully if the anyPolicy OID is treated the same as any other policy OID");

    /* 4.10.8 Invalid Mapping To anyPolicy Test8 */
    default_inputs.end_entity_certificate = "InvalidMappingToanyPolicyTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidMappingToanyPolicyTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidMappingToanyPolicyTest8EE.p12";

    if (policyMappings && anyPolicyOID)
	print_test_entry(f, "4.10.8 Invalid Mapping To anyPolicy Test8", &default_inputs, INVALID_PATH, "Reject - intermediate certificate includes a policyMappings extension in which anyPolicy appears as a subjectDomainPolicy");
    else if (!policyMappings)
	print_notest_entry(f, "4.10.8 Invalid Mapping To anyPolicy Test8", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.8 Invalid Mapping To anyPolicy Test8", &default_inputs, VALID, "Validate Successfully if the anyPolicy OID is treated the same as any other policy OID");

    /* 4.10.9 Valid Policy Mapping Test9 */
    default_inputs.end_entity_certificate = "ValidPolicyMappingTest9EE.crt";
    default_inputs.end_entity_smime = "SignedValidPolicyMappingTest9.eml";
    default_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest9EE.p12";

    if (policyMappings && anyPolicyOID)
	print_notest_entry(f, "4.10.9 Valid Policy Mapping Test9", &default_inputs, VALID, "Validate Successfully");
    else if (!policyMappings)
	print_notest_entry(f, "4.10.9 Valid Policy Mapping Test9", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.9 Valid Policy Mapping Test9", &default_inputs, INVALID_PATH, "Reject - no acceptable policy if anyPolicy is treated the same as any other policy OID");

    /* 4.10.10 Invalid Policy Mapping Test10 */
    default_inputs.end_entity_certificate = "InvalidPolicyMappingTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidPolicyMappingTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvalidPolicyMappingTest10EE.p12";

    if (policyMappings && anyPolicyOID)
	print_test_entry(f, "4.10.10 Invalid Policy Mapping Test10", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else if (!policyMappings)
	print_notest_entry(f, "4.10.10 Invalid Policy Mapping Test10", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.10 Invalid Policy Mapping Test10", &default_inputs, INVALID_PATH, "Reject - no acceptable policy if anyPolicy is treated the same as any other policy OID");

    /* 4.10.11 Valid Policy Mapping Test11 */
    default_inputs.end_entity_certificate = "ValidPolicyMappingTest11EE.crt";
    default_inputs.end_entity_smime = "SignedValidPolicyMappingTest11.eml";
    default_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest11EE.p12";

    if (policyMappings && anyPolicyOID)
	print_test_entry(f, "4.10.11 Valid Policy Mapping Test11", &default_inputs, VALID, "Validate Successfully");
    else if (!policyMappings)
	print_notest_entry(f, "4.10.11 Valid Policy Mapping Test11", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.11 Valid Policy Mapping Test11", &default_inputs, INVALID_PATH, "Reject - no acceptable policy if anyPolicy is treated the same as any other policy OID");

    /* 4.10.12 Valid Policy Mapping Test12, subtest 1 */
    P1_inputs.end_entity_certificate = "ValidPolicyMappingTest12EE.crt";
    P1_inputs.end_entity_smime = "SignedValidPolicyMappingTest12.eml";
    P1_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest12EE.p12";

    if (policyMappings)
	print_test_entry(f, "4.10.12 Valid Policy Mapping Test12, subtest 1", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.10.12 Valid Policy Mapping Test12, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.12 Valid Policy Mapping Test12, subtest 2 */
    P2_inputs.end_entity_certificate = "ValidPolicyMappingTest12EE.crt";
    P2_inputs.end_entity_smime = "SignedValidPolicyMappingTest12.eml";
    P2_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest12EE.p12";

    if (policyMappings && anyPolicyOID)
	print_test_entry(f, "4.10.12 Valid Policy Mapping Test12, subtest 2", &default_inputs, VALID, "Validate Successfully");
    else if (!policyMappings)
	print_notest_entry(f, "4.10.12 Valid Policy Mapping Test12, subtest 2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.12 Valid Policy Mapping Test12, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy if anyPolicy is treated the same as any other policy OID");

    /* 4.10.13 Valid Policy Mapping Test13 */
    default_inputs.end_entity_certificate = "ValidPolicyMappingTest13EE.crt";
    default_inputs.end_entity_smime = "SignedValidPolicyMappingTest13.eml";
    default_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest13EE.p12";

    if (policyMappings)
	print_notest_entry(f, "4.10.13 Valid Policy Mapping Test13", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.10.13 Valid Policy Mapping Test13", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.10.14 Valid Policy Mapping Test14 */
    default_inputs.end_entity_certificate = "ValidPolicyMappingTest14EE.crt";
    default_inputs.end_entity_smime = "SignedValidPolicyMappingTest14.eml";
    default_inputs.end_entity_pkcs12 = "ValidPolicyMappingTest14EE.p12";

    if (policyMappings && anyPolicyOID)
	print_notest_entry(f, "4.10.14 Valid Policy Mapping Test14", &default_inputs, VALID, "Validate Successfully");
    else if (!policyMappings)
	print_notest_entry(f, "4.10.14 Valid Policy Mapping Test14", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");
    else
	print_notest_entry(f, "4.10.14 Valid Policy Mapping Test14", &default_inputs, INVALID_PATH, "Reject - no acceptable policy if anyPolicy is treated the same as any other policy OID");

    /* 4.11.1 Invalid inhibitPolicyMapping Test1 */
    default_inputs.end_entity_certificate = "InvalidinhibitPolicyMappingTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitPolicyMappingTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitPolicyMappingTest1EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.1 Invalid inhibitPolicyMapping Test1", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.1 Invalid inhibitPolicyMapping Test1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.2 Valid inhibitPolicyMapping Test2 */
    default_inputs.end_entity_certificate = "ValidinhibitPolicyMappingTest2EE.crt";
    default_inputs.end_entity_smime = "SignedValidinhibitPolicyMappingTest2.eml";
    default_inputs.end_entity_pkcs12 = "ValidinhibitPolicyMappingTest2EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.2 Valid inhibitPolicyMapping Test2", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.11.2 Valid inhibitPolicyMapping Test2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.3 Invalid inhibitPolicyMapping Test3 */
    default_inputs.end_entity_certificate = "InvalidinhibitPolicyMappingTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitPolicyMappingTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitPolicyMappingTest3EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.3 Invalid inhibitPolicyMapping Test3", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.3 Invalid inhibitPolicyMapping Test3", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.4 Valid inhibitPolicyMapping Test4 */
    default_inputs.end_entity_certificate = "ValidinhibitPolicyMappingTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidinhibitPolicyMappingTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidinhibitPolicyMappingTest4EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.4 Valid inhibitPolicyMapping Test4", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.11.4 Valid inhibitPolicyMapping Test4", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.5 Invalid inhibitPolicyMapping Test5 */
    default_inputs.end_entity_certificate = "InvalidinhibitPolicyMappingTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitPolicyMappingTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitPolicyMappingTest5EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.5 Invalid inhibitPolicyMapping Test5", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.5 Invalid inhibitPolicyMapping Test5", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.6 Invalid inhibitPolicyMapping Test6 */
    default_inputs.end_entity_certificate = "InvalidinhibitPolicyMappingTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitPolicyMappingTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitPolicyMappingTest6EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.6 Invalid inhibitPolicyMapping Test6", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.6 Invalid inhibitPolicyMapping Test6", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.7 Valid Self-Issued inhibitPolicyMapping Test7 */
    default_inputs.end_entity_certificate = "ValidSelfIssuedinhibitPolicyMappingTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedinhibitPolicyMappingTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValidSelfIssuedinhibitPolicyMappingTest7EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.7 Valid Self-Issued inhibitPolicyMapping Test7", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.11.7 Valid Self-Issued inhibitPolicyMapping Test7", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.8 Invalid Self-Issued inhibitPolicyMapping Test8 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedinhibitPolicyMappingTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedinhibitPolicyMappingTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedinhibitPolicyMappingTest8EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.8 Invalid Self-Issued inhibitPolicyMapping Test8", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.8 Invalid Self-Issued inhibitPolicyMapping Test8", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.9 Invalid Self-Issued inhibitPolicyMapping Test9 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedinhibitPolicyMappingTest9EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedinhibitPolicyMappingTest9.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedinhibitPolicyMappingTest9EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.9 Invalid Self-Issued inhibitPolicyMapping Test9", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.9 Invalid Self-Issued inhibitPolicyMapping Test9", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.10 Invalid Self-Issued inhibitPolicyMapping Test10 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedinhibitPolicyMappingTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedinhibitPolicyMappingTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedinhibitPolicyMappingTest10EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.10 Invalid Self-Issued inhibitPolicyMapping Test10", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.10 Invalid Self-Issued inhibitPolicyMapping Test10", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.11.11 Invalid Self-Issued inhibitPolicyMapping Test11 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedinhibitPolicyMappingTest11EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedinhibitPolicyMappingTest11.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedinhibitPolicyMappingTest11EE.p12";

    if (inhibitPolicyMapping)
	print_test_entry(f, "4.11.11 Invalid Self-Issued inhibitPolicyMapping Test11", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.11.11 Invalid Self-Issued inhibitPolicyMapping Test11", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.1 Invalid inhibitAnyPolicy Test1 */
    default_inputs.end_entity_certificate = "InvalidinhibitAnyPolicyTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitAnyPolicyTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitAnyPolicyTest1EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.1 Invalid inhibitAnyPolicy Test1", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.1 Invalid inhibitAnyPolicy Test1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.2 Valid inhibitAnyPolicy Test2 */
    default_inputs.end_entity_certificate = "ValidinhibitAnyPolicyTest2EE.crt";
    default_inputs.end_entity_smime = "SignedValidinhibitAnyPolicyTest2.eml";
    default_inputs.end_entity_pkcs12 = "ValidinhibitAnyPolicyTest2EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.2 Valid inhibitAnyPolicy Test2", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.12.2 Valid inhibitAnyPolicy Test2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.3 inhibitAnyPolicy Test3, subtest 1 */
    default_inputs.end_entity_certificate = "inhibitAnyPolicyTest3EE.crt";
    default_inputs.end_entity_smime = "SignedinhibitAnyPolicyTest3.eml";
    default_inputs.end_entity_pkcs12 = "inhibitAnyPolicyTest3EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.3 inhibitAnyPolicy Test3, subtest 1", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.12.3 inhibitAnyPolicy Test3, subtest 1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.3 inhibitAnyPolicy Test3, subtest 2 */
    PanyPolicy_iiap_inputs.end_entity_certificate = "inhibitAnyPolicyTest3EE.crt";
    PanyPolicy_iiap_inputs.end_entity_smime = "SignedinhibitAnyPolicyTest3.eml";
    PanyPolicy_iiap_inputs.end_entity_pkcs12 = "inhibitAnyPolicyTest3EE.p12";

    if (initial_inhibit_any_policy)
	print_test_entry(f, "4.12.3 inhibitAnyPolicy Test3, subtest 2", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.3 inhibitAnyPolicy Test3, subtest 2", &default_inputs, INVALID_PATH, "Test can not be run");

    /* 4.12.4 Invalid inhibitAnyPolicy Test4 */
    default_inputs.end_entity_certificate = "InvalidinhibitAnyPolicyTest4EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitAnyPolicyTest4.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitAnyPolicyTest4EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.4 Invalid inhibitAnyPolicy Test4", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.4 Invalid inhibitAnyPolicy Test4", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.5 Invalid inhibitAnyPolicy Test5 */
    default_inputs.end_entity_certificate = "InvalidinhibitAnyPolicyTest5EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitAnyPolicyTest5.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitAnyPolicyTest5EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.5 Invalid inhibitAnyPolicy Test5", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.5 Invalid inhibitAnyPolicy Test5", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.6 Invalid inhibitAnyPolicy Test6 */
    default_inputs.end_entity_certificate = "InvalidinhibitAnyPolicyTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidinhibitAnyPolicyTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvalidinhibitAnyPolicyTest6EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.6 Invalid inhibitAnyPolicy Test6", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.6 Invalid inhibitAnyPolicy Test6", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.7 Valid Self-Issued inhibitAnyPolicy Test7 */
    default_inputs.end_entity_certificate = "ValidSelfIssuedinhibitAnyPolicyTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedinhibitAnyPolicyTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValidSelfIssuedinhibitAnyPolicyTest7EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.7 Valid Self-Issued inhibitAnyPolicy Test7", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.12.7 Valid Self-Issued inhibitAnyPolicy Test7", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.8 Invalid Self-Issued inhibitAnyPolicy Test8 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedinhibitAnyPolicyTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedinhibitAnyPolicyTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedinhibitAnyPolicyTest8EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.8 Invalid Self-Issued inhibitAnyPolicy Test8", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.8 Invalid Self-Issued inhibitAnyPolicy Test8", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.9 Valid Self-Issued inhibitAnyPolicy Test9 */
    default_inputs.end_entity_certificate = "ValidSelfIssuedinhibitAnyPolicyTest9EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedinhibitAnyPolicyTest9.eml";
    default_inputs.end_entity_pkcs12 = "ValidSelfIssuedinhibitAnyPolicyTest9EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.9 Valid Self-Issued inhibitAnyPolicy Test9", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.12.9 Valid Self-Issued inhibitAnyPolicy Test9", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.12.10 Invalid Self-Issued inhibitAnyPolicy Test10 */
    default_inputs.end_entity_certificate = "InvalidSelfIssuedinhibitAnyPolicyTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedinhibitAnyPolicyTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvalidSelfIssuedinhibitAnyPolicyTest10EE.p12";

    if (inhibitAnyPolicy)
	print_test_entry(f, "4.12.10 Invalid Self-Issued inhibitAnyPolicy Test10", &default_inputs, INVALID_PATH, "Reject - no acceptable policy");
    else
	print_notest_entry(f, "4.12.10 Invalid Self-Issued inhibitAnyPolicy Test10", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.1 Valid DN nameConstraints Test1 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest1EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest1.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest1EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.1 Valid DN nameConstraints Test1", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.13.1 Valid DN nameConstraints Test1", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.2 Invalid DN nameConstraints Test2 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest2EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.2 Invalid DN nameConstraints Test2", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.2 Invalid DN nameConstraints Test2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.3 Invalid DN nameConstraints Test3 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest3EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.3 Invalid DN nameConstraints Test3", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.3 Invalid DN nameConstraints Test3", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.4 Valid DN nameConstraints Test4 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest4EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.4 Valid DN nameConstraints Test4", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.4 Valid DN nameConstraints Test4", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.5 Valid DN nameConstraints Test5 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest5EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest5.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest5EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.5 Valid DN nameConstraints Test5", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.5 Valid DN nameConstraints Test5", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.6 Valid DN nameConstraints Test6 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest6EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest6.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest6EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.6 Valid DN nameConstraints Test6", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.6 Valid DN nameConstraints Test6", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.7 Invalid DN nameConstraints Test7 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest7EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest7.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest7EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.7 Invalid DN nameConstraints Test7", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.7 Invalid DN nameConstraints Test7", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.8 Invalid DN nameConstraints Test8 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest8EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.8 Invalid DN nameConstraints Test8", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.8 Invalid DN nameConstraints Test8", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.9 Invalid DN nameConstraints Test9 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest9EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest9.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest9EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.9 Invalid DN nameConstraints Test9", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.9 Invalid DN nameConstraints Test9", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.10 Invalid DN nameConstraints Test10 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest10EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.10 Invalid DN nameConstraints Test10", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.10 Invalid DN nameConstraints Test10", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.11 Valid DN nameConstraints Test11 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest11EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest11.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest11EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.11 Valid DN nameConstraints Test11", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.11 Valid DN nameConstraints Test11", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.12 Invalid DN nameConstraints Test12 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest12EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest12.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest12EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.12 Invalid DN nameConstraints Test12", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.12 Invalid DN nameConstraints Test12", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.13 Invalid DN nameConstraints Test13 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest13EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest13.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest13EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.13 Invalid DN nameConstraints Test13", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.13 Invalid DN nameConstraints Test13", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.14 Valid DN nameConstraints Test14 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest14EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest14.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest14EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.14 Valid DN nameConstraints Test14", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.14 Valid DN nameConstraints Test14", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.15 Invalid DN nameConstraints Test15 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest15EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest15.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest15EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.15 Invalid DN nameConstraints Test15", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.15 Invalid DN nameConstraints Test15", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.16 Invalid DN nameConstraints Test16 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest16EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest16.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest16EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.16 Invalid DN nameConstraints Test16", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.16 Invalid DN nameConstraints Test16", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.17 Invalid DN nameConstraints Test17 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest17EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNnameConstraintsTest17.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest17EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.17 Invalid DN nameConstraints Test17", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.17 Invalid DN nameConstraints Test17", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.18 Valid DN nameConstraints Test18 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest18EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNnameConstraintsTest18.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest18EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.18 Valid DN nameConstraints Test18", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.18 Valid DN nameConstraints Test18", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.19 Valid Self-Issued DN nameConstraints Test19 */
    default_inputs.end_entity_certificate = "ValidDNnameConstraintsTest19EE.crt";
    default_inputs.end_entity_smime = "SignedValidSelfIssuedDNnameConstraintsTest19.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNnameConstraintsTest19EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.19 Valid Self-Issued DN nameConstraints Test19", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.19 Valid Self-Issued DN nameConstraints Test19", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.20 Invalid Self-Issued DN nameConstraints Test20 */
    default_inputs.end_entity_certificate = "InvalidDNnameConstraintsTest20EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidSelfIssuedDNnameConstraintsTest20.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNnameConstraintsTest20EE.p12";

    if (nameConstraints_directoryName)
	print_test_entry(f, "4.13.20 Invalid Self-Issued DN nameConstraints Test20", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.20 Invalid Self-Issued DN nameConstraints Test20", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.21 Valid RFC822 nameConstraints Test21 */
    default_inputs.end_entity_certificate = "ValidRFC822nameConstraintsTest21EE.crt";
    default_inputs.end_entity_smime = "SignedValidRFC822nameConstraintsTest21.eml";
    default_inputs.end_entity_pkcs12 = "ValidRFC822nameConstraintsTest21EE.p12";

    if (nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.21 Valid RFC822 nameConstraints Test21", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.13.21 Valid RFC822 nameConstraints Test21", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.22 Invalid RFC822 nameConstraints Test22 */
    default_inputs.end_entity_certificate = "InvalidRFC822nameConstraintsTest22EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRFC822nameConstraintsTest22.eml";
    default_inputs.end_entity_pkcs12 = "InvalidRFC822nameConstraintsTest22EE.p12";

    if (nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.22 Invalid RFC822 nameConstraints Test22", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.22 Invalid RFC822 nameConstraints Test22", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.23 Valid RFC822 nameConstraints Test23 */
    default_inputs.end_entity_certificate = "ValidRFC822nameConstraintsTest23EE.crt";
    default_inputs.end_entity_smime = "SignedValidRFC822nameConstraintsTest23.eml";
    default_inputs.end_entity_pkcs12 = "ValidRFC822nameConstraintsTest23EE.p12";

    if (nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.23 Valid RFC822 nameConstraints Test23", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.23 Valid RFC822 nameConstraints Test23", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.24 Invalid RFC822 nameConstraints Test24 */
    default_inputs.end_entity_certificate = "InvalidRFC822nameConstraintsTest24EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRFC822nameConstraintsTest24.eml";
    default_inputs.end_entity_pkcs12 = "InvalidRFC822nameConstraintsTest24EE.p12";

    if (nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.24 Invalid RFC822 nameConstraints Test24", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.24 Invalid RFC822 nameConstraints Test24", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.25 Valid RFC822 nameConstraints Test25 */
    default_inputs.end_entity_certificate = "ValidRFC822nameConstraintsTest25EE.crt";
    default_inputs.end_entity_smime = "SignedValidRFC822nameConstraintsTest25.eml";
    default_inputs.end_entity_pkcs12 = "ValidRFC822nameConstraintsTest25EE.p12";

    if (nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.25 Valid RFC822 nameConstraints Test25", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.25 Valid RFC822 nameConstraints Test25", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.26 Invalid RFC822 nameConstraints Test26 */
    default_inputs.end_entity_certificate = "InvalidRFC822nameConstraintsTest26EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidRFC822nameConstraintsTest26.eml";
    default_inputs.end_entity_pkcs12 = "InvalidRFC822nameConstraintsTest26EE.p12";

    if (nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.26 Invalid RFC822 nameConstraints Test26", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.26 Invalid RFC822 nameConstraints Test26", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.27 Valid DN and  RFC822 nameConstraints Test27 */
    default_inputs.end_entity_certificate = "ValidDNandRFC822nameConstraintsTest27EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNandRFC822nameConstraintsTest27.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNandRFC822nameConstraintsTest27EE.p12";

    if (nameConstraints_directoryName && nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.27 Valid DN and  RFC822 nameConstraints Test27", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.27 Valid DN and  RFC822 nameConstraints Test27", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.28 Invalid DN and  RFC822 nameConstraints Test28 */
    default_inputs.end_entity_certificate = "InvalidDNandRFC822nameConstraintsTest28EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNandRFC822nameConstraintsTest28.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNandRFC822nameConstraintsTest28EE.p12";

    if (nameConstraints_directoryName && nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.28 Invalid DN and  RFC822 nameConstraints Test28", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.28 Invalid DN and  RFC822 nameConstraints Test28", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.29 Invalid DN and  RFC822 nameConstraints Test29 */
    default_inputs.end_entity_certificate = "InvalidDNandRFC822nameConstraintsTest29EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNandRFC822nameConstraintsTest29.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNandRFC822nameConstraintsTest29EE.p12";

    if (nameConstraints_directoryName && nameConstraints_rfc822Name)
	print_test_entry(f, "4.13.29 Invalid DN and  RFC822 nameConstraints Test29", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.29 Invalid DN and  RFC822 nameConstraints Test29", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.30 Valid DNS nameConstraints Test30 */
    default_inputs.end_entity_certificate = "ValidDNSnameConstraintsTest30EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNSnameConstraintsTest30.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNSnameConstraintsTest30EE.p12";

    if (nameConstraints_DNS)
	print_test_entry(f, "4.13.30 Valid DNS nameConstraints Test30", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.13.30 Valid DNS nameConstraints Test30", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.31 Invalid DNS nameConstraints Test31 */
    default_inputs.end_entity_certificate = "InvalidDNSnameConstraintsTest31EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNSnameConstraintsTest31.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNSnameConstraintsTest31EE.p12";

    if (nameConstraints_DNS)
	print_test_entry(f, "4.13.31 Invalid DNS nameConstraints Test31", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.31 Invalid DNS nameConstraints Test31", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.32 Valid DNS nameConstraints Test32 */
    default_inputs.end_entity_certificate = "ValidDNSnameConstraintsTest32EE.crt";
    default_inputs.end_entity_smime = "SignedValidDNSnameConstraintsTest32.eml";
    default_inputs.end_entity_pkcs12 = "ValidDNSnameConstraintsTest32EE.p12";

    if (nameConstraints_DNS)
	print_test_entry(f, "4.13.32 Valid DNS nameConstraints Test32", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.32 Valid DNS nameConstraints Test32", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.33 Invalid DNS nameConstraints Test33 */
    default_inputs.end_entity_certificate = "InvalidDNSnameConstraintsTest33EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNSnameConstraintsTest33.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNSnameConstraintsTest33EE.p12";

    if (nameConstraints_DNS)
	print_test_entry(f, "4.13.33 Invalid DNS nameConstraints Test33", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.33 Invalid DNS nameConstraints Test33", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.34 Valid URI nameConstraints Test34 */
    default_inputs.end_entity_certificate = "ValidURInameConstraintsTest34EE.crt";
    default_inputs.end_entity_smime = "SignedValidURInameConstraintsTest34.eml";
    default_inputs.end_entity_pkcs12 = "ValidURInameConstraintsTest34EE.p12";

    if (nameConstraints_URI)
	print_test_entry(f, "4.13.34 Valid URI nameConstraints Test34", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.13.34 Valid URI nameConstraints Test34", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.35 Invalid URI nameConstraints Test35 */
    default_inputs.end_entity_certificate = "InvalidURInameConstraintsTest35EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidURInameConstraintsTest35.eml";
    default_inputs.end_entity_pkcs12 = "InvalidURInameConstraintsTest35EE.p12";

    if (nameConstraints_URI)
	print_test_entry(f, "4.13.35 Invalid URI nameConstraints Test35", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.35 Invalid URI nameConstraints Test35", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.36 Valid URI nameConstraints Test36 */
    default_inputs.end_entity_certificate = "ValidURInameConstraintsTest36EE.crt";
    default_inputs.end_entity_smime = "SignedValidURInameConstraintsTest36.eml";
    default_inputs.end_entity_pkcs12 = "ValidURInameConstraintsTest36EE.p12";

    if (nameConstraints_URI)
	print_test_entry(f, "4.13.36 Valid URI nameConstraints Test36", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.13.36 Valid URI nameConstraints Test36", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.37 Invalid URI nameConstraints Test37 */
    default_inputs.end_entity_certificate = "InvalidURInameConstraintsTest37EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidURInameConstraintsTest37.eml";
    default_inputs.end_entity_pkcs12 = "InvalidURInameConstraintsTest37EE.p12";

    if (nameConstraints_URI)
	print_test_entry(f, "4.13.37 Invalid URI nameConstraints Test37", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.37 Invalid URI nameConstraints Test37", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.13.38 Invalid DNS nameConstraints Test38 */
    default_inputs.end_entity_certificate = "InvalidDNSnameConstraintsTest38EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidDNSnameConstraintsTest38.eml";
    default_inputs.end_entity_pkcs12 = "InvalidDNSnameConstraintsTest38EE.p12";

    if (nameConstraints_DNS)
	print_test_entry(f, "4.13.38 Invalid DNS nameConstraints Test38", &default_inputs, INVALID_PATH, "Reject - name constraints violation");
    else
	print_notest_entry(f, "4.13.38 Invalid DNS nameConstraints Test38", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");

    /* 4.14.1 Valid distributionPoint Test1 */
    default_inputs.end_entity_certificate = "ValiddistributionPointTest1EE.crt";
    default_inputs.end_entity_smime = "SignedValiddistributionPointTest1.eml";
    default_inputs.end_entity_pkcs12 = "ValiddistributionPointTest1EE.p12";

    print_test_entry(f, "4.14.1 Valid distributionPoint Test1", &default_inputs, VALID, "Validate Successfully");

    /* 4.14.2 Invalid distributionPoint Test2 */
    default_inputs.end_entity_certificate = "InvaliddistributionPointTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddistributionPointTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddistributionPointTest2EE.p12";

    print_test_entry(f, "4.14.2 Invalid distributionPoint Test2", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");

    /* 4.14.3 Invalid distributionPoint Test3 */
    default_inputs.end_entity_certificate = "InvaliddistributionPointTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddistributionPointTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddistributionPointTest3EE.p12";

    print_test_entry(f, "4.14.3 Invalid distributionPoint Test3", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.4 Valid distributionPoint Test4 */
    default_inputs.end_entity_certificate = "ValiddistributionPointTest4EE.crt";
    default_inputs.end_entity_smime = "SignedValiddistributionPointTest4.eml";
    default_inputs.end_entity_pkcs12 = "ValiddistributionPointTest4EE.p12";

    if (distributionPoints_nameRelativeToIssuer)
	print_test_entry(f, "4.14.4 Valid distributionPoint Test4", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.14.4 Valid distributionPoint Test4", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.5 Valid distributionPoint Test5 */
    default_inputs.end_entity_certificate = "ValiddistributionPointTest5EE.crt";
    default_inputs.end_entity_smime = "SignedValiddistributionPointTest5.eml";
    default_inputs.end_entity_pkcs12 = "ValiddistributionPointTest5EE.p12";

    if (distributionPoints_nameRelativeToIssuer)
	print_test_entry(f, "4.14.5 Valid distributionPoint Test5", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.14.5 Valid distributionPoint Test5", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.6 Invalid distributionPoint Test6 */
    default_inputs.end_entity_certificate = "InvaliddistributionPointTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddistributionPointTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddistributionPointTest6EE.p12";

    if (distributionPoints_nameRelativeToIssuer)
	print_test_entry(f, "4.14.6 Invalid distributionPoint Test6", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.6 Invalid distributionPoint Test6", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.7 Valid distributionPoint Test7 */
    default_inputs.end_entity_certificate = "ValiddistributionPointTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValiddistributionPointTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValiddistributionPointTest7EE.p12";

    if (distributionPoints_nameRelativeToIssuer)
	print_test_entry(f, "4.14.7 Valid distributionPoint Test7", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.7 Valid distributionPoint Test7", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.8 Invalid distributionPoint Test8 */
    default_inputs.end_entity_certificate = "InvaliddistributionPointTest8EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddistributionPointTest8.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddistributionPointTest8EE.p12";

    if (distributionPoints_nameRelativeToIssuer)
	print_test_entry(f, "4.14.8 Invalid distributionPoint Test8", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");
    else
	print_notest_entry(f, "4.14.8 Invalid distributionPoint Test8", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.9 Invalid distributionPoint Test9 */
    default_inputs.end_entity_certificate = "InvaliddistributionPointTest9EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddistributionPointTest9.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddistributionPointTest9EE.p12";

    print_test_entry(f, "4.14.9 Invalid distributionPoint Test9", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.10 Valid No issuingDistributionPoint Test10 */
    default_inputs.end_entity_certificate = "ValidNoissuingDistributionPointTest10EE.crt";
    default_inputs.end_entity_smime = "SignedValidNoissuingDistributionPointTest10.eml";
    default_inputs.end_entity_pkcs12 = "ValidNoissuingDistributionPointTest10EE.p12";

    print_test_entry(f, "4.14.10 Valid No issuingDistributionPoint Test10", &default_inputs, VALID, "Validate Successfully");

    /* 4.14.11 Invalid onlyContainsUserCerts CRL Test11 */
    default_inputs.end_entity_certificate = "InvalidonlyContainsUserCertsTest11EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlyContainsUserCertsCRLTest11.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlyContainsUserCertsTest11EE.p12";

    print_test_entry(f, "4.14.11 Invalid onlyContainsUserCerts CRL Test11", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.12 Invalid onlyContainsCACerts CRL Test12 */
    default_inputs.end_entity_certificate = "InvalidonlyContainsCACertsTest12EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlyContainsCACertsCRLTest12.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlyContainsCACertsTest12EE.p12";

    print_test_entry(f, "4.14.12 Invalid onlyContainsCACerts CRL Test12", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.13 Valid onlyContainsCACerts CRL Test13 */
    default_inputs.end_entity_certificate = "ValidonlyContainsCACertsTest13EE.crt";
    default_inputs.end_entity_smime = "SignedValidonlyContainsCACertsCRLTest13.eml";
    default_inputs.end_entity_pkcs12 = "ValidonlyContainsCACertsTest13EE.p12";

    print_test_entry(f, "4.14.13 Valid onlyContainsCACerts CRL Test13", &default_inputs, VALID, "Validate Successfully");

    /* 4.14.14 Invalid onlyContainsAttributeCerts Test14 */
    default_inputs.end_entity_certificate = "InvalidonlyContainsAttributeCertsTest14EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlyContainsAttributeCertsTest14.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlyContainsAttributeCertsTest14EE.p12";

    print_test_entry(f, "4.14.14 Invalid onlyContainsAttributeCerts Test14", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.15 Invalid onlySomeReasons Test15 */
    default_inputs.end_entity_certificate = "InvalidonlySomeReasonsTest15EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlySomeReasonsTest15.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlySomeReasonsTest15EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.15 Invalid onlySomeReasons Test15", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.15 Invalid onlySomeReasons Test15", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.16 Invalid onlySomeReasons Test16 */
    default_inputs.end_entity_certificate = "InvalidonlySomeReasonsTest16EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlySomeReasonsTest16.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlySomeReasonsTest16EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.16 Invalid onlySomeReasons Test16", &default_inputs, REVOKED, "Reject - end entity certificate is on hold");
    else
	print_notest_entry(f, "4.14.16 Invalid onlySomeReasons Test16", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.17 Invalid onlySomeReasons Test17 */
    default_inputs.end_entity_certificate = "InvalidonlySomeReasonsTest17EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlySomeReasonsTest17.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlySomeReasonsTest17EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.17 Invalid onlySomeReasons Test17", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");
    else
	print_notest_entry(f, "4.14.17 Invalid onlySomeReasons Test17", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.18 Valid onlySomeReasons Test18 */
    default_inputs.end_entity_certificate = "ValidonlySomeReasonsTest18EE.crt";
    default_inputs.end_entity_smime = "SignedValidonlySomeReasonsTest18.eml";
    default_inputs.end_entity_pkcs12 = "ValidonlySomeReasonsTest18EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.18 Valid onlySomeReasons Test18", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.14.18 Valid onlySomeReasons Test18", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.19 Valid onlySomeReasons Test19 */
    default_inputs.end_entity_certificate = "ValidonlySomeReasonsTest19EE.crt";
    default_inputs.end_entity_smime = "SignedValidonlySomeReasonsTest19.eml";
    default_inputs.end_entity_pkcs12 = "ValidonlySomeReasonsTest19EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.19 Valid onlySomeReasons Test19", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.19 Valid onlySomeReasons Test19", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.20 Invalid onlySomeReasons Test20 */
    default_inputs.end_entity_certificate = "InvalidonlySomeReasonsTest20EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlySomeReasonsTest20.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlySomeReasonsTest20EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.20 Invalid onlySomeReasons Test20", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.20 Invalid onlySomeReasons Test20", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.21 Invalid onlySomeReasons Test21 */
    default_inputs.end_entity_certificate = "InvalidonlySomeReasonsTest21EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidonlySomeReasonsTest21.eml";
    default_inputs.end_entity_pkcs12 = "InvalidonlySomeReasonsTest21EE.p12";

    if (distributionPoints_onlySomeReasons)
	print_test_entry(f, "4.14.21 Invalid onlySomeReasons Test21", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.21 Invalid onlySomeReasons Test21", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.22 Valid IDP with indirectCRL Test22 */
    default_inputs.end_entity_certificate = "ValidIDPwithindirectCRLTest22EE.crt";
    default_inputs.end_entity_smime = "SignedValidIDPwithindirectCRLTest22.eml";
    default_inputs.end_entity_pkcs12 = "ValidIDPwithindirectCRLTest22EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.22 Valid IDP with indirectCRL Test22", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.22 Valid IDP with indirectCRL Test22", &default_inputs, VALID, "Application may validate successfully. However, if the application treats an issuingDistributionPoint extension with indirectCRL set to TRUE as an unrecognized critical extension then the application should reject the path or issue a warning that the status of end entity certificate can not be determined");

    /* 4.14.23 Invalid IDP with indirectCRL Test23 */
    default_inputs.end_entity_certificate = "InvalidIDPwithindirectCRLTest23EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidIDPwithindirectCRLTest23.eml";
    default_inputs.end_entity_pkcs12 = "InvalidIDPwithindirectCRLTest23EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.23 Invalid IDP with indirectCRL Test23", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.23 Invalid IDP with indirectCRL Test23", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");

    /* 4.14.24 Valid IDP with indirectCRL Test24 */
    default_inputs.end_entity_certificate = "ValidIDPwithindirectCRLTest24EE.crt";
    default_inputs.end_entity_smime = "SignedValidIDPwithindirectCRLTest24.eml";
    default_inputs.end_entity_pkcs12 = "ValidIDPwithindirectCRLTest24EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.24 Valid IDP with indirectCRL Test24", &default_inputs, VALID, "Validate Successfully");
    else
	print_test_entry(f, "4.14.24 Valid IDP with indirectCRL Test24", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.25 Valid IDP with indirectCRL Test25 */
    default_inputs.end_entity_certificate = "ValidIDPwithindirectCRLTest25EE.crt";
    default_inputs.end_entity_smime = "SignedValidIDPwithindirectCRLTest25.eml";
    default_inputs.end_entity_pkcs12 = "ValidIDPwithindirectCRLTest25EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.25 Valid IDP with indirectCRL Test25", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.25 Valid IDP with indirectCRL Test25", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.26 Invalid IDP with indirectCRL Test26 */
    default_inputs.end_entity_certificate = "InvalidIDPwithindirectCRLTest26EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidIDPwithindirectCRLTest26.eml";
    default_inputs.end_entity_pkcs12 = "InvalidIDPwithindirectCRLTest26EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.26 Invalid IDP with indirectCRL Test26", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");
    else
	print_notest_entry(f, "4.14.26 Invalid IDP with indirectCRL Test26", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.27 Invalid cRLIssuer Test27 */
    default_inputs.end_entity_certificate = "InvalidcRLIssuerTest27EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcRLIssuerTest27.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcRLIssuerTest27EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.27 Invalid cRLIssuer Test27", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");
    else
	print_notest_entry(f, "4.14.27 Invalid cRLIssuer Test27", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.28 Valid cRLIssuer Test28 */
    default_inputs.end_entity_certificate = "ValidcRLIssuerTest28EE.crt";
    default_inputs.end_entity_smime = "SignedValidcRLIssuerTest28.eml";
    default_inputs.end_entity_pkcs12 = "ValidcRLIssuerTest28EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.28 Valid cRLIssuer Test28", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.28 Valid cRLIssuer Test28", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.29 Valid cRLIssuer Test29 */
    default_inputs.end_entity_certificate = "ValidcRLIssuerTest29EE.crt";
    default_inputs.end_entity_smime = "SignedValidcRLIssuerTest29.eml";
    default_inputs.end_entity_pkcs12 = "ValidcRLIssuerTest29EE.p12";

    if (distributionPoints_nameRelativeToIssuer && indirectCRLs)
	print_test_entry(f, "4.14.29 Valid cRLIssuer Test29", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.29 Valid cRLIssuer Test29", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.30 Valid cRLIssuer Test30 */
    default_inputs.end_entity_certificate = "ValidcRLIssuerTest30EE.crt";
    default_inputs.end_entity_smime = "SignedValidcRLIssuerTest30.eml";
    default_inputs.end_entity_pkcs12 = "ValidcRLIssuerTest30EE.p12";

    if (indirectCRLs)
	print_notest_entry(f, "4.14.30 Valid cRLIssuer Test30", &default_inputs, STATUS_UNKNOWN, "Do not run this test.  There is a circular dependency in the certification path to the CRL issuer");
    else
	print_notest_entry(f, "4.14.30 Valid cRLIssuer Test30", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.31 Invalid cRLIssuer Test31 */
    default_inputs.end_entity_certificate = "InvalidcRLIssuerTest31EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcRLIssuerTest31.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcRLIssuerTest31EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.31 Invalid cRLIssuer Test31", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.31 Invalid cRLIssuer Test31", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.32 Invalid cRLIssuer Test32 */
    default_inputs.end_entity_certificate = "InvalidcRLIssuerTest32EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcRLIssuerTest32.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcRLIssuerTest32EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.32 Invalid cRLIssuer Test32", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.32 Invalid cRLIssuer Test32", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.33 Valid cRLIssuer Test33 */
    default_inputs.end_entity_certificate = "ValidcRLIssuerTest33EE.crt";
    default_inputs.end_entity_smime = "SignedValidcRLIssuerTest33.eml";
    default_inputs.end_entity_pkcs12 = "ValidcRLIssuerTest33EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.33 Valid cRLIssuer Test33", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.14.33 Valid cRLIssuer Test33", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.14.34 Invalid cRLIssuer Test34 */
    default_inputs.end_entity_certificate = "InvalidcRLIssuerTest34EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcRLIssuerTest34.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcRLIssuerTest34EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.34 Invalid cRLIssuer Test34", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.14.34 Invalid cRLIssuer Test34", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");

    /* 4.14.35 Invalid cRLIssuer Test35 */
    default_inputs.end_entity_certificate = "InvalidcRLIssuerTest35EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidcRLIssuerTest35.eml";
    default_inputs.end_entity_pkcs12 = "InvalidcRLIssuerTest35EE.p12";

    if (indirectCRLs)
	print_test_entry(f, "4.14.35 Invalid cRLIssuer Test35", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");
    else
	print_notest_entry(f, "4.14.35 Invalid cRLIssuer Test35", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.15.1 Invalid deltaCRLIndicator No Base Test1 */
    default_inputs.end_entity_certificate = "InvaliddeltaCRLIndicatorNoBaseTest1EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddeltaCRLIndicatorNoBaseTest1.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddeltaCRLIndicatorNoBaseTest1EE.p12";

    print_test_entry(f, "4.15.1 Invalid deltaCRLIndicator No Base Test1", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.15.2 Valid delta-CRL Test2 */
    default_inputs.end_entity_certificate = "ValiddeltaCRLTest2EE.crt";
    default_inputs.end_entity_smime = "SignedValiddeltaCRLTest2.eml";
    default_inputs.end_entity_pkcs12 = "ValiddeltaCRLTest2EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.2 Valid delta-CRL Test2", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.15.2 Valid delta-CRL Test2", &default_inputs, VALID, "Validate Successfully");

    /* 4.15.3 Invalid delta-CRL Test3 */
    default_inputs.end_entity_certificate = "InvaliddeltaCRLTest3EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddeltaCRLTest3.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddeltaCRLTest3EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.3 Invalid delta-CRL Test3", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.15.3 Invalid delta-CRL Test3", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");

    /* 4.15.4 Invalid delta-CRL Test4 */
    default_inputs.end_entity_certificate = "InvaliddeltaCRLTest4EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddeltaCRLTest4.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddeltaCRLTest4EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.4 Invalid delta-CRL Test4", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.15.4 Invalid delta-CRL Test4", &default_inputs, VALID, "Validate Successfully");

    /* 4.15.5 Valid delta-CRL Test5 */
    default_inputs.end_entity_certificate = "ValiddeltaCRLTest5EE.crt";
    default_inputs.end_entity_smime = "SignedValiddeltaCRLTest5.eml";
    default_inputs.end_entity_pkcs12 = "ValiddeltaCRLTest5EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.5 Valid delta-CRL Test5", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.15.5 Valid delta-CRL Test5", &default_inputs, REVOKED, "Reject - end entity certificate is on hold");

    /* 4.15.6 Invalid delta-CRL Test6 */
    default_inputs.end_entity_certificate = "InvaliddeltaCRLTest6EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddeltaCRLTest6.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddeltaCRLTest6EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.6 Invalid delta-CRL Test6", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.15.6 Invalid delta-CRL Test6", &default_inputs, REVOKED, "Reject - end entity certificate is on hold");

    /* 4.15.7 Valid delta-CRL Test7 */
    default_inputs.end_entity_certificate = "ValiddeltaCRLTest7EE.crt";
    default_inputs.end_entity_smime = "SignedValiddeltaCRLTest7.eml";
    default_inputs.end_entity_pkcs12 = "ValiddeltaCRLTest7EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.7 Valid delta-CRL Test7", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.15.7 Valid delta-CRL Test7", &default_inputs, VALID, "Validate Successfully");

    /* 4.15.8 Valid delta-CRL Test8 */
    default_inputs.end_entity_certificate = "ValiddeltaCRLTest8EE.crt";
    default_inputs.end_entity_smime = "SignedValiddeltaCRLTest8.eml";
    default_inputs.end_entity_pkcs12 = "ValiddeltaCRLTest8EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.8 Valid delta-CRL Test8", &default_inputs, VALID, "Validate Successfully");
    else
	print_notest_entry(f, "4.15.8 Valid delta-CRL Test8", &default_inputs, VALID, "Validate Successfully");

    /* 4.15.9 Invalid delta-CRL Test9 */
    default_inputs.end_entity_certificate = "InvaliddeltaCRLTest9EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddeltaCRLTest9.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddeltaCRLTest9EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.9 Invalid delta-CRL Test9", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");
    else
	print_notest_entry(f, "4.15.9 Invalid delta-CRL Test9", &default_inputs, REVOKED, "Reject - end entity certificate has been revoked");

    /* 4.15.10 Invalid delta-CRL Test10 */
    default_inputs.end_entity_certificate = "InvaliddeltaCRLTest10EE.crt";
    default_inputs.end_entity_smime = "SignedInvaliddeltaCRLTest10.eml";
    default_inputs.end_entity_pkcs12 = "InvaliddeltaCRLTest10EE.p12";

    if (DeltaCRLs)
	print_test_entry(f, "4.15.10 Invalid delta-CRL Test10", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");
    else
	print_notest_entry(f, "4.15.10 Invalid delta-CRL Test10", &default_inputs, STATUS_UNKNOWN, "Reject or Warn - status of end entity certificate can not be determined");

    /* 4.16.1 Valid Unknown Not Critical Certificate Extension Test1 */
    default_inputs.end_entity_certificate = "ValidUnknownNotCriticalCertificateExtensionTest1EE.crt";
    default_inputs.end_entity_smime = "SignedValidUnknownNotCriticalCertificateExtensionTest1.eml";
    default_inputs.end_entity_pkcs12 = "ValidUnknownNotCriticalCertificateExtensionTest1EE.p12";

    print_test_entry(f, "4.16.1 Valid Unknown Not Critical Certificate Extension Test1", &default_inputs, VALID, "Validate Successfully");

    /* 4.16.2 Invalid Unknown Critical Certificate Extension Test2 */
    default_inputs.end_entity_certificate = "InvalidUnknownCriticalCertificateExtensionTest2EE.crt";
    default_inputs.end_entity_smime = "SignedInvalidUnknownCriticalCertificateExtensionTest2.eml";
    default_inputs.end_entity_pkcs12 = "InvalidUnknownCriticalCertificateExtensionTest2EE.p12";

    print_test_entry(f, "4.16.2 Invalid Unknown Critical Certificate Extension Test2", &default_inputs, INVALID_PATH, "Reject - unrecognized critical extension");



    print_trailer(f);

    fclose(f);

}
