(ns mori.chain
  (:require [mori :as m]))

(declare Chainable)

(defn ^:export _ [coll & keywordize?]
  (cond
   (and coll
        (.-isChainable coll)) coll
   (or (m/isCollection coll)
       (nil? coll)) (Chainable. coll)
   :else (Chainable. (m/toClj coll keywordize?))))

(deftype Chainable [coll]
  Object
  (map [this f] (_ (m/map f coll)))
  (reduce [this f start] (_ (m/reduce f start coll)))
  (count [this]  ( m/count coll))
  (distinct [this] (_ (m/distinct coll)))
  ;; Not sure `empty` should be here
  (empty [this] (_ (m/empty coll)))
  (first [this] (_ (m/first coll)))
  (second [this] (_ (m/second coll)))
  (next [this] (_ (m/next coll)))
  (rest [this] (_ (m/rest coll)))
  ;; TODO: Handle both arities ([coll x] & [this x & xs]) ?
  (conj [this x] (_ (m/conj coll x)))
  (cons [this x] (_ (m/cons x coll)))
  (find [this key] (_ (m/find coll key)))
  (nth [this n not-found] (_ (m/nth coll n not-found)))
  (last [this] (_ (m/last coll)))
  ;; TODO: Handle variadic arities?
  (assoc [this key value] (_ (m/assoc coll key value)))
  (dissoc [this & ks] (_ (apply m/dissoc coll ks)))
  (getIn [this ks not-found] (_ (m/getIn coll ks not-found)))
  ;; TODO: Handle variadic args
  (updateIn [this ks f ] (_ (m/updateIn coll ks f)))
  (assocIn [this ks value] (_ (m/assocIn coll ks value)))
  (disj [this key] (_ (m/disj coll key)))
  (pop [this] (_ (m/pop coll)))
  (peek [this] (_ (m/peek coll)))
  (hash [this] (m/hash coll))
  (get [this k not-found] (_ (m/get coll k not-found)))
  (hasKey [this key] (m/hasKey coll key))
  (reverse [this] (_ (m/reverse coll)))
  (take [this] (_ (m/take coll)))
  (take [this n] (_ (m/take n coll)))
  (drop [this] (_ (m/drop coll)))
  (drop [this n] (_ (m/drop n coll)))
  (takeNth [this n] (_ (m/takeNth n coll)))
  (partition [this n] (_ (m/partition n coll)))
  (partition [this n step] (_ (m/partition n step coll)))
  (partition [this n step pad] (_ (m/partition n step pad coll)))
  (partitionAll [this n] (_ (m/partitionAll n coll)))
  (partitionAll [this n step] (_ (m/partitionAll n step coll)))
  (partitionBy [this f] (_ (m/partitionBy f coll)))
  (iterate [this f] (_ (m/iterate coll f coll)))
  (into [this from] (_ (m/into coll from)))
  (intoArray [this] (_ (m/intoArray coll)))
  (merge [this & maps] (_ (apply m/merge coll maps)))
  ;; TODO: Fix apply issue here
  (mergeWith [this f & maps] (_ (apply m/merge f coll maps)))
  (subvec [this start end] (_ (m/subvec coll start end)))
  (takeWhile [this pred] (_ (m/takeWhile pred coll)))
  (dropWhile [this pred] (_ (m/dropWhile pred coll)))
  (groupBy [this f] (_ (m/groupBy f coll)))
  (interpose [this sep] (_ (m/interpose sep coll)))
  (interleave [this & colls] (_ (apply m/interleave coll colls)))
  (concat [this & zs] (_ (apply m/concat coll zs)))
  (sort [this] (_ (m/sort coll)))
  (sortBy [this f] (_ (m/sortBy f coll)))
  (vec [this] (_ (vec coll)))
  
  ;; Should prStr be here for clj programmers?
  (prStr [this] (pr-str coll))
  (isEqual [this other] (= coll
                           ;; Compare against a potentiall wrapped/unwrapped other
                           (or (.-coll other)
                               other)))
  ;; Same as isEqual, apparently more idiomatic with ES6 now
  (is [this other] (= coll (or (.-coll other)
                               other)))
  (isEmpty [this] (m/isEmpty coll))

  ;; It may be impossible to create a list through this interface, but
  ;; useful in case a manually created one is passed in
  (isList [this] (m/isList coll))
  (isSeq [this] (m/isSeq coll))
  (isVector [this] (m/isVector coll))
  (isMap [this] (m/isMap coll))
  (isSet [this] (m/isSet coll))
  
  (isSymbol [this] (m/isSymbol coll))
  
  (isCollection [this] (m/isCollection coll))
  (isSequential [this] (m/isSequential coll))
  (isAssociative [this] (m/isAssociative coll))
  (isCounted [this] (m/isCounted coll))
  (isIndexed [this] (m/isIndexed coll))
  (isReduceable [this] (m/isReduceable coll))
  (isSeqable [this] (m/isSeqable coll))
  (isReversible [this] (m/isReversible coll))

  (isChainable [_] true)
  (toSeq [this] (_ (m/seq coll)))
  (toSet [this] (_ (m/set coll)))
  ;; Not sure if .toJs or .out makes more sense for the JS world. Perhaps .out should give the .-coll out so other mori functions could use it, and .toJs should be for converting to JS values?
  (toJs [this] (m/toJs coll))
  (out [this] (m/toJs coll))
  (toString [this] (pr-str coll)))

;; Some built in helpers
(defn ^:export getter [key not-found]
  (fn [map]
    (if (and (m/isCollection map)
             (m/hasKey map key))
      (m/get map key)
      not-found)))

(goog/exportSymbol "mori.chain.Chainable" Chainable)

(goog/exportSymbol "mori.chain.Chainable.prototype.out" (.. Chainable -prototype -out))

(goog/exportSymbol "mori.chain.Chainable.prototype.map" (.. Chainable -prototype -map))
(goog/exportSymbol "mori.chain.Chainable.prototype.reduce" (.. Chainable -prototype -reduce))
(goog/exportSymbol "mori.chain.Chainable.prototype.count" (.. Chainable -prototype -count))
(goog/exportSymbol "mori.chain.Chainable.prototype.distinct" (.. Chainable -prototype -distinct))
(goog/exportSymbol "mori.chain.Chainable.prototype.empty" (.. Chainable -prototype -empty))
(goog/exportSymbol "mori.chain.Chainable.prototype.first" (.. Chainable -prototype -first))
(goog/exportSymbol "mori.chain.Chainable.prototype.second" (.. Chainable -prototype -second))
(goog/exportSymbol "mori.chain.Chainable.prototype.next" (.. Chainable -prototype -next))
(goog/exportSymbol "mori.chain.Chainable.prototype.rest" (.. Chainable -prototype -rest))
(goog/exportSymbol "mori.chain.Chainable.prototype.conj" (.. Chainable -prototype -conj))
(goog/exportSymbol "mori.chain.Chainable.prototype.cons" (.. Chainable -prototype -cons))
(goog/exportSymbol "mori.chain.Chainable.prototype.find" (.. Chainable -prototype -find))
(goog/exportSymbol "mori.chain.Chainable.prototype.nth" (.. Chainable -prototype -nth))
(goog/exportSymbol "mori.chain.Chainable.prototype.last" (.. Chainable -prototype -last))
(goog/exportSymbol "mori.chain.Chainable.prototype.assoc" (.. Chainable -prototype -assoc))
(goog/exportSymbol "mori.chain.Chainable.prototype.dissoc" (.. Chainable -prototype -dissoc))
(goog/exportSymbol "mori.chain.Chainable.prototype.getIn" (.. Chainable -prototype -getIn))
(goog/exportSymbol "mori.chain.Chainable.prototype.updateIn" (.. Chainable -prototype -updateIn))
(goog/exportSymbol "mori.chain.Chainable.prototype.assocIn" (.. Chainable -prototype -assocIn))
(goog/exportSymbol "mori.chain.Chainable.prototype.disj" (.. Chainable -prototype -disj))
(goog/exportSymbol "mori.chain.Chainable.prototype.pop" (.. Chainable -prototype -pop))
(goog/exportSymbol "mori.chain.Chainable.prototype.peek" (.. Chainable -prototype -peek))
(goog/exportSymbol "mori.chain.Chainable.prototype.hash" (.. Chainable -prototype -hash))
(goog/exportSymbol "mori.chain.Chainable.prototype.get" (.. Chainable -prototype -get))
(goog/exportSymbol "mori.chain.Chainable.prototype.hasKey" (.. Chainable -prototype -hasKey))
(goog/exportSymbol "mori.chain.Chainable.prototype.reverse" (.. Chainable -prototype -reverse))
(goog/exportSymbol "mori.chain.Chainable.prototype.take" (.. Chainable -prototype -take))
(goog/exportSymbol "mori.chain.Chainable.prototype.take" (.. Chainable -prototype -take))
(goog/exportSymbol "mori.chain.Chainable.prototype.drop" (.. Chainable -prototype -drop))
(goog/exportSymbol "mori.chain.Chainable.prototype.drop" (.. Chainable -prototype -drop))
(goog/exportSymbol "mori.chain.Chainable.prototype.takeNth" (.. Chainable -prototype -takeNth))
(goog/exportSymbol "mori.chain.Chainable.prototype.partition" (.. Chainable -prototype -partition))
(goog/exportSymbol "mori.chain.Chainable.prototype.partition" (.. Chainable -prototype -partition))
(goog/exportSymbol "mori.chain.Chainable.prototype.partition" (.. Chainable -prototype -partition))
(goog/exportSymbol "mori.chain.Chainable.prototype.partitionAll" (.. Chainable -prototype -partitionAll))
(goog/exportSymbol "mori.chain.Chainable.prototype.partitionAll" (.. Chainable -prototype -partitionAll))
(goog/exportSymbol "mori.chain.Chainable.prototype.partitionBy" (.. Chainable -prototype -partitionBy))
(goog/exportSymbol "mori.chain.Chainable.prototype.iterate" (.. Chainable -prototype -iterate))
(goog/exportSymbol "mori.chain.Chainable.prototype.into" (.. Chainable -prototype -into))
(goog/exportSymbol "mori.chain.Chainable.prototype.intoArray" (.. Chainable -prototype -intoArray))
(goog/exportSymbol "mori.chain.Chainable.prototype.merge" (.. Chainable -prototype -merge))
(goog/exportSymbol "mori.chain.Chainable.prototype.mergeWith" (.. Chainable -prototype -mergeWith))
(goog/exportSymbol "mori.chain.Chainable.prototype.subvec" (.. Chainable -prototype -subvec))
(goog/exportSymbol "mori.chain.Chainable.prototype.takeWhile" (.. Chainable -prototype -takeWhile))
(goog/exportSymbol "mori.chain.Chainable.prototype.dropWhile" (.. Chainable -prototype -dropWhile))
(goog/exportSymbol "mori.chain.Chainable.prototype.groupBy" (.. Chainable -prototype -groupBy))
(goog/exportSymbol "mori.chain.Chainable.prototype.interpose" (.. Chainable -prototype -interpose))
(goog/exportSymbol "mori.chain.Chainable.prototype.interleave" (.. Chainable -prototype -interleave))
(goog/exportSymbol "mori.chain.Chainable.prototype.concat" (.. Chainable -prototype -concat))
(goog/exportSymbol "mori.chain.Chainable.prototype.sort" (.. Chainable -prototype -sort))
(goog/exportSymbol "mori.chain.Chainable.prototype.sortBy" (.. Chainable -prototype -sortBy))
(goog/exportSymbol "mori.chain.Chainable.prototype.vec" (.. Chainable -prototype -vec))
(goog/exportSymbol "mori.chain.Chainable.prototype.prStr" (.. Chainable -prototype -prStr))
(goog/exportSymbol "mori.chain.Chainable.prototype.isEqual" (.. Chainable -prototype -isEqual))
(goog/exportSymbol "mori.chain.Chainable.prototype.is" (.. Chainable -prototype -is))
(goog/exportSymbol "mori.chain.Chainable.prototype.isEmpty" (.. Chainable -prototype -isEmpty))
(goog/exportSymbol "mori.chain.Chainable.prototype.isList" (.. Chainable -prototype -isList))
(goog/exportSymbol "mori.chain.Chainable.prototype.isSeq" (.. Chainable -prototype -isSeq))
(goog/exportSymbol "mori.chain.Chainable.prototype.isVector" (.. Chainable -prototype -isVector))
(goog/exportSymbol "mori.chain.Chainable.prototype.isMap" (.. Chainable -prototype -isMap))
(goog/exportSymbol "mori.chain.Chainable.prototype.isSet" (.. Chainable -prototype -isSet))
(goog/exportSymbol "mori.chain.Chainable.prototype.isSymbol" (.. Chainable -prototype -isSymbol))
(goog/exportSymbol "mori.chain.Chainable.prototype.isCollection" (.. Chainable -prototype -isCollection))
(goog/exportSymbol "mori.chain.Chainable.prototype.isSequential" (.. Chainable -prototype -isSequential))
(goog/exportSymbol "mori.chain.Chainable.prototype.isAssociative" (.. Chainable -prototype -isAssociative))
(goog/exportSymbol "mori.chain.Chainable.prototype.isCounted" (.. Chainable -prototype -isCounted))
(goog/exportSymbol "mori.chain.Chainable.prototype.isIndexed" (.. Chainable -prototype -isIndexed))
(goog/exportSymbol "mori.chain.Chainable.prototype.isReduceable" (.. Chainable -prototype -isReduceable))
(goog/exportSymbol "mori.chain.Chainable.prototype.isSeqable" (.. Chainable -prototype -isSeqable))
(goog/exportSymbol "mori.chain.Chainable.prototype.isReversible" (.. Chainable -prototype -isReversible))
(goog/exportSymbol "mori.chain.Chainable.prototype.isChainable" (.. Chainable -prototype -isChainable))
(goog/exportSymbol "mori.chain.Chainable.prototype.toSeq" (.. Chainable -prototype -toSeq))
(goog/exportSymbol "mori.chain.Chainable.prototype.toSet" (.. Chainable -prototype -toSet))
(goog/exportSymbol "mori.chain.Chainable.prototype.toJs" (.. Chainable -prototype -toJs))
(goog/exportSymbol "mori.chain.Chainable.prototype.toString" (.. Chainable -prototype -toString))

(goog/exportSymbol "mori.chain.getter" getter)
