﻿using NUnit.Framework;

namespace ServiceStack.OrmLite.Tests.Expression;

[TestFixtureOrmLite]
public class LogicalExpressionsTest(DialectContext context) : ExpressionsTestBase(context)
{
    [Test]
    public void Can_select_logical_and_variable_expression()
    {
        // ReSharper disable ConvertToConstant.Local
        var a = true;
        var b = false;
        // ReSharper restore ConvertToConstant.Local

        var expected = new TestType
        {
            IntColumn = 12,
            BoolColumn = false,
            StringColumn = "test"
        };

        Init(10, expected);

        using (var db = OpenDbConnection())
        {
            var actual = db.Select<TestType>(q => q.BoolColumn == (a & b));

            Assert.IsNotNull(actual);
            Assert.Greater(actual.Count, 0);
            CollectionAssert.Contains(actual, expected);
        }
    }

    [Test]
    public void Can_select_logical_or_variable_expression()
    {
        // ReSharper disable ConvertToConstant.Local
        var a = true;
        var b = false;
        // ReSharper restore ConvertToConstant.Local

        var expected = new TestType
        {
            IntColumn = 12,
            BoolColumn = true,
            StringColumn = "test"
        };

        Init(10, expected);

        using (var db = OpenDbConnection())
        {
            var actual = db.Select<TestType>(q => q.BoolColumn == (a | b));

            Assert.IsNotNull(actual);
            Assert.Greater(actual.Count, 0);
            CollectionAssert.Contains(actual, expected);
        }
    }

    [Test]
    public void Can_select_logical_xor_variable_expression()
    {
        // ReSharper disable ConvertToConstant.Local
        var a = true;
        var b = false;
        // ReSharper restore ConvertToConstant.Local

        var expected = new TestType
        {
            IntColumn = 12,
            BoolColumn = true,
            StringColumn = "test"
        };

        Init(10, expected);

        using (var db = OpenDbConnection())
        {
            var actual = db.Select<TestType>(q => q.BoolColumn == (a ^ b));

            Assert.IsNotNull(actual);
            Assert.Greater(actual.Count, 0);
            CollectionAssert.Contains(actual, expected);
        }
    }

    [Test]
    public void Can_select_logical_and_method_expression()
    {
        var expected = new TestType
        {
            IntColumn = 12,
            BoolColumn = false,
            StringColumn = "test"
        };

        Init(10, expected);

        using (var db = OpenDbConnection())
        {
            var actual = db.Select<TestType>(q => q.BoolColumn == (GetValue(true) & GetValue(false)));

            Assert.IsNotNull(actual);
            Assert.Greater(actual.Count, 0);
            CollectionAssert.Contains(actual, expected);
        }
    }

    [Test]
    public void Can_select_logical_or_method_expression()
    {
        var expected = new TestType()
        {
            IntColumn = 12,
            BoolColumn = true,
            StringColumn = "test"
        };

        Init(10, expected);

        using (var db = OpenDbConnection())
        {
            var actual = db.Select<TestType>(q => q.BoolColumn == (GetValue(true) | GetValue(false)));

            Assert.IsNotNull(actual);
            Assert.Greater(actual.Count, 0);
            CollectionAssert.Contains(actual, expected);
        }
    }

    [Test]
    public void Can_select_logical_xor_method_expression()
    {
        var expected = new TestType
        {
            IntColumn = 12,
            BoolColumn = true,
            StringColumn = "test"
        };

        Init(10, expected);

        using (var db = OpenDbConnection())
        {
            var actual = db.Select<TestType>(q => q.BoolColumn == (GetValue(true) ^ GetValue(false)));

            Assert.IsNotNull(actual);
            Assert.Greater(actual.Count, 0);
            CollectionAssert.Contains(actual, expected);
        }
    }
}