using System;
using System.Collections.Generic;
using System.Linq;

namespace ServiceStack;

public static class ByteArrayExtensions
{
    public static bool AreEqual(this byte[] b1, byte[] b2)
    {
        if (b1 == b2) return true;
        if (b1 == null || b2 == null) return false;
        if (b1.Length != b2.Length) return false;

        for (var i = 0; i < b1.Length; i++)
        {
            if (b1[i] != b2[i]) return false;
        }

        return true;
    }

    public static byte[] ToSha1Hash(this byte[] bytes)
    {
        using var sha1 = Text.TextConfig.CreateSha();
        return sha1.ComputeHash(bytes);
    }
}

public class ByteArrayComparer : IEqualityComparer<byte[]>
{
    public static ByteArrayComparer Instance = new();

    public bool Equals(byte[] left, byte[] right)
    {
        if (left == null || right == null)
        {
            return left == right;
        }
        return left.SequenceEqual(right);
    }

    public int GetHashCode(byte[] key)
    {
        if (key == null)
            throw new ArgumentNullException(nameof(key));

        return key.Sum(b => b);
    }
}
