﻿using System.Runtime.Serialization;
using MyApp.ServiceInterface;
using ServiceStack;

namespace MyApp.ServiceModel;

[Tag("hello"), Tag("auth")]
[Route("/greet/{Name}")]
public class Greet : IReturn<HelloResponse>
{
    public string Name { get; set; }
}

[Tag("hello")]
[Route("/hello")]
[Route("/hello/{Name}")]
// [ValidateHasRole("Employee")]
public class Hello : IGet, IReturn<HelloResponse>
{
    public string Name { get; set; } = string.Empty;
}

[Tag("hello")]
[Route("/hellosecure/{Name}", "PUT")]
[ValidateIsAuthenticated]
public class HelloSecure : IReturn<HelloResponse>
{
    public string Name { get; set; } = string.Empty;
}

[Tag("hello")]
[Route("/hello-long/{Name}", "PATCH,PUT")]
[Route("/hello-very-long/{Name}", "GET,POST,PUT")]
[ValidateHasRole("Employee")]
[ValidateHasPermission("ThePermission")]
[ValidateIsAuthenticated]
public class HelloVeryLongOperationNameVersions : IReturn<HelloResponse>, IGet, IPost, IPut, IPatch
{
    public string? Name { get; set; }
    public string[]? Names { get; set; }
    public int[]? Ids { get; set; }
}

[Tag("hello")]
[Route("/hello-long/{Name}")]
[ValidateIsAuthenticated]
public class HelloVeryLongOperationNameVersionsAndThenSome : IReturn<HelloResponse>
{
    public string Name { get; set; } = string.Empty;
}

public class HelloResponse
{
    public string Result { get; set; } = string.Empty;
    public ResponseStatus? ResponseStatus { get; set; }
}

[DataContract]
public class HelloBookingList : IReturn<List<Booking>>
{
    [DataMember(Order = 1, Name = "Alias")]
    public string Name { get; set; }
}

public class HelloString : IReturn<string>
{
    public string Name { get; set; }
}

[Route("/return/string")]
public class ReturnString : IReturn<string>
{
    public string Data { get; set; }
}